/*
 * arch/arm/cpu/armv8/rcar_gen3/pfc-r8a7795.c
 *     This file is r8a7795 processor support - PFC hardware block.
 *
 * Copyright (C) 2015-2016 Renesas Electronics Corporation
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#include <common.h>
#include <sh_pfc.h>
#include <asm/arch/r8a7795-gpio.h>

#define CPU_32_PORT(fn, pfx, sfx)				\
	PORT_10(fn, pfx, sfx), PORT_10(fn, pfx##1, sfx),	\
	PORT_10(fn, pfx##2, sfx), PORT_1(fn, pfx##30, sfx),	\
	PORT_1(fn, pfx##31, sfx)

#define CPU_32_PORT1(fn, pfx, sfx)				\
	PORT_10(fn, pfx, sfx), PORT_10(fn, pfx##1, sfx),	\
	PORT_10(fn, pfx##2, sfx)

#define CPU_32_PORT2(fn, pfx, sfx)				\
	PORT_10(fn, pfx, sfx), PORT_10(fn, pfx##1, sfx),	\
	PORT_10(fn, pfx##2, sfx)

#define CPU_32_PORT_29(fn, pfx, sfx)				\
	PORT_10(fn, pfx, sfx),					\
	PORT_10(fn, pfx##1, sfx),				\
	PORT_1(fn, pfx##20, sfx),				\
	PORT_1(fn, pfx##21, sfx),				\
	PORT_1(fn, pfx##22, sfx),				\
	PORT_1(fn, pfx##23, sfx),				\
	PORT_1(fn, pfx##24, sfx),				\
	PORT_1(fn, pfx##25, sfx),				\
	PORT_1(fn, pfx##26, sfx),				\
	PORT_1(fn, pfx##27, sfx),				\
	PORT_1(fn, pfx##28, sfx)

#define CPU_32_PORT_28(fn, pfx, sfx)				\
	PORT_10(fn, pfx, sfx),					\
	PORT_10(fn, pfx##1, sfx),				\
	PORT_1(fn, pfx##20, sfx),				\
	PORT_1(fn, pfx##21, sfx),				\
	PORT_1(fn, pfx##22, sfx),				\
	PORT_1(fn, pfx##23, sfx),				\
	PORT_1(fn, pfx##24, sfx),				\
	PORT_1(fn, pfx##25, sfx),				\
	PORT_1(fn, pfx##26, sfx),				\
	PORT_1(fn, pfx##27, sfx)

#define CPU_32_PORT_26(fn, pfx, sfx)				\
	PORT_10(fn, pfx, sfx),					\
	PORT_10(fn, pfx##1, sfx),				\
	PORT_1(fn, pfx##20, sfx),				\
	PORT_1(fn, pfx##21, sfx),				\
	PORT_1(fn, pfx##22, sfx),				\
	PORT_1(fn, pfx##23, sfx),				\
	PORT_1(fn, pfx##24, sfx),				\
	PORT_1(fn, pfx##25, sfx)

#define CPU_32_PORT_18(fn, pfx, sfx)				\
	PORT_10(fn, pfx, sfx),					\
	PORT_1(fn, pfx##10, sfx),				\
	PORT_1(fn, pfx##11, sfx),				\
	PORT_1(fn, pfx##12, sfx),				\
	PORT_1(fn, pfx##13, sfx),				\
	PORT_1(fn, pfx##14, sfx),				\
	PORT_1(fn, pfx##15, sfx),				\
	PORT_1(fn, pfx##16, sfx),				\
	PORT_1(fn, pfx##17, sfx)

#define CPU_32_PORT_16(fn, pfx, sfx)				\
	PORT_10(fn, pfx, sfx),					\
	PORT_1(fn, pfx##10, sfx),				\
	PORT_1(fn, pfx##11, sfx),				\
	PORT_1(fn, pfx##12, sfx),				\
	PORT_1(fn, pfx##13, sfx),				\
	PORT_1(fn, pfx##14, sfx),				\
	PORT_1(fn, pfx##15, sfx)

#define CPU_32_PORT_15(fn, pfx, sfx)				\
	PORT_10(fn, pfx, sfx),					\
	PORT_1(fn, pfx##10, sfx),				\
	PORT_1(fn, pfx##11, sfx),				\
	PORT_1(fn, pfx##12, sfx),				\
	PORT_1(fn, pfx##13, sfx),				\
	PORT_1(fn, pfx##14, sfx)

#define CPU_32_PORT_4(fn, pfx, sfx)				\
	PORT_1(fn, pfx##0, sfx),				\
	PORT_1(fn, pfx##1, sfx),				\
	PORT_1(fn, pfx##2, sfx),				\
	PORT_1(fn, pfx##3, sfx)


/* --gen3-- */
/* GP_0_0_DATA -> GP_7_4_DATA */
/* except for GP0[16] - [31],
		GP1[28] - [31],
		GP2[15] - [31],
		GP3[16] - [31],
		GP4[18] - [31],
		GP5[26] - [31],
		GP7[4] - [31] */

#define ES_CPU_ALL_PORT(fn, pfx, sfx)		\
	CPU_32_PORT_16(fn, pfx##_0_, sfx),	\
	CPU_32_PORT_28(fn, pfx##_1_, sfx),	\
	CPU_32_PORT_15(fn, pfx##_2_, sfx),	\
	CPU_32_PORT_16(fn, pfx##_3_, sfx),	\
	CPU_32_PORT_18(fn, pfx##_4_, sfx),	\
	CPU_32_PORT_26(fn, pfx##_5_, sfx),	\
	CPU_32_PORT(fn, pfx##_6_, sfx),		\
	CPU_32_PORT_4(fn, pfx##_7_, sfx)

#define CPU_ALL_PORT(fn, pfx, sfx)		\
	CPU_32_PORT_16(fn, pfx##_0_, sfx),	\
	CPU_32_PORT_29(fn, pfx##_1_, sfx),	\
	CPU_32_PORT_15(fn, pfx##_2_, sfx),	\
	CPU_32_PORT_16(fn, pfx##_3_, sfx),	\
	CPU_32_PORT_18(fn, pfx##_4_, sfx),	\
	CPU_32_PORT_26(fn, pfx##_5_, sfx),	\
	CPU_32_PORT(fn, pfx##_6_, sfx),		\
	CPU_32_PORT_4(fn, pfx##_7_, sfx)

#define _GP_GPIO(pfx, sfx) PINMUX_GPIO(GPIO_GP##pfx, GP##pfx##_DATA)
#define _GP_DATA(pfx, sfx) PINMUX_DATA(GP##pfx##_DATA, GP##pfx##_FN,	\
				       GP##pfx##_IN, GP##pfx##_OUT)

#define _GP_INOUTSEL(pfx, sfx) GP##pfx##_IN, GP##pfx##_OUT
#define _GP_INDT(pfx, sfx) GP##pfx##_DATA

#define GP_ALL(str)	CPU_ALL_PORT(_PORT_ALL, GP, str)
#define PINMUX_GPIO_GP_ALL()	CPU_ALL_PORT(_GP_GPIO, , unused)
#define PINMUX_DATA_GP_ALL()	CPU_ALL_PORT(_GP_DATA, , unused)


#define PORT_10_REV(fn, pfx, sfx)				\
	PORT_1(fn, pfx##9, sfx), PORT_1(fn, pfx##8, sfx),	\
	PORT_1(fn, pfx##7, sfx), PORT_1(fn, pfx##6, sfx),	\
	PORT_1(fn, pfx##5, sfx), PORT_1(fn, pfx##4, sfx),	\
	PORT_1(fn, pfx##3, sfx), PORT_1(fn, pfx##2, sfx),	\
	PORT_1(fn, pfx##1, sfx), PORT_1(fn, pfx##0, sfx)

#define CPU_32_PORT_REV(fn, pfx, sfx)					\
	PORT_1(fn, pfx##31, sfx), PORT_1(fn, pfx##30, sfx),		\
	PORT_10_REV(fn, pfx##2, sfx), PORT_10_REV(fn, pfx##1, sfx),	\
	PORT_10_REV(fn, pfx, sfx)

#define GP_INOUTSEL(bank) CPU_32_PORT_REV(_GP_INOUTSEL, _##bank##_, unused)
#define GP_INDT(bank) CPU_32_PORT_REV(_GP_INDT, _##bank##_, unused)

#define PINMUX_IPSR_DATA(ipsr, fn) PINMUX_DATA(fn##_MARK, FN_##ipsr, FN_##fn)
#define PINMUX_IPSR_MODSEL_DATA(ipsr, fn, ms) PINMUX_DATA(fn##_MARK, FN_##ms, \
							  FN_##ipsr, FN_##fn)

enum {
	PINMUX_RESERVED = 0,

	PINMUX_DATA_BEGIN,
	GP_ALL(DATA),
	PINMUX_DATA_END,

	PINMUX_INPUT_BEGIN,
	GP_ALL(IN),
	PINMUX_INPUT_END,

	PINMUX_OUTPUT_BEGIN,
	GP_ALL(OUT),
	PINMUX_OUTPUT_END,

	PINMUX_FUNCTION_BEGIN,
	GP_ALL(FN),

	/* GPSR0 */
	GFN_D15,
	GFN_D14,
	GFN_D13,
	GFN_D12,
	GFN_D11,
	GFN_D10,
	GFN_D9,
	GFN_D8,
	GFN_D7,
	GFN_D6,
	GFN_D5,
	GFN_D4,
	GFN_D3,
	GFN_D2,
	GFN_D1,
	GFN_D0,

	/* GPSR1 */
	GFN_CLKOUT,
	GFN_EX_WAIT0_A,
	GFN_WE1x,
	GFN_WE0x,
	GFN_RD_WRx,
	GFN_RDx,
	GFN_BSx,
	GFN_CS1x_A26,
	GFN_CS0x,
	GFN_A19,
	GFN_A18,
	GFN_A17,
	GFN_A16,
	GFN_A15,
	GFN_A14,
	GFN_A13,
	GFN_A12,
	GFN_A11,
	GFN_A10,
	GFN_A9,
	GFN_A8,
	GFN_A7,
	GFN_A6,
	GFN_A5,
	GFN_A4,
	GFN_A3,
	GFN_A2,
	GFN_A1,
	GFN_A0,

	/* GPSR2 */
	GFN_AVB_AVTP_CAPTURE_A,
	GFN_AVB_AVTP_MATCH_A,
	GFN_AVB_LINK,
	GFN_AVB_PHY_INT,
	GFN_AVB_MAGIC,
	GFN_AVB_MDC,
	GFN_PWM2_A,
	GFN_PWM1_A,
	GFN_PWM0,
	GFN_IRQ5,
	GFN_IRQ4,
	GFN_IRQ3,
	GFN_IRQ2,
	GFN_IRQ1,
	GFN_IRQ0,

	/* GPSR3 */
	GFN_SD1_WP,
	GFN_SD1_CD,
	GFN_SD0_WP,
	GFN_SD0_CD,
	GFN_SD1_DAT3,
	GFN_SD1_DAT2,
	GFN_SD1_DAT1,
	GFN_SD1_DAT0,
	GFN_SD1_CMD,
	GFN_SD1_CLK,
	GFN_SD0_DAT3,
	GFN_SD0_DAT2,
	GFN_SD0_DAT1,
	GFN_SD0_DAT0,
	GFN_SD0_CMD,
	GFN_SD0_CLK,

	/* GPSR4 */
	GFN_SD3_DS,
	GFN_SD3_DAT7,
	GFN_SD3_DAT6,
	GFN_SD3_DAT5,
	GFN_SD3_DAT4,
	GFN_SD3_DAT3,
	GFN_SD3_DAT2,
	GFN_SD3_DAT1,
	GFN_SD3_DAT0,
	GFN_SD3_CMD,
	GFN_SD3_CLK,
	GFN_SD2_DS,
	GFN_SD2_DAT3,
	GFN_SD2_DAT2,
	GFN_SD2_DAT1,
	GFN_SD2_DAT0,
	GFN_SD2_CMD,
	GFN_SD2_CLK,

	/* GPSR5 */
	GFN_MLB_DAT,
	GFN_MLB_SIG,
	GFN_MLB_CLK,
	FN_MSIOF0_RXD,
	GFN_MSIOF0_SS2,
	FN_MSIOF0_TXD,
	GFN_MSIOF0_SS1,
	GFN_MSIOF0_SYNC,
	FN_MSIOF0_SCK,
	GFN_HRTS0x,
	GFN_HCTS0x,
	GFN_HTX0,
	GFN_HRX0,
	GFN_HSCK0,
	GFN_RX2_A,
	GFN_TX2_A,
	GFN_SCK2,
	GFN_RTS1x_TANS,
	GFN_CTS1x,
	GFN_TX1_A,
	GFN_RX1_A,
	GFN_RTS0x_TANS,
	GFN_CTS0x,
	GFN_TX0,
	GFN_RX0,
	GFN_SCK0,

	/* GPSR6 */
	GFN_USB3_OVC,
	GFN_USB3_PWEN,
	GFN_USB30_OVC,
	GFN_USB30_PWEN,
	GFN_USB1_OVC,
	GFN_USB1_PWEN,
	GFN_USB0_OVC,
	GFN_USB0_PWEN,
	GFN_AUDIO_CLKB_B,
	GFN_AUDIO_CLKA_A,
	GFN_SSI_SDATA9_A,
	GFN_SSI_SDATA8,
	GFN_SSI_SDATA7,
	GFN_SSI_WS78,
	GFN_SSI_SCK78,
	GFN_SSI_SDATA6,
	GFN_SSI_WS6,
	GFN_SSI_SCK6,
	FN_SSI_SDATA5,
	FN_SSI_WS5,
	FN_SSI_SCK5,
	GFN_SSI_SDATA4,
	GFN_SSI_WS4,
	GFN_SSI_SCK4,
	GFN_SSI_SDATA3,
	GFN_SSI_WS34,
	GFN_SSI_SCK34,
	GFN_SSI_SDATA2_A,
	GFN_SSI_SDATA1_A,
	GFN_SSI_SDATA0,
	GFN_SSI_WS01239,
	GFN_SSI_SCK01239,

	/* GPSR7 */
	FN_HDMI1_CEC,
	FN_HDMI0_CEC,
	FN_AVS2,
	FN_AVS1,

	/* IPSR0 */
	IFN_AVB_MDC,
	FN_MSIOF2_SS2_C,
	IFN_AVB_MAGIC,
	FN_MSIOF2_SS1_C,
	FN_SCK4_A,
	IFN_AVB_PHY_INT,
	FN_MSIOF2_SYNC_C,
	FN_RX4_A,
	IFN_AVB_LINK,
	FN_MSIOF2_SCK_C,
	FN_TX4_A,
	IFN_AVB_AVTP_MATCH_A,
	FN_MSIOF2_RXD_C,
	FN_CTS4x_A,
	FN_FSCLKST2x_A,
	IFN_AVB_AVTP_CAPTURE_A,
	FN_MSIOF2_TXD_C,
	FN_RTS4x_TANS_A,
	IFN_IRQ0,
	FN_QPOLB,
	FN_DU_CDE,
	FN_VI4_DATA0_B,
	FN_CAN0_TX_B,
	FN_CANFD0_TX_B,
	FN_MSIOF3_SS2_E,
	IFN_IRQ1,
	FN_QPOLA,
	FN_DU_DISP,
	FN_VI4_DATA1_B,
	FN_CAN0_RX_B,
	FN_CANFD0_RX_B,
	FN_MSIOF3_SS1_E,

	/* IPSR1 */
	IFN_IRQ2,
	FN_QCPV_QDE,
	FN_DU_EXODDF_DU_ODDF_DISP_CDE,
	FN_VI4_DATA2_B,
	FN_MSIOF3_SYNC_E,
	FN_PWM3_B,
	IFN_IRQ3,
	FN_QSTVB_QVE,
	FN_DU_DOTCLKOUT1,
	FN_VI4_DATA3_B,
	FN_MSIOF3_SCK_E,
	FN_PWM4_B,
	IFN_IRQ4,
	FN_QSTH_QHS,
	FN_DU_EXHSYNC_DU_HSYNC,
	FN_VI4_DATA4_B,
	FN_MSIOF3_RXD_E,
	FN_PWM5_B,
	IFN_IRQ5,
	FN_QSTB_QHE,
	FN_DU_EXVSYNC_DU_VSYNC,
	FN_VI4_DATA5_B,
	FN_FSCLKST2x_B,
	FN_MSIOF3_TXD_E,
	FN_PWM6_B,
	IFN_PWM0,
	FN_AVB_AVTP_PPS,
	FN_VI4_DATA6_B,
	FN_IECLK_B,
	IFN_PWM1_A,
	FN_HRX3_D,
	FN_VI4_DATA7_B,
	FN_IERX_B,
	IFN_PWM2_A,
	FN_HTX3_D,
	FN_IETX_B,
	IFN_A0,
	FN_LCDOUT16,
	FN_MSIOF3_SYNC_B,
	FN_VI4_DATA8,
	FN_DU_DB0,
	FN_PWM3_A,

	/* IPSR2 */
	IFN_A1,
	FN_LCDOUT17,
	FN_MSIOF3_TXD_B,
	FN_VI4_DATA9,
	FN_DU_DB1,
	FN_PWM4_A,
	IFN_A2,
	FN_LCDOUT18,
	FN_MSIOF3_SCK_B,
	FN_VI4_DATA10,
	FN_DU_DB2,
	FN_PWM5_A,
	IFN_A3,
	FN_LCDOUT19,
	FN_MSIOF3_RXD_B,
	FN_VI4_DATA11,
	FN_DU_DB3,
	FN_PWM6_A,
	IFN_A4,
	FN_LCDOUT20,
	FN_MSIOF3_SS1_B,
	FN_VI4_DATA12,
	FN_VI5_DATA12,
	FN_DU_DB4,
	IFN_A5,
	FN_LCDOUT21,
	FN_MSIOF3_SS2_B,
	FN_SCK4_B,
	FN_VI4_DATA13,
	FN_VI5_DATA13,
	FN_DU_DB5,
	IFN_A6,
	FN_LCDOUT22,
	FN_MSIOF2_SS1_A,
	FN_RX4_B,
	FN_VI4_DATA14,
	FN_VI5_DATA14,
	FN_DU_DB6,
	IFN_A7,
	FN_LCDOUT23,
	FN_MSIOF2_SS2_A,
	FN_TX4_B,
	FN_VI4_DATA15,
	FN_V15_DATA15,
	FN_DU_DB7,
	IFN_A8,
	FN_RX3_B,
	FN_MSIOF2_SYNC_A,
	FN_HRX4_B,
	FN_SDA6_A,
	FN_AVB_AVTP_MATCH_B,
	FN_PWM1_B,

	/* IPSR3 */
	IFN_A9,
	FN_MSIOF2_SCK_A,
	FN_CTS4x_B,
	FN_VI5_VSYNCx,
	IFN_A10,
	FN_MSIOF2_RXD_A,
	FN_RTS4n_TANS_B,
	FN_VI5_HSYNCx,
	IFN_A11,
	FN_TX3_B,
	FN_MSIOF2_TXD_A,
	FN_HTX4_B,
	FN_HSCK4,
	FN_VI5_FIELD,
	FN_SCL6_A,
	FN_AVB_AVTP_CAPTURE_B,
	FN_PWM2_B,
	IFN_A12,
	FN_LCDOUT12,
	FN_MSIOF3_SCK_C,
	FN_HRX4_A,
	FN_VI5_DATA8,
	FN_DU_DG4,
	IFN_A13,
	FN_LCDOUT13,
	FN_MSIOF3_SYNC_C,
	FN_HTX4_A,
	FN_VI5_DATA9,
	FN_DU_DG5,
	IFN_A14,
	FN_LCDOUT14,
	FN_MSIOF3_RXD_C,
	FN_HCTS4x,
	FN_VI5_DATA10,
	FN_DU_DG6,
	IFN_A15,
	FN_LCDOUT15,
	FN_MSIOF3_TXD_C,
	FN_HRTS4x,
	FN_VI5_DATA11,
	FN_DU_DG7,
	IFN_A16,
	FN_LCDOUT8,
	FN_VI4_FIELD,
	FN_DU_DG0,

	/* IPSR4 */
	IFN_A17,
	FN_LCDOUT9,
	FN_VI4_VSYNCx,
	FN_DU_DG1,
	IFN_A18,
	FN_LCDOUT10,
	FN_VI4_HSYNCx,
	FN_DU_DG2,
	IFN_A19,
	FN_LCDOUT11,
	FN_VI4_CLKENB,
	FN_DU_DG3,
	IFN_CS0x,
	FN_VI5_CLKENB,
	IFN_CS1x_A26,
	FN_VI5_CLK,
	FN_EX_WAIT0_B,
	IFN_BSx,
	FN_QSTVA_QVS,
	FN_MSIOF3_SCK_D,
	FN_SCK3,
	FN_HSCK3,
	FN_CAN1_TX,
	FN_CANFD1_TX,
	FN_IETX_A,
	IFN_RDx,
	FN_MSIOF3_SYNC_D,
	FN_RX3_A,
	FN_HRX3_A,
	FN_CAN0_TX_A,
	FN_CANFD0_TX_A,
	IFN_RD_WRx,
	FN_MSIOF3_RXD_D,
	FN_TX3_A,
	FN_HTX3_A,
	FN_CAN0_RX_A,
	FN_CANFD0_RX_A,

	/* IPSR5 */
	IFN_WE0x,
	FN_MSIIOF3_TXD_D,
	FN_CTS3x,
	FN_HCTS3x,
	FN_SCL6_B,
	FN_CAN_CLK,
	FN_IECLK_A,
	IFN_WE1x,
	FN_MSIOF3_SS1_D,
	FN_RTS3x_TANS,
	FN_HRTS3x,
	FN_SDA6_B,
	FN_CAN1_RX,
	FN_CANFD1_RX,
	FN_IERX_A,
	IFN_EX_WAIT0_A,
	FN_QCLK,
	FN_VI4_CLK,
	FN_DU_DOTCLKOUT0,
	IFN_D0,
	FN_MSIOF2_SS1_B,
	FN_MSIOF3_SCK_A,
	FN_VI4_DATA16,
	FN_VI5_DATA0,
	IFN_D1,
	FN_MSIOF2_SS2_B,
	FN_MSIOF3_SYNC_A,
	FN_VI4_DATA17,
	FN_VI5_DATA1,
	IFN_D2,
	FN_MSIOF3_RXD_A,
	FN_VI4_DATA18,
	FN_VI5_DATA2,
	IFN_D3,
	FN_MSIOF3_TXD_A,
	FN_VI4_DATA19,
	FN_VI5_DATA3,
	IFN_D4,
	FN_MSIOF2_SCK_B,
	FN_VI4_DATA20,
	FN_VI5_DATA4,

	/* IPSR6 */
	IFN_D5,
	FN_MSIOF2_SYNC_B,
	FN_VI4_DATA21,
	FN_VI5_DATA5,
	IFN_D6,
	FN_MSIOF2_RXD_B,
	FN_VI4_DATA22,
	FN_VI5_DATA6,
	IFN_D7,
	FN_MSIOF2_TXD_B,
	FN_VI4_DATA23,
	FN_VI5_DATA7,
	IFN_D8,
	FN_LCDOUT0,
	FN_MSIOF2_SCK_D,
	FN_SCK4_C,
	FN_VI4_DATA0_A,
	FN_DU_DR0,
	IFN_D9,
	FN_LCDOUT1,
	FN_MSIOF2_SYNC_D,
	FN_VI4_DATA1_A,
	FN_DU_DR1,
	IFN_D10,
	FN_LCDOUT2,
	FN_MSIOF2_RXD_D,
	FN_HRX3_B,
	FN_VI4_DATA2_A,
	FN_CTS4x_C,
	FN_DU_DR2,
	IFN_D11,
	FN_LCDOUT3,
	FN_MSIOF2_TXD_D,
	FN_HTX3_B,
	FN_VI4_DATA3_A,
	FN_RTS4x_TANS_C,
	FN_DU_DR3,
	IFN_D12,
	FN_LCDOUT4,
	FN_MSIOF2_SS1_D,
	FN_RX4_C,
	FN_VI4_DATA4_A,
	FN_DU_DR4,

	/* IPSR7 */
	IFN_D13,
	FN_LCDOUT5,
	FN_MSIOF2_SS2_D,
	FN_TX4_C,
	FN_VI4_DATA5_A,
	FN_DU_DR5,
	IFN_D14,
	FN_LCDOUT6,
	FN_MSIOF3_SS1_A,
	FN_HRX3_C,
	FN_VI4_DATA6_A,
	FN_DU_DR6,
	FN_SCL6_C,
	IFN_D15,
	FN_LCDOUT7,
	FN_MSIOF3_SS2_A,
	FN_HTX3_C,
	FN_VI4_DATA7_A,
	FN_DU_DR7,
	FN_SDA6_C,
	FN_FSCLKST,
	IFN_SD0_CLK,
	FN_MSIOF1_SCK_E,
	FN_STP_OPWM_0_B,
	IFN_SD0_CMD,
	FN_MSIOF1_SYNC_E,
	FN_STP_IVCXO27_0_B,
	IFN_SD0_DAT0,
	FN_MSIOF1_RXD_E,
	FN_TS_SCK0_B,
	FN_STP_ISCLK_0_B,
	IFN_SD0_DAT1,
	FN_MSIOF1_TXD_E,
	FN_TS_SPSYNC0_B,
	FN_STP_ISSYNC_0_B,

	/* IPSR8 */
	IFN_SD0_DAT2,
	FN_MSIOF1_SS1_E,
	FN_TS_SDAT0_B,
	FN_STP_ISD_0_B,
	IFN_SD0_DAT3,
	FN_MSIOF1_SS2_E,
	FN_TS_SDEN0_B,
	FN_STP_ISEN_0_B,
	IFN_SD1_CLK,
	FN_MSIOF1_SCK_G,
	FN_SIM0_CLK_A,
	IFN_SD1_CMD,
	FN_MSIOF1_SYNC_G,
	FN_NFCEx_B,
	FN_SIM0_D_A,
	FN_STP_IVCXO27_1_B,
	IFN_SD1_DAT0,
	FN_SD2_DAT4,
	FN_MSIOF1_RXD_G,
	FN_NFWPx_B,
	FN_TS_SCK1_B,
	FN_STP_ISCLK_1_B,
	IFN_SD1_DAT1,
	FN_SD2_DAT5,
	FN_MSIOF1_TXD_G,
	FN_NFDATA14_B,
	FN_TS_SPSYNC1_B,
	FN_STP_ISSYNC_1_B,
	IFN_SD1_DAT2,
	FN_SD2_DAT6,
	FN_MSIOF1_SS1_G,
	FN_NFDATA15_B,
	FN_TS_SDAT1_B,
	FN_STP_IOD_1_B,
	IFN_SD1_DAT3,
	FN_SD2_DAT7,
	FN_MSIOF1_SS2_G,
	FN_NFRBx_B,
	FN_TS_SDEN1_B,
	FN_STP_ISEN_1_B,

	/* IPSR9 */
	IFN_SD2_CLK,
	FN_NFDATA8,
	IFN_SD2_CMD,
	FN_NFDATA9,
	IFN_SD2_DAT0,
	FN_NFDATA10,
	IFN_SD2_DAT1,
	FN_NFDATA11,
	IFN_SD2_DAT2,
	FN_NFDATA12,
	IFN_SD2_DAT3,
	FN_NFDATA13,
	IFN_SD2_DS,
	FN_NFALE,
	FN_SATA_DEVSLP_B,
	IFN_SD3_CLK,
	FN_NFWEx,

	/* IPSR10 */
	IFN_SD3_CMD,
	FN_NFREx,
	IFN_SD3_DAT0,
	FN_NFDATA0,
	IFN_SD3_DAT1,
	FN_NFDATA1,
	IFN_SD3_DAT2,
	FN_NFDATA2,
	IFN_SD3_DAT3,
	FN_NFDATA3,
	IFN_SD3_DAT4,
	FN_SD2_CD_A,
	FN_NFDATA4,
	IFN_SD3_DAT5,
	FN_SD2_WP_A,
	FN_NFDATA5,
	IFN_SD3_DAT6,
	FN_SD3_CD,
	FN_NFDATA6,

	/* IPSR11 */
	IFN_SD3_DAT7,
	FN_SD3_WP,
	FN_NFDATA7,
	IFN_SD3_DS,
	FN_NFCLE,
	IFN_SD0_CD,
	FN_NFDATA14_A,
	FN_SCL2_B,
	FN_SIM0_RST_A,
	IFN_SD0_WP,
	FN_NFDATA15_A,
	FN_SDA2_B,
	IFN_SD1_CD,
	FN_NFRBx_A,
	FN_SIM0_CLK_B,
	IFN_SD1_WP,
	FN_NFCEx_A,
	FN_SIM0_D_B,
	IFN_SCK0,
	FN_HSCK1_B,
	FN_MSIOF1_SS2_B,
	FN_AUDIO_CLKC_B,
	FN_SDA2_A,
	FN_SIM0_RST_B,
	FN_STP_OPWM_0_C,
	FN_RIF0_CLK_B,
	FN_ADICHS2,
	FN_SCK5_B,
	IFN_RX0,
	FN_HRX1_B,
	FN_TS_SCK0_C,
	FN_STP_ISCLK_0_C,
	FN_RIF0_D0_B,

	/* IPSR12 */
	IFN_TX0,
	FN_HTX1_B,
	FN_TS_SPSYNC0_C,
	FN_STP_ISSYNC_0_C,
	FN_RIF0_D1_B,
	IFN_CTS0x,
	FN_HCTS1x_B,
	FN_MSIOF1_SYNC_B,
	FN_TS_SPSYNC1_C,
	FN_STP_ISSYNC_1_C,
	FN_RIF1_SYNC_B,
	FN_AUDIO_CLKOUT_C,
	FN_ADICS_SAMP,
	IFN_RTS0x_TANS,
	FN_HRTS1x_B,
	FN_MSIOF1_SS1_B,
	FN_AUDIO_CLKA_B,
	FN_SCL2_A,
	FN_STP_IVCXO27_1_C,
	FN_RIF0_SYNC_B,
	FN_ADICHS1,
	IFN_RX1_A,
	FN_HRX1_A,
	FN_TS_SDAT0_C,
	FN_STP_ISD_0_C,
	FN_RIF1_CLK_C,
	IFN_TX1_A,
	FN_HTX1_A,
	FN_TS_SDEN0_C,
	FN_STP_ISEN_0_C,
	FN_RIF1_D0_C,
	IFN_CTS1x,
	FN_HCTS1x_A,
	FN_MSIOF1_RXD_B,
	FN_TS_SDEN1_C,
	FN_STP_ISEN_1_C,
	FN_RIF1_D0_B,
	FN_ADIDATA,
	IFN_RTS1x_TANS,
	FN_HRTS1x_A,
	FN_MSIOF1_TXD_B,
	FN_TS_SDAT1_C,
	FN_STP_ISD_1_C,
	FN_RIF1_D1_B,
	FN_ADICHS0,
	IFN_SCK2,
	FN_SCIF_CLK_B,
	FN_MSIOF1_SCK_B,
	FN_TS_SCK1_C,
	FN_STP_ISCLK_1_C,
	FN_RIF1_CLK_B,
	FN_ADICLK,

	/* IPSR13 */
	IFN_TX2_A,
	FN_SD2_CD_B,
	FN_SCL1_A,
	FN_FMCLK_A,
	FN_RIF1_D1_C,
	FN_FSO_CFE_0x,
	IFN_RX2_A,
	FN_SD2_WP_B,
	FN_SDA1_A,
	FN_FMIN_A,
	FN_RIF1_SYNC_C,
	FN_FSO_CFE_1x,
	IFN_HSCK0,
	FN_MSIOF1_SCK_D,
	FN_AUDIO_CLKB_A,
	FN_SSI_SDATA1_B,
	FN_TS_SCK0_D,
	FN_STP_ISCLK_0_D,
	FN_RIF0_CLK_C,
	FN_RX5_B,
	IFN_HRX0,
	FN_MSIOF1_RXD_D,
	FN_SSI_SDATA2_B,
	FN_TS_SDEN0_D,
	FN_STP_ISEN_0_D,
	FN_RIF0_D0_C,
	IFN_HTX0,
	FN_MSIOF1_TXD_D,
	FN_SSI_SDATA9_B,
	FN_TS_SDAT0_D,
	FN_STP_ISD_0_D,
	FN_RIF0_D1_C,
	IFN_HCTS0x,
	FN_RX2_B,
	FN_MSIOF1_SYNC_D,
	FN_SSI_SCK9_A,
	FN_TS_SPSYNC0_D,
	FN_STP_ISSYNC_0_D,
	FN_RIF0_SYNC_C,
	FN_AUDIO_CLKOUT1_A,
	IFN_HRTS0x,
	FN_TX2_B,
	FN_MSIOF1_SS1_D,
	FN_SSI_WS9_A,
	FN_STP_IVCXO27_0_D,
	FN_BPFCLK_A,
	FN_AUDIO_CLKOUT2_A,
	IFN_MSIOF0_SYNC,
	FN_AUDIO_CLKOUT_A,
	FN_TX5_B,
	FN_BPFCLK_D,

	/* IPSR14 */
	IFN_MSIOF0_SS1,
	FN_RX5_A,
	FN_NFWPx_A,
	FN_AUDIO_CLKA_C,
	FN_SSI_SCK2_A,
	FN_STP_IVCXO27_0_C,
	FN_AUDIO_CLKOUT3_A,
	FN_TCLK1_B,
	IFN_MSIOF0_SS2,
	FN_TX5_A,
	FN_MSIOF1_SS2_D,
	FN_AUDIO_CLKC_A,
	FN_SSI_WS2_A,
	FN_STP_OPWM_0_D,
	FN_AUDIO_CLKOUT_D,
	FN_SPEEDIN_B,
	IFN_MLB_CLK,
	FN_MSIOF1_SCK_F,
	FN_SCL1_B,
	IFN_MLB_SIG,
	FN_RX1_B,
	FN_MSIOF1_SYNC_F,
	FN_SDA1_B,
	IFN_MLB_DAT,
	FN_TX1_B,
	FN_MSIOF1_RXD_F,
	IFN_SSI_SCK01239,
	FN_MSIOF1_TXD_F,
	FN_MOUT0,
	IFN_SSI_WS01239,
	FN_MSIOF1_SS1_F,
	FN_MOUT1,
	IFN_SSI_SDATA0,
	FN_MSIOF1_SS2_F,
	FN_MOUT2,

	/* IPSR15 */
	IFN_SSI_SDATA1_A,
	FN_MOUT5,
	IFN_SSI_SDATA2_A,
	FN_SSI_SCK1_B,
	FN_MOUT6,
	IFN_SSI_SCK34,
	FN_MSIOF1_SS1_A,
	FN_STP_OPWM_0_A,
	IFN_SSI_WS34,
	FN_HCTS2x_A,
	FN_MSIOF1_SS2_A,
	FN_STP_IVCXO27_0_A,
	IFN_SSI_SDATA3,
	FN_HRTS2x_A,
	FN_MSIOF1_TXD_A,
	FN_TS_SCK0_A,
	FN_STP_ISCLK_0_A,
	FN_RIF0_D1_A,
	FN_RIF2_D0_A,
	IFN_SSI_SCK4,
	FN_HRX2_A,
	FN_MSIOF1_SCK_A,
	FN_TS_SDAT0_A,
	FN_STP_ISD_0_A,
	FN_RIF0_CLK_A,
	FN_RIF2_CLK_A,
	IFN_SSI_WS4,
	FN_HTX2_A,
	FN_MSIOF1_SYNC_A,
	FN_TS_SDEN0_A,
	FN_STP_ISEN_0_A,
	FN_RIF0_SYNC_A,
	FN_RIF2_SYNC_A,
	IFN_SSI_SDATA4,
	FN_HSCK2_A,
	FN_MSIOF1_RXD_A,
	FN_TS_SPSYNC0_A,
	FN_STP_ISSYNC_0_A,
	FN_RIF0_D0_A,
	FN_RIF2_D1_A,

	/* IPSR16 */
	IFN_SSI_SCK6,
	FN_SIM0_RST_D,
	IFN_SSI_WS6,
	FN_SIM0_D_D,
	IFN_SSI_SDATA6,
	FN_SIM0_CLK_D,
	FN_SATA_DEVSLP_A,
	IFN_SSI_SCK78,
	FN_HRX2_B,
	FN_MSIOF1_SCK_C,
	FN_TS_SCK1_A,
	FN_STP_ISCLK_1_A,
	FN_RIF1_CLK_A,
	FN_RIF3_CLK_A,
	IFN_SSI_WS78,
	FN_HTX2_B,
	FN_MSIOF1_SYNC_C,
	FN_TS_SDAT1_A,
	FN_STP_ISD_1_A,
	FN_RIF1_SYNC_A,
	FN_RIF3_SYNC_A,
	IFN_SSI_SDATA7,
	FN_HCTS2x_B,
	FN_MSIOF1_RXD_C,
	FN_TS_SDEN1_A,
	FN_STP_ISEN_1_A,
	FN_RIF1_D0_A,
	FN_RIF3_D0_A,
	FN_TCLK2_A,
	IFN_SSI_SDATA8,
	FN_HRTS2x_B,
	FN_MSIOF1_TXD_C,
	FN_TS_SPSYNC1_A,
	FN_STP_ISSYNC_1_A,
	FN_RIF1_D1_A,
	FN_RIF3_D1_A,
	IFN_SSI_SDATA9_A,
	FN_HSCK2_B,
	FN_MSIOF1_SS1_C,
	FN_HSCK1_A,
	FN_SSI_WS1_B,
	FN_SCK1,
	FN_STP_IVCXO27_1_A,
	FN_SCK5_A,

	/* IPSR17 */
	IFN_AUDIO_CLKA_A,
	FN_CC5_OSCOUT,
	IFN_AUDIO_CLKB_B,
	FN_SCIF_CLK_A,
	FN_STP_IVCXO27_1_D,
	FN_REMOCON_A,
	FN_TCLK1_A,
	IFN_USB0_PWEN,
	FN_SIM0_RST_C,
	FN_TS_SCK1_D,
	FN_STP_ISCLK_1_D,
	FN_BPFCLK_B,
	FN_RIF3_CLK_B,
	FN_HSCK2_C,
	IFN_USB0_OVC,
	FN_SIM0_D_C,
	FN_TS_SDAT1_D,
	FN_STP_ISD_1_D,
	FN_RIF3_SYNC_B,
	FN_HRX2_C,
	IFN_USB1_PWEN,
	FN_SIM0_CLK_C,
	FN_SSI_SCK1_A,
	FN_TS_SCK0_E,
	FN_STP_ISCLK_0_E,
	FN_FMCLK_B,
	FN_RIF2_CLK_B,
	FN_SPEEDIN_A,
	FN_HTX2_C,
	IFN_USB1_OVC,
	FN_MSIOF1_SS2_C,
	FN_SSI_WS1_A,
	FN_TS_SDAT0_E,
	FN_STP_ISD_0_E,
	FN_FMIN_B,
	FN_RIF2_SYNC_B,
	FN_REMOCON_B,
	FN_HCTS2x_C,
	IFN_USB30_PWEN,
	FN_AUDIO_CLKOUT_B,
	FN_SSI_SCK2_B,
	FN_TS_SDEN1_D,
	FN_STP_ISEN_1_D,
	FN_STP_OPWM_0_E,
	FN_RIF3_D0_B,
	FN_TCLK2_B,
	FN_TPU0TO0,
	FN_BPFCLK_C,
	FN_HRTS2x_C,
	IFN_USB30_OVC,
	FN_AUDIO_CLKOUT1_B,
	FN_SSI_WS2_B,
	FN_TS_SPSYNC1_D,
	FN_STP_ISSYNC_1_D,
	FN_STP_IVCXO27_0_E,
	FN_RIF3_D1_B,
	FN_FSO_TOEx,
	FN_TPU0TO1,

	/* IPSR18 */
	IFN_USB3_PWEN,
	FN_AUDIO_CLKOUT2_B,
	FN_SSI_SCK9_B,
	FN_TS_SDEN0_E,
	FN_STP_ISEN_0_E,
	FN_RIF2_D0_B,
	FN_TPU0TO2,
	FN_FMCLK_C,
	FN_FMCLK_D,
	IFN_USB3_OVC,
	FN_AUDIO_CLKOUT3_B,
	FN_SSI_WS9_B,
	FN_TS_SPSYNC0_E,
	FN_STP_ISSYNC_0_E,
	FN_RIF2_D1_B,
	FN_TPU0TO3,
	FN_FMIN_C,
	FN_FMIN_D,

	/* MOD_SEL0 */
	/* sel_msiof3[3](0,1,2,3,4) */
	FN_SEL_MSIOF3_0, FN_SEL_MSIOF3_1,
	FN_SEL_MSIOF3_2, FN_SEL_MSIOF3_3,
	FN_SEL_MSIOF3_4,
	/* sel_msiof2[2](0,1,2,3) */
	FN_SEL_MSIOF2_0, FN_SEL_MSIOF2_1,
	FN_SEL_MSIOF2_2, FN_SEL_MSIOF2_3,
	/* sel_msiof1[3](0,1,2,3,4,5,6) */
	FN_SEL_MSIOF1_0, FN_SEL_MSIOF1_1,
	FN_SEL_MSIOF1_2, FN_SEL_MSIOF1_3,
	FN_SEL_MSIOF1_4, FN_SEL_MSIOF1_5,
	FN_SEL_MSIOF1_6,
	/* sel_lbsc[1](0,1) */
	FN_SEL_LBSC_0, FN_SEL_LBSC_1,
	/* sel_iebus[1](0,1) */
	FN_SEL_IEBUS_0, FN_SEL_IEBUS_1,
	/* sel_i2c2[1](0,1) */
	FN_SEL_I2C2_0, FN_SEL_I2C2_1,
	/* sel_i2c1[1](0,1) */
	FN_SEL_I2C1_0, FN_SEL_I2C1_1,
	/* sel_hscif4[1](0,1) */
	FN_SEL_HSCIF4_0, FN_SEL_HSCIF4_1,
	/* sel_hscif3[2](0,1,2,3) */
	FN_SEL_HSCIF3_0, FN_SEL_HSCIF3_1,
	FN_SEL_HSCIF3_2, FN_SEL_HSCIF3_3,
	/* sel_hscif1[1](0,1) */
	FN_SEL_HSCIF1_0, FN_SEL_HSCIF1_1,
	/* reserved[1] */
	/* sel_hscif2[2](0,1,2) */
	FN_SEL_HSCIF2_0, FN_SEL_HSCIF2_1,
	FN_SEL_HSCIF2_2,
	/* sel_etheravb[1](0,1) */
	FN_SEL_ETHERAVB_0, FN_SEL_ETHERAVB_1,
	/* sel_drif3[1](0,1) */
	FN_SEL_DRIF3_0, FN_SEL_DRIF3_1,
	/* sel_drif2[1](0,1) */
	FN_SEL_DRIF2_0, FN_SEL_DRIF2_1,
	/* sel_drif1[2](0,1,2) */
	FN_SEL_DRIF1_0, FN_SEL_DRIF1_1,
	FN_SEL_DRIF1_2,
	/* sel_drif0[2](0,1,2) */
	FN_SEL_DRIF0_0, FN_SEL_DRIF0_1,
	FN_SEL_DRIF0_2,
	/* sel_canfd0[1](0,1) */
	FN_SEL_CANFD_0, FN_SEL_CANFD_1,
	/* sel_adg_a[2](0,1,2) */
	FN_SEL_ADG_A_0, FN_SEL_ADG_A_1,
	FN_SEL_ADG_A_2,
	/* reserved[3]*/

	/* MOD_SEL1 */
	/* sel_tsif1[2](0,1,2,3) */
	FN_SEL_TSIF1_0, FN_SEL_TSIF1_1,
	FN_SEL_TSIF1_2, FN_SEL_TSIF1_3,
	/* sel_tsif0[3](0,1,2,3,4) */
	FN_SEL_TSIF0_0, FN_SEL_TSIF0_1,
	FN_SEL_TSIF0_2, FN_SEL_TSIF0_3,
	FN_SEL_TSIF0_4,
	/* sel_timer_tmu1[1](0,1) */
	FN_SEL_TIMER_TMU1_0, FN_SEL_TIMER_TMU1_1,
	/* sel_ssp1_1[2](0,1,2,3) */
	FN_SEL_SSP1_1_0, FN_SEL_SSP1_1_1,
	FN_SEL_SSP1_1_2, FN_SEL_SSP1_1_3,
	/* sel_ssp1_0[3](0,1,2,3,4) */
	FN_SEL_SSP1_0_0, FN_SEL_SSP1_0_1,
	FN_SEL_SSP1_0_2, FN_SEL_SSP1_0_3,
	FN_SEL_SSP1_0_4,
	/* sel_ssi1[1](0,1) */
	FN_SEL_SSI_0, FN_SEL_SSI_1,
	/* sel_speed_pulse_if[1](0,1) */
	FN_SEL_SPEED_PULSE_IF_0, FN_SEL_SPEED_PULSE_IF_1,
	/* sel_simcard[2](0,1,2,3) */
	FN_SEL_SIMCARD_0, FN_SEL_SIMCARD_1,
	FN_SEL_SIMCARD_2, FN_SEL_SIMCARD_3,
	/* sel_sdhi2[1](0,1) */
	FN_SEL_SDHI2_0, FN_SEL_SDHI2_1,
	/* sel_scif4[2](0,1,2) */
	FN_SEL_SCIF4_0, FN_SEL_SCIF4_1,
	FN_SEL_SCIF4_2,
	/* sel_scif3[1](0,1) */
	FN_SEL_SCIF3_0, FN_SEL_SCIF3_1,
	/* sel_scif2[1](0,1) */
	FN_SEL_SCIF2_0, FN_SEL_SCIF2_1,
	/* sel_scif1[1](0,1) */
	FN_SEL_SCIF1_0, FN_SEL_SCIF1_1,
	/* sel_scif[1](0,1) */
	FN_SEL_SCIF_0, FN_SEL_SCIF_1,
	/* sel_remocon[1](0,1) */
	FN_SEL_REMOCON_0, FN_SEL_REMOCON_1,
	/* reserved[8..7] */
	/* sel_rcan0[1](0,1) */
	FN_SEL_RCAN_0, FN_SEL_RCAN_1,
	/* sel_pwm6[1](0,1) */
	FN_SEL_PWM6_0, FN_SEL_PWM6_1,
	/* sel_pwm5[1](0,1) */
	FN_SEL_PWM5_0, FN_SEL_PWM5_1,
	/* sel_pwm4[1](0,1) */
	FN_SEL_PWM4_0, FN_SEL_PWM4_1,
	/* sel_pwm3[1](0,1) */
	FN_SEL_PWM3_0, FN_SEL_PWM3_1,
	/* sel_pwm2[1](0,1) */
	FN_SEL_PWM2_0, FN_SEL_PWM2_1,
	/* sel_pwm1[1](0,1) */
	FN_SEL_PWM1_0, FN_SEL_PWM1_1,

	/* MOD_SEL2 */
	/* i2c_sel_5[1](0,1) */
	FN_I2C_SEL_5_0, FN_I2C_SEL_5_1,
	/* i2c_sel_3[1](0,1) */
	FN_I2C_SEL_3_0, FN_I2C_SEL_3_1,
	/* i2c_sel_0[1](0,1) */
	FN_I2C_SEL_0_0, FN_I2C_SEL_0_1,
	/* sel_fm[2](0,1,2,3) */
	FN_SEL_FM_0, FN_SEL_FM_1,
	FN_SEL_FM_2, FN_SEL_FM_3,
	/* sel_scif5[1](0,1) */
	FN_SEL_SCIF5_0, FN_SEL_SCIF5_1,
	/* sel_i2c6[3](0,1,2) */
	FN_SEL_I2C6_0, FN_SEL_I2C6_1,
	FN_SEL_I2C6_2,
	/* sel_ndfc[1](0,1) */
	FN_SEL_NDFC_0, FN_SEL_NDFC_1,
	/* sel_ssi2[1](0,1) */
	FN_SEL_SSI2_0, FN_SEL_SSI2_1,
	/* sel_ssi9[1](0,1) */
	FN_SEL_SSI9_0, FN_SEL_SSI9_1,
	/* sel_timer_tmu2[1](0,1) */
	FN_SEL_TIMER_TMU2_0, FN_SEL_TIMER_TMU2_1,
	/* sel_adg_b[1](0,1) */
	FN_SEL_ADG_B_0, FN_SEL_ADG_B_1,
	/* sel_adg_c[1](0,1) */
	FN_SEL_ADG_C_0, FN_SEL_ADG_C_1,
	/* reserved[16..16] */
	/* reserved[15..8] */
	/* reserved[7..1] */
	/* sel_vin4[1](0,1) */
	FN_SEL_VIN4_0, FN_SEL_VIN4_1,

	PINMUX_FUNCTION_END,

	PINMUX_MARK_BEGIN,

	/* GPSR0 */
	D15_GMARK,
	D14_GMARK,
	D13_GMARK,
	D12_GMARK,
	D11_GMARK,
	D10_GMARK,
	D9_GMARK,
	D8_GMARK,
	D7_GMARK,
	D6_GMARK,
	D5_GMARK,
	D4_GMARK,
	D3_GMARK,
	D2_GMARK,
	D1_GMARK,
	D0_GMARK,

	/* GPSR1 */
	CLKOUT_GMARK,
	EX_WAIT0_A_GMARK,
	WE1x_GMARK,
	WE0x_GMARK,
	RD_WRx_GMARK,
	RDx_GMARK,
	BSx_GMARK,
	CS1x_A26_GMARK,
	CS0x_GMARK,
	A19_GMARK,
	A18_GMARK,
	A17_GMARK,
	A16_GMARK,
	A15_GMARK,
	A14_GMARK,
	A13_GMARK,
	A12_GMARK,
	A11_GMARK,
	A10_GMARK,
	A9_GMARK,
	A8_GMARK,
	A7_GMARK,
	A6_GMARK,
	A5_GMARK,
	A4_GMARK,
	A3_GMARK,
	A2_GMARK,
	A1_GMARK,
	A0_GMARK,

	/* GPSR2 */
	AVB_AVTP_CAPTURE_A_GMARK,
	AVB_AVTP_MATCH_A_GMARK,
	AVB_LINK_GMARK,
	AVB_PHY_INT_GMARK,
	AVB_MAGIC_GMARK,
	AVB_MDC_GMARK,
	PWM2_A_GMARK,
	PWM1_A_GMARK,
	PWM0_GMARK,
	IRQ5_GMARK,
	IRQ4_GMARK,
	IRQ3_GMARK,
	IRQ2_GMARK,
	IRQ1_GMARK,
	IRQ0_GMARK,

	/* GPSR3 */
	SD1_WP_GMARK,
	SD1_CD_GMARK,
	SD0_WP_GMARK,
	SD0_CD_GMARK,
	SD1_DAT3_GMARK,
	SD1_DAT2_GMARK,
	SD1_DAT1_GMARK,
	SD1_DAT0_GMARK,
	SD1_CMD_GMARK,
	SD1_CLK_GMARK,
	SD0_DAT3_GMARK,
	SD0_DAT2_GMARK,
	SD0_DAT1_GMARK,
	SD0_DAT0_GMARK,
	SD0_CMD_GMARK,
	SD0_CLK_GMARK,

	/* GPSR4 */
	SD3_DS_GMARK,
	SD3_DAT7_GMARK,
	SD3_DAT6_GMARK,
	SD3_DAT5_GMARK,
	SD3_DAT4_GMARK,
	SD3_DAT3_GMARK,
	SD3_DAT2_GMARK,
	SD3_DAT1_GMARK,
	SD3_DAT0_GMARK,
	SD3_CMD_GMARK,
	SD3_CLK_GMARK,
	SD2_DS_GMARK,
	SD2_DAT3_GMARK,
	SD2_DAT2_GMARK,
	SD2_DAT1_GMARK,
	SD2_DAT0_GMARK,
	SD2_CMD_GMARK,
	SD2_CLK_GMARK,

	/* GPSR5 */
	MLB_DAT_GMARK,
	MLB_SIG_GMARK,
	MLB_CLK_GMARK,
	MSIOF0_RXD_MARK,
	MSIOF0_SS2_GMARK,
	MSIOF0_TXD_MARK,
	MSIOF0_SS1_GMARK,
	MSIOF0_SYNC_GMARK,
	MSIOF0_SCK_MARK,
	HRTS0x_GMARK,
	HCTS0x_GMARK,
	HTX0_GMARK,
	HRX0_GMARK,
	HSCK0_GMARK,
	RX2_A_GMARK,
	TX2_A_GMARK,
	SCK2_GMARK,
	RTS1x_TANS_GMARK,
	CTS1x_GMARK,
	TX1_A_GMARK,
	RX1_A_GMARK,
	RTS0x_TANS_GMARK,
	CTS0x_GMARK,
	TX0_GMARK,
	RX0_GMARK,
	SCK0_GMARK,

	/* GPSR6 */
	USB3_OVC_GMARK,
	USB3_PWEN_GMARK,
	USB30_OVC_GMARK,
	USB30_PWEN_GMARK,
	USB1_OVC_GMARK,
	USB1_PWEN_GMARK,
	USB0_OVC_GMARK,
	USB0_PWEN_GMARK,
	AUDIO_CLKB_B_GMARK,
	AUDIO_CLKA_A_GMARK,
	SSI_SDATA9_A_GMARK,
	SSI_SDATA8_GMARK,
	SSI_SDATA7_GMARK,
	SSI_WS78_GMARK,
	SSI_SCK78_GMARK,
	SSI_SDATA6_GMARK,
	SSI_WS6_GMARK,
	SSI_SCK6_GMARK,
	SSI_SDATA5_MARK,
	SSI_WS5_MARK,
	SSI_SCK5_MARK,
	SSI_SDATA4_GMARK,
	SSI_WS4_GMARK,
	SSI_SCK4_GMARK,
	SSI_SDATA3_GMARK,
	SSI_WS34_GMARK,
	SSI_SCK34_GMARK,
	SSI_SDATA2_A_GMARK,
	SSI_SDATA1_A_GMARK,
	SSI_SDATA0_GMARK,
	SSI_WS01239_GMARK,
	SSI_SCK01239_GMARK,

	/* GPSR7 */
	HDMI1_CEC_MARK,
	HDMI0_CEC_MARK,
	AVS2_MARK,
	AVS1_MARK,

	/* IPSR0 */
	AVB_MDC_IMARK,
	MSIOF2_SS2_C_MARK,
	AVB_MAGIC_IMARK,
	MSIOF2_SS1_C_MARK,
	SCK4_A_MARK,
	AVB_PHY_INT_IMARK,
	MSIOF2_SYNC_C_MARK,
	RX4_A_MARK,
	AVB_LINK_IMARK,
	MSIOF2_SCK_C_MARK,
	TX4_A_MARK,
	AVB_AVTP_MATCH_A_IMARK,
	MSIOF2_RXD_C_MARK,
	CTS4x_A_MARK,
	FSCLKST2x_A_MARK,
	AVB_AVTP_CAPTURE_A_IMARK,
	MSIOF2_TXD_C_MARK,
	RTS4x_TANS_A_MARK,
	IRQ0_IMARK,
	QPOLB_MARK,
	DU_CDE_MARK,
	VI4_DATA0_B_MARK,
	CAN0_TX_B_MARK,
	CANFD0_TX_B_MARK,
	MSIOF3_SS2_E_MARK,
	IRQ1_IMARK,
	QPOLA_MARK,
	DU_DISP_MARK,
	VI4_DATA1_B_MARK,
	CAN0_RX_B_MARK,
	CANFD0_RX_B_MARK,
	MSIOF3_SS1_E_MARK,

	/* IPSR1 */
	IRQ2_IMARK,
	QCPV_QDE_MARK,
	DU_EXODDF_DU_ODDF_DISP_CDE_MARK,
	VI4_DATA2_B_MARK,
	MSIOF3_SYNC_E_MARK,
	PWM3_B_MARK,
	IRQ3_IMARK,
	QSTVB_QVE_MARK,
	DU_DOTCLKOUT1_MARK,
	VI4_DATA3_B_MARK,
	MSIOF3_SCK_E_MARK,
	PWM4_B_MARK,
	IRQ4_IMARK,
	QSTH_QHS_MARK,
	DU_EXHSYNC_DU_HSYNC_MARK,
	VI4_DATA4_B_MARK,
	MSIOF3_RXD_E_MARK,
	PWM5_B_MARK,
	IRQ5_IMARK,
	QSTB_QHE_MARK,
	DU_EXVSYNC_DU_VSYNC_MARK,
	VI4_DATA5_B_MARK,
	FSCLKST2x_B_MARK,
	MSIOF3_TXD_E_MARK,
	PWM6_B_MARK,
	PWM0_IMARK,
	AVB_AVTP_PPS_MARK,
	VI4_DATA6_B_MARK,
	IECLK_B_MARK,
	PWM1_A_IMARK,
	HRX3_D_MARK,
	VI4_DATA7_B_MARK,
	IERX_B_MARK,
	PWM2_A_IMARK,
	PWMFSW0_MARK,
	HTX3_D_MARK,
	IETX_B_MARK,
	A0_IMARK,
	LCDOUT16_MARK,
	MSIOF3_SYNC_B_MARK,
	VI4_DATA8_MARK,
	DU_DB0_MARK,
	PWM3_A_MARK,

	/* IPSR2 */
	A1_IMARK,
	LCDOUT17_MARK,
	MSIOF3_TXD_B_MARK,
	VI4_DATA9_MARK,
	DU_DB1_MARK,
	PWM4_A_MARK,
	A2_IMARK,
	LCDOUT18_MARK,
	MSIOF3_SCK_B_MARK,
	VI4_DATA10_MARK,
	DU_DB2_MARK,
	PWM5_A_MARK,
	A3_IMARK,
	LCDOUT19_MARK,
	MSIOF3_RXD_B_MARK,
	VI4_DATA11_MARK,
	DU_DB3_MARK,
	PWM6_A_MARK,
	A4_IMARK,
	LCDOUT20_MARK,
	MSIOF3_SS1_B_MARK,
	VI4_DATA12_MARK,
	VI5_DATA12_MARK,
	DU_DB4_MARK,
	A5_IMARK,
	LCDOUT21_MARK,
	MSIOF3_SS2_B_MARK,
	SCK4_B_MARK,
	VI4_DATA13_MARK,
	VI5_DATA13_MARK,
	DU_DB5_MARK,
	A6_IMARK,
	LCDOUT22_MARK,
	MSIOF2_SS1_A_MARK,
	RX4_B_MARK,
	VI4_DATA14_MARK,
	VI5_DATA14_MARK,
	DU_DB6_MARK,
	A7_IMARK,
	LCDOUT23_MARK,
	MSIOF2_SS2_A_MARK,
	TX4_B_MARK,
	VI4_DATA15_MARK,
	V15_DATA15_MARK,
	DU_DB7_MARK,
	A8_IMARK,
	RX3_B_MARK,
	MSIOF2_SYNC_A_MARK,
	HRX4_B_MARK,
	SDA6_A_MARK,
	AVB_AVTP_MATCH_B_MARK,
	PWM1_B_MARK,

	/* IPSR3 */
	A9_IMARK,
	MSIOF2_SCK_A_MARK,
	CTS4x_B_MARK,
	VI5_VSYNCx_MARK,
	A10_IMARK,
	MSIOF2_RXD_A_MARK,
	RTS4n_TANS_B_MARK,
	VI5_HSYNCx_MARK,
	A11_IMARK,
	TX3_B_MARK,
	MSIOF2_TXD_A_MARK,
	HTX4_B_MARK,
	HSCK4_MARK,
	VI5_FIELD_MARK,
	SCL6_A_MARK,
	AVB_AVTP_CAPTURE_B_MARK,
	PWM2_B_MARK,
	A12_IMARK,
	LCDOUT12_MARK,
	MSIOF3_SCK_C_MARK,
	HRX4_A_MARK,
	VI5_DATA8_MARK,
	DU_DG4_MARK,
	A13_IMARK,
	LCDOUT13_MARK,
	MSIOF3_SYNC_C_MARK,
	HTX4_A_MARK,
	VI5_DATA9_MARK,
	DU_DG5_MARK,
	A14_IMARK,
	LCDOUT14_MARK,
	MSIOF3_RXD_C_MARK,
	HCTS4x_MARK,
	VI5_DATA10_MARK,
	DU_DG6_MARK,
	A15_IMARK,
	LCDOUT15_MARK,
	MSIOF3_TXD_C_MARK,
	HRTS4x_MARK,
	VI5_DATA11_MARK,
	DU_DG7_MARK,
	A16_IMARK,
	LCDOUT8_MARK,
	VI4_FIELD_MARK,
	DU_DG0_MARK,

	/* IPSR4 */
	A17_IMARK,
	LCDOUT9_MARK,
	VI4_VSYNCx_MARK,
	DU_DG1_MARK,
	A18_IMARK,
	LCDOUT10_MARK,
	VI4_HSYNCx_MARK,
	DU_DG2_MARK,
	A19_IMARK,
	LCDOUT11_MARK,
	VI4_CLKENB_MARK,
	DU_DG3_MARK,
	CS0x_IMARK,
	VI5_CLKENB_MARK,
	CS1x_A26_IMARK,
	VI5_CLK_MARK,
	EX_WAIT0_B_MARK,
	BSx_IMARK,
	QSTVA_QVS_MARK,
	MSIOF3_SCK_D_MARK,
	SCK3_MARK,
	HSCK3_MARK,
	CAN1_TX_MARK,
	CANFD1_TX_MARK,
	IETX_A_MARK,
	RDx_IMARK,
	MSIOF3_SYNC_D_MARK,
	RX3_A_MARK,
	HRX3_A_MARK,
	CAN0_TX_A_MARK,
	CANFD0_TX_A_MARK,
	RD_WRx_IMARK,
	MSIOF3_RXD_D_MARK,
	TX3_A_MARK,
	HTX3_A_MARK,
	CAN0_RX_A_MARK,
	CANFD0_RX_A_MARK,

	/* IPSR5 */
	WE0x_IMARK,
	MSIIOF3_TXD_D_MARK,
	CTS3x_MARK,
	HCTS3x_MARK,
	SCL6_B_MARK,
	CAN_CLK_MARK,
	IECLK_A_MARK,
	WE1x_IMARK,
	MSIOF3_SS1_D_MARK,
	RTS3x_TANS_MARK,
	HRTS3x_MARK,
	SDA6_B_MARK,
	CAN1_RX_MARK,
	CANFD1_RX_MARK,
	IERX_A_MARK,
	EX_WAIT0_A_IMARK,
	QCLK_MARK,
	VI4_CLK_MARK,
	DU_DOTCLKOUT0_MARK,
	D0_IMARK,
	MSIOF2_SS1_B_MARK,
	MSIOF3_SCK_A_MARK,
	VI4_DATA16_MARK,
	VI5_DATA0_MARK,
	D1_IMARK,
	MSIOF2_SS2_B_MARK,
	MSIOF3_SYNC_A_MARK,
	VI4_DATA17_MARK,
	VI5_DATA1_MARK,
	D2_IMARK,
	MSIOF3_RXD_A_MARK,
	VI4_DATA18_MARK,
	VI5_DATA2_MARK,
	D3_IMARK,
	MSIOF3_TXD_A_MARK,
	VI4_DATA19_MARK,
	VI5_DATA3_MARK,
	D4_IMARK,
	MSIOF2_SCK_B_MARK,
	VI4_DATA20_MARK,
	VI5_DATA4_MARK,

	/* IPSR6 */
	D5_IMARK,
	MSIOF2_SYNC_B_MARK,
	VI4_DATA21_MARK,
	VI5_DATA5_MARK,
	D6_IMARK,
	MSIOF2_RXD_B_MARK,
	VI4_DATA22_MARK,
	VI5_DATA6_MARK,
	D7_IMARK,
	MSIOF2_TXD_B_MARK,
	VI4_DATA23_MARK,
	VI5_DATA7_MARK,
	D8_IMARK,
	LCDOUT0_MARK,
	MSIOF2_SCK_D_MARK,
	SCK4_C_MARK,
	VI4_DATA0_A_MARK,
	DU_DR0_MARK,
	D9_IMARK,
	LCDOUT1_MARK,
	MSIOF2_SYNC_D_MARK,
	VI4_DATA1_A_MARK,
	DU_DR1_MARK,
	D10_IMARK,
	LCDOUT2_MARK,
	MSIOF2_RXD_D_MARK,
	HRX3_B_MARK,
	VI4_DATA2_A_MARK,
	CTS4x_C_MARK,
	DU_DR2_MARK,
	D11_IMARK,
	LCDOUT3_MARK,
	MSIOF2_TXD_D_MARK,
	HTX3_B_MARK,
	VI4_DATA3_A_MARK,
	RTS4x_TANS_C_MARK,
	DU_DR3_MARK,
	D12_IMARK,
	LCDOUT4_MARK,
	MSIOF2_SS1_D_MARK,
	RX4_C_MARK,
	VI4_DATA4_A_MARK,
	DU_DR4_MARK,

	/* IPSR7 */
	D13_IMARK,
	LCDOUT5_MARK,
	MSIOF2_SS2_D_MARK,
	TX4_C_MARK,
	VI4_DATA5_A_MARK,
	DU_DR5_MARK,
	D14_IMARK,
	LCDOUT6_MARK,
	MSIOF3_SS1_A_MARK,
	HRX3_C_MARK,
	VI4_DATA6_A_MARK,
	DU_DR6_MARK,
	SCL6_C_MARK,
	D15_IMARK,
	LCDOUT7_MARK,
	MSIOF3_SS2_A_MARK,
	HTX3_C_MARK,
	VI4_DATA7_A_MARK,
	DU_DR7_MARK,
	SDA6_C_MARK,
	FSCLKST_MARK,
	SD0_CLK_IMARK,
	MSIOF1_SCK_E_MARK,
	STP_OPWM_0_B_MARK,
	SD0_CMD_IMARK,
	MSIOF1_SYNC_E_MARK,
	STP_IVCXO27_0_B_MARK,
	SD0_DAT0_IMARK,
	MSIOF1_RXD_E_MARK,
	TS_SCK0_B_MARK,
	STP_ISCLK_0_B_MARK,
	SD0_DAT1_IMARK,
	MSIOF1_TXD_E_MARK,
	TS_SPSYNC0_B_MARK,
	STP_ISSYNC_0_B_MARK,

	/* IPSR8 */
	SD0_DAT2_IMARK,
	MSIOF1_SS1_E_MARK,
	TS_SDAT0_B_MARK,
	STP_ISD_0_B_MARK,
	SD0_DAT3_IMARK,
	MSIOF1_SS2_E_MARK,
	TS_SDEN0_B_MARK,
	STP_ISEN_0_B_MARK,
	SD1_CLK_IMARK,
	MSIOF1_SCK_G_MARK,
	SIM0_CLK_A_MARK,
	SD1_CMD_IMARK,
	MSIOF1_SYNC_G_MARK,
	NFCEx_B_MARK,
	SIM0_D_A_MARK,
	STP_IVCXO27_1_B_MARK,
	SD1_DAT0_IMARK,
	SD2_DAT4_MARK,
	MSIOF1_RXD_G_MARK,
	NFWPx_B_MARK,
	TS_SCK1_B_MARK,
	STP_ISCLK_1_B_MARK,
	SD1_DAT1_IMARK,
	SD2_DAT5_MARK,
	MSIOF1_TXD_G_MARK,
	NFDATA14_B_MARK,
	TS_SPSYNC1_B_MARK,
	STP_ISSYNC_1_B_MARK,
	SD1_DAT2_IMARK,
	SD2_DAT6_MARK,
	MSIOF1_SS1_G_MARK,
	NFDATA15_B_MARK,
	TS_SDAT1_B_MARK,
	STP_IOD_1_B_MARK,
	SD1_DAT3_IMARK,
	SD2_DAT7_MARK,
	MSIOF1_SS2_G_MARK,
	NFRBx_B_MARK,
	TS_SDEN1_B_MARK,
	STP_ISEN_1_B_MARK,

	/* IPSR9 */
	SD2_CLK_IMARK,
	NFDATA8_MARK,
	SD2_CMD_IMARK,
	NFDATA9_MARK,
	SD2_DAT0_IMARK,
	NFDATA10_MARK,
	SD2_DAT1_IMARK,
	NFDATA11_MARK,
	SD2_DAT2_IMARK,
	NFDATA12_MARK,
	SD2_DAT3_IMARK,
	NFDATA13_MARK,
	SD2_DS_IMARK,
	NFALE_MARK,
	SATA_DEVSLP_B_MARK,
	SD3_CLK_IMARK,
	NFWEx_MARK,

	/* IPSR10 */
	SD3_CMD_IMARK,
	NFREx_MARK,
	SD3_DAT0_IMARK,
	NFDATA0_MARK,
	SD3_DAT1_IMARK,
	NFDATA1_MARK,
	SD3_DAT2_IMARK,
	NFDATA2_MARK,
	SD3_DAT3_IMARK,
	NFDATA3_MARK,
	SD3_DAT4_IMARK,
	SD2_CD_A_MARK,
	NFDATA4_MARK,
	SD3_DAT5_IMARK,
	SD2_WP_A_MARK,
	NFDATA5_MARK,
	SD3_DAT6_IMARK,
	SD3_CD_MARK,
	NFDATA6_MARK,

	/* IPSR11 */
	SD3_DAT7_IMARK,
	SD3_WP_MARK,
	NFDATA7_MARK,
	SD3_DS_IMARK,
	NFCLE_MARK,
	SD0_CD_IMARK,
	NFDATA14_A_MARK,
	SCL2_B_MARK,
	SIM0_RST_A_MARK,
	SD0_WP_IMARK,
	NFDATA15_A_MARK,
	SDA2_B_MARK,
	SD1_CD_IMARK,
	NFRBx_A_MARK,
	SIM0_CLK_B_MARK,
	SD1_WP_IMARK,
	NFCEx_A_MARK,
	SIM0_D_B_MARK,
	SCK0_IMARK,
	HSCK1_B_MARK,
	MSIOF1_SS2_B_MARK,
	AUDIO_CLKC_B_MARK,
	SDA2_A_MARK,
	SIM0_RST_B_MARK,
	STP_OPWM_0_C_MARK,
	RIF0_CLK_B_MARK,
	ADICHS2_MARK,
	SCK5_B_MARK,
	RX0_IMARK,
	HRX1_B_MARK,
	TS_SCK0_C_MARK,
	STP_ISCLK_0_C_MARK,
	RIF0_D0_B_MARK,

	/* IPSR12 */
	TX0_IMARK,
	HTX1_B_MARK,
	TS_SPSYNC0_C_MARK,
	STP_ISSYNC_0_C_MARK,
	RIF0_D1_B_MARK,
	CTS0x_IMARK,
	HCTS1x_B_MARK,
	MSIOF1_SYNC_B_MARK,
	TS_SPSYNC1_C_MARK,
	STP_ISSYNC_1_C_MARK,
	RIF1_SYNC_B_MARK,
	AUDIO_CLKOUT_C_MARK,
	ADICS_SAMP_MARK,
	RTS0x_TANS_IMARK,
	HRTS1x_B_MARK,
	MSIOF1_SS1_B_MARK,
	AUDIO_CLKA_B_MARK,
	SCL2_A_MARK,
	STP_IVCXO27_1_C_MARK,
	RIF0_SYNC_B_MARK,
	ADICHS1_MARK,
	RX1_A_IMARK,
	HRX1_A_MARK,
	TS_SDAT0_C_MARK,
	STP_ISD_0_C_MARK,
	RIF1_CLK_C_MARK,
	TX1_A_IMARK,
	HTX1_A_MARK,
	TS_SDEN0_C_MARK,
	STP_ISEN_0_C_MARK,
	RIF1_D0_C_MARK,
	CTS1x_IMARK,
	HCTS1x_A_MARK,
	MSIOF1_RXD_B_MARK,
	TS_SDEN1_C_MARK,
	STP_ISEN_1_C_MARK,
	RIF1_D0_B_MARK,
	ADIDATA_MARK,
	RTS1x_TANS_IMARK,
	HRTS1x_A_MARK,
	MSIOF1_TXD_B_MARK,
	TS_SDAT1_C_MARK,
	STP_ISD_1_C_MARK,
	RIF1_D1_B_MARK,
	ADICHS0_MARK,
	SCK2_IMARK,
	SCIF_CLK_B_MARK,
	MSIOF1_SCK_B_MARK,
	TS_SCK1_C_MARK,
	STP_ISCLK_1_C_MARK,
	RIF1_CLK_B_MARK,
	ADICLK_MARK,

	/* IPSR13 */
	TX2_A_IMARK,
	SD2_CD_B_MARK,
	SCL1_A_MARK,
	FMCLK_A_MARK,
	RIF1_D1_C_MARK,
	FSO_CFE_0x_MARK,
	RX2_A_IMARK,
	SD2_WP_B_MARK,
	SDA1_A_MARK,
	FMIN_A_MARK,
	RIF1_SYNC_C_MARK,
	FSO_CFE_1x_MARK,
	HSCK0_IMARK,
	MSIOF1_SCK_D_MARK,
	AUDIO_CLKB_A_MARK,
	SSI_SDATA1_B_MARK,
	TS_SCK0_D_MARK,
	STP_ISCLK_0_D_MARK,
	RIF0_CLK_C_MARK,
	RX5_B_MARK,
	HRX0_IMARK,
	MSIOF1_RXD_D_MARK,
	SSI_SDATA2_B_MARK,
	TS_SDEN0_D_MARK,
	STP_ISEN_0_D_MARK,
	RIF0_D0_C_MARK,
	HTX0_IMARK,
	MSIOF1_TXD_D_MARK,
	SSI_SDATA9_B_MARK,
	TS_SDAT0_D_MARK,
	STP_ISD_0_D_MARK,
	RIF0_D1_C_MARK,
	HCTS0x_IMARK,
	RX2_B_MARK,
	MSIOF1_SYNC_D_MARK,
	SSI_SCK9_A_MARK,
	TS_SPSYNC0_D_MARK,
	STP_ISSYNC_0_D_MARK,
	RIF0_SYNC_C_MARK,
	AUDIO_CLKOUT1_A_MARK,
	HRTS0x_IMARK,
	TX2_B_MARK,
	MSIOF1_SS1_D_MARK,
	SSI_WS9_A_MARK,
	STP_IVCXO27_0_D_MARK,
	BPFCLK_A_MARK,
	AUDIO_CLKOUT2_A_MARK,
	MSIOF0_SYNC_IMARK,
	AUDIO_CLKOUT_A_MARK,
	TX5_B_MARK,
	BPFCLK_D_MARK,

	/* IPSR14 */
	MSIOF0_SS1_IMARK,
	RX5_A_MARK,
	NFWPx_A_MARK,
	AUDIO_CLKA_C_MARK,
	SSI_SCK2_A_MARK,
	STP_IVCXO27_0_C_MARK,
	AUDIO_CLKOUT3_A_MARK,
	TCLK1_B_MARK,
	MSIOF0_SS2_IMARK,
	TX5_A_MARK,
	MSIOF1_SS2_D_MARK,
	AUDIO_CLKC_A_MARK,
	SSI_WS2_A_MARK,
	STP_OPWM_0_D_MARK,
	AUDIO_CLKOUT_D_MARK,
	SPEEDIN_B_MARK,
	MLB_CLK_IMARK,
	MSIOF1_SCK_F_MARK,
	SCL1_B_MARK,
	MLB_SIG_IMARK,
	RX1_B_MARK,
	MSIOF1_SYNC_F_MARK,
	SDA1_B_MARK,
	MLB_DAT_IMARK,
	TX1_B_MARK,
	MSIOF1_RXD_F_MARK,
	SSI_SCK01239_IMARK,
	MSIOF1_TXD_F_MARK,
	MOUT0_MARK,
	SSI_WS01239_IMARK,
	MSIOF1_SS1_F_MARK,
	MOUT1_MARK,
	SSI_SDATA0_IMARK,
	MSIOF1_SS2_F_MARK,
	MOUT2_MARK,

	/* IPSR15 */
	SSI_SDATA1_A_IMARK,
	MOUT5_MARK,
	SSI_SDATA2_A_IMARK,
	SSI_SCK1_B_MARK,
	MOUT6_MARK,
	SSI_SCK34_IMARK,
	MSIOF1_SS1_A_MARK,
	STP_OPWM_0_A_MARK,
	SSI_WS34_IMARK,
	HCTS2x_A_MARK,
	MSIOF1_SS2_A_MARK,
	STP_IVCXO27_0_A_MARK,
	SSI_SDATA3_IMARK,
	HRTS2x_A_MARK,
	MSIOF1_TXD_A_MARK,
	TS_SCK0_A_MARK,
	STP_ISCLK_0_A_MARK,
	RIF0_D1_A_MARK,
	RIF2_D0_A_MARK,
	SSI_SCK4_IMARK,
	HRX2_A_MARK,
	MSIOF1_SCK_A_MARK,
	TS_SDAT0_A_MARK,
	STP_ISD_0_A_MARK,
	RIF0_CLK_A_MARK,
	RIF2_CLK_A_MARK,
	SSI_WS4_IMARK,
	HTX2_A_MARK,
	MSIOF1_SYNC_A_MARK,
	TS_SDEN0_A_MARK,
	STP_ISEN_0_A_MARK,
	RIF0_SYNC_A_MARK,
	RIF2_SYNC_A_MARK,
	SSI_SDATA4_IMARK,
	HSCK2_A_MARK,
	MSIOF1_RXD_A_MARK,
	TS_SPSYNC0_A_MARK,
	STP_ISSYNC_0_A_MARK,
	RIF0_D0_A_MARK,
	RIF2_D1_A_MARK,

	/* IPSR16 */
	SSI_SCK6_IMARK,
	SIM0_RST_D_MARK,
	SSI_WS6_IMARK,
	SIM0_D_D_MARK,
	SSI_SDATA6_IMARK,
	SIM0_CLK_D_MARK,
	SATA_DEVSLP_A_MARK,
	SSI_SCK78_IMARK,
	HRX2_B_MARK,
	MSIOF1_SCK_C_MARK,
	TS_SCK1_A_MARK,
	STP_ISCLK_1_A_MARK,
	RIF1_CLK_A_MARK,
	RIF3_CLK_A_MARK,
	SSI_WS78_IMARK,
	HTX2_B_MARK,
	MSIOF1_SYNC_C_MARK,
	TS_SDAT1_A_MARK,
	STP_ISD_1_A_MARK,
	RIF1_SYNC_A_MARK,
	RIF3_SYNC_A_MARK,
	SSI_SDATA7_IMARK,
	HCTS2x_B_MARK,
	MSIOF1_RXD_C_MARK,
	TS_SDEN1_A_MARK,
	STP_ISEN_1_A_MARK,
	RIF1_D0_A_MARK,
	RIF3_D0_A_MARK,
	TCLK2_A_MARK,
	SSI_SDATA8_IMARK,
	HRTS2x_B_MARK,
	MSIOF1_TXD_C_MARK,
	TS_SPSYNC1_A_MARK,
	STP_ISSYNC_1_A_MARK,
	RIF1_D1_A_MARK,
	RIF3_D1_A_MARK,
	SSI_SDATA9_A_IMARK,
	HSCK2_B_MARK,
	MSIOF1_SS1_C_MARK,
	HSCK1_A_MARK,
	SSI_WS1_B_MARK,
	SCK1_MARK,
	STP_IVCXO27_1_A_MARK,
	SCK5_A_MARK,

	/* IPSR17 */
	AUDIO_CLKA_A_IMARK,
	CC5_OSCOUT_MARK,
	AUDIO_CLKB_B_IMARK,
	SCIF_CLK_A_MARK,
	STP_IVCXO27_1_D_MARK,
	REMOCON_A_MARK,
	TCLK1_A_MARK,
	USB0_PWEN_IMARK,
	SIM0_RST_C_MARK,
	TS_SCK1_D_MARK,
	STP_ISCLK_1_D_MARK,
	BPFCLK_B_MARK,
	RIF3_CLK_B_MARK,
	HSCK2_C_MARK,
	USB0_OVC_IMARK,
	SIM0_D_C_MARK,
	TS_SDAT1_D_MARK,
	STP_ISD_1_D_MARK,
	RIF3_SYNC_B_MARK,
	HRX2_C_MARK,
	USB1_PWEN_IMARK,
	SIM0_CLK_C_MARK,
	SSI_SCK1_A_MARK,
	TS_SCK0_E_MARK,
	STP_ISCLK_0_E_MARK,
	FMCLK_B_MARK,
	RIF2_CLK_B_MARK,
	SPEEDIN_A_MARK,
	HTX2_C_MARK,
	USB1_OVC_IMARK,
	MSIOF1_SS2_C_MARK,
	SSI_WS1_A_MARK,
	TS_SDAT0_E_MARK,
	STP_ISD_0_E_MARK,
	FMIN_B_MARK,
	RIF2_SYNC_B_MARK,
	REMOCON_B_MARK,
	HCTS2x_C_MARK,
	USB30_PWEN_IMARK,
	AUDIO_CLKOUT_B_MARK,
	SSI_SCK2_B_MARK,
	TS_SDEN1_D_MARK,
	STP_ISEN_1_D_MARK,
	STP_OPWM_0_E_MARK,
	RIF3_D0_B_MARK,
	TCLK2_B_MARK,
	TPU0TO0_MARK,
	BPFCLK_C_MARK,
	HRTS2x_C_MARK,
	USB30_OVC_IMARK,
	AUDIO_CLKOUT1_B_MARK,
	SSI_WS2_B_MARK,
	TS_SPSYNC1_D_MARK,
	STP_ISSYNC_1_D_MARK,
	STP_IVCXO27_0_E_MARK,
	RIF3_D1_B_MARK,
	FSO_TOEx_MARK,
	TPU0TO1_MARK,

	PINMUX_MARK_END,
};

static pinmux_enum_t pinmux_data[] = {
	PINMUX_DATA_GP_ALL(), /* PINMUX_DATA(GP_M_N_DATA, GP_M_N_FN...), */

	/* GPSR0 */
	PINMUX_DATA(D15_GMARK, GFN_D15),
	PINMUX_DATA(D14_GMARK, GFN_D14),
	PINMUX_DATA(D13_GMARK, GFN_D13),
	PINMUX_DATA(D12_GMARK, GFN_D12),
	PINMUX_DATA(D11_GMARK, GFN_D11),
	PINMUX_DATA(D10_GMARK, GFN_D10),
	PINMUX_DATA(D9_GMARK, GFN_D9),
	PINMUX_DATA(D8_GMARK, GFN_D8),
	PINMUX_DATA(D7_GMARK, GFN_D7),
	PINMUX_DATA(D6_GMARK, GFN_D6),
	PINMUX_DATA(D5_GMARK, GFN_D5),
	PINMUX_DATA(D4_GMARK, GFN_D4),
	PINMUX_DATA(D3_GMARK, GFN_D3),
	PINMUX_DATA(D2_GMARK, GFN_D2),
	PINMUX_DATA(D1_GMARK, GFN_D1),
	PINMUX_DATA(D0_GMARK, GFN_D0),

	/* GPSR1 */
	PINMUX_DATA(CLKOUT_GMARK, GFN_CLKOUT),
	PINMUX_DATA(EX_WAIT0_A_GMARK, GFN_EX_WAIT0_A),
	PINMUX_DATA(WE1x_GMARK, GFN_WE1x),
	PINMUX_DATA(WE0x_GMARK, GFN_WE0x),
	PINMUX_DATA(RD_WRx_GMARK, GFN_RD_WRx),
	PINMUX_DATA(RDx_GMARK, GFN_RDx),
	PINMUX_DATA(BSx_GMARK, GFN_BSx),
	PINMUX_DATA(CS1x_A26_GMARK, GFN_CS1x_A26),
	PINMUX_DATA(CS0x_GMARK, GFN_CS0x),
	PINMUX_DATA(A19_GMARK, GFN_A19),
	PINMUX_DATA(A18_GMARK, GFN_A18),
	PINMUX_DATA(A17_GMARK, GFN_A17),
	PINMUX_DATA(A16_GMARK, GFN_A16),
	PINMUX_DATA(A15_GMARK, GFN_A15),
	PINMUX_DATA(A14_GMARK, GFN_A14),
	PINMUX_DATA(A13_GMARK, GFN_A13),
	PINMUX_DATA(A12_GMARK, GFN_A12),
	PINMUX_DATA(A11_GMARK, GFN_A11),
	PINMUX_DATA(A10_GMARK, GFN_A10),
	PINMUX_DATA(A9_GMARK, GFN_A9),
	PINMUX_DATA(A8_GMARK, GFN_A8),
	PINMUX_DATA(A7_GMARK, GFN_A7),
	PINMUX_DATA(A6_GMARK, GFN_A6),
	PINMUX_DATA(A5_GMARK, GFN_A5),
	PINMUX_DATA(A4_GMARK, GFN_A4),
	PINMUX_DATA(A3_GMARK, GFN_A3),
	PINMUX_DATA(A2_GMARK, GFN_A2),
	PINMUX_DATA(A1_GMARK, GFN_A1),
	PINMUX_DATA(A0_GMARK, GFN_A0),

	/* GPSR2 */
	PINMUX_DATA(AVB_AVTP_CAPTURE_A_GMARK, GFN_AVB_AVTP_CAPTURE_A),
	PINMUX_DATA(AVB_AVTP_MATCH_A_GMARK, GFN_AVB_AVTP_MATCH_A),
	PINMUX_DATA(AVB_LINK_GMARK, GFN_AVB_LINK),
	PINMUX_DATA(AVB_PHY_INT_GMARK, GFN_AVB_PHY_INT),
	PINMUX_DATA(AVB_MAGIC_GMARK, GFN_AVB_MAGIC),
	PINMUX_DATA(AVB_MDC_GMARK, GFN_AVB_MDC),
	PINMUX_DATA(PWM2_A_GMARK, GFN_PWM2_A),
	PINMUX_DATA(PWM1_A_GMARK, GFN_PWM1_A),
	PINMUX_DATA(PWM0_GMARK, GFN_PWM0),
	PINMUX_DATA(IRQ5_GMARK, GFN_IRQ5),
	PINMUX_DATA(IRQ4_GMARK, GFN_IRQ4),
	PINMUX_DATA(IRQ3_GMARK, GFN_IRQ3),
	PINMUX_DATA(IRQ2_GMARK, GFN_IRQ2),
	PINMUX_DATA(IRQ1_GMARK, GFN_IRQ1),
	PINMUX_DATA(IRQ0_GMARK, GFN_IRQ0),

	/* GPSR3 */
	PINMUX_DATA(SD1_WP_GMARK, GFN_SD1_WP),
	PINMUX_DATA(SD1_CD_GMARK, GFN_SD1_CD),
	PINMUX_DATA(SD0_WP_GMARK, GFN_SD0_WP),
	PINMUX_DATA(SD0_CD_GMARK, GFN_SD0_CD),
	PINMUX_DATA(SD1_DAT3_GMARK, GFN_SD1_DAT3),
	PINMUX_DATA(SD1_DAT2_GMARK, GFN_SD1_DAT2),
	PINMUX_DATA(SD1_DAT1_GMARK, GFN_SD1_DAT1),
	PINMUX_DATA(SD1_DAT0_GMARK, GFN_SD1_DAT0),
	PINMUX_DATA(SD1_CMD_GMARK, GFN_SD1_CMD),
	PINMUX_DATA(SD1_CLK_GMARK, GFN_SD1_CLK),
	PINMUX_DATA(SD0_DAT3_GMARK, GFN_SD0_DAT3),
	PINMUX_DATA(SD0_DAT2_GMARK, GFN_SD0_DAT2),
	PINMUX_DATA(SD0_DAT1_GMARK, GFN_SD0_DAT1),
	PINMUX_DATA(SD0_DAT0_GMARK, GFN_SD0_DAT0),
	PINMUX_DATA(SD0_CMD_GMARK, GFN_SD0_CMD),
	PINMUX_DATA(SD0_CLK_GMARK, GFN_SD0_CLK),

	/* GPSR4 */
	PINMUX_DATA(SD3_DS_GMARK, GFN_SD3_DS),
	PINMUX_DATA(SD3_DAT7_GMARK, GFN_SD3_DAT7),
	PINMUX_DATA(SD3_DAT6_GMARK, GFN_SD3_DAT6),
	PINMUX_DATA(SD3_DAT5_GMARK, GFN_SD3_DAT5),
	PINMUX_DATA(SD3_DAT4_GMARK, GFN_SD3_DAT4),
	PINMUX_DATA(SD3_DAT3_GMARK, GFN_SD3_DAT3),
	PINMUX_DATA(SD3_DAT2_GMARK, GFN_SD3_DAT2),
	PINMUX_DATA(SD3_DAT1_GMARK, GFN_SD3_DAT1),
	PINMUX_DATA(SD3_DAT0_GMARK, GFN_SD3_DAT0),
	PINMUX_DATA(SD3_CMD_GMARK, GFN_SD3_CMD),
	PINMUX_DATA(SD3_CLK_GMARK, GFN_SD3_CLK),
	PINMUX_DATA(SD2_DS_GMARK, GFN_SD2_DS),
	PINMUX_DATA(SD2_DAT3_GMARK, GFN_SD2_DAT3),
	PINMUX_DATA(SD2_DAT2_GMARK, GFN_SD2_DAT2),
	PINMUX_DATA(SD2_DAT1_GMARK, GFN_SD2_DAT1),
	PINMUX_DATA(SD2_DAT0_GMARK, GFN_SD2_DAT0),
	PINMUX_DATA(SD2_CMD_GMARK, GFN_SD2_CMD),
	PINMUX_DATA(SD2_CLK_GMARK, GFN_SD2_CLK),

	/* GPSR5 */
	PINMUX_DATA(MLB_DAT_GMARK, GFN_MLB_DAT),
	PINMUX_DATA(MLB_SIG_GMARK, GFN_MLB_SIG),
	PINMUX_DATA(MLB_CLK_GMARK, GFN_MLB_CLK),
	PINMUX_DATA(MSIOF0_RXD_MARK, FN_MSIOF0_RXD),
	PINMUX_DATA(MSIOF0_SS2_GMARK, GFN_MSIOF0_SS2),
	PINMUX_DATA(MSIOF0_TXD_MARK, FN_MSIOF0_TXD),
	PINMUX_DATA(MSIOF0_SS1_GMARK, GFN_MSIOF0_SS1),
	PINMUX_DATA(MSIOF0_SYNC_GMARK, GFN_MSIOF0_SYNC),
	PINMUX_DATA(MSIOF0_SCK_MARK, FN_MSIOF0_SCK),
	PINMUX_DATA(HRTS0x_GMARK, GFN_HRTS0x),
	PINMUX_DATA(HCTS0x_GMARK, GFN_HCTS0x),
	PINMUX_DATA(HTX0_GMARK, GFN_HTX0),
	PINMUX_DATA(HRX0_GMARK, GFN_HRX0),
	PINMUX_DATA(HSCK0_GMARK, GFN_HSCK0),
	PINMUX_DATA(RX2_A_GMARK, GFN_RX2_A),
	PINMUX_DATA(TX2_A_GMARK, GFN_TX2_A),
	PINMUX_DATA(SCK2_GMARK, GFN_SCK2),
	PINMUX_DATA(RTS1x_TANS_GMARK, GFN_RTS1x_TANS),
	PINMUX_DATA(CTS1x_GMARK, GFN_CTS1x),
	PINMUX_DATA(TX1_A_GMARK, GFN_TX1_A),
	PINMUX_DATA(RX1_A_GMARK, GFN_RX1_A),
	PINMUX_DATA(RTS0x_TANS_GMARK, GFN_RTS0x_TANS),
	PINMUX_DATA(CTS0x_GMARK, GFN_CTS0x),
	PINMUX_DATA(TX0_GMARK, GFN_TX0),
	PINMUX_DATA(RX0_GMARK, GFN_RX0),
	PINMUX_DATA(SCK0_GMARK, GFN_SCK0),

	/* GPSR6 */
	PINMUX_DATA(USB3_OVC_GMARK, GFN_USB3_OVC),
	PINMUX_DATA(USB3_PWEN_GMARK, GFN_USB3_PWEN),
	PINMUX_DATA(USB30_OVC_GMARK, GFN_USB30_OVC),
	PINMUX_DATA(USB30_PWEN_GMARK, GFN_USB30_PWEN),
	PINMUX_DATA(USB1_OVC_GMARK, GFN_USB1_OVC),
	PINMUX_DATA(USB1_PWEN_GMARK, GFN_USB1_PWEN),
	PINMUX_DATA(USB0_OVC_GMARK, GFN_USB0_OVC),
	PINMUX_DATA(USB0_PWEN_GMARK, GFN_USB0_PWEN),
	PINMUX_DATA(AUDIO_CLKB_B_GMARK, GFN_AUDIO_CLKB_B),
	PINMUX_DATA(AUDIO_CLKA_A_GMARK, GFN_AUDIO_CLKA_A),
	PINMUX_DATA(SSI_SDATA9_A_GMARK, GFN_SSI_SDATA9_A),
	PINMUX_DATA(SSI_SDATA8_GMARK, GFN_SSI_SDATA8),
	PINMUX_DATA(SSI_SDATA7_GMARK, GFN_SSI_SDATA7),
	PINMUX_DATA(SSI_WS78_GMARK, GFN_SSI_WS78),
	PINMUX_DATA(SSI_SCK78_GMARK, GFN_SSI_SCK78),
	PINMUX_DATA(SSI_SDATA6_GMARK, GFN_SSI_SDATA6),
	PINMUX_DATA(SSI_WS6_GMARK, GFN_SSI_WS6),
	PINMUX_DATA(SSI_SCK6_GMARK, GFN_SSI_SCK6),
	PINMUX_DATA(SSI_SDATA5_MARK, FN_SSI_SDATA5),
	PINMUX_DATA(SSI_WS5_MARK, FN_SSI_WS5),
	PINMUX_DATA(SSI_SCK5_MARK, FN_SSI_SCK5),
	PINMUX_DATA(SSI_SDATA4_GMARK, GFN_SSI_SDATA4),
	PINMUX_DATA(SSI_WS4_GMARK, GFN_SSI_WS4),
	PINMUX_DATA(SSI_SCK4_GMARK, GFN_SSI_SCK4),
	PINMUX_DATA(SSI_SDATA3_GMARK, GFN_SSI_SDATA3),
	PINMUX_DATA(SSI_WS34_GMARK, GFN_SSI_WS34),
	PINMUX_DATA(SSI_SCK34_GMARK, GFN_SSI_SCK34),
	PINMUX_DATA(SSI_SDATA2_A_GMARK, GFN_SSI_SDATA2_A),
	PINMUX_DATA(SSI_SDATA1_A_GMARK, GFN_SSI_SDATA1_A),
	PINMUX_DATA(SSI_SDATA0_GMARK, GFN_SSI_SDATA0),
	PINMUX_DATA(SSI_WS01239_GMARK, GFN_SSI_WS01239),
	PINMUX_DATA(SSI_SCK01239_GMARK, GFN_SSI_SCK01239),

	/* GPSR7 */
	PINMUX_DATA(HDMI1_CEC_MARK, FN_HDMI1_CEC),
	PINMUX_DATA(HDMI0_CEC_MARK, FN_HDMI0_CEC),
	PINMUX_DATA(AVS2_MARK, FN_AVS2),
	PINMUX_DATA(AVS1_MARK, FN_AVS1),
};

static struct pinmux_gpio pinmux_gpios[] = {
	PINMUX_GPIO_GP_ALL(),
	/* GPSR0 */
	GPIO_GFN(D15),
	GPIO_GFN(D14),
	GPIO_GFN(D13),
	GPIO_GFN(D12),
	GPIO_GFN(D11),
	GPIO_GFN(D10),
	GPIO_GFN(D9),
	GPIO_GFN(D8),
	GPIO_GFN(D7),
	GPIO_GFN(D6),
	GPIO_GFN(D5),
	GPIO_GFN(D4),
	GPIO_GFN(D3),
	GPIO_GFN(D2),
	GPIO_GFN(D1),
	GPIO_GFN(D0),
	/* GPSR1 */
	GPIO_GFN(CLKOUT),
	GPIO_GFN(EX_WAIT0_A),
	GPIO_GFN(WE1x),
	GPIO_GFN(WE0x),
	GPIO_GFN(RD_WRx),
	GPIO_GFN(RDx),
	GPIO_GFN(BSx),
	GPIO_GFN(CS1x_A26),
	GPIO_GFN(CS0x),
	GPIO_GFN(A19),
	GPIO_GFN(A18),
	GPIO_GFN(A17),
	GPIO_GFN(A16),
	GPIO_GFN(A15),
	GPIO_GFN(A14),
	GPIO_GFN(A13),
	GPIO_GFN(A12),
	GPIO_GFN(A11),
	GPIO_GFN(A10),
	GPIO_GFN(A9),
	GPIO_GFN(A8),
	GPIO_GFN(A7),
	GPIO_GFN(A6),
	GPIO_GFN(A5),
	GPIO_GFN(A4),
	GPIO_GFN(A3),
	GPIO_GFN(A2),
	GPIO_GFN(A1),
	GPIO_GFN(A0),

	/* GPSR2 */
	GPIO_GFN(AVB_AVTP_CAPTURE_A),
	GPIO_GFN(AVB_AVTP_MATCH_A),
	GPIO_GFN(AVB_LINK),
	GPIO_GFN(AVB_PHY_INT),
	GPIO_GFN(AVB_MAGIC),
	GPIO_GFN(AVB_MDC),
	GPIO_GFN(PWM2_A),
	GPIO_GFN(PWM1_A),
	GPIO_GFN(PWM0),
	GPIO_GFN(IRQ5),
	GPIO_GFN(IRQ4),
	GPIO_GFN(IRQ3),
	GPIO_GFN(IRQ2),
	GPIO_GFN(IRQ1),
	GPIO_GFN(IRQ0),

	/* GPSR3 */
	GPIO_GFN(SD1_WP),
	GPIO_GFN(SD1_CD),
	GPIO_GFN(SD0_WP),
	GPIO_GFN(SD0_CD),
	GPIO_GFN(SD1_DAT3),
	GPIO_GFN(SD1_DAT2),
	GPIO_GFN(SD1_DAT1),
	GPIO_GFN(SD1_DAT0),
	GPIO_GFN(SD1_CMD),
	GPIO_GFN(SD1_CLK),
	GPIO_GFN(SD0_DAT3),
	GPIO_GFN(SD0_DAT2),
	GPIO_GFN(SD0_DAT1),
	GPIO_GFN(SD0_DAT0),
	GPIO_GFN(SD0_CMD),
	GPIO_GFN(SD0_CLK),

	/* GPSR4 */
	GPIO_GFN(SD3_DS),
	GPIO_GFN(SD3_DAT7),
	GPIO_GFN(SD3_DAT6),
	GPIO_GFN(SD3_DAT5),
	GPIO_GFN(SD3_DAT4),
	GPIO_GFN(SD3_DAT3),
	GPIO_GFN(SD3_DAT2),
	GPIO_GFN(SD3_DAT1),
	GPIO_GFN(SD3_DAT0),
	GPIO_GFN(SD3_CMD),
	GPIO_GFN(SD3_CLK),
	GPIO_GFN(SD2_DS),
	GPIO_GFN(SD2_DAT3),
	GPIO_GFN(SD2_DAT2),
	GPIO_GFN(SD2_DAT1),
	GPIO_GFN(SD2_DAT0),
	GPIO_GFN(SD2_CMD),
	GPIO_GFN(SD2_CLK),

	/* GPSR5 */
	GPIO_GFN(MLB_DAT),
	GPIO_GFN(MLB_SIG),
	GPIO_GFN(MLB_CLK),
	GPIO_FN(MSIOF0_RXD),
	GPIO_GFN(MSIOF0_SS2),
	GPIO_FN(MSIOF0_TXD),
	GPIO_GFN(MSIOF0_SS1),
	GPIO_GFN(MSIOF0_SYNC),
	GPIO_FN(MSIOF0_SCK),
	GPIO_GFN(HRTS0x),
	GPIO_GFN(HCTS0x),
	GPIO_GFN(HTX0),
	GPIO_GFN(HRX0),
	GPIO_GFN(HSCK0),
	GPIO_GFN(RX2_A),
	GPIO_GFN(TX2_A),
	GPIO_GFN(SCK2),
	GPIO_GFN(RTS1x_TANS),
	GPIO_GFN(CTS1x),
	GPIO_GFN(TX1_A),
	GPIO_GFN(RX1_A),
	GPIO_GFN(RTS0x_TANS),
	GPIO_GFN(CTS0x),
	GPIO_GFN(TX0),
	GPIO_GFN(RX0),
	GPIO_GFN(SCK0),

	/* GPSR6 */
	GPIO_GFN(USB3_OVC),
	GPIO_GFN(USB3_PWEN),
	GPIO_GFN(USB30_OVC),
	GPIO_GFN(USB30_PWEN),
	GPIO_GFN(USB1_OVC),
	GPIO_GFN(USB1_PWEN),
	GPIO_GFN(USB0_OVC),
	GPIO_GFN(USB0_PWEN),
	GPIO_GFN(AUDIO_CLKB_B),
	GPIO_GFN(AUDIO_CLKA_A),
	GPIO_GFN(SSI_SDATA9_A),
	GPIO_GFN(SSI_SDATA8),
	GPIO_GFN(SSI_SDATA7),
	GPIO_GFN(SSI_WS78),
	GPIO_GFN(SSI_SCK78),
	GPIO_GFN(SSI_SDATA6),
	GPIO_GFN(SSI_WS6),
	GPIO_GFN(SSI_SCK6),
	GPIO_FN(SSI_SDATA5),
	GPIO_FN(SSI_WS5),
	GPIO_FN(SSI_SCK5),
	GPIO_GFN(SSI_SDATA4),
	GPIO_GFN(SSI_WS4),
	GPIO_GFN(SSI_SCK4),
	GPIO_GFN(SSI_SDATA3),
	GPIO_GFN(SSI_WS34),
	GPIO_GFN(SSI_SCK34),
	GPIO_GFN(SSI_SDATA2_A),
	GPIO_GFN(SSI_SDATA1_A),
	GPIO_GFN(SSI_SDATA0),
	GPIO_GFN(SSI_WS01239),
	GPIO_GFN(SSI_SCK01239),

	/* GPSR7 */
	GPIO_FN(HDMI1_CEC),
	GPIO_FN(HDMI0_CEC),
	GPIO_FN(AVS2),
	GPIO_FN(AVS1),

	/* IPSR0 */
	GPIO_IFN(AVB_MDC),
	GPIO_FN(MSIOF2_SS2_C),
	GPIO_IFN(AVB_MAGIC),
	GPIO_FN(MSIOF2_SS1_C),
	GPIO_FN(SCK4_A),
	GPIO_IFN(AVB_PHY_INT),
	GPIO_FN(MSIOF2_SYNC_C),
	GPIO_FN(RX4_A),
	GPIO_IFN(AVB_LINK),
	GPIO_FN(MSIOF2_SCK_C),
	GPIO_FN(TX4_A),
	GPIO_IFN(AVB_AVTP_MATCH_A),
	GPIO_FN(MSIOF2_RXD_C),
	GPIO_FN(CTS4x_A),
	GPIO_FN(FSCLKST2x_A),
	GPIO_IFN(AVB_AVTP_CAPTURE_A),
	GPIO_FN(MSIOF2_TXD_C),
	GPIO_FN(RTS4x_TANS_A),
	GPIO_IFN(IRQ0),
	GPIO_FN(QPOLB),
	GPIO_FN(DU_CDE),
	GPIO_FN(VI4_DATA0_B),
	GPIO_FN(CAN0_TX_B),
	GPIO_FN(CANFD0_TX_B),
	GPIO_FN(MSIOF3_SS2_E),
	GPIO_IFN(IRQ1),
	GPIO_FN(QPOLA),
	GPIO_FN(DU_DISP),
	GPIO_FN(VI4_DATA1_B),
	GPIO_FN(CAN0_RX_B),
	GPIO_FN(CANFD0_RX_B),
	GPIO_FN(MSIOF3_SS1_E),

	/* IPSR1 */
	GPIO_IFN(IRQ2),
	GPIO_FN(QCPV_QDE),
	GPIO_FN(DU_EXODDF_DU_ODDF_DISP_CDE),
	GPIO_FN(VI4_DATA2_B),
	GPIO_FN(MSIOF3_SYNC_E),
	GPIO_FN(PWM3_B),
	GPIO_IFN(IRQ3),
	GPIO_FN(QSTVB_QVE),
	GPIO_FN(DU_DOTCLKOUT1),
	GPIO_FN(VI4_DATA3_B),
	GPIO_FN(MSIOF3_SCK_E),
	GPIO_FN(PWM4_B),
	GPIO_IFN(IRQ4),
	GPIO_FN(QSTH_QHS),
	GPIO_FN(DU_EXHSYNC_DU_HSYNC),
	GPIO_FN(VI4_DATA4_B),
	GPIO_FN(MSIOF3_RXD_E),
	GPIO_FN(PWM5_B),
	GPIO_IFN(IRQ5),
	GPIO_FN(QSTB_QHE),
	GPIO_FN(DU_EXVSYNC_DU_VSYNC),
	GPIO_FN(VI4_DATA5_B),
	GPIO_FN(FSCLKST2x_B),
	GPIO_FN(MSIOF3_TXD_E),
	GPIO_FN(PWM6_B),
	GPIO_IFN(PWM0),
	GPIO_FN(AVB_AVTP_PPS),
	GPIO_FN(VI4_DATA6_B),
	GPIO_FN(IECLK_B),
	GPIO_IFN(PWM1_A),
	GPIO_FN(HRX3_D),
	GPIO_FN(VI4_DATA7_B),
	GPIO_FN(IERX_B),
	GPIO_IFN(PWM2_A),
	GPIO_FN(HTX3_D),
	GPIO_FN(IETX_B),
	GPIO_IFN(A0),
	GPIO_FN(LCDOUT16),
	GPIO_FN(MSIOF3_SYNC_B),
	GPIO_FN(VI4_DATA8),
	GPIO_FN(DU_DB0),
	GPIO_FN(PWM3_A),

	/* IPSR2 */
	GPIO_IFN(A1),
	GPIO_FN(LCDOUT17),
	GPIO_FN(MSIOF3_TXD_B),
	GPIO_FN(VI4_DATA9),
	GPIO_FN(DU_DB1),
	GPIO_FN(PWM4_A),
	GPIO_IFN(A2),
	GPIO_FN(LCDOUT18),
	GPIO_FN(MSIOF3_SCK_B),
	GPIO_FN(VI4_DATA10),
	GPIO_FN(DU_DB2),
	GPIO_FN(PWM5_A),
	GPIO_IFN(A3),
	GPIO_FN(LCDOUT19),
	GPIO_FN(MSIOF3_RXD_B),
	GPIO_FN(VI4_DATA11),
	GPIO_FN(DU_DB3),
	GPIO_FN(PWM6_A),
	GPIO_IFN(A4),
	GPIO_FN(LCDOUT20),
	GPIO_FN(MSIOF3_SS1_B),
	GPIO_FN(VI4_DATA12),
	GPIO_FN(VI5_DATA12),
	GPIO_FN(DU_DB4),
	GPIO_IFN(A5),
	GPIO_FN(LCDOUT21),
	GPIO_FN(MSIOF3_SS2_B),
	GPIO_FN(SCK4_B),
	GPIO_FN(VI4_DATA13),
	GPIO_FN(VI5_DATA13),
	GPIO_FN(DU_DB5),
	GPIO_IFN(A6),
	GPIO_FN(LCDOUT22),
	GPIO_FN(MSIOF2_SS1_A),
	GPIO_FN(RX4_B),
	GPIO_FN(VI4_DATA14),
	GPIO_FN(VI5_DATA14),
	GPIO_FN(DU_DB6),
	GPIO_IFN(A7),
	GPIO_FN(LCDOUT23),
	GPIO_FN(MSIOF2_SS2_A),
	GPIO_FN(TX4_B),
	GPIO_FN(VI4_DATA15),
	GPIO_FN(V15_DATA15),
	GPIO_FN(DU_DB7),
	GPIO_IFN(A8),
	GPIO_FN(RX3_B),
	GPIO_FN(MSIOF2_SYNC_A),
	GPIO_FN(HRX4_B),
	GPIO_FN(SDA6_A),
	GPIO_FN(AVB_AVTP_MATCH_B),
	GPIO_FN(PWM1_B),

	/* IPSR3 */
	GPIO_IFN(A9),
	GPIO_FN(MSIOF2_SCK_A),
	GPIO_FN(CTS4x_B),
	GPIO_FN(VI5_VSYNCx),
	GPIO_IFN(A10),
	GPIO_FN(MSIOF2_RXD_A),
	GPIO_FN(RTS4n_TANS_B),
	GPIO_FN(VI5_HSYNCx),
	GPIO_IFN(A11),
	GPIO_FN(TX3_B),
	GPIO_FN(MSIOF2_TXD_A),
	GPIO_FN(HTX4_B),
	GPIO_FN(HSCK4),
	GPIO_FN(VI5_FIELD),
	GPIO_FN(SCL6_A),
	GPIO_FN(AVB_AVTP_CAPTURE_B),
	GPIO_FN(PWM2_B),
	GPIO_IFN(A12),
	GPIO_FN(LCDOUT12),
	GPIO_FN(MSIOF3_SCK_C),
	GPIO_FN(HRX4_A),
	GPIO_FN(VI5_DATA8),
	GPIO_FN(DU_DG4),
	GPIO_IFN(A13),
	GPIO_FN(LCDOUT13),
	GPIO_FN(MSIOF3_SYNC_C),
	GPIO_FN(HTX4_A),
	GPIO_FN(VI5_DATA9),
	GPIO_FN(DU_DG5),
	GPIO_IFN(A14),
	GPIO_FN(LCDOUT14),
	GPIO_FN(MSIOF3_RXD_C),
	GPIO_FN(HCTS4x),
	GPIO_FN(VI5_DATA10),
	GPIO_FN(DU_DG6),
	GPIO_IFN(A15),
	GPIO_FN(LCDOUT15),
	GPIO_FN(MSIOF3_TXD_C),
	GPIO_FN(HRTS4x),
	GPIO_FN(VI5_DATA11),
	GPIO_FN(DU_DG7),
	GPIO_IFN(A16),
	GPIO_FN(LCDOUT8),
	GPIO_FN(VI4_FIELD),
	GPIO_FN(DU_DG0),

	/* IPSR4 */
	GPIO_IFN(A17),
	GPIO_FN(LCDOUT9),
	GPIO_FN(VI4_VSYNCx),
	GPIO_FN(DU_DG1),
	GPIO_IFN(A18),
	GPIO_FN(LCDOUT10),
	GPIO_FN(VI4_HSYNCx),
	GPIO_FN(DU_DG2),
	GPIO_IFN(A19),
	GPIO_FN(LCDOUT11),
	GPIO_FN(VI4_CLKENB),
	GPIO_FN(DU_DG3),
	GPIO_IFN(CS0x),
	GPIO_FN(VI5_CLKENB),
	GPIO_IFN(CS1x_A26),
	GPIO_FN(VI5_CLK),
	GPIO_FN(EX_WAIT0_B),
	GPIO_IFN(BSx),
	GPIO_FN(QSTVA_QVS),
	GPIO_FN(MSIOF3_SCK_D),
	GPIO_FN(SCK3),
	GPIO_FN(HSCK3),
	GPIO_FN(CAN1_TX),
	GPIO_FN(CANFD1_TX),
	GPIO_FN(IETX_A),
	GPIO_IFN(RDx),
	GPIO_FN(MSIOF3_SYNC_D),
	GPIO_FN(RX3_A),
	GPIO_FN(HRX3_A),
	GPIO_FN(CAN0_TX_A),
	GPIO_FN(CANFD0_TX_A),
	GPIO_IFN(RD_WRx),
	GPIO_FN(MSIOF3_RXD_D),
	GPIO_FN(TX3_A),
	GPIO_FN(HTX3_A),
	GPIO_FN(CAN0_RX_A),
	GPIO_FN(CANFD0_RX_A),

	/* IPSR5 */
	GPIO_IFN(WE0x),
	GPIO_FN(MSIIOF3_TXD_D),
	GPIO_FN(CTS3x),
	GPIO_FN(HCTS3x),
	GPIO_FN(SCL6_B),
	GPIO_FN(CAN_CLK),
	GPIO_FN(IECLK_A),
	GPIO_IFN(WE1x),
	GPIO_FN(MSIOF3_SS1_D),
	GPIO_FN(RTS3x_TANS),
	GPIO_FN(HRTS3x),
	GPIO_FN(SDA6_B),
	GPIO_FN(CAN1_RX),
	GPIO_FN(CANFD1_RX),
	GPIO_FN(IERX_A),
	GPIO_IFN(EX_WAIT0_A),
	GPIO_FN(QCLK),
	GPIO_FN(VI4_CLK),
	GPIO_FN(DU_DOTCLKOUT0),
	GPIO_IFN(D0),
	GPIO_FN(MSIOF2_SS1_B),
	GPIO_FN(MSIOF3_SCK_A),
	GPIO_FN(VI4_DATA16),
	GPIO_FN(VI5_DATA0),
	GPIO_IFN(D1),
	GPIO_FN(MSIOF2_SS2_B),
	GPIO_FN(MSIOF3_SYNC_A),
	GPIO_FN(VI4_DATA17),
	GPIO_FN(VI5_DATA1),
	GPIO_IFN(D2),
	GPIO_FN(MSIOF3_RXD_A),
	GPIO_FN(VI4_DATA18),
	GPIO_FN(VI5_DATA2),
	GPIO_IFN(D3),
	GPIO_FN(MSIOF3_TXD_A),
	GPIO_FN(VI4_DATA19),
	GPIO_FN(VI5_DATA3),
	GPIO_IFN(D4),
	GPIO_FN(MSIOF2_SCK_B),
	GPIO_FN(VI4_DATA20),
	GPIO_FN(VI5_DATA4),

	/* IPSR6 */
	GPIO_IFN(D5),
	GPIO_FN(MSIOF2_SYNC_B),
	GPIO_FN(VI4_DATA21),
	GPIO_FN(VI5_DATA5),
	GPIO_IFN(D6),
	GPIO_FN(MSIOF2_RXD_B),
	GPIO_FN(VI4_DATA22),
	GPIO_FN(VI5_DATA6),
	GPIO_IFN(D7),
	GPIO_FN(MSIOF2_TXD_B),
	GPIO_FN(VI4_DATA23),
	GPIO_FN(VI5_DATA7),
	GPIO_IFN(D8),
	GPIO_FN(LCDOUT0),
	GPIO_FN(MSIOF2_SCK_D),
	GPIO_FN(SCK4_C),
	GPIO_FN(VI4_DATA0_A),
	GPIO_FN(DU_DR0),
	GPIO_IFN(D9),
	GPIO_FN(LCDOUT1),
	GPIO_FN(MSIOF2_SYNC_D),
	GPIO_FN(VI4_DATA1_A),
	GPIO_FN(DU_DR1),
	GPIO_IFN(D10),
	GPIO_FN(LCDOUT2),
	GPIO_FN(MSIOF2_RXD_D),
	GPIO_FN(HRX3_B),
	GPIO_FN(VI4_DATA2_A),
	GPIO_FN(CTS4x_C),
	GPIO_FN(DU_DR2),
	GPIO_IFN(D11),
	GPIO_FN(LCDOUT3),
	GPIO_FN(MSIOF2_TXD_D),
	GPIO_FN(HTX3_B),
	GPIO_FN(VI4_DATA3_A),
	GPIO_FN(RTS4x_TANS_C),
	GPIO_FN(DU_DR3),
	GPIO_IFN(D12),
	GPIO_FN(LCDOUT4),
	GPIO_FN(MSIOF2_SS1_D),
	GPIO_FN(RX4_C),
	GPIO_FN(VI4_DATA4_A),
	GPIO_FN(DU_DR4),

	/* IPSR7 */
	GPIO_IFN(D13),
	GPIO_FN(LCDOUT5),
	GPIO_FN(MSIOF2_SS2_D),
	GPIO_FN(TX4_C),
	GPIO_FN(VI4_DATA5_A),
	GPIO_FN(DU_DR5),
	GPIO_IFN(D14),
	GPIO_FN(LCDOUT6),
	GPIO_FN(MSIOF3_SS1_A),
	GPIO_FN(HRX3_C),
	GPIO_FN(VI4_DATA6_A),
	GPIO_FN(DU_DR6),
	GPIO_FN(SCL6_C),
	GPIO_IFN(D15),
	GPIO_FN(LCDOUT7),
	GPIO_FN(MSIOF3_SS2_A),
	GPIO_FN(HTX3_C),
	GPIO_FN(VI4_DATA7_A),
	GPIO_FN(DU_DR7),
	GPIO_FN(SDA6_C),
	GPIO_FN(FSCLKST),
	GPIO_IFN(SD0_CLK),
	GPIO_FN(MSIOF1_SCK_E),
	GPIO_FN(STP_OPWM_0_B),
	GPIO_IFN(SD0_CMD),
	GPIO_FN(MSIOF1_SYNC_E),
	GPIO_FN(STP_IVCXO27_0_B),
	GPIO_IFN(SD0_DAT0),
	GPIO_FN(MSIOF1_RXD_E),
	GPIO_FN(TS_SCK0_B),
	GPIO_FN(STP_ISCLK_0_B),
	GPIO_IFN(SD0_DAT1),
	GPIO_FN(MSIOF1_TXD_E),
	GPIO_FN(TS_SPSYNC0_B),
	GPIO_FN(STP_ISSYNC_0_B),

	/* IPSR8 */
	GPIO_IFN(SD0_DAT2),
	GPIO_FN(MSIOF1_SS1_E),
	GPIO_FN(TS_SDAT0_B),
	GPIO_FN(STP_ISD_0_B),
	GPIO_IFN(SD0_DAT3),
	GPIO_FN(MSIOF1_SS2_E),
	GPIO_FN(TS_SDEN0_B),
	GPIO_FN(STP_ISEN_0_B),
	GPIO_IFN(SD1_CLK),
	GPIO_FN(MSIOF1_SCK_G),
	GPIO_FN(SIM0_CLK_A),
	GPIO_IFN(SD1_CMD),
	GPIO_FN(MSIOF1_SYNC_G),
	GPIO_FN(NFCEx_B),
	GPIO_FN(SIM0_D_A),
	GPIO_FN(STP_IVCXO27_1_B),
	GPIO_IFN(SD1_DAT0),
	GPIO_FN(SD2_DAT4),
	GPIO_FN(MSIOF1_RXD_G),
	GPIO_FN(NFWPx_B),
	GPIO_FN(TS_SCK1_B),
	GPIO_FN(STP_ISCLK_1_B),
	GPIO_IFN(SD1_DAT1),
	GPIO_FN(SD2_DAT5),
	GPIO_FN(MSIOF1_TXD_G),
	GPIO_FN(NFDATA14_B),
	GPIO_FN(TS_SPSYNC1_B),
	GPIO_FN(STP_ISSYNC_1_B),
	GPIO_IFN(SD1_DAT2),
	GPIO_FN(SD2_DAT6),
	GPIO_FN(MSIOF1_SS1_G),
	GPIO_FN(NFDATA15_B),
	GPIO_FN(TS_SDAT1_B),
	GPIO_FN(STP_IOD_1_B),
	GPIO_IFN(SD1_DAT3),
	GPIO_FN(SD2_DAT7),
	GPIO_FN(MSIOF1_SS2_G),
	GPIO_FN(NFRBx_B),
	GPIO_FN(TS_SDEN1_B),
	GPIO_FN(STP_ISEN_1_B),

	/* IPSR9 */
	GPIO_IFN(SD2_CLK),
	GPIO_FN(NFDATA8),
	GPIO_IFN(SD2_CMD),
	GPIO_FN(NFDATA9),
	GPIO_IFN(SD2_DAT0),
	GPIO_FN(NFDATA10),
	GPIO_IFN(SD2_DAT1),
	GPIO_FN(NFDATA11),
	GPIO_IFN(SD2_DAT2),
	GPIO_FN(NFDATA12),
	GPIO_IFN(SD2_DAT3),
	GPIO_FN(NFDATA13),
	GPIO_IFN(SD2_DS),
	GPIO_FN(NFALE),
	GPIO_FN(SATA_DEVSLP_B),
	GPIO_IFN(SD3_CLK),
	GPIO_FN(NFWEx),

	/* IPSR10 */
	GPIO_IFN(SD3_CMD),
	GPIO_FN(NFREx),
	GPIO_IFN(SD3_DAT0),
	GPIO_FN(NFDATA0),
	GPIO_IFN(SD3_DAT1),
	GPIO_FN(NFDATA1),
	GPIO_IFN(SD3_DAT2),
	GPIO_FN(NFDATA2),
	GPIO_IFN(SD3_DAT3),
	GPIO_FN(NFDATA3),
	GPIO_IFN(SD3_DAT4),
	GPIO_FN(SD2_CD_A),
	GPIO_FN(NFDATA4),
	GPIO_IFN(SD3_DAT5),
	GPIO_FN(SD2_WP_A),
	GPIO_FN(NFDATA5),
	GPIO_IFN(SD3_DAT6),
	GPIO_FN(SD3_CD),
	GPIO_FN(NFDATA6),

	/* IPSR11 */
	GPIO_IFN(SD3_DAT7),
	GPIO_FN(SD3_WP),
	GPIO_FN(NFDATA7),
	GPIO_IFN(SD3_DS),
	GPIO_FN(NFCLE),
	GPIO_IFN(SD0_CD),
	GPIO_FN(NFDATA14_A),
	GPIO_FN(SCL2_B),
	GPIO_FN(SIM0_RST_A),
	GPIO_IFN(SD0_WP),
	GPIO_FN(NFDATA15_A),
	GPIO_FN(SDA2_B),
	GPIO_IFN(SD1_CD),
	GPIO_FN(NFRBx_A),
	GPIO_FN(SIM0_CLK_B),
	GPIO_IFN(SD1_WP),
	GPIO_FN(NFCEx_A),
	GPIO_FN(SIM0_D_B),
	GPIO_IFN(SCK0),
	GPIO_FN(HSCK1_B),
	GPIO_FN(MSIOF1_SS2_B),
	GPIO_FN(AUDIO_CLKC_B),
	GPIO_FN(SDA2_A),
	GPIO_FN(SIM0_RST_B),
	GPIO_FN(STP_OPWM_0_C),
	GPIO_FN(RIF0_CLK_B),
	GPIO_FN(ADICHS2),
	GPIO_FN(SCK5_B),
	GPIO_IFN(RX0),
	GPIO_FN(HRX1_B),
	GPIO_FN(TS_SCK0_C),
	GPIO_FN(STP_ISCLK_0_C),
	GPIO_FN(RIF0_D0_B),

	/* IPSR12 */
	GPIO_IFN(TX0),
	GPIO_FN(HTX1_B),
	GPIO_FN(TS_SPSYNC0_C),
	GPIO_FN(STP_ISSYNC_0_C),
	GPIO_FN(RIF0_D1_B),
	GPIO_IFN(CTS0x),
	GPIO_FN(HCTS1x_B),
	GPIO_FN(MSIOF1_SYNC_B),
	GPIO_FN(TS_SPSYNC1_C),
	GPIO_FN(STP_ISSYNC_1_C),
	GPIO_FN(RIF1_SYNC_B),
	GPIO_FN(AUDIO_CLKOUT_C),
	GPIO_FN(ADICS_SAMP),
	GPIO_IFN(RTS0x_TANS),
	GPIO_FN(HRTS1x_B),
	GPIO_FN(MSIOF1_SS1_B),
	GPIO_FN(AUDIO_CLKA_B),
	GPIO_FN(SCL2_A),
	GPIO_FN(STP_IVCXO27_1_C),
	GPIO_FN(RIF0_SYNC_B),
	GPIO_FN(ADICHS1),
	GPIO_IFN(RX1_A),
	GPIO_FN(HRX1_A),
	GPIO_FN(TS_SDAT0_C),
	GPIO_FN(STP_ISD_0_C),
	GPIO_FN(RIF1_CLK_C),
	GPIO_IFN(TX1_A),
	GPIO_FN(HTX1_A),
	GPIO_FN(TS_SDEN0_C),
	GPIO_FN(STP_ISEN_0_C),
	GPIO_FN(RIF1_D0_C),
	GPIO_IFN(CTS1x),
	GPIO_FN(HCTS1x_A),
	GPIO_FN(MSIOF1_RXD_B),
	GPIO_FN(TS_SDEN1_C),
	GPIO_FN(STP_ISEN_1_C),
	GPIO_FN(RIF1_D0_B),
	GPIO_FN(ADIDATA),
	GPIO_IFN(RTS1x_TANS),
	GPIO_FN(HRTS1x_A),
	GPIO_FN(MSIOF1_TXD_B),
	GPIO_FN(TS_SDAT1_C),
	GPIO_FN(STP_ISD_1_C),
	GPIO_FN(RIF1_D1_B),
	GPIO_FN(ADICHS0),
	GPIO_IFN(SCK2),
	GPIO_FN(SCIF_CLK_B),
	GPIO_FN(MSIOF1_SCK_B),
	GPIO_FN(TS_SCK1_C),
	GPIO_FN(STP_ISCLK_1_C),
	GPIO_FN(RIF1_CLK_B),
	GPIO_FN(ADICLK),

	/* IPSR13 */
	GPIO_IFN(TX2_A),
	GPIO_FN(SD2_CD_B),
	GPIO_FN(SCL1_A),
	GPIO_FN(FMCLK_A),
	GPIO_FN(RIF1_D1_C),
	GPIO_FN(FSO_CFE_0x),
	GPIO_IFN(RX2_A),
	GPIO_FN(SD2_WP_B),
	GPIO_FN(SDA1_A),
	GPIO_FN(FMIN_A),
	GPIO_FN(RIF1_SYNC_C),
	GPIO_FN(FSO_CFE_1x),
	GPIO_IFN(HSCK0),
	GPIO_FN(MSIOF1_SCK_D),
	GPIO_FN(AUDIO_CLKB_A),
	GPIO_FN(SSI_SDATA1_B),
	GPIO_FN(TS_SCK0_D),
	GPIO_FN(STP_ISCLK_0_D),
	GPIO_FN(RIF0_CLK_C),
	GPIO_FN(RX5_B),
	GPIO_IFN(HRX0),
	GPIO_FN(MSIOF1_RXD_D),
	GPIO_FN(SSI_SDATA2_B),
	GPIO_FN(TS_SDEN0_D),
	GPIO_FN(STP_ISEN_0_D),
	GPIO_FN(RIF0_D0_C),
	GPIO_IFN(HTX0),
	GPIO_FN(MSIOF1_TXD_D),
	GPIO_FN(SSI_SDATA9_B),
	GPIO_FN(TS_SDAT0_D),
	GPIO_FN(STP_ISD_0_D),
	GPIO_FN(RIF0_D1_C),
	GPIO_IFN(HCTS0x),
	GPIO_FN(RX2_B),
	GPIO_FN(MSIOF1_SYNC_D),
	GPIO_FN(SSI_SCK9_A),
	GPIO_FN(TS_SPSYNC0_D),
	GPIO_FN(STP_ISSYNC_0_D),
	GPIO_FN(RIF0_SYNC_C),
	GPIO_FN(AUDIO_CLKOUT1_A),
	GPIO_IFN(HRTS0x),
	GPIO_FN(TX2_B),
	GPIO_FN(MSIOF1_SS1_D),
	GPIO_FN(SSI_WS9_A),
	GPIO_FN(STP_IVCXO27_0_D),
	GPIO_FN(BPFCLK_A),
	GPIO_FN(AUDIO_CLKOUT2_A),
	GPIO_IFN(MSIOF0_SYNC),
	GPIO_FN(AUDIO_CLKOUT_A),
	GPIO_FN(TX5_B),
	GPIO_FN(BPFCLK_D),

	/* IPSR14 */
	GPIO_IFN(MSIOF0_SS1),
	GPIO_FN(RX5_A),
	GPIO_FN(NFWPx_A),
	GPIO_FN(AUDIO_CLKA_C),
	GPIO_FN(SSI_SCK2_A),
	GPIO_FN(STP_IVCXO27_0_C),
	GPIO_FN(AUDIO_CLKOUT3_A),
	GPIO_FN(TCLK1_B),
	GPIO_IFN(MSIOF0_SS2),
	GPIO_FN(TX5_A),
	GPIO_FN(MSIOF1_SS2_D),
	GPIO_FN(AUDIO_CLKC_A),
	GPIO_FN(SSI_WS2_A),
	GPIO_FN(STP_OPWM_0_D),
	GPIO_FN(AUDIO_CLKOUT_D),
	GPIO_FN(SPEEDIN_B),
	GPIO_IFN(MLB_CLK),
	GPIO_FN(MSIOF1_SCK_F),
	GPIO_FN(SCL1_B),
	GPIO_IFN(MLB_SIG),
	GPIO_FN(RX1_B),
	GPIO_FN(MSIOF1_SYNC_F),
	GPIO_FN(SDA1_B),
	GPIO_IFN(MLB_DAT),
	GPIO_FN(TX1_B),
	GPIO_FN(MSIOF1_RXD_F),
	GPIO_IFN(SSI_SCK01239),
	GPIO_FN(MSIOF1_TXD_F),
	GPIO_FN(MOUT0),
	GPIO_IFN(SSI_WS01239),
	GPIO_FN(MSIOF1_SS1_F),
	GPIO_FN(MOUT1),
	GPIO_IFN(SSI_SDATA0),
	GPIO_FN(MSIOF1_SS2_F),
	GPIO_FN(MOUT2),

	/* IPSR15 */
	GPIO_IFN(SSI_SDATA1_A),
	GPIO_FN(MOUT5),
	GPIO_IFN(SSI_SDATA2_A),
	GPIO_FN(SSI_SCK1_B),
	GPIO_FN(MOUT6),
	GPIO_IFN(SSI_SCK34),
	GPIO_FN(MSIOF1_SS1_A),
	GPIO_FN(STP_OPWM_0_A),
	GPIO_IFN(SSI_WS34),
	GPIO_FN(HCTS2x_A),
	GPIO_FN(MSIOF1_SS2_A),
	GPIO_FN(STP_IVCXO27_0_A),
	GPIO_IFN(SSI_SDATA3),
	GPIO_FN(HRTS2x_A),
	GPIO_FN(MSIOF1_TXD_A),
	GPIO_FN(TS_SCK0_A),
	GPIO_FN(STP_ISCLK_0_A),
	GPIO_FN(RIF0_D1_A),
	GPIO_FN(RIF2_D0_A),
	GPIO_IFN(SSI_SCK4),
	GPIO_FN(HRX2_A),
	GPIO_FN(MSIOF1_SCK_A),
	GPIO_FN(TS_SDAT0_A),
	GPIO_FN(STP_ISD_0_A),
	GPIO_FN(RIF0_CLK_A),
	GPIO_FN(RIF2_CLK_A),
	GPIO_IFN(SSI_WS4),
	GPIO_FN(HTX2_A),
	GPIO_FN(MSIOF1_SYNC_A),
	GPIO_FN(TS_SDEN0_A),
	GPIO_FN(STP_ISEN_0_A),
	GPIO_FN(RIF0_SYNC_A),
	GPIO_FN(RIF2_SYNC_A),
	GPIO_IFN(SSI_SDATA4),
	GPIO_FN(HSCK2_A),
	GPIO_FN(MSIOF1_RXD_A),
	GPIO_FN(TS_SPSYNC0_A),
	GPIO_FN(STP_ISSYNC_0_A),
	GPIO_FN(RIF0_D0_A),
	GPIO_FN(RIF2_D1_A),

	/* IPSR16 */
	GPIO_IFN(SSI_SCK6),
	GPIO_FN(SIM0_RST_D),
	GPIO_IFN(SSI_WS6),
	GPIO_FN(SIM0_D_D),
	GPIO_IFN(SSI_SDATA6),
	GPIO_FN(SIM0_CLK_D),
	GPIO_FN(SATA_DEVSLP_A),
	GPIO_IFN(SSI_SCK78),
	GPIO_FN(HRX2_B),
	GPIO_FN(MSIOF1_SCK_C),
	GPIO_FN(TS_SCK1_A),
	GPIO_FN(STP_ISCLK_1_A),
	GPIO_FN(RIF1_CLK_A),
	GPIO_FN(RIF3_CLK_A),
	GPIO_IFN(SSI_WS78),
	GPIO_FN(HTX2_B),
	GPIO_FN(MSIOF1_SYNC_C),
	GPIO_FN(TS_SDAT1_A),
	GPIO_FN(STP_ISD_1_A),
	GPIO_FN(RIF1_SYNC_A),
	GPIO_FN(RIF3_SYNC_A),
	GPIO_IFN(SSI_SDATA7),
	GPIO_FN(HCTS2x_B),
	GPIO_FN(MSIOF1_RXD_C),
	GPIO_FN(TS_SDEN1_A),
	GPIO_FN(STP_ISEN_1_A),
	GPIO_FN(RIF1_D0_A),
	GPIO_FN(RIF3_D0_A),
	GPIO_FN(TCLK2_A),
	GPIO_IFN(SSI_SDATA8),
	GPIO_FN(HRTS2x_B),
	GPIO_FN(MSIOF1_TXD_C),
	GPIO_FN(TS_SPSYNC1_A),
	GPIO_FN(STP_ISSYNC_1_A),
	GPIO_FN(RIF1_D1_A),
	GPIO_FN(RIF3_D1_A),
	GPIO_IFN(SSI_SDATA9_A),
	GPIO_FN(HSCK2_B),
	GPIO_FN(MSIOF1_SS1_C),
	GPIO_FN(HSCK1_A),
	GPIO_FN(SSI_WS1_B),
	GPIO_FN(SCK1),
	GPIO_FN(STP_IVCXO27_1_A),
	GPIO_FN(SCK5_A),

	/* IPSR17 */
	GPIO_IFN(AUDIO_CLKA_A),
	GPIO_FN(CC5_OSCOUT),
	GPIO_IFN(AUDIO_CLKB_B),
	GPIO_FN(SCIF_CLK_A),
	GPIO_FN(STP_IVCXO27_1_D),
	GPIO_FN(REMOCON_A),
	GPIO_FN(TCLK1_A),
	GPIO_IFN(USB0_PWEN),
	GPIO_FN(SIM0_RST_C),
	GPIO_FN(TS_SCK1_D),
	GPIO_FN(STP_ISCLK_1_D),
	GPIO_FN(BPFCLK_B),
	GPIO_FN(RIF3_CLK_B),
	GPIO_FN(HSCK2_C),
	GPIO_IFN(USB0_OVC),
	GPIO_FN(SIM0_D_C),
	GPIO_FN(TS_SDAT1_D),
	GPIO_FN(STP_ISD_1_D),
	GPIO_FN(RIF3_SYNC_B),
	GPIO_FN(HRX2_C),
	GPIO_IFN(USB1_PWEN),
	GPIO_FN(SIM0_CLK_C),
	GPIO_FN(SSI_SCK1_A),
	GPIO_FN(TS_SCK0_E),
	GPIO_FN(STP_ISCLK_0_E),
	GPIO_FN(FMCLK_B),
	GPIO_FN(RIF2_CLK_B),
	GPIO_FN(SPEEDIN_A),
	GPIO_FN(HTX2_C),
	GPIO_IFN(USB1_OVC),
	GPIO_FN(MSIOF1_SS2_C),
	GPIO_FN(SSI_WS1_A),
	GPIO_FN(TS_SDAT0_E),
	GPIO_FN(STP_ISD_0_E),
	GPIO_FN(FMIN_B),
	GPIO_FN(RIF2_SYNC_B),
	GPIO_FN(REMOCON_B),
	GPIO_FN(HCTS2x_C),
	GPIO_IFN(USB30_PWEN),
	GPIO_FN(AUDIO_CLKOUT_B),
	GPIO_FN(SSI_SCK2_B),
	GPIO_FN(TS_SDEN1_D),
	GPIO_FN(STP_ISEN_1_D),
	GPIO_FN(STP_OPWM_0_E),
	GPIO_FN(RIF3_D0_B),
	GPIO_FN(TCLK2_B),
	GPIO_FN(TPU0TO0),
	GPIO_FN(BPFCLK_C),
	GPIO_FN(HRTS2x_C),
	GPIO_IFN(USB30_OVC),
	GPIO_FN(AUDIO_CLKOUT1_B),
	GPIO_FN(SSI_WS2_B),
	GPIO_FN(TS_SPSYNC1_D),
	GPIO_FN(STP_ISSYNC_1_D),
	GPIO_FN(STP_IVCXO27_0_E),
	GPIO_FN(RIF3_D1_B),
	GPIO_FN(FSO_TOEx),
	GPIO_FN(TPU0TO1),
};

static struct pinmux_cfg_reg pinmux_config_regs[] = {
	/* GPSR0(0xE6060100) md[3:1] controls initial value */
	/*   md[3:1] .. 0     : 0x0000FFFF                  */
	/*           .. other : 0x00000000                  */
	{ PINMUX_CFG_REG("GPSR0", 0xE6060100, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,

		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,

		GP_0_15_FN, GFN_D15,
		GP_0_14_FN, GFN_D14,
		GP_0_13_FN, GFN_D13,
		GP_0_12_FN, GFN_D12,
		GP_0_11_FN, GFN_D11,
		GP_0_10_FN, GFN_D10,
		GP_0_9_FN, GFN_D9,
		GP_0_8_FN, GFN_D8,
		GP_0_7_FN, GFN_D7,
		GP_0_6_FN, GFN_D6,
		GP_0_5_FN, GFN_D5,
		GP_0_4_FN, GFN_D4,
		GP_0_3_FN, GFN_D3,
		GP_0_2_FN, GFN_D2,
		GP_0_1_FN, GFN_D1,
		GP_0_0_FN, GFN_D0 }
	},
	/* GPSR1(0xE6060104) is md[3:1] controls initial value */
	/*   md[3:1] .. 0     : 0x0EFFFFFF                     */
	/*           .. other : 0x00000000                     */
	{ PINMUX_CFG_REG("GPSR1", 0xE6060104, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		GP_1_28_FN, GFN_CLKOUT,
		GP_1_27_FN, GFN_EX_WAIT0_A,
		GP_1_26_FN, GFN_WE1x,
		GP_1_25_FN, GFN_WE0x,
		GP_1_24_FN, GFN_RD_WRx,
		GP_1_23_FN, GFN_RDx,
		GP_1_22_FN, GFN_BSx,
		GP_1_21_FN, GFN_CS1x_A26,
		GP_1_20_FN, GFN_CS0x,
		GP_1_19_FN, GFN_A19,
		GP_1_18_FN, GFN_A18,
		GP_1_17_FN, GFN_A17,
		GP_1_16_FN, GFN_A16,
		GP_1_15_FN, GFN_A15,
		GP_1_14_FN, GFN_A14,
		GP_1_13_FN, GFN_A13,
		GP_1_12_FN, GFN_A12,
		GP_1_11_FN, GFN_A11,
		GP_1_10_FN, GFN_A10,
		GP_1_9_FN, GFN_A9,
		GP_1_8_FN, GFN_A8,
		GP_1_7_FN, GFN_A7,
		GP_1_6_FN, GFN_A6,
		GP_1_5_FN, GFN_A5,
		GP_1_4_FN, GFN_A4,
		GP_1_3_FN, GFN_A3,
		GP_1_2_FN, GFN_A2,
		GP_1_1_FN, GFN_A1,
		GP_1_0_FN, GFN_A0 }
	},
	/* GPSR2(0xE6060108) is md[3:1] controls               */
	/*   md[3:1] .. 0     : 0x000003C0                     */
	/*           .. other : 0x00000200                     */
	{ PINMUX_CFG_REG("GPSR2", 0xE6060108, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,

		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,

		0, 0,
		GP_2_14_FN, GFN_AVB_AVTP_CAPTURE_A,
		GP_2_13_FN, GFN_AVB_AVTP_MATCH_A,
		GP_2_12_FN, GFN_AVB_LINK,
		GP_2_11_FN, GFN_AVB_PHY_INT,
		GP_2_10_FN, GFN_AVB_MAGIC,
		GP_2_9_FN, GFN_AVB_MDC,
		GP_2_8_FN, GFN_PWM2_A,
		GP_2_7_FN, GFN_PWM1_A,
		GP_2_6_FN, GFN_PWM0,
		GP_2_5_FN, GFN_IRQ5,
		GP_2_4_FN, GFN_IRQ4,
		GP_2_3_FN, GFN_IRQ3,
		GP_2_2_FN, GFN_IRQ2,
		GP_2_1_FN, GFN_IRQ1,
		GP_2_0_FN, GFN_IRQ0 }
	},

	/* GPSR3 */
	{ PINMUX_CFG_REG("GPSR3", 0xE606010C, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,

		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,

		GP_3_15_FN, GFN_SD1_WP,
		GP_3_14_FN, GFN_SD1_CD,
		GP_3_13_FN, GFN_SD0_WP,
		GP_3_12_FN, GFN_SD0_CD,
		GP_3_11_FN, GFN_SD1_DAT3,
		GP_3_10_FN, GFN_SD1_DAT2,
		GP_3_9_FN, GFN_SD1_DAT1,
		GP_3_8_FN, GFN_SD1_DAT0,
		GP_3_7_FN, GFN_SD1_CMD,
		GP_3_6_FN, GFN_SD1_CLK,
		GP_3_5_FN, GFN_SD0_DAT3,
		GP_3_4_FN, GFN_SD0_DAT2,
		GP_3_3_FN, GFN_SD0_DAT1,
		GP_3_2_FN, GFN_SD0_DAT0,
		GP_3_1_FN, GFN_SD0_CMD,
		GP_3_0_FN, GFN_SD0_CLK }
	},
	/* GPSR4 */
	{ PINMUX_CFG_REG("GPSR4", 0xE6060110, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,

		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_4_17_FN, GFN_SD3_DS,
		GP_4_16_FN, GFN_SD3_DAT7,

		GP_4_15_FN, GFN_SD3_DAT6,
		GP_4_14_FN, GFN_SD3_DAT5,
		GP_4_13_FN, GFN_SD3_DAT4,
		GP_4_12_FN, GFN_SD3_DAT3,
		GP_4_11_FN, GFN_SD3_DAT2,
		GP_4_10_FN, GFN_SD3_DAT1,
		GP_4_9_FN, GFN_SD3_DAT0,
		GP_4_8_FN, GFN_SD3_CMD,
		GP_4_7_FN, GFN_SD3_CLK,
		GP_4_6_FN, GFN_SD2_DS,
		GP_4_5_FN, GFN_SD2_DAT3,
		GP_4_4_FN, GFN_SD2_DAT2,
		GP_4_3_FN, GFN_SD2_DAT1,
		GP_4_2_FN, GFN_SD2_DAT0,
		GP_4_1_FN, GFN_SD2_CMD,
		GP_4_0_FN, GFN_SD2_CLK }
	},
	/* GPSR5 */
	{ PINMUX_CFG_REG("GPSR5", 0xE6060114, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_5_25_FN, GFN_MLB_DAT,
		GP_5_24_FN, GFN_MLB_SIG,
		GP_5_23_FN, GFN_MLB_CLK,
		GP_5_22_FN, FN_MSIOF0_RXD,
		GP_5_21_FN, GFN_MSIOF0_SS2,
		GP_5_20_FN, FN_MSIOF0_TXD,
		GP_5_19_FN, GFN_MSIOF0_SS1,
		GP_5_18_FN, GFN_MSIOF0_SYNC,
		GP_5_17_FN, FN_MSIOF0_SCK,
		GP_5_16_FN, GFN_HRTS0x,
		GP_5_15_FN, GFN_HCTS0x,
		GP_5_14_FN, GFN_HTX0,
		GP_5_13_FN, GFN_HRX0,
		GP_5_12_FN, GFN_HSCK0,
		GP_5_11_FN, GFN_RX2_A,
		GP_5_10_FN, GFN_TX2_A,
		GP_5_9_FN, GFN_SCK2,
		GP_5_8_FN, GFN_RTS1x_TANS,
		GP_5_7_FN, GFN_CTS1x,
		GP_5_6_FN, GFN_TX1_A,
		GP_5_5_FN, GFN_RX1_A,
		GP_5_4_FN, GFN_RTS0x_TANS,
		GP_5_3_FN, GFN_CTS0x,
		GP_5_2_FN, GFN_TX0,
		GP_5_1_FN, GFN_RX0,
		GP_5_0_FN, GFN_SCK0 }
	},
	/* GPSR6 */
	{ PINMUX_CFG_REG("GPSR6", 0xE6060118, 32, 1) {
		GP_6_31_FN, GFN_USB3_OVC,
		GP_6_30_FN, GFN_USB3_PWEN,
		GP_6_29_FN, GFN_USB30_OVC,
		GP_6_28_FN, GFN_USB30_PWEN,
		GP_6_27_FN, GFN_USB1_OVC,
		GP_6_26_FN, GFN_USB1_PWEN,
		GP_6_25_FN, GFN_USB0_OVC,
		GP_6_24_FN, GFN_USB0_PWEN,
		GP_6_23_FN, GFN_AUDIO_CLKB_B,
		GP_6_22_FN, GFN_AUDIO_CLKA_A,
		GP_6_21_FN, GFN_SSI_SDATA9_A,
		GP_6_20_FN, GFN_SSI_SDATA8,
		GP_6_19_FN, GFN_SSI_SDATA7,
		GP_6_18_FN, GFN_SSI_WS78,
		GP_6_17_FN, GFN_SSI_SCK78,
		GP_6_16_FN, GFN_SSI_SDATA6,
		GP_6_15_FN, GFN_SSI_WS6,
		GP_6_14_FN, GFN_SSI_SCK6,
		GP_6_13_FN, FN_SSI_SDATA5,
		GP_6_12_FN, FN_SSI_WS5,
		GP_6_11_FN, FN_SSI_SCK5,
		GP_6_10_FN, GFN_SSI_SDATA4,
		GP_6_9_FN, GFN_SSI_WS4,
		GP_6_8_FN, GFN_SSI_SCK4,
		GP_6_7_FN, GFN_SSI_SDATA3,
		GP_6_6_FN, GFN_SSI_WS34,
		GP_6_5_FN, GFN_SSI_SCK34,
		GP_6_4_FN, GFN_SSI_SDATA2_A,
		GP_6_3_FN, GFN_SSI_SDATA1_A,
		GP_6_2_FN, GFN_SSI_SDATA0,
		GP_6_1_FN, GFN_SSI_WS01239,
		GP_6_0_FN, GFN_SSI_SCK01239 }
	},
	/* GPSR7 */
	{ PINMUX_CFG_REG("GPSR7", 0xE606011C, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,

		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,

		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,

		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_7_3_FN, FN_HDMI1_CEC,
		GP_7_2_FN, FN_HDMI0_CEC,
		GP_7_1_FN, FN_AVS2,
		GP_7_0_FN, FN_AVS1 }
	},
	{ PINMUX_CFG_REG_VAR("IPSR0", 0xE6060200, 32,
				4, 4, 4, 4, 4, 4, 4, 4) {
		/* IPSR0_31_28 [4] */
		IFN_IRQ1, FN_QPOLA, 0, FN_DU_DISP,
		FN_VI4_DATA1_B, FN_CAN0_RX_B, FN_CANFD0_RX_B, FN_MSIOF3_SS1_E,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR0_27_24 [4] */
		IFN_IRQ0, FN_QPOLB, 0, FN_DU_CDE,
		FN_VI4_DATA0_B, FN_CAN0_TX_B, FN_CANFD0_TX_B, FN_MSIOF3_SS2_E,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR0_23_20 [4] */
		IFN_AVB_AVTP_CAPTURE_A, 0, FN_MSIOF2_TXD_C, FN_RTS4x_TANS_A,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR0_19_16 [4] */
		IFN_AVB_AVTP_MATCH_A, 0, FN_MSIOF2_RXD_C, FN_CTS4x_A,
		0, FN_FSCLKST2x_A, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR0_15_12 [4] */
		IFN_AVB_LINK, 0, FN_MSIOF2_SCK_C, FN_TX4_A,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR0_11_8 [4] */
		IFN_AVB_PHY_INT, 0, FN_MSIOF2_SYNC_C, FN_RX4_A,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR0_7_4 [4] */
		IFN_AVB_MAGIC, 0, FN_MSIOF2_SS1_C, FN_SCK4_A,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR0_3_0 [4] */
		IFN_AVB_MDC, 0, FN_MSIOF2_SS2_C, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		}
	},
	{ PINMUX_CFG_REG_VAR("IPSR1", 0xE6060204, 32,
				4, 4, 4, 4, 4, 4, 4, 4) {
		/* IPSR1_31_28 [4] */
		IFN_A0, FN_LCDOUT16, FN_MSIOF3_SYNC_B, 0,
		FN_VI4_DATA8, 0, FN_DU_DB0, 0,
		0, FN_PWM3_A, 0, 0,
		0, 0, 0, 0,
		/* IPSR1_27_24 [4] */
		IFN_PWM2_A, 0, 0, FN_HTX3_D,
		0, 0, 0, 0,
		0, FN_IETX_B, 0, 0,
		0, 0, 0, 0,
		/* IPSR1_23_20 [4] */
		IFN_PWM1_A, 0, 0, FN_HRX3_D,
		FN_VI4_DATA7_B, 0, 0, 0,
		0, FN_IERX_B, 0, 0,
		0, 0, 0, 0,
		/* IPSR1_19_16 [4] */
		IFN_PWM0, FN_AVB_AVTP_PPS, 0, 0,
		FN_VI4_DATA6_B, 0, 0, 0,
		0, FN_IECLK_B, 0, 0,
		0, 0, 0, 0,
		/* IPSR1_15_12 [4] */
		IFN_IRQ5, FN_QSTB_QHE, 0, FN_DU_EXVSYNC_DU_VSYNC,
		FN_VI4_DATA5_B, FN_FSCLKST2x_B, 0, FN_MSIOF3_TXD_E,
		0, FN_PWM6_B, 0, 0,
		0, 0, 0, 0,
		/* IPSR1_11_8 [4] */
		IFN_IRQ4, FN_QSTH_QHS, 0, FN_DU_EXHSYNC_DU_HSYNC,
		FN_VI4_DATA4_B, 0, 0, FN_MSIOF3_RXD_E,
		0, FN_PWM5_B, 0, 0,
		0, 0, 0, 0,
		/* IPSR1_7_4 [4] */
		IFN_IRQ3, FN_QSTVB_QVE, 0, FN_DU_DOTCLKOUT1,
		FN_VI4_DATA3_B, 0, 0, FN_MSIOF3_SCK_E,
		0, FN_PWM4_B, 0, 0,
		0, 0, 0, 0,
		/* IPSR1_3_0 [4] */
		IFN_IRQ2, FN_QCPV_QDE, 0, FN_DU_EXODDF_DU_ODDF_DISP_CDE,
		FN_VI4_DATA2_B, 0, 0, FN_MSIOF3_SYNC_E,
		0, FN_PWM3_B, 0, 0,
		0, 0, 0, 0
		}
	},
	{ PINMUX_CFG_REG_VAR("IPSR2", 0xE6060208, 32,
				4, 4, 4, 4, 4, 4, 4, 4) {
		/* IPSR2_31_28 [4] */
		IFN_A8, FN_RX3_B, FN_MSIOF2_SYNC_A, FN_HRX4_B,
		0, 0, 0, FN_SDA6_A,
		FN_AVB_AVTP_MATCH_B, FN_PWM1_B, 0, 0,
		0, 0, 0, 0,
		/* IPSR2_27_24 [4] */
		IFN_A7, FN_LCDOUT23, FN_MSIOF2_SS2_A, FN_TX4_B,
		FN_VI4_DATA15, FN_V15_DATA15, FN_DU_DB7, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR2_23_20 [4] */
		IFN_A6, FN_LCDOUT22, FN_MSIOF2_SS1_A, FN_RX4_B,
		FN_VI4_DATA14, FN_VI5_DATA14, FN_DU_DB6, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR2_19_16 [4] */
		IFN_A5, FN_LCDOUT21, FN_MSIOF3_SS2_B, FN_SCK4_B,
		FN_VI4_DATA13, FN_VI5_DATA13, FN_DU_DB5, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR2_15_12 [4] */
		IFN_A4, FN_LCDOUT20, FN_MSIOF3_SS1_B, 0,
		FN_VI4_DATA12, FN_VI5_DATA12, FN_DU_DB4, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR2_11_8 [4] */
		IFN_A3, FN_LCDOUT19, FN_MSIOF3_RXD_B, 0,
		FN_VI4_DATA11, 0, FN_DU_DB3, 0,
		0, FN_PWM6_A, 0, 0,
		0, 0, 0, 0,
		/* IPSR2_7_4 [4] */
		IFN_A2, FN_LCDOUT18, FN_MSIOF3_SCK_B, 0,
		FN_VI4_DATA10, 0, FN_DU_DB2, 0,
		0, FN_PWM5_A, 0, 0,
		0, 0, 0, 0,
		/* IPSR2_3_0 [4] */
		IFN_A1, FN_LCDOUT17, FN_MSIOF3_TXD_B, 0,
		FN_VI4_DATA9, 0, FN_DU_DB1, 0,
		0, FN_PWM4_A, 0, 0,
		0, 0, 0, 0,
		}
	},
	{ PINMUX_CFG_REG_VAR("IPSR3", 0xE606020C, 32,
				4, 4, 4, 4, 4, 4, 4, 4) {
		/* IPSR3_31_28 [4] */
		IFN_A16, FN_LCDOUT8, 0, 0,
		FN_VI4_FIELD, 0, FN_DU_DG0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR3_27_24 [4] */
		IFN_A15, FN_LCDOUT15, FN_MSIOF3_TXD_C, 0,
		FN_HRTS4x, FN_VI5_DATA11, FN_DU_DG7, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR3_23_20 [4] */
		IFN_A14, FN_LCDOUT14, FN_MSIOF3_RXD_C, 0,
		FN_HCTS4x, FN_VI5_DATA10, FN_DU_DG6, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR3_19_16 [4] */
		IFN_A13, FN_LCDOUT13, FN_MSIOF3_SYNC_C, 0,
		FN_HTX4_A, FN_VI5_DATA9, FN_DU_DG5, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR3_15_12 [4] */
		IFN_A12, FN_LCDOUT12, FN_MSIOF3_SCK_C, 0,
		FN_HRX4_A, FN_VI5_DATA8, FN_DU_DG4, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR3_11_8 [4] */
		IFN_A11, FN_TX3_B, FN_MSIOF2_TXD_A, FN_HTX4_B,
		FN_HSCK4, FN_VI5_FIELD, 0, FN_SCL6_A,
		FN_AVB_AVTP_CAPTURE_B, FN_PWM2_B, 0, 0,
		0, 0, 0, 0,
		/* IPSR3_7_4 [4] */
		IFN_A10, 0, FN_MSIOF2_RXD_A, FN_RTS4n_TANS_B,
		0, FN_VI5_HSYNCx, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR3_3_0 [4] */
		IFN_A9, 0, FN_MSIOF2_SCK_A, FN_CTS4x_B,
		0, FN_VI5_VSYNCx, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		}
	},
	{ PINMUX_CFG_REG_VAR("IPSR4", 0xE6060210, 32,
				4, 4, 4, 4, 4, 4, 4, 4) {
		/* IPSR4_31_28 [4] */
		IFN_RD_WRx, 0, FN_MSIOF3_RXD_D, FN_TX3_A,
		FN_HTX3_A, 0, 0, 0,
		FN_CAN0_RX_A, FN_CANFD0_RX_A, 0, 0,
		0, 0, 0, 0,
		/* IPSR4_27_24 [4] */
		IFN_RDx, 0, FN_MSIOF3_SYNC_D, FN_RX3_A,
		FN_HRX3_A, 0, 0, 0,
		FN_CAN0_TX_A, FN_CANFD0_TX_A, 0, 0,
		0, 0, 0, 0,
		/* IPSR4_23_20 [4] */
		IFN_BSx, FN_QSTVA_QVS, FN_MSIOF3_SCK_D, FN_SCK3,
		FN_HSCK3, 0, 0, 0,
		FN_CAN1_TX, FN_CANFD1_TX, FN_IETX_A, 0,
		0, 0, 0, 0,
		/* IPSR4_19_16 [4] */
		IFN_CS1x_A26, 0, 0, 0,
		0, FN_VI5_CLK, 0, FN_EX_WAIT0_B,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR4_15_12 [4] */
		IFN_CS0x, 0, 0, 0,
		0, FN_VI5_CLKENB, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR4_11_8 [4] */
		IFN_A19, FN_LCDOUT11, 0, 0,
		FN_VI4_CLKENB, 0, FN_DU_DG3, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR4_7_4 [4] */
		IFN_A18, FN_LCDOUT10, 0, 0,
		FN_VI4_HSYNCx, 0, FN_DU_DG2, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR4_3_0 [4] */
		IFN_A17, FN_LCDOUT9, 0, 0,
		FN_VI4_VSYNCx, 0, FN_DU_DG1, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		}
	},
	{ PINMUX_CFG_REG_VAR("IPSR5", 0xE6060214, 32,
				4, 4, 4, 4, 4, 4, 4, 4) {
		/* IPSR5_31_28 [4] */
		IFN_D4, FN_MSIOF2_SCK_B, 0, 0,
		FN_VI4_DATA20, FN_VI5_DATA4, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR5_27_24 [4] */
		IFN_D3, 0, FN_MSIOF3_TXD_A, 0,
		FN_VI4_DATA19, FN_VI5_DATA3, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR5_23_20 [4] */
		IFN_D2, 0, FN_MSIOF3_RXD_A, 0,
		FN_VI4_DATA18, FN_VI5_DATA2, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR5_19_16 [4] */
		IFN_D1, FN_MSIOF2_SS2_B, FN_MSIOF3_SYNC_A, 0,
		FN_VI4_DATA17, FN_VI5_DATA1, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR5_15_12 [4] */
		IFN_D0, FN_MSIOF2_SS1_B, FN_MSIOF3_SCK_A, 0,
		FN_VI4_DATA16, FN_VI5_DATA0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR5_11_8 [4] */
		IFN_EX_WAIT0_A, FN_QCLK, 0, 0,
		FN_VI4_CLK, 0, FN_DU_DOTCLKOUT0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR5_7_4 [4] */
		IFN_WE1x, 0, FN_MSIOF3_SS1_D, FN_RTS3x_TANS,
		FN_HRTS3x, 0, 0, FN_SDA6_B,
		FN_CAN1_RX, FN_CANFD1_RX, FN_IERX_A, 0,
		0, 0, 0, 0,
		/* IPSR5_3_0 [4] */
		IFN_WE0x, 0, FN_MSIIOF3_TXD_D, FN_CTS3x,
		FN_HCTS3x, 0, 0, FN_SCL6_B,
		FN_CAN_CLK, 0, FN_IECLK_A, 0,
		0, 0, 0, 0,
		}
	},
	{ PINMUX_CFG_REG_VAR("IPSR6", 0xE6060218, 32,
				4, 4, 4, 4, 4, 4, 4, 4) {
		/* IPSR6_31_28 [4] */
		IFN_D12, FN_LCDOUT4, FN_MSIOF2_SS1_D, FN_RX4_C,
		FN_VI4_DATA4_A, 0, FN_DU_DR4, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR6_27_24 [4] */
		IFN_D11, FN_LCDOUT3, FN_MSIOF2_TXD_D, FN_HTX3_B,
		FN_VI4_DATA3_A, FN_RTS4x_TANS_C, FN_DU_DR3, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR6_23_20 [4] */
		IFN_D10, FN_LCDOUT2, FN_MSIOF2_RXD_D, FN_HRX3_B,
		FN_VI4_DATA2_A, FN_CTS4x_C, FN_DU_DR2, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR6_19_16 [4] */
		IFN_D9, FN_LCDOUT1, FN_MSIOF2_SYNC_D, 0,
		FN_VI4_DATA1_A, 0, FN_DU_DR1, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR6_15_12 [4] */
		IFN_D8, FN_LCDOUT0, FN_MSIOF2_SCK_D, FN_SCK4_C,
		FN_VI4_DATA0_A, 0, FN_DU_DR0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR6_11_8 [4] */
		IFN_D7, FN_MSIOF2_TXD_B, 0, 0,
		FN_VI4_DATA23, FN_VI5_DATA7, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR6_7_4 [4] */
		IFN_D6, FN_MSIOF2_RXD_B, 0, 0,
		FN_VI4_DATA22, FN_VI5_DATA6, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR6_3_0 [4] */
		IFN_D5, FN_MSIOF2_SYNC_B, 0, 0,
		FN_VI4_DATA21, FN_VI5_DATA5, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		}
	},
	{ PINMUX_CFG_REG_VAR("IPSR7", 0xE606021C, 32,
				4, 4, 4, 4, 4, 4, 4, 4) {
		/* IPSR7_31_28 [4] */
		IFN_SD0_DAT1, 0, FN_MSIOF1_TXD_E, 0,
		0, FN_TS_SPSYNC0_B, FN_STP_ISSYNC_0_B, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR7_27_24 [4] */
		IFN_SD0_DAT0, 0, FN_MSIOF1_RXD_E, 0,
		0, FN_TS_SCK0_B, FN_STP_ISCLK_0_B, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR7_23_20 [4] */
		IFN_SD0_CMD, 0, FN_MSIOF1_SYNC_E, 0,
		0, 0, FN_STP_IVCXO27_0_B, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR7_19_16 [4] */
		IFN_SD0_CLK, 0, FN_MSIOF1_SCK_E, 0,
		0, 0, FN_STP_OPWM_0_B, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR7_15_12 [4] */
		FN_FSCLKST, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR7_11_8 [4] */
		IFN_D15, FN_LCDOUT7, FN_MSIOF3_SS2_A, FN_HTX3_C,
		FN_VI4_DATA7_A, 0, FN_DU_DR7, FN_SDA6_C,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR7_7_4 [4] */
		IFN_D14, FN_LCDOUT6, FN_MSIOF3_SS1_A, FN_HRX3_C,
		FN_VI4_DATA6_A, 0, FN_DU_DR6, FN_SCL6_C,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR7_3_0 [4] */
		IFN_D13, FN_LCDOUT5, FN_MSIOF2_SS2_D, FN_TX4_C,
		FN_VI4_DATA5_A, 0, FN_DU_DR5, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		}
	},
	{ PINMUX_CFG_REG_VAR("IPSR8", 0xE6060220, 32,
				4, 4, 4, 4, 4, 4, 4, 4) {
		/* IPSR8_31_28 [4] */
		IFN_SD1_DAT3, FN_SD2_DAT7, FN_MSIOF1_SS2_G, FN_NFRBx_B,
		0, FN_TS_SDEN1_B, FN_STP_ISEN_1_B, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR8_27_24 [4] */
		IFN_SD1_DAT2, FN_SD2_DAT6, FN_MSIOF1_SS1_G, FN_NFDATA15_B,
		0, FN_TS_SDAT1_B, FN_STP_IOD_1_B, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR8_23_20 [4] */
		IFN_SD1_DAT1, FN_SD2_DAT5, FN_MSIOF1_TXD_G, FN_NFDATA14_B,
		0, FN_TS_SPSYNC1_B, FN_STP_ISSYNC_1_B, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR8_19_16 [4] */
		IFN_SD1_DAT0, FN_SD2_DAT4, FN_MSIOF1_RXD_G, FN_NFWPx_B,
		0, FN_TS_SCK1_B, FN_STP_ISCLK_1_B, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR8_15_12 [4] */
		IFN_SD1_CMD, 0, FN_MSIOF1_SYNC_G, FN_NFCEx_B,
		0, FN_SIM0_D_A, FN_STP_IVCXO27_1_B, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR8_11_8 [4] */
		IFN_SD1_CLK, 0, FN_MSIOF1_SCK_G, 0,
		0, FN_SIM0_CLK_A, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR8_7_4 [4] */
		IFN_SD0_DAT3, 0, FN_MSIOF1_SS2_E, 0,
		0, FN_TS_SDEN0_B, FN_STP_ISEN_0_B, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR8_3_0 [4] */
		IFN_SD0_DAT2, 0, FN_MSIOF1_SS1_E, 0,
		0, FN_TS_SDAT0_B, FN_STP_ISD_0_B, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		}
	},
	{ PINMUX_CFG_REG_VAR("IPSR9", 0xE6060224, 32,
				4, 4, 4, 4, 4, 4, 4, 4) {
		/* IPSR9_31_28 [4] */
		IFN_SD3_CLK, 0, FN_NFWEx, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR9_27_24 [4] */
		IFN_SD2_DS, 0, FN_NFALE, 0,
		0, 0, 0, 0,
		FN_SATA_DEVSLP_B, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR9_23_20 [4] */
		IFN_SD2_DAT3, 0, FN_NFDATA13, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR9_19_16 [4] */
		IFN_SD2_DAT2, 0, FN_NFDATA12, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR9_15_12 [4] */
		IFN_SD2_DAT1, 0, FN_NFDATA11, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR9_11_8 [4] */
		IFN_SD2_DAT0, 0, FN_NFDATA10, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR9_7_4 [4] */
		IFN_SD2_CMD, 0, FN_NFDATA9, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR9_3_0 [4] */
		IFN_SD2_CLK, 0, FN_NFDATA8, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		}
	},
	{ PINMUX_CFG_REG_VAR("IPSR10", 0xE6060228, 32,
				4, 4, 4, 4, 4, 4, 4, 4) {
		/* IPSR10_31_28 [4] */
		IFN_SD3_DAT6, FN_SD3_CD, FN_NFDATA6, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR10_27_24 [4] */
		IFN_SD3_DAT5, FN_SD2_WP_A, FN_NFDATA5, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR10_23_20 [4] */
		IFN_SD3_DAT4, FN_SD2_CD_A, FN_NFDATA4, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR10_19_16 [4] */
		IFN_SD3_DAT3, 0, FN_NFDATA3, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR10_15_12 [4] */
		IFN_SD3_DAT2, 0, FN_NFDATA2, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR10_11_8 [4] */
		IFN_SD3_DAT1, 0, FN_NFDATA1, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR10_7_4 [4] */
		IFN_SD3_DAT0, 0, FN_NFDATA0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR10_3_0 [4] */
		IFN_SD3_CMD, 0, FN_NFREx, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		}
	},
	{ PINMUX_CFG_REG_VAR("IPSR11", 0xE606022C, 32,
				4, 4, 4, 4, 4, 4, 4, 4) {
		/* IPSR11_31_28 [4] */
		IFN_RX0, FN_HRX1_B, 0, 0,
		0, FN_TS_SCK0_C, FN_STP_ISCLK_0_C, FN_RIF0_D0_B,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR11_27_24 [4] */
		IFN_SCK0, FN_HSCK1_B, FN_MSIOF1_SS2_B, FN_AUDIO_CLKC_B,
		FN_SDA2_A, FN_SIM0_RST_B, FN_STP_OPWM_0_C, FN_RIF0_CLK_B,
		FN_ADICHS2, FN_SCK5_B, 0, 0,
		0, 0, 0, 0,
		/* IPSR11_23_20 [4] */
		IFN_SD1_WP, 0, FN_NFCEx_A, 0,
		0, FN_SIM0_D_B, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR11_19_16 [4] */
		IFN_SD1_CD, 0, FN_NFRBx_A, 0,
		0, FN_SIM0_CLK_B, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR11_15_12 [4] */
		IFN_SD0_WP, 0, FN_NFDATA15_A, 0,
		FN_SDA2_B, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR11_11_8 [4] */
		IFN_SD0_CD, 0, FN_NFDATA14_A, 0,
		FN_SCL2_B, FN_SIM0_RST_A, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR11_7_4 [4] */
		IFN_SD3_DS, 0, FN_NFCLE, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR11_3_0 [4] */
		IFN_SD3_DAT7, FN_SD3_WP, FN_NFDATA7, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		}
	},
	{ PINMUX_CFG_REG_VAR("IPSR12", 0xE6060230, 32,
				4, 4, 4, 4, 4, 4, 4, 4) {
		/* IPSR12_31_28 [4] */
		IFN_SCK2, FN_SCIF_CLK_B, FN_MSIOF1_SCK_B, 0,
		0, FN_TS_SCK1_C, FN_STP_ISCLK_1_C, FN_RIF1_CLK_B,
		0, FN_ADICLK, 0, 0,
		0, 0, 0, 0,
		/* IPSR12_27_24 [4] */
		IFN_RTS1x_TANS, FN_HRTS1x_A, FN_MSIOF1_TXD_B, 0,
		0, FN_TS_SDAT1_C, FN_STP_ISD_1_C, FN_RIF1_D1_B,
		0, FN_ADICHS0, 0, 0,
		0, 0, 0, 0,
		/* IPSR12_23_20 [4] */
		IFN_CTS1x, FN_HCTS1x_A, FN_MSIOF1_RXD_B, 0,
		0, FN_TS_SDEN1_C, FN_STP_ISEN_1_C, FN_RIF1_D0_B,
		0, FN_ADIDATA, 0, 0,
		0, 0, 0, 0,
		/* IPSR12_19_16 [4] */
		IFN_TX1_A, FN_HTX1_A, 0, 0,
		0, FN_TS_SDEN0_C, FN_STP_ISEN_0_C, FN_RIF1_D0_C,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR12_15_12 [4] */
		IFN_RX1_A, FN_HRX1_A, 0, 0,
		0, FN_TS_SDAT0_C, FN_STP_ISD_0_C, FN_RIF1_CLK_C,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR12_11_8 [4] */
		IFN_RTS0x_TANS, FN_HRTS1x_B, FN_MSIOF1_SS1_B, FN_AUDIO_CLKA_B,
		FN_SCL2_A, 0, FN_STP_IVCXO27_1_C, FN_RIF0_SYNC_B,
		0, FN_ADICHS1, 0, 0,
		0, 0, 0, 0,
		/* IPSR12_7_4 [4] */
		IFN_CTS0x, FN_HCTS1x_B, FN_MSIOF1_SYNC_B, 0,
		0, FN_TS_SPSYNC1_C, FN_STP_ISSYNC_1_C, FN_RIF1_SYNC_B,
		FN_AUDIO_CLKOUT_C, FN_ADICS_SAMP, 0, 0,
		0, 0, 0, 0,
		/* IPSR12_3_0 [4] */
		IFN_TX0, FN_HTX1_B, 0, 0,
		0, FN_TS_SPSYNC0_C, FN_STP_ISSYNC_0_C, FN_RIF0_D1_B,
		0, 0, 0, 0,
		}
	},
	{ PINMUX_CFG_REG_VAR("IPSR13", 0xE6060234, 32,
				4, 4, 4, 4, 4, 4, 4, 4) {
		/* IPSR13_31_28 [4] */
		IFN_MSIOF0_SYNC, 0, 0, 0,
		0, 0, 0, 0,
		FN_AUDIO_CLKOUT_A, 0, FN_TX5_B, 0,
		0, FN_BPFCLK_D, 0, 0,
		/* IPSR13_27_24 [4] */
		IFN_HRTS0x, FN_TX2_B, FN_MSIOF1_SS1_D, 0,
		FN_SSI_WS9_A, 0, FN_STP_IVCXO27_0_D, FN_BPFCLK_A,
		FN_AUDIO_CLKOUT2_A, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR13_23_20 [4] */
		IFN_HCTS0x, FN_RX2_B, FN_MSIOF1_SYNC_D, 0,
		FN_SSI_SCK9_A, FN_TS_SPSYNC0_D,
		FN_STP_ISSYNC_0_D, FN_RIF0_SYNC_C,
		FN_AUDIO_CLKOUT1_A, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR13_19_16 [4] */
		IFN_HTX0, 0, FN_MSIOF1_TXD_D, 0,
		FN_SSI_SDATA9_B, FN_TS_SDAT0_D, FN_STP_ISD_0_D, FN_RIF0_D1_C,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR13_15_12 [4] */
		IFN_HRX0, 0, FN_MSIOF1_RXD_D, 0,
		FN_SSI_SDATA2_B, FN_TS_SDEN0_D, FN_STP_ISEN_0_D, FN_RIF0_D0_C,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR13_11_8 [4] */
		IFN_HSCK0, 0, FN_MSIOF1_SCK_D, FN_AUDIO_CLKB_A,
		FN_SSI_SDATA1_B, FN_TS_SCK0_D, FN_STP_ISCLK_0_D, FN_RIF0_CLK_C,
		0, 0, FN_RX5_B, 0,
		0, 0, 0, 0,
		/* IPSR13_7_4 [4] */
		IFN_RX2_A, 0, 0, FN_SD2_WP_B,
		FN_SDA1_A, 0, FN_FMIN_A, FN_RIF1_SYNC_C,
		0, FN_FSO_CFE_1x, 0, 0,
		0, 0, 0, 0,
		/* IPSR13_3_0 [4] */
		IFN_TX2_A, 0, 0, FN_SD2_CD_B,
		FN_SCL1_A, 0, FN_FMCLK_A, FN_RIF1_D1_C,
		0, FN_FSO_CFE_0x, 0, 0,
		}
	},
	{ PINMUX_CFG_REG_VAR("IPSR14", 0xE6060238, 32,
				4, 4, 4, 4, 4, 4, 4, 4) {
		/* IPSR14_31_28 [4] */
		IFN_SSI_SDATA0, 0, FN_MSIOF1_SS2_F, 0,
		0, 0, 0, FN_MOUT2,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR14_27_24 [4] */
		IFN_SSI_WS01239, 0, FN_MSIOF1_SS1_F, 0,
		0, 0, 0, 0, FN_MOUT1,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR14_23_20 [4] */
		IFN_SSI_SCK01239, 0, FN_MSIOF1_TXD_F, 0,
		0, 0, 0, FN_MOUT0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR14_19_16 [4] */
		IFN_MLB_DAT, FN_TX1_B, FN_MSIOF1_RXD_F, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR14_15_12 [4] */
		IFN_MLB_SIG, FN_RX1_B, FN_MSIOF1_SYNC_F, 0,
		FN_SDA1_B, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR14_11_8 [4] */
		IFN_MLB_CLK, 0, FN_MSIOF1_SCK_F, 0,
		FN_SCL1_B, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR14_7_4 [4] */
		IFN_MSIOF0_SS2, FN_TX5_A, FN_MSIOF1_SS2_D, FN_AUDIO_CLKC_A,
		FN_SSI_WS2_A, 0, FN_STP_OPWM_0_D, 0,
		FN_AUDIO_CLKOUT_D, 0, FN_SPEEDIN_B, 0,
		0, 0, 0, 0,
		/* IPSR14_3_0 [4] */
		IFN_MSIOF0_SS1, FN_RX5_A, FN_NFWPx_A, FN_AUDIO_CLKA_C,
		FN_SSI_SCK2_A, 0, FN_STP_IVCXO27_0_C, 0,
		FN_AUDIO_CLKOUT3_A, 0, FN_TCLK1_B, 0,
		0, 0, 0, 0,
		}
	},
	{ PINMUX_CFG_REG_VAR("IPSR15", 0xE606023C, 32,
				4, 4, 4, 4, 4, 4, 4, 4) {
		/* IPSR15_31_28 [4] */
		IFN_SSI_SDATA4, FN_HSCK2_A, FN_MSIOF1_RXD_A, 0,
		0, FN_TS_SPSYNC0_A, FN_STP_ISSYNC_0_A, FN_RIF0_D0_A,
		FN_RIF2_D1_A, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR15_27_24 [4] */
		IFN_SSI_WS4, FN_HTX2_A, FN_MSIOF1_SYNC_A, 0,
		0, FN_TS_SDEN0_A, FN_STP_ISEN_0_A, FN_RIF0_SYNC_A,
		FN_RIF2_SYNC_A, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR15_23_20 [4] */
		IFN_SSI_SCK4, FN_HRX2_A, FN_MSIOF1_SCK_A, 0,
		0, FN_TS_SDAT0_A, FN_STP_ISD_0_A, FN_RIF0_CLK_A,
		FN_RIF2_CLK_A, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR15_19_16 [4] */
		IFN_SSI_SDATA3, FN_HRTS2x_A, FN_MSIOF1_TXD_A, 0,
		0, FN_TS_SCK0_A, FN_STP_ISCLK_0_A, FN_RIF0_D1_A,
		FN_RIF2_D0_A, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR15_15_12 [4] */
		IFN_SSI_WS34, FN_HCTS2x_A, FN_MSIOF1_SS2_A, 0,
		0, 0, FN_STP_IVCXO27_0_A, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR15_11_8 [4] */
		IFN_SSI_SCK34, 0, FN_MSIOF1_SS1_A, 0,
		0, 0, FN_STP_OPWM_0_A, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR15_7_4 [4] */
		IFN_SSI_SDATA2_A, 0, 0, 0,
		FN_SSI_SCK1_B, 0, 0, FN_MOUT6,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR15_3_0 [4] */
		IFN_SSI_SDATA1_A, 0, 0, 0,
		0, 0, 0, FN_MOUT5,
		0, 0, 0, 0,
		0, 0, 0, 0,
		}
	},
	{ PINMUX_CFG_REG_VAR("IPSR16", 0xE6060240, 32,
				4, 4, 4, 4, 4, 4, 4, 4) {
		/* IPSR16_31_28 [4] */
		IFN_SSI_SDATA9_A, FN_HSCK2_B, FN_MSIOF1_SS1_C, FN_HSCK1_A,
		FN_SSI_WS1_B, FN_SCK1, FN_STP_IVCXO27_1_A, FN_SCK5_A,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR16_27_24 [4] */
		IFN_SSI_SDATA8, FN_HRTS2x_B, FN_MSIOF1_TXD_C, 0,
		0, FN_TS_SPSYNC1_A, FN_STP_ISSYNC_1_A, FN_RIF1_D1_A,
		FN_RIF3_D1_A, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR16_23_20 [4] */
		IFN_SSI_SDATA7, FN_HCTS2x_B, FN_MSIOF1_RXD_C, 0,
		0, FN_TS_SDEN1_A, FN_STP_ISEN_1_A, FN_RIF1_D0_A,
		FN_RIF3_D0_A, 0, FN_TCLK2_A, 0,
		0, 0, 0, 0,
		/* IPSR16_19_16 [4] */
		IFN_SSI_WS78, FN_HTX2_B, FN_MSIOF1_SYNC_C, 0,
		0, FN_TS_SDAT1_A, FN_STP_ISD_1_A, FN_RIF1_SYNC_A,
		FN_RIF3_SYNC_A, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR16_15_12 [4] */
		IFN_SSI_SCK78, FN_HRX2_B, FN_MSIOF1_SCK_C, 0,
		0, FN_TS_SCK1_A, FN_STP_ISCLK_1_A, FN_RIF1_CLK_A,
		FN_RIF3_CLK_A, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR16_11_8 [4] */
		IFN_SSI_SDATA6, 0, 0, FN_SIM0_CLK_D,
		0, 0, 0, 0,
		FN_SATA_DEVSLP_A, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR16_7_4 [4] */
		IFN_SSI_WS6, 0, 0, FN_SIM0_D_D,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		/* IPSR16_3_0 [4] */
		IFN_SSI_SCK6, 0, 0, FN_SIM0_RST_D,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		}
	},
	{ PINMUX_CFG_REG_VAR("IPSR17", 0xE6060244, 32,
				4, 4, 4, 4, 4, 4, 4, 4) {
		/* IPSR17_31_28 [4] */
		IFN_USB30_OVC, 0, 0, FN_AUDIO_CLKOUT1_B,
		FN_SSI_WS2_B, FN_TS_SPSYNC1_D, FN_STP_ISSYNC_1_D, FN_STP_IVCXO27_0_E,
		FN_RIF3_D1_B, 0, FN_FSO_TOEx, FN_TPU0TO1,
		0, 0, 0, 0,
		/* IPSR17_27_24 [4] */
		IFN_USB30_PWEN, 0, 0, FN_AUDIO_CLKOUT_B,
		FN_SSI_SCK2_B, FN_TS_SDEN1_D, FN_STP_ISEN_1_D, FN_STP_OPWM_0_E,
		FN_RIF3_D0_B, 0, FN_TCLK2_B, FN_TPU0TO0,
		FN_BPFCLK_C, FN_HRTS2x_C, 0, 0,
		/* IPSR17_23_20 [4] */
		IFN_USB1_OVC, 0, FN_MSIOF1_SS2_C, 0,
		FN_SSI_WS1_A, FN_TS_SDAT0_E, FN_STP_ISD_0_E, FN_FMIN_B,
		FN_RIF2_SYNC_B, 0, FN_REMOCON_B, 0,
		0, FN_HCTS2x_C, 0, 0,
		/* IPSR17_19_16 [4] */
		IFN_USB1_PWEN, 0, 0, FN_SIM0_CLK_C,
		FN_SSI_SCK1_A, FN_TS_SCK0_E, FN_STP_ISCLK_0_E, FN_FMCLK_B,
		FN_RIF2_CLK_B, 0, FN_SPEEDIN_A, 0,
		0, FN_HTX2_C, 0, 0,
		/* IPSR17_15_12 [4] */
		IFN_USB0_OVC, 0, 0, FN_SIM0_D_C,
		0, FN_TS_SDAT1_D, FN_STP_ISD_1_D, 0,
		FN_RIF3_SYNC_B, 0, 0, 0,
		0, FN_HRX2_C, 0, 0,
		/* IPSR17_11_8 [4] */
		IFN_USB0_PWEN, 0, 0, FN_SIM0_RST_C,
		0, FN_TS_SCK1_D, FN_STP_ISCLK_1_D, FN_BPFCLK_B,
		FN_RIF3_CLK_B, 0, 0, 0,
		0, FN_HSCK2_C, 0, 0,
		/* IPSR17_7_4 [4] */
		IFN_AUDIO_CLKB_B, FN_SCIF_CLK_A, 0, 0,
		0, 0, FN_STP_IVCXO27_1_D, FN_REMOCON_A,
		0, 0, FN_TCLK1_A, 0,
		0, 0, 0, 0,
		/* IPSR17_3_0 [4] */
		IFN_AUDIO_CLKA_A, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, FN_CC5_OSCOUT,
		0, 0, 0, 0,
		}
	},
	{ PINMUX_CFG_REG_VAR("IPSR18", 0xE6060248, 32,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1,
				4, 4) {
		/* reserved [31..24] */
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		/* reserved [23..16] */
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		/* reserved [15..8] */
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		/* IPSR18_7_4 [4] */
		IFN_USB3_OVC, 0, 0, FN_AUDIO_CLKOUT3_B,
		FN_SSI_WS9_B, FN_TS_SPSYNC0_E, FN_STP_ISSYNC_0_E, 0,
		FN_RIF2_D1_B, 0, 0, FN_TPU0TO3,
		FN_FMIN_C, FN_FMIN_D, 0, 0,
		/* IPSR18_3_0 [4] */
		IFN_USB3_PWEN, 0, 0, FN_AUDIO_CLKOUT2_B,
		FN_SSI_SCK9_B, FN_TS_SDEN0_E, FN_STP_ISEN_0_E, 0,
		FN_RIF2_D0_B, 0, 0, FN_TPU0TO2,
		FN_FMCLK_C, FN_FMCLK_D, 0, 0,
		}
	},
	{ PINMUX_CFG_REG_VAR("MOD_SEL0", 0xE6060500, 32,
				3, 2, 3, 1, 1, 1, 1, 1, 2, 1,
				1, 2, 1, 1, 1, 2, 2, 1, 2, 1, 1, 1) {
		/* MOD_SEL0 */
		/* sel_msiof3[3](0,1,2,3,4) */
		FN_SEL_MSIOF3_0, FN_SEL_MSIOF3_1,
		FN_SEL_MSIOF3_2, FN_SEL_MSIOF3_3,
		FN_SEL_MSIOF3_4, 0,
		0, 0,
		/* sel_msiof2[2](0,1,2,3) */
		FN_SEL_MSIOF2_0, FN_SEL_MSIOF2_1,
		FN_SEL_MSIOF2_2, FN_SEL_MSIOF2_3,
		/* sel_msiof1[3](0,1,2,3,4,5,6) */
		FN_SEL_MSIOF1_0, FN_SEL_MSIOF1_1,
		FN_SEL_MSIOF1_2, FN_SEL_MSIOF1_3,
		FN_SEL_MSIOF1_4, FN_SEL_MSIOF1_5,
		FN_SEL_MSIOF1_6, 0,
		/* sel_lbsc[1](0,1) */
		FN_SEL_LBSC_0, FN_SEL_LBSC_1,
		/* sel_iebus[1](0,1) */
		FN_SEL_IEBUS_0, FN_SEL_IEBUS_1,
		/* sel_i2c2[1](0,1) */
		FN_SEL_I2C2_0, FN_SEL_I2C2_1,
		/* sel_i2c1[1](0,1) */
		FN_SEL_I2C1_0, FN_SEL_I2C1_1,
		/* sel_hscif4[1](0,1) */
		FN_SEL_HSCIF4_0, FN_SEL_HSCIF4_1,
		/* sel_hscif3[2](0,1,2,3) */
		FN_SEL_HSCIF3_0, FN_SEL_HSCIF3_1,
		FN_SEL_HSCIF3_2, FN_SEL_HSCIF3_3,
		/* sel_hscif1[1](0,1) */
		FN_SEL_HSCIF1_0, FN_SEL_HSCIF1_1,
		/* reserved[1] */
		0, 0,
		/* sel_hscif2[2](0,1,2) */
		FN_SEL_HSCIF2_0, FN_SEL_HSCIF2_1,
		FN_SEL_HSCIF2_2, 0,
		/* sel_etheravb[1](0,1) */
		FN_SEL_ETHERAVB_0, FN_SEL_ETHERAVB_1,
		/* sel_drif3[1](0,1) */
		FN_SEL_DRIF3_0, FN_SEL_DRIF3_1,
		/* sel_drif2[1](0,1) */
		FN_SEL_DRIF2_0, FN_SEL_DRIF2_1,
		/* sel_drif1[2](0,1,2) */
		FN_SEL_DRIF1_0, FN_SEL_DRIF1_1,
		FN_SEL_DRIF1_2, 0,
		/* sel_drif0[2](0,1,2) */
		FN_SEL_DRIF0_0, FN_SEL_DRIF0_1,
		FN_SEL_DRIF0_2, 0,
		/* sel_canfd0[1](0,1) */
		FN_SEL_CANFD_0, FN_SEL_CANFD_1,
		/* sel_adg_a[2](0,1,2) */
		FN_SEL_ADG_A_0, FN_SEL_ADG_A_1,
		FN_SEL_ADG_A_2, 0,
		/* reserved[3]*/
		0, 0,
		0, 0,
		0, 0,
		}
	},
	{ PINMUX_CFG_REG_VAR("MOD_SEL1", 0xE6060504, 32,
				2, 3, 1, 2,
				3, 1, 1, 2, 1,
				2, 1, 1, 1, 1, 1, 1,
				1, 1, 1, 1, 1, 1, 1, 1) {
		/* sel_tsif1[2](0,1,2,3) */
		FN_SEL_TSIF1_0, FN_SEL_TSIF1_1,
		FN_SEL_TSIF1_2, FN_SEL_TSIF1_3,
		/* sel_tsif0[3](0,1,2,3,4) */
		FN_SEL_TSIF0_0, FN_SEL_TSIF0_1,
		FN_SEL_TSIF0_2, FN_SEL_TSIF0_3,
		FN_SEL_TSIF0_4, 0,
		0, 0,
		/* sel_timer_tmu1[1](0,1) */
		FN_SEL_TIMER_TMU1_0, FN_SEL_TIMER_TMU1_1,
		/* sel_ssp1_1[2](0,1,2,3) */
		FN_SEL_SSP1_1_0, FN_SEL_SSP1_1_1,
		FN_SEL_SSP1_1_2, FN_SEL_SSP1_1_3,
		/* sel_ssp1_0[3](0,1,2,3,4) */
		FN_SEL_SSP1_0_0, FN_SEL_SSP1_0_1,
		FN_SEL_SSP1_0_2, FN_SEL_SSP1_0_3,
		FN_SEL_SSP1_0_4, 0,
		0, 0,
		/* sel_ssi1[1](0,1) */
		FN_SEL_SSI_0, FN_SEL_SSI_1,
		/* sel_speed_pulse_if[1](0,1) */
		FN_SEL_SPEED_PULSE_IF_0, FN_SEL_SPEED_PULSE_IF_1,
		/* sel_simcard[2](0,1,2,3) */
		FN_SEL_SIMCARD_0, FN_SEL_SIMCARD_1,
		FN_SEL_SIMCARD_2, FN_SEL_SIMCARD_3,
		/* sel_sdhi2[1](0,1) */
		FN_SEL_SDHI2_0, FN_SEL_SDHI2_1,
		/* sel_scif4[2](0,1,2) */
		FN_SEL_SCIF4_0, FN_SEL_SCIF4_1,
		FN_SEL_SCIF4_2, 0,
		/* sel_scif3[1](0,1) */
		FN_SEL_SCIF3_0, FN_SEL_SCIF3_1,
		/* sel_scif2[1](0,1) */
		FN_SEL_SCIF2_0, FN_SEL_SCIF2_1,
		/* sel_scif1[1](0,1) */
		FN_SEL_SCIF1_0, FN_SEL_SCIF1_1,
		/* sel_scif[1](0,1) */
		FN_SEL_SCIF_0, FN_SEL_SCIF_1,
		/* sel_remocon[1](0,1) */
		FN_SEL_REMOCON_0, FN_SEL_REMOCON_1,
		/* reserved[8..7] */
		0, 0,
		0, 0,
		/* sel_rcan0[1](0,1) */
		FN_SEL_RCAN_0, FN_SEL_RCAN_1,
		/* sel_pwm6[1](0,1) */
		FN_SEL_PWM6_0, FN_SEL_PWM6_1,
		/* sel_pwm5[1](0,1) */
		FN_SEL_PWM5_0, FN_SEL_PWM5_1,
		/* sel_pwm4[1](0,1) */
		FN_SEL_PWM4_0, FN_SEL_PWM4_1,
		/* sel_pwm3[1](0,1) */
		FN_SEL_PWM3_0, FN_SEL_PWM3_1,
		/* sel_pwm2[1](0,1) */
		FN_SEL_PWM2_0, FN_SEL_PWM2_1,
		/* sel_pwm1[1](0,1) */
		FN_SEL_PWM1_0, FN_SEL_PWM1_1,
		}
	},
	{ PINMUX_CFG_REG_VAR("MOD_SEL2", 0xE6060508, 32,
			1, 1, 1, 2, 1, 3, 1, 1, 1, 1, 1, 1, 1,
			1, 1, 1, 1, 1, 1, 1, 1,
			1, 1, 1, 1, 1, 1, 1, 1) {
		/* i2c_sel_5[1](0,1) */
		FN_I2C_SEL_5_0, FN_I2C_SEL_5_1,
		/* i2c_sel_3[1](0,1) */
		FN_I2C_SEL_3_0, FN_I2C_SEL_3_1,
		/* i2c_sel_0[1](0,1) */
		FN_I2C_SEL_0_0, FN_I2C_SEL_0_1,
		/* sel_fm[2](0,1,2,3) */
		FN_SEL_FM_0, FN_SEL_FM_1,
		FN_SEL_FM_2, FN_SEL_FM_3,
		/* sel_scif5[1](0,1) */
		FN_SEL_SCIF5_0, FN_SEL_SCIF5_1,
		/* sel_i2c6[3](0,1,2) */
		FN_SEL_I2C6_0, FN_SEL_I2C6_1,
		FN_SEL_I2C6_2, 0,
		/* sel_ndfc[1](0,1) */
		FN_SEL_NDFC_0, FN_SEL_NDFC_1,
		/* sel_ssi2[1](0,1) */
		FN_SEL_SSI2_0, FN_SEL_SSI2_1,
		/* sel_ssi9[1](0,1) */
		FN_SEL_SSI9_0, FN_SEL_SSI9_1,
		/* sel_timer_tmu2[1](0,1) */
		FN_SEL_TIMER_TMU2_0, FN_SEL_TIMER_TMU2_1,
		/* sel_adg_b[1](0,1) */
		FN_SEL_ADG_B_0, FN_SEL_ADG_B_1,
		/* sel_adg_c[1](0,1) */
		FN_SEL_ADG_C_0, FN_SEL_ADG_C_1,
		/* reserved[16..16] */
		0, 0,
		/* reserved[15..8] */
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		/* reserved[7..1] */
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		/* sel_vin4[1](0,1) */
		FN_SEL_VIN4_0, FN_SEL_VIN4_1,
		}
	},
	{ PINMUX_CFG_REG("INOUTSEL0", 0xE6050004, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,

		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,

		GP_0_15_IN, GP_0_15_OUT,
		GP_0_14_IN, GP_0_14_OUT,
		GP_0_13_IN, GP_0_13_OUT,
		GP_0_12_IN, GP_0_12_OUT,
		GP_0_11_IN, GP_0_11_OUT,
		GP_0_10_IN, GP_0_10_OUT,
		GP_0_9_IN, GP_0_9_OUT,
		GP_0_8_IN, GP_0_8_OUT,
		GP_0_7_IN, GP_0_7_OUT,
		GP_0_6_IN, GP_0_6_OUT,
		GP_0_5_IN, GP_0_5_OUT,
		GP_0_4_IN, GP_0_4_OUT,
		GP_0_3_IN, GP_0_3_OUT,
		GP_0_2_IN, GP_0_2_OUT,
		GP_0_1_IN, GP_0_1_OUT,
		GP_0_0_IN, GP_0_0_OUT,
		}
	},
	{ PINMUX_CFG_REG("INOUTSEL1", 0xE6051004, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		GP_1_28_IN, GP_1_28_OUT,
		GP_1_27_IN, GP_1_27_OUT,
		GP_1_26_IN, GP_1_26_OUT,
		GP_1_25_IN, GP_1_25_OUT,
		GP_1_24_IN, GP_1_24_OUT,
		GP_1_23_IN, GP_1_23_OUT,
		GP_1_22_IN, GP_1_22_OUT,
		GP_1_21_IN, GP_1_21_OUT,
		GP_1_20_IN, GP_1_20_OUT,
		GP_1_19_IN, GP_1_19_OUT,
		GP_1_18_IN, GP_1_18_OUT,
		GP_1_17_IN, GP_1_17_OUT,
		GP_1_16_IN, GP_1_16_OUT,
		GP_1_15_IN, GP_1_15_OUT,
		GP_1_14_IN, GP_1_14_OUT,
		GP_1_13_IN, GP_1_13_OUT,
		GP_1_12_IN, GP_1_12_OUT,
		GP_1_11_IN, GP_1_11_OUT,
		GP_1_10_IN, GP_1_10_OUT,
		GP_1_9_IN, GP_1_9_OUT,
		GP_1_8_IN, GP_1_8_OUT,
		GP_1_7_IN, GP_1_7_OUT,
		GP_1_6_IN, GP_1_6_OUT,
		GP_1_5_IN, GP_1_5_OUT,
		GP_1_4_IN, GP_1_4_OUT,
		GP_1_3_IN, GP_1_3_OUT,
		GP_1_2_IN, GP_1_2_OUT,
		GP_1_1_IN, GP_1_1_OUT,
		GP_1_0_IN, GP_1_0_OUT,
		}
	},
	{ PINMUX_CFG_REG("INOUTSEL2", 0xE6052004, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,

		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,

		0, 0,
		GP_2_14_IN, GP_2_14_OUT,
		GP_2_13_IN, GP_2_13_OUT,
		GP_2_12_IN, GP_2_12_OUT,
		GP_2_11_IN, GP_2_11_OUT,
		GP_2_10_IN, GP_2_10_OUT,
		GP_2_9_IN, GP_2_9_OUT,
		GP_2_8_IN, GP_2_8_OUT,
		GP_2_7_IN, GP_2_7_OUT,
		GP_2_6_IN, GP_2_6_OUT,
		GP_2_5_IN, GP_2_5_OUT,
		GP_2_4_IN, GP_2_4_OUT,
		GP_2_3_IN, GP_2_3_OUT,
		GP_2_2_IN, GP_2_2_OUT,
		GP_2_1_IN, GP_2_1_OUT,
		GP_2_0_IN, GP_2_0_OUT,
		}
	},
	{ PINMUX_CFG_REG("INOUTSEL3", 0xE6053004, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,

		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,

		GP_3_15_IN, GP_3_15_OUT,
		GP_3_14_IN, GP_3_14_OUT,
		GP_3_13_IN, GP_3_13_OUT,
		GP_3_12_IN, GP_3_12_OUT,
		GP_3_11_IN, GP_3_11_OUT,
		GP_3_10_IN, GP_3_10_OUT,
		GP_3_9_IN, GP_3_9_OUT,
		GP_3_8_IN, GP_3_8_OUT,
		GP_3_7_IN, GP_3_7_OUT,
		GP_3_6_IN, GP_3_6_OUT,
		GP_3_5_IN, GP_3_5_OUT,
		GP_3_4_IN, GP_3_4_OUT,
		GP_3_3_IN, GP_3_3_OUT,
		GP_3_2_IN, GP_3_2_OUT,
		GP_3_1_IN, GP_3_1_OUT,
		GP_3_0_IN, GP_3_0_OUT,
		}
	},
	{ PINMUX_CFG_REG("INOUTSEL4", 0xE6054004, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,

		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_4_17_IN, GP_4_17_OUT,
		GP_4_16_IN, GP_4_16_OUT,

		GP_4_15_IN, GP_4_15_OUT,
		GP_4_14_IN, GP_4_14_OUT,
		GP_4_13_IN, GP_4_13_OUT,
		GP_4_12_IN, GP_4_12_OUT,
		GP_4_11_IN, GP_4_11_OUT,
		GP_4_10_IN, GP_4_10_OUT,
		GP_4_9_IN, GP_4_9_OUT,
		GP_4_8_IN, GP_4_8_OUT,
		GP_4_7_IN, GP_4_7_OUT,
		GP_4_6_IN, GP_4_6_OUT,
		GP_4_5_IN, GP_4_5_OUT,
		GP_4_4_IN, GP_4_4_OUT,
		GP_4_3_IN, GP_4_3_OUT,
		GP_4_2_IN, GP_4_2_OUT,
		GP_4_1_IN, GP_4_1_OUT,
		GP_4_0_IN, GP_4_0_OUT,
		}
	},
	{ PINMUX_CFG_REG("INOUTSEL5", 0xE6055004, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_5_25_IN, GP_5_25_OUT,
		GP_5_24_IN, GP_5_24_OUT,

		GP_5_23_IN, GP_5_23_OUT,
		GP_5_22_IN, GP_5_22_OUT,
		GP_5_21_IN, GP_5_21_OUT,
		GP_5_20_IN, GP_5_20_OUT,
		GP_5_19_IN, GP_5_19_OUT,
		GP_5_18_IN, GP_5_18_OUT,
		GP_5_17_IN, GP_5_17_OUT,
		GP_5_16_IN, GP_5_16_OUT,

		GP_5_15_IN, GP_5_15_OUT,
		GP_5_14_IN, GP_5_14_OUT,
		GP_5_13_IN, GP_5_13_OUT,
		GP_5_12_IN, GP_5_12_OUT,
		GP_5_11_IN, GP_5_11_OUT,
		GP_5_10_IN, GP_5_10_OUT,
		GP_5_9_IN, GP_5_9_OUT,
		GP_5_8_IN, GP_5_8_OUT,
		GP_5_7_IN, GP_5_7_OUT,
		GP_5_6_IN, GP_5_6_OUT,
		GP_5_5_IN, GP_5_5_OUT,
		GP_5_4_IN, GP_5_4_OUT,
		GP_5_3_IN, GP_5_3_OUT,
		GP_5_2_IN, GP_5_2_OUT,
		GP_5_1_IN, GP_5_1_OUT,
		GP_5_0_IN, GP_5_0_OUT,
		}
	},
	{ PINMUX_CFG_REG("INOUTSEL6", 0xE6055404, 32, 1) {
		GP_INOUTSEL(6)
		}
	},
	{ PINMUX_CFG_REG("INOUTSEL7", 0xE6055804, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,

		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,

		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,

		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_6_3_IN, GP_6_3_OUT,
		GP_6_2_IN, GP_6_2_OUT,
		GP_6_1_IN, GP_6_1_OUT,
		GP_6_0_IN, GP_6_0_OUT,
		}
	},
	{ },
};

static struct pinmux_data_reg pinmux_data_regs[] = {
	/* use OUTDT registers? */
	{ PINMUX_DATA_REG("INDT0", 0xE6050008, 32) {
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		GP_0_15_DATA, GP_0_14_DATA, GP_0_13_DATA, GP_0_12_DATA,
		GP_0_11_DATA, GP_0_10_DATA, GP_0_9_DATA, GP_0_8_DATA,
		GP_0_7_DATA, GP_0_6_DATA, GP_0_5_DATA, GP_0_4_DATA,
		GP_0_3_DATA, GP_0_2_DATA, GP_0_1_DATA, GP_0_0_DATA }
	},
	{ PINMUX_DATA_REG("INDT1", 0xE6051008, 32) {
		0, 0, 0, GP_1_28_DATA,
		GP_1_27_DATA, GP_1_26_DATA, GP_1_25_DATA, GP_1_24_DATA,
		GP_1_23_DATA, GP_1_22_DATA, GP_1_21_DATA, GP_1_20_DATA,
		GP_1_19_DATA, GP_1_18_DATA, GP_1_17_DATA, GP_1_16_DATA,
		GP_1_15_DATA, GP_1_14_DATA, GP_1_13_DATA, GP_1_12_DATA,
		GP_1_11_DATA, GP_1_10_DATA, GP_1_9_DATA, GP_1_8_DATA,
		GP_1_7_DATA, GP_1_6_DATA, GP_1_5_DATA, GP_1_4_DATA,
		GP_1_3_DATA, GP_1_2_DATA, GP_1_1_DATA, GP_1_0_DATA }
	},
	{ PINMUX_DATA_REG("INDT2", 0xE6052008, 32) {
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, GP_2_14_DATA, GP_2_13_DATA, GP_2_12_DATA,
		GP_2_11_DATA, GP_2_10_DATA, GP_2_9_DATA, GP_2_8_DATA,
		GP_2_7_DATA, GP_2_6_DATA, GP_2_5_DATA, GP_2_4_DATA,
		GP_2_3_DATA, GP_2_2_DATA, GP_2_1_DATA, GP_2_0_DATA }
	},
	{ PINMUX_DATA_REG("INDT3", 0xE6053008, 32) {
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		GP_3_15_DATA, GP_3_14_DATA, GP_3_13_DATA, GP_3_12_DATA,
		GP_3_11_DATA, GP_3_10_DATA, GP_3_9_DATA, GP_3_8_DATA,
		GP_3_7_DATA, GP_3_6_DATA, GP_3_5_DATA, GP_3_4_DATA,
		GP_3_3_DATA, GP_3_2_DATA, GP_3_1_DATA, GP_3_0_DATA }
	},
	{ PINMUX_DATA_REG("INDT4", 0xE6054008, 32) {
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, GP_4_17_DATA, GP_4_16_DATA,
		GP_4_15_DATA, GP_4_14_DATA, GP_4_13_DATA, GP_4_12_DATA,
		GP_4_11_DATA, GP_4_10_DATA, GP_4_9_DATA, GP_4_8_DATA,
		GP_4_7_DATA, GP_4_6_DATA, GP_4_5_DATA, GP_4_4_DATA,
		GP_4_3_DATA, GP_4_2_DATA, GP_4_1_DATA, GP_4_0_DATA }
	},
	{ PINMUX_DATA_REG("INDT5", 0xE6055008, 32) {
		0, 0, 0, 0,
		0, 0, GP_5_25_DATA, GP_5_24_DATA,
		GP_5_23_DATA, GP_5_22_DATA, GP_5_21_DATA, GP_5_20_DATA,
		GP_5_19_DATA, GP_5_18_DATA, GP_5_17_DATA, GP_5_16_DATA,
		GP_5_15_DATA, GP_5_14_DATA, GP_5_13_DATA, GP_5_12_DATA,
		GP_5_11_DATA, GP_5_10_DATA, GP_5_9_DATA, GP_5_8_DATA,
		GP_5_7_DATA, GP_5_6_DATA, GP_5_5_DATA, GP_5_4_DATA,
		GP_5_3_DATA, GP_5_2_DATA, GP_5_1_DATA, GP_5_0_DATA }
	},
	{ PINMUX_DATA_REG("INDT6", 0xE6055408, 32) {
		GP_INDT(6) }
	},
	{ PINMUX_DATA_REG("INDT7", 0xE6055808, 32) {
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0,
		GP_7_3_DATA, GP_7_2_DATA, GP_7_1_DATA, GP_7_0_DATA }
	},
	{ },
};


static struct pinmux_info r8a7795_pinmux_info = {
	.name = "r8a7795_pfc",

	.unlock_reg = 0xe6060000, /* PMMR */

	.reserved_id = PINMUX_RESERVED,
	.data = { PINMUX_DATA_BEGIN, PINMUX_DATA_END },
	.input = { PINMUX_INPUT_BEGIN, PINMUX_INPUT_END },
	.output = { PINMUX_OUTPUT_BEGIN, PINMUX_OUTPUT_END },
	.mark = { PINMUX_MARK_BEGIN, PINMUX_MARK_END },
	.function = { PINMUX_FUNCTION_BEGIN, PINMUX_FUNCTION_END },

	.first_gpio = GPIO_GP_0_0,
	.last_gpio = GPIO_FN_FMIN_D,

	.gpios = pinmux_gpios,
	.cfg_regs = pinmux_config_regs,
	.data_regs = pinmux_data_regs,

	.gpio_data = pinmux_data,
	.gpio_data_size = ARRAY_SIZE(pinmux_data),
};

void r8a7795_pinmux_init(void)
{
	register_pinmux(&r8a7795_pinmux_info);
}
