/*
 * arch/arm/include/asm/arch-rcar_gen3/r8a7795_es-gpio.h
 *	This file defines pin function control of gpio.
 *
 * Copyright (C) 2016 Renesas Electronics Corporation
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */
#ifndef __ASM_R8A7795_ES_GPIO_H__
#define __ASM_R8A7795_ES_GPIO_H__

/* Pin Function Controller:
 * ES_GPIO_FN_xx - GPIO used to select pin function
 * ES_GPIO_GP_x_x - GPIO mapped to real I/O pin on CPU
 */
enum {
	ES_GPIO_GP_0_0, ES_GPIO_GP_0_1, ES_GPIO_GP_0_2, ES_GPIO_GP_0_3,
	ES_GPIO_GP_0_4, ES_GPIO_GP_0_5, ES_GPIO_GP_0_6, ES_GPIO_GP_0_7,
	ES_GPIO_GP_0_8, ES_GPIO_GP_0_9, ES_GPIO_GP_0_10, ES_GPIO_GP_0_11,
	ES_GPIO_GP_0_12, ES_GPIO_GP_0_13, ES_GPIO_GP_0_14, ES_GPIO_GP_0_15,

	ES_GPIO_GP_1_0, ES_GPIO_GP_1_1, ES_GPIO_GP_1_2, ES_GPIO_GP_1_3,
	ES_GPIO_GP_1_4, ES_GPIO_GP_1_5, ES_GPIO_GP_1_6, ES_GPIO_GP_1_7,
	ES_GPIO_GP_1_8, ES_GPIO_GP_1_9, ES_GPIO_GP_1_10, ES_GPIO_GP_1_11,
	ES_GPIO_GP_1_12, ES_GPIO_GP_1_13, ES_GPIO_GP_1_14, ES_GPIO_GP_1_15,
	ES_GPIO_GP_1_16, ES_GPIO_GP_1_17, ES_GPIO_GP_1_18, ES_GPIO_GP_1_19,
	ES_GPIO_GP_1_20, ES_GPIO_GP_1_21, ES_GPIO_GP_1_22, ES_GPIO_GP_1_23,
	ES_GPIO_GP_1_24, ES_GPIO_GP_1_25, ES_GPIO_GP_1_26, ES_GPIO_GP_1_27,

	ES_GPIO_GP_2_0, ES_GPIO_GP_2_1, ES_GPIO_GP_2_2, ES_GPIO_GP_2_3,
	ES_GPIO_GP_2_4, ES_GPIO_GP_2_5, ES_GPIO_GP_2_6, ES_GPIO_GP_2_7,
	ES_GPIO_GP_2_8, ES_GPIO_GP_2_9, ES_GPIO_GP_2_10, ES_GPIO_GP_2_11,
	ES_GPIO_GP_2_12, ES_GPIO_GP_2_13, ES_GPIO_GP_2_14,

	ES_GPIO_GP_3_0, ES_GPIO_GP_3_1, ES_GPIO_GP_3_2, ES_GPIO_GP_3_3,
	ES_GPIO_GP_3_4, ES_GPIO_GP_3_5, ES_GPIO_GP_3_6, ES_GPIO_GP_3_7,
	ES_GPIO_GP_3_8, ES_GPIO_GP_3_9, ES_GPIO_GP_3_10, ES_GPIO_GP_3_11,
	ES_GPIO_GP_3_12, ES_GPIO_GP_3_13, ES_GPIO_GP_3_14, ES_GPIO_GP_3_15,

	ES_GPIO_GP_4_0, ES_GPIO_GP_4_1, ES_GPIO_GP_4_2, ES_GPIO_GP_4_3,
	ES_GPIO_GP_4_4, ES_GPIO_GP_4_5, ES_GPIO_GP_4_6, ES_GPIO_GP_4_7,
	ES_GPIO_GP_4_8, ES_GPIO_GP_4_9, ES_GPIO_GP_4_10, ES_GPIO_GP_4_11,
	ES_GPIO_GP_4_12, ES_GPIO_GP_4_13, ES_GPIO_GP_4_14, ES_GPIO_GP_4_15,
	ES_GPIO_GP_4_16, ES_GPIO_GP_4_17,

	ES_GPIO_GP_5_0, ES_GPIO_GP_5_1, ES_GPIO_GP_5_2, ES_GPIO_GP_5_3,
	ES_GPIO_GP_5_4, ES_GPIO_GP_5_5, ES_GPIO_GP_5_6, ES_GPIO_GP_5_7,
	ES_GPIO_GP_5_8, ES_GPIO_GP_5_9, ES_GPIO_GP_5_10, ES_GPIO_GP_5_11,
	ES_GPIO_GP_5_12, ES_GPIO_GP_5_13, ES_GPIO_GP_5_14, ES_GPIO_GP_5_15,
	ES_GPIO_GP_5_16, ES_GPIO_GP_5_17, ES_GPIO_GP_5_18, ES_GPIO_GP_5_19,
	ES_GPIO_GP_5_20, ES_GPIO_GP_5_21, ES_GPIO_GP_5_22, ES_GPIO_GP_5_23,
	ES_GPIO_GP_5_24, ES_GPIO_GP_5_25,

	ES_GPIO_GP_6_0, ES_GPIO_GP_6_1, ES_GPIO_GP_6_2, ES_GPIO_GP_6_3,
	ES_GPIO_GP_6_4, ES_GPIO_GP_6_5, ES_GPIO_GP_6_6, ES_GPIO_GP_6_7,
	ES_GPIO_GP_6_8, ES_GPIO_GP_6_9, ES_GPIO_GP_6_10, ES_GPIO_GP_6_11,
	ES_GPIO_GP_6_12, ES_GPIO_GP_6_13, ES_GPIO_GP_6_14, ES_GPIO_GP_6_15,
	ES_GPIO_GP_6_16, ES_GPIO_GP_6_17, ES_GPIO_GP_6_18, ES_GPIO_GP_6_19,
	ES_GPIO_GP_6_20, ES_GPIO_GP_6_21, ES_GPIO_GP_6_22, ES_GPIO_GP_6_23,
	ES_GPIO_GP_6_24, ES_GPIO_GP_6_25, ES_GPIO_GP_6_26, ES_GPIO_GP_6_27,
	ES_GPIO_GP_6_28, ES_GPIO_GP_6_29, ES_GPIO_GP_6_30, ES_GPIO_GP_6_31,

	ES_GPIO_GP_7_0, ES_GPIO_GP_7_1, ES_GPIO_GP_7_2, ES_GPIO_GP_7_3,

	/* GPSR0 */
	ES_GPIO_GFN_D15,
	ES_GPIO_GFN_D14,
	ES_GPIO_GFN_D13,
	ES_GPIO_GFN_D12,
	ES_GPIO_GFN_D11,
	ES_GPIO_GFN_D10,
	ES_GPIO_GFN_D9,
	ES_GPIO_GFN_D8,
	ES_GPIO_GFN_D7,
	ES_GPIO_GFN_D6,
	ES_GPIO_GFN_D5,
	ES_GPIO_GFN_D4,
	ES_GPIO_GFN_D3,
	ES_GPIO_GFN_D2,
	ES_GPIO_GFN_D1,
	ES_GPIO_GFN_D0,

	/* GPSR1 */
	ES_GPIO_GFN_EX_WAIT0_A,
	ES_GPIO_GFN_WE1x,
	ES_GPIO_GFN_WE0x,
	ES_GPIO_GFN_RD_WRx,
	ES_GPIO_GFN_RDx,
	ES_GPIO_GFN_BSx,
	ES_GPIO_GFN_CS1x_A26,
	ES_GPIO_GFN_CS0x,
	ES_GPIO_GFN_A19,
	ES_GPIO_GFN_A18,
	ES_GPIO_GFN_A17,
	ES_GPIO_GFN_A16,
	ES_GPIO_GFN_A15,
	ES_GPIO_GFN_A14,
	ES_GPIO_GFN_A13,
	ES_GPIO_GFN_A12,
	ES_GPIO_GFN_A11,
	ES_GPIO_GFN_A10,
	ES_GPIO_GFN_A9,
	ES_GPIO_GFN_A8,
	ES_GPIO_GFN_A7,
	ES_GPIO_GFN_A6,
	ES_GPIO_GFN_A5,
	ES_GPIO_GFN_A4,
	ES_GPIO_GFN_A3,
	ES_GPIO_GFN_A2,
	ES_GPIO_GFN_A1,
	ES_GPIO_GFN_A0,

	/* GPSR2 */
	ES_GPIO_GFN_AVB_AVTP_CAPTURE_A,
	ES_GPIO_GFN_AVB_AVTP_MATCH_A,
	ES_GPIO_GFN_AVB_LINK,
	ES_GPIO_GFN_AVB_PHY_INT,
	ES_GPIO_GFN_AVB_MAGIC,
	ES_GPIO_GFN_AVB_MDC,
	ES_GPIO_GFN_PWM2_A,
	ES_GPIO_GFN_PWM1_A,
	ES_GPIO_GFN_PWM0,
	ES_GPIO_GFN_IRQ5,
	ES_GPIO_GFN_IRQ4,
	ES_GPIO_GFN_IRQ3,
	ES_GPIO_GFN_IRQ2,
	ES_GPIO_GFN_IRQ1,
	ES_GPIO_GFN_IRQ0,

	/* GPSR3 */
	ES_GPIO_GFN_SD1_WP,
	ES_GPIO_GFN_SD1_CD,
	ES_GPIO_GFN_SD0_WP,
	ES_GPIO_GFN_SD0_CD,
	ES_GPIO_GFN_SD1_DAT3,
	ES_GPIO_GFN_SD1_DAT2,
	ES_GPIO_GFN_SD1_DAT1,
	ES_GPIO_GFN_SD1_DAT0,
	ES_GPIO_GFN_SD1_CMD,
	ES_GPIO_GFN_SD1_CLK,
	ES_GPIO_GFN_SD0_DAT3,
	ES_GPIO_GFN_SD0_DAT2,
	ES_GPIO_GFN_SD0_DAT1,
	ES_GPIO_GFN_SD0_DAT0,
	ES_GPIO_GFN_SD0_CMD,
	ES_GPIO_GFN_SD0_CLK,

	/* GPSR4 */
	ES_GPIO_FN_SD3_DS,
	ES_GPIO_GFN_SD3_DAT7,
	ES_GPIO_GFN_SD3_DAT6,
	ES_GPIO_GFN_SD3_DAT5,
	ES_GPIO_GFN_SD3_DAT4,
	ES_GPIO_FN_SD3_DAT3,
	ES_GPIO_FN_SD3_DAT2,
	ES_GPIO_FN_SD3_DAT1,
	ES_GPIO_FN_SD3_DAT0,
	ES_GPIO_FN_SD3_CMD,
	ES_GPIO_FN_SD3_CLK,
	ES_GPIO_GFN_SD2_DS,
	ES_GPIO_GFN_SD2_DAT3,
	ES_GPIO_GFN_SD2_DAT2,
	ES_GPIO_GFN_SD2_DAT1,
	ES_GPIO_GFN_SD2_DAT0,
	ES_GPIO_FN_SD2_CMD,
	ES_GPIO_GFN_SD2_CLK,

	/* GPSR5 */
	ES_GPIO_GFN_MLB_DAT,
	ES_GPIO_GFN_MLB_SIG,
	ES_GPIO_GFN_MLB_CLK,
	ES_GPIO_FN_MSIOF0_RXD,
	ES_GPIO_GFN_MSIOF0_SS2,
	ES_GPIO_FN_MSIOF0_TXD,
	ES_GPIO_GFN_MSIOF0_SS1,
	ES_GPIO_GFN_MSIOF0_SYNC,
	ES_GPIO_FN_MSIOF0_SCK,
	ES_GPIO_GFN_HRTS0x,
	ES_GPIO_GFN_HCTS0x,
	ES_GPIO_GFN_HTX0,
	ES_GPIO_GFN_HRX0,
	ES_GPIO_GFN_HSCK0,
	ES_GPIO_GFN_RX2_A,
	ES_GPIO_GFN_TX2_A,
	ES_GPIO_GFN_SCK2,
	ES_GPIO_GFN_RTS1x_TANS,
	ES_GPIO_GFN_CTS1x,
	ES_GPIO_GFN_TX1_A,
	ES_GPIO_GFN_RX1_A,
	ES_GPIO_GFN_RTS0x_TANS,
	ES_GPIO_GFN_CTS0x,
	ES_GPIO_GFN_TX0,
	ES_GPIO_GFN_RX0,
	ES_GPIO_GFN_SCK0,

	/* GPSR6 */
	ES_GPIO_GFN_USB31_OVC,
	ES_GPIO_GFN_USB31_PWEN,
	ES_GPIO_GFN_USB30_OVC,
	ES_GPIO_GFN_USB30_PWEN,
	ES_GPIO_GFN_USB1_OVC,
	ES_GPIO_GFN_USB1_PWEN,
	ES_GPIO_GFN_USB0_OVC,
	ES_GPIO_GFN_USB0_PWEN,
	ES_GPIO_GFN_AUDIO_CLKB_B,
	ES_GPIO_GFN_AUDIO_CLKA_A,
	ES_GPIO_GFN_SSI_SDATA9_A,
	ES_GPIO_GFN_SSI_SDATA8,
	ES_GPIO_GFN_SSI_SDATA7,
	ES_GPIO_GFN_SSI_WS78,
	ES_GPIO_GFN_SSI_SCK78,
	ES_GPIO_GFN_SSI_SDATA6,
	ES_GPIO_GFN_SSI_WS6,
	ES_GPIO_GFN_SSI_SCK6,
	ES_GPIO_FN_SSI_SDATA5,
	ES_GPIO_FN_SSI_WS5,
	ES_GPIO_FN_SSI_SCK5,
	ES_GPIO_GFN_SSI_SDATA4,
	ES_GPIO_GFN_SSI_WS4,
	ES_GPIO_GFN_SSI_SCK4,
	ES_GPIO_GFN_SSI_SDATA3,
	ES_GPIO_GFN_SSI_WS34,
	ES_GPIO_GFN_SSI_SCK34,
	ES_GPIO_GFN_SSI_SDATA2_A,
	ES_GPIO_GFN_SSI_SDATA1_A,
	ES_GPIO_GFN_SSI_SDATA0,
	ES_GPIO_GFN_SSI_WS0129,
	ES_GPIO_GFN_SSI_SCK0129,

	/* GPSR7 */
	ES_GPIO_FN_HDMI1_CEC,
	ES_GPIO_FN_HDMI0_CEC,
	ES_GPIO_FN_AVS2,
	ES_GPIO_FN_AVS1,

	/* IPSR0 */
	ES_GPIO_IFN_AVB_MDC,
	ES_GPIO_FN_MSIOF2_SS2_C,
	ES_GPIO_IFN_AVB_MAGIC,
	ES_GPIO_FN_MSIOF2_S1_C,
	ES_GPIO_FN_SCK4_A,
	ES_GPIO_IFN_AVB_PHY_INT,
	ES_GPIO_FN_MSIOF2_SYNC_C,
	ES_GPIO_FN_RX4_A,
	ES_GPIO_IFN_AVB_LINK,
	ES_GPIO_FN_MSIOF2_SCK_C,
	ES_GPIO_FN_TX4_A,
	ES_GPIO_IFN_AVB_AVTP_MATCH_A,
	ES_GPIO_FN_MSIOF2_RXD_C,
	ES_GPIO_FN_CTS4x_A,
	ES_GPIO_IFN_AVB_AVTP_CAPTURE_A,
	ES_GPIO_FN_MSIOF2_TXD_C,
	ES_GPIO_FN_RTS4x_TANS_A,
	ES_GPIO_IFN_IRQ0,
	ES_GPIO_FN_QPOLB,
	ES_GPIO_FN_DU_CDE,
	ES_GPIO_FN_VI4_DATA0_B,
	ES_GPIO_FN_CAN0_TX_B,
	ES_GPIO_FN_CANFD0_TX_B,
	ES_GPIO_IFN_IRQ1,
	ES_GPIO_FN_QPOLA,
	ES_GPIO_FN_DU_DISP,
	ES_GPIO_FN_VI4_DATA1_B,
	ES_GPIO_FN_CAN0_RX_B,
	ES_GPIO_FN_CANFD0_RX_B,

	/* IPSR1 */
	ES_GPIO_IFN_IRQ2,
	ES_GPIO_FN_QCPV_QDE,
	ES_GPIO_FN_DU_EXODDF_DU_ODDF_DISP_CDE,
	ES_GPIO_FN_VI4_DATA2_B,
	ES_GPIO_FN_PWM3_B,
	ES_GPIO_IFN_IRQ3,
	ES_GPIO_FN_QSTVB_QVE,
	ES_GPIO_FN_A25,
	ES_GPIO_FN_DU_DOTCLKOUT1,
	ES_GPIO_FN_VI4_DATA3_B,
	ES_GPIO_FN_PWM4_B,
	ES_GPIO_IFN_IRQ4,
	ES_GPIO_FN_QSTH_QHS,
	ES_GPIO_FN_A24,
	ES_GPIO_FN_DU_EXHSYNC_DU_HSYNC,
	ES_GPIO_FN_VI4_DATA4_B,
	ES_GPIO_FN_PWM5_B,
	ES_GPIO_IFN_IRQ5,
	ES_GPIO_FN_QSTB_QHE,
	ES_GPIO_FN_A23,
	ES_GPIO_FN_DU_EXVSYNC_DU_VSYNC,
	ES_GPIO_FN_VI4_DATA5_B,
	ES_GPIO_FN_PWM6_B,
	ES_GPIO_IFN_PWM0,
	ES_GPIO_FN_AVB_AVTP_PPS,
	ES_GPIO_FN_A22,
	ES_GPIO_FN_VI4_DATA6_B,
	ES_GPIO_FN_IECLK_B,
	ES_GPIO_IFN_PWM1_A,
	ES_GPIO_FN_A21,
	ES_GPIO_FN_HRX3_D,
	ES_GPIO_FN_VI4_DATA7_B,
	ES_GPIO_FN_IERX_B,
	ES_GPIO_IFN_PWM2_A,
	ES_GPIO_FN_PWMFSW0,
	ES_GPIO_FN_A20,
	ES_GPIO_FN_HTX3_D,
	ES_GPIO_FN_IETX_B,
	ES_GPIO_IFN_A0,
	ES_GPIO_FN_LCDOUT16,
	ES_GPIO_FN_MSIOF3_SYNC_B,
	ES_GPIO_FN_VI4_DATA8,
	ES_GPIO_FN_DU_DB0,
	ES_GPIO_FN_PWM3_A,

	/* IPSR2 */
	ES_GPIO_IFN_A1,
	ES_GPIO_FN_LCDOUT17,
	ES_GPIO_FN_MSIOF3_TXD_B,
	ES_GPIO_FN_VI4_DATA9,
	ES_GPIO_FN_DU_DB1,
	ES_GPIO_FN_PWM4_A,
	ES_GPIO_IFN_A2,
	ES_GPIO_FN_LCDOUT18,
	ES_GPIO_FN_MSIOF3_SCK_B,
	ES_GPIO_FN_VI4_DATA10,
	ES_GPIO_FN_DU_DB2,
	ES_GPIO_FN_PWM5_A,
	ES_GPIO_IFN_A3,
	ES_GPIO_FN_LCDOUT19,
	ES_GPIO_FN_MSIOF3_RXD_B,
	ES_GPIO_FN_VI4_DATA11,
	ES_GPIO_FN_DU_DB3,
	ES_GPIO_FN_PWM6_A,
	ES_GPIO_IFN_A4,
	ES_GPIO_FN_LCDOUT20,
	ES_GPIO_FN_MSIOF3_SS1_B,
	ES_GPIO_FN_VI4_DATA12,
	ES_GPIO_FN_VI5_DATA12,
	ES_GPIO_FN_DU_DB4,
	ES_GPIO_IFN_A5,
	ES_GPIO_FN_LCDOUT21,
	ES_GPIO_FN_MSIOF3_SS2_B,
	ES_GPIO_FN_SCK4_B,
	ES_GPIO_FN_VI4_DATA13,
	ES_GPIO_FN_VI5_DATA13,
	ES_GPIO_FN_DU_DB5,
	ES_GPIO_IFN_A6,
	ES_GPIO_FN_LCDOUT22,
	ES_GPIO_FN_MSIOF2_SS1_A,
	ES_GPIO_FN_RX4_B,
	ES_GPIO_FN_VI4_DATA14,
	ES_GPIO_FN_VI5_DATA14,
	ES_GPIO_FN_DU_DB6,
	ES_GPIO_IFN_A7,
	ES_GPIO_FN_LCDOUT23,
	ES_GPIO_FN_MSIOF2_SS2_A,
	ES_GPIO_FN_TX4_B,
	ES_GPIO_FN_VI4_DATA15,
	ES_GPIO_FN_V15_DATA15,
	ES_GPIO_FN_DU_DB7,
	ES_GPIO_IFN_A8,
	ES_GPIO_FN_RX3_B,
	ES_GPIO_FN_MSIOF2_SYNC_A,
	ES_GPIO_FN_HRX4_B,
	ES_GPIO_FN_SDA6_A,
	ES_GPIO_FN_AVB_AVTP_MATCH_B,
	ES_GPIO_FN_PWM1_B,

	/* IPSR3 */
	ES_GPIO_IFN_A9,
	ES_GPIO_FN_MSIOF2_SCK_A,
	ES_GPIO_FN_CTS4x_B,
	ES_GPIO_FN_VI5_VSYNCx,
	ES_GPIO_IFN_A10,
	ES_GPIO_FN_MSIOF2_RXD_A,
	ES_GPIO_FN_RTS4n_TANS_B,
	ES_GPIO_FN_VI5_HSYNCx,
	ES_GPIO_IFN_A11,
	ES_GPIO_FN_TX3_B,
	ES_GPIO_FN_MSIOF2_TXD_A,
	ES_GPIO_FN_HTX4_B,
	ES_GPIO_FN_HSCK4,
	ES_GPIO_FN_VI5_FIELD,
	ES_GPIO_FN_SCL6_A,
	ES_GPIO_FN_AVB_AVTP_CAPTURE_B,
	ES_GPIO_FN_PWM2_B,
	ES_GPIO_FN_SPV_EVEN,
	ES_GPIO_IFN_A12,
	ES_GPIO_FN_LCDOUT12,
	ES_GPIO_FN_MSIOF3_SCK_C,
	ES_GPIO_FN_HRX4_A,
	ES_GPIO_FN_VI5_DATA8,
	ES_GPIO_FN_DU_DG4,
	ES_GPIO_IFN_A13,
	ES_GPIO_FN_LCDOUT13,
	ES_GPIO_FN_MSIOF3_SYNC_C,
	ES_GPIO_FN_HTX4_A,
	ES_GPIO_FN_VI5_DATA9,
	ES_GPIO_FN_DU_DG5,
	ES_GPIO_IFN_A14,
	ES_GPIO_FN_LCDOUT14,
	ES_GPIO_FN_MSIOF3_RXD_C,
	ES_GPIO_FN_HCTS4x,
	ES_GPIO_FN_VI5_DATA10,
	ES_GPIO_FN_DU_DG6,
	ES_GPIO_IFN_A15,
	ES_GPIO_FN_LCDOUT15,
	ES_GPIO_FN_MSIOF3_TXD_C,
	ES_GPIO_FN_HRTS4x,
	ES_GPIO_FN_VI5_DATA11,
	ES_GPIO_FN_DU_DG7,
	ES_GPIO_IFN_A16,
	ES_GPIO_FN_LCDOUT8,
	ES_GPIO_FN_VI4_FIELD,
	ES_GPIO_FN_DU_DG0,

	/* IPSR4 */
	ES_GPIO_IFN_A17,
	ES_GPIO_FN_LCDOUT9,
	ES_GPIO_FN_VI4_VSYNCx,
	ES_GPIO_FN_DU_DG1,
	ES_GPIO_IFN_A18,
	ES_GPIO_FN_LCDOUT10,
	ES_GPIO_FN_VI4_HSYNCx,
	ES_GPIO_FN_DU_DG2,
	ES_GPIO_IFN_A19,
	ES_GPIO_FN_LCDOUT11,
	ES_GPIO_FN_VI4_CLKENB,
	ES_GPIO_FN_DU_DG3,
	ES_GPIO_IFN_CS0x,
	ES_GPIO_FN_VI5_CLKENB,
	ES_GPIO_IFN_CS1x_A26,
	ES_GPIO_FN_VI5_CLK,
	ES_GPIO_FN_EX_WAIT0_B,
	ES_GPIO_IFN_BSx,
	ES_GPIO_FN_QSTVA_QVS,
	ES_GPIO_FN_MSIOF3_SCK_D,
	ES_GPIO_FN_SCK3,
	ES_GPIO_FN_HSCK3,
	ES_GPIO_FN_CAN1_TX,
	ES_GPIO_FN_CANFD1_TX,
	ES_GPIO_FN_IETX_A,
	ES_GPIO_IFN_RDx,
	ES_GPIO_FN_MSIOF3_SYNC_D,
	ES_GPIO_FN_RX3_A,
	ES_GPIO_FN_HRX3_A,
	ES_GPIO_FN_CAN0_TX_A,
	ES_GPIO_FN_CANFD0_TX_A,
	ES_GPIO_IFN_RD_WRx,
	ES_GPIO_FN_MSIOF3_RXD_D,
	ES_GPIO_FN_TX3_A,
	ES_GPIO_FN_HTX3_A,
	ES_GPIO_FN_CAN0_RX_A,
	ES_GPIO_FN_CANFD0_RX_A,

	/* IPSR5 */
	ES_GPIO_IFN_WE0x,
	ES_GPIO_FN_MSIIOF3_TXD_D,
	ES_GPIO_FN_CTS3x,
	ES_GPIO_FN_HCTS3x,
	ES_GPIO_FN_SCL6_B,
	ES_GPIO_FN_CAN_CLK,
	ES_GPIO_FN_IECLK_A,
	ES_GPIO_IFN_WE1x,
	ES_GPIO_FN_MSIOF3_SS1_D,
	ES_GPIO_FN_RTS3x_TANS,
	ES_GPIO_FN_HRTS3x,
	ES_GPIO_FN_SDA6_B,
	ES_GPIO_FN_CAN1_RX,
	ES_GPIO_FN_CANFD1_RX,
	ES_GPIO_FN_IERX_A,
	ES_GPIO_IFN_EX_WAIT0_A,
	ES_GPIO_FN_QCLK,
	ES_GPIO_FN_VI4_CLK,
	ES_GPIO_FN_DU_DOTCLKOUT0,
	ES_GPIO_IFN_D0,
	ES_GPIO_FN_MSIOF2_SS1_B,
	ES_GPIO_FN_MSIOF3_SCK_A,
	ES_GPIO_FN_VI4_DATA16,
	ES_GPIO_FN_VI5_DATA0,
	ES_GPIO_IFN_D1,
	ES_GPIO_FN_MSIOF2_SS2_B,
	ES_GPIO_FN_MSIOF3_SYNC_A,
	ES_GPIO_FN_VI4_DATA17,
	ES_GPIO_FN_VI5_DATA1,
	ES_GPIO_IFN_D2,
	ES_GPIO_FN_MSIOF3_RXD_A,
	ES_GPIO_FN_VI4_DATA18,
	ES_GPIO_FN_VI5_DATA2,
	ES_GPIO_IFN_D3,
	ES_GPIO_FN_MSIOF3_TXD_A,
	ES_GPIO_FN_VI4_DATA19,
	ES_GPIO_FN_VI5_DATA3,
	ES_GPIO_IFN_D4,
	ES_GPIO_FN_MSIOF2_SCK_B,
	ES_GPIO_FN_VI4_DATA20,
	ES_GPIO_FN_VI5_DATA4,

	/* IPSR6 */
	ES_GPIO_IFN_D5,
	ES_GPIO_FN_MSIOF2_SYNC_B,
	ES_GPIO_FN_VI4_DATA21,
	ES_GPIO_FN_VI5_DATA5,
	ES_GPIO_IFN_D6,
	ES_GPIO_FN_MSIOF2_RXD_B,
	ES_GPIO_FN_VI4_DATA22,
	ES_GPIO_FN_VI5_DATA6,
	ES_GPIO_IFN_D7,
	ES_GPIO_FN_MSIOF2_TXD_B,
	ES_GPIO_FN_VI4_DATA23,
	ES_GPIO_FN_VI5_DATA7,
	ES_GPIO_IFN_D8,
	ES_GPIO_FN_LCDOUT0,
	ES_GPIO_FN_MSIOF2_SCK_D,
	ES_GPIO_FN_SCK4_C,
	ES_GPIO_FN_VI4_DATA0_A,
	ES_GPIO_FN_DU_DR0,
	ES_GPIO_IFN_D9,
	ES_GPIO_FN_LCDOUT1,
	ES_GPIO_FN_MSIOF2_SYNC_D,
	ES_GPIO_FN_VI4_DATA1_A,
	ES_GPIO_FN_DU_DR1,
	ES_GPIO_IFN_D10,
	ES_GPIO_FN_LCDOUT2,
	ES_GPIO_FN_MSIOF2_RXD_D,
	ES_GPIO_FN_HRX3_B,
	ES_GPIO_FN_VI4_DATA2_A,
	ES_GPIO_FN_CTS4x_C,
	ES_GPIO_FN_DU_DR2,
	ES_GPIO_IFN_D11,
	ES_GPIO_FN_LCDOUT3,
	ES_GPIO_FN_MSIOF2_TXD_D,
	ES_GPIO_FN_HTX3_B,
	ES_GPIO_FN_VI4_DATA3_A,
	ES_GPIO_FN_RTS4x_TANS_C,
	ES_GPIO_FN_DU_DR3,
	ES_GPIO_IFN_D12,
	ES_GPIO_FN_LCDOUT4,
	ES_GPIO_FN_MSIOF2_SS1_D,
	ES_GPIO_FN_RX4_C,
	ES_GPIO_FN_VI4_DATA4_A,
	ES_GPIO_FN_DU_DR4,

	/* IPSR7 */
	ES_GPIO_IFN_D13,
	ES_GPIO_FN_LCDOUT5,
	ES_GPIO_FN_MSIOF2_SS2_D,
	ES_GPIO_FN_TX4_C,
	ES_GPIO_FN_VI4_DATA5_A,
	ES_GPIO_FN_DU_DR5,
	ES_GPIO_IFN_D14,
	ES_GPIO_FN_LCDOUT6,
	ES_GPIO_FN_MSIOF3_SS1_A,
	ES_GPIO_FN_HRX3_C,
	ES_GPIO_FN_VI4_DATA6_A,
	ES_GPIO_FN_DU_DR6,
	ES_GPIO_FN_SCL6_C,
	ES_GPIO_IFN_D15,
	ES_GPIO_FN_LCDOUT7,
	ES_GPIO_FN_MSIOF3_SS2_A,
	ES_GPIO_FN_HTX3_C,
	ES_GPIO_FN_VI4_DATA7_A,
	ES_GPIO_FN_DU_DR7,
	ES_GPIO_FN_SDA6_C,
	ES_GPIO_FN_FSCLKST,
	ES_GPIO_IFN_SD0_CLK,
	ES_GPIO_FN_MSIOF1_SCK_E,
	ES_GPIO_FN_STP_OPWM_0_B,
	ES_GPIO_IFN_SD0_CMD,
	ES_GPIO_FN_MSIOF1_SYNC_E,
	ES_GPIO_FN_STP_IVCXO27_0_B,
	ES_GPIO_IFN_SD0_DAT0,
	ES_GPIO_FN_MSIOF1_RXD_E,
	ES_GPIO_FN_TS_SCK0_B,
	ES_GPIO_FN_STP_ISCLK_0_B,
	ES_GPIO_IFN_SD0_DAT1,
	ES_GPIO_FN_MSIOF1_TXD_E,
	ES_GPIO_FN_TS_SPSYNC0_B,
	ES_GPIO_FN_STP_ISSYNC_0_B,

	/* IPSR8 */
	ES_GPIO_IFN_SD0_DAT2,
	ES_GPIO_FN_MSIOF1_SS1_E,
	ES_GPIO_FN_TS_SDAT0_B,
	ES_GPIO_FN_STP_ISD_0_B,
	ES_GPIO_IFN_SD0_DAT3,
	ES_GPIO_FN_MSIOF1_SS2_E,
	ES_GPIO_FN_TS_SDEN0_B,
	ES_GPIO_FN_STP_ISEN_0_B,
	ES_GPIO_IFN_SD1_CLK,
	ES_GPIO_FN_MSIOF1_SCK_G,
	ES_GPIO_FN_SIM0_CLK_A,

	ES_GPIO_IFN_SD1_CMD,
	ES_GPIO_FN_MSIOF1_SYNC_G,
	ES_GPIO_FN_SIM0_D_A,
	ES_GPIO_FN_STP_IVCXO27_1_B,

	ES_GPIO_IFN_SD1_DAT0,
	ES_GPIO_FN_SD2_DAT4,
	ES_GPIO_FN_MSIOF1_RXD_G,
	ES_GPIO_FN_TS_SCK1_B,
	ES_GPIO_FN_STP_ISCLK_1_B,

	ES_GPIO_IFN_SD1_DAT1,
	ES_GPIO_FN_SD2_DAT5,
	ES_GPIO_FN_MSIOF1_TXD_G,
	ES_GPIO_FN_TS_SPSYNC1_B,
	ES_GPIO_FN_STP_ISSYNC_1_B,

	ES_GPIO_IFN_SD1_DAT2,
	ES_GPIO_FN_SD2_DAT6,
	ES_GPIO_FN_MSIOF1_SS1_G,
	ES_GPIO_FN_TS_SDAT1_B,
	ES_GPIO_FN_STP_IOD_1_B,
	ES_GPIO_IFN_SD1_DAT3,
	ES_GPIO_FN_SD2_DAT7,
	ES_GPIO_FN_MSIOF1_SS2_G,
	ES_GPIO_FN_TS_SDEN1_B,
	ES_GPIO_FN_STP_ISEN_1_B,

	/* IPSR9 */
	ES_GPIO_IFN_SD2_CLK,
	ES_GPIO_FN_SCKZ_A,
	ES_GPIO_IFN_SD2_DAT0,
	ES_GPIO_FN_MTSx_A,
	ES_GPIO_IFN_SD2_DAT1,
	ES_GPIO_FN_STMx_A,
	ES_GPIO_IFN_SD2_DAT2,
	ES_GPIO_FN_MDATA_A,
	ES_GPIO_IFN_SD2_DAT3,
	ES_GPIO_FN_SDATA_A,
	ES_GPIO_IFN_SD2_DS,
	ES_GPIO_FN_SATA_DEVSLP_B,
	ES_GPIO_FN_VSP_A,
	ES_GPIO_IFN_SD3_DAT4,
	ES_GPIO_FN_SD2_CD_A,
	ES_GPIO_IFN_SD3_DAT5,
	ES_GPIO_FN_SD2_WP_A,

	/* IPSR10 */
	ES_GPIO_IFN_SD3_DAT6,
	ES_GPIO_FN_SD3_CD,
	ES_GPIO_IFN_SD3_DAT7,
	ES_GPIO_FN_SD3_WP,
	ES_GPIO_IFN_SD0_CD,
	ES_GPIO_FN_SCL2_B,
	ES_GPIO_FN_SIM0_RST_A,
	ES_GPIO_IFN_SD0_WP,
	ES_GPIO_FN_SDA2_B,
	ES_GPIO_IFN_SD1_CD,
	ES_GPIO_FN_SIM0_CLK_B,
	ES_GPIO_IFN_SD1_WP,
	ES_GPIO_FN_SIM0_D_B,
	ES_GPIO_IFN_SCK0,
	ES_GPIO_FN_HSCK1_B,
	ES_GPIO_FN_MSIOF1_SS2_B,
	ES_GPIO_FN_AUDIO_CLKC_B,
	ES_GPIO_FN_SDA2_A,
	ES_GPIO_FN_SIM0_RST_B,
	ES_GPIO_FN_STP_OPWM__C,
	ES_GPIO_FN_RIF0_CLK_B,
	ES_GPIO_FN_ADICHS2,
	ES_GPIO_IFN_RX0,
	ES_GPIO_FN_HRX1_B,
	ES_GPIO_FN_TS_SCK0_C,
	ES_GPIO_FN_STP_ISCLK_0_C,
	ES_GPIO_FN_RIF0_D0_B,

	/* IPSR11 */
	ES_GPIO_IFN_TX0,
	ES_GPIO_FN_HTX1_B,
	ES_GPIO_FN_TS_SPSYNC0_C,
	ES_GPIO_FN_STP_ISSYNC_0_C,
	ES_GPIO_FN_RIF0_D1_B,
	ES_GPIO_IFN_CTS0x,
	ES_GPIO_FN_HCTS1x_B,
	ES_GPIO_FN_MSIOF1_SYNC_B,
	ES_GPIO_FN_TS_SPSYNC1_C,
	ES_GPIO_FN_STP_ISSYNC_1_C,
	ES_GPIO_FN_RIF1_SYNC_B,
	ES_GPIO_FN_AUDIO_CLKOUT_C,
	ES_GPIO_FN_ADICS_SAMP,
	ES_GPIO_IFN_RTS0x_TANS,
	ES_GPIO_FN_HRTS1x_B,
	ES_GPIO_FN_MSIOF1_SS1_B,
	ES_GPIO_FN_AUDIO_CLKA_B,
	ES_GPIO_FN_SCL2_A,
	ES_GPIO_FN_STP_IVCXO27_1_C,
	ES_GPIO_FN_RIF0_SYNC_B,
	ES_GPIO_FN_ADICHS1,
	ES_GPIO_IFN_RX1_A,
	ES_GPIO_FN_HRX1_A,
	ES_GPIO_FN_TS_SDAT0_C,
	ES_GPIO_FN_STP_IDS_0_C,
	ES_GPIO_FN_RIF1_CLK_C,
	ES_GPIO_IFN_TX1_A,
	ES_GPIO_FN_HTX1_A,
	ES_GPIO_FN_TS_SDEN0_C,
	ES_GPIO_FN_STP_ISEN_0_C,
	ES_GPIO_FN_RIF1_D0_C,
	ES_GPIO_IFN_CTS1x,
	ES_GPIO_FN_HCTS1x_A,
	ES_GPIO_FN_MSIOF1_RXD_B,
	ES_GPIO_FN_TS_SDEN1_C,
	ES_GPIO_FN_STP_ISEN_1_C,
	ES_GPIO_FN_RIF1_D0_B,
	ES_GPIO_FN_ADIDATA,
	ES_GPIO_IFN_RTS1x_TANS,
	ES_GPIO_FN_HRTS1x_A,
	ES_GPIO_FN_MSIOF1_TXD_B,
	ES_GPIO_FN_TS_SDAT1_C,
	ES_GPIO_FN_STP_ISD_1_C,
	ES_GPIO_FN_RIF1_D1_B,
	ES_GPIO_FN_ADICHS0,
	ES_GPIO_IFN_SCK2,
	ES_GPIO_FN_SCIF_CLK_B,
	ES_GPIO_FN_MSIOF1_SCK_B,
	ES_GPIO_FN_TS_SCK1_C,
	ES_GPIO_FN_STP_ISCLK_1_C,
	ES_GPIO_FN_RIF1_CLK_B,
	ES_GPIO_FN_ADICLK,

	/* IPSR12 */
	ES_GPIO_IFN_TX2_A,
	ES_GPIO_FN_SD2_CD_B,
	ES_GPIO_FN_SCL1_A,
	ES_GPIO_FN_RSD_CLK_B,
	ES_GPIO_FN_FMCLK_A,
	ES_GPIO_FN_RIF1_D1_C,
	ES_GPIO_FN_FSO_CFE_0_B,
	ES_GPIO_IFN_RX2_A,
	ES_GPIO_FN_SD2_WP_B,
	ES_GPIO_FN_SDA1_A,
	ES_GPIO_FN_RDS_DATA_B,
	ES_GPIO_FN_RMIN_A,
	ES_GPIO_FN_RIF1_SYNC_C,
	ES_GPIO_FN_FSO_CEF_1_B,
	ES_GPIO_IFN_HSCK0,
	ES_GPIO_FN_MSIOF1_SCK_D,
	ES_GPIO_FN_AUDIO_CLKB_A,
	ES_GPIO_FN_SSI_SDATA1_B,
	ES_GPIO_FN_TS_SCK0_D,
	ES_GPIO_FN_STP_ISCLK_0_D,
	ES_GPIO_FN_RIF0_CLK_C,
	ES_GPIO_FN_AD_CLK,
	ES_GPIO_IFN_HRX0,
	ES_GPIO_FN_MSIOF1_RXD_D,
	ES_GPIO_FN_SS1_SDATA2_B,
	ES_GPIO_FN_TS_SDEN0_D,
	ES_GPIO_FN_STP_ISEN_0_D,
	ES_GPIO_FN_RIF0_D0_C,
	ES_GPIO_FN_AD_DI,
	ES_GPIO_IFN_HTX0,
	ES_GPIO_FN_MSIOF1_TXD_D,
	ES_GPIO_FN_SSI_SDATA9_B,
	ES_GPIO_FN_TS_SDAT0_D,
	ES_GPIO_FN_STP_ISD_0_D,
	ES_GPIO_FN_RIF0_D1_C,
	ES_GPIO_FN_AD_DO,
	ES_GPIO_IFN_HCTS0x,
	ES_GPIO_FN_RX2_B,
	ES_GPIO_FN_MSIOF1_SYNC_D,
	ES_GPIO_FN_SSI_SCK9_A,
	ES_GPIO_FN_TS_SPSYNC0_D,
	ES_GPIO_FN_STP_ISSYNC_0_D,
	ES_GPIO_FN_RIF0_SYNC_C,
	ES_GPIO_FN_AUDIO_CLKOUT1_A,
	ES_GPIO_FN_AD_NSCx,
	ES_GPIO_IFN_HRTS0x,
	ES_GPIO_FN_TX2_B,
	ES_GPIO_FN_MSIOF1_SS1_D,
	ES_GPIO_FN_SSI_WS9_A,
	ES_GPIO_FN_STP_IVCXO27_0_D,
	ES_GPIO_FN_BPFCLK_A,
	ES_GPIO_FN_AUDIO_CLKOUT2_A,
	ES_GPIO_IFN_MSIOF0_SYNC,
	ES_GPIO_FN_AUDIO_CLKOUT_A,

	/* IPSR13 */
	ES_GPIO_IFN_MSIOF0_SS1,
	ES_GPIO_FN_RX5,
	ES_GPIO_FN_AUDIO_CLKA_C,
	ES_GPIO_FN_SSI_SCK2_A,
	ES_GPIO_FN_RDS_CLK_A,
	ES_GPIO_FN_STP_IVCXO27_0_C,
	ES_GPIO_FN_AUDIO_CLKOUT3_A,
	ES_GPIO_FN_TCLK1_B,
	ES_GPIO_IFN_MSIOF0_SS2,
	ES_GPIO_FN_TX5,
	ES_GPIO_FN_MSIOF1_SS2_D,
	ES_GPIO_FN_AUDIO_CLKC_A,
	ES_GPIO_FN_SSI_WS2_A,
	ES_GPIO_FN_RDS_DATA_A,
	ES_GPIO_FN_STP_OPWM_0_D,
	ES_GPIO_FN_AUDIO_CLKOUT_D,
	ES_GPIO_FN_SPEEDIN_B,
	ES_GPIO_IFN_MLB_CLK,
	ES_GPIO_FN_MSIOF1_SCK_F,
	ES_GPIO_FN_SCL1_B,
	ES_GPIO_IFN_MLB_SIG,
	ES_GPIO_FN_RX1_B,
	ES_GPIO_FN_MSIOF1_SYNC_F,
	ES_GPIO_FN_SDA1_B,
	ES_GPIO_IFN_MLB_DAT,
	ES_GPIO_FN_TX1_B,
	ES_GPIO_FN_MSIOF1_RXD_F,
	ES_GPIO_IFN_SSI_SCK0129,
	ES_GPIO_FN_MSIOF1_TXD_F,
	ES_GPIO_FN_MOUT0,
	ES_GPIO_IFN_SSI_WS0129,
	ES_GPIO_FN_MSIOF1_SS1_F,
	ES_GPIO_FN_MOUT1,
	ES_GPIO_IFN_SSI_SDATA0,
	ES_GPIO_FN_MSIOF1_SS2_F,
	ES_GPIO_FN_MOUT2,

	/* IPSR14 */
	ES_GPIO_IFN_SSI_SDATA1_A,
	ES_GPIO_FN_MOUT5,
	ES_GPIO_IFN_SSI_SDATA2_A,
	ES_GPIO_FN_SSI_SCK1_B,
	ES_GPIO_FN_MOUT6,
	ES_GPIO_IFN_SSI_SCK34,
	ES_GPIO_FN_MSIOF1_SS1_A,
	ES_GPIO_FN_STP_OPWM_0_A,
	ES_GPIO_IFN_SSI_WS34,
	ES_GPIO_FN_HCTS2x_A,
	ES_GPIO_FN_MSIOF1_SS2_A,
	ES_GPIO_FN_STP_IVCXO27_0_A,
	ES_GPIO_IFN_SSI_SDATA3,
	ES_GPIO_FN_HRTS2x_A,
	ES_GPIO_FN_MSIOF1_TXD_A,
	ES_GPIO_FN_TS_SCK0_A,
	ES_GPIO_FN_STP_ISCLK_0_A,
	ES_GPIO_FN_RIF0_D1_A,
	ES_GPIO_FN_RIF2_D0_A,
	ES_GPIO_IFN_SSI_SCK4,
	ES_GPIO_FN_HRX2_A,
	ES_GPIO_FN_MSIOF1_SCK_A,
	ES_GPIO_FN_TS_SDAT0_A,
	ES_GPIO_FN_STP_ISD_0_A,
	ES_GPIO_FN_RIF0_CLK_A,
	ES_GPIO_FN_RIF2_CLK_A,
	ES_GPIO_IFN_SSI_WS4,
	ES_GPIO_FN_HTX2_A,
	ES_GPIO_FN_MSIOF1_SYNC_A,
	ES_GPIO_FN_TS_SDEN0_A,
	ES_GPIO_FN_STP_ISEN_0_A,
	ES_GPIO_FN_RIF0_SYNC_A,
	ES_GPIO_FN_RIF2_SYNC_A,
	ES_GPIO_IFN_SSI_SDATA4,
	ES_GPIO_FN_HSCK2_A,
	ES_GPIO_FN_MSIOF1_RXD_A,
	ES_GPIO_FN_TS_SPSYNC0_A,
	ES_GPIO_FN_STP_ISSYNC_0_A,
	ES_GPIO_FN_RIF0_D0_A,
	ES_GPIO_FN_RIF2_D1_A,

	/* IPSR15 */
	ES_GPIO_IFN_SSI_SCK6,
	ES_GPIO_FN_USB2_PWEN,
	ES_GPIO_FN_SIM0_RST_D,
	ES_GPIO_FN_RDS_CLK_C,
	ES_GPIO_IFN_SSI_WS6,
	ES_GPIO_FN_USB2_OVC,
	ES_GPIO_FN_SIM0_D_D,
	ES_GPIO_IFN_SSI_SDATA6,
	ES_GPIO_FN_SIM0_CLK_D,
	ES_GPIO_FN_RSD_DATA_C,
	ES_GPIO_FN_SATA_DEVSLP_A,
	ES_GPIO_IFN_SSI_SCK78,
	ES_GPIO_FN_HRX2_B,
	ES_GPIO_FN_MSIOF1_SCK_C,
	ES_GPIO_FN_TS_SCK1_A,
	ES_GPIO_FN_STP_ISCLK_1_A,
	ES_GPIO_FN_RIF1_CLK_A,
	ES_GPIO_FN_RIF3_CLK_A,
	ES_GPIO_IFN_SSI_WS78,
	ES_GPIO_FN_HTX2_B,
	ES_GPIO_FN_MSIOF1_SYNC_C,
	ES_GPIO_FN_TS_SDT1_A,
	ES_GPIO_FN_STP_ISD_1_A,
	ES_GPIO_FN_RIF1_SYNC_A,
	ES_GPIO_FN_RIF3_SYNC_A,
	ES_GPIO_IFN_SSI_SDATA7,
	ES_GPIO_FN_HCTS2x_B,
	ES_GPIO_FN_MSIOF1_RXD_C,
	ES_GPIO_FN_TS_SDEN1_A,
	ES_GPIO_FN_STP_IEN_1_A,
	ES_GPIO_FN_RIF1_D0_A,
	ES_GPIO_FN_RIF3_D0_A,
	ES_GPIO_FN_TCLK2_A,
	ES_GPIO_IFN_SSI_SDATA8,
	ES_GPIO_FN_HRTS2x_B,
	ES_GPIO_FN_MSIOF1_TXD_C,
	ES_GPIO_FN_TS_SPSYNC1_A,
	ES_GPIO_FN_STP_ISSYNC_1_A,
	ES_GPIO_FN_RIF1_D1_A,
	ES_GPIO_FN_EIF3_D1_A,
	ES_GPIO_IFN_SSI_SDATA9_A,
	ES_GPIO_FN_HSCK2_B,
	ES_GPIO_FN_MSIOF1_SS1_C,
	ES_GPIO_FN_HSCK1_A,
	ES_GPIO_FN_SSI_WS1_B,
	ES_GPIO_FN_SCK1,
	ES_GPIO_FN_STP_IVCXO27_1_A,
	ES_GPIO_FN_SCK5,

	/* IPSR16 */
	ES_GPIO_IFN_AUDIO_CLKA_A,
	ES_GPIO_FN_CC5_OSCOUT,
	ES_GPIO_IFN_AUDIO_CLKB_B,
	ES_GPIO_FN_SCIF_CLK_A,
	ES_GPIO_FN_DVC_MUTE,
	ES_GPIO_FN_STP_IVCXO27_1_D,
	ES_GPIO_FN_REMOCON_A,
	ES_GPIO_FN_TCLK1_A,
	ES_GPIO_FN_VSP_B,
	ES_GPIO_IFN_USB0_PWEN,
	ES_GPIO_FN_SIM0_RST_C,
	ES_GPIO_FN_TS_SCK1_D,
	ES_GPIO_FN_STP_ISCLK_1_D,
	ES_GPIO_FN_BPFCLK_B,
	ES_GPIO_FN_RIF3_CLK_B,
	ES_GPIO_FN_SCKZ_B,
	ES_GPIO_IFN_USB0_OVC,
	ES_GPIO_FN_SIM0_D_C,
	ES_GPIO_FN_TS_SDAT1_D,
	ES_GPIO_FN_STP_ISD_1_D,
	ES_GPIO_FN_RIF3_SYNC_B,
	ES_GPIO_FN_VSP_C,
	ES_GPIO_IFN_USB1_PWEN,
	ES_GPIO_FN_SIM0_CLK_C,
	ES_GPIO_FN_SSI_SCK1_A,
	ES_GPIO_FN_TS_SCK0_E,
	ES_GPIO_FN_STP_ISCLK_0_E,
	ES_GPIO_FN_FMCLK_B,
	ES_GPIO_FN_RIF2_CLK_B,
	ES_GPIO_FN_MTSx_B,
	ES_GPIO_FN_SPEEDIN_A,
	ES_GPIO_FN_VSP_D,
	ES_GPIO_IFN_USB1_OVC,
	ES_GPIO_FN_MSIOF1_SS2_C,
	ES_GPIO_FN_SSI_WS1_A,
	ES_GPIO_FN_TS_SDAT0_E,
	ES_GPIO_FN_STP_ISD_0_E,
	ES_GPIO_FN_FMIN_B,
	ES_GPIO_FN_RIF2_SYNC_B,
	ES_GPIO_FN_STMx_B,
	ES_GPIO_FN_REMOCON_B,
	ES_GPIO_IFN_USB30_PWEN,
	ES_GPIO_FN_AUDIO_CLKOUT_B,
	ES_GPIO_FN_SSI_SCK2_B,
	ES_GPIO_FN_TS_SDEN1_D,
	ES_GPIO_FN_STP_ISEN_1_D,
	ES_GPIO_FN_STP_OPWM_0_E,
	ES_GPIO_FN_RIF3_D0_B,
	ES_GPIO_FN_MDATA_B,
	ES_GPIO_FN_TCLK2_B,
	ES_GPIO_FN_TPU0TO0,
	ES_GPIO_IFN_USB30_OVC,
	ES_GPIO_FN_AUDIO_CLKOUT1_B,
	ES_GPIO_FN_SSI_WS2_B,
	ES_GPIO_FN_TS_SPSYNC1_D,
	ES_GPIO_FN_STP_ISSYNC_1_D,
	ES_GPIO_FN_STP_IVCXO27_0_E,
	ES_GPIO_FN_RIF3_D1_B,
	ES_GPIO_FN_SDATA_B,
	ES_GPIO_FN_RSO_TOE_B,
	ES_GPIO_FN_TPU0TO1,

	/* IPSR17 */
	ES_GPIO_IFN_USB31_PWEN,
	ES_GPIO_FN_AUDIO_CLKOUT2_B,
	ES_GPIO_FN_SI_SCK9_B,
	ES_GPIO_FN_TS_SDEN0_E,
	ES_GPIO_FN_STP_ISEN_0_E,
	ES_GPIO_FN_RIF2_D0_B,
	ES_GPIO_FN_TPU0TO2,
	ES_GPIO_IFN_USB31_OVC,
	ES_GPIO_FN_AUDIO_CLKOUT3_B,
	ES_GPIO_FN_SSI_WS9_B,
	ES_GPIO_FN_TS_SPSYNC0_E,
	ES_GPIO_FN_STP_ISSYNC_0_E,
	ES_GPIO_FN_RIF2_D1_B,
	ES_GPIO_FN_TPU0TO3,
};

#endif /* __ASM_R8A7795_ES_GPIO_H__ */
