/*************************************************************************/ /*!
@Title          Poulsbo Display kernel driver register macros
@Copyright      Copyright (c) Imagination Technologies Ltd. All Rights Reserved
@Description    Poulsbo Display kernel driver register macros
@License        Dual MIT/GPLv2

The contents of this file are subject to the MIT license as set out below.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

Alternatively, the contents of this file may be used under the terms of
the GNU General Public License Version 2 ("GPL") in which case the provisions
of GPL are applicable instead of those above.

If you wish to allow use of your version of this file only under the terms of
GPL, and not to allow others to use your version of this file under the terms
of the MIT license, indicate your decision by deleting the provisions above
and replace them with the notice and other provisions required by GPL as set
out in the file called "GPL-COPYING" included in this distribution. If you do
not delete the provisions above, a recipient may use your version of this file
under the terms of either the MIT license or GPL.

This License is also included in this distribution in the file called
"MIT-COPYING".

EXCEPT AS OTHERWISE STATED IN A NEGOTIATED AGREEMENT: (A) THE SOFTWARE IS
PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT; AND (B) IN NO EVENT SHALL THE AUTHORS OR
COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/ /**************************************************************************/

#if !defined(__POULSBO_REGS_H__)
#define __POULSBO_REGS_H__

/* Device register macros */
#define PVRPSB_PGTBL_CTL			(0x02020)

#define PVRPSB_PGTBL_CTL_ENABLE_SHIFT		(0)
#define PVRPSB_PGTBL_CTL_ENABLE_MASK		(0x00000001)
#define PVRPSB_PGTBL_CTL_ENABLE_GET(W)		(((W) & PVRPSB_PGTBL_CTL_ENABLE_MASK) >> PVRPSB_PGTBL_CTL_ENABLE_SHIFT)
#define PVRPSB_PGTBL_CTL_ENABLE_SET(W, V)	(((W) & ~PVRPSB_PGTBL_CTL_ENABLE_MASK) | (((V) << PVRPSB_PGTBL_CTL_ENABLE_SHIFT) & PVRPSB_PGTBL_CTL_ENABLE_MASK))

#define PVRPSB_PGTBL_CTL_BASEADDR_SHIFT		(12)
#define PVRPSB_PGTBL_CTL_BASEADDR_MASK		(0xFFFFF000)
#define PVRPSB_PGTBL_CTL_BASEADDR_GET(W)	((((W) & PVRPSB_PGTBL_CTL_BASEADDR_MASK) >> PVRPSB_PGTBL_CTL_BASEADDR_SHIFT) << PVRPSB_PAGE_SHIFT)


/* Interrupt Control - this is guess work */
#define PVRPSB_IER				(0x020A0)

#define PVRPSB_IER_PIPEA_ENABLE_SHIFT		(7)
#define PVRPSB_IER_PIPEA_ENABLE_MASK		(0x00000080)
#define PVRPSB_IER_PIPEA_ENABLE_GET(W)		(((W) & PVRPSB_IER_PIPEA_ENABLE_MASK) >> PVRPSB_IER_PIPEA_ENABLE_SHIFT)
#define PVRPSB_IER_PIPEA_ENABLE_SET(W, V)	(((W) & ~PVRPSB_IER_PIPEA_ENABLE_MASK) | (((V) << PVRPSB_IER_PIPEA_ENABLE_SHIFT) & PVRPSB_IER_PIPEA_ENABLE_MASK))

#define PVRPSB_IER_PIPEB_ENABLE_SHIFT		(5)
#define PVRPSB_IER_PIPEB_ENABLE_MASK		(0x00000020)
#define PVRPSB_IER_PIPEB_ENABLE_GET(W)		(((W) & PVRPSB_IER_PIPEB_ENABLE_MASK) >> PVRPSB_IER_PIPEB_ENABLE_SHIFT)
#define PVRPSB_IER_PIPEB_ENABLE_SET(W, V)	(((W) & ~PVRPSB_IER_PIPEB_ENABLE_MASK) | (((V) << PVRPSB_IER_PIPEB_ENABLE_SHIFT) & PVRPSB_IER_PIPEB_ENABLE_MASK))


#define PVRPSB_IIR				(0x020A4)

#define PVRPSB_IMR_PIPEA_STATUS_SHIFT		(7)
#define PVRPSB_IMR_PIPEA_STATUS_MASK		(0x00000080)
#define PVRPSB_IMR_PIPEA_STATUS_GET(W)		(((W) & PVRPSB_IMR_PIPEA_STATUS_MASK) >> PVRPSB_IMR_PIPEA_STATUS_SHIFT)
#define PVRPSB_IMR_PIPEA_STATUS_SET(W, V)	(((W) & ~PVRPSB_IMR_PIPEA_STATUS_MASK) | (((V) << PVRPSB_IMR_PIPEA_STATUS_SHIFT) & PVRPSB_IMR_PIPEA_STATUS_MASK))

#define PVRPSB_IMR_PIPEB_STATUS_SHIFT		(5)
#define PVRPSB_IMR_PIPEB_STATUS_MASK		(0x00000020)
#define PVRPSB_IMR_PIPEB_STATUS_GET(W)		(((W) & PVRPSB_IMR_PIPEB_STATUS_MASK) >> PVRPSB_IMR_PIPEB_STATUS_SHIFT)
#define PVRPSB_IMR_PIPEB_STATUS_SET(W, V)	(((W) & ~PVRPSB_IMR_PIPEB_STATUS_MASK) | (((V) << PVRPSB_IMR_PIPEB_STATUS_SHIFT) & PVRPSB_IMR_PIPEB_STATUS_MASK))


#define PVRPSB_IMR				(0x020A8)

#define PVRPSB_IMR_PIPEA_MASK_SHIFT		(7)
#define PVRPSB_IMR_PIPEA_MASK_MASK		(0x00000080)
#define PVRPSB_IMR_PIPEA_MASK_GET(W)		(((W) & PVRPSB_IMR_PIPEA_MASK_MASK) >> PVRPSB_IMR_PIPEA_MASK_SHIFT)
#define PVRPSB_IMR_PIPEA_MASK_SET(W, V)		(((W) & ~PVRPSB_IMR_PIPEA_MASK_MASK) | (((V) << PVRPSB_IMR_PIPEA_MASK_SHIFT) & PVRPSB_IMR_PIPEA_MASK_MASK))

#define PVRPSB_IMR_PIPEB_MASK_SHIFT		(5)
#define PVRPSB_IMR_PIPEB_MASK_MASK		(0x00000020)
#define PVRPSB_IMR_PIPEB_MASK_GET(W)		(((W) & PVRPSB_IMR_PIPEB_MASK_MASK) >> PVRPSB_IMR_PIPEB_MASK_SHIFT)
#define PVRPSB_IMR_PIPEB_MASK_SET(W, V)		(((W) & ~PVRPSB_IMR_PIPEB_MASK_MASK) | (((V) << PVRPSB_IMR_PIPEB_MASK_SHIFT) & PVRPSB_IMR_PIPEB_MASK_MASK))


#define PVRPSB_ISR				(0x020AC)


/* On Cedarview some of the PLL related registers are behind a sideband bus 
 * (unlike Poulsbo where we can access them directly). We therefore program 
 * these registers indirectly via these DPIO registers. */
#define PVRPSB_DPIO_CMD				(0x02100)

#define PVRPSB_DPIO_CMD_OP_SHIFT		(16)
#define PVRPSB_DPIO_CMD_OP_MASK			(0xFFFF0000)
#define PVRPSB_DPIO_CMD_OP_GET(W)		(((W) & PVRPSB_DPIO_CMD_OP_MASK) >> PVRPSB_DPIO_CMD_OP_SHIFT)
#define PVRPSB_DPIO_CMD_OP_SET(W, V)		(((W) & ~PVRPSB_DPIO_CMD_OP_MASK) | (((V) << PVRPSB_DPIO_CMD_OP_SHIFT) & PVRPSB_DPIO_CMD_OP_MASK))
#define PVRPSB_DPIO_CMD_OP_READ			(0)
#define PVRPSB_DPIO_CMD_OP_WRITE		(1)

#define PVRPSB_DPIO_CMD_TARGET_SHIFT		(8)
#define PVRPSB_DPIO_CMD_TARGET_MASK		(0x0000FF00)
#define PVRPSB_DPIO_CMD_TARGET_GET(W)		(((W) & PVRPSB_DPIO_CMD_TARGET_MASK) >> PVRPSB_DPIO_CMD_TARGET_SHIFT)
#define PVRPSB_DPIO_CMD_TARGET_SET(W, V)	(((W) & ~PVRPSB_DPIO_CMD_TARGET_MASK) | (((V) << PVRPSB_DPIO_CMD_TARGET_SHIFT) & PVRPSB_DPIO_CMD_TARGET_MASK))
#define PVRPSB_DPIO_CMD_TARGET_DPLL		(0x88)

#define PVRPSB_DPIO_CMD_ENABLE_SHIFT		(4)
#define PVRPSB_DPIO_CMD_ENABLE_MASK		(0x000000F0)
#define PVRPSB_DPIO_CMD_ENABLE_GET(W)		(((W) & PVRPSB_DPIO_CMD_ENABLE_MASK) >> PVRPSB_DPIO_CMD_ENABLE_SHIFT)
#define PVRPSB_DPIO_CMD_ENABLE_SET(W, V)	(((W) & ~PVRPSB_DPIO_CMD_ENABLE_MASK) | (((V) << PVRPSB_DPIO_CMD_ENABLE_SHIFT) & PVRPSB_DPIO_CMD_ENABLE_MASK))

#define PVRPSB_DPIO_CMD_BUSY_SHIFT		(0)
#define PVRPSB_DPIO_CMD_BUSY_MASK		(0x0000001)
#define PVRPSB_DPIO_CMD_BUSY_GET(W)		(((W) & PVRPSB_DPIO_CMD_BUSY_MASK) >> PVRPSB_DPIO_CMD_BUSY_SHIFT)


#define PVRPSB_DPIO_DATA			(0x02104)
#define PVRPSB_DPIO_ADDR			(0x02108)

#define PVRPSB_DPIO_ADDR_REF_A			(0x8018) /* Pipe A */
#define PVRPSB_DPIO_ADDR_REF_B			(0x8038) /* Pipe B */

#define PVRPSB_DPIO_ADDR_M_A			(0x8008) /* Pipe A */
#define PVRPSB_DPIO_ADDR_M_B			(0x8028) /* Pipe B */

#define PVRPSB_DPIO_DATA_M_M2_SHIFT		(24)
#define PVRPSB_DPIO_DATA_M_M2_MASK		(0xFF000000)
#define PVRPSB_DPIO_DATA_M_M2_GET(W)		(((W) & PVRPSB_DPIO_DATA_M_M2_MASK) >> PVRPSB_DPIO_DATA_M_M2_SHIFT)
#define PVRPSB_DPIO_DATA_M_M2_SET(W, V)		(((W) & ~PVRPSB_DPIO_DATA_M_M2_MASK) | (((V) << PVRPSB_DPIO_DATA_M_M2_SHIFT) & PVRPSB_DPIO_DATA_M_M2_MASK))

#define PVRPSB_DPIO_ADDR_N_VCO_A		(0x8014) /* Pipe A */
#define PVRPSB_DPIO_ADDR_N_VCO_B		(0x8034) /* Pipe B */

#define PVRPSB_DPIO_DATA_N_VCO_SEL_SHIFT	(30)
#define PVRPSB_DPIO_DATA_N_VCO_SEL_MASK		(0xC0000000)
#define PVRPSB_DPIO_DATA_N_VCO_SEL_GET(W)	(((W) & PVRPSB_DPIO_DATA_N_VCO_SEL_MASK) >> PVRPSB_DPIO_DATA_N_VCO_SEL_SHIFT)
#define PVRPSB_DPIO_DATA_N_VCO_SEL_SET(W, V)	(((W) & ~PVRPSB_DPIO_DATA_N_VCO_SEL_MASK) | (((V) << PVRPSB_DPIO_DATA_N_VCO_SEL_SHIFT) & PVRPSB_DPIO_DATA_N_VCO_SEL_MASK))

#define PVRPSB_DPIO_DATA_N_VCO_N_SHIFT		(26)
#define PVRPSB_DPIO_DATA_N_VCO_N_MASK		(0x3C000000)
#define PVRPSB_DPIO_DATA_N_VCO_N_GET(W)		(((W) & PVRPSB_DPIO_DATA_N_VCO_N_MASK) >> PVRPSB_DPIO_DATA_N_VCO_N_SHIFT)
#define PVRPSB_DPIO_DATA_N_VCO_N_SET(W, V)	(((W) & ~PVRPSB_DPIO_DATA_N_VCO_N_MASK) | (((V) << PVRPSB_DPIO_DATA_N_VCO_N_SHIFT) & PVRPSB_DPIO_DATA_N_VCO_N_MASK))
 
#define PVRPSB_DPIO_DATA_N_VCO_CB_TUNE_SHIFT	(24)
#define PVRPSB_DPIO_DATA_N_VCO_CB_TUNE_MASK	(0x03000000)
#define PVRPSB_DPIO_DATA_N_VCO_CB_TUNE_GET(W)	(((W) & PVRPSB_DPIO_DATA_N_VCO_CB_TUNE_MASK) >> PVRPSB_DPIO_DATA_N_VCO_CB_TUNE_SHIFT)
#define PVRPSB_DPIO_DATA_N_VCO_CB_TUNE_SET(W, V) (((W) & ~PVRPSB_DPIO_DATA_N_VCO_CB_TUNE_MASK) | (((V) << PVRPSB_DPIO_DATA_N_VCO_CB_TUNE_SHIFT) & PVRPSB_DPIO_DATA_N_VCO_CB_TUNE_MASK))

#define PVRPSB_DPIO_DATA_N_VCO_MAGIC_SHIFT	(0)
#define PVRPSB_DPIO_DATA_N_VCO_MAGIC_MASK	(0x0000FFFF)
#define PVRPSB_DPIO_DATA_N_VCO_MAGIC_GET(W)	(((W) & PVRPSB_DPIO_DATA_N_VCO_MAGIC_MASK) >> PVRPSB_DPIO_DATA_N_VCO_MAGIC_SHIFT)
#define PVRPSB_DPIO_DATA_N_VCO_MAGIC_SET(W, V)	(((W) & ~PVRPSB_DPIO_DATA_N_VCO_MAGIC_MASK) | (((V) << PVRPSB_DPIO_DATA_N_VCO_MAGIC_SHIFT) & PVRPSB_DPIO_DATA_N_VCO_MAGIC_MASK))

#define PVRPSB_DPIO_ADDR_P_A			(0x801C) /* Pipe A */
#define PVRPSB_DPIO_ADDR_P_B			(0x803C) /* Pipe B */

#define PVRPSB_DPIO_DATA_P_P2_DIVIDE_SHIFT	(30)
#define PVRPSB_DPIO_DATA_P_P2_DIVIDE_MASK	(0xC0000000)
#define PVRPSB_DPIO_DATA_P_P2_DIVIDE_GET(W)	(((W) & PVRPSB_DPIO_DATA_P_P2_DIVIDE_MASK) >> PVRPSB_DPIO_DATA_P_P2_DIVIDE_SHIFT)
#define PVRPSB_DPIO_DATA_P_P2_DIVIDE_SET(W, V)	(((W) & ~PVRPSB_DPIO_DATA_P_P2_DIVIDE_MASK) | (((V) << PVRPSB_DPIO_DATA_P_P2_DIVIDE_SHIFT) & PVRPSB_DPIO_DATA_P_P2_DIVIDE_MASK))
#define PVRPSB_DPIO_DATA_P_P2_DIVIDE_10		(0) /* SDVO/CRT */
#define PVRPSB_DPIO_DATA_P_P2_DIVIDE_5		(1) /* SDVO/CRT */
#define PVRPSB_DPIO_DATA_P_P2_DIVIDE_14		(2) /* Single LVDS */
#define PVRPSB_DPIO_DATA_P_P2_DIVIDE__7		(3) /* Dual LVDS */

#define PVRPSB_DPIO_DATA_P_P1_SHIFT		(12)
#define PVRPSB_DPIO_DATA_P_P1_MASK		(0x0000F000)
#define PVRPSB_DPIO_DATA_P_P1_GET(W)		(((W) & PVRPSB_DPIO_DATA_P_P1_MASK) >> PVRPSB_DPIO_DATA_P_P1_SHIFT)
#define PVRPSB_DPIO_DATA_P_P1_SET(W, V)		(((W) & ~PVRPSB_DPIO_DATA_P_P1_MASK) | (((V) << PVRPSB_DPIO_DATA_P_P1_SHIFT) & PVRPSB_DPIO_DATA_P_P1_MASK))

#define PVRPSB_DPIO_ADDR_LANE0			(0x0120)
#define PVRPSB_DPIO_ADDR_LANE1			(0x0220)
#define PVRPSB_DPIO_ADDR_LANE2			(0x2320)
#define PVRPSB_DPIO_ADDR_LANE3			(0x2420)

#define PVRPSB_DPIO_DATA_LANE_ENABLE_SHIFT	(20)
#define PVRPSB_DPIO_DATA_LANE_ENABLE_MASK	(0x00700000)
#define PVRPSB_DPIO_DATA_LANE_ENABLE_GET(W)	(((W) & PVRPSB_DPIO_DATA_LANE_ENABLE_MASK) >> PVRPSB_DPIO_DATA_LANE_ENABLE_SHIFT)
#define PVRPSB_DPIO_DATA_LANE_ENABLE_SET(W, V)	(((W) & ~PVRPSB_DPIO_DATA_LANE_ENABLE_MASK) | (((V) << PVRPSB_DPIO_DATA_LANE_ENABLE_SHIFT) & PVRPSB_DPIO_DATA_LANE_ENABLE_MASK))


/* Cedarview only register */
#define PVRPSB_DPIO_CFG				(0x02110)

#define PVRPSB_DPIO_CFG_MODE_SHIFT		(2)
#define PVRPSB_DPIO_CFG_MODE_MASK		(0x0000000C)
#define PVRPSB_DPIO_CFG_MODE_GET(W)		(((W) & PVRPSB_DPIO_CFG_MODE_MASK) >> PVRPSB_DPIO_CFG_MODE_SHIFT)
#define PVRPSB_DPIO_CFG_MODE_SET(W, V)		(((W) & ~PVRPSB_DPIO_CFG_MODE_MASK) | (((V) << PVRPSB_DPIO_CFG_MODE_SHIFT) & PVRPSB_DPIO_CFG_MODE_MASK))
#define PVRPSB_DPIO_CFG_MODE_SELECT0		(1)
#define PVRPSB_DPIO_CFG_MODE_SELECT1		(2)

#define PVRPSB_DPIO_CFG_BYPASS_SHIFT		(1)
#define PVRPSB_DPIO_CFG_BYPASS_MASK		(0x00000002)
#define PVRPSB_DPIO_CFG_BYPASS_GET(W)		(((W) & PVRPSB_DPIO_CFG_BYPASS_MASK) >> PVRPSB_DPIO_CFG_BYPASS_SHIFT)
#define PVRPSB_DPIO_CFG_BYPASS_SET(W, V)	(((W) & ~PVRPSB_DPIO_CFG_BYPASS_MASK) | (((V) << PVRPSB_DPIO_CFG_BYPASS_SHIFT) & PVRPSB_DPIO_CFG_BYPASS_MASK))

#define PVRPSB_DPIO_CFG_SFR_BYPASS_SHIFT	(1)
#define PVRPSB_DPIO_CFG_SFR_BYPASS_MASK		(0x00000002)
#define PVRPSB_DPIO_CFG_SFR_BYPASS_GET(W)	(((W) & PVRPSB_DPIO_CFG_SFR_BYPASS_MASK) >> PVRPSB_DPIO_CFG_SFR_BYPASS_SHIFT)
#define PVRPSB_DPIO_CFG_SFR_BYPASS_SET(W, V)	(((W) & ~PVRPSB_DPIO_CFG_SFR_BYPASS_MASK) | (((V) << PVRPSB_DPIO_CFG_SFR_BYPASS_SHIFT) & PVRPSB_DPIO_CFG_SFR_BYPASS_MASK))

#define PVRPSB_DPIO_CFG_RESET_SHIFT		(0)
#define PVRPSB_DPIO_CFG_RESET_MASK		(0x00000001)
#define PVRPSB_DPIO_CFG_RESET_GET(W)		(((W) & PVRPSB_DPIO_CFG_RESET_MASK) >> PVRPSB_DPIO_CFG_RESET_SHIFT)
#define PVRPSB_DPIO_CFG_RESET_SET(W, V)		(((W) & ~PVRPSB_DPIO_CFG_RESET_MASK) | (((V) << PVRPSB_DPIO_CFG_RESET_SHIFT) & PVRPSB_DPIO_CFG_RESET_MASK))


/* GPIO pins are used to implemented a "bit banging" version of I2C protocol. This is 
   used to program the SDVO device and allow DDC communication with connected displays. */
#define PVRPSB_GPIO_A				(0x05010) /* DAC DDC */
#define PVRPSB_GPIO_B				(0x05014) /* I2C */
#define PVRPSB_GPIO_C				(0x05018) /* LVDS/DPD DDC */
#define PVRPSB_GPIO_D				(0x0501C) /* Reserved */
#define PVRPSB_GPIO_E				(0x05020) /* SDVO/HDMIB  */
#define PVRPSB_GPIO_F				(0x05024) /* Reserved */
#define PVRPSB_GPIO_G				(0x05028) /* Reserved */
#define PVRPSB_GPIO_H				(0x0502C) /* TV */

#define PVRPSB_GPIO_DATA_IN_SHIFT		(12)
#define PVRPSB_GPIO_DATA_IN_MASK		(0x00001000)
#define PVRPSB_GPIO_DATA_IN_GET(W)		(((W) & PVRPSB_GPIO_DATA_IN_MASK) >> PVRPSB_GPIO_DATA_IN_SHIFT)

#define PVRPSB_GPIO_DATA_VALUE_SHIFT		(11)
#define PVRPSB_GPIO_DATA_VALUE_MASK		(0x00000800)
#define PVRPSB_GPIO_DATA_VALUE_GET(W)		(((W) & PVRPSB_GPIO_DATA_VALUE_MASK) >> PVRPSB_GPIO_DATA_VALUE_SHIFT)
#define PVRPSB_GPIO_DATA_VALUE_SET(W, V)	(((W) & ~PVRPSB_GPIO_DATA_VALUE_MASK) | (((V) << PVRPSB_GPIO_DATA_VALUE_SHIFT) & PVRPSB_GPIO_DATA_VALUE_MASK))

#define PVRPSB_GPIO_DATA_MASK_SHIFT		(10)
#define PVRPSB_GPIO_DATA_MASK_MASK		(0x00000400)
#define PVRPSB_GPIO_DATA_MASK_SET(W, V)		(((W) & ~PVRPSB_GPIO_DATA_MASK_MASK) | (((V) << PVRPSB_GPIO_DATA_MASK_SHIFT) & PVRPSB_GPIO_DATA_MASK_MASK))
#define PVRPSB_GPIO_DATA_MASK_NOWRITE_VALUE	(0)
#define PVRPSB_GPIO_DATA_MASK_WRITE_VALUE	(1)

#define PVRPSB_GPIO_DATA_DIR_VALUE_SHIFT	(9)
#define PVRPSB_GPIO_DATA_DIR_VALUE_MASK		(0x00000200)
#define PVRPSB_GPIO_DATA_DIR_VALUE_GET(W)	(((W) & PVRPSB_GPIO_DATA_DIR_VALUE_MASK) >> PVRPSB_GPIO_DATA_DIR_VALUE_SHIFT)
#define PVRPSB_GPIO_DATA_DIR_VALUE_SET(W, V)	(((W) & ~PVRPSB_GPIO_DATA_DIR_VALUE_MASK) | (((V) << PVRPSB_GPIO_DATA_DIR_VALUE_SHIFT) & PVRPSB_GPIO_DATA_DIR_VALUE_MASK))
#define PVRPSB_GPIO_DATA_DIR_VALUE_IN		(0)
#define PVRPSB_GPIO_DATA_DIR_VALUE_OUT		(1)

#define PVRPSB_GPIO_DATA_DIR_MASK_SHIFT		(8)
#define PVRPSB_GPIO_DATA_DIR_MASK_MASK		(0x00000100)
#define PVRPSB_GPIO_DATA_DIR_MASK_SET(W, V)	(((W) & ~PVRPSB_GPIO_DATA_DIR_MASK_MASK) | (((V) << PVRPSB_GPIO_DATA_DIR_MASK_SHIFT) & PVRPSB_GPIO_DATA_DIR_MASK_MASK))
#define PVRPSB_GPIO_DATA_DIR_MASK_NOWRITE_VALUE	(0)
#define PVRPSB_GPIO_DATA_DIR_MASK_WRITE_VALUE	(1)

#define PVRPSB_GPIO_CLOCK_IN_SHIFT		(4)
#define PVRPSB_GPIO_CLOCK_IN_MASK		(0x0000010)
#define PVRPSB_GPIO_CLOCK_IN_GET(W)		(((W) & PVRPSB_GPIO_CLOCK_IN_MASK) >> PVRPSB_GPIO_CLOCK_IN_SHIFT)

#define PVRPSB_GPIO_CLOCK_VALUE_SHIFT		(3)
#define PVRPSB_GPIO_CLOCK_VALUE_MASK		(0x00000008)
#define PVRPSB_GPIO_CLOCK_VALUE_GET(W)		(((W) & PVRPSB_GPIO_CLOCK_VALUE_MASK) >> PVRPSB_GPIO_CLOCK_VALUE_SHIFT)
#define PVRPSB_GPIO_CLOCK_VALUE_SET(W, V)	(((W) & ~PVRPSB_GPIO_CLOCK_VALUE_MASK) | (((V) << PVRPSB_GPIO_CLOCK_VALUE_SHIFT) & PVRPSB_GPIO_CLOCK_VALUE_MASK))

#define PVRPSB_GPIO_CLOCK_MASK_SHIFT		(2)
#define PVRPSB_GPIO_CLOCK_MASK_MASK		(0x00000004)
#define PVRPSB_GPIO_CLOCK_MASK_SET(W, V)	(((W) & ~PVRPSB_GPIO_CLOCK_MASK_MASK) | (((V) << PVRPSB_GPIO_CLOCK_MASK_SHIFT) & PVRPSB_GPIO_CLOCK_MASK_MASK))
#define PVRPSB_GPIO_CLOCK_MASK_NOWRITE_VALUE	(0)
#define PVRPSB_GPIO_CLOCK_MASK_WRITE_VALUE	(1)

#define PVRPSB_GPIO_CLOCK_DIR_VALUE_SHIFT	(1)
#define PVRPSB_GPIO_CLOCK_DIR_VALUE_MASK	(0x00000002)
#define PVRPSB_GPIO_CLOCK_DIR_VALUE_GET(W)	(((W) & PVRPSB_GPIO_CLOCK_DIR_VALUE_MASK) >> PVRPSB_GPIO_CLOCK_DIR_VALUE_SHIFT)
#define PVRPSB_GPIO_CLOCK_DIR_VALUE_SET(W, V)	(((W) & ~PVRPSB_GPIO_CLOCK_DIR_VALUE_MASK) | (((V) << PVRPSB_GPIO_CLOCK_DIR_VALUE_SHIFT) & PVRPSB_GPIO_CLOCK_DIR_VALUE_MASK))
#define PVRPSB_GPIO_CLOCK_DIR_VALUE_IN		(0)
#define PVRPSB_GPIO_CLOCK_DIR_VALUE_OUT		(1)

#define PVRPSB_GPIO_CLOCK_DIR_MASK_SHIFT	(0)
#define PVRPSB_GPIO_CLOCK_DIR_MASK_MASK		(0x00000001)
#define PVRPSB_GPIO_CLOCK_DIR_MASK_SET(W, V)	(((W) & ~PVRPSB_GPIO_CLOCK_DIR_MASK_MASK) | (((V) << PVRPSB_GPIO_CLOCK_DIR_MASK_SHIFT) & PVRPSB_GPIO_CLOCK_DIR_MASK_MASK))
#define PVRPSB_GPIO_CLOCK_DIR_MASK_NOWRITE_VALUE (0)
#define PVRPSB_GPIO_CLOCK_DIR_MASK_WRITE_VALUE	(1)


#define PVRPSB_DPLLA_CTL			(0x06014) /* Pipe A */
#define PVRPSB_DPLLB_CTL			(0x06018) /* Pipe B */

#define PVRPSB_DPLL_ENABLE_SHIFT		(31)
#define PVRPSB_DPLL_ENABLE_MASK			(0x80000000)
#define PVRPSB_DPLL_ENABLE_GET(W)		(((W) & PVRPSB_DPLL_ENABLE_MASK) >> PVRPSB_DPLL_ENABLE_SHIFT)
#define PVRPSB_DPLL_ENABLE_SET(W, V)		(((W) & ~PVRPSB_DPLL_ENABLE_MASK) | (((V) << PVRPSB_DPLL_ENABLE_SHIFT) & PVRPSB_DPLL_ENABLE_MASK))

#define PVRPSB_DPLL_HIGHSPEED_ENABLE_SHIFT	(30)
#define PVRPSB_DPLL_HIGHSPEED_ENABLE_MASK	(0x40000000)
#define PVRPSB_DPLL_HIGHSPEED_ENABLE_GET(W)	(((W) & PVRPSB_DPLL_HIGHSPEED_ENABLE_MASK) >> PVRPSB_DPLL_HIGHSPEED_ENABLE_SHIFT)
#define PVRPSB_DPLL_HIGHSPEED_ENABLE_SET(W, V)	(((W) & ~PVRPSB_DPLL_HIGHSPEED_ENABLE_MASK) | (((V) << PVRPSB_DPLL_HIGHSPEED_ENABLE_SHIFT) & PVRPSB_DPLL_HIGHSPEED_ENABLE_MASK))

/* Cedarview only */
#define PVRPSB_DPLL_SYNC_CLOCK_ENABLE_SHIFT	(29)
#define PVRPSB_DPLL_SYNC_CLOCK_ENABLE_MASK	(0x20000000)
#define PVRPSB_DPLL_SYNC_CLOCK_ENABLE_GET(W)	(((W) & PVRPSB_DPLL_SYNC_CLOCK_ENABLE_MASK) >> PVRPSB_DPLL_SYNC_CLOCK_ENABLE_SHIFT)
#define PVRPSB_DPLL_SYNC_CLOCK_ENABLE_SET(W, V)	(((W) & ~PVRPSB_DPLL_SYNC_CLOCK_ENABLE_MASK) | (((V) << PVRPSB_DPLL_SYNC_CLOCK_ENABLE_SHIFT) & PVRPSB_DPLL_SYNC_CLOCK_ENABLE_MASK))

#define PVRPSB_DPLL_VGA_DISABLE_SHIFT		(28)
#define PVRPSB_DPLL_VGA_DISABLE_MASK		(0x10000000)
#define PVRPSB_DPLL_VGA_DISABLE_GET(W)		(((W) & PVRPSB_DPLL_VGA_DISABLE_MASK) >> PVRPSB_DPLL_VGA_DISABLE_SHIFT)
#define PVRPSB_DPLL_VGA_DISABLE_SET(W, V)	(((W) & ~PVRPSB_DPLL_VGA_DISABLE_MASK) | (((V) << PVRPSB_DPLL_VGA_DISABLE_SHIFT) & PVRPSB_DPLL_VGA_DISABLE_MASK))

#define PVRPSB_DPLL_MODE_SHIFT			(26)
#define PVRPSB_DPLL_MODE_MASK			(0x0C000000)
#define PVRPSB_DPLL_MODE_GET(W)			(((W) & PVRPSB_DPLL_MODE_MASK) >> PVRPSB_DPLL_MODE_SHIFT)
#define PVRPSB_DPLL_MODE_SET(W, V)		(((W) & ~PVRPSB_DPLL_MODE_MASK) | (((V) << PVRPSB_DPLL_MODE_SHIFT) & PVRPSB_DPLL_MODE_MASK))
#define PVRPSB_DPLL_MODE_SDVO			(1)
#define PVRPSB_DPLL_MODE_LVDS			(2)

#define PVRPSB_DPLL_P2_DIVIDE_SHIFT		(24)
#define PVRPSB_DPLL_P2_DIVIDE_MASK		(0x03000000)
#define PVRPSB_DPLL_P2_DIVIDE_GET(W)		(((W) & PVRPSB_DPLL_P2_DIVIDE_MASK) >> PVRPSB_DPLL_P2_DIVIDE_SHIFT)
#define PVRPSB_DPLL_P2_DIVIDE_SET(W, V)		(((W) & ~PVRPSB_DPLL_P2_DIVIDE_MASK) | (((V) << PVRPSB_DPLL_P2_DIVIDE_SHIFT) & PVRPSB_DPLL_P2_DIVIDE_MASK))
#define PVRPSB_DPLL_P2_DIVIDE_SDVO_10		(0) /* DPLL_MODE set to SDVO and Dot Clock <= 270MHz */
#define PVRPSB_DPLL_P2_DIVIDE_SDVO_5		(1) /* DPLL_MODE set to SDVO and Dot Clock > 270MHz */
#define PVRPSB_DPLL_P2_DIVIDE_LVDS_14		(0) /* DPLL_MODE set to LVDS and single channel LVDS */
#define PVRPSB_DPLL_P2_DIVIDE_LVDS_7		(1) /* DPLL_MODE set to LVDS and dual channel LVDS */

#define PVRPSB_DPLL_P1_POSTDIVIDE_SHIFT		(16)
#define PVRPSB_DPLL_P1_POSTDIVIDE_MASK		(0x00FF0000)
#define PVRPSB_DPLL_P1_POSTDIVIDE_GET(W)	((((W) & PVRPSB_DPLL_P1_POSTDIVIDE_MASK) >> PVRPSB_DPLL_P1_POSTDIVIDE_SHIFT))
#define PVRPSB_DPLL_P1_POSTDIVIDE_SET(W, V)	(((W) & ~PVRPSB_DPLL_P1_POSTDIVIDE_MASK) | (((V) << PVRPSB_DPLL_P1_POSTDIVIDE_SHIFT) & PVRPSB_DPLL_P1_POSTDIVIDE_MASK))
#define PVRPSB_DPLL_P1_POSTDIVIDE_1		(1 << 0)
#define PVRPSB_DPLL_P1_POSTDIVIDE_2		(1 << 1)
#define PVRPSB_DPLL_P1_POSTDIVIDE_3		(1 << 2)
#define PVRPSB_DPLL_P1_POSTDIVIDE_4		(1 << 3)
#define PVRPSB_DPLL_P1_POSTDIVIDE_5		(1 << 4)
#define PVRPSB_DPLL_P1_POSTDIVIDE_6		(1 << 5)
#define PVRPSB_DPLL_P1_POSTDIVIDE_7		(1 << 6)
#define PVRPSB_DPLL_P1_POSTDIVIDE_8		(1 << 7)

/* Cedarview only */
#define PVRPSB_DPLL_LOCK_SHIFT			(15)
#define PVRPSB_DPLL_LOCK_MASK			(0x00008000)
#define PVRPSB_DPLL_LOCK_GET(W)			((((W) & PVRPSB_DPLL_LOCK_MASK) >> PVRPSB_DPLL_LOCK_SHIFT))
#define PVRPSB_DPLL_LOCK_SET(W, V)		(((W) & ~PVRPSB_DPLL_LOCK_MASK) | (((V) << PVRPSB_DPLL_LOCK_SHIFT) & PVRPSB_DPLL_LOCK_MASK))

#define PVRPSB_DPLL_REF_CLOCK_SHIFT		(13)
#define PVRPSB_DPLL_REF_CLOCK_MASK		(0x00006000)
#define PVRPSB_DPLL_REF_CLOCK_GET(W)		(((W) & PVRPSB_DPLL_REF_CLOCK_MASK) >> PVRPSB_DPLL_REF_CLOCK_SHIFT)
#define PVRPSB_DPLL_REF_CLOCK_SET(W, V)		(((W) & ~PVRPSB_DPLL_REF_CLOCK_MASK) | (((V) << PVRPSB_DPLL_REF_CLOCK_SHIFT) & PVRPSB_DPLL_REF_CLOCK_MASK))
#define PVRPSB_DPLL_REF_CLOCK_DEFAULT		(0)
#define PVRPSB_DPLL_REF_CLOCK_SDVO_TV		(2)
#define PVRPSB_DPLL_REF_CLOCK_SPREAD		(3)

#define PVRPSB_DPLL_CLOCK_MULTI_SHIFT		(4)
#define PVRPSB_DPLL_CLOCK_MULTI_MASK		(0x00000F0) /* This is a guess */
#define PVRPSB_DPLL_CLOCK_MULTI_GET(W)		((((W) & PVRPSB_DPLL_CLOCK_MULTI_MASK) >> PVRPSB_DPLL_CLOCK_MULTI_SHIFT) + 1)
#define PVRPSB_DPLL_CLOCK_MULTI_SET(W, V)	(((W) & ~PVRPSB_DPLL_CLOCK_MULTI_MASK) | ((((V) - 1) << PVRPSB_DPLL_CLOCK_MULTI_SHIFT) & PVRPSB_DPLL_CLOCK_MULTI_MASK))

/* This is a guess */
#define PVRPSB_DPLL_P2_SHIFT			(0)
#define PVRPSB_DPLL_P2_MASK			(0x000000F)
#define PVRPSB_DPLL_P2_GET(W)			(((W) & PVRPSB_DPLL_P2_MASK) >> PVRPSB_DPLL_P2_SHIFT)
#define PVRPSB_DPLL_P2_SET(W, V)		(((W) & ~PVRPSB_DPLL_P2_MASK) | (((V) << PVRPSB_DPLL_P2_SHIFT) & PVRPSB_DPLL_P2_MASK))


#define PVRPSB_DPLLAMD				(0x0601C) /* Pipe A */
#define PVRPSB_DPLLBMD				(0x06020) /* Pipe B */

#define PVRPSB_DPLLMD_DIV_HIRES_SHIFT		(24)
#define PVRPSB_DPLLMD_DIV_HIRES_MASK		(0x3F000000)
#define PVRPSB_DPLLMD_DIV_HIRES_GET(W)		(((W) & PVRPSB_DPLLMD_DIV_HIRES_MASK) >> PVRPSB_DPLLMD_DIV_HIRES_SHIFT)
#define PVRPSB_DPLLMD_DIV_HIRES_SET(W, V)	(((W) & ~PVRPSB_DPLLMD_DIV_HIRES_MASK) | (((V) << PVRPSB_DPLLMD_DIV_HIRES_SHIFT) & PVRPSB_DPLLMD_DIV_HIRES_MASK))

#define PVRPSB_DPLLMD_DIV_VGA_SHIFT		(16)
#define PVRPSB_DPLLMD_DIV_VGA_MASK		(0x003F0000)
#define PVRPSB_DPLLMD_DIV_VGA_GET(W)		(((W) & PVRPSB_DPLLMD_DIV_VGA_MASK) >> PVRPSB_DPLLMD_DIV_VGA_SHIFT)
#define PVRPSB_DPLLMD_DIV_VGA_SET(W, V)		(((W) & ~PVRPSB_DPLLMD_DIV_VGA_MASK) | (((V) << PVRPSB_DPLLMD_DIV_VGA_SHIFT) & PVRPSB_DPLLMD_DIV_VGA_MASK))

#define PVRPSB_DPLLMD_MUL_HIRES_SHIFT		(8)
#define PVRPSB_DPLLMD_MUL_HIRES_MASK		(0x00003F00)
#define PVRPSB_DPLLMD_MUL_HIRES_GET(W)		(((W) & PVRPSB_DPLLMD_MUL_HIRES_MASK) >> PVRPSB_DPLLMD_MUL_HIRES_SHIFT)
#define PVRPSB_DPLLMD_MUL_HIRES_SET(W, V)	(((W) & ~PVRPSB_DPLLMD_MUL_HIRES_MASK) | (((V) << PVRPSB_DPLLMD_MUL_HIRES_SHIFT) & PVRPSB_DPLLMD_MUL_HIRES_MASK))

#define PVRPSB_DPLLMD_MUL_VGA_SHIFT		(0)
#define PVRPSB_DPLLMD_MUL_VGA_MASK		(0x0000003F)
#define PVRPSB_DPLLMD_MUL_VGA_GET(W)		(((W) & PVRPSB_DPLLMD_MUL_VGA_MASK) >> PVRPSB_DPLLMD_MUL_VGA_SHIFT)
#define PVRPSB_DPLLMD_MUL_VGA_SET(W, V)		(((W) & ~PVRPSB_DPLLMD_MUL_VGA_MASK) | (((V) << PVRPSB_DPLLMD_MUL_VGA_SHIFT) & PVRPSB_DPLLMD_MUL_VGA_MASK))


#define PVRPSB_FPA0				(0x06040) /* Pipe A */
#define PVRPSB_FPA1				(0x06044) /* Pipe A */
#define PVRPSB_FPB0				(0x06048) /* Pipe B */
#define PVRPSB_FPB1				(0x0604C) /* Pipe B */

#define PVRPSB_FP_NDIVISOR_SHIFT		(16)
#define PVRPSB_FP_NDIVISOR_MASK			(0x003F0000)
#define PVRPSB_FP_NDIVISOR_GET(W)		(((W) & PVRPSB_FP_NDIVISOR_MASK) >> PVRPSB_FP_NDIVISOR_SHIFT)
#define PVRPSB_FP_NDIVISOR_SET(W, V)		(((W) & ~PVRPSB_FP_NDIVISOR_MASK) | (((V) << PVRPSB_FP_NDIVISOR_SHIFT) & PVRPSB_FP_NDIVISOR_MASK))

#define PVRPSB_FP_M1DIVISOR_SHIFT		(8)
#define PVRPSB_FP_M1DIVISOR_MASK		(0x00003F00)
#define PVRPSB_FP_M1DIVISOR_GET(W)		(((W) & PVRPSB_FP_M1DIVISOR_MASK) >> PVRPSB_FP_M1DIVISOR_SHIFT)
#define PVRPSB_FP_M1DIVISOR_SET(W, V)		(((W) & ~PVRPSB_FP_M1DIVISOR_MASK) | (((V) << PVRPSB_FP_M1DIVISOR_SHIFT) & PVRPSB_FP_M1DIVISOR_MASK))

#define PVRPSB_FP_M2DIVISOR_SHIFT		(0)
#define PVRPSB_FP_M2DIVISOR_MASK		(0x0000003F)
#define PVRPSB_FP_M2DIVISOR_GET(W)		(((W) & PVRPSB_FP_M2DIVISOR_MASK) >> PVRPSB_FP_M2DIVISOR_SHIFT)
#define PVRPSB_FP_M2DIVISOR_SET(W, V)		(((W) & ~PVRPSB_FP_M2DIVISOR_MASK) | (((V) << PVRPSB_FP_M2DIVISOR_SHIFT) & PVRPSB_FP_M2DIVISOR_MASK))


#define PVRPSB_DPALETTEA			(0x0A000)
#define PVRPSB_DPALETTEB			(0x0A800)
#define PVRPSB_DPALETTE_LEN			(256)


#define PVRPSB_OVADD				(0x30000)
#define PVRPSB_OGAMC5				(0x30010)
#define PVRPSB_OGAMC4				(0x30014)
#define PVRPSB_OGAMC3				(0x30018)
#define PVRPSB_OGAMC2				(0x3001C)
#define PVRPSB_OGAMC1				(0x30020)
#define PVRPSB_OGAMC0				(0x30024)


#define PVRPSB_HTOTALA				(0x60000) /* Pipe A */
#define PVRPSB_HTOTALB				(0x61000) /* Pipe B */

#define PVRPSB_HTOTAL_TOTAL_SHIFT		(16)
#define PVRPSB_HTOTAL_TOTAL_MASK		(0x1FFF0000)
#define PVRPSB_HTOTAL_TOTAL_GET(W)		((((W) & PVRPSB_HTOTAL_TOTAL_MASK) >> PVRPSB_HTOTAL_TOTAL_SHIFT) + 1)
#define PVRPSB_HTOTAL_TOTAL_SET(W, V)		(((W) & ~PVRPSB_HTOTAL_TOTAL_MASK) | ((((V) - 1) << PVRPSB_HTOTAL_TOTAL_SHIFT) & PVRPSB_HTOTAL_TOTAL_MASK))

#define PVRPSB_HTOTAL_ACTIVE_SHIFT		(0)
#define PVRPSB_HTOTAL_ACTIVE_MASK		(0x0000FFF)
#define PVRPSB_HTOTAL_ACTIVE_GET(W)		((((W) & PVRPSB_HTOTAL_ACTIVE_MASK) >> PVRPSB_HTOTAL_ACTIVE_SHIFT) + 1)
#define PVRPSB_HTOTAL_ACTIVE_SET(W, V)		(((W) & ~PVRPSB_HTOTAL_ACTIVE_MASK) | ((((V) - 1) << PVRPSB_HTOTAL_ACTIVE_SHIFT) & PVRPSB_HTOTAL_ACTIVE_MASK))


#define PVRPSB_HBLANKA				(0x60004) /* Pipe A */
#define PVRPSB_HBLANKB				(0x61004) /* Pipe B */

#define PVRPSB_HBLANK_END_SHIFT			(16)
#define PVRPSB_HBLANK_END_MASK			(0x1FFF0000)
#define PVRPSB_HBLANK_END_GET(W)		((((W) & PVRPSB_HBLANK_END_MASK) >> PVRPSB_HBLANK_END_SHIFT) + 1)
#define PVRPSB_HBLANK_END_SET(W, V)		(((W) & ~PVRPSB_HBLANK_END_MASK) | ((((V) - 1) << PVRPSB_HBLANK_END_SHIFT) & PVRPSB_HBLANK_END_MASK))

#define PVRPSB_HBLANK_START_SHIFT		(0)
#define PVRPSB_HBLANK_START_MASK		(0x0001FFF)
#define PVRPSB_HBLANK_START_GET(W)		((((W) & PVRPSB_HBLANK_START_MASK) >> PVRPSB_HBLANK_START_SHIFT) + 1)
#define PVRPSB_HBLANK_START_SET(W, V)		(((W) & ~PVRPSB_HBLANK_START_MASK) | ((((V) - 1) << PVRPSB_HBLANK_START_SHIFT) & PVRPSB_HBLANK_START_MASK))


#define PVRPSB_HSYNCA				(0x60008) /* Pipe A */
#define PVRPSB_HSYNCB				(0x61008) /* Pipe B */

#define PVRPSB_HSYNC_END_SHIFT			(16)
#define PVRPSB_HSYNC_END_MASK			(0x1FFF0000)
#define PVRPSB_HSYNC_END_GET(W)			((((W) & PVRPSB_HSYNC_END_MASK) >> PVRPSB_HSYNC_END_SHIFT) + 1)
#define PVRPSB_HSYNC_END_SET(W, V)		(((W) & ~PVRPSB_HSYNC_END_MASK) | ((((V) - 1) << PVRPSB_HSYNC_END_SHIFT) & PVRPSB_HSYNC_END_MASK))

#define PVRPSB_HSYNC_START_SHIFT		(0)
#define PVRPSB_HSYNC_START_MASK			(0x0001FFF)
#define PVRPSB_HSYNC_START_GET(W)		((((W) & PVRPSB_HSYNC_START_MASK) >> PVRPSB_HSYNC_START_SHIFT) + 1)
#define PVRPSB_HSYNC_START_SET(W, V)		(((W) & ~PVRPSB_HSYNC_START_MASK) | ((((V) - 1) << PVRPSB_HSYNC_START_SHIFT) & PVRPSB_HSYNC_START_MASK))


#define PVRPSB_VTOTALA				(0x6000C) /* Pipe A */
#define PVRPSB_VTOTALB				(0x6100C) /* Pipe B */

#define PVRPSB_VTOTAL_TOTAL_SHIFT		(16)
#define PVRPSB_VTOTAL_TOTAL_MASK		(0x1FFF0000)
#define PVRPSB_VTOTAL_TOTAL_GET(W)		((((W) & PVRPSB_VTOTAL_TOTAL_MASK) >> PVRPSB_VTOTAL_TOTAL_SHIFT) + 1)
#define PVRPSB_VTOTAL_TOTAL_SET(W, V)		(((W) & ~PVRPSB_VTOTAL_TOTAL_MASK) | ((((V) - 1) << PVRPSB_VTOTAL_TOTAL_SHIFT) & PVRPSB_VTOTAL_TOTAL_MASK))

#define PVRPSB_VTOTAL_ACTIVE_SHIFT		(0)
#define PVRPSB_VTOTAL_ACTIVE_MASK		(0x0000FFF)
#define PVRPSB_VTOTAL_ACTIVE_GET(W)		((((W) & PVRPSB_VTOTAL_ACTIVE_MASK) >> PVRPSB_VTOTAL_ACTIVE_SHIFT) + 1)
#define PVRPSB_VTOTAL_ACTIVE_SET(W, V)		(((W) & ~PVRPSB_VTOTAL_ACTIVE_MASK) | ((((V) - 1) << PVRPSB_VTOTAL_ACTIVE_SHIFT) & PVRPSB_VTOTAL_ACTIVE_MASK))


#define PVRPSB_VBLANKA				(0x60010) /* Pipe A */
#define PVRPSB_VBLANKB				(0x61010) /* Pipe B */

#define PVRPSB_VBLANK_END_SHIFT			(16)
#define PVRPSB_VBLANK_END_MASK			(0x1FFF0000)
#define PVRPSB_VBLANK_END_GET(W)		(((W) & PVRPSB_VBLANK_END_MASK) >> PVRPSB_VBLANK_END_SHIFT)
#define PVRPSB_VBLANK_END_SET(W, V)		(((W) & ~PVRPSB_VBLANK_END_MASK) | ((((V) - 1) << PVRPSB_VBLANK_END_SHIFT) & PVRPSB_VBLANK_END_MASK))

#define PVRPSB_VBLANK_START_SHIFT		(0)
#define PVRPSB_VBLANK_START_MASK		(0x0001FFF)
#define PVRPSB_VBLANK_START_GET(W)		((((W) & PVRPSB_VBLANK_START_MASK) >> PVRPSB_VBLANK_START_SHIFT) + 1)
#define PVRPSB_VBLANK_START_SET(W, V)		(((W) & ~PVRPSB_VBLANK_START_MASK) | ((((V) - 1) << PVRPSB_VBLANK_START_SHIFT) & PVRPSB_VBLANK_START_MASK))


#define PVRPSB_VSYNCA				(0x60014) /* Pipe A */
#define PVRPSB_VSYNCB				(0x61014) /* Pipe B */

#define PVRPSB_VSYNC_END_SHIFT			(16)
#define PVRPSB_VSYNC_END_MASK			(0x1FFF0000)
#define PVRPSB_VSYNC_END_GET(W)			((((W) & PVRPSB_VSYNC_END_MASK) >> PVRPSB_VSYNC_END_SHIFT) + 1)
#define PVRPSB_VSYNC_END_SET(W, V)		(((W) & ~PVRPSB_VSYNC_END_MASK) | ((((V) - 1) << PVRPSB_VSYNC_END_SHIFT) & PVRPSB_VSYNC_END_MASK))

#define PVRPSB_VSYNC_START_SHIFT		(0)
#define PVRPSB_VSYNC_START_MASK			(0x0001FFF)
#define PVRPSB_VSYNC_START_GET(W)		((((W) & PVRPSB_VSYNC_START_MASK) >> PVRPSB_VSYNC_START_SHIFT) + 1)
#define PVRPSB_VSYNC_START_SET(W, V)		(((W) & ~PVRPSB_VSYNC_START_MASK) | ((((V) - 1) << PVRPSB_VSYNC_START_SHIFT) & PVRPSB_VSYNC_START_MASK))


#define PVRPSB_PIPEASRC				(0x6001C)
#define PVRPSB_PIPEBSRC				(0x6101C)

#define PVRPSB_PIPESRC_HSIZE_SHIFT		(16)
#define PVRPSB_PIPESRC_HSIZE_MASK		(0x0FFF0000)
#define PVRPSB_PIPESRC_HSIZE_GET(W)		((((W) & PVRPSB_PIPESRC_HSIZE_MASK) >> PVRPSB_PIPESRC_HSIZE_SHIFT) + 1)
#define PVRPSB_PIPESRC_HSIZE_SET(W, V)		(((W) & ~PVRPSB_PIPESRC_HSIZE_MASK) | ((((V) - 1) << PVRPSB_PIPESRC_HSIZE_SHIFT) & PVRPSB_PIPESRC_HSIZE_MASK))

#define PVRPSB_PIPESRC_VSIZE_SHIFT		(0)
#define PVRPSB_PIPESRC_VSIZE_MASK		(0x0000FFF)
#define PVRPSB_PIPESRC_VSIZE_GET(W)		((((W) & PVRPSB_PIPESRC_VSIZE_MASK) >> PVRPSB_PIPESRC_VSIZE_SHIFT) + 1)
#define PVRPSB_PIPESRC_VSIZE_SET(W, V)		(((W) & ~PVRPSB_PIPESRC_VSIZE_MASK) | ((((V) - 1) << PVRPSB_PIPESRC_VSIZE_SHIFT) & PVRPSB_PIPESRC_VSIZE_MASK))


#define PVRPSB_BCLRPATA				(0x60020) /* Pipe A */
#define PVRPSB_BCLRPATB				(0x61020) /* Pipe B */

#define PVRPSB_BCLRPAT_RED_SHIFT		(16)
#define PVRPSB_BCLRPAT_RED_MASK			(0x00FF0000)
#define PVRPSB_BCLRPAT_RED_GET(W)		((((W) & PVRPSB_BCLRPAT_RED_MASK) >> PVRPSB_BCLRPAT_RED_SHIFT) + 1)
#define PVRPSB_BCLRPAT_RED_SET(W, V)		(((W) & ~PVRPSB_BCLRPAT_RED_MASK) | ((((V) - 1) << PVRPSB_BCLRPAT_RED_SHIFT) & PVRPSB_BCLRPAT_RED_MASK))

#define PVRPSB_BCLRPAT_GREEN_SHIFT		(8)
#define PVRPSB_BCLRPAT_GREEN_MASK		(0x0000FF00)
#define PVRPSB_BCLRPAT_GREEN_GET(W)		((((W) & PVRPSB_BCLRPAT_GREEN_MASK) >> PVRPSB_BCLRPAT_GREEN_SHIFT) + 1)
#define PVRPSB_BCLRPAT_GREEN_SET(W, V)		(((W) & ~PVRPSB_BCLRPAT_GREEN_MASK) | ((((V) - 1) << PVRPSB_BCLRPAT_GREEN_SHIFT) & PVRPSB_BCLRPAT_GREEN_MASK))

#define PVRPSB_BCLRPAT_BLUE_SHIFT		(0)
#define PVRPSB_BCLRPAT_BLUE_MASK		(0x000000FF)
#define PVRPSB_BCLRPAT_BLUE_GET(W)		((((W) & PVRPSB_BCLRPAT_BLUE_MASK) >> PVRPSB_BCLRPAT_BLUE_SHIFT) + 1)
#define PVRPSB_BCLRPAT_BLUE_SET(W, V)		(((W) & ~PVRPSB_BCLRPAT_BLUE_MASK) | ((((V) - 1) << PVRPSB_BCLRPAT_BLUE_SHIFT) & PVRPSB_BCLRPAT_BLUE_MASK))


#define PVRPSB_ADPA_CTL				(0x61100)

#define PVRPSB_ADPA_CTL_ENABLE_SHIFT		(31)
#define PVRPSB_ADPA_CTL_ENABLE_MASK		(0x80000000)
#define PVRPSB_ADPA_CTL_ENABLE_GET(W)		(((W) & PVRPSB_ADPA_CTL_ENABLE_MASK) >> PVRPSB_ADPA_CTL_ENABLE_SHIFT)
#define PVRPSB_ADPA_CTL_ENABLE_SET(W, V)	(((W) & ~PVRPSB_ADPA_CTL_ENABLE_MASK) | (((V) << PVRPSB_ADPA_CTL_ENABLE_SHIFT) & PVRPSB_ADPA_CTL_ENABLE_MASK))

#define PVRPSB_ADPA_CTL_PIPE_SHIFT		(30)
#define PVRPSB_ADPA_CTL_PIPE_MASK		(0x40000000)
#define PVRPSB_ADPA_CTL_PIPE_GET(W)		(((W) & PVRPSB_ADPA_CTL_PIPE_MASK) >> PVRPSB_ADPA_CTL_PIPE_SHIFT)
#define PVRPSB_ADPA_CTL_PIPE_SET(W, V)		(((W) & ~PVRPSB_ADPA_CTL_PIPE_MASK) | (((V) << PVRPSB_ADPA_CTL_PIPE_SHIFT) & PVRPSB_ADPA_CTL_PIPE_MASK))

#define PVRPSB_ADPA_CTL_POLARITY_SEL_SHIFT	(15)
#define PVRPSB_ADPA_CTL_POLARITY_SEL_MASK	(0x00008000)
#define PVRPSB_ADPA_CTL_POLARITY_SEL_GET(W)	(((W) & PVRPSB_ADPA_CTL_POLARITY_SEL_MASK) >> PVRPSB_ADPA_CTL_POLARITY_SEL_SHIFT)
#define PVRPSB_ADPA_CTL_POLARITY_SEL_SET(W, V)	(((W) & ~PVRPSB_ADPA_CTL_POLARITY_SEL_MASK) | (((V) << PVRPSB_ADPA_CTL_POLARITY_SEL_SHIFT) & PVRPSB_ADPA_CTL_POLARITY_SEL_MASK))
#define PVRPSB_ADPA_CTL_POLARITY_SEL_ADPA	(0)
#define PVRPSB_ADPA_CTL_POLARITY_SEL_VGA	(1)

#define PVRPSB_ADPA_CTL_DPMS_SHIFT		(10)
#define PVRPSB_ADPA_CTL_DPMS_MASK		(0x00000C00)
#define PVRPSB_ADPA_CTL_DPMS_GET(W)		(((W) & PVRPSB_ADPA_CTL_DPMS_MASK) >> PVRPSB_ADPA_CTL_DPMS_SHIFT)
#define PVRPSB_ADPA_CTL_DPMS_SET(W, V)		(((W) & ~PVRPSB_ADPA_CTL_DPMS_MASK) | (((V) << PVRPSB_ADPA_CTL_DPMS_SHIFT) & PVRPSB_ADPA_CTL_DPMS_MASK))
#define PVRPSB_ADPA_CTL_DPMS_ON			(0)
#define PVRPSB_ADPA_CTL_DPMS_SUSPEND		(1)
#define PVRPSB_ADPA_CTL_DPMS_STANDBY		(2)
#define PVRPSB_ADPA_CTL_DPMS_OFF		(3)

#define PVRPSB_ADPA_CTL_VPOLARITY_CTL_SHIFT	(4)
#define PVRPSB_ADPA_CTL_VPOLARITY_CTL_MASK	(0x00000010)
#define PVRPSB_ADPA_CTL_VPOLARITY_CTL_GET(W)	(((W) & PVRPSB_ADPA_CTL_VPOLARITY_CTL_MASK) >> PVRPSB_ADPA_CTL_VPOLARITY_CTL_SHIFT)
#define PVRPSB_ADPA_CTL_VPOLARITY_CTL_SET(W, V)	(((W) & ~PVRPSB_ADPA_CTL_VPOLARITY_CTL_MASK) | (((V) << PVRPSB_ADPA_CTL_VPOLARITY_CTL_SHIFT) & PVRPSB_ADPA_CTL_VPOLARITY_CTL_MASK))
#define PVRPSB_ADPA_CTL_VPOLARITY_CTL_ACTIVE_LO	(0)
#define PVRPSB_ADPA_CTL_VPOLARITY_CTL_ACTIVE_HI	(1)

#define PVRPSB_ADPA_CTL_HPOLARITY_CTL_SHIFT	(3)
#define PVRPSB_ADPA_CTL_HPOLARITY_CTL_MASK	(0x00000008)
#define PVRPSB_ADPA_CTL_HPOLARITY_CTL_GET(W)	(((W) & PVRPSB_ADPA_CTL_HPOLARITY_CTL_MASK) >> PVRPSB_ADPA_CTL_HPOLARITY_CTL_SHIFT)
#define PVRPSB_ADPA_CTL_HPOLARITY_CTL_SET(W, V)	(((W) & ~PVRPSB_ADPA_CTL_HPOLARITY_CTL_MASK) | (((V) << PVRPSB_ADPA_CTL_HPOLARITY_CTL_SHIFT) & PVRPSB_ADPA_CTL_HPOLARITY_CTL_MASK))
#define PVRPSB_ADPA_CTL_HPOLARITY_CTL_ACTIVE_LO	(0)
#define PVRPSB_ADPA_CTL_HPOLARITY_CTL_ACTIVE_HI	(1)


#define PVRPSB_SDVOB_CTL			(0x61140)
#define PVRPSB_SDVOC_CTL			(0x61160)

#define PVRPSB_SDVO_CTL_ENABLE_SHIFT		(31)
#define PVRPSB_SDVO_CTL_ENABLE_MASK		(0x80000000)
#define PVRPSB_SDVO_CTL_ENABLE_GET(W)		(((W) & PVRPSB_SDVO_CTL_ENABLE_MASK) >> PVRPSB_SDVO_CTL_ENABLE_SHIFT)
#define PVRPSB_SDVO_CTL_ENABLE_SET(W, V)	(((W) & ~PVRPSB_SDVO_CTL_ENABLE_MASK) | (((V) << PVRPSB_SDVO_CTL_ENABLE_SHIFT) & PVRPSB_SDVO_CTL_ENABLE_MASK))

#define PVRPSB_SDVO_CTL_PIPE_SHIFT		(30)
#define PVRPSB_SDVO_CTL_PIPE_MASK		(0x40000000)
#define PVRPSB_SDVO_CTL_PIPE_GET(W)		(((W) & PVRPSB_SDVO_CTL_PIPE_MASK) >> PVRPSB_SDVO_CTL_PIPE_SHIFT)
#define PVRPSB_SDVO_CTL_PIPE_SET(W, V)		(((W) & ~PVRPSB_SDVO_CTL_PIPE_MASK) | (((V) << PVRPSB_SDVO_CTL_PIPE_SHIFT) & PVRPSB_SDVO_CTL_PIPE_MASK))

#define PVRPSB_SDVO_CTL_STALL_SHIFT		(29)
#define PVRPSB_SDVO_CTL_STALL_MASK		(0x20000000)
#define PVRPSB_SDVO_CTL_STALL_GET(W)		(((W) & PVRPSB_SDVO_CTL_STALL_MASK) >> PVRPSB_SDVO_CTL_STALL_SHIFT)
#define PVRPSB_SDVO_CTL_STALL_SET(W, V)		(((W) & ~PVRPSB_SDVO_CTL_STALL_MASK) | (((V) << PVRPSB_SDVO_CTL_STALL_SHIFT) & PVRPSB_SDVO_CTL_STALL_MASK))

#define PVRPSB_SDVO_CTL_FORMAT_SHIFT		(26)
#define PVRPSB_SDVO_CTL_FORMAT_MASK		(0x1C000000)
#define PVRPSB_SDVO_CTL_FORMAT_GET(W)		(((W) & PVRPSB_SDVO_CTL_FORMAT_MASK) >> PVRPSB_SDVO_CTL_FORMAT_SHIFT)
#define PVRPSB_SDVO_CTL_FORMAT_SET(W, V)	(((W) & ~PVRPSB_SDVO_CTL_FORMAT_MASK) | (((V) << PVRPSB_SDVO_CTL_FORMAT_SHIFT) & PVRPSB_SDVO_CTL_FORMAT_MASK))

#define PVRPSB_SDVO_CTL_LANE_REV_SHIFT		(15)
#define PVRPSB_SDVO_CTL_LANE_REV_MASK		(0x00008000)
#define PVRPSB_SDVO_CTL_LANE_REV_GET(W)		(((W) & PVRPSB_SDVO_CTL_LANE_REV_MASK) >> PVRPSB_SDVO_CTL_LANE_REV_SHIFT)
#define PVRPSB_SDVO_CTL_LANE_REV_SET(W, V)	(((W) & ~PVRPSB_SDVO_CTL_LANE_REV_MASK) | (((V) << PVRPSB_SDVO_CTL_LANE_REV_SHIFT) & PVRPSB_SDVO_CTL_LANE_REV_MASK))

#define PVRPSB_SDVO_CTL_ENCODING_SHIFT		(10)
#define PVRPSB_SDVO_CTL_ENCODING_MASK		(0x00000C00)
#define PVRPSB_SDVO_CTL_ENCODING_GET(W)		(((W) & PVRPSB_SDVO_CTL_ENCODING_MASK) >> PVRPSB_SDVO_CTL_ENCODING_SHIFT)
#define PVRPSB_SDVO_CTL_ENCODING_SET(W, V)	(((W) & ~PVRPSB_SDVO_CTL_ENCODING_MASK) | (((V) << PVRPSB_SDVO_CTL_ENCODING_SHIFT) & PVRPSB_SDVO_CTL_ENCODING_MASK))
#define PVRPSB_SDVO_CTL_ENCODING_SDVO		(0)
#define PVRPSB_SDVO_CTL_ENCODING_TMDS		(2)

#define PVRPSB_SDVO_CTL_NULL_PACK_EN_SHIFT	(9)
#define PVRPSB_SDVO_CTL_NULL_PACK_EN_MASK	(0x00000200)
#define PVRPSB_SDVO_CTL_NULL_PACK_EN_GET(W)	(((W) & PVRPSB_SDVO_CTL_NULL_PACK_EN_MASK) >> PVRPSB_SDVO_CTL_NULL_PACK_EN_SHIFT)
#define PVRPSB_SDVO_CTL_NULL_PACK_EN_SET(W, V)	(((W) & ~PVRPSB_SDVO_CTL_NULL_PACK_EN_MASK) | (((V) << PVRPSB_SDVO_CTL_NULL_PACK_EN_SHIFT) & PVRPSB_SDVO_CTL_NULL_PACK_EN_MASK))

#define PVRPSB_SDVO_CTL_BORDER_EN_SHIFT		(7)
#define PVRPSB_SDVO_CTL_BORDER_EN_MASK		(0x00000080)
#define PVRPSB_SDVO_CTL_BORDER_EN_GET(W)	(((W) & PVRPSB_SDVO_CTL_BORDER_EN_MASK) >> PVRPSB_SDVO_CTL_BORDER_EN_SHIFT)
#define PVRPSB_SDVO_CTL_BORDER_EN_SET(W, V)	(((W) & ~PVRPSB_SDVO_CTL_BORDER_EN_MASK) | (((V) << PVRPSB_SDVO_CTL_BORDER_EN_SHIFT) & PVRPSB_SDVO_CTL_BORDER_EN_MASK))

#define PVRPSB_SDVO_CTL_PORT_DETECT_SHIFT	(2)
#define PVRPSB_SDVO_CTL_PORT_DETECT_MASK	(0x00000004)
#define PVRPSB_SDVO_CTL_PORT_DETECT_GET(W)	(((W) & PVRPSB_SDVO_CTL_PORT_DETECT_MASK) >> PVRPSB_SDVO_CTL_PORT_DETECT_SHIFT)


#define PVRPSB_LVDS_CTL				(0x61180)

#define PVRPSB_LVDS_CTL_ENABLE_SHIFT		(31)
#define PVRPSB_LVDS_CTL_ENABLE_MASK		(0x80000000)
#define PVRPSB_LVDS_CTL_ENABLE_GET(W)		(((W) & PVRPSB_LVDS_CTL_ENABLE_MASK) >> PVRPSB_LVDS_CTL_ENABLE_SHIFT)
#define PVRPSB_LVDS_CTL_ENABLE_SET(W, V)	(((W) & ~PVRPSB_LVDS_CTL_ENABLE_MASK) | (((V) << PVRPSB_LVDS_CTL_ENABLE_SHIFT) & PVRPSB_LVDS_CTL_ENABLE_MASK))

#define PVRPSB_LVDS_CTL_PIPE_SHIFT		(30)
#define PVRPSB_LVDS_CTL_PIPE_MASK		(0x40000000)
#define PVRPSB_LVDS_CTL_PIPE_GET(W)		(((W) & PVRPSB_LVDS_CTL_PIPE_MASK) >> PVRPSB_LVDS_CTL_PIPE_SHIFT)
#define PVRPSB_LVDS_CTL_PIPE_SET(W, V)		(((W) & ~PVRPSB_LVDS_CTL_PIPE_MASK) | (((V) << PVRPSB_LVDS_CTL_PIPE_SHIFT) & PVRPSB_LVDS_CTL_PIPE_MASK))


#define PVRPSB_VGA_CTL				(0x71400)

#define PVRPSB_VGA_CTL_DISABLE_SHIFT		(31)
#define PVRPSB_VGA_CTL_DISABLE_MASK		(0x80000000)
#define PVRPSB_VGA_CTL_DISABLE_GET(W)		(((W) & PVRPSB_VGA_CTL_DISABLE_MASK) >> PVRPSB_VGA_CTL_DISABLE_SHIFT)
#define PVRPSB_VGA_CTL_DISABLE_SET(W, V)	(((W) & ~PVRPSB_VGA_CTL_DISABLE_MASK) | (((V) << PVRPSB_VGA_CTL_DISABLE_SHIFT) & PVRPSB_VGA_CTL_DISABLE_MASK))


#define PVRPSB_PIPEACONF			(0x70008)
#define PVRPSB_PIPEBCONF			(0x71008)

#define PVRPSB_PIPECONF_ENABLE_SHIFT		(31)
#define PVRPSB_PIPECONF_ENABLE_MASK		(0x80000000)
#define PVRPSB_PIPECONF_ENABLE_GET(W)		(((W) & PVRPSB_PIPECONF_ENABLE_MASK) >> PVRPSB_PIPECONF_ENABLE_SHIFT)
#define PVRPSB_PIPECONF_ENABLE_SET(W, V)	(((W) & ~PVRPSB_PIPECONF_ENABLE_MASK) | (((V) << PVRPSB_PIPECONF_ENABLE_SHIFT) & PVRPSB_PIPECONF_ENABLE_MASK))

#define PVRPSB_PIPECONF_STATE_SHIFT		(30)
#define PVRPSB_PIPECONF_STATE_MASK		(0x40000000)
#define PVRPSB_PIPECONF_STATE_GET(W)		(((W) & PVRPSB_PIPECONF_STATE_MASK) >> PVRPSB_PIPECONF_STATE_SHIFT)
#define PVRPSB_PIPECONF_STATE_SET(W, V)		(((W) & ~PVRPSB_PIPECONF_STATE_MASK) | (((V) << PVRPSB_PIPECONF_STATE_SHIFT) & PVRPSB_PIPECONF_STATE_MASK))
#define PVRPSB_PIPECONF_STATE_DISABLED		(0)
#define PVRPSB_PIPECONF_STATE_ENABLED		(1)

#define PVRPSB_PIPECONF_GAMMA_SHIFT		(24)
#define PVRPSB_PIPECONF_GAMMA_MASK		(0x01000000)
#define PVRPSB_PIPECONF_GAMMA_GET(W)		(((W) & PVRPSB_PIPECONF_GAMMA_MASK) >> PVRPSB_PIPECONF_GAMMA_SHIFT)
#define PVRPSB_PIPECONF_GAMMA_SET(W, V)		(((W) & ~PVRPSB_PIPECONF_GAMMA_MASK) | (((V) << PVRPSB_PIPECONF_GAMMA_SHIFT) & PVRPSB_PIPECONF_GAMMA_MASK))
#define PVRPSB_PIPECONF_GAMMA_8BIT_PALET	(0)
#define PVRPSB_PIPECONF_GAMMA_10BIT		(1)

#define PVRPSB_PIPECONF_INTERLACED_SHIFT	(21)
#define PVRPSB_PIPECONF_INTERLACED_MASK		(0x00E00000)
#define PVRPSB_PIPECONF_INTERLACED_GET(W)	(((W) & PVRPSB_PIPECONF_INTERLACED_MASK) >> PVRPSB_PIPECONF_INTERLACED_SHIFT)
#define PVRPSB_PIPECONF_INTERLACED_SET(W, V)	(((W) & ~PVRPSB_PIPECONF_INTERLACED_MASK) | (((V) << PVRPSB_PIPECONF_INTERLACED_SHIFT) & PVRPSB_PIPECONF_INTERLACED_MASK))
#define PVRPSB_PIPECONF_INTERLACED_PROG		(0)
#define PVRPSB_PIPECONF_INTERLACED_EMBED	(4)
#define PVRPSB_PIPECONF_INTERLACED_VSYNC	(5)
#define PVRPSB_PIPECONF_INTERLACED_SYNC_FIELD	(6)
#define PVRPSB_PIPECONF_INTERLACED_FIELD0	(7)

/* Turn display/overlay planes off */
#define PVRPSB_PIPECONF_PLANES_OFF_SHIFT	(19)
#define PVRPSB_PIPECONF_PLANES_OFF_MASK		(0x00080000)
#define PVRPSB_PIPECONF_PLANES_OFF_GET(W)	(((W) & PVRPSB_PIPECONF_PLANES_OFF_MASK) >> PVRPSB_PIPECONF_PLANES_OFF_SHIFT)
#define PVRPSB_PIPECONF_PLANES_OFF_SET(W, V)	(((W) & ~PVRPSB_PIPECONF_PLANES_OFF_MASK) | (((V) << PVRPSB_PIPECONF_PLANES_OFF_SHIFT) & PVRPSB_PIPECONF_PLANES_OFF_MASK))

/* Turn cursor plane off */
#define PVRPSB_PIPECONF_CURSOR_OFF_SHIFT	(18)
#define PVRPSB_PIPECONF_CURSOR_OFF_MASK		(0x00040000)
#define PVRPSB_PIPECONF_CURSOR_OFF_GET(W)	(((W) & PVRPSB_PIPECONF_CURSOR_OFF_MASK) >> PVRPSB_PIPECONF_CURSOR_OFF_SHIFT)
#define PVRPSB_PIPECONF_CURSOR_OFF_SET(W, V)	(((W) & ~PVRPSB_PIPECONF_CURSOR_OFF_MASK) | (((V) << PVRPSB_PIPECONF_CURSOR_OFF_SHIFT) & PVRPSB_PIPECONF_CURSOR_OFF_MASK))

#define PVRPSB_PIPECONF_REFRESH_MODE_SHIFT	(16)
#define PVRPSB_PIPECONF_REFRESH_MODE_MASK	(0x00030000)
#define PVRPSB_PIPECONF_REFRESH_MODE_GET(W)	(((W) & PVRPSB_PIPECONF_REFRESH_MODE_MASK) >> PVRPSB_PIPECONF_REFRESH_MODE_SHIFT)
#define PVRPSB_PIPECONF_REFRESH_MODE_SET(W, V)	(((W) & ~PVRPSB_PIPECONF_REFRESH_MODE_MASK) | (((V) << PVRPSB_PIPECONF_REFRESH_MODE_SHIFT) & PVRPSB_PIPECONF_REFRESH_MODE_MASK))
#define PVRPSB_PIPECONF_REFRESH_MODE_OFF	(0)
#define PVRPSB_PIPECONF_REFRESH_MODE_PROG2PROG	(1)
#define PVRPSB_PIPECONF_REFRESH_MODE_PROG2INTER	(2)


#define PVRPSB_PIPEASTAT			(0x70024)
#define PVRPSB_PIPEBSTAT			(0x71024)

#define PVRPSB_PIPESTAT_FIFO_STATUS_SHIFT	(31)
#define PVRPSB_PIPESTAT_FIFO_STATUS_MASK	(0x80000000)
#define PVRPSB_PIPESTAT_FIFO_STATUS_GET(W)	(((W) & PVRPSB_PIPESTAT_FIFO_STATUS_MASK) >> PVRPSB_PIPESTAT_FIFO_STATUS_SHIFT)
#define PVRPSB_PIPESTAT_FIFO_STATUS_OK		(0)
#define PVRPSB_PIPESTAT_FIFO_STATUS_UNDERFLOW	(1)

#define PVRPSB_PIPESTAT_CRC_ERR_ENSHIFT		(29)
#define PVRPSB_PIPESTAT_CRC_ERR_ENMASK		(0x20000000)
#define PVRPSB_PIPESTAT_CRC_ERR_ENGET(W)	(((W) & PVRPSB_PIPESTAT_CRC_ERR_ENMASK) >> PVRPSB_PIPESTAT_CRC_ERR_ENSHIFT)
#define PVRPSB_PIPESTAT_CRC_ERR_ENSET(W, V)	(((W) & ~PVRPSB_PIPESTAT_CRC_ERR_ENMASK) | (((V) << PVRPSB_PIPESTAT_CRC_ERR_ENSHIFT) & PVRPSB_PIPESTAT_CRC_ERR_ENMASK))

#define PVRPSB_PIPESTAT_CRC_DONE_EN_SHIFT	(28)
#define PVRPSB_PIPESTAT_CRC_DONE_EN_MASK	(0x10000000)
#define PVRPSB_PIPESTAT_CRC_DONE_EN_GET(W)	(((W) & PVRPSB_PIPESTAT_CRC_DONE_EN_MASK) >> PVRPSB_PIPESTAT_CRC_DONE_EN_SHIFT)

#define PVRPSB_PIPESTAT_GMBUS_EVENT_EN_SHIFT	(27)
#define PVRPSB_PIPESTAT_GMBUS_EVENT_EN_MASK	(0x08000000)
#define PVRPSB_PIPESTAT_GMBUS_EVENT_EN_GET(W)	(((W) & PVRPSB_PIPESTAT_GMBUS_EVENT_EN_MASK) >> PVRPSB_PIPESTAT_GMBUS_EVENT_EN_SHIFT)
#define PVRPSB_PIPESTAT_GMBUS_EVENT_EN_SET(W, V) (((W) & ~PVRPSB_PIPESTAT_GMBUS_EVENT_EN_MASK) | (((V) << PVRPSB_PIPESTAT_GMBUS_EVENT_EN_SHIFT) & PVRPSB_PIPESTAT_GMBUS_EVENT_EN_MASK))

#define PVRPSB_PIPESTAT_VSYNC_EN_SHIFT		(27)
#define PVRPSB_PIPESTAT_VSYNC_EN_MASK		(0x08000000)
#define PVRPSB_PIPESTAT_VSYNC_EN_GET(W)		(((W) & PVRPSB_PIPESTAT_VSYNC_EN_MASK) >> PVRPSB_PIPESTAT_VSYNC_EN_SHIFT)
#define PVRPSB_PIPESTAT_VSYNC_EN_SET(W, V) 	(((W) & ~PVRPSB_PIPESTAT_VSYNC_EN_MASK) | (((V) << PVRPSB_PIPESTAT_VSYNC_EN_SHIFT) & PVRPSB_PIPESTAT_VSYNC_EN_MASK))

#define PVRPSB_PIPESTAT_DL_COMP_EN_SHIFT	(25)
#define PVRPSB_PIPESTAT_DL_COMP_EN_MASK		(0x02000000)
#define PVRPSB_PIPESTAT_DL_COMP_EN_GET(W)	(((W) & PVRPSB_PIPESTAT_DL_COMP_EN_MASK) >> PVRPSB_PIPESTAT_DL_COMP_EN_SHIFT)
#define PVRPSB_PIPESTAT_DL_COMP_EN_SET(W, V) 	(((W) & ~PVRPSB_PIPESTAT_DL_COMP_EN_MASK) | (((V) << PVRPSB_PIPESTAT_DL_COMP_EN_SHIFT) & PVRPSB_PIPESTAT_DL_COMP_EN_MASK))

#define PVRPSB_PIPESTAT_ODD_FIELD_EN_SHIFT	(21)
#define PVRPSB_PIPESTAT_ODD_FIELD_EN_MASK	(0x00200000)
#define PVRPSB_PIPESTAT_ODD_FIELD_EN_GET(W)	(((W) & PVRPSB_PIPESTAT_ODD_FIELD_EN_MASK) >> PVRPSB_PIPESTAT_ODD_FIELD_EN_SHIFT)
#define PVRPSB_PIPESTAT_ODD_FIELD_EN_SET(W, V) 	(((W) & ~PVRPSB_PIPESTAT_ODD_FIELD_EN_MASK) | (((V) << PVRPSB_PIPESTAT_ODD_FIELD_EN_SHIFT) & PVRPSB_PIPESTAT_ODD_FIELD_EN_MASK))
 
#define PVRPSB_PIPESTAT_EVEN_FIELD_EN_SHIFT	(20)
#define PVRPSB_PIPESTAT_EVEN_FIELD_EN_MASK	(0x00100000)
#define PVRPSB_PIPESTAT_EVEN_FIELD_EN_GET(W)	(((W) & PVRPSB_PIPESTAT_EVEN_FIELD_EN_MASK) >> PVRPSB_PIPESTAT_EVEN_FIELD_EN_SHIFT)
#define PVRPSB_PIPESTAT_EVEN_FIELD_EN_SET(W, V)	(((W) & ~PVRPSB_PIPESTAT_EVEN_FIELD_EN_MASK) | (((V) << PVRPSB_PIPESTAT_EVEN_FIELD_EN_SHIFT) & PVRPSB_PIPESTAT_EVEN_FIELD_EN_MASK))

#define PVRPSB_PIPESTAT_START_VBLANK_EN_SHIFT	(18)
#define PVRPSB_PIPESTAT_START_VBLANK_EN_MASK	(0x00040000)
#define PVRPSB_PIPESTAT_START_VBLANK_EN_GET(W)	(((W) & PVRPSB_PIPESTAT_START_VBLANK_EN_MASK) >> PVRPSB_PIPESTAT_START_VBLANK_EN_SHIFT)
#define PVRPSB_PIPESTAT_START_VBLANK_EN_SET(W, V) (((W) & ~PVRPSB_PIPESTAT_START_VBLANK_EN_MASK) | (((V) << PVRPSB_PIPESTAT_START_VBLANK_EN_SHIFT) & PVRPSB_PIPESTAT_START_VBLANK_EN_MASK))

#define PVRPSB_PIPESTAT_VBLANK_EN_SHIFT		(17)
#define PVRPSB_PIPESTAT_VBLANK_EN_MASK		(0x00020000)
#define PVRPSB_PIPESTAT_VBLANK_EN_GET(W)	(((W) & PVRPSB_PIPESTAT_VBLANK_EN_MASK) >> PVRPSB_PIPESTAT_VBLANK_EN_SHIFT)
#define PVRPSB_PIPESTAT_VBLANK_EN_SET(W, V)	(((W) & ~PVRPSB_PIPESTAT_VBLANK_EN_MASK) | (((V) << PVRPSB_PIPESTAT_VBLANK_EN_SHIFT) & PVRPSB_PIPESTAT_VBLANK_EN_MASK))

#define PVRPSB_PIPESTAT_OVERLAY_UP_EN_SHIFT	(16)
#define PVRPSB_PIPESTAT_OVERLAY_UP_EN_MASK	(0x00010000)
#define PVRPSB_PIPESTAT_OVERLAY_UP_EN_GET(W)	(((W) & PVRPSB_PIPESTAT_OVERLAY_UP_EN_MASK) >> PVRPSB_PIPESTAT_OVERLAY_UP_EN_SHIFT)
#define PVRPSB_PIPESTAT_OVERLAY_UP_EN_SET(W, V)	(((W) & ~PVRPSB_PIPESTAT_OVERLAY_UP_EN_MASK) | (((V) << PVRPSB_PIPESTAT_OVERLAY_UP_EN_SHIFT) & PVRPSB_PIPESTAT_OVERLAY_UP_EN_MASK))

#define PVRPSB_PIPESTAT_CRC_ERR_STAT_SHIFT	(13)
#define PVRPSB_PIPESTAT_CRC_ERR_STAT_MASK	(0x00002000)
#define PVRPSB_PIPESTAT_CRC_ERR_STAT_GET(W)	(((W) & PVRPSB_PIPESTAT_CRC_ERR_STAT_MASK) >> PVRPSB_PIPESTAT_CRC_ERR_STAT_SHIFT)

#define PVRPSB_PIPESTAT_CRC_DONE_STAT_SHIFT	(12)
#define PVRPSB_PIPESTAT_CRC_DONE_STAT_MASK	(0x00001000)
#define PVRPSB_PIPESTAT_CRC_DONE_STAT_GET(W)	(((W) & PVRPSB_PIPESTAT_CRC_DONE_STAT_MASK) >> PVRPSB_PIPESTAT_CRC_DONE_STAT_SHIFT)

#define PVRPSB_PIPESTAT_GMBUS_STAT_SHIFT	(11)
#define PVRPSB_PIPESTAT_GMBUS_STAT_MASK		(0x00000800)
#define PVRPSB_PIPESTAT_GMBUS_STAT_GET(W)	(((W) & PVRPSB_PIPESTAT_GMBUS_STAT_MASK) >> PVRPSB_PIPESTAT_GMBUS_STAT_SHIFT)

#define PVRPSB_PIPESTAT_VSYNC_STAT_SHIFT	(9)
#define PVRPSB_PIPESTAT_VSYNC_STAT_MASK		(0x00000200)
#define PVRPSB_PIPESTAT_VSYNC_STAT_GET(W)	(((W) & PVRPSB_PIPESTAT_VSYNC_STAT_MASK) >> PVRPSB_PIPESTAT_VSYNC_STAT_SHIFT)

#define PVRPSB_PIPESTAT_DL_COMP_STAT_SHIFT	(8)
#define PVRPSB_PIPESTAT_DL_COMP_STAT_MASK	(0x00000100)
#define PVRPSB_PIPESTAT_DL_COMP_STAT_GET(W)	(((W) & PVRPSB_PIPESTAT_DL_COMP_STAT_MASK) >> PVRPSB_PIPESTAT_DL_COMP_STAT_SHIFT)

#define PVRPSB_PIPESTAT_ODD_FIELD_STAT_SHIFT	(5)
#define PVRPSB_PIPESTAT_ODD_FIELD_STAT_MASK	(0x00000020)
#define PVRPSB_PIPESTAT_ODD_FIELD_STAT_GET(W)	(((W) & PVRPSB_PIPESTAT_ODD_FIELD_STAT_MASK) >> PVRPSB_PIPESTAT_ODD_FIELD_STAT_SHIFT)

#define PVRPSB_PIPESTAT_EVEN_FIELD_STAT_SHIFT	(4)
#define PVRPSB_PIPESTAT_EVEN_FIELD_STAT_MASK	(0x00000010)
#define PVRPSB_PIPESTAT_EVEN_FIELD_STAT_GET(W)	(((W) & PVRPSB_PIPESTAT_EVEN_FIELD_STAT_MASK) >> PVRPSB_PIPESTAT_EVEN_FIELD_STAT_SHIFT)

#define PVRPSB_PIPESTAT_START_VBLANK_STAT_SHIFT	(2)
#define PVRPSB_PIPESTAT_START_VBLANK_STAT_MASK	(0x00000004)
#define PVRPSB_PIPESTAT_START_VBLANK_STAT_GET(W) (((W) & PVRPSB_PIPESTAT_START_VBLANK_STAT_MASK) >> PVRPSB_PIPESTAT_START_VBLANK_STAT_SHIFT)

#define PVRPSB_PIPESTAT_VBLANK_STAT_SHIFT	(1)
#define PVRPSB_PIPESTAT_VBLANK_STAT_MASK	(0x00000002)
#define PVRPSB_PIPESTAT_VBLANK_STAT_GET(W)	(((W) & PVRPSB_PIPESTAT_VBLANK_STAT_MASK) >> PVRPSB_PIPESTAT_VBLANK_STAT_SHIFT)

#define PVRPSB_PIPESTAT_OVERLAY_UP_STAT_SHIFT	(0)
#define PVRPSB_PIPESTAT_OVERLAY_UP_STAT_MASK	(0x00000001)
#define PVRPSB_PIPESTAT_OVERLAY_UP_STAT_GET(W)	(((W) & PVRPSB_PIPESTAT_OVERLAY_UP_STAT_MASK) >> PVRPSB_PIPESTAT_OVERLAY_UP_STAT_SHIFT)


#define PVRPSB_HOTPLUG				(0x61110)

#define PVRPSB_HOTPLUG_SDVOB_EN_SHIFT		(26)
#define PVRPSB_HOTPLUG_SDVOB_EN_MASK		(0x04000000)
#define PVRPSB_HOTPLUG_SDVOB_EN_GET(W)		(((W) & PVRPSB_HOTPLUG_SDVOB_EN_MASK) >> PVRPSB_HOTPLUG_SDVOB_EN_SHIFT)
#define PVRPSB_HOTPLUG_SDVOB_EN_SET(W, V)	(((W) & ~PVRPSB_HOTPLUG_SDVOB_EN_MASK) | (((V) << PVRPSB_HOTPLUG_SDVOB_EN_SHIFT) & PVRPSB_HOTPLUG_SDVOB_EN_MASK))

#define PVRPSB_HOTPLUG_SDVOC_EN_SHIFT		(25)
#define PVRPSB_HOTPLUG_SDVOC_EN_MASK		(0x02000000)
#define PVRPSB_HOTPLUG_SDVOC_EN_GET(W)		(((W) & PVRPSB_HOTPLUG_SDVOC_EN_MASK) >> PVRPSB_HOTPLUG_SDVOC_EN_SHIFT)
#define PVRPSB_HOTPLUG_SDVOC_EN_SET(W, V)	(((W) & ~PVRPSB_HOTPLUG_SDVOC_EN_MASK) | (((V) << PVRPSB_HOTPLUG_SDVOC_EN_SHIFT) & PVRPSB_HOTPLUG_SDVOC_EN_MASK))

#define PVRPSB_HOTPLUG_TV_EN_SHIFT		(18)
#define PVRPSB_HOTPLUG_TV_EN_MASK		(0x00400000)
#define PVRPSB_HOTPLUG_TV_EN_GET(W)		(((W) & PVRPSB_HOTPLUG_TV_EN_MASK) >> PVRPSB_HOTPLUG_TV_EN_SHIFT)
#define PVRPSB_HOTPLUG_TV_EN_SET(W, V)		(((W) & ~PVRPSB_HOTPLUG_TV_EN_MASK) | (((V) << PVRPSB_HOTPLUG_TV_EN_SHIFT) & PVRPSB_HOTPLUG_TV_EN_MASK))

#define PVRPSB_HOTPLUG_CRT_EN_SHIFT		(9)
#define PVRPSB_HOTPLUG_CRT_EN_MASK		(0x00000200)
#define PVRPSB_HOTPLUG_CRT_EN_GET(W)		(((W) & PVRPSB_HOTPLUG_CRT_EN_MASK) >> PVRPSB_HOTPLUG_CRT_EN_SHIFT)
#define PVRPSB_HOTPLUG_CRT_EN_SET(W, V)		(((W) & ~PVRPSB_HOTPLUG_CRT_EN_MASK) | (((V) << PVRPSB_HOTPLUG_CRT_EN_SHIFT) & PVRPSB_HOTPLUG_CRT_EN_MASK))

#define PVRPSB_HOTPLUG_CRT_PERIOD_SHIFT		(8)
#define PVRPSB_HOTPLUG_CRT_PERIOD_MASK		(0x00000100)
#define PVRPSB_HOTPLUG_CRT_PERIOD_GET(W)	(((W) & PVRPSB_HOTPLUG_CRT_PERIOD_MASK) >> PVRPSB_HOTPLUG_CRT_PERIOD_SHIFT)
#define PVRPSB_HOTPLUG_CRT_PERIOD_SET(W, V)	(((W) & ~PVRPSB_HOTPLUG_CRT_PERIOD_MASK) | (((V) << PVRPSB_HOTPLUG_CRT_PERIOD_SHIFT) & PVRPSB_HOTPLUG_CRT_PERIOD_MASK))
#define PVRPSB_HOTPLUG_CRT_PERIOD_32		(0)
#define PVRPSB_HOTPLUG_CRT_PERIOD_64		(1)

#define PVRPSB_HOTPLUG_CRT_WARMUP_SHIFT		(7)
#define PVRPSB_HOTPLUG_CRT_WARMUP_MASK		(0x00000080)
#define PVRPSB_HOTPLUG_CRT_WARMUP_GET(W)	(((W) & PVRPSB_HOTPLUG_CRT_WARMUP_MASK) >> PVRPSB_HOTPLUG_CRT_WARMUP_SHIFT)
#define PVRPSB_HOTPLUG_CRT_WARMUP_SET(W, V)	(((W) & ~PVRPSB_HOTPLUG_CRT_WARMUP_MASK) | (((V) << PVRPSB_HOTPLUG_CRT_WARMUP_SHIFT) & PVRPSB_HOTPLUG_CRT_WARMUP_MASK))
#define PVRPSB_HOTPLUG_CRT_WARMUP_2M		(0)
#define PVRPSB_HOTPLUG_CRT_WARMUP_4M		(1)

#define PVRPSB_HOTPLUG_CRT_VOLT_SHIFT		(5)
#define PVRPSB_HOTPLUG_CRT_VOLT_MASK		(0x00000060)
#define PVRPSB_HOTPLUG_CRT_VOLT_GET(W)		(((W) & PVRPSB_HOTPLUG_CRT_VOLT_MASK) >> PVRPSB_HOTPLUG_CRT_VOLT_SHIFT)
#define PVRPSB_HOTPLUG_CRT_VOLT_SET(W, V)	(((W) & ~PVRPSB_HOTPLUG_CRT_VOLT_MASK) | (((V) << PVRPSB_HOTPLUG_CRT_VOLT_SHIFT) & PVRPSB_HOTPLUG_CRT_VOLT_MASK))
#define PVRPSB_HOTPLUG_CRT_VOLT_40		(0)
#define PVRPSB_HOTPLUG_CRT_VOLT_50		(1)
#define PVRPSB_HOTPLUG_CRT_VOLT_60		(2)
#define PVRPSB_HOTPLUG_CRT_VOLT_70		(3)

#define PVRPSB_HOTPLUG_CRT_DELAY_SHIFT		(4)
#define PVRPSB_HOTPLUG_CRT_DELAY_MASK		(0x00000010)
#define PVRPSB_HOTPLUG_CRT_DELAY_GET(W)		(((W) & PVRPSB_HOTPLUG_CRT_DELAY_MASK) >> PVRPSB_HOTPLUG_CRT_DELAY_SHIFT)
#define PVRPSB_HOTPLUG_CRT_DELAY_SET(W, V)	(((W) & ~PVRPSB_HOTPLUG_CRT_DELAY_MASK) | (((V) << PVRPSB_HOTPLUG_CRT_DELAY_SHIFT) & PVRPSB_HOTPLUG_CRT_DELAY_MASK))
#define PVRPSB_HOTPLUG_CRT_DELAY_1G		(0)
#define PVRPSB_HOTPLUG_CRT_DELAY_2G		(1)

#define PVRPSB_HOTPLUG_CRT_TRIGGER_SHIFT	(3)
#define PVRPSB_HOTPLUG_CRT_TRIGGER_MASK		(0x00000008)
#define PVRPSB_HOTPLUG_CRT_TRIGGER_GET(W)	(((W) & PVRPSB_HOTPLUG_CRT_TRIGGER_MASK) >> PVRPSB_HOTPLUG_CRT_TRIGGER_SHIFT)
#define PVRPSB_HOTPLUG_CRT_TRIGGER_SET(W, V)	(((W) & ~PVRPSB_HOTPLUG_CRT_TRIGGER_MASK) | (((V) << PVRPSB_HOTPLUG_CRT_TRIGGER_SHIFT) & PVRPSB_HOTPLUG_CRT_TRIGGER_MASK))


#define PVRPSB_HOTPLUG_STAT			(0x61114)

#define PVRPSB_HOTPLUG_CRT_INT_STAT_SHIFT	(11)
#define PVRPSB_HOTPLUG_CRT_INT_STAT_MASK	(0x00000800)
#define PVRPSB_HOTPLUG_CRT_INT_STAT_GET(W)	(((W) & PVRPSB_HOTPLUG_CRT_INT_STAT_MASK) >> PVRPSB_HOTPLUG_CRT_INT_STAT_SHIFT)
#define PVRPSB_HOTPLUG_CRT_INT_STAT_SET(W, V)	(((W) & ~PVRPSB_HOTPLUG_CRT_INT_STAT_MASK) | (((V) << PVRPSB_HOTPLUG_CRT_INT_STAT_SHIFT) & PVRPSB_HOTPLUG_CRT_INT_STAT_MASK))
#define PVRPSB_HOTPLUG_CRT_INT_STAT_NOT_OCCURRED (0)
#define PVRPSB_HOTPLUG_CRT_INT_STAT_OCCURRED	(1)

#define PVRPSB_HOTPLUG_TV_INT_STAT_SHIFT	(10)
#define PVRPSB_HOTPLUG_TV_INT_STAT_MASK		(0x00000400)
#define PVRPSB_HOTPLUG_TV_INT_STAT_GET(W)	(((W) & PVRPSB_HOTPLUG_TV_INT_STAT_MASK) >> PVRPSB_HOTPLUG_TV_INT_STAT_SHIFT)
#define PVRPSB_HOTPLUG_TV_INT_STAT_SET(W, V)	(((W) & ~PVRPSB_HOTPLUG_TV_INT_STAT_MASK) | (((V) << PVRPSB_HOTPLUG_TV_INT_STAT_SHIFT) & PVRPSB_HOTPLUG_TV_INT_STAT_MASK))
#define PVRPSB_HOTPLUG_TV_INT_STAT_NOT_OCCURRED	(0)
#define PVRPSB_HOTPLUG_TV_INT_STAT_OCCURRED	(1)

#define PVRPSB_HOTPLUG_CRT_DET_STAT_SHIFT	(8)
#define PVRPSB_HOTPLUG_CRT_DET_STAT_MASK	(0x00000300)
#define PVRPSB_HOTPLUG_CRT_DET_STAT_GET(W)	(((W) & PVRPSB_HOTPLUG_CRT_DET_STAT_MASK) >> PVRPSB_HOTPLUG_CRT_DET_STAT_SHIFT)
#define PVRPSB_HOTPLUG_CRT_DET_STAT_SET(W, V)	(((W) & ~PVRPSB_HOTPLUG_CRT_DET_STAT_MASK) | (((V) << PVRPSB_HOTPLUG_CRT_DET_STAT_SHIFT) & PVRPSB_HOTPLUG_CRT_DET_STAT_MASK))
#define PVRPSB_HOTPLUG_CRT_DET_STAT_NONE	(0)
#define PVRPSB_HOTPLUG_CRT_DET_STAT_BLUE	(1)
#define PVRPSB_HOTPLUG_CRT_DET_STAT_GREEN	(2)
#define PVRPSB_HOTPLUG_CRT_DET_STAT_BLUEGREEN	(3)

#define PVRPSB_HOTPLUG_SDVOC_INT_STAT_SHIFT	(4)
#define PVRPSB_HOTPLUG_SDVOC_INT_STAT_MASK	(0x00000030)
#define PVRPSB_HOTPLUG_SDVOC_INT_STAT_GET(W)	(((W) & PVRPSB_HOTPLUG_SDVOC_INT_STAT_MASK) >> PVRPSB_HOTPLUG_SDVOC_INT_STAT_SHIFT)
#define PVRPSB_HOTPLUG_SDVOC_INT_STAT_SET(W, V)	(((W) & ~PVRPSB_HOTPLUG_SDVOC_INT_STAT_MASK) | (((V) << PVRPSB_HOTPLUG_SDVOC_INT_STAT_SHIFT) & PVRPSB_HOTPLUG_SDVOC_INT_STAT_MASK))
#define PVRPSB_HOTPLUG_SDVOC_INT_STAT_NOT_OCCURRED (0)
#define PVRPSB_HOTPLUG_SDVOC_INT_STAT_LONG	(1)
#define PVRPSB_HOTPLUG_SDVOC_INT_STAT_SHORT	(2)

#define PVRPSB_HOTPLUG_SDVOB_INT_STAT_SHIFT	(2)
#define PVRPSB_HOTPLUG_SDVOB_INT_STAT_MASK	(0x0000000C)
#define PVRPSB_HOTPLUG_SDVOB_INT_STAT_GET(W)	(((W) & PVRPSB_HOTPLUG_SDVOB_INT_STAT_MASK) >> PVRPSB_HOTPLUG_SDVOB_INT_STAT_SHIFT)
#define PVRPSB_HOTPLUG_SDVOB_INT_STAT_SET(W, V)	(((W) & ~PVRPSB_HOTPLUG_SDVOB_INT_STAT_MASK) | (((V) << PVRPSB_HOTPLUG_SDVOB_INT_STAT_SHIFT) & PVRPSB_HOTPLUG_SDVOB_INT_STAT_MASK))
#define PVRPSB_HOTPLUG_SDVOB_INT_STAT_NOT_OCCURRED (0)
#define PVRPSB_HOTPLUG_SDVOB_INT_STAT_LONG	(1)
#define PVRPSB_HOTPLUG_SDVOB_INT_STAT_SHORT	(2)


#define PVRPSB_DSPARB				(0x70030)
#define PVRPSB_DSPFW1				(0x70034)
#define PVRPSB_DSPFW2				(0x70038)
#define PVRPSB_DSPFW3				(0x7003C)
#define PVRPSB_DSPFW4				(0x70050)
#define PVRPSB_DSPFW5				(0x70054)
#define PVRPSB_DSPFW6				(0x70058)


#define PVRPSB_CURACNTR				(0x70080)
#define PVRPSB_CURBCNTR				(0x700C0)

/* Select on which pipe the cursor should be shown */
#define PVRPSB_CURACNTR_PIPE_SHIFT		(28)
#define PVRPSB_CURACNTR_PIPE_MASK		(0x30000000)
#define PVRPSB_CURACNTR_PIPE_GET(W)		(((W) & PVRPSB_CURACNTR_PIPE_MASK) >> PVRPSB_CURACNTR_PIPE_SHIFT)
#define PVRPSB_CURACNTR_PIPE_SET(W, V)		(((W) & ~PVRPSB_CURACNTR_PIPE_MASK) | (((V) << PVRPSB_CURACNTR_PIPE_SHIFT) & PVRPSB_CURACNTR_PIPE_MASK))
#define PVRPSB_CURACNTR_PIPEA			(0)
#define PVRPSB_CURACNTR_PIPEB			(1)

/* Enabling popup mode means the cursor base address should be programmed with the physical address instead of the graphics address */
#define PVRPSB_CURACNTR_POPUP_SHIFT		(27)
#define PVRPSB_CURACNTR_POPUP_MASK		(0x08000000)
#define PVRPSB_CURACNTR_POPUP_GET(W)		(((W) & PVRPSB_CURACNTR_POPUP_MASK) >> PVRPSB_CURACNTR_POPUP_SHIFT)
#define PVRPSB_CURACNTR_POPUP_SET(W, V)		(((W) & ~PVRPSB_CURACNTR_POPUP_MASK) | (((V) << PVRPSB_CURACNTR_POPUP_SHIFT) & PVRPSB_CURACNTR_POPUP_MASK))

/* Will only effect non-VGA mode cursor */
#define PVRPSB_CURACNTR_GAMMA_SHIFT		(26)
#define PVRPSB_CURACNTR_GAMMA_MASK		(0x02000000)
#define PVRPSB_CURACNTR_GAMMA_GET(W)		(((W) & PVRPSB_CURACNTR_GAMMA_MASK) >> PVRPSB_CURACNTR_GAMMA_SHIFT)
#define PVRPSB_CURACNTR_GAMMA_SET(W, V)		(((W) & ~PVRPSB_CURACNTR_GAMMA_MASK) | (((V) << PVRPSB_CURACNTR_GAMMA_SHIFT) & PVRPSB_CURACNTR_GAMMA_MASK))

/* Only 32bits per pixel cursors can be rotated */
#define PVRPSB_CURACNTR_180_SHIFT		(15)
#define PVRPSB_CURACNTR_180_MASK		(0x00008000)
#define PVRPSB_CURACNTR_180_GET(W)		(((W) & PVRPSB_CURACNTR_180_MASK) >> PVRPSB_CURACNTR_180_SHIFT)
#define PVRPSB_CURACNTR_180_SET(W, V)		(((W) & ~PVRPSB_CURACNTR_180_MASK) | (((V) << PVRPSB_CURACNTR_180_SHIFT) & PVRPSB_CURACNTR_180_MASK))

#define PVRPSB_CURACNTR_MODE_SHIFT		(0)
#define PVRPSB_CURACNTR_MODE_MASK		(0x00000027)
#define PVRPSB_CURACNTR_MODE_GET(W)		(((W) & PVRPSB_CURACNTR_MODE_MASK) >> PVRPSB_CURACNTR_MODE_SHIFT)
#define PVRPSB_CURACNTR_MODE_SET(W, V)		(((W) & ~PVRPSB_CURACNTR_MODE_MASK) | (((V) << PVRPSB_CURACNTR_MODE_SHIFT) & PVRPSB_CURACNTR_MODE_MASK))
#define PVRPSB_CURACNTR_MODE_OFF		(0x0)	/* Disable the cursor */
#define PVRPSB_CURACNTR_MODE_128_32_XRGB	(0x2)	/* 128x128 32bpp XRGB (non-VGA) */
#define PVRPSB_CURACNTR_MODE_256_32_XRGB	(0x3)	/* 256x256 32bpp XRGB (non-VGA) */
#define PVRPSB_CURACNTR_MODE_64_2_3COLOUR	(0x4)	/* 64x64 2bpp 3 colours + transparency */
#define PVRPSB_CURACNTR_MODE_64_2_2PLANE	(0x5)	/* 64x64 2bpp AND/XOR 2-plane */
#define PVRPSB_CURACNTR_MODE_64_2_4COLOUR	(0x6)	/* 64x64 2bpp 4 colours */
#define PVRPSB_CURACNTR_MODE_64_32_RGB		(0x7)	/* 64x64 32bpp AND/XOR (non-VGA) */
#define PVRPSB_CURACNTR_MODE_128_32_ARGB	(0x22)	/* 128x128 32bpp ARGB (non-VGA) */
#define PVRPSB_CURACNTR_MODE_256_32_ARGB	(0x23)	/* 256x256 32bpp ARGB (non-VGA) */
#define PVRPSB_CURACNTR_MODE_64_32_ARGB		(0x27)	/* 64x64 32bpp ARGB (non-VGA) */


#define PVRPSB_CURABASE				(0x70084)
#define PVRPSB_CURBBASE				(0x700C4)

/* Specifies bits 31:4 of the physical address when PVRPSB_CURACNTR has popup mode enabled and 31:4 of the graphics address otherwise */ 
#define PVRPSB_CURABASE_ADDR_SHIFT		(4)
#define PVRPSB_CURABASE_ADDR_MASK		(0xFFFFFFF0)
#define PVRPSB_CURABASE_ADDR_GET(W)		(((W) & PVRPSB_CURABASE_ADDR_MASK) >> PVRPSB_CURABASE_ADDR_SHIFT)
#define PVRPSB_CURABASE_ADDR_SET(W, V)		(((W) & ~PVRPSB_CURABASE_ADDR_MASK) | (((V) << PVRPSB_CURABASE_ADDR_SHIFT) & PVRPSB_CURABASE_ADDR_MASK))

/* Specifies bits 35:32 of physical address when PVRPSB_CURACNTR has popup mode enabled */
#define PVRPSB_CURABASE_ADDR_MSB_SHIFT		(0)
#define PVRPSB_CURABASE_ADDR_MSB_MASK		(0x0000000F)
#define PVRPSB_CURABASE_ADDR_MSB_GET(W)		(((W) & PVRPSB_CURABASE_ADDR_MSB_MASK) >> PVRPSB_CURABASE_ADDR_MSB_SHIFT)
#define PVRPSB_CURABASE_ADDR_MSB_SET(W, V)	(((W) & ~PVRPSB_CURABASE_ADDR_MSB_MASK) | (((V) << PVRPSB_CURABASE_ADDR_MSB_SHIFT) & PVRPSB_CURABASE_ADDR_MSB_MASK))


#define PVRPSB_CURAPOS				(0x70088)
#define PVRPSB_CURBPOS				(0x700C8)

#define PVRPSB_CURAPOS_YSIGN_SHIFT		(31)
#define PVRPSB_CURAPOS_YSIGN_MASK		(0x80000000)
#define PVRPSB_CURAPOS_YSIGN_GET(W)		(((W) & PVRPSB_CURAPOS_YSIGN_MASK) >> PVRPSB_CURAPOS_YSIGN_SHIFT)
#define PVRPSB_CURAPOS_YSIGN_SET(W, V)		(((W) & ~PVRPSB_CURAPOS_YSIGN_MASK) | (((V) << PVRPSB_CURAPOS_YSIGN_SHIFT) & PVRPSB_CURAPOS_YSIGN_MASK))

#define PVRPSB_CURAPOS_YMAG_SHIFT		(16)
#define PVRPSB_CURAPOS_YMAG_MASK		(0x0FFF0000)
#define PVRPSB_CURAPOS_YMAG_GET(W)		(((W) & PVRPSB_CURAPOS_YMAG_MASK) >> PVRPSB_CURAPOS_YMAG_SHIFT)
#define PVRPSB_CURAPOS_YMAG_SET(W, V)		(((W) & ~PVRPSB_CURAPOS_YMAG_MASK) | (((V) << PVRPSB_CURAPOS_YMAG_SHIFT) & PVRPSB_CURAPOS_YMAG_MASK))

#define PVRPSB_CURAPOS_XSIGN_SHIFT		(15)
#define PVRPSB_CURAPOS_XSIGN_MASK		(0x00008000)
#define PVRPSB_CURAPOS_XSIGN_GET(W)		(((W) & PVRPSB_CURAPOS_XSIGN_MASK) >> PVRPSB_CURAPOS_XSIGN_SHIFT)
#define PVRPSB_CURAPOS_XSIGN_SET(W, V)		(((W) & ~PVRPSB_CURAPOS_XSIGN_MASK) | (((V) << PVRPSB_CURAPOS_XSIGN_SHIFT) & PVRPSB_CURAPOS_XSIGN_MASK))

#define PVRPSB_CURAPOS_XMAG_SHIFT		(0)
#define PVRPSB_CURAPOS_XMAG_MASK		(0x00000FFF)
#define PVRPSB_CURAPOS_XMAG_GET(W)		(((W) & PVRPSB_CURAPOS_XMAG_MASK) >> PVRPSB_CURAPOS_XMAG_SHIFT)
#define PVRPSB_CURAPOS_XMAG_SET(W, V)		(((W) & ~PVRPSB_CURAPOS_XMAG_MASK) | (((V) << PVRPSB_CURAPOS_XMAG_SHIFT) & PVRPSB_CURAPOS_XMAG_MASK))


#define PVRPSB_CURAPALET0			(0x70090)
#define PVRPSB_CURAPALET1			(0x70094)
#define PVRPSB_CURAPALET2			(0x70098)
#define PVRPSB_CURAPALET3			(0x7009C)
#define PVRPSB_CURBPALET0			(0x700D0)
#define PVRPSB_CURBPALET1			(0x700D4)
#define PVRPSB_CURBPALET2			(0x700D8)
#define PVRPSB_CURBPALET3			(0x700DC)


#define PVRPSB_DSPACNTR				(0x70180) /* Plane A */
#define PVRPSB_DSPBCNTR				(0x71180) /* Plane B */

#define PVRPSB_DSPCNTR_ENABLE_SHIFT		(31)
#define PVRPSB_DSPCNTR_ENABLE_MASK		(0x80000000)
#define PVRPSB_DSPCNTR_ENABLE_GET(W)		(((W) & PVRPSB_DSPCNTR_ENABLE_MASK) >> PVRPSB_DSPCNTR_ENABLE_SHIFT)
#define PVRPSB_DSPCNTR_ENABLE_SET(W, V)		(((W) & ~PVRPSB_DSPCNTR_ENABLE_MASK) | (((V) << PVRPSB_DSPCNTR_ENABLE_SHIFT) & PVRPSB_DSPCNTR_ENABLE_MASK))

#define PVRPSB_DSPCNTR_GAMMA_SHIFT		(30)
#define PVRPSB_DSPCNTR_GAMMA_MASK		(0x40000000)
#define PVRPSB_DSPCNTR_GAMMA_GET(W)		(((W) & PVRPSB_DSPCNTR_GAMMA_MASK) >> PVRPSB_DSPCNTR_GAMMA_SHIFT)
#define PVRPSB_DSPCNTR_GAMMA_SET(W, V)		(((W) & ~PVRPSB_DSPCNTR_GAMMA_MASK) | (((V) << PVRPSB_DSPCNTR_GAMMA_SHIFT) & PVRPSB_DSPCNTR_GAMMA_MASK))

#define PVRPSB_DSPCNTR_FORMAT_SHIFT		(26)
#define PVRPSB_DSPCNTR_FORMAT_MASK		(0x3C000000)
#define PVRPSB_DSPCNTR_FORMAT_GET(W)		(((W) & PVRPSB_DSPCNTR_FORMAT_MASK) >> PVRPSB_DSPCNTR_FORMAT_SHIFT)
#define PVRPSB_DSPCNTR_FORMAT_SET(W, V)		(((W) & ~PVRPSB_DSPCNTR_FORMAT_MASK) | (((V) << PVRPSB_DSPCNTR_FORMAT_SHIFT) & PVRPSB_DSPCNTR_FORMAT_MASK))
#define PVRPSB_DSPCNTR_FORMAT_8BPP_INDEX	(0x2)
#define PVRPSB_DSPCNTR_FORMAT_B5G6R5		(0x5)
#define PVRPSB_DSPCNTR_FORMAT_B8G8R8X8		(0x6)
#define PVRPSB_DSPCNTR_FORMAT_R10G10B10X2	(0x8)
#define PVRPSB_DSPCNTR_FORMAT_B10G10R10X2	(0xA)
#define PVRPSB_DSPCNTR_FORMAT_R16G16B16X16	(0xC)
#define PVRPSB_DSPCNTR_FORMAT_R8G8B8X8		(0xE)

/* The documentation claims that Display Plane A is always attached to Pipe A */
#define PVRPSB_DSPCNTR_PIPE_SHIFT		(24)
#define PVRPSB_DSPCNTR_PIPE_MASK		(0x03000000)
#define PVRPSB_DSPCNTR_PIPE_GET(W)		(((W) & PVRPSB_DSPCNTR_PIPE_MASK) >> PVRPSB_DSPCNTR_PIPE_SHIFT)
#define PVRPSB_DSPCNTR_PIPE_A			(0)
#define PVRPSB_DSPCNTR_PIPE_B			(1)

#define PVRPSB_DSPCNTR_PIXELMULTI_SHIFT		(20)
#define PVRPSB_DSPCNTR_PIXELMULTI_MASK		(0x00300000)
#define PVRPSB_DSPCNTR_PIXELMULTI_GET(W)	(((W) & PVRPSB_DSPCNTR_PIXELMULTI_MASK) >> PVRPSB_DSPCNTR_PIXELMULTI_SHIFT)
#define PVRPSB_DSPCNTR_PIXELMULTI_SET(W, V)	(((W) & ~PVRPSB_DSPCNTR_PIXELMULTI_MASK) | (((V) << PVRPSB_DSPCNTR_PIXELMULTI_SHIFT) & PVRPSB_DSPCNTR_PIXELMULTI_MASK))
#define PVRPSB_DSPCNTR_PIXELMULTI_NONE		(0)
#define PVRPSB_DSPCNTR_PIXELMULTI_LINE_PIXEL	(1)
#define PVRPSB_DSPCNTR_PIXELMULTI_PIXEL		(3)

#define PVRPSB_DSPCNTR_180_SHIFT		(15)
#define PVRPSB_DSPCNTR_180_MASK			(0x00008000)
#define PVRPSB_DSPCNTR_180_GET(W)		(((W) & PVRPSB_DSPCNTR_180_MASK) >> PVRPSB_DSPCNTR_180_SHIFT)
#define PVRPSB_DSPCNTR_180_SET(W, V)		(((W) & ~PVRPSB_DSPCNTR_180_MASK) | (((V) << PVRPSB_DSPCNTR_180_SHIFT) & PVRPSB_DSPCNTR_180_MASK))

#define PVRPSB_DSPCNTR_TILED_SHIFT		(10)
#define PVRPSB_DSPCNTR_TILED_MASK		(0x00000400)
#define PVRPSB_DSPCNTR_TILED_GET(W)		(((W) & PVRPSB_DSPCNTR_TILED_MASK) >> PVRPSB_DSPCNTR_TILED_SHIFT)
#define PVRPSB_DSPCNTR_TILED_SET(W, V)		(((W) & ~PVRPSB_DSPCNTR_TILED_MASK) | (((V) << PVRPSB_DSPCNTR_TILED_SHIFT) & PVRPSB_DSPCNTR_TILED_MASK))


#define PVRPSB_DSPALINOFF			(0x70184) /* Plane A */
#define PVRPSB_DSPBLINOFF			(0x71184) /* Plane B */

#define PVRPSB_DSPLINOFF_OFFSET_SHIFT		(0)
#define PVRPSB_DSPLINOFF_OFFSET_MASK		(0xFFFFFFFF)
#define PVRPSB_DSPLINOFF_OFFSET_GET(W)		(((W) & PVRPSB_DSPLINOFF_OFFSET_MASK) >> PVRPSB_DSPLINOFF_OFFSET_SHIFT)
#define PVRPSB_DSPLINOFF_OFFSET_SET(W, V)	(((W) & ~PVRPSB_DSPLINOFF_OFFSET_MASK) | (((V) << PVRPSB_DSPLINOFF_OFFSET_SHIFT) & PVRPSB_DSPLINOFF_OFFSET_MASK))


#define PVRPSB_DSPASTRIDE			(0x70188) /* Plane A */
#define PVRPSB_DSPBSTRIDE			(0x71188) /* Plane B */

#define PVRPSB_DSPSTRIDE_STRIDE_SHIFT		(0)
#define PVRPSB_DSPSTRIDE_STRIDE_MASK		(0xFFFFFFFF)
#define PVRPSB_DSPSTRIDE_STRIDE_GET(W)		(((W) & PVRPSB_DSPSTRIDE_STRIDE_MASK) >> PVRPSB_DSPSTRIDE_STRIDE_SHIFT)
#define PVRPSB_DSPSTRIDE_STRIDE_SET(W, V)	(((W) & ~PVRPSB_DSPSTRIDE_STRIDE_MASK) | (((V) << PVRPSB_DSPSTRIDE_STRIDE_SHIFT) & PVRPSB_DSPSTRIDE_STRIDE_MASK))
#define PVRPSB_DSPSTRIDE_LINEAR_MEM		(64)
#define PVRPSB_DSPSTRIDE_TILED_MEM		(512)

/* Note: This is a guess based on CURPOS */
#define PVRPSB_DSPAPOS				(0x7018C) /* Plane A */
#define PVRPSB_DSPBPOS				(0x7118C) /* Plane B */

#define PVRPSB_DSPPOS_YSIGN_SHIFT		(31)
#define PVRPSB_DSPPOS_YSIGN_MASK		(0x80000000)
#define PVRPSB_DSPPOS_YSIGN_GET(W)		(((W) & PVRPSB_DSPPOS_YSIGN_MASK) >> PVRPSB_DSPPOS_YSIGN_SHIFT)
#define PVRPSB_DSPPOS_YSIGN_SET(W, V)		(((W) & ~PVRPSB_DSPPOS_YSIGN_MASK) | (((V) << PVRPSB_DSPPOS_YSIGN_SHIFT) & PVRPSB_DSPPOS_YSIGN_MASK))

#define PVRPSB_DSPPOS_YMAG_SHIFT		(16)
#define PVRPSB_DSPPOS_YMAG_MASK			(0x0FFF0000)
#define PVRPSB_DSPPOS_YMAG_GET(W)		(((W) & PVRPSB_DSPPOS_YMAG_MASK) >> PVRPSB_DSPPOS_YMAG_SHIFT)
#define PVRPSB_DSPPOS_YMAG_SET(W, V)		(((W) & ~PVRPSB_DSPPOS_YMAG_MASK) | (((V) << PVRPSB_DSPPOS_YMAG_SHIFT) & PVRPSB_DSPPOS_YMAG_MASK))

#define PVRPSB_DSPPOS_XSIGN_SHIFT		(15)
#define PVRPSB_DSPPOS_XSIGN_MASK		(0x00008000)
#define PVRPSB_DSPPOS_XSIGN_GET(W)		(((W) & PVRPSB_DSPPOS_XSIGN_MASK) >> PVRPSB_DSPPOS_XSIGN_SHIFT)
#define PVRPSB_DSPPOS_XSIGN_SET(W, V)		(((W) & ~PVRPSB_DSPPOS_XSIGN_MASK) | (((V) << PVRPSB_DSPPOS_XSIGN_SHIFT) & PVRPSB_DSPPOS_XSIGN_MASK))

#define PVRPSB_DSPPOS_XMAG_SHIFT		(16)
#define PVRPSB_DSPPOS_XMAG_MASK			(0x00000FFF)
#define PVRPSB_DSPPOS_XMAG_GET(W)		(((W) & PVRPSB_DSPPOS_XMAG_MASK) >> PVRPSB_DSPPOS_XMAG_SHIFT)
#define PVRPSB_DSPPOS_XMAG_SET(W, V)		(((W) & ~PVRPSB_DSPPOS_XMAG_MASK) | (((V) << PVRPSB_DSPPOS_XMAG_SHIFT) & PVRPSB_DSPPOS_XMAG_MASK))


#define PVRPSB_DSPASIZE				(0x70190) /* Plane A */
#define PVRPSB_DSPBSIZE				(0x71190) /* Plane B */

#define PVRPSB_DSPSIZE_HEIGHT_SHIFT		(16)
#define PVRPSB_DSPSIZE_HEIGHT_MASK		(0x0FFF0000)
#define PVRPSB_DSPSIZE_HEIGHT_GET(W)		((((W) & PVRPSB_DSPSIZE_HEIGHT_MASK) >> PVRPSB_DSPSIZE_HEIGHT_SHIFT) + 1)
#define PVRPSB_DSPSIZE_HEIGHT_SET(W, V)		(((W) & ~PVRPSB_DSPSIZE_HEIGHT_MASK) | ((((V) - 1) << PVRPSB_DSPSIZE_HEIGHT_SHIFT) & PVRPSB_DSPSIZE_HEIGHT_MASK))

#define PVRPSB_DSPSIZE_WIDTH_SHIFT		(0)
#define PVRPSB_DSPSIZE_WIDTH_MASK		(0x0000FFF)
#define PVRPSB_DSPSIZE_WIDTH_GET(W)		((((W) & PVRPSB_DSPSIZE_WIDTH_MASK) >> PVRPSB_DSPSIZE_WIDTH_SHIFT) + 1)
#define PVRPSB_DSPSIZE_WIDTH_SET(W, V)		(((W) & ~PVRPSB_DSPSIZE_WIDTH_MASK) | ((((V) - 1) << PVRPSB_DSPSIZE_WIDTH_SHIFT) & PVRPSB_DSPSIZE_WIDTH_MASK))


#define PVRPSB_DSPASURF				(0x7019C) /* Plane A */
#define PVRPSB_DSPBSURF				(0x7119C) /* Plane B */


#define PVRPSB_DSPATILEOFF			(0x701A4) /* Plane A */
#define PVRPSB_DSPBTILEOFF			(0x711A4) /* Plane B */


#define PVRPSB_DSPCHICKEN			(0x70400)

#endif /* #if !defined(__POULSBO_REGS_H__) */

/******************************************************************************
 End of file (poulsbo_regs.h)
******************************************************************************/
