/* valafield.c generated by valac, the Vala compiler
 * generated from valafield.vala, do not modify */

/* valafield.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaFieldPrivate {
	ValaMemberBinding _binding;
	gboolean _is_volatile;
	gboolean _lock_used;
};

static gint ValaField_private_offset;
static gpointer vala_field_parent_class = NULL;
static ValaLockableIface * vala_field_vala_lockable_parent_iface = NULL;

static void vala_field_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor);
static void vala_field_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static void vala_field_real_replace_expression (ValaCodeNode* base,
                                         ValaExpression* old_node,
                                         ValaExpression* new_node);
static void vala_field_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type);
static gboolean vala_field_real_check (ValaCodeNode* base,
                                ValaCodeContext* context);
static void vala_field_finalize (ValaCodeNode * obj);

static inline gpointer
vala_field_get_instance_private (ValaField* self)
{
	return G_STRUCT_MEMBER_P (self, ValaField_private_offset);
}

/**
 * Creates a new field.
 *
 * @param name              field name
 * @param variable_type     field type
 * @param initializer       initializer expression
 * @param source_reference  reference to source code
 * @return                  newly created field
 */
ValaField*
vala_field_construct (GType object_type,
                      const gchar* name,
                      ValaDataType* variable_type,
                      ValaExpression* initializer,
                      ValaSourceReference* source_reference,
                      ValaComment* comment)
{
	ValaField* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (variable_type != NULL, NULL);
	self = (ValaField*) vala_variable_construct (object_type, variable_type, name, initializer, source_reference, comment);
	return self;
}

ValaField*
vala_field_new (const gchar* name,
                ValaDataType* variable_type,
                ValaExpression* initializer,
                ValaSourceReference* source_reference,
                ValaComment* comment)
{
	return vala_field_construct (VALA_TYPE_FIELD, name, variable_type, initializer, source_reference, comment);
}

static void
vala_field_real_accept (ValaCodeNode* base,
                        ValaCodeVisitor* visitor)
{
	ValaField * self;
	self = (ValaField*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_field (visitor, self);
}

static void
vala_field_real_accept_children (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaField * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaField*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp5_ = _tmp4_;
		vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
	}
}

static void
vala_field_real_replace_expression (ValaCodeNode* base,
                                    ValaExpression* old_node,
                                    ValaExpression* new_node)
{
	ValaField * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaField*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}

static void
vala_field_real_replace_type (ValaCodeNode* base,
                              ValaDataType* old_type,
                              ValaDataType* new_type)
{
	ValaField * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaField*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_field_real_check (ValaCodeNode* base,
                       ValaCodeContext* context)
{
	ValaField * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp28_;
	ValaDataType* _tmp29_;
	ValaTypeSymbol* _tmp30_;
	ValaTypeSymbol* _tmp31_;
	ValaSemanticAnalyzer* _tmp32_;
	ValaSemanticAnalyzer* _tmp33_;
	ValaDataType* _tmp34_;
	ValaTypeSymbol* _tmp35_;
	ValaTypeSymbol* _tmp36_;
	ValaDataType* _tmp47_;
	ValaDataType* _tmp48_;
	ValaSemanticAnalyzer* _tmp49_;
	ValaSemanticAnalyzer* _tmp50_;
	ValaDataType* _tmp51_;
	ValaDataType* _tmp52_;
	ValaArrayType* variable_array_type = NULL;
	ValaDataType* _tmp63_;
	ValaDataType* _tmp64_;
	gboolean _tmp65_ = FALSE;
	gboolean _tmp66_ = FALSE;
	gboolean _tmp67_ = FALSE;
	ValaArrayType* _tmp68_;
	gboolean _tmp80_ = FALSE;
	gboolean _tmp81_ = FALSE;
	ValaArrayType* _tmp82_;
	ValaExpression* _tmp91_;
	ValaExpression* _tmp92_;
	gboolean _tmp215_ = FALSE;
	ValaMemberBinding _tmp216_;
	gboolean field_in_header = FALSE;
	ValaSymbol* _tmp221_;
	ValaSymbol* _tmp222_;
	gboolean _tmp231_ = FALSE;
	gboolean _tmp232_ = FALSE;
	gboolean _tmp233_;
	gboolean _tmp234_;
	ValaSemanticAnalyzer* _tmp249_;
	ValaSemanticAnalyzer* _tmp250_;
	ValaSourceFile* _tmp251_;
	ValaSemanticAnalyzer* _tmp252_;
	ValaSemanticAnalyzer* _tmp253_;
	ValaSymbol* _tmp254_;
	gboolean _tmp255_;
	gboolean _tmp256_;
	gboolean result = FALSE;
	self = (ValaField*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	_tmp24_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp25_ = _tmp24_;
	if (VALA_IS_VOID_TYPE (_tmp25_)) {
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp27_ = _tmp26_;
		vala_report_error (_tmp27_, "'void' not supported as field type");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp28_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp29_ = _tmp28_;
	_tmp30_ = vala_data_type_get_data_type (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_code_context_get_analyzer (context);
	_tmp33_ = _tmp32_;
	_tmp34_ = _tmp33_->va_list_type;
	_tmp35_ = vala_data_type_get_data_type (_tmp34_);
	_tmp36_ = _tmp35_;
	if (_tmp31_ == _tmp36_) {
		ValaSourceReference* _tmp37_;
		ValaSourceReference* _tmp38_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		ValaTypeSymbol* _tmp41_;
		ValaTypeSymbol* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_data_type_get_data_type (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = g_strdup_printf ("`%s' not supported as field type", _tmp44_);
		_tmp46_ = _tmp45_;
		vala_report_error (_tmp38_, _tmp46_);
		_g_free0 (_tmp46_);
		_g_free0 (_tmp44_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp47_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp48_ = _tmp47_;
	vala_code_node_check ((ValaCodeNode*) _tmp48_, context);
	_tmp49_ = vala_code_context_get_analyzer (context);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp52_ = _tmp51_;
	if (!vala_semantic_analyzer_is_type_accessible (_tmp50_, (ValaSymbol*) self, _tmp52_)) {
		ValaSourceReference* _tmp53_;
		ValaSourceReference* _tmp54_;
		ValaDataType* _tmp55_;
		ValaDataType* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
		gchar* _tmp62_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp53_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp54_ = _tmp53_;
		_tmp55_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp56_ = _tmp55_;
		_tmp57_ = vala_code_node_to_string ((ValaCodeNode*) _tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp60_ = _tmp59_;
		_tmp61_ = g_strdup_printf ("field type `%s' is less accessible than field `%s'", _tmp58_, _tmp60_);
		_tmp62_ = _tmp61_;
		vala_report_error (_tmp54_, _tmp62_);
		_g_free0 (_tmp62_);
		_g_free0 (_tmp60_);
		_g_free0 (_tmp58_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp63_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp64_ = _tmp63_;
	variable_array_type = VALA_IS_ARRAY_TYPE (_tmp64_) ? ((ValaArrayType*) _tmp64_) : NULL;
	_tmp68_ = variable_array_type;
	if (_tmp68_ != NULL) {
		ValaArrayType* _tmp69_;
		gboolean _tmp70_;
		gboolean _tmp71_;
		_tmp69_ = variable_array_type;
		_tmp70_ = vala_array_type_get_fixed_length (_tmp69_);
		_tmp71_ = _tmp70_;
		_tmp67_ = _tmp71_;
	} else {
		_tmp67_ = FALSE;
	}
	if (_tmp67_) {
		ValaExpression* _tmp72_;
		ValaExpression* _tmp73_;
		_tmp72_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp73_ = _tmp72_;
		_tmp66_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp73_);
	} else {
		_tmp66_ = FALSE;
	}
	if (_tmp66_) {
		ValaExpression* _tmp74_;
		ValaExpression* _tmp75_;
		ValaInitializerList* _tmp76_;
		ValaInitializerList* _tmp77_;
		_tmp74_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp75_ = _tmp74_;
		_tmp76_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
		_tmp77_ = _tmp76_;
		_tmp65_ = _tmp77_ == NULL;
	} else {
		_tmp65_ = FALSE;
	}
	if (_tmp65_) {
		ValaSourceReference* _tmp78_;
		ValaSourceReference* _tmp79_;
		_tmp78_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp79_ = _tmp78_;
		vala_report_warning (_tmp79_, "Arrays with fixed length don't require an explicit instantiation");
		vala_variable_set_initializer ((ValaVariable*) self, NULL);
	}
	_tmp82_ = variable_array_type;
	if (_tmp82_ != NULL) {
		ValaArrayType* _tmp83_;
		gboolean _tmp84_;
		gboolean _tmp85_;
		_tmp83_ = variable_array_type;
		_tmp84_ = vala_array_type_get_inline_allocated (_tmp83_);
		_tmp85_ = _tmp84_;
		_tmp81_ = _tmp85_;
	} else {
		_tmp81_ = FALSE;
	}
	if (_tmp81_) {
		ValaArrayType* _tmp86_;
		gboolean _tmp87_;
		gboolean _tmp88_;
		_tmp86_ = variable_array_type;
		_tmp87_ = vala_array_type_get_fixed_length (_tmp86_);
		_tmp88_ = _tmp87_;
		_tmp80_ = !_tmp88_;
	} else {
		_tmp80_ = FALSE;
	}
	if (_tmp80_) {
		ValaSourceReference* _tmp89_;
		ValaSourceReference* _tmp90_;
		_tmp89_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp90_ = _tmp89_;
		vala_report_error (_tmp90_, "Inline allocated array as field requires to have fixed length");
	}
	_tmp91_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp92_ = _tmp91_;
	if (_tmp92_ != NULL) {
		ValaExpression* _tmp93_;
		ValaExpression* _tmp94_;
		ValaDataType* _tmp95_;
		ValaDataType* _tmp96_;
		gboolean is_initializer_list = FALSE;
		gint initializer_size = 0;
		ValaExpression* _tmp97_;
		ValaExpression* _tmp98_;
		ValaExpression* _tmp103_;
		ValaExpression* _tmp104_;
		ValaExpression* _tmp105_;
		ValaExpression* _tmp106_;
		ValaDataType* _tmp107_;
		ValaDataType* _tmp108_;
		ValaExpression* _tmp111_;
		ValaExpression* _tmp112_;
		ValaDataType* _tmp113_;
		ValaDataType* _tmp114_;
		ValaDataType* _tmp115_;
		ValaDataType* _tmp116_;
		gboolean _tmp131_ = FALSE;
		gboolean _tmp132_ = FALSE;
		gboolean _tmp133_ = FALSE;
		ValaArrayType* _tmp134_;
		gboolean _tmp148_ = FALSE;
		gboolean _tmp149_ = FALSE;
		ValaArrayType* _tmp150_;
		ValaExpression* _tmp160_;
		ValaExpression* _tmp161_;
		ValaDataType* _tmp162_;
		ValaDataType* _tmp163_;
		gboolean _tmp173_ = FALSE;
		ValaSymbol* _tmp174_;
		ValaSymbol* _tmp175_;
		gboolean _tmp180_ = FALSE;
		gboolean _tmp181_ = FALSE;
		ValaSymbol* _tmp182_;
		ValaSymbol* _tmp183_;
		gboolean _tmp197_ = FALSE;
		gboolean _tmp198_ = FALSE;
		gboolean _tmp199_ = FALSE;
		ValaMemberBinding _tmp200_;
		gboolean _tmp211_;
		gboolean _tmp212_;
		_tmp93_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp94_ = _tmp93_;
		_tmp95_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp96_ = _tmp95_;
		vala_expression_set_target_type (_tmp94_, _tmp96_);
		is_initializer_list = FALSE;
		initializer_size = -1;
		_tmp97_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp98_ = _tmp97_;
		if (VALA_IS_INITIALIZER_LIST (_tmp98_)) {
			ValaExpression* _tmp99_;
			ValaExpression* _tmp100_;
			gint _tmp101_;
			gint _tmp102_;
			_tmp99_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp100_ = _tmp99_;
			_tmp101_ = vala_initializer_list_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
			_tmp102_ = _tmp101_;
			initializer_size = _tmp102_;
			is_initializer_list = TRUE;
		}
		_tmp103_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp104_ = _tmp103_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp104_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp105_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp106_ = _tmp105_;
		_tmp107_ = vala_expression_get_value_type (_tmp106_);
		_tmp108_ = _tmp107_;
		if (_tmp108_ == NULL) {
			ValaSourceReference* _tmp109_;
			ValaSourceReference* _tmp110_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp109_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp110_ = _tmp109_;
			vala_report_error (_tmp110_, "expression type not allowed as initializer");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp111_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp112_ = _tmp111_;
		_tmp113_ = vala_expression_get_value_type (_tmp112_);
		_tmp114_ = _tmp113_;
		_tmp115_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp116_ = _tmp115_;
		if (!vala_data_type_compatible (_tmp114_, _tmp116_)) {
			ValaSourceReference* _tmp117_;
			ValaSourceReference* _tmp118_;
			ValaExpression* _tmp119_;
			ValaExpression* _tmp120_;
			ValaDataType* _tmp121_;
			ValaDataType* _tmp122_;
			gchar* _tmp123_;
			gchar* _tmp124_;
			ValaDataType* _tmp125_;
			ValaDataType* _tmp126_;
			gchar* _tmp127_;
			gchar* _tmp128_;
			gchar* _tmp129_;
			gchar* _tmp130_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp117_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp118_ = _tmp117_;
			_tmp119_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp120_ = _tmp119_;
			_tmp121_ = vala_expression_get_value_type (_tmp120_);
			_tmp122_ = _tmp121_;
			_tmp123_ = vala_code_node_to_string ((ValaCodeNode*) _tmp122_);
			_tmp124_ = _tmp123_;
			_tmp125_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp126_ = _tmp125_;
			_tmp127_ = vala_code_node_to_string ((ValaCodeNode*) _tmp126_);
			_tmp128_ = _tmp127_;
			_tmp129_ = g_strdup_printf ("Cannot convert from `%s' to `%s'", _tmp124_, _tmp128_);
			_tmp130_ = _tmp129_;
			vala_report_error (_tmp118_, _tmp130_);
			_g_free0 (_tmp130_);
			_g_free0 (_tmp128_);
			_g_free0 (_tmp124_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp134_ = variable_array_type;
		if (_tmp134_ != NULL) {
			ValaArrayType* _tmp135_;
			gboolean _tmp136_;
			gboolean _tmp137_;
			_tmp135_ = variable_array_type;
			_tmp136_ = vala_array_type_get_inline_allocated (_tmp135_);
			_tmp137_ = _tmp136_;
			_tmp133_ = _tmp137_;
		} else {
			_tmp133_ = FALSE;
		}
		if (_tmp133_) {
			ValaArrayType* _tmp138_;
			gboolean _tmp139_;
			gboolean _tmp140_;
			_tmp138_ = variable_array_type;
			_tmp139_ = vala_array_type_get_fixed_length (_tmp138_);
			_tmp140_ = _tmp139_;
			_tmp132_ = !_tmp140_;
		} else {
			_tmp132_ = FALSE;
		}
		if (_tmp132_) {
			_tmp131_ = is_initializer_list;
		} else {
			_tmp131_ = FALSE;
		}
		if (_tmp131_) {
			ValaArrayType* _tmp141_;
			gchar* _tmp142_;
			gchar* _tmp143_;
			ValaIntegerLiteral* _tmp144_;
			ValaIntegerLiteral* _tmp145_;
			ValaArrayType* _tmp146_;
			ValaArrayType* _tmp147_;
			_tmp141_ = variable_array_type;
			_tmp142_ = g_strdup_printf ("%i", initializer_size);
			_tmp143_ = _tmp142_;
			_tmp144_ = vala_integer_literal_new (_tmp143_, NULL);
			_tmp145_ = _tmp144_;
			vala_array_type_set_length (_tmp141_, (ValaExpression*) _tmp145_);
			_vala_code_node_unref0 (_tmp145_);
			_g_free0 (_tmp143_);
			_tmp146_ = variable_array_type;
			vala_array_type_set_fixed_length (_tmp146_, TRUE);
			_tmp147_ = variable_array_type;
			vala_data_type_set_nullable ((ValaDataType*) _tmp147_, FALSE);
		}
		_tmp150_ = variable_array_type;
		if (_tmp150_ != NULL) {
			ValaArrayType* _tmp151_;
			gboolean _tmp152_;
			gboolean _tmp153_;
			_tmp151_ = variable_array_type;
			_tmp152_ = vala_array_type_get_inline_allocated (_tmp151_);
			_tmp153_ = _tmp152_;
			_tmp149_ = _tmp153_;
		} else {
			_tmp149_ = FALSE;
		}
		if (_tmp149_) {
			ValaExpression* _tmp154_;
			ValaExpression* _tmp155_;
			ValaDataType* _tmp156_;
			ValaDataType* _tmp157_;
			_tmp154_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp155_ = _tmp154_;
			_tmp156_ = vala_expression_get_value_type (_tmp155_);
			_tmp157_ = _tmp156_;
			_tmp148_ = !VALA_IS_ARRAY_TYPE (_tmp157_);
		} else {
			_tmp148_ = FALSE;
		}
		if (_tmp148_) {
			ValaSourceReference* _tmp158_;
			ValaSourceReference* _tmp159_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp158_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp159_ = _tmp158_;
			vala_report_error (_tmp159_, "only arrays are allowed as initializer for arrays with fixed length");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp160_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp161_ = _tmp160_;
		_tmp162_ = vala_expression_get_value_type (_tmp161_);
		_tmp163_ = _tmp162_;
		if (vala_data_type_is_disposable (_tmp163_)) {
			gboolean _tmp164_ = FALSE;
			ValaDataType* _tmp165_;
			ValaDataType* _tmp166_;
			_tmp165_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp166_ = _tmp165_;
			if (!VALA_IS_POINTER_TYPE (_tmp166_)) {
				ValaDataType* _tmp167_;
				ValaDataType* _tmp168_;
				gboolean _tmp169_;
				gboolean _tmp170_;
				_tmp167_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp168_ = _tmp167_;
				_tmp169_ = vala_data_type_get_value_owned (_tmp168_);
				_tmp170_ = _tmp169_;
				_tmp164_ = !_tmp170_;
			} else {
				_tmp164_ = FALSE;
			}
			if (_tmp164_) {
				ValaSourceReference* _tmp171_;
				ValaSourceReference* _tmp172_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp171_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp172_ = _tmp171_;
				vala_report_error (_tmp172_, "Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
		_tmp174_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp175_ = _tmp174_;
		if (VALA_IS_NAMESPACE (_tmp175_)) {
			ValaExpression* _tmp176_;
			ValaExpression* _tmp177_;
			_tmp176_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp177_ = _tmp176_;
			_tmp173_ = !vala_expression_is_constant (_tmp177_);
		} else {
			_tmp173_ = FALSE;
		}
		if (_tmp173_) {
			ValaSourceReference* _tmp178_;
			ValaSourceReference* _tmp179_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp178_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp179_ = _tmp178_;
			vala_report_error (_tmp179_, "Non-constant field initializers not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp182_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp183_ = _tmp182_;
		if (VALA_IS_NAMESPACE (_tmp183_)) {
			ValaExpression* _tmp184_;
			ValaExpression* _tmp185_;
			_tmp184_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp185_ = _tmp184_;
			_tmp181_ = vala_expression_is_constant (_tmp185_);
		} else {
			_tmp181_ = FALSE;
		}
		if (_tmp181_) {
			ValaExpression* _tmp186_;
			ValaExpression* _tmp187_;
			_tmp186_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp187_ = _tmp186_;
			_tmp180_ = vala_expression_is_non_null (_tmp187_);
		} else {
			_tmp180_ = FALSE;
		}
		if (_tmp180_) {
			gboolean _tmp188_ = FALSE;
			ValaDataType* _tmp189_;
			ValaDataType* _tmp190_;
			_tmp189_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp190_ = _tmp189_;
			if (vala_data_type_is_disposable (_tmp190_)) {
				ValaDataType* _tmp191_;
				ValaDataType* _tmp192_;
				gboolean _tmp193_;
				gboolean _tmp194_;
				_tmp191_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp192_ = _tmp191_;
				_tmp193_ = vala_data_type_get_value_owned (_tmp192_);
				_tmp194_ = _tmp193_;
				_tmp188_ = _tmp194_;
			} else {
				_tmp188_ = FALSE;
			}
			if (_tmp188_) {
				ValaSourceReference* _tmp195_;
				ValaSourceReference* _tmp196_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp195_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp196_ = _tmp195_;
				vala_report_error (_tmp196_, "Owned namespace fields can only be initialized in a function or method");
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
		_tmp200_ = self->priv->_binding;
		if (_tmp200_ == VALA_MEMBER_BINDING_STATIC) {
			ValaSymbol* _tmp201_;
			ValaSymbol* _tmp202_;
			_tmp201_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp202_ = _tmp201_;
			_tmp199_ = VALA_IS_CLASS (_tmp202_);
		} else {
			_tmp199_ = FALSE;
		}
		if (_tmp199_) {
			ValaSymbol* _tmp203_;
			ValaSymbol* _tmp204_;
			gboolean _tmp205_;
			gboolean _tmp206_;
			_tmp203_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp204_ = _tmp203_;
			_tmp205_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp204_, VALA_TYPE_CLASS, ValaClass));
			_tmp206_ = _tmp205_;
			_tmp198_ = _tmp206_;
		} else {
			_tmp198_ = FALSE;
		}
		if (_tmp198_) {
			ValaExpression* _tmp207_;
			ValaExpression* _tmp208_;
			_tmp207_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp208_ = _tmp207_;
			_tmp197_ = !vala_expression_is_constant (_tmp208_);
		} else {
			_tmp197_ = FALSE;
		}
		if (_tmp197_) {
			ValaSourceReference* _tmp209_;
			ValaSourceReference* _tmp210_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp209_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp210_ = _tmp209_;
			vala_report_error (_tmp210_, "Static fields in compact classes cannot have non-constant initializers");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp211_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp212_ = _tmp211_;
		if (_tmp212_) {
			ValaSourceReference* _tmp213_;
			ValaSourceReference* _tmp214_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp213_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp214_ = _tmp213_;
			vala_report_error (_tmp214_, "External fields cannot use initializers");
		}
	}
	_tmp216_ = self->priv->_binding;
	if (_tmp216_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaSymbol* _tmp217_;
		ValaSymbol* _tmp218_;
		_tmp217_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp218_ = _tmp217_;
		_tmp215_ = VALA_IS_INTERFACE (_tmp218_);
	} else {
		_tmp215_ = FALSE;
	}
	if (_tmp215_) {
		ValaSourceReference* _tmp219_;
		ValaSourceReference* _tmp220_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp219_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp220_ = _tmp219_;
		vala_report_error (_tmp220_, "Interfaces may not have instance fields");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	field_in_header = !vala_symbol_is_internal_symbol ((ValaSymbol*) self);
	_tmp221_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp222_ = _tmp221_;
	if (VALA_IS_CLASS (_tmp222_)) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp223_;
		ValaSymbol* _tmp224_;
		ValaClass* _tmp225_;
		gboolean _tmp226_ = FALSE;
		ValaClass* _tmp227_;
		gboolean _tmp228_;
		gboolean _tmp229_;
		_tmp223_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp224_ = _tmp223_;
		_tmp225_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp224_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp225_;
		_tmp227_ = cl;
		_tmp228_ = vala_class_get_is_compact (_tmp227_);
		_tmp229_ = _tmp228_;
		if (_tmp229_) {
			ValaClass* _tmp230_;
			_tmp230_ = cl;
			_tmp226_ = !vala_symbol_is_internal_symbol ((ValaSymbol*) _tmp230_);
		} else {
			_tmp226_ = FALSE;
		}
		if (_tmp226_) {
			field_in_header = TRUE;
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp233_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp234_ = _tmp233_;
	if (!_tmp234_) {
		gboolean _tmp235_;
		gboolean _tmp236_;
		_tmp235_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp236_ = _tmp235_;
		_tmp232_ = !_tmp236_;
	} else {
		_tmp232_ = FALSE;
	}
	if (_tmp232_) {
		ValaSymbol* _tmp237_;
		ValaSymbol* _tmp238_;
		_tmp237_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp238_ = _tmp237_;
		_tmp231_ = _tmp238_ != NULL;
		_vala_code_node_unref0 (_tmp238_);
	} else {
		_tmp231_ = FALSE;
	}
	if (_tmp231_) {
		ValaSourceReference* _tmp239_;
		ValaSourceReference* _tmp240_;
		gchar* _tmp241_;
		gchar* _tmp242_;
		ValaSymbol* _tmp243_;
		ValaSymbol* _tmp244_;
		gchar* _tmp245_;
		gchar* _tmp246_;
		gchar* _tmp247_;
		gchar* _tmp248_;
		_tmp239_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp240_ = _tmp239_;
		_tmp241_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp242_ = _tmp241_;
		_tmp243_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp244_ = _tmp243_;
		_tmp245_ = vala_symbol_get_full_name (_tmp244_);
		_tmp246_ = _tmp245_;
		_tmp247_ = g_strdup_printf ("%s hides inherited field `%s'. Use the `new' keyword if hiding was int" \
"entional", _tmp242_, _tmp246_);
		_tmp248_ = _tmp247_;
		vala_report_warning (_tmp240_, _tmp248_);
		_g_free0 (_tmp248_);
		_g_free0 (_tmp246_);
		_vala_code_node_unref0 (_tmp244_);
		_g_free0 (_tmp242_);
	}
	_tmp249_ = vala_code_context_get_analyzer (context);
	_tmp250_ = _tmp249_;
	_tmp251_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp250_, _tmp251_);
	_tmp252_ = vala_code_context_get_analyzer (context);
	_tmp253_ = _tmp252_;
	_tmp254_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp253_, _tmp254_);
	_tmp255_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp256_ = _tmp255_;
	result = !_tmp256_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

ValaMemberBinding
vala_field_get_binding (ValaField* self)
{
	ValaMemberBinding result;
	ValaMemberBinding _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_binding;
	result = _tmp0_;
	return result;
}

void
vala_field_set_binding (ValaField* self,
                        ValaMemberBinding value)
{
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}

gboolean
vala_field_get_is_volatile (ValaField* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_volatile;
	return result;
}

void
vala_field_set_is_volatile (ValaField* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_volatile = value;
}

static gboolean
vala_field_real_get_lock_used (ValaLockable* base)
{
	gboolean result;
	ValaField* self;
	self = (ValaField*) base;
	result = self->priv->_lock_used;
	return result;
}

static void
vala_field_real_set_lock_used (ValaLockable* base,
                               gboolean value)
{
	ValaField* self;
	self = (ValaField*) base;
	self->priv->_lock_used = value;
}

static void
vala_field_class_init (ValaFieldClass * klass,
                       gpointer klass_data)
{
	vala_field_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_field_finalize;
	g_type_class_adjust_private_offset (klass, &ValaField_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_field_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_field_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_field_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_field_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_field_real_check;
}

static void
vala_field_vala_lockable_interface_init (ValaLockableIface * iface,
                                         gpointer iface_data)
{
	vala_field_vala_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_lock_used = vala_field_real_get_lock_used;
	iface->set_lock_used = vala_field_real_set_lock_used;
}

static void
vala_field_instance_init (ValaField * self,
                          gpointer klass)
{
	self->priv = vala_field_get_instance_private (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
}

static void
vala_field_finalize (ValaCodeNode * obj)
{
	ValaField * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_FIELD, ValaField);
	VALA_CODE_NODE_CLASS (vala_field_parent_class)->finalize (obj);
}

/**
 * Represents a type or namespace field.
 */
GType
vala_field_get_type (void)
{
	static volatile gsize vala_field_type_id__volatile = 0;
	if (g_once_init_enter (&vala_field_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaFieldClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_field_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaField), 0, (GInstanceInitFunc) vala_field_instance_init, NULL };
		static const GInterfaceInfo vala_lockable_info = { (GInterfaceInitFunc) vala_field_vala_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_field_type_id;
		vala_field_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaField", &g_define_type_info, 0);
		g_type_add_interface_static (vala_field_type_id, VALA_TYPE_LOCKABLE, &vala_lockable_info);
		ValaField_private_offset = g_type_add_instance_private (vala_field_type_id, sizeof (ValaFieldPrivate));
		g_once_init_leave (&vala_field_type_id__volatile, vala_field_type_id);
	}
	return vala_field_type_id__volatile;
}

