/*
 * Copyright (c) 2011 Samsung Electronics Co., Ltd All Rights Reserved
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
/*
 * @file        colors.h
 * @author      Lukasz Wrzosek (l.wrzosek@samsung.com)
 * @version     1.0
 * @brief       Some constants with definition of colors for Console
 *              and html output
 */

#ifndef SECURITY_MANAGER_COLORS_H
#define SECURITY_MANAGER_COLORS_H

namespace SecurityManager {
namespace Colors {
namespace Text {
extern const char* BOLD_GREEN_BEGIN;
extern const char* BOLD_GREEN_END;
extern const char* PURPLE_BEGIN;
extern const char* PURPLE_END;
extern const char* RED_BEGIN;
extern const char* RED_END;
extern const char* GREEN_BEGIN;
extern const char* GREEN_END;
extern const char* CYAN_BEGIN;
extern const char* CYAN_END;
extern const char* BOLD_RED_BEGIN;
extern const char* BOLD_RED_END;
extern const char* BOLD_YELLOW_BEGIN;
extern const char* BOLD_YELLOW_END;
extern const char* BOLD_GOLD_BEGIN;
extern const char* BOLD_GOLD_END;
extern const char* BOLD_WHITE_BEGIN;
extern const char* BOLD_WHITE_END;
} //namespace Text

namespace Html {
extern const char* BOLD_GREEN_BEGIN;
extern const char* BOLD_GREEN_END;
extern const char* PURPLE_BEGIN;
extern const char* PURPLE_END;
extern const char* RED_BEGIN;
extern const char* RED_END;
extern const char* GREEN_BEGIN;
extern const char* GREEN_END;
extern const char* CYAN_BEGIN;
extern const char* CYAN_END;
extern const char* BOLD_RED_BEGIN;
extern const char* BOLD_RED_END;
extern const char* BOLD_YELLOW_BEGIN;
extern const char* BOLD_YELLOW_END;
extern const char* BOLD_GOLD_BEGIN;
extern const char* BOLD_GOLD_END;
extern const char* BOLD_WHITE_BEGIN;
extern const char* BOLD_WHITE_END;
} //namespace Html
} //namespace Colors
} //namespace SecurityManager

#endif /* SECURITY_MANAGER_COLORS_H */
