// Copyright John Maddock 2019.

// Use, modification and distribution are subject to the
// Boost Software License, Version 1.0.
// (See accompanying file LICENSE_1_0.txt
// or copy at http://www.boost.org/LICENSE_1_0.txt)

#ifndef SC_
#  define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
#endif
   static const boost::array<boost::array<T, 4>, 2008> hypergeometric_1f1_large_regularized = {{
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(4.0276663579159193006951037397981254601813e+15) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(6.7129875507034971595620263116260431712429e+15) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(6.7129878785237833504309558423436229226113e+15) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(6.7129878785237833504309560010065400162665e+15) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(6.7129882063439619148485089154693302002749e+15) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.1356661595453269338409583627017301161607e+16) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-4.4961264612476914793427869087364885977294e+72) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(2.5059660579261572510917574295320572992652e+02) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.3602718650614843079637735827878150847154e-05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-1.4532897651483803866724488114571994275810e-05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-1.4532897651483803867174688567286966894045e-05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.5463075433775013585809069442820986244113e-05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.6779062583965630305716417992355873640682e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.9609926727072889915880225396661994166653e+04) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(2.5059306983409045286278997685820494014182e+02) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.3018543397254310147086821986620071089127e-07) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-1.3700637846434619423646541192532193067304e-12) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-1.3700637846439121465940532661296084221633e-12) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-9.3018695552471360836728197654473932529617e-07) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.6779824944324178296635393118565891539927e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.9603253473482147926803512057213604147013e+04) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(2.5059306983375711117960278608577385878886e+02) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.3018680403706335701290922818235855933469e-07) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(2.2510182145678120277553565223562021634050e-25) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-2.2510240794272170514802442713301279884300e-25) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-9.3018558546166457675699928272254372974062e-07) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.6779824944396043709566009459680439185644e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.9603253472853091160352830937648227098010e+04) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(2.5059306983375711117960278608561252354847e+02) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.3018680403706335701290989128481430204703e-07) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(2.2510248455888091405993166043887445621715e-25) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-2.2510174484062199386362841892993087594947e-25) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-9.3018558546166457675699861962080004999150e-07) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.6779824944396043709566009459715221585372e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.9603253472853091160352830937343767650688e+04) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(2.5059306983342376949641595821001917491667e+02) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.3018817410158361472190253671894431904939e-07) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3700637846460791005981528879382424910460e-12) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3700637846456288963687530289987844874287e-12) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-9.3018421539861554297975970795199062785812e-07) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.6779824944467909122495834884599387636034e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.9603253472224034393911096444575950225576e+04) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(2.5058953391661681263544129082370930894242e+02) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.5463332446281055395842288497736874539552e-05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.4533137839335554835014800540258494116422e-05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.4533137839335554834564592534300137267727e-05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.3602944450963100583299350492192146423088e-05) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.6780587215641672356674494949332424218202e-01) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.9596581226978818963671289617541658335518e+04) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(2.2642938916874995087527200233512488887943e-16) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.3576273862752083056509537463143878972101e-16) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3576273199771626836261775864980601220200e-16) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3576273199771626836261775544102326018804e-16) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.3576272536791453209149858379393819501926e-16) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(8.0316910492822212721239639161672023237352e-17) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.6025465972351057034356198592920349545411e-63) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.9802492826931166205674621000580546389098e-1379) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.2620956968523977678035898416343600924011e-3335) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.2521922990361235988945080975907936697130e-3335) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.2521922981061751721204943360523196578055e-3335) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.2521922981061751721204943356022305922506e-3335) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.2521922971762270992762813030733182826733e-3335) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.2423665505792903194029051252323362939786e-3335) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.0876148202591982075659114249418299219177e-4449) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.4708377420715569795366027225555325046146e-36158) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.1455283484319132825579313017285233569132e-49854) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.5044732436047150747630351086073655786882e-50254) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.5033810691518719242849441952169862060071e-50254) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.5033810690489472871281351480366267975638e-50254) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.5033810690489472871281351479868119342419e-50254) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.5033810689460226890741638367217683623680e-50254) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.5022896876273388900144227969299778349955e-50254) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.0033029511860989905395613318990158946962e-50684) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.2503181428503121765536421904010009822901e-4391) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.0277315967446816168740190507139687250493e-20237) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.4651771148099769828685320690419730443482e-67037) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.1668956355679791365451212300992264076711e-78445) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(8.8199752637130430488670548014420437476931e-78718) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(8.8156938212093970702879350947444645831451e-78718) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(8.8156938208058727570404215561833429508570e-78718) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(8.8156938208058727570404215559880397749899e-78718) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(8.8156938204023485970895722170286295947930e-78718) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(8.8114144574016393607525946512662867103012e-78718) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(8.5215865257959017693967343932763153726866e-78999) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(2.2798227749051521351076454466955545242988e-6713264) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(4.8486052841732235166033463953714631626900e-6903364) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.8260505188535679386041686920330693446319e-6904958) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0635531626583772132465631237064299117501e-6907909) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(4.3410879933076460355940784180281371389276e-6908207) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.1011468290359737993925642020077722290068e-6908211) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.1011379385226755241481833721010747592636e-6908211) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.1011379385218373966166313545726668073991e-6908211) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.1011379385218373966166313545722611590569e-6908211) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.1011379385209992694034416462507737863299e-6908211) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.1011290480821522742114482092297034968518e-6908211) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.7924497938758277149482637650156463879015e-6908216) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(4.2340065164274310008757719114100354093898e-6908514) }, 
      { SC_(-8.1472375000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.5475988046716377679876247791794313977856e-6911515) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.6554261194445435510830259032054289229569e+15) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(6.7129878730725957200074691569732078908729e+15) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(6.7129878785237833504309559203559248443670e+15) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(6.7129878785237833504309559229942646469459e+15) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(6.7129878839749689148992694505863014344874e+15) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.7710752598246612439200669194668522144095e+15) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-2.0384836115954991045694332751139758997384e+55) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-1.6690564485483697832453318482504935354240e+296) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.7789061941520362025712209075970437293795e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.4517430097980847957283515405244543891434e-05) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-1.4532897651483803866945845280353714211696e-05) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-1.4532897651483803866953331476846848294598e-05) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.4548365198872196459061505472100206266522e-05) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.5099106221909087005361332476023699265227e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-4.6058661081681992869246119214554243787624e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(7.9207125009837227169003165581408089219149e+226) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.7790644097618589696760395186455390218597e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.5466313194846530612079157678973866597214e-08) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-1.3700637846436833013873777854375237602411e-12) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-1.3700637846436907876466718333144999632889e-12) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.5469047207804682810292485065794589686593e-08) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.5097798356472110271874297770446739462731e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-4.6062162790094034946809276675495420214583e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(7.9229901413178761649610106786586993755599e+226) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.7790644097767744417647469572302947243604e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.5467683258643406487475825381194297904702e-08) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(3.7427987329399628243845150472635529092807e-27) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-3.7434605611138344524502429285379967102712e-27) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.5467677144032271307092972211680342931562e-08) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.5097798356348813185876204303152775715057e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-4.6062162790424101863242326419698590141879e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(7.9229901415325637916107311175149509042643e+226) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.7790644097767744417647469572375137173526e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.5467683258643406487476488483299929489942e-08) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(3.7434618350396741087805232504330669737559e-27) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-3.7427974590141231680542347253713480333960e-27) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.5467677144032271307092309109586551945828e-08) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.5097798356348813185876204303093100714864e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-4.6062162790424101863242326419858340416123e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(7.9229901415325637916107311176188583409888e+226) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.7790644097916899138534719109217980195699e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.5469053322440284529827045583101810613671e-08) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3700637846458577415754288716426446428274e-12) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3700637846458502553161348119250671763777e-12) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.5466307080259857636938830686855294713568e-08) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.5097798356225516099877854949117430012709e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-4.6062162790754168779666355096451189482891e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(7.9229901417472514182545703422757865309717e+226) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.7792226273327075111151432570543170976051e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.4548605652345567871180874679455958146244e-05) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.4533137839335554834793439660654324847456e-05) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.4533137839335554834785953338561441155654e-05) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.4517670032440200749541805801618650604783e-05) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.5096490462323544430409376308427695429314e-01) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-4.6065663483238516406930346393460289410647e+03) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(7.9252671197566398419477281343550086394704e+226) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.3693695078056857625345434746364700446600e-16) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.3576273210796053451594904208468083498999e-16) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3576273199771626836261775707209312606066e-16) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3576273199771626836261775701873560933563e-16) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.3576273188747204417048064013574769278017e-16) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.3459808351788403131109850603466739613523e-16) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(5.2853529350532954376328858751821777345786e-47) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0117187692127655118166953454271597723284e+160) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(8.5198586460490995671096851077704609811773e-1410) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(8.5391113122529525669591377840151457538431e-3266) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.2523563410657985369748530988550621027263e-3335) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.2521922981216388985712064499196359547579e-3335) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.2521922981061751721204943358310172595077e-3335) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.2521922981061751721204943358235329152254e-3335) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.2521922980907114515438497428682278108635e-3335) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.2520282766646632230492865165216776849191e-3335) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.8662746798716814409213319791088577910189e-3417) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-5.7362403534204934524827025068138020399055e-4263) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(-3.4994152135232750041363005174768096158856e-2680) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.1881479187750288394224331368230088871354e-1569) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(6.4785686326757359339666508671118110422634e-46142) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(2.9813609221351488388903136707082763212133e-47133) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(8.2282013686018106547459553939011455708297e-49833) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.1038282012821784091600230604909135958955e-50247) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.5033992238827600016519688437750462359640e-50254) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.5033810690506587782052049630053122367412e-50254) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.5033810690489472871281351480121335370790e-50254) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.5033810690489472871281351480113051863902e-50254) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.5033810690472357967011749785341142401442e-50254) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.5033629144397908641145570110406929521742e-50254) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.9733298664783716961797633338545241672652e-50261) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(4.8264975585311190834623852156272537519142e-50748) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(9.7799750429322479967770797506708350791407e-54293) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(-9.6211567959632149221190374455015304356911e-54262) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(4.6553821607479941874646066042876515382905e-75476) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(2.9815103372339818184634334179896273355838e-76318) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.3964339118443725171065829684805547244484e-78427) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.4520466236686951828684797562359531873330e-78713) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(8.8157649981487565035730825003192024714538e-78718) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(8.8156938208125827953809925618974789800708e-78718) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(8.8156938208058727570404215560873151543113e-78718) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(8.8156938208058727570404215560840675388514e-78718) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(8.8156938207991627212486551415021061648444e-78718) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(8.8156226440589756560375058091187844102819e-78718) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.2205143137915046933829030515863555023475e-78722) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(4.4614647664104590175359903876805866510804e-79034) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.4224163587247397631407985689939701111715e-83040) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(-2.7864468981981455937298706696608936026516e-83598) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(4.4784346048391167007000921194150721719012e-6904652) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.0168273070624197175611556299658705906628e-6908130) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.9928690490936536959018245739055076566637e-6908157) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.1609859195197776047610801965754639574756e-6908206) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.3129947362449448875223456696201681140256e-6908211) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.1011380863579204865077450487636258343078e-6908211) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.1011379385218513334915271110230835743170e-6908211) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.1011379385218373966166313545724673558730e-6908211) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.1011379385218373966166313545724606105151e-6908211) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.1011379385218234597470295024083638150302e-6908211) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.1011377906858185618324529054157575216099e-6908211) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.2346292347324961405536568726641668222748e-6908212) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0339916491955952323143014423382682682366e-6908216) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.8774325345822519410979150004697662943112e-6908266) }, 
      { SC_(-1.3547703125000000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(8.5902573156622354482284941712647283719756e-6908294) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.6744444665073597650499537533585869141105e+15) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(6.7129878748791484456227386853688534103991e+15) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(6.7129878785237833504309559207931048771498e+15) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(6.7129878785237833504309559225570847629626e+15) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(6.7129878821684168729174267993443087828616e+15) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.7517662400491728021353573897161321600615e+15) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-3.7962311358609516444413432823534986125227e+53) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(-2.9233252190256922531628385079134135593537e+294) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.1581098356484088233649431186643656162922e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.4522556127937312615182165511626492908124e-05) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-1.4532897651483803866947085763336644638888e-05) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-1.4532897651483803866952090994286131325165e-05) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.4543239170995142930356691843601065118415e-05) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.0380536538839036992509842084311722111038e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.2014889524761216459896227251664765633042e+04) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(8.9855178532525658155311683685274168123477e+227) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.1582639824878897220810636557735603884857e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0340240236657499021071846482521419330848e-08) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-1.3700637846436845418807669969375515445429e-12) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-1.3700637846436895471537048388141360713714e-12) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.0342976329042301708938910183151965760568e-08) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.0379178824769325744369912467186534276912e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.2013214765434740632312200947532134079551e+04) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(8.9846895254226153586455312971300543118903e+227) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.1582639825024216285004085791828441250039e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0341610300450321083863033293401955026839e-08) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(2.5023053437274817867918006575535386726703e-27) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-2.5029675941183530790838113775561812742362e-27) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.0341606265265836394597121570414141683406e-08) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.0379178824641329371180020109753274541269e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.2013214765276866023675861634464847715019e+04) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(8.9846895253445300023985929407409782289346e+227) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.1582639825024216285004085791898774746680e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0341610300450321083863696395505624592733e-08) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(2.5029684458271930711878088607225779346794e-27) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-2.5023044920186417946878031743890577950564e-27) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.0341606265265836394596458468318388679035e-08) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.0379178824641329371180020109691325116162e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.2013214765276866023675861634388437415258e+04) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(8.9846895253445300023985929407031854164654e+227) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.1582639825169535349197724193763814408281e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0342980364243145313608785225714286230225e-08) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3700637846458565010820396581805972417035e-12) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3700637846458514958091018083874500173202e-12) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.0340236201489368913300716908705320128881e-08) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.0379178824513332997989884581696965317972e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.2013214765118991415041241792096841021571e+04) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(8.9846895252664446461522521138717548578682e+227) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.1584181314463646460946567390107092887201e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.4543479536387077322457373568899376016968e-05) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.4533137839335554834792199156859176601367e-05) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.4533137839335554834787193841934368860291e-05) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.4522796146319249127033282020834811441242e-05) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.0377821083421923912722418138763565223616e-01) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.2011540199686716037294473175001588431541e+04) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(8.9838612648779109800615155780666342877840e+227) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(4.2132930947438503024482697699620522986263e+277) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.3654674348189268066945633650948536081559e-16) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.3576273207142499526948358158447228923771e-16) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3576273199771626836261775706325164139357e-16) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3576273199771626836261775702757709099341e-16) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.3576273192400756949193544476372872841133e-16) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.3498299852888328503647053159735155621194e-16) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.3587930231719566736208545409020355397515e-45) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(4.1081151694658989395077720162318522232615e+161) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(6.6481487096781668058085312042344093291823e-1893) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(4.3753551885880548115507646324579583272511e-3288) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.2523019739730673194473869827905889758591e-3335) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.2521922981165141369468021141327170268458e-3335) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.2521922981061751721204943358297770834411e-3335) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.2521922981061751721204943358247730908699e-3335) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.2521922980958362112215144159634867746736e-3335) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.2520826318688502837676542580594494562204e-3335) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.6836041062588970744957731679271387083449e-3388) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(2.4098288184146892232754374080542867871520e-4159) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(2.4572994404901410645872305441948366614758e-2576) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.6934625000000000000000000000000000000000e+04), SC_(-5.1759642864793532313294858464348721872793e-1466) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(4.5546799195591154661681312045162497982473e-47389) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(3.8380525115746392504826039835014913841490e-48087) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0683561167771435942061314024498322326832e-49969) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(5.8669262366619421711293445733411961274461e-50250) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.5033932072494805465905559904979272741804e-50254) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.5033810690500915809115771337865376086985e-50254) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.5033810690489472871281351480119962771320e-50254) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.5033810690489472871281351480114424462904e-50254) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.5033810690478029937793525636533362927655e-50254) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.5033689309500443940528960667453291004982e-50254) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.7738049762027014650816024364560388164953e-50259) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(7.1669186147424800170109794382067349653880e-50579) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(-8.0247187184377302853341194448990374727722e-53518) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.4881631672770639598901893790151105227838e-53487) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(3.0197881480195347382715085547677589800795e-76488) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(2.3541055898277820661526175895800445341816e-77073) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(8.7287093225118769045544189411004780662880e-78523) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0381399518709866948246327864566471167028e-78714) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(8.8157414095331024812821345831444205313616e-78718) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(8.8156938208103590527989240991663711862561e-78718) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(8.8156938208058727570404215560867770156561e-78718) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(8.8156938208058727570404215560846056773234e-78718) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(8.8156938208013864629860350036153867648013e-78718) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(8.8156462323497883621216795663149043138871e-78718) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.4265533127313962872504086895822832705306e-78721) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(7.2852383941823885355491859781268921793418e-78928) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(9.1393404824696654114558712659886839962471e-82033) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.0918778174210534268991178164131246765884e-82589) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(2.8815934044782737926798602300022404058523e-6905830) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.5004736809739842092716283190496132088409e-6908157) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(2.0836105621050594140783385405807961929223e-6908175) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(2.5129743433169080451213198175395539686249e-6908208) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.2386156767182269882736008739805237941420e-6908211) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.1011380373642499287265988909893256851350e-6908211) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.1011379385218467147366715300493666736145e-6908211) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.1011379385218373966166313545724662381490e-6908211) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.1011379385218373966166313545724617282388e-6908211) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.1011379385218280785001306551579663386589e-6908211) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.1011378396794634272713136469331868565475e-6908211) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(9.7891776750263839867942626217444824024107e-6908212) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(4.7929687187023143130606415378818101262964e-6908215) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(2.6588654512713347002865480865234966255903e-6908248) }, 
      { SC_(-9.0579218750000000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.4009066973521459408087017815130653227820e-6908266) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.3444997936285484757347558108861645249985e+135) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.7094249273001988569867417538388791264463e+15) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(6.7129878781878010653743273428994778069263e+15) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(6.7129878785237833504309559215937883222985e+15) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(6.7129878785237833504309559217564015903362e+15) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(6.7129878788597655078828693271363530412780e+15) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.7165528232347421375249860496148787802865e+15) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-2.5363090258326204076668708539788397820544e+43) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(2.7653816107952893549332579454549884589786e+284) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.2904057963704615075315069797274304364225e+97) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0149203202381191522255971008596680259523e-02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.4531944313554037794051639933413294900473e-05) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-1.4532897651483803866949357674480661663093e-05) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-1.4532897651483803866949819083915386867403e-05) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.4533850989050537961055397656647299701530e-05) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.0076121740069586975505747952423728261286e-02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-7.9924227660396454529681079626660617996850e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(8.4363353371058535156723825793377723369976e+227) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.2903181709479728970017780834900237137317e+97) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0163820617062883744298643216644932084084e-02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.5197586343289196478545436703375321315106e-10) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-1.3700637846436868138109698372285598859969e-12) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-1.3700637846436872752242752775764717679836e-12) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-9.5471562796716830267659063552808299464211e-10) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.0061673989763861644382387536954738420458e-02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-7.9955794081383003042136500854911172775575e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(8.4354894473595125340331094492350733329075e+227) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.2903181709397125108189111626746435527317e+97) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0163820618440915156523523951688852359913e-02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.5334592721828957902729663880771163576630e-10) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(2.3037514088539408543094096551909119704802e-28) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-2.3103816455531872237254421385875835655525e-28) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-9.5334556418327854254420822731853340502123e-10) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.0061673988401824650890536328199408112311e-02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-7.9955794084358623037299966479050514021463e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(8.4354894472797723203195638923307313055952e+227) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.2903181709397125108189111626706455787077e+97) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0163820618440915156523523952355810740360e-02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.5334592721828957902795974090778781609884e-10) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(2.3103824298510536982694916868726087113928e-28) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-2.3037506245560743797653601069076528975369e-28) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-9.5334556418327854254354512521918701642339e-10) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.0061673988401824650890536327540190928124e-02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-7.9955794084358623037299966480490695047219e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.0437607421875000000000000000000000000000e+03), SC_(8.4354894472797723203195638922921375527078e+227) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.2903181709314521246360971112966406105083e+97) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0163820619818946568750546696660118370434e-02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(9.5471599100368936022372714839861033917208e-10) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3700637846458542291518368142962028614437e-12) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3700637846458537677385313732184991364612e-12) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-9.5197550039938661545723288651425759917269e-10) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.0061673987039787657396493309579950014869e-02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-7.9955794087334243032421001347607540005437e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.0437607421875000000000000000000000000000e+03), SC_(8.4354894472000321066067569013377510156688e+227) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.2902305514797714163335303673090505634127e+97) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.0178438271860557866728303400781501641991e-02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.4534091193259959210641588367780433399052e-05) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.4533137839335554834789927207598143668762e-05) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.4533137839335554834789465790422116252865e-05) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.4532184485774188502117455683198574780133e-05) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.0047225993728178933832275615384634253139e-02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-7.9987355726107319150084624605666237645948e+02) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.0437607421875000000000000000000000000000e+03), SC_(8.4346436407689284090651815651952885103368e+227) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.1646627340901304357605073008607834804336e+58) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.3583482708671723308865069170351858246636e-16) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.3576273200451114003820669043863418478362e-16) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3576273199771626836261775704705870056229e-16) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3576273199771626836261775704377002631322e-16) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.3576273199092139926837487224886440013950e-16) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.3569067324400716351526434041496038102496e-16) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-2.6103609942522782670016638115372924496395e-36) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.9792477447468426159755402108172306881611e+171) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(2.5557657005425834245628314592137566837024e-2450) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(5.8630480882447934468569368130668731517161e-2578) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(8.3928986772519471098340208183519660897434e-3136) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(4.4249654878006258852475651618883931799405e-3331) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.2522024082229871580696883275645579484129e-3335) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.2521922981071282741779771814593540585516e-3335) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.2521922981061751721204943358275057344061e-3335) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.2521922981061751721204943358270444391318e-3335) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.2521922981052220704250468121429550431110e-3335) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.2521821880738650788027625983970709165764e-3335) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.8339096886317781358713998692041861245771e-3340) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(2.7613667105533974081069975477410558878403e-3637) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(2.5783098705966723797728824588653737281262e-1391) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(2.1508094607451666917359742887572488239072e-49964) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(5.5089059426420649532677577029934185035880e-50037) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.1395626316638232444375331117353491101636e-50228) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.9854116261888363773370229574122596714091e-50254) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.5033821880102458363173496059934749671576e-50254) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.5033810690490527743580164180565784394812e-50254) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.5033810690489472871281351480117448892393e-50254) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.5033810690489472871281351480116938340975e-50254) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.5033810690488417999383230747586468624377e-50254) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.5033799500888166421733407229916745475861e-50254) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(5.6642136571416699911961967565898327867233e-50255) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.2965688847423693628100565464491167494377e-50283) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(-1.2214387208339439095938892471748119402865e-50901) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(-8.2047589359567986802539456839662967613308e-50870) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.7431710529997894258080671182615351889921e-78499) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(4.0405359924147543513413465558506664619653e-78558) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.2330246665079839360976087520558787060164e-78699) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.6920087736611453285848179024901405317698e-78717) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(8.8156982077830476246532978792457684803293e-78718) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(8.8156938208062863282044359865746706189536e-78718) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(8.8156938208058727570404215560857914292156e-78718) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(8.8156938208058727570404215560855912634285e-78718) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(8.8156938208054591860335016228531239298246e-78718) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(8.8156894338321960730461283127877504464078e-78718) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(4.5907119953351159294696641656244135977308e-78718) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(6.3388333786162028362219572742346915917353e-78737) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(5.9177277652169552848713049591744871799115e-79027) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(-2.4248199273873211397282034182062452577739e-79412) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(6.6858516535445918258672056801093090741249e-6907992) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.0776358814845442734187890279825123767398e-6908206) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(2.4330640233893221639828010234914425485303e-6908208) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(2.2461215782099347767575173501363734529302e-6908211) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.1131454803964264463542355815689915851813e-6908211) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.1011379476336686578232744983337796025272e-6908211) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.1011379385218382556116595220304107021232e-6908211) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.1011379385218373966166313545724641910676e-6908211) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.1011379385218373966166313545724637753195e-6908211) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.1011379385218365376219294752783663268069e-6908211) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.1011379294100089478228000092829020710523e-6908211) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0892597688988912626262148183273039313411e-6908211) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.3949258751906760232907464785045717023071e-6908212) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(4.6385329278640769537140406472624748204282e-6908215) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(9.5834718757094897817000510607588153324841e-6908217) }, 
      { SC_(-8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.3070954782826769503342565082298431737776e-6908864) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-1.1853491854490898702276334470585042143056e+54) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-7.7848289691809037355539135552804647110849e+40) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-5.5673194288064544807552192472854241129168e+15) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.7129336787453082930543137185008899708873e+15) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(6.7129878785186737822400452955192935188501e+15) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(6.7129878785237833504309559216738584708504e+15) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(6.7129878785237833504309559216763314690372e+15) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(6.7129878785288929166810073847457174857734e+15) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.7130420787114590820873363309133213390442e+15) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-4.0392797851129671989014527988034896153300e+20) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.3615089251072899997562720873398412771261e+43) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.1016268808373984264675304701707928956226e+30) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.0992898430896332940897863708208483775454e+09) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.3926856812964332528059725351880519665624e-04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.4532883153263584051076344544887180475751e-05) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-1.4532897651483803866949584870713954896060e-05) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-1.4532897651483803866949591887759422633357e-05) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.4532912149698516358759111398290979697303e-05) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.6831252772173144446886811310719114655393e-04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-5.2570824294114032807843878912877516226576e+03) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.3614594492773247308449229787019314890187e+43) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.1015870225038611683464112019583017083983e+30) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.0991967813886257302043943107394100292000e+09) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.5380275447701831874345633555963035932597e-04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.3128278059214383955295422198337153305492e-11) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-1.3700637846436870410091090557300491749776e-12) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-1.3700637846436870480262133887226084364805e-12) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.5868400121131496776422090916597115502002e-11) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.5378092163975897701266481348387299899837e-04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-5.2568233120411016432492672050216042276514e+03) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.3614594492726606048912324847395199816797e+43) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.1015870225001036911519079536232341959724e+30) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.0991967813798527009459905444989932555093e+09) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.5380275584720371910604048653612802012825e-04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.4498341843869536611211572065156163823997e-11) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(3.1770016667129227918522839990845642162190e-30) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-3.8401026662851857520871741214870208560879e-30) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.4498336336499275339610933551658078932494e-11) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.5378092026981682067265403212341358744020e-04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-5.2568233120166745226457422526800753800696e+03) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.3614594492726606048912324847372625745810e+43) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.1015870225001036911519079536214156010681e+30) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.0991967813798527009459905444947471655190e+09) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.5380275584720371910604048719928898106881e-04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.4498341843869536611874674164872997502672e-11) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(3.8401037664242071878604871671672775564125e-30) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-3.1770005665739013560789709534069933330635e-30) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.4498336336499275338947831451952343817045e-11) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.5378092026981682067265403146037035504915e-04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-5.2568233120166745226457422526682528100962e+03) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.3614594492679964789375577598902923291837e+43) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.1015870224963462139574173524825280719712e+30) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.0991967813710796716876110702077563801232e+09) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.5380275721738911947079121341751746438571e-04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.5868405628526856221718271439509711495619e-11) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3700637846458540019536975954353668722476e-12) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3700637846458539949365932624317090458716e-12) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.3128272551864886948209155281708195581048e-11) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.5378091889987466433047591750585650870125e-04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-5.2568233119922474020423150783276779008132e+03) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.3614099752247581690857776991362784345584e+43) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.1015471655958498514694295985421164327482e+30) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.0991037224266999999993375835790127954357e+09) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.6833718370968318201723684718840908098245e-04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.4533152337799018710718350231624772970975e-05) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.4533137839335554834789700007553062962692e-05) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.4533137839335554834789692990389866662626e-05) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.4533123340877598375318329108894260188067e-05) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.3924907258711988885239993844692583228104e-04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-5.2565642056887965100548965258967897433748e+03) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(9.0926699523975613563952591806006648861957e+17) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.0276446028676978844597389677428540096126e+04) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.5722460939286167400452190787687524597055e-13) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.3576382813671773105426091828047270648145e-16) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.3576273199781960375176585185328354992372e-16) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3576273199771626836261775704543936999450e-16) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3576273199771626836261775704538935632985e-16) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.3576273199761293301272154653105202308216e-16) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.3576163586679054904648119526838246529339e-16) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.9349756489021509139150791049661590210723e-21) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(6.2723949892570508341851399458241402817784e-3323) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(2.7239045493702912497185812288802547236050e-3332) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.4693327612768028647952108980083654613705e-3335) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.2521924518587042744554410206753593576950e-3335) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.2521922981061896667536106518237883483079e-3335) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.2521922981061751721204943358272785943850e-3335) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.2521922981061751721204943358272715790756e-3335) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.2521922981061606774928837878423005010388e-3335) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.2521921443537096337231844917721160161656e-3335) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0649465051765994684946926387928429583280e-3335) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.6135595687715126736536562476721456804332e-3346) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(-5.4811454617956388000919532693594302082924e-203) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(4.3626581926789896567713536101200966339208e-50250) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(3.3067351397894758815651862931334478586710e-50251) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(3.8480309047563857137349799231206389037276e-50254) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.5258378033675438558333916952563242145001e-50254) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.5033810860659366251348727660485852500783e-50254) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.5033810690489488913621031494232826147462e-50254) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.5033810690489472871281351480117197498836e-50254) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.5033810690489472871281351480117189734447e-50254) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.5033810690489456828947765128233821410356e-50254) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.5033810520319632382921008614962909149468e-50254) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.4812291494257458829318214536531656065927e-50254) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.4478867208028044272844344274482311055030e-50255) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.7164151956901210208843548380062846820769e-50264) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(-4.3774972997248315718852076493909060103892e-50137) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.9397643116495500105551275972032971962455e-78714) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(2.4402878837482323873554563521360951728936e-78715) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.6652498816394302183268806499258284082771e-78717) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(8.9035378605640007037768402453013407385066e-78718) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(8.8156938875223471995187832179051386025829e-78718) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(8.8156938208058790465686444944964729051238e-78718) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(8.8156938208058727570404215560856928683509e-78718) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(8.8156938208058727570404215560856898242596e-78718) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(8.8156938208058664675145876869330389622591e-78718) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(8.8156937540894188206490760230093691672739e-78718) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(8.7286487997857527427627154319994210589286e-78718) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(4.5129131512507104866065858962051150080455e-78718) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(2.8217057519604059483434875181594139834650e-78722) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.0552766309804502277271792930491290346972e-78727) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(2.4246924526810557958115833376985708012511e-6908208) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.3114110232736955293584357709863508620088e-6908211) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.2379459254582193760486901137776885827566e-6908211) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.1131404097558433499029436691522693696223e-6908211) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.1013195739320627675776951532743989375470e-6908211) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.1011379386604087590158369032253208001096e-6908211) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.1011379385218374096800988859659544362501e-6908211) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.1011379385218373966166313545724639863548e-6908211) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.1011379385218373966166313545724639800322e-6908211) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.1011379385218373835531687853204131527513e-6908211) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.1011379383832660758589502683850800278762e-6908211) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.1009563307092085768674570279150954629850e-6908211) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0892547942596409531032349330677635292369e-6908211) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(9.7838183879513707505386055983313042159203e-6908212) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(9.2232827449734329302120280728612817814388e-6908212) }, 
      { SC_(-1.2698684692382812500000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.4443967629390048170198285326477878511994e-6908221) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(6.7120575007589738465605154281445657644682e+15) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(6.7119013251867124713223424608700457938439e+15) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(6.7126332196481429677245568016027142958007e+15) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.7129878784824305218402792387314018485811e+15) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(6.7129878785237833465325230632888283189844e+15) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(6.7129878785237833504309559216750949692108e+15) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(6.7129878785237833504309559216750949710976e+15) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(6.7129878785237833543293872992463780989483e+15) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.7129878785651361388507681755307213123083e+15) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-2.5176571469114176969982320136871961634911e+24) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-4.8447644429328358183622363933589219826038e-06) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-4.8446525021040013653287688892894293396999e-06) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-4.8444541347335273347663082937916081469126e-06) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.4532780315035482937361371320498674440895e-05) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.4532897651472742200683315321409507307433e-05) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-1.4532897651483803866949588379234608960815e-05) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-1.4532897651483803866949588379239962736242e-05) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.4532897651494865529014114278113812112512e-05) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.4533014989317937025907032061491234884617e-05) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-7.5853753728970701462242971122824818886591e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(9.6896087978632945841108284427304332027809e-06) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.6893849143604054617142373505151838888223e-06) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.6889844638551556642776788993543693093003e-06) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.1596736886971695319923758665763415026399e-10) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.3700527228846256183744389509842305570308e-12) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-1.3700637846436870445176591424049886484637e-12) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-1.3700637846436870445176644962253273445450e-12) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.3700748463985466882537355812862678949923e-12) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.1870888224220667766278886604278362534887e-10) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-7.5850766078230791759487026005670737956192e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(9.6896101680663165228506802190513114402608e-06) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.6893862845317681397414264891236824137784e-06) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.6889858339700658310547566352390163890986e-06) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.1733743265445343427271781411059821348034e-10) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.1061759061434559557275678376352354749776e-17) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-3.3154841996479132120727806621913978936367e-31) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-3.3155377378513002152255276325688795855972e-31) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.1061754859652815507040188040584321029706e-17) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.1733881845765578379689120983400335009689e-10) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-7.5850766077949143976274425577923364614957e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(9.6896101680663165228506808822208011108613e-06) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.6893862845317681397414271522778492048975e-06) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.6889858339700658310547572983658605262190e-06) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.1733743265445343427338091621035440959239e-10) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.1061759061435222659375389660752596873518e-17) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(3.3155367974649307480092510186223064304135e-31) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(3.3154832592615437448565040482448247179610e-31) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.1061754859652152404940476756192546745504e-17) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.1733881845765578379622810773433697700505e-10) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-7.5850766077949143976274425577787048891178e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(9.6896115382693384637576109993256064110220e-06) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.6893876547031308199356445918740607903981e-06) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.6889872040849759999987765682509447893666e-06) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.1870749643919208230078833785297973538420e-10) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.3700748464049154420841387085932184043803e-12) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3700637846458539984451475087548781196145e-12) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3700637846458539984451421549345394150653e-12) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.3700527228909943372133067072168958004951e-12) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.1596875467310272297640267950092486004373e-10) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-7.5850766077667496193062859408285367849627e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(2.4224224980546492755103941413324217627195e-05) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(2.4223665267102145587388549323939210093385e-05) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.4222665988995138887514193284259402745906e-05) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.4533255177752510056717108790955019711177e-05) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.4533137839346616686643205288150313037305e-05) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.4533137839335554834789696498973544651446e-05) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.4533137839335554834789696498968190786196e-05) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.4533137839324492987138005363972081586579e-05) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.4533020499532805437660359327888002580541e-05) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-7.5847778544050276981115048648027459294658e+01) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.3577117115592222539532313655126102258977e-16) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.3576805570313245345912523651562125819773e-16) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.3576353638099849848439519391054844058541e-16) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.3576273199855258324299755453180648426691e-16) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.3576273199771626844145926799840975269183e-16) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3576273199771626836261775704541436317700e-16) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3576273199771626836261775704541436313884e-16) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.3576273199771626828377627604026161624324e-16) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.3576273199687995322825241239331585930072e-16) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.3576072488322872012871631291011144276814e-16) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.2522202856458349444781011292646963636353e-3335) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.2521996528233762813451401779069300412844e-3335) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.2521924508933113306916466710988904087140e-3335) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.2521922981062924802475899179460430801075e-3335) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.2521922981061751721315532652513692265941e-3335) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.2521922981061751721204943358272750867324e-3335) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.2521922981061751721204943358272750867270e-3335) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.2521922981061751721094354106039011391208e-3335) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.2521922981060578640275035842118782865367e-3335) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.2521921433719196192499562499933424828703e-3335) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.2521706769458247361187372191628389767009e-3335) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(-4.8189420014955955261492568640272142276499e-166) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.5033928577364525126911659381794361412758e-50254) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.5033898980268702211474985029607283506426e-50254) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.5033821471147178991009340619992095670106e-50254) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.5033810860560006607272641324413814141392e-50254) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.5033810690489602705325114028930148522536e-50254) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.5033810690489472871293591258861156291750e-50254) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.5033810690489472871281351480117193616644e-50254) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.5033810690489472871281351480117193616638e-50254) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.5033810690489472871269111706022495247206e-50254) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.5033810690489343037276474067390616648322e-50254) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.5033810520220148606361270277618703792859e-50254) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.5033799047758487679047827946304646788596e-50254) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.5033549842591150011010305278827799678388e-50254) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(-2.7745179706351342829446703881151780265393e-50106) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(8.8157455929322894506038837872679886500842e-78718) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(8.8157316473512563876702896631472045815291e-78718) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(8.8156980988407240606956650927166370615104e-78718) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(8.8156938874962895990967577550452901628527e-78718) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(8.8156938208059236595209170101787265102384e-78718) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(8.8156938208058727570452202597279400668749e-78718) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(8.8156938208058727570404215560856913463062e-78718) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(8.8156938208058727570404215560856913463038e-78718) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(8.8156938208058727570356228542662240685825e-78718) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(8.8156938208058218545751863668905796441822e-78718) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(8.8156937540633461131334738285552806348386e-78718) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(8.8156893171615927786236047794697295172344e-78718) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(8.8156242515549519128543254799150124465489e-78718) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(8.8155408359348735057750911595264198354765e-78718) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(1.1011444051464704196112169681957645213178e-6908211) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.1011380853429590656360551196130683837697e-6908211) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.1011380369091802915313150797178662892193e-6908211) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.1011379476297802840461487889174383467098e-6908211) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.1011379386604078257899220174239252622786e-6908211) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.1011379385218375023420336175628653204748e-6908211) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.1011379385218373966166413215695107042488e-6908211) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.1011379385218373966166313545724639831935e-6908211) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.1011379385218373966166313545724639831935e-6908211) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.1011379385218373966166213875792032132231e-6908211) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.1011379385218372908912608493938949516654e-6908211) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.1011379383832651675951467775438527903786e-6908211) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.1011379294061123402485566103268419629007e-6908211) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1011378392187421065320741098031408512940e-6908211) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.1011377896519540245714039955032597305394e-6908211) }, 
      { SC_(-9.6886797109618782997131347656250000000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.1011188232848922171252315875660982470110e-6908211) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(6.7129878784360812014560493180588435868691e+15) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(6.7129878784213559262360884653202767518191e+15) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(6.7129878784903481686384753175638348956945e+15) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.7129878785237833465325210148891527341436e+15) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(6.7129878785237833504309555541600481210645e+15) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(6.7129878785237833504309559216750949701542e+15) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(6.7129878785237833504309559216750949701542e+15) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(6.7129878785237833504309562891900022191000e+15) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.7129878785237833543293870414275121131745e+15) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-2.3064235636127435947757456617432238793527e+17) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-1.4532896738246888251494424311658602558326e-05) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-1.4532896738215232099348935701546820008899e-05) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.4532896738158899950231839595075643800916e-05) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.4532897651472742265566233354785953402879e-05) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.4532897651483803865906777346251801365873e-05) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-1.4532897651483803866949588379237285848732e-05) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-1.4532897651483803866949588379237285849237e-05) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.4532897651483803867992399016113523355288e-05) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.4532897651494865598978237286190970598537e-05) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-2.1684046819516632212375722314493111233008e-05) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-4.5668763909811744829238854682929525879746e-13) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-4.5668763909712267253846325379928966364074e-13) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-4.5668775576031514342436072278991338850841e-13) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.3700527229495081072208244914618001341035e-12) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.3700637846426442247366444275536331316609e-12) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-1.3700637846436870445176618193153611969540e-12) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-1.3700637846436870445176618193158659150302e-12) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.3700637846447298639025666411647355541607e-12) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.3700748464685104246893101701607143301298e-12) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-7.1508702458501421065192885972103333454527e-06) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(9.1337614555869521002761516179617933278947e-13) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.1337614555670565663044007675468271377777e-13) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.1337602888819157237541917151357134844901e-13) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.1061694178945713212196009740932846035515e-17) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0428194494671195716793927161122678081074e-24) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-3.3155109687516387181453983974264181777945e-31) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-3.3155109687566858989077048589589576110616e-31) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.0428197164567434093401719826175621129212e-24) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.1061824823389251045185561048165918090445e-17) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-7.1508688757599341336049292860983630326423e-06) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(9.1337614555869521069071726151381644199960e-13) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(9.1337614555670565729354217647087542678641e-13) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.1337602888819157303852127122718843465950e-13) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.1061694178946376314295721025333088178840e-17) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.0428201125692192829637887243158350317934e-24) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(3.3155100283612052419366332833872861360097e-31) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(3.3155100283561580611743268218547467027426e-31) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.0428190533546436980557759744147931737147e-24) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.1061824823388587943085849763774143788605e-17) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-7.1508688757599341336049286229834745991916e-06) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(2.2834399302176748229382158052445953130931e-12) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(2.2834399302127009403899356249692284373245e-12) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.2834398135388652427657831038390860599250e-12) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.3700748463400329532378340897335171958781e-12) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.3700637846468968182261638729764640280908e-12) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3700637846458539984451448318445055668903e-12) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3700637846458539984451448318440008488141e-12) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.3700637846448111790602383606255273263286e-12) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.3700527228210306007778050053453271383907e-12) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-7.1508675056697261585237130939440390702045e-06) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.4533138752850931621567987508118798239491e-05) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.4533138752819274942592459521050786952392e-05) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.4533138752762708550204564731683933401019e-05) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.4533137839346616621761145634742525191539e-05) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.4533137839335554835832525027730708729518e-05) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.4533137839335554834789696498970867718618e-05) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.4533137839335554834789696498970867718113e-05) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.4533137839335554833746868366326919446171e-05) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.4533137839324492917174655508297128125827e-05) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.3825492447840650358162048671190463752363e-06) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.3576273199851182428702747516197270006056e-16) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.3576273199821813762088985558673553758451e-16) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.3576273199779209937482367211744562185487e-16) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.3576273199771626844145925915857421354935e-16) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.3576273199771626836261776447800141649436e-16) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3576273199771626836261775704541436315792e-16) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3576273199771626836261775704541436315792e-16) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.3576273199771626836261774961283013307975e-16) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.3576273199771626828377623098793827602817e-16) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.3576273199752705145798940289494848927967e-16) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.2521922981088135982240178659285519634099e-3335) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.2521922981068685177289997275543802648454e-3335) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.2521922981061895757462896282203310968091e-3335) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.2521922981061751721315532672983062376410e-3335) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.2521922981061751721204943368698281107362e-3335) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.2521922981061751721204943358272750867297e-3335) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.2521922981061751721204943358272750867297e-3335) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.2521922981061751721204943347847224587357e-3335) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.2521922981061751721094354075713908422512e-3335) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.2521922981061605849330897718251330206874e-3335) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.2521922981041368735926817015253186570560e-3335) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(-4.5433686556028247774885389087026009269988e-173) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.5033810690500586319203150477228399064350e-50254) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.5033810690497796145851888674173798086214e-50254) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.5033810690490489190567938799229522278951e-50254) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.5033810690489488904257188338583179119569e-50254) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.5033810690489472871293591261180333799270e-50254) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.5033810690489472871281351481271068268819e-50254) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.5033810690489472871281351480117193616641e-50254) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.5033810690489472871281351480117193616641e-50254) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.5033810690489472871281351478963319402761e-50254) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.5033810690489472871269111702719852671190e-50254) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.5033810690489456819564851115555789236665e-50254) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.5033810690488375281394431149620043292300e-50254) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.5033810690464881872215894559118315148869e-50254) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(-2.6158279626870575166749741109301813732428e-50113) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(8.8156938208107534309645843778240458607967e-78718) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(8.8156938208094387527314437402605484351724e-78718) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(8.8156938208062760580217248261867867529193e-78718) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(8.8156938208058790441133218025315564640832e-78718) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(8.8156938208058727570452202606379009385192e-78718) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(8.8156938208058727570404215565380771787561e-78718) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(8.8156938208058727570404215560856913463050e-78718) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(8.8156938208058727570404215560856913463050e-78718) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(8.8156938208058727570404215556333056856920e-78718) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(8.8156938208058727570356228529721051867895e-78718) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(8.8156938208058664650549519477540683912241e-78718) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(8.8156938208054481870859210418947440826433e-78718) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(8.8156938207993142633294574371252970241769e-78718) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(8.8156938207914503643140643415482772787079e-78718) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(1.1011379385224470197556919355941309017704e-6908211) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.1011379385218512378112270807848408129681e-6908211) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.1011379385218466718378885816778873392091e-6908211) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.1011379385218382552452559128682386229413e-6908211) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.1011379385218374096800133894234668426768e-6908211) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.1011379385218373966166413215714036304048e-6908211) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.1011379385218373966166313545734035970126e-6908211) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.1011379385218373966166313545724639831935e-6908211) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.1011379385218373966166313545724639831935e-6908211) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.1011379385218373966166313545715243697313e-6908211) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.1011379385218373966166213875765182245840e-6908211) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.1011379385218373835530796418723916847069e-6908211) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.1011379385218365372543550966177040022533e-6908211) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1011379385218280350642616881447476657849e-6908211) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.1011379385218233622782580196717740682112e-6908211) }, 
      { SC_(-9.1337614555042634378878574352711439132690e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.1011379385200353396277114218963770824413e-6908211) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(6.7129878785237833504309559216538713285546e+15) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(6.7129878785237833504309559216503078587037e+15) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(6.7129878785237833504309559216670037623163e+15) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.7129878785237833504309559216750949692108e+15) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(6.7129878785237833504309559216750949701542e+15) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(6.7129878785237833504309559216750949701542e+15) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(6.7129878785237833504309559216750949701542e+15) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(6.7129878785237833504309559216750949701542e+15) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.7129878785237833504309559216750949710976e+15) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(6.7129878785237832929917162127460301029312e+15) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-1.4532897651483803866949588158236851776554e-05) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-1.4532897651483803866949588158229191087761e-05) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.4532897651483803866949588158215558885669e-05) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.4532897651483803866949588379234608976570e-05) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.4532897651483803866949588379237285848732e-05) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-1.4532897651483803866949588379237285848984e-05) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-1.4532897651483803866949588379237285848984e-05) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.4532897651483803866949588379237285849237e-05) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.4532897651483803866949588379239962753014e-05) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.4532897651483803868680143773185537877815e-05) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-1.3700637846436870442966276920421470485295e-12) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-1.3700637846436870442966276920414248503501e-12) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.3700637846436870442966277202726884829516e-12) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.3700637846436870445176591424207428572908e-12) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.3700637846436870445176618193153611969589e-12) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-1.3700637846436870445176618193156135560350e-12) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-1.3700637846436870445176618193156135560350e-12) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.3700637846436870445176618193158659150152e-12) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.3700637846436870445176644962420997951622e-12) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.3700637846454175320817763461021953699414e-12) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-1.1051696959877336644320020926432122172180e-31) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-1.1051696959877336644320020926426296519744e-31) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.1051699783132481258403662482013379212711e-31) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-3.3154841998054553003437259232054765571392e-31) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-3.3155109687516387181952238003087985799669e-31) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-3.3155109687541623089560190279002218341753e-31) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-3.3155109687541623089560190279014432358951e-31) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-3.3155109687566858987582344127786326454094e-31) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-3.3155377380190247213968669576745779237285e-31) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.7304878956592293002184288042768613045935e-24) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(5.5258513011251102956500295881858654608378e-31) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.5258513011251102956500295881829526331330e-31) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(5.5258510187995958342416654326180114287603e-31) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(3.3155367973073886597383057576082277669111e-31) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(3.3155100283612052418868078805049057338373e-31) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(3.3155100283586816511260126529134824796290e-31) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(3.3155100283586816511260126529122610779092e-31) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(3.3155100283561580613237972680350716683948e-31) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(3.3154832590938192386851647231391263798299e-31) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.7304872325571295889340327960705983930627e-24) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.3700637846458539986661789591240724292085e-12) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.3700637846458539986661789591233502310291e-12) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.3700637846458539986661789308895109713490e-12) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.3700637846458539984451475087391239107874e-12) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.3700637846458539984451448318445055668853e-12) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3700637846458539984451448318442532078092e-12) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3700637846458539984451448318442532078092e-12) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.3700637846458539984451448318440008488290e-12) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.3700637846458539984451421549177669644482e-12) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.3700637846441235108810430937812306022529e-12) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.4533137839335554834789696720038688510148e-05) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.4533137839335554834789696720031027694827e-05) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.4533137839335554834789696720017338808325e-05) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.4533137839335554834789696498973544635691e-05) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.4533137839335554834789696498970867718618e-05) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.4533137839335554834789696498970867718365e-05) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.4533137839335554834789696498970867718365e-05) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.4533137839335554834789696498970867718113e-05) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.4533137839335554834789696498968190769424e-05) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.4533137839335554833059276762025293156657e-05) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.3576273199771626836261775704560688516576e-16) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.3576273199771626836261775704553581392500e-16) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.3576273199771626836261775704543271402212e-16) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.3576273199771626836261775704541436317700e-16) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.3576273199771626836261775704541436315792e-16) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3576273199771626836261775704541436315792e-16) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3576273199771626836261775704541436315792e-16) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.3576273199771626836261775704541436315792e-16) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.3576273199771626836261775704541436313884e-16) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.3576273199771626836261775704536857326776e-16) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.2521922981061751721204943358279135774698e-3335) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.2521922981061751721204943358274428741656e-3335) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.2521922981061751721204943358272785723614e-3335) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.2521922981061751721204943358272750867324e-3335) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.2521922981061751721204943358272750867297e-3335) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.2521922981061751721204943358272750867297e-3335) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.2521922981061751721204943358272750867297e-3335) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.2521922981061751721204943358272750867297e-3335) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.2521922981061751721204943358272750867270e-3335) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.2521922981061751721204943358272715566767e-3335) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.2521922981061751721204943358267818249575e-3335) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(-1.0994807895831626539186588563312721277732e-191) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.5033810690489472871281351480119883035753e-50254) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.5033810690489472871281351480119207822661e-50254) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.5033810690489472871281351480117439562681e-50254) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.5033810690489472871281351480117197496570e-50254) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.5033810690489472871281351480117193616644e-50254) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.5033810690489472871281351480117193616641e-50254) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.5033810690489472871281351480117193616641e-50254) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.5033810690489472871281351480117193616641e-50254) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.5033810690489472871281351480117193616641e-50254) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.5033810690489472871281351480117193616638e-50254) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.5033810690489472871281351480117189732176e-50254) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.5033810690489472871281351480116928003373e-50254) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.5033810690489472871281351480111242672943e-50254) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(-6.3302206178652745729209454308232914884803e-50132) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(8.8156938208058727570404215560868724538986e-78718) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(8.8156938208058727570404215560865543059403e-78718) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(8.8156938208058727570404215560857889438620e-78718) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(8.8156938208058727570404215560856928677567e-78718) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(8.8156938208058727570404215560856913463062e-78718) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(8.8156938208058727570404215560856913463050e-78718) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(8.8156938208058727570404215560856913463050e-78718) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(8.8156938208058727570404215560856913463050e-78718) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(8.8156938208058727570404215560856913463050e-78718) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(8.8156938208058727570404215560856913463038e-78718) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(8.8156938208058727570404215560856898236645e-78718) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(8.8156938208058727570404215560855886017240e-78718) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(8.8156938208058727570404215560841042116500e-78718) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(8.8156938208058727570404215560822011730560e-78718) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(1.1011379385218373966166313545726115100576e-6908211) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.1011379385218373966166313545724673327186e-6908211) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.1011379385218373966166313545724662277676e-6908211) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.1011379385218373966166313545724641909789e-6908211) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.1011379385218373966166313545724639863548e-6908211) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.1011379385218373966166313545724639831935e-6908211) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.1011379385218373966166313545724639831935e-6908211) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.1011379385218373966166313545724639831935e-6908211) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.1011379385218373966166313545724639831935e-6908211) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.1011379385218373966166313545724639831935e-6908211) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.1011379385218373966166313545724639831935e-6908211) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.1011379385218373966166313545724639800322e-6908211) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.1011379385218373966166313545724637752306e-6908211) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1011379385218373966166313545724617177275e-6908211) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.1011379385218373966166313545724605869282e-6908211) }, 
      { SC_(-2.2103412727664286445240169352604645491846e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.1011379385218373966166313545720278911237e-6908211) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(6.7129878785237833504309559216963186027242e+15) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(6.7129878785237833504309559216998820710590e+15) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(6.7129878785237833504309559216831861745497e+15) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.7129878785237833504309559216750949710976e+15) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(6.7129878785237833504309559216750949701542e+15) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(6.7129878785237833504309559216750949701542e+15) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(6.7129878785237833504309559216750949701542e+15) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(6.7129878785237833504309559216750949701542e+15) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.7129878785237833504309559216750949692108e+15) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(6.7129878785237834078701711929292631036345e+15) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-1.4532897651483803866949588600237625896202e-05) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-1.4532897651483803866949588600245286581735e-05) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.4532897651483803866949588600258918778027e-05) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.4532897651483803866949588379239962720260e-05) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.4532897651483803866949588379237285849237e-05) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-1.4532897651483803866949588379237285848984e-05) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-1.4532897651483803866949588379237285848984e-05) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.4532897651483803866949588379237285848732e-05) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.4532897651483803866949588379234608946093e-05) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.4532897651483803865219033721558356366952e-05) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-1.3700637846436870447386958525495319991089e-12) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-1.3700637846436870447386958525502541969811e-12) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.3700637846436870447386958243190025754446e-12) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.3700637846436870445176644962093453628491e-12) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.3700637846436870445176618193158659150037e-12) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-1.3700637846436870445176618193156135560350e-12) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-1.3700637846436870445176618193156135560350e-12) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.3700637846436870445176618193153611971622e-12) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.3700637846436870445176591423902662222890e-12) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-1.3700637846419565576897877566955091333986e-12) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-5.5258513011251102956500295881595381787497e-31) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-5.5258513011251102956500295881624510052152e-31) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-5.5258510187997159503708555700904249237054e-31) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-3.3155377376914803982660337435073868960123e-31) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-3.3155109687566858986431459601388824277519e-31) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-3.3155109687541623089560190279014432358431e-31) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-3.3155109687541623089560190279002218346430e-31) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-3.3155109687516387202274715305467130655834e-31) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-3.3154841995006889503265936673877652728161e-31) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.7304864963165713856290737011916015735405e-24) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.1051696959877336644320020926387927773437e-31) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.1051696959877336644320020926393753423394e-31) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.1051699783131280097111761107176343562734e-31) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(3.3154832594213635618159979373063174075459e-31) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(3.3155100283561580614388857206748218860523e-31) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(3.3155100283586816511260126529122610779611e-31) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(3.3155100283586816511260126529134824791613e-31) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(3.3155100283612052398545601502669912482208e-31) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(3.3155367976121550097554380134259390512340e-31) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.7304871594186710969134697093916748260672e-24) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.3700637846458539982241107986039820535443e-12) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.3700637846458539982241107986047042514165e-12) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.3700637846458539982241108268385314989358e-12) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.3700637846458539984451421549505213967613e-12) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.3700637846458539984451448318440008488405e-12) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3700637846458539984451448318442532078092e-12) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3700637846458539984451448318442532078092e-12) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.3700637846458539984451448318445055666821e-12) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.3700637846458539984451475087696005457891e-12) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.3700637846475844852730061057462394180118e-12) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.4533137839335554834789696277903140980465e-05) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.4533137839335554834789696277910801792527e-05) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.4533137839335554834789696277924490673206e-05) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.4533137839335554834789696498968190802178e-05) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.4533137839335554834789696498970867718113e-05) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.4533137839335554834789696498970867718365e-05) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.4533137839335554834789696498970867718365e-05) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.4533137839335554834789696498970867718618e-05) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.4533137839335554834789696498973544666168e-05) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.4533137839335554836520115499704835360183e-05) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.3576273199771626836261775704522184123200e-16) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.3576273199771626836261775704529291244252e-16) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.3576273199771626836261775704539601230154e-16) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.3576273199771626836261775704541436313884e-16) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.3576273199771626836261775704541436315792e-16) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3576273199771626836261775704541436315792e-16) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3576273199771626836261775704541436315792e-16) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.3576273199771626836261775704541436315792e-16) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.3576273199771626836261775704541436317700e-16) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.3576273199771626836261775704546015302860e-16) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.2521922981061751721204943358266365962612e-3335) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.2521922981061751721204943358271072993652e-3335) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.2521922981061751721204943358272716010995e-3335) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.2521922981061751721204943358272750867270e-3335) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.2521922981061751721204943358272750867297e-3335) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.2521922981061751721204943358272750867297e-3335) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.2521922981061751721204943358272750867297e-3335) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.2521922981061751721204943358272750867297e-3335) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.2521922981061751721204943358272750867324e-3335) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.2521922981061751721204943358272786167812e-3335) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.2521922981061751721204943358277683482920e-3335) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.0994803218061825407811696229851183395168e-191) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.5033810690489472871281351480114504198673e-50254) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.5033810690489472871281351480115179411478e-50254) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.5033810690489472871281351480116947670705e-50254) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.5033810690489472871281351480117189736713e-50254) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.5033810690489472871281351480117193616638e-50254) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.5033810690489472871281351480117193616641e-50254) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.5033810690489472871281351480117193616641e-50254) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.5033810690489472871281351480117193616641e-50254) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.5033810690489472871281351480117193616641e-50254) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.5033810690489472871281351480117193616644e-50254) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.5033810690489472871281351480117197501104e-50254) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.5033810690489472871281351480117459229796e-50254) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.5033810690489472871281351480123144557807e-50254) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(6.3302179246563416568965393750633584671433e-50132) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(8.8156938208058727570404215560845102392139e-78718) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(8.8156938208058727570404215560848283870369e-78718) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(8.8156938208058727570404215560855937487895e-78718) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(8.8156938208058727570404215560856898248540e-78718) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(8.8156938208058727570404215560856913463038e-78718) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(8.8156938208058727570404215560856913463050e-78718) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(8.8156938208058727570404215560856913463050e-78718) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(8.8156938208058727570404215560856913463050e-78718) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(8.8156938208058727570404215560856913463050e-78718) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(8.8156938208058727570404215560856913463062e-78718) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(8.8156938208058727570404215560856928689449e-78718) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(8.8156938208058727570404215560857940908423e-78718) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(8.8156938208058727570404215560872784802847e-78718) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(8.8156938208058727570404215560891815180691e-78718) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(1.1011379385218373966166313545723164563922e-6908211) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.1011379385218373966166313545724606336698e-6908211) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.1011379385218373966166313545724617386204e-6908211) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.1011379385218373966166313545724637754082e-6908211) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.1011379385218373966166313545724639800322e-6908211) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.1011379385218373966166313545724639831935e-6908211) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.1011379385218373966166313545724639831935e-6908211) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.1011379385218373966166313545724639831935e-6908211) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.1011379385218373966166313545724639831935e-6908211) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.1011379385218373966166313545724639831935e-6908211) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.1011379385218373966166313545724639831935e-6908211) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.1011379385218373966166313545724639863548e-6908211) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.1011379385218373966166313545724641911564e-6908211) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1011379385218373966166313545724662486585e-6908211) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.1011379385218373966166313545724673794574e-6908211) }, 
      { SC_(2.2103403323709479866940105602712347713881e-31), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.1011379385218373966166313545729000750778e-6908211) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(6.7129878786114854577626335858130116831606e+15) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(6.7129878786262107259912916283649275559807e+15) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(6.7129878785572185163481637997814551046078e+15) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.7129878785237833543293889774419950225906e+15) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(6.7129878785237833504309562891899673191262e+15) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(6.7129878785237833504309559216750949701542e+15) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(6.7129878785237833504309559216750949701542e+15) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(6.7129878785237833504309555541603622212599e+15) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.7129878785237833465325266529399218910252e+15) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.4406821942122713228106550599933893587227e+17) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-1.4532898564720285851107185310811139836249e-05) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-1.4532898564751941992200557032529892598578e-05) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.4532898564808274121665408259447874775260e-05) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.4532897651494865463080775472784639132142e-05) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.4532897651483803867992398917084817381344e-05) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-1.4532897651483803866949588379237285849237e-05) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-1.4532897651483803866949588379237285848732e-05) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.4532897651483803865906778237498813216479e-05) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.4532897651472742140173169434740878152348e-05) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(-7.3817518788511432293366245332685749547232e-06) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-2.2834394964918499274850699212274320461504e-12) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-2.2834394964968238067269487948991622817698e-12) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-2.2834393798407822103477040678875557970053e-12) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.3700748463326137698232494341329134694639e-12) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.3700637846447298638035371044667119983063e-12) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-1.3700637846436870445176618193158659149963e-12) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-1.3700637846436870445176618193153611971597e-12) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.3700637846426442256278989159988427198339e-12) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.3700527228241159383684124132480295647749e-12) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.1508641104554892095342898896462843678500e-06) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-9.1337571186128849120054895854188633704856e-13) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-9.1337571186327804270836987744791057255335e-13) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-9.1337559520191483548681906610802566960444e-13) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.1061688926734385060523114232402911634858e-17) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.0428196174272067112383029955890809301691e-24) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-3.3155109687566858985684114573571430806007e-31) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-3.3155109687516387202025609900292820211918e-31) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0428185582126311257649790066870925758669e-24) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.1061819571114565539893460964033899257048e-17) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.1508654804928505365399419507739615041320e-06) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-9.1337571186128849053744685883695465122588e-13) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-9.1337571186327804204526777774153449121503e-13) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-9.1337559520191483482371696639907396269092e-13) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.1061688926733721958423402948011137369836e-17) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.0428189543251069999539069873863119909247e-24) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(3.3155100283561580615136202234565612332035e-31) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(3.3155100283612052398794706907844222926124e-31) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0428192213147308370493750148906597992118e-24) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.1061819571115228641993172248434141359534e-17) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.1508654804928505365399426138632724993222e-06) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(4.5668807277143989967454548188523109060890e-13) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.5668807277243467590078723490504109734842e-13) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(4.5668818943911949396465231020786398936022e-13) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.3700527229569272556437135942111576817564e-12) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.3700637846448111791592678973237075084483e-12) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3700637846458539984451448318440008488480e-12) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3700637846458539984451448318445055666846e-12) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.3700637846468968173349093845298447888450e-12) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.3700748464654251220900774064221927325396e-12) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.1508668505302118657126463119833045966205e-06) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.4533136925820611811527887395802742919676e-05) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.4533136925852268471492840424757607771288e-05) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.4533136925908834829926305971744865065045e-05) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.4533137839324493053070503413336782156012e-05) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.4533137839335554833746868465357286840787e-05) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.4533137839335554834789696498970867718113e-05) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.4533137839335554834789696498970867718618e-05) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.4533137839335554835832524136468743937094e-05) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.4533137839346616747152419408761875609076e-05) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.1683723038753039893993245141444533081660e-05) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.3576273199692071281595124888584974502295e-16) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.3576273199721439934264045770510921252358e-16) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.3576273199764043738641726753460403134432e-16) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.3576273199771626828377629236705212145376e-16) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.3576273199771626836261774961283083889418e-16) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3576273199771626836261775704541436315792e-16) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3576273199771626836261775704541436315792e-16) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.3576273199771626836261776447799506416474e-16) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.3576273199771626844145924566808147266718e-16) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.3576273199790548517740410274507365772064e-16) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.2521922981035367472697296039746571698236e-3335) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.2521922981054818268411973189527247107427e-3335) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.2521922981061607685015380408540773127860e-3335) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.2521922981061751721094354096071441633626e-3335) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.2521922981061751721204943347847225577387e-3335) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.2521922981061751721204943358272750867297e-3335) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.2521922981061751721204943358272750867297e-3335) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.2521922981061751721204943368698272197085e-3335) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.2521922981061751721315532588322606302507e-3335) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.2521922981061897593009727457082198726050e-3335) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.2521922981082134696805040901029182720359e-3335) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(4.5433664984435555206854277083875958773641e-173) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.5033810690478359428636345925893563368222e-50254) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.5033810690481149600662799648213369513089e-50254) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.5033810690488456552477323615047466141816e-50254) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.5033810690489456838313127251938282090464e-50254) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.5033810690489472871269111704865633814800e-50254) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.5033810690489472871281351478963319512335e-50254) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.5033810690489472871281351480117193616641e-50254) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.5033810690489472871281351480117193616641e-50254) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.5033810690489472871281351481271067282649e-50254) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.5033810690489472871293591251702955921863e-50254) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.5033810690489488922990230316156108711601e-50254) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.5033810690490570460647124345693010095908e-50254) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.5033810690514063858670776376852424534400e-50254) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.6158267207051897442617591989108373441439e-50113) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(8.8156938208009920854336581836244376614924e-78718) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(8.8156938208023067630425741226587936871491e-78718) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(8.8156938208054694562506099706985909252931e-78718) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(8.8156938208058664699705064798308659740869e-78718) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(8.8156938208058727570356228538119585573081e-78718) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(8.8156938208058727570404215556333057286515e-78718) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(8.8156938208058727570404215560856913463050e-78718) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(8.8156938208058727570404215560856913463050e-78718) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(8.8156938208058727570404215565380767921204e-78718) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(8.8156938208058727570452202569208013856772e-78718) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(8.8156938208058790490229036616942026830625e-78718) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(8.8156938208062973267933316860321527877570e-78718) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(8.8156938208124312476373468317178328748987e-78718) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(8.8156938208202951429188943604166117917940e-78718) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(1.1011379385212277737670267685032047614795e-6908211) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.1011379385218235554286075773740240023098e-6908211) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.1011379385218281213997781028783798874597e-6908211) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.1011379385218365379884144824314759533562e-6908211) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.1011379385218373835532555223564879065542e-6908211) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.1011379385218373966166213875782567748382e-6908211) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.1011379385218373966166313545715243698205e-6908211) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.1011379385218373966166313545724639831935e-6908211) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.1011379385218373966166313545724639831935e-6908211) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.1011379385218373966166313545734035962095e-6908211) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.1011379385218373966166413215636773043685e-6908211) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.1011379385218374096801768645569449315626e-6908211) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.1011379385218382559784995780280185832429e-6908211) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1011379385218467581645560548009915814567e-6908211) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.1011379385218514309483410340582627959588e-6908211) }, 
      { SC_(9.1337571186955734958701214054599404335022e-13), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.1011379385236394527499180948507803805804e-6908211) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(6.7139181096178512279180473026687454021593e+15) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(6.7140743320600419729182630360938487203959e+15) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(6.7133425499897907842093764523222866734500e+15) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.7129878785651361634944283120692311114989e+15) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(6.7129878785237833543293873162482784403498e+15) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(6.7129878785237833504309559216750949710976e+15) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(6.7129878785237833504309559216750949692108e+15) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(6.7129878785237833465325260079163389994925e+15) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.7129878784824305775388705818321850104831e+15) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.5178574964672014576144215415400892425384e+24) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-2.4219166539853493176664778098198486525555e-05) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-2.4219726149149757883806614428784912500348e-05) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-2.4220722831442805169206381605596888458167e-05) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.4533014987888052650380410275340889927222e-05) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.4532897651494865529062343243716400156777e-05) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-1.4532897651483803866949588379239962736148e-05) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-1.4532897651483803866949588379234608962732e-05) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.4532897651472742209038579095760864485370e-05) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(-1.4532780313693715837879707477110983715235e-05) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.5858508986481206493587457716412123878709e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-9.6877470743544523112412369626537985439496e-06) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-9.6879709199308460700738608082952306691894e-06) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-9.6883688535475675690823028483650695134472e-06) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.1870745236648864951921298378817058335723e-10) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.3700748463985949176241094277064074264748e-12) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-1.3700637846436870445176644962252333169391e-12) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-1.3700637846436870445176591424069049138502e-12) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.3700527228929809522404015241951818935029e-12) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.1596871062741972983482598630087597574060e-10) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.5855550212396958729166206115750127600270e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-9.6877457044298914387100456613624693275731e-06) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-9.6879695499746316508845898363260267295714e-06) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-9.6883674835349071622544060711926407982292e-06) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.1733738858193775646948596019554118288689e-10) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.1061754907882185880924766343797722892315e-17) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-3.3155377378503599391663713198290751577669e-31) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-3.3154841996670758659382576680959670764955e-31) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.1061750706100693588094865957116795029675e-17) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.1733877441215621002244989122011463506923e-10) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.5855550212118033243469227126549371906782e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-9.6877457044298914387100449983277530301253e-06) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-9.6879695499746316508845891732759903182080e-06) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-9.6883674835349071622544054081152848902534e-06) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.1733738858193775646882285809587481019007e-10) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.1061754907881522778825055059405948608132e-17) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(3.3154832592624840209156603609846291457914e-31) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(3.3155367974457680941437740127177372475547e-31) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.1061750706101356690194577241517037150219e-17) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.1733877441215621002311299331987083075254e-10) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.5855550212118033243469227126414373757571e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-9.6877443345053305640120241782056321219159e-06) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-9.6879681800184172295284386472855796842315e-06) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-9.6883661135222467532595423122078484448035e-06) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.1596732479738469646516806247987879361580e-10) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.3700527228909461078429327844804289052927e-12) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3700637846458539984451421549346334426712e-12) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3700637846458539984451475087529618542280e-12) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.3700748463965601082181629201793312903060e-12) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.1870883819689485716466409242772249690070e-10) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.5855550211839107757773286795841450951847e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(4.8439153052166754836297157503018661593720e-06) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.8440272289693726427423864380096924005971e-06) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(4.8442280537547584681448789781394193336839e-06) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.4533020500962672498048196271882295794808e-05) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.4533137839324492987089775588840366201359e-05) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.4533137839335554834789696498968190786290e-05) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.4533137839335554834789696498973544649529e-05) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.4533137839346616678287801332895736457150e-05) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.4533255179094258362671346835189922961058e-05) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.5852591555365453224410500302298228403668e+01) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.3575429336654877370072694448364843968760e-16) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.3575740850238776516580923698497644986002e-16) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.3576192761936164378458644598918965310541e-16) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.3576273199687995379626869708351417617328e-16) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.3576273199771626828377627569642638466397e-16) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3576273199771626836261775704541436313884e-16) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3576273199771626836261775704541436317700e-16) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.3576273199771626844145920844657094416234e-16) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.3576273199855258318296205845794303588961e-16) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.3576473913661081279997178838502043231143e-16) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.2521643112024787202692359975440707055365e-3335) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.2521849434349137256679051984229659817766e-3335) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.2521921453191150109518599860137696222446e-3335) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.2521922981060578640374465083453976011182e-3335) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.2521922981061751721094354105556714898708e-3335) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.2521922981061751721204943358272750867270e-3335) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.2521922981061751721204943358272750867324e-3335) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.2521922981061751721315532568981600686516e-3335) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.2521922981062924801694373675735347907286e-3335) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.2521924528403917293611676540291369207223e-3335) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.2522139196295334809628756544384920694622e-3335) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(4.8198548636703843102218547786497652880877e-166) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.5033692804583049964433821170637241870842e-50254) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.5033722401261874058310102403569322619400e-50254) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.5033799909843544962603405323551018001963e-50254) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.5033810520419004918448213061890005772798e-50254) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.5033810690489343037286340002100348805648e-50254) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.5033810690489472871269111705969115726911e-50254) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.5033810690489472871281351480117193616638e-50254) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.5033810690489472871281351480117193616644e-50254) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.5033810690489472871293591249616008946437e-50254) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.5033810690489602705237477838890907890657e-50254) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.5033810860758735130472779015030223522717e-50254) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.5033822333225102200740505638229572991477e-50254) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.5034071542813252445454574231027681264035e-50254) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.7749842277857342705008264886094049207110e-50106) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(8.8156420490029288320238442456493490175035e-78718) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(8.8156559944369933774069101676697305810533e-78718) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(8.8156895427747037258306791073740860327781e-78718) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(8.8156937541154814608922762506998200709913e-78718) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(8.8156938208058218545790393510258395570492e-78718) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(8.8156938208058727570356228542452961984426e-78718) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(8.8156938208058727570404215560856913463038e-78718) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(8.8156938208058727570404215560856913463062e-78718) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(8.8156938208058727570452202561033057357518e-78718) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(8.8156938208059236594865435025654595519179e-78718) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(8.8156938875483748452324265089632262313772e-78718) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(8.8156983244507623153431418570658475076371e-78718) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(8.8157633905796181515167353624411021079984e-78718) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(8.8158468082733117050936662349227499048445e-78718) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(1.1011314719376086301433381098846956255070e-6908211) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.1011377917007904335876056004187113242123e-6908211) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.1011378401345402358822275372131609296246e-6908211) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.1011379294138980044417179075463152792795e-6908211) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.1011379383832670194922525857572032990818e-6908211) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.1011379385218372908912687901565203386216e-6908211) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.1011379385218373966166213875791597456456e-6908211) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.1011379385218373966166313545724639831935e-6908211) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.1011379385218373966166313545724639831935e-6908211) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.1011379385218373966166413215619822710781e-6908211) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.1011379385218375023419621611885202879713e-6908211) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.1011379386604095736234048405649105460648e-6908211) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.1011379476375591056073009530503312615209e-6908211) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.1011380378249043549879751617305284488404e-6908211) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.1011380873916849965177528993302461832685e-6908211) }, 
      { SC_(9.6886760729830712080001831054687500000000e-06), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.1011570540834400283691095375224574508945e-6908211) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(8.5259065580440763904077965292769061171561e-18) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.7346014464075023019803483828167735306834e-04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.2971245376656969486908846832549015386468e+21) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.7130420787478288685227246131123731498955e+15) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(6.7129878785288929170869513849361199059196e+15) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(6.7129878785237833504309559216763314690866e+15) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(6.7129878785237833504309559216738584716427e+15) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(6.7129878785186737857158272476935166062549e+15) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.7129336788142406013698870856714800197674e+15) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(7.2416919496563574146941611003542058199553e+41) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-2.4788474992041317756624270658764871837532e-43) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-4.0582937681632714430158067234277666357442e-30) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-6.7149023810969521977755383663315593011780e-04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.6831066530256512233801017924987992839722e-04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.4532912149699668193126707138018521966804e-05) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-1.4532897651483803866949591887759562838079e-05) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-1.4532897651483803866949584870716203028083e-05) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.4532883153273446442775718524381486597334e-05) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.3927033842338706766750552238480531994360e-04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.4264786790827276236521190343969250780211e+16) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-2.4788360179342034411707160873487361040298e-43) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-4.0582743055347826478062121122534445907211e-30) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-6.7144850029660862450138029327080944755957e-04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.5377905923203475027874530954362926382798e-04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.5868401272975527229908083839095631210825e-11) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-1.3700637846436870480262135289285061391072e-12) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-1.3700637846436870410091113038809317411679e-12) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.3128268196739949775675203394917499296691e-11) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.5380452475854109732341798370606924827706e-04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.4263673242850307373987998158011391573133e+16) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-2.4788360179331207077465163298858726662561e-43) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-4.0582743055329472592366546765683274834679e-30) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-6.7144850029267397000323155678807150928811e-04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.5377905786209259501741797524908363140628e-04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.4498337488343305794007853073436526933658e-11) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-3.8401028064910834548247176859321824497729e-30) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(3.1769994185620402238840673503690824192826e-30) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.4498331981395102423791866080386254656083e-11) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.5380452612872649653389403274580710404725e-04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.4263673242745332841909770433254303721391e+16) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-2.4788360179331207077465163298853486302112e-43) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-4.0582743055329472592366546765674391671515e-30) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-6.7144850029267397000323155678616716170327e-04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.5377905786209259501741797458604039953730e-04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.4498337488343305793344750973730791818650e-11) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-3.1770007067797990588165145178521549268022e-30) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(3.8401015182733246198922705184517957586156e-30) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.4498331981395102424454968180103088330983e-11) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.5380452612872649653389403340896806443021e-04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.4263673242745332841909770433203496719982e+16) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-2.4788360179320379743222476532147445763207e-43) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-4.0582743055311118706669844643682014991369e-30) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-6.7144850028873931550509658185791295553766e-04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.5377905649215043975392330769907031784984e-04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.3128273703708917403517001402763739704211e-11) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3700637846458539949365931222258113430232e-12) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3700637846458540019536953472844843025014e-12) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.5868395766052422026499078273413831210446e-11) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.5380452749891189574653665768903452450394e-04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.4263673242640358309831996398013252322031e+16) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(-2.4788245289101898490581068274095349453420e-43) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-4.0582548302178741868776257842607114198694e-30) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-6.7140676403455176679282544352521155356902e-04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.3924721019083794021462198961471852975643e-04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.4533123340876446521625337599763537439216e-05) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.4533137839335554834789692990389726455552e-05) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.4533137839335554834789700007550814792951e-05) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.4533152337789156153552102524732422055545e-05) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.6833895397898483976756292270985312036488e-04) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.4262559745991318668125487682970227075704e+16) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.4961938975517699169280445571512212244734e-54) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.9798799053356946213169730446898099534579e-41) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.6167705338482478532217075694370069594826e-20) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.3576163586745272242195516951755267512574e-16) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.3576273199761293300451178864268064395322e-16) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3576273199771626836261775704538935632885e-16) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3576273199771626836261775704543936997848e-16) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.3576273199781960368147200240615124354855e-16) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.3576382813672134903041927072378794706484e-16) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.6910587396612373571360468277120738750275e-11) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(2.2519598205161564059884392286436365159056e-3348) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.6052590702510127044381713482078097068269e-3339) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0671197675765923723589754822856591936297e-3335) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.2521921443537111208855971469262773632001e-3335) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.2521922981061606774917322219220316010737e-3335) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.2521922981061751721204943358272715790755e-3335) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.2521922981061751721204943358272785943827e-3335) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.2521922981061896667437506837102125005914e-3335) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.2521924518586133868066093328257057491760e-3335) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.4723295821052753394367178479037094054521e-3335) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(2.5298064524784792039091688458119471858200e-3326) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.5318526437471894567137596744682361736678e-118) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(5.1618033805826182495454013987407622428554e-50259) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(6.8182788032358496953704386495920160449529e-50258) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.8731824654749434137826337872096880980111e-50255) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.4812548275633411421651441642855603794725e-50254) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.5033810520319632536451067383896992688980e-50254) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.5033810690489456828946490600503392774665e-50254) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.5033810690489472871281351480117189734447e-50254) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.5033810690489472871281351480117197498834e-50254) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.5033810690489488913610118699363510712985e-50254) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.5033810860659264166489671960688713888369e-50254) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.5258642411111909185152248210019397071185e-50254) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(4.1483392414153954315040969424055320735435e-50254) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(9.8007735783846291022818443549468882759471e-50245) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(8.2455308105875691250826630849246377338277e-50065) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(3.9999355441081569101060214769220608782526e-78721) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(3.1814965659753386194054948114212068046324e-78720) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.6668672066525337910146899683645174503980e-78718) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(8.7287164512703460022210485395071496022694e-78718) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(8.8156937540894188611359782068598416851385e-78718) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(8.8156938208058664675140879980912520758623e-78718) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(8.8156938208058727570404215560856898242596e-78718) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(8.8156938208058727570404215560856928683499e-78718) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(8.8156938208058790465643660455486542150410e-78718) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(8.8156938875223071566235709785218394662236e-78718) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(8.9036068143333432573046545093901617081074e-78718) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.7220502941408367741505649050785598650924e-78717) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(2.7198644799189091534015278290694558327045e-78713) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(6.0434705802483960581064422588524979525619e-78708) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(5.0005290608660969697651707880364828080348e-6908215) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(9.2458029702356247824438282842750889553465e-6908212) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(9.7944891120886304425490633405487501732621e-6908212) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0892648877514881615302081432604654793180e-6908211) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.1009563331224036013000232323878404117820e-6908211) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.1011379383832660758618365305998673414971e-6908211) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.1011379385218373835531677474573598930741e-6908211) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.1011379385218373966166313545724639800322e-6908211) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.1011379385218373966166313545724639863548e-6908211) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.1011379385218374096800899995476193927854e-6908211) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.1011379386604086757647908590693076601335e-6908211) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.1013195762369173688459956789793534853225e-6908211) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.1131507173280257411190296470501226947253e-6908211) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.2392960033900116761802176310206297276016e-6908211) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.3146129171627117262111271195696270305336e-6908211) }, 
      { SC_(1.2698680877685546875000000000000000000000e+01), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0184045000000000000000000000000000000000e+06), SC_(8.3668392748388898068303411255419703915340e-6908202) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-1.6595309304843955876132382891204363149770e-169) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.6146507400180575887587219733191683484502e+36) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.7165528266988676008920345307450424829753e+15) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(6.7129878788597656355053319995123883716529e+15) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(6.7129878785237833504309559217564016180099e+15) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(6.7129878785237833504309559215937883499722e+15) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(6.7129878781878011929967900017927836659124e+15) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.7094249307602873432034073338977904458632e+15) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.1964217412949383555868403692139154700206e+143) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.2327589882394893423600380513821934427218e-226) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.0208237954131524960127173055987705644239e-04) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.0076002891718179597729220164176456206046e-02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.4533850989412661065807113356992111653951e-05) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-1.4532897651483803866949819083993910034876e-05) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-1.4532897651483803866949357674559184830565e-05) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.4531944313916160899493823749359597527075e-05) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0149323227838080341496868644729337999642e-02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0102674988338973594789284828654247080295e+104) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.2323300425537294350405833449524427227248e-226) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.0212703792050069788921458822268454710614e-04) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.0061555142182347436002805384159428882864e-02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-9.5471599009331088279621014941381602371092e-10) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-1.3700637846436872752243538014026672260732e-12) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-1.3700637846436868138110483610547553440864e-12) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.5197550130674869420196164969547539381793e-10) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0163940641733647110410185340295217810281e-02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0101968692727499357586403077234276347749e+104) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.2323300425132935089055983888988659071008e-226) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.0212703792471043828010183527499758284521e-04) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.0061555140820310515091230505895051921241e-02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-9.5334592630942112295020665407635991808585e-10) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-2.3103824307914491789273216927144578582965e-28) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(2.3037506236156788991075301010640373154168e-28) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.5334556509214630815742500899728495551216e-10) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0163940643111678448524537885334215496795e-02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0101968692660917440159043089766343760902e+104) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.2323300425132935089055983888792951777492e-226) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.0212703792471043828010183527703507024083e-04) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.0061555140820310515091230505235834772183e-02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-9.5334592630942112294954355197701352962662e-10) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-2.3037514097943363349672396610345271905814e-28) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(2.3103816446127917430676121327457340560288e-28) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.5334556509214630815808811109736113570608e-10) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0163940643111678448524537886001173841373e-02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0101968692660917440159043089734118539169e+104) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.2323300424728575827709624035643418054546e-226) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.0212703792892017867092947994541828978517e-04) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.0061555139458273594177463817866794854448e-02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-9.5197586252552919614961022614328594434682e-10) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3700637846458537677384528493923035541748e-12) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3700637846458542291517582904700072791573e-12) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.5471562887754608906747660611692644988383e-10) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0163940644489709786641032440201426503065e-02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0101968692594335522732121870923645905450e+104) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.2319011361606842709532220943806268018779e-226) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-1.0217168959046230617035956779736384729148e-04) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.0047107146916569127158762449604131930663e-02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.4532184485412059321809448576440558382464e-05) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.4533137839335554834789465790343591767969e-05) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.4533137839335554834789927207519619183866e-05) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.4534091192897830029643121630284725700591e-05) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.0178558295745184673894457050405626479637e-02) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0101262446529943324247833428451722210469e+104) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-1.1537860469464929323878016763467038108586e-282) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.8281552715306000362065765404537157390182e-43) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.3569067326588706322799638175735944919461e-16) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.3576273199092139668735194101867560128478e-16) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3576273199771626836261775704377002575355e-16) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3576273199771626836261775704705870000262e-16) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.3576273200451113745718375896297403053288e-16) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.3583482710861712934069116243764047004703e-16) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(8.1013448741251014664657547612006506213182e+63) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(2.7570485909534920209468185926748252192622e-4311) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(2.8362364240150649206139433312077436279153e-3591) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.2478140072469050630076723545044486997349e-3340) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.2521821880709258149582472239393492800726e-3335) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.2521922981052220700630122150669646175564e-3335) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.2521922981061751721204943358270444390533e-3335) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.2521922981061751721204943358275057343276e-3335) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.2521922981071282738159425843828129498740e-3335) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.2522024082200478467987569680026204804533e-3335) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(5.0483537192631085818016207192794159421881e-3331) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.6399483753119374276708841431006949545333e-2999) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.4255817299501775825446162693385437186640e-50551) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.0105984426811537559142063287144283748155e-50476) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.9045202099452337880739916903757572806889e-50281) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(5.6706732723992166652849243596373097812238e-50255) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.5033799500884815150273317411522281831017e-50254) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.5033810690488417998982538853680022594873e-50254) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.5033810690489472871281351480116938340889e-50254) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.5033810690489472871281351480117448892306e-50254) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.5033810690490527743179472286659282139033e-50254) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.5033821880099107086725091808304472521955e-50254) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.9899553866399134621495359651714021789254e-50254) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.2218588648294243504026275053320384115362e-50225) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(9.6541461768407754327295311829059679604328e-49727) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.0726755349774883330627090294504031408118e-49083) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(3.7097756542430689792323986693091896786226e-78939) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(2.3760526043108200762471570368711803308291e-78879) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.8073735267012006836050186604776930161269e-78736) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(4.5930514358743912429362262088284129733892e-78718) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(8.8156894338308808840439604688715208212479e-78718) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(8.8156938208054591858764071449976457787415e-78718) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(8.8156938208058727570404215560855912633944e-78718) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(8.8156938208058727570404215560857914291815e-78718) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(8.8156938208062863280473415087191777290336e-78718) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(8.8156982077817324343422321813879273080700e-78718) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.6928709156755109941587868932884833712419e-78717) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.1087260678373344308075405055201878242974e-78698) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(7.1205637979418107949554403002214614348739e-78433) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(9.1914220163102960159079421499238480187382e-78165) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0184047500000000000000000000000000000000e+06), SC_(1.6118798761267429434716498410654147208171e-6908431) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.1250326376610913964543064924566384392314e-6908216) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(4.9832082303073476607110210382554379672623e-6908215) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.3982129358383691077779847141376760425263e-6908212) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0892599223451064066580204991978597924979e-6908211) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.1011379294100062108096247174363687395565e-6908211) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.1011379385218365376216031871151873636481e-6908211) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.1011379385218373966166313545724637753194e-6908211) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.1011379385218373966166313545724641910675e-6908211) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.1011379385218382556113332338672317384554e-6908211) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.1011379476336659208100539093863260911186e-6908211) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.1131456372074642584611623058553025087621e-6908211) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(2.2474901087108372770863094759719552467481e-6908211) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(2.6138528812606387698763296265955669428814e-6908208) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.2650615445634894319037094064791655900554e-6908206) }, 
      { SC_(8.3500854492187500000000000000000000000000e+02), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0184045000000000000000000000000000000000e+06), SC_(5.8705962068399510352939917240673018292555e-6907565) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-1.7260967761431603491153639885615044978344e-159) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-2.1967403760711028109840253749614271237731e+46) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.7517662610692203019853316276486315231669e+15) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(6.7129878821684166855702364529620011653131e+15) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(6.7129878785237833504309559225570846827983e+15) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(6.7129878785237833504309559207931055577060e+15) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(6.7129878748791514017896095870650422736237e+15) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.6744445203979927130890186339820057728749e+15) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.5155029373938938206029156305282567694986e-226) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.5340652078397588232119547064748223628038e-03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.0380409555908616141415204761285233884508e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.4543239170463539404402431550249495166761e-05) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-1.4532897651483803866952090994058668096949e-05) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-1.4532897651483803866947085765267698967596e-05) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.4522556136325319878054434272842246545961e-05) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.1581229702900687350590905128386874524538e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.5151132756202362466606998802663446632272e-226) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.5338491370953951974273165118951750807673e-03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.0379051842546929927163332115484636834586e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.0342975797434316360214933100606593323451e-08) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-1.3700637846436895471534773736777544306158e-12) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-1.3700637846436845418826980674656701929784e-12) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0340231848579869869121051877912571010941e-08) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.1582771170317423506403943128868385609966e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.5151132755835031135440928777413003826584e-226) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.5338491370750268513932539263701455707210e-03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.0379051842418933620721387362915954876882e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.0341605733657851045452753218779409777023e-08) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-2.5029673666532166972631712535264060581475e-27) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(2.5023034126569536666162315432905017457064e-27) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0341601912372691925278743968810235421201e-08) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.1582771170462742478391560074832270907201e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.5151132755835031135440928777235217814199e-226) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.5338491370750268513932539263602874216522e-03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.0379051842418933620721387362854005484081e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.0341605733657851045452090116683656772448e-08) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-2.5023042645535054128671630503592825788807e-27) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(2.5029665147566649510122397464595410069763e-27) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0341601912372691925279407070913904983884e-08) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.1582771170462742478391560074902604359215e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.5151132755467699804277218928759888859363e-226) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.5338491370546585053594139364436603815209e-03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.0379051842290937314279199439849800457846e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.0340235669881383563735957287982537693695e-08) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3700637846458514958093292735238320178448e-12) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3700637846458565010801085876524755390007e-12) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.0342971976165516148391001181160349018892e-08) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.1582771170608061450379366188549519876174e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.5147236404273792693751971970647033277706e-226) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.5336330914108554869178577806716188279335e-03) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.0377694101907567215595092372897138988954e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.4522796146850861571628912075027082858836e-05) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.4533137839335554834787193842161835904774e-05) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.4533137839335554834792199154928089874373e-05) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.4543479527998929329354042007768473784223e-05) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.1584312658924089941968191704034707807013e-01) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.7212953372261257326071019487696351117334e-292) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.9651092293797114417084431559771059903474e-52) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.3498299910050702752087722829131624608107e-16) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.3576273192400757328083488773159799619861e-16) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3576273199771626836261775702757709261464e-16) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3576273199771626836261775706325162763008e-16) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.3576273207142493548427323955404988736466e-16) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.3654674338149439436602516108875409122509e-16) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.5148058346871540406936581899288267925557e+284) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.6138238909123505591130741950925530818819e-4575) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.0209614061084367765974227481362989803376e-3387) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.2520826318842603312935708812545582751303e-3335) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.2521922980958362117529746248106793503837e-3335) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.2521922981061751721204943358247730910973e-3335) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.2521922981061751721204943358297770815105e-3335) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.2521922981165141285608584769689252432188e-3335) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.2523019738938799903424688879954949105589e-3335) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.5062144256169866428907105793291923648228e-3287) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(9.5802942100572869074848415754847152184629e-1590) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(2.4858400570812205355605090958027537671854e-53027) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(8.1471435438322146034582779811388608066025e-50553) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(3.8208381068776911479975069582097514545929e-50259) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.5033689309516436260694133042295868884873e-50254) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.5033810690478029938381734043828063364902e-50254) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.5033810690489472871281351480114424463155e-50254) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.5033810690489472871281351480119962769184e-50254) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.5033810690500915799834394194933391593895e-50254) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.5033932072406105089807872677621875049807e-50254) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(5.9397630991827506752209815016154426423640e-50250) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.5082564839206342206814254490893966889426e-49948) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(2.7377793940191090600381403940978215908580e-46608) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(8.4954422822238802948600194633416230952336e-44611) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(1.5417812860630516026378112023983838594014e-80594) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.7608639739204783946957098363393041570049e-78917) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(7.4677595115170279774827343453060859133171e-78721) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(8.8156462323560442405792631776201992099988e-78718) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(8.8156938208013864632166468377018803103616e-78718) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(8.8156938208058727570404215560846056774221e-78718) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(8.8156938208058727570404215560867770148184e-78718) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(8.8156938208103590491600855846745668916486e-78718) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(8.8157414094983128227426060291871981312013e-78718) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.0438856634105577626062764693212191148633e-78714) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(7.5859352089875133994657343805976789164198e-78513) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(7.0540494725942347087155077237856751538094e-76187) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.0087642667899605577204858077863485409612e-74698) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(7.9805295951229378957204662253394343214173e-6908266) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(5.7866279287946872444523067742501622327736e-6908248) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.8247588732649798326353173214433684446398e-6908215) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.7891931309203637113806203582543829639301e-6908212) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.1011378396794763629928642189513196178095e-6908211) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.1011379385218280785006096402418905353623e-6908211) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.1011379385218373966166313545724617282390e-6908211) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.1011379385218373966166313545724662381473e-6908211) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.1011379385218467147291135945247442121324e-6908211) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.1011380373641776124161482418941467843608e-6908211) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.2386175066494467080025339860107035489563e-6908211) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(2.5296247573670413859490835015103830568996e-6908208) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(4.5333739964260293729227596472710597061621e-6908175) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(8.5406990096730105657771829813714924022813e-6908157) }, 
      { SC_(9.0579179687500000000000000000000000000000e+03), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0184045000000000000000000000000000000000e+06), SC_(2.2227669760846787395622146836679811300154e-6901464) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(-8.9532737561743328123541064410329440754568e-158) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-2.3741064956247595878446366426712256138913e+48) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.7710752997052731966105289875398383883762e+15) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(6.7129878839749694137689374661090188200490e+15) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(6.7129878785237833504309559229942647155812e+15) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(6.7129878785237833504309559203559256737227e+15) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(6.7129878730725993623911964579481562913373e+15) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(6.6554261916088860122981586137360283113610e+15) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.0583409526503177228559072165912818101936e-227) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-5.8887757636799062551895836225497013550494e-04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.5098923541539260404419659171676026138751e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.4548365200287702953083194283811824640438e-05) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-1.4532897651483803866953331477041598524141e-05) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-1.4532897651483803866945845282706981998163e-05) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.4517430108315965340640377790887510892542e-05) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.7789266093565168565712865252755200660841e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.0597882556238471703646498744619494538799e-227) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-5.8892439074097659637922808351908466908768e-04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.5097615677114430896738021651097289857435e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.5469048623323051623823363790670244629850e-08) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-1.3700637846436907876468665851777822149175e-12) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-1.3700637846436833013897310729653063010609e-12) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.5466302859642446789846536589338390440265e-08) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.7790848248145191542711259573437670528637e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.0597882557602688425756287893085824293319e-227) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-5.8892439074538927421933221879554179947944e-04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.5097615676991133906158553761472019192689e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.5467678559550640121743298623102627507375e-08) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-3.7434607558656977348558856354885887376451e-27) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(3.7427963796524350399826631020201434647178e-27) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.5467672923439322657069870674158279019342e-08) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.7790848248294346120472690952760957110152e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.0597882557602688425756287893746096452191e-227) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-5.8892439074538927421933221879767750730114e-04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.5097615676991133906158553761412344238678e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.5467678559550640121742635521008836522183e-08) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-3.7427976537659864504598774323219400608445e-27) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(3.7434594817521463243786713051896575282923e-27) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.5467672923439322657070533776263910600626e-08) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.7790848248294346120472690952833146970802e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.0597882558966905147829916164918712505054e-227) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-5.8892439074980195205931765599945449346264e-04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.5097615676867836915578829985291703694509e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.5466308495778226452708604784820723513976e-08) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3700637846458502553159400600617846167209e-12) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3700637846458577415730755841148583799433e-12) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.5469042987236200691247757258690697028449e-08) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.7790848248443500698234297483018026748044e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.0612351516254909212100880649839546734912e-227) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-5.8897119175515383394525494497051285834723e-04) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(-1.5096307783978033185210001855297855681034e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.4517670031024670506329344915140706986762e-05) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.4533137839335554834785953338366687658686e-05) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.4533137839335554834793439658301017579011e-05) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.4548605642010277089762042765521833909723e-05) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.7792430422335457313723006130065233011463e-01) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(5.7607512377405966970404671608925670772492e-294) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(6.6731384784447089355153589829720395309353e-54) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.3459808420485067239483452831266890706057e-16) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.3576273188747203408140431225581925105033e-16) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3576273199771626836261775701873560794755e-16) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3576273199771626836261775707209310928785e-16) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.3576273210796046085276289347419072275576e-16) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.3693695079841214162669588381247776494234e-16) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(4.7828689383651682088828681048111089530895e-4691) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(6.4164311124035274888777131613959426996664e-3416) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.2520282766642703316768427857878534258679e-3335) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.2521922980907114501286758056682549104487e-3335) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.2521922981061751721204943358235329150307e-3335) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.2521922981061751721204943358310172571550e-3335) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.2521922981216388882386286666285179854166e-3335) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.2523563409708013648527281345119619003562e-3335) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(4.8026166942298860527661958741715000591377e-3265) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.1821522722865253511674604148485740892066e-1084) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.7276482924531966385313415191193710826317e-50706) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.0102517312220920388836325862192870305569e-50261) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.5033629144395881554435263366326235560440e-50254) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.5033810690472357965445466525182626644335e-50254) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.5033810690489472871281351480113051863686e-50254) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.5033810690489472871281351480121335368186e-50254) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.5033810690506587770616180819659737048980e-50254) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.5033992238720879507413593873386170985202e-50254) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.1243741833812141390919609383953441478976e-50247) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.6485237324302836610174729590054855067766e-49802) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.2981099604799759927776434369179328229168e-45347) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.0289261797937951215558109621980222422319e-42913) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(7.1596640726341464722546140936351378980427e-81663) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(2.2986544356824093410067009897335636232416e-79017) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.2389701252059112570624212622607119398873e-78722) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(8.8156226440581598940911872769808387480256e-78718) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(8.8156938207991627206345811990860347915386e-78718) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(8.8156938208058727570404215560840675387669e-78718) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(8.8156938208058727570404215560873151532904e-78718) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(8.8156938208125827908974682709009642938619e-78718) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(8.8157649981068950140979581781109640660127e-78718) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.4806571586481415388417145394503360251202e-78713) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(5.0339949960241096400369857058537545751906e-78413) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(7.3662270159319284985274099520329046309841e-75175) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.6934625000000000000000000000000000000000e+04), SC_(3.7494699766451070582992485976224685252945e-73264) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.6934625000000000000000000000000000000000e+04), SC_(1.1595115738662604159505795648839958356898e-6908292) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(6.0079173246574489168065991657624004962434e-6908266) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(1.0442643459511271518397776701046644019251e-6908216) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(9.2346508099305187514012774529803637404904e-6908212) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.1011377906858167808311117060988114513266e-6908211) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.1011379385218234597457540593657172852499e-6908211) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.1011379385218373966166313545724606105149e-6908211) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.1011379385218373966166313545724673558709e-6908211) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.1011379385218513334822147473718903122475e-6908211) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.1011380863578334534678089125755057173219e-6908211) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.3129976706044303755819339096146846039311e-6908211) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.1725120406178319461435901958165885139980e-6908206) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(6.3738144917748372281789304098309042535167e-6908157) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(1.3701705012288194845393909347766777680304e-6908129) }, 
      { SC_(1.3547699218750000000000000000000000000000e+04), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.7532820998308415579889013895793408645727e-6898295) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-5.4687074159399016081448643710665086630848e+65) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.1356665764892170831316456771963993612866e+16) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(6.7129882063439858445211477866196738427178e+15) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(6.7129878785237833504309560010065426746385e+15) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(6.7129878785237833504309558423436742670922e+15) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(6.7129875507037222741218509864879584538616e+15) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.9048027038574218750000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(4.0276689116775682316821768969359574152489e+15) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(5.0472277012806593243960583491938779649014e-03) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.6778255237435156604633900506401859786566e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-1.5463075501673431421529083268249528957040e-05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-1.4532897651483803867174688574830003845749e-05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-1.4532897651483803866724488260260154870643e-05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(-1.3602719289369003528853344017485959922707e-05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.4533019566442817449569702148437500000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(2.5059911922470601055957967478463432608582e+02) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(5.0463759412783240768632560980182900635333e-03) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.6779017592378262014337210296019336452785e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-9.3018702342370105311454773843467334641080e-07) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-1.3700637846439121466015963663590550429587e-12) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(-1.3700637846434619425103435020106844357592e-12) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.3018479521302420408951414388775264644518e-07) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(2.5059558321671214249342651851080364029762e+02) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(5.0463759411980326041984480637403900937017e-03) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.6779017592450126916776661586322999450225e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-9.3018565336065202155796261812118484006426e-07) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-2.2510241548582193460061047426801251673654e-25) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(2.2510167576739844519519221384984630120518e-25) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.3018616527754445912640925313162413503098e-07) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(-3.3155109687541623089560190279014670459804e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(2.5059558321637879614675315940288491868395e+02) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(5.0463759411980326041984480637015295350115e-03) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.6779017592450126916776661586357781602879e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-9.3018565336065202155796195501944116034113e-07) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(-2.2510175238372222331621446606493059384589e-25) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(2.7629251803648148189100116065917360197859e-31), SC_(2.2510233886949815647958822205310054102607e-25) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.3018616527754445912640991623407987749883e-07) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(3.3155100283586816511260126529122372681838e-31), SC_(1.2110846000723540782928466796875000000000e-05), SC_(2.5059558321637879614675315940272358118646e+02) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(5.0463759411177411315347829353443579956849e-03) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.6779017592521991819215321967233906003030e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(-9.3018428329760298783442061685917164037365e-07) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3700637846456288963612099287693259361299e-12) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3700637846460791004524635051805469331980e-12) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.1417195314167294384333217749372124671936e-12), SC_(9.3018753534206471633025666259749633018781e-07) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3700637846447705214814050123095512390137e-12), SC_(1.2110846000723540782928466796875000000000e-05), SC_(2.5059558321604544980008016319945609707918e+02) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(5.0455243099284731838626288123862807305458e-03) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(6.6779779858281079284145946319072669175756e-01) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.3602944383063543548371922277172399986135e-05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.4533137839335554834564592526756973762632e-05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.4533137839335554835014800394567889236764e-05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.5463331807516178227597309884322703930153e-05) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.4533015928464010357856750488281250000000e-05), SC_(1.2110846000723540782928466796875000000000e-05), SC_(2.5059204724977078867864596735169233488740e+02) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.1179037541354844220601706868659147980053e-70) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(8.0316937217597129621969156105908653015582e-17) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.3576272536791404814106919113275433582799e-16) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.3576273199771626836261775544102320642539e-16) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.3576273199771626836261775864980497381643e-16) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.3576273862751627787140790101447156178331e-16) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.9048019409179687500000000000000000000000e+01), SC_(1.2110846000723540782928466796875000000000e-05), SC_(2.2642938726079125970366474072000298318127e-16) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(-2.4768921833277728458163747148094201671184e-4456) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.2423665507370980444567778937491482982041e-3335) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.2521922971762270313935386751704147909044e-3335) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.2521922981061751721204943356022305847094e-3335) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.2521922981061751721204943360523195121534e-3335) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.2521922990361229602979188048795643258727e-3335) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.2620956909109925774883311540689392653803e-3335) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2525126953125000000000000000000000000000e+03), SC_(1.5873352050781250000000000000000000000000e+01), SC_(2.2305821754544348028216801401605282441557e-1374) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.1042984179267884990346895971978473341304e-50683) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.5022896876353616891785711881043471839404e-50254) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.5033810689460226815610517767135849344934e-50254) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.5033810690489472871281351479868119334073e-50254) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.5033810690489472871281351480366267814433e-50254) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.5033810691518718536064846084475994491695e-50254) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.5044732429422333083646410015523153118824e-50254) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(3.0483447121759530296680202172040775719996e-49854) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.3586878906250000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(6.5392460722549680901188796808279663942537e-35873) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(1.4493070788437172999463756198938183618993e-78998) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(8.8114144574318372868016340800396286894009e-78718) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(8.8156938204023485676338124555720839877289e-78718) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(8.8156938208058727570404215559880397717177e-78718) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(2.7629251803648148189100116065917360197859e-31), SC_(8.8156938208058727570404215561833428876554e-78718) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1417195314167294384333217749372124671936e-12), SC_(8.8156938212093967931873530103564240691013e-78718) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.2110846000723540782928466796875000000000e-05), SC_(8.8199752611150900788382191609666277879237e-78718) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.5873352050781250000000000000000000000000e+01), SC_(1.8632725118598602149860918221705128006283e-78445) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.0509143925550271038771708018266879557798e-66808) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(2.0321546875000000000000000000000000000000e+04), SC_(1.1322398437500000000000000000000000000000e+04), SC_(4.4907958463949740809169944871307693311307e-16256) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1322402343750000000000000000000000000000e+04), SC_(8.7823586675416606930931477888101914118149e-6911485) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.0437607421875000000000000000000000000000e+03), SC_(7.6778868725060013852824378433979160662968e-6908514) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.5873352050781250000000000000000000000000e+01), SC_(2.7928427174723416916896287940449471351511e-6908216) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.2110849638702347874641418457031250000000e-05), SC_(1.1011290480822098158519612760943692394801e-6908211) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-1.1417199650975984326350953779183328151703e-12), SC_(1.1011379385209992693422614832996827808576e-6908211) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(-2.7629261207602954767400179815809657975825e-31), SC_(1.1011379385218373966166313545722611590501e-6908211) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(2.7629251803648148189100116065917360197859e-31), SC_(1.1011379385218373966166313545726668072678e-6908211) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1417195314167294384333217749372124671936e-12), SC_(1.1011379385226755235726402902025168245168e-6908211) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.2110846000723540782928466796875000000000e-05), SC_(1.1011468290305751682029337048898692981471e-6908211) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.5873352050781250000000000000000000000000e+01), SC_(4.3416706074892663636733570635410547195705e-6908207) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0437607421875000000000000000000000000000e+03), SC_(1.9252010268589187539067226868889925498096e-6907909) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.1322398437500000000000000000000000000000e+04), SC_(1.8313539959750791504702701948892151418320e-6904928) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.6934625000000000000000000000000000000000e+04), SC_(2.5453595080908262529160408477313938141928e-6903297) }, 
      { SC_(8.1472350000000000000000000000000000000000e+05), SC_(1.2220855000000000000000000000000000000000e+06), SC_(1.0184045000000000000000000000000000000000e+06), SC_(1.1493684282135965301643442134948215004518e-6580243) }
   }};
//#undef SC_

