include(RunCMake)

function(run_TargetMessages case)
  set(RunCMake_TEST_BINARY_DIR ${RunCMake_BINARY_DIR}/TargetMessages-${case}-build)
  set(RunCMake_TEST_NO_CLEAN 1)
  file(REMOVE_RECURSE "${RunCMake_TEST_BINARY_DIR}")
  file(MAKE_DIRECTORY "${RunCMake_TEST_BINARY_DIR}")
  set(RunCMake_TEST_OPTIONS "${ARGN}")
  run_cmake(TargetMessages-${case})
  run_cmake_command(TargetMessages-${case}-build ${CMAKE_COMMAND} --build .)
endfunction()

run_TargetMessages(ON)
run_TargetMessages(OFF)

run_TargetMessages(VAR-ON -DCMAKE_TARGET_MESSAGES=ON)
run_TargetMessages(VAR-OFF -DCMAKE_TARGET_MESSAGES=OFF)

function(run_VerboseBuild)
  run_cmake(VerboseBuild)
  set(RunCMake_TEST_NO_CLEAN 1)
  set(RunCMake_TEST_BINARY_DIR ${RunCMake_BINARY_DIR}/VerboseBuild-build)
  if(RunCMake_GENERATOR STREQUAL "Watcom WMake")
    # wmake does not actually show the verbose output.
    set(RunCMake-stdout-file VerboseBuild-build-watcom-stdout.txt)
  endif()
  run_cmake_command(VerboseBuild-build ${CMAKE_COMMAND} --build . -v --clean-first)
  unset(RunCMake-stdout-file)
  if(MAKE_IS_GNU)
    set(RunCMake-stdout-file VerboseBuild-nowork-gnu-stdout.txt)
  endif()
  run_cmake_command(VerboseBuild-nowork ${CMAKE_COMMAND} --build . --verbose)
endfunction()
run_VerboseBuild()

run_cmake(CustomCommandDepfile-ERROR)
run_cmake(IncludeRegexSubdir)
