dnl vim: set filetype=sysctl.conf.m4 syntax=sysctl.conf.m4:
;-------------------------------------------------------------------------------
;----         M A I N    P A R T    O F   T H E   S E R V I C E             ----
;-------------------------------------------------------------------------------
%begin systemd-unit

# auto generated by wgtpkg-unit for {{:id}} version {{:version}} target {{:#target}} of {{:idaver}}
%nl

%systemd-unit system
IF_PERM(:partner:scope-platform)
%systemd-unit service UNIT_NAME_BASE
ELSE
%systemd-unit service UNIT_NAME_BASE@
ENDIF

[Unit]
Description={{description}}
X-AFM-description={{description}}
X-AFM-name={{name.content}}
X-AFM-shortname={{name.short}}
X-AFM-id=TARGET
X-AFM-version={{:version}}
X-AFM-author={{author.content}}
X-AFM-author-email={{author.email}}
X-AFM-width={{width}}
X-AFM-height={{height}}
{{#icon}}
X-AFM-icon={{:#metadata.install-dir}}/{{:src}}
{{/icon}}
X-AFM--ID=AFID
X-AFM--target-name={{:#target}}
X-AFM--content={{content.src}}
X-AFM--type={{content.type}}
X-AFM--wgtdir={{:#metadata.install-dir}}
X-AFM--workdir=APP_WORK_DIR
X-AFM--visibility=ON_PERM(`:public:hidden', `hidden', `visible')
%nl

IF_PERM(:partner:scope-platform)
X-AFM--scope=platform
After=afm-system-setup.service
ELSE
X-AFM--scope=user
Requires=afm-user-session@%i.target
After=user@%i.service
ENDIF

IF_PERM(:public:display)
BindsTo=weston@display.service
After=weston@display.service
ENDIF

IF_PERM(:public:bluetooth)
Wants=bluetooth.target
After=bluetooth.target
ENDIF

IF_PERM(:public:network)
Wants=network.target
After=network.target
ENDIF

# Adds check to smack
ConditionSecurity=smack
%nl

# Automatic bound to required api
{{#required-binding}}
{{#value=extern}}
Requires=UNIT_NAME_BINDING_SERVICE({{name}})
After=UNIT_NAME_BINDING_SERVICE({{name}})
{{/value=extern}}
{{/required-binding}}

{{#required-api}}
{{#value=auto|ws}}
Requires=UNIT_NAME_API_SERVICE({{name}})
After=UNIT_NAME_API_SERVICE({{name}})
{{/value=auto|ws}}
{{/required-api}}

{{#provided-api}}
{{#value=ws|auto}}
Requires=UNIT_NAME_API_SOCKET({{name}})
After=UNIT_NAME_API_SOCKET({{name}})
{{/value=ws|auto}}
{{/provided-api}}

%nl

[Service]

EnvironmentFile=-@afm_confdir@/unit.env.d/*
EnvironmentFile=-@afm_confdir@/widget.env.d/{{:id}}/*
SmackProcessLabel=SMACKLABEL
SuccessExitStatus=0 SIGKILL
UMask=0077

IF_PERM(:partner:scope-platform)
#DynamicUser=true
User=daemon
Group=nobody
Slice=platform.slice
ELSE
User=%i
Slice=user-%i.slice
WorkingDirectory=-APP_WORK_DIR
ExecStartPre=/bin/mkdir -p APP_WORK_DIR
Environment=DBUS_SESSION_BUS_ADDRESS=unix:path=USER_RUN_DIR/bus
ENDIF
IF_PERM(:system:capability:keep-all)
CapabilityBoundingSet=~
AmbientCapabilities=~
ELSE
CapabilityBoundingSet=
ENDIF

ON_PERM(:platform:no-oom,   OOMScoreAdjust=-500)
ON_PERM(:partner:real-time, IOSchedulingClass=realtime)
ON_PERM(:public:display,    SupplementaryGroups=display)
ON_PERM(:public:audio,      SupplementaryGroups=audio)
ON_NOT_PERM(:public:syscall:clock, SystemCallFilter=~@clock)
%nl

Environment=AFM_ID=TARGET
Environment=AFM_APP_INSTALL_DIR={{:#metadata.install-dir}}
Environment=AFM_WORKDIR=APP_WORK_DIR
Environment=AFM_WSAPI_DIR=API_PATH_WS
Environment=PATH=/usr/sbin:/usr/bin:/sbin:/bin:{{:#metadata.install-dir}}/bin
Environment=LD_LIBRARY_PATH={{:#metadata.install-dir}}/lib
Environment=XDG_DATA_HOME=APP_WORK_DIR
Environment=XDG_CONFIG_HOME=APP_WORK_DIR
Environment=XDG_CACHE_HOME=APP_WORK_DIR
Environment=XDG_RUNTIME_DIR=RUN_DIR
ON_CONTENT(text/html, Environment=WAIT_FOR_HOST_SERVICE="1")

IF_AGL_DEVEL
; Needed to enable debug
EnvironmentFile=-DEBUGGING_DIR/TARGET.env
ENDIF

SyslogIdentifier=afbd-TARGET
StandardInput=null
StandardOutput=journal
StandardError=journal

;-------------------------------------------------------------------------------
;----   text/html  application/vnd.agl.native  application/vnd.agl.service  ----
;-------------------------------------------------------------------------------
{{#content.type=text/html|application/vnd.agl.native|application/vnd.agl.service}}
include(binder.inc)
{{/content.type=text/html|application/vnd.agl.native|application/vnd.agl.service}}

;-------------------------------------------------------------------------------
;----                 application/x-executable                              ----
;-------------------------------------------------------------------------------
{{#content.type=application/x-executable}}
ExecStart={{:#metadata.install-dir}}/{{content.src}}
{{/content.type=application/x-executable}}

;-------------------------------------------------------------------------------
;----                 application/vnd.agl.resource                          ----
;-------------------------------------------------------------------------------
{{#content.type=application/vnd.agl.resource}}
Type=oneshot
ExecStart=/bin/true
{{/content.type=application/vnd.agl.resource}}

IF_PERM(:system:run-by-default)
;-------------------------------------------------------------------------------
; auto start
;-------------------------------------------------------------------------------
[Install]
IF_PERM(:partner:scope-platform)
WantedBy=multi-user.target
%systemd-unit wanted-by multi-user.target
ELSE
WantedBy=afm-user-session@.target
%systemd-unit wanted-by afm-user-session@.target
ENDIF
ENDIF

%end systemd-unit
