# Scientific assertions

>**Note**
>If you need to deal with value minus zero, be very careful because Lua versions
are inconsistent on how they treat the >syntax -0 : it creates either a plus
zero or a minus zero. Multiplying or dividing 0 by -1 also yields inconsistent >
results. The reliable way to create the -0 value is : minusZero = -1 / (1/0).

* **_AFT.assertIsNaN(value)**
    Assert that a given number is a *NaN* (Not a Number), according to the
    definition of IEEE-754_ . If provided, *extra_msg* is a string which will
    be printed along with the failure message.

* **_AFT.assertIsPlusInf(value)**

    Assert that a given number is *plus infinity*, according to the definition of
    IEEE-754_. If provided, *extra_msg* is a string which will be printed along
    with the failure message.

* **_AFT.assertIsMinusInf(value)**

    Assert that a given number is *minus infinity*, according to the definition of
    IEEE-754_. If provided, *extra_msg* is a string which will be printed along
    with the failure message.

* **_AFT.assertIsInf(value)**

    Assert that a given number is *infinity* (either positive or negative),
    according to the definition of IEEE-754_. If provided, *extra_msg* is a string
    which will be printed along with the failure message.

* **_AFT.assertIsPlusZero(value)**

    Assert that a given number is *+0*, according to the definition of IEEE-754_.
    The verification is done by dividing by the provided number and verifying
    that it yields *infinity* . If provided, *extra_msg* is a string which will
    be printed along with the failure message.

    Be careful when dealing with *+0* and *-0*, see note above

* **_AFT.assertIsMinusZero(value)**

    Assert that a given number is *-0*, according to the definition of IEEE-754_.
    The verification is done by dividing by the provided number and verifying that
    it yields *minus infinity* . If provided, *extra_msg* is a string which will
    be printed along with the failure message.

    Be careful when dealing with *+0* and *-0*