#!/bin/bash

#This script updates a fresh Ubuntu installation with all the dependent
# components necessary to use the IoT Client SDK for C.

repo_name_from_uri()
{
    echo "$1" | sed -e 's|/$||' -e 's|:*/*\.git$||' -e 's|.*[/:]||g'
}

scriptdir=$(cd "$(dirname "$0")" && pwd)
deps="curl build-essential pkg-config libcurl4-openssl-dev git cmake libssl-dev uuid-dev valgrind"
repo="https://github.com/Azure/azure-iot-sdk-c.git"
repo_name=$(repo_name_from_uri $repo)

push_dir () { pushd $1 > /dev/null; }
pop_dir () { popd $1 > /dev/null; }

repo_exists ()
{
    push_dir "$scriptdir"
    [ "$(git rev-parse --is-inside-work-tree)" == "true" ] || return 1
    origin=$(git config remote.origin.url) || return 1
    actual_name=$(repo_name_from_uri $origin)
    [ "${repo_name,,}" == "${actual_name,,}" ] || return 1
    pop_dir
}

deps_install ()
{
    sudo apt-get update
    sudo apt-get install -y $deps
}

clone_source ()
{
    git clone $repo
}

deps_install

if repo_exists
then
    echo "Repo $repo_name already cloned"
    push_dir "$(git rev-parse --show-toplevel)"
else
    clone_source || exit 1
    push_dir "$repo_name"
fi

pop_dir