/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_member_access_finalize (ValaCodeNode * obj);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns a copy of the list of generic type arguments.
 *
 * @return type argument list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _type_arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_type_arg_list = _tmp5_;
		_tmp6_ = _type_arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_arg_size = _tmp8_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp9_;
			gpointer _tmp10_;
			ValaDataType* _tmp11_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp9_ = _type_arg_list;
			_tmp10_ = vala_list_get (_tmp9_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp10_;
			_tmp11_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result = NULL;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaMethod* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL);
	method = _tmp2_;
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_CONSTANT (_tmp4_)) {
		result = TRUE;
		_vala_code_node_unref0 (method);
		return result;
	} else {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp8_ = _tmp7_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp8_)) {
			ValaExpression* _tmp9_;
			ValaExpression* _tmp10_;
			_tmp9_ = vala_member_access_get_inner (self);
			_tmp10_ = _tmp9_;
			_tmp6_ = _tmp10_ != NULL;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaSymbol* _tmp14_;
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_expression_get_symbol_reference (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp5_ = VALA_IS_CONSTANT (_tmp14_);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			result = TRUE;
			_vala_code_node_unref0 (method);
			return result;
		} else {
			gboolean _tmp15_ = FALSE;
			ValaMethod* _tmp16_;
			_tmp16_ = method;
			if (_tmp16_ != NULL) {
				gboolean _tmp17_ = FALSE;
				ValaMethod* _tmp18_;
				ValaMemberBinding _tmp19_;
				ValaMemberBinding _tmp20_;
				_tmp18_ = method;
				_tmp19_ = vala_method_get_binding (_tmp18_);
				_tmp20_ = _tmp19_;
				if (_tmp20_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp17_ = TRUE;
				} else {
					gboolean _tmp21_;
					_tmp21_ = self->priv->_prototype_access;
					_tmp17_ = _tmp21_;
				}
				_tmp15_ = _tmp17_;
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				result = TRUE;
				_vala_code_node_unref0 (method);
				return result;
			} else {
				result = FALSE;
				_vala_code_node_unref0 (method);
				return result;
			}
		}
	}
	_vala_code_node_unref0 (method);
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	ValaConstant* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL);
	c = _tmp2_;
	_tmp3_ = c;
	if (_tmp3_ != NULL) {
		gboolean _tmp4_ = FALSE;
		ValaConstant* _tmp5_;
		_tmp5_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp5_)) {
			_tmp4_ = TRUE;
		} else {
			ValaConstant* _tmp6_;
			ValaDataType* _tmp7_;
			ValaDataType* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp6_ = c;
			_tmp7_ = vala_constant_get_type_reference (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_data_type_get_nullable (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp4_ = !_tmp10_;
		}
		result = _tmp4_;
		_vala_code_node_unref0 (c);
		return result;
	} else {
		result = FALSE;
		_vala_code_node_unref0 (c);
		return result;
	}
	_vala_code_node_unref0 (c);
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	gboolean _tmp16_;
	gboolean _tmp537_ = FALSE;
	gboolean _tmp538_ = FALSE;
	gboolean _tmp539_ = FALSE;
	ValaExpression* _tmp540_;
	ValaExpression* _tmp541_;
	ValaSymbol* _tmp567_;
	ValaSymbol* _tmp568_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp591_;
	ValaSymbol* _tmp592_;
	ValaSymbol* _tmp593_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp594_;
	ValaSymbol* _tmp595_;
	ValaSymbol* _tmp1017_;
	ValaSymbol* _tmp1018_;
	ValaVersionAttribute* _tmp1019_;
	ValaVersionAttribute* _tmp1020_;
	ValaSourceReference* _tmp1021_;
	ValaSourceReference* _tmp1022_;
	gboolean _tmp1023_ = FALSE;
	ValaSymbolAccessibility _tmp1024_;
	gboolean _tmp1083_ = FALSE;
	gboolean _tmp1114_ = FALSE;
	gboolean _tmp1115_ = FALSE;
	ValaDataType* _tmp1370_;
	ValaDataType* _tmp1371_;
	gboolean _tmp1374_;
	gboolean _tmp1375_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _type_arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_type_arg_list = _tmp9_;
		_tmp10_ = _type_arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_type_arg_size = _tmp12_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp13_;
			gpointer _tmp14_;
			ValaDataType* _tmp15_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp13_ = _type_arg_list;
			_tmp14_ = vala_list_get (_tmp13_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp14_;
			_tmp15_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp15_, context);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp16_ = self->priv->_qualified;
	if (_tmp16_) {
		ValaNamespace* _tmp17_;
		ValaNamespace* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaScope* _tmp21_;
		ValaScope* _tmp22_;
		const gchar* _tmp23_;
		ValaSymbol* _tmp24_;
		ValaSymbol* _tmp25_;
		_tmp17_ = vala_code_context_get_root (context);
		_tmp18_ = _tmp17_;
		_tmp19_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp18_);
		_vala_code_node_unref0 (base_symbol);
		base_symbol = _tmp19_;
		_tmp20_ = base_symbol;
		_tmp21_ = vala_symbol_get_scope (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = self->priv->_member_name;
		_tmp24_ = vala_scope_lookup (_tmp22_, _tmp23_);
		_tmp25_ = _tmp24_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp25_);
		_vala_code_node_unref0 (_tmp25_);
	} else {
		ValaExpression* _tmp26_;
		ValaExpression* _tmp27_;
		_tmp26_ = vala_member_access_get_inner (self);
		_tmp27_ = _tmp26_;
		if (_tmp27_ == NULL) {
			const gchar* _tmp28_;
			ValaSemanticAnalyzer* _tmp33_;
			ValaSemanticAnalyzer* _tmp34_;
			ValaSymbol* _tmp35_;
			ValaSymbol* _tmp36_;
			ValaSymbol* _tmp37_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp38_;
			ValaSemanticAnalyzer* _tmp39_;
			ValaSymbol* _tmp40_;
			ValaSymbol* _tmp41_;
			ValaSymbol* _tmp42_;
			gboolean _tmp152_ = FALSE;
			ValaSymbol* _tmp153_;
			ValaSymbol* _tmp154_;
			_tmp28_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp28_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp29_;
				ValaSemanticAnalyzer* _tmp30_;
				_tmp29_ = vala_code_context_get_analyzer (context);
				_tmp30_ = _tmp29_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp30_)) {
					ValaSourceReference* _tmp31_;
					ValaSourceReference* _tmp32_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp32_ = _tmp31_;
					vala_report_error (_tmp32_, "This access invalid outside of instance methods");
					result = FALSE;
					_vala_code_node_unref0 (this_parameter);
					_vala_code_node_unref0 (base_symbol);
					return result;
				}
			}
			_tmp33_ = vala_code_context_get_analyzer (context);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_semantic_analyzer_get_current_symbol (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = _vala_code_node_ref0 (_tmp36_);
			_vala_code_node_unref0 (base_symbol);
			base_symbol = _tmp37_;
			method_found = FALSE;
			_tmp38_ = vala_code_context_get_analyzer (context);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_semantic_analyzer_get_current_symbol (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = _vala_code_node_ref0 (_tmp41_);
			sym = _tmp42_;
			while (TRUE) {
				gboolean _tmp43_ = FALSE;
				ValaSymbol* _tmp44_;
				ValaSymbol* _tmp100_;
				const gchar* _tmp101_;
				ValaSymbol* _tmp102_;
				ValaSymbol* _tmp103_;
				gboolean _tmp104_ = FALSE;
				gboolean _tmp105_ = FALSE;
				ValaSymbol* _tmp106_;
				ValaSymbol* _tmp107_;
				ValaSymbol* _tmp145_;
				ValaSymbol* _tmp146_;
				ValaSymbol* _tmp148_;
				ValaSymbol* _tmp149_;
				ValaSymbol* _tmp150_;
				ValaSymbol* _tmp151_;
				_tmp44_ = sym;
				if (_tmp44_ != NULL) {
					ValaSymbol* _tmp45_;
					ValaSymbol* _tmp46_;
					_tmp45_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp46_ = _tmp45_;
					_tmp43_ = _tmp46_ == NULL;
				} else {
					_tmp43_ = FALSE;
				}
				if (!_tmp43_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp47_;
					_tmp47_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp47_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp48_;
						ValaCreationMethod* _tmp49_;
						ValaCreationMethod* _tmp50_;
						ValaParameter* _tmp51_;
						ValaParameter* _tmp52_;
						ValaParameter* _tmp53_;
						_tmp48_ = sym;
						_tmp49_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
						cm = _tmp49_;
						_tmp50_ = cm;
						_tmp51_ = vala_method_get_this_parameter ((ValaMethod*) _tmp50_);
						_tmp52_ = _tmp51_;
						_tmp53_ = _vala_code_node_ref0 (_tmp52_);
						_vala_code_node_unref0 (this_parameter);
						this_parameter = _tmp53_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
						_vala_code_node_unref0 (cm);
					} else {
						ValaSymbol* _tmp54_;
						_tmp54_ = sym;
						if (VALA_IS_PROPERTY (_tmp54_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp55_;
							ValaProperty* _tmp56_;
							ValaProperty* _tmp57_;
							ValaParameter* _tmp58_;
							ValaParameter* _tmp59_;
							ValaParameter* _tmp60_;
							ValaProperty* _tmp61_;
							ValaMemberBinding _tmp62_;
							ValaMemberBinding _tmp63_;
							ValaProperty* _tmp64_;
							ValaMemberBinding _tmp65_;
							ValaMemberBinding _tmp66_;
							_tmp55_ = sym;
							_tmp56_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp56_;
							_tmp57_ = prop;
							_tmp58_ = vala_property_get_this_parameter (_tmp57_);
							_tmp59_ = _tmp58_;
							_tmp60_ = _vala_code_node_ref0 (_tmp59_);
							_vala_code_node_unref0 (this_parameter);
							this_parameter = _tmp60_;
							_tmp61_ = prop;
							_tmp62_ = vala_property_get_binding (_tmp61_);
							_tmp63_ = _tmp62_;
							may_access_instance_members = _tmp63_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp64_ = prop;
							_tmp65_ = vala_property_get_binding (_tmp64_);
							_tmp66_ = _tmp65_;
							may_access_klass_members = _tmp66_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
							_vala_code_node_unref0 (prop);
						} else {
							ValaSymbol* _tmp67_;
							_tmp67_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp67_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp68_;
								ValaConstructor* _tmp69_;
								ValaConstructor* _tmp70_;
								ValaParameter* _tmp71_;
								ValaParameter* _tmp72_;
								ValaParameter* _tmp73_;
								ValaConstructor* _tmp74_;
								ValaMemberBinding _tmp75_;
								ValaMemberBinding _tmp76_;
								_tmp68_ = sym;
								_tmp69_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, VALA_TYPE_CONSTRUCTOR, ValaConstructor));
								c = _tmp69_;
								_tmp70_ = c;
								_tmp71_ = vala_constructor_get_this_parameter (_tmp70_);
								_tmp72_ = _tmp71_;
								_tmp73_ = _vala_code_node_ref0 (_tmp72_);
								_vala_code_node_unref0 (this_parameter);
								this_parameter = _tmp73_;
								_tmp74_ = c;
								_tmp75_ = vala_constructor_get_binding (_tmp74_);
								_tmp76_ = _tmp75_;
								may_access_instance_members = _tmp76_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
								_vala_code_node_unref0 (c);
							} else {
								ValaSymbol* _tmp77_;
								_tmp77_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp77_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp78_;
									ValaDestructor* _tmp79_;
									ValaDestructor* _tmp80_;
									ValaParameter* _tmp81_;
									ValaParameter* _tmp82_;
									ValaParameter* _tmp83_;
									ValaDestructor* _tmp84_;
									ValaMemberBinding _tmp85_;
									ValaMemberBinding _tmp86_;
									_tmp78_ = sym;
									_tmp79_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, VALA_TYPE_DESTRUCTOR, ValaDestructor));
									d = _tmp79_;
									_tmp80_ = d;
									_tmp81_ = vala_destructor_get_this_parameter (_tmp80_);
									_tmp82_ = _tmp81_;
									_tmp83_ = _vala_code_node_ref0 (_tmp82_);
									_vala_code_node_unref0 (this_parameter);
									this_parameter = _tmp83_;
									_tmp84_ = d;
									_tmp85_ = vala_destructor_get_binding (_tmp84_);
									_tmp86_ = _tmp85_;
									may_access_instance_members = _tmp86_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
									_vala_code_node_unref0 (d);
								} else {
									ValaSymbol* _tmp87_;
									_tmp87_ = sym;
									if (VALA_IS_METHOD (_tmp87_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp88_;
										ValaMethod* _tmp89_;
										ValaMethod* _tmp90_;
										ValaParameter* _tmp91_;
										ValaParameter* _tmp92_;
										ValaParameter* _tmp93_;
										ValaMethod* _tmp94_;
										ValaMemberBinding _tmp95_;
										ValaMemberBinding _tmp96_;
										ValaMethod* _tmp97_;
										ValaMemberBinding _tmp98_;
										ValaMemberBinding _tmp99_;
										_tmp88_ = sym;
										_tmp89_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, VALA_TYPE_METHOD, ValaMethod));
										m = _tmp89_;
										_tmp90_ = m;
										_tmp91_ = vala_method_get_this_parameter (_tmp90_);
										_tmp92_ = _tmp91_;
										_tmp93_ = _vala_code_node_ref0 (_tmp92_);
										_vala_code_node_unref0 (this_parameter);
										this_parameter = _tmp93_;
										_tmp94_ = m;
										_tmp95_ = vala_method_get_binding (_tmp94_);
										_tmp96_ = _tmp95_;
										may_access_instance_members = _tmp96_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp97_ = m;
										_tmp98_ = vala_method_get_binding (_tmp97_);
										_tmp99_ = _tmp98_;
										may_access_klass_members = _tmp99_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
										_vala_code_node_unref0 (m);
									}
								}
							}
						}
					}
				}
				_tmp100_ = sym;
				_tmp101_ = self->priv->_member_name;
				_tmp102_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp100_, _tmp101_);
				_tmp103_ = _tmp102_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp103_);
				_vala_code_node_unref0 (_tmp103_);
				_tmp106_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp107_ = _tmp106_;
				if (_tmp107_ == NULL) {
					ValaSymbol* _tmp108_;
					_tmp108_ = sym;
					_tmp105_ = VALA_IS_TYPESYMBOL (_tmp108_);
				} else {
					_tmp105_ = FALSE;
				}
				if (_tmp105_) {
					_tmp104_ = may_access_instance_members;
				} else {
					_tmp104_ = FALSE;
				}
				if (_tmp104_) {
					ValaParameter* _tmp109_;
					ValaDataType* _tmp110_;
					ValaDataType* _tmp111_;
					const gchar* _tmp112_;
					ValaSymbol* _tmp113_;
					ValaSymbol* _tmp114_;
					gboolean _tmp115_ = FALSE;
					ValaSymbol* _tmp116_;
					ValaSymbol* _tmp117_;
					_tmp109_ = this_parameter;
					_tmp110_ = vala_variable_get_variable_type ((ValaVariable*) _tmp109_);
					_tmp111_ = _tmp110_;
					_tmp112_ = self->priv->_member_name;
					_tmp113_ = vala_data_type_get_member (_tmp111_, _tmp112_);
					_tmp114_ = _tmp113_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp114_);
					_vala_code_node_unref0 (_tmp114_);
					_tmp116_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp117_ = _tmp116_;
					if (_tmp117_ != NULL) {
						ValaSymbol* _tmp118_;
						ValaSymbol* _tmp119_;
						_tmp118_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp119_ = _tmp118_;
						_tmp115_ = vala_member_access_is_instance_symbol (_tmp119_);
					} else {
						_tmp115_ = FALSE;
					}
					if (_tmp115_) {
						ValaSourceReference* _tmp120_;
						ValaSourceReference* _tmp121_;
						ValaMemberAccess* _tmp122_;
						ValaMemberAccess* _tmp123_;
						ValaExpression* _tmp124_;
						ValaExpression* _tmp125_;
						ValaParameter* _tmp126_;
						ValaDataType* _tmp127_;
						ValaDataType* _tmp128_;
						ValaDataType* _tmp129_;
						ValaDataType* _tmp130_;
						ValaExpression* _tmp131_;
						ValaExpression* _tmp132_;
						ValaDataType* _tmp133_;
						ValaDataType* _tmp134_;
						ValaExpression* _tmp135_;
						ValaExpression* _tmp136_;
						ValaParameter* _tmp137_;
						ValaExpression* _tmp138_;
						ValaExpression* _tmp139_;
						ValaDataType* _tmp140_;
						ValaDataType* _tmp141_;
						const gchar* _tmp142_;
						ValaSymbol* _tmp143_;
						ValaSymbol* _tmp144_;
						_tmp120_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp121_ = _tmp120_;
						_tmp122_ = vala_member_access_new (NULL, "this", _tmp121_);
						_tmp123_ = _tmp122_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp123_);
						_vala_code_node_unref0 (_tmp123_);
						_tmp124_ = vala_member_access_get_inner (self);
						_tmp125_ = _tmp124_;
						_tmp126_ = this_parameter;
						_tmp127_ = vala_variable_get_variable_type ((ValaVariable*) _tmp126_);
						_tmp128_ = _tmp127_;
						_tmp129_ = vala_data_type_copy (_tmp128_);
						_tmp130_ = _tmp129_;
						vala_expression_set_value_type (_tmp125_, _tmp130_);
						_vala_code_node_unref0 (_tmp130_);
						_tmp131_ = vala_member_access_get_inner (self);
						_tmp132_ = _tmp131_;
						_tmp133_ = vala_expression_get_value_type (_tmp132_);
						_tmp134_ = _tmp133_;
						vala_data_type_set_value_owned (_tmp134_, FALSE);
						_tmp135_ = vala_member_access_get_inner (self);
						_tmp136_ = _tmp135_;
						_tmp137_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp136_, (ValaSymbol*) _tmp137_);
						_tmp138_ = vala_member_access_get_inner (self);
						_tmp139_ = _tmp138_;
						_tmp140_ = vala_expression_get_value_type (_tmp139_);
						_tmp141_ = _tmp140_;
						_tmp142_ = self->priv->_member_name;
						_tmp143_ = vala_data_type_get_member (_tmp141_, _tmp142_);
						_tmp144_ = _tmp143_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp144_);
						_vala_code_node_unref0 (_tmp144_);
					}
				}
				_tmp145_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp146_ = _tmp145_;
				if (_tmp146_ == NULL) {
					ValaSymbol* _tmp147_;
					_tmp147_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp147_)) {
						_vala_code_node_unref0 (this_parameter);
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp148_ = sym;
				_tmp149_ = vala_symbol_get_parent_symbol (_tmp148_);
				_tmp150_ = _tmp149_;
				_tmp151_ = _vala_code_node_ref0 (_tmp150_);
				_vala_code_node_unref0 (sym);
				sym = _tmp151_;
			}
			_tmp153_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp154_ = _tmp153_;
			if (_tmp154_ == NULL) {
				ValaSourceReference* _tmp155_;
				ValaSourceReference* _tmp156_;
				_tmp155_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp156_ = _tmp155_;
				_tmp152_ = _tmp156_ != NULL;
			} else {
				_tmp152_ = FALSE;
			}
			if (_tmp152_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp157_;
					ValaSourceReference* _tmp158_;
					ValaList* _tmp159_;
					ValaList* _tmp160_;
					ValaList* _tmp161_;
					gint _ns_size = 0;
					ValaList* _tmp162_;
					gint _tmp163_;
					gint _tmp164_;
					gint _ns_index = 0;
					_tmp157_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp158_ = _tmp157_;
					_tmp159_ = vala_source_reference_get_using_directives (_tmp158_);
					_tmp160_ = _tmp159_;
					_tmp161_ = _vala_iterable_ref0 (_tmp160_);
					_ns_list = _tmp161_;
					_tmp162_ = _ns_list;
					_tmp163_ = vala_collection_get_size ((ValaCollection*) _tmp162_);
					_tmp164_ = _tmp163_;
					_ns_size = _tmp164_;
					_ns_index = -1;
					while (TRUE) {
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp165_;
						gpointer _tmp166_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp167_;
						ValaSymbol* _tmp168_;
						ValaSymbol* _tmp169_;
						ValaScope* _tmp170_;
						ValaScope* _tmp171_;
						const gchar* _tmp172_;
						ValaSymbol* _tmp173_;
						ValaSymbol* _tmp174_;
						_ns_index = _ns_index + 1;
						if (!(_ns_index < _ns_size)) {
							break;
						}
						_tmp165_ = _ns_list;
						_tmp166_ = vala_list_get (_tmp165_, _ns_index);
						ns = (ValaUsingDirective*) _tmp166_;
						_tmp167_ = ns;
						_tmp168_ = vala_using_directive_get_namespace_symbol (_tmp167_);
						_tmp169_ = _tmp168_;
						_tmp170_ = vala_symbol_get_scope (_tmp169_);
						_tmp171_ = _tmp170_;
						_tmp172_ = self->priv->_member_name;
						_tmp173_ = vala_scope_lookup (_tmp171_, _tmp172_);
						local_sym = _tmp173_;
						_tmp174_ = local_sym;
						if (_tmp174_ != NULL) {
							gboolean _tmp175_ = FALSE;
							ValaSymbol* _tmp176_;
							ValaSymbol* _tmp177_;
							ValaSymbol* _tmp193_;
							_tmp176_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp177_ = _tmp176_;
							if (_tmp177_ != NULL) {
								ValaSymbol* _tmp178_;
								ValaSymbol* _tmp179_;
								ValaSymbol* _tmp180_;
								_tmp178_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp179_ = _tmp178_;
								_tmp180_ = local_sym;
								_tmp175_ = _tmp179_ != _tmp180_;
							} else {
								_tmp175_ = FALSE;
							}
							if (_tmp175_) {
								ValaSourceReference* _tmp181_;
								ValaSourceReference* _tmp182_;
								const gchar* _tmp183_;
								ValaSymbol* _tmp184_;
								ValaSymbol* _tmp185_;
								gchar* _tmp186_;
								gchar* _tmp187_;
								ValaSymbol* _tmp188_;
								gchar* _tmp189_;
								gchar* _tmp190_;
								gchar* _tmp191_;
								gchar* _tmp192_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp181_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp182_ = _tmp181_;
								_tmp183_ = self->priv->_member_name;
								_tmp184_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp185_ = _tmp184_;
								_tmp186_ = vala_symbol_get_full_name (_tmp185_);
								_tmp187_ = _tmp186_;
								_tmp188_ = local_sym;
								_tmp189_ = vala_symbol_get_full_name (_tmp188_);
								_tmp190_ = _tmp189_;
								_tmp191_ = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", _tmp183_, _tmp187_, _tmp190_);
								_tmp192_ = _tmp191_;
								vala_report_error (_tmp182_, _tmp192_);
								_g_free0 (_tmp192_);
								_g_free0 (_tmp190_);
								_g_free0 (_tmp187_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (_ns_list);
								_vala_code_node_unref0 (sym);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp193_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp193_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
					_vala_iterable_unref0 (_ns_list);
				}
			}
			_vala_code_node_unref0 (sym);
		} else {
			ValaExpression* _tmp194_;
			ValaExpression* _tmp195_;
			gboolean _tmp196_;
			gboolean _tmp197_;
			ValaExpression* _tmp198_;
			ValaExpression* _tmp199_;
			ValaDataType* _tmp200_;
			ValaDataType* _tmp201_;
			ValaExpression* _tmp220_;
			ValaExpression* _tmp221_;
			gboolean _tmp237_ = FALSE;
			ValaExpression* _tmp238_;
			ValaExpression* _tmp239_;
			gboolean _tmp261_ = FALSE;
			ValaSymbol* _tmp262_;
			ValaSymbol* _tmp263_;
			gboolean _tmp298_ = FALSE;
			gboolean _tmp299_ = FALSE;
			ValaSymbol* _tmp300_;
			ValaSymbol* _tmp301_;
			gboolean _tmp519_ = FALSE;
			ValaSymbol* _tmp520_;
			ValaSymbol* _tmp521_;
			_tmp194_ = vala_member_access_get_inner (self);
			_tmp195_ = _tmp194_;
			_tmp196_ = vala_code_node_get_error ((ValaCodeNode*) _tmp195_);
			_tmp197_ = _tmp196_;
			if (_tmp197_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (this_parameter);
				_vala_code_node_unref0 (base_symbol);
				return result;
			}
			_tmp198_ = vala_member_access_get_inner (self);
			_tmp199_ = _tmp198_;
			_tmp200_ = vala_expression_get_value_type (_tmp199_);
			_tmp201_ = _tmp200_;
			if (VALA_IS_POINTER_TYPE (_tmp201_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp202_;
				ValaExpression* _tmp203_;
				ValaDataType* _tmp204_;
				ValaDataType* _tmp205_;
				ValaPointerType* _tmp206_;
				gboolean _tmp207_ = FALSE;
				ValaPointerType* _tmp208_;
				_tmp202_ = vala_member_access_get_inner (self);
				_tmp203_ = _tmp202_;
				_tmp204_ = vala_expression_get_value_type (_tmp203_);
				_tmp205_ = _tmp204_;
				_tmp206_ = _vala_code_node_ref0 (VALA_IS_POINTER_TYPE (_tmp205_) ? ((ValaPointerType*) _tmp205_) : NULL);
				pointer_type = _tmp206_;
				_tmp208_ = pointer_type;
				if (_tmp208_ != NULL) {
					ValaPointerType* _tmp209_;
					ValaDataType* _tmp210_;
					ValaDataType* _tmp211_;
					_tmp209_ = pointer_type;
					_tmp210_ = vala_pointer_type_get_base_type (_tmp209_);
					_tmp211_ = _tmp210_;
					_tmp207_ = VALA_IS_VALUE_TYPE (_tmp211_);
				} else {
					_tmp207_ = FALSE;
				}
				if (_tmp207_) {
					ValaExpression* _tmp212_;
					ValaExpression* _tmp213_;
					ValaSourceReference* _tmp214_;
					ValaSourceReference* _tmp215_;
					ValaPointerIndirection* _tmp216_;
					ValaPointerIndirection* _tmp217_;
					ValaExpression* _tmp218_;
					ValaExpression* _tmp219_;
					_tmp212_ = vala_member_access_get_inner (self);
					_tmp213_ = _tmp212_;
					_tmp214_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp215_ = _tmp214_;
					_tmp216_ = vala_pointer_indirection_new (_tmp213_, _tmp215_);
					_tmp217_ = _tmp216_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp217_);
					_vala_code_node_unref0 (_tmp217_);
					_tmp218_ = vala_member_access_get_inner (self);
					_tmp219_ = _tmp218_;
					vala_code_node_check ((ValaCodeNode*) _tmp219_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
				_vala_code_node_unref0 (pointer_type);
			}
			_tmp220_ = vala_member_access_get_inner (self);
			_tmp221_ = _tmp220_;
			if (VALA_IS_MEMBER_ACCESS (_tmp221_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp222_;
				ValaExpression* _tmp223_;
				ValaMemberAccess* _tmp224_;
				ValaMemberAccess* _tmp225_;
				gboolean _tmp226_;
				_tmp222_ = vala_member_access_get_inner (self);
				_tmp223_ = _tmp222_;
				_tmp224_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp223_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				ma = _tmp224_;
				_tmp225_ = ma;
				_tmp226_ = _tmp225_->priv->_prototype_access;
				if (_tmp226_) {
					ValaSourceReference* _tmp227_;
					ValaSourceReference* _tmp228_;
					ValaExpression* _tmp229_;
					ValaExpression* _tmp230_;
					ValaSymbol* _tmp231_;
					ValaSymbol* _tmp232_;
					gchar* _tmp233_;
					gchar* _tmp234_;
					gchar* _tmp235_;
					gchar* _tmp236_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp227_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp228_ = _tmp227_;
					_tmp229_ = vala_member_access_get_inner (self);
					_tmp230_ = _tmp229_;
					_tmp231_ = vala_expression_get_symbol_reference (_tmp230_);
					_tmp232_ = _tmp231_;
					_tmp233_ = vala_symbol_get_full_name (_tmp232_);
					_tmp234_ = _tmp233_;
					_tmp235_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp234_);
					_tmp236_ = _tmp235_;
					vala_report_error (_tmp228_, _tmp236_);
					_g_free0 (_tmp236_);
					_g_free0 (_tmp234_);
					result = FALSE;
					_vala_code_node_unref0 (ma);
					_vala_code_node_unref0 (this_parameter);
					_vala_code_node_unref0 (base_symbol);
					return result;
				}
				_vala_code_node_unref0 (ma);
			}
			_tmp238_ = vala_member_access_get_inner (self);
			_tmp239_ = _tmp238_;
			if (VALA_IS_MEMBER_ACCESS (_tmp239_)) {
				_tmp237_ = TRUE;
			} else {
				ValaExpression* _tmp240_;
				ValaExpression* _tmp241_;
				_tmp240_ = vala_member_access_get_inner (self);
				_tmp241_ = _tmp240_;
				_tmp237_ = VALA_IS_BASE_ACCESS (_tmp241_);
			}
			if (_tmp237_) {
				ValaExpression* _tmp242_;
				ValaExpression* _tmp243_;
				ValaSymbol* _tmp244_;
				ValaSymbol* _tmp245_;
				ValaSymbol* _tmp246_;
				gboolean _tmp247_ = FALSE;
				ValaSymbol* _tmp248_;
				ValaSymbol* _tmp249_;
				_tmp242_ = vala_member_access_get_inner (self);
				_tmp243_ = _tmp242_;
				_tmp244_ = vala_expression_get_symbol_reference (_tmp243_);
				_tmp245_ = _tmp244_;
				_tmp246_ = _vala_code_node_ref0 (_tmp245_);
				_vala_code_node_unref0 (base_symbol);
				base_symbol = _tmp246_;
				_tmp248_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp249_ = _tmp248_;
				if (_tmp249_ == NULL) {
					gboolean _tmp250_ = FALSE;
					ValaSymbol* _tmp251_;
					_tmp251_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp251_)) {
						_tmp250_ = TRUE;
					} else {
						ValaSymbol* _tmp252_;
						_tmp252_ = base_symbol;
						_tmp250_ = VALA_IS_TYPESYMBOL (_tmp252_);
					}
					_tmp247_ = _tmp250_;
				} else {
					_tmp247_ = FALSE;
				}
				if (_tmp247_) {
					ValaSymbol* _tmp253_;
					ValaScope* _tmp254_;
					ValaScope* _tmp255_;
					const gchar* _tmp256_;
					ValaSymbol* _tmp257_;
					ValaSymbol* _tmp258_;
					ValaExpression* _tmp259_;
					ValaExpression* _tmp260_;
					_tmp253_ = base_symbol;
					_tmp254_ = vala_symbol_get_scope (_tmp253_);
					_tmp255_ = _tmp254_;
					_tmp256_ = self->priv->_member_name;
					_tmp257_ = vala_scope_lookup (_tmp255_, _tmp256_);
					_tmp258_ = _tmp257_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp258_);
					_vala_code_node_unref0 (_tmp258_);
					_tmp259_ = vala_member_access_get_inner (self);
					_tmp260_ = _tmp259_;
					if (VALA_IS_BASE_ACCESS (_tmp260_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp262_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp263_ = _tmp262_;
			if (_tmp263_ == NULL) {
				ValaExpression* _tmp264_;
				ValaExpression* _tmp265_;
				ValaDataType* _tmp266_;
				ValaDataType* _tmp267_;
				_tmp264_ = vala_member_access_get_inner (self);
				_tmp265_ = _tmp264_;
				_tmp266_ = vala_expression_get_value_type (_tmp265_);
				_tmp267_ = _tmp266_;
				_tmp261_ = _tmp267_ != NULL;
			} else {
				_tmp261_ = FALSE;
			}
			if (_tmp261_) {
				gboolean _tmp268_;
				ValaSymbol* _tmp296_;
				ValaSymbol* _tmp297_;
				_tmp268_ = self->priv->_pointer_member_access;
				if (_tmp268_) {
					ValaExpression* _tmp269_;
					ValaExpression* _tmp270_;
					ValaDataType* _tmp271_;
					ValaDataType* _tmp272_;
					const gchar* _tmp273_;
					ValaSymbol* _tmp274_;
					ValaSymbol* _tmp275_;
					_tmp269_ = vala_member_access_get_inner (self);
					_tmp270_ = _tmp269_;
					_tmp271_ = vala_expression_get_value_type (_tmp270_);
					_tmp272_ = _tmp271_;
					_tmp273_ = self->priv->_member_name;
					_tmp274_ = vala_data_type_get_pointer_member (_tmp272_, _tmp273_);
					_tmp275_ = _tmp274_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp275_);
					_vala_code_node_unref0 (_tmp275_);
				} else {
					ValaExpression* _tmp276_;
					ValaExpression* _tmp277_;
					ValaDataType* _tmp278_;
					ValaDataType* _tmp279_;
					ValaTypeSymbol* _tmp280_;
					ValaTypeSymbol* _tmp281_;
					ValaExpression* _tmp289_;
					ValaExpression* _tmp290_;
					ValaDataType* _tmp291_;
					ValaDataType* _tmp292_;
					const gchar* _tmp293_;
					ValaSymbol* _tmp294_;
					ValaSymbol* _tmp295_;
					_tmp276_ = vala_member_access_get_inner (self);
					_tmp277_ = _tmp276_;
					_tmp278_ = vala_expression_get_value_type (_tmp277_);
					_tmp279_ = _tmp278_;
					_tmp280_ = vala_data_type_get_data_type (_tmp279_);
					_tmp281_ = _tmp280_;
					if (_tmp281_ != NULL) {
						ValaExpression* _tmp282_;
						ValaExpression* _tmp283_;
						ValaDataType* _tmp284_;
						ValaDataType* _tmp285_;
						ValaTypeSymbol* _tmp286_;
						ValaTypeSymbol* _tmp287_;
						ValaSymbol* _tmp288_;
						_tmp282_ = vala_member_access_get_inner (self);
						_tmp283_ = _tmp282_;
						_tmp284_ = vala_expression_get_value_type (_tmp283_);
						_tmp285_ = _tmp284_;
						_tmp286_ = vala_data_type_get_data_type (_tmp285_);
						_tmp287_ = _tmp286_;
						_tmp288_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp287_);
						_vala_code_node_unref0 (base_symbol);
						base_symbol = _tmp288_;
					}
					_tmp289_ = vala_member_access_get_inner (self);
					_tmp290_ = _tmp289_;
					_tmp291_ = vala_expression_get_value_type (_tmp290_);
					_tmp292_ = _tmp291_;
					_tmp293_ = self->priv->_member_name;
					_tmp294_ = vala_data_type_get_member (_tmp292_, _tmp293_);
					_tmp295_ = _tmp294_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp295_);
					_vala_code_node_unref0 (_tmp295_);
				}
				_tmp296_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp297_ = _tmp296_;
				if (_tmp297_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp300_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp301_ = _tmp300_;
			if (_tmp301_ == NULL) {
				ValaExpression* _tmp302_;
				ValaExpression* _tmp303_;
				ValaDataType* _tmp304_;
				ValaDataType* _tmp305_;
				_tmp302_ = vala_member_access_get_inner (self);
				_tmp303_ = _tmp302_;
				_tmp304_ = vala_expression_get_value_type (_tmp303_);
				_tmp305_ = _tmp304_;
				_tmp299_ = _tmp305_ != NULL;
			} else {
				_tmp299_ = FALSE;
			}
			if (_tmp299_) {
				ValaExpression* _tmp306_;
				ValaExpression* _tmp307_;
				ValaDataType* _tmp308_;
				ValaDataType* _tmp309_;
				gboolean _tmp310_;
				gboolean _tmp311_;
				_tmp306_ = vala_member_access_get_inner (self);
				_tmp307_ = _tmp306_;
				_tmp308_ = vala_expression_get_value_type (_tmp307_);
				_tmp309_ = _tmp308_;
				_tmp310_ = vala_data_type_get_is_dynamic (_tmp309_);
				_tmp311_ = _tmp310_;
				_tmp298_ = _tmp311_;
			} else {
				_tmp298_ = FALSE;
			}
			if (_tmp298_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp312_;
				ValaExpression* _tmp313_;
				ValaDataType* _tmp314_;
				ValaDataType* _tmp315_;
				ValaObjectType* _tmp316_;
				ValaCodeNode* _tmp317_;
				ValaCodeNode* _tmp318_;
				ValaSymbol* _tmp467_;
				ValaSymbol* _tmp468_;
				ValaSymbol* _tmp517_;
				ValaSymbol* _tmp518_;
				_tmp312_ = vala_member_access_get_inner (self);
				_tmp313_ = _tmp312_;
				_tmp314_ = vala_expression_get_value_type (_tmp313_);
				_tmp315_ = _tmp314_;
				_tmp316_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp315_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp316_;
				_tmp317_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp318_ = _tmp317_;
				if (VALA_IS_METHOD_CALL (_tmp318_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp319_;
					ValaCodeNode* _tmp320_;
					ValaMethodCall* _tmp321_;
					ValaMethodCall* _tmp322_;
					ValaExpression* _tmp323_;
					ValaExpression* _tmp324_;
					_tmp319_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp320_ = _tmp319_;
					_tmp321_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp320_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
					invoc = _tmp321_;
					_tmp322_ = invoc;
					_tmp323_ = vala_method_call_get_call (_tmp322_);
					_tmp324_ = _tmp323_;
					if (_tmp324_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp325_;
						ValaDataType* _tmp326_;
						ValaDataType* _tmp327_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp342_;
						ValaExpression* _tmp343_;
						ValaDataType* _tmp344_;
						ValaDataType* _tmp345_;
						const gchar* _tmp346_;
						ValaDataType* _tmp347_;
						ValaSourceReference* _tmp348_;
						ValaSourceReference* _tmp349_;
						ValaDynamicMethod* _tmp350_;
						ValaDynamicMethod* _tmp351_;
						ValaMethodCall* _tmp352_;
						ValaErrorType* err = NULL;
						ValaErrorType* _tmp353_;
						ValaErrorType* _tmp354_;
						ValaDynamicMethod* _tmp355_;
						ValaErrorType* _tmp356_;
						ValaDynamicMethod* _tmp357_;
						ValaDynamicMethod* _tmp358_;
						ValaParameter* _tmp359_;
						ValaParameter* _tmp360_;
						ValaDynamicMethod* _tmp361_;
						ValaObjectType* _tmp362_;
						ValaDataType* _tmp363_;
						ValaDataType* _tmp364_;
						ValaParameter* _tmp365_;
						ValaParameter* _tmp366_;
						ValaObjectType* _tmp367_;
						ValaObjectTypeSymbol* _tmp368_;
						ValaObjectTypeSymbol* _tmp369_;
						ValaScope* _tmp370_;
						ValaScope* _tmp371_;
						ValaDynamicMethod* _tmp372_;
						ValaDynamicMethod* _tmp373_;
						_tmp325_ = invoc;
						_tmp326_ = vala_expression_get_target_type ((ValaExpression*) _tmp325_);
						_tmp327_ = _tmp326_;
						if (_tmp327_ != NULL) {
							ValaMethodCall* _tmp328_;
							ValaDataType* _tmp329_;
							ValaDataType* _tmp330_;
							ValaDataType* _tmp331_;
							ValaDataType* _tmp332_;
							_tmp328_ = invoc;
							_tmp329_ = vala_expression_get_target_type ((ValaExpression*) _tmp328_);
							_tmp330_ = _tmp329_;
							_tmp331_ = vala_data_type_copy (_tmp330_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp331_;
							_tmp332_ = ret_type;
							vala_data_type_set_value_owned (_tmp332_, TRUE);
						} else {
							ValaMethodCall* _tmp333_;
							ValaCodeNode* _tmp334_;
							ValaCodeNode* _tmp335_;
							_tmp333_ = invoc;
							_tmp334_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp333_);
							_tmp335_ = _tmp334_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp335_)) {
								ValaVoidType* _tmp336_;
								_tmp336_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp336_;
							} else {
								ValaExpression* _tmp337_;
								ValaExpression* _tmp338_;
								ValaDataType* _tmp339_;
								ValaDataType* _tmp340_;
								ValaDataType* _tmp341_;
								_tmp337_ = vala_member_access_get_inner (self);
								_tmp338_ = _tmp337_;
								_tmp339_ = vala_expression_get_value_type (_tmp338_);
								_tmp340_ = _tmp339_;
								_tmp341_ = vala_data_type_copy (_tmp340_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp341_;
							}
						}
						_tmp342_ = vala_member_access_get_inner (self);
						_tmp343_ = _tmp342_;
						_tmp344_ = vala_expression_get_value_type (_tmp343_);
						_tmp345_ = _tmp344_;
						_tmp346_ = self->priv->_member_name;
						_tmp347_ = ret_type;
						_tmp348_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp349_ = _tmp348_;
						_tmp350_ = vala_dynamic_method_new (_tmp345_, _tmp346_, _tmp347_, _tmp349_, NULL);
						m = _tmp350_;
						_tmp351_ = m;
						_tmp352_ = invoc;
						vala_dynamic_method_set_invocation (_tmp351_, _tmp352_);
						_tmp353_ = vala_error_type_new (NULL, NULL, NULL);
						err = _tmp353_;
						_tmp354_ = err;
						vala_error_type_set_dynamic_error (_tmp354_, TRUE);
						_tmp355_ = m;
						_tmp356_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp355_, (ValaDataType*) _tmp356_);
						_tmp357_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp357_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp358_ = m;
						_tmp359_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp360_ = _tmp359_;
						vala_callable_add_parameter ((ValaCallable*) _tmp358_, _tmp360_);
						_vala_code_node_unref0 (_tmp360_);
						_tmp361_ = m;
						_tmp362_ = dynamic_object_type;
						_tmp363_ = vala_data_type_copy ((ValaDataType*) _tmp362_);
						_tmp364_ = _tmp363_;
						_tmp365_ = vala_parameter_new ("this", _tmp364_, NULL);
						_tmp366_ = _tmp365_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp361_, _tmp366_);
						_vala_code_node_unref0 (_tmp366_);
						_vala_code_node_unref0 (_tmp364_);
						_tmp367_ = dynamic_object_type;
						_tmp368_ = vala_object_type_get_type_symbol (_tmp367_);
						_tmp369_ = _tmp368_;
						_tmp370_ = vala_symbol_get_scope ((ValaSymbol*) _tmp369_);
						_tmp371_ = _tmp370_;
						_tmp372_ = m;
						vala_scope_add (_tmp371_, NULL, (ValaSymbol*) _tmp372_);
						_tmp373_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp373_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
					_vala_code_node_unref0 (invoc);
				} else {
					ValaCodeNode* _tmp374_;
					ValaCodeNode* _tmp375_;
					_tmp374_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp375_ = _tmp374_;
					if (VALA_IS_ASSIGNMENT (_tmp375_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp376_;
						ValaCodeNode* _tmp377_;
						ValaAssignment* _tmp378_;
						ValaAssignment* _tmp379_;
						ValaExpression* _tmp380_;
						ValaExpression* _tmp381_;
						_tmp376_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp377_ = _tmp376_;
						_tmp378_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp377_, VALA_TYPE_ASSIGNMENT, ValaAssignment));
						a = _tmp378_;
						_tmp379_ = a;
						_tmp380_ = vala_assignment_get_left (_tmp379_);
						_tmp381_ = _tmp380_;
						if (_tmp381_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp382_;
							ValaExpression* _tmp383_;
							ValaDataType* _tmp384_;
							ValaDataType* _tmp385_;
							const gchar* _tmp386_;
							ValaSourceReference* _tmp387_;
							ValaSourceReference* _tmp388_;
							ValaDynamicProperty* _tmp389_;
							ValaDynamicProperty* _tmp390_;
							ValaDynamicProperty* _tmp391_;
							ValaDynamicProperty* _tmp392_;
							ValaSourceReference* _tmp393_;
							ValaSourceReference* _tmp394_;
							ValaPropertyAccessor* _tmp395_;
							ValaPropertyAccessor* _tmp396_;
							ValaDynamicProperty* _tmp397_;
							ValaExpression* _tmp398_;
							ValaExpression* _tmp399_;
							ValaDataType* _tmp400_;
							ValaDataType* _tmp401_;
							ValaTypeSymbol* _tmp402_;
							ValaTypeSymbol* _tmp403_;
							ValaScope* _tmp404_;
							ValaScope* _tmp405_;
							ValaObjectType* _tmp406_;
							ValaObjectTypeSymbol* _tmp407_;
							ValaObjectTypeSymbol* _tmp408_;
							ValaScope* _tmp409_;
							ValaScope* _tmp410_;
							ValaDynamicProperty* _tmp411_;
							ValaDynamicProperty* _tmp412_;
							_tmp382_ = vala_member_access_get_inner (self);
							_tmp383_ = _tmp382_;
							_tmp384_ = vala_expression_get_value_type (_tmp383_);
							_tmp385_ = _tmp384_;
							_tmp386_ = self->priv->_member_name;
							_tmp387_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp388_ = _tmp387_;
							_tmp389_ = vala_dynamic_property_new (_tmp385_, _tmp386_, _tmp388_, NULL);
							prop = _tmp389_;
							_tmp390_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp390_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp391_ = prop;
							_tmp392_ = prop;
							_tmp393_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp392_);
							_tmp394_ = _tmp393_;
							_tmp395_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp394_, NULL);
							_tmp396_ = _tmp395_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp391_, _tmp396_);
							_vala_code_node_unref0 (_tmp396_);
							_tmp397_ = prop;
							_tmp398_ = vala_member_access_get_inner (self);
							_tmp399_ = _tmp398_;
							_tmp400_ = vala_expression_get_value_type (_tmp399_);
							_tmp401_ = _tmp400_;
							_tmp402_ = vala_data_type_get_data_type (_tmp401_);
							_tmp403_ = _tmp402_;
							_tmp404_ = vala_symbol_get_scope ((ValaSymbol*) _tmp403_);
							_tmp405_ = _tmp404_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp397_, _tmp405_);
							_tmp406_ = dynamic_object_type;
							_tmp407_ = vala_object_type_get_type_symbol (_tmp406_);
							_tmp408_ = _tmp407_;
							_tmp409_ = vala_symbol_get_scope ((ValaSymbol*) _tmp408_);
							_tmp410_ = _tmp409_;
							_tmp411_ = prop;
							vala_scope_add (_tmp410_, NULL, (ValaSymbol*) _tmp411_);
							_tmp412_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp412_);
							_vala_code_node_unref0 (prop);
						}
						_vala_code_node_unref0 (a);
					} else {
						gboolean _tmp413_ = FALSE;
						gboolean _tmp414_ = FALSE;
						ValaCodeNode* _tmp415_;
						ValaCodeNode* _tmp416_;
						_tmp415_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp416_ = _tmp415_;
						if (VALA_IS_MEMBER_ACCESS (_tmp416_)) {
							ValaExpression* _tmp417_;
							ValaExpression* _tmp418_;
							_tmp417_ = vala_member_access_get_inner (self);
							_tmp418_ = _tmp417_;
							_tmp414_ = VALA_IS_MEMBER_ACCESS (_tmp418_);
						} else {
							_tmp414_ = FALSE;
						}
						if (_tmp414_) {
							ValaCodeNode* _tmp419_;
							ValaCodeNode* _tmp420_;
							ValaCodeNode* _tmp421_;
							ValaCodeNode* _tmp422_;
							_tmp419_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp420_ = _tmp419_;
							_tmp421_ = vala_code_node_get_parent_node (_tmp420_);
							_tmp422_ = _tmp421_;
							_tmp413_ = VALA_IS_METHOD_CALL (_tmp422_);
						} else {
							_tmp413_ = FALSE;
						}
						if (_tmp413_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp423_;
							ValaCodeNode* _tmp424_;
							ValaMemberAccess* _tmp425_;
							gboolean _tmp426_ = FALSE;
							ValaMemberAccess* _tmp427_;
							const gchar* _tmp428_;
							_tmp423_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp424_ = _tmp423_;
							_tmp425_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp424_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
							ma = _tmp425_;
							_tmp427_ = ma;
							_tmp428_ = _tmp427_->priv->_member_name;
							if (g_strcmp0 (_tmp428_, "connect") == 0) {
								_tmp426_ = TRUE;
							} else {
								ValaMemberAccess* _tmp429_;
								const gchar* _tmp430_;
								_tmp429_ = ma;
								_tmp430_ = _tmp429_->priv->_member_name;
								_tmp426_ = g_strcmp0 (_tmp430_, "connect_after") == 0;
							}
							if (_tmp426_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp431_;
								ValaExpression* _tmp432_;
								ValaDataType* _tmp433_;
								ValaDataType* _tmp434_;
								const gchar* _tmp435_;
								ValaVoidType* _tmp436_;
								ValaVoidType* _tmp437_;
								ValaSourceReference* _tmp438_;
								ValaSourceReference* _tmp439_;
								ValaDynamicSignal* _tmp440_;
								ValaDynamicSignal* _tmp441_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp442_;
								ValaCodeNode* _tmp443_;
								ValaCodeNode* _tmp444_;
								ValaCodeNode* _tmp445_;
								ValaMethodCall* _tmp446_;
								ValaMethodCall* _tmp447_;
								ValaList* _tmp448_;
								ValaList* _tmp449_;
								gint _tmp450_;
								gint _tmp451_;
								gboolean _tmp452_;
								ValaDynamicSignal* _tmp459_;
								ValaObjectType* _tmp460_;
								ValaObjectTypeSymbol* _tmp461_;
								ValaObjectTypeSymbol* _tmp462_;
								ValaScope* _tmp463_;
								ValaScope* _tmp464_;
								ValaDynamicSignal* _tmp465_;
								ValaDynamicSignal* _tmp466_;
								_tmp431_ = vala_member_access_get_inner (self);
								_tmp432_ = _tmp431_;
								_tmp433_ = vala_expression_get_value_type (_tmp432_);
								_tmp434_ = _tmp433_;
								_tmp435_ = self->priv->_member_name;
								_tmp436_ = vala_void_type_new (NULL);
								_tmp437_ = _tmp436_;
								_tmp438_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp439_ = _tmp438_;
								_tmp440_ = vala_dynamic_signal_new (_tmp434_, _tmp435_, (ValaDataType*) _tmp437_, _tmp439_, NULL);
								_tmp441_ = _tmp440_;
								_vala_code_node_unref0 (_tmp437_);
								s = _tmp441_;
								_tmp442_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp443_ = _tmp442_;
								_tmp444_ = vala_code_node_get_parent_node (_tmp443_);
								_tmp445_ = _tmp444_;
								_tmp446_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp445_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp446_;
								_tmp447_ = mcall;
								_tmp448_ = vala_method_call_get_argument_list (_tmp447_);
								_tmp449_ = _tmp448_;
								_tmp450_ = vala_collection_get_size ((ValaCollection*) _tmp449_);
								_tmp451_ = _tmp450_;
								_tmp452_ = _tmp451_ > 0;
								_vala_iterable_unref0 (_tmp449_);
								if (_tmp452_) {
									ValaDynamicSignal* _tmp453_;
									ValaMethodCall* _tmp454_;
									ValaList* _tmp455_;
									ValaList* _tmp456_;
									gpointer _tmp457_;
									ValaExpression* _tmp458_;
									_tmp453_ = s;
									_tmp454_ = mcall;
									_tmp455_ = vala_method_call_get_argument_list (_tmp454_);
									_tmp456_ = _tmp455_;
									_tmp457_ = vala_list_get (_tmp456_, 0);
									_tmp458_ = (ValaExpression*) _tmp457_;
									vala_dynamic_signal_set_handler (_tmp453_, _tmp458_);
									_vala_code_node_unref0 (_tmp458_);
									_vala_iterable_unref0 (_tmp456_);
								}
								_tmp459_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp459_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp460_ = dynamic_object_type;
								_tmp461_ = vala_object_type_get_type_symbol (_tmp460_);
								_tmp462_ = _tmp461_;
								_tmp463_ = vala_symbol_get_scope ((ValaSymbol*) _tmp462_);
								_tmp464_ = _tmp463_;
								_tmp465_ = s;
								vala_scope_add (_tmp464_, NULL, (ValaSymbol*) _tmp465_);
								_tmp466_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp466_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							}
							_vala_code_node_unref0 (ma);
						}
					}
				}
				_tmp467_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp468_ = _tmp467_;
				if (_tmp468_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp469_;
					ValaExpression* _tmp470_;
					ValaDataType* _tmp471_;
					ValaDataType* _tmp472_;
					const gchar* _tmp473_;
					ValaSourceReference* _tmp474_;
					ValaSourceReference* _tmp475_;
					ValaDynamicProperty* _tmp476_;
					ValaDataType* _tmp477_;
					ValaDataType* _tmp478_;
					ValaDynamicProperty* _tmp489_;
					ValaDynamicProperty* _tmp490_;
					ValaDynamicProperty* _tmp491_;
					ValaDataType* _tmp492_;
					ValaDataType* _tmp493_;
					ValaDataType* _tmp494_;
					ValaDataType* _tmp495_;
					ValaDynamicProperty* _tmp496_;
					ValaSourceReference* _tmp497_;
					ValaSourceReference* _tmp498_;
					ValaPropertyAccessor* _tmp499_;
					ValaPropertyAccessor* _tmp500_;
					ValaDynamicProperty* _tmp501_;
					ValaExpression* _tmp502_;
					ValaExpression* _tmp503_;
					ValaDataType* _tmp504_;
					ValaDataType* _tmp505_;
					ValaTypeSymbol* _tmp506_;
					ValaTypeSymbol* _tmp507_;
					ValaScope* _tmp508_;
					ValaScope* _tmp509_;
					ValaObjectType* _tmp510_;
					ValaObjectTypeSymbol* _tmp511_;
					ValaObjectTypeSymbol* _tmp512_;
					ValaScope* _tmp513_;
					ValaScope* _tmp514_;
					ValaDynamicProperty* _tmp515_;
					ValaDynamicProperty* _tmp516_;
					_tmp469_ = vala_member_access_get_inner (self);
					_tmp470_ = _tmp469_;
					_tmp471_ = vala_expression_get_value_type (_tmp470_);
					_tmp472_ = _tmp471_;
					_tmp473_ = self->priv->_member_name;
					_tmp474_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp475_ = _tmp474_;
					_tmp476_ = vala_dynamic_property_new (_tmp472_, _tmp473_, _tmp475_, NULL);
					prop = _tmp476_;
					_tmp477_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp478_ = _tmp477_;
					if (_tmp478_ != NULL) {
						ValaDynamicProperty* _tmp479_;
						ValaDataType* _tmp480_;
						ValaDataType* _tmp481_;
						_tmp479_ = prop;
						_tmp480_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp481_ = _tmp480_;
						vala_property_set_property_type ((ValaProperty*) _tmp479_, _tmp481_);
					} else {
						ValaDynamicProperty* _tmp482_;
						ValaExpression* _tmp483_;
						ValaExpression* _tmp484_;
						ValaDataType* _tmp485_;
						ValaDataType* _tmp486_;
						ValaDataType* _tmp487_;
						ValaDataType* _tmp488_;
						_tmp482_ = prop;
						_tmp483_ = vala_member_access_get_inner (self);
						_tmp484_ = _tmp483_;
						_tmp485_ = vala_expression_get_value_type (_tmp484_);
						_tmp486_ = _tmp485_;
						_tmp487_ = vala_data_type_copy (_tmp486_);
						_tmp488_ = _tmp487_;
						vala_property_set_property_type ((ValaProperty*) _tmp482_, _tmp488_);
						_vala_code_node_unref0 (_tmp488_);
					}
					_tmp489_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp489_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp490_ = prop;
					_tmp491_ = prop;
					_tmp492_ = vala_property_get_property_type ((ValaProperty*) _tmp491_);
					_tmp493_ = _tmp492_;
					_tmp494_ = vala_data_type_copy (_tmp493_);
					_tmp495_ = _tmp494_;
					_tmp496_ = prop;
					_tmp497_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp496_);
					_tmp498_ = _tmp497_;
					_tmp499_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp495_, NULL, _tmp498_, NULL);
					_tmp500_ = _tmp499_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp490_, _tmp500_);
					_vala_code_node_unref0 (_tmp500_);
					_vala_code_node_unref0 (_tmp495_);
					_tmp501_ = prop;
					_tmp502_ = vala_member_access_get_inner (self);
					_tmp503_ = _tmp502_;
					_tmp504_ = vala_expression_get_value_type (_tmp503_);
					_tmp505_ = _tmp504_;
					_tmp506_ = vala_data_type_get_data_type (_tmp505_);
					_tmp507_ = _tmp506_;
					_tmp508_ = vala_symbol_get_scope ((ValaSymbol*) _tmp507_);
					_tmp509_ = _tmp508_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp501_, _tmp509_);
					_tmp510_ = dynamic_object_type;
					_tmp511_ = vala_object_type_get_type_symbol (_tmp510_);
					_tmp512_ = _tmp511_;
					_tmp513_ = vala_symbol_get_scope ((ValaSymbol*) _tmp512_);
					_tmp514_ = _tmp513_;
					_tmp515_ = prop;
					vala_scope_add (_tmp514_, NULL, (ValaSymbol*) _tmp515_);
					_tmp516_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp516_);
					_vala_code_node_unref0 (prop);
				}
				_tmp517_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp518_ = _tmp517_;
				if (_tmp518_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp520_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp521_ = _tmp520_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp521_)) {
				ValaExpression* _tmp522_;
				ValaExpression* _tmp523_;
				ValaDataType* _tmp524_;
				ValaDataType* _tmp525_;
				_tmp522_ = vala_member_access_get_inner (self);
				_tmp523_ = _tmp522_;
				_tmp524_ = vala_expression_get_value_type (_tmp523_);
				_tmp525_ = _tmp524_;
				_tmp519_ = VALA_IS_ARRAY_TYPE (_tmp525_);
			} else {
				_tmp519_ = FALSE;
			}
			if (_tmp519_) {
				ValaArrayType* value_array_type = NULL;
				ValaExpression* _tmp526_;
				ValaExpression* _tmp527_;
				ValaDataType* _tmp528_;
				ValaDataType* _tmp529_;
				gboolean _tmp530_ = FALSE;
				ValaArrayType* _tmp531_;
				_tmp526_ = vala_member_access_get_inner (self);
				_tmp527_ = _tmp526_;
				_tmp528_ = vala_expression_get_value_type (_tmp527_);
				_tmp529_ = _tmp528_;
				value_array_type = VALA_IS_ARRAY_TYPE (_tmp529_) ? ((ValaArrayType*) _tmp529_) : NULL;
				_tmp531_ = value_array_type;
				if (_tmp531_ != NULL) {
					ValaArrayType* _tmp532_;
					gboolean _tmp533_;
					gboolean _tmp534_;
					_tmp532_ = value_array_type;
					_tmp533_ = vala_array_type_get_inline_allocated (_tmp532_);
					_tmp534_ = _tmp533_;
					_tmp530_ = _tmp534_;
				} else {
					_tmp530_ = FALSE;
				}
				if (_tmp530_) {
					ValaSourceReference* _tmp535_;
					ValaSourceReference* _tmp536_;
					_tmp535_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp536_ = _tmp535_;
					vala_report_error (_tmp536_, "`resize' is not supported for arrays with fixed length");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
		}
	}
	_tmp540_ = vala_member_access_get_inner (self);
	_tmp541_ = _tmp540_;
	if (_tmp541_ == NULL) {
		ValaSymbol* _tmp542_;
		ValaSymbol* _tmp543_;
		_tmp542_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp543_ = _tmp542_;
		_tmp539_ = _tmp543_ == NULL;
	} else {
		_tmp539_ = FALSE;
	}
	if (_tmp539_) {
		ValaDataType* _tmp544_;
		ValaDataType* _tmp545_;
		_tmp544_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp545_ = _tmp544_;
		_tmp538_ = _tmp545_ != NULL;
	} else {
		_tmp538_ = FALSE;
	}
	if (_tmp538_) {
		ValaDataType* _tmp546_;
		ValaDataType* _tmp547_;
		ValaTypeSymbol* _tmp548_;
		ValaTypeSymbol* _tmp549_;
		_tmp546_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp547_ = _tmp546_;
		_tmp548_ = vala_data_type_get_data_type (_tmp547_);
		_tmp549_ = _tmp548_;
		_tmp537_ = VALA_IS_ENUM (_tmp549_);
	} else {
		_tmp537_ = FALSE;
	}
	if (_tmp537_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp550_;
		ValaDataType* _tmp551_;
		ValaTypeSymbol* _tmp552_;
		ValaTypeSymbol* _tmp553_;
		ValaEnum* _tmp554_;
		_tmp550_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp551_ = _tmp550_;
		_tmp552_ = vala_data_type_get_data_type (_tmp551_);
		_tmp553_ = _tmp552_;
		_tmp554_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp553_, VALA_TYPE_ENUM, ValaEnum));
		enum_type = _tmp554_;
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp555_;
			ValaList* _tmp556_;
			gint _val_size = 0;
			ValaList* _tmp557_;
			gint _tmp558_;
			gint _tmp559_;
			gint _val_index = 0;
			_tmp555_ = enum_type;
			_tmp556_ = vala_enum_get_values (_tmp555_);
			_val_list = _tmp556_;
			_tmp557_ = _val_list;
			_tmp558_ = vala_collection_get_size ((ValaCollection*) _tmp557_);
			_tmp559_ = _tmp558_;
			_val_size = _tmp559_;
			_val_index = -1;
			while (TRUE) {
				ValaEnumValue* val = NULL;
				ValaList* _tmp560_;
				gpointer _tmp561_;
				const gchar* _tmp562_;
				ValaEnumValue* _tmp563_;
				const gchar* _tmp564_;
				const gchar* _tmp565_;
				_val_index = _val_index + 1;
				if (!(_val_index < _val_size)) {
					break;
				}
				_tmp560_ = _val_list;
				_tmp561_ = vala_list_get (_tmp560_, _val_index);
				val = (ValaEnumValue*) _tmp561_;
				_tmp562_ = self->priv->_member_name;
				_tmp563_ = val;
				_tmp564_ = vala_symbol_get_name ((ValaSymbol*) _tmp563_);
				_tmp565_ = _tmp564_;
				if (g_strcmp0 (_tmp562_, _tmp565_) == 0) {
					ValaEnumValue* _tmp566_;
					_tmp566_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp566_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
			_vala_iterable_unref0 (_val_list);
		}
		_vala_code_node_unref0 (enum_type);
	}
	_tmp567_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp568_ = _tmp567_;
	if (_tmp568_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp569_;
		gboolean _tmp570_ = FALSE;
		ValaExpression* _tmp571_;
		ValaExpression* _tmp572_;
		ValaSourceReference* _tmp585_;
		ValaSourceReference* _tmp586_;
		const gchar* _tmp587_;
		const gchar* _tmp588_;
		gchar* _tmp589_;
		gchar* _tmp590_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp569_ = g_strdup ("(null)");
		base_type_name = _tmp569_;
		_tmp571_ = vala_member_access_get_inner (self);
		_tmp572_ = _tmp571_;
		if (_tmp572_ != NULL) {
			ValaExpression* _tmp573_;
			ValaExpression* _tmp574_;
			ValaDataType* _tmp575_;
			ValaDataType* _tmp576_;
			_tmp573_ = vala_member_access_get_inner (self);
			_tmp574_ = _tmp573_;
			_tmp575_ = vala_expression_get_value_type (_tmp574_);
			_tmp576_ = _tmp575_;
			_tmp570_ = _tmp576_ != NULL;
		} else {
			_tmp570_ = FALSE;
		}
		if (_tmp570_) {
			ValaExpression* _tmp577_;
			ValaExpression* _tmp578_;
			ValaDataType* _tmp579_;
			ValaDataType* _tmp580_;
			gchar* _tmp581_;
			_tmp577_ = vala_member_access_get_inner (self);
			_tmp578_ = _tmp577_;
			_tmp579_ = vala_expression_get_value_type (_tmp578_);
			_tmp580_ = _tmp579_;
			_tmp581_ = vala_code_node_to_string ((ValaCodeNode*) _tmp580_);
			_g_free0 (base_type_name);
			base_type_name = _tmp581_;
		} else {
			ValaSymbol* _tmp582_;
			_tmp582_ = base_symbol;
			if (_tmp582_ != NULL) {
				ValaSymbol* _tmp583_;
				gchar* _tmp584_;
				_tmp583_ = base_symbol;
				_tmp584_ = vala_symbol_get_full_name (_tmp583_);
				_g_free0 (base_type_name);
				base_type_name = _tmp584_;
			}
		}
		_tmp585_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp586_ = _tmp585_;
		_tmp587_ = self->priv->_member_name;
		_tmp588_ = base_type_name;
		_tmp589_ = g_strdup_printf ("The name `%s' does not exist in the context of `%s'", _tmp587_, _tmp588_);
		_tmp590_ = _tmp589_;
		vala_report_error (_tmp586_, _tmp590_);
		_g_free0 (_tmp590_);
		result = FALSE;
		_g_free0 (base_type_name);
		_vala_code_node_unref0 (this_parameter);
		_vala_code_node_unref0 (base_symbol);
		return result;
	}
	_tmp591_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp592_ = _tmp591_;
	_tmp593_ = _vala_code_node_ref0 (_tmp592_);
	member = _tmp593_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp594_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp594_, context)) {
		result = FALSE;
		_vala_code_node_unref0 (member);
		_vala_code_node_unref0 (this_parameter);
		_vala_code_node_unref0 (base_symbol);
		return result;
	}
	_tmp595_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp595_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp596_;
		ValaLocalVariable* _tmp597_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp598_;
		ValaSymbol* _tmp599_;
		ValaSymbol* _tmp600_;
		ValaBlock* _tmp601_;
		gboolean _tmp602_ = FALSE;
		ValaBlock* _tmp603_;
		_tmp596_ = member;
		_tmp597_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp596_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable));
		local = _tmp597_;
		_tmp598_ = local;
		_tmp599_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp598_);
		_tmp600_ = _tmp599_;
		_tmp601_ = _vala_code_node_ref0 (VALA_IS_BLOCK (_tmp600_) ? ((ValaBlock*) _tmp600_) : NULL);
		block = _tmp601_;
		_tmp603_ = block;
		if (_tmp603_ != NULL) {
			ValaSemanticAnalyzer* _tmp604_;
			ValaSemanticAnalyzer* _tmp605_;
			ValaBlock* _tmp606_;
			ValaSymbol* _tmp607_;
			ValaSymbol* _tmp608_;
			ValaSemanticAnalyzer* _tmp609_;
			ValaSemanticAnalyzer* _tmp610_;
			ValaSymbol* _tmp611_;
			ValaSymbol* _tmp612_;
			_tmp604_ = vala_code_context_get_analyzer (context);
			_tmp605_ = _tmp604_;
			_tmp606_ = block;
			_tmp607_ = vala_semantic_analyzer_find_parent_method_or_property_accessor (_tmp605_, (ValaSymbol*) _tmp606_);
			_tmp608_ = _tmp607_;
			_tmp609_ = vala_code_context_get_analyzer (context);
			_tmp610_ = _tmp609_;
			_tmp611_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp610_);
			_tmp612_ = _tmp611_;
			_tmp602_ = _tmp608_ != _tmp612_;
			_vala_code_node_unref0 (_tmp608_);
		} else {
			_tmp602_ = FALSE;
		}
		if (_tmp602_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp613_;
			ValaSemanticAnalyzer* _tmp614_;
			ValaSymbol* _tmp615_;
			ValaSymbol* _tmp616_;
			ValaSymbol* _tmp617_;
			ValaLocalVariable* _tmp630_;
			ValaBlock* _tmp631_;
			_tmp613_ = vala_code_context_get_analyzer (context);
			_tmp614_ = _tmp613_;
			_tmp615_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp614_);
			_tmp616_ = _tmp615_;
			_tmp617_ = _vala_code_node_ref0 (_tmp616_);
			sym = _tmp617_;
			while (TRUE) {
				ValaSymbol* _tmp618_;
				ValaBlock* _tmp619_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp620_;
				ValaMethod* _tmp621_;
				ValaMethod* _tmp622_;
				ValaSymbol* _tmp626_;
				ValaSymbol* _tmp627_;
				ValaSymbol* _tmp628_;
				ValaSymbol* _tmp629_;
				_tmp618_ = sym;
				_tmp619_ = block;
				if (!(_tmp618_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp619_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp620_ = sym;
				_tmp621_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp620_) ? ((ValaMethod*) _tmp620_) : NULL);
				method = _tmp621_;
				_tmp622_ = method;
				if (_tmp622_ != NULL) {
					ValaMethod* _tmp623_;
					ValaMethod* _tmp624_;
					ValaLocalVariable* _tmp625_;
					_tmp623_ = method;
					vala_method_set_closure (_tmp623_, TRUE);
					_tmp624_ = method;
					_tmp625_ = local;
					vala_method_add_captured_variable (_tmp624_, _tmp625_);
				}
				_tmp626_ = sym;
				_tmp627_ = vala_symbol_get_parent_symbol (_tmp626_);
				_tmp628_ = _tmp627_;
				_tmp629_ = _vala_code_node_ref0 (_tmp628_);
				_vala_code_node_unref0 (sym);
				sym = _tmp629_;
				_vala_code_node_unref0 (method);
			}
			_tmp630_ = local;
			vala_local_variable_set_captured (_tmp630_, TRUE);
			_tmp631_ = block;
			vala_block_set_captured (_tmp631_, TRUE);
			_vala_code_node_unref0 (sym);
		}
		_vala_code_node_unref0 (block);
		_vala_code_node_unref0 (local);
	} else {
		ValaSymbol* _tmp632_;
		_tmp632_ = member;
		if (VALA_IS_PARAMETER (_tmp632_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp633_;
			ValaParameter* _tmp634_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp635_;
			ValaSymbol* _tmp636_;
			ValaSymbol* _tmp637_;
			ValaMethod* _tmp638_;
			gboolean _tmp639_ = FALSE;
			gboolean _tmp640_ = FALSE;
			ValaMethod* _tmp641_;
			_tmp633_ = member;
			_tmp634_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp633_, VALA_TYPE_PARAMETER, ValaParameter));
			param = _tmp634_;
			_tmp635_ = param;
			_tmp636_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp635_);
			_tmp637_ = _tmp636_;
			_tmp638_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp637_) ? ((ValaMethod*) _tmp637_) : NULL);
			m = _tmp638_;
			_tmp641_ = m;
			if (_tmp641_ != NULL) {
				ValaMethod* _tmp642_;
				ValaSemanticAnalyzer* _tmp643_;
				ValaSemanticAnalyzer* _tmp644_;
				ValaSymbol* _tmp645_;
				ValaSymbol* _tmp646_;
				_tmp642_ = m;
				_tmp643_ = vala_code_context_get_analyzer (context);
				_tmp644_ = _tmp643_;
				_tmp645_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp644_);
				_tmp646_ = _tmp645_;
				_tmp640_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp642_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp646_;
			} else {
				_tmp640_ = FALSE;
			}
			if (_tmp640_) {
				ValaParameter* _tmp647_;
				ValaMethod* _tmp648_;
				ValaParameter* _tmp649_;
				ValaParameter* _tmp650_;
				_tmp647_ = param;
				_tmp648_ = m;
				_tmp649_ = vala_method_get_this_parameter (_tmp648_);
				_tmp650_ = _tmp649_;
				_tmp639_ = _tmp647_ != _tmp650_;
			} else {
				_tmp639_ = FALSE;
			}
			if (_tmp639_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp651_;
				ValaSemanticAnalyzer* _tmp652_;
				ValaSymbol* _tmp653_;
				ValaSymbol* _tmp654_;
				ValaSymbol* _tmp655_;
				ValaParameter* _tmp666_;
				ValaMethod* _tmp667_;
				ValaBlock* _tmp668_;
				ValaBlock* _tmp669_;
				ValaParameter* _tmp670_;
				ValaParameterDirection _tmp671_;
				ValaParameterDirection _tmp672_;
				_tmp651_ = vala_code_context_get_analyzer (context);
				_tmp652_ = _tmp651_;
				_tmp653_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp652_);
				_tmp654_ = _tmp653_;
				_tmp655_ = _vala_code_node_ref0 (_tmp654_);
				sym = _tmp655_;
				while (TRUE) {
					ValaSymbol* _tmp656_;
					ValaMethod* _tmp657_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp658_;
					ValaMethod* _tmp659_;
					ValaMethod* _tmp660_;
					ValaSymbol* _tmp662_;
					ValaSymbol* _tmp663_;
					ValaSymbol* _tmp664_;
					ValaSymbol* _tmp665_;
					_tmp656_ = sym;
					_tmp657_ = m;
					if (!(_tmp656_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp657_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp658_ = sym;
					_tmp659_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp658_) ? ((ValaMethod*) _tmp658_) : NULL);
					method = _tmp659_;
					_tmp660_ = method;
					if (_tmp660_ != NULL) {
						ValaMethod* _tmp661_;
						_tmp661_ = method;
						vala_method_set_closure (_tmp661_, TRUE);
					}
					_tmp662_ = sym;
					_tmp663_ = vala_symbol_get_parent_symbol (_tmp662_);
					_tmp664_ = _tmp663_;
					_tmp665_ = _vala_code_node_ref0 (_tmp664_);
					_vala_code_node_unref0 (sym);
					sym = _tmp665_;
					_vala_code_node_unref0 (method);
				}
				_tmp666_ = param;
				vala_parameter_set_captured (_tmp666_, TRUE);
				_tmp667_ = m;
				_tmp668_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp667_);
				_tmp669_ = _tmp668_;
				vala_block_set_captured (_tmp669_, TRUE);
				_tmp670_ = param;
				_tmp671_ = vala_parameter_get_direction (_tmp670_);
				_tmp672_ = _tmp671_;
				if (_tmp672_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp673_;
					ValaSourceReference* _tmp674_;
					ValaParameter* _tmp675_;
					gchar* _tmp676_;
					gchar* _tmp677_;
					gchar* _tmp678_;
					gchar* _tmp679_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp673_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp674_ = _tmp673_;
					_tmp675_ = param;
					_tmp676_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp675_);
					_tmp677_ = _tmp676_;
					_tmp678_ = g_strdup_printf ("Cannot capture reference or output parameter `%s'", _tmp677_);
					_tmp679_ = _tmp678_;
					vala_report_error (_tmp674_, _tmp679_);
					_g_free0 (_tmp679_);
					_g_free0 (_tmp677_);
				}
				_vala_code_node_unref0 (sym);
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp680_;
				ValaSymbol* _tmp681_;
				ValaSymbol* _tmp682_;
				ValaSymbol* _tmp683_;
				ValaSymbol* _tmp684_;
				ValaPropertyAccessor* _tmp685_;
				gboolean _tmp686_ = FALSE;
				gboolean _tmp687_ = FALSE;
				ValaPropertyAccessor* _tmp688_;
				_tmp680_ = param;
				_tmp681_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp680_);
				_tmp682_ = _tmp681_;
				_tmp683_ = vala_symbol_get_parent_symbol (_tmp682_);
				_tmp684_ = _tmp683_;
				_tmp685_ = _vala_code_node_ref0 (VALA_IS_PROPERTY_ACCESSOR (_tmp684_) ? ((ValaPropertyAccessor*) _tmp684_) : NULL);
				acc = _tmp685_;
				_tmp688_ = acc;
				if (_tmp688_ != NULL) {
					ValaPropertyAccessor* _tmp689_;
					ValaSemanticAnalyzer* _tmp690_;
					ValaSemanticAnalyzer* _tmp691_;
					ValaSymbol* _tmp692_;
					ValaSymbol* _tmp693_;
					_tmp689_ = acc;
					_tmp690_ = vala_code_context_get_analyzer (context);
					_tmp691_ = _tmp690_;
					_tmp692_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp691_);
					_tmp693_ = _tmp692_;
					_tmp687_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp689_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp693_;
				} else {
					_tmp687_ = FALSE;
				}
				if (_tmp687_) {
					ValaParameter* _tmp694_;
					ValaPropertyAccessor* _tmp695_;
					ValaProperty* _tmp696_;
					ValaProperty* _tmp697_;
					ValaParameter* _tmp698_;
					ValaParameter* _tmp699_;
					_tmp694_ = param;
					_tmp695_ = acc;
					_tmp696_ = vala_property_accessor_get_prop (_tmp695_);
					_tmp697_ = _tmp696_;
					_tmp698_ = vala_property_get_this_parameter (_tmp697_);
					_tmp699_ = _tmp698_;
					_tmp686_ = _tmp694_ != _tmp699_;
				} else {
					_tmp686_ = FALSE;
				}
				if (_tmp686_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp700_;
					ValaSemanticAnalyzer* _tmp701_;
					ValaSymbol* _tmp702_;
					ValaSymbol* _tmp703_;
					ValaSymbol* _tmp704_;
					ValaParameter* _tmp715_;
					ValaPropertyAccessor* _tmp716_;
					ValaBlock* _tmp717_;
					ValaBlock* _tmp718_;
					_tmp700_ = vala_code_context_get_analyzer (context);
					_tmp701_ = _tmp700_;
					_tmp702_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp701_);
					_tmp703_ = _tmp702_;
					_tmp704_ = _vala_code_node_ref0 (_tmp703_);
					sym = _tmp704_;
					while (TRUE) {
						ValaSymbol* _tmp705_;
						ValaMethod* _tmp706_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp707_;
						ValaMethod* _tmp708_;
						ValaMethod* _tmp709_;
						ValaSymbol* _tmp711_;
						ValaSymbol* _tmp712_;
						ValaSymbol* _tmp713_;
						ValaSymbol* _tmp714_;
						_tmp705_ = sym;
						_tmp706_ = m;
						if (!(_tmp705_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp706_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp707_ = sym;
						_tmp708_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp707_) ? ((ValaMethod*) _tmp707_) : NULL);
						method = _tmp708_;
						_tmp709_ = method;
						if (_tmp709_ != NULL) {
							ValaMethod* _tmp710_;
							_tmp710_ = method;
							vala_method_set_closure (_tmp710_, TRUE);
						}
						_tmp711_ = sym;
						_tmp712_ = vala_symbol_get_parent_symbol (_tmp711_);
						_tmp713_ = _tmp712_;
						_tmp714_ = _vala_code_node_ref0 (_tmp713_);
						_vala_code_node_unref0 (sym);
						sym = _tmp714_;
						_vala_code_node_unref0 (method);
					}
					_tmp715_ = param;
					vala_parameter_set_captured (_tmp715_, TRUE);
					_tmp716_ = acc;
					_tmp717_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp716_);
					_tmp718_ = _tmp717_;
					vala_block_set_captured (_tmp718_, TRUE);
					_vala_code_node_unref0 (sym);
				}
				_vala_code_node_unref0 (acc);
			}
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (param);
		} else {
			ValaSymbol* _tmp719_;
			_tmp719_ = member;
			if (VALA_IS_FIELD (_tmp719_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp720_;
				ValaField* _tmp721_;
				ValaField* _tmp722_;
				ValaSymbolAccessibility _tmp723_;
				ValaSymbolAccessibility _tmp724_;
				ValaField* _tmp725_;
				ValaMemberBinding _tmp726_;
				ValaMemberBinding _tmp727_;
				ValaField* _tmp728_;
				ValaMemberBinding _tmp729_;
				ValaMemberBinding _tmp730_;
				ValaField* _tmp731_;
				ValaDataType* _tmp732_;
				ValaDataType* _tmp733_;
				_tmp720_ = member;
				_tmp721_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp720_, VALA_TYPE_FIELD, ValaField));
				f = _tmp721_;
				_tmp722_ = f;
				_tmp723_ = vala_symbol_get_access ((ValaSymbol*) _tmp722_);
				_tmp724_ = _tmp723_;
				access = _tmp724_;
				_tmp725_ = f;
				_tmp726_ = vala_field_get_binding (_tmp725_);
				_tmp727_ = _tmp726_;
				instance = _tmp727_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp728_ = f;
				_tmp729_ = vala_field_get_binding (_tmp728_);
				_tmp730_ = _tmp729_;
				klass = _tmp730_ == VALA_MEMBER_BINDING_CLASS;
				_tmp731_ = f;
				_tmp732_ = vala_variable_get_variable_type ((ValaVariable*) _tmp731_);
				_tmp733_ = _tmp732_;
				if (VALA_IS_GENERIC_TYPE (_tmp733_)) {
					generics = TRUE;
				}
				_vala_code_node_unref0 (f);
			} else {
				ValaSymbol* _tmp734_;
				_tmp734_ = member;
				if (VALA_IS_CONSTANT (_tmp734_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp735_;
					ValaConstant* _tmp736_;
					ValaConstant* _tmp737_;
					ValaSymbolAccessibility _tmp738_;
					ValaSymbolAccessibility _tmp739_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp740_;
					ValaSymbol* _tmp741_;
					ValaSymbol* _tmp742_;
					ValaBlock* _tmp743_;
					gboolean _tmp744_ = FALSE;
					ValaBlock* _tmp745_;
					_tmp735_ = member;
					_tmp736_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp735_, VALA_TYPE_CONSTANT, ValaConstant));
					c = _tmp736_;
					_tmp737_ = c;
					_tmp738_ = vala_symbol_get_access ((ValaSymbol*) _tmp737_);
					_tmp739_ = _tmp738_;
					access = _tmp739_;
					_tmp740_ = c;
					_tmp741_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp740_);
					_tmp742_ = _tmp741_;
					_tmp743_ = _vala_code_node_ref0 (VALA_IS_BLOCK (_tmp742_) ? ((ValaBlock*) _tmp742_) : NULL);
					block = _tmp743_;
					_tmp745_ = block;
					if (_tmp745_ != NULL) {
						ValaSemanticAnalyzer* _tmp746_;
						ValaSemanticAnalyzer* _tmp747_;
						ValaBlock* _tmp748_;
						ValaSymbol* _tmp749_;
						ValaSymbol* _tmp750_;
						ValaSemanticAnalyzer* _tmp751_;
						ValaSemanticAnalyzer* _tmp752_;
						ValaSymbol* _tmp753_;
						ValaSymbol* _tmp754_;
						_tmp746_ = vala_code_context_get_analyzer (context);
						_tmp747_ = _tmp746_;
						_tmp748_ = block;
						_tmp749_ = vala_semantic_analyzer_find_parent_method_or_property_accessor (_tmp747_, (ValaSymbol*) _tmp748_);
						_tmp750_ = _tmp749_;
						_tmp751_ = vala_code_context_get_analyzer (context);
						_tmp752_ = _tmp751_;
						_tmp753_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp752_);
						_tmp754_ = _tmp753_;
						_tmp744_ = _tmp750_ != _tmp754_;
						_vala_code_node_unref0 (_tmp750_);
					} else {
						_tmp744_ = FALSE;
					}
					if (_tmp744_) {
						ValaSourceReference* _tmp755_;
						ValaSourceReference* _tmp756_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp755_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp756_ = _tmp755_;
						vala_report_error (_tmp756_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						_vala_code_node_unref0 (block);
						_vala_code_node_unref0 (c);
						_vala_code_node_unref0 (member);
						_vala_code_node_unref0 (this_parameter);
						_vala_code_node_unref0 (base_symbol);
						return result;
					}
					_vala_code_node_unref0 (block);
					_vala_code_node_unref0 (c);
				} else {
					ValaSymbol* _tmp757_;
					_tmp757_ = member;
					if (VALA_IS_METHOD (_tmp757_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp758_;
						ValaMethod* _tmp759_;
						ValaMethod* _tmp760_;
						gboolean _tmp761_;
						gboolean _tmp762_;
						ValaMethod* _tmp864_;
						ValaSymbolAccessibility _tmp865_;
						ValaSymbolAccessibility _tmp866_;
						ValaMethod* _tmp867_;
						ValaMethod* _tmp871_;
						ValaMemberBinding _tmp872_;
						ValaMemberBinding _tmp873_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp892_;
						ValaDataType* _tmp893_;
						ValaDataType* _tmp894_;
						ValaGenericType* _tmp895_;
						gboolean _tmp896_ = FALSE;
						ValaGenericType* _tmp897_;
						_tmp758_ = member;
						_tmp759_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp758_, VALA_TYPE_METHOD, ValaMethod));
						m = _tmp759_;
						_tmp760_ = m;
						_tmp761_ = vala_method_get_is_async_callback (_tmp760_);
						_tmp762_ = _tmp761_;
						if (_tmp762_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp763_;
							ValaSemanticAnalyzer* _tmp764_;
							ValaMethod* _tmp765_;
							ValaMethod* _tmp766_;
							ValaMethod* _tmp767_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp768_;
							ValaMethod* _tmp801_;
							ValaSemanticAnalyzer* _tmp802_;
							ValaSemanticAnalyzer* _tmp803_;
							ValaMethod* _tmp804_;
							ValaMethod* _tmp805_;
							ValaMethod* _tmp824_;
							ValaMethod* _tmp825_;
							ValaMethod* _tmp826_;
							ValaSymbol* _tmp827_;
							ValaSymbol* _tmp828_;
							ValaSymbol* _tmp829_;
							_tmp763_ = vala_code_context_get_analyzer (context);
							_tmp764_ = _tmp763_;
							_tmp765_ = vala_semantic_analyzer_get_current_async_method (_tmp764_);
							_tmp766_ = _tmp765_;
							_tmp767_ = _vala_code_node_ref0 (_tmp766_);
							async_method = _tmp767_;
							is_valid_access = FALSE;
							_tmp768_ = async_method;
							if (_tmp768_ != NULL) {
								ValaMethod* _tmp769_;
								ValaMethod* _tmp770_;
								ValaMethod* _tmp771_;
								ValaMethod* _tmp772_;
								gboolean _tmp773_;
								_tmp769_ = m;
								_tmp770_ = async_method;
								_tmp771_ = vala_method_get_callback_method (_tmp770_);
								_tmp772_ = _tmp771_;
								_tmp773_ = _tmp769_ == _tmp772_;
								_vala_code_node_unref0 (_tmp772_);
								if (_tmp773_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp774_ = FALSE;
									ValaMethod* _tmp775_;
									ValaMethod* _tmp776_;
									ValaMethod* _tmp777_;
									_tmp775_ = async_method;
									_tmp776_ = vala_method_get_base_method (_tmp775_);
									_tmp777_ = _tmp776_;
									if (_tmp777_ != NULL) {
										ValaMethod* _tmp778_;
										ValaMethod* _tmp779_;
										ValaMethod* _tmp780_;
										ValaMethod* _tmp781_;
										ValaMethod* _tmp782_;
										ValaMethod* _tmp783_;
										_tmp778_ = m;
										_tmp779_ = async_method;
										_tmp780_ = vala_method_get_base_method (_tmp779_);
										_tmp781_ = _tmp780_;
										_tmp782_ = vala_method_get_callback_method (_tmp781_);
										_tmp783_ = _tmp782_;
										_tmp774_ = _tmp778_ == _tmp783_;
										_vala_code_node_unref0 (_tmp783_);
									} else {
										_tmp774_ = FALSE;
									}
									if (_tmp774_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp784_ = FALSE;
										ValaMethod* _tmp785_;
										ValaMethod* _tmp786_;
										ValaMethod* _tmp787_;
										_tmp785_ = async_method;
										_tmp786_ = vala_method_get_base_interface_method (_tmp785_);
										_tmp787_ = _tmp786_;
										if (_tmp787_ != NULL) {
											ValaMethod* _tmp788_;
											ValaMethod* _tmp789_;
											ValaMethod* _tmp790_;
											ValaMethod* _tmp791_;
											ValaMethod* _tmp792_;
											ValaMethod* _tmp793_;
											_tmp788_ = m;
											_tmp789_ = async_method;
											_tmp790_ = vala_method_get_base_interface_method (_tmp789_);
											_tmp791_ = _tmp790_;
											_tmp792_ = vala_method_get_callback_method (_tmp791_);
											_tmp793_ = _tmp792_;
											_tmp784_ = _tmp788_ == _tmp793_;
											_vala_code_node_unref0 (_tmp793_);
										} else {
											_tmp784_ = FALSE;
										}
										if (_tmp784_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp794_;
								ValaSourceReference* _tmp795_;
								ValaMethod* _tmp796_;
								gchar* _tmp797_;
								gchar* _tmp798_;
								gchar* _tmp799_;
								gchar* _tmp800_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp794_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp795_ = _tmp794_;
								_tmp796_ = m;
								_tmp797_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp796_);
								_tmp798_ = _tmp797_;
								_tmp799_ = g_strdup_printf ("Access to async callback `%s' not allowed in this context", _tmp798_);
								_tmp800_ = _tmp799_;
								vala_report_error (_tmp795_, _tmp800_);
								_g_free0 (_tmp800_);
								_g_free0 (_tmp798_);
								result = FALSE;
								_vala_code_node_unref0 (async_method);
								_vala_code_node_unref0 (m);
								_vala_code_node_unref0 (member);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp801_ = async_method;
							_tmp802_ = vala_code_context_get_analyzer (context);
							_tmp803_ = _tmp802_;
							_tmp804_ = vala_semantic_analyzer_get_current_method (_tmp803_);
							_tmp805_ = _tmp804_;
							if (_tmp801_ != _tmp805_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp806_;
								ValaSemanticAnalyzer* _tmp807_;
								ValaMethod* _tmp808_;
								ValaMethod* _tmp809_;
								ValaSymbol* _tmp810_;
								ValaMethod* _tmp821_;
								ValaBlock* _tmp822_;
								ValaBlock* _tmp823_;
								_tmp806_ = vala_code_context_get_analyzer (context);
								_tmp807_ = _tmp806_;
								_tmp808_ = vala_semantic_analyzer_get_current_method (_tmp807_);
								_tmp809_ = _tmp808_;
								_tmp810_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp809_);
								sym = _tmp810_;
								while (TRUE) {
									ValaSymbol* _tmp811_;
									ValaMethod* _tmp812_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp813_;
									ValaMethod* _tmp814_;
									ValaMethod* _tmp815_;
									ValaSymbol* _tmp817_;
									ValaSymbol* _tmp818_;
									ValaSymbol* _tmp819_;
									ValaSymbol* _tmp820_;
									_tmp811_ = sym;
									_tmp812_ = async_method;
									if (!(_tmp811_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp812_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp813_ = sym;
									_tmp814_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp813_) ? ((ValaMethod*) _tmp813_) : NULL);
									method = _tmp814_;
									_tmp815_ = method;
									if (_tmp815_ != NULL) {
										ValaMethod* _tmp816_;
										_tmp816_ = method;
										vala_method_set_closure (_tmp816_, TRUE);
									}
									_tmp817_ = sym;
									_tmp818_ = vala_symbol_get_parent_symbol (_tmp817_);
									_tmp819_ = _tmp818_;
									_tmp820_ = _vala_code_node_ref0 (_tmp819_);
									_vala_code_node_unref0 (sym);
									sym = _tmp820_;
									_vala_code_node_unref0 (method);
								}
								_tmp821_ = async_method;
								_tmp822_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp821_);
								_tmp823_ = _tmp822_;
								vala_block_set_captured (_tmp823_, TRUE);
								_vala_code_node_unref0 (sym);
							}
							_tmp824_ = async_method;
							_tmp825_ = vala_method_get_callback_method (_tmp824_);
							_vala_code_node_unref0 (m);
							m = _tmp825_;
							_tmp826_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp826_);
							_tmp827_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp828_ = _tmp827_;
							_tmp829_ = _vala_code_node_ref0 (_tmp828_);
							_vala_code_node_unref0 (member);
							member = _tmp829_;
							_vala_code_node_unref0 (async_method);
						} else {
							ValaMethod* _tmp830_;
							ValaMethod* _tmp831_;
							ValaMethod* _tmp832_;
							_tmp830_ = m;
							_tmp831_ = vala_method_get_base_method (_tmp830_);
							_tmp832_ = _tmp831_;
							if (_tmp832_ != NULL) {
								ValaMethod* _tmp833_;
								ValaMethod* _tmp834_;
								ValaMethod* _tmp835_;
								ValaMethod* _tmp836_;
								ValaMethod* _tmp837_;
								ValaSignal* _tmp838_;
								ValaSignal* _tmp839_;
								ValaSymbol* _tmp844_;
								ValaSymbol* _tmp845_;
								ValaSymbol* _tmp846_;
								_tmp833_ = m;
								_tmp834_ = vala_method_get_base_method (_tmp833_);
								_tmp835_ = _tmp834_;
								_tmp836_ = _vala_code_node_ref0 (_tmp835_);
								_vala_code_node_unref0 (m);
								m = _tmp836_;
								_tmp837_ = m;
								_tmp838_ = vala_method_get_signal_reference (_tmp837_);
								_tmp839_ = _tmp838_;
								if (_tmp839_ != NULL) {
									ValaMethod* _tmp840_;
									ValaSignal* _tmp841_;
									ValaSignal* _tmp842_;
									_tmp840_ = m;
									_tmp841_ = vala_method_get_signal_reference (_tmp840_);
									_tmp842_ = _tmp841_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp842_);
								} else {
									ValaMethod* _tmp843_;
									_tmp843_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp843_);
								}
								_tmp844_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp845_ = _tmp844_;
								_tmp846_ = _vala_code_node_ref0 (_tmp845_);
								_vala_code_node_unref0 (member);
								member = _tmp846_;
							} else {
								ValaMethod* _tmp847_;
								ValaMethod* _tmp848_;
								ValaMethod* _tmp849_;
								_tmp847_ = m;
								_tmp848_ = vala_method_get_base_interface_method (_tmp847_);
								_tmp849_ = _tmp848_;
								if (_tmp849_ != NULL) {
									ValaMethod* _tmp850_;
									ValaMethod* _tmp851_;
									ValaMethod* _tmp852_;
									ValaMethod* _tmp853_;
									ValaMethod* _tmp854_;
									ValaSignal* _tmp855_;
									ValaSignal* _tmp856_;
									ValaSymbol* _tmp861_;
									ValaSymbol* _tmp862_;
									ValaSymbol* _tmp863_;
									_tmp850_ = m;
									_tmp851_ = vala_method_get_base_interface_method (_tmp850_);
									_tmp852_ = _tmp851_;
									_tmp853_ = _vala_code_node_ref0 (_tmp852_);
									_vala_code_node_unref0 (m);
									m = _tmp853_;
									_tmp854_ = m;
									_tmp855_ = vala_method_get_signal_reference (_tmp854_);
									_tmp856_ = _tmp855_;
									if (_tmp856_ != NULL) {
										ValaMethod* _tmp857_;
										ValaSignal* _tmp858_;
										ValaSignal* _tmp859_;
										_tmp857_ = m;
										_tmp858_ = vala_method_get_signal_reference (_tmp857_);
										_tmp859_ = _tmp858_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp859_);
									} else {
										ValaMethod* _tmp860_;
										_tmp860_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp860_);
									}
									_tmp861_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp862_ = _tmp861_;
									_tmp863_ = _vala_code_node_ref0 (_tmp862_);
									_vala_code_node_unref0 (member);
									member = _tmp863_;
								}
							}
						}
						_tmp864_ = m;
						_tmp865_ = vala_symbol_get_access ((ValaSymbol*) _tmp864_);
						_tmp866_ = _tmp865_;
						access = _tmp866_;
						_tmp867_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp867_)) {
							ValaMethod* _tmp868_;
							ValaMemberBinding _tmp869_;
							ValaMemberBinding _tmp870_;
							_tmp868_ = m;
							_tmp869_ = vala_method_get_binding (_tmp868_);
							_tmp870_ = _tmp869_;
							instance = _tmp870_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp871_ = m;
						_tmp872_ = vala_method_get_binding (_tmp871_);
						_tmp873_ = _tmp872_;
						klass = _tmp873_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp874_;
							ValaList* _tmp875_;
							gint _param_size = 0;
							ValaList* _tmp876_;
							gint _tmp877_;
							gint _tmp878_;
							gint _param_index = 0;
							_tmp874_ = m;
							_tmp875_ = vala_callable_get_parameters ((ValaCallable*) _tmp874_);
							_param_list = _tmp875_;
							_tmp876_ = _param_list;
							_tmp877_ = vala_collection_get_size ((ValaCollection*) _tmp876_);
							_tmp878_ = _tmp877_;
							_param_size = _tmp878_;
							_param_index = -1;
							while (TRUE) {
								ValaParameter* param = NULL;
								ValaList* _tmp879_;
								gpointer _tmp880_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp881_;
								ValaDataType* _tmp882_;
								ValaDataType* _tmp883_;
								ValaGenericType* _tmp884_;
								gboolean _tmp885_ = FALSE;
								ValaGenericType* _tmp886_;
								_param_index = _param_index + 1;
								if (!(_param_index < _param_size)) {
									break;
								}
								_tmp879_ = _param_list;
								_tmp880_ = vala_list_get (_tmp879_, _param_index);
								param = (ValaParameter*) _tmp880_;
								_tmp881_ = param;
								_tmp882_ = vala_variable_get_variable_type ((ValaVariable*) _tmp881_);
								_tmp883_ = _tmp882_;
								_tmp884_ = _vala_code_node_ref0 (VALA_IS_GENERIC_TYPE (_tmp883_) ? ((ValaGenericType*) _tmp883_) : NULL);
								generic_type = _tmp884_;
								_tmp886_ = generic_type;
								if (_tmp886_ != NULL) {
									ValaGenericType* _tmp887_;
									ValaTypeParameter* _tmp888_;
									ValaTypeParameter* _tmp889_;
									ValaSymbol* _tmp890_;
									ValaSymbol* _tmp891_;
									_tmp887_ = generic_type;
									_tmp888_ = vala_generic_type_get_type_parameter (_tmp887_);
									_tmp889_ = _tmp888_;
									_tmp890_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp889_);
									_tmp891_ = _tmp890_;
									_tmp885_ = VALA_IS_TYPESYMBOL (_tmp891_);
								} else {
									_tmp885_ = FALSE;
								}
								if (_tmp885_) {
									generics = TRUE;
									_vala_code_node_unref0 (generic_type);
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (generic_type);
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp892_ = m;
						_tmp893_ = vala_callable_get_return_type ((ValaCallable*) _tmp892_);
						_tmp894_ = _tmp893_;
						_tmp895_ = _vala_code_node_ref0 (VALA_IS_GENERIC_TYPE (_tmp894_) ? ((ValaGenericType*) _tmp894_) : NULL);
						generic_type = _tmp895_;
						_tmp897_ = generic_type;
						if (_tmp897_ != NULL) {
							ValaGenericType* _tmp898_;
							ValaTypeParameter* _tmp899_;
							ValaTypeParameter* _tmp900_;
							ValaSymbol* _tmp901_;
							ValaSymbol* _tmp902_;
							_tmp898_ = generic_type;
							_tmp899_ = vala_generic_type_get_type_parameter (_tmp898_);
							_tmp900_ = _tmp899_;
							_tmp901_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp900_);
							_tmp902_ = _tmp901_;
							_tmp896_ = VALA_IS_TYPESYMBOL (_tmp902_);
						} else {
							_tmp896_ = FALSE;
						}
						if (_tmp896_) {
							generics = TRUE;
						}
						_vala_code_node_unref0 (generic_type);
						_vala_code_node_unref0 (m);
					} else {
						ValaSymbol* _tmp903_;
						_tmp903_ = member;
						if (VALA_IS_PROPERTY (_tmp903_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp904_;
							ValaProperty* _tmp905_;
							ValaProperty* _tmp906_;
							ValaProperty* _tmp907_;
							ValaProperty* _tmp908_;
							ValaProperty* _tmp909_;
							ValaProperty* _tmp929_;
							ValaSymbolAccessibility _tmp930_;
							ValaSymbolAccessibility _tmp931_;
							gboolean _tmp932_;
							gboolean _tmp933_;
							ValaProperty* _tmp998_;
							ValaMemberBinding _tmp999_;
							ValaMemberBinding _tmp1000_;
							ValaProperty* _tmp1001_;
							ValaDataType* _tmp1002_;
							ValaDataType* _tmp1003_;
							_tmp904_ = member;
							_tmp905_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp904_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp905_;
							_tmp906_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp906_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								_vala_code_node_unref0 (prop);
								_vala_code_node_unref0 (member);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp907_ = prop;
							_tmp908_ = vala_property_get_base_property (_tmp907_);
							_tmp909_ = _tmp908_;
							if (_tmp909_ != NULL) {
								ValaProperty* _tmp910_;
								ValaProperty* _tmp911_;
								ValaProperty* _tmp912_;
								ValaProperty* _tmp913_;
								ValaProperty* _tmp914_;
								ValaSymbol* _tmp915_;
								ValaSymbol* _tmp916_;
								ValaSymbol* _tmp917_;
								_tmp910_ = prop;
								_tmp911_ = vala_property_get_base_property (_tmp910_);
								_tmp912_ = _tmp911_;
								_tmp913_ = _vala_code_node_ref0 (_tmp912_);
								_vala_code_node_unref0 (prop);
								prop = _tmp913_;
								_tmp914_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp914_);
								_tmp915_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp916_ = _tmp915_;
								_tmp917_ = _vala_code_node_ref0 (_tmp916_);
								_vala_code_node_unref0 (member);
								member = _tmp917_;
							} else {
								ValaProperty* _tmp918_;
								ValaProperty* _tmp919_;
								ValaProperty* _tmp920_;
								_tmp918_ = prop;
								_tmp919_ = vala_property_get_base_interface_property (_tmp918_);
								_tmp920_ = _tmp919_;
								if (_tmp920_ != NULL) {
									ValaProperty* _tmp921_;
									ValaProperty* _tmp922_;
									ValaProperty* _tmp923_;
									ValaProperty* _tmp924_;
									ValaProperty* _tmp925_;
									ValaSymbol* _tmp926_;
									ValaSymbol* _tmp927_;
									ValaSymbol* _tmp928_;
									_tmp921_ = prop;
									_tmp922_ = vala_property_get_base_interface_property (_tmp921_);
									_tmp923_ = _tmp922_;
									_tmp924_ = _vala_code_node_ref0 (_tmp923_);
									_vala_code_node_unref0 (prop);
									prop = _tmp924_;
									_tmp925_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp925_);
									_tmp926_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp927_ = _tmp926_;
									_tmp928_ = _vala_code_node_ref0 (_tmp927_);
									_vala_code_node_unref0 (member);
									member = _tmp928_;
								}
							}
							_tmp929_ = prop;
							_tmp930_ = vala_symbol_get_access ((ValaSymbol*) _tmp929_);
							_tmp931_ = _tmp930_;
							access = _tmp931_;
							_tmp932_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp933_ = _tmp932_;
							if (_tmp933_) {
								ValaProperty* _tmp934_;
								ValaPropertyAccessor* _tmp935_;
								ValaPropertyAccessor* _tmp936_;
								ValaProperty* _tmp944_;
								ValaSymbolAccessibility _tmp945_;
								ValaSymbolAccessibility _tmp946_;
								_tmp934_ = prop;
								_tmp935_ = vala_property_get_set_accessor (_tmp934_);
								_tmp936_ = _tmp935_;
								if (_tmp936_ == NULL) {
									ValaSourceReference* _tmp937_;
									ValaSourceReference* _tmp938_;
									ValaProperty* _tmp939_;
									gchar* _tmp940_;
									gchar* _tmp941_;
									gchar* _tmp942_;
									gchar* _tmp943_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp937_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp938_ = _tmp937_;
									_tmp939_ = prop;
									_tmp940_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp939_);
									_tmp941_ = _tmp940_;
									_tmp942_ = g_strdup_printf ("Property `%s' is read-only", _tmp941_);
									_tmp943_ = _tmp942_;
									vala_report_error (_tmp938_, _tmp943_);
									_g_free0 (_tmp943_);
									_g_free0 (_tmp941_);
									result = FALSE;
									_vala_code_node_unref0 (prop);
									_vala_code_node_unref0 (member);
									_vala_code_node_unref0 (this_parameter);
									_vala_code_node_unref0 (base_symbol);
									return result;
								}
								_tmp944_ = prop;
								_tmp945_ = vala_symbol_get_access ((ValaSymbol*) _tmp944_);
								_tmp946_ = _tmp945_;
								if (_tmp946_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp947_;
									ValaPropertyAccessor* _tmp948_;
									ValaPropertyAccessor* _tmp949_;
									ValaSymbolAccessibility _tmp950_;
									ValaSymbolAccessibility _tmp951_;
									_tmp947_ = prop;
									_tmp948_ = vala_property_get_set_accessor (_tmp947_);
									_tmp949_ = _tmp948_;
									_tmp950_ = vala_symbol_get_access ((ValaSymbol*) _tmp949_);
									_tmp951_ = _tmp950_;
									access = _tmp951_;
								} else {
									gboolean _tmp952_ = FALSE;
									ValaProperty* _tmp953_;
									ValaSymbolAccessibility _tmp954_;
									ValaSymbolAccessibility _tmp955_;
									_tmp953_ = prop;
									_tmp954_ = vala_symbol_get_access ((ValaSymbol*) _tmp953_);
									_tmp955_ = _tmp954_;
									if (_tmp955_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp956_;
										ValaPropertyAccessor* _tmp957_;
										ValaPropertyAccessor* _tmp958_;
										ValaSymbolAccessibility _tmp959_;
										ValaSymbolAccessibility _tmp960_;
										_tmp956_ = prop;
										_tmp957_ = vala_property_get_set_accessor (_tmp956_);
										_tmp958_ = _tmp957_;
										_tmp959_ = vala_symbol_get_access ((ValaSymbol*) _tmp958_);
										_tmp960_ = _tmp959_;
										_tmp952_ = _tmp960_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp952_ = FALSE;
									}
									if (_tmp952_) {
										ValaProperty* _tmp961_;
										ValaPropertyAccessor* _tmp962_;
										ValaPropertyAccessor* _tmp963_;
										ValaSymbolAccessibility _tmp964_;
										ValaSymbolAccessibility _tmp965_;
										_tmp961_ = prop;
										_tmp962_ = vala_property_get_set_accessor (_tmp961_);
										_tmp963_ = _tmp962_;
										_tmp964_ = vala_symbol_get_access ((ValaSymbol*) _tmp963_);
										_tmp965_ = _tmp964_;
										access = _tmp965_;
									}
								}
							} else {
								ValaProperty* _tmp966_;
								ValaPropertyAccessor* _tmp967_;
								ValaPropertyAccessor* _tmp968_;
								ValaProperty* _tmp976_;
								ValaSymbolAccessibility _tmp977_;
								ValaSymbolAccessibility _tmp978_;
								_tmp966_ = prop;
								_tmp967_ = vala_property_get_get_accessor (_tmp966_);
								_tmp968_ = _tmp967_;
								if (_tmp968_ == NULL) {
									ValaSourceReference* _tmp969_;
									ValaSourceReference* _tmp970_;
									ValaProperty* _tmp971_;
									gchar* _tmp972_;
									gchar* _tmp973_;
									gchar* _tmp974_;
									gchar* _tmp975_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp969_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp970_ = _tmp969_;
									_tmp971_ = prop;
									_tmp972_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp971_);
									_tmp973_ = _tmp972_;
									_tmp974_ = g_strdup_printf ("Property `%s' is write-only", _tmp973_);
									_tmp975_ = _tmp974_;
									vala_report_error (_tmp970_, _tmp975_);
									_g_free0 (_tmp975_);
									_g_free0 (_tmp973_);
									result = FALSE;
									_vala_code_node_unref0 (prop);
									_vala_code_node_unref0 (member);
									_vala_code_node_unref0 (this_parameter);
									_vala_code_node_unref0 (base_symbol);
									return result;
								}
								_tmp976_ = prop;
								_tmp977_ = vala_symbol_get_access ((ValaSymbol*) _tmp976_);
								_tmp978_ = _tmp977_;
								if (_tmp978_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp979_;
									ValaPropertyAccessor* _tmp980_;
									ValaPropertyAccessor* _tmp981_;
									ValaSymbolAccessibility _tmp982_;
									ValaSymbolAccessibility _tmp983_;
									_tmp979_ = prop;
									_tmp980_ = vala_property_get_get_accessor (_tmp979_);
									_tmp981_ = _tmp980_;
									_tmp982_ = vala_symbol_get_access ((ValaSymbol*) _tmp981_);
									_tmp983_ = _tmp982_;
									access = _tmp983_;
								} else {
									gboolean _tmp984_ = FALSE;
									ValaProperty* _tmp985_;
									ValaSymbolAccessibility _tmp986_;
									ValaSymbolAccessibility _tmp987_;
									_tmp985_ = prop;
									_tmp986_ = vala_symbol_get_access ((ValaSymbol*) _tmp985_);
									_tmp987_ = _tmp986_;
									if (_tmp987_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp988_;
										ValaPropertyAccessor* _tmp989_;
										ValaPropertyAccessor* _tmp990_;
										ValaSymbolAccessibility _tmp991_;
										ValaSymbolAccessibility _tmp992_;
										_tmp988_ = prop;
										_tmp989_ = vala_property_get_get_accessor (_tmp988_);
										_tmp990_ = _tmp989_;
										_tmp991_ = vala_symbol_get_access ((ValaSymbol*) _tmp990_);
										_tmp992_ = _tmp991_;
										_tmp984_ = _tmp992_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp984_ = FALSE;
									}
									if (_tmp984_) {
										ValaProperty* _tmp993_;
										ValaPropertyAccessor* _tmp994_;
										ValaPropertyAccessor* _tmp995_;
										ValaSymbolAccessibility _tmp996_;
										ValaSymbolAccessibility _tmp997_;
										_tmp993_ = prop;
										_tmp994_ = vala_property_get_get_accessor (_tmp993_);
										_tmp995_ = _tmp994_;
										_tmp996_ = vala_symbol_get_access ((ValaSymbol*) _tmp995_);
										_tmp997_ = _tmp996_;
										access = _tmp997_;
									}
								}
							}
							_tmp998_ = prop;
							_tmp999_ = vala_property_get_binding (_tmp998_);
							_tmp1000_ = _tmp999_;
							instance = _tmp1000_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1001_ = prop;
							_tmp1002_ = vala_property_get_property_type (_tmp1001_);
							_tmp1003_ = _tmp1002_;
							if (VALA_IS_GENERIC_TYPE (_tmp1003_)) {
								generics = TRUE;
							}
							_vala_code_node_unref0 (prop);
						} else {
							ValaSymbol* _tmp1004_;
							_tmp1004_ = member;
							if (VALA_IS_SIGNAL (_tmp1004_)) {
								ValaSymbol* _tmp1005_;
								ValaSymbolAccessibility _tmp1006_;
								ValaSymbolAccessibility _tmp1007_;
								instance = TRUE;
								_tmp1005_ = member;
								_tmp1006_ = vala_symbol_get_access (_tmp1005_);
								_tmp1007_ = _tmp1006_;
								access = _tmp1007_;
							} else {
								gboolean _tmp1008_ = FALSE;
								gboolean _tmp1009_;
								_tmp1009_ = self->priv->_creation_member;
								if (!_tmp1009_) {
									ValaSymbol* _tmp1010_;
									_tmp1010_ = member;
									_tmp1008_ = VALA_IS_ERROR_CODE (_tmp1010_);
								} else {
									_tmp1008_ = FALSE;
								}
								if (_tmp1008_) {
									ValaSymbol* _tmp1011_;
									ValaConstant* _tmp1012_;
									ValaConstant* _tmp1013_;
									ValaSymbol* _tmp1014_;
									ValaSymbol* _tmp1015_;
									ValaSymbol* _tmp1016_;
									_tmp1011_ = member;
									_tmp1012_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1011_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1013_ = _tmp1012_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1013_);
									_tmp1014_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1015_ = _tmp1014_;
									_tmp1016_ = _vala_code_node_ref0 (_tmp1015_);
									_vala_code_node_unref0 (member);
									member = _tmp1016_;
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp1017_ = member;
	vala_symbol_set_used (_tmp1017_, TRUE);
	_tmp1018_ = member;
	_tmp1019_ = vala_symbol_get_version (_tmp1018_);
	_tmp1020_ = _tmp1019_;
	_tmp1021_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1022_ = _tmp1021_;
	vala_version_attribute_check (_tmp1020_, _tmp1022_);
	_tmp1024_ = access;
	if (_tmp1024_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1025_;
		ValaSymbol* _tmp1026_;
		ValaSymbol* _tmp1027_;
		_tmp1025_ = member;
		_tmp1026_ = vala_symbol_get_parent_symbol (_tmp1025_);
		_tmp1027_ = _tmp1026_;
		_tmp1023_ = VALA_IS_TYPESYMBOL (_tmp1027_);
	} else {
		_tmp1023_ = FALSE;
	}
	if (_tmp1023_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1028_;
		ValaSymbol* _tmp1029_;
		ValaSymbol* _tmp1030_;
		ValaTypeSymbol* _tmp1031_;
		gboolean in_subtype = FALSE;
		_tmp1028_ = member;
		_tmp1029_ = vala_symbol_get_parent_symbol (_tmp1028_);
		_tmp1030_ = _tmp1029_;
		_tmp1031_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1030_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
		target_type = _tmp1031_;
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1032_;
			ValaSemanticAnalyzer* _tmp1033_;
			ValaSymbol* _tmp1034_;
			ValaSymbol* _tmp1035_;
			ValaSymbol* _tmp1036_;
			_tmp1032_ = vala_code_context_get_analyzer (context);
			_tmp1033_ = _tmp1032_;
			_tmp1034_ = vala_semantic_analyzer_get_current_symbol (_tmp1033_);
			_tmp1035_ = _tmp1034_;
			_tmp1036_ = _vala_code_node_ref0 (_tmp1035_);
			this_symbol = _tmp1036_;
			{
				gboolean _tmp1037_ = FALSE;
				_tmp1037_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1042_;
					ValaSymbol* _tmp1043_;
					ValaTypeSymbol* _tmp1044_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1045_;
					ValaClass* _tmp1046_;
					gboolean _tmp1047_ = FALSE;
					ValaClass* _tmp1048_;
					if (!_tmp1037_) {
						ValaSymbol* _tmp1038_;
						ValaSymbol* _tmp1039_;
						ValaSymbol* _tmp1040_;
						ValaSymbol* _tmp1041_;
						_tmp1038_ = this_symbol;
						_tmp1039_ = vala_symbol_get_parent_symbol (_tmp1038_);
						_tmp1040_ = _tmp1039_;
						_tmp1041_ = _vala_code_node_ref0 (_tmp1040_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1041_;
					}
					_tmp1037_ = FALSE;
					_tmp1042_ = this_symbol;
					if (!(_tmp1042_ != NULL)) {
						break;
					}
					_tmp1043_ = this_symbol;
					_tmp1044_ = target_type;
					if (_tmp1043_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1044_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1045_ = this_symbol;
					_tmp1046_ = _vala_code_node_ref0 (VALA_IS_CLASS (_tmp1045_) ? ((ValaClass*) _tmp1045_) : NULL);
					cl = _tmp1046_;
					_tmp1048_ = cl;
					if (_tmp1048_ != NULL) {
						ValaClass* _tmp1049_;
						ValaTypeSymbol* _tmp1050_;
						_tmp1049_ = cl;
						_tmp1050_ = target_type;
						_tmp1047_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1049_, _tmp1050_);
					} else {
						_tmp1047_ = FALSE;
					}
					if (_tmp1047_) {
						in_subtype = TRUE;
						_vala_code_node_unref0 (cl);
						break;
					}
					_vala_code_node_unref0 (cl);
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1051_;
			ValaSourceReference* _tmp1052_;
			ValaSymbol* _tmp1053_;
			gchar* _tmp1054_;
			gchar* _tmp1055_;
			gchar* _tmp1056_;
			gchar* _tmp1057_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1051_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1052_ = _tmp1051_;
			_tmp1053_ = member;
			_tmp1054_ = vala_symbol_get_full_name (_tmp1053_);
			_tmp1055_ = _tmp1054_;
			_tmp1056_ = g_strdup_printf ("Access to protected member `%s' denied", _tmp1055_);
			_tmp1057_ = _tmp1056_;
			vala_report_error (_tmp1052_, _tmp1057_);
			_g_free0 (_tmp1057_);
			_g_free0 (_tmp1055_);
			result = FALSE;
			_vala_code_node_unref0 (target_type);
			_vala_code_node_unref0 (member);
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
		_vala_code_node_unref0 (target_type);
	} else {
		ValaSymbolAccessibility _tmp1058_;
		_tmp1058_ = access;
		if (_tmp1058_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1059_;
			ValaSymbol* _tmp1060_;
			ValaSymbol* _tmp1061_;
			ValaSymbol* _tmp1062_;
			gboolean in_target_type = FALSE;
			_tmp1059_ = member;
			_tmp1060_ = vala_symbol_get_parent_symbol (_tmp1059_);
			_tmp1061_ = _tmp1060_;
			_tmp1062_ = _vala_code_node_ref0 (_tmp1061_);
			target_type = _tmp1062_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1063_;
				ValaSemanticAnalyzer* _tmp1064_;
				ValaSymbol* _tmp1065_;
				ValaSymbol* _tmp1066_;
				ValaSymbol* _tmp1067_;
				_tmp1063_ = vala_code_context_get_analyzer (context);
				_tmp1064_ = _tmp1063_;
				_tmp1065_ = vala_semantic_analyzer_get_current_symbol (_tmp1064_);
				_tmp1066_ = _tmp1065_;
				_tmp1067_ = _vala_code_node_ref0 (_tmp1066_);
				this_symbol = _tmp1067_;
				{
					gboolean _tmp1068_ = FALSE;
					_tmp1068_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1073_;
						ValaSymbol* _tmp1074_;
						ValaSymbol* _tmp1075_;
						if (!_tmp1068_) {
							ValaSymbol* _tmp1069_;
							ValaSymbol* _tmp1070_;
							ValaSymbol* _tmp1071_;
							ValaSymbol* _tmp1072_;
							_tmp1069_ = this_symbol;
							_tmp1070_ = vala_symbol_get_parent_symbol (_tmp1069_);
							_tmp1071_ = _tmp1070_;
							_tmp1072_ = _vala_code_node_ref0 (_tmp1071_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1072_;
						}
						_tmp1068_ = FALSE;
						_tmp1073_ = this_symbol;
						if (!(_tmp1073_ != NULL)) {
							break;
						}
						_tmp1074_ = target_type;
						_tmp1075_ = this_symbol;
						if (_tmp1074_ == _tmp1075_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1076_;
				ValaSourceReference* _tmp1077_;
				ValaSymbol* _tmp1078_;
				gchar* _tmp1079_;
				gchar* _tmp1080_;
				gchar* _tmp1081_;
				gchar* _tmp1082_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1076_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1077_ = _tmp1076_;
				_tmp1078_ = member;
				_tmp1079_ = vala_symbol_get_full_name (_tmp1078_);
				_tmp1080_ = _tmp1079_;
				_tmp1081_ = g_strdup_printf ("Access to private member `%s' denied", _tmp1080_);
				_tmp1082_ = _tmp1081_;
				vala_report_error (_tmp1077_, _tmp1082_);
				_g_free0 (_tmp1082_);
				_g_free0 (_tmp1080_);
				result = FALSE;
				_vala_code_node_unref0 (target_type);
				_vala_code_node_unref0 (member);
				_vala_code_node_unref0 (this_parameter);
				_vala_code_node_unref0 (base_symbol);
				return result;
			}
			_vala_code_node_unref0 (target_type);
		}
	}
	if (generics) {
		ValaExpression* _tmp1084_;
		ValaExpression* _tmp1085_;
		_tmp1084_ = vala_member_access_get_inner (self);
		_tmp1085_ = _tmp1084_;
		_tmp1083_ = _tmp1085_ != NULL;
	} else {
		_tmp1083_ = FALSE;
	}
	if (_tmp1083_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1086_;
		ValaExpression* _tmp1087_;
		ValaDataType* _tmp1088_;
		ValaDataType* _tmp1089_;
		ValaDataType* _tmp1090_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1091_;
		ValaExpression* _tmp1092_;
		ValaDataType* _tmp1093_;
		ValaDataType* _tmp1094_;
		ValaPointerType* _tmp1095_;
		ValaPointerType* _tmp1096_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1101_;
		ValaObjectType* _tmp1102_;
		gboolean _tmp1103_ = FALSE;
		gboolean _tmp1104_ = FALSE;
		ValaObjectType* _tmp1105_;
		_tmp1086_ = vala_member_access_get_inner (self);
		_tmp1087_ = _tmp1086_;
		_tmp1088_ = vala_expression_get_value_type (_tmp1087_);
		_tmp1089_ = _tmp1088_;
		_tmp1090_ = _vala_code_node_ref0 (_tmp1089_);
		instance_type = _tmp1090_;
		_tmp1091_ = vala_member_access_get_inner (self);
		_tmp1092_ = _tmp1091_;
		_tmp1093_ = vala_expression_get_value_type (_tmp1092_);
		_tmp1094_ = _tmp1093_;
		_tmp1095_ = _vala_code_node_ref0 (VALA_IS_POINTER_TYPE (_tmp1094_) ? ((ValaPointerType*) _tmp1094_) : NULL);
		pointer_type = _tmp1095_;
		_tmp1096_ = pointer_type;
		if (_tmp1096_ != NULL) {
			ValaPointerType* _tmp1097_;
			ValaDataType* _tmp1098_;
			ValaDataType* _tmp1099_;
			ValaDataType* _tmp1100_;
			_tmp1097_ = pointer_type;
			_tmp1098_ = vala_pointer_type_get_base_type (_tmp1097_);
			_tmp1099_ = _tmp1098_;
			_tmp1100_ = _vala_code_node_ref0 (_tmp1099_);
			_vala_code_node_unref0 (instance_type);
			instance_type = _tmp1100_;
		}
		_tmp1101_ = instance_type;
		_tmp1102_ = _vala_code_node_ref0 (VALA_IS_OBJECT_TYPE (_tmp1101_) ? ((ValaObjectType*) _tmp1101_) : NULL);
		object_type = _tmp1102_;
		_tmp1105_ = object_type;
		if (_tmp1105_ != NULL) {
			ValaObjectType* _tmp1106_;
			ValaObjectTypeSymbol* _tmp1107_;
			ValaObjectTypeSymbol* _tmp1108_;
			_tmp1106_ = object_type;
			_tmp1107_ = vala_object_type_get_type_symbol (_tmp1106_);
			_tmp1108_ = _tmp1107_;
			_tmp1104_ = vala_object_type_symbol_has_type_parameters (_tmp1108_);
		} else {
			_tmp1104_ = FALSE;
		}
		if (_tmp1104_) {
			ValaDataType* _tmp1109_;
			_tmp1109_ = instance_type;
			_tmp1103_ = !vala_data_type_has_type_arguments (_tmp1109_);
		} else {
			_tmp1103_ = FALSE;
		}
		if (_tmp1103_) {
			ValaExpression* _tmp1110_;
			ValaExpression* _tmp1111_;
			ValaSourceReference* _tmp1112_;
			ValaSourceReference* _tmp1113_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1110_ = vala_member_access_get_inner (self);
			_tmp1111_ = _tmp1110_;
			_tmp1112_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1111_);
			_tmp1113_ = _tmp1112_;
			vala_report_error (_tmp1113_, "missing generic type arguments");
			result = FALSE;
			_vala_code_node_unref0 (object_type);
			_vala_code_node_unref0 (pointer_type);
			_vala_code_node_unref0 (instance_type);
			_vala_code_node_unref0 (member);
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
		_vala_code_node_unref0 (object_type);
		_vala_code_node_unref0 (pointer_type);
		_vala_code_node_unref0 (instance_type);
	}
	if (instance) {
		_tmp1115_ = !may_access_instance_members;
	} else {
		_tmp1115_ = FALSE;
	}
	if (_tmp1115_) {
		_tmp1114_ = TRUE;
	} else {
		gboolean _tmp1116_ = FALSE;
		if (klass) {
			_tmp1116_ = !may_access_klass_members;
		} else {
			_tmp1116_ = FALSE;
		}
		_tmp1114_ = _tmp1116_;
	}
	if (_tmp1114_) {
		ValaSymbol* _tmp1117_;
		ValaSymbol* _tmp1118_;
		ValaDataType* _tmp1141_;
		ValaDataType* _tmp1142_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1117_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1118_ = _tmp1117_;
		if (VALA_IS_METHOD (_tmp1118_)) {
			ValaSemanticAnalyzer* _tmp1119_;
			ValaSemanticAnalyzer* _tmp1120_;
			ValaSymbol* _tmp1121_;
			ValaSymbol* _tmp1122_;
			gboolean _tmp1123_;
			gboolean _tmp1124_;
			ValaDataType* _tmp1125_;
			ValaDataType* _tmp1126_;
			_tmp1119_ = vala_code_context_get_analyzer (context);
			_tmp1120_ = _tmp1119_;
			_tmp1121_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1122_ = _tmp1121_;
			_tmp1123_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1124_ = _tmp1123_;
			_tmp1125_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1120_, _tmp1122_, _tmp1124_);
			_tmp1126_ = _tmp1125_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1126_);
			_vala_code_node_unref0 (_tmp1126_);
		} else {
			ValaSymbol* _tmp1127_;
			ValaSymbol* _tmp1128_;
			_tmp1127_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1128_ = _tmp1127_;
			if (VALA_IS_FIELD (_tmp1128_)) {
				ValaSymbol* _tmp1129_;
				ValaSymbol* _tmp1130_;
				ValaFieldPrototype* _tmp1131_;
				ValaFieldPrototype* _tmp1132_;
				_tmp1129_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1130_ = _tmp1129_;
				_tmp1131_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1130_, VALA_TYPE_FIELD, ValaField));
				_tmp1132_ = _tmp1131_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1132_);
				_vala_code_node_unref0 (_tmp1132_);
			} else {
				ValaSymbol* _tmp1133_;
				ValaSymbol* _tmp1134_;
				_tmp1133_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1134_ = _tmp1133_;
				if (VALA_IS_PROPERTY (_tmp1134_)) {
					ValaSymbol* _tmp1135_;
					ValaSymbol* _tmp1136_;
					ValaPropertyPrototype* _tmp1137_;
					ValaPropertyPrototype* _tmp1138_;
					_tmp1135_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1136_ = _tmp1135_;
					_tmp1137_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1136_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1138_ = _tmp1137_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1138_);
					_vala_code_node_unref0 (_tmp1138_);
				} else {
					ValaInvalidType* _tmp1139_;
					ValaInvalidType* _tmp1140_;
					_tmp1139_ = vala_invalid_type_new ();
					_tmp1140_ = _tmp1139_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1140_);
					_vala_code_node_unref0 (_tmp1140_);
				}
			}
		}
		_tmp1141_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1142_ = _tmp1141_;
		if (_tmp1142_ != NULL) {
			ValaDataType* _tmp1143_;
			ValaDataType* _tmp1144_;
			ValaDataType* _tmp1145_;
			ValaDataType* _tmp1146_;
			gboolean _tmp1147_;
			gboolean _tmp1148_;
			_tmp1143_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1144_ = _tmp1143_;
			_tmp1145_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1146_ = _tmp1145_;
			_tmp1147_ = vala_data_type_get_value_owned (_tmp1146_);
			_tmp1148_ = _tmp1147_;
			vala_data_type_set_value_owned (_tmp1144_, _tmp1148_);
		}
	} else {
		gboolean _tmp1149_ = FALSE;
		gboolean _tmp1170_ = FALSE;
		gboolean _tmp1171_ = FALSE;
		gboolean _tmp1172_ = FALSE;
		gboolean _tmp1173_ = FALSE;
		gboolean _tmp1190_ = FALSE;
		gboolean _tmp1191_ = FALSE;
		gboolean _tmp1192_ = FALSE;
		gboolean _tmp1193_ = FALSE;
		gboolean _tmp1194_ = FALSE;
		gboolean _tmp1195_;
		gboolean _tmp1196_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1223_;
		ValaSymbol* _tmp1224_;
		ValaMethod* _tmp1225_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1226_;
		ValaExpression* _tmp1227_;
		ValaMemberAccess* _tmp1228_;
		gboolean _tmp1229_ = FALSE;
		gboolean _tmp1230_ = FALSE;
		gboolean _tmp1231_ = FALSE;
		gboolean _tmp1232_ = FALSE;
		gboolean _tmp1233_ = FALSE;
		ValaMethod* _tmp1234_;
		ValaSemanticAnalyzer* _tmp1271_;
		ValaSemanticAnalyzer* _tmp1272_;
		ValaSymbol* _tmp1273_;
		ValaSymbol* _tmp1274_;
		gboolean _tmp1275_;
		gboolean _tmp1276_;
		ValaDataType* _tmp1277_;
		ValaDataType* _tmp1278_;
		gboolean _tmp1279_ = FALSE;
		ValaExpression* _tmp1280_;
		ValaExpression* _tmp1281_;
		ValaSymbol* _tmp1294_;
		ValaSymbol* _tmp1295_;
		if (instance) {
			ValaExpression* _tmp1150_;
			ValaExpression* _tmp1151_;
			_tmp1150_ = vala_member_access_get_inner (self);
			_tmp1151_ = _tmp1150_;
			_tmp1149_ = _tmp1151_ == NULL;
		} else {
			_tmp1149_ = FALSE;
		}
		if (_tmp1149_) {
			ValaSourceReference* _tmp1152_;
			ValaSourceReference* _tmp1153_;
			ValaMemberAccess* _tmp1154_;
			ValaMemberAccess* _tmp1155_;
			ValaExpression* _tmp1156_;
			ValaExpression* _tmp1157_;
			ValaParameter* _tmp1158_;
			ValaDataType* _tmp1159_;
			ValaDataType* _tmp1160_;
			ValaDataType* _tmp1161_;
			ValaDataType* _tmp1162_;
			ValaExpression* _tmp1163_;
			ValaExpression* _tmp1164_;
			ValaDataType* _tmp1165_;
			ValaDataType* _tmp1166_;
			ValaExpression* _tmp1167_;
			ValaExpression* _tmp1168_;
			ValaParameter* _tmp1169_;
			_tmp1152_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1153_ = _tmp1152_;
			_tmp1154_ = vala_member_access_new (NULL, "this", _tmp1153_);
			_tmp1155_ = _tmp1154_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1155_);
			_vala_code_node_unref0 (_tmp1155_);
			_tmp1156_ = vala_member_access_get_inner (self);
			_tmp1157_ = _tmp1156_;
			_tmp1158_ = this_parameter;
			_tmp1159_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1158_);
			_tmp1160_ = _tmp1159_;
			_tmp1161_ = vala_data_type_copy (_tmp1160_);
			_tmp1162_ = _tmp1161_;
			vala_expression_set_value_type (_tmp1157_, _tmp1162_);
			_vala_code_node_unref0 (_tmp1162_);
			_tmp1163_ = vala_member_access_get_inner (self);
			_tmp1164_ = _tmp1163_;
			_tmp1165_ = vala_expression_get_value_type (_tmp1164_);
			_tmp1166_ = _tmp1165_;
			vala_data_type_set_value_owned (_tmp1166_, FALSE);
			_tmp1167_ = vala_member_access_get_inner (self);
			_tmp1168_ = _tmp1167_;
			_tmp1169_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1168_, (ValaSymbol*) _tmp1169_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1173_ = !klass;
		} else {
			_tmp1173_ = FALSE;
		}
		if (_tmp1173_) {
			ValaSymbol* _tmp1174_;
			ValaSymbol* _tmp1175_;
			_tmp1174_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1175_ = _tmp1174_;
			_tmp1172_ = !VALA_IS_CREATION_METHOD (_tmp1175_);
		} else {
			_tmp1172_ = FALSE;
		}
		if (_tmp1172_) {
			_tmp1171_ = may_access_instance_members;
		} else {
			_tmp1171_ = FALSE;
		}
		if (_tmp1171_) {
			ValaExpression* _tmp1176_;
			ValaExpression* _tmp1177_;
			_tmp1176_ = vala_member_access_get_inner (self);
			_tmp1177_ = _tmp1176_;
			_tmp1170_ = _tmp1177_ != NULL;
		} else {
			_tmp1170_ = FALSE;
		}
		if (_tmp1170_) {
			ValaExpression* _tmp1178_;
			ValaExpression* _tmp1179_;
			ValaSymbol* _tmp1180_;
			ValaSymbol* _tmp1181_;
			_tmp1178_ = vala_member_access_get_inner (self);
			_tmp1179_ = _tmp1178_;
			_tmp1180_ = vala_expression_get_symbol_reference (_tmp1179_);
			_tmp1181_ = _tmp1180_;
			if (VALA_IS_METHOD (_tmp1181_)) {
			} else {
				ValaSourceReference* _tmp1182_;
				ValaSourceReference* _tmp1183_;
				ValaSymbol* _tmp1184_;
				ValaSymbol* _tmp1185_;
				gchar* _tmp1186_;
				gchar* _tmp1187_;
				gchar* _tmp1188_;
				gchar* _tmp1189_;
				_tmp1182_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1183_ = _tmp1182_;
				_tmp1184_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1185_ = _tmp1184_;
				_tmp1186_ = vala_symbol_get_full_name (_tmp1185_);
				_tmp1187_ = _tmp1186_;
				_tmp1188_ = g_strdup_printf ("Access to static member `%s' with an instance reference", _tmp1187_);
				_tmp1189_ = _tmp1188_;
				vala_report_warning (_tmp1183_, _tmp1189_);
				_g_free0 (_tmp1189_);
				_g_free0 (_tmp1187_);
			}
		}
		_tmp1195_ = vala_code_context_get_experimental_non_null (context);
		_tmp1196_ = _tmp1195_;
		if (_tmp1196_) {
			_tmp1194_ = instance;
		} else {
			_tmp1194_ = FALSE;
		}
		if (_tmp1194_) {
			ValaExpression* _tmp1197_;
			ValaExpression* _tmp1198_;
			ValaDataType* _tmp1199_;
			ValaDataType* _tmp1200_;
			gboolean _tmp1201_;
			gboolean _tmp1202_;
			_tmp1197_ = vala_member_access_get_inner (self);
			_tmp1198_ = _tmp1197_;
			_tmp1199_ = vala_expression_get_value_type (_tmp1198_);
			_tmp1200_ = _tmp1199_;
			_tmp1201_ = vala_data_type_get_nullable (_tmp1200_);
			_tmp1202_ = _tmp1201_;
			_tmp1193_ = _tmp1202_;
		} else {
			_tmp1193_ = FALSE;
		}
		if (_tmp1193_) {
			ValaExpression* _tmp1203_;
			ValaExpression* _tmp1204_;
			ValaDataType* _tmp1205_;
			ValaDataType* _tmp1206_;
			_tmp1203_ = vala_member_access_get_inner (self);
			_tmp1204_ = _tmp1203_;
			_tmp1205_ = vala_expression_get_value_type (_tmp1204_);
			_tmp1206_ = _tmp1205_;
			_tmp1192_ = !VALA_IS_POINTER_TYPE (_tmp1206_);
		} else {
			_tmp1192_ = FALSE;
		}
		if (_tmp1192_) {
			ValaExpression* _tmp1207_;
			ValaExpression* _tmp1208_;
			ValaDataType* _tmp1209_;
			ValaDataType* _tmp1210_;
			_tmp1207_ = vala_member_access_get_inner (self);
			_tmp1208_ = _tmp1207_;
			_tmp1209_ = vala_expression_get_value_type (_tmp1208_);
			_tmp1210_ = _tmp1209_;
			_tmp1191_ = !VALA_IS_GENERIC_TYPE (_tmp1210_);
		} else {
			_tmp1191_ = FALSE;
		}
		if (_tmp1191_) {
			ValaExpression* _tmp1211_;
			ValaExpression* _tmp1212_;
			ValaDataType* _tmp1213_;
			ValaDataType* _tmp1214_;
			_tmp1211_ = vala_member_access_get_inner (self);
			_tmp1212_ = _tmp1211_;
			_tmp1213_ = vala_expression_get_value_type (_tmp1212_);
			_tmp1214_ = _tmp1213_;
			_tmp1190_ = !VALA_IS_ARRAY_TYPE (_tmp1214_);
		} else {
			_tmp1190_ = FALSE;
		}
		if (_tmp1190_) {
			ValaSourceReference* _tmp1215_;
			ValaSourceReference* _tmp1216_;
			ValaSymbol* _tmp1217_;
			ValaSymbol* _tmp1218_;
			gchar* _tmp1219_;
			gchar* _tmp1220_;
			gchar* _tmp1221_;
			gchar* _tmp1222_;
			_tmp1215_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1216_ = _tmp1215_;
			_tmp1217_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1218_ = _tmp1217_;
			_tmp1219_ = vala_symbol_get_full_name (_tmp1218_);
			_tmp1220_ = _tmp1219_;
			_tmp1221_ = g_strdup_printf ("Access to instance member `%s' from nullable reference denied", _tmp1220_);
			_tmp1222_ = _tmp1221_;
			vala_report_error (_tmp1216_, _tmp1222_);
			_g_free0 (_tmp1222_);
			_g_free0 (_tmp1220_);
		}
		_tmp1223_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1224_ = _tmp1223_;
		_tmp1225_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp1224_) ? ((ValaMethod*) _tmp1224_) : NULL);
		m = _tmp1225_;
		_tmp1226_ = vala_member_access_get_inner (self);
		_tmp1227_ = _tmp1226_;
		_tmp1228_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp1227_) ? ((ValaMemberAccess*) _tmp1227_) : NULL);
		inner_ma = _tmp1228_;
		_tmp1234_ = m;
		if (_tmp1234_ != NULL) {
			ValaMethod* _tmp1235_;
			ValaMemberBinding _tmp1236_;
			ValaMemberBinding _tmp1237_;
			_tmp1235_ = m;
			_tmp1236_ = vala_method_get_binding (_tmp1235_);
			_tmp1237_ = _tmp1236_;
			_tmp1233_ = _tmp1237_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1233_ = FALSE;
		}
		if (_tmp1233_) {
			ValaMethod* _tmp1238_;
			ValaSymbol* _tmp1239_;
			ValaSymbol* _tmp1240_;
			_tmp1238_ = m;
			_tmp1239_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1238_);
			_tmp1240_ = _tmp1239_;
			_tmp1232_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1240_);
		} else {
			_tmp1232_ = FALSE;
		}
		if (_tmp1232_) {
			ValaExpression* _tmp1241_;
			ValaExpression* _tmp1242_;
			_tmp1241_ = vala_member_access_get_inner (self);
			_tmp1242_ = _tmp1241_;
			_tmp1231_ = _tmp1242_ != NULL;
		} else {
			_tmp1231_ = FALSE;
		}
		if (_tmp1231_) {
			ValaExpression* _tmp1243_;
			ValaExpression* _tmp1244_;
			ValaDataType* _tmp1245_;
			ValaDataType* _tmp1246_;
			_tmp1243_ = vala_member_access_get_inner (self);
			_tmp1244_ = _tmp1243_;
			_tmp1245_ = vala_expression_get_value_type (_tmp1244_);
			_tmp1246_ = _tmp1245_;
			_tmp1230_ = _tmp1246_ == NULL;
		} else {
			_tmp1230_ = FALSE;
		}
		if (_tmp1230_) {
			ValaMemberAccess* _tmp1247_;
			ValaList* _tmp1248_;
			gint _tmp1249_;
			gint _tmp1250_;
			_tmp1247_ = inner_ma;
			_tmp1248_ = _tmp1247_->priv->type_argument_list;
			_tmp1249_ = vala_collection_get_size ((ValaCollection*) _tmp1248_);
			_tmp1250_ = _tmp1249_;
			_tmp1229_ = _tmp1250_ > 0;
		} else {
			_tmp1229_ = FALSE;
		}
		if (_tmp1229_) {
			ValaExpression* _tmp1251_;
			ValaExpression* _tmp1252_;
			ValaMethod* _tmp1253_;
			ValaSymbol* _tmp1254_;
			ValaSymbol* _tmp1255_;
			ValaObjectType* _tmp1256_;
			ValaObjectType* _tmp1257_;
			_tmp1251_ = vala_member_access_get_inner (self);
			_tmp1252_ = _tmp1251_;
			_tmp1253_ = m;
			_tmp1254_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1253_);
			_tmp1255_ = _tmp1254_;
			_tmp1256_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1255_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1257_ = _tmp1256_;
			vala_expression_set_value_type (_tmp1252_, (ValaDataType*) _tmp1257_);
			_vala_code_node_unref0 (_tmp1257_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1258_;
				ValaList* _tmp1259_;
				ValaList* _tmp1260_;
				gint _type_argument_size = 0;
				ValaList* _tmp1261_;
				gint _tmp1262_;
				gint _tmp1263_;
				gint _type_argument_index = 0;
				_tmp1258_ = inner_ma;
				_tmp1259_ = _tmp1258_->priv->type_argument_list;
				_tmp1260_ = _vala_iterable_ref0 (_tmp1259_);
				_type_argument_list = _tmp1260_;
				_tmp1261_ = _type_argument_list;
				_tmp1262_ = vala_collection_get_size ((ValaCollection*) _tmp1261_);
				_tmp1263_ = _tmp1262_;
				_type_argument_size = _tmp1263_;
				_type_argument_index = -1;
				while (TRUE) {
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1264_;
					gpointer _tmp1265_;
					ValaExpression* _tmp1266_;
					ValaExpression* _tmp1267_;
					ValaDataType* _tmp1268_;
					ValaDataType* _tmp1269_;
					ValaDataType* _tmp1270_;
					_type_argument_index = _type_argument_index + 1;
					if (!(_type_argument_index < _type_argument_size)) {
						break;
					}
					_tmp1264_ = _type_argument_list;
					_tmp1265_ = vala_list_get (_tmp1264_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1265_;
					_tmp1266_ = vala_member_access_get_inner (self);
					_tmp1267_ = _tmp1266_;
					_tmp1268_ = vala_expression_get_value_type (_tmp1267_);
					_tmp1269_ = _tmp1268_;
					_tmp1270_ = type_argument;
					vala_data_type_add_type_argument (_tmp1269_, _tmp1270_);
					_vala_code_node_unref0 (type_argument);
				}
				_vala_iterable_unref0 (_type_argument_list);
			}
		}
		_tmp1271_ = vala_code_context_get_analyzer (context);
		_tmp1272_ = _tmp1271_;
		_tmp1273_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1274_ = _tmp1273_;
		_tmp1275_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1276_ = _tmp1275_;
		_tmp1277_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1272_, _tmp1274_, _tmp1276_);
		_tmp1278_ = _tmp1277_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1278_);
		_vala_code_node_unref0 (_tmp1278_);
		_tmp1280_ = vala_member_access_get_inner (self);
		_tmp1281_ = _tmp1280_;
		if (_tmp1281_ != NULL) {
			ValaDataType* _tmp1282_;
			ValaDataType* _tmp1283_;
			_tmp1282_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1283_ = _tmp1282_;
			_tmp1279_ = _tmp1283_ != NULL;
		} else {
			_tmp1279_ = FALSE;
		}
		if (_tmp1279_) {
			ValaDataType* _tmp1284_;
			ValaDataType* _tmp1285_;
			ValaExpression* _tmp1286_;
			ValaExpression* _tmp1287_;
			ValaDataType* _tmp1288_;
			ValaDataType* _tmp1289_;
			ValaDataType* _tmp1290_;
			ValaDataType* _tmp1291_;
			_tmp1284_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1285_ = _tmp1284_;
			_tmp1286_ = vala_member_access_get_inner (self);
			_tmp1287_ = _tmp1286_;
			_tmp1288_ = vala_expression_get_value_type (_tmp1287_);
			_tmp1289_ = _tmp1288_;
			_tmp1290_ = vala_data_type_get_actual_type (_tmp1285_, _tmp1289_, NULL, (ValaCodeNode*) self);
			_tmp1291_ = _tmp1290_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1291_);
			_vala_code_node_unref0 (_tmp1291_);
		} else {
			ValaDataType* _tmp1292_;
			ValaDataType* _tmp1293_;
			_tmp1292_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1293_ = _tmp1292_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1293_);
		}
		_tmp1294_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1295_ = _tmp1294_;
		if (VALA_IS_METHOD (_tmp1295_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1296_;
			ValaSymbol* _tmp1297_;
			ValaMethod* _tmp1298_;
			ValaDataType* _tmp1299_;
			ValaDataType* _tmp1300_;
			gboolean _tmp1307_ = FALSE;
			_tmp1296_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1297_ = _tmp1296_;
			_tmp1298_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1297_, VALA_TYPE_METHOD, ValaMethod));
			method = _tmp1298_;
			_tmp1299_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1300_ = _tmp1299_;
			if (_tmp1300_ != NULL) {
				ValaDataType* _tmp1301_;
				ValaDataType* _tmp1302_;
				ValaDataType* _tmp1303_;
				ValaDataType* _tmp1304_;
				gboolean _tmp1305_;
				gboolean _tmp1306_;
				_tmp1301_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1302_ = _tmp1301_;
				_tmp1303_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1304_ = _tmp1303_;
				_tmp1305_ = vala_data_type_get_value_owned (_tmp1304_);
				_tmp1306_ = _tmp1305_;
				vala_data_type_set_value_owned (_tmp1302_, _tmp1306_);
			}
			if (instance) {
				ValaMethod* _tmp1308_;
				ValaSymbol* _tmp1309_;
				ValaSymbol* _tmp1310_;
				_tmp1308_ = method;
				_tmp1309_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1308_);
				_tmp1310_ = _tmp1309_;
				_tmp1307_ = VALA_IS_TYPESYMBOL (_tmp1310_);
			} else {
				_tmp1307_ = FALSE;
			}
			if (_tmp1307_) {
				ValaExpression* _tmp1311_;
				ValaExpression* _tmp1312_;
				ValaMethod* _tmp1313_;
				ValaSymbol* _tmp1314_;
				ValaSymbol* _tmp1315_;
				ValaDataType* _tmp1316_;
				ValaDataType* _tmp1317_;
				ValaExpression* _tmp1318_;
				ValaExpression* _tmp1319_;
				ValaDataType* _tmp1320_;
				ValaDataType* _tmp1321_;
				ValaMethod* _tmp1322_;
				ValaParameter* _tmp1323_;
				ValaParameter* _tmp1324_;
				ValaDataType* _tmp1325_;
				ValaDataType* _tmp1326_;
				gboolean _tmp1327_;
				gboolean _tmp1328_;
				_tmp1311_ = vala_member_access_get_inner (self);
				_tmp1312_ = _tmp1311_;
				_tmp1313_ = method;
				_tmp1314_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1313_);
				_tmp1315_ = _tmp1314_;
				_tmp1316_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1315_);
				_tmp1317_ = _tmp1316_;
				vala_expression_set_target_type (_tmp1312_, _tmp1317_);
				_vala_code_node_unref0 (_tmp1317_);
				_tmp1318_ = vala_member_access_get_inner (self);
				_tmp1319_ = _tmp1318_;
				_tmp1320_ = vala_expression_get_target_type (_tmp1319_);
				_tmp1321_ = _tmp1320_;
				_tmp1322_ = method;
				_tmp1323_ = vala_method_get_this_parameter (_tmp1322_);
				_tmp1324_ = _tmp1323_;
				_tmp1325_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1324_);
				_tmp1326_ = _tmp1325_;
				_tmp1327_ = vala_data_type_get_value_owned (_tmp1326_);
				_tmp1328_ = _tmp1327_;
				vala_data_type_set_value_owned (_tmp1321_, _tmp1328_);
			}
			_vala_code_node_unref0 (method);
		} else {
			ValaSymbol* _tmp1329_;
			ValaSymbol* _tmp1330_;
			_tmp1329_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1330_ = _tmp1329_;
			if (VALA_IS_PROPERTY (_tmp1330_)) {
				ValaProperty* prop = NULL;
				ValaSymbol* _tmp1331_;
				ValaSymbol* _tmp1332_;
				ValaProperty* _tmp1333_;
				gboolean _tmp1334_ = FALSE;
				_tmp1331_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1332_ = _tmp1331_;
				_tmp1333_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1332_, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp1333_;
				if (instance) {
					ValaProperty* _tmp1335_;
					ValaSymbol* _tmp1336_;
					ValaSymbol* _tmp1337_;
					_tmp1335_ = prop;
					_tmp1336_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1335_);
					_tmp1337_ = _tmp1336_;
					_tmp1334_ = _tmp1337_ != NULL;
				} else {
					_tmp1334_ = FALSE;
				}
				if (_tmp1334_) {
					ValaExpression* _tmp1338_;
					ValaExpression* _tmp1339_;
					ValaProperty* _tmp1340_;
					ValaSymbol* _tmp1341_;
					ValaSymbol* _tmp1342_;
					ValaDataType* _tmp1343_;
					ValaDataType* _tmp1344_;
					_tmp1338_ = vala_member_access_get_inner (self);
					_tmp1339_ = _tmp1338_;
					_tmp1340_ = prop;
					_tmp1341_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1340_);
					_tmp1342_ = _tmp1341_;
					_tmp1343_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1342_);
					_tmp1344_ = _tmp1343_;
					vala_expression_set_target_type (_tmp1339_, _tmp1344_);
					_vala_code_node_unref0 (_tmp1344_);
				}
				_vala_code_node_unref0 (prop);
			} else {
				gboolean _tmp1345_ = FALSE;
				gboolean _tmp1346_ = FALSE;
				gboolean _tmp1347_ = FALSE;
				ValaSymbol* _tmp1348_;
				ValaSymbol* _tmp1349_;
				_tmp1348_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1349_ = _tmp1348_;
				if (VALA_IS_FIELD (_tmp1349_)) {
					_tmp1347_ = TRUE;
				} else {
					ValaSymbol* _tmp1350_;
					ValaSymbol* _tmp1351_;
					_tmp1350_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1351_ = _tmp1350_;
					_tmp1347_ = VALA_IS_SIGNAL (_tmp1351_);
				}
				if (_tmp1347_) {
					_tmp1346_ = instance;
				} else {
					_tmp1346_ = FALSE;
				}
				if (_tmp1346_) {
					ValaSymbol* _tmp1352_;
					ValaSymbol* _tmp1353_;
					ValaSymbol* _tmp1354_;
					ValaSymbol* _tmp1355_;
					_tmp1352_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1353_ = _tmp1352_;
					_tmp1354_ = vala_symbol_get_parent_symbol (_tmp1353_);
					_tmp1355_ = _tmp1354_;
					_tmp1345_ = _tmp1355_ != NULL;
				} else {
					_tmp1345_ = FALSE;
				}
				if (_tmp1345_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1356_;
					ValaSymbol* _tmp1357_;
					ValaSymbol* _tmp1358_;
					ValaSymbol* _tmp1359_;
					ValaDataType* _tmp1360_;
					ValaExpression* _tmp1361_;
					ValaExpression* _tmp1362_;
					ValaDataType* _tmp1363_;
					ValaExpression* _tmp1364_;
					ValaExpression* _tmp1365_;
					ValaDataType* _tmp1366_;
					ValaDataType* _tmp1367_;
					ValaDataType* _tmp1368_;
					ValaDataType* _tmp1369_;
					_tmp1356_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1357_ = _tmp1356_;
					_tmp1358_ = vala_symbol_get_parent_symbol (_tmp1357_);
					_tmp1359_ = _tmp1358_;
					_tmp1360_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1359_);
					parent_type = _tmp1360_;
					_tmp1361_ = vala_member_access_get_inner (self);
					_tmp1362_ = _tmp1361_;
					_tmp1363_ = parent_type;
					_tmp1364_ = vala_member_access_get_inner (self);
					_tmp1365_ = _tmp1364_;
					_tmp1366_ = vala_expression_get_value_type (_tmp1365_);
					_tmp1367_ = _tmp1366_;
					_tmp1368_ = vala_data_type_get_actual_type (_tmp1363_, _tmp1367_, NULL, (ValaCodeNode*) self);
					_tmp1369_ = _tmp1368_;
					vala_expression_set_target_type (_tmp1362_, _tmp1369_);
					_vala_code_node_unref0 (_tmp1369_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
		_vala_code_node_unref0 (inner_ma);
		_vala_code_node_unref0 (m);
	}
	_tmp1370_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1371_ = _tmp1370_;
	if (_tmp1371_ != NULL) {
		ValaDataType* _tmp1372_;
		ValaDataType* _tmp1373_;
		_tmp1372_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1373_ = _tmp1372_;
		vala_code_node_check ((ValaCodeNode*) _tmp1373_, context);
	}
	_tmp1374_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1375_ = _tmp1374_;
	result = !_tmp1375_;
	_vala_code_node_unref0 (member);
	_vala_code_node_unref0 (this_parameter);
	_vala_code_node_unref0 (base_symbol);
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp56_;
	ValaExpression* _tmp57_;
	ValaMemberAccess* _tmp58_;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_ = FALSE;
	ValaMemberAccess* _tmp61_;
	gboolean _tmp69_ = FALSE;
	gboolean _tmp70_ = FALSE;
	gboolean _tmp71_ = FALSE;
	gboolean _tmp72_ = FALSE;
	gboolean _tmp91_ = FALSE;
	ValaSymbol* _tmp92_;
	ValaSymbol* _tmp93_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		gboolean _tmp46_ = FALSE;
		ValaCodeContext* _tmp47_;
		ValaCodeContext* _tmp48_;
		ValaProfile _tmp49_;
		ValaProfile _tmp50_;
		gboolean _tmp51_;
		_tmp47_ = vala_code_context_get ();
		_tmp48_ = _tmp47_;
		_tmp49_ = vala_code_context_get_profile (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = _tmp50_ == VALA_PROFILE_GOBJECT;
		_vala_code_context_unref0 (_tmp48_);
		if (_tmp51_) {
			ValaExpression* _tmp52_;
			ValaExpression* _tmp53_;
			ValaDataType* _tmp54_;
			ValaDataType* _tmp55_;
			_tmp52_ = vala_member_access_get_inner (self);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_expression_get_value_type (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp46_ = VALA_IS_ARRAY_TYPE (_tmp55_);
		} else {
			_tmp46_ = FALSE;
		}
		_tmp34_ = _tmp46_;
	}
	struct_or_array = _tmp34_;
	_tmp56_ = vala_member_access_get_inner (self);
	_tmp57_ = _tmp56_;
	_tmp58_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp57_) ? ((ValaMemberAccess*) _tmp57_) : NULL);
	ma = _tmp58_;
	_tmp61_ = ma;
	if (_tmp61_ == NULL) {
		_tmp60_ = struct_or_array;
	} else {
		_tmp60_ = FALSE;
	}
	if (_tmp60_) {
		ValaExpression* _tmp62_;
		ValaExpression* _tmp63_;
		_tmp62_ = vala_member_access_get_inner (self);
		_tmp63_ = _tmp62_;
		_tmp59_ = VALA_IS_POINTER_INDIRECTION (_tmp63_);
	} else {
		_tmp59_ = FALSE;
	}
	if (_tmp59_) {
		ValaExpression* _tmp64_;
		ValaExpression* _tmp65_;
		ValaExpression* _tmp66_;
		ValaExpression* _tmp67_;
		ValaMemberAccess* _tmp68_;
		_tmp64_ = vala_member_access_get_inner (self);
		_tmp65_ = _tmp64_;
		_tmp66_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp67_ = _tmp66_;
		_tmp68_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp67_) ? ((ValaMemberAccess*) _tmp67_) : NULL);
		_vala_code_node_unref0 (ma);
		ma = _tmp68_;
	}
	if (instance) {
		_tmp72_ = struct_or_array;
	} else {
		_tmp72_ = FALSE;
	}
	if (_tmp72_) {
		gboolean _tmp73_ = FALSE;
		ValaSymbol* _tmp74_;
		ValaSymbol* _tmp75_;
		_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp75_ = _tmp74_;
		if (VALA_IS_METHOD (_tmp75_)) {
			_tmp73_ = TRUE;
		} else {
			gboolean _tmp76_;
			gboolean _tmp77_;
			_tmp76_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp77_ = _tmp76_;
			_tmp73_ = _tmp77_;
		}
		_tmp71_ = _tmp73_;
	} else {
		_tmp71_ = FALSE;
	}
	if (_tmp71_) {
		gboolean _tmp78_ = FALSE;
		gboolean _tmp79_ = FALSE;
		ValaMemberAccess* _tmp80_;
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaSymbol* _tmp82_;
			ValaSymbol* _tmp83_;
			_tmp81_ = ma;
			_tmp82_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp81_);
			_tmp83_ = _tmp82_;
			_tmp79_ = VALA_IS_VARIABLE (_tmp83_);
		} else {
			_tmp79_ = FALSE;
		}
		if (_tmp79_) {
			_tmp78_ = TRUE;
		} else {
			ValaExpression* _tmp84_;
			ValaExpression* _tmp85_;
			_tmp84_ = vala_member_access_get_inner (self);
			_tmp85_ = _tmp84_;
			_tmp78_ = VALA_IS_ELEMENT_ACCESS (_tmp85_);
		}
		_tmp70_ = _tmp78_;
	} else {
		_tmp70_ = FALSE;
	}
	if (_tmp70_) {
		_tmp69_ = !this_access;
	} else {
		_tmp69_ = FALSE;
	}
	if (_tmp69_) {
		ValaExpression* _tmp86_;
		ValaExpression* _tmp87_;
		ValaMemberAccess* _tmp88_;
		_tmp86_ = vala_member_access_get_inner (self);
		_tmp87_ = _tmp86_;
		vala_expression_set_lvalue (_tmp87_, TRUE);
		_tmp88_ = ma;
		if (_tmp88_ != NULL) {
			ValaMemberAccess* _tmp89_;
			ValaMemberAccess* _tmp90_;
			_tmp89_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp89_, TRUE);
			_tmp90_ = ma;
			vala_member_access_check_lvalue_access (_tmp90_);
		}
	}
	_tmp92_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp93_ = _tmp92_;
	if (VALA_IS_METHOD (_tmp93_)) {
		ValaSymbol* _tmp94_;
		ValaSymbol* _tmp95_;
		ValaAttribute* _tmp96_;
		_tmp94_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp95_ = _tmp94_;
		_tmp96_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp95_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp91_ = _tmp96_ != NULL;
	} else {
		_tmp91_ = FALSE;
	}
	if (_tmp91_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp97_;
		ValaSymbol* _tmp98_;
		ValaSymbol* _tmp99_;
		ValaSymbol* _tmp100_;
		gboolean _tmp101_ = FALSE;
		gboolean _tmp102_ = FALSE;
		ValaClass* _tmp103_;
		_tmp97_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp98_ = _tmp97_;
		_tmp99_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp98_, VALA_TYPE_METHOD, ValaMethod));
		_tmp100_ = _tmp99_;
		cl = VALA_IS_CLASS (_tmp100_) ? ((ValaClass*) _tmp100_) : NULL;
		_tmp103_ = cl;
		if (_tmp103_ != NULL) {
			ValaClass* _tmp104_;
			gboolean _tmp105_;
			gboolean _tmp106_;
			_tmp104_ = cl;
			_tmp105_ = vala_class_get_is_compact (_tmp104_);
			_tmp106_ = _tmp105_;
			_tmp102_ = _tmp106_;
		} else {
			_tmp102_ = FALSE;
		}
		if (_tmp102_) {
			ValaMemberAccess* _tmp107_;
			_tmp107_ = ma;
			_tmp101_ = _tmp107_ != NULL;
		} else {
			_tmp101_ = FALSE;
		}
		if (_tmp101_) {
			ValaMemberAccess* _tmp108_;
			ValaMemberAccess* _tmp109_;
			_tmp108_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp108_, TRUE);
			_tmp109_ = ma;
			vala_member_access_check_lvalue_access (_tmp109_);
		}
	}
	_vala_code_node_unref0 (ma);
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaLocalVariable* _tmp6_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaParameter* _tmp9_;
	ValaLocalVariable* _tmp10_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL);
	local = _tmp6_;
	_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = _vala_code_node_ref0 (VALA_IS_PARAMETER (_tmp8_) ? ((ValaParameter*) _tmp8_) : NULL);
	param = _tmp9_;
	_tmp10_ = local;
	if (_tmp10_ != NULL) {
		ValaLocalVariable* _tmp11_;
		_tmp11_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp11_);
	} else {
		gboolean _tmp12_ = FALSE;
		ValaParameter* _tmp13_;
		_tmp13_ = param;
		if (_tmp13_ != NULL) {
			ValaParameter* _tmp14_;
			ValaParameterDirection _tmp15_;
			ValaParameterDirection _tmp16_;
			_tmp14_ = param;
			_tmp15_ = vala_parameter_get_direction (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp12_ = _tmp16_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			ValaParameter* _tmp17_;
			_tmp17_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp17_);
		}
	}
	_vala_code_node_unref0 (param);
	_vala_code_node_unref0 (local);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
		GType vala_member_access_type_id;
		vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
		ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}

