# eloquent/ros-distro-recipe-blacklist.inc
#
# Copyright (c) 2019-2021 LG Electronics, Inc.

PNBLACKLIST[ament-clang-format-native] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'clang', 'clang: depends on clang-format', '', d)}"
PNBLACKLIST[ament-clang-format] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'clang', 'clang: depends on clang-format', '', d)}"
PNBLACKLIST[ament-clang-tidy-native] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'clang', 'clang: depends on clang-tidy', '', d)}"
PNBLACKLIST[ament-clang-tidy] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'clang', 'clang: depends on clang-tidy', '', d)}"
PNBLACKLIST[ament-cmake-clang-format] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'clang', 'clang: depends on ament-clang-format-native->clang-format', '', d)}"
PNBLACKLIST[ament-cmake-clang-tidy] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'clang', 'clang: depends on ament-clang-tidy-native->clang-tidy', '', d)}"
PNBLACKLIST[connext-cmake-module-native] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'connext', 'connext: depends on rti-connext-dds-native which is not available', '', d)}"
PNBLACKLIST[connext-cmake-module] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'connext', 'connext: depends on rti-connext-dds which is not available', '', d)}"
PNBLACKLIST[control-box-rst] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'coinor-libipopt', 'Depends on unavailable ROS_UNRESOLVED_DEP-coinor-libipopt-dev', '', d)}"
PNBLACKLIST[cross-compile] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'docker', 'docker: depends on python3-docker which is available in meta-virtualization', '', d)}"
PNBLACKLIST[desktop] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'python3-matplotlib'], 'qt5: depends on rqt-common-plugins->(rqt-action,rqt-console,rqt-graph,rqt-shell,rqt-plot,rqt-publisher->python-qt-binding->qtbase; python3-matplotlib: depends on rqt-common-plugins->rqt-plot->python3-matplotlib which is not available', '', d)}"
PNBLACKLIST[dolly-gazebo] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'gazebo', 'gazebo: depends on gazebo-ros-pkgs->gazebo-ros->gazebo-rosdev->gazebo which is not available', '', d)}"
PNBLACKLIST[dolly] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'gazebo', 'gazebo: depends on dolly-gazebo->gazebo-ros-pkgs->gazebo-ros->gazebo-rosdev->gazebo which is not available', '', d)}"
PNBLACKLIST[gazebo-plugins] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'gazebo', 'gazebo: depends on gazebo-rosdev->gazebo which is not available', '', d)}"
PNBLACKLIST[gazebo-ros-pkgs] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'gazebo', 'gazebo: depends on gazebo-ros->gazebo-rosdev->gazebo which is not available', '', d)}"
PNBLACKLIST[gazebo-ros] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'gazebo', 'gazebo: depends on gazebo-rosdev->gazebo which is not available', '', d)}"
PNBLACKLIST[gazebo-rosdev] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'gazebo', 'gazebo: depends on gazebo which is not available', '', d)}"
PNBLACKLIST[joint-state-publisher-gui] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on python-qt-binding which depends on qtbase; pyqt5: depends on python-qt-binding which depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[kobuki-ftdi] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'kobuki-ftdi', 'kobuki-ftdi: Not compatible with newer libftdi included in meta-oe: https://github.com/kobuki-base/kobuki_ftdi/issues/3', '', d)}"
PNBLACKLIST[launch-testing-ament-cmake] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'launch', 'launch: depends on launch-testing-native->launch-native', '', d)}"
PNBLACKLIST[launch-testing-native] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'launch', 'launch: depends on launch-native', '', d)}"
PNBLACKLIST[lanelet2-examples] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'lanelet2-traffic-rules', 'lanelet2-traffic-rules: depends on lanelet2-traffic-rules which fails in do_configure', '', d)}"
PNBLACKLIST[lanelet2-io] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'lanelet2-io', 'lanelet2-io: do_configure task fails: ', '', d)}"
PNBLACKLIST[lanelet2-projection] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'lanelet2-io', 'lanelet2-io: depends on lanelet2-io which fails in do_configure', '', d)}"
PNBLACKLIST[lanelet2-python] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'lanelet2-traffic-rules', 'lanelet2-traffic-rules: depends on lanelet2-traffic-rules which fails in do_configure', '', d)}"
PNBLACKLIST[lanelet2-routing] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'lanelet2-traffic-rules', 'lanelet2-traffic-rules: depends on lanelet2-traffic-rules which fails in do_configure', '', d)}"
PNBLACKLIST[lanelet2-traffic-rules] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'lanelet2-traffic-rules', 'lanelet2-traffic-rules: do_configure task fails: ', '', d)}"
PNBLACKLIST[lanelet2-validation] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'lanelet2-traffic-rules', 'lanelet2-traffic-rules: depends on lanelet2-traffic-rules which fails in do_configure', '', d)}"
PNBLACKLIST[lanelet2] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'lanelet2-traffic-rules', 'lanelet2-traffic-rules: depends on lanelet2-traffic-rules which fails in do_configure', '', d)}"
PNBLACKLIST[libg2o] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'opengl', 'opengl: depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[mapviz-plugins] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'x11'], 'Requires libqt-rosdev->qtbase which requires meta-qt5 to be included and depends on mapviz->(freeglut, libxmu, libxi) which require x11; qt-gui-cpp: depends on mapviz which rdepends on rqt-gui-cpp which depends on qt-gui-cpp which requires pyqt5-native for sip', '', d)}"
PNBLACKLIST[mapviz] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'x11'], 'Requires libqt-rosdev->qtbase which requires meta-qt5 to be included and freeglut, libxmu, libxi which require x11; qt-gui-cpp: rdepends on rqt-gui-cpp which depends on qt-gui-cpp which requires pyqt5-native for sip', '', d)}"
PNBLACKLIST[multires-image] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'x11'], 'Requires libqt-rosdev->qtbase which requires meta-qt5 to be included and depends on mapviz->(freeglut, libxmu, libxi) which require x11; qt-gui-cpp: depends on mapviz which rdepends on rqt-gui-cpp which depends on qt-gui-cpp which requires pyqt5-native for sip', '', d)}"
PNBLACKLIST[nav2-rviz-plugins] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'x11'], 'qt5: depends on qtbase; x11: depends on rviz-ogre-vendor->(libx11,libxrandr,libxaw) which require x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[nav2-system-tests] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'gazebo', 'gazebo: depends on gazebo-ros-pkgs->gazebo-ros->gazebo-rosdev->gazebo which is not available', '', d)}"
PNBLACKLIST[octovis] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'qt4', 'qt4: depends on qt4 packages ROS_UNRESOLVED_DEP-libqt4-opengl-dev, ROS_UNRESOLVED_DEP-libqglviewer-qt4-dev, ROS_UNRESOLVED_DEP-libqt4-dev, ROS_UNRESOLVED_DEP-libqt4-opengl, ROS_UNRESOLVED_DEP-libqtgui4', '', d)}"
PNBLACKLIST[opensplice-cmake-module] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'opensplice', 'opensplice: depends on libopensplice69 which is not available', '', d)}"
PNBLACKLIST[packagegroup-ros-turtlebot3-core] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'turtlebot3', 'turtlebot3: rdepends on turtlebot3-bringup,hls-lfcd-lds-driver,turtlebot3-msgs which were not ported to eloquent yet', '', d)}"
PNBLACKLIST[packagegroup-ros-turtlebot3-extended] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'turtlebot3', 'turtlebot3: rdepends on turtlebot3-applications-msgs,turtlebot3-autorace,turtlebot3,slam-karto,turtlebot3-applications which were not ported to eloquent yet', '', d)}"
PNBLACKLIST[plansys2-bringup] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'coin-or', 'coin-or: depends on plansys2-executor which depends on popf->libcbc for which we do not have recipes yet', '', d)}"
PNBLACKLIST[plansys2-executor] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'coin-or', 'coin-or: depends on popf->libcbc for which we do not have recipes yet', '', d)}"
PNBLACKLIST[plansys2-multidomain-example] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'coin-or', 'coin-or: Depends on plansys2-executor->popf->libcbc for which we do not have recipes yet', '', d)}"
PNBLACKLIST[plansys2-patrol-navigation-example] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'coin-or', 'coin-or: Depends on plansys2-executor->popf->libcbc for which we do not have recipes yet', '', d)}"
PNBLACKLIST[plansys2-simple-example] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'coin-or', 'coin-or: Depends on plansys2-executor->popf->libcbc for which we do not have recipes yet', '', d)}"
PNBLACKLIST[plansys2-terminal] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'coin-or', 'coin-or: Depends on plansys2-executor->popf->libcbc for which we do not have recipes yet', '', d)}"
PNBLACKLIST[popf] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'coin-or', 'coin-or: depends on libcbc for which we do not have recipes yet', '', d)}"
PNBLACKLIST[py-trees-js] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on python3-pyqt5; pyqt5: depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[py-trees-ros-tutorials] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on python3-pyqt5; pyqt5: depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[py-trees-ros-viewer] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on python3-pyqt5; pyqt5: depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[python-qt-binding] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on qtbase; pyqt5: depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[qt-dotgraph] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on python-qt-binding->qtbase; pyqt5: depends on python-qt-binding->python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[qt-gui-app] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on qt-gui->qtbase; pyqt5: depends on qt-gui->python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[qt-gui-core] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on qt-dotgraph->python-qt-binding->qtbase; pyqt5: depends on qt-dotgraph->python-qt-binding->python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[qt-gui-cpp] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on qtbase; pyqt5: depends on python-qt-binding->python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[qt-gui-py-common] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on python-qt-bindings->qtbase; pyqt5: depends on python-qt-binding->python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[qt-gui] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on qtbase; pyqt5: depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rmw-connext-cpp] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'connext', 'connext: depends on rti-connext-dds which is not available', '', d)}"
PNBLACKLIST[rmw-connext-shared-cpp] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'connext', 'connext: depends on rti-connext-dds which is not available', '', d)}"
PNBLACKLIST[rmw-opensplice-cpp] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'opensplice', 'opensplice: depends on libopensplice69 which is not available', '', d)}"
PNBLACKLIST[ros-image-turtlebot3-all] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'turtlebot3', 'turtlebot3: Depends on packagegroup-ros-turtlebot3-extended which depends on turtlebot3-autorace, turtlebot3-applications, turtlebot3-applications-msgs, slam-karto which exist in melodic where this packagegroup was originally used, but were never ported to dashing', '', d)}"
PNBLACKLIST[ros-image-turtlebot3-core] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'turtlebot3', 'turtlebot3: Depends on packagegroup-ros-turtlebot3-extended which depends on turtlebot3-autorace, turtlebot3-applications, turtlebot3-applications-msgs, slam-karto which exist in melodic where this packagegroup was originally used, but were never ported to dashing', '', d)}"
PNBLACKLIST[ros-testing] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'launch', 'launch: depends on launch-testing-ament-cmake->launch-testing-native->launch-native', '', d)}"
PNBLACKLIST[ros2test-native] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'launch', 'launch: depends on launch-testing-native->launch-native', '', d)}"
PNBLACKLIST[rosidl-typesupport-connext-c] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'connext', 'connext: depends on (rosidl-typesupport-connext-cpp-native,connext-cmake-module-native)->rti-connext-dds-native which is not available', '', d)}"
PNBLACKLIST[rosidl-typesupport-connext-cpp-native] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'connext', 'connext: depends on rti-connext-dds-native which is not available', '', d)}"
PNBLACKLIST[rosidl-typesupport-connext-cpp] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'connext', 'connext: depends on rti-connext-dds-native which is not available', '', d)}"
PNBLACKLIST[rosidl-typesupport-opensplice-c] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'opensplice', 'opensplice: depends on libopensplice69-native which is not available', '', d)}"
PNBLACKLIST[rosidl-typesupport-opensplice-cpp] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'opensplice', 'opensplice: depends on libopensplice69-native which is not available', '', d)}"
PNBLACKLIST[rqt-action] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on rqt-py-common->qtbase; pyqt5: depends on python-qt-binding->python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-common-plugins] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'python3-matplotlib'], 'qt5: depends on (rqt-action,rqt-console,rqt-graph,rqt-shell,rqt-plot,rqt-publisher->python-qt-binding->qtbase; python3-matplotlib: depends on rqt-plot->python3-matplotlib which is not available', '', d)}"
PNBLACKLIST[rqt-console] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on rqt-py-common->qtbase; pyqt5: depends on python-qt-binding->python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-graph] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on python-qt-binding->qtbase; pyqt5: depends on rqt-gui->python-qt-binding->python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-gui-cpp] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on qtbase; pyqt5: depends on qt-gui-cpp->python-qt-binding->python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-gui-py] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on qt-gui->qtbase; pyqt5: depends on rqt-gui->python-qt-binding->python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-gui] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on python-qt-binding->qtbase; pyqt5: depends on python-qt-binding->python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-image-view] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on qtbase; pyqt5: depends on qt-gui-cpp->python-qt-binding->python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-moveit] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on  python-qt-binding->qtbase; pyqt5: depends on python-qt-binding->python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-msg] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on python-qt-bindings->qtbase; pyqt5: depends on python-qt-binding->python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-plot] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'python3-matplotlib'], 'qt5: depends on (python-qt-binding,rqt-py-common)->qtbase; python3-matplotlib: depends on python3-matplotlib which is not available', '', d)}"
PNBLACKLIST[rqt-publisher] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on rqt-py-common->qtbase; pyqt5: depends on python-qt-binding->python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-py-common] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on qtbase; pyqt5: depends on python-qt-binding->python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-py-console] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on python-qt-bindings->qtbase; pyqt5: depends on python-qt-binding->python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-reconfigure] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on rqt-console->python-qt-binding->qtbase; pyqt5: depends on python-qt-binding->python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-robot-monitor] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: rdepends on rqt-gui,rqt-gui-py,qt-gui-py-common which depends qt-gui which depends on qtbase; pyqt5: rdepends on rqt-gui,rqt-gui-py,qt-gui-py-common which depends on qt-gui which depends on python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-robot-steering] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on python-qt-bindings->qtbase; pyqt5: depends on rqt-gui->python-qt-binding->python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-service-caller] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on rqt-py-common->qtbase; pyqt5: depends on rqt-gui->python-qt-binding->python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-shell] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on python-qt-binding->qtbase; pyqt5: depends on rqt-gui->python-qt-binding->python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-srv] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on rqt-msg->python-qt-bindings->qtbase; pyqt5: depends on rqt-msg->python-qt-binding->python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-tf-tree] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on python-qt-binding->qtbase; pyqt5: depends on qt-dotgraph->python-qt-binding->python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-top] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on python-qt-bindings->qtbase; pyqt5: depends on python-qt-binding->python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt-topic] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on python-qt-bindings->qtbase; pyqt5: depends on python-qt-binding->python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rqt] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'pyqt5'], 'qt5: depends on rqt-gui->python-qt-binding->qtbase; pyqt5: depends on rqt-gui->python-qt-binding->python3-pyqt5 which requires pyqt5', '', d)}"
PNBLACKLIST[rviz-common] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'x11'], 'qt5: depends on qtbase; x11: depends on rviz-ogre-vendor->(libx11,libxrandr,libxaw) which require x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[rviz-default-plugins] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'x11'], 'qt5: depends on qtbase; x11: depends on rviz-ogre-vendor->(libx11,libxrandr,libxaw) which require x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[rviz-ogre-vendor] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['opengl', 'x11'], 'opengl: depends on mesa which is not available because of missing opengl or vulkan in DISTRO_FEATURES; x11: depends on libx11,libxrandr,libxaw which require x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[rviz-rendering-tests] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'x11'], 'qt5: depends on rviz-rendering0>qtbase; x11: depends on rviz-rendering->rviz-ogre-vendor->(libx11,libxrandr,libxaw) which require x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[rviz-rendering] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'x11'], 'qt5: depends on qtbase; x11: depends on rviz-ogre-vendor->(libx11,libxrandr,libxaw) which require x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[rviz-visual-testing-framework] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'x11'], 'qt5: depends on rviz-common->qtbase; x11: depends on rviz-common->rviz-ogre-vendor->(libx11,libxrandr,libxaw) which require x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[rviz2] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'x11'], 'qt5: depends on rviz-common->qtbase; x11: depends on rviz-common->rviz-ogre-vendor->(libx11,libxrandr,libxaw) which require x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[slam-toolbox] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'x11'], 'qt5: depends on qtbase; x11: depends on rviz-common->rviz-ogre-vendor->(libx11,libxrandr,libxaw) which require x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[spatio-temporal-voxel-layer] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'openvdb-openexr', 'openvdb-openexr: Depends on openvdb and openexr for which we do not have recipes yet', '', d)}"
PNBLACKLIST[swri-console] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'qt5-widgets'], 'qt5: depends on qtbase; qt5-widgets: needs widgets enabled in qtbase PACKAGECONFIG', '', d)}"
PNBLACKLIST[tile-map] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'x11'], 'Requires libqt-rosdev->qtbase which requires meta-qt5 to be included and depends on mapviz->(freeglut, libxmu, libxi) which require x11; qt-gui-cpp: depends on mapviz which rdepends on rqt-gui-cpp which depends on qt-gui-cpp which requires pyqt5-native for sip', '', d)}"
PNBLACKLIST[tracetools-read] ?= "${@bb.utils.contains('ROS_WORLD_SKIP_GROUPS', 'babeltrace-python', 'babeltrace-python: rdepends on ROS_UNRESOLVED_DEP-python3-babeltrace and python bindings in babeltrace are not enabled as shown in log.do_configure - configure: You may configure with --enable-python-bindings if you want Python bindings.', '', d)}"
PNBLACKLIST[turtlebot3-bringup] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'x11'], 'qt5: rdepends on rviz2 which depends on rviz-common->qtbase; x11: rdepends on rviz2 which depends on rviz-common->rviz-ogre-vendor->(libx11,libxrandr,libxaw) which require x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[turtlebot3] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'x11'], 'qt5: rdepends on turtlebot3-bringup which rdepends on rviz2 which depends on rviz-common->qtbase; x11: rdepends on turtlebot3-bringup which rdepends on rviz2 which depends on rviz-common->rviz-ogre-vendor->(libx11,libxrandr,libxaw) which require x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[turtlesim] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'qt5-widgets'], 'qt5: depends on qtbase; qt5-widgets: needs widgets enabled in qtbase PACKAGECONFIG', '', d)}"
PNBLACKLIST[webots-ros2-demos] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'x11'], 'qt5: rdepends on webots-ros2-universal-robot which rdepends on rviz2 which depends on rviz-common->qtbase; x11: rdepends on webots-ros2-universal-robot which rdepends on rviz2 which depends on rviz-common->rviz-ogre-vendor->(libx11,libxrandr,libxaw) which require x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[webots-ros2-epuck] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'x11'], 'qt5: rdepends on rviz2 which depends on rviz-common->qtbase; x11: rdepends on rviz2 which depends on rviz-common->rviz-ogre-vendor->(libx11,libxrandr,libxaw) which require x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[webots-ros2-tiago] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'x11'], 'qt5: rdepends on rviz2 which depends on rviz-common->qtbase; x11: rdepends on rviz2 which depends on rviz-common->rviz-ogre-vendor->(libx11,libxrandr,libxaw) which require x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[webots-ros2-universal-robot] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'x11'], 'qt5: rdepends on rviz2 which depends on rviz-common->qtbase; x11: rdepends on rviz2 which depends on rviz-common->rviz-ogre-vendor->(libx11,libxrandr,libxaw) which require x11 in DISTRO_FEATURES', '', d)}"
PNBLACKLIST[webots-ros2] ?= "${@bb.utils.contains_any('ROS_WORLD_SKIP_GROUPS', ['qt5', 'x11'], 'qt5: rdepends on webots-ros2-universal-robot, webots-ros2-epuck, webots-ros2-tiago which rdepend on rviz2 which depends on rviz-common->qtbase; x11: rdepends on webots-ros2-universal-robot, webots-ros2-epuck, webots-ros2-tiago which rdepend on rviz2 which depends on rviz-common->rviz-ogre-vendor->(libx11,libxrandr,libxaw) which require x11 in DISTRO_FEATURES', '', d)}"
