# GRPC GYP build file

# This file has been automatically generated from a template file.
# Please look at the templates directory instead.
# This file can be regenerated from the template by running
# tools/buildgen/generate_projects.sh

# Copyright 2015 gRPC authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

{
  'variables': {
   # The openssl and zlib dependencies must be passed in as variables
   # defined in an included gypi file, usually common.gypi.
   'openssl_gyp_target%': 'Please Define openssl_gyp_target variable',
   'zlib_gyp_target%': 'Please Define zlib_gyp_target variable',

   'grpc_gcov%': 'false',
   'grpc_alpine%': 'false',
  },
  'target_defaults': {
    'configurations': {
      'Release': {
        'cflags': [
          '-O2',
          '-Wframe-larger-than=16384',
        ],
        'defines': [
          'NDEBUG',
        ],
      },
      'Debug': {
        'cflags': [
          '-O0',
        ],
        'defines': [
          '_DEBUG',
          'DEBUG',
        ],
      },
    },
    'cflags': [
      '-g',
      '-Wall',
      '-Wextra',
      '-DOSATOMIC_USE_INLINED=1',
      '-Ithird_party/upb',
      '-Isrc/core/ext/upb-generated',
    ],
    'ldflags': [
      '-g',
    ],
    'cflags_c': [
      '-Werror',
      '-std=c99',
    ],
    'cflags_cc': [
      '-Werror',
      '-std=c++11',
    ],
    'include_dirs': [
      '.',
      '../..',
      'include',
    ],
    'defines': [
      'GRPC_ARES=0',
    ],
    'dependencies': [
      '<(openssl_gyp_target)',
      '<(zlib_gyp_target)',
    ],
    'conditions': [
      ['grpc_gcov=="true"', {
        'cflags': [
          '-O0',
          '-fprofile-arcs',
          '-ftest-coverage',
          '-Wno-return-type',
        ],
        'defines': [
          '_DEBUG',
          'DEBUG',
          'GPR_GCOV',
        ],
        'ldflags': [
          '-fprofile-arcs',
          '-ftest-coverage',
          '-rdynamic',
          '-lstdc++',
        ],
      }],
      ['grpc_alpine=="true"', {
        'defines': [
          'GPR_MUSL_LIBC_COMPAT'
        ]
      }],
      ['OS == "win"', {
        'defines': [
          '_WIN32_WINNT=0x0600',
          'WIN32_LEAN_AND_MEAN',
          '_HAS_EXCEPTIONS=0',
          'UNICODE',
          '_UNICODE',
          'NOMINMAX',
        ],
        'msvs_settings': {
          'VCCLCompilerTool': {
            'RuntimeLibrary': 1, # static debug
          }
        },
        "libraries": [
          "ws2_32"
        ]
      }],
      ['OS == "mac"', {
        'xcode_settings': {
          'OTHER_CFLAGS': [
            '-g',
            '-Wall',
            '-Wextra',
            '-DOSATOMIC_USE_INLINED=1',
            '-Ithird_party/upb',
            '-Isrc/core/ext/upb-generated',
          ],
          'OTHER_CPLUSPLUSFLAGS': [
            '-g',
            '-Wall',
            '-Wextra',
            '-DOSATOMIC_USE_INLINED=1',
            '-Ithird_party/upb',
            '-Isrc/core/ext/upb-generated',
            '-stdlib=libc++',
            '-std=c++11',
            '-Wno-error=deprecated-declarations',
          ],
        },
      }]
    ]
  },
  'targets': [
    {
      'target_name': 'address_sorting',
      'type': 'static_library',
      'dependencies': [
      ],
      'sources': [
        'third_party/address_sorting/address_sorting.c',
        'third_party/address_sorting/address_sorting_posix.c',
        'third_party/address_sorting/address_sorting_windows.c',
      ],
    },
    {
      'target_name': 'alts_test_util',
      'type': 'static_library',
      'dependencies': [
        'grpc',
      ],
      'sources': [
        'test/core/tsi/alts/crypt/gsec_test_util.cc',
        'test/core/tsi/alts/handshaker/alts_handshaker_service_api_test_lib.cc',
      ],
    },
    {
      'target_name': 'cxxabi',
      'type': 'static_library',
      'dependencies': [
      ],
      'sources': [
        'third_party/libcxxabi/src/abort_message.cpp',
        'third_party/libcxxabi/src/cxa_aux_runtime.cpp',
        'third_party/libcxxabi/src/cxa_default_handlers.cpp',
        'third_party/libcxxabi/src/cxa_demangle.cpp',
        'third_party/libcxxabi/src/cxa_exception_storage.cpp',
        'third_party/libcxxabi/src/cxa_guard.cpp',
        'third_party/libcxxabi/src/cxa_handlers.cpp',
        'third_party/libcxxabi/src/cxa_noexception.cpp',
        'third_party/libcxxabi/src/cxa_thread_atexit.cpp',
        'third_party/libcxxabi/src/cxa_unexpected.cpp',
        'third_party/libcxxabi/src/cxa_vector.cpp',
        'third_party/libcxxabi/src/cxa_virtual.cpp',
        'third_party/libcxxabi/src/fallback_malloc.cpp',
        'third_party/libcxxabi/src/private_typeinfo.cpp',
        'third_party/libcxxabi/src/stdlib_exception.cpp',
        'third_party/libcxxabi/src/stdlib_new_delete.cpp',
        'third_party/libcxxabi/src/stdlib_stdexcept.cpp',
        'third_party/libcxxabi/src/stdlib_typeinfo.cpp',
      ],
    },
    {
      'target_name': 'gpr',
      'type': 'static_library',
      'dependencies': [
      ],
      'sources': [
        'src/core/lib/gpr/alloc.cc',
        'src/core/lib/gpr/atm.cc',
        'src/core/lib/gpr/cpu_iphone.cc',
        'src/core/lib/gpr/cpu_linux.cc',
        'src/core/lib/gpr/cpu_posix.cc',
        'src/core/lib/gpr/cpu_windows.cc',
        'src/core/lib/gpr/env_linux.cc',
        'src/core/lib/gpr/env_posix.cc',
        'src/core/lib/gpr/env_windows.cc',
        'src/core/lib/gpr/log.cc',
        'src/core/lib/gpr/log_android.cc',
        'src/core/lib/gpr/log_linux.cc',
        'src/core/lib/gpr/log_posix.cc',
        'src/core/lib/gpr/log_windows.cc',
        'src/core/lib/gpr/mpscq.cc',
        'src/core/lib/gpr/murmur_hash.cc',
        'src/core/lib/gpr/string.cc',
        'src/core/lib/gpr/string_posix.cc',
        'src/core/lib/gpr/string_util_windows.cc',
        'src/core/lib/gpr/string_windows.cc',
        'src/core/lib/gpr/sync.cc',
        'src/core/lib/gpr/sync_posix.cc',
        'src/core/lib/gpr/sync_windows.cc',
        'src/core/lib/gpr/time.cc',
        'src/core/lib/gpr/time_posix.cc',
        'src/core/lib/gpr/time_precise.cc',
        'src/core/lib/gpr/time_windows.cc',
        'src/core/lib/gpr/tls_pthread.cc',
        'src/core/lib/gpr/tmpfile_msys.cc',
        'src/core/lib/gpr/tmpfile_posix.cc',
        'src/core/lib/gpr/tmpfile_windows.cc',
        'src/core/lib/gpr/wrap_memcpy.cc',
        'src/core/lib/gprpp/arena.cc',
        'src/core/lib/gprpp/fork.cc',
        'src/core/lib/gprpp/global_config_env.cc',
        'src/core/lib/gprpp/host_port.cc',
        'src/core/lib/gprpp/thd_posix.cc',
        'src/core/lib/gprpp/thd_windows.cc',
        'src/core/lib/profiling/basic_timers.cc',
        'src/core/lib/profiling/stap_timers.cc',
      ],
    },
    {
      'target_name': 'grpc',
      'type': 'static_library',
      'dependencies': [
        'gpr',
      ],
      'sources': [
        'src/core/lib/surface/init.cc',
        'src/core/lib/avl/avl.cc',
        'src/core/lib/backoff/backoff.cc',
        'src/core/lib/channel/channel_args.cc',
        'src/core/lib/channel/channel_stack.cc',
        'src/core/lib/channel/channel_stack_builder.cc',
        'src/core/lib/channel/channel_trace.cc',
        'src/core/lib/channel/channelz.cc',
        'src/core/lib/channel/channelz_registry.cc',
        'src/core/lib/channel/connected_channel.cc',
        'src/core/lib/channel/handshaker.cc',
        'src/core/lib/channel/handshaker_registry.cc',
        'src/core/lib/channel/status_util.cc',
        'src/core/lib/compression/compression.cc',
        'src/core/lib/compression/compression_args.cc',
        'src/core/lib/compression/compression_internal.cc',
        'src/core/lib/compression/message_compress.cc',
        'src/core/lib/compression/stream_compression.cc',
        'src/core/lib/compression/stream_compression_gzip.cc',
        'src/core/lib/compression/stream_compression_identity.cc',
        'src/core/lib/debug/stats.cc',
        'src/core/lib/debug/stats_data.cc',
        'src/core/lib/http/format_request.cc',
        'src/core/lib/http/httpcli.cc',
        'src/core/lib/http/parser.cc',
        'src/core/lib/iomgr/buffer_list.cc',
        'src/core/lib/iomgr/call_combiner.cc',
        'src/core/lib/iomgr/cfstream_handle.cc',
        'src/core/lib/iomgr/combiner.cc',
        'src/core/lib/iomgr/endpoint.cc',
        'src/core/lib/iomgr/endpoint_cfstream.cc',
        'src/core/lib/iomgr/endpoint_pair_posix.cc',
        'src/core/lib/iomgr/endpoint_pair_uv.cc',
        'src/core/lib/iomgr/endpoint_pair_windows.cc',
        'src/core/lib/iomgr/error.cc',
        'src/core/lib/iomgr/error_cfstream.cc',
        'src/core/lib/iomgr/ev_epoll1_linux.cc',
        'src/core/lib/iomgr/ev_epollex_linux.cc',
        'src/core/lib/iomgr/ev_poll_posix.cc',
        'src/core/lib/iomgr/ev_posix.cc',
        'src/core/lib/iomgr/ev_windows.cc',
        'src/core/lib/iomgr/exec_ctx.cc',
        'src/core/lib/iomgr/executor.cc',
        'src/core/lib/iomgr/executor/mpmcqueue.cc',
        'src/core/lib/iomgr/executor/threadpool.cc',
        'src/core/lib/iomgr/fork_posix.cc',
        'src/core/lib/iomgr/fork_windows.cc',
        'src/core/lib/iomgr/gethostname_fallback.cc',
        'src/core/lib/iomgr/gethostname_host_name_max.cc',
        'src/core/lib/iomgr/gethostname_sysconf.cc',
        'src/core/lib/iomgr/grpc_if_nametoindex_posix.cc',
        'src/core/lib/iomgr/grpc_if_nametoindex_unsupported.cc',
        'src/core/lib/iomgr/internal_errqueue.cc',
        'src/core/lib/iomgr/iocp_windows.cc',
        'src/core/lib/iomgr/iomgr.cc',
        'src/core/lib/iomgr/iomgr_custom.cc',
        'src/core/lib/iomgr/iomgr_internal.cc',
        'src/core/lib/iomgr/iomgr_posix.cc',
        'src/core/lib/iomgr/iomgr_posix_cfstream.cc',
        'src/core/lib/iomgr/iomgr_uv.cc',
        'src/core/lib/iomgr/iomgr_windows.cc',
        'src/core/lib/iomgr/is_epollexclusive_available.cc',
        'src/core/lib/iomgr/load_file.cc',
        'src/core/lib/iomgr/lockfree_event.cc',
        'src/core/lib/iomgr/polling_entity.cc',
        'src/core/lib/iomgr/pollset.cc',
        'src/core/lib/iomgr/pollset_custom.cc',
        'src/core/lib/iomgr/pollset_set.cc',
        'src/core/lib/iomgr/pollset_set_custom.cc',
        'src/core/lib/iomgr/pollset_set_windows.cc',
        'src/core/lib/iomgr/pollset_uv.cc',
        'src/core/lib/iomgr/pollset_windows.cc',
        'src/core/lib/iomgr/resolve_address.cc',
        'src/core/lib/iomgr/resolve_address_custom.cc',
        'src/core/lib/iomgr/resolve_address_posix.cc',
        'src/core/lib/iomgr/resolve_address_windows.cc',
        'src/core/lib/iomgr/resource_quota.cc',
        'src/core/lib/iomgr/sockaddr_utils.cc',
        'src/core/lib/iomgr/socket_factory_posix.cc',
        'src/core/lib/iomgr/socket_mutator.cc',
        'src/core/lib/iomgr/socket_utils_common_posix.cc',
        'src/core/lib/iomgr/socket_utils_linux.cc',
        'src/core/lib/iomgr/socket_utils_posix.cc',
        'src/core/lib/iomgr/socket_utils_uv.cc',
        'src/core/lib/iomgr/socket_utils_windows.cc',
        'src/core/lib/iomgr/socket_windows.cc',
        'src/core/lib/iomgr/tcp_client.cc',
        'src/core/lib/iomgr/tcp_client_cfstream.cc',
        'src/core/lib/iomgr/tcp_client_custom.cc',
        'src/core/lib/iomgr/tcp_client_posix.cc',
        'src/core/lib/iomgr/tcp_client_windows.cc',
        'src/core/lib/iomgr/tcp_custom.cc',
        'src/core/lib/iomgr/tcp_posix.cc',
        'src/core/lib/iomgr/tcp_server.cc',
        'src/core/lib/iomgr/tcp_server_custom.cc',
        'src/core/lib/iomgr/tcp_server_posix.cc',
        'src/core/lib/iomgr/tcp_server_utils_posix_common.cc',
        'src/core/lib/iomgr/tcp_server_utils_posix_ifaddrs.cc',
        'src/core/lib/iomgr/tcp_server_utils_posix_noifaddrs.cc',
        'src/core/lib/iomgr/tcp_server_windows.cc',
        'src/core/lib/iomgr/tcp_uv.cc',
        'src/core/lib/iomgr/tcp_windows.cc',
        'src/core/lib/iomgr/time_averaged_stats.cc',
        'src/core/lib/iomgr/timer.cc',
        'src/core/lib/iomgr/timer_custom.cc',
        'src/core/lib/iomgr/timer_generic.cc',
        'src/core/lib/iomgr/timer_heap.cc',
        'src/core/lib/iomgr/timer_manager.cc',
        'src/core/lib/iomgr/timer_uv.cc',
        'src/core/lib/iomgr/udp_server.cc',
        'src/core/lib/iomgr/unix_sockets_posix.cc',
        'src/core/lib/iomgr/unix_sockets_posix_noop.cc',
        'src/core/lib/iomgr/wakeup_fd_eventfd.cc',
        'src/core/lib/iomgr/wakeup_fd_nospecial.cc',
        'src/core/lib/iomgr/wakeup_fd_pipe.cc',
        'src/core/lib/iomgr/wakeup_fd_posix.cc',
        'src/core/lib/json/json.cc',
        'src/core/lib/json/json_reader.cc',
        'src/core/lib/json/json_string.cc',
        'src/core/lib/json/json_writer.cc',
        'src/core/lib/slice/b64.cc',
        'src/core/lib/slice/percent_encoding.cc',
        'src/core/lib/slice/slice.cc',
        'src/core/lib/slice/slice_buffer.cc',
        'src/core/lib/slice/slice_intern.cc',
        'src/core/lib/slice/slice_string_helpers.cc',
        'src/core/lib/surface/api_trace.cc',
        'src/core/lib/surface/byte_buffer.cc',
        'src/core/lib/surface/byte_buffer_reader.cc',
        'src/core/lib/surface/call.cc',
        'src/core/lib/surface/call_details.cc',
        'src/core/lib/surface/call_log_batch.cc',
        'src/core/lib/surface/channel.cc',
        'src/core/lib/surface/channel_init.cc',
        'src/core/lib/surface/channel_ping.cc',
        'src/core/lib/surface/channel_stack_type.cc',
        'src/core/lib/surface/completion_queue.cc',
        'src/core/lib/surface/completion_queue_factory.cc',
        'src/core/lib/surface/event_string.cc',
        'src/core/lib/surface/lame_client.cc',
        'src/core/lib/surface/metadata_array.cc',
        'src/core/lib/surface/server.cc',
        'src/core/lib/surface/validate_metadata.cc',
        'src/core/lib/surface/version.cc',
        'src/core/lib/transport/bdp_estimator.cc',
        'src/core/lib/transport/byte_stream.cc',
        'src/core/lib/transport/connectivity_state.cc',
        'src/core/lib/transport/error_utils.cc',
        'src/core/lib/transport/metadata.cc',
        'src/core/lib/transport/metadata_batch.cc',
        'src/core/lib/transport/pid_controller.cc',
        'src/core/lib/transport/static_metadata.cc',
        'src/core/lib/transport/status_conversion.cc',
        'src/core/lib/transport/status_metadata.cc',
        'src/core/lib/transport/timeout_encoding.cc',
        'src/core/lib/transport/transport.cc',
        'src/core/lib/transport/transport_op_string.cc',
        'src/core/lib/uri/uri_parser.cc',
        'src/core/lib/debug/trace.cc',
        'src/core/ext/transport/chttp2/server/secure/server_secure_chttp2.cc',
        'src/core/ext/transport/chttp2/transport/bin_decoder.cc',
        'src/core/ext/transport/chttp2/transport/bin_encoder.cc',
        'src/core/ext/transport/chttp2/transport/chttp2_plugin.cc',
        'src/core/ext/transport/chttp2/transport/chttp2_transport.cc',
        'src/core/ext/transport/chttp2/transport/context_list.cc',
        'src/core/ext/transport/chttp2/transport/flow_control.cc',
        'src/core/ext/transport/chttp2/transport/frame_data.cc',
        'src/core/ext/transport/chttp2/transport/frame_goaway.cc',
        'src/core/ext/transport/chttp2/transport/frame_ping.cc',
        'src/core/ext/transport/chttp2/transport/frame_rst_stream.cc',
        'src/core/ext/transport/chttp2/transport/frame_settings.cc',
        'src/core/ext/transport/chttp2/transport/frame_window_update.cc',
        'src/core/ext/transport/chttp2/transport/hpack_encoder.cc',
        'src/core/ext/transport/chttp2/transport/hpack_parser.cc',
        'src/core/ext/transport/chttp2/transport/hpack_table.cc',
        'src/core/ext/transport/chttp2/transport/http2_settings.cc',
        'src/core/ext/transport/chttp2/transport/huffsyms.cc',
        'src/core/ext/transport/chttp2/transport/incoming_metadata.cc',
        'src/core/ext/transport/chttp2/transport/parsing.cc',
        'src/core/ext/transport/chttp2/transport/stream_lists.cc',
        'src/core/ext/transport/chttp2/transport/stream_map.cc',
        'src/core/ext/transport/chttp2/transport/varint.cc',
        'src/core/ext/transport/chttp2/transport/writing.cc',
        'src/core/ext/transport/chttp2/alpn/alpn.cc',
        'src/core/ext/filters/http/client/http_client_filter.cc',
        'src/core/ext/filters/http/http_filters_plugin.cc',
        'src/core/ext/filters/http/message_compress/message_compress_filter.cc',
        'src/core/ext/filters/http/server/http_server_filter.cc',
        'src/core/lib/http/httpcli_security_connector.cc',
        'src/core/lib/security/context/security_context.cc',
        'src/core/lib/security/credentials/alts/alts_credentials.cc',
        'src/core/lib/security/credentials/composite/composite_credentials.cc',
        'src/core/lib/security/credentials/credentials.cc',
        'src/core/lib/security/credentials/credentials_metadata.cc',
        'src/core/lib/security/credentials/fake/fake_credentials.cc',
        'src/core/lib/security/credentials/google_default/credentials_generic.cc',
        'src/core/lib/security/credentials/google_default/google_default_credentials.cc',
        'src/core/lib/security/credentials/iam/iam_credentials.cc',
        'src/core/lib/security/credentials/jwt/json_token.cc',
        'src/core/lib/security/credentials/jwt/jwt_credentials.cc',
        'src/core/lib/security/credentials/jwt/jwt_verifier.cc',
        'src/core/lib/security/credentials/local/local_credentials.cc',
        'src/core/lib/security/credentials/oauth2/oauth2_credentials.cc',
        'src/core/lib/security/credentials/plugin/plugin_credentials.cc',
        'src/core/lib/security/credentials/ssl/ssl_credentials.cc',
        'src/core/lib/security/credentials/tls/grpc_tls_credentials_options.cc',
        'src/core/lib/security/credentials/tls/spiffe_credentials.cc',
        'src/core/lib/security/security_connector/alts/alts_security_connector.cc',
        'src/core/lib/security/security_connector/fake/fake_security_connector.cc',
        'src/core/lib/security/security_connector/load_system_roots_fallback.cc',
        'src/core/lib/security/security_connector/load_system_roots_linux.cc',
        'src/core/lib/security/security_connector/local/local_security_connector.cc',
        'src/core/lib/security/security_connector/security_connector.cc',
        'src/core/lib/security/security_connector/ssl/ssl_security_connector.cc',
        'src/core/lib/security/security_connector/ssl_utils.cc',
        'src/core/lib/security/security_connector/ssl_utils_config.cc',
        'src/core/lib/security/security_connector/tls/spiffe_security_connector.cc',
        'src/core/lib/security/transport/client_auth_filter.cc',
        'src/core/lib/security/transport/secure_endpoint.cc',
        'src/core/lib/security/transport/security_handshaker.cc',
        'src/core/lib/security/transport/server_auth_filter.cc',
        'src/core/lib/security/transport/target_authority_table.cc',
        'src/core/lib/security/transport/tsi_error.cc',
        'src/core/lib/security/util/json_util.cc',
        'src/core/lib/surface/init_secure.cc',
        'src/core/tsi/alts/crypt/aes_gcm.cc',
        'src/core/tsi/alts/crypt/gsec.cc',
        'src/core/tsi/alts/frame_protector/alts_counter.cc',
        'src/core/tsi/alts/frame_protector/alts_crypter.cc',
        'src/core/tsi/alts/frame_protector/alts_frame_protector.cc',
        'src/core/tsi/alts/frame_protector/alts_record_protocol_crypter_common.cc',
        'src/core/tsi/alts/frame_protector/alts_seal_privacy_integrity_crypter.cc',
        'src/core/tsi/alts/frame_protector/alts_unseal_privacy_integrity_crypter.cc',
        'src/core/tsi/alts/frame_protector/frame_handler.cc',
        'src/core/tsi/alts/handshaker/alts_handshaker_client.cc',
        'src/core/tsi/alts/handshaker/alts_shared_resource.cc',
        'src/core/tsi/alts/handshaker/alts_tsi_handshaker.cc',
        'src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_integrity_only_record_protocol.cc',
        'src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_privacy_integrity_record_protocol.cc',
        'src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_record_protocol_common.cc',
        'src/core/tsi/alts/zero_copy_frame_protector/alts_iovec_record_protocol.cc',
        'src/core/tsi/alts/zero_copy_frame_protector/alts_zero_copy_grpc_protector.cc',
        'src/core/lib/security/credentials/alts/check_gcp_environment.cc',
        'src/core/lib/security/credentials/alts/check_gcp_environment_linux.cc',
        'src/core/lib/security/credentials/alts/check_gcp_environment_no_op.cc',
        'src/core/lib/security/credentials/alts/check_gcp_environment_windows.cc',
        'src/core/lib/security/credentials/alts/grpc_alts_credentials_client_options.cc',
        'src/core/lib/security/credentials/alts/grpc_alts_credentials_options.cc',
        'src/core/lib/security/credentials/alts/grpc_alts_credentials_server_options.cc',
        'src/core/tsi/alts/handshaker/alts_tsi_utils.cc',
        'src/core/tsi/alts/handshaker/transport_security_common_api.cc',
        'src/core/ext/upb-generated/src/proto/grpc/gcp/altscontext.upb.c',
        'src/core/ext/upb-generated/src/proto/grpc/gcp/handshaker.upb.c',
        'src/core/ext/upb-generated/src/proto/grpc/gcp/transport_security_common.upb.c',
        'third_party/upb/upb/decode.c',
        'third_party/upb/upb/encode.c',
        'third_party/upb/upb/msg.c',
        'third_party/upb/upb/port.c',
        'third_party/upb/upb/table.c',
        'third_party/upb/upb/upb.c',
        'src/core/tsi/transport_security.cc',
        'src/core/ext/transport/chttp2/client/insecure/channel_create.cc',
        'src/core/ext/transport/chttp2/client/insecure/channel_create_posix.cc',
        'src/core/ext/transport/chttp2/client/authority.cc',
        'src/core/ext/transport/chttp2/client/chttp2_connector.cc',
        'src/core/ext/filters/client_channel/backend_metric.cc',
        'src/core/ext/filters/client_channel/backup_poller.cc',
        'src/core/ext/filters/client_channel/channel_connectivity.cc',
        'src/core/ext/filters/client_channel/client_channel.cc',
        'src/core/ext/filters/client_channel/client_channel_channelz.cc',
        'src/core/ext/filters/client_channel/client_channel_factory.cc',
        'src/core/ext/filters/client_channel/client_channel_plugin.cc',
        'src/core/ext/filters/client_channel/connector.cc',
        'src/core/ext/filters/client_channel/global_subchannel_pool.cc',
        'src/core/ext/filters/client_channel/health/health_check_client.cc',
        'src/core/ext/filters/client_channel/http_connect_handshaker.cc',
        'src/core/ext/filters/client_channel/http_proxy.cc',
        'src/core/ext/filters/client_channel/lb_policy.cc',
        'src/core/ext/filters/client_channel/lb_policy_registry.cc',
        'src/core/ext/filters/client_channel/local_subchannel_pool.cc',
        'src/core/ext/filters/client_channel/parse_address.cc',
        'src/core/ext/filters/client_channel/proxy_mapper.cc',
        'src/core/ext/filters/client_channel/proxy_mapper_registry.cc',
        'src/core/ext/filters/client_channel/resolver.cc',
        'src/core/ext/filters/client_channel/resolver_registry.cc',
        'src/core/ext/filters/client_channel/resolver_result_parsing.cc',
        'src/core/ext/filters/client_channel/resolving_lb_policy.cc',
        'src/core/ext/filters/client_channel/retry_throttle.cc',
        'src/core/ext/filters/client_channel/server_address.cc',
        'src/core/ext/filters/client_channel/service_config.cc',
        'src/core/ext/filters/client_channel/subchannel.cc',
        'src/core/ext/filters/client_channel/subchannel_pool_interface.cc',
        'src/core/ext/filters/deadline/deadline_filter.cc',
        'src/core/ext/upb-generated/src/proto/grpc/health/v1/health.upb.c',
        'src/core/ext/upb-generated/udpa/data/orca/v1/orca_load_report.upb.c',
        'src/core/ext/upb-generated/gogoproto/gogo.upb.c',
        'src/core/ext/upb-generated/validate/validate.upb.c',
        'src/core/ext/upb-generated/google/api/annotations.upb.c',
        'src/core/ext/upb-generated/google/api/http.upb.c',
        'src/core/ext/upb-generated/google/protobuf/any.upb.c',
        'src/core/ext/upb-generated/google/protobuf/descriptor.upb.c',
        'src/core/ext/upb-generated/google/protobuf/duration.upb.c',
        'src/core/ext/upb-generated/google/protobuf/empty.upb.c',
        'src/core/ext/upb-generated/google/protobuf/struct.upb.c',
        'src/core/ext/upb-generated/google/protobuf/timestamp.upb.c',
        'src/core/ext/upb-generated/google/protobuf/wrappers.upb.c',
        'src/core/ext/upb-generated/google/rpc/status.upb.c',
        'src/core/tsi/fake_transport_security.cc',
        'src/core/tsi/local_transport_security.cc',
        'src/core/tsi/ssl/session_cache/ssl_session_boringssl.cc',
        'src/core/tsi/ssl/session_cache/ssl_session_cache.cc',
        'src/core/tsi/ssl/session_cache/ssl_session_openssl.cc',
        'src/core/tsi/ssl_transport_security.cc',
        'src/core/tsi/transport_security_grpc.cc',
        'src/core/ext/transport/chttp2/server/chttp2_server.cc',
        'src/core/ext/transport/chttp2/client/secure/secure_channel_create.cc',
        'src/core/ext/transport/chttp2/server/insecure/server_chttp2.cc',
        'src/core/ext/transport/chttp2/server/insecure/server_chttp2_posix.cc',
        'src/core/ext/transport/inproc/inproc_plugin.cc',
        'src/core/ext/transport/inproc/inproc_transport.cc',
        'src/core/ext/filters/client_channel/lb_policy/grpclb/client_load_reporting_filter.cc',
        'src/core/ext/filters/client_channel/lb_policy/grpclb/grpclb.cc',
        'src/core/ext/filters/client_channel/lb_policy/grpclb/grpclb_channel_secure.cc',
        'src/core/ext/filters/client_channel/lb_policy/grpclb/grpclb_client_stats.cc',
        'src/core/ext/filters/client_channel/lb_policy/grpclb/load_balancer_api.cc',
        'src/core/ext/upb-generated/src/proto/grpc/lb/v1/load_balancer.upb.c',
        'src/core/ext/filters/client_channel/resolver/fake/fake_resolver.cc',
        'src/core/ext/filters/client_channel/lb_policy/xds/xds.cc',
        'src/core/ext/filters/client_channel/lb_policy/xds/xds_channel_secure.cc',
        'src/core/ext/filters/client_channel/lb_policy/xds/xds_client_stats.cc',
        'src/core/ext/filters/client_channel/lb_policy/xds/xds_load_balancer_api.cc',
        'src/core/ext/upb-generated/envoy/api/v2/auth/cert.upb.c',
        'src/core/ext/upb-generated/envoy/api/v2/cds.upb.c',
        'src/core/ext/upb-generated/envoy/api/v2/cluster/circuit_breaker.upb.c',
        'src/core/ext/upb-generated/envoy/api/v2/cluster/filter.upb.c',
        'src/core/ext/upb-generated/envoy/api/v2/cluster/outlier_detection.upb.c',
        'src/core/ext/upb-generated/envoy/api/v2/discovery.upb.c',
        'src/core/ext/upb-generated/envoy/api/v2/eds.upb.c',
        'src/core/ext/upb-generated/envoy/api/v2/endpoint/endpoint.upb.c',
        'src/core/ext/upb-generated/envoy/api/v2/endpoint/load_report.upb.c',
        'src/core/ext/upb-generated/envoy/service/discovery/v2/ads.upb.c',
        'src/core/ext/upb-generated/envoy/service/load_stats/v2/lrs.upb.c',
        'src/core/ext/upb-generated/envoy/api/v2/core/address.upb.c',
        'src/core/ext/upb-generated/envoy/api/v2/core/base.upb.c',
        'src/core/ext/upb-generated/envoy/api/v2/core/config_source.upb.c',
        'src/core/ext/upb-generated/envoy/api/v2/core/grpc_service.upb.c',
        'src/core/ext/upb-generated/envoy/api/v2/core/health_check.upb.c',
        'src/core/ext/upb-generated/envoy/api/v2/core/http_uri.upb.c',
        'src/core/ext/upb-generated/envoy/api/v2/core/protocol.upb.c',
        'src/core/ext/upb-generated/envoy/type/percent.upb.c',
        'src/core/ext/upb-generated/envoy/type/range.upb.c',
        'src/core/ext/filters/client_channel/lb_policy/pick_first/pick_first.cc',
        'src/core/ext/filters/client_channel/lb_policy/round_robin/round_robin.cc',
        'src/core/ext/filters/client_channel/resolver/dns/c_ares/dns_resolver_ares.cc',
        'src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_ev_driver.cc',
        'src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_ev_driver_libuv.cc',
        'src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_ev_driver_posix.cc',
        'src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_ev_driver_windows.cc',
        'src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_wrapper.cc',
        'src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_wrapper_fallback.cc',
        'src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_wrapper_libuv.cc',
        'src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_wrapper_posix.cc',
        'src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_wrapper_windows.cc',
        'src/core/ext/filters/client_channel/resolver/dns/dns_resolver_selection.cc',
        'src/core/ext/filters/client_channel/resolver/dns/native/dns_resolver.cc',
        'src/core/ext/filters/client_channel/resolver/sockaddr/sockaddr_resolver.cc',
        'src/core/ext/filters/client_channel/resolver/xds/xds_resolver.cc',
        'src/core/ext/filters/census/grpc_context.cc',
        'src/core/ext/filters/client_idle/client_idle_filter.cc',
        'src/core/ext/filters/max_age/max_age_filter.cc',
        'src/core/ext/filters/message_size/message_size_filter.cc',
        'src/core/ext/filters/http/client_authority_filter.cc',
        'src/core/ext/filters/workarounds/workaround_cronet_compression_filter.cc',
        'src/core/ext/filters/workarounds/workaround_utils.cc',
        'src/core/plugin_registry/grpc_plugin_registry.cc',
      ],
    },
    {
      'target_name': 'grpc_test_util',
      'type': 'static_library',
      'dependencies': [
        'gpr',
        'grpc',
      ],
      'sources': [
        'test/core/end2end/data/client_certs.cc',
        'test/core/end2end/data/server1_cert.cc',
        'test/core/end2end/data/server1_key.cc',
        'test/core/end2end/data/test_root_cert.cc',
        'test/core/security/oauth2_utils.cc',
        'src/core/ext/filters/client_channel/resolver/fake/fake_resolver.cc',
        'test/core/end2end/cq_verifier.cc',
        'test/core/end2end/fixtures/http_proxy_fixture.cc',
        'test/core/end2end/fixtures/local_util.cc',
        'test/core/end2end/fixtures/proxy.cc',
        'test/core/iomgr/endpoint_tests.cc',
        'test/core/util/debugger_macros.cc',
        'test/core/util/fuzzer_util.cc',
        'test/core/util/grpc_profiler.cc',
        'test/core/util/histogram.cc',
        'test/core/util/memory_counters.cc',
        'test/core/util/mock_endpoint.cc',
        'test/core/util/parse_hexstring.cc',
        'test/core/util/passthru_endpoint.cc',
        'test/core/util/port.cc',
        'test/core/util/port_isolated_runtime_environment.cc',
        'test/core/util/port_server_client.cc',
        'test/core/util/slice_splitter.cc',
        'test/core/util/subprocess_posix.cc',
        'test/core/util/subprocess_windows.cc',
        'test/core/util/test_config.cc',
        'test/core/util/test_lb_policies.cc',
        'test/core/util/tracer_util.cc',
        'test/core/util/trickle_endpoint.cc',
        'test/core/util/cmdline.cc',
        'src/core/lib/avl/avl.cc',
        'src/core/lib/backoff/backoff.cc',
        'src/core/lib/channel/channel_args.cc',
        'src/core/lib/channel/channel_stack.cc',
        'src/core/lib/channel/channel_stack_builder.cc',
        'src/core/lib/channel/channel_trace.cc',
        'src/core/lib/channel/channelz.cc',
        'src/core/lib/channel/channelz_registry.cc',
        'src/core/lib/channel/connected_channel.cc',
        'src/core/lib/channel/handshaker.cc',
        'src/core/lib/channel/handshaker_registry.cc',
        'src/core/lib/channel/status_util.cc',
        'src/core/lib/compression/compression.cc',
        'src/core/lib/compression/compression_args.cc',
        'src/core/lib/compression/compression_internal.cc',
        'src/core/lib/compression/message_compress.cc',
        'src/core/lib/compression/stream_compression.cc',
        'src/core/lib/compression/stream_compression_gzip.cc',
        'src/core/lib/compression/stream_compression_identity.cc',
        'src/core/lib/debug/stats.cc',
        'src/core/lib/debug/stats_data.cc',
        'src/core/lib/http/format_request.cc',
        'src/core/lib/http/httpcli.cc',
        'src/core/lib/http/parser.cc',
        'src/core/lib/iomgr/buffer_list.cc',
        'src/core/lib/iomgr/call_combiner.cc',
        'src/core/lib/iomgr/cfstream_handle.cc',
        'src/core/lib/iomgr/combiner.cc',
        'src/core/lib/iomgr/endpoint.cc',
        'src/core/lib/iomgr/endpoint_cfstream.cc',
        'src/core/lib/iomgr/endpoint_pair_posix.cc',
        'src/core/lib/iomgr/endpoint_pair_uv.cc',
        'src/core/lib/iomgr/endpoint_pair_windows.cc',
        'src/core/lib/iomgr/error.cc',
        'src/core/lib/iomgr/error_cfstream.cc',
        'src/core/lib/iomgr/ev_epoll1_linux.cc',
        'src/core/lib/iomgr/ev_epollex_linux.cc',
        'src/core/lib/iomgr/ev_poll_posix.cc',
        'src/core/lib/iomgr/ev_posix.cc',
        'src/core/lib/iomgr/ev_windows.cc',
        'src/core/lib/iomgr/exec_ctx.cc',
        'src/core/lib/iomgr/executor.cc',
        'src/core/lib/iomgr/executor/mpmcqueue.cc',
        'src/core/lib/iomgr/executor/threadpool.cc',
        'src/core/lib/iomgr/fork_posix.cc',
        'src/core/lib/iomgr/fork_windows.cc',
        'src/core/lib/iomgr/gethostname_fallback.cc',
        'src/core/lib/iomgr/gethostname_host_name_max.cc',
        'src/core/lib/iomgr/gethostname_sysconf.cc',
        'src/core/lib/iomgr/grpc_if_nametoindex_posix.cc',
        'src/core/lib/iomgr/grpc_if_nametoindex_unsupported.cc',
        'src/core/lib/iomgr/internal_errqueue.cc',
        'src/core/lib/iomgr/iocp_windows.cc',
        'src/core/lib/iomgr/iomgr.cc',
        'src/core/lib/iomgr/iomgr_custom.cc',
        'src/core/lib/iomgr/iomgr_internal.cc',
        'src/core/lib/iomgr/iomgr_posix.cc',
        'src/core/lib/iomgr/iomgr_posix_cfstream.cc',
        'src/core/lib/iomgr/iomgr_uv.cc',
        'src/core/lib/iomgr/iomgr_windows.cc',
        'src/core/lib/iomgr/is_epollexclusive_available.cc',
        'src/core/lib/iomgr/load_file.cc',
        'src/core/lib/iomgr/lockfree_event.cc',
        'src/core/lib/iomgr/polling_entity.cc',
        'src/core/lib/iomgr/pollset.cc',
        'src/core/lib/iomgr/pollset_custom.cc',
        'src/core/lib/iomgr/pollset_set.cc',
        'src/core/lib/iomgr/pollset_set_custom.cc',
        'src/core/lib/iomgr/pollset_set_windows.cc',
        'src/core/lib/iomgr/pollset_uv.cc',
        'src/core/lib/iomgr/pollset_windows.cc',
        'src/core/lib/iomgr/resolve_address.cc',
        'src/core/lib/iomgr/resolve_address_custom.cc',
        'src/core/lib/iomgr/resolve_address_posix.cc',
        'src/core/lib/iomgr/resolve_address_windows.cc',
        'src/core/lib/iomgr/resource_quota.cc',
        'src/core/lib/iomgr/sockaddr_utils.cc',
        'src/core/lib/iomgr/socket_factory_posix.cc',
        'src/core/lib/iomgr/socket_mutator.cc',
        'src/core/lib/iomgr/socket_utils_common_posix.cc',
        'src/core/lib/iomgr/socket_utils_linux.cc',
        'src/core/lib/iomgr/socket_utils_posix.cc',
        'src/core/lib/iomgr/socket_utils_uv.cc',
        'src/core/lib/iomgr/socket_utils_windows.cc',
        'src/core/lib/iomgr/socket_windows.cc',
        'src/core/lib/iomgr/tcp_client.cc',
        'src/core/lib/iomgr/tcp_client_cfstream.cc',
        'src/core/lib/iomgr/tcp_client_custom.cc',
        'src/core/lib/iomgr/tcp_client_posix.cc',
        'src/core/lib/iomgr/tcp_client_windows.cc',
        'src/core/lib/iomgr/tcp_custom.cc',
        'src/core/lib/iomgr/tcp_posix.cc',
        'src/core/lib/iomgr/tcp_server.cc',
        'src/core/lib/iomgr/tcp_server_custom.cc',
        'src/core/lib/iomgr/tcp_server_posix.cc',
        'src/core/lib/iomgr/tcp_server_utils_posix_common.cc',
        'src/core/lib/iomgr/tcp_server_utils_posix_ifaddrs.cc',
        'src/core/lib/iomgr/tcp_server_utils_posix_noifaddrs.cc',
        'src/core/lib/iomgr/tcp_server_windows.cc',
        'src/core/lib/iomgr/tcp_uv.cc',
        'src/core/lib/iomgr/tcp_windows.cc',
        'src/core/lib/iomgr/time_averaged_stats.cc',
        'src/core/lib/iomgr/timer.cc',
        'src/core/lib/iomgr/timer_custom.cc',
        'src/core/lib/iomgr/timer_generic.cc',
        'src/core/lib/iomgr/timer_heap.cc',
        'src/core/lib/iomgr/timer_manager.cc',
        'src/core/lib/iomgr/timer_uv.cc',
        'src/core/lib/iomgr/udp_server.cc',
        'src/core/lib/iomgr/unix_sockets_posix.cc',
        'src/core/lib/iomgr/unix_sockets_posix_noop.cc',
        'src/core/lib/iomgr/wakeup_fd_eventfd.cc',
        'src/core/lib/iomgr/wakeup_fd_nospecial.cc',
        'src/core/lib/iomgr/wakeup_fd_pipe.cc',
        'src/core/lib/iomgr/wakeup_fd_posix.cc',
        'src/core/lib/json/json.cc',
        'src/core/lib/json/json_reader.cc',
        'src/core/lib/json/json_string.cc',
        'src/core/lib/json/json_writer.cc',
        'src/core/lib/slice/b64.cc',
        'src/core/lib/slice/percent_encoding.cc',
        'src/core/lib/slice/slice.cc',
        'src/core/lib/slice/slice_buffer.cc',
        'src/core/lib/slice/slice_intern.cc',
        'src/core/lib/slice/slice_string_helpers.cc',
        'src/core/lib/surface/api_trace.cc',
        'src/core/lib/surface/byte_buffer.cc',
        'src/core/lib/surface/byte_buffer_reader.cc',
        'src/core/lib/surface/call.cc',
        'src/core/lib/surface/call_details.cc',
        'src/core/lib/surface/call_log_batch.cc',
        'src/core/lib/surface/channel.cc',
        'src/core/lib/surface/channel_init.cc',
        'src/core/lib/surface/channel_ping.cc',
        'src/core/lib/surface/channel_stack_type.cc',
        'src/core/lib/surface/completion_queue.cc',
        'src/core/lib/surface/completion_queue_factory.cc',
        'src/core/lib/surface/event_string.cc',
        'src/core/lib/surface/lame_client.cc',
        'src/core/lib/surface/metadata_array.cc',
        'src/core/lib/surface/server.cc',
        'src/core/lib/surface/validate_metadata.cc',
        'src/core/lib/surface/version.cc',
        'src/core/lib/transport/bdp_estimator.cc',
        'src/core/lib/transport/byte_stream.cc',
        'src/core/lib/transport/connectivity_state.cc',
        'src/core/lib/transport/error_utils.cc',
        'src/core/lib/transport/metadata.cc',
        'src/core/lib/transport/metadata_batch.cc',
        'src/core/lib/transport/pid_controller.cc',
        'src/core/lib/transport/static_metadata.cc',
        'src/core/lib/transport/status_conversion.cc',
        'src/core/lib/transport/status_metadata.cc',
        'src/core/lib/transport/timeout_encoding.cc',
        'src/core/lib/transport/transport.cc',
        'src/core/lib/transport/transport_op_string.cc',
        'src/core/lib/uri/uri_parser.cc',
        'src/core/lib/debug/trace.cc',
        'src/core/ext/filters/client_channel/backend_metric.cc',
        'src/core/ext/filters/client_channel/backup_poller.cc',
        'src/core/ext/filters/client_channel/channel_connectivity.cc',
        'src/core/ext/filters/client_channel/client_channel.cc',
        'src/core/ext/filters/client_channel/client_channel_channelz.cc',
        'src/core/ext/filters/client_channel/client_channel_factory.cc',
        'src/core/ext/filters/client_channel/client_channel_plugin.cc',
        'src/core/ext/filters/client_channel/connector.cc',
        'src/core/ext/filters/client_channel/global_subchannel_pool.cc',
        'src/core/ext/filters/client_channel/health/health_check_client.cc',
        'src/core/ext/filters/client_channel/http_connect_handshaker.cc',
        'src/core/ext/filters/client_channel/http_proxy.cc',
        'src/core/ext/filters/client_channel/lb_policy.cc',
        'src/core/ext/filters/client_channel/lb_policy_registry.cc',
        'src/core/ext/filters/client_channel/local_subchannel_pool.cc',
        'src/core/ext/filters/client_channel/parse_address.cc',
        'src/core/ext/filters/client_channel/proxy_mapper.cc',
        'src/core/ext/filters/client_channel/proxy_mapper_registry.cc',
        'src/core/ext/filters/client_channel/resolver.cc',
        'src/core/ext/filters/client_channel/resolver_registry.cc',
        'src/core/ext/filters/client_channel/resolver_result_parsing.cc',
        'src/core/ext/filters/client_channel/resolving_lb_policy.cc',
        'src/core/ext/filters/client_channel/retry_throttle.cc',
        'src/core/ext/filters/client_channel/server_address.cc',
        'src/core/ext/filters/client_channel/service_config.cc',
        'src/core/ext/filters/client_channel/subchannel.cc',
        'src/core/ext/filters/client_channel/subchannel_pool_interface.cc',
        'src/core/ext/filters/deadline/deadline_filter.cc',
        'src/core/ext/upb-generated/src/proto/grpc/health/v1/health.upb.c',
        'third_party/upb/upb/decode.c',
        'third_party/upb/upb/encode.c',
        'third_party/upb/upb/msg.c',
        'third_party/upb/upb/port.c',
        'third_party/upb/upb/table.c',
        'third_party/upb/upb/upb.c',
        'src/core/ext/upb-generated/udpa/data/orca/v1/orca_load_report.upb.c',
        'src/core/ext/upb-generated/gogoproto/gogo.upb.c',
        'src/core/ext/upb-generated/validate/validate.upb.c',
        'src/core/ext/upb-generated/google/api/annotations.upb.c',
        'src/core/ext/upb-generated/google/api/http.upb.c',
        'src/core/ext/upb-generated/google/protobuf/any.upb.c',
        'src/core/ext/upb-generated/google/protobuf/descriptor.upb.c',
        'src/core/ext/upb-generated/google/protobuf/duration.upb.c',
        'src/core/ext/upb-generated/google/protobuf/empty.upb.c',
        'src/core/ext/upb-generated/google/protobuf/struct.upb.c',
        'src/core/ext/upb-generated/google/protobuf/timestamp.upb.c',
        'src/core/ext/upb-generated/google/protobuf/wrappers.upb.c',
        'src/core/ext/upb-generated/google/rpc/status.upb.c',
        'src/core/ext/transport/chttp2/transport/bin_decoder.cc',
        'src/core/ext/transport/chttp2/transport/bin_encoder.cc',
        'src/core/ext/transport/chttp2/transport/chttp2_plugin.cc',
        'src/core/ext/transport/chttp2/transport/chttp2_transport.cc',
        'src/core/ext/transport/chttp2/transport/context_list.cc',
        'src/core/ext/transport/chttp2/transport/flow_control.cc',
        'src/core/ext/transport/chttp2/transport/frame_data.cc',
        'src/core/ext/transport/chttp2/transport/frame_goaway.cc',
        'src/core/ext/transport/chttp2/transport/frame_ping.cc',
        'src/core/ext/transport/chttp2/transport/frame_rst_stream.cc',
        'src/core/ext/transport/chttp2/transport/frame_settings.cc',
        'src/core/ext/transport/chttp2/transport/frame_window_update.cc',
        'src/core/ext/transport/chttp2/transport/hpack_encoder.cc',
        'src/core/ext/transport/chttp2/transport/hpack_parser.cc',
        'src/core/ext/transport/chttp2/transport/hpack_table.cc',
        'src/core/ext/transport/chttp2/transport/http2_settings.cc',
        'src/core/ext/transport/chttp2/transport/huffsyms.cc',
        'src/core/ext/transport/chttp2/transport/incoming_metadata.cc',
        'src/core/ext/transport/chttp2/transport/parsing.cc',
        'src/core/ext/transport/chttp2/transport/stream_lists.cc',
        'src/core/ext/transport/chttp2/transport/stream_map.cc',
        'src/core/ext/transport/chttp2/transport/varint.cc',
        'src/core/ext/transport/chttp2/transport/writing.cc',
        'src/core/ext/transport/chttp2/alpn/alpn.cc',
        'src/core/ext/filters/http/client/http_client_filter.cc',
        'src/core/ext/filters/http/http_filters_plugin.cc',
        'src/core/ext/filters/http/message_compress/message_compress_filter.cc',
        'src/core/ext/filters/http/server/http_server_filter.cc',
      ],
    },
    {
      'target_name': 'grpc_test_util_unsecure',
      'type': 'static_library',
      'dependencies': [
        'gpr',
        'grpc_unsecure',
      ],
      'sources': [
        'src/core/ext/filters/client_channel/resolver/fake/fake_resolver.cc',
        'test/core/end2end/cq_verifier.cc',
        'test/core/end2end/fixtures/http_proxy_fixture.cc',
        'test/core/end2end/fixtures/local_util.cc',
        'test/core/end2end/fixtures/proxy.cc',
        'test/core/iomgr/endpoint_tests.cc',
        'test/core/util/debugger_macros.cc',
        'test/core/util/fuzzer_util.cc',
        'test/core/util/grpc_profiler.cc',
        'test/core/util/histogram.cc',
        'test/core/util/memory_counters.cc',
        'test/core/util/mock_endpoint.cc',
        'test/core/util/parse_hexstring.cc',
        'test/core/util/passthru_endpoint.cc',
        'test/core/util/port.cc',
        'test/core/util/port_isolated_runtime_environment.cc',
        'test/core/util/port_server_client.cc',
        'test/core/util/slice_splitter.cc',
        'test/core/util/subprocess_posix.cc',
        'test/core/util/subprocess_windows.cc',
        'test/core/util/test_config.cc',
        'test/core/util/test_lb_policies.cc',
        'test/core/util/tracer_util.cc',
        'test/core/util/trickle_endpoint.cc',
        'test/core/util/cmdline.cc',
        'src/core/lib/avl/avl.cc',
        'src/core/lib/backoff/backoff.cc',
        'src/core/lib/channel/channel_args.cc',
        'src/core/lib/channel/channel_stack.cc',
        'src/core/lib/channel/channel_stack_builder.cc',
        'src/core/lib/channel/channel_trace.cc',
        'src/core/lib/channel/channelz.cc',
        'src/core/lib/channel/channelz_registry.cc',
        'src/core/lib/channel/connected_channel.cc',
        'src/core/lib/channel/handshaker.cc',
        'src/core/lib/channel/handshaker_registry.cc',
        'src/core/lib/channel/status_util.cc',
        'src/core/lib/compression/compression.cc',
        'src/core/lib/compression/compression_args.cc',
        'src/core/lib/compression/compression_internal.cc',
        'src/core/lib/compression/message_compress.cc',
        'src/core/lib/compression/stream_compression.cc',
        'src/core/lib/compression/stream_compression_gzip.cc',
        'src/core/lib/compression/stream_compression_identity.cc',
        'src/core/lib/debug/stats.cc',
        'src/core/lib/debug/stats_data.cc',
        'src/core/lib/http/format_request.cc',
        'src/core/lib/http/httpcli.cc',
        'src/core/lib/http/parser.cc',
        'src/core/lib/iomgr/buffer_list.cc',
        'src/core/lib/iomgr/call_combiner.cc',
        'src/core/lib/iomgr/cfstream_handle.cc',
        'src/core/lib/iomgr/combiner.cc',
        'src/core/lib/iomgr/endpoint.cc',
        'src/core/lib/iomgr/endpoint_cfstream.cc',
        'src/core/lib/iomgr/endpoint_pair_posix.cc',
        'src/core/lib/iomgr/endpoint_pair_uv.cc',
        'src/core/lib/iomgr/endpoint_pair_windows.cc',
        'src/core/lib/iomgr/error.cc',
        'src/core/lib/iomgr/error_cfstream.cc',
        'src/core/lib/iomgr/ev_epoll1_linux.cc',
        'src/core/lib/iomgr/ev_epollex_linux.cc',
        'src/core/lib/iomgr/ev_poll_posix.cc',
        'src/core/lib/iomgr/ev_posix.cc',
        'src/core/lib/iomgr/ev_windows.cc',
        'src/core/lib/iomgr/exec_ctx.cc',
        'src/core/lib/iomgr/executor.cc',
        'src/core/lib/iomgr/executor/mpmcqueue.cc',
        'src/core/lib/iomgr/executor/threadpool.cc',
        'src/core/lib/iomgr/fork_posix.cc',
        'src/core/lib/iomgr/fork_windows.cc',
        'src/core/lib/iomgr/gethostname_fallback.cc',
        'src/core/lib/iomgr/gethostname_host_name_max.cc',
        'src/core/lib/iomgr/gethostname_sysconf.cc',
        'src/core/lib/iomgr/grpc_if_nametoindex_posix.cc',
        'src/core/lib/iomgr/grpc_if_nametoindex_unsupported.cc',
        'src/core/lib/iomgr/internal_errqueue.cc',
        'src/core/lib/iomgr/iocp_windows.cc',
        'src/core/lib/iomgr/iomgr.cc',
        'src/core/lib/iomgr/iomgr_custom.cc',
        'src/core/lib/iomgr/iomgr_internal.cc',
        'src/core/lib/iomgr/iomgr_posix.cc',
        'src/core/lib/iomgr/iomgr_posix_cfstream.cc',
        'src/core/lib/iomgr/iomgr_uv.cc',
        'src/core/lib/iomgr/iomgr_windows.cc',
        'src/core/lib/iomgr/is_epollexclusive_available.cc',
        'src/core/lib/iomgr/load_file.cc',
        'src/core/lib/iomgr/lockfree_event.cc',
        'src/core/lib/iomgr/polling_entity.cc',
        'src/core/lib/iomgr/pollset.cc',
        'src/core/lib/iomgr/pollset_custom.cc',
        'src/core/lib/iomgr/pollset_set.cc',
        'src/core/lib/iomgr/pollset_set_custom.cc',
        'src/core/lib/iomgr/pollset_set_windows.cc',
        'src/core/lib/iomgr/pollset_uv.cc',
        'src/core/lib/iomgr/pollset_windows.cc',
        'src/core/lib/iomgr/resolve_address.cc',
        'src/core/lib/iomgr/resolve_address_custom.cc',
        'src/core/lib/iomgr/resolve_address_posix.cc',
        'src/core/lib/iomgr/resolve_address_windows.cc',
        'src/core/lib/iomgr/resource_quota.cc',
        'src/core/lib/iomgr/sockaddr_utils.cc',
        'src/core/lib/iomgr/socket_factory_posix.cc',
        'src/core/lib/iomgr/socket_mutator.cc',
        'src/core/lib/iomgr/socket_utils_common_posix.cc',
        'src/core/lib/iomgr/socket_utils_linux.cc',
        'src/core/lib/iomgr/socket_utils_posix.cc',
        'src/core/lib/iomgr/socket_utils_uv.cc',
        'src/core/lib/iomgr/socket_utils_windows.cc',
        'src/core/lib/iomgr/socket_windows.cc',
        'src/core/lib/iomgr/tcp_client.cc',
        'src/core/lib/iomgr/tcp_client_cfstream.cc',
        'src/core/lib/iomgr/tcp_client_custom.cc',
        'src/core/lib/iomgr/tcp_client_posix.cc',
        'src/core/lib/iomgr/tcp_client_windows.cc',
        'src/core/lib/iomgr/tcp_custom.cc',
        'src/core/lib/iomgr/tcp_posix.cc',
        'src/core/lib/iomgr/tcp_server.cc',
        'src/core/lib/iomgr/tcp_server_custom.cc',
        'src/core/lib/iomgr/tcp_server_posix.cc',
        'src/core/lib/iomgr/tcp_server_utils_posix_common.cc',
        'src/core/lib/iomgr/tcp_server_utils_posix_ifaddrs.cc',
        'src/core/lib/iomgr/tcp_server_utils_posix_noifaddrs.cc',
        'src/core/lib/iomgr/tcp_server_windows.cc',
        'src/core/lib/iomgr/tcp_uv.cc',
        'src/core/lib/iomgr/tcp_windows.cc',
        'src/core/lib/iomgr/time_averaged_stats.cc',
        'src/core/lib/iomgr/timer.cc',
        'src/core/lib/iomgr/timer_custom.cc',
        'src/core/lib/iomgr/timer_generic.cc',
        'src/core/lib/iomgr/timer_heap.cc',
        'src/core/lib/iomgr/timer_manager.cc',
        'src/core/lib/iomgr/timer_uv.cc',
        'src/core/lib/iomgr/udp_server.cc',
        'src/core/lib/iomgr/unix_sockets_posix.cc',
        'src/core/lib/iomgr/unix_sockets_posix_noop.cc',
        'src/core/lib/iomgr/wakeup_fd_eventfd.cc',
        'src/core/lib/iomgr/wakeup_fd_nospecial.cc',
        'src/core/lib/iomgr/wakeup_fd_pipe.cc',
        'src/core/lib/iomgr/wakeup_fd_posix.cc',
        'src/core/lib/json/json.cc',
        'src/core/lib/json/json_reader.cc',
        'src/core/lib/json/json_string.cc',
        'src/core/lib/json/json_writer.cc',
        'src/core/lib/slice/b64.cc',
        'src/core/lib/slice/percent_encoding.cc',
        'src/core/lib/slice/slice.cc',
        'src/core/lib/slice/slice_buffer.cc',
        'src/core/lib/slice/slice_intern.cc',
        'src/core/lib/slice/slice_string_helpers.cc',
        'src/core/lib/surface/api_trace.cc',
        'src/core/lib/surface/byte_buffer.cc',
        'src/core/lib/surface/byte_buffer_reader.cc',
        'src/core/lib/surface/call.cc',
        'src/core/lib/surface/call_details.cc',
        'src/core/lib/surface/call_log_batch.cc',
        'src/core/lib/surface/channel.cc',
        'src/core/lib/surface/channel_init.cc',
        'src/core/lib/surface/channel_ping.cc',
        'src/core/lib/surface/channel_stack_type.cc',
        'src/core/lib/surface/completion_queue.cc',
        'src/core/lib/surface/completion_queue_factory.cc',
        'src/core/lib/surface/event_string.cc',
        'src/core/lib/surface/lame_client.cc',
        'src/core/lib/surface/metadata_array.cc',
        'src/core/lib/surface/server.cc',
        'src/core/lib/surface/validate_metadata.cc',
        'src/core/lib/surface/version.cc',
        'src/core/lib/transport/bdp_estimator.cc',
        'src/core/lib/transport/byte_stream.cc',
        'src/core/lib/transport/connectivity_state.cc',
        'src/core/lib/transport/error_utils.cc',
        'src/core/lib/transport/metadata.cc',
        'src/core/lib/transport/metadata_batch.cc',
        'src/core/lib/transport/pid_controller.cc',
        'src/core/lib/transport/static_metadata.cc',
        'src/core/lib/transport/status_conversion.cc',
        'src/core/lib/transport/status_metadata.cc',
        'src/core/lib/transport/timeout_encoding.cc',
        'src/core/lib/transport/transport.cc',
        'src/core/lib/transport/transport_op_string.cc',
        'src/core/lib/uri/uri_parser.cc',
        'src/core/lib/debug/trace.cc',
        'src/core/ext/filters/client_channel/backend_metric.cc',
        'src/core/ext/filters/client_channel/backup_poller.cc',
        'src/core/ext/filters/client_channel/channel_connectivity.cc',
        'src/core/ext/filters/client_channel/client_channel.cc',
        'src/core/ext/filters/client_channel/client_channel_channelz.cc',
        'src/core/ext/filters/client_channel/client_channel_factory.cc',
        'src/core/ext/filters/client_channel/client_channel_plugin.cc',
        'src/core/ext/filters/client_channel/connector.cc',
        'src/core/ext/filters/client_channel/global_subchannel_pool.cc',
        'src/core/ext/filters/client_channel/health/health_check_client.cc',
        'src/core/ext/filters/client_channel/http_connect_handshaker.cc',
        'src/core/ext/filters/client_channel/http_proxy.cc',
        'src/core/ext/filters/client_channel/lb_policy.cc',
        'src/core/ext/filters/client_channel/lb_policy_registry.cc',
        'src/core/ext/filters/client_channel/local_subchannel_pool.cc',
        'src/core/ext/filters/client_channel/parse_address.cc',
        'src/core/ext/filters/client_channel/proxy_mapper.cc',
        'src/core/ext/filters/client_channel/proxy_mapper_registry.cc',
        'src/core/ext/filters/client_channel/resolver.cc',
        'src/core/ext/filters/client_channel/resolver_registry.cc',
        'src/core/ext/filters/client_channel/resolver_result_parsing.cc',
        'src/core/ext/filters/client_channel/resolving_lb_policy.cc',
        'src/core/ext/filters/client_channel/retry_throttle.cc',
        'src/core/ext/filters/client_channel/server_address.cc',
        'src/core/ext/filters/client_channel/service_config.cc',
        'src/core/ext/filters/client_channel/subchannel.cc',
        'src/core/ext/filters/client_channel/subchannel_pool_interface.cc',
        'src/core/ext/filters/deadline/deadline_filter.cc',
        'src/core/ext/upb-generated/src/proto/grpc/health/v1/health.upb.c',
        'third_party/upb/upb/decode.c',
        'third_party/upb/upb/encode.c',
        'third_party/upb/upb/msg.c',
        'third_party/upb/upb/port.c',
        'third_party/upb/upb/table.c',
        'third_party/upb/upb/upb.c',
        'src/core/ext/upb-generated/udpa/data/orca/v1/orca_load_report.upb.c',
        'src/core/ext/upb-generated/gogoproto/gogo.upb.c',
        'src/core/ext/upb-generated/validate/validate.upb.c',
        'src/core/ext/upb-generated/google/api/annotations.upb.c',
        'src/core/ext/upb-generated/google/api/http.upb.c',
        'src/core/ext/upb-generated/google/protobuf/any.upb.c',
        'src/core/ext/upb-generated/google/protobuf/descriptor.upb.c',
        'src/core/ext/upb-generated/google/protobuf/duration.upb.c',
        'src/core/ext/upb-generated/google/protobuf/empty.upb.c',
        'src/core/ext/upb-generated/google/protobuf/struct.upb.c',
        'src/core/ext/upb-generated/google/protobuf/timestamp.upb.c',
        'src/core/ext/upb-generated/google/protobuf/wrappers.upb.c',
        'src/core/ext/upb-generated/google/rpc/status.upb.c',
        'src/core/ext/transport/chttp2/transport/bin_decoder.cc',
        'src/core/ext/transport/chttp2/transport/bin_encoder.cc',
        'src/core/ext/transport/chttp2/transport/chttp2_plugin.cc',
        'src/core/ext/transport/chttp2/transport/chttp2_transport.cc',
        'src/core/ext/transport/chttp2/transport/context_list.cc',
        'src/core/ext/transport/chttp2/transport/flow_control.cc',
        'src/core/ext/transport/chttp2/transport/frame_data.cc',
        'src/core/ext/transport/chttp2/transport/frame_goaway.cc',
        'src/core/ext/transport/chttp2/transport/frame_ping.cc',
        'src/core/ext/transport/chttp2/transport/frame_rst_stream.cc',
        'src/core/ext/transport/chttp2/transport/frame_settings.cc',
        'src/core/ext/transport/chttp2/transport/frame_window_update.cc',
        'src/core/ext/transport/chttp2/transport/hpack_encoder.cc',
        'src/core/ext/transport/chttp2/transport/hpack_parser.cc',
        'src/core/ext/transport/chttp2/transport/hpack_table.cc',
        'src/core/ext/transport/chttp2/transport/http2_settings.cc',
        'src/core/ext/transport/chttp2/transport/huffsyms.cc',
        'src/core/ext/transport/chttp2/transport/incoming_metadata.cc',
        'src/core/ext/transport/chttp2/transport/parsing.cc',
        'src/core/ext/transport/chttp2/transport/stream_lists.cc',
        'src/core/ext/transport/chttp2/transport/stream_map.cc',
        'src/core/ext/transport/chttp2/transport/varint.cc',
        'src/core/ext/transport/chttp2/transport/writing.cc',
        'src/core/ext/transport/chttp2/alpn/alpn.cc',
        'src/core/ext/filters/http/client/http_client_filter.cc',
        'src/core/ext/filters/http/http_filters_plugin.cc',
        'src/core/ext/filters/http/message_compress/message_compress_filter.cc',
        'src/core/ext/filters/http/server/http_server_filter.cc',
      ],
    },
    {
      'target_name': 'grpc_unsecure',
      'type': 'static_library',
      'dependencies': [
        'gpr',
      ],
      'sources': [
        'src/core/lib/surface/init.cc',
        'src/core/lib/surface/init_unsecure.cc',
        'src/core/lib/avl/avl.cc',
        'src/core/lib/backoff/backoff.cc',
        'src/core/lib/channel/channel_args.cc',
        'src/core/lib/channel/channel_stack.cc',
        'src/core/lib/channel/channel_stack_builder.cc',
        'src/core/lib/channel/channel_trace.cc',
        'src/core/lib/channel/channelz.cc',
        'src/core/lib/channel/channelz_registry.cc',
        'src/core/lib/channel/connected_channel.cc',
        'src/core/lib/channel/handshaker.cc',
        'src/core/lib/channel/handshaker_registry.cc',
        'src/core/lib/channel/status_util.cc',
        'src/core/lib/compression/compression.cc',
        'src/core/lib/compression/compression_args.cc',
        'src/core/lib/compression/compression_internal.cc',
        'src/core/lib/compression/message_compress.cc',
        'src/core/lib/compression/stream_compression.cc',
        'src/core/lib/compression/stream_compression_gzip.cc',
        'src/core/lib/compression/stream_compression_identity.cc',
        'src/core/lib/debug/stats.cc',
        'src/core/lib/debug/stats_data.cc',
        'src/core/lib/http/format_request.cc',
        'src/core/lib/http/httpcli.cc',
        'src/core/lib/http/parser.cc',
        'src/core/lib/iomgr/buffer_list.cc',
        'src/core/lib/iomgr/call_combiner.cc',
        'src/core/lib/iomgr/cfstream_handle.cc',
        'src/core/lib/iomgr/combiner.cc',
        'src/core/lib/iomgr/endpoint.cc',
        'src/core/lib/iomgr/endpoint_cfstream.cc',
        'src/core/lib/iomgr/endpoint_pair_posix.cc',
        'src/core/lib/iomgr/endpoint_pair_uv.cc',
        'src/core/lib/iomgr/endpoint_pair_windows.cc',
        'src/core/lib/iomgr/error.cc',
        'src/core/lib/iomgr/error_cfstream.cc',
        'src/core/lib/iomgr/ev_epoll1_linux.cc',
        'src/core/lib/iomgr/ev_epollex_linux.cc',
        'src/core/lib/iomgr/ev_poll_posix.cc',
        'src/core/lib/iomgr/ev_posix.cc',
        'src/core/lib/iomgr/ev_windows.cc',
        'src/core/lib/iomgr/exec_ctx.cc',
        'src/core/lib/iomgr/executor.cc',
        'src/core/lib/iomgr/executor/mpmcqueue.cc',
        'src/core/lib/iomgr/executor/threadpool.cc',
        'src/core/lib/iomgr/fork_posix.cc',
        'src/core/lib/iomgr/fork_windows.cc',
        'src/core/lib/iomgr/gethostname_fallback.cc',
        'src/core/lib/iomgr/gethostname_host_name_max.cc',
        'src/core/lib/iomgr/gethostname_sysconf.cc',
        'src/core/lib/iomgr/grpc_if_nametoindex_posix.cc',
        'src/core/lib/iomgr/grpc_if_nametoindex_unsupported.cc',
        'src/core/lib/iomgr/internal_errqueue.cc',
        'src/core/lib/iomgr/iocp_windows.cc',
        'src/core/lib/iomgr/iomgr.cc',
        'src/core/lib/iomgr/iomgr_custom.cc',
        'src/core/lib/iomgr/iomgr_internal.cc',
        'src/core/lib/iomgr/iomgr_posix.cc',
        'src/core/lib/iomgr/iomgr_posix_cfstream.cc',
        'src/core/lib/iomgr/iomgr_uv.cc',
        'src/core/lib/iomgr/iomgr_windows.cc',
        'src/core/lib/iomgr/is_epollexclusive_available.cc',
        'src/core/lib/iomgr/load_file.cc',
        'src/core/lib/iomgr/lockfree_event.cc',
        'src/core/lib/iomgr/polling_entity.cc',
        'src/core/lib/iomgr/pollset.cc',
        'src/core/lib/iomgr/pollset_custom.cc',
        'src/core/lib/iomgr/pollset_set.cc',
        'src/core/lib/iomgr/pollset_set_custom.cc',
        'src/core/lib/iomgr/pollset_set_windows.cc',
        'src/core/lib/iomgr/pollset_uv.cc',
        'src/core/lib/iomgr/pollset_windows.cc',
        'src/core/lib/iomgr/resolve_address.cc',
        'src/core/lib/iomgr/resolve_address_custom.cc',
        'src/core/lib/iomgr/resolve_address_posix.cc',
        'src/core/lib/iomgr/resolve_address_windows.cc',
        'src/core/lib/iomgr/resource_quota.cc',
        'src/core/lib/iomgr/sockaddr_utils.cc',
        'src/core/lib/iomgr/socket_factory_posix.cc',
        'src/core/lib/iomgr/socket_mutator.cc',
        'src/core/lib/iomgr/socket_utils_common_posix.cc',
        'src/core/lib/iomgr/socket_utils_linux.cc',
        'src/core/lib/iomgr/socket_utils_posix.cc',
        'src/core/lib/iomgr/socket_utils_uv.cc',
        'src/core/lib/iomgr/socket_utils_windows.cc',
        'src/core/lib/iomgr/socket_windows.cc',
        'src/core/lib/iomgr/tcp_client.cc',
        'src/core/lib/iomgr/tcp_client_cfstream.cc',
        'src/core/lib/iomgr/tcp_client_custom.cc',
        'src/core/lib/iomgr/tcp_client_posix.cc',
        'src/core/lib/iomgr/tcp_client_windows.cc',
        'src/core/lib/iomgr/tcp_custom.cc',
        'src/core/lib/iomgr/tcp_posix.cc',
        'src/core/lib/iomgr/tcp_server.cc',
        'src/core/lib/iomgr/tcp_server_custom.cc',
        'src/core/lib/iomgr/tcp_server_posix.cc',
        'src/core/lib/iomgr/tcp_server_utils_posix_common.cc',
        'src/core/lib/iomgr/tcp_server_utils_posix_ifaddrs.cc',
        'src/core/lib/iomgr/tcp_server_utils_posix_noifaddrs.cc',
        'src/core/lib/iomgr/tcp_server_windows.cc',
        'src/core/lib/iomgr/tcp_uv.cc',
        'src/core/lib/iomgr/tcp_windows.cc',
        'src/core/lib/iomgr/time_averaged_stats.cc',
        'src/core/lib/iomgr/timer.cc',
        'src/core/lib/iomgr/timer_custom.cc',
        'src/core/lib/iomgr/timer_generic.cc',
        'src/core/lib/iomgr/timer_heap.cc',
        'src/core/lib/iomgr/timer_manager.cc',
        'src/core/lib/iomgr/timer_uv.cc',
        'src/core/lib/iomgr/udp_server.cc',
        'src/core/lib/iomgr/unix_sockets_posix.cc',
        'src/core/lib/iomgr/unix_sockets_posix_noop.cc',
        'src/core/lib/iomgr/wakeup_fd_eventfd.cc',
        'src/core/lib/iomgr/wakeup_fd_nospecial.cc',
        'src/core/lib/iomgr/wakeup_fd_pipe.cc',
        'src/core/lib/iomgr/wakeup_fd_posix.cc',
        'src/core/lib/json/json.cc',
        'src/core/lib/json/json_reader.cc',
        'src/core/lib/json/json_string.cc',
        'src/core/lib/json/json_writer.cc',
        'src/core/lib/slice/b64.cc',
        'src/core/lib/slice/percent_encoding.cc',
        'src/core/lib/slice/slice.cc',
        'src/core/lib/slice/slice_buffer.cc',
        'src/core/lib/slice/slice_intern.cc',
        'src/core/lib/slice/slice_string_helpers.cc',
        'src/core/lib/surface/api_trace.cc',
        'src/core/lib/surface/byte_buffer.cc',
        'src/core/lib/surface/byte_buffer_reader.cc',
        'src/core/lib/surface/call.cc',
        'src/core/lib/surface/call_details.cc',
        'src/core/lib/surface/call_log_batch.cc',
        'src/core/lib/surface/channel.cc',
        'src/core/lib/surface/channel_init.cc',
        'src/core/lib/surface/channel_ping.cc',
        'src/core/lib/surface/channel_stack_type.cc',
        'src/core/lib/surface/completion_queue.cc',
        'src/core/lib/surface/completion_queue_factory.cc',
        'src/core/lib/surface/event_string.cc',
        'src/core/lib/surface/lame_client.cc',
        'src/core/lib/surface/metadata_array.cc',
        'src/core/lib/surface/server.cc',
        'src/core/lib/surface/validate_metadata.cc',
        'src/core/lib/surface/version.cc',
        'src/core/lib/transport/bdp_estimator.cc',
        'src/core/lib/transport/byte_stream.cc',
        'src/core/lib/transport/connectivity_state.cc',
        'src/core/lib/transport/error_utils.cc',
        'src/core/lib/transport/metadata.cc',
        'src/core/lib/transport/metadata_batch.cc',
        'src/core/lib/transport/pid_controller.cc',
        'src/core/lib/transport/static_metadata.cc',
        'src/core/lib/transport/status_conversion.cc',
        'src/core/lib/transport/status_metadata.cc',
        'src/core/lib/transport/timeout_encoding.cc',
        'src/core/lib/transport/transport.cc',
        'src/core/lib/transport/transport_op_string.cc',
        'src/core/lib/uri/uri_parser.cc',
        'src/core/lib/debug/trace.cc',
        'src/core/ext/transport/chttp2/server/insecure/server_chttp2.cc',
        'src/core/ext/transport/chttp2/server/insecure/server_chttp2_posix.cc',
        'src/core/ext/transport/chttp2/transport/bin_decoder.cc',
        'src/core/ext/transport/chttp2/transport/bin_encoder.cc',
        'src/core/ext/transport/chttp2/transport/chttp2_plugin.cc',
        'src/core/ext/transport/chttp2/transport/chttp2_transport.cc',
        'src/core/ext/transport/chttp2/transport/context_list.cc',
        'src/core/ext/transport/chttp2/transport/flow_control.cc',
        'src/core/ext/transport/chttp2/transport/frame_data.cc',
        'src/core/ext/transport/chttp2/transport/frame_goaway.cc',
        'src/core/ext/transport/chttp2/transport/frame_ping.cc',
        'src/core/ext/transport/chttp2/transport/frame_rst_stream.cc',
        'src/core/ext/transport/chttp2/transport/frame_settings.cc',
        'src/core/ext/transport/chttp2/transport/frame_window_update.cc',
        'src/core/ext/transport/chttp2/transport/hpack_encoder.cc',
        'src/core/ext/transport/chttp2/transport/hpack_parser.cc',
        'src/core/ext/transport/chttp2/transport/hpack_table.cc',
        'src/core/ext/transport/chttp2/transport/http2_settings.cc',
        'src/core/ext/transport/chttp2/transport/huffsyms.cc',
        'src/core/ext/transport/chttp2/transport/incoming_metadata.cc',
        'src/core/ext/transport/chttp2/transport/parsing.cc',
        'src/core/ext/transport/chttp2/transport/stream_lists.cc',
        'src/core/ext/transport/chttp2/transport/stream_map.cc',
        'src/core/ext/transport/chttp2/transport/varint.cc',
        'src/core/ext/transport/chttp2/transport/writing.cc',
        'src/core/ext/transport/chttp2/alpn/alpn.cc',
        'src/core/ext/filters/http/client/http_client_filter.cc',
        'src/core/ext/filters/http/http_filters_plugin.cc',
        'src/core/ext/filters/http/message_compress/message_compress_filter.cc',
        'src/core/ext/filters/http/server/http_server_filter.cc',
        'src/core/ext/transport/chttp2/server/chttp2_server.cc',
        'src/core/ext/transport/chttp2/client/insecure/channel_create.cc',
        'src/core/ext/transport/chttp2/client/insecure/channel_create_posix.cc',
        'src/core/ext/transport/chttp2/client/authority.cc',
        'src/core/ext/transport/chttp2/client/chttp2_connector.cc',
        'src/core/ext/filters/client_channel/backend_metric.cc',
        'src/core/ext/filters/client_channel/backup_poller.cc',
        'src/core/ext/filters/client_channel/channel_connectivity.cc',
        'src/core/ext/filters/client_channel/client_channel.cc',
        'src/core/ext/filters/client_channel/client_channel_channelz.cc',
        'src/core/ext/filters/client_channel/client_channel_factory.cc',
        'src/core/ext/filters/client_channel/client_channel_plugin.cc',
        'src/core/ext/filters/client_channel/connector.cc',
        'src/core/ext/filters/client_channel/global_subchannel_pool.cc',
        'src/core/ext/filters/client_channel/health/health_check_client.cc',
        'src/core/ext/filters/client_channel/http_connect_handshaker.cc',
        'src/core/ext/filters/client_channel/http_proxy.cc',
        'src/core/ext/filters/client_channel/lb_policy.cc',
        'src/core/ext/filters/client_channel/lb_policy_registry.cc',
        'src/core/ext/filters/client_channel/local_subchannel_pool.cc',
        'src/core/ext/filters/client_channel/parse_address.cc',
        'src/core/ext/filters/client_channel/proxy_mapper.cc',
        'src/core/ext/filters/client_channel/proxy_mapper_registry.cc',
        'src/core/ext/filters/client_channel/resolver.cc',
        'src/core/ext/filters/client_channel/resolver_registry.cc',
        'src/core/ext/filters/client_channel/resolver_result_parsing.cc',
        'src/core/ext/filters/client_channel/resolving_lb_policy.cc',
        'src/core/ext/filters/client_channel/retry_throttle.cc',
        'src/core/ext/filters/client_channel/server_address.cc',
        'src/core/ext/filters/client_channel/service_config.cc',
        'src/core/ext/filters/client_channel/subchannel.cc',
        'src/core/ext/filters/client_channel/subchannel_pool_interface.cc',
        'src/core/ext/filters/deadline/deadline_filter.cc',
        'src/core/ext/upb-generated/src/proto/grpc/health/v1/health.upb.c',
        'third_party/upb/upb/decode.c',
        'third_party/upb/upb/encode.c',
        'third_party/upb/upb/msg.c',
        'third_party/upb/upb/port.c',
        'third_party/upb/upb/table.c',
        'third_party/upb/upb/upb.c',
        'src/core/ext/upb-generated/udpa/data/orca/v1/orca_load_report.upb.c',
        'src/core/ext/upb-generated/gogoproto/gogo.upb.c',
        'src/core/ext/upb-generated/validate/validate.upb.c',
        'src/core/ext/upb-generated/google/api/annotations.upb.c',
        'src/core/ext/upb-generated/google/api/http.upb.c',
        'src/core/ext/upb-generated/google/protobuf/any.upb.c',
        'src/core/ext/upb-generated/google/protobuf/descriptor.upb.c',
        'src/core/ext/upb-generated/google/protobuf/duration.upb.c',
        'src/core/ext/upb-generated/google/protobuf/empty.upb.c',
        'src/core/ext/upb-generated/google/protobuf/struct.upb.c',
        'src/core/ext/upb-generated/google/protobuf/timestamp.upb.c',
        'src/core/ext/upb-generated/google/protobuf/wrappers.upb.c',
        'src/core/ext/upb-generated/google/rpc/status.upb.c',
        'src/core/ext/transport/inproc/inproc_plugin.cc',
        'src/core/ext/transport/inproc/inproc_transport.cc',
        'src/core/ext/filters/client_channel/resolver/dns/c_ares/dns_resolver_ares.cc',
        'src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_ev_driver.cc',
        'src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_ev_driver_libuv.cc',
        'src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_ev_driver_posix.cc',
        'src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_ev_driver_windows.cc',
        'src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_wrapper.cc',
        'src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_wrapper_fallback.cc',
        'src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_wrapper_libuv.cc',
        'src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_wrapper_posix.cc',
        'src/core/ext/filters/client_channel/resolver/dns/c_ares/grpc_ares_wrapper_windows.cc',
        'src/core/ext/filters/client_channel/resolver/dns/dns_resolver_selection.cc',
        'src/core/ext/filters/client_channel/resolver/dns/native/dns_resolver.cc',
        'src/core/ext/filters/client_channel/resolver/sockaddr/sockaddr_resolver.cc',
        'src/core/ext/filters/client_channel/resolver/fake/fake_resolver.cc',
        'src/core/ext/filters/client_channel/resolver/xds/xds_resolver.cc',
        'src/core/ext/filters/client_channel/lb_policy/grpclb/client_load_reporting_filter.cc',
        'src/core/ext/filters/client_channel/lb_policy/grpclb/grpclb.cc',
        'src/core/ext/filters/client_channel/lb_policy/grpclb/grpclb_channel.cc',
        'src/core/ext/filters/client_channel/lb_policy/grpclb/grpclb_client_stats.cc',
        'src/core/ext/filters/client_channel/lb_policy/grpclb/load_balancer_api.cc',
        'src/core/ext/upb-generated/src/proto/grpc/lb/v1/load_balancer.upb.c',
        'src/core/ext/filters/client_channel/lb_policy/xds/xds.cc',
        'src/core/ext/filters/client_channel/lb_policy/xds/xds_channel.cc',
        'src/core/ext/filters/client_channel/lb_policy/xds/xds_client_stats.cc',
        'src/core/ext/filters/client_channel/lb_policy/xds/xds_load_balancer_api.cc',
        'src/core/ext/upb-generated/envoy/api/v2/auth/cert.upb.c',
        'src/core/ext/upb-generated/envoy/api/v2/cds.upb.c',
        'src/core/ext/upb-generated/envoy/api/v2/cluster/circuit_breaker.upb.c',
        'src/core/ext/upb-generated/envoy/api/v2/cluster/filter.upb.c',
        'src/core/ext/upb-generated/envoy/api/v2/cluster/outlier_detection.upb.c',
        'src/core/ext/upb-generated/envoy/api/v2/discovery.upb.c',
        'src/core/ext/upb-generated/envoy/api/v2/eds.upb.c',
        'src/core/ext/upb-generated/envoy/api/v2/endpoint/endpoint.upb.c',
        'src/core/ext/upb-generated/envoy/api/v2/endpoint/load_report.upb.c',
        'src/core/ext/upb-generated/envoy/service/discovery/v2/ads.upb.c',
        'src/core/ext/upb-generated/envoy/service/load_stats/v2/lrs.upb.c',
        'src/core/ext/upb-generated/envoy/api/v2/core/address.upb.c',
        'src/core/ext/upb-generated/envoy/api/v2/core/base.upb.c',
        'src/core/ext/upb-generated/envoy/api/v2/core/config_source.upb.c',
        'src/core/ext/upb-generated/envoy/api/v2/core/grpc_service.upb.c',
        'src/core/ext/upb-generated/envoy/api/v2/core/health_check.upb.c',
        'src/core/ext/upb-generated/envoy/api/v2/core/http_uri.upb.c',
        'src/core/ext/upb-generated/envoy/api/v2/core/protocol.upb.c',
        'src/core/ext/upb-generated/envoy/type/percent.upb.c',
        'src/core/ext/upb-generated/envoy/type/range.upb.c',
        'src/core/ext/filters/client_channel/lb_policy/pick_first/pick_first.cc',
        'src/core/ext/filters/client_channel/lb_policy/round_robin/round_robin.cc',
        'src/core/ext/filters/census/grpc_context.cc',
        'src/core/ext/filters/client_idle/client_idle_filter.cc',
        'src/core/ext/filters/max_age/max_age_filter.cc',
        'src/core/ext/filters/message_size/message_size_filter.cc',
        'src/core/ext/filters/http/client_authority_filter.cc',
        'src/core/ext/filters/workarounds/workaround_cronet_compression_filter.cc',
        'src/core/ext/filters/workarounds/workaround_utils.cc',
        'src/core/plugin_registry/grpc_unsecure_plugin_registry.cc',
      ],
    },
    {
      'target_name': 'reconnect_server',
      'type': 'static_library',
      'dependencies': [
        'test_tcp_server',
        'grpc_test_util',
        'grpc',
        'gpr',
      ],
      'sources': [
        'test/core/util/reconnect_server.cc',
      ],
    },
    {
      'target_name': 'test_tcp_server',
      'type': 'static_library',
      'dependencies': [
        'grpc_test_util',
        'grpc',
        'gpr',
      ],
      'sources': [
        'test/core/util/test_tcp_server.cc',
      ],
    },
    {
      'target_name': 'bm_callback_test_service_impl',
      'type': 'static_library',
      'dependencies': [
        'grpc_benchmark',
        'benchmark',
        'grpc++_test_util_unsecure',
        'grpc_test_util_unsecure',
        'grpc++_unsecure',
        'grpc_unsecure',
        'gpr',
        'grpc++_test_config',
      ],
      'sources': [
        'src/proto/grpc/testing/echo.proto',
        'test/cpp/microbenchmarks/callback_test_service.cc',
      ],
    },
    {
      'target_name': 'dns_test_util',
      'type': 'static_library',
      'dependencies': [
      ],
      'sources': [
        'test/cpp/naming/dns_test_util.cc',
      ],
    },
    {
      'target_name': 'grpc++',
      'type': 'static_library',
      'dependencies': [
        'grpc',
        'gpr',
      ],
      'sources': [
        'src/cpp/client/insecure_credentials.cc',
        'src/cpp/client/secure_credentials.cc',
        'src/cpp/common/auth_property_iterator.cc',
        'src/cpp/common/secure_auth_context.cc',
        'src/cpp/common/secure_channel_arguments.cc',
        'src/cpp/common/secure_create_auth_context.cc',
        'src/cpp/server/insecure_server_credentials.cc',
        'src/cpp/server/secure_server_credentials.cc',
        'src/cpp/client/channel_cc.cc',
        'src/cpp/client/client_context.cc',
        'src/cpp/client/client_interceptor.cc',
        'src/cpp/client/create_channel.cc',
        'src/cpp/client/create_channel_internal.cc',
        'src/cpp/client/create_channel_posix.cc',
        'src/cpp/client/credentials_cc.cc',
        'src/cpp/client/generic_stub.cc',
        'src/cpp/common/alarm.cc',
        'src/cpp/common/channel_arguments.cc',
        'src/cpp/common/channel_filter.cc',
        'src/cpp/common/completion_queue_cc.cc',
        'src/cpp/common/core_codegen.cc',
        'src/cpp/common/resource_quota_cc.cc',
        'src/cpp/common/rpc_method.cc',
        'src/cpp/common/validate_service_config.cc',
        'src/cpp/common/version_cc.cc',
        'src/cpp/server/async_generic_service.cc',
        'src/cpp/server/channel_argument_option.cc',
        'src/cpp/server/create_default_thread_pool.cc',
        'src/cpp/server/dynamic_thread_pool.cc',
        'src/cpp/server/external_connection_acceptor_impl.cc',
        'src/cpp/server/health/default_health_check_service.cc',
        'src/cpp/server/health/health_check_service.cc',
        'src/cpp/server/health/health_check_service_server_builder_option.cc',
        'src/cpp/server/server_builder.cc',
        'src/cpp/server/server_cc.cc',
        'src/cpp/server/server_context.cc',
        'src/cpp/server/server_credentials.cc',
        'src/cpp/server/server_posix.cc',
        'src/cpp/thread_manager/thread_manager.cc',
        'src/cpp/util/byte_buffer_cc.cc',
        'src/cpp/util/status.cc',
        'src/cpp/util/string_ref.cc',
        'src/cpp/util/time_cc.cc',
        'src/core/ext/upb-generated/src/proto/grpc/health/v1/health.upb.c',
        'third_party/upb/upb/decode.c',
        'third_party/upb/upb/encode.c',
        'third_party/upb/upb/msg.c',
        'third_party/upb/upb/port.c',
        'third_party/upb/upb/table.c',
        'third_party/upb/upb/upb.c',
        'src/cpp/codegen/codegen_init.cc',
      ],
    },
    {
      'target_name': 'grpc++_core_stats',
      'type': 'static_library',
      'dependencies': [
        'grpc++',
      ],
      'sources': [
        'src/proto/grpc/core/stats.proto',
        'src/cpp/util/core_stats.cc',
      ],
    },
    {
      'target_name': 'grpc++_error_details',
      'type': 'static_library',
      'dependencies': [
        'grpc++',
      ],
      'sources': [
        'src/proto/grpc/status/status.proto',
        'src/cpp/util/error_details.cc',
      ],
    },
    {
      'target_name': 'grpc++_proto_reflection_desc_db',
      'type': 'static_library',
      'dependencies': [
        'grpc++',
        'grpc',
      ],
      'sources': [
        'test/cpp/util/proto_reflection_descriptor_database.cc',
        'src/proto/grpc/reflection/v1alpha/reflection.proto',
      ],
    },
    {
      'target_name': 'grpc++_reflection',
      'type': 'static_library',
      'dependencies': [
        'grpc++',
        'grpc',
      ],
      'sources': [
        'src/cpp/ext/proto_server_reflection.cc',
        'src/cpp/ext/proto_server_reflection_plugin.cc',
        'src/proto/grpc/reflection/v1alpha/reflection.proto',
      ],
    },
    {
      'target_name': 'grpc++_test_config',
      'type': 'static_library',
      'dependencies': [
      ],
      'sources': [
        'test/cpp/util/test_config_cc.cc',
      ],
    },
    {
      'target_name': 'grpc++_test_util',
      'type': 'static_library',
      'dependencies': [
        'grpc++',
        'grpc_test_util',
        'grpc',
      ],
      'sources': [
        'src/proto/grpc/channelz/channelz.proto',
        'src/proto/grpc/health/v1/health.proto',
        'src/proto/grpc/testing/echo_messages.proto',
        'src/proto/grpc/testing/echo.proto',
        'src/proto/grpc/testing/duplicate/echo_duplicate.proto',
        'src/proto/grpc/testing/simple_messages.proto',
        'test/cpp/end2end/test_health_check_service_impl.cc',
        'test/cpp/end2end/test_service_impl.cc',
        'test/cpp/util/byte_buffer_proto_helper.cc',
        'test/cpp/util/channel_trace_proto_helper.cc',
        'test/cpp/util/create_test_channel.cc',
        'test/cpp/util/string_ref_helper.cc',
        'test/cpp/util/subprocess.cc',
        'test/cpp/util/test_credentials_provider.cc',
        'src/cpp/codegen/codegen_init.cc',
      ],
    },
    {
      'target_name': 'grpc++_test_util_unsecure',
      'type': 'static_library',
      'dependencies': [
        'grpc++_unsecure',
        'grpc_test_util_unsecure',
        'grpc_unsecure',
      ],
      'sources': [
        'src/proto/grpc/health/v1/health.proto',
        'src/proto/grpc/testing/echo_messages.proto',
        'src/proto/grpc/testing/echo.proto',
        'src/proto/grpc/testing/duplicate/echo_duplicate.proto',
        'src/proto/grpc/testing/simple_messages.proto',
        'test/cpp/end2end/test_health_check_service_impl.cc',
        'test/cpp/end2end/test_service_impl.cc',
        'test/cpp/util/byte_buffer_proto_helper.cc',
        'test/cpp/util/string_ref_helper.cc',
        'test/cpp/util/subprocess.cc',
        'src/cpp/codegen/codegen_init.cc',
      ],
    },
    {
      'target_name': 'grpc++_unsecure',
      'type': 'static_library',
      'dependencies': [
        'gpr',
        'grpc_unsecure',
      ],
      'sources': [
        'src/cpp/client/insecure_credentials.cc',
        'src/cpp/common/insecure_create_auth_context.cc',
        'src/cpp/server/insecure_server_credentials.cc',
        'src/cpp/client/channel_cc.cc',
        'src/cpp/client/client_context.cc',
        'src/cpp/client/client_interceptor.cc',
        'src/cpp/client/create_channel.cc',
        'src/cpp/client/create_channel_internal.cc',
        'src/cpp/client/create_channel_posix.cc',
        'src/cpp/client/credentials_cc.cc',
        'src/cpp/client/generic_stub.cc',
        'src/cpp/common/alarm.cc',
        'src/cpp/common/channel_arguments.cc',
        'src/cpp/common/channel_filter.cc',
        'src/cpp/common/completion_queue_cc.cc',
        'src/cpp/common/core_codegen.cc',
        'src/cpp/common/resource_quota_cc.cc',
        'src/cpp/common/rpc_method.cc',
        'src/cpp/common/validate_service_config.cc',
        'src/cpp/common/version_cc.cc',
        'src/cpp/server/async_generic_service.cc',
        'src/cpp/server/channel_argument_option.cc',
        'src/cpp/server/create_default_thread_pool.cc',
        'src/cpp/server/dynamic_thread_pool.cc',
        'src/cpp/server/external_connection_acceptor_impl.cc',
        'src/cpp/server/health/default_health_check_service.cc',
        'src/cpp/server/health/health_check_service.cc',
        'src/cpp/server/health/health_check_service_server_builder_option.cc',
        'src/cpp/server/server_builder.cc',
        'src/cpp/server/server_cc.cc',
        'src/cpp/server/server_context.cc',
        'src/cpp/server/server_credentials.cc',
        'src/cpp/server/server_posix.cc',
        'src/cpp/thread_manager/thread_manager.cc',
        'src/cpp/util/byte_buffer_cc.cc',
        'src/cpp/util/status.cc',
        'src/cpp/util/string_ref.cc',
        'src/cpp/util/time_cc.cc',
        'src/core/ext/upb-generated/src/proto/grpc/health/v1/health.upb.c',
        'third_party/upb/upb/decode.c',
        'third_party/upb/upb/encode.c',
        'third_party/upb/upb/msg.c',
        'third_party/upb/upb/port.c',
        'third_party/upb/upb/table.c',
        'third_party/upb/upb/upb.c',
        'src/cpp/codegen/codegen_init.cc',
      ],
    },
    {
      'target_name': 'grpc_benchmark',
      'type': 'static_library',
      'dependencies': [
        'benchmark',
        'grpc++_unsecure',
        'grpc_test_util_unsecure',
        'grpc_unsecure',
      ],
      'sources': [
        'test/cpp/microbenchmarks/helpers.cc',
      ],
    },
    {
      'target_name': 'grpc_cli_libs',
      'type': 'static_library',
      'dependencies': [
        'grpc++_proto_reflection_desc_db',
        'grpc++',
        'grpc',
      ],
      'sources': [
        'test/cpp/util/cli_call.cc',
        'test/cpp/util/cli_credentials.cc',
        'test/cpp/util/grpc_tool.cc',
        'test/cpp/util/proto_file_parser.cc',
        'test/cpp/util/service_describer.cc',
        'src/proto/grpc/reflection/v1alpha/reflection.proto',
      ],
    },
    {
      'target_name': 'grpc_plugin_support',
      'type': 'static_library',
      'dependencies': [
      ],
      'sources': [
        'src/compiler/cpp_generator.cc',
        'src/compiler/csharp_generator.cc',
        'src/compiler/node_generator.cc',
        'src/compiler/objective_c_generator.cc',
        'src/compiler/php_generator.cc',
        'src/compiler/python_generator.cc',
        'src/compiler/ruby_generator.cc',
      ],
    },
    {
      'target_name': 'grpcpp_channelz',
      'type': 'static_library',
      'dependencies': [
        'grpc++',
        'grpc',
      ],
      'sources': [
        'src/cpp/server/channelz/channelz_service.cc',
        'src/cpp/server/channelz/channelz_service_plugin.cc',
        'src/proto/grpc/channelz/channelz.proto',
      ],
    },
    {
      'target_name': 'http2_client_main',
      'type': 'static_library',
      'dependencies': [
        'grpc++_test_util',
        'grpc_test_util',
        'grpc++',
        'grpc',
        'grpc++_test_config',
      ],
      'sources': [
        'src/proto/grpc/testing/empty.proto',
        'src/proto/grpc/testing/messages.proto',
        'src/proto/grpc/testing/test.proto',
        'test/cpp/interop/http2_client.cc',
      ],
    },
    {
      'target_name': 'interop_client_helper',
      'type': 'static_library',
      'dependencies': [
        'grpc++_test_util',
        'grpc_test_util',
        'grpc++',
        'grpc',
        'gpr',
      ],
      'sources': [
        'src/proto/grpc/testing/messages.proto',
        'test/cpp/interop/client_helper.cc',
      ],
    },
    {
      'target_name': 'interop_client_main',
      'type': 'static_library',
      'dependencies': [
        'interop_client_helper',
        'grpc++_test_util',
        'grpc_test_util',
        'grpc++',
        'grpc',
        'gpr',
        'grpc++_test_config',
      ],
      'sources': [
        'src/proto/grpc/testing/empty.proto',
        'src/proto/grpc/testing/messages.proto',
        'src/proto/grpc/testing/test.proto',
        'test/cpp/interop/client.cc',
        'test/cpp/interop/interop_client.cc',
      ],
    },
    {
      'target_name': 'interop_server_helper',
      'type': 'static_library',
      'dependencies': [
        'grpc++_test_util',
        'grpc_test_util',
        'grpc++',
        'grpc',
        'gpr',
      ],
      'sources': [
        'test/cpp/interop/server_helper.cc',
      ],
    },
    {
      'target_name': 'interop_server_lib',
      'type': 'static_library',
      'dependencies': [
        'interop_server_helper',
        'grpc++_test_util',
        'grpc_test_util',
        'grpc++',
        'grpc',
        'gpr',
        'grpc++_test_config',
      ],
      'sources': [
        'src/proto/grpc/testing/empty.proto',
        'src/proto/grpc/testing/messages.proto',
        'src/proto/grpc/testing/test.proto',
        'test/cpp/interop/interop_server.cc',
      ],
    },
    {
      'target_name': 'interop_server_main',
      'type': 'static_library',
      'dependencies': [
        'interop_server_lib',
      ],
      'sources': [
        'test/cpp/interop/interop_server_bootstrap.cc',
      ],
    },
    {
      'target_name': 'qps',
      'type': 'static_library',
      'dependencies': [
        'grpc_test_util',
        'grpc++_test_util',
        'grpc++_core_stats',
        'grpc++',
        'grpc',
      ],
      'sources': [
        'src/proto/grpc/testing/messages.proto',
        'src/proto/grpc/testing/payloads.proto',
        'src/proto/grpc/testing/stats.proto',
        'src/proto/grpc/testing/control.proto',
        'src/proto/grpc/testing/benchmark_service.proto',
        'src/proto/grpc/testing/report_qps_scenario_service.proto',
        'src/proto/grpc/testing/worker_service.proto',
        'test/cpp/qps/benchmark_config.cc',
        'test/cpp/qps/client_async.cc',
        'test/cpp/qps/client_callback.cc',
        'test/cpp/qps/client_sync.cc',
        'test/cpp/qps/driver.cc',
        'test/cpp/qps/parse_json.cc',
        'test/cpp/qps/qps_server_builder.cc',
        'test/cpp/qps/qps_worker.cc',
        'test/cpp/qps/report.cc',
        'test/cpp/qps/server_async.cc',
        'test/cpp/qps/server_callback.cc',
        'test/cpp/qps/server_sync.cc',
        'test/cpp/qps/usage_timer.cc',
      ],
    },
    {
      'target_name': 'grpc_csharp_ext',
      'type': 'static_library',
      'dependencies': [
        'grpc',
        'gpr',
      ],
      'sources': [
        'src/csharp/ext/grpc_csharp_ext.c',
      ],
    },
    {
      'target_name': 'boringssl',
      'type': 'static_library',
      'dependencies': [
      ],
      'sources': [
        'src/boringssl/err_data.c',
        'third_party/boringssl/crypto/asn1/a_bitstr.c',
        'third_party/boringssl/crypto/asn1/a_bool.c',
        'third_party/boringssl/crypto/asn1/a_d2i_fp.c',
        'third_party/boringssl/crypto/asn1/a_dup.c',
        'third_party/boringssl/crypto/asn1/a_enum.c',
        'third_party/boringssl/crypto/asn1/a_gentm.c',
        'third_party/boringssl/crypto/asn1/a_i2d_fp.c',
        'third_party/boringssl/crypto/asn1/a_int.c',
        'third_party/boringssl/crypto/asn1/a_mbstr.c',
        'third_party/boringssl/crypto/asn1/a_object.c',
        'third_party/boringssl/crypto/asn1/a_octet.c',
        'third_party/boringssl/crypto/asn1/a_print.c',
        'third_party/boringssl/crypto/asn1/a_strnid.c',
        'third_party/boringssl/crypto/asn1/a_time.c',
        'third_party/boringssl/crypto/asn1/a_type.c',
        'third_party/boringssl/crypto/asn1/a_utctm.c',
        'third_party/boringssl/crypto/asn1/a_utf8.c',
        'third_party/boringssl/crypto/asn1/asn1_lib.c',
        'third_party/boringssl/crypto/asn1/asn1_par.c',
        'third_party/boringssl/crypto/asn1/asn_pack.c',
        'third_party/boringssl/crypto/asn1/f_enum.c',
        'third_party/boringssl/crypto/asn1/f_int.c',
        'third_party/boringssl/crypto/asn1/f_string.c',
        'third_party/boringssl/crypto/asn1/tasn_dec.c',
        'third_party/boringssl/crypto/asn1/tasn_enc.c',
        'third_party/boringssl/crypto/asn1/tasn_fre.c',
        'third_party/boringssl/crypto/asn1/tasn_new.c',
        'third_party/boringssl/crypto/asn1/tasn_typ.c',
        'third_party/boringssl/crypto/asn1/tasn_utl.c',
        'third_party/boringssl/crypto/asn1/time_support.c',
        'third_party/boringssl/crypto/base64/base64.c',
        'third_party/boringssl/crypto/bio/bio.c',
        'third_party/boringssl/crypto/bio/bio_mem.c',
        'third_party/boringssl/crypto/bio/connect.c',
        'third_party/boringssl/crypto/bio/fd.c',
        'third_party/boringssl/crypto/bio/file.c',
        'third_party/boringssl/crypto/bio/hexdump.c',
        'third_party/boringssl/crypto/bio/pair.c',
        'third_party/boringssl/crypto/bio/printf.c',
        'third_party/boringssl/crypto/bio/socket.c',
        'third_party/boringssl/crypto/bio/socket_helper.c',
        'third_party/boringssl/crypto/bn_extra/bn_asn1.c',
        'third_party/boringssl/crypto/bn_extra/convert.c',
        'third_party/boringssl/crypto/buf/buf.c',
        'third_party/boringssl/crypto/bytestring/asn1_compat.c',
        'third_party/boringssl/crypto/bytestring/ber.c',
        'third_party/boringssl/crypto/bytestring/cbb.c',
        'third_party/boringssl/crypto/bytestring/cbs.c',
        'third_party/boringssl/crypto/chacha/chacha.c',
        'third_party/boringssl/crypto/cipher_extra/cipher_extra.c',
        'third_party/boringssl/crypto/cipher_extra/derive_key.c',
        'third_party/boringssl/crypto/cipher_extra/e_aesccm.c',
        'third_party/boringssl/crypto/cipher_extra/e_aesctrhmac.c',
        'third_party/boringssl/crypto/cipher_extra/e_aesgcmsiv.c',
        'third_party/boringssl/crypto/cipher_extra/e_chacha20poly1305.c',
        'third_party/boringssl/crypto/cipher_extra/e_null.c',
        'third_party/boringssl/crypto/cipher_extra/e_rc2.c',
        'third_party/boringssl/crypto/cipher_extra/e_rc4.c',
        'third_party/boringssl/crypto/cipher_extra/e_ssl3.c',
        'third_party/boringssl/crypto/cipher_extra/e_tls.c',
        'third_party/boringssl/crypto/cipher_extra/tls_cbc.c',
        'third_party/boringssl/crypto/cmac/cmac.c',
        'third_party/boringssl/crypto/conf/conf.c',
        'third_party/boringssl/crypto/cpu-aarch64-fuchsia.c',
        'third_party/boringssl/crypto/cpu-aarch64-linux.c',
        'third_party/boringssl/crypto/cpu-arm-linux.c',
        'third_party/boringssl/crypto/cpu-arm.c',
        'third_party/boringssl/crypto/cpu-intel.c',
        'third_party/boringssl/crypto/cpu-ppc64le.c',
        'third_party/boringssl/crypto/crypto.c',
        'third_party/boringssl/crypto/curve25519/spake25519.c',
        'third_party/boringssl/crypto/dh/check.c',
        'third_party/boringssl/crypto/dh/dh.c',
        'third_party/boringssl/crypto/dh/dh_asn1.c',
        'third_party/boringssl/crypto/dh/params.c',
        'third_party/boringssl/crypto/digest_extra/digest_extra.c',
        'third_party/boringssl/crypto/dsa/dsa.c',
        'third_party/boringssl/crypto/dsa/dsa_asn1.c',
        'third_party/boringssl/crypto/ec_extra/ec_asn1.c',
        'third_party/boringssl/crypto/ecdh/ecdh.c',
        'third_party/boringssl/crypto/ecdsa_extra/ecdsa_asn1.c',
        'third_party/boringssl/crypto/engine/engine.c',
        'third_party/boringssl/crypto/err/err.c',
        'third_party/boringssl/crypto/evp/digestsign.c',
        'third_party/boringssl/crypto/evp/evp.c',
        'third_party/boringssl/crypto/evp/evp_asn1.c',
        'third_party/boringssl/crypto/evp/evp_ctx.c',
        'third_party/boringssl/crypto/evp/p_dsa_asn1.c',
        'third_party/boringssl/crypto/evp/p_ec.c',
        'third_party/boringssl/crypto/evp/p_ec_asn1.c',
        'third_party/boringssl/crypto/evp/p_ed25519.c',
        'third_party/boringssl/crypto/evp/p_ed25519_asn1.c',
        'third_party/boringssl/crypto/evp/p_rsa.c',
        'third_party/boringssl/crypto/evp/p_rsa_asn1.c',
        'third_party/boringssl/crypto/evp/pbkdf.c',
        'third_party/boringssl/crypto/evp/print.c',
        'third_party/boringssl/crypto/evp/scrypt.c',
        'third_party/boringssl/crypto/evp/sign.c',
        'third_party/boringssl/crypto/ex_data.c',
        'third_party/boringssl/crypto/fipsmodule/bcm.c',
        'third_party/boringssl/crypto/fipsmodule/is_fips.c',
        'third_party/boringssl/crypto/hkdf/hkdf.c',
        'third_party/boringssl/crypto/lhash/lhash.c',
        'third_party/boringssl/crypto/mem.c',
        'third_party/boringssl/crypto/obj/obj.c',
        'third_party/boringssl/crypto/obj/obj_xref.c',
        'third_party/boringssl/crypto/pem/pem_all.c',
        'third_party/boringssl/crypto/pem/pem_info.c',
        'third_party/boringssl/crypto/pem/pem_lib.c',
        'third_party/boringssl/crypto/pem/pem_oth.c',
        'third_party/boringssl/crypto/pem/pem_pk8.c',
        'third_party/boringssl/crypto/pem/pem_pkey.c',
        'third_party/boringssl/crypto/pem/pem_x509.c',
        'third_party/boringssl/crypto/pem/pem_xaux.c',
        'third_party/boringssl/crypto/pkcs7/pkcs7.c',
        'third_party/boringssl/crypto/pkcs7/pkcs7_x509.c',
        'third_party/boringssl/crypto/pkcs8/p5_pbev2.c',
        'third_party/boringssl/crypto/pkcs8/pkcs8.c',
        'third_party/boringssl/crypto/pkcs8/pkcs8_x509.c',
        'third_party/boringssl/crypto/poly1305/poly1305.c',
        'third_party/boringssl/crypto/poly1305/poly1305_arm.c',
        'third_party/boringssl/crypto/poly1305/poly1305_vec.c',
        'third_party/boringssl/crypto/pool/pool.c',
        'third_party/boringssl/crypto/rand_extra/deterministic.c',
        'third_party/boringssl/crypto/rand_extra/forkunsafe.c',
        'third_party/boringssl/crypto/rand_extra/fuchsia.c',
        'third_party/boringssl/crypto/rand_extra/rand_extra.c',
        'third_party/boringssl/crypto/rand_extra/windows.c',
        'third_party/boringssl/crypto/rc4/rc4.c',
        'third_party/boringssl/crypto/refcount_c11.c',
        'third_party/boringssl/crypto/refcount_lock.c',
        'third_party/boringssl/crypto/rsa_extra/rsa_asn1.c',
        'third_party/boringssl/crypto/stack/stack.c',
        'third_party/boringssl/crypto/thread.c',
        'third_party/boringssl/crypto/thread_none.c',
        'third_party/boringssl/crypto/thread_pthread.c',
        'third_party/boringssl/crypto/thread_win.c',
        'third_party/boringssl/crypto/x509/a_digest.c',
        'third_party/boringssl/crypto/x509/a_sign.c',
        'third_party/boringssl/crypto/x509/a_strex.c',
        'third_party/boringssl/crypto/x509/a_verify.c',
        'third_party/boringssl/crypto/x509/algorithm.c',
        'third_party/boringssl/crypto/x509/asn1_gen.c',
        'third_party/boringssl/crypto/x509/by_dir.c',
        'third_party/boringssl/crypto/x509/by_file.c',
        'third_party/boringssl/crypto/x509/i2d_pr.c',
        'third_party/boringssl/crypto/x509/rsa_pss.c',
        'third_party/boringssl/crypto/x509/t_crl.c',
        'third_party/boringssl/crypto/x509/t_req.c',
        'third_party/boringssl/crypto/x509/t_x509.c',
        'third_party/boringssl/crypto/x509/t_x509a.c',
        'third_party/boringssl/crypto/x509/x509.c',
        'third_party/boringssl/crypto/x509/x509_att.c',
        'third_party/boringssl/crypto/x509/x509_cmp.c',
        'third_party/boringssl/crypto/x509/x509_d2.c',
        'third_party/boringssl/crypto/x509/x509_def.c',
        'third_party/boringssl/crypto/x509/x509_ext.c',
        'third_party/boringssl/crypto/x509/x509_lu.c',
        'third_party/boringssl/crypto/x509/x509_obj.c',
        'third_party/boringssl/crypto/x509/x509_r2x.c',
        'third_party/boringssl/crypto/x509/x509_req.c',
        'third_party/boringssl/crypto/x509/x509_set.c',
        'third_party/boringssl/crypto/x509/x509_trs.c',
        'third_party/boringssl/crypto/x509/x509_txt.c',
        'third_party/boringssl/crypto/x509/x509_v3.c',
        'third_party/boringssl/crypto/x509/x509_vfy.c',
        'third_party/boringssl/crypto/x509/x509_vpm.c',
        'third_party/boringssl/crypto/x509/x509cset.c',
        'third_party/boringssl/crypto/x509/x509name.c',
        'third_party/boringssl/crypto/x509/x509rset.c',
        'third_party/boringssl/crypto/x509/x509spki.c',
        'third_party/boringssl/crypto/x509/x_algor.c',
        'third_party/boringssl/crypto/x509/x_all.c',
        'third_party/boringssl/crypto/x509/x_attrib.c',
        'third_party/boringssl/crypto/x509/x_crl.c',
        'third_party/boringssl/crypto/x509/x_exten.c',
        'third_party/boringssl/crypto/x509/x_info.c',
        'third_party/boringssl/crypto/x509/x_name.c',
        'third_party/boringssl/crypto/x509/x_pkey.c',
        'third_party/boringssl/crypto/x509/x_pubkey.c',
        'third_party/boringssl/crypto/x509/x_req.c',
        'third_party/boringssl/crypto/x509/x_sig.c',
        'third_party/boringssl/crypto/x509/x_spki.c',
        'third_party/boringssl/crypto/x509/x_val.c',
        'third_party/boringssl/crypto/x509/x_x509.c',
        'third_party/boringssl/crypto/x509/x_x509a.c',
        'third_party/boringssl/crypto/x509v3/pcy_cache.c',
        'third_party/boringssl/crypto/x509v3/pcy_data.c',
        'third_party/boringssl/crypto/x509v3/pcy_lib.c',
        'third_party/boringssl/crypto/x509v3/pcy_map.c',
        'third_party/boringssl/crypto/x509v3/pcy_node.c',
        'third_party/boringssl/crypto/x509v3/pcy_tree.c',
        'third_party/boringssl/crypto/x509v3/v3_akey.c',
        'third_party/boringssl/crypto/x509v3/v3_akeya.c',
        'third_party/boringssl/crypto/x509v3/v3_alt.c',
        'third_party/boringssl/crypto/x509v3/v3_bcons.c',
        'third_party/boringssl/crypto/x509v3/v3_bitst.c',
        'third_party/boringssl/crypto/x509v3/v3_conf.c',
        'third_party/boringssl/crypto/x509v3/v3_cpols.c',
        'third_party/boringssl/crypto/x509v3/v3_crld.c',
        'third_party/boringssl/crypto/x509v3/v3_enum.c',
        'third_party/boringssl/crypto/x509v3/v3_extku.c',
        'third_party/boringssl/crypto/x509v3/v3_genn.c',
        'third_party/boringssl/crypto/x509v3/v3_ia5.c',
        'third_party/boringssl/crypto/x509v3/v3_info.c',
        'third_party/boringssl/crypto/x509v3/v3_int.c',
        'third_party/boringssl/crypto/x509v3/v3_lib.c',
        'third_party/boringssl/crypto/x509v3/v3_ncons.c',
        'third_party/boringssl/crypto/x509v3/v3_pci.c',
        'third_party/boringssl/crypto/x509v3/v3_pcia.c',
        'third_party/boringssl/crypto/x509v3/v3_pcons.c',
        'third_party/boringssl/crypto/x509v3/v3_pku.c',
        'third_party/boringssl/crypto/x509v3/v3_pmaps.c',
        'third_party/boringssl/crypto/x509v3/v3_prn.c',
        'third_party/boringssl/crypto/x509v3/v3_purp.c',
        'third_party/boringssl/crypto/x509v3/v3_skey.c',
        'third_party/boringssl/crypto/x509v3/v3_sxnet.c',
        'third_party/boringssl/crypto/x509v3/v3_utl.c',
        'third_party/boringssl/ssl/bio_ssl.cc',
        'third_party/boringssl/ssl/custom_extensions.cc',
        'third_party/boringssl/ssl/d1_both.cc',
        'third_party/boringssl/ssl/d1_lib.cc',
        'third_party/boringssl/ssl/d1_pkt.cc',
        'third_party/boringssl/ssl/d1_srtp.cc',
        'third_party/boringssl/ssl/dtls_method.cc',
        'third_party/boringssl/ssl/dtls_record.cc',
        'third_party/boringssl/ssl/handoff.cc',
        'third_party/boringssl/ssl/handshake.cc',
        'third_party/boringssl/ssl/handshake_client.cc',
        'third_party/boringssl/ssl/handshake_server.cc',
        'third_party/boringssl/ssl/s3_both.cc',
        'third_party/boringssl/ssl/s3_lib.cc',
        'third_party/boringssl/ssl/s3_pkt.cc',
        'third_party/boringssl/ssl/ssl_aead_ctx.cc',
        'third_party/boringssl/ssl/ssl_asn1.cc',
        'third_party/boringssl/ssl/ssl_buffer.cc',
        'third_party/boringssl/ssl/ssl_cert.cc',
        'third_party/boringssl/ssl/ssl_cipher.cc',
        'third_party/boringssl/ssl/ssl_file.cc',
        'third_party/boringssl/ssl/ssl_key_share.cc',
        'third_party/boringssl/ssl/ssl_lib.cc',
        'third_party/boringssl/ssl/ssl_privkey.cc',
        'third_party/boringssl/ssl/ssl_session.cc',
        'third_party/boringssl/ssl/ssl_stat.cc',
        'third_party/boringssl/ssl/ssl_transcript.cc',
        'third_party/boringssl/ssl/ssl_versions.cc',
        'third_party/boringssl/ssl/ssl_x509.cc',
        'third_party/boringssl/ssl/t1_enc.cc',
        'third_party/boringssl/ssl/t1_lib.cc',
        'third_party/boringssl/ssl/tls13_both.cc',
        'third_party/boringssl/ssl/tls13_client.cc',
        'third_party/boringssl/ssl/tls13_enc.cc',
        'third_party/boringssl/ssl/tls13_server.cc',
        'third_party/boringssl/ssl/tls_method.cc',
        'third_party/boringssl/ssl/tls_record.cc',
        'third_party/boringssl/third_party/fiat/curve25519.c',
      ],
    },
    {
      'target_name': 'boringssl_test_util',
      'type': 'static_library',
      'dependencies': [
      ],
      'sources': [
        'third_party/boringssl/crypto/test/file_test.cc',
        'third_party/boringssl/crypto/test/malloc.cc',
        'third_party/boringssl/crypto/test/test_util.cc',
      ],
    },
    {
      'target_name': 'benchmark',
      'type': 'static_library',
      'dependencies': [
      ],
      'sources': [
        'third_party/benchmark/src/benchmark.cc',
        'third_party/benchmark/src/benchmark_api_internal.cc',
        'third_party/benchmark/src/benchmark_main.cc',
        'third_party/benchmark/src/benchmark_name.cc',
        'third_party/benchmark/src/benchmark_register.cc',
        'third_party/benchmark/src/benchmark_runner.cc',
        'third_party/benchmark/src/colorprint.cc',
        'third_party/benchmark/src/commandlineflags.cc',
        'third_party/benchmark/src/complexity.cc',
        'third_party/benchmark/src/console_reporter.cc',
        'third_party/benchmark/src/counter.cc',
        'third_party/benchmark/src/csv_reporter.cc',
        'third_party/benchmark/src/json_reporter.cc',
        'third_party/benchmark/src/reporter.cc',
        'third_party/benchmark/src/sleep.cc',
        'third_party/benchmark/src/statistics.cc',
        'third_party/benchmark/src/string_util.cc',
        'third_party/benchmark/src/sysinfo.cc',
        'third_party/benchmark/src/timers.cc',
      ],
    },
    {
      'target_name': 'z',
      'type': 'static_library',
      'dependencies': [
      ],
      'sources': [
        'third_party/zlib/adler32.c',
        'third_party/zlib/compress.c',
        'third_party/zlib/crc32.c',
        'third_party/zlib/deflate.c',
        'third_party/zlib/gzclose.c',
        'third_party/zlib/gzlib.c',
        'third_party/zlib/gzread.c',
        'third_party/zlib/gzwrite.c',
        'third_party/zlib/infback.c',
        'third_party/zlib/inffast.c',
        'third_party/zlib/inflate.c',
        'third_party/zlib/inftrees.c',
        'third_party/zlib/trees.c',
        'third_party/zlib/uncompr.c',
        'third_party/zlib/zutil.c',
      ],
    },
    {
      'target_name': 'bad_client_test',
      'type': 'static_library',
      'dependencies': [
        'grpc_test_util_unsecure',
        'grpc_unsecure',
        'gpr',
      ],
      'sources': [
        'test/core/bad_client/bad_client.cc',
      ],
    },
    {
      'target_name': 'end2end_tests',
      'type': 'static_library',
      'dependencies': [
        'grpc_test_util',
        'grpc',
        'gpr',
      ],
      'sources': [
        'test/core/end2end/end2end_tests.cc',
        'test/core/end2end/end2end_test_utils.cc',
        'test/core/end2end/tests/authority_not_supported.cc',
        'test/core/end2end/tests/bad_hostname.cc',
        'test/core/end2end/tests/bad_ping.cc',
        'test/core/end2end/tests/binary_metadata.cc',
        'test/core/end2end/tests/call_creds.cc',
        'test/core/end2end/tests/call_host_override.cc',
        'test/core/end2end/tests/cancel_after_accept.cc',
        'test/core/end2end/tests/cancel_after_client_done.cc',
        'test/core/end2end/tests/cancel_after_invoke.cc',
        'test/core/end2end/tests/cancel_after_round_trip.cc',
        'test/core/end2end/tests/cancel_before_invoke.cc',
        'test/core/end2end/tests/cancel_in_a_vacuum.cc',
        'test/core/end2end/tests/cancel_with_status.cc',
        'test/core/end2end/tests/channelz.cc',
        'test/core/end2end/tests/compressed_payload.cc',
        'test/core/end2end/tests/connectivity.cc',
        'test/core/end2end/tests/default_host.cc',
        'test/core/end2end/tests/disappearing_server.cc',
        'test/core/end2end/tests/empty_batch.cc',
        'test/core/end2end/tests/filter_call_init_fails.cc',
        'test/core/end2end/tests/filter_causes_close.cc',
        'test/core/end2end/tests/filter_context.cc',
        'test/core/end2end/tests/filter_latency.cc',
        'test/core/end2end/tests/filter_status_code.cc',
        'test/core/end2end/tests/graceful_server_shutdown.cc',
        'test/core/end2end/tests/high_initial_seqno.cc',
        'test/core/end2end/tests/hpack_size.cc',
        'test/core/end2end/tests/idempotent_request.cc',
        'test/core/end2end/tests/invoke_large_request.cc',
        'test/core/end2end/tests/keepalive_timeout.cc',
        'test/core/end2end/tests/large_metadata.cc',
        'test/core/end2end/tests/max_concurrent_streams.cc',
        'test/core/end2end/tests/max_connection_age.cc',
        'test/core/end2end/tests/max_connection_idle.cc',
        'test/core/end2end/tests/max_message_length.cc',
        'test/core/end2end/tests/negative_deadline.cc',
        'test/core/end2end/tests/no_error_on_hotpath.cc',
        'test/core/end2end/tests/no_logging.cc',
        'test/core/end2end/tests/no_op.cc',
        'test/core/end2end/tests/payload.cc',
        'test/core/end2end/tests/ping.cc',
        'test/core/end2end/tests/ping_pong_streaming.cc',
        'test/core/end2end/tests/proxy_auth.cc',
        'test/core/end2end/tests/registered_call.cc',
        'test/core/end2end/tests/request_with_flags.cc',
        'test/core/end2end/tests/request_with_payload.cc',
        'test/core/end2end/tests/resource_quota_server.cc',
        'test/core/end2end/tests/retry.cc',
        'test/core/end2end/tests/retry_cancellation.cc',
        'test/core/end2end/tests/retry_disabled.cc',
        'test/core/end2end/tests/retry_exceeds_buffer_size_in_initial_batch.cc',
        'test/core/end2end/tests/retry_exceeds_buffer_size_in_subsequent_batch.cc',
        'test/core/end2end/tests/retry_non_retriable_status.cc',
        'test/core/end2end/tests/retry_non_retriable_status_before_recv_trailing_metadata_started.cc',
        'test/core/end2end/tests/retry_recv_initial_metadata.cc',
        'test/core/end2end/tests/retry_recv_message.cc',
        'test/core/end2end/tests/retry_server_pushback_delay.cc',
        'test/core/end2end/tests/retry_server_pushback_disabled.cc',
        'test/core/end2end/tests/retry_streaming.cc',
        'test/core/end2end/tests/retry_streaming_after_commit.cc',
        'test/core/end2end/tests/retry_streaming_succeeds_before_replay_finished.cc',
        'test/core/end2end/tests/retry_throttled.cc',
        'test/core/end2end/tests/retry_too_many_attempts.cc',
        'test/core/end2end/tests/server_finishes_request.cc',
        'test/core/end2end/tests/shutdown_finishes_calls.cc',
        'test/core/end2end/tests/shutdown_finishes_tags.cc',
        'test/core/end2end/tests/simple_cacheable_request.cc',
        'test/core/end2end/tests/simple_delayed_request.cc',
        'test/core/end2end/tests/simple_metadata.cc',
        'test/core/end2end/tests/simple_request.cc',
        'test/core/end2end/tests/stream_compression_compressed_payload.cc',
        'test/core/end2end/tests/stream_compression_payload.cc',
        'test/core/end2end/tests/stream_compression_ping_pong_streaming.cc',
        'test/core/end2end/tests/streaming_error_response.cc',
        'test/core/end2end/tests/trailing_metadata.cc',
        'test/core/end2end/tests/workaround_cronet_compression.cc',
        'test/core/end2end/tests/write_buffering.cc',
        'test/core/end2end/tests/write_buffering_at_end.cc',
      ],
    },
    {
      'target_name': 'end2end_nosec_tests',
      'type': 'static_library',
      'dependencies': [
        'grpc_test_util_unsecure',
        'grpc_unsecure',
        'gpr',
      ],
      'sources': [
        'test/core/end2end/end2end_nosec_tests.cc',
        'test/core/end2end/end2end_test_utils.cc',
        'test/core/end2end/tests/authority_not_supported.cc',
        'test/core/end2end/tests/bad_hostname.cc',
        'test/core/end2end/tests/bad_ping.cc',
        'test/core/end2end/tests/binary_metadata.cc',
        'test/core/end2end/tests/call_host_override.cc',
        'test/core/end2end/tests/cancel_after_accept.cc',
        'test/core/end2end/tests/cancel_after_client_done.cc',
        'test/core/end2end/tests/cancel_after_invoke.cc',
        'test/core/end2end/tests/cancel_after_round_trip.cc',
        'test/core/end2end/tests/cancel_before_invoke.cc',
        'test/core/end2end/tests/cancel_in_a_vacuum.cc',
        'test/core/end2end/tests/cancel_with_status.cc',
        'test/core/end2end/tests/channelz.cc',
        'test/core/end2end/tests/compressed_payload.cc',
        'test/core/end2end/tests/connectivity.cc',
        'test/core/end2end/tests/default_host.cc',
        'test/core/end2end/tests/disappearing_server.cc',
        'test/core/end2end/tests/empty_batch.cc',
        'test/core/end2end/tests/filter_call_init_fails.cc',
        'test/core/end2end/tests/filter_causes_close.cc',
        'test/core/end2end/tests/filter_context.cc',
        'test/core/end2end/tests/filter_latency.cc',
        'test/core/end2end/tests/filter_status_code.cc',
        'test/core/end2end/tests/graceful_server_shutdown.cc',
        'test/core/end2end/tests/high_initial_seqno.cc',
        'test/core/end2end/tests/hpack_size.cc',
        'test/core/end2end/tests/idempotent_request.cc',
        'test/core/end2end/tests/invoke_large_request.cc',
        'test/core/end2end/tests/keepalive_timeout.cc',
        'test/core/end2end/tests/large_metadata.cc',
        'test/core/end2end/tests/max_concurrent_streams.cc',
        'test/core/end2end/tests/max_connection_age.cc',
        'test/core/end2end/tests/max_connection_idle.cc',
        'test/core/end2end/tests/max_message_length.cc',
        'test/core/end2end/tests/negative_deadline.cc',
        'test/core/end2end/tests/no_error_on_hotpath.cc',
        'test/core/end2end/tests/no_logging.cc',
        'test/core/end2end/tests/no_op.cc',
        'test/core/end2end/tests/payload.cc',
        'test/core/end2end/tests/ping.cc',
        'test/core/end2end/tests/ping_pong_streaming.cc',
        'test/core/end2end/tests/proxy_auth.cc',
        'test/core/end2end/tests/registered_call.cc',
        'test/core/end2end/tests/request_with_flags.cc',
        'test/core/end2end/tests/request_with_payload.cc',
        'test/core/end2end/tests/resource_quota_server.cc',
        'test/core/end2end/tests/retry.cc',
        'test/core/end2end/tests/retry_cancellation.cc',
        'test/core/end2end/tests/retry_disabled.cc',
        'test/core/end2end/tests/retry_exceeds_buffer_size_in_initial_batch.cc',
        'test/core/end2end/tests/retry_exceeds_buffer_size_in_subsequent_batch.cc',
        'test/core/end2end/tests/retry_non_retriable_status.cc',
        'test/core/end2end/tests/retry_non_retriable_status_before_recv_trailing_metadata_started.cc',
        'test/core/end2end/tests/retry_recv_initial_metadata.cc',
        'test/core/end2end/tests/retry_recv_message.cc',
        'test/core/end2end/tests/retry_server_pushback_delay.cc',
        'test/core/end2end/tests/retry_server_pushback_disabled.cc',
        'test/core/end2end/tests/retry_streaming.cc',
        'test/core/end2end/tests/retry_streaming_after_commit.cc',
        'test/core/end2end/tests/retry_streaming_succeeds_before_replay_finished.cc',
        'test/core/end2end/tests/retry_throttled.cc',
        'test/core/end2end/tests/retry_too_many_attempts.cc',
        'test/core/end2end/tests/server_finishes_request.cc',
        'test/core/end2end/tests/shutdown_finishes_calls.cc',
        'test/core/end2end/tests/shutdown_finishes_tags.cc',
        'test/core/end2end/tests/simple_cacheable_request.cc',
        'test/core/end2end/tests/simple_delayed_request.cc',
        'test/core/end2end/tests/simple_metadata.cc',
        'test/core/end2end/tests/simple_request.cc',
        'test/core/end2end/tests/stream_compression_compressed_payload.cc',
        'test/core/end2end/tests/stream_compression_payload.cc',
        'test/core/end2end/tests/stream_compression_ping_pong_streaming.cc',
        'test/core/end2end/tests/streaming_error_response.cc',
        'test/core/end2end/tests/trailing_metadata.cc',
        'test/core/end2end/tests/workaround_cronet_compression.cc',
        'test/core/end2end/tests/write_buffering.cc',
        'test/core/end2end/tests/write_buffering_at_end.cc',
      ],
    },
  ]
}
