; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -relocation-model=pic -mtriple=mipsel-- -mcpu=mips32r5 -mattr=+abs2008 \
; RUN:     -mattr=+fp64,+msa -verify-machineinstrs -mips-jalr-reloc=false < %s | FileCheck %s \
; RUN:     --check-prefixes=ALL,MIPS32,MIPSR5,MIPS32-O32,MIPS32R5-O32
; RUN: llc -relocation-model=pic -mtriple=mips64el-- -mcpu=mips64r5 -mattr=+abs2008 \
; RUN:     -mattr=+fp64,+msa -verify-machineinstrs -target-abi n32 -mips-jalr-reloc=false < %s | FileCheck %s \
; RUN:     --check-prefixes=ALL,MIPS64,MIPSR5,MIPS64-N32,MIPS64R5-N32
; RUN: llc -relocation-model=pic -mtriple=mips64el-- -mcpu=mips64r5 -mattr=+abs2008 \
; RUN:     -mattr=+fp64,+msa -verify-machineinstrs -target-abi n64 -mips-jalr-reloc=false < %s | FileCheck %s \
; RUN:     --check-prefixes=ALL,MIPS64,MIPSR5,MIPS64-N64,MIPS64R5-N64

; RUN: llc -relocation-model=pic -mtriple=mipsel-- -mcpu=mips32r6 \
; RUN:     -mattr=+fp64,+msa -verify-machineinstrs -mips-jalr-reloc=false < %s | FileCheck %s \
; RUN:     --check-prefixes=ALL,MIPS32,MIPSR6,MIPSR6-O32
; RUN: llc -relocation-model=pic -mtriple=mips64el-- -mcpu=mips64r6 \
; RUN:     -mattr=+fp64,+msa -verify-machineinstrs -target-abi n32 -mips-jalr-reloc=false < %s | FileCheck %s \
; RUN:     --check-prefixes=ALL,MIPS64,MIPSR6,MIPS64-N32,MIPSR6-N32
; RUN: llc -relocation-model=pic -mtriple=mips64el-- -mcpu=mips64r6 \
; RUN:     -mattr=+fp64,+msa -verify-machineinstrs -target-abi n64 -mips-jalr-reloc=false < %s | FileCheck %s \
; RUN:     --check-prefixes=ALL,MIPS64,MIPSR6,MIPS64-N64,MIPSR6-N64


; Check the use of frame indexes in the msa pseudo f16 instructions.

@k = external global float

declare float @k2(half *)

define void @f3(i16 %b) {
; MIPS32-LABEL: f3:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-NEXT:    addiu $sp, $sp, -32
; MIPS32-NEXT:    .cfi_def_cfa_offset 32
; MIPS32-NEXT:    sw $ra, 28($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $16, 24($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    .cfi_offset 31, -4
; MIPS32-NEXT:    .cfi_offset 16, -8
; MIPS32-NEXT:    addu $16, $2, $25
; MIPS32-NEXT:    sh $4, 22($sp)
; MIPS32-NEXT:    addiu $4, $sp, 22
; MIPS32-NEXT:    lw $25, %call16(k2)($16)
; MIPS32-NEXT:    jalr $25
; MIPS32-NEXT:    move $gp, $16
; MIPS32-NEXT:    lw $1, %got(k)($16)
; MIPS32-NEXT:    swc1 $f0, 0($1)
; MIPS32-NEXT:    lw $16, 24($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $ra, 28($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    addiu $sp, $sp, 32
;
; MIPS64-N32-LABEL: f3:
; MIPS64-N32:       # %bb.0: # %entry
; MIPS64-N32-NEXT:    addiu $sp, $sp, -32
; MIPS64-N32-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N32-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    .cfi_offset 31, -8
; MIPS64-N32-NEXT:    .cfi_offset 28, -16
; MIPS64-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(f3)))
; MIPS64-N32-NEXT:    addu $1, $1, $25
; MIPS64-N32-NEXT:    addiu $gp, $1, %lo(%neg(%gp_rel(f3)))
; MIPS64-N32-NEXT:    sh $4, 14($sp)
; MIPS64-N32-NEXT:    lw $25, %call16(k2)($gp)
; MIPS64-N32-NEXT:    jalr $25
; MIPS64-N32-NEXT:    addiu $4, $sp, 14
; MIPS64-N32-NEXT:    lw $1, %got_disp(k)($gp)
; MIPS64-N32-NEXT:    swc1 $f0, 0($1)
; MIPS64-N32-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    jr $ra
; MIPS64-N32-NEXT:    addiu $sp, $sp, 32
;
; MIPS64-N64-LABEL: f3:
; MIPS64-N64:       # %bb.0: # %entry
; MIPS64-N64-NEXT:    daddiu $sp, $sp, -32
; MIPS64-N64-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N64-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    .cfi_offset 31, -8
; MIPS64-N64-NEXT:    .cfi_offset 28, -16
; MIPS64-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(f3)))
; MIPS64-N64-NEXT:    daddu $1, $1, $25
; MIPS64-N64-NEXT:    daddiu $gp, $1, %lo(%neg(%gp_rel(f3)))
; MIPS64-N64-NEXT:    sh $4, 14($sp)
; MIPS64-N64-NEXT:    ld $25, %call16(k2)($gp)
; MIPS64-N64-NEXT:    jalr $25
; MIPS64-N64-NEXT:    daddiu $4, $sp, 14
; MIPS64-N64-NEXT:    ld $1, %got_disp(k)($gp)
; MIPS64-N64-NEXT:    swc1 $f0, 0($1)
; MIPS64-N64-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    jr $ra
; MIPS64-N64-NEXT:    daddiu $sp, $sp, 32
entry:
  %0 = alloca half
  %1 = bitcast i16 %b to half
  store half %1, half * %0
  %2 = call float @k2(half * %0)
  store float %2, float * @k
  ret void
}

define void  @f(i16 %b) {
; MIPS32-LABEL: f:
; MIPS32:       # %bb.0:
; MIPS32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-NEXT:    addiu $sp, $sp, -8
; MIPS32-NEXT:    .cfi_def_cfa_offset 8
; MIPS32-NEXT:    addu $1, $2, $25
; MIPS32-NEXT:    sh $4, 4($sp)
; MIPS32-NEXT:    lh $2, 4($sp)
; MIPS32-NEXT:    fill.h $w0, $2
; MIPS32-NEXT:    fexupr.w $w0, $w0
; MIPS32-NEXT:    copy_s.w $2, $w0[0]
; MIPS32-NEXT:    mtc1 $2, $f0
; MIPS32-NEXT:    lw $1, %got(k)($1)
; MIPS32-NEXT:    swc1 $f0, 0($1)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    addiu $sp, $sp, 8
;
; MIPS64-N32-LABEL: f:
; MIPS64-N32:       # %bb.0:
; MIPS64-N32-NEXT:    addiu $sp, $sp, -16
; MIPS64-N32-NEXT:    .cfi_def_cfa_offset 16
; MIPS64-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(f)))
; MIPS64-N32-NEXT:    addu $1, $1, $25
; MIPS64-N32-NEXT:    addiu $1, $1, %lo(%neg(%gp_rel(f)))
; MIPS64-N32-NEXT:    sh $4, 12($sp)
; MIPS64-N32-NEXT:    lh $2, 12($sp)
; MIPS64-N32-NEXT:    fill.h $w0, $2
; MIPS64-N32-NEXT:    fexupr.w $w0, $w0
; MIPS64-N32-NEXT:    copy_s.w $2, $w0[0]
; MIPS64-N32-NEXT:    mtc1 $2, $f0
; MIPS64-N32-NEXT:    lw $1, %got_disp(k)($1)
; MIPS64-N32-NEXT:    swc1 $f0, 0($1)
; MIPS64-N32-NEXT:    jr $ra
; MIPS64-N32-NEXT:    addiu $sp, $sp, 16
;
; MIPS64-N64-LABEL: f:
; MIPS64-N64:       # %bb.0:
; MIPS64-N64-NEXT:    daddiu $sp, $sp, -16
; MIPS64-N64-NEXT:    .cfi_def_cfa_offset 16
; MIPS64-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(f)))
; MIPS64-N64-NEXT:    daddu $1, $1, $25
; MIPS64-N64-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(f)))
; MIPS64-N64-NEXT:    sh $4, 12($sp)
; MIPS64-N64-NEXT:    lh $2, 12($sp)
; MIPS64-N64-NEXT:    fill.h $w0, $2
; MIPS64-N64-NEXT:    fexupr.w $w0, $w0
; MIPS64-N64-NEXT:    copy_s.w $2, $w0[0]
; MIPS64-N64-NEXT:    mtc1 $2, $f0
; MIPS64-N64-NEXT:    ld $1, %got_disp(k)($1)
; MIPS64-N64-NEXT:    swc1 $f0, 0($1)
; MIPS64-N64-NEXT:    jr $ra
; MIPS64-N64-NEXT:    daddiu $sp, $sp, 16
  %1 = bitcast i16 %b to half
  %2 = fpext half %1 to float
  store float %2, float * @k
  ret void
}

@g = external global i16, align 2
@h = external global half, align 2

; Check that fext f16 to double has a fexupr.w, fexupr.d sequence.
; Check that ftrunc double to f16 has fexdo.w, fexdo.h sequence.
; Check that MIPS64R5+ uses 64-bit floating point <-> 64-bit GPR transfers.

; We don't need to check if pre-MIPSR5 expansions occur, the MSA ASE requires
; MIPSR5. Additionally, fp64 mode / FR=1 is required to use MSA.

define void @fadd_f64() {
; MIPS32-LABEL: fadd_f64:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-NEXT:    addu $1, $2, $25
; MIPS32-NEXT:    lw $1, %got(h)($1)
; MIPS32-NEXT:    lh $2, 0($1)
; MIPS32-NEXT:    fill.h $w0, $2
; MIPS32-NEXT:    fexupr.w $w0, $w0
; MIPS32-NEXT:    fexupr.d $w0, $w0
; MIPS32-NEXT:    copy_s.w $2, $w0[0]
; MIPS32-NEXT:    mtc1 $2, $f1
; MIPS32-NEXT:    copy_s.w $2, $w0[1]
; MIPS32-NEXT:    mthc1 $2, $f1
; MIPS32-NEXT:    add.d $f0, $f1, $f1
; MIPS32-NEXT:    mfc1 $2, $f0
; MIPS32-NEXT:    fill.w $w1, $2
; MIPS32-NEXT:    mfhc1 $2, $f0
; MIPS32-NEXT:    insert.w $w1[1], $2
; MIPS32-NEXT:    insert.w $w1[3], $2
; MIPS32-NEXT:    fexdo.w $w0, $w1, $w1
; MIPS32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS32-NEXT:    copy_u.h $2, $w0[0]
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    sh $2, 0($1)
;
; MIPS64-N32-LABEL: fadd_f64:
; MIPS64-N32:       # %bb.0: # %entry
; MIPS64-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(fadd_f64)))
; MIPS64-N32-NEXT:    addu $1, $1, $25
; MIPS64-N32-NEXT:    addiu $1, $1, %lo(%neg(%gp_rel(fadd_f64)))
; MIPS64-N32-NEXT:    lw $1, %got_disp(h)($1)
; MIPS64-N32-NEXT:    lh $2, 0($1)
; MIPS64-N32-NEXT:    fill.h $w0, $2
; MIPS64-N32-NEXT:    fexupr.w $w0, $w0
; MIPS64-N32-NEXT:    fexupr.d $w0, $w0
; MIPS64-N32-NEXT:    copy_s.d $2, $w0[0]
; MIPS64-N32-NEXT:    dmtc1 $2, $f0
; MIPS64-N32-NEXT:    add.d $f0, $f0, $f0
; MIPS64-N32-NEXT:    dmfc1 $2, $f0
; MIPS64-N32-NEXT:    fill.d $w0, $2
; MIPS64-N32-NEXT:    fexdo.w $w0, $w0, $w0
; MIPS64-N32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N32-NEXT:    copy_u.h $2, $w0[0]
; MIPS64-N32-NEXT:    jr $ra
; MIPS64-N32-NEXT:    sh $2, 0($1)
;
; MIPS64-N64-LABEL: fadd_f64:
; MIPS64-N64:       # %bb.0: # %entry
; MIPS64-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(fadd_f64)))
; MIPS64-N64-NEXT:    daddu $1, $1, $25
; MIPS64-N64-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(fadd_f64)))
; MIPS64-N64-NEXT:    ld $1, %got_disp(h)($1)
; MIPS64-N64-NEXT:    lh $2, 0($1)
; MIPS64-N64-NEXT:    fill.h $w0, $2
; MIPS64-N64-NEXT:    fexupr.w $w0, $w0
; MIPS64-N64-NEXT:    fexupr.d $w0, $w0
; MIPS64-N64-NEXT:    copy_s.d $2, $w0[0]
; MIPS64-N64-NEXT:    dmtc1 $2, $f0
; MIPS64-N64-NEXT:    add.d $f0, $f0, $f0
; MIPS64-N64-NEXT:    dmfc1 $2, $f0
; MIPS64-N64-NEXT:    fill.d $w0, $2
; MIPS64-N64-NEXT:    fexdo.w $w0, $w0, $w0
; MIPS64-N64-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N64-NEXT:    copy_u.h $2, $w0[0]
; MIPS64-N64-NEXT:    jr $ra
; MIPS64-N64-NEXT:    sh $2, 0($1)
entry:
  %0 = load half, half * @h, align 2
  %1 = fpext half %0 to double
  %2 = load half, half * @h, align 2
  %3 = fpext half %2 to double
  %add = fadd double %1, %3
  %4 = fptrunc double %add to half
   store half %4, half * @h, align 2
  ret void
}

; Entire fp16 (unsigned) range fits into (signed) i32.
define i32 @ffptoui() {
; MIPS32-LABEL: ffptoui:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-NEXT:    addu $1, $2, $25
; MIPS32-NEXT:    lw $1, %got(h)($1)
; MIPS32-NEXT:    lh $1, 0($1)
; MIPS32-NEXT:    fill.h $w0, $1
; MIPS32-NEXT:    fexupr.w $w0, $w0
; MIPS32-NEXT:    fexupr.d $w0, $w0
; MIPS32-NEXT:    copy_s.w $1, $w0[0]
; MIPS32-NEXT:    mtc1 $1, $f1
; MIPS32-NEXT:    copy_s.w $1, $w0[1]
; MIPS32-NEXT:    mthc1 $1, $f1
; MIPS32-NEXT:    trunc.w.d $f0, $f1
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    mfc1 $2, $f0
;
; MIPS64-N32-LABEL: ffptoui:
; MIPS64-N32:       # %bb.0: # %entry
; MIPS64-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(ffptoui)))
; MIPS64-N32-NEXT:    addu $1, $1, $25
; MIPS64-N32-NEXT:    addiu $1, $1, %lo(%neg(%gp_rel(ffptoui)))
; MIPS64-N32-NEXT:    lw $1, %got_disp(h)($1)
; MIPS64-N32-NEXT:    lh $1, 0($1)
; MIPS64-N32-NEXT:    fill.h $w0, $1
; MIPS64-N32-NEXT:    fexupr.w $w0, $w0
; MIPS64-N32-NEXT:    fexupr.d $w0, $w0
; MIPS64-N32-NEXT:    copy_s.d $1, $w0[0]
; MIPS64-N32-NEXT:    dmtc1 $1, $f0
; MIPS64-N32-NEXT:    trunc.w.d $f0, $f0
; MIPS64-N32-NEXT:    jr $ra
; MIPS64-N32-NEXT:    mfc1 $2, $f0
;
; MIPS64-N64-LABEL: ffptoui:
; MIPS64-N64:       # %bb.0: # %entry
; MIPS64-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(ffptoui)))
; MIPS64-N64-NEXT:    daddu $1, $1, $25
; MIPS64-N64-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(ffptoui)))
; MIPS64-N64-NEXT:    ld $1, %got_disp(h)($1)
; MIPS64-N64-NEXT:    lh $1, 0($1)
; MIPS64-N64-NEXT:    fill.h $w0, $1
; MIPS64-N64-NEXT:    fexupr.w $w0, $w0
; MIPS64-N64-NEXT:    fexupr.d $w0, $w0
; MIPS64-N64-NEXT:    copy_s.d $1, $w0[0]
; MIPS64-N64-NEXT:    dmtc1 $1, $f0
; MIPS64-N64-NEXT:    trunc.w.d $f0, $f0
; MIPS64-N64-NEXT:    jr $ra
; MIPS64-N64-NEXT:    mfc1 $2, $f0
entry:
  %0 = load half, half * @h, align 2
  %1 = fptoui half %0 to i32
  ret i32 %1
}

define i32 @ffptosi() {
; MIPS32-LABEL: ffptosi:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-NEXT:    addu $1, $2, $25
; MIPS32-NEXT:    lw $1, %got(h)($1)
; MIPS32-NEXT:    lh $1, 0($1)
; MIPS32-NEXT:    fill.h $w0, $1
; MIPS32-NEXT:    fexupr.w $w0, $w0
; MIPS32-NEXT:    fexupr.d $w0, $w0
; MIPS32-NEXT:    copy_s.w $1, $w0[0]
; MIPS32-NEXT:    mtc1 $1, $f1
; MIPS32-NEXT:    copy_s.w $1, $w0[1]
; MIPS32-NEXT:    mthc1 $1, $f1
; MIPS32-NEXT:    trunc.w.d $f0, $f1
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    mfc1 $2, $f0
;
; MIPS64-N32-LABEL: ffptosi:
; MIPS64-N32:       # %bb.0: # %entry
; MIPS64-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(ffptosi)))
; MIPS64-N32-NEXT:    addu $1, $1, $25
; MIPS64-N32-NEXT:    addiu $1, $1, %lo(%neg(%gp_rel(ffptosi)))
; MIPS64-N32-NEXT:    lw $1, %got_disp(h)($1)
; MIPS64-N32-NEXT:    lh $1, 0($1)
; MIPS64-N32-NEXT:    fill.h $w0, $1
; MIPS64-N32-NEXT:    fexupr.w $w0, $w0
; MIPS64-N32-NEXT:    fexupr.d $w0, $w0
; MIPS64-N32-NEXT:    copy_s.d $1, $w0[0]
; MIPS64-N32-NEXT:    dmtc1 $1, $f0
; MIPS64-N32-NEXT:    trunc.w.d $f0, $f0
; MIPS64-N32-NEXT:    jr $ra
; MIPS64-N32-NEXT:    mfc1 $2, $f0
;
; MIPS64-N64-LABEL: ffptosi:
; MIPS64-N64:       # %bb.0: # %entry
; MIPS64-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(ffptosi)))
; MIPS64-N64-NEXT:    daddu $1, $1, $25
; MIPS64-N64-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(ffptosi)))
; MIPS64-N64-NEXT:    ld $1, %got_disp(h)($1)
; MIPS64-N64-NEXT:    lh $1, 0($1)
; MIPS64-N64-NEXT:    fill.h $w0, $1
; MIPS64-N64-NEXT:    fexupr.w $w0, $w0
; MIPS64-N64-NEXT:    fexupr.d $w0, $w0
; MIPS64-N64-NEXT:    copy_s.d $1, $w0[0]
; MIPS64-N64-NEXT:    dmtc1 $1, $f0
; MIPS64-N64-NEXT:    trunc.w.d $f0, $f0
; MIPS64-N64-NEXT:    jr $ra
; MIPS64-N64-NEXT:    mfc1 $2, $f0
entry:
  %0 = load half, half * @h, align 2
  %1 = fptosi half %0 to i32
  ret i32 %1




}

define void @uitofp(i32 %a) {
; MIPS32-LABEL: uitofp:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-NEXT:    addiu $sp, $sp, -8
; MIPS32-NEXT:    .cfi_def_cfa_offset 8
; MIPS32-NEXT:    addu $1, $2, $25
; MIPS32-NEXT:    lui $2, 17200
; MIPS32-NEXT:    sw $2, 4($sp)
; MIPS32-NEXT:    sw $4, 0($sp)
; MIPS32-NEXT:    lw $2, %got($CPI5_0)($1)
; MIPS32-NEXT:    ldc1 $f0, %lo($CPI5_0)($2)
; MIPS32-NEXT:    ldc1 $f1, 0($sp)
; MIPS32-NEXT:    sub.d $f0, $f1, $f0
; MIPS32-NEXT:    mfc1 $2, $f0
; MIPS32-NEXT:    fill.w $w1, $2
; MIPS32-NEXT:    mfhc1 $2, $f0
; MIPS32-NEXT:    insert.w $w1[1], $2
; MIPS32-NEXT:    insert.w $w1[3], $2
; MIPS32-NEXT:    fexdo.w $w0, $w1, $w1
; MIPS32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS32-NEXT:    lw $1, %got(h)($1)
; MIPS32-NEXT:    copy_u.h $2, $w0[0]
; MIPS32-NEXT:    sh $2, 0($1)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    addiu $sp, $sp, 8
;
; MIPS64-N32-LABEL: uitofp:
; MIPS64-N32:       # %bb.0: # %entry
; MIPS64-N32-NEXT:    addiu $sp, $sp, -16
; MIPS64-N32-NEXT:    .cfi_def_cfa_offset 16
; MIPS64-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(uitofp)))
; MIPS64-N32-NEXT:    addu $1, $1, $25
; MIPS64-N32-NEXT:    addiu $1, $1, %lo(%neg(%gp_rel(uitofp)))
; MIPS64-N32-NEXT:    lui $2, 17200
; MIPS64-N32-NEXT:    sw $2, 12($sp)
; MIPS64-N32-NEXT:    sll $2, $4, 0
; MIPS64-N32-NEXT:    sw $2, 8($sp)
; MIPS64-N32-NEXT:    lw $2, %got_page(.LCPI5_0)($1)
; MIPS64-N32-NEXT:    ldc1 $f0, %got_ofst(.LCPI5_0)($2)
; MIPS64-N32-NEXT:    ldc1 $f1, 8($sp)
; MIPS64-N32-NEXT:    sub.d $f0, $f1, $f0
; MIPS64-N32-NEXT:    dmfc1 $2, $f0
; MIPS64-N32-NEXT:    fill.d $w0, $2
; MIPS64-N32-NEXT:    fexdo.w $w0, $w0, $w0
; MIPS64-N32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N32-NEXT:    lw $1, %got_disp(h)($1)
; MIPS64-N32-NEXT:    copy_u.h $2, $w0[0]
; MIPS64-N32-NEXT:    sh $2, 0($1)
; MIPS64-N32-NEXT:    jr $ra
; MIPS64-N32-NEXT:    addiu $sp, $sp, 16
;
; MIPS64-N64-LABEL: uitofp:
; MIPS64-N64:       # %bb.0: # %entry
; MIPS64-N64-NEXT:    daddiu $sp, $sp, -16
; MIPS64-N64-NEXT:    .cfi_def_cfa_offset 16
; MIPS64-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(uitofp)))
; MIPS64-N64-NEXT:    daddu $1, $1, $25
; MIPS64-N64-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(uitofp)))
; MIPS64-N64-NEXT:    lui $2, 17200
; MIPS64-N64-NEXT:    sw $2, 12($sp)
; MIPS64-N64-NEXT:    sll $2, $4, 0
; MIPS64-N64-NEXT:    sw $2, 8($sp)
; MIPS64-N64-NEXT:    ld $2, %got_page(.LCPI5_0)($1)
; MIPS64-N64-NEXT:    ldc1 $f0, %got_ofst(.LCPI5_0)($2)
; MIPS64-N64-NEXT:    ldc1 $f1, 8($sp)
; MIPS64-N64-NEXT:    sub.d $f0, $f1, $f0
; MIPS64-N64-NEXT:    dmfc1 $2, $f0
; MIPS64-N64-NEXT:    fill.d $w0, $2
; MIPS64-N64-NEXT:    fexdo.w $w0, $w0, $w0
; MIPS64-N64-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N64-NEXT:    ld $1, %got_disp(h)($1)
; MIPS64-N64-NEXT:    copy_u.h $2, $w0[0]
; MIPS64-N64-NEXT:    sh $2, 0($1)
; MIPS64-N64-NEXT:    jr $ra
; MIPS64-N64-NEXT:    daddiu $sp, $sp, 16
entry:









  %0 = uitofp i32 %a to half
  store half %0, half * @h, align 2
  ret void
}


; Check that f16 is expanded to f32 and relevant transfer ops occur.
; We don't check f16 -> f64 expansion occurs, as we expand f16 to f32.

define void @fadd() {
; MIPS32-LABEL: fadd:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-NEXT:    addu $1, $2, $25
; MIPS32-NEXT:    lw $1, %got(g)($1)
; MIPS32-NEXT:    lh $2, 0($1)
; MIPS32-NEXT:    fill.h $w0, $2
; MIPS32-NEXT:    fexupr.w $w0, $w0
; MIPS32-NEXT:    copy_s.w $2, $w0[0]
; MIPS32-NEXT:    mtc1 $2, $f0
; MIPS32-NEXT:    add.s $f0, $f0, $f0
; MIPS32-NEXT:    mfc1 $2, $f0
; MIPS32-NEXT:    fill.w $w0, $2
; MIPS32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS32-NEXT:    copy_u.h $2, $w0[0]
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    sh $2, 0($1)
;
; MIPS64-N32-LABEL: fadd:
; MIPS64-N32:       # %bb.0: # %entry
; MIPS64-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(fadd)))
; MIPS64-N32-NEXT:    addu $1, $1, $25
; MIPS64-N32-NEXT:    addiu $1, $1, %lo(%neg(%gp_rel(fadd)))
; MIPS64-N32-NEXT:    lw $1, %got_disp(g)($1)
; MIPS64-N32-NEXT:    lh $2, 0($1)
; MIPS64-N32-NEXT:    fill.h $w0, $2
; MIPS64-N32-NEXT:    fexupr.w $w0, $w0
; MIPS64-N32-NEXT:    copy_s.w $2, $w0[0]
; MIPS64-N32-NEXT:    mtc1 $2, $f0
; MIPS64-N32-NEXT:    add.s $f0, $f0, $f0
; MIPS64-N32-NEXT:    mfc1 $2, $f0
; MIPS64-N32-NEXT:    fill.w $w0, $2
; MIPS64-N32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N32-NEXT:    copy_u.h $2, $w0[0]
; MIPS64-N32-NEXT:    jr $ra
; MIPS64-N32-NEXT:    sh $2, 0($1)
;
; MIPS64-N64-LABEL: fadd:
; MIPS64-N64:       # %bb.0: # %entry
; MIPS64-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(fadd)))
; MIPS64-N64-NEXT:    daddu $1, $1, $25
; MIPS64-N64-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(fadd)))
; MIPS64-N64-NEXT:    ld $1, %got_disp(g)($1)
; MIPS64-N64-NEXT:    lh $2, 0($1)
; MIPS64-N64-NEXT:    fill.h $w0, $2
; MIPS64-N64-NEXT:    fexupr.w $w0, $w0
; MIPS64-N64-NEXT:    copy_s.w $2, $w0[0]
; MIPS64-N64-NEXT:    mtc1 $2, $f0
; MIPS64-N64-NEXT:    add.s $f0, $f0, $f0
; MIPS64-N64-NEXT:    mfc1 $2, $f0
; MIPS64-N64-NEXT:    fill.w $w0, $2
; MIPS64-N64-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N64-NEXT:    copy_u.h $2, $w0[0]
; MIPS64-N64-NEXT:    jr $ra
; MIPS64-N64-NEXT:    sh $2, 0($1)
entry:
  %0 = load i16, i16* @g, align 2
  %1 = call float @llvm.convert.from.fp16.f32(i16 %0)


  %2 = load i16, i16* @g, align 2
  %3 = call float @llvm.convert.from.fp16.f32(i16 %2)
  %add = fadd float %1, %3


 %4 = call i16 @llvm.convert.to.fp16.f32(float %add)

   store i16 %4, i16* @g, align 2
  ret void
}

; Function Attrs: nounwind readnone
declare float @llvm.convert.from.fp16.f32(i16)

; Function Attrs: nounwind readnone
declare i16 @llvm.convert.to.fp16.f32(float)

; Function Attrs: nounwind
define void @fsub() {
; MIPS32-LABEL: fsub:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-NEXT:    addu $1, $2, $25
; MIPS32-NEXT:    lw $1, %got(g)($1)
; MIPS32-NEXT:    lh $2, 0($1)
; MIPS32-NEXT:    fill.h $w0, $2
; MIPS32-NEXT:    fexupr.w $w0, $w0
; MIPS32-NEXT:    copy_s.w $2, $w0[0]
; MIPS32-NEXT:    mtc1 $2, $f0
; MIPS32-NEXT:    sub.s $f0, $f0, $f0
; MIPS32-NEXT:    mfc1 $2, $f0
; MIPS32-NEXT:    fill.w $w0, $2
; MIPS32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS32-NEXT:    copy_u.h $2, $w0[0]
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    sh $2, 0($1)
;
; MIPS64-N32-LABEL: fsub:
; MIPS64-N32:       # %bb.0: # %entry
; MIPS64-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(fsub)))
; MIPS64-N32-NEXT:    addu $1, $1, $25
; MIPS64-N32-NEXT:    addiu $1, $1, %lo(%neg(%gp_rel(fsub)))
; MIPS64-N32-NEXT:    lw $1, %got_disp(g)($1)
; MIPS64-N32-NEXT:    lh $2, 0($1)
; MIPS64-N32-NEXT:    fill.h $w0, $2
; MIPS64-N32-NEXT:    fexupr.w $w0, $w0
; MIPS64-N32-NEXT:    copy_s.w $2, $w0[0]
; MIPS64-N32-NEXT:    mtc1 $2, $f0
; MIPS64-N32-NEXT:    sub.s $f0, $f0, $f0
; MIPS64-N32-NEXT:    mfc1 $2, $f0
; MIPS64-N32-NEXT:    fill.w $w0, $2
; MIPS64-N32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N32-NEXT:    copy_u.h $2, $w0[0]
; MIPS64-N32-NEXT:    jr $ra
; MIPS64-N32-NEXT:    sh $2, 0($1)
;
; MIPS64-N64-LABEL: fsub:
; MIPS64-N64:       # %bb.0: # %entry
; MIPS64-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(fsub)))
; MIPS64-N64-NEXT:    daddu $1, $1, $25
; MIPS64-N64-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(fsub)))
; MIPS64-N64-NEXT:    ld $1, %got_disp(g)($1)
; MIPS64-N64-NEXT:    lh $2, 0($1)
; MIPS64-N64-NEXT:    fill.h $w0, $2
; MIPS64-N64-NEXT:    fexupr.w $w0, $w0
; MIPS64-N64-NEXT:    copy_s.w $2, $w0[0]
; MIPS64-N64-NEXT:    mtc1 $2, $f0
; MIPS64-N64-NEXT:    sub.s $f0, $f0, $f0
; MIPS64-N64-NEXT:    mfc1 $2, $f0
; MIPS64-N64-NEXT:    fill.w $w0, $2
; MIPS64-N64-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N64-NEXT:    copy_u.h $2, $w0[0]
; MIPS64-N64-NEXT:    jr $ra
; MIPS64-N64-NEXT:    sh $2, 0($1)
entry:
  %0 = load i16, i16* @g, align 2
  %1 = call float @llvm.convert.from.fp16.f32(i16 %0)


  %2 = load i16, i16* @g, align 2
  %3 = call float @llvm.convert.from.fp16.f32(i16 %2)
  %sub = fsub float %1, %3


  %4 = call i16 @llvm.convert.to.fp16.f32(float %sub)


  store i16 %4, i16* @g, align 2
  ret void
}

define void @fmult() {
; MIPS32-LABEL: fmult:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-NEXT:    addu $1, $2, $25
; MIPS32-NEXT:    lw $1, %got(g)($1)
; MIPS32-NEXT:    lh $2, 0($1)
; MIPS32-NEXT:    fill.h $w0, $2
; MIPS32-NEXT:    fexupr.w $w0, $w0
; MIPS32-NEXT:    copy_s.w $2, $w0[0]
; MIPS32-NEXT:    mtc1 $2, $f0
; MIPS32-NEXT:    mul.s $f0, $f0, $f0
; MIPS32-NEXT:    mfc1 $2, $f0
; MIPS32-NEXT:    fill.w $w0, $2
; MIPS32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS32-NEXT:    copy_u.h $2, $w0[0]
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    sh $2, 0($1)
;
; MIPS64-N32-LABEL: fmult:
; MIPS64-N32:       # %bb.0: # %entry
; MIPS64-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(fmult)))
; MIPS64-N32-NEXT:    addu $1, $1, $25
; MIPS64-N32-NEXT:    addiu $1, $1, %lo(%neg(%gp_rel(fmult)))
; MIPS64-N32-NEXT:    lw $1, %got_disp(g)($1)
; MIPS64-N32-NEXT:    lh $2, 0($1)
; MIPS64-N32-NEXT:    fill.h $w0, $2
; MIPS64-N32-NEXT:    fexupr.w $w0, $w0
; MIPS64-N32-NEXT:    copy_s.w $2, $w0[0]
; MIPS64-N32-NEXT:    mtc1 $2, $f0
; MIPS64-N32-NEXT:    mul.s $f0, $f0, $f0
; MIPS64-N32-NEXT:    mfc1 $2, $f0
; MIPS64-N32-NEXT:    fill.w $w0, $2
; MIPS64-N32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N32-NEXT:    copy_u.h $2, $w0[0]
; MIPS64-N32-NEXT:    jr $ra
; MIPS64-N32-NEXT:    sh $2, 0($1)
;
; MIPS64-N64-LABEL: fmult:
; MIPS64-N64:       # %bb.0: # %entry
; MIPS64-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(fmult)))
; MIPS64-N64-NEXT:    daddu $1, $1, $25
; MIPS64-N64-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(fmult)))
; MIPS64-N64-NEXT:    ld $1, %got_disp(g)($1)
; MIPS64-N64-NEXT:    lh $2, 0($1)
; MIPS64-N64-NEXT:    fill.h $w0, $2
; MIPS64-N64-NEXT:    fexupr.w $w0, $w0
; MIPS64-N64-NEXT:    copy_s.w $2, $w0[0]
; MIPS64-N64-NEXT:    mtc1 $2, $f0
; MIPS64-N64-NEXT:    mul.s $f0, $f0, $f0
; MIPS64-N64-NEXT:    mfc1 $2, $f0
; MIPS64-N64-NEXT:    fill.w $w0, $2
; MIPS64-N64-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N64-NEXT:    copy_u.h $2, $w0[0]
; MIPS64-N64-NEXT:    jr $ra
; MIPS64-N64-NEXT:    sh $2, 0($1)
entry:
  %0 = load i16, i16* @g, align 2
  %1 = call float @llvm.convert.from.fp16.f32(i16 %0)


  %2 = load i16, i16* @g, align 2
  %3 = call float @llvm.convert.from.fp16.f32(i16 %2)
  %mul = fmul float %1, %3


  %4 = call i16 @llvm.convert.to.fp16.f32(float %mul)


  store i16 %4, i16* @g, align 2

  ret void
}

define void @fdiv() {
; MIPS32-LABEL: fdiv:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-NEXT:    addu $1, $2, $25
; MIPS32-NEXT:    lw $1, %got(g)($1)
; MIPS32-NEXT:    lh $2, 0($1)
; MIPS32-NEXT:    fill.h $w0, $2
; MIPS32-NEXT:    fexupr.w $w0, $w0
; MIPS32-NEXT:    copy_s.w $2, $w0[0]
; MIPS32-NEXT:    mtc1 $2, $f0
; MIPS32-NEXT:    div.s $f0, $f0, $f0
; MIPS32-NEXT:    mfc1 $2, $f0
; MIPS32-NEXT:    fill.w $w0, $2
; MIPS32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS32-NEXT:    copy_u.h $2, $w0[0]
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    sh $2, 0($1)
;
; MIPS64-N32-LABEL: fdiv:
; MIPS64-N32:       # %bb.0: # %entry
; MIPS64-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(fdiv)))
; MIPS64-N32-NEXT:    addu $1, $1, $25
; MIPS64-N32-NEXT:    addiu $1, $1, %lo(%neg(%gp_rel(fdiv)))
; MIPS64-N32-NEXT:    lw $1, %got_disp(g)($1)
; MIPS64-N32-NEXT:    lh $2, 0($1)
; MIPS64-N32-NEXT:    fill.h $w0, $2
; MIPS64-N32-NEXT:    fexupr.w $w0, $w0
; MIPS64-N32-NEXT:    copy_s.w $2, $w0[0]
; MIPS64-N32-NEXT:    mtc1 $2, $f0
; MIPS64-N32-NEXT:    div.s $f0, $f0, $f0
; MIPS64-N32-NEXT:    mfc1 $2, $f0
; MIPS64-N32-NEXT:    fill.w $w0, $2
; MIPS64-N32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N32-NEXT:    copy_u.h $2, $w0[0]
; MIPS64-N32-NEXT:    jr $ra
; MIPS64-N32-NEXT:    sh $2, 0($1)
;
; MIPS64-N64-LABEL: fdiv:
; MIPS64-N64:       # %bb.0: # %entry
; MIPS64-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(fdiv)))
; MIPS64-N64-NEXT:    daddu $1, $1, $25
; MIPS64-N64-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(fdiv)))
; MIPS64-N64-NEXT:    ld $1, %got_disp(g)($1)
; MIPS64-N64-NEXT:    lh $2, 0($1)
; MIPS64-N64-NEXT:    fill.h $w0, $2
; MIPS64-N64-NEXT:    fexupr.w $w0, $w0
; MIPS64-N64-NEXT:    copy_s.w $2, $w0[0]
; MIPS64-N64-NEXT:    mtc1 $2, $f0
; MIPS64-N64-NEXT:    div.s $f0, $f0, $f0
; MIPS64-N64-NEXT:    mfc1 $2, $f0
; MIPS64-N64-NEXT:    fill.w $w0, $2
; MIPS64-N64-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N64-NEXT:    copy_u.h $2, $w0[0]
; MIPS64-N64-NEXT:    jr $ra
; MIPS64-N64-NEXT:    sh $2, 0($1)
entry:

  %0 = load i16, i16* @g, align 2
  %1 = call float @llvm.convert.from.fp16.f32(i16 %0)


  %2 = load i16, i16* @g, align 2
  %3 = call float @llvm.convert.from.fp16.f32(i16 %2)
  %div = fdiv float %1, %3


  %4 = call i16 @llvm.convert.to.fp16.f32(float %div)

  store i16 %4, i16* @g, align 2
  ret void
}

define void @frem() {
; MIPS32-LABEL: frem:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-NEXT:    addiu $sp, $sp, -24
; MIPS32-NEXT:    .cfi_def_cfa_offset 24
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $16, 16($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    .cfi_offset 31, -4
; MIPS32-NEXT:    .cfi_offset 16, -8
; MIPS32-NEXT:    addu $gp, $2, $25
; MIPS32-NEXT:    lw $16, %got(g)($gp)
; MIPS32-NEXT:    lh $1, 0($16)
; MIPS32-NEXT:    fill.h $w0, $1
; MIPS32-NEXT:    fexupr.w $w0, $w0
; MIPS32-NEXT:    copy_s.w $1, $w0[0]
; MIPS32-NEXT:    mtc1 $1, $f12
; MIPS32-NEXT:    lw $25, %call16(fmodf)($gp)
; MIPS32-NEXT:    jalr $25
; MIPS32-NEXT:    mov.s $f14, $f12
; MIPS32-NEXT:    mfc1 $1, $f0
; MIPS32-NEXT:    fill.w $w0, $1
; MIPS32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS32-NEXT:    copy_u.h $1, $w0[0]
; MIPS32-NEXT:    sh $1, 0($16)
; MIPS32-NEXT:    lw $16, 16($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    addiu $sp, $sp, 24
;
; MIPS64-N32-LABEL: frem:
; MIPS64-N32:       # %bb.0: # %entry
; MIPS64-N32-NEXT:    addiu $sp, $sp, -32
; MIPS64-N32-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N32-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    .cfi_offset 31, -8
; MIPS64-N32-NEXT:    .cfi_offset 28, -16
; MIPS64-N32-NEXT:    .cfi_offset 16, -24
; MIPS64-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(frem)))
; MIPS64-N32-NEXT:    addu $1, $1, $25
; MIPS64-N32-NEXT:    addiu $gp, $1, %lo(%neg(%gp_rel(frem)))
; MIPS64-N32-NEXT:    lw $16, %got_disp(g)($gp)
; MIPS64-N32-NEXT:    lh $1, 0($16)
; MIPS64-N32-NEXT:    fill.h $w0, $1
; MIPS64-N32-NEXT:    fexupr.w $w0, $w0
; MIPS64-N32-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N32-NEXT:    mtc1 $1, $f12
; MIPS64-N32-NEXT:    lw $25, %call16(fmodf)($gp)
; MIPS64-N32-NEXT:    jalr $25
; MIPS64-N32-NEXT:    mov.s $f13, $f12
; MIPS64-N32-NEXT:    mfc1 $1, $f0
; MIPS64-N32-NEXT:    fill.w $w0, $1
; MIPS64-N32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N32-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N32-NEXT:    sh $1, 0($16)
; MIPS64-N32-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    jr $ra
; MIPS64-N32-NEXT:    addiu $sp, $sp, 32
;
; MIPS64-N64-LABEL: frem:
; MIPS64-N64:       # %bb.0: # %entry
; MIPS64-N64-NEXT:    daddiu $sp, $sp, -32
; MIPS64-N64-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N64-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    .cfi_offset 31, -8
; MIPS64-N64-NEXT:    .cfi_offset 28, -16
; MIPS64-N64-NEXT:    .cfi_offset 16, -24
; MIPS64-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(frem)))
; MIPS64-N64-NEXT:    daddu $1, $1, $25
; MIPS64-N64-NEXT:    daddiu $gp, $1, %lo(%neg(%gp_rel(frem)))
; MIPS64-N64-NEXT:    ld $16, %got_disp(g)($gp)
; MIPS64-N64-NEXT:    lh $1, 0($16)
; MIPS64-N64-NEXT:    fill.h $w0, $1
; MIPS64-N64-NEXT:    fexupr.w $w0, $w0
; MIPS64-N64-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N64-NEXT:    mtc1 $1, $f12
; MIPS64-N64-NEXT:    ld $25, %call16(fmodf)($gp)
; MIPS64-N64-NEXT:    jalr $25
; MIPS64-N64-NEXT:    mov.s $f13, $f12
; MIPS64-N64-NEXT:    mfc1 $1, $f0
; MIPS64-N64-NEXT:    fill.w $w0, $1
; MIPS64-N64-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N64-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N64-NEXT:    sh $1, 0($16)
; MIPS64-N64-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    jr $ra
; MIPS64-N64-NEXT:    daddiu $sp, $sp, 32
entry:
  %0 = load i16, i16* @g, align 2
  %1 = call float @llvm.convert.from.fp16.f32(i16 %0)


  %2 = load i16, i16* @g, align 2
  %3 = call float @llvm.convert.from.fp16.f32(i16 %2)
  %rem = frem float %1, %3


  %4 = call i16 @llvm.convert.to.fp16.f32(float %rem)


  store i16 %4, i16* @g, align 2

  ret void
}

@i1 = external global i16, align 1

define void @fcmp() {
; MIPS32-O32-LABEL: fcmp:
; MIPS32-O32:       # %bb.0: # %entry
; MIPS32-O32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-O32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-O32-NEXT:    addu $1, $2, $25
; MIPS32-O32-NEXT:    lw $2, %got(g)($1)
; MIPS32-O32-NEXT:    lh $2, 0($2)
; MIPS32-O32-NEXT:    fill.h $w0, $2
; MIPS32-O32-NEXT:    fexupr.w $w0, $w0
; MIPS32-O32-NEXT:    copy_s.w $2, $w0[0]
; MIPS32-O32-NEXT:    mtc1 $2, $f0
; MIPS32-O32-NEXT:    addiu $2, $zero, 1
; MIPS32-O32-NEXT:    c.un.s $f0, $f0
; MIPS32-O32-NEXT:    movt $2, $zero, $fcc0
; MIPS32-O32-NEXT:    lw $1, %got(i1)($1)
; MIPS32-O32-NEXT:    jr $ra
; MIPS32-O32-NEXT:    sh $2, 0($1)
;
; MIPS64R5-N32-LABEL: fcmp:
; MIPS64R5-N32:       # %bb.0: # %entry
; MIPS64R5-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(fcmp)))
; MIPS64R5-N32-NEXT:    addu $1, $1, $25
; MIPS64R5-N32-NEXT:    addiu $1, $1, %lo(%neg(%gp_rel(fcmp)))
; MIPS64R5-N32-NEXT:    lw $2, %got_disp(g)($1)
; MIPS64R5-N32-NEXT:    lh $2, 0($2)
; MIPS64R5-N32-NEXT:    fill.h $w0, $2
; MIPS64R5-N32-NEXT:    fexupr.w $w0, $w0
; MIPS64R5-N32-NEXT:    copy_s.w $2, $w0[0]
; MIPS64R5-N32-NEXT:    mtc1 $2, $f0
; MIPS64R5-N32-NEXT:    addiu $2, $zero, 1
; MIPS64R5-N32-NEXT:    c.un.s $f0, $f0
; MIPS64R5-N32-NEXT:    movt $2, $zero, $fcc0
; MIPS64R5-N32-NEXT:    lw $1, %got_disp(i1)($1)
; MIPS64R5-N32-NEXT:    jr $ra
; MIPS64R5-N32-NEXT:    sh $2, 0($1)
;
; MIPS64R5-N64-LABEL: fcmp:
; MIPS64R5-N64:       # %bb.0: # %entry
; MIPS64R5-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(fcmp)))
; MIPS64R5-N64-NEXT:    daddu $1, $1, $25
; MIPS64R5-N64-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(fcmp)))
; MIPS64R5-N64-NEXT:    ld $2, %got_disp(g)($1)
; MIPS64R5-N64-NEXT:    lh $2, 0($2)
; MIPS64R5-N64-NEXT:    fill.h $w0, $2
; MIPS64R5-N64-NEXT:    fexupr.w $w0, $w0
; MIPS64R5-N64-NEXT:    copy_s.w $2, $w0[0]
; MIPS64R5-N64-NEXT:    mtc1 $2, $f0
; MIPS64R5-N64-NEXT:    addiu $2, $zero, 1
; MIPS64R5-N64-NEXT:    c.un.s $f0, $f0
; MIPS64R5-N64-NEXT:    movt $2, $zero, $fcc0
; MIPS64R5-N64-NEXT:    ld $1, %got_disp(i1)($1)
; MIPS64R5-N64-NEXT:    jr $ra
; MIPS64R5-N64-NEXT:    sh $2, 0($1)
;
; MIPSR6-O32-LABEL: fcmp:
; MIPSR6-O32:       # %bb.0: # %entry
; MIPSR6-O32-NEXT:    lui $2, %hi(_gp_disp)
; MIPSR6-O32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPSR6-O32-NEXT:    addu $1, $2, $25
; MIPSR6-O32-NEXT:    lw $2, %got(g)($1)
; MIPSR6-O32-NEXT:    lh $2, 0($2)
; MIPSR6-O32-NEXT:    fill.h $w0, $2
; MIPSR6-O32-NEXT:    fexupr.w $w0, $w0
; MIPSR6-O32-NEXT:    copy_s.w $2, $w0[0]
; MIPSR6-O32-NEXT:    mtc1 $2, $f0
; MIPSR6-O32-NEXT:    cmp.un.s $f0, $f0, $f0
; MIPSR6-O32-NEXT:    mfc1 $2, $f0
; MIPSR6-O32-NEXT:    not $2, $2
; MIPSR6-O32-NEXT:    andi $2, $2, 1
; MIPSR6-O32-NEXT:    lw $1, %got(i1)($1)
; MIPSR6-O32-NEXT:    jr $ra
; MIPSR6-O32-NEXT:    sh $2, 0($1)
;
; MIPSR6-N32-LABEL: fcmp:
; MIPSR6-N32:       # %bb.0: # %entry
; MIPSR6-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(fcmp)))
; MIPSR6-N32-NEXT:    addu $1, $1, $25
; MIPSR6-N32-NEXT:    addiu $1, $1, %lo(%neg(%gp_rel(fcmp)))
; MIPSR6-N32-NEXT:    lw $2, %got_disp(g)($1)
; MIPSR6-N32-NEXT:    lh $2, 0($2)
; MIPSR6-N32-NEXT:    fill.h $w0, $2
; MIPSR6-N32-NEXT:    fexupr.w $w0, $w0
; MIPSR6-N32-NEXT:    copy_s.w $2, $w0[0]
; MIPSR6-N32-NEXT:    mtc1 $2, $f0
; MIPSR6-N32-NEXT:    cmp.un.s $f0, $f0, $f0
; MIPSR6-N32-NEXT:    mfc1 $2, $f0
; MIPSR6-N32-NEXT:    not $2, $2
; MIPSR6-N32-NEXT:    andi $2, $2, 1
; MIPSR6-N32-NEXT:    lw $1, %got_disp(i1)($1)
; MIPSR6-N32-NEXT:    jr $ra
; MIPSR6-N32-NEXT:    sh $2, 0($1)
;
; MIPSR6-N64-LABEL: fcmp:
; MIPSR6-N64:       # %bb.0: # %entry
; MIPSR6-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(fcmp)))
; MIPSR6-N64-NEXT:    daddu $1, $1, $25
; MIPSR6-N64-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(fcmp)))
; MIPSR6-N64-NEXT:    ld $2, %got_disp(g)($1)
; MIPSR6-N64-NEXT:    lh $2, 0($2)
; MIPSR6-N64-NEXT:    fill.h $w0, $2
; MIPSR6-N64-NEXT:    fexupr.w $w0, $w0
; MIPSR6-N64-NEXT:    copy_s.w $2, $w0[0]
; MIPSR6-N64-NEXT:    mtc1 $2, $f0
; MIPSR6-N64-NEXT:    cmp.un.s $f0, $f0, $f0
; MIPSR6-N64-NEXT:    mfc1 $2, $f0
; MIPSR6-N64-NEXT:    not $2, $2
; MIPSR6-N64-NEXT:    andi $2, $2, 1
; MIPSR6-N64-NEXT:    ld $1, %got_disp(i1)($1)
; MIPSR6-N64-NEXT:    jr $ra
; MIPSR6-N64-NEXT:    sh $2, 0($1)
entry:
  %0 = load i16, i16* @g, align 2
  %1 = call float @llvm.convert.from.fp16.f32(i16 %0)

  %2 = load i16, i16* @g, align 2
  %3 = call float @llvm.convert.from.fp16.f32(i16 %2)
  %fcmp = fcmp oeq float %1, %3


  %4 = zext i1 %fcmp to i16
  store i16 %4, i16* @i1, align 2

  ret void
}

declare float @llvm.powi.f32(float, i32)

define void @fpowi() {
; MIPS32-LABEL: fpowi:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-NEXT:    addu $1, $2, $25
; MIPS32-NEXT:    lw $1, %got(g)($1)
; MIPS32-NEXT:    lh $2, 0($1)
; MIPS32-NEXT:    fill.h $w0, $2
; MIPS32-NEXT:    fexupr.w $w0, $w0
; MIPS32-NEXT:    copy_s.w $2, $w0[0]
; MIPS32-NEXT:    mtc1 $2, $f0
; MIPS32-NEXT:    mul.s $f0, $f0, $f0
; MIPS32-NEXT:    mfc1 $2, $f0
; MIPS32-NEXT:    fill.w $w0, $2
; MIPS32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS32-NEXT:    copy_u.h $2, $w0[0]
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    sh $2, 0($1)
;
; MIPS64-N32-LABEL: fpowi:
; MIPS64-N32:       # %bb.0: # %entry
; MIPS64-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(fpowi)))
; MIPS64-N32-NEXT:    addu $1, $1, $25
; MIPS64-N32-NEXT:    addiu $1, $1, %lo(%neg(%gp_rel(fpowi)))
; MIPS64-N32-NEXT:    lw $1, %got_disp(g)($1)
; MIPS64-N32-NEXT:    lh $2, 0($1)
; MIPS64-N32-NEXT:    fill.h $w0, $2
; MIPS64-N32-NEXT:    fexupr.w $w0, $w0
; MIPS64-N32-NEXT:    copy_s.w $2, $w0[0]
; MIPS64-N32-NEXT:    mtc1 $2, $f0
; MIPS64-N32-NEXT:    mul.s $f0, $f0, $f0
; MIPS64-N32-NEXT:    mfc1 $2, $f0
; MIPS64-N32-NEXT:    fill.w $w0, $2
; MIPS64-N32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N32-NEXT:    copy_u.h $2, $w0[0]
; MIPS64-N32-NEXT:    jr $ra
; MIPS64-N32-NEXT:    sh $2, 0($1)
;
; MIPS64-N64-LABEL: fpowi:
; MIPS64-N64:       # %bb.0: # %entry
; MIPS64-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(fpowi)))
; MIPS64-N64-NEXT:    daddu $1, $1, $25
; MIPS64-N64-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(fpowi)))
; MIPS64-N64-NEXT:    ld $1, %got_disp(g)($1)
; MIPS64-N64-NEXT:    lh $2, 0($1)
; MIPS64-N64-NEXT:    fill.h $w0, $2
; MIPS64-N64-NEXT:    fexupr.w $w0, $w0
; MIPS64-N64-NEXT:    copy_s.w $2, $w0[0]
; MIPS64-N64-NEXT:    mtc1 $2, $f0
; MIPS64-N64-NEXT:    mul.s $f0, $f0, $f0
; MIPS64-N64-NEXT:    mfc1 $2, $f0
; MIPS64-N64-NEXT:    fill.w $w0, $2
; MIPS64-N64-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N64-NEXT:    copy_u.h $2, $w0[0]
; MIPS64-N64-NEXT:    jr $ra
; MIPS64-N64-NEXT:    sh $2, 0($1)
entry:
  %0 = load i16, i16* @g, align 2
  %1 = call float @llvm.convert.from.fp16.f32(i16 %0)


  %powi = call float @llvm.powi.f32(float %1, i32 2)


  %2 = call i16 @llvm.convert.to.fp16.f32(float %powi)


  store i16 %2, i16* @g, align 2
  ret void
}

define void @fpowi_var(i32 %var) {
; MIPS32-LABEL: fpowi_var:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-NEXT:    addiu $sp, $sp, -24
; MIPS32-NEXT:    .cfi_def_cfa_offset 24
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $16, 16($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    .cfi_offset 31, -4
; MIPS32-NEXT:    .cfi_offset 16, -8
; MIPS32-NEXT:    addu $gp, $2, $25
; MIPS32-NEXT:    lw $16, %got(g)($gp)
; MIPS32-NEXT:    lh $1, 0($16)
; MIPS32-NEXT:    fill.h $w0, $1
; MIPS32-NEXT:    fexupr.w $w0, $w0
; MIPS32-NEXT:    copy_s.w $1, $w0[0]
; MIPS32-NEXT:    mtc1 $1, $f12
; MIPS32-NEXT:    lw $25, %call16(__powisf2)($gp)
; MIPS32-NEXT:    jalr $25
; MIPS32-NEXT:    move $5, $4
; MIPS32-NEXT:    mfc1 $1, $f0
; MIPS32-NEXT:    fill.w $w0, $1
; MIPS32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS32-NEXT:    copy_u.h $1, $w0[0]
; MIPS32-NEXT:    sh $1, 0($16)
; MIPS32-NEXT:    lw $16, 16($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    addiu $sp, $sp, 24
;
; MIPS64-N32-LABEL: fpowi_var:
; MIPS64-N32:       # %bb.0: # %entry
; MIPS64-N32-NEXT:    addiu $sp, $sp, -32
; MIPS64-N32-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N32-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    .cfi_offset 31, -8
; MIPS64-N32-NEXT:    .cfi_offset 28, -16
; MIPS64-N32-NEXT:    .cfi_offset 16, -24
; MIPS64-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(fpowi_var)))
; MIPS64-N32-NEXT:    addu $1, $1, $25
; MIPS64-N32-NEXT:    addiu $gp, $1, %lo(%neg(%gp_rel(fpowi_var)))
; MIPS64-N32-NEXT:    sll $5, $4, 0
; MIPS64-N32-NEXT:    lw $16, %got_disp(g)($gp)
; MIPS64-N32-NEXT:    lh $1, 0($16)
; MIPS64-N32-NEXT:    fill.h $w0, $1
; MIPS64-N32-NEXT:    fexupr.w $w0, $w0
; MIPS64-N32-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N32-NEXT:    lw $25, %call16(__powisf2)($gp)
; MIPS64-N32-NEXT:    jalr $25
; MIPS64-N32-NEXT:    mtc1 $1, $f12
; MIPS64-N32-NEXT:    mfc1 $1, $f0
; MIPS64-N32-NEXT:    fill.w $w0, $1
; MIPS64-N32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N32-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N32-NEXT:    sh $1, 0($16)
; MIPS64-N32-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    jr $ra
; MIPS64-N32-NEXT:    addiu $sp, $sp, 32
;
; MIPS64-N64-LABEL: fpowi_var:
; MIPS64-N64:       # %bb.0: # %entry
; MIPS64-N64-NEXT:    daddiu $sp, $sp, -32
; MIPS64-N64-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N64-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    .cfi_offset 31, -8
; MIPS64-N64-NEXT:    .cfi_offset 28, -16
; MIPS64-N64-NEXT:    .cfi_offset 16, -24
; MIPS64-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(fpowi_var)))
; MIPS64-N64-NEXT:    daddu $1, $1, $25
; MIPS64-N64-NEXT:    daddiu $gp, $1, %lo(%neg(%gp_rel(fpowi_var)))
; MIPS64-N64-NEXT:    sll $5, $4, 0
; MIPS64-N64-NEXT:    ld $16, %got_disp(g)($gp)
; MIPS64-N64-NEXT:    lh $1, 0($16)
; MIPS64-N64-NEXT:    fill.h $w0, $1
; MIPS64-N64-NEXT:    fexupr.w $w0, $w0
; MIPS64-N64-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N64-NEXT:    ld $25, %call16(__powisf2)($gp)
; MIPS64-N64-NEXT:    jalr $25
; MIPS64-N64-NEXT:    mtc1 $1, $f12
; MIPS64-N64-NEXT:    mfc1 $1, $f0
; MIPS64-N64-NEXT:    fill.w $w0, $1
; MIPS64-N64-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N64-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N64-NEXT:    sh $1, 0($16)
; MIPS64-N64-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    jr $ra
; MIPS64-N64-NEXT:    daddiu $sp, $sp, 32
entry:
  %0 = load i16, i16* @g, align 2
  %1 = call float @llvm.convert.from.fp16.f32(i16 %0)


  %powi = call float @llvm.powi.f32(float %1, i32 %var)


  %2 = call i16 @llvm.convert.to.fp16.f32(float %powi)


  store i16 %2, i16* @g, align 2
  ret void
}

declare float @llvm.pow.f32(float %Val, float %power)

define void @fpow(float %var) {
; MIPS32-LABEL: fpow:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-NEXT:    addiu $sp, $sp, -24
; MIPS32-NEXT:    .cfi_def_cfa_offset 24
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $16, 16($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    .cfi_offset 31, -4
; MIPS32-NEXT:    .cfi_offset 16, -8
; MIPS32-NEXT:    addu $gp, $2, $25
; MIPS32-NEXT:    mov.s $f14, $f12
; MIPS32-NEXT:    lw $16, %got(g)($gp)
; MIPS32-NEXT:    lh $1, 0($16)
; MIPS32-NEXT:    fill.h $w0, $1
; MIPS32-NEXT:    fexupr.w $w0, $w0
; MIPS32-NEXT:    copy_s.w $1, $w0[0]
; MIPS32-NEXT:    lw $25, %call16(powf)($gp)
; MIPS32-NEXT:    jalr $25
; MIPS32-NEXT:    mtc1 $1, $f12
; MIPS32-NEXT:    mfc1 $1, $f0
; MIPS32-NEXT:    fill.w $w0, $1
; MIPS32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS32-NEXT:    copy_u.h $1, $w0[0]
; MIPS32-NEXT:    sh $1, 0($16)
; MIPS32-NEXT:    lw $16, 16($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    addiu $sp, $sp, 24
;
; MIPS64-N32-LABEL: fpow:
; MIPS64-N32:       # %bb.0: # %entry
; MIPS64-N32-NEXT:    addiu $sp, $sp, -32
; MIPS64-N32-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N32-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    .cfi_offset 31, -8
; MIPS64-N32-NEXT:    .cfi_offset 28, -16
; MIPS64-N32-NEXT:    .cfi_offset 16, -24
; MIPS64-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(fpow)))
; MIPS64-N32-NEXT:    addu $1, $1, $25
; MIPS64-N32-NEXT:    addiu $gp, $1, %lo(%neg(%gp_rel(fpow)))
; MIPS64-N32-NEXT:    mov.s $f13, $f12
; MIPS64-N32-NEXT:    lw $16, %got_disp(g)($gp)
; MIPS64-N32-NEXT:    lh $1, 0($16)
; MIPS64-N32-NEXT:    fill.h $w0, $1
; MIPS64-N32-NEXT:    fexupr.w $w0, $w0
; MIPS64-N32-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N32-NEXT:    lw $25, %call16(powf)($gp)
; MIPS64-N32-NEXT:    jalr $25
; MIPS64-N32-NEXT:    mtc1 $1, $f12
; MIPS64-N32-NEXT:    mfc1 $1, $f0
; MIPS64-N32-NEXT:    fill.w $w0, $1
; MIPS64-N32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N32-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N32-NEXT:    sh $1, 0($16)
; MIPS64-N32-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    jr $ra
; MIPS64-N32-NEXT:    addiu $sp, $sp, 32
;
; MIPS64-N64-LABEL: fpow:
; MIPS64-N64:       # %bb.0: # %entry
; MIPS64-N64-NEXT:    daddiu $sp, $sp, -32
; MIPS64-N64-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N64-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    .cfi_offset 31, -8
; MIPS64-N64-NEXT:    .cfi_offset 28, -16
; MIPS64-N64-NEXT:    .cfi_offset 16, -24
; MIPS64-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(fpow)))
; MIPS64-N64-NEXT:    daddu $1, $1, $25
; MIPS64-N64-NEXT:    daddiu $gp, $1, %lo(%neg(%gp_rel(fpow)))
; MIPS64-N64-NEXT:    mov.s $f13, $f12
; MIPS64-N64-NEXT:    ld $16, %got_disp(g)($gp)
; MIPS64-N64-NEXT:    lh $1, 0($16)
; MIPS64-N64-NEXT:    fill.h $w0, $1
; MIPS64-N64-NEXT:    fexupr.w $w0, $w0
; MIPS64-N64-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N64-NEXT:    ld $25, %call16(powf)($gp)
; MIPS64-N64-NEXT:    jalr $25
; MIPS64-N64-NEXT:    mtc1 $1, $f12
; MIPS64-N64-NEXT:    mfc1 $1, $f0
; MIPS64-N64-NEXT:    fill.w $w0, $1
; MIPS64-N64-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N64-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N64-NEXT:    sh $1, 0($16)
; MIPS64-N64-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    jr $ra
; MIPS64-N64-NEXT:    daddiu $sp, $sp, 32
entry:
  %0 = load i16, i16* @g, align 2
  %1 = call float @llvm.convert.from.fp16.f32(i16 %0)


  %powi = call float @llvm.pow.f32(float %1, float %var)


  %2 = call i16 @llvm.convert.to.fp16.f32(float %powi)


  store i16 %2, i16* @g, align 2
  ret void
}

declare float @llvm.log2.f32(float %Val)

define void @flog2() {
; MIPS32-LABEL: flog2:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-NEXT:    addiu $sp, $sp, -24
; MIPS32-NEXT:    .cfi_def_cfa_offset 24
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $16, 16($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    .cfi_offset 31, -4
; MIPS32-NEXT:    .cfi_offset 16, -8
; MIPS32-NEXT:    addu $gp, $2, $25
; MIPS32-NEXT:    lw $16, %got(g)($gp)
; MIPS32-NEXT:    lh $1, 0($16)
; MIPS32-NEXT:    fill.h $w0, $1
; MIPS32-NEXT:    fexupr.w $w0, $w0
; MIPS32-NEXT:    copy_s.w $1, $w0[0]
; MIPS32-NEXT:    lw $25, %call16(log2f)($gp)
; MIPS32-NEXT:    jalr $25
; MIPS32-NEXT:    mtc1 $1, $f12
; MIPS32-NEXT:    mfc1 $1, $f0
; MIPS32-NEXT:    fill.w $w0, $1
; MIPS32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS32-NEXT:    copy_u.h $1, $w0[0]
; MIPS32-NEXT:    sh $1, 0($16)
; MIPS32-NEXT:    lw $16, 16($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    addiu $sp, $sp, 24
;
; MIPS64-N32-LABEL: flog2:
; MIPS64-N32:       # %bb.0: # %entry
; MIPS64-N32-NEXT:    addiu $sp, $sp, -32
; MIPS64-N32-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N32-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    .cfi_offset 31, -8
; MIPS64-N32-NEXT:    .cfi_offset 28, -16
; MIPS64-N32-NEXT:    .cfi_offset 16, -24
; MIPS64-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(flog2)))
; MIPS64-N32-NEXT:    addu $1, $1, $25
; MIPS64-N32-NEXT:    addiu $gp, $1, %lo(%neg(%gp_rel(flog2)))
; MIPS64-N32-NEXT:    lw $16, %got_disp(g)($gp)
; MIPS64-N32-NEXT:    lh $1, 0($16)
; MIPS64-N32-NEXT:    fill.h $w0, $1
; MIPS64-N32-NEXT:    fexupr.w $w0, $w0
; MIPS64-N32-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N32-NEXT:    lw $25, %call16(log2f)($gp)
; MIPS64-N32-NEXT:    jalr $25
; MIPS64-N32-NEXT:    mtc1 $1, $f12
; MIPS64-N32-NEXT:    mfc1 $1, $f0
; MIPS64-N32-NEXT:    fill.w $w0, $1
; MIPS64-N32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N32-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N32-NEXT:    sh $1, 0($16)
; MIPS64-N32-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    jr $ra
; MIPS64-N32-NEXT:    addiu $sp, $sp, 32
;
; MIPS64-N64-LABEL: flog2:
; MIPS64-N64:       # %bb.0: # %entry
; MIPS64-N64-NEXT:    daddiu $sp, $sp, -32
; MIPS64-N64-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N64-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    .cfi_offset 31, -8
; MIPS64-N64-NEXT:    .cfi_offset 28, -16
; MIPS64-N64-NEXT:    .cfi_offset 16, -24
; MIPS64-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(flog2)))
; MIPS64-N64-NEXT:    daddu $1, $1, $25
; MIPS64-N64-NEXT:    daddiu $gp, $1, %lo(%neg(%gp_rel(flog2)))
; MIPS64-N64-NEXT:    ld $16, %got_disp(g)($gp)
; MIPS64-N64-NEXT:    lh $1, 0($16)
; MIPS64-N64-NEXT:    fill.h $w0, $1
; MIPS64-N64-NEXT:    fexupr.w $w0, $w0
; MIPS64-N64-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N64-NEXT:    ld $25, %call16(log2f)($gp)
; MIPS64-N64-NEXT:    jalr $25
; MIPS64-N64-NEXT:    mtc1 $1, $f12
; MIPS64-N64-NEXT:    mfc1 $1, $f0
; MIPS64-N64-NEXT:    fill.w $w0, $1
; MIPS64-N64-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N64-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N64-NEXT:    sh $1, 0($16)
; MIPS64-N64-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    jr $ra
; MIPS64-N64-NEXT:    daddiu $sp, $sp, 32
entry:
  %0 = load i16, i16* @g, align 2
  %1 = call float @llvm.convert.from.fp16.f32(i16 %0)


  %log2 = call float @llvm.log2.f32(float %1)
  %2 = call i16 @llvm.convert.to.fp16.f32(float %log2)


  store i16 %2, i16* @g, align 2

  ret void
}

declare float @llvm.log10.f32(float %Val)

define void @flog10() {
; MIPS32-LABEL: flog10:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-NEXT:    addiu $sp, $sp, -24
; MIPS32-NEXT:    .cfi_def_cfa_offset 24
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $16, 16($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    .cfi_offset 31, -4
; MIPS32-NEXT:    .cfi_offset 16, -8
; MIPS32-NEXT:    addu $gp, $2, $25
; MIPS32-NEXT:    lw $16, %got(g)($gp)
; MIPS32-NEXT:    lh $1, 0($16)
; MIPS32-NEXT:    fill.h $w0, $1
; MIPS32-NEXT:    fexupr.w $w0, $w0
; MIPS32-NEXT:    copy_s.w $1, $w0[0]
; MIPS32-NEXT:    lw $25, %call16(log10f)($gp)
; MIPS32-NEXT:    jalr $25
; MIPS32-NEXT:    mtc1 $1, $f12
; MIPS32-NEXT:    mfc1 $1, $f0
; MIPS32-NEXT:    fill.w $w0, $1
; MIPS32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS32-NEXT:    copy_u.h $1, $w0[0]
; MIPS32-NEXT:    sh $1, 0($16)
; MIPS32-NEXT:    lw $16, 16($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    addiu $sp, $sp, 24
;
; MIPS64-N32-LABEL: flog10:
; MIPS64-N32:       # %bb.0: # %entry
; MIPS64-N32-NEXT:    addiu $sp, $sp, -32
; MIPS64-N32-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N32-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    .cfi_offset 31, -8
; MIPS64-N32-NEXT:    .cfi_offset 28, -16
; MIPS64-N32-NEXT:    .cfi_offset 16, -24
; MIPS64-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(flog10)))
; MIPS64-N32-NEXT:    addu $1, $1, $25
; MIPS64-N32-NEXT:    addiu $gp, $1, %lo(%neg(%gp_rel(flog10)))
; MIPS64-N32-NEXT:    lw $16, %got_disp(g)($gp)
; MIPS64-N32-NEXT:    lh $1, 0($16)
; MIPS64-N32-NEXT:    fill.h $w0, $1
; MIPS64-N32-NEXT:    fexupr.w $w0, $w0
; MIPS64-N32-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N32-NEXT:    lw $25, %call16(log10f)($gp)
; MIPS64-N32-NEXT:    jalr $25
; MIPS64-N32-NEXT:    mtc1 $1, $f12
; MIPS64-N32-NEXT:    mfc1 $1, $f0
; MIPS64-N32-NEXT:    fill.w $w0, $1
; MIPS64-N32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N32-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N32-NEXT:    sh $1, 0($16)
; MIPS64-N32-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    jr $ra
; MIPS64-N32-NEXT:    addiu $sp, $sp, 32
;
; MIPS64-N64-LABEL: flog10:
; MIPS64-N64:       # %bb.0: # %entry
; MIPS64-N64-NEXT:    daddiu $sp, $sp, -32
; MIPS64-N64-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N64-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    .cfi_offset 31, -8
; MIPS64-N64-NEXT:    .cfi_offset 28, -16
; MIPS64-N64-NEXT:    .cfi_offset 16, -24
; MIPS64-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(flog10)))
; MIPS64-N64-NEXT:    daddu $1, $1, $25
; MIPS64-N64-NEXT:    daddiu $gp, $1, %lo(%neg(%gp_rel(flog10)))
; MIPS64-N64-NEXT:    ld $16, %got_disp(g)($gp)
; MIPS64-N64-NEXT:    lh $1, 0($16)
; MIPS64-N64-NEXT:    fill.h $w0, $1
; MIPS64-N64-NEXT:    fexupr.w $w0, $w0
; MIPS64-N64-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N64-NEXT:    ld $25, %call16(log10f)($gp)
; MIPS64-N64-NEXT:    jalr $25
; MIPS64-N64-NEXT:    mtc1 $1, $f12
; MIPS64-N64-NEXT:    mfc1 $1, $f0
; MIPS64-N64-NEXT:    fill.w $w0, $1
; MIPS64-N64-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N64-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N64-NEXT:    sh $1, 0($16)
; MIPS64-N64-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    jr $ra
; MIPS64-N64-NEXT:    daddiu $sp, $sp, 32
entry:
  %0 = load i16, i16* @g, align 2
  %1 = call float @llvm.convert.from.fp16.f32(i16 %0)


  %log10 = call float @llvm.log10.f32(float %1)
  %2 = call i16 @llvm.convert.to.fp16.f32(float %log10)


  store i16 %2, i16* @g, align 2

  ret void
}

declare float @llvm.sqrt.f32(float %Val)

define void @fsqrt() {
; MIPS32-LABEL: fsqrt:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-NEXT:    addu $1, $2, $25
; MIPS32-NEXT:    lw $1, %got(g)($1)
; MIPS32-NEXT:    lh $2, 0($1)
; MIPS32-NEXT:    fill.h $w0, $2
; MIPS32-NEXT:    fexupr.w $w0, $w0
; MIPS32-NEXT:    copy_s.w $2, $w0[0]
; MIPS32-NEXT:    mtc1 $2, $f0
; MIPS32-NEXT:    sqrt.s $f0, $f0
; MIPS32-NEXT:    mfc1 $2, $f0
; MIPS32-NEXT:    fill.w $w0, $2
; MIPS32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS32-NEXT:    copy_u.h $2, $w0[0]
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    sh $2, 0($1)
;
; MIPS64-N32-LABEL: fsqrt:
; MIPS64-N32:       # %bb.0: # %entry
; MIPS64-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(fsqrt)))
; MIPS64-N32-NEXT:    addu $1, $1, $25
; MIPS64-N32-NEXT:    addiu $1, $1, %lo(%neg(%gp_rel(fsqrt)))
; MIPS64-N32-NEXT:    lw $1, %got_disp(g)($1)
; MIPS64-N32-NEXT:    lh $2, 0($1)
; MIPS64-N32-NEXT:    fill.h $w0, $2
; MIPS64-N32-NEXT:    fexupr.w $w0, $w0
; MIPS64-N32-NEXT:    copy_s.w $2, $w0[0]
; MIPS64-N32-NEXT:    mtc1 $2, $f0
; MIPS64-N32-NEXT:    sqrt.s $f0, $f0
; MIPS64-N32-NEXT:    mfc1 $2, $f0
; MIPS64-N32-NEXT:    fill.w $w0, $2
; MIPS64-N32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N32-NEXT:    copy_u.h $2, $w0[0]
; MIPS64-N32-NEXT:    jr $ra
; MIPS64-N32-NEXT:    sh $2, 0($1)
;
; MIPS64-N64-LABEL: fsqrt:
; MIPS64-N64:       # %bb.0: # %entry
; MIPS64-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(fsqrt)))
; MIPS64-N64-NEXT:    daddu $1, $1, $25
; MIPS64-N64-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(fsqrt)))
; MIPS64-N64-NEXT:    ld $1, %got_disp(g)($1)
; MIPS64-N64-NEXT:    lh $2, 0($1)
; MIPS64-N64-NEXT:    fill.h $w0, $2
; MIPS64-N64-NEXT:    fexupr.w $w0, $w0
; MIPS64-N64-NEXT:    copy_s.w $2, $w0[0]
; MIPS64-N64-NEXT:    mtc1 $2, $f0
; MIPS64-N64-NEXT:    sqrt.s $f0, $f0
; MIPS64-N64-NEXT:    mfc1 $2, $f0
; MIPS64-N64-NEXT:    fill.w $w0, $2
; MIPS64-N64-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N64-NEXT:    copy_u.h $2, $w0[0]
; MIPS64-N64-NEXT:    jr $ra
; MIPS64-N64-NEXT:    sh $2, 0($1)
entry:
  %0 = load i16, i16* @g, align 2
  %1 = call float @llvm.convert.from.fp16.f32(i16 %0)


  %sqrt = call float @llvm.sqrt.f32(float %1)
  %2 = call i16 @llvm.convert.to.fp16.f32(float %sqrt)


  store i16 %2, i16* @g, align 2

  ret void
}

declare float @llvm.sin.f32(float %Val)

define void @fsin() {
; MIPS32-LABEL: fsin:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-NEXT:    addiu $sp, $sp, -24
; MIPS32-NEXT:    .cfi_def_cfa_offset 24
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $16, 16($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    .cfi_offset 31, -4
; MIPS32-NEXT:    .cfi_offset 16, -8
; MIPS32-NEXT:    addu $gp, $2, $25
; MIPS32-NEXT:    lw $16, %got(g)($gp)
; MIPS32-NEXT:    lh $1, 0($16)
; MIPS32-NEXT:    fill.h $w0, $1
; MIPS32-NEXT:    fexupr.w $w0, $w0
; MIPS32-NEXT:    copy_s.w $1, $w0[0]
; MIPS32-NEXT:    lw $25, %call16(sinf)($gp)
; MIPS32-NEXT:    jalr $25
; MIPS32-NEXT:    mtc1 $1, $f12
; MIPS32-NEXT:    mfc1 $1, $f0
; MIPS32-NEXT:    fill.w $w0, $1
; MIPS32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS32-NEXT:    copy_u.h $1, $w0[0]
; MIPS32-NEXT:    sh $1, 0($16)
; MIPS32-NEXT:    lw $16, 16($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    addiu $sp, $sp, 24
;
; MIPS64-N32-LABEL: fsin:
; MIPS64-N32:       # %bb.0: # %entry
; MIPS64-N32-NEXT:    addiu $sp, $sp, -32
; MIPS64-N32-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N32-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    .cfi_offset 31, -8
; MIPS64-N32-NEXT:    .cfi_offset 28, -16
; MIPS64-N32-NEXT:    .cfi_offset 16, -24
; MIPS64-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(fsin)))
; MIPS64-N32-NEXT:    addu $1, $1, $25
; MIPS64-N32-NEXT:    addiu $gp, $1, %lo(%neg(%gp_rel(fsin)))
; MIPS64-N32-NEXT:    lw $16, %got_disp(g)($gp)
; MIPS64-N32-NEXT:    lh $1, 0($16)
; MIPS64-N32-NEXT:    fill.h $w0, $1
; MIPS64-N32-NEXT:    fexupr.w $w0, $w0
; MIPS64-N32-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N32-NEXT:    lw $25, %call16(sinf)($gp)
; MIPS64-N32-NEXT:    jalr $25
; MIPS64-N32-NEXT:    mtc1 $1, $f12
; MIPS64-N32-NEXT:    mfc1 $1, $f0
; MIPS64-N32-NEXT:    fill.w $w0, $1
; MIPS64-N32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N32-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N32-NEXT:    sh $1, 0($16)
; MIPS64-N32-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    jr $ra
; MIPS64-N32-NEXT:    addiu $sp, $sp, 32
;
; MIPS64-N64-LABEL: fsin:
; MIPS64-N64:       # %bb.0: # %entry
; MIPS64-N64-NEXT:    daddiu $sp, $sp, -32
; MIPS64-N64-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N64-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    .cfi_offset 31, -8
; MIPS64-N64-NEXT:    .cfi_offset 28, -16
; MIPS64-N64-NEXT:    .cfi_offset 16, -24
; MIPS64-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(fsin)))
; MIPS64-N64-NEXT:    daddu $1, $1, $25
; MIPS64-N64-NEXT:    daddiu $gp, $1, %lo(%neg(%gp_rel(fsin)))
; MIPS64-N64-NEXT:    ld $16, %got_disp(g)($gp)
; MIPS64-N64-NEXT:    lh $1, 0($16)
; MIPS64-N64-NEXT:    fill.h $w0, $1
; MIPS64-N64-NEXT:    fexupr.w $w0, $w0
; MIPS64-N64-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N64-NEXT:    ld $25, %call16(sinf)($gp)
; MIPS64-N64-NEXT:    jalr $25
; MIPS64-N64-NEXT:    mtc1 $1, $f12
; MIPS64-N64-NEXT:    mfc1 $1, $f0
; MIPS64-N64-NEXT:    fill.w $w0, $1
; MIPS64-N64-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N64-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N64-NEXT:    sh $1, 0($16)
; MIPS64-N64-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    jr $ra
; MIPS64-N64-NEXT:    daddiu $sp, $sp, 32
entry:
  %0 = load i16, i16* @g, align 2
  %1 = call float @llvm.convert.from.fp16.f32(i16 %0)


  %sin = call float @llvm.sin.f32(float %1)
  %2 = call i16 @llvm.convert.to.fp16.f32(float %sin)


  store i16 %2, i16* @g, align 2

  ret void
}

declare float @llvm.cos.f32(float %Val)

define void @fcos() {
; MIPS32-LABEL: fcos:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-NEXT:    addiu $sp, $sp, -24
; MIPS32-NEXT:    .cfi_def_cfa_offset 24
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $16, 16($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    .cfi_offset 31, -4
; MIPS32-NEXT:    .cfi_offset 16, -8
; MIPS32-NEXT:    addu $gp, $2, $25
; MIPS32-NEXT:    lw $16, %got(g)($gp)
; MIPS32-NEXT:    lh $1, 0($16)
; MIPS32-NEXT:    fill.h $w0, $1
; MIPS32-NEXT:    fexupr.w $w0, $w0
; MIPS32-NEXT:    copy_s.w $1, $w0[0]
; MIPS32-NEXT:    lw $25, %call16(cosf)($gp)
; MIPS32-NEXT:    jalr $25
; MIPS32-NEXT:    mtc1 $1, $f12
; MIPS32-NEXT:    mfc1 $1, $f0
; MIPS32-NEXT:    fill.w $w0, $1
; MIPS32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS32-NEXT:    copy_u.h $1, $w0[0]
; MIPS32-NEXT:    sh $1, 0($16)
; MIPS32-NEXT:    lw $16, 16($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    addiu $sp, $sp, 24
;
; MIPS64-N32-LABEL: fcos:
; MIPS64-N32:       # %bb.0: # %entry
; MIPS64-N32-NEXT:    addiu $sp, $sp, -32
; MIPS64-N32-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N32-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    .cfi_offset 31, -8
; MIPS64-N32-NEXT:    .cfi_offset 28, -16
; MIPS64-N32-NEXT:    .cfi_offset 16, -24
; MIPS64-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(fcos)))
; MIPS64-N32-NEXT:    addu $1, $1, $25
; MIPS64-N32-NEXT:    addiu $gp, $1, %lo(%neg(%gp_rel(fcos)))
; MIPS64-N32-NEXT:    lw $16, %got_disp(g)($gp)
; MIPS64-N32-NEXT:    lh $1, 0($16)
; MIPS64-N32-NEXT:    fill.h $w0, $1
; MIPS64-N32-NEXT:    fexupr.w $w0, $w0
; MIPS64-N32-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N32-NEXT:    lw $25, %call16(cosf)($gp)
; MIPS64-N32-NEXT:    jalr $25
; MIPS64-N32-NEXT:    mtc1 $1, $f12
; MIPS64-N32-NEXT:    mfc1 $1, $f0
; MIPS64-N32-NEXT:    fill.w $w0, $1
; MIPS64-N32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N32-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N32-NEXT:    sh $1, 0($16)
; MIPS64-N32-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    jr $ra
; MIPS64-N32-NEXT:    addiu $sp, $sp, 32
;
; MIPS64-N64-LABEL: fcos:
; MIPS64-N64:       # %bb.0: # %entry
; MIPS64-N64-NEXT:    daddiu $sp, $sp, -32
; MIPS64-N64-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N64-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    .cfi_offset 31, -8
; MIPS64-N64-NEXT:    .cfi_offset 28, -16
; MIPS64-N64-NEXT:    .cfi_offset 16, -24
; MIPS64-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(fcos)))
; MIPS64-N64-NEXT:    daddu $1, $1, $25
; MIPS64-N64-NEXT:    daddiu $gp, $1, %lo(%neg(%gp_rel(fcos)))
; MIPS64-N64-NEXT:    ld $16, %got_disp(g)($gp)
; MIPS64-N64-NEXT:    lh $1, 0($16)
; MIPS64-N64-NEXT:    fill.h $w0, $1
; MIPS64-N64-NEXT:    fexupr.w $w0, $w0
; MIPS64-N64-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N64-NEXT:    ld $25, %call16(cosf)($gp)
; MIPS64-N64-NEXT:    jalr $25
; MIPS64-N64-NEXT:    mtc1 $1, $f12
; MIPS64-N64-NEXT:    mfc1 $1, $f0
; MIPS64-N64-NEXT:    fill.w $w0, $1
; MIPS64-N64-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N64-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N64-NEXT:    sh $1, 0($16)
; MIPS64-N64-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    jr $ra
; MIPS64-N64-NEXT:    daddiu $sp, $sp, 32
entry:
  %0 = load i16, i16* @g, align 2
  %1 = call float @llvm.convert.from.fp16.f32(i16 %0)


  %cos = call float @llvm.cos.f32(float %1)
  %2 = call i16 @llvm.convert.to.fp16.f32(float %cos)


  store i16 %2, i16* @g, align 2

  ret void
}

declare float @llvm.exp.f32(float %Val)

define void @fexp() {
; MIPS32-LABEL: fexp:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-NEXT:    addiu $sp, $sp, -24
; MIPS32-NEXT:    .cfi_def_cfa_offset 24
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $16, 16($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    .cfi_offset 31, -4
; MIPS32-NEXT:    .cfi_offset 16, -8
; MIPS32-NEXT:    addu $gp, $2, $25
; MIPS32-NEXT:    lw $16, %got(g)($gp)
; MIPS32-NEXT:    lh $1, 0($16)
; MIPS32-NEXT:    fill.h $w0, $1
; MIPS32-NEXT:    fexupr.w $w0, $w0
; MIPS32-NEXT:    copy_s.w $1, $w0[0]
; MIPS32-NEXT:    lw $25, %call16(expf)($gp)
; MIPS32-NEXT:    jalr $25
; MIPS32-NEXT:    mtc1 $1, $f12
; MIPS32-NEXT:    mfc1 $1, $f0
; MIPS32-NEXT:    fill.w $w0, $1
; MIPS32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS32-NEXT:    copy_u.h $1, $w0[0]
; MIPS32-NEXT:    sh $1, 0($16)
; MIPS32-NEXT:    lw $16, 16($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    addiu $sp, $sp, 24
;
; MIPS64-N32-LABEL: fexp:
; MIPS64-N32:       # %bb.0: # %entry
; MIPS64-N32-NEXT:    addiu $sp, $sp, -32
; MIPS64-N32-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N32-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    .cfi_offset 31, -8
; MIPS64-N32-NEXT:    .cfi_offset 28, -16
; MIPS64-N32-NEXT:    .cfi_offset 16, -24
; MIPS64-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(fexp)))
; MIPS64-N32-NEXT:    addu $1, $1, $25
; MIPS64-N32-NEXT:    addiu $gp, $1, %lo(%neg(%gp_rel(fexp)))
; MIPS64-N32-NEXT:    lw $16, %got_disp(g)($gp)
; MIPS64-N32-NEXT:    lh $1, 0($16)
; MIPS64-N32-NEXT:    fill.h $w0, $1
; MIPS64-N32-NEXT:    fexupr.w $w0, $w0
; MIPS64-N32-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N32-NEXT:    lw $25, %call16(expf)($gp)
; MIPS64-N32-NEXT:    jalr $25
; MIPS64-N32-NEXT:    mtc1 $1, $f12
; MIPS64-N32-NEXT:    mfc1 $1, $f0
; MIPS64-N32-NEXT:    fill.w $w0, $1
; MIPS64-N32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N32-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N32-NEXT:    sh $1, 0($16)
; MIPS64-N32-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    jr $ra
; MIPS64-N32-NEXT:    addiu $sp, $sp, 32
;
; MIPS64-N64-LABEL: fexp:
; MIPS64-N64:       # %bb.0: # %entry
; MIPS64-N64-NEXT:    daddiu $sp, $sp, -32
; MIPS64-N64-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N64-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    .cfi_offset 31, -8
; MIPS64-N64-NEXT:    .cfi_offset 28, -16
; MIPS64-N64-NEXT:    .cfi_offset 16, -24
; MIPS64-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(fexp)))
; MIPS64-N64-NEXT:    daddu $1, $1, $25
; MIPS64-N64-NEXT:    daddiu $gp, $1, %lo(%neg(%gp_rel(fexp)))
; MIPS64-N64-NEXT:    ld $16, %got_disp(g)($gp)
; MIPS64-N64-NEXT:    lh $1, 0($16)
; MIPS64-N64-NEXT:    fill.h $w0, $1
; MIPS64-N64-NEXT:    fexupr.w $w0, $w0
; MIPS64-N64-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N64-NEXT:    ld $25, %call16(expf)($gp)
; MIPS64-N64-NEXT:    jalr $25
; MIPS64-N64-NEXT:    mtc1 $1, $f12
; MIPS64-N64-NEXT:    mfc1 $1, $f0
; MIPS64-N64-NEXT:    fill.w $w0, $1
; MIPS64-N64-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N64-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N64-NEXT:    sh $1, 0($16)
; MIPS64-N64-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    jr $ra
; MIPS64-N64-NEXT:    daddiu $sp, $sp, 32
entry:
  %0 = load i16, i16* @g, align 2
  %1 = call float @llvm.convert.from.fp16.f32(i16 %0)

  %exp = call float @llvm.exp.f32(float %1)
  %2 = call i16 @llvm.convert.to.fp16.f32(float %exp)


  store i16 %2, i16* @g, align 2

  ret void
}

declare float @llvm.exp2.f32(float %Val)

define void @fexp2() {
; MIPS32-LABEL: fexp2:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-NEXT:    addiu $sp, $sp, -24
; MIPS32-NEXT:    .cfi_def_cfa_offset 24
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $16, 16($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    .cfi_offset 31, -4
; MIPS32-NEXT:    .cfi_offset 16, -8
; MIPS32-NEXT:    addu $gp, $2, $25
; MIPS32-NEXT:    lw $16, %got(g)($gp)
; MIPS32-NEXT:    lh $1, 0($16)
; MIPS32-NEXT:    fill.h $w0, $1
; MIPS32-NEXT:    fexupr.w $w0, $w0
; MIPS32-NEXT:    copy_s.w $1, $w0[0]
; MIPS32-NEXT:    lw $25, %call16(exp2f)($gp)
; MIPS32-NEXT:    jalr $25
; MIPS32-NEXT:    mtc1 $1, $f12
; MIPS32-NEXT:    mfc1 $1, $f0
; MIPS32-NEXT:    fill.w $w0, $1
; MIPS32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS32-NEXT:    copy_u.h $1, $w0[0]
; MIPS32-NEXT:    sh $1, 0($16)
; MIPS32-NEXT:    lw $16, 16($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    addiu $sp, $sp, 24
;
; MIPS64-N32-LABEL: fexp2:
; MIPS64-N32:       # %bb.0: # %entry
; MIPS64-N32-NEXT:    addiu $sp, $sp, -32
; MIPS64-N32-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N32-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    .cfi_offset 31, -8
; MIPS64-N32-NEXT:    .cfi_offset 28, -16
; MIPS64-N32-NEXT:    .cfi_offset 16, -24
; MIPS64-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(fexp2)))
; MIPS64-N32-NEXT:    addu $1, $1, $25
; MIPS64-N32-NEXT:    addiu $gp, $1, %lo(%neg(%gp_rel(fexp2)))
; MIPS64-N32-NEXT:    lw $16, %got_disp(g)($gp)
; MIPS64-N32-NEXT:    lh $1, 0($16)
; MIPS64-N32-NEXT:    fill.h $w0, $1
; MIPS64-N32-NEXT:    fexupr.w $w0, $w0
; MIPS64-N32-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N32-NEXT:    lw $25, %call16(exp2f)($gp)
; MIPS64-N32-NEXT:    jalr $25
; MIPS64-N32-NEXT:    mtc1 $1, $f12
; MIPS64-N32-NEXT:    mfc1 $1, $f0
; MIPS64-N32-NEXT:    fill.w $w0, $1
; MIPS64-N32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N32-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N32-NEXT:    sh $1, 0($16)
; MIPS64-N32-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    jr $ra
; MIPS64-N32-NEXT:    addiu $sp, $sp, 32
;
; MIPS64-N64-LABEL: fexp2:
; MIPS64-N64:       # %bb.0: # %entry
; MIPS64-N64-NEXT:    daddiu $sp, $sp, -32
; MIPS64-N64-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N64-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    .cfi_offset 31, -8
; MIPS64-N64-NEXT:    .cfi_offset 28, -16
; MIPS64-N64-NEXT:    .cfi_offset 16, -24
; MIPS64-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(fexp2)))
; MIPS64-N64-NEXT:    daddu $1, $1, $25
; MIPS64-N64-NEXT:    daddiu $gp, $1, %lo(%neg(%gp_rel(fexp2)))
; MIPS64-N64-NEXT:    ld $16, %got_disp(g)($gp)
; MIPS64-N64-NEXT:    lh $1, 0($16)
; MIPS64-N64-NEXT:    fill.h $w0, $1
; MIPS64-N64-NEXT:    fexupr.w $w0, $w0
; MIPS64-N64-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N64-NEXT:    ld $25, %call16(exp2f)($gp)
; MIPS64-N64-NEXT:    jalr $25
; MIPS64-N64-NEXT:    mtc1 $1, $f12
; MIPS64-N64-NEXT:    mfc1 $1, $f0
; MIPS64-N64-NEXT:    fill.w $w0, $1
; MIPS64-N64-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N64-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N64-NEXT:    sh $1, 0($16)
; MIPS64-N64-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    jr $ra
; MIPS64-N64-NEXT:    daddiu $sp, $sp, 32
entry:
  %0 = load i16, i16* @g, align 2
  %1 = call float @llvm.convert.from.fp16.f32(i16 %0)


  %exp2 = call float @llvm.exp2.f32(float %1)
  %2 = call i16 @llvm.convert.to.fp16.f32(float %exp2)


  store i16 %2, i16* @g, align 2

  ret void
}

declare float @llvm.fma.f32(float, float, float)

define void @ffma(float %b, float %c) {
; MIPS32-LABEL: ffma:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-NEXT:    addiu $sp, $sp, -24
; MIPS32-NEXT:    .cfi_def_cfa_offset 24
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $16, 16($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    .cfi_offset 31, -4
; MIPS32-NEXT:    .cfi_offset 16, -8
; MIPS32-NEXT:    addu $gp, $2, $25
; MIPS32-NEXT:    mov.s $f0, $f12
; MIPS32-NEXT:    mfc1 $6, $f14
; MIPS32-NEXT:    lw $16, %got(g)($gp)
; MIPS32-NEXT:    lh $1, 0($16)
; MIPS32-NEXT:    fill.h $w1, $1
; MIPS32-NEXT:    fexupr.w $w1, $w1
; MIPS32-NEXT:    copy_s.w $1, $w1[0]
; MIPS32-NEXT:    mtc1 $1, $f12
; MIPS32-NEXT:    lw $25, %call16(fmaf)($gp)
; MIPS32-NEXT:    jalr $25
; MIPS32-NEXT:    mov.s $f14, $f0
; MIPS32-NEXT:    mfc1 $1, $f0
; MIPS32-NEXT:    fill.w $w0, $1
; MIPS32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS32-NEXT:    copy_u.h $1, $w0[0]
; MIPS32-NEXT:    sh $1, 0($16)
; MIPS32-NEXT:    lw $16, 16($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    addiu $sp, $sp, 24
;
; MIPS64-N32-LABEL: ffma:
; MIPS64-N32:       # %bb.0: # %entry
; MIPS64-N32-NEXT:    addiu $sp, $sp, -32
; MIPS64-N32-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N32-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    .cfi_offset 31, -8
; MIPS64-N32-NEXT:    .cfi_offset 28, -16
; MIPS64-N32-NEXT:    .cfi_offset 16, -24
; MIPS64-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(ffma)))
; MIPS64-N32-NEXT:    addu $1, $1, $25
; MIPS64-N32-NEXT:    addiu $gp, $1, %lo(%neg(%gp_rel(ffma)))
; MIPS64-N32-NEXT:    mov.s $f14, $f13
; MIPS64-N32-NEXT:    mov.s $f13, $f12
; MIPS64-N32-NEXT:    lw $16, %got_disp(g)($gp)
; MIPS64-N32-NEXT:    lh $1, 0($16)
; MIPS64-N32-NEXT:    fill.h $w0, $1
; MIPS64-N32-NEXT:    fexupr.w $w0, $w0
; MIPS64-N32-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N32-NEXT:    lw $25, %call16(fmaf)($gp)
; MIPS64-N32-NEXT:    jalr $25
; MIPS64-N32-NEXT:    mtc1 $1, $f12
; MIPS64-N32-NEXT:    mfc1 $1, $f0
; MIPS64-N32-NEXT:    fill.w $w0, $1
; MIPS64-N32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N32-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N32-NEXT:    sh $1, 0($16)
; MIPS64-N32-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    jr $ra
; MIPS64-N32-NEXT:    addiu $sp, $sp, 32
;
; MIPS64-N64-LABEL: ffma:
; MIPS64-N64:       # %bb.0: # %entry
; MIPS64-N64-NEXT:    daddiu $sp, $sp, -32
; MIPS64-N64-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N64-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    .cfi_offset 31, -8
; MIPS64-N64-NEXT:    .cfi_offset 28, -16
; MIPS64-N64-NEXT:    .cfi_offset 16, -24
; MIPS64-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(ffma)))
; MIPS64-N64-NEXT:    daddu $1, $1, $25
; MIPS64-N64-NEXT:    daddiu $gp, $1, %lo(%neg(%gp_rel(ffma)))
; MIPS64-N64-NEXT:    mov.s $f14, $f13
; MIPS64-N64-NEXT:    mov.s $f13, $f12
; MIPS64-N64-NEXT:    ld $16, %got_disp(g)($gp)
; MIPS64-N64-NEXT:    lh $1, 0($16)
; MIPS64-N64-NEXT:    fill.h $w0, $1
; MIPS64-N64-NEXT:    fexupr.w $w0, $w0
; MIPS64-N64-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N64-NEXT:    ld $25, %call16(fmaf)($gp)
; MIPS64-N64-NEXT:    jalr $25
; MIPS64-N64-NEXT:    mtc1 $1, $f12
; MIPS64-N64-NEXT:    mfc1 $1, $f0
; MIPS64-N64-NEXT:    fill.w $w0, $1
; MIPS64-N64-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N64-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N64-NEXT:    sh $1, 0($16)
; MIPS64-N64-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    jr $ra
; MIPS64-N64-NEXT:    daddiu $sp, $sp, 32
entry:
  %0 = load i16, i16* @g, align 2
  %1 = call float @llvm.convert.from.fp16.f32(i16 %0)


  %fma = call float @llvm.fma.f32(float %1, float %b, float %c)
  %2 = call i16 @llvm.convert.to.fp16.f32(float %fma)


  store i16 %2, i16* @g, align 2

  ret void
}

; FIXME: For MIPSR6, this should produced the maddf.s instruction. MIPSR5 cannot
;        fuse the operation such that the intermediate result is not rounded.

declare float @llvm.fmuladd.f32(float, float, float)

define void @ffmuladd(float %b, float %c) {
; MIPS32-O32-LABEL: ffmuladd:
; MIPS32-O32:       # %bb.0: # %entry
; MIPS32-O32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-O32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-O32-NEXT:    addu $1, $2, $25
; MIPS32-O32-NEXT:    lw $1, %got(g)($1)
; MIPS32-O32-NEXT:    lh $2, 0($1)
; MIPS32-O32-NEXT:    fill.h $w0, $2
; MIPS32-O32-NEXT:    fexupr.w $w0, $w0
; MIPS32-O32-NEXT:    copy_s.w $2, $w0[0]
; MIPS32-O32-NEXT:    mtc1 $2, $f0
; MIPS32-O32-NEXT:    madd.s $f0, $f14, $f0, $f12
; MIPS32-O32-NEXT:    mfc1 $2, $f0
; MIPS32-O32-NEXT:    fill.w $w0, $2
; MIPS32-O32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS32-O32-NEXT:    copy_u.h $2, $w0[0]
; MIPS32-O32-NEXT:    jr $ra
; MIPS32-O32-NEXT:    sh $2, 0($1)
;
; MIPS64R5-N32-LABEL: ffmuladd:
; MIPS64R5-N32:       # %bb.0: # %entry
; MIPS64R5-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(ffmuladd)))
; MIPS64R5-N32-NEXT:    addu $1, $1, $25
; MIPS64R5-N32-NEXT:    addiu $1, $1, %lo(%neg(%gp_rel(ffmuladd)))
; MIPS64R5-N32-NEXT:    lw $1, %got_disp(g)($1)
; MIPS64R5-N32-NEXT:    lh $2, 0($1)
; MIPS64R5-N32-NEXT:    fill.h $w0, $2
; MIPS64R5-N32-NEXT:    fexupr.w $w0, $w0
; MIPS64R5-N32-NEXT:    copy_s.w $2, $w0[0]
; MIPS64R5-N32-NEXT:    mtc1 $2, $f0
; MIPS64R5-N32-NEXT:    madd.s $f0, $f13, $f0, $f12
; MIPS64R5-N32-NEXT:    mfc1 $2, $f0
; MIPS64R5-N32-NEXT:    fill.w $w0, $2
; MIPS64R5-N32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64R5-N32-NEXT:    copy_u.h $2, $w0[0]
; MIPS64R5-N32-NEXT:    jr $ra
; MIPS64R5-N32-NEXT:    sh $2, 0($1)
;
; MIPS64R5-N64-LABEL: ffmuladd:
; MIPS64R5-N64:       # %bb.0: # %entry
; MIPS64R5-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(ffmuladd)))
; MIPS64R5-N64-NEXT:    daddu $1, $1, $25
; MIPS64R5-N64-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(ffmuladd)))
; MIPS64R5-N64-NEXT:    ld $1, %got_disp(g)($1)
; MIPS64R5-N64-NEXT:    lh $2, 0($1)
; MIPS64R5-N64-NEXT:    fill.h $w0, $2
; MIPS64R5-N64-NEXT:    fexupr.w $w0, $w0
; MIPS64R5-N64-NEXT:    copy_s.w $2, $w0[0]
; MIPS64R5-N64-NEXT:    mtc1 $2, $f0
; MIPS64R5-N64-NEXT:    madd.s $f0, $f13, $f0, $f12
; MIPS64R5-N64-NEXT:    mfc1 $2, $f0
; MIPS64R5-N64-NEXT:    fill.w $w0, $2
; MIPS64R5-N64-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64R5-N64-NEXT:    copy_u.h $2, $w0[0]
; MIPS64R5-N64-NEXT:    jr $ra
; MIPS64R5-N64-NEXT:    sh $2, 0($1)
;
; MIPSR6-O32-LABEL: ffmuladd:
; MIPSR6-O32:       # %bb.0: # %entry
; MIPSR6-O32-NEXT:    lui $2, %hi(_gp_disp)
; MIPSR6-O32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPSR6-O32-NEXT:    addu $1, $2, $25
; MIPSR6-O32-NEXT:    lw $1, %got(g)($1)
; MIPSR6-O32-NEXT:    lh $2, 0($1)
; MIPSR6-O32-NEXT:    fill.h $w0, $2
; MIPSR6-O32-NEXT:    fexupr.w $w0, $w0
; MIPSR6-O32-NEXT:    copy_s.w $2, $w0[0]
; MIPSR6-O32-NEXT:    mtc1 $2, $f0
; MIPSR6-O32-NEXT:    mul.s $f0, $f0, $f12
; MIPSR6-O32-NEXT:    add.s $f0, $f0, $f14
; MIPSR6-O32-NEXT:    mfc1 $2, $f0
; MIPSR6-O32-NEXT:    fill.w $w0, $2
; MIPSR6-O32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPSR6-O32-NEXT:    copy_u.h $2, $w0[0]
; MIPSR6-O32-NEXT:    jr $ra
; MIPSR6-O32-NEXT:    sh $2, 0($1)
;
; MIPSR6-N32-LABEL: ffmuladd:
; MIPSR6-N32:       # %bb.0: # %entry
; MIPSR6-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(ffmuladd)))
; MIPSR6-N32-NEXT:    addu $1, $1, $25
; MIPSR6-N32-NEXT:    addiu $1, $1, %lo(%neg(%gp_rel(ffmuladd)))
; MIPSR6-N32-NEXT:    lw $1, %got_disp(g)($1)
; MIPSR6-N32-NEXT:    lh $2, 0($1)
; MIPSR6-N32-NEXT:    fill.h $w0, $2
; MIPSR6-N32-NEXT:    fexupr.w $w0, $w0
; MIPSR6-N32-NEXT:    copy_s.w $2, $w0[0]
; MIPSR6-N32-NEXT:    mtc1 $2, $f0
; MIPSR6-N32-NEXT:    mul.s $f0, $f0, $f12
; MIPSR6-N32-NEXT:    add.s $f0, $f0, $f13
; MIPSR6-N32-NEXT:    mfc1 $2, $f0
; MIPSR6-N32-NEXT:    fill.w $w0, $2
; MIPSR6-N32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPSR6-N32-NEXT:    copy_u.h $2, $w0[0]
; MIPSR6-N32-NEXT:    jr $ra
; MIPSR6-N32-NEXT:    sh $2, 0($1)
;
; MIPSR6-N64-LABEL: ffmuladd:
; MIPSR6-N64:       # %bb.0: # %entry
; MIPSR6-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(ffmuladd)))
; MIPSR6-N64-NEXT:    daddu $1, $1, $25
; MIPSR6-N64-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(ffmuladd)))
; MIPSR6-N64-NEXT:    ld $1, %got_disp(g)($1)
; MIPSR6-N64-NEXT:    lh $2, 0($1)
; MIPSR6-N64-NEXT:    fill.h $w0, $2
; MIPSR6-N64-NEXT:    fexupr.w $w0, $w0
; MIPSR6-N64-NEXT:    copy_s.w $2, $w0[0]
; MIPSR6-N64-NEXT:    mtc1 $2, $f0
; MIPSR6-N64-NEXT:    mul.s $f0, $f0, $f12
; MIPSR6-N64-NEXT:    add.s $f0, $f0, $f13
; MIPSR6-N64-NEXT:    mfc1 $2, $f0
; MIPSR6-N64-NEXT:    fill.w $w0, $2
; MIPSR6-N64-NEXT:    fexdo.h $w0, $w0, $w0
; MIPSR6-N64-NEXT:    copy_u.h $2, $w0[0]
; MIPSR6-N64-NEXT:    jr $ra
; MIPSR6-N64-NEXT:    sh $2, 0($1)
entry:
  %0 = load i16, i16* @g, align 2
  %1 = call float @llvm.convert.from.fp16.f32(i16 %0)

; MIPS32-N32:     madd.s $f[[F1:[0-9]]], $f13, $f[[F0]], $f12
; MIPS32-N64:     madd.s $f[[F1:[0-9]]], $f13, $f[[F0]], $f12

  %fmuladd = call float @llvm.fmuladd.f32(float %1, float %b, float %c)
  %2 = call i16 @llvm.convert.to.fp16.f32(float %fmuladd)


  store i16 %2, i16* @g, align 2

  ret void
}

declare float @llvm.fabs.f32(float %Val)

define void @ffabs() {
; MIPS32-LABEL: ffabs:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-NEXT:    addu $1, $2, $25
; MIPS32-NEXT:    lw $1, %got(g)($1)
; MIPS32-NEXT:    lh $2, 0($1)
; MIPS32-NEXT:    fill.h $w0, $2
; MIPS32-NEXT:    fexupr.w $w0, $w0
; MIPS32-NEXT:    copy_s.w $2, $w0[0]
; MIPS32-NEXT:    mtc1 $2, $f0
; MIPS32-NEXT:    abs.s $f0, $f0
; MIPS32-NEXT:    mfc1 $2, $f0
; MIPS32-NEXT:    fill.w $w0, $2
; MIPS32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS32-NEXT:    copy_u.h $2, $w0[0]
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    sh $2, 0($1)
;
; MIPS64-N32-LABEL: ffabs:
; MIPS64-N32:       # %bb.0: # %entry
; MIPS64-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(ffabs)))
; MIPS64-N32-NEXT:    addu $1, $1, $25
; MIPS64-N32-NEXT:    addiu $1, $1, %lo(%neg(%gp_rel(ffabs)))
; MIPS64-N32-NEXT:    lw $1, %got_disp(g)($1)
; MIPS64-N32-NEXT:    lh $2, 0($1)
; MIPS64-N32-NEXT:    fill.h $w0, $2
; MIPS64-N32-NEXT:    fexupr.w $w0, $w0
; MIPS64-N32-NEXT:    copy_s.w $2, $w0[0]
; MIPS64-N32-NEXT:    mtc1 $2, $f0
; MIPS64-N32-NEXT:    abs.s $f0, $f0
; MIPS64-N32-NEXT:    mfc1 $2, $f0
; MIPS64-N32-NEXT:    fill.w $w0, $2
; MIPS64-N32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N32-NEXT:    copy_u.h $2, $w0[0]
; MIPS64-N32-NEXT:    jr $ra
; MIPS64-N32-NEXT:    sh $2, 0($1)
;
; MIPS64-N64-LABEL: ffabs:
; MIPS64-N64:       # %bb.0: # %entry
; MIPS64-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(ffabs)))
; MIPS64-N64-NEXT:    daddu $1, $1, $25
; MIPS64-N64-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(ffabs)))
; MIPS64-N64-NEXT:    ld $1, %got_disp(g)($1)
; MIPS64-N64-NEXT:    lh $2, 0($1)
; MIPS64-N64-NEXT:    fill.h $w0, $2
; MIPS64-N64-NEXT:    fexupr.w $w0, $w0
; MIPS64-N64-NEXT:    copy_s.w $2, $w0[0]
; MIPS64-N64-NEXT:    mtc1 $2, $f0
; MIPS64-N64-NEXT:    abs.s $f0, $f0
; MIPS64-N64-NEXT:    mfc1 $2, $f0
; MIPS64-N64-NEXT:    fill.w $w0, $2
; MIPS64-N64-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N64-NEXT:    copy_u.h $2, $w0[0]
; MIPS64-N64-NEXT:    jr $ra
; MIPS64-N64-NEXT:    sh $2, 0($1)
entry:
  %0 = load i16, i16* @g, align 2
  %1 = call float @llvm.convert.from.fp16.f32(i16 %0)


  %fabs = call float @llvm.fabs.f32(float %1)
  %2 = call i16 @llvm.convert.to.fp16.f32(float %fabs)


  store i16 %2, i16* @g, align 2

  ret void
}

declare float @llvm.minnum.f32(float %Val, float %b)

define void @fminnum(float %b) {
; MIPS32-LABEL: fminnum:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-NEXT:    addiu $sp, $sp, -24
; MIPS32-NEXT:    .cfi_def_cfa_offset 24
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $16, 16($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    .cfi_offset 31, -4
; MIPS32-NEXT:    .cfi_offset 16, -8
; MIPS32-NEXT:    addu $gp, $2, $25
; MIPS32-NEXT:    mov.s $f14, $f12
; MIPS32-NEXT:    lw $16, %got(g)($gp)
; MIPS32-NEXT:    lh $1, 0($16)
; MIPS32-NEXT:    fill.h $w0, $1
; MIPS32-NEXT:    fexupr.w $w0, $w0
; MIPS32-NEXT:    copy_s.w $1, $w0[0]
; MIPS32-NEXT:    lw $25, %call16(fminf)($gp)
; MIPS32-NEXT:    jalr $25
; MIPS32-NEXT:    mtc1 $1, $f12
; MIPS32-NEXT:    mfc1 $1, $f0
; MIPS32-NEXT:    fill.w $w0, $1
; MIPS32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS32-NEXT:    copy_u.h $1, $w0[0]
; MIPS32-NEXT:    sh $1, 0($16)
; MIPS32-NEXT:    lw $16, 16($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    addiu $sp, $sp, 24
;
; MIPS64-N32-LABEL: fminnum:
; MIPS64-N32:       # %bb.0: # %entry
; MIPS64-N32-NEXT:    addiu $sp, $sp, -32
; MIPS64-N32-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N32-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    .cfi_offset 31, -8
; MIPS64-N32-NEXT:    .cfi_offset 28, -16
; MIPS64-N32-NEXT:    .cfi_offset 16, -24
; MIPS64-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(fminnum)))
; MIPS64-N32-NEXT:    addu $1, $1, $25
; MIPS64-N32-NEXT:    addiu $gp, $1, %lo(%neg(%gp_rel(fminnum)))
; MIPS64-N32-NEXT:    mov.s $f13, $f12
; MIPS64-N32-NEXT:    lw $16, %got_disp(g)($gp)
; MIPS64-N32-NEXT:    lh $1, 0($16)
; MIPS64-N32-NEXT:    fill.h $w0, $1
; MIPS64-N32-NEXT:    fexupr.w $w0, $w0
; MIPS64-N32-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N32-NEXT:    lw $25, %call16(fminf)($gp)
; MIPS64-N32-NEXT:    jalr $25
; MIPS64-N32-NEXT:    mtc1 $1, $f12
; MIPS64-N32-NEXT:    mfc1 $1, $f0
; MIPS64-N32-NEXT:    fill.w $w0, $1
; MIPS64-N32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N32-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N32-NEXT:    sh $1, 0($16)
; MIPS64-N32-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    jr $ra
; MIPS64-N32-NEXT:    addiu $sp, $sp, 32
;
; MIPS64-N64-LABEL: fminnum:
; MIPS64-N64:       # %bb.0: # %entry
; MIPS64-N64-NEXT:    daddiu $sp, $sp, -32
; MIPS64-N64-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N64-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    .cfi_offset 31, -8
; MIPS64-N64-NEXT:    .cfi_offset 28, -16
; MIPS64-N64-NEXT:    .cfi_offset 16, -24
; MIPS64-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(fminnum)))
; MIPS64-N64-NEXT:    daddu $1, $1, $25
; MIPS64-N64-NEXT:    daddiu $gp, $1, %lo(%neg(%gp_rel(fminnum)))
; MIPS64-N64-NEXT:    mov.s $f13, $f12
; MIPS64-N64-NEXT:    ld $16, %got_disp(g)($gp)
; MIPS64-N64-NEXT:    lh $1, 0($16)
; MIPS64-N64-NEXT:    fill.h $w0, $1
; MIPS64-N64-NEXT:    fexupr.w $w0, $w0
; MIPS64-N64-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N64-NEXT:    ld $25, %call16(fminf)($gp)
; MIPS64-N64-NEXT:    jalr $25
; MIPS64-N64-NEXT:    mtc1 $1, $f12
; MIPS64-N64-NEXT:    mfc1 $1, $f0
; MIPS64-N64-NEXT:    fill.w $w0, $1
; MIPS64-N64-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N64-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N64-NEXT:    sh $1, 0($16)
; MIPS64-N64-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    jr $ra
; MIPS64-N64-NEXT:    daddiu $sp, $sp, 32
entry:
  %0 = load i16, i16* @g, align 2
  %1 = call float @llvm.convert.from.fp16.f32(i16 %0)


  %minnum = call float @llvm.minnum.f32(float %1, float %b)
  %2 = call i16 @llvm.convert.to.fp16.f32(float %minnum)


  store i16 %2, i16* @g, align 2

  ret void
}

declare float @llvm.maxnum.f32(float %Val, float %b)

define void @fmaxnum(float %b) {
; MIPS32-LABEL: fmaxnum:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-NEXT:    addiu $sp, $sp, -24
; MIPS32-NEXT:    .cfi_def_cfa_offset 24
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $16, 16($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    .cfi_offset 31, -4
; MIPS32-NEXT:    .cfi_offset 16, -8
; MIPS32-NEXT:    addu $gp, $2, $25
; MIPS32-NEXT:    mov.s $f14, $f12
; MIPS32-NEXT:    lw $16, %got(g)($gp)
; MIPS32-NEXT:    lh $1, 0($16)
; MIPS32-NEXT:    fill.h $w0, $1
; MIPS32-NEXT:    fexupr.w $w0, $w0
; MIPS32-NEXT:    copy_s.w $1, $w0[0]
; MIPS32-NEXT:    lw $25, %call16(fmaxf)($gp)
; MIPS32-NEXT:    jalr $25
; MIPS32-NEXT:    mtc1 $1, $f12
; MIPS32-NEXT:    mfc1 $1, $f0
; MIPS32-NEXT:    fill.w $w0, $1
; MIPS32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS32-NEXT:    copy_u.h $1, $w0[0]
; MIPS32-NEXT:    sh $1, 0($16)
; MIPS32-NEXT:    lw $16, 16($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    addiu $sp, $sp, 24
;
; MIPS64-N32-LABEL: fmaxnum:
; MIPS64-N32:       # %bb.0: # %entry
; MIPS64-N32-NEXT:    addiu $sp, $sp, -32
; MIPS64-N32-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N32-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    .cfi_offset 31, -8
; MIPS64-N32-NEXT:    .cfi_offset 28, -16
; MIPS64-N32-NEXT:    .cfi_offset 16, -24
; MIPS64-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(fmaxnum)))
; MIPS64-N32-NEXT:    addu $1, $1, $25
; MIPS64-N32-NEXT:    addiu $gp, $1, %lo(%neg(%gp_rel(fmaxnum)))
; MIPS64-N32-NEXT:    mov.s $f13, $f12
; MIPS64-N32-NEXT:    lw $16, %got_disp(g)($gp)
; MIPS64-N32-NEXT:    lh $1, 0($16)
; MIPS64-N32-NEXT:    fill.h $w0, $1
; MIPS64-N32-NEXT:    fexupr.w $w0, $w0
; MIPS64-N32-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N32-NEXT:    lw $25, %call16(fmaxf)($gp)
; MIPS64-N32-NEXT:    jalr $25
; MIPS64-N32-NEXT:    mtc1 $1, $f12
; MIPS64-N32-NEXT:    mfc1 $1, $f0
; MIPS64-N32-NEXT:    fill.w $w0, $1
; MIPS64-N32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N32-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N32-NEXT:    sh $1, 0($16)
; MIPS64-N32-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    jr $ra
; MIPS64-N32-NEXT:    addiu $sp, $sp, 32
;
; MIPS64-N64-LABEL: fmaxnum:
; MIPS64-N64:       # %bb.0: # %entry
; MIPS64-N64-NEXT:    daddiu $sp, $sp, -32
; MIPS64-N64-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N64-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    .cfi_offset 31, -8
; MIPS64-N64-NEXT:    .cfi_offset 28, -16
; MIPS64-N64-NEXT:    .cfi_offset 16, -24
; MIPS64-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(fmaxnum)))
; MIPS64-N64-NEXT:    daddu $1, $1, $25
; MIPS64-N64-NEXT:    daddiu $gp, $1, %lo(%neg(%gp_rel(fmaxnum)))
; MIPS64-N64-NEXT:    mov.s $f13, $f12
; MIPS64-N64-NEXT:    ld $16, %got_disp(g)($gp)
; MIPS64-N64-NEXT:    lh $1, 0($16)
; MIPS64-N64-NEXT:    fill.h $w0, $1
; MIPS64-N64-NEXT:    fexupr.w $w0, $w0
; MIPS64-N64-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N64-NEXT:    ld $25, %call16(fmaxf)($gp)
; MIPS64-N64-NEXT:    jalr $25
; MIPS64-N64-NEXT:    mtc1 $1, $f12
; MIPS64-N64-NEXT:    mfc1 $1, $f0
; MIPS64-N64-NEXT:    fill.w $w0, $1
; MIPS64-N64-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N64-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N64-NEXT:    sh $1, 0($16)
; MIPS64-N64-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    jr $ra
; MIPS64-N64-NEXT:    daddiu $sp, $sp, 32
entry:
  %0 = load i16, i16* @g, align 2
  %1 = call float @llvm.convert.from.fp16.f32(i16 %0)


  %maxnum = call float @llvm.maxnum.f32(float %1, float %b)
  %2 = call i16 @llvm.convert.to.fp16.f32(float %maxnum)


  store i16 %2, i16* @g, align 2

  ret void
}

; This expansion of fcopysign could be done without converting f16 to float.

declare float @llvm.copysign.f32(float %Val, float %b)

define void @fcopysign(float %b) {
; MIPS32-LABEL: fcopysign:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-NEXT:    addu $1, $2, $25
; MIPS32-NEXT:    lw $1, %got(g)($1)
; MIPS32-NEXT:    lh $2, 0($1)
; MIPS32-NEXT:    fill.h $w0, $2
; MIPS32-NEXT:    fexupr.w $w0, $w0
; MIPS32-NEXT:    copy_s.w $2, $w0[0]
; MIPS32-NEXT:    mfc1 $3, $f12
; MIPS32-NEXT:    ext $3, $3, 31, 1
; MIPS32-NEXT:    ins $2, $3, 31, 1
; MIPS32-NEXT:    fill.w $w0, $2
; MIPS32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS32-NEXT:    copy_u.h $2, $w0[0]
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    sh $2, 0($1)
;
; MIPS64-N32-LABEL: fcopysign:
; MIPS64-N32:       # %bb.0: # %entry
; MIPS64-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(fcopysign)))
; MIPS64-N32-NEXT:    addu $1, $1, $25
; MIPS64-N32-NEXT:    addiu $1, $1, %lo(%neg(%gp_rel(fcopysign)))
; MIPS64-N32-NEXT:    lw $1, %got_disp(g)($1)
; MIPS64-N32-NEXT:    lh $2, 0($1)
; MIPS64-N32-NEXT:    fill.h $w0, $2
; MIPS64-N32-NEXT:    fexupr.w $w0, $w0
; MIPS64-N32-NEXT:    copy_s.w $2, $w0[0]
; MIPS64-N32-NEXT:    mfc1 $3, $f12
; MIPS64-N32-NEXT:    ext $3, $3, 31, 1
; MIPS64-N32-NEXT:    ins $2, $3, 31, 1
; MIPS64-N32-NEXT:    fill.w $w0, $2
; MIPS64-N32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N32-NEXT:    copy_u.h $2, $w0[0]
; MIPS64-N32-NEXT:    jr $ra
; MIPS64-N32-NEXT:    sh $2, 0($1)
;
; MIPS64-N64-LABEL: fcopysign:
; MIPS64-N64:       # %bb.0: # %entry
; MIPS64-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(fcopysign)))
; MIPS64-N64-NEXT:    daddu $1, $1, $25
; MIPS64-N64-NEXT:    daddiu $1, $1, %lo(%neg(%gp_rel(fcopysign)))
; MIPS64-N64-NEXT:    ld $1, %got_disp(g)($1)
; MIPS64-N64-NEXT:    lh $2, 0($1)
; MIPS64-N64-NEXT:    fill.h $w0, $2
; MIPS64-N64-NEXT:    fexupr.w $w0, $w0
; MIPS64-N64-NEXT:    copy_s.w $2, $w0[0]
; MIPS64-N64-NEXT:    mfc1 $3, $f12
; MIPS64-N64-NEXT:    ext $3, $3, 31, 1
; MIPS64-N64-NEXT:    ins $2, $3, 31, 1
; MIPS64-N64-NEXT:    fill.w $w0, $2
; MIPS64-N64-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N64-NEXT:    copy_u.h $2, $w0[0]
; MIPS64-N64-NEXT:    jr $ra
; MIPS64-N64-NEXT:    sh $2, 0($1)
entry:
  %0 = load i16, i16* @g, align 2
  %1 = call float @llvm.convert.from.fp16.f32(i16 %0)


  %copysign = call float @llvm.copysign.f32(float %1, float %b)
  %2 = call i16 @llvm.convert.to.fp16.f32(float %copysign)


  store i16 %2, i16* @g, align 2

  ret void
}

declare float @llvm.floor.f32(float %Val)

define void @ffloor() {
; MIPS32-LABEL: ffloor:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-NEXT:    addiu $sp, $sp, -24
; MIPS32-NEXT:    .cfi_def_cfa_offset 24
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $16, 16($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    .cfi_offset 31, -4
; MIPS32-NEXT:    .cfi_offset 16, -8
; MIPS32-NEXT:    addu $gp, $2, $25
; MIPS32-NEXT:    lw $16, %got(g)($gp)
; MIPS32-NEXT:    lh $1, 0($16)
; MIPS32-NEXT:    fill.h $w0, $1
; MIPS32-NEXT:    fexupr.w $w0, $w0
; MIPS32-NEXT:    copy_s.w $1, $w0[0]
; MIPS32-NEXT:    lw $25, %call16(floorf)($gp)
; MIPS32-NEXT:    jalr $25
; MIPS32-NEXT:    mtc1 $1, $f12
; MIPS32-NEXT:    mfc1 $1, $f0
; MIPS32-NEXT:    fill.w $w0, $1
; MIPS32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS32-NEXT:    copy_u.h $1, $w0[0]
; MIPS32-NEXT:    sh $1, 0($16)
; MIPS32-NEXT:    lw $16, 16($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    addiu $sp, $sp, 24
;
; MIPS64-N32-LABEL: ffloor:
; MIPS64-N32:       # %bb.0: # %entry
; MIPS64-N32-NEXT:    addiu $sp, $sp, -32
; MIPS64-N32-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N32-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    .cfi_offset 31, -8
; MIPS64-N32-NEXT:    .cfi_offset 28, -16
; MIPS64-N32-NEXT:    .cfi_offset 16, -24
; MIPS64-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(ffloor)))
; MIPS64-N32-NEXT:    addu $1, $1, $25
; MIPS64-N32-NEXT:    addiu $gp, $1, %lo(%neg(%gp_rel(ffloor)))
; MIPS64-N32-NEXT:    lw $16, %got_disp(g)($gp)
; MIPS64-N32-NEXT:    lh $1, 0($16)
; MIPS64-N32-NEXT:    fill.h $w0, $1
; MIPS64-N32-NEXT:    fexupr.w $w0, $w0
; MIPS64-N32-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N32-NEXT:    lw $25, %call16(floorf)($gp)
; MIPS64-N32-NEXT:    jalr $25
; MIPS64-N32-NEXT:    mtc1 $1, $f12
; MIPS64-N32-NEXT:    mfc1 $1, $f0
; MIPS64-N32-NEXT:    fill.w $w0, $1
; MIPS64-N32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N32-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N32-NEXT:    sh $1, 0($16)
; MIPS64-N32-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    jr $ra
; MIPS64-N32-NEXT:    addiu $sp, $sp, 32
;
; MIPS64-N64-LABEL: ffloor:
; MIPS64-N64:       # %bb.0: # %entry
; MIPS64-N64-NEXT:    daddiu $sp, $sp, -32
; MIPS64-N64-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N64-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    .cfi_offset 31, -8
; MIPS64-N64-NEXT:    .cfi_offset 28, -16
; MIPS64-N64-NEXT:    .cfi_offset 16, -24
; MIPS64-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(ffloor)))
; MIPS64-N64-NEXT:    daddu $1, $1, $25
; MIPS64-N64-NEXT:    daddiu $gp, $1, %lo(%neg(%gp_rel(ffloor)))
; MIPS64-N64-NEXT:    ld $16, %got_disp(g)($gp)
; MIPS64-N64-NEXT:    lh $1, 0($16)
; MIPS64-N64-NEXT:    fill.h $w0, $1
; MIPS64-N64-NEXT:    fexupr.w $w0, $w0
; MIPS64-N64-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N64-NEXT:    ld $25, %call16(floorf)($gp)
; MIPS64-N64-NEXT:    jalr $25
; MIPS64-N64-NEXT:    mtc1 $1, $f12
; MIPS64-N64-NEXT:    mfc1 $1, $f0
; MIPS64-N64-NEXT:    fill.w $w0, $1
; MIPS64-N64-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N64-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N64-NEXT:    sh $1, 0($16)
; MIPS64-N64-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    jr $ra
; MIPS64-N64-NEXT:    daddiu $sp, $sp, 32
entry:
  %0 = load i16, i16* @g, align 2
  %1 = call float @llvm.convert.from.fp16.f32(i16 %0)


  %floor = call float @llvm.floor.f32(float %1)
  %2 = call i16 @llvm.convert.to.fp16.f32(float %floor)


  store i16 %2, i16* @g, align 2

  ret void
}

declare float @llvm.ceil.f32(float %Val)

define void @fceil() {
; MIPS32-LABEL: fceil:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-NEXT:    addiu $sp, $sp, -24
; MIPS32-NEXT:    .cfi_def_cfa_offset 24
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $16, 16($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    .cfi_offset 31, -4
; MIPS32-NEXT:    .cfi_offset 16, -8
; MIPS32-NEXT:    addu $gp, $2, $25
; MIPS32-NEXT:    lw $16, %got(g)($gp)
; MIPS32-NEXT:    lh $1, 0($16)
; MIPS32-NEXT:    fill.h $w0, $1
; MIPS32-NEXT:    fexupr.w $w0, $w0
; MIPS32-NEXT:    copy_s.w $1, $w0[0]
; MIPS32-NEXT:    lw $25, %call16(ceilf)($gp)
; MIPS32-NEXT:    jalr $25
; MIPS32-NEXT:    mtc1 $1, $f12
; MIPS32-NEXT:    mfc1 $1, $f0
; MIPS32-NEXT:    fill.w $w0, $1
; MIPS32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS32-NEXT:    copy_u.h $1, $w0[0]
; MIPS32-NEXT:    sh $1, 0($16)
; MIPS32-NEXT:    lw $16, 16($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    addiu $sp, $sp, 24
;
; MIPS64-N32-LABEL: fceil:
; MIPS64-N32:       # %bb.0: # %entry
; MIPS64-N32-NEXT:    addiu $sp, $sp, -32
; MIPS64-N32-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N32-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    .cfi_offset 31, -8
; MIPS64-N32-NEXT:    .cfi_offset 28, -16
; MIPS64-N32-NEXT:    .cfi_offset 16, -24
; MIPS64-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(fceil)))
; MIPS64-N32-NEXT:    addu $1, $1, $25
; MIPS64-N32-NEXT:    addiu $gp, $1, %lo(%neg(%gp_rel(fceil)))
; MIPS64-N32-NEXT:    lw $16, %got_disp(g)($gp)
; MIPS64-N32-NEXT:    lh $1, 0($16)
; MIPS64-N32-NEXT:    fill.h $w0, $1
; MIPS64-N32-NEXT:    fexupr.w $w0, $w0
; MIPS64-N32-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N32-NEXT:    lw $25, %call16(ceilf)($gp)
; MIPS64-N32-NEXT:    jalr $25
; MIPS64-N32-NEXT:    mtc1 $1, $f12
; MIPS64-N32-NEXT:    mfc1 $1, $f0
; MIPS64-N32-NEXT:    fill.w $w0, $1
; MIPS64-N32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N32-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N32-NEXT:    sh $1, 0($16)
; MIPS64-N32-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    jr $ra
; MIPS64-N32-NEXT:    addiu $sp, $sp, 32
;
; MIPS64-N64-LABEL: fceil:
; MIPS64-N64:       # %bb.0: # %entry
; MIPS64-N64-NEXT:    daddiu $sp, $sp, -32
; MIPS64-N64-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N64-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    .cfi_offset 31, -8
; MIPS64-N64-NEXT:    .cfi_offset 28, -16
; MIPS64-N64-NEXT:    .cfi_offset 16, -24
; MIPS64-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(fceil)))
; MIPS64-N64-NEXT:    daddu $1, $1, $25
; MIPS64-N64-NEXT:    daddiu $gp, $1, %lo(%neg(%gp_rel(fceil)))
; MIPS64-N64-NEXT:    ld $16, %got_disp(g)($gp)
; MIPS64-N64-NEXT:    lh $1, 0($16)
; MIPS64-N64-NEXT:    fill.h $w0, $1
; MIPS64-N64-NEXT:    fexupr.w $w0, $w0
; MIPS64-N64-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N64-NEXT:    ld $25, %call16(ceilf)($gp)
; MIPS64-N64-NEXT:    jalr $25
; MIPS64-N64-NEXT:    mtc1 $1, $f12
; MIPS64-N64-NEXT:    mfc1 $1, $f0
; MIPS64-N64-NEXT:    fill.w $w0, $1
; MIPS64-N64-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N64-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N64-NEXT:    sh $1, 0($16)
; MIPS64-N64-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    jr $ra
; MIPS64-N64-NEXT:    daddiu $sp, $sp, 32
entry:
  %0 = load i16, i16* @g, align 2
  %1 = call float @llvm.convert.from.fp16.f32(i16 %0)


  %ceil = call float @llvm.ceil.f32(float %1)
  %2 = call i16 @llvm.convert.to.fp16.f32(float %ceil)


  store i16 %2, i16* @g, align 2

  ret void
}

declare float @llvm.trunc.f32(float %Val)

define void @ftrunc() {
; MIPS32-LABEL: ftrunc:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-NEXT:    addiu $sp, $sp, -24
; MIPS32-NEXT:    .cfi_def_cfa_offset 24
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $16, 16($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    .cfi_offset 31, -4
; MIPS32-NEXT:    .cfi_offset 16, -8
; MIPS32-NEXT:    addu $gp, $2, $25
; MIPS32-NEXT:    lw $16, %got(g)($gp)
; MIPS32-NEXT:    lh $1, 0($16)
; MIPS32-NEXT:    fill.h $w0, $1
; MIPS32-NEXT:    fexupr.w $w0, $w0
; MIPS32-NEXT:    copy_s.w $1, $w0[0]
; MIPS32-NEXT:    lw $25, %call16(truncf)($gp)
; MIPS32-NEXT:    jalr $25
; MIPS32-NEXT:    mtc1 $1, $f12
; MIPS32-NEXT:    mfc1 $1, $f0
; MIPS32-NEXT:    fill.w $w0, $1
; MIPS32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS32-NEXT:    copy_u.h $1, $w0[0]
; MIPS32-NEXT:    sh $1, 0($16)
; MIPS32-NEXT:    lw $16, 16($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    addiu $sp, $sp, 24
;
; MIPS64-N32-LABEL: ftrunc:
; MIPS64-N32:       # %bb.0: # %entry
; MIPS64-N32-NEXT:    addiu $sp, $sp, -32
; MIPS64-N32-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N32-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    .cfi_offset 31, -8
; MIPS64-N32-NEXT:    .cfi_offset 28, -16
; MIPS64-N32-NEXT:    .cfi_offset 16, -24
; MIPS64-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(ftrunc)))
; MIPS64-N32-NEXT:    addu $1, $1, $25
; MIPS64-N32-NEXT:    addiu $gp, $1, %lo(%neg(%gp_rel(ftrunc)))
; MIPS64-N32-NEXT:    lw $16, %got_disp(g)($gp)
; MIPS64-N32-NEXT:    lh $1, 0($16)
; MIPS64-N32-NEXT:    fill.h $w0, $1
; MIPS64-N32-NEXT:    fexupr.w $w0, $w0
; MIPS64-N32-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N32-NEXT:    lw $25, %call16(truncf)($gp)
; MIPS64-N32-NEXT:    jalr $25
; MIPS64-N32-NEXT:    mtc1 $1, $f12
; MIPS64-N32-NEXT:    mfc1 $1, $f0
; MIPS64-N32-NEXT:    fill.w $w0, $1
; MIPS64-N32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N32-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N32-NEXT:    sh $1, 0($16)
; MIPS64-N32-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    jr $ra
; MIPS64-N32-NEXT:    addiu $sp, $sp, 32
;
; MIPS64-N64-LABEL: ftrunc:
; MIPS64-N64:       # %bb.0: # %entry
; MIPS64-N64-NEXT:    daddiu $sp, $sp, -32
; MIPS64-N64-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N64-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    .cfi_offset 31, -8
; MIPS64-N64-NEXT:    .cfi_offset 28, -16
; MIPS64-N64-NEXT:    .cfi_offset 16, -24
; MIPS64-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(ftrunc)))
; MIPS64-N64-NEXT:    daddu $1, $1, $25
; MIPS64-N64-NEXT:    daddiu $gp, $1, %lo(%neg(%gp_rel(ftrunc)))
; MIPS64-N64-NEXT:    ld $16, %got_disp(g)($gp)
; MIPS64-N64-NEXT:    lh $1, 0($16)
; MIPS64-N64-NEXT:    fill.h $w0, $1
; MIPS64-N64-NEXT:    fexupr.w $w0, $w0
; MIPS64-N64-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N64-NEXT:    ld $25, %call16(truncf)($gp)
; MIPS64-N64-NEXT:    jalr $25
; MIPS64-N64-NEXT:    mtc1 $1, $f12
; MIPS64-N64-NEXT:    mfc1 $1, $f0
; MIPS64-N64-NEXT:    fill.w $w0, $1
; MIPS64-N64-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N64-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N64-NEXT:    sh $1, 0($16)
; MIPS64-N64-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    jr $ra
; MIPS64-N64-NEXT:    daddiu $sp, $sp, 32
entry:
  %0 = load i16, i16* @g, align 2
  %1 = call float @llvm.convert.from.fp16.f32(i16 %0)


  %trunc = call float @llvm.trunc.f32(float %1)
  %2 = call i16 @llvm.convert.to.fp16.f32(float %trunc)


  store i16 %2, i16* @g, align 2

  ret void
}

declare float @llvm.rint.f32(float %Val)

define void @frint() {
; MIPS32-LABEL: frint:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-NEXT:    addiu $sp, $sp, -24
; MIPS32-NEXT:    .cfi_def_cfa_offset 24
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $16, 16($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    .cfi_offset 31, -4
; MIPS32-NEXT:    .cfi_offset 16, -8
; MIPS32-NEXT:    addu $gp, $2, $25
; MIPS32-NEXT:    lw $16, %got(g)($gp)
; MIPS32-NEXT:    lh $1, 0($16)
; MIPS32-NEXT:    fill.h $w0, $1
; MIPS32-NEXT:    fexupr.w $w0, $w0
; MIPS32-NEXT:    copy_s.w $1, $w0[0]
; MIPS32-NEXT:    lw $25, %call16(rintf)($gp)
; MIPS32-NEXT:    jalr $25
; MIPS32-NEXT:    mtc1 $1, $f12
; MIPS32-NEXT:    mfc1 $1, $f0
; MIPS32-NEXT:    fill.w $w0, $1
; MIPS32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS32-NEXT:    copy_u.h $1, $w0[0]
; MIPS32-NEXT:    sh $1, 0($16)
; MIPS32-NEXT:    lw $16, 16($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    addiu $sp, $sp, 24
;
; MIPS64-N32-LABEL: frint:
; MIPS64-N32:       # %bb.0: # %entry
; MIPS64-N32-NEXT:    addiu $sp, $sp, -32
; MIPS64-N32-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N32-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    .cfi_offset 31, -8
; MIPS64-N32-NEXT:    .cfi_offset 28, -16
; MIPS64-N32-NEXT:    .cfi_offset 16, -24
; MIPS64-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(frint)))
; MIPS64-N32-NEXT:    addu $1, $1, $25
; MIPS64-N32-NEXT:    addiu $gp, $1, %lo(%neg(%gp_rel(frint)))
; MIPS64-N32-NEXT:    lw $16, %got_disp(g)($gp)
; MIPS64-N32-NEXT:    lh $1, 0($16)
; MIPS64-N32-NEXT:    fill.h $w0, $1
; MIPS64-N32-NEXT:    fexupr.w $w0, $w0
; MIPS64-N32-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N32-NEXT:    lw $25, %call16(rintf)($gp)
; MIPS64-N32-NEXT:    jalr $25
; MIPS64-N32-NEXT:    mtc1 $1, $f12
; MIPS64-N32-NEXT:    mfc1 $1, $f0
; MIPS64-N32-NEXT:    fill.w $w0, $1
; MIPS64-N32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N32-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N32-NEXT:    sh $1, 0($16)
; MIPS64-N32-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    jr $ra
; MIPS64-N32-NEXT:    addiu $sp, $sp, 32
;
; MIPS64-N64-LABEL: frint:
; MIPS64-N64:       # %bb.0: # %entry
; MIPS64-N64-NEXT:    daddiu $sp, $sp, -32
; MIPS64-N64-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N64-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    .cfi_offset 31, -8
; MIPS64-N64-NEXT:    .cfi_offset 28, -16
; MIPS64-N64-NEXT:    .cfi_offset 16, -24
; MIPS64-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(frint)))
; MIPS64-N64-NEXT:    daddu $1, $1, $25
; MIPS64-N64-NEXT:    daddiu $gp, $1, %lo(%neg(%gp_rel(frint)))
; MIPS64-N64-NEXT:    ld $16, %got_disp(g)($gp)
; MIPS64-N64-NEXT:    lh $1, 0($16)
; MIPS64-N64-NEXT:    fill.h $w0, $1
; MIPS64-N64-NEXT:    fexupr.w $w0, $w0
; MIPS64-N64-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N64-NEXT:    ld $25, %call16(rintf)($gp)
; MIPS64-N64-NEXT:    jalr $25
; MIPS64-N64-NEXT:    mtc1 $1, $f12
; MIPS64-N64-NEXT:    mfc1 $1, $f0
; MIPS64-N64-NEXT:    fill.w $w0, $1
; MIPS64-N64-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N64-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N64-NEXT:    sh $1, 0($16)
; MIPS64-N64-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    jr $ra
; MIPS64-N64-NEXT:    daddiu $sp, $sp, 32
entry:
  %0 = load i16, i16* @g, align 2
  %1 = call float @llvm.convert.from.fp16.f32(i16 %0)

  %rint = call float @llvm.rint.f32(float %1)
  %2 = call i16 @llvm.convert.to.fp16.f32(float %rint)

  store i16 %2, i16* @g, align 2

  ret void
}

declare float @llvm.nearbyint.f32(float %Val)

define void @fnearbyint() {
; MIPS32-LABEL: fnearbyint:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-NEXT:    addiu $sp, $sp, -24
; MIPS32-NEXT:    .cfi_def_cfa_offset 24
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $16, 16($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    .cfi_offset 31, -4
; MIPS32-NEXT:    .cfi_offset 16, -8
; MIPS32-NEXT:    addu $gp, $2, $25
; MIPS32-NEXT:    lw $16, %got(g)($gp)
; MIPS32-NEXT:    lh $1, 0($16)
; MIPS32-NEXT:    fill.h $w0, $1
; MIPS32-NEXT:    fexupr.w $w0, $w0
; MIPS32-NEXT:    copy_s.w $1, $w0[0]
; MIPS32-NEXT:    lw $25, %call16(nearbyintf)($gp)
; MIPS32-NEXT:    jalr $25
; MIPS32-NEXT:    mtc1 $1, $f12
; MIPS32-NEXT:    mfc1 $1, $f0
; MIPS32-NEXT:    fill.w $w0, $1
; MIPS32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS32-NEXT:    copy_u.h $1, $w0[0]
; MIPS32-NEXT:    sh $1, 0($16)
; MIPS32-NEXT:    lw $16, 16($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    addiu $sp, $sp, 24
;
; MIPS64-N32-LABEL: fnearbyint:
; MIPS64-N32:       # %bb.0: # %entry
; MIPS64-N32-NEXT:    addiu $sp, $sp, -32
; MIPS64-N32-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N32-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    .cfi_offset 31, -8
; MIPS64-N32-NEXT:    .cfi_offset 28, -16
; MIPS64-N32-NEXT:    .cfi_offset 16, -24
; MIPS64-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(fnearbyint)))
; MIPS64-N32-NEXT:    addu $1, $1, $25
; MIPS64-N32-NEXT:    addiu $gp, $1, %lo(%neg(%gp_rel(fnearbyint)))
; MIPS64-N32-NEXT:    lw $16, %got_disp(g)($gp)
; MIPS64-N32-NEXT:    lh $1, 0($16)
; MIPS64-N32-NEXT:    fill.h $w0, $1
; MIPS64-N32-NEXT:    fexupr.w $w0, $w0
; MIPS64-N32-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N32-NEXT:    lw $25, %call16(nearbyintf)($gp)
; MIPS64-N32-NEXT:    jalr $25
; MIPS64-N32-NEXT:    mtc1 $1, $f12
; MIPS64-N32-NEXT:    mfc1 $1, $f0
; MIPS64-N32-NEXT:    fill.w $w0, $1
; MIPS64-N32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N32-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N32-NEXT:    sh $1, 0($16)
; MIPS64-N32-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    jr $ra
; MIPS64-N32-NEXT:    addiu $sp, $sp, 32
;
; MIPS64-N64-LABEL: fnearbyint:
; MIPS64-N64:       # %bb.0: # %entry
; MIPS64-N64-NEXT:    daddiu $sp, $sp, -32
; MIPS64-N64-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N64-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    .cfi_offset 31, -8
; MIPS64-N64-NEXT:    .cfi_offset 28, -16
; MIPS64-N64-NEXT:    .cfi_offset 16, -24
; MIPS64-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(fnearbyint)))
; MIPS64-N64-NEXT:    daddu $1, $1, $25
; MIPS64-N64-NEXT:    daddiu $gp, $1, %lo(%neg(%gp_rel(fnearbyint)))
; MIPS64-N64-NEXT:    ld $16, %got_disp(g)($gp)
; MIPS64-N64-NEXT:    lh $1, 0($16)
; MIPS64-N64-NEXT:    fill.h $w0, $1
; MIPS64-N64-NEXT:    fexupr.w $w0, $w0
; MIPS64-N64-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N64-NEXT:    ld $25, %call16(nearbyintf)($gp)
; MIPS64-N64-NEXT:    jalr $25
; MIPS64-N64-NEXT:    mtc1 $1, $f12
; MIPS64-N64-NEXT:    mfc1 $1, $f0
; MIPS64-N64-NEXT:    fill.w $w0, $1
; MIPS64-N64-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N64-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N64-NEXT:    sh $1, 0($16)
; MIPS64-N64-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    jr $ra
; MIPS64-N64-NEXT:    daddiu $sp, $sp, 32
entry:
  %0 = load i16, i16* @g, align 2
  %1 = call float @llvm.convert.from.fp16.f32(i16 %0)


  %nearbyint = call float @llvm.nearbyint.f32(float %1)
  %2 = call i16 @llvm.convert.to.fp16.f32(float %nearbyint)


  store i16 %2, i16* @g, align 2

  ret void
}

declare float @llvm.round.f32(float %Val)

define void @fround() {
; MIPS32-LABEL: fround:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-NEXT:    addiu $sp, $sp, -24
; MIPS32-NEXT:    .cfi_def_cfa_offset 24
; MIPS32-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    sw $16, 16($sp) # 4-byte Folded Spill
; MIPS32-NEXT:    .cfi_offset 31, -4
; MIPS32-NEXT:    .cfi_offset 16, -8
; MIPS32-NEXT:    addu $gp, $2, $25
; MIPS32-NEXT:    lw $16, %got(g)($gp)
; MIPS32-NEXT:    lh $1, 0($16)
; MIPS32-NEXT:    fill.h $w0, $1
; MIPS32-NEXT:    fexupr.w $w0, $w0
; MIPS32-NEXT:    copy_s.w $1, $w0[0]
; MIPS32-NEXT:    lw $25, %call16(roundf)($gp)
; MIPS32-NEXT:    jalr $25
; MIPS32-NEXT:    mtc1 $1, $f12
; MIPS32-NEXT:    mfc1 $1, $f0
; MIPS32-NEXT:    fill.w $w0, $1
; MIPS32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS32-NEXT:    copy_u.h $1, $w0[0]
; MIPS32-NEXT:    sh $1, 0($16)
; MIPS32-NEXT:    lw $16, 16($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    addiu $sp, $sp, 24
;
; MIPS64-N32-LABEL: fround:
; MIPS64-N32:       # %bb.0: # %entry
; MIPS64-N32-NEXT:    addiu $sp, $sp, -32
; MIPS64-N32-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N32-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N32-NEXT:    .cfi_offset 31, -8
; MIPS64-N32-NEXT:    .cfi_offset 28, -16
; MIPS64-N32-NEXT:    .cfi_offset 16, -24
; MIPS64-N32-NEXT:    lui $1, %hi(%neg(%gp_rel(fround)))
; MIPS64-N32-NEXT:    addu $1, $1, $25
; MIPS64-N32-NEXT:    addiu $gp, $1, %lo(%neg(%gp_rel(fround)))
; MIPS64-N32-NEXT:    lw $16, %got_disp(g)($gp)
; MIPS64-N32-NEXT:    lh $1, 0($16)
; MIPS64-N32-NEXT:    fill.h $w0, $1
; MIPS64-N32-NEXT:    fexupr.w $w0, $w0
; MIPS64-N32-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N32-NEXT:    lw $25, %call16(roundf)($gp)
; MIPS64-N32-NEXT:    jalr $25
; MIPS64-N32-NEXT:    mtc1 $1, $f12
; MIPS64-N32-NEXT:    mfc1 $1, $f0
; MIPS64-N32-NEXT:    fill.w $w0, $1
; MIPS64-N32-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N32-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N32-NEXT:    sh $1, 0($16)
; MIPS64-N32-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N32-NEXT:    jr $ra
; MIPS64-N32-NEXT:    addiu $sp, $sp, 32
;
; MIPS64-N64-LABEL: fround:
; MIPS64-N64:       # %bb.0: # %entry
; MIPS64-N64-NEXT:    daddiu $sp, $sp, -32
; MIPS64-N64-NEXT:    .cfi_def_cfa_offset 32
; MIPS64-N64-NEXT:    sd $ra, 24($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $gp, 16($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    sd $16, 8($sp) # 8-byte Folded Spill
; MIPS64-N64-NEXT:    .cfi_offset 31, -8
; MIPS64-N64-NEXT:    .cfi_offset 28, -16
; MIPS64-N64-NEXT:    .cfi_offset 16, -24
; MIPS64-N64-NEXT:    lui $1, %hi(%neg(%gp_rel(fround)))
; MIPS64-N64-NEXT:    daddu $1, $1, $25
; MIPS64-N64-NEXT:    daddiu $gp, $1, %lo(%neg(%gp_rel(fround)))
; MIPS64-N64-NEXT:    ld $16, %got_disp(g)($gp)
; MIPS64-N64-NEXT:    lh $1, 0($16)
; MIPS64-N64-NEXT:    fill.h $w0, $1
; MIPS64-N64-NEXT:    fexupr.w $w0, $w0
; MIPS64-N64-NEXT:    copy_s.w $1, $w0[0]
; MIPS64-N64-NEXT:    ld $25, %call16(roundf)($gp)
; MIPS64-N64-NEXT:    jalr $25
; MIPS64-N64-NEXT:    mtc1 $1, $f12
; MIPS64-N64-NEXT:    mfc1 $1, $f0
; MIPS64-N64-NEXT:    fill.w $w0, $1
; MIPS64-N64-NEXT:    fexdo.h $w0, $w0, $w0
; MIPS64-N64-NEXT:    copy_u.h $1, $w0[0]
; MIPS64-N64-NEXT:    sh $1, 0($16)
; MIPS64-N64-NEXT:    ld $16, 8($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $gp, 16($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    ld $ra, 24($sp) # 8-byte Folded Reload
; MIPS64-N64-NEXT:    jr $ra
; MIPS64-N64-NEXT:    daddiu $sp, $sp, 32
entry:
  %0 = load i16, i16* @g, align 2
  %1 = call float @llvm.convert.from.fp16.f32(i16 %0)


  %round = call float @llvm.round.f32(float %1)
  %2 = call i16 @llvm.convert.to.fp16.f32(float %round)


  store i16 %2, i16* @g, align 2

  ret void
}
