; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -disable-peephole -mtriple=x86_64-apple-darwin -mattr=sse2    | FileCheck %s --check-prefixes=SSE,SSE2
; RUN: llc < %s -disable-peephole -mtriple=x86_64-apple-darwin -mattr=sse4.2  | FileCheck %s --check-prefixes=SSE,SSE42
; RUN: llc < %s -disable-peephole -mtriple=x86_64-apple-darwin -mattr=avx     | FileCheck %s --check-prefixes=AVX,AVX1OR2,AVX1
; RUN: llc < %s -disable-peephole -mtriple=x86_64-apple-darwin -mattr=avx2    | FileCheck %s --check-prefixes=AVX,AVX1OR2,AVX2
; RUN: llc < %s -disable-peephole -mtriple=x86_64-apple-darwin -mattr=avx512f | FileCheck %s --check-prefixes=AVX,AVX512,AVX512F
; RUN: llc < %s -disable-peephole -mtriple=x86_64-apple-darwin -mattr=avx512f,avx512dq,avx512vl | FileCheck %s --check-prefixes=AVX,AVX512,AVX512VL,AVX512VLDQ
; RUN: llc < %s -disable-peephole -mtriple=x86_64-apple-darwin -mattr=avx512f,avx512bw,avx512vl | FileCheck %s --check-prefixes=AVX,AVX512,AVX512VL,AVX512VLBW

;
; vXf64
;

define void @compressstore_v8f64_v8i1(double* %base, <8 x double> %V, <8 x i1> %mask) {
; SSE2-LABEL: compressstore_v8f64_v8i1:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    movd %xmm4, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB0_2
; SSE2-NEXT:  ## %bb.1: ## %cond.store
; SSE2-NEXT:    movlps %xmm0, (%rdi)
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB0_2: ## %else
; SSE2-NEXT:    shrl $16, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB0_4
; SSE2-NEXT:  ## %bb.3: ## %cond.store1
; SSE2-NEXT:    movhps %xmm0, (%rdi)
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB0_4: ## %else2
; SSE2-NEXT:    pextrw $2, %xmm4, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB0_6
; SSE2-NEXT:  ## %bb.5: ## %cond.store4
; SSE2-NEXT:    movlps %xmm1, (%rdi)
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB0_6: ## %else5
; SSE2-NEXT:    pextrw $3, %xmm4, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB0_8
; SSE2-NEXT:  ## %bb.7: ## %cond.store7
; SSE2-NEXT:    movhps %xmm1, (%rdi)
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB0_8: ## %else8
; SSE2-NEXT:    pextrw $4, %xmm4, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB0_10
; SSE2-NEXT:  ## %bb.9: ## %cond.store10
; SSE2-NEXT:    movlps %xmm2, (%rdi)
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB0_10: ## %else11
; SSE2-NEXT:    pextrw $5, %xmm4, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB0_12
; SSE2-NEXT:  ## %bb.11: ## %cond.store13
; SSE2-NEXT:    movhps %xmm2, (%rdi)
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB0_12: ## %else14
; SSE2-NEXT:    pextrw $6, %xmm4, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB0_14
; SSE2-NEXT:  ## %bb.13: ## %cond.store16
; SSE2-NEXT:    movlps %xmm3, (%rdi)
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB0_14: ## %else17
; SSE2-NEXT:    pextrw $7, %xmm4, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB0_16
; SSE2-NEXT:  ## %bb.15: ## %cond.store19
; SSE2-NEXT:    movhps %xmm3, (%rdi)
; SSE2-NEXT:  LBB0_16: ## %else20
; SSE2-NEXT:    retq
;
; SSE42-LABEL: compressstore_v8f64_v8i1:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    pextrb $0, %xmm4, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB0_2
; SSE42-NEXT:  ## %bb.1: ## %cond.store
; SSE42-NEXT:    movlps %xmm0, (%rdi)
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB0_2: ## %else
; SSE42-NEXT:    pextrb $2, %xmm4, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB0_4
; SSE42-NEXT:  ## %bb.3: ## %cond.store1
; SSE42-NEXT:    movhps %xmm0, (%rdi)
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB0_4: ## %else2
; SSE42-NEXT:    pextrb $4, %xmm4, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB0_6
; SSE42-NEXT:  ## %bb.5: ## %cond.store4
; SSE42-NEXT:    movlps %xmm1, (%rdi)
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB0_6: ## %else5
; SSE42-NEXT:    pextrb $6, %xmm4, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB0_8
; SSE42-NEXT:  ## %bb.7: ## %cond.store7
; SSE42-NEXT:    movhps %xmm1, (%rdi)
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB0_8: ## %else8
; SSE42-NEXT:    pextrb $8, %xmm4, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB0_10
; SSE42-NEXT:  ## %bb.9: ## %cond.store10
; SSE42-NEXT:    movlps %xmm2, (%rdi)
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB0_10: ## %else11
; SSE42-NEXT:    pextrb $10, %xmm4, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB0_12
; SSE42-NEXT:  ## %bb.11: ## %cond.store13
; SSE42-NEXT:    movhps %xmm2, (%rdi)
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB0_12: ## %else14
; SSE42-NEXT:    pextrb $12, %xmm4, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB0_14
; SSE42-NEXT:  ## %bb.13: ## %cond.store16
; SSE42-NEXT:    movlps %xmm3, (%rdi)
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB0_14: ## %else17
; SSE42-NEXT:    pextrb $14, %xmm4, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB0_16
; SSE42-NEXT:  ## %bb.15: ## %cond.store19
; SSE42-NEXT:    movhps %xmm3, (%rdi)
; SSE42-NEXT:  LBB0_16: ## %else20
; SSE42-NEXT:    retq
;
; AVX1OR2-LABEL: compressstore_v8f64_v8i1:
; AVX1OR2:       ## %bb.0:
; AVX1OR2-NEXT:    vpextrb $0, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB0_2
; AVX1OR2-NEXT:  ## %bb.1: ## %cond.store
; AVX1OR2-NEXT:    vmovlps %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $8, %rdi
; AVX1OR2-NEXT:  LBB0_2: ## %else
; AVX1OR2-NEXT:    vpextrb $2, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB0_4
; AVX1OR2-NEXT:  ## %bb.3: ## %cond.store1
; AVX1OR2-NEXT:    vmovhps %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $8, %rdi
; AVX1OR2-NEXT:  LBB0_4: ## %else2
; AVX1OR2-NEXT:    vpextrb $4, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1OR2-NEXT:    je LBB0_6
; AVX1OR2-NEXT:  ## %bb.5: ## %cond.store4
; AVX1OR2-NEXT:    vmovlps %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $8, %rdi
; AVX1OR2-NEXT:  LBB0_6: ## %else5
; AVX1OR2-NEXT:    vpextrb $6, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB0_8
; AVX1OR2-NEXT:  ## %bb.7: ## %cond.store7
; AVX1OR2-NEXT:    vmovhps %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $8, %rdi
; AVX1OR2-NEXT:  LBB0_8: ## %else8
; AVX1OR2-NEXT:    vpextrb $8, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB0_10
; AVX1OR2-NEXT:  ## %bb.9: ## %cond.store10
; AVX1OR2-NEXT:    vmovlps %xmm1, (%rdi)
; AVX1OR2-NEXT:    addq $8, %rdi
; AVX1OR2-NEXT:  LBB0_10: ## %else11
; AVX1OR2-NEXT:    vpextrb $10, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB0_12
; AVX1OR2-NEXT:  ## %bb.11: ## %cond.store13
; AVX1OR2-NEXT:    vmovhps %xmm1, (%rdi)
; AVX1OR2-NEXT:    addq $8, %rdi
; AVX1OR2-NEXT:  LBB0_12: ## %else14
; AVX1OR2-NEXT:    vpextrb $12, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    vextractf128 $1, %ymm1, %xmm0
; AVX1OR2-NEXT:    je LBB0_14
; AVX1OR2-NEXT:  ## %bb.13: ## %cond.store16
; AVX1OR2-NEXT:    vmovlps %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $8, %rdi
; AVX1OR2-NEXT:  LBB0_14: ## %else17
; AVX1OR2-NEXT:    vpextrb $14, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB0_16
; AVX1OR2-NEXT:  ## %bb.15: ## %cond.store19
; AVX1OR2-NEXT:    vmovhps %xmm0, (%rdi)
; AVX1OR2-NEXT:  LBB0_16: ## %else20
; AVX1OR2-NEXT:    vzeroupper
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: compressstore_v8f64_v8i1:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    vpmovsxwq %xmm1, %zmm1
; AVX512F-NEXT:    vpsllq $63, %zmm1, %zmm1
; AVX512F-NEXT:    vptestmq %zmm1, %zmm1, %k1
; AVX512F-NEXT:    vcompresspd %zmm0, (%rdi) {%k1}
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLDQ-LABEL: compressstore_v8f64_v8i1:
; AVX512VLDQ:       ## %bb.0:
; AVX512VLDQ-NEXT:    vpmovsxwd %xmm1, %ymm1
; AVX512VLDQ-NEXT:    vpslld $31, %ymm1, %ymm1
; AVX512VLDQ-NEXT:    vpmovd2m %ymm1, %k1
; AVX512VLDQ-NEXT:    vcompresspd %zmm0, (%rdi) {%k1}
; AVX512VLDQ-NEXT:    vzeroupper
; AVX512VLDQ-NEXT:    retq
;
; AVX512VLBW-LABEL: compressstore_v8f64_v8i1:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vpsllw $15, %xmm1, %xmm1
; AVX512VLBW-NEXT:    vpmovw2m %xmm1, %k1
; AVX512VLBW-NEXT:    vcompresspd %zmm0, (%rdi) {%k1}
; AVX512VLBW-NEXT:    vzeroupper
; AVX512VLBW-NEXT:    retq
  call void @llvm.masked.compressstore.v8f64(<8 x double> %V, double* %base, <8 x i1> %mask)
  ret void
}

define void @compressstore_v16f64_v16i1(double* %base, <16 x double> %V, <16 x i1> %mask) {
; SSE2-LABEL: compressstore_v16f64_v16i1:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm8
; SSE2-NEXT:    movdqa %xmm8, -{{[0-9]+}}(%rsp)
; SSE2-NEXT:    testb $1, -{{[0-9]+}}(%rsp)
; SSE2-NEXT:    je LBB1_2
; SSE2-NEXT:  ## %bb.1: ## %cond.store
; SSE2-NEXT:    movlps %xmm0, (%rdi)
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB1_2: ## %else
; SSE2-NEXT:    movd %xmm8, %eax
; SSE2-NEXT:    movl %eax, %ecx
; SSE2-NEXT:    shrl $8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB1_4
; SSE2-NEXT:  ## %bb.3: ## %cond.store1
; SSE2-NEXT:    movhps %xmm0, (%rdi)
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB1_4: ## %else2
; SSE2-NEXT:    movl %eax, %ecx
; SSE2-NEXT:    shrl $16, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB1_6
; SSE2-NEXT:  ## %bb.5: ## %cond.store4
; SSE2-NEXT:    movlps %xmm1, (%rdi)
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB1_6: ## %else5
; SSE2-NEXT:    shrl $24, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB1_8
; SSE2-NEXT:  ## %bb.7: ## %cond.store7
; SSE2-NEXT:    movhps %xmm1, (%rdi)
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB1_8: ## %else8
; SSE2-NEXT:    pextrw $2, %xmm8, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB1_10
; SSE2-NEXT:  ## %bb.9: ## %cond.store10
; SSE2-NEXT:    movlps %xmm2, (%rdi)
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB1_10: ## %else11
; SSE2-NEXT:    shrl $8, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB1_12
; SSE2-NEXT:  ## %bb.11: ## %cond.store13
; SSE2-NEXT:    movhps %xmm2, (%rdi)
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB1_12: ## %else14
; SSE2-NEXT:    pextrw $3, %xmm8, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB1_14
; SSE2-NEXT:  ## %bb.13: ## %cond.store16
; SSE2-NEXT:    movlps %xmm3, (%rdi)
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB1_14: ## %else17
; SSE2-NEXT:    shrl $8, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB1_16
; SSE2-NEXT:  ## %bb.15: ## %cond.store19
; SSE2-NEXT:    movhps %xmm3, (%rdi)
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB1_16: ## %else20
; SSE2-NEXT:    pextrw $4, %xmm8, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB1_18
; SSE2-NEXT:  ## %bb.17: ## %cond.store22
; SSE2-NEXT:    movlps %xmm4, (%rdi)
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB1_18: ## %else23
; SSE2-NEXT:    shrl $8, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB1_20
; SSE2-NEXT:  ## %bb.19: ## %cond.store25
; SSE2-NEXT:    movhps %xmm4, (%rdi)
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB1_20: ## %else26
; SSE2-NEXT:    pextrw $5, %xmm8, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB1_22
; SSE2-NEXT:  ## %bb.21: ## %cond.store28
; SSE2-NEXT:    movlps %xmm5, (%rdi)
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB1_22: ## %else29
; SSE2-NEXT:    shrl $8, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB1_24
; SSE2-NEXT:  ## %bb.23: ## %cond.store31
; SSE2-NEXT:    movhps %xmm5, (%rdi)
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB1_24: ## %else32
; SSE2-NEXT:    pextrw $6, %xmm8, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB1_26
; SSE2-NEXT:  ## %bb.25: ## %cond.store34
; SSE2-NEXT:    movlps %xmm6, (%rdi)
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB1_26: ## %else35
; SSE2-NEXT:    shrl $8, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB1_28
; SSE2-NEXT:  ## %bb.27: ## %cond.store37
; SSE2-NEXT:    movhps %xmm6, (%rdi)
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB1_28: ## %else38
; SSE2-NEXT:    pextrw $7, %xmm8, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB1_30
; SSE2-NEXT:  ## %bb.29: ## %cond.store40
; SSE2-NEXT:    movlps %xmm7, (%rdi)
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB1_30: ## %else41
; SSE2-NEXT:    shrl $8, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB1_32
; SSE2-NEXT:  ## %bb.31: ## %cond.store43
; SSE2-NEXT:    movhps %xmm7, (%rdi)
; SSE2-NEXT:  LBB1_32: ## %else44
; SSE2-NEXT:    retq
;
; SSE42-LABEL: compressstore_v16f64_v16i1:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm8
; SSE42-NEXT:    pextrb $0, %xmm8, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB1_2
; SSE42-NEXT:  ## %bb.1: ## %cond.store
; SSE42-NEXT:    movlps %xmm0, (%rdi)
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB1_2: ## %else
; SSE42-NEXT:    pextrb $1, %xmm8, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB1_4
; SSE42-NEXT:  ## %bb.3: ## %cond.store1
; SSE42-NEXT:    movhps %xmm0, (%rdi)
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB1_4: ## %else2
; SSE42-NEXT:    pextrb $2, %xmm8, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB1_6
; SSE42-NEXT:  ## %bb.5: ## %cond.store4
; SSE42-NEXT:    movlps %xmm1, (%rdi)
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB1_6: ## %else5
; SSE42-NEXT:    pextrb $3, %xmm8, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB1_8
; SSE42-NEXT:  ## %bb.7: ## %cond.store7
; SSE42-NEXT:    movhps %xmm1, (%rdi)
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB1_8: ## %else8
; SSE42-NEXT:    pextrb $4, %xmm8, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB1_10
; SSE42-NEXT:  ## %bb.9: ## %cond.store10
; SSE42-NEXT:    movlps %xmm2, (%rdi)
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB1_10: ## %else11
; SSE42-NEXT:    pextrb $5, %xmm8, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB1_12
; SSE42-NEXT:  ## %bb.11: ## %cond.store13
; SSE42-NEXT:    movhps %xmm2, (%rdi)
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB1_12: ## %else14
; SSE42-NEXT:    pextrb $6, %xmm8, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB1_14
; SSE42-NEXT:  ## %bb.13: ## %cond.store16
; SSE42-NEXT:    movlps %xmm3, (%rdi)
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB1_14: ## %else17
; SSE42-NEXT:    pextrb $7, %xmm8, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB1_16
; SSE42-NEXT:  ## %bb.15: ## %cond.store19
; SSE42-NEXT:    movhps %xmm3, (%rdi)
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB1_16: ## %else20
; SSE42-NEXT:    pextrb $8, %xmm8, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB1_18
; SSE42-NEXT:  ## %bb.17: ## %cond.store22
; SSE42-NEXT:    movlps %xmm4, (%rdi)
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB1_18: ## %else23
; SSE42-NEXT:    pextrb $9, %xmm8, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB1_20
; SSE42-NEXT:  ## %bb.19: ## %cond.store25
; SSE42-NEXT:    movhps %xmm4, (%rdi)
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB1_20: ## %else26
; SSE42-NEXT:    pextrb $10, %xmm8, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB1_22
; SSE42-NEXT:  ## %bb.21: ## %cond.store28
; SSE42-NEXT:    movlps %xmm5, (%rdi)
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB1_22: ## %else29
; SSE42-NEXT:    pextrb $11, %xmm8, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB1_24
; SSE42-NEXT:  ## %bb.23: ## %cond.store31
; SSE42-NEXT:    movhps %xmm5, (%rdi)
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB1_24: ## %else32
; SSE42-NEXT:    pextrb $12, %xmm8, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB1_26
; SSE42-NEXT:  ## %bb.25: ## %cond.store34
; SSE42-NEXT:    movlps %xmm6, (%rdi)
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB1_26: ## %else35
; SSE42-NEXT:    pextrb $13, %xmm8, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB1_28
; SSE42-NEXT:  ## %bb.27: ## %cond.store37
; SSE42-NEXT:    movhps %xmm6, (%rdi)
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB1_28: ## %else38
; SSE42-NEXT:    pextrb $14, %xmm8, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB1_30
; SSE42-NEXT:  ## %bb.29: ## %cond.store40
; SSE42-NEXT:    movlps %xmm7, (%rdi)
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB1_30: ## %else41
; SSE42-NEXT:    pextrb $15, %xmm8, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB1_32
; SSE42-NEXT:  ## %bb.31: ## %cond.store43
; SSE42-NEXT:    movhps %xmm7, (%rdi)
; SSE42-NEXT:  LBB1_32: ## %else44
; SSE42-NEXT:    retq
;
; AVX1OR2-LABEL: compressstore_v16f64_v16i1:
; AVX1OR2:       ## %bb.0:
; AVX1OR2-NEXT:    vpextrb $0, %xmm4, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB1_2
; AVX1OR2-NEXT:  ## %bb.1: ## %cond.store
; AVX1OR2-NEXT:    vmovlps %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $8, %rdi
; AVX1OR2-NEXT:  LBB1_2: ## %else
; AVX1OR2-NEXT:    vpextrb $1, %xmm4, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB1_4
; AVX1OR2-NEXT:  ## %bb.3: ## %cond.store1
; AVX1OR2-NEXT:    vmovhps %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $8, %rdi
; AVX1OR2-NEXT:  LBB1_4: ## %else2
; AVX1OR2-NEXT:    vpextrb $2, %xmm4, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1OR2-NEXT:    je LBB1_6
; AVX1OR2-NEXT:  ## %bb.5: ## %cond.store4
; AVX1OR2-NEXT:    vmovlps %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $8, %rdi
; AVX1OR2-NEXT:  LBB1_6: ## %else5
; AVX1OR2-NEXT:    vpextrb $3, %xmm4, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB1_8
; AVX1OR2-NEXT:  ## %bb.7: ## %cond.store7
; AVX1OR2-NEXT:    vmovhps %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $8, %rdi
; AVX1OR2-NEXT:  LBB1_8: ## %else8
; AVX1OR2-NEXT:    vpextrb $4, %xmm4, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB1_10
; AVX1OR2-NEXT:  ## %bb.9: ## %cond.store10
; AVX1OR2-NEXT:    vmovlps %xmm1, (%rdi)
; AVX1OR2-NEXT:    addq $8, %rdi
; AVX1OR2-NEXT:  LBB1_10: ## %else11
; AVX1OR2-NEXT:    vpextrb $5, %xmm4, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB1_12
; AVX1OR2-NEXT:  ## %bb.11: ## %cond.store13
; AVX1OR2-NEXT:    vmovhps %xmm1, (%rdi)
; AVX1OR2-NEXT:    addq $8, %rdi
; AVX1OR2-NEXT:  LBB1_12: ## %else14
; AVX1OR2-NEXT:    vpextrb $6, %xmm4, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    vextractf128 $1, %ymm1, %xmm0
; AVX1OR2-NEXT:    je LBB1_14
; AVX1OR2-NEXT:  ## %bb.13: ## %cond.store16
; AVX1OR2-NEXT:    vmovlps %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $8, %rdi
; AVX1OR2-NEXT:  LBB1_14: ## %else17
; AVX1OR2-NEXT:    vpextrb $7, %xmm4, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB1_16
; AVX1OR2-NEXT:  ## %bb.15: ## %cond.store19
; AVX1OR2-NEXT:    vmovhps %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $8, %rdi
; AVX1OR2-NEXT:  LBB1_16: ## %else20
; AVX1OR2-NEXT:    vpextrb $8, %xmm4, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB1_18
; AVX1OR2-NEXT:  ## %bb.17: ## %cond.store22
; AVX1OR2-NEXT:    vmovlps %xmm2, (%rdi)
; AVX1OR2-NEXT:    addq $8, %rdi
; AVX1OR2-NEXT:  LBB1_18: ## %else23
; AVX1OR2-NEXT:    vpextrb $9, %xmm4, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB1_20
; AVX1OR2-NEXT:  ## %bb.19: ## %cond.store25
; AVX1OR2-NEXT:    vmovhps %xmm2, (%rdi)
; AVX1OR2-NEXT:    addq $8, %rdi
; AVX1OR2-NEXT:  LBB1_20: ## %else26
; AVX1OR2-NEXT:    vpextrb $10, %xmm4, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    vextractf128 $1, %ymm2, %xmm0
; AVX1OR2-NEXT:    je LBB1_22
; AVX1OR2-NEXT:  ## %bb.21: ## %cond.store28
; AVX1OR2-NEXT:    vmovlps %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $8, %rdi
; AVX1OR2-NEXT:  LBB1_22: ## %else29
; AVX1OR2-NEXT:    vpextrb $11, %xmm4, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB1_24
; AVX1OR2-NEXT:  ## %bb.23: ## %cond.store31
; AVX1OR2-NEXT:    vmovhps %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $8, %rdi
; AVX1OR2-NEXT:  LBB1_24: ## %else32
; AVX1OR2-NEXT:    vpextrb $12, %xmm4, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB1_26
; AVX1OR2-NEXT:  ## %bb.25: ## %cond.store34
; AVX1OR2-NEXT:    vmovlps %xmm3, (%rdi)
; AVX1OR2-NEXT:    addq $8, %rdi
; AVX1OR2-NEXT:  LBB1_26: ## %else35
; AVX1OR2-NEXT:    vpextrb $13, %xmm4, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB1_28
; AVX1OR2-NEXT:  ## %bb.27: ## %cond.store37
; AVX1OR2-NEXT:    vmovhps %xmm3, (%rdi)
; AVX1OR2-NEXT:    addq $8, %rdi
; AVX1OR2-NEXT:  LBB1_28: ## %else38
; AVX1OR2-NEXT:    vpextrb $14, %xmm4, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    vextractf128 $1, %ymm3, %xmm0
; AVX1OR2-NEXT:    je LBB1_30
; AVX1OR2-NEXT:  ## %bb.29: ## %cond.store40
; AVX1OR2-NEXT:    vmovlps %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $8, %rdi
; AVX1OR2-NEXT:  LBB1_30: ## %else41
; AVX1OR2-NEXT:    vpextrb $15, %xmm4, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB1_32
; AVX1OR2-NEXT:  ## %bb.31: ## %cond.store43
; AVX1OR2-NEXT:    vmovhps %xmm0, (%rdi)
; AVX1OR2-NEXT:  LBB1_32: ## %else44
; AVX1OR2-NEXT:    vzeroupper
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: compressstore_v16f64_v16i1:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vpslld $31, %zmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k1
; AVX512F-NEXT:    kshiftrw $8, %k1, %k2
; AVX512F-NEXT:    vcompresspd %zmm0, (%rdi) {%k1}
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    movzbl %al, %eax
; AVX512F-NEXT:    movl %eax, %ecx
; AVX512F-NEXT:    shrl %ecx
; AVX512F-NEXT:    andl $-43, %ecx
; AVX512F-NEXT:    subl %ecx, %eax
; AVX512F-NEXT:    movl %eax, %ecx
; AVX512F-NEXT:    andl $858993459, %ecx ## imm = 0x33333333
; AVX512F-NEXT:    shrl $2, %eax
; AVX512F-NEXT:    andl $858993459, %eax ## imm = 0x33333333
; AVX512F-NEXT:    addl %ecx, %eax
; AVX512F-NEXT:    movl %eax, %ecx
; AVX512F-NEXT:    shrl $4, %ecx
; AVX512F-NEXT:    addl %eax, %ecx
; AVX512F-NEXT:    andl $252645135, %ecx ## imm = 0xF0F0F0F
; AVX512F-NEXT:    imull $16843009, %ecx, %eax ## imm = 0x1010101
; AVX512F-NEXT:    shrl $24, %eax
; AVX512F-NEXT:    vcompresspd %zmm1, (%rdi,%rax,8) {%k2}
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLDQ-LABEL: compressstore_v16f64_v16i1:
; AVX512VLDQ:       ## %bb.0:
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpslld $31, %zmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k1
; AVX512VLDQ-NEXT:    kmovb %k1, %eax
; AVX512VLDQ-NEXT:    movl %eax, %ecx
; AVX512VLDQ-NEXT:    shrl %ecx
; AVX512VLDQ-NEXT:    andl $-43, %ecx
; AVX512VLDQ-NEXT:    subl %ecx, %eax
; AVX512VLDQ-NEXT:    movl %eax, %ecx
; AVX512VLDQ-NEXT:    andl $858993459, %ecx ## imm = 0x33333333
; AVX512VLDQ-NEXT:    shrl $2, %eax
; AVX512VLDQ-NEXT:    andl $858993459, %eax ## imm = 0x33333333
; AVX512VLDQ-NEXT:    addl %ecx, %eax
; AVX512VLDQ-NEXT:    movl %eax, %ecx
; AVX512VLDQ-NEXT:    shrl $4, %ecx
; AVX512VLDQ-NEXT:    addl %eax, %ecx
; AVX512VLDQ-NEXT:    andl $252645135, %ecx ## imm = 0xF0F0F0F
; AVX512VLDQ-NEXT:    imull $16843009, %ecx, %eax ## imm = 0x1010101
; AVX512VLDQ-NEXT:    shrl $24, %eax
; AVX512VLDQ-NEXT:    kshiftrw $8, %k1, %k2
; AVX512VLDQ-NEXT:    vcompresspd %zmm1, (%rdi,%rax,8) {%k2}
; AVX512VLDQ-NEXT:    vcompresspd %zmm0, (%rdi) {%k1}
; AVX512VLDQ-NEXT:    vzeroupper
; AVX512VLDQ-NEXT:    retq
;
; AVX512VLBW-LABEL: compressstore_v16f64_v16i1:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vpsllw $7, %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpmovb2m %xmm2, %k1
; AVX512VLBW-NEXT:    kshiftrw $8, %k1, %k2
; AVX512VLBW-NEXT:    vcompresspd %zmm0, (%rdi) {%k1}
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    movzbl %al, %eax
; AVX512VLBW-NEXT:    movl %eax, %ecx
; AVX512VLBW-NEXT:    shrl %ecx
; AVX512VLBW-NEXT:    andl $-43, %ecx
; AVX512VLBW-NEXT:    subl %ecx, %eax
; AVX512VLBW-NEXT:    movl %eax, %ecx
; AVX512VLBW-NEXT:    andl $858993459, %ecx ## imm = 0x33333333
; AVX512VLBW-NEXT:    shrl $2, %eax
; AVX512VLBW-NEXT:    andl $858993459, %eax ## imm = 0x33333333
; AVX512VLBW-NEXT:    addl %ecx, %eax
; AVX512VLBW-NEXT:    movl %eax, %ecx
; AVX512VLBW-NEXT:    shrl $4, %ecx
; AVX512VLBW-NEXT:    addl %eax, %ecx
; AVX512VLBW-NEXT:    andl $252645135, %ecx ## imm = 0xF0F0F0F
; AVX512VLBW-NEXT:    imull $16843009, %ecx, %eax ## imm = 0x1010101
; AVX512VLBW-NEXT:    shrl $24, %eax
; AVX512VLBW-NEXT:    vcompresspd %zmm1, (%rdi,%rax,8) {%k2}
; AVX512VLBW-NEXT:    vzeroupper
; AVX512VLBW-NEXT:    retq
  call void @llvm.masked.compressstore.v16f64(<16 x double> %V, double* %base, <16 x i1> %mask)
  ret void
}

;
; vXf32
;

define void @compressstore_v2f32_v2i32(float* %base, <2 x float> %V, <2 x i32> %trigger) {
; SSE2-LABEL: compressstore_v2f32_v2i32:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm1
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,0,3,2]
; SSE2-NEXT:    pand %xmm2, %xmm1
; SSE2-NEXT:    movd %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB2_2
; SSE2-NEXT:  ## %bb.1: ## %cond.store
; SSE2-NEXT:    movss %xmm0, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB2_2: ## %else
; SSE2-NEXT:    pextrw $4, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB2_4
; SSE2-NEXT:  ## %bb.3: ## %cond.store1
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1,2,3]
; SSE2-NEXT:    movss %xmm0, (%rdi)
; SSE2-NEXT:  LBB2_4: ## %else2
; SSE2-NEXT:    retq
;
; SSE42-LABEL: compressstore_v2f32_v2i32:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0,1],xmm2[2,3],xmm1[4,5],xmm2[6,7]
; SSE42-NEXT:    pcmpeqq %xmm2, %xmm1
; SSE42-NEXT:    pextrb $0, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB2_2
; SSE42-NEXT:  ## %bb.1: ## %cond.store
; SSE42-NEXT:    movss %xmm0, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB2_2: ## %else
; SSE42-NEXT:    pextrb $8, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB2_4
; SSE42-NEXT:  ## %bb.3: ## %cond.store1
; SSE42-NEXT:    extractps $1, %xmm0, (%rdi)
; SSE42-NEXT:  LBB2_4: ## %else2
; SSE42-NEXT:    retq
;
; AVX1-LABEL: compressstore_v2f32_v2i32:
; AVX1:       ## %bb.0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm1 = xmm1[0,1],xmm2[2,3],xmm1[4,5],xmm2[6,7]
; AVX1-NEXT:    vpcmpeqq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpextrb $0, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB2_2
; AVX1-NEXT:  ## %bb.1: ## %cond.store
; AVX1-NEXT:    vmovss %xmm0, (%rdi)
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB2_2: ## %else
; AVX1-NEXT:    vpextrb $8, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB2_4
; AVX1-NEXT:  ## %bb.3: ## %cond.store1
; AVX1-NEXT:    vextractps $1, %xmm0, (%rdi)
; AVX1-NEXT:  LBB2_4: ## %else2
; AVX1-NEXT:    retq
;
; AVX2-LABEL: compressstore_v2f32_v2i32:
; AVX2:       ## %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0],xmm2[1],xmm1[2],xmm2[3]
; AVX2-NEXT:    vpcmpeqq %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpextrb $0, %xmm1, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB2_2
; AVX2-NEXT:  ## %bb.1: ## %cond.store
; AVX2-NEXT:    vmovss %xmm0, (%rdi)
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB2_2: ## %else
; AVX2-NEXT:    vpextrb $8, %xmm1, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB2_4
; AVX2-NEXT:  ## %bb.3: ## %cond.store1
; AVX2-NEXT:    vextractps $1, %xmm0, (%rdi)
; AVX2-NEXT:  LBB2_4: ## %else2
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: compressstore_v2f32_v2i32:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0],xmm2[1],xmm1[2],xmm2[3]
; AVX512F-NEXT:    vptestnmq %zmm1, %zmm1, %k0
; AVX512F-NEXT:    kshiftlw $14, %k0, %k0
; AVX512F-NEXT:    kshiftrw $14, %k0, %k1
; AVX512F-NEXT:    vcompressps %zmm0, (%rdi) {%k1}
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: compressstore_v2f32_v2i32:
; AVX512VL:       ## %bb.0:
; AVX512VL-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VL-NEXT:    vpblendd {{.*#+}} xmm1 = xmm1[0],xmm2[1],xmm1[2],xmm2[3]
; AVX512VL-NEXT:    vptestnmq %xmm1, %xmm1, %k1
; AVX512VL-NEXT:    vcompressps %xmm0, (%rdi) {%k1}
; AVX512VL-NEXT:    retq
  %mask = icmp eq <2 x i32> %trigger, zeroinitializer
  call void @llvm.masked.compressstore.v2f32(<2 x float> %V, float* %base, <2 x i1> %mask)
  ret void
}

define void @compressstore_v4f32_v4i1(float* %base, <4 x float> %V, <4 x i1> %mask) {
; SSE2-LABEL: compressstore_v4f32_v4i1:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    movd %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB3_2
; SSE2-NEXT:  ## %bb.1: ## %cond.store
; SSE2-NEXT:    movss %xmm0, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB3_2: ## %else
; SSE2-NEXT:    pextrw $2, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB3_4
; SSE2-NEXT:  ## %bb.3: ## %cond.store1
; SSE2-NEXT:    movaps %xmm0, %xmm2
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,1],xmm0[2,3]
; SSE2-NEXT:    movss %xmm2, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB3_4: ## %else2
; SSE2-NEXT:    pextrw $4, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB3_6
; SSE2-NEXT:  ## %bb.5: ## %cond.store4
; SSE2-NEXT:    movaps %xmm0, %xmm2
; SSE2-NEXT:    unpckhpd {{.*#+}} xmm2 = xmm2[1],xmm0[1]
; SSE2-NEXT:    movss %xmm2, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB3_6: ## %else5
; SSE2-NEXT:    pextrw $6, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB3_8
; SSE2-NEXT:  ## %bb.7: ## %cond.store7
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,1,2,3]
; SSE2-NEXT:    movss %xmm0, (%rdi)
; SSE2-NEXT:  LBB3_8: ## %else8
; SSE2-NEXT:    retq
;
; SSE42-LABEL: compressstore_v4f32_v4i1:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    pextrb $0, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB3_2
; SSE42-NEXT:  ## %bb.1: ## %cond.store
; SSE42-NEXT:    movss %xmm0, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB3_2: ## %else
; SSE42-NEXT:    pextrb $4, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB3_4
; SSE42-NEXT:  ## %bb.3: ## %cond.store1
; SSE42-NEXT:    extractps $1, %xmm0, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB3_4: ## %else2
; SSE42-NEXT:    pextrb $8, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB3_6
; SSE42-NEXT:  ## %bb.5: ## %cond.store4
; SSE42-NEXT:    extractps $2, %xmm0, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB3_6: ## %else5
; SSE42-NEXT:    pextrb $12, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB3_8
; SSE42-NEXT:  ## %bb.7: ## %cond.store7
; SSE42-NEXT:    extractps $3, %xmm0, (%rdi)
; SSE42-NEXT:  LBB3_8: ## %else8
; SSE42-NEXT:    retq
;
; AVX1OR2-LABEL: compressstore_v4f32_v4i1:
; AVX1OR2:       ## %bb.0:
; AVX1OR2-NEXT:    vpextrb $0, %xmm1, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB3_2
; AVX1OR2-NEXT:  ## %bb.1: ## %cond.store
; AVX1OR2-NEXT:    vmovss %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $4, %rdi
; AVX1OR2-NEXT:  LBB3_2: ## %else
; AVX1OR2-NEXT:    vpextrb $4, %xmm1, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB3_4
; AVX1OR2-NEXT:  ## %bb.3: ## %cond.store1
; AVX1OR2-NEXT:    vextractps $1, %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $4, %rdi
; AVX1OR2-NEXT:  LBB3_4: ## %else2
; AVX1OR2-NEXT:    vpextrb $8, %xmm1, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB3_6
; AVX1OR2-NEXT:  ## %bb.5: ## %cond.store4
; AVX1OR2-NEXT:    vextractps $2, %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $4, %rdi
; AVX1OR2-NEXT:  LBB3_6: ## %else5
; AVX1OR2-NEXT:    vpextrb $12, %xmm1, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB3_8
; AVX1OR2-NEXT:  ## %bb.7: ## %cond.store7
; AVX1OR2-NEXT:    vextractps $3, %xmm0, (%rdi)
; AVX1OR2-NEXT:  LBB3_8: ## %else8
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: compressstore_v4f32_v4i1:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX512F-NEXT:    vptestmd %zmm1, %zmm1, %k0
; AVX512F-NEXT:    kshiftlw $12, %k0, %k0
; AVX512F-NEXT:    kshiftrw $12, %k0, %k1
; AVX512F-NEXT:    vcompressps %zmm0, (%rdi) {%k1}
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLDQ-LABEL: compressstore_v4f32_v4i1:
; AVX512VLDQ:       ## %bb.0:
; AVX512VLDQ-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX512VLDQ-NEXT:    vpmovd2m %xmm1, %k1
; AVX512VLDQ-NEXT:    vcompressps %xmm0, (%rdi) {%k1}
; AVX512VLDQ-NEXT:    retq
;
; AVX512VLBW-LABEL: compressstore_v4f32_v4i1:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX512VLBW-NEXT:    vptestmd %xmm1, %xmm1, %k1
; AVX512VLBW-NEXT:    vcompressps %xmm0, (%rdi) {%k1}
; AVX512VLBW-NEXT:    retq
  call void @llvm.masked.compressstore.v4f32(<4 x float> %V, float* %base, <4 x i1> %mask)
  ret void
}

define void @compressstore_v8f32_v8i1(float* %base, <8 x float> %V, <8 x i1> %mask) {
; SSE2-LABEL: compressstore_v8f32_v8i1:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    movd %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB4_2
; SSE2-NEXT:  ## %bb.1: ## %cond.store
; SSE2-NEXT:    movss %xmm0, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB4_2: ## %else
; SSE2-NEXT:    shrl $16, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB4_4
; SSE2-NEXT:  ## %bb.3: ## %cond.store1
; SSE2-NEXT:    movaps %xmm0, %xmm3
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,1],xmm0[2,3]
; SSE2-NEXT:    movss %xmm3, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB4_4: ## %else2
; SSE2-NEXT:    pextrw $2, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB4_6
; SSE2-NEXT:  ## %bb.5: ## %cond.store4
; SSE2-NEXT:    movaps %xmm0, %xmm3
; SSE2-NEXT:    unpckhpd {{.*#+}} xmm3 = xmm3[1],xmm0[1]
; SSE2-NEXT:    movss %xmm3, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB4_6: ## %else5
; SSE2-NEXT:    pextrw $3, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB4_8
; SSE2-NEXT:  ## %bb.7: ## %cond.store7
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,1,2,3]
; SSE2-NEXT:    movss %xmm0, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB4_8: ## %else8
; SSE2-NEXT:    pextrw $4, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB4_10
; SSE2-NEXT:  ## %bb.9: ## %cond.store10
; SSE2-NEXT:    movss %xmm1, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB4_10: ## %else11
; SSE2-NEXT:    pextrw $5, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB4_12
; SSE2-NEXT:  ## %bb.11: ## %cond.store13
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[2,3]
; SSE2-NEXT:    movss %xmm0, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB4_12: ## %else14
; SSE2-NEXT:    pextrw $6, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB4_14
; SSE2-NEXT:  ## %bb.13: ## %cond.store16
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE2-NEXT:    movss %xmm0, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB4_14: ## %else17
; SSE2-NEXT:    pextrw $7, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB4_16
; SSE2-NEXT:  ## %bb.15: ## %cond.store19
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,1,2,3]
; SSE2-NEXT:    movss %xmm1, (%rdi)
; SSE2-NEXT:  LBB4_16: ## %else20
; SSE2-NEXT:    retq
;
; SSE42-LABEL: compressstore_v8f32_v8i1:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    pextrb $0, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB4_2
; SSE42-NEXT:  ## %bb.1: ## %cond.store
; SSE42-NEXT:    movss %xmm0, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB4_2: ## %else
; SSE42-NEXT:    pextrb $2, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB4_4
; SSE42-NEXT:  ## %bb.3: ## %cond.store1
; SSE42-NEXT:    extractps $1, %xmm0, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB4_4: ## %else2
; SSE42-NEXT:    pextrb $4, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB4_6
; SSE42-NEXT:  ## %bb.5: ## %cond.store4
; SSE42-NEXT:    extractps $2, %xmm0, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB4_6: ## %else5
; SSE42-NEXT:    pextrb $6, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB4_8
; SSE42-NEXT:  ## %bb.7: ## %cond.store7
; SSE42-NEXT:    extractps $3, %xmm0, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB4_8: ## %else8
; SSE42-NEXT:    pextrb $8, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB4_10
; SSE42-NEXT:  ## %bb.9: ## %cond.store10
; SSE42-NEXT:    movss %xmm1, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB4_10: ## %else11
; SSE42-NEXT:    pextrb $10, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB4_12
; SSE42-NEXT:  ## %bb.11: ## %cond.store13
; SSE42-NEXT:    extractps $1, %xmm1, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB4_12: ## %else14
; SSE42-NEXT:    pextrb $12, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB4_14
; SSE42-NEXT:  ## %bb.13: ## %cond.store16
; SSE42-NEXT:    extractps $2, %xmm1, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB4_14: ## %else17
; SSE42-NEXT:    pextrb $14, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB4_16
; SSE42-NEXT:  ## %bb.15: ## %cond.store19
; SSE42-NEXT:    extractps $3, %xmm1, (%rdi)
; SSE42-NEXT:  LBB4_16: ## %else20
; SSE42-NEXT:    retq
;
; AVX1OR2-LABEL: compressstore_v8f32_v8i1:
; AVX1OR2:       ## %bb.0:
; AVX1OR2-NEXT:    vpextrb $0, %xmm1, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB4_2
; AVX1OR2-NEXT:  ## %bb.1: ## %cond.store
; AVX1OR2-NEXT:    vmovss %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $4, %rdi
; AVX1OR2-NEXT:  LBB4_2: ## %else
; AVX1OR2-NEXT:    vpextrb $2, %xmm1, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB4_4
; AVX1OR2-NEXT:  ## %bb.3: ## %cond.store1
; AVX1OR2-NEXT:    vextractps $1, %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $4, %rdi
; AVX1OR2-NEXT:  LBB4_4: ## %else2
; AVX1OR2-NEXT:    vpextrb $4, %xmm1, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB4_6
; AVX1OR2-NEXT:  ## %bb.5: ## %cond.store4
; AVX1OR2-NEXT:    vextractps $2, %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $4, %rdi
; AVX1OR2-NEXT:  LBB4_6: ## %else5
; AVX1OR2-NEXT:    vpextrb $6, %xmm1, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB4_8
; AVX1OR2-NEXT:  ## %bb.7: ## %cond.store7
; AVX1OR2-NEXT:    vextractps $3, %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $4, %rdi
; AVX1OR2-NEXT:  LBB4_8: ## %else8
; AVX1OR2-NEXT:    vpextrb $8, %xmm1, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1OR2-NEXT:    je LBB4_10
; AVX1OR2-NEXT:  ## %bb.9: ## %cond.store10
; AVX1OR2-NEXT:    vmovss %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $4, %rdi
; AVX1OR2-NEXT:  LBB4_10: ## %else11
; AVX1OR2-NEXT:    vpextrb $10, %xmm1, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB4_12
; AVX1OR2-NEXT:  ## %bb.11: ## %cond.store13
; AVX1OR2-NEXT:    vextractps $1, %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $4, %rdi
; AVX1OR2-NEXT:  LBB4_12: ## %else14
; AVX1OR2-NEXT:    vpextrb $12, %xmm1, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB4_14
; AVX1OR2-NEXT:  ## %bb.13: ## %cond.store16
; AVX1OR2-NEXT:    vextractps $2, %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $4, %rdi
; AVX1OR2-NEXT:  LBB4_14: ## %else17
; AVX1OR2-NEXT:    vpextrb $14, %xmm1, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB4_16
; AVX1OR2-NEXT:  ## %bb.15: ## %cond.store19
; AVX1OR2-NEXT:    vextractps $3, %xmm0, (%rdi)
; AVX1OR2-NEXT:  LBB4_16: ## %else20
; AVX1OR2-NEXT:    vzeroupper
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: compressstore_v8f32_v8i1:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vpmovsxwq %xmm1, %zmm1
; AVX512F-NEXT:    vpsllq $63, %zmm1, %zmm1
; AVX512F-NEXT:    vptestmq %zmm1, %zmm1, %k1
; AVX512F-NEXT:    vcompressps %zmm0, (%rdi) {%k1}
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLDQ-LABEL: compressstore_v8f32_v8i1:
; AVX512VLDQ:       ## %bb.0:
; AVX512VLDQ-NEXT:    vpmovsxwd %xmm1, %ymm1
; AVX512VLDQ-NEXT:    vpslld $31, %ymm1, %ymm1
; AVX512VLDQ-NEXT:    vpmovd2m %ymm1, %k1
; AVX512VLDQ-NEXT:    vcompressps %ymm0, (%rdi) {%k1}
; AVX512VLDQ-NEXT:    vzeroupper
; AVX512VLDQ-NEXT:    retq
;
; AVX512VLBW-LABEL: compressstore_v8f32_v8i1:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vpsllw $15, %xmm1, %xmm1
; AVX512VLBW-NEXT:    vpmovw2m %xmm1, %k1
; AVX512VLBW-NEXT:    vcompressps %ymm0, (%rdi) {%k1}
; AVX512VLBW-NEXT:    vzeroupper
; AVX512VLBW-NEXT:    retq
  call void @llvm.masked.compressstore.v8f32(<8 x float> %V, float* %base, <8 x i1> %mask)
  ret void
}

define void @compressstore_v16f32_const(float* %base, <16 x float> %V) {
; SSE2-LABEL: compressstore_v16f32_const:
; SSE2:       ## %bb.0: ## %cond.store
; SSE2-NEXT:    movss %xmm0, (%rdi)
; SSE2-NEXT:    movaps %xmm0, %xmm4
; SSE2-NEXT:    shufps {{.*#+}} xmm4 = xmm4[1,1],xmm0[2,3]
; SSE2-NEXT:    movss %xmm4, 4(%rdi)
; SSE2-NEXT:    movaps %xmm0, %xmm4
; SSE2-NEXT:    unpckhpd {{.*#+}} xmm4 = xmm4[1],xmm0[1]
; SSE2-NEXT:    movss %xmm4, 8(%rdi)
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,1,2,3]
; SSE2-NEXT:    movss %xmm0, 12(%rdi)
; SSE2-NEXT:    movss %xmm1, 16(%rdi)
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[2,3]
; SSE2-NEXT:    movss %xmm0, 20(%rdi)
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE2-NEXT:    movss %xmm0, 24(%rdi)
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,1,2,3]
; SSE2-NEXT:    movss %xmm1, 28(%rdi)
; SSE2-NEXT:    movss %xmm2, 32(%rdi)
; SSE2-NEXT:    movaps %xmm2, %xmm0
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm2[2,3]
; SSE2-NEXT:    movss %xmm0, 36(%rdi)
; SSE2-NEXT:    movhlps {{.*#+}} xmm2 = xmm2[1,1]
; SSE2-NEXT:    movss %xmm2, 40(%rdi)
; SSE2-NEXT:    movss %xmm3, 44(%rdi)
; SSE2-NEXT:    movaps %xmm3, %xmm0
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm3[2,3]
; SSE2-NEXT:    movss %xmm0, 48(%rdi)
; SSE2-NEXT:    movaps %xmm3, %xmm0
; SSE2-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm3[1]
; SSE2-NEXT:    movss %xmm0, 52(%rdi)
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[3,1,2,3]
; SSE2-NEXT:    movss %xmm3, 56(%rdi)
; SSE2-NEXT:    retq
;
; SSE42-LABEL: compressstore_v16f32_const:
; SSE42:       ## %bb.0: ## %cond.store
; SSE42-NEXT:    movups %xmm0, (%rdi)
; SSE42-NEXT:    movups %xmm1, 16(%rdi)
; SSE42-NEXT:    insertps {{.*#+}} xmm2 = xmm2[0,1,2],xmm3[0]
; SSE42-NEXT:    movups %xmm2, 32(%rdi)
; SSE42-NEXT:    extractps $1, %xmm3, 48(%rdi)
; SSE42-NEXT:    extractps $2, %xmm3, 52(%rdi)
; SSE42-NEXT:    extractps $3, %xmm3, 56(%rdi)
; SSE42-NEXT:    retq
;
; AVX1-LABEL: compressstore_v16f32_const:
; AVX1:       ## %bb.0: ## %cond.store
; AVX1-NEXT:    vmovups %ymm0, (%rdi)
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm0
; AVX1-NEXT:    vinsertps {{.*#+}} xmm1 = xmm1[0,1,2],xmm0[0]
; AVX1-NEXT:    vmovups %xmm1, 32(%rdi)
; AVX1-NEXT:    vextractps $1, %xmm0, 48(%rdi)
; AVX1-NEXT:    vextractps $2, %xmm0, 52(%rdi)
; AVX1-NEXT:    vextractps $3, %xmm0, 56(%rdi)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: compressstore_v16f32_const:
; AVX2:       ## %bb.0: ## %cond.store
; AVX2-NEXT:    vmovups %ymm0, (%rdi)
; AVX2-NEXT:    vmovaps {{.*#+}} xmm0 = [0,1,2,4]
; AVX2-NEXT:    vpermps %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vmovups %xmm0, 32(%rdi)
; AVX2-NEXT:    vextractf128 $1, %ymm1, %xmm0
; AVX2-NEXT:    vextractps $1, %xmm0, 48(%rdi)
; AVX2-NEXT:    vextractps $2, %xmm0, 52(%rdi)
; AVX2-NEXT:    vextractps $3, %xmm0, 56(%rdi)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: compressstore_v16f32_const:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    movw $-2049, %ax ## imm = 0xF7FF
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vcompressps %zmm0, (%rdi) {%k1}
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLDQ-LABEL: compressstore_v16f32_const:
; AVX512VLDQ:       ## %bb.0:
; AVX512VLDQ-NEXT:    movw $-2049, %ax ## imm = 0xF7FF
; AVX512VLDQ-NEXT:    kmovw %eax, %k1
; AVX512VLDQ-NEXT:    vcompressps %zmm0, (%rdi) {%k1}
; AVX512VLDQ-NEXT:    vzeroupper
; AVX512VLDQ-NEXT:    retq
;
; AVX512VLBW-LABEL: compressstore_v16f32_const:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    movw $-2049, %ax ## imm = 0xF7FF
; AVX512VLBW-NEXT:    kmovd %eax, %k1
; AVX512VLBW-NEXT:    vcompressps %zmm0, (%rdi) {%k1}
; AVX512VLBW-NEXT:    vzeroupper
; AVX512VLBW-NEXT:    retq
  call void @llvm.masked.compressstore.v16f32(<16 x float> %V, float* %base, <16 x i1> <i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 false, i1 true, i1 true, i1 true, i1 true>)
  ret void
}

define void @compressstore_v32f32_v32i32(float* %base, <32 x float> %V, <32 x i32> %trigger) {
; SSE2-LABEL: compressstore_v32f32_v32i32:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm9
; SSE2-NEXT:    pxor %xmm8, %xmm8
; SSE2-NEXT:    pcmpeqd %xmm9, %xmm8
; SSE2-NEXT:    movd %xmm8, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_2
; SSE2-NEXT:  ## %bb.1: ## %cond.store
; SSE2-NEXT:    movss %xmm0, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB6_2: ## %else
; SSE2-NEXT:    pextrw $2, %xmm8, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_4
; SSE2-NEXT:  ## %bb.3: ## %cond.store1
; SSE2-NEXT:    movaps %xmm0, %xmm8
; SSE2-NEXT:    shufps {{.*#+}} xmm8 = xmm8[1,1],xmm0[2,3]
; SSE2-NEXT:    movss %xmm8, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB6_4: ## %else2
; SSE2-NEXT:    xorps %xmm8, %xmm8
; SSE2-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE2-NEXT:    pextrw $4, %xmm9, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_6
; SSE2-NEXT:  ## %bb.5: ## %cond.store4
; SSE2-NEXT:    movaps %xmm0, %xmm8
; SSE2-NEXT:    unpckhpd {{.*#+}} xmm8 = xmm8[1],xmm0[1]
; SSE2-NEXT:    movss %xmm8, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB6_6: ## %else5
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm8
; SSE2-NEXT:    pextrw $6, %xmm9, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_8
; SSE2-NEXT:  ## %bb.7: ## %cond.store7
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[3,1,2,3]
; SSE2-NEXT:    movss %xmm0, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB6_8: ## %else8
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm8, %xmm0
; SSE2-NEXT:    movd %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_10
; SSE2-NEXT:  ## %bb.9: ## %cond.store10
; SSE2-NEXT:    movss %xmm1, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB6_10: ## %else11
; SSE2-NEXT:    pextrw $2, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_12
; SSE2-NEXT:  ## %bb.11: ## %cond.store13
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm1[2,3]
; SSE2-NEXT:    movss %xmm0, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB6_12: ## %else14
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm8
; SSE2-NEXT:    pextrw $4, %xmm8, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_14
; SSE2-NEXT:  ## %bb.13: ## %cond.store16
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm1[1]
; SSE2-NEXT:    movss %xmm0, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB6_14: ## %else17
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm0
; SSE2-NEXT:    pextrw $6, %xmm8, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_16
; SSE2-NEXT:  ## %bb.15: ## %cond.store19
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[3,1,2,3]
; SSE2-NEXT:    movss %xmm1, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB6_16: ## %else20
; SSE2-NEXT:    xorps %xmm1, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE2-NEXT:    movd %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_18
; SSE2-NEXT:  ## %bb.17: ## %cond.store22
; SSE2-NEXT:    movss %xmm2, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB6_18: ## %else23
; SSE2-NEXT:    pextrw $2, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_20
; SSE2-NEXT:  ## %bb.19: ## %cond.store25
; SSE2-NEXT:    movaps %xmm2, %xmm1
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm2[2,3]
; SSE2-NEXT:    movss %xmm1, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB6_20: ## %else26
; SSE2-NEXT:    xorps %xmm1, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE2-NEXT:    pextrw $4, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_22
; SSE2-NEXT:  ## %bb.21: ## %cond.store28
; SSE2-NEXT:    movaps %xmm2, %xmm1
; SSE2-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm2[1]
; SSE2-NEXT:    movss %xmm1, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB6_22: ## %else29
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm1
; SSE2-NEXT:    pextrw $6, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_24
; SSE2-NEXT:  ## %bb.23: ## %cond.store31
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[3,1,2,3]
; SSE2-NEXT:    movss %xmm2, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB6_24: ## %else32
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE2-NEXT:    movd %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_26
; SSE2-NEXT:  ## %bb.25: ## %cond.store34
; SSE2-NEXT:    movss %xmm3, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB6_26: ## %else35
; SSE2-NEXT:    pextrw $2, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_28
; SSE2-NEXT:  ## %bb.27: ## %cond.store37
; SSE2-NEXT:    movaps %xmm3, %xmm0
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm3[2,3]
; SSE2-NEXT:    movss %xmm0, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB6_28: ## %else38
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE2-NEXT:    pextrw $4, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_30
; SSE2-NEXT:  ## %bb.29: ## %cond.store40
; SSE2-NEXT:    movaps %xmm3, %xmm0
; SSE2-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm3[1]
; SSE2-NEXT:    movss %xmm0, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB6_30: ## %else41
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm0
; SSE2-NEXT:    pextrw $6, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_32
; SSE2-NEXT:  ## %bb.31: ## %cond.store43
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[3,1,2,3]
; SSE2-NEXT:    movss %xmm3, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB6_32: ## %else44
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE2-NEXT:    movd %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_34
; SSE2-NEXT:  ## %bb.33: ## %cond.store46
; SSE2-NEXT:    movss %xmm4, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB6_34: ## %else47
; SSE2-NEXT:    pextrw $2, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_36
; SSE2-NEXT:  ## %bb.35: ## %cond.store49
; SSE2-NEXT:    movaps %xmm4, %xmm1
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm4[2,3]
; SSE2-NEXT:    movss %xmm1, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB6_36: ## %else50
; SSE2-NEXT:    xorps %xmm1, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE2-NEXT:    pextrw $4, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_38
; SSE2-NEXT:  ## %bb.37: ## %cond.store52
; SSE2-NEXT:    movaps %xmm4, %xmm1
; SSE2-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm4[1]
; SSE2-NEXT:    movss %xmm1, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB6_38: ## %else53
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm1
; SSE2-NEXT:    pextrw $6, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_40
; SSE2-NEXT:  ## %bb.39: ## %cond.store55
; SSE2-NEXT:    shufps {{.*#+}} xmm4 = xmm4[3,1,2,3]
; SSE2-NEXT:    movss %xmm4, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB6_40: ## %else56
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE2-NEXT:    movd %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_42
; SSE2-NEXT:  ## %bb.41: ## %cond.store58
; SSE2-NEXT:    movss %xmm5, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB6_42: ## %else59
; SSE2-NEXT:    pextrw $2, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_44
; SSE2-NEXT:  ## %bb.43: ## %cond.store61
; SSE2-NEXT:    movaps %xmm5, %xmm0
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm5[2,3]
; SSE2-NEXT:    movss %xmm0, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB6_44: ## %else62
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE2-NEXT:    pextrw $4, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_46
; SSE2-NEXT:  ## %bb.45: ## %cond.store64
; SSE2-NEXT:    movaps %xmm5, %xmm0
; SSE2-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm5[1]
; SSE2-NEXT:    movss %xmm0, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB6_46: ## %else65
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm0
; SSE2-NEXT:    pextrw $6, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_48
; SSE2-NEXT:  ## %bb.47: ## %cond.store67
; SSE2-NEXT:    shufps {{.*#+}} xmm5 = xmm5[3,1,2,3]
; SSE2-NEXT:    movss %xmm5, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB6_48: ## %else68
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE2-NEXT:    movd %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_50
; SSE2-NEXT:  ## %bb.49: ## %cond.store70
; SSE2-NEXT:    movss %xmm6, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB6_50: ## %else71
; SSE2-NEXT:    pextrw $2, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_52
; SSE2-NEXT:  ## %bb.51: ## %cond.store73
; SSE2-NEXT:    movaps %xmm6, %xmm1
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[1,1],xmm6[2,3]
; SSE2-NEXT:    movss %xmm1, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB6_52: ## %else74
; SSE2-NEXT:    xorps %xmm1, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE2-NEXT:    pextrw $4, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_54
; SSE2-NEXT:  ## %bb.53: ## %cond.store76
; SSE2-NEXT:    movaps %xmm6, %xmm1
; SSE2-NEXT:    unpckhpd {{.*#+}} xmm1 = xmm1[1],xmm6[1]
; SSE2-NEXT:    movss %xmm1, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB6_54: ## %else77
; SSE2-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm1
; SSE2-NEXT:    pextrw $6, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_56
; SSE2-NEXT:  ## %bb.55: ## %cond.store79
; SSE2-NEXT:    shufps {{.*#+}} xmm6 = xmm6[3,1,2,3]
; SSE2-NEXT:    movss %xmm6, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB6_56: ## %else80
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE2-NEXT:    movd %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_58
; SSE2-NEXT:  ## %bb.57: ## %cond.store82
; SSE2-NEXT:    movss %xmm7, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB6_58: ## %else83
; SSE2-NEXT:    pextrw $2, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_60
; SSE2-NEXT:  ## %bb.59: ## %cond.store85
; SSE2-NEXT:    movaps %xmm7, %xmm0
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,1],xmm7[2,3]
; SSE2-NEXT:    movss %xmm0, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB6_60: ## %else86
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE2-NEXT:    pextrw $4, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_62
; SSE2-NEXT:  ## %bb.61: ## %cond.store88
; SSE2-NEXT:    movaps %xmm7, %xmm0
; SSE2-NEXT:    unpckhpd {{.*#+}} xmm0 = xmm0[1],xmm7[1]
; SSE2-NEXT:    movss %xmm0, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB6_62: ## %else89
; SSE2-NEXT:    pextrw $6, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_64
; SSE2-NEXT:  ## %bb.63: ## %cond.store91
; SSE2-NEXT:    shufps {{.*#+}} xmm7 = xmm7[3,1,2,3]
; SSE2-NEXT:    movss %xmm7, (%rdi)
; SSE2-NEXT:  LBB6_64: ## %else92
; SSE2-NEXT:    retq
;
; SSE42-LABEL: compressstore_v32f32_v32i32:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm9
; SSE42-NEXT:    pxor %xmm8, %xmm8
; SSE42-NEXT:    pcmpeqd %xmm9, %xmm8
; SSE42-NEXT:    pextrb $0, %xmm8, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_2
; SSE42-NEXT:  ## %bb.1: ## %cond.store
; SSE42-NEXT:    movd %xmm0, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB6_2: ## %else
; SSE42-NEXT:    pextrb $4, %xmm8, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_4
; SSE42-NEXT:  ## %bb.3: ## %cond.store1
; SSE42-NEXT:    pextrd $1, %xmm0, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB6_4: ## %else2
; SSE42-NEXT:    pxor %xmm8, %xmm8
; SSE42-NEXT:    pcmpeqd %xmm8, %xmm9
; SSE42-NEXT:    pextrb $8, %xmm9, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_6
; SSE42-NEXT:  ## %bb.5: ## %cond.store4
; SSE42-NEXT:    pextrd $2, %xmm0, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB6_6: ## %else5
; SSE42-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm8
; SSE42-NEXT:    pextrb $12, %xmm9, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_8
; SSE42-NEXT:  ## %bb.7: ## %cond.store7
; SSE42-NEXT:    pextrd $3, %xmm0, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB6_8: ## %else8
; SSE42-NEXT:    pxor %xmm0, %xmm0
; SSE42-NEXT:    pcmpeqd %xmm8, %xmm0
; SSE42-NEXT:    pextrb $0, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_10
; SSE42-NEXT:  ## %bb.9: ## %cond.store10
; SSE42-NEXT:    movd %xmm1, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB6_10: ## %else11
; SSE42-NEXT:    pextrb $4, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_12
; SSE42-NEXT:  ## %bb.11: ## %cond.store13
; SSE42-NEXT:    pextrd $1, %xmm1, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB6_12: ## %else14
; SSE42-NEXT:    pxor %xmm0, %xmm0
; SSE42-NEXT:    pcmpeqd %xmm0, %xmm8
; SSE42-NEXT:    pextrb $8, %xmm8, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_14
; SSE42-NEXT:  ## %bb.13: ## %cond.store16
; SSE42-NEXT:    pextrd $2, %xmm1, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB6_14: ## %else17
; SSE42-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm0
; SSE42-NEXT:    pextrb $12, %xmm8, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_16
; SSE42-NEXT:  ## %bb.15: ## %cond.store19
; SSE42-NEXT:    pextrd $3, %xmm1, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB6_16: ## %else20
; SSE42-NEXT:    pxor %xmm1, %xmm1
; SSE42-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE42-NEXT:    pextrb $0, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_18
; SSE42-NEXT:  ## %bb.17: ## %cond.store22
; SSE42-NEXT:    movss %xmm2, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB6_18: ## %else23
; SSE42-NEXT:    pextrb $4, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_20
; SSE42-NEXT:  ## %bb.19: ## %cond.store25
; SSE42-NEXT:    extractps $1, %xmm2, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB6_20: ## %else26
; SSE42-NEXT:    pxor %xmm1, %xmm1
; SSE42-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE42-NEXT:    pextrb $8, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_22
; SSE42-NEXT:  ## %bb.21: ## %cond.store28
; SSE42-NEXT:    extractps $2, %xmm2, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB6_22: ## %else29
; SSE42-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm1
; SSE42-NEXT:    pextrb $12, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_24
; SSE42-NEXT:  ## %bb.23: ## %cond.store31
; SSE42-NEXT:    extractps $3, %xmm2, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB6_24: ## %else32
; SSE42-NEXT:    pxor %xmm0, %xmm0
; SSE42-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE42-NEXT:    pextrb $0, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_26
; SSE42-NEXT:  ## %bb.25: ## %cond.store34
; SSE42-NEXT:    movss %xmm3, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB6_26: ## %else35
; SSE42-NEXT:    pextrb $4, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_28
; SSE42-NEXT:  ## %bb.27: ## %cond.store37
; SSE42-NEXT:    extractps $1, %xmm3, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB6_28: ## %else38
; SSE42-NEXT:    pxor %xmm0, %xmm0
; SSE42-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE42-NEXT:    pextrb $8, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_30
; SSE42-NEXT:  ## %bb.29: ## %cond.store40
; SSE42-NEXT:    extractps $2, %xmm3, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB6_30: ## %else41
; SSE42-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm0
; SSE42-NEXT:    pextrb $12, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_32
; SSE42-NEXT:  ## %bb.31: ## %cond.store43
; SSE42-NEXT:    extractps $3, %xmm3, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB6_32: ## %else44
; SSE42-NEXT:    pxor %xmm1, %xmm1
; SSE42-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE42-NEXT:    pextrb $0, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_34
; SSE42-NEXT:  ## %bb.33: ## %cond.store46
; SSE42-NEXT:    movss %xmm4, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB6_34: ## %else47
; SSE42-NEXT:    pextrb $4, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_36
; SSE42-NEXT:  ## %bb.35: ## %cond.store49
; SSE42-NEXT:    extractps $1, %xmm4, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB6_36: ## %else50
; SSE42-NEXT:    pxor %xmm1, %xmm1
; SSE42-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE42-NEXT:    pextrb $8, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_38
; SSE42-NEXT:  ## %bb.37: ## %cond.store52
; SSE42-NEXT:    extractps $2, %xmm4, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB6_38: ## %else53
; SSE42-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm1
; SSE42-NEXT:    pextrb $12, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_40
; SSE42-NEXT:  ## %bb.39: ## %cond.store55
; SSE42-NEXT:    extractps $3, %xmm4, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB6_40: ## %else56
; SSE42-NEXT:    pxor %xmm0, %xmm0
; SSE42-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE42-NEXT:    pextrb $0, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_42
; SSE42-NEXT:  ## %bb.41: ## %cond.store58
; SSE42-NEXT:    movss %xmm5, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB6_42: ## %else59
; SSE42-NEXT:    pextrb $4, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_44
; SSE42-NEXT:  ## %bb.43: ## %cond.store61
; SSE42-NEXT:    extractps $1, %xmm5, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB6_44: ## %else62
; SSE42-NEXT:    pxor %xmm0, %xmm0
; SSE42-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE42-NEXT:    pextrb $8, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_46
; SSE42-NEXT:  ## %bb.45: ## %cond.store64
; SSE42-NEXT:    extractps $2, %xmm5, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB6_46: ## %else65
; SSE42-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm0
; SSE42-NEXT:    pextrb $12, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_48
; SSE42-NEXT:  ## %bb.47: ## %cond.store67
; SSE42-NEXT:    extractps $3, %xmm5, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB6_48: ## %else68
; SSE42-NEXT:    pxor %xmm1, %xmm1
; SSE42-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE42-NEXT:    pextrb $0, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_50
; SSE42-NEXT:  ## %bb.49: ## %cond.store70
; SSE42-NEXT:    movss %xmm6, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB6_50: ## %else71
; SSE42-NEXT:    pextrb $4, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_52
; SSE42-NEXT:  ## %bb.51: ## %cond.store73
; SSE42-NEXT:    extractps $1, %xmm6, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB6_52: ## %else74
; SSE42-NEXT:    pxor %xmm1, %xmm1
; SSE42-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE42-NEXT:    pextrb $8, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_54
; SSE42-NEXT:  ## %bb.53: ## %cond.store76
; SSE42-NEXT:    extractps $2, %xmm6, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB6_54: ## %else77
; SSE42-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm1
; SSE42-NEXT:    pextrb $12, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_56
; SSE42-NEXT:  ## %bb.55: ## %cond.store79
; SSE42-NEXT:    extractps $3, %xmm6, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB6_56: ## %else80
; SSE42-NEXT:    pxor %xmm0, %xmm0
; SSE42-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE42-NEXT:    pextrb $0, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_58
; SSE42-NEXT:  ## %bb.57: ## %cond.store82
; SSE42-NEXT:    movss %xmm7, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB6_58: ## %else83
; SSE42-NEXT:    pextrb $4, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_60
; SSE42-NEXT:  ## %bb.59: ## %cond.store85
; SSE42-NEXT:    extractps $1, %xmm7, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB6_60: ## %else86
; SSE42-NEXT:    pxor %xmm0, %xmm0
; SSE42-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE42-NEXT:    pextrb $8, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_62
; SSE42-NEXT:  ## %bb.61: ## %cond.store88
; SSE42-NEXT:    extractps $2, %xmm7, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB6_62: ## %else89
; SSE42-NEXT:    pextrb $12, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_64
; SSE42-NEXT:  ## %bb.63: ## %cond.store91
; SSE42-NEXT:    extractps $3, %xmm7, (%rdi)
; SSE42-NEXT:  LBB6_64: ## %else92
; SSE42-NEXT:    retq
;
; AVX1-LABEL: compressstore_v32f32_v32i32:
; AVX1:       ## %bb.0:
; AVX1-NEXT:    vpxor %xmm8, %xmm8, %xmm8
; AVX1-NEXT:    vpcmpeqd %xmm8, %xmm4, %xmm9
; AVX1-NEXT:    vpackssdw %xmm0, %xmm9, %xmm9
; AVX1-NEXT:    vpacksswb %xmm0, %xmm9, %xmm9
; AVX1-NEXT:    vpextrb $0, %xmm9, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB6_2
; AVX1-NEXT:  ## %bb.1: ## %cond.store
; AVX1-NEXT:    vmovd %xmm0, (%rdi)
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB6_2: ## %else
; AVX1-NEXT:    vpcmpeqd %xmm8, %xmm4, %xmm8
; AVX1-NEXT:    vpackssdw %xmm0, %xmm8, %xmm8
; AVX1-NEXT:    vpacksswb %xmm0, %xmm8, %xmm8
; AVX1-NEXT:    vpextrb $1, %xmm8, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB6_4
; AVX1-NEXT:  ## %bb.3: ## %cond.store1
; AVX1-NEXT:    vpextrd $1, %xmm0, (%rdi)
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB6_4: ## %else2
; AVX1-NEXT:    vpxor %xmm8, %xmm8, %xmm8
; AVX1-NEXT:    vpcmpeqd %xmm8, %xmm4, %xmm9
; AVX1-NEXT:    vpackssdw %xmm0, %xmm9, %xmm9
; AVX1-NEXT:    vpacksswb %xmm0, %xmm9, %xmm9
; AVX1-NEXT:    vpextrb $2, %xmm9, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB6_6
; AVX1-NEXT:  ## %bb.5: ## %cond.store4
; AVX1-NEXT:    vpextrd $2, %xmm0, (%rdi)
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB6_6: ## %else5
; AVX1-NEXT:    vpcmpeqd %xmm8, %xmm4, %xmm8
; AVX1-NEXT:    vpackssdw %xmm0, %xmm8, %xmm8
; AVX1-NEXT:    vpacksswb %xmm0, %xmm8, %xmm8
; AVX1-NEXT:    vpextrb $3, %xmm8, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB6_8
; AVX1-NEXT:  ## %bb.7: ## %cond.store7
; AVX1-NEXT:    vpextrd $3, %xmm0, (%rdi)
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB6_8: ## %else8
; AVX1-NEXT:    vextractf128 $1, %ymm4, %xmm8
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm8, %xmm9
; AVX1-NEXT:    vpackssdw %xmm9, %xmm0, %xmm4
; AVX1-NEXT:    vpacksswb %xmm0, %xmm4, %xmm4
; AVX1-NEXT:    vpextrb $4, %xmm4, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm10
; AVX1-NEXT:    je LBB6_10
; AVX1-NEXT:  ## %bb.9: ## %cond.store10
; AVX1-NEXT:    vmovss %xmm10, (%rdi)
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB6_10: ## %else11
; AVX1-NEXT:    vpackssdw %xmm9, %xmm0, %xmm4
; AVX1-NEXT:    vpacksswb %xmm0, %xmm4, %xmm4
; AVX1-NEXT:    vpextrb $5, %xmm4, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB6_12
; AVX1-NEXT:  ## %bb.11: ## %cond.store13
; AVX1-NEXT:    vextractps $1, %xmm10, (%rdi)
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB6_12: ## %else14
; AVX1-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm8, %xmm4
; AVX1-NEXT:    vpackssdw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpextrb $6, %xmm0, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB6_14
; AVX1-NEXT:  ## %bb.13: ## %cond.store16
; AVX1-NEXT:    vextractps $2, %xmm10, (%rdi)
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB6_14: ## %else17
; AVX1-NEXT:    vpackssdw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpextrb $7, %xmm0, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB6_16
; AVX1-NEXT:  ## %bb.15: ## %cond.store19
; AVX1-NEXT:    vextractps $3, %xmm10, (%rdi)
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB6_16: ## %else20
; AVX1-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpeqd %xmm0, %xmm5, %xmm4
; AVX1-NEXT:    vpackssdw %xmm0, %xmm4, %xmm4
; AVX1-NEXT:    vpacksswb %xmm4, %xmm0, %xmm4
; AVX1-NEXT:    vpextrb $8, %xmm4, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB6_18
; AVX1-NEXT:  ## %bb.17: ## %cond.store22
; AVX1-NEXT:    vmovss %xmm1, (%rdi)
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB6_18: ## %else23
; AVX1-NEXT:    vpcmpeqd %xmm0, %xmm5, %xmm0
; AVX1-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpextrb $9, %xmm0, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB6_20
; AVX1-NEXT:  ## %bb.19: ## %cond.store25
; AVX1-NEXT:    vextractps $1, %xmm1, (%rdi)
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB6_20: ## %else26
; AVX1-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpeqd %xmm0, %xmm5, %xmm4
; AVX1-NEXT:    vpackssdw %xmm0, %xmm4, %xmm4
; AVX1-NEXT:    vpacksswb %xmm4, %xmm0, %xmm4
; AVX1-NEXT:    vpextrb $10, %xmm4, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB6_22
; AVX1-NEXT:  ## %bb.21: ## %cond.store28
; AVX1-NEXT:    vextractps $2, %xmm1, (%rdi)
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB6_22: ## %else29
; AVX1-NEXT:    vpcmpeqd %xmm0, %xmm5, %xmm0
; AVX1-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpextrb $11, %xmm0, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB6_24
; AVX1-NEXT:  ## %bb.23: ## %cond.store31
; AVX1-NEXT:    vextractps $3, %xmm1, (%rdi)
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB6_24: ## %else32
; AVX1-NEXT:    vextractf128 $1, %ymm5, %xmm4
; AVX1-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpeqd %xmm0, %xmm4, %xmm5
; AVX1-NEXT:    vpackssdw %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpextrb $12, %xmm0, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm0
; AVX1-NEXT:    je LBB6_26
; AVX1-NEXT:  ## %bb.25: ## %cond.store34
; AVX1-NEXT:    vmovd %xmm0, (%rdi)
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB6_26: ## %else35
; AVX1-NEXT:    vpackssdw %xmm5, %xmm0, %xmm1
; AVX1-NEXT:    vpacksswb %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vpextrb $13, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB6_28
; AVX1-NEXT:  ## %bb.27: ## %cond.store37
; AVX1-NEXT:    vpextrd $1, %xmm0, (%rdi)
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB6_28: ## %else38
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm1, %xmm4, %xmm1
; AVX1-NEXT:    vpackssdw %xmm1, %xmm0, %xmm4
; AVX1-NEXT:    vpacksswb %xmm4, %xmm0, %xmm4
; AVX1-NEXT:    vpextrb $14, %xmm4, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB6_30
; AVX1-NEXT:  ## %bb.29: ## %cond.store40
; AVX1-NEXT:    vpextrd $2, %xmm0, (%rdi)
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB6_30: ## %else41
; AVX1-NEXT:    vpackssdw %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vpacksswb %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vpextrb $15, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB6_32
; AVX1-NEXT:  ## %bb.31: ## %cond.store43
; AVX1-NEXT:    vpextrd $3, %xmm0, (%rdi)
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB6_32: ## %else44
; AVX1-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpeqd %xmm0, %xmm6, %xmm1
; AVX1-NEXT:    vpackssdw %xmm0, %xmm1, %xmm1
; AVX1-NEXT:    vpacksswb %xmm0, %xmm1, %xmm1
; AVX1-NEXT:    vpextrb $0, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB6_34
; AVX1-NEXT:  ## %bb.33: ## %cond.store46
; AVX1-NEXT:    vmovss %xmm2, (%rdi)
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB6_34: ## %else47
; AVX1-NEXT:    vpcmpeqd %xmm0, %xmm6, %xmm0
; AVX1-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpextrb $1, %xmm0, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB6_36
; AVX1-NEXT:  ## %bb.35: ## %cond.store49
; AVX1-NEXT:    vextractps $1, %xmm2, (%rdi)
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB6_36: ## %else50
; AVX1-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpeqd %xmm0, %xmm6, %xmm1
; AVX1-NEXT:    vpackssdw %xmm0, %xmm1, %xmm1
; AVX1-NEXT:    vpacksswb %xmm0, %xmm1, %xmm1
; AVX1-NEXT:    vpextrb $2, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB6_38
; AVX1-NEXT:  ## %bb.37: ## %cond.store52
; AVX1-NEXT:    vextractps $2, %xmm2, (%rdi)
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB6_38: ## %else53
; AVX1-NEXT:    vpcmpeqd %xmm0, %xmm6, %xmm0
; AVX1-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpextrb $3, %xmm0, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB6_40
; AVX1-NEXT:  ## %bb.39: ## %cond.store55
; AVX1-NEXT:    vextractps $3, %xmm2, (%rdi)
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB6_40: ## %else56
; AVX1-NEXT:    vextractf128 $1, %ymm6, %xmm1
; AVX1-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpeqd %xmm0, %xmm1, %xmm4
; AVX1-NEXT:    vpackssdw %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpextrb $4, %xmm0, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm0
; AVX1-NEXT:    je LBB6_42
; AVX1-NEXT:  ## %bb.41: ## %cond.store58
; AVX1-NEXT:    vmovd %xmm0, (%rdi)
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB6_42: ## %else59
; AVX1-NEXT:    vpackssdw %xmm4, %xmm0, %xmm2
; AVX1-NEXT:    vpacksswb %xmm0, %xmm2, %xmm2
; AVX1-NEXT:    vpextrb $5, %xmm2, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB6_44
; AVX1-NEXT:  ## %bb.43: ## %cond.store61
; AVX1-NEXT:    vpextrd $1, %xmm0, (%rdi)
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB6_44: ## %else62
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpackssdw %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vpacksswb %xmm0, %xmm2, %xmm2
; AVX1-NEXT:    vpextrb $6, %xmm2, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB6_46
; AVX1-NEXT:  ## %bb.45: ## %cond.store64
; AVX1-NEXT:    vpextrd $2, %xmm0, (%rdi)
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB6_46: ## %else65
; AVX1-NEXT:    vpackssdw %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vpacksswb %xmm0, %xmm1, %xmm1
; AVX1-NEXT:    vpextrb $7, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB6_48
; AVX1-NEXT:  ## %bb.47: ## %cond.store67
; AVX1-NEXT:    vpextrd $3, %xmm0, (%rdi)
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB6_48: ## %else68
; AVX1-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpeqd %xmm0, %xmm7, %xmm1
; AVX1-NEXT:    vpackssdw %xmm0, %xmm1, %xmm1
; AVX1-NEXT:    vpacksswb %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vpextrb $8, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB6_50
; AVX1-NEXT:  ## %bb.49: ## %cond.store70
; AVX1-NEXT:    vmovss %xmm3, (%rdi)
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB6_50: ## %else71
; AVX1-NEXT:    vpcmpeqd %xmm0, %xmm7, %xmm0
; AVX1-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpextrb $9, %xmm0, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB6_52
; AVX1-NEXT:  ## %bb.51: ## %cond.store73
; AVX1-NEXT:    vextractps $1, %xmm3, (%rdi)
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB6_52: ## %else74
; AVX1-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpeqd %xmm0, %xmm7, %xmm1
; AVX1-NEXT:    vpackssdw %xmm0, %xmm1, %xmm1
; AVX1-NEXT:    vpacksswb %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vpextrb $10, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB6_54
; AVX1-NEXT:  ## %bb.53: ## %cond.store76
; AVX1-NEXT:    vextractps $2, %xmm3, (%rdi)
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB6_54: ## %else77
; AVX1-NEXT:    vpcmpeqd %xmm0, %xmm7, %xmm0
; AVX1-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpextrb $11, %xmm0, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB6_56
; AVX1-NEXT:  ## %bb.55: ## %cond.store79
; AVX1-NEXT:    vextractps $3, %xmm3, (%rdi)
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB6_56: ## %else80
; AVX1-NEXT:    vextractf128 $1, %ymm7, %xmm1
; AVX1-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpcmpeqd %xmm0, %xmm1, %xmm2
; AVX1-NEXT:    vpackssdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX1-NEXT:    vpextrb $12, %xmm0, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm0
; AVX1-NEXT:    je LBB6_58
; AVX1-NEXT:  ## %bb.57: ## %cond.store82
; AVX1-NEXT:    vmovd %xmm0, (%rdi)
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB6_58: ## %else83
; AVX1-NEXT:    vpackssdw %xmm2, %xmm0, %xmm2
; AVX1-NEXT:    vpacksswb %xmm2, %xmm0, %xmm2
; AVX1-NEXT:    vpextrb $13, %xmm2, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB6_60
; AVX1-NEXT:  ## %bb.59: ## %cond.store85
; AVX1-NEXT:    vpextrd $1, %xmm0, (%rdi)
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB6_60: ## %else86
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpackssdw %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vpacksswb %xmm2, %xmm0, %xmm2
; AVX1-NEXT:    vpextrb $14, %xmm2, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB6_62
; AVX1-NEXT:  ## %bb.61: ## %cond.store88
; AVX1-NEXT:    vpextrd $2, %xmm0, (%rdi)
; AVX1-NEXT:    addq $4, %rdi
; AVX1-NEXT:  LBB6_62: ## %else89
; AVX1-NEXT:    vpackssdw %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vpacksswb %xmm1, %xmm0, %xmm1
; AVX1-NEXT:    vpextrb $15, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB6_64
; AVX1-NEXT:  ## %bb.63: ## %cond.store91
; AVX1-NEXT:    vpextrd $3, %xmm0, (%rdi)
; AVX1-NEXT:  LBB6_64: ## %else92
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: compressstore_v32f32_v32i32:
; AVX2:       ## %bb.0:
; AVX2-NEXT:    vpxor %xmm8, %xmm8, %xmm8
; AVX2-NEXT:    vpcmpeqd %xmm8, %xmm4, %xmm9
; AVX2-NEXT:    vpackssdw %xmm0, %xmm9, %xmm9
; AVX2-NEXT:    vpacksswb %xmm0, %xmm9, %xmm9
; AVX2-NEXT:    vpextrb $0, %xmm9, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB6_2
; AVX2-NEXT:  ## %bb.1: ## %cond.store
; AVX2-NEXT:    vmovd %xmm0, (%rdi)
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB6_2: ## %else
; AVX2-NEXT:    vpcmpeqd %xmm8, %xmm4, %xmm8
; AVX2-NEXT:    vpackssdw %xmm0, %xmm8, %xmm8
; AVX2-NEXT:    vpacksswb %xmm0, %xmm8, %xmm8
; AVX2-NEXT:    vpextrb $1, %xmm8, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB6_4
; AVX2-NEXT:  ## %bb.3: ## %cond.store1
; AVX2-NEXT:    vpextrd $1, %xmm0, (%rdi)
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB6_4: ## %else2
; AVX2-NEXT:    vpxor %xmm8, %xmm8, %xmm8
; AVX2-NEXT:    vpcmpeqd %xmm8, %xmm4, %xmm9
; AVX2-NEXT:    vpackssdw %xmm0, %xmm9, %xmm9
; AVX2-NEXT:    vpacksswb %xmm0, %xmm9, %xmm9
; AVX2-NEXT:    vpextrb $2, %xmm9, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB6_6
; AVX2-NEXT:  ## %bb.5: ## %cond.store4
; AVX2-NEXT:    vpextrd $2, %xmm0, (%rdi)
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB6_6: ## %else5
; AVX2-NEXT:    vpcmpeqd %xmm8, %xmm4, %xmm8
; AVX2-NEXT:    vpackssdw %xmm0, %xmm8, %xmm8
; AVX2-NEXT:    vpacksswb %xmm0, %xmm8, %xmm8
; AVX2-NEXT:    vpextrb $3, %xmm8, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB6_8
; AVX2-NEXT:  ## %bb.7: ## %cond.store7
; AVX2-NEXT:    vpextrd $3, %xmm0, (%rdi)
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB6_8: ## %else8
; AVX2-NEXT:    vextracti128 $1, %ymm4, %xmm8
; AVX2-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vpcmpeqd %xmm4, %xmm8, %xmm9
; AVX2-NEXT:    vpackssdw %xmm9, %xmm0, %xmm4
; AVX2-NEXT:    vpacksswb %xmm0, %xmm4, %xmm4
; AVX2-NEXT:    vpextrb $4, %xmm4, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm10
; AVX2-NEXT:    je LBB6_10
; AVX2-NEXT:  ## %bb.9: ## %cond.store10
; AVX2-NEXT:    vmovd %xmm10, (%rdi)
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB6_10: ## %else11
; AVX2-NEXT:    vpackssdw %xmm9, %xmm0, %xmm4
; AVX2-NEXT:    vpacksswb %xmm0, %xmm4, %xmm4
; AVX2-NEXT:    vpextrb $5, %xmm4, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB6_12
; AVX2-NEXT:  ## %bb.11: ## %cond.store13
; AVX2-NEXT:    vpextrd $1, %xmm10, (%rdi)
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB6_12: ## %else14
; AVX2-NEXT:    vpxor %xmm4, %xmm4, %xmm4
; AVX2-NEXT:    vpcmpeqd %xmm4, %xmm8, %xmm4
; AVX2-NEXT:    vpackssdw %xmm4, %xmm0, %xmm0
; AVX2-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpextrb $6, %xmm0, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB6_14
; AVX2-NEXT:  ## %bb.13: ## %cond.store16
; AVX2-NEXT:    vpextrd $2, %xmm10, (%rdi)
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB6_14: ## %else17
; AVX2-NEXT:    vpackssdw %xmm4, %xmm0, %xmm0
; AVX2-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpextrb $7, %xmm0, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB6_16
; AVX2-NEXT:  ## %bb.15: ## %cond.store19
; AVX2-NEXT:    vpextrd $3, %xmm10, (%rdi)
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB6_16: ## %else20
; AVX2-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpcmpeqd %xmm0, %xmm5, %xmm4
; AVX2-NEXT:    vpackssdw %xmm0, %xmm4, %xmm4
; AVX2-NEXT:    vpacksswb %xmm4, %xmm0, %xmm4
; AVX2-NEXT:    vpextrb $8, %xmm4, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB6_18
; AVX2-NEXT:  ## %bb.17: ## %cond.store22
; AVX2-NEXT:    vmovd %xmm1, (%rdi)
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB6_18: ## %else23
; AVX2-NEXT:    vpcmpeqd %xmm0, %xmm5, %xmm0
; AVX2-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpextrb $9, %xmm0, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB6_20
; AVX2-NEXT:  ## %bb.19: ## %cond.store25
; AVX2-NEXT:    vpextrd $1, %xmm1, (%rdi)
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB6_20: ## %else26
; AVX2-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpcmpeqd %xmm0, %xmm5, %xmm4
; AVX2-NEXT:    vpackssdw %xmm0, %xmm4, %xmm4
; AVX2-NEXT:    vpacksswb %xmm4, %xmm0, %xmm4
; AVX2-NEXT:    vpextrb $10, %xmm4, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB6_22
; AVX2-NEXT:  ## %bb.21: ## %cond.store28
; AVX2-NEXT:    vpextrd $2, %xmm1, (%rdi)
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB6_22: ## %else29
; AVX2-NEXT:    vpcmpeqd %xmm0, %xmm5, %xmm0
; AVX2-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpextrb $11, %xmm0, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB6_24
; AVX2-NEXT:  ## %bb.23: ## %cond.store31
; AVX2-NEXT:    vpextrd $3, %xmm1, (%rdi)
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB6_24: ## %else32
; AVX2-NEXT:    vextracti128 $1, %ymm5, %xmm4
; AVX2-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpcmpeqd %xmm0, %xmm4, %xmm5
; AVX2-NEXT:    vpackssdw %xmm5, %xmm0, %xmm0
; AVX2-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpextrb $12, %xmm0, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm0
; AVX2-NEXT:    je LBB6_26
; AVX2-NEXT:  ## %bb.25: ## %cond.store34
; AVX2-NEXT:    vmovd %xmm0, (%rdi)
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB6_26: ## %else35
; AVX2-NEXT:    vpackssdw %xmm5, %xmm0, %xmm1
; AVX2-NEXT:    vpacksswb %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vpextrb $13, %xmm1, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB6_28
; AVX2-NEXT:  ## %bb.27: ## %cond.store37
; AVX2-NEXT:    vpextrd $1, %xmm0, (%rdi)
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB6_28: ## %else38
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpeqd %xmm1, %xmm4, %xmm1
; AVX2-NEXT:    vpackssdw %xmm1, %xmm0, %xmm4
; AVX2-NEXT:    vpacksswb %xmm4, %xmm0, %xmm4
; AVX2-NEXT:    vpextrb $14, %xmm4, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB6_30
; AVX2-NEXT:  ## %bb.29: ## %cond.store40
; AVX2-NEXT:    vpextrd $2, %xmm0, (%rdi)
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB6_30: ## %else41
; AVX2-NEXT:    vpackssdw %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vpacksswb %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vpextrb $15, %xmm1, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB6_32
; AVX2-NEXT:  ## %bb.31: ## %cond.store43
; AVX2-NEXT:    vpextrd $3, %xmm0, (%rdi)
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB6_32: ## %else44
; AVX2-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpcmpeqd %xmm0, %xmm6, %xmm1
; AVX2-NEXT:    vpackssdw %xmm0, %xmm1, %xmm1
; AVX2-NEXT:    vpacksswb %xmm0, %xmm1, %xmm1
; AVX2-NEXT:    vpextrb $0, %xmm1, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB6_34
; AVX2-NEXT:  ## %bb.33: ## %cond.store46
; AVX2-NEXT:    vmovd %xmm2, (%rdi)
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB6_34: ## %else47
; AVX2-NEXT:    vpcmpeqd %xmm0, %xmm6, %xmm0
; AVX2-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpextrb $1, %xmm0, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB6_36
; AVX2-NEXT:  ## %bb.35: ## %cond.store49
; AVX2-NEXT:    vpextrd $1, %xmm2, (%rdi)
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB6_36: ## %else50
; AVX2-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpcmpeqd %xmm0, %xmm6, %xmm1
; AVX2-NEXT:    vpackssdw %xmm0, %xmm1, %xmm1
; AVX2-NEXT:    vpacksswb %xmm0, %xmm1, %xmm1
; AVX2-NEXT:    vpextrb $2, %xmm1, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB6_38
; AVX2-NEXT:  ## %bb.37: ## %cond.store52
; AVX2-NEXT:    vpextrd $2, %xmm2, (%rdi)
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB6_38: ## %else53
; AVX2-NEXT:    vpcmpeqd %xmm0, %xmm6, %xmm0
; AVX2-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpextrb $3, %xmm0, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB6_40
; AVX2-NEXT:  ## %bb.39: ## %cond.store55
; AVX2-NEXT:    vpextrd $3, %xmm2, (%rdi)
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB6_40: ## %else56
; AVX2-NEXT:    vextracti128 $1, %ymm6, %xmm1
; AVX2-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpcmpeqd %xmm0, %xmm1, %xmm4
; AVX2-NEXT:    vpackssdw %xmm4, %xmm0, %xmm0
; AVX2-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpextrb $4, %xmm0, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    vextracti128 $1, %ymm2, %xmm0
; AVX2-NEXT:    je LBB6_42
; AVX2-NEXT:  ## %bb.41: ## %cond.store58
; AVX2-NEXT:    vmovd %xmm0, (%rdi)
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB6_42: ## %else59
; AVX2-NEXT:    vpackssdw %xmm4, %xmm0, %xmm2
; AVX2-NEXT:    vpacksswb %xmm0, %xmm2, %xmm2
; AVX2-NEXT:    vpextrb $5, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB6_44
; AVX2-NEXT:  ## %bb.43: ## %cond.store61
; AVX2-NEXT:    vpextrd $1, %xmm0, (%rdi)
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB6_44: ## %else62
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpackssdw %xmm1, %xmm0, %xmm2
; AVX2-NEXT:    vpacksswb %xmm0, %xmm2, %xmm2
; AVX2-NEXT:    vpextrb $6, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB6_46
; AVX2-NEXT:  ## %bb.45: ## %cond.store64
; AVX2-NEXT:    vpextrd $2, %xmm0, (%rdi)
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB6_46: ## %else65
; AVX2-NEXT:    vpackssdw %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vpacksswb %xmm0, %xmm1, %xmm1
; AVX2-NEXT:    vpextrb $7, %xmm1, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB6_48
; AVX2-NEXT:  ## %bb.47: ## %cond.store67
; AVX2-NEXT:    vpextrd $3, %xmm0, (%rdi)
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB6_48: ## %else68
; AVX2-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpcmpeqd %xmm0, %xmm7, %xmm1
; AVX2-NEXT:    vpackssdw %xmm0, %xmm1, %xmm1
; AVX2-NEXT:    vpacksswb %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vpextrb $8, %xmm1, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB6_50
; AVX2-NEXT:  ## %bb.49: ## %cond.store70
; AVX2-NEXT:    vmovd %xmm3, (%rdi)
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB6_50: ## %else71
; AVX2-NEXT:    vpcmpeqd %xmm0, %xmm7, %xmm0
; AVX2-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpextrb $9, %xmm0, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB6_52
; AVX2-NEXT:  ## %bb.51: ## %cond.store73
; AVX2-NEXT:    vpextrd $1, %xmm3, (%rdi)
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB6_52: ## %else74
; AVX2-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpcmpeqd %xmm0, %xmm7, %xmm1
; AVX2-NEXT:    vpackssdw %xmm0, %xmm1, %xmm1
; AVX2-NEXT:    vpacksswb %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vpextrb $10, %xmm1, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB6_54
; AVX2-NEXT:  ## %bb.53: ## %cond.store76
; AVX2-NEXT:    vpextrd $2, %xmm3, (%rdi)
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB6_54: ## %else77
; AVX2-NEXT:    vpcmpeqd %xmm0, %xmm7, %xmm0
; AVX2-NEXT:    vpackssdw %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpextrb $11, %xmm0, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB6_56
; AVX2-NEXT:  ## %bb.55: ## %cond.store79
; AVX2-NEXT:    vpextrd $3, %xmm3, (%rdi)
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB6_56: ## %else80
; AVX2-NEXT:    vextracti128 $1, %ymm7, %xmm1
; AVX2-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpcmpeqd %xmm0, %xmm1, %xmm2
; AVX2-NEXT:    vpackssdw %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX2-NEXT:    vpextrb $12, %xmm0, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    vextracti128 $1, %ymm3, %xmm0
; AVX2-NEXT:    je LBB6_58
; AVX2-NEXT:  ## %bb.57: ## %cond.store82
; AVX2-NEXT:    vmovd %xmm0, (%rdi)
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB6_58: ## %else83
; AVX2-NEXT:    vpackssdw %xmm2, %xmm0, %xmm2
; AVX2-NEXT:    vpacksswb %xmm2, %xmm0, %xmm2
; AVX2-NEXT:    vpextrb $13, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB6_60
; AVX2-NEXT:  ## %bb.59: ## %cond.store85
; AVX2-NEXT:    vpextrd $1, %xmm0, (%rdi)
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB6_60: ## %else86
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vpackssdw %xmm1, %xmm0, %xmm2
; AVX2-NEXT:    vpacksswb %xmm2, %xmm0, %xmm2
; AVX2-NEXT:    vpextrb $14, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB6_62
; AVX2-NEXT:  ## %bb.61: ## %cond.store88
; AVX2-NEXT:    vpextrd $2, %xmm0, (%rdi)
; AVX2-NEXT:    addq $4, %rdi
; AVX2-NEXT:  LBB6_62: ## %else89
; AVX2-NEXT:    vpackssdw %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vpacksswb %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vpextrb $15, %xmm1, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB6_64
; AVX2-NEXT:  ## %bb.63: ## %cond.store91
; AVX2-NEXT:    vpextrd $3, %xmm0, (%rdi)
; AVX2-NEXT:  LBB6_64: ## %else92
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: compressstore_v32f32_v32i32:
; AVX512:       ## %bb.0:
; AVX512-NEXT:    vptestnmd %zmm3, %zmm3, %k1
; AVX512-NEXT:    vptestnmd %zmm2, %zmm2, %k2
; AVX512-NEXT:    kmovw %k2, %eax
; AVX512-NEXT:    movl %eax, %ecx
; AVX512-NEXT:    shrl %ecx
; AVX512-NEXT:    andl $21845, %ecx ## imm = 0x5555
; AVX512-NEXT:    subl %ecx, %eax
; AVX512-NEXT:    movl %eax, %ecx
; AVX512-NEXT:    andl $858993459, %ecx ## imm = 0x33333333
; AVX512-NEXT:    shrl $2, %eax
; AVX512-NEXT:    andl $858993459, %eax ## imm = 0x33333333
; AVX512-NEXT:    addl %ecx, %eax
; AVX512-NEXT:    movl %eax, %ecx
; AVX512-NEXT:    shrl $4, %ecx
; AVX512-NEXT:    addl %eax, %ecx
; AVX512-NEXT:    andl $252645135, %ecx ## imm = 0xF0F0F0F
; AVX512-NEXT:    imull $16843009, %ecx, %eax ## imm = 0x1010101
; AVX512-NEXT:    shrl $24, %eax
; AVX512-NEXT:    vcompressps %zmm1, (%rdi,%rax,4) {%k1}
; AVX512-NEXT:    vcompressps %zmm0, (%rdi) {%k2}
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %mask = icmp eq <32 x i32> %trigger, zeroinitializer
  call void @llvm.masked.compressstore.v32f32(<32 x float> %V, float* %base, <32 x i1> %mask)
  ret void
}

;
; vXi64
;

define void @compressstore_v2i64_v2i1(i64* %base, <2 x i64> %V, <2 x i1> %mask) {
; SSE2-LABEL: compressstore_v2i64_v2i1:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    movd %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB7_2
; SSE2-NEXT:  ## %bb.1: ## %cond.store
; SSE2-NEXT:    movq %xmm0, (%rdi)
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB7_2: ## %else
; SSE2-NEXT:    pextrw $4, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB7_4
; SSE2-NEXT:  ## %bb.3: ## %cond.store1
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,0,1]
; SSE2-NEXT:    movq %xmm0, (%rdi)
; SSE2-NEXT:  LBB7_4: ## %else2
; SSE2-NEXT:    retq
;
; SSE42-LABEL: compressstore_v2i64_v2i1:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    pextrb $0, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB7_2
; SSE42-NEXT:  ## %bb.1: ## %cond.store
; SSE42-NEXT:    movq %xmm0, (%rdi)
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB7_2: ## %else
; SSE42-NEXT:    pextrb $8, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB7_4
; SSE42-NEXT:  ## %bb.3: ## %cond.store1
; SSE42-NEXT:    pextrq $1, %xmm0, (%rdi)
; SSE42-NEXT:  LBB7_4: ## %else2
; SSE42-NEXT:    retq
;
; AVX1OR2-LABEL: compressstore_v2i64_v2i1:
; AVX1OR2:       ## %bb.0:
; AVX1OR2-NEXT:    vpextrb $0, %xmm1, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB7_2
; AVX1OR2-NEXT:  ## %bb.1: ## %cond.store
; AVX1OR2-NEXT:    vmovq %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $8, %rdi
; AVX1OR2-NEXT:  LBB7_2: ## %else
; AVX1OR2-NEXT:    vpextrb $8, %xmm1, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB7_4
; AVX1OR2-NEXT:  ## %bb.3: ## %cond.store1
; AVX1OR2-NEXT:    vpextrq $1, %xmm0, (%rdi)
; AVX1OR2-NEXT:  LBB7_4: ## %else2
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: compressstore_v2i64_v2i1:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vpsllq $63, %xmm1, %xmm1
; AVX512F-NEXT:    vptestmq %zmm1, %zmm1, %k0
; AVX512F-NEXT:    kshiftlw $14, %k0, %k0
; AVX512F-NEXT:    kshiftrw $14, %k0, %k1
; AVX512F-NEXT:    vpcompressq %zmm0, (%rdi) {%k1}
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLDQ-LABEL: compressstore_v2i64_v2i1:
; AVX512VLDQ:       ## %bb.0:
; AVX512VLDQ-NEXT:    vpsllq $63, %xmm1, %xmm1
; AVX512VLDQ-NEXT:    vpmovq2m %xmm1, %k1
; AVX512VLDQ-NEXT:    vpcompressq %xmm0, (%rdi) {%k1}
; AVX512VLDQ-NEXT:    retq
;
; AVX512VLBW-LABEL: compressstore_v2i64_v2i1:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vpsllq $63, %xmm1, %xmm1
; AVX512VLBW-NEXT:    vptestmq %xmm1, %xmm1, %k1
; AVX512VLBW-NEXT:    vpcompressq %xmm0, (%rdi) {%k1}
; AVX512VLBW-NEXT:    retq
  call void @llvm.masked.compressstore.v2i64(<2 x i64> %V, i64* %base, <2 x i1> %mask)
  ret void
}

define void @compressstore_v4i64_v4i1(i64* %base, <4 x i64> %V, <4 x i1> %mask) {
; SSE2-LABEL: compressstore_v4i64_v4i1:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    movd %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB8_2
; SSE2-NEXT:  ## %bb.1: ## %cond.store
; SSE2-NEXT:    movq %xmm0, (%rdi)
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB8_2: ## %else
; SSE2-NEXT:    pextrw $2, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB8_4
; SSE2-NEXT:  ## %bb.3: ## %cond.store1
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,0,1]
; SSE2-NEXT:    movq %xmm0, (%rdi)
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB8_4: ## %else2
; SSE2-NEXT:    pextrw $4, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB8_6
; SSE2-NEXT:  ## %bb.5: ## %cond.store4
; SSE2-NEXT:    movq %xmm1, (%rdi)
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB8_6: ## %else5
; SSE2-NEXT:    pextrw $6, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB8_8
; SSE2-NEXT:  ## %bb.7: ## %cond.store7
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,3,0,1]
; SSE2-NEXT:    movq %xmm0, (%rdi)
; SSE2-NEXT:  LBB8_8: ## %else8
; SSE2-NEXT:    retq
;
; SSE42-LABEL: compressstore_v4i64_v4i1:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    pextrb $0, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB8_2
; SSE42-NEXT:  ## %bb.1: ## %cond.store
; SSE42-NEXT:    movq %xmm0, (%rdi)
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB8_2: ## %else
; SSE42-NEXT:    pextrb $4, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB8_4
; SSE42-NEXT:  ## %bb.3: ## %cond.store1
; SSE42-NEXT:    pextrq $1, %xmm0, (%rdi)
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB8_4: ## %else2
; SSE42-NEXT:    pextrb $8, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB8_6
; SSE42-NEXT:  ## %bb.5: ## %cond.store4
; SSE42-NEXT:    movq %xmm1, (%rdi)
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB8_6: ## %else5
; SSE42-NEXT:    pextrb $12, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB8_8
; SSE42-NEXT:  ## %bb.7: ## %cond.store7
; SSE42-NEXT:    pextrq $1, %xmm1, (%rdi)
; SSE42-NEXT:  LBB8_8: ## %else8
; SSE42-NEXT:    retq
;
; AVX1-LABEL: compressstore_v4i64_v4i1:
; AVX1:       ## %bb.0:
; AVX1-NEXT:    vpextrb $0, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_2
; AVX1-NEXT:  ## %bb.1: ## %cond.store
; AVX1-NEXT:    vmovq %xmm0, (%rdi)
; AVX1-NEXT:    addq $8, %rdi
; AVX1-NEXT:  LBB8_2: ## %else
; AVX1-NEXT:    vpextrb $4, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_4
; AVX1-NEXT:  ## %bb.3: ## %cond.store1
; AVX1-NEXT:    vpextrq $1, %xmm0, (%rdi)
; AVX1-NEXT:    addq $8, %rdi
; AVX1-NEXT:  LBB8_4: ## %else2
; AVX1-NEXT:    vpextrb $8, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    je LBB8_6
; AVX1-NEXT:  ## %bb.5: ## %cond.store4
; AVX1-NEXT:    vmovq %xmm0, (%rdi)
; AVX1-NEXT:    addq $8, %rdi
; AVX1-NEXT:  LBB8_6: ## %else5
; AVX1-NEXT:    vpextrb $12, %xmm1, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB8_8
; AVX1-NEXT:  ## %bb.7: ## %cond.store7
; AVX1-NEXT:    vpextrq $1, %xmm0, (%rdi)
; AVX1-NEXT:  LBB8_8: ## %else8
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: compressstore_v4i64_v4i1:
; AVX2:       ## %bb.0:
; AVX2-NEXT:    vpextrb $0, %xmm1, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_2
; AVX2-NEXT:  ## %bb.1: ## %cond.store
; AVX2-NEXT:    vmovq %xmm0, (%rdi)
; AVX2-NEXT:    addq $8, %rdi
; AVX2-NEXT:  LBB8_2: ## %else
; AVX2-NEXT:    vpextrb $4, %xmm1, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_4
; AVX2-NEXT:  ## %bb.3: ## %cond.store1
; AVX2-NEXT:    vpextrq $1, %xmm0, (%rdi)
; AVX2-NEXT:    addq $8, %rdi
; AVX2-NEXT:  LBB8_4: ## %else2
; AVX2-NEXT:    vpextrb $8, %xmm1, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-NEXT:    je LBB8_6
; AVX2-NEXT:  ## %bb.5: ## %cond.store4
; AVX2-NEXT:    vmovq %xmm0, (%rdi)
; AVX2-NEXT:    addq $8, %rdi
; AVX2-NEXT:  LBB8_6: ## %else5
; AVX2-NEXT:    vpextrb $12, %xmm1, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB8_8
; AVX2-NEXT:  ## %bb.7: ## %cond.store7
; AVX2-NEXT:    vpextrq $1, %xmm0, (%rdi)
; AVX2-NEXT:  LBB8_8: ## %else8
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: compressstore_v4i64_v4i1:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX512F-NEXT:    vptestmd %zmm1, %zmm1, %k0
; AVX512F-NEXT:    kshiftlw $12, %k0, %k0
; AVX512F-NEXT:    kshiftrw $12, %k0, %k1
; AVX512F-NEXT:    vpcompressq %zmm0, (%rdi) {%k1}
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLDQ-LABEL: compressstore_v4i64_v4i1:
; AVX512VLDQ:       ## %bb.0:
; AVX512VLDQ-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX512VLDQ-NEXT:    vpmovd2m %xmm1, %k1
; AVX512VLDQ-NEXT:    vpcompressq %ymm0, (%rdi) {%k1}
; AVX512VLDQ-NEXT:    vzeroupper
; AVX512VLDQ-NEXT:    retq
;
; AVX512VLBW-LABEL: compressstore_v4i64_v4i1:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX512VLBW-NEXT:    vptestmd %xmm1, %xmm1, %k1
; AVX512VLBW-NEXT:    vpcompressq %ymm0, (%rdi) {%k1}
; AVX512VLBW-NEXT:    vzeroupper
; AVX512VLBW-NEXT:    retq
  call void @llvm.masked.compressstore.v4i64(<4 x i64> %V, i64* %base, <4 x i1> %mask)
  ret void
}

define void @compressstore_v8i64_v8i1(i64* %base, <8 x i64> %V, <8 x i1> %mask) {
; SSE2-LABEL: compressstore_v8i64_v8i1:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    movd %xmm4, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB9_2
; SSE2-NEXT:  ## %bb.1: ## %cond.store
; SSE2-NEXT:    movq %xmm0, (%rdi)
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB9_2: ## %else
; SSE2-NEXT:    shrl $16, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB9_4
; SSE2-NEXT:  ## %bb.3: ## %cond.store1
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,3,0,1]
; SSE2-NEXT:    movq %xmm0, (%rdi)
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB9_4: ## %else2
; SSE2-NEXT:    pextrw $2, %xmm4, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB9_6
; SSE2-NEXT:  ## %bb.5: ## %cond.store4
; SSE2-NEXT:    movq %xmm1, (%rdi)
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB9_6: ## %else5
; SSE2-NEXT:    pextrw $3, %xmm4, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB9_8
; SSE2-NEXT:  ## %bb.7: ## %cond.store7
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[2,3,0,1]
; SSE2-NEXT:    movq %xmm0, (%rdi)
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB9_8: ## %else8
; SSE2-NEXT:    pextrw $4, %xmm4, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB9_10
; SSE2-NEXT:  ## %bb.9: ## %cond.store10
; SSE2-NEXT:    movq %xmm2, (%rdi)
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB9_10: ## %else11
; SSE2-NEXT:    pextrw $5, %xmm4, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB9_12
; SSE2-NEXT:  ## %bb.11: ## %cond.store13
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[2,3,0,1]
; SSE2-NEXT:    movq %xmm0, (%rdi)
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB9_12: ## %else14
; SSE2-NEXT:    pextrw $6, %xmm4, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB9_14
; SSE2-NEXT:  ## %bb.13: ## %cond.store16
; SSE2-NEXT:    movq %xmm3, (%rdi)
; SSE2-NEXT:    addq $8, %rdi
; SSE2-NEXT:  LBB9_14: ## %else17
; SSE2-NEXT:    pextrw $7, %xmm4, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB9_16
; SSE2-NEXT:  ## %bb.15: ## %cond.store19
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm3[2,3,0,1]
; SSE2-NEXT:    movq %xmm0, (%rdi)
; SSE2-NEXT:  LBB9_16: ## %else20
; SSE2-NEXT:    retq
;
; SSE42-LABEL: compressstore_v8i64_v8i1:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    pextrb $0, %xmm4, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB9_2
; SSE42-NEXT:  ## %bb.1: ## %cond.store
; SSE42-NEXT:    movq %xmm0, (%rdi)
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB9_2: ## %else
; SSE42-NEXT:    pextrb $2, %xmm4, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB9_4
; SSE42-NEXT:  ## %bb.3: ## %cond.store1
; SSE42-NEXT:    pextrq $1, %xmm0, (%rdi)
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB9_4: ## %else2
; SSE42-NEXT:    pextrb $4, %xmm4, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB9_6
; SSE42-NEXT:  ## %bb.5: ## %cond.store4
; SSE42-NEXT:    movq %xmm1, (%rdi)
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB9_6: ## %else5
; SSE42-NEXT:    pextrb $6, %xmm4, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB9_8
; SSE42-NEXT:  ## %bb.7: ## %cond.store7
; SSE42-NEXT:    pextrq $1, %xmm1, (%rdi)
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB9_8: ## %else8
; SSE42-NEXT:    pextrb $8, %xmm4, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB9_10
; SSE42-NEXT:  ## %bb.9: ## %cond.store10
; SSE42-NEXT:    movq %xmm2, (%rdi)
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB9_10: ## %else11
; SSE42-NEXT:    pextrb $10, %xmm4, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB9_12
; SSE42-NEXT:  ## %bb.11: ## %cond.store13
; SSE42-NEXT:    pextrq $1, %xmm2, (%rdi)
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB9_12: ## %else14
; SSE42-NEXT:    pextrb $12, %xmm4, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB9_14
; SSE42-NEXT:  ## %bb.13: ## %cond.store16
; SSE42-NEXT:    movq %xmm3, (%rdi)
; SSE42-NEXT:    addq $8, %rdi
; SSE42-NEXT:  LBB9_14: ## %else17
; SSE42-NEXT:    pextrb $14, %xmm4, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB9_16
; SSE42-NEXT:  ## %bb.15: ## %cond.store19
; SSE42-NEXT:    pextrq $1, %xmm3, (%rdi)
; SSE42-NEXT:  LBB9_16: ## %else20
; SSE42-NEXT:    retq
;
; AVX1-LABEL: compressstore_v8i64_v8i1:
; AVX1:       ## %bb.0:
; AVX1-NEXT:    vpextrb $0, %xmm2, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB9_2
; AVX1-NEXT:  ## %bb.1: ## %cond.store
; AVX1-NEXT:    vmovq %xmm0, (%rdi)
; AVX1-NEXT:    addq $8, %rdi
; AVX1-NEXT:  LBB9_2: ## %else
; AVX1-NEXT:    vpextrb $2, %xmm2, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB9_4
; AVX1-NEXT:  ## %bb.3: ## %cond.store1
; AVX1-NEXT:    vpextrq $1, %xmm0, (%rdi)
; AVX1-NEXT:    addq $8, %rdi
; AVX1-NEXT:  LBB9_4: ## %else2
; AVX1-NEXT:    vpextrb $4, %xmm2, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    je LBB9_6
; AVX1-NEXT:  ## %bb.5: ## %cond.store4
; AVX1-NEXT:    vmovq %xmm0, (%rdi)
; AVX1-NEXT:    addq $8, %rdi
; AVX1-NEXT:  LBB9_6: ## %else5
; AVX1-NEXT:    vpextrb $6, %xmm2, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB9_8
; AVX1-NEXT:  ## %bb.7: ## %cond.store7
; AVX1-NEXT:    vpextrq $1, %xmm0, (%rdi)
; AVX1-NEXT:    addq $8, %rdi
; AVX1-NEXT:  LBB9_8: ## %else8
; AVX1-NEXT:    vpextrb $8, %xmm2, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB9_10
; AVX1-NEXT:  ## %bb.9: ## %cond.store10
; AVX1-NEXT:    vmovq %xmm1, (%rdi)
; AVX1-NEXT:    addq $8, %rdi
; AVX1-NEXT:  LBB9_10: ## %else11
; AVX1-NEXT:    vpextrb $10, %xmm2, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB9_12
; AVX1-NEXT:  ## %bb.11: ## %cond.store13
; AVX1-NEXT:    vpextrq $1, %xmm1, (%rdi)
; AVX1-NEXT:    addq $8, %rdi
; AVX1-NEXT:  LBB9_12: ## %else14
; AVX1-NEXT:    vpextrb $12, %xmm2, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm0
; AVX1-NEXT:    je LBB9_14
; AVX1-NEXT:  ## %bb.13: ## %cond.store16
; AVX1-NEXT:    vmovq %xmm0, (%rdi)
; AVX1-NEXT:    addq $8, %rdi
; AVX1-NEXT:  LBB9_14: ## %else17
; AVX1-NEXT:    vpextrb $14, %xmm2, %eax
; AVX1-NEXT:    testb $1, %al
; AVX1-NEXT:    je LBB9_16
; AVX1-NEXT:  ## %bb.15: ## %cond.store19
; AVX1-NEXT:    vpextrq $1, %xmm0, (%rdi)
; AVX1-NEXT:  LBB9_16: ## %else20
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: compressstore_v8i64_v8i1:
; AVX2:       ## %bb.0:
; AVX2-NEXT:    vpextrb $0, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB9_2
; AVX2-NEXT:  ## %bb.1: ## %cond.store
; AVX2-NEXT:    vmovq %xmm0, (%rdi)
; AVX2-NEXT:    addq $8, %rdi
; AVX2-NEXT:  LBB9_2: ## %else
; AVX2-NEXT:    vpextrb $2, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB9_4
; AVX2-NEXT:  ## %bb.3: ## %cond.store1
; AVX2-NEXT:    vpextrq $1, %xmm0, (%rdi)
; AVX2-NEXT:    addq $8, %rdi
; AVX2-NEXT:  LBB9_4: ## %else2
; AVX2-NEXT:    vpextrb $4, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm0
; AVX2-NEXT:    je LBB9_6
; AVX2-NEXT:  ## %bb.5: ## %cond.store4
; AVX2-NEXT:    vmovq %xmm0, (%rdi)
; AVX2-NEXT:    addq $8, %rdi
; AVX2-NEXT:  LBB9_6: ## %else5
; AVX2-NEXT:    vpextrb $6, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB9_8
; AVX2-NEXT:  ## %bb.7: ## %cond.store7
; AVX2-NEXT:    vpextrq $1, %xmm0, (%rdi)
; AVX2-NEXT:    addq $8, %rdi
; AVX2-NEXT:  LBB9_8: ## %else8
; AVX2-NEXT:    vpextrb $8, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB9_10
; AVX2-NEXT:  ## %bb.9: ## %cond.store10
; AVX2-NEXT:    vmovq %xmm1, (%rdi)
; AVX2-NEXT:    addq $8, %rdi
; AVX2-NEXT:  LBB9_10: ## %else11
; AVX2-NEXT:    vpextrb $10, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB9_12
; AVX2-NEXT:  ## %bb.11: ## %cond.store13
; AVX2-NEXT:    vpextrq $1, %xmm1, (%rdi)
; AVX2-NEXT:    addq $8, %rdi
; AVX2-NEXT:  LBB9_12: ## %else14
; AVX2-NEXT:    vpextrb $12, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    vextracti128 $1, %ymm1, %xmm0
; AVX2-NEXT:    je LBB9_14
; AVX2-NEXT:  ## %bb.13: ## %cond.store16
; AVX2-NEXT:    vmovq %xmm0, (%rdi)
; AVX2-NEXT:    addq $8, %rdi
; AVX2-NEXT:  LBB9_14: ## %else17
; AVX2-NEXT:    vpextrb $14, %xmm2, %eax
; AVX2-NEXT:    testb $1, %al
; AVX2-NEXT:    je LBB9_16
; AVX2-NEXT:  ## %bb.15: ## %cond.store19
; AVX2-NEXT:    vpextrq $1, %xmm0, (%rdi)
; AVX2-NEXT:  LBB9_16: ## %else20
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: compressstore_v8i64_v8i1:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    vpmovsxwq %xmm1, %zmm1
; AVX512F-NEXT:    vpsllq $63, %zmm1, %zmm1
; AVX512F-NEXT:    vptestmq %zmm1, %zmm1, %k1
; AVX512F-NEXT:    vpcompressq %zmm0, (%rdi) {%k1}
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLDQ-LABEL: compressstore_v8i64_v8i1:
; AVX512VLDQ:       ## %bb.0:
; AVX512VLDQ-NEXT:    vpmovsxwd %xmm1, %ymm1
; AVX512VLDQ-NEXT:    vpslld $31, %ymm1, %ymm1
; AVX512VLDQ-NEXT:    vpmovd2m %ymm1, %k1
; AVX512VLDQ-NEXT:    vpcompressq %zmm0, (%rdi) {%k1}
; AVX512VLDQ-NEXT:    vzeroupper
; AVX512VLDQ-NEXT:    retq
;
; AVX512VLBW-LABEL: compressstore_v8i64_v8i1:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vpsllw $15, %xmm1, %xmm1
; AVX512VLBW-NEXT:    vpmovw2m %xmm1, %k1
; AVX512VLBW-NEXT:    vpcompressq %zmm0, (%rdi) {%k1}
; AVX512VLBW-NEXT:    vzeroupper
; AVX512VLBW-NEXT:    retq
  call void @llvm.masked.compressstore.v8i64(<8 x i64> %V, i64* %base, <8 x i1> %mask)
  ret void
}

;
; vXi32
;

define void @compressstore_v4i32_v4i32(i32* %base, <4 x i32> %V, <4 x i32> %trigger) {
; SSE2-LABEL: compressstore_v4i32_v4i32:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm2
; SSE2-NEXT:    movd %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB10_2
; SSE2-NEXT:  ## %bb.1: ## %cond.store
; SSE2-NEXT:    movd %xmm0, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB10_2: ## %else
; SSE2-NEXT:    pextrw $2, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB10_4
; SSE2-NEXT:  ## %bb.3: ## %cond.store1
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[1,1,2,3]
; SSE2-NEXT:    movd %xmm2, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB10_4: ## %else2
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm1
; SSE2-NEXT:    pextrw $4, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB10_6
; SSE2-NEXT:  ## %bb.5: ## %cond.store4
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[2,3,0,1]
; SSE2-NEXT:    movd %xmm2, (%rdi)
; SSE2-NEXT:    addq $4, %rdi
; SSE2-NEXT:  LBB10_6: ## %else5
; SSE2-NEXT:    pextrw $6, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB10_8
; SSE2-NEXT:  ## %bb.7: ## %cond.store7
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,1,2,3]
; SSE2-NEXT:    movd %xmm0, (%rdi)
; SSE2-NEXT:  LBB10_8: ## %else8
; SSE2-NEXT:    retq
;
; SSE42-LABEL: compressstore_v4i32_v4i32:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqd %xmm1, %xmm2
; SSE42-NEXT:    pextrb $0, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB10_2
; SSE42-NEXT:  ## %bb.1: ## %cond.store
; SSE42-NEXT:    movss %xmm0, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB10_2: ## %else
; SSE42-NEXT:    pextrb $4, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB10_4
; SSE42-NEXT:  ## %bb.3: ## %cond.store1
; SSE42-NEXT:    extractps $1, %xmm0, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB10_4: ## %else2
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqd %xmm2, %xmm1
; SSE42-NEXT:    pextrb $8, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB10_6
; SSE42-NEXT:  ## %bb.5: ## %cond.store4
; SSE42-NEXT:    extractps $2, %xmm0, (%rdi)
; SSE42-NEXT:    addq $4, %rdi
; SSE42-NEXT:  LBB10_6: ## %else5
; SSE42-NEXT:    pextrb $12, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB10_8
; SSE42-NEXT:  ## %bb.7: ## %cond.store7
; SSE42-NEXT:    extractps $3, %xmm0, (%rdi)
; SSE42-NEXT:  LBB10_8: ## %else8
; SSE42-NEXT:    retq
;
; AVX1OR2-LABEL: compressstore_v4i32_v4i32:
; AVX1OR2:       ## %bb.0:
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqd %xmm2, %xmm1, %xmm2
; AVX1OR2-NEXT:    vpextrb $0, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB10_2
; AVX1OR2-NEXT:  ## %bb.1: ## %cond.store
; AVX1OR2-NEXT:    vmovss %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $4, %rdi
; AVX1OR2-NEXT:  LBB10_2: ## %else
; AVX1OR2-NEXT:    vpextrb $4, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB10_4
; AVX1OR2-NEXT:  ## %bb.3: ## %cond.store1
; AVX1OR2-NEXT:    vextractps $1, %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $4, %rdi
; AVX1OR2-NEXT:  LBB10_4: ## %else2
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqd %xmm2, %xmm1, %xmm1
; AVX1OR2-NEXT:    vpextrb $8, %xmm1, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB10_6
; AVX1OR2-NEXT:  ## %bb.5: ## %cond.store4
; AVX1OR2-NEXT:    vextractps $2, %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $4, %rdi
; AVX1OR2-NEXT:  LBB10_6: ## %else5
; AVX1OR2-NEXT:    vpextrb $12, %xmm1, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB10_8
; AVX1OR2-NEXT:  ## %bb.7: ## %cond.store7
; AVX1OR2-NEXT:    vextractps $3, %xmm0, (%rdi)
; AVX1OR2-NEXT:  LBB10_8: ## %else8
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: compressstore_v4i32_v4i32:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vptestnmd %zmm1, %zmm1, %k0
; AVX512F-NEXT:    kshiftlw $12, %k0, %k0
; AVX512F-NEXT:    kshiftrw $12, %k0, %k1
; AVX512F-NEXT:    vpcompressd %zmm0, (%rdi) {%k1}
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: compressstore_v4i32_v4i32:
; AVX512VL:       ## %bb.0:
; AVX512VL-NEXT:    vptestnmd %xmm1, %xmm1, %k1
; AVX512VL-NEXT:    vpcompressd %xmm0, (%rdi) {%k1}
; AVX512VL-NEXT:    retq
  %mask = icmp eq <4 x i32> %trigger, zeroinitializer
  call void @llvm.masked.compressstore.v4i32(<4 x i32> %V, i32* %base, <4 x i1> %mask)
  ret void
}

;
; vXi16
;

define void @compressstore_v8i16_v8i16(i16* %base, <8 x i16> %V, <8 x i16> %trigger) {
; SSE2-LABEL: compressstore_v8i16_v8i16:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqw %xmm1, %xmm2
; SSE2-NEXT:    movd %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB11_2
; SSE2-NEXT:  ## %bb.1: ## %cond.store
; SSE2-NEXT:    movd %xmm0, %ecx
; SSE2-NEXT:    movw %cx, (%rdi)
; SSE2-NEXT:    addq $2, %rdi
; SSE2-NEXT:  LBB11_2: ## %else
; SSE2-NEXT:    shrl $16, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB11_4
; SSE2-NEXT:  ## %bb.3: ## %cond.store1
; SSE2-NEXT:    pextrw $1, %xmm0, %eax
; SSE2-NEXT:    movw %ax, (%rdi)
; SSE2-NEXT:    addq $2, %rdi
; SSE2-NEXT:  LBB11_4: ## %else2
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqw %xmm1, %xmm2
; SSE2-NEXT:    pextrw $2, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB11_6
; SSE2-NEXT:  ## %bb.5: ## %cond.store4
; SSE2-NEXT:    pextrw $2, %xmm0, %eax
; SSE2-NEXT:    movw %ax, (%rdi)
; SSE2-NEXT:    addq $2, %rdi
; SSE2-NEXT:  LBB11_6: ## %else5
; SSE2-NEXT:    pextrw $3, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB11_8
; SSE2-NEXT:  ## %bb.7: ## %cond.store7
; SSE2-NEXT:    pextrw $3, %xmm0, %eax
; SSE2-NEXT:    movw %ax, (%rdi)
; SSE2-NEXT:    addq $2, %rdi
; SSE2-NEXT:  LBB11_8: ## %else8
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqw %xmm1, %xmm2
; SSE2-NEXT:    pextrw $4, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB11_10
; SSE2-NEXT:  ## %bb.9: ## %cond.store10
; SSE2-NEXT:    pextrw $4, %xmm0, %eax
; SSE2-NEXT:    movw %ax, (%rdi)
; SSE2-NEXT:    addq $2, %rdi
; SSE2-NEXT:  LBB11_10: ## %else11
; SSE2-NEXT:    pextrw $5, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB11_12
; SSE2-NEXT:  ## %bb.11: ## %cond.store13
; SSE2-NEXT:    pextrw $5, %xmm0, %eax
; SSE2-NEXT:    movw %ax, (%rdi)
; SSE2-NEXT:    addq $2, %rdi
; SSE2-NEXT:  LBB11_12: ## %else14
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqw %xmm2, %xmm1
; SSE2-NEXT:    pextrw $6, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB11_14
; SSE2-NEXT:  ## %bb.13: ## %cond.store16
; SSE2-NEXT:    pextrw $6, %xmm0, %eax
; SSE2-NEXT:    movw %ax, (%rdi)
; SSE2-NEXT:    addq $2, %rdi
; SSE2-NEXT:  LBB11_14: ## %else17
; SSE2-NEXT:    pextrw $7, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB11_16
; SSE2-NEXT:  ## %bb.15: ## %cond.store19
; SSE2-NEXT:    pextrw $7, %xmm0, %eax
; SSE2-NEXT:    movw %ax, (%rdi)
; SSE2-NEXT:  LBB11_16: ## %else20
; SSE2-NEXT:    retq
;
; SSE42-LABEL: compressstore_v8i16_v8i16:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqw %xmm1, %xmm2
; SSE42-NEXT:    pextrb $0, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB11_2
; SSE42-NEXT:  ## %bb.1: ## %cond.store
; SSE42-NEXT:    pextrw $0, %xmm0, (%rdi)
; SSE42-NEXT:    addq $2, %rdi
; SSE42-NEXT:  LBB11_2: ## %else
; SSE42-NEXT:    pextrb $2, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB11_4
; SSE42-NEXT:  ## %bb.3: ## %cond.store1
; SSE42-NEXT:    pextrw $1, %xmm0, (%rdi)
; SSE42-NEXT:    addq $2, %rdi
; SSE42-NEXT:  LBB11_4: ## %else2
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqw %xmm1, %xmm2
; SSE42-NEXT:    pextrb $4, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB11_6
; SSE42-NEXT:  ## %bb.5: ## %cond.store4
; SSE42-NEXT:    pextrw $2, %xmm0, (%rdi)
; SSE42-NEXT:    addq $2, %rdi
; SSE42-NEXT:  LBB11_6: ## %else5
; SSE42-NEXT:    pextrb $6, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB11_8
; SSE42-NEXT:  ## %bb.7: ## %cond.store7
; SSE42-NEXT:    pextrw $3, %xmm0, (%rdi)
; SSE42-NEXT:    addq $2, %rdi
; SSE42-NEXT:  LBB11_8: ## %else8
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqw %xmm1, %xmm2
; SSE42-NEXT:    pextrb $8, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB11_10
; SSE42-NEXT:  ## %bb.9: ## %cond.store10
; SSE42-NEXT:    pextrw $4, %xmm0, (%rdi)
; SSE42-NEXT:    addq $2, %rdi
; SSE42-NEXT:  LBB11_10: ## %else11
; SSE42-NEXT:    pextrb $10, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB11_12
; SSE42-NEXT:  ## %bb.11: ## %cond.store13
; SSE42-NEXT:    pextrw $5, %xmm0, (%rdi)
; SSE42-NEXT:    addq $2, %rdi
; SSE42-NEXT:  LBB11_12: ## %else14
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqw %xmm2, %xmm1
; SSE42-NEXT:    pextrb $12, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB11_14
; SSE42-NEXT:  ## %bb.13: ## %cond.store16
; SSE42-NEXT:    pextrw $6, %xmm0, (%rdi)
; SSE42-NEXT:    addq $2, %rdi
; SSE42-NEXT:  LBB11_14: ## %else17
; SSE42-NEXT:    pextrb $14, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB11_16
; SSE42-NEXT:  ## %bb.15: ## %cond.store19
; SSE42-NEXT:    pextrw $7, %xmm0, (%rdi)
; SSE42-NEXT:  LBB11_16: ## %else20
; SSE42-NEXT:    retq
;
; AVX1OR2-LABEL: compressstore_v8i16_v8i16:
; AVX1OR2:       ## %bb.0:
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqw %xmm2, %xmm1, %xmm2
; AVX1OR2-NEXT:    vpextrb $0, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB11_2
; AVX1OR2-NEXT:  ## %bb.1: ## %cond.store
; AVX1OR2-NEXT:    vpextrw $0, %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $2, %rdi
; AVX1OR2-NEXT:  LBB11_2: ## %else
; AVX1OR2-NEXT:    vpextrb $2, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB11_4
; AVX1OR2-NEXT:  ## %bb.3: ## %cond.store1
; AVX1OR2-NEXT:    vpextrw $1, %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $2, %rdi
; AVX1OR2-NEXT:  LBB11_4: ## %else2
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqw %xmm2, %xmm1, %xmm2
; AVX1OR2-NEXT:    vpextrb $4, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB11_6
; AVX1OR2-NEXT:  ## %bb.5: ## %cond.store4
; AVX1OR2-NEXT:    vpextrw $2, %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $2, %rdi
; AVX1OR2-NEXT:  LBB11_6: ## %else5
; AVX1OR2-NEXT:    vpextrb $6, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB11_8
; AVX1OR2-NEXT:  ## %bb.7: ## %cond.store7
; AVX1OR2-NEXT:    vpextrw $3, %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $2, %rdi
; AVX1OR2-NEXT:  LBB11_8: ## %else8
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqw %xmm2, %xmm1, %xmm2
; AVX1OR2-NEXT:    vpextrb $8, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB11_10
; AVX1OR2-NEXT:  ## %bb.9: ## %cond.store10
; AVX1OR2-NEXT:    vpextrw $4, %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $2, %rdi
; AVX1OR2-NEXT:  LBB11_10: ## %else11
; AVX1OR2-NEXT:    vpextrb $10, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB11_12
; AVX1OR2-NEXT:  ## %bb.11: ## %cond.store13
; AVX1OR2-NEXT:    vpextrw $5, %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $2, %rdi
; AVX1OR2-NEXT:  LBB11_12: ## %else14
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqw %xmm2, %xmm1, %xmm1
; AVX1OR2-NEXT:    vpextrb $12, %xmm1, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB11_14
; AVX1OR2-NEXT:  ## %bb.13: ## %cond.store16
; AVX1OR2-NEXT:    vpextrw $6, %xmm0, (%rdi)
; AVX1OR2-NEXT:    addq $2, %rdi
; AVX1OR2-NEXT:  LBB11_14: ## %else17
; AVX1OR2-NEXT:    vpextrb $14, %xmm1, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB11_16
; AVX1OR2-NEXT:  ## %bb.15: ## %cond.store19
; AVX1OR2-NEXT:    vpextrw $7, %xmm0, (%rdi)
; AVX1OR2-NEXT:  LBB11_16: ## %else20
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: compressstore_v8i16_v8i16:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqw %xmm2, %xmm1, %xmm2
; AVX512F-NEXT:    vpmovsxwq %xmm2, %zmm2
; AVX512F-NEXT:    vptestmq %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB11_2
; AVX512F-NEXT:  ## %bb.1: ## %cond.store
; AVX512F-NEXT:    vpextrw $0, %xmm0, (%rdi)
; AVX512F-NEXT:    addq $2, %rdi
; AVX512F-NEXT:  LBB11_2: ## %else
; AVX512F-NEXT:    kshiftrw $1, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB11_4
; AVX512F-NEXT:  ## %bb.3: ## %cond.store1
; AVX512F-NEXT:    vpextrw $1, %xmm0, (%rdi)
; AVX512F-NEXT:    addq $2, %rdi
; AVX512F-NEXT:  LBB11_4: ## %else2
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqw %xmm2, %xmm1, %xmm2
; AVX512F-NEXT:    vpmovsxwq %xmm2, %zmm2
; AVX512F-NEXT:    vptestmq %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $2, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB11_6
; AVX512F-NEXT:  ## %bb.5: ## %cond.store4
; AVX512F-NEXT:    vpextrw $2, %xmm0, (%rdi)
; AVX512F-NEXT:    addq $2, %rdi
; AVX512F-NEXT:  LBB11_6: ## %else5
; AVX512F-NEXT:    kshiftrw $3, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB11_8
; AVX512F-NEXT:  ## %bb.7: ## %cond.store7
; AVX512F-NEXT:    vpextrw $3, %xmm0, (%rdi)
; AVX512F-NEXT:    addq $2, %rdi
; AVX512F-NEXT:  LBB11_8: ## %else8
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqw %xmm2, %xmm1, %xmm2
; AVX512F-NEXT:    vpmovsxwq %xmm2, %zmm2
; AVX512F-NEXT:    vptestmq %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $4, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB11_10
; AVX512F-NEXT:  ## %bb.9: ## %cond.store10
; AVX512F-NEXT:    vpextrw $4, %xmm0, (%rdi)
; AVX512F-NEXT:    addq $2, %rdi
; AVX512F-NEXT:  LBB11_10: ## %else11
; AVX512F-NEXT:    kshiftrw $5, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB11_12
; AVX512F-NEXT:  ## %bb.11: ## %cond.store13
; AVX512F-NEXT:    vpextrw $5, %xmm0, (%rdi)
; AVX512F-NEXT:    addq $2, %rdi
; AVX512F-NEXT:  LBB11_12: ## %else14
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqw %xmm2, %xmm1, %xmm1
; AVX512F-NEXT:    vpmovsxwq %xmm1, %zmm1
; AVX512F-NEXT:    vptestmq %zmm1, %zmm1, %k0
; AVX512F-NEXT:    kshiftrw $6, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB11_14
; AVX512F-NEXT:  ## %bb.13: ## %cond.store16
; AVX512F-NEXT:    vpextrw $6, %xmm0, (%rdi)
; AVX512F-NEXT:    addq $2, %rdi
; AVX512F-NEXT:  LBB11_14: ## %else17
; AVX512F-NEXT:    kshiftrw $7, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB11_16
; AVX512F-NEXT:  ## %bb.15: ## %cond.store19
; AVX512F-NEXT:    vpextrw $7, %xmm0, (%rdi)
; AVX512F-NEXT:  LBB11_16: ## %else20
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLDQ-LABEL: compressstore_v8i16_v8i16:
; AVX512VLDQ:       ## %bb.0:
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqw %xmm2, %xmm1, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxwd %xmm2, %ymm2
; AVX512VLDQ-NEXT:    vpmovd2m %ymm2, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB11_2
; AVX512VLDQ-NEXT:  ## %bb.1: ## %cond.store
; AVX512VLDQ-NEXT:    vpextrw $0, %xmm0, (%rdi)
; AVX512VLDQ-NEXT:    addq $2, %rdi
; AVX512VLDQ-NEXT:  LBB11_2: ## %else
; AVX512VLDQ-NEXT:    kshiftrb $1, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB11_4
; AVX512VLDQ-NEXT:  ## %bb.3: ## %cond.store1
; AVX512VLDQ-NEXT:    vpextrw $1, %xmm0, (%rdi)
; AVX512VLDQ-NEXT:    addq $2, %rdi
; AVX512VLDQ-NEXT:  LBB11_4: ## %else2
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqw %xmm2, %xmm1, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxwd %xmm2, %ymm2
; AVX512VLDQ-NEXT:    vpmovd2m %ymm2, %k0
; AVX512VLDQ-NEXT:    kshiftrb $2, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB11_6
; AVX512VLDQ-NEXT:  ## %bb.5: ## %cond.store4
; AVX512VLDQ-NEXT:    vpextrw $2, %xmm0, (%rdi)
; AVX512VLDQ-NEXT:    addq $2, %rdi
; AVX512VLDQ-NEXT:  LBB11_6: ## %else5
; AVX512VLDQ-NEXT:    kshiftrb $3, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB11_8
; AVX512VLDQ-NEXT:  ## %bb.7: ## %cond.store7
; AVX512VLDQ-NEXT:    vpextrw $3, %xmm0, (%rdi)
; AVX512VLDQ-NEXT:    addq $2, %rdi
; AVX512VLDQ-NEXT:  LBB11_8: ## %else8
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqw %xmm2, %xmm1, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxwd %xmm2, %ymm2
; AVX512VLDQ-NEXT:    vpmovd2m %ymm2, %k0
; AVX512VLDQ-NEXT:    kshiftrb $4, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB11_10
; AVX512VLDQ-NEXT:  ## %bb.9: ## %cond.store10
; AVX512VLDQ-NEXT:    vpextrw $4, %xmm0, (%rdi)
; AVX512VLDQ-NEXT:    addq $2, %rdi
; AVX512VLDQ-NEXT:  LBB11_10: ## %else11
; AVX512VLDQ-NEXT:    kshiftrb $5, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB11_12
; AVX512VLDQ-NEXT:  ## %bb.11: ## %cond.store13
; AVX512VLDQ-NEXT:    vpextrw $5, %xmm0, (%rdi)
; AVX512VLDQ-NEXT:    addq $2, %rdi
; AVX512VLDQ-NEXT:  LBB11_12: ## %else14
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqw %xmm2, %xmm1, %xmm1
; AVX512VLDQ-NEXT:    vpmovsxwd %xmm1, %ymm1
; AVX512VLDQ-NEXT:    vpmovd2m %ymm1, %k0
; AVX512VLDQ-NEXT:    kshiftrb $6, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB11_14
; AVX512VLDQ-NEXT:  ## %bb.13: ## %cond.store16
; AVX512VLDQ-NEXT:    vpextrw $6, %xmm0, (%rdi)
; AVX512VLDQ-NEXT:    addq $2, %rdi
; AVX512VLDQ-NEXT:  LBB11_14: ## %else17
; AVX512VLDQ-NEXT:    kshiftrb $7, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB11_16
; AVX512VLDQ-NEXT:  ## %bb.15: ## %cond.store19
; AVX512VLDQ-NEXT:    vpextrw $7, %xmm0, (%rdi)
; AVX512VLDQ-NEXT:  LBB11_16: ## %else20
; AVX512VLDQ-NEXT:    vzeroupper
; AVX512VLDQ-NEXT:    retq
;
; AVX512VLBW-LABEL: compressstore_v8i16_v8i16:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vptestnmw %xmm1, %xmm1, %k0
; AVX512VLBW-NEXT:    kmovd %k0, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB11_2
; AVX512VLBW-NEXT:  ## %bb.1: ## %cond.store
; AVX512VLBW-NEXT:    vpextrw $0, %xmm0, (%rdi)
; AVX512VLBW-NEXT:    addq $2, %rdi
; AVX512VLBW-NEXT:  LBB11_2: ## %else
; AVX512VLBW-NEXT:    kshiftrw $1, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB11_4
; AVX512VLBW-NEXT:  ## %bb.3: ## %cond.store1
; AVX512VLBW-NEXT:    vpextrw $1, %xmm0, (%rdi)
; AVX512VLBW-NEXT:    addq $2, %rdi
; AVX512VLBW-NEXT:  LBB11_4: ## %else2
; AVX512VLBW-NEXT:    kshiftrw $2, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB11_6
; AVX512VLBW-NEXT:  ## %bb.5: ## %cond.store4
; AVX512VLBW-NEXT:    vpextrw $2, %xmm0, (%rdi)
; AVX512VLBW-NEXT:    addq $2, %rdi
; AVX512VLBW-NEXT:  LBB11_6: ## %else5
; AVX512VLBW-NEXT:    kshiftrw $3, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB11_8
; AVX512VLBW-NEXT:  ## %bb.7: ## %cond.store7
; AVX512VLBW-NEXT:    vpextrw $3, %xmm0, (%rdi)
; AVX512VLBW-NEXT:    addq $2, %rdi
; AVX512VLBW-NEXT:  LBB11_8: ## %else8
; AVX512VLBW-NEXT:    kshiftrw $4, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB11_10
; AVX512VLBW-NEXT:  ## %bb.9: ## %cond.store10
; AVX512VLBW-NEXT:    vpextrw $4, %xmm0, (%rdi)
; AVX512VLBW-NEXT:    addq $2, %rdi
; AVX512VLBW-NEXT:  LBB11_10: ## %else11
; AVX512VLBW-NEXT:    kshiftrw $5, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB11_12
; AVX512VLBW-NEXT:  ## %bb.11: ## %cond.store13
; AVX512VLBW-NEXT:    vpextrw $5, %xmm0, (%rdi)
; AVX512VLBW-NEXT:    addq $2, %rdi
; AVX512VLBW-NEXT:  LBB11_12: ## %else14
; AVX512VLBW-NEXT:    kshiftrw $6, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB11_14
; AVX512VLBW-NEXT:  ## %bb.13: ## %cond.store16
; AVX512VLBW-NEXT:    vpextrw $6, %xmm0, (%rdi)
; AVX512VLBW-NEXT:    addq $2, %rdi
; AVX512VLBW-NEXT:  LBB11_14: ## %else17
; AVX512VLBW-NEXT:    kshiftrw $7, %k0, %k0
; AVX512VLBW-NEXT:    kmovd %k0, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB11_16
; AVX512VLBW-NEXT:  ## %bb.15: ## %cond.store19
; AVX512VLBW-NEXT:    vpextrw $7, %xmm0, (%rdi)
; AVX512VLBW-NEXT:  LBB11_16: ## %else20
; AVX512VLBW-NEXT:    retq
  %mask = icmp eq <8 x i16> %trigger, zeroinitializer
  call void @llvm.masked.compressstore.v8i16(<8 x i16> %V, i16* %base, <8 x i1> %mask)
  ret void
}

;
; vXi8
;

define void @compressstore_v16i8_v16i8(i8* %base, <16 x i8> %V, <16 x i8> %trigger) {
; SSE2-LABEL: compressstore_v16i8_v16i8:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqb %xmm1, %xmm2
; SSE2-NEXT:    movd %xmm2, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    movd %xmm0, %eax
; SSE2-NEXT:    je LBB12_2
; SSE2-NEXT:  ## %bb.1: ## %cond.store
; SSE2-NEXT:    movb %al, (%rdi)
; SSE2-NEXT:    incq %rdi
; SSE2-NEXT:  LBB12_2: ## %else
; SSE2-NEXT:    shrl $8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB12_4
; SSE2-NEXT:  ## %bb.3: ## %cond.store1
; SSE2-NEXT:    movb %ah, (%rdi)
; SSE2-NEXT:    incq %rdi
; SSE2-NEXT:  LBB12_4: ## %else2
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqb %xmm1, %xmm2
; SSE2-NEXT:    movd %xmm2, %ecx
; SSE2-NEXT:    movl %ecx, %edx
; SSE2-NEXT:    shrl $16, %edx
; SSE2-NEXT:    testb $1, %dl
; SSE2-NEXT:    je LBB12_6
; SSE2-NEXT:  ## %bb.5: ## %cond.store4
; SSE2-NEXT:    movl %eax, %edx
; SSE2-NEXT:    shrl $16, %edx
; SSE2-NEXT:    movb %dl, (%rdi)
; SSE2-NEXT:    incq %rdi
; SSE2-NEXT:  LBB12_6: ## %else5
; SSE2-NEXT:    shrl $24, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB12_8
; SSE2-NEXT:  ## %bb.7: ## %cond.store7
; SSE2-NEXT:    shrl $24, %eax
; SSE2-NEXT:    movb %al, (%rdi)
; SSE2-NEXT:    incq %rdi
; SSE2-NEXT:  LBB12_8: ## %else8
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqb %xmm1, %xmm2
; SSE2-NEXT:    pextrw $2, %xmm2, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    pextrw $2, %xmm0, %eax
; SSE2-NEXT:    je LBB12_10
; SSE2-NEXT:  ## %bb.9: ## %cond.store10
; SSE2-NEXT:    movb %al, (%rdi)
; SSE2-NEXT:    incq %rdi
; SSE2-NEXT:  LBB12_10: ## %else11
; SSE2-NEXT:    shrl $8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB12_12
; SSE2-NEXT:  ## %bb.11: ## %cond.store13
; SSE2-NEXT:    movb %ah, (%rdi)
; SSE2-NEXT:    incq %rdi
; SSE2-NEXT:  LBB12_12: ## %else14
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqb %xmm1, %xmm2
; SSE2-NEXT:    pextrw $3, %xmm2, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    pextrw $3, %xmm0, %eax
; SSE2-NEXT:    je LBB12_14
; SSE2-NEXT:  ## %bb.13: ## %cond.store16
; SSE2-NEXT:    movb %al, (%rdi)
; SSE2-NEXT:    incq %rdi
; SSE2-NEXT:  LBB12_14: ## %else17
; SSE2-NEXT:    shrl $8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB12_16
; SSE2-NEXT:  ## %bb.15: ## %cond.store19
; SSE2-NEXT:    movb %ah, (%rdi)
; SSE2-NEXT:    incq %rdi
; SSE2-NEXT:  LBB12_16: ## %else20
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqb %xmm1, %xmm2
; SSE2-NEXT:    pextrw $4, %xmm2, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    pextrw $4, %xmm0, %eax
; SSE2-NEXT:    je LBB12_18
; SSE2-NEXT:  ## %bb.17: ## %cond.store22
; SSE2-NEXT:    movb %al, (%rdi)
; SSE2-NEXT:    incq %rdi
; SSE2-NEXT:  LBB12_18: ## %else23
; SSE2-NEXT:    shrl $8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB12_20
; SSE2-NEXT:  ## %bb.19: ## %cond.store25
; SSE2-NEXT:    movb %ah, (%rdi)
; SSE2-NEXT:    incq %rdi
; SSE2-NEXT:  LBB12_20: ## %else26
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqb %xmm1, %xmm2
; SSE2-NEXT:    pextrw $5, %xmm2, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    pextrw $5, %xmm0, %eax
; SSE2-NEXT:    je LBB12_22
; SSE2-NEXT:  ## %bb.21: ## %cond.store28
; SSE2-NEXT:    movb %al, (%rdi)
; SSE2-NEXT:    incq %rdi
; SSE2-NEXT:  LBB12_22: ## %else29
; SSE2-NEXT:    shrl $8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB12_24
; SSE2-NEXT:  ## %bb.23: ## %cond.store31
; SSE2-NEXT:    movb %ah, (%rdi)
; SSE2-NEXT:    incq %rdi
; SSE2-NEXT:  LBB12_24: ## %else32
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqb %xmm1, %xmm2
; SSE2-NEXT:    pextrw $6, %xmm2, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    pextrw $6, %xmm0, %eax
; SSE2-NEXT:    je LBB12_26
; SSE2-NEXT:  ## %bb.25: ## %cond.store34
; SSE2-NEXT:    movb %al, (%rdi)
; SSE2-NEXT:    incq %rdi
; SSE2-NEXT:  LBB12_26: ## %else35
; SSE2-NEXT:    shrl $8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB12_28
; SSE2-NEXT:  ## %bb.27: ## %cond.store37
; SSE2-NEXT:    movb %ah, (%rdi)
; SSE2-NEXT:    incq %rdi
; SSE2-NEXT:  LBB12_28: ## %else38
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqb %xmm2, %xmm1
; SSE2-NEXT:    pextrw $7, %xmm1, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    pextrw $7, %xmm0, %eax
; SSE2-NEXT:    je LBB12_30
; SSE2-NEXT:  ## %bb.29: ## %cond.store40
; SSE2-NEXT:    movb %al, (%rdi)
; SSE2-NEXT:    incq %rdi
; SSE2-NEXT:  LBB12_30: ## %else41
; SSE2-NEXT:    shrl $8, %ecx
; SSE2-NEXT:    testb $1, %cl
; SSE2-NEXT:    je LBB12_32
; SSE2-NEXT:  ## %bb.31: ## %cond.store43
; SSE2-NEXT:    movb %ah, (%rdi)
; SSE2-NEXT:  LBB12_32: ## %else44
; SSE2-NEXT:    retq
;
; SSE42-LABEL: compressstore_v16i8_v16i8:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqb %xmm1, %xmm2
; SSE42-NEXT:    pextrb $0, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB12_2
; SSE42-NEXT:  ## %bb.1: ## %cond.store
; SSE42-NEXT:    pextrb $0, %xmm0, (%rdi)
; SSE42-NEXT:    incq %rdi
; SSE42-NEXT:  LBB12_2: ## %else
; SSE42-NEXT:    pextrb $1, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB12_4
; SSE42-NEXT:  ## %bb.3: ## %cond.store1
; SSE42-NEXT:    pextrb $1, %xmm0, (%rdi)
; SSE42-NEXT:    incq %rdi
; SSE42-NEXT:  LBB12_4: ## %else2
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqb %xmm1, %xmm2
; SSE42-NEXT:    pextrb $2, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB12_6
; SSE42-NEXT:  ## %bb.5: ## %cond.store4
; SSE42-NEXT:    pextrb $2, %xmm0, (%rdi)
; SSE42-NEXT:    incq %rdi
; SSE42-NEXT:  LBB12_6: ## %else5
; SSE42-NEXT:    pextrb $3, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB12_8
; SSE42-NEXT:  ## %bb.7: ## %cond.store7
; SSE42-NEXT:    pextrb $3, %xmm0, (%rdi)
; SSE42-NEXT:    incq %rdi
; SSE42-NEXT:  LBB12_8: ## %else8
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqb %xmm1, %xmm2
; SSE42-NEXT:    pextrb $4, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB12_10
; SSE42-NEXT:  ## %bb.9: ## %cond.store10
; SSE42-NEXT:    pextrb $4, %xmm0, (%rdi)
; SSE42-NEXT:    incq %rdi
; SSE42-NEXT:  LBB12_10: ## %else11
; SSE42-NEXT:    pextrb $5, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB12_12
; SSE42-NEXT:  ## %bb.11: ## %cond.store13
; SSE42-NEXT:    pextrb $5, %xmm0, (%rdi)
; SSE42-NEXT:    incq %rdi
; SSE42-NEXT:  LBB12_12: ## %else14
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqb %xmm1, %xmm2
; SSE42-NEXT:    pextrb $6, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB12_14
; SSE42-NEXT:  ## %bb.13: ## %cond.store16
; SSE42-NEXT:    pextrb $6, %xmm0, (%rdi)
; SSE42-NEXT:    incq %rdi
; SSE42-NEXT:  LBB12_14: ## %else17
; SSE42-NEXT:    pextrb $7, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB12_16
; SSE42-NEXT:  ## %bb.15: ## %cond.store19
; SSE42-NEXT:    pextrb $7, %xmm0, (%rdi)
; SSE42-NEXT:    incq %rdi
; SSE42-NEXT:  LBB12_16: ## %else20
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqb %xmm1, %xmm2
; SSE42-NEXT:    pextrb $8, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB12_18
; SSE42-NEXT:  ## %bb.17: ## %cond.store22
; SSE42-NEXT:    pextrb $8, %xmm0, (%rdi)
; SSE42-NEXT:    incq %rdi
; SSE42-NEXT:  LBB12_18: ## %else23
; SSE42-NEXT:    pextrb $9, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB12_20
; SSE42-NEXT:  ## %bb.19: ## %cond.store25
; SSE42-NEXT:    pextrb $9, %xmm0, (%rdi)
; SSE42-NEXT:    incq %rdi
; SSE42-NEXT:  LBB12_20: ## %else26
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqb %xmm1, %xmm2
; SSE42-NEXT:    pextrb $10, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB12_22
; SSE42-NEXT:  ## %bb.21: ## %cond.store28
; SSE42-NEXT:    pextrb $10, %xmm0, (%rdi)
; SSE42-NEXT:    incq %rdi
; SSE42-NEXT:  LBB12_22: ## %else29
; SSE42-NEXT:    pextrb $11, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB12_24
; SSE42-NEXT:  ## %bb.23: ## %cond.store31
; SSE42-NEXT:    pextrb $11, %xmm0, (%rdi)
; SSE42-NEXT:    incq %rdi
; SSE42-NEXT:  LBB12_24: ## %else32
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqb %xmm1, %xmm2
; SSE42-NEXT:    pextrb $12, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB12_26
; SSE42-NEXT:  ## %bb.25: ## %cond.store34
; SSE42-NEXT:    pextrb $12, %xmm0, (%rdi)
; SSE42-NEXT:    incq %rdi
; SSE42-NEXT:  LBB12_26: ## %else35
; SSE42-NEXT:    pextrb $13, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB12_28
; SSE42-NEXT:  ## %bb.27: ## %cond.store37
; SSE42-NEXT:    pextrb $13, %xmm0, (%rdi)
; SSE42-NEXT:    incq %rdi
; SSE42-NEXT:  LBB12_28: ## %else38
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqb %xmm2, %xmm1
; SSE42-NEXT:    pextrb $14, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB12_30
; SSE42-NEXT:  ## %bb.29: ## %cond.store40
; SSE42-NEXT:    pextrb $14, %xmm0, (%rdi)
; SSE42-NEXT:    incq %rdi
; SSE42-NEXT:  LBB12_30: ## %else41
; SSE42-NEXT:    pextrb $15, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB12_32
; SSE42-NEXT:  ## %bb.31: ## %cond.store43
; SSE42-NEXT:    pextrb $15, %xmm0, (%rdi)
; SSE42-NEXT:  LBB12_32: ## %else44
; SSE42-NEXT:    retq
;
; AVX1OR2-LABEL: compressstore_v16i8_v16i8:
; AVX1OR2:       ## %bb.0:
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX1OR2-NEXT:    vpextrb $0, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB12_2
; AVX1OR2-NEXT:  ## %bb.1: ## %cond.store
; AVX1OR2-NEXT:    vpextrb $0, %xmm0, (%rdi)
; AVX1OR2-NEXT:    incq %rdi
; AVX1OR2-NEXT:  LBB12_2: ## %else
; AVX1OR2-NEXT:    vpextrb $1, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB12_4
; AVX1OR2-NEXT:  ## %bb.3: ## %cond.store1
; AVX1OR2-NEXT:    vpextrb $1, %xmm0, (%rdi)
; AVX1OR2-NEXT:    incq %rdi
; AVX1OR2-NEXT:  LBB12_4: ## %else2
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX1OR2-NEXT:    vpextrb $2, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB12_6
; AVX1OR2-NEXT:  ## %bb.5: ## %cond.store4
; AVX1OR2-NEXT:    vpextrb $2, %xmm0, (%rdi)
; AVX1OR2-NEXT:    incq %rdi
; AVX1OR2-NEXT:  LBB12_6: ## %else5
; AVX1OR2-NEXT:    vpextrb $3, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB12_8
; AVX1OR2-NEXT:  ## %bb.7: ## %cond.store7
; AVX1OR2-NEXT:    vpextrb $3, %xmm0, (%rdi)
; AVX1OR2-NEXT:    incq %rdi
; AVX1OR2-NEXT:  LBB12_8: ## %else8
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX1OR2-NEXT:    vpextrb $4, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB12_10
; AVX1OR2-NEXT:  ## %bb.9: ## %cond.store10
; AVX1OR2-NEXT:    vpextrb $4, %xmm0, (%rdi)
; AVX1OR2-NEXT:    incq %rdi
; AVX1OR2-NEXT:  LBB12_10: ## %else11
; AVX1OR2-NEXT:    vpextrb $5, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB12_12
; AVX1OR2-NEXT:  ## %bb.11: ## %cond.store13
; AVX1OR2-NEXT:    vpextrb $5, %xmm0, (%rdi)
; AVX1OR2-NEXT:    incq %rdi
; AVX1OR2-NEXT:  LBB12_12: ## %else14
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX1OR2-NEXT:    vpextrb $6, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB12_14
; AVX1OR2-NEXT:  ## %bb.13: ## %cond.store16
; AVX1OR2-NEXT:    vpextrb $6, %xmm0, (%rdi)
; AVX1OR2-NEXT:    incq %rdi
; AVX1OR2-NEXT:  LBB12_14: ## %else17
; AVX1OR2-NEXT:    vpextrb $7, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB12_16
; AVX1OR2-NEXT:  ## %bb.15: ## %cond.store19
; AVX1OR2-NEXT:    vpextrb $7, %xmm0, (%rdi)
; AVX1OR2-NEXT:    incq %rdi
; AVX1OR2-NEXT:  LBB12_16: ## %else20
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX1OR2-NEXT:    vpextrb $8, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB12_18
; AVX1OR2-NEXT:  ## %bb.17: ## %cond.store22
; AVX1OR2-NEXT:    vpextrb $8, %xmm0, (%rdi)
; AVX1OR2-NEXT:    incq %rdi
; AVX1OR2-NEXT:  LBB12_18: ## %else23
; AVX1OR2-NEXT:    vpextrb $9, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB12_20
; AVX1OR2-NEXT:  ## %bb.19: ## %cond.store25
; AVX1OR2-NEXT:    vpextrb $9, %xmm0, (%rdi)
; AVX1OR2-NEXT:    incq %rdi
; AVX1OR2-NEXT:  LBB12_20: ## %else26
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX1OR2-NEXT:    vpextrb $10, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB12_22
; AVX1OR2-NEXT:  ## %bb.21: ## %cond.store28
; AVX1OR2-NEXT:    vpextrb $10, %xmm0, (%rdi)
; AVX1OR2-NEXT:    incq %rdi
; AVX1OR2-NEXT:  LBB12_22: ## %else29
; AVX1OR2-NEXT:    vpextrb $11, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB12_24
; AVX1OR2-NEXT:  ## %bb.23: ## %cond.store31
; AVX1OR2-NEXT:    vpextrb $11, %xmm0, (%rdi)
; AVX1OR2-NEXT:    incq %rdi
; AVX1OR2-NEXT:  LBB12_24: ## %else32
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX1OR2-NEXT:    vpextrb $12, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB12_26
; AVX1OR2-NEXT:  ## %bb.25: ## %cond.store34
; AVX1OR2-NEXT:    vpextrb $12, %xmm0, (%rdi)
; AVX1OR2-NEXT:    incq %rdi
; AVX1OR2-NEXT:  LBB12_26: ## %else35
; AVX1OR2-NEXT:    vpextrb $13, %xmm2, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB12_28
; AVX1OR2-NEXT:  ## %bb.27: ## %cond.store37
; AVX1OR2-NEXT:    vpextrb $13, %xmm0, (%rdi)
; AVX1OR2-NEXT:    incq %rdi
; AVX1OR2-NEXT:  LBB12_28: ## %else38
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm1
; AVX1OR2-NEXT:    vpextrb $14, %xmm1, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB12_30
; AVX1OR2-NEXT:  ## %bb.29: ## %cond.store40
; AVX1OR2-NEXT:    vpextrb $14, %xmm0, (%rdi)
; AVX1OR2-NEXT:    incq %rdi
; AVX1OR2-NEXT:  LBB12_30: ## %else41
; AVX1OR2-NEXT:    vpextrb $15, %xmm1, %eax
; AVX1OR2-NEXT:    testb $1, %al
; AVX1OR2-NEXT:    je LBB12_32
; AVX1OR2-NEXT:  ## %bb.31: ## %cond.store43
; AVX1OR2-NEXT:    vpextrb $15, %xmm0, (%rdi)
; AVX1OR2-NEXT:  LBB12_32: ## %else44
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: compressstore_v16i8_v16i8:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB12_2
; AVX512F-NEXT:  ## %bb.1: ## %cond.store
; AVX512F-NEXT:    vpextrb $0, %xmm0, (%rdi)
; AVX512F-NEXT:    incq %rdi
; AVX512F-NEXT:  LBB12_2: ## %else
; AVX512F-NEXT:    kshiftrw $1, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB12_4
; AVX512F-NEXT:  ## %bb.3: ## %cond.store1
; AVX512F-NEXT:    vpextrb $1, %xmm0, (%rdi)
; AVX512F-NEXT:    incq %rdi
; AVX512F-NEXT:  LBB12_4: ## %else2
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $2, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB12_6
; AVX512F-NEXT:  ## %bb.5: ## %cond.store4
; AVX512F-NEXT:    vpextrb $2, %xmm0, (%rdi)
; AVX512F-NEXT:    incq %rdi
; AVX512F-NEXT:  LBB12_6: ## %else5
; AVX512F-NEXT:    kshiftrw $3, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB12_8
; AVX512F-NEXT:  ## %bb.7: ## %cond.store7
; AVX512F-NEXT:    vpextrb $3, %xmm0, (%rdi)
; AVX512F-NEXT:    incq %rdi
; AVX512F-NEXT:  LBB12_8: ## %else8
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $4, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB12_10
; AVX512F-NEXT:  ## %bb.9: ## %cond.store10
; AVX512F-NEXT:    vpextrb $4, %xmm0, (%rdi)
; AVX512F-NEXT:    incq %rdi
; AVX512F-NEXT:  LBB12_10: ## %else11
; AVX512F-NEXT:    kshiftrw $5, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB12_12
; AVX512F-NEXT:  ## %bb.11: ## %cond.store13
; AVX512F-NEXT:    vpextrb $5, %xmm0, (%rdi)
; AVX512F-NEXT:    incq %rdi
; AVX512F-NEXT:  LBB12_12: ## %else14
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $6, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB12_14
; AVX512F-NEXT:  ## %bb.13: ## %cond.store16
; AVX512F-NEXT:    vpextrb $6, %xmm0, (%rdi)
; AVX512F-NEXT:    incq %rdi
; AVX512F-NEXT:  LBB12_14: ## %else17
; AVX512F-NEXT:    kshiftrw $7, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB12_16
; AVX512F-NEXT:  ## %bb.15: ## %cond.store19
; AVX512F-NEXT:    vpextrb $7, %xmm0, (%rdi)
; AVX512F-NEXT:    incq %rdi
; AVX512F-NEXT:  LBB12_16: ## %else20
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $8, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB12_18
; AVX512F-NEXT:  ## %bb.17: ## %cond.store22
; AVX512F-NEXT:    vpextrb $8, %xmm0, (%rdi)
; AVX512F-NEXT:    incq %rdi
; AVX512F-NEXT:  LBB12_18: ## %else23
; AVX512F-NEXT:    kshiftrw $9, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB12_20
; AVX512F-NEXT:  ## %bb.19: ## %cond.store25
; AVX512F-NEXT:    vpextrb $9, %xmm0, (%rdi)
; AVX512F-NEXT:    incq %rdi
; AVX512F-NEXT:  LBB12_20: ## %else26
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $10, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB12_22
; AVX512F-NEXT:  ## %bb.21: ## %cond.store28
; AVX512F-NEXT:    vpextrb $10, %xmm0, (%rdi)
; AVX512F-NEXT:    incq %rdi
; AVX512F-NEXT:  LBB12_22: ## %else29
; AVX512F-NEXT:    kshiftrw $11, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB12_24
; AVX512F-NEXT:  ## %bb.23: ## %cond.store31
; AVX512F-NEXT:    vpextrb $11, %xmm0, (%rdi)
; AVX512F-NEXT:    incq %rdi
; AVX512F-NEXT:  LBB12_24: ## %else32
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX512F-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512F-NEXT:    vptestmd %zmm2, %zmm2, %k0
; AVX512F-NEXT:    kshiftrw $12, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB12_26
; AVX512F-NEXT:  ## %bb.25: ## %cond.store34
; AVX512F-NEXT:    vpextrb $12, %xmm0, (%rdi)
; AVX512F-NEXT:    incq %rdi
; AVX512F-NEXT:  LBB12_26: ## %else35
; AVX512F-NEXT:    kshiftrw $13, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB12_28
; AVX512F-NEXT:  ## %bb.27: ## %cond.store37
; AVX512F-NEXT:    vpextrb $13, %xmm0, (%rdi)
; AVX512F-NEXT:    incq %rdi
; AVX512F-NEXT:  LBB12_28: ## %else38
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm1
; AVX512F-NEXT:    vpmovsxbd %xmm1, %zmm1
; AVX512F-NEXT:    vptestmd %zmm1, %zmm1, %k0
; AVX512F-NEXT:    kshiftrw $14, %k0, %k1
; AVX512F-NEXT:    kmovw %k1, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB12_30
; AVX512F-NEXT:  ## %bb.29: ## %cond.store40
; AVX512F-NEXT:    vpextrb $14, %xmm0, (%rdi)
; AVX512F-NEXT:    incq %rdi
; AVX512F-NEXT:  LBB12_30: ## %else41
; AVX512F-NEXT:    kshiftrw $15, %k0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $1, %al
; AVX512F-NEXT:    je LBB12_32
; AVX512F-NEXT:  ## %bb.31: ## %cond.store43
; AVX512F-NEXT:    vpextrb $15, %xmm0, (%rdi)
; AVX512F-NEXT:  LBB12_32: ## %else44
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLDQ-LABEL: compressstore_v16i8_v16i8:
; AVX512VLDQ:       ## %bb.0:
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB12_2
; AVX512VLDQ-NEXT:  ## %bb.1: ## %cond.store
; AVX512VLDQ-NEXT:    vpextrb $0, %xmm0, (%rdi)
; AVX512VLDQ-NEXT:    incq %rdi
; AVX512VLDQ-NEXT:  LBB12_2: ## %else
; AVX512VLDQ-NEXT:    kshiftrw $1, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB12_4
; AVX512VLDQ-NEXT:  ## %bb.3: ## %cond.store1
; AVX512VLDQ-NEXT:    vpextrb $1, %xmm0, (%rdi)
; AVX512VLDQ-NEXT:    incq %rdi
; AVX512VLDQ-NEXT:  LBB12_4: ## %else2
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $2, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB12_6
; AVX512VLDQ-NEXT:  ## %bb.5: ## %cond.store4
; AVX512VLDQ-NEXT:    vpextrb $2, %xmm0, (%rdi)
; AVX512VLDQ-NEXT:    incq %rdi
; AVX512VLDQ-NEXT:  LBB12_6: ## %else5
; AVX512VLDQ-NEXT:    kshiftrw $3, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB12_8
; AVX512VLDQ-NEXT:  ## %bb.7: ## %cond.store7
; AVX512VLDQ-NEXT:    vpextrb $3, %xmm0, (%rdi)
; AVX512VLDQ-NEXT:    incq %rdi
; AVX512VLDQ-NEXT:  LBB12_8: ## %else8
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $4, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB12_10
; AVX512VLDQ-NEXT:  ## %bb.9: ## %cond.store10
; AVX512VLDQ-NEXT:    vpextrb $4, %xmm0, (%rdi)
; AVX512VLDQ-NEXT:    incq %rdi
; AVX512VLDQ-NEXT:  LBB12_10: ## %else11
; AVX512VLDQ-NEXT:    kshiftrw $5, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB12_12
; AVX512VLDQ-NEXT:  ## %bb.11: ## %cond.store13
; AVX512VLDQ-NEXT:    vpextrb $5, %xmm0, (%rdi)
; AVX512VLDQ-NEXT:    incq %rdi
; AVX512VLDQ-NEXT:  LBB12_12: ## %else14
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $6, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB12_14
; AVX512VLDQ-NEXT:  ## %bb.13: ## %cond.store16
; AVX512VLDQ-NEXT:    vpextrb $6, %xmm0, (%rdi)
; AVX512VLDQ-NEXT:    incq %rdi
; AVX512VLDQ-NEXT:  LBB12_14: ## %else17
; AVX512VLDQ-NEXT:    kshiftrw $7, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB12_16
; AVX512VLDQ-NEXT:  ## %bb.15: ## %cond.store19
; AVX512VLDQ-NEXT:    vpextrb $7, %xmm0, (%rdi)
; AVX512VLDQ-NEXT:    incq %rdi
; AVX512VLDQ-NEXT:  LBB12_16: ## %else20
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $8, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB12_18
; AVX512VLDQ-NEXT:  ## %bb.17: ## %cond.store22
; AVX512VLDQ-NEXT:    vpextrb $8, %xmm0, (%rdi)
; AVX512VLDQ-NEXT:    incq %rdi
; AVX512VLDQ-NEXT:  LBB12_18: ## %else23
; AVX512VLDQ-NEXT:    kshiftrw $9, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB12_20
; AVX512VLDQ-NEXT:  ## %bb.19: ## %cond.store25
; AVX512VLDQ-NEXT:    vpextrb $9, %xmm0, (%rdi)
; AVX512VLDQ-NEXT:    incq %rdi
; AVX512VLDQ-NEXT:  LBB12_20: ## %else26
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $10, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB12_22
; AVX512VLDQ-NEXT:  ## %bb.21: ## %cond.store28
; AVX512VLDQ-NEXT:    vpextrb $10, %xmm0, (%rdi)
; AVX512VLDQ-NEXT:    incq %rdi
; AVX512VLDQ-NEXT:  LBB12_22: ## %else29
; AVX512VLDQ-NEXT:    kshiftrw $11, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB12_24
; AVX512VLDQ-NEXT:  ## %bb.23: ## %cond.store31
; AVX512VLDQ-NEXT:    vpextrb $11, %xmm0, (%rdi)
; AVX512VLDQ-NEXT:    incq %rdi
; AVX512VLDQ-NEXT:  LBB12_24: ## %else32
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm2
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm2, %zmm2
; AVX512VLDQ-NEXT:    vpmovd2m %zmm2, %k0
; AVX512VLDQ-NEXT:    kshiftrw $12, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB12_26
; AVX512VLDQ-NEXT:  ## %bb.25: ## %cond.store34
; AVX512VLDQ-NEXT:    vpextrb $12, %xmm0, (%rdi)
; AVX512VLDQ-NEXT:    incq %rdi
; AVX512VLDQ-NEXT:  LBB12_26: ## %else35
; AVX512VLDQ-NEXT:    kshiftrw $13, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB12_28
; AVX512VLDQ-NEXT:  ## %bb.27: ## %cond.store37
; AVX512VLDQ-NEXT:    vpextrb $13, %xmm0, (%rdi)
; AVX512VLDQ-NEXT:    incq %rdi
; AVX512VLDQ-NEXT:  LBB12_28: ## %else38
; AVX512VLDQ-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLDQ-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm1
; AVX512VLDQ-NEXT:    vpmovsxbd %xmm1, %zmm1
; AVX512VLDQ-NEXT:    vpmovd2m %zmm1, %k0
; AVX512VLDQ-NEXT:    kshiftrw $14, %k0, %k1
; AVX512VLDQ-NEXT:    kmovw %k1, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB12_30
; AVX512VLDQ-NEXT:  ## %bb.29: ## %cond.store40
; AVX512VLDQ-NEXT:    vpextrb $14, %xmm0, (%rdi)
; AVX512VLDQ-NEXT:    incq %rdi
; AVX512VLDQ-NEXT:  LBB12_30: ## %else41
; AVX512VLDQ-NEXT:    kshiftrw $15, %k0, %k0
; AVX512VLDQ-NEXT:    kmovw %k0, %eax
; AVX512VLDQ-NEXT:    testb $1, %al
; AVX512VLDQ-NEXT:    je LBB12_32
; AVX512VLDQ-NEXT:  ## %bb.31: ## %cond.store43
; AVX512VLDQ-NEXT:    vpextrb $15, %xmm0, (%rdi)
; AVX512VLDQ-NEXT:  LBB12_32: ## %else44
; AVX512VLDQ-NEXT:    vzeroupper
; AVX512VLDQ-NEXT:    retq
;
; AVX512VLBW-LABEL: compressstore_v16i8_v16i8:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vptestnmb %xmm1, %xmm1, %k0
; AVX512VLBW-NEXT:    kmovd %k0, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB12_2
; AVX512VLBW-NEXT:  ## %bb.1: ## %cond.store
; AVX512VLBW-NEXT:    vpextrb $0, %xmm0, (%rdi)
; AVX512VLBW-NEXT:    incq %rdi
; AVX512VLBW-NEXT:  LBB12_2: ## %else
; AVX512VLBW-NEXT:    kshiftrw $1, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB12_4
; AVX512VLBW-NEXT:  ## %bb.3: ## %cond.store1
; AVX512VLBW-NEXT:    vpextrb $1, %xmm0, (%rdi)
; AVX512VLBW-NEXT:    incq %rdi
; AVX512VLBW-NEXT:  LBB12_4: ## %else2
; AVX512VLBW-NEXT:    kshiftrw $2, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB12_6
; AVX512VLBW-NEXT:  ## %bb.5: ## %cond.store4
; AVX512VLBW-NEXT:    vpextrb $2, %xmm0, (%rdi)
; AVX512VLBW-NEXT:    incq %rdi
; AVX512VLBW-NEXT:  LBB12_6: ## %else5
; AVX512VLBW-NEXT:    kshiftrw $3, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB12_8
; AVX512VLBW-NEXT:  ## %bb.7: ## %cond.store7
; AVX512VLBW-NEXT:    vpextrb $3, %xmm0, (%rdi)
; AVX512VLBW-NEXT:    incq %rdi
; AVX512VLBW-NEXT:  LBB12_8: ## %else8
; AVX512VLBW-NEXT:    kshiftrw $4, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB12_10
; AVX512VLBW-NEXT:  ## %bb.9: ## %cond.store10
; AVX512VLBW-NEXT:    vpextrb $4, %xmm0, (%rdi)
; AVX512VLBW-NEXT:    incq %rdi
; AVX512VLBW-NEXT:  LBB12_10: ## %else11
; AVX512VLBW-NEXT:    kshiftrw $5, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB12_12
; AVX512VLBW-NEXT:  ## %bb.11: ## %cond.store13
; AVX512VLBW-NEXT:    vpextrb $5, %xmm0, (%rdi)
; AVX512VLBW-NEXT:    incq %rdi
; AVX512VLBW-NEXT:  LBB12_12: ## %else14
; AVX512VLBW-NEXT:    kshiftrw $6, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB12_14
; AVX512VLBW-NEXT:  ## %bb.13: ## %cond.store16
; AVX512VLBW-NEXT:    vpextrb $6, %xmm0, (%rdi)
; AVX512VLBW-NEXT:    incq %rdi
; AVX512VLBW-NEXT:  LBB12_14: ## %else17
; AVX512VLBW-NEXT:    kshiftrw $7, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB12_16
; AVX512VLBW-NEXT:  ## %bb.15: ## %cond.store19
; AVX512VLBW-NEXT:    vpextrb $7, %xmm0, (%rdi)
; AVX512VLBW-NEXT:    incq %rdi
; AVX512VLBW-NEXT:  LBB12_16: ## %else20
; AVX512VLBW-NEXT:    kshiftrw $8, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB12_18
; AVX512VLBW-NEXT:  ## %bb.17: ## %cond.store22
; AVX512VLBW-NEXT:    vpextrb $8, %xmm0, (%rdi)
; AVX512VLBW-NEXT:    incq %rdi
; AVX512VLBW-NEXT:  LBB12_18: ## %else23
; AVX512VLBW-NEXT:    kshiftrw $9, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB12_20
; AVX512VLBW-NEXT:  ## %bb.19: ## %cond.store25
; AVX512VLBW-NEXT:    vpextrb $9, %xmm0, (%rdi)
; AVX512VLBW-NEXT:    incq %rdi
; AVX512VLBW-NEXT:  LBB12_20: ## %else26
; AVX512VLBW-NEXT:    kshiftrw $10, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB12_22
; AVX512VLBW-NEXT:  ## %bb.21: ## %cond.store28
; AVX512VLBW-NEXT:    vpextrb $10, %xmm0, (%rdi)
; AVX512VLBW-NEXT:    incq %rdi
; AVX512VLBW-NEXT:  LBB12_22: ## %else29
; AVX512VLBW-NEXT:    kshiftrw $11, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB12_24
; AVX512VLBW-NEXT:  ## %bb.23: ## %cond.store31
; AVX512VLBW-NEXT:    vpextrb $11, %xmm0, (%rdi)
; AVX512VLBW-NEXT:    incq %rdi
; AVX512VLBW-NEXT:  LBB12_24: ## %else32
; AVX512VLBW-NEXT:    kshiftrw $12, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB12_26
; AVX512VLBW-NEXT:  ## %bb.25: ## %cond.store34
; AVX512VLBW-NEXT:    vpextrb $12, %xmm0, (%rdi)
; AVX512VLBW-NEXT:    incq %rdi
; AVX512VLBW-NEXT:  LBB12_26: ## %else35
; AVX512VLBW-NEXT:    kshiftrw $13, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB12_28
; AVX512VLBW-NEXT:  ## %bb.27: ## %cond.store37
; AVX512VLBW-NEXT:    vpextrb $13, %xmm0, (%rdi)
; AVX512VLBW-NEXT:    incq %rdi
; AVX512VLBW-NEXT:  LBB12_28: ## %else38
; AVX512VLBW-NEXT:    kshiftrw $14, %k0, %k1
; AVX512VLBW-NEXT:    kmovd %k1, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB12_30
; AVX512VLBW-NEXT:  ## %bb.29: ## %cond.store40
; AVX512VLBW-NEXT:    vpextrb $14, %xmm0, (%rdi)
; AVX512VLBW-NEXT:    incq %rdi
; AVX512VLBW-NEXT:  LBB12_30: ## %else41
; AVX512VLBW-NEXT:    kshiftrw $15, %k0, %k0
; AVX512VLBW-NEXT:    kmovd %k0, %eax
; AVX512VLBW-NEXT:    testb $1, %al
; AVX512VLBW-NEXT:    je LBB12_32
; AVX512VLBW-NEXT:  ## %bb.31: ## %cond.store43
; AVX512VLBW-NEXT:    vpextrb $15, %xmm0, (%rdi)
; AVX512VLBW-NEXT:  LBB12_32: ## %else44
; AVX512VLBW-NEXT:    retq
  %mask = icmp eq <16 x i8> %trigger, zeroinitializer
  call void @llvm.masked.compressstore.v16i8(<16 x i8> %V, i8* %base, <16 x i1> %mask)
  ret void
}

declare void @llvm.masked.compressstore.v16f64(<16 x double>, double*, <16 x i1>)
declare void @llvm.masked.compressstore.v8f64(<8 x double>, double*, <8 x i1>)
declare void @llvm.masked.compressstore.v4f64(<4 x double>, double*, <4 x i1>)
declare void @llvm.masked.compressstore.v2f64(<2 x double>, double*, <2 x i1>)
declare void @llvm.masked.compressstore.v1f64(<1 x double>, double*, <1 x i1>)

declare void @llvm.masked.compressstore.v32f32(<32 x float>, float*, <32 x i1>)
declare void @llvm.masked.compressstore.v16f32(<16 x float>, float*, <16 x i1>)
declare void @llvm.masked.compressstore.v8f32(<8 x float>, float*, <8 x i1>)
declare void @llvm.masked.compressstore.v4f32(<4 x float>, float*, <4 x i1>)
declare void @llvm.masked.compressstore.v2f32(<2 x float>, float*, <2 x i1>)

declare void @llvm.masked.compressstore.v8i64(<8 x i64>, i64*, <8 x i1>)
declare void @llvm.masked.compressstore.v4i64(<4 x i64>, i64*, <4 x i1>)
declare void @llvm.masked.compressstore.v2i64(<2 x i64>, i64*, <2 x i1>)
declare void @llvm.masked.compressstore.v1i64(<1 x i64>, i64*, <1 x i1>)

declare void @llvm.masked.compressstore.v16i32(<16 x i32>, i32*, <16 x i1>)
declare void @llvm.masked.compressstore.v8i32(<8 x i32>, i32*, <8 x i1>)
declare void @llvm.masked.compressstore.v4i32(<4 x i32>, i32*, <4 x i1>)
declare void @llvm.masked.compressstore.v2i32(<2 x i32>, i32*, <2 x i1>)

declare void @llvm.masked.compressstore.v32i16(<32 x i16>, i16*, <32 x i1>)
declare void @llvm.masked.compressstore.v16i16(<16 x i16>, i16*, <16 x i1>)
declare void @llvm.masked.compressstore.v8i16(<8 x i16>, i16*, <8 x i1>)
declare void @llvm.masked.compressstore.v4i16(<4 x i16>, i16*, <4 x i1>)

declare void @llvm.masked.compressstore.v64i8(<64 x i8>, i8*, <64 x i1>)
declare void @llvm.masked.compressstore.v32i8(<32 x i8>, i8*, <32 x i1>)
declare void @llvm.masked.compressstore.v16i8(<16 x i8>, i8*, <16 x i1>)
declare void @llvm.masked.compressstore.v8i8(<8 x i8>, i8*, <8 x i1>)
