/* valaobjectcreationexpression.c generated by valac, the Vala compiler
 * generated from valaobjectcreationexpression.vala, do not modify */

/* valaobjectcreationexpression.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaObjectCreationExpressionPrivate {
	gboolean _is_yield_expression;
	gboolean _is_chainup;
	gboolean _struct_creation;
	ValaList* argument_list;
	ValaList* object_initializer;
	ValaDataType* _data_type;
	ValaMemberAccess* _member_name;
};

static gint ValaObjectCreationExpression_private_offset;
static gpointer vala_object_creation_expression_parent_class = NULL;
static ValaCallableExpressionIface * vala_object_creation_expression_vala_callable_expression_parent_iface = NULL;

static void vala_object_creation_expression_set_type_reference (ValaObjectCreationExpression* self,
                                                         ValaDataType* value);
static void vala_object_creation_expression_set_member_name (ValaObjectCreationExpression* self,
                                                      ValaMemberAccess* value);
static void vala_object_creation_expression_real_add_argument (ValaCallableExpression* base,
                                                        ValaExpression* arg);
static ValaList* vala_object_creation_expression_real_get_argument_list (ValaCallableExpression* base);
static void vala_object_creation_expression_real_accept (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_accept_children (ValaCodeNode* base,
                                                           ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                              ValaExpression* old_node,
                                                              ValaExpression* new_node);
static gboolean vala_object_creation_expression_real_is_pure (ValaExpression* base);
static gboolean vala_object_creation_expression_real_is_accessible (ValaExpression* base,
                                                             ValaSymbol* sym);
static void vala_object_creation_expression_real_replace_type (ValaCodeNode* base,
                                                        ValaDataType* old_type,
                                                        ValaDataType* new_type);
static gboolean vala_object_creation_expression_real_check (ValaCodeNode* base,
                                                     ValaCodeContext* context);
static void vala_object_creation_expression_real_get_error_types (ValaCodeNode* base,
                                                           ValaCollection* collection,
                                                           ValaSourceReference* source_reference);
static void vala_object_creation_expression_real_emit (ValaCodeNode* base,
                                                ValaCodeGenerator* codegen);
static void vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base,
                                                                 ValaCollection* collection);
static void vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                              ValaCollection* collection);
static gchar* vala_object_creation_expression_real_to_string (ValaCodeNode* base);
static void vala_object_creation_expression_finalize (ValaCodeNode * obj);
static GType vala_object_creation_expression_get_type_once (void);

static inline gpointer
vala_object_creation_expression_get_instance_private (ValaObjectCreationExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaObjectCreationExpression_private_offset);
}

ValaDataType*
vala_object_creation_expression_get_type_reference (ValaObjectCreationExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_object_creation_expression_set_type_reference (ValaObjectCreationExpression* self,
                                                    ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp0_;
	_tmp1_ = self->priv->_data_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

static ValaExpression*
vala_object_creation_expression_real_get_call (ValaCallableExpression* base)
{
	ValaExpression* result;
	ValaObjectCreationExpression* self;
	ValaMemberAccess* _tmp0_;
	ValaMemberAccess* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	_tmp0_ = vala_object_creation_expression_get_member_name (self);
	_tmp1_ = _tmp0_;
	result = (ValaExpression*) _tmp1_;
	return result;
}

ValaMemberAccess*
vala_object_creation_expression_get_member_name (ValaObjectCreationExpression* self)
{
	ValaMemberAccess* result;
	ValaMemberAccess* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

static void
vala_object_creation_expression_set_member_name (ValaObjectCreationExpression* self,
                                                 ValaMemberAccess* value)
{
	ValaMemberAccess* _tmp0_;
	ValaMemberAccess* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
	_tmp1_ = self->priv->_member_name;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

static gboolean
vala_object_creation_expression_real_get_is_yield_expression (ValaCallableExpression* base)
{
	gboolean result;
	ValaObjectCreationExpression* self;
	self = (ValaObjectCreationExpression*) base;
	result = self->priv->_is_yield_expression;
	return result;
}

static void
vala_object_creation_expression_real_set_is_yield_expression (ValaCallableExpression* base,
                                                              gboolean value)
{
	ValaObjectCreationExpression* self;
	self = (ValaObjectCreationExpression*) base;
	self->priv->_is_yield_expression = value;
}

static gboolean
vala_object_creation_expression_real_get_is_chainup (ValaCallableExpression* base)
{
	gboolean result;
	ValaObjectCreationExpression* self;
	self = (ValaObjectCreationExpression*) base;
	result = self->priv->_is_chainup;
	return result;
}

static void
vala_object_creation_expression_real_set_is_chainup (ValaCallableExpression* base,
                                                     gboolean value)
{
	ValaObjectCreationExpression* self;
	self = (ValaObjectCreationExpression*) base;
	self->priv->_is_chainup = value;
}

gboolean
vala_object_creation_expression_get_struct_creation (ValaObjectCreationExpression* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_struct_creation;
	return result;
}

void
vala_object_creation_expression_set_struct_creation (ValaObjectCreationExpression* self,
                                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_struct_creation = value;
}

/**
 * Creates a new object creation expression.
 *
 * @param member_name      object type to create
 * @param source_reference reference to source code
 * @return                 newly created object creation expression
 */
ValaObjectCreationExpression*
vala_object_creation_expression_construct (GType object_type,
                                           ValaMemberAccess* member_name,
                                           ValaSourceReference* source_reference)
{
	ValaObjectCreationExpression* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaObjectCreationExpression*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_object_creation_expression_set_member_name (self, member_name);
	return self;
}

ValaObjectCreationExpression*
vala_object_creation_expression_new (ValaMemberAccess* member_name,
                                     ValaSourceReference* source_reference)
{
	return vala_object_creation_expression_construct (VALA_TYPE_OBJECT_CREATION_EXPRESSION, member_name, source_reference);
}

/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
static void
vala_object_creation_expression_real_add_argument (ValaCallableExpression* base,
                                                   ValaExpression* arg)
{
	ValaObjectCreationExpression * self;
	ValaList* _tmp0_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the argument list.
 *
 * @return argument list
 */
static ValaList*
vala_object_creation_expression_real_get_argument_list (ValaCallableExpression* base)
{
	ValaObjectCreationExpression * self;
	ValaList* _tmp0_;
	ValaList* result;
	self = (ValaObjectCreationExpression*) base;
	_tmp0_ = self->priv->argument_list;
	result = _tmp0_;
	return result;
}

/**
 * Appends the specified member initializer to the object initializer.
 *
 * @param init a member initializer
 */
void
vala_object_creation_expression_add_member_initializer (ValaObjectCreationExpression* self,
                                                        ValaMemberInitializer* init)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (init != NULL);
	_tmp0_ = self->priv->object_initializer;
	vala_collection_add ((ValaCollection*) _tmp0_, init);
	vala_code_node_set_parent_node ((ValaCodeNode*) init, (ValaCodeNode*) self);
}

/**
 * Returns the object initializer.
 *
 * @return member initializer list
 */
ValaList*
vala_object_creation_expression_get_object_initializer (ValaObjectCreationExpression* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->object_initializer;
	result = _tmp0_;
	return result;
}

static void
vala_object_creation_expression_real_accept (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_object_creation_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_object_creation_expression_real_accept_children (ValaCodeNode* base,
                                                      ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaMemberAccess* _tmp5_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		_tmp2_ = vala_object_creation_expression_get_type_reference (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	_tmp4_ = vala_object_creation_expression_get_member_name (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaMemberAccess* _tmp7_;
		_tmp6_ = vala_object_creation_expression_get_member_name (self);
		_tmp7_ = _tmp6_;
		vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp8_;
		gint _arg_size = 0;
		ValaList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _arg_index = 0;
		_tmp8_ = self->priv->argument_list;
		_arg_list = _tmp8_;
		_tmp9_ = _arg_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_arg_size = _tmp11_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			ValaExpression* arg = NULL;
			ValaList* _tmp14_;
			gpointer _tmp15_;
			ValaExpression* _tmp16_;
			_arg_index = _arg_index + 1;
			_tmp12_ = _arg_index;
			_tmp13_ = _arg_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _arg_list;
			_tmp15_ = vala_list_get (_tmp14_, _arg_index);
			arg = (ValaExpression*) _tmp15_;
			_tmp16_ = arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp16_, visitor);
			_vala_code_node_unref0 (arg);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp17_;
		gint _init_size = 0;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _init_index = 0;
		_tmp17_ = self->priv->object_initializer;
		_init_list = _tmp17_;
		_tmp18_ = _init_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_init_size = _tmp20_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp23_;
			gpointer _tmp24_;
			ValaMemberInitializer* _tmp25_;
			_init_index = _init_index + 1;
			_tmp21_ = _init_index;
			_tmp22_ = _init_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _init_list;
			_tmp24_ = vala_list_get (_tmp23_, _init_index);
			init = (ValaMemberInitializer*) _tmp24_;
			_tmp25_ = init;
			vala_code_node_accept ((ValaCodeNode*) _tmp25_, visitor);
			_vala_code_node_unref0 (init);
		}
	}
}

static void
vala_object_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                         ValaExpression* old_node,
                                                         ValaExpression* new_node)
{
	ValaObjectCreationExpression * self;
	gint index = 0;
	ValaList* _tmp0_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp0_, old_node);
	if (index >= 0) {
		ValaList* _tmp1_;
		_tmp1_ = self->priv->argument_list;
		vala_list_set (_tmp1_, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}

static gboolean
vala_object_creation_expression_real_is_pure (ValaExpression* base)
{
	ValaObjectCreationExpression * self;
	gboolean result;
	self = (ValaObjectCreationExpression*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_object_creation_expression_real_is_accessible (ValaExpression* base,
                                                    ValaSymbol* sym)
{
	ValaObjectCreationExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberAccess* _tmp1_;
	ValaMemberAccess* _tmp2_;
	gboolean result;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_object_creation_expression_get_member_name (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaMemberAccess* _tmp3_;
		ValaMemberAccess* _tmp4_;
		_tmp3_ = vala_object_creation_expression_get_member_name (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = !vala_expression_is_accessible ((ValaExpression*) _tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp5_;
		gint _arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _arg_index = 0;
		_tmp5_ = self->priv->argument_list;
		_arg_list = _tmp5_;
		_tmp6_ = _arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_arg_size = _tmp8_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			ValaExpression* arg = NULL;
			ValaList* _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			_arg_index = _arg_index + 1;
			_tmp9_ = _arg_index;
			_tmp10_ = _arg_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _arg_list;
			_tmp12_ = vala_list_get (_tmp11_, _arg_index);
			arg = (ValaExpression*) _tmp12_;
			_tmp13_ = arg;
			if (!vala_expression_is_accessible (_tmp13_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp14_;
		gint _init_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _init_index = 0;
		_tmp14_ = self->priv->object_initializer;
		_init_list = _tmp14_;
		_tmp15_ = _init_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_init_size = _tmp17_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp20_;
			gpointer _tmp21_;
			ValaMemberInitializer* _tmp22_;
			ValaExpression* _tmp23_;
			ValaExpression* _tmp24_;
			_init_index = _init_index + 1;
			_tmp18_ = _init_index;
			_tmp19_ = _init_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _init_list;
			_tmp21_ = vala_list_get (_tmp20_, _init_index);
			init = (ValaMemberInitializer*) _tmp21_;
			_tmp22_ = init;
			_tmp23_ = vala_member_initializer_get_initializer (_tmp22_);
			_tmp24_ = _tmp23_;
			if (!vala_expression_is_accessible (_tmp24_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (init);
				return result;
			}
			_vala_code_node_unref0 (init);
		}
	}
	result = TRUE;
	return result;
}

static void
vala_object_creation_expression_real_replace_type (ValaCodeNode* base,
                                                   ValaDataType* old_type,
                                                   ValaDataType* new_type)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_object_creation_expression_set_type_reference (self, new_type);
	}
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gboolean
vala_object_creation_expression_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context)
{
	ValaObjectCreationExpression * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaMemberAccess* _tmp5_;
	ValaTypeSymbol* type = NULL;
	ValaMemberAccess* _tmp6_;
	ValaMemberAccess* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaSymbol* _tmp9_;
	ValaSymbol* constructor_sym = NULL;
	ValaMemberAccess* _tmp10_;
	ValaMemberAccess* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSymbol* _tmp14_;
	ValaSymbol* type_sym = NULL;
	ValaMemberAccess* _tmp15_;
	ValaMemberAccess* _tmp16_;
	ValaSymbol* _tmp17_;
	ValaSymbol* _tmp18_;
	ValaSymbol* _tmp19_;
	ValaList* type_args = NULL;
	ValaMemberAccess* _tmp20_;
	ValaMemberAccess* _tmp21_;
	ValaList* _tmp22_;
	ValaList* _tmp23_;
	ValaSymbol* _tmp24_;
	ValaSymbol* _tmp46_;
	ValaDataType* _tmp97_;
	ValaDataType* _tmp98_;
	ValaDataType* _tmp99_;
	ValaDataType* _tmp100_;
	ValaDataType* _tmp101_;
	ValaDataType* _tmp102_;
	ValaTypeSymbol* _tmp103_;
	ValaDataType* _tmp209_;
	ValaDataType* _tmp210_;
	gboolean _tmp211_ = FALSE;
	ValaSymbol* _tmp212_;
	ValaSymbol* _tmp213_;
	ValaSymbol* _tmp222_;
	ValaSymbol* _tmp223_;
	ValaTypeSymbol* _tmp476_;
	gboolean _tmp477_;
	gboolean _tmp478_;
	gboolean _tmp566_;
	gboolean _tmp567_;
	gboolean _tmp623_;
	gboolean _tmp624_;
	gboolean result;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_object_creation_expression_get_member_name (self);
	_tmp5_ = _tmp4_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp5_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp6_ = vala_object_creation_expression_get_member_name (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == NULL) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp10_ = vala_object_creation_expression_get_member_name (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _vala_code_node_ref0 (_tmp13_);
	constructor_sym = _tmp14_;
	_tmp15_ = vala_object_creation_expression_get_member_name (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = _vala_code_node_ref0 (_tmp18_);
	type_sym = _tmp19_;
	_tmp20_ = vala_object_creation_expression_get_member_name (self);
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_member_access_get_type_arguments (_tmp21_);
	_tmp23_ = _vala_iterable_ref0 (_tmp22_);
	type_args = _tmp23_;
	_tmp24_ = constructor_sym;
	if (VALA_IS_METHOD (_tmp24_)) {
		ValaSymbol* _tmp25_;
		ValaSymbol* _tmp26_;
		ValaSymbol* _tmp27_;
		ValaSymbol* _tmp28_;
		ValaMethod* constructor = NULL;
		ValaSymbol* _tmp29_;
		ValaMethod* _tmp30_;
		ValaSymbol* _tmp31_;
		ValaMethod* _tmp37_;
		ValaMemberAccess* ma = NULL;
		ValaMemberAccess* _tmp38_;
		ValaMemberAccess* _tmp39_;
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaMemberAccess* _tmp42_;
		_tmp25_ = constructor_sym;
		_tmp26_ = vala_symbol_get_parent_symbol (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = _vala_code_node_ref0 (_tmp27_);
		_vala_code_node_unref0 (type_sym);
		type_sym = _tmp28_;
		_tmp29_ = constructor_sym;
		_tmp30_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, VALA_TYPE_METHOD, ValaMethod));
		constructor = _tmp30_;
		_tmp31_ = constructor_sym;
		if (!VALA_IS_CREATION_METHOD (_tmp31_)) {
			ValaSourceReference* _tmp32_;
			ValaSourceReference* _tmp33_;
			ValaMethod* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp33_ = _tmp32_;
			_tmp34_ = constructor;
			_tmp35_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp34_);
			_tmp36_ = _tmp35_;
			vala_report_error (_tmp33_, "`%s' is not a creation method", _tmp36_);
			_g_free0 (_tmp36_);
			result = FALSE;
			_vala_code_node_unref0 (constructor);
			_vala_iterable_unref0 (type_args);
			_vala_code_node_unref0 (type_sym);
			_vala_code_node_unref0 (constructor_sym);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp37_ = constructor;
		vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp37_);
		_tmp38_ = vala_object_creation_expression_get_member_name (self);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_member_access_get_inner (_tmp39_);
		_tmp41_ = _tmp40_;
		ma = VALA_IS_MEMBER_ACCESS (_tmp41_) ? ((ValaMemberAccess*) _tmp41_) : NULL;
		_tmp42_ = ma;
		if (_tmp42_ != NULL) {
			ValaMemberAccess* _tmp43_;
			ValaList* _tmp44_;
			ValaList* _tmp45_;
			_tmp43_ = ma;
			_tmp44_ = vala_member_access_get_type_arguments (_tmp43_);
			_tmp45_ = _vala_iterable_ref0 (_tmp44_);
			_vala_iterable_unref0 (type_args);
			type_args = _tmp45_;
		}
		_vala_code_node_unref0 (constructor);
	}
	_tmp46_ = type_sym;
	if (VALA_IS_CLASS (_tmp46_)) {
		ValaSymbol* _tmp47_;
		ValaTypeSymbol* _tmp48_;
		ValaTypeSymbol* _tmp49_;
		gboolean _tmp50_;
		gboolean _tmp51_;
		_tmp47_ = type_sym;
		_tmp48_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
		_vala_code_node_unref0 (type);
		type = _tmp48_;
		_tmp49_ = type;
		_tmp50_ = vala_class_get_is_error_base (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, VALA_TYPE_CLASS, ValaClass));
		_tmp51_ = _tmp50_;
		if (_tmp51_) {
			ValaSourceReference* _tmp52_;
			ValaSourceReference* _tmp53_;
			ValaErrorType* _tmp54_;
			ValaErrorType* _tmp55_;
			_tmp52_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_error_type_new (NULL, NULL, _tmp53_);
			_tmp55_ = _tmp54_;
			vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp55_);
			_vala_code_node_unref0 (_tmp55_);
		} else {
			ValaTypeSymbol* _tmp56_;
			ValaSourceReference* _tmp57_;
			ValaSourceReference* _tmp58_;
			ValaObjectType* _tmp59_;
			ValaObjectType* _tmp60_;
			_tmp56_ = type;
			_tmp57_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp58_ = _tmp57_;
			_tmp59_ = vala_object_type_new ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, VALA_TYPE_CLASS, ValaClass), _tmp58_);
			_tmp60_ = _tmp59_;
			vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp60_);
			_vala_code_node_unref0 (_tmp60_);
		}
	} else {
		ValaSymbol* _tmp61_;
		_tmp61_ = type_sym;
		if (VALA_IS_STRUCT (_tmp61_)) {
			ValaSymbol* _tmp62_;
			ValaTypeSymbol* _tmp63_;
			ValaTypeSymbol* _tmp64_;
			ValaSourceReference* _tmp65_;
			ValaSourceReference* _tmp66_;
			ValaStructValueType* _tmp67_;
			ValaStructValueType* _tmp68_;
			_tmp62_ = type_sym;
			_tmp63_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
			_vala_code_node_unref0 (type);
			type = _tmp63_;
			_tmp64_ = type;
			_tmp65_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp66_ = _tmp65_;
			_tmp67_ = vala_struct_value_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, VALA_TYPE_STRUCT, ValaStruct), _tmp66_);
			_tmp68_ = _tmp67_;
			vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp68_);
			_vala_code_node_unref0 (_tmp68_);
		} else {
			ValaSymbol* _tmp69_;
			_tmp69_ = type_sym;
			if (VALA_IS_ERROR_CODE (_tmp69_)) {
				ValaSymbol* _tmp70_;
				ValaTypeSymbol* _tmp71_;
				ValaSymbol* _tmp72_;
				ValaSymbol* _tmp73_;
				ValaSymbol* _tmp74_;
				ValaSymbol* _tmp75_;
				ValaSourceReference* _tmp76_;
				ValaSourceReference* _tmp77_;
				ValaErrorType* _tmp78_;
				ValaErrorType* _tmp79_;
				ValaSymbol* _tmp80_;
				_tmp70_ = type_sym;
				_tmp71_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
				_vala_code_node_unref0 (type);
				type = _tmp71_;
				_tmp72_ = type_sym;
				_tmp73_ = vala_symbol_get_parent_symbol (_tmp72_);
				_tmp74_ = _tmp73_;
				_tmp75_ = type_sym;
				_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_error_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain), G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, VALA_TYPE_ERROR_CODE, ValaErrorCode), _tmp77_);
				_tmp79_ = _tmp78_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp79_);
				_vala_code_node_unref0 (_tmp79_);
				_tmp80_ = type_sym;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp80_);
			} else {
				ValaSourceReference* _tmp81_;
				ValaSourceReference* _tmp82_;
				ValaSymbol* _tmp83_;
				gchar* _tmp84_;
				gchar* _tmp85_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp81_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp82_ = _tmp81_;
				_tmp83_ = type_sym;
				_tmp84_ = vala_symbol_get_full_name (_tmp83_);
				_tmp85_ = _tmp84_;
				vala_report_error (_tmp82_, "`%s' is not a class, struct, or error code", _tmp85_);
				_g_free0 (_tmp85_);
				result = FALSE;
				_vala_iterable_unref0 (type_args);
				_vala_code_node_unref0 (type_sym);
				_vala_code_node_unref0 (constructor_sym);
				_vala_code_node_unref0 (type);
				return result;
			}
		}
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp86_;
		gint _type_arg_size = 0;
		ValaList* _tmp87_;
		gint _tmp88_;
		gint _tmp89_;
		gint _type_arg_index = 0;
		_tmp86_ = type_args;
		_type_arg_list = _tmp86_;
		_tmp87_ = _type_arg_list;
		_tmp88_ = vala_collection_get_size ((ValaCollection*) _tmp87_);
		_tmp89_ = _tmp88_;
		_type_arg_size = _tmp89_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp90_;
			gint _tmp91_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp92_;
			gpointer _tmp93_;
			ValaDataType* _tmp94_;
			ValaDataType* _tmp95_;
			ValaDataType* _tmp96_;
			_type_arg_index = _type_arg_index + 1;
			_tmp90_ = _type_arg_index;
			_tmp91_ = _type_arg_size;
			if (!(_tmp90_ < _tmp91_)) {
				break;
			}
			_tmp92_ = _type_arg_list;
			_tmp93_ = vala_list_get (_tmp92_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp93_;
			_tmp94_ = vala_object_creation_expression_get_type_reference (self);
			_tmp95_ = _tmp94_;
			_tmp96_ = type_arg;
			vala_data_type_add_type_argument (_tmp95_, _tmp96_);
			_vala_code_node_unref0 (type_arg);
		}
	}
	_tmp97_ = vala_object_creation_expression_get_type_reference (self);
	_tmp98_ = _tmp97_;
	_tmp99_ = vala_data_type_copy (_tmp98_);
	_tmp100_ = _tmp99_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp100_);
	_vala_code_node_unref0 (_tmp100_);
	_tmp101_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp102_ = _tmp101_;
	vala_data_type_set_value_owned (_tmp102_, TRUE);
	_tmp103_ = type;
	if (VALA_IS_CLASS (_tmp103_)) {
		ValaClass* cl = NULL;
		ValaTypeSymbol* _tmp104_;
		ValaClass* _tmp105_;
		gboolean _tmp106_;
		ValaClass* _tmp109_;
		gboolean _tmp110_;
		gboolean _tmp111_;
		ValaSymbol* _tmp117_;
		ValaSymbol* _tmp118_;
		gboolean _tmp137_ = FALSE;
		ValaSymbol* _tmp138_;
		ValaSymbol* _tmp139_;
		_tmp104_ = type;
		_tmp105_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp104_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp105_;
		_tmp106_ = self->priv->_struct_creation;
		if (_tmp106_) {
			ValaSourceReference* _tmp107_;
			ValaSourceReference* _tmp108_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp107_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp108_ = _tmp107_;
			vala_report_error (_tmp108_, "syntax error, use `new' to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_iterable_unref0 (type_args);
			_vala_code_node_unref0 (type_sym);
			_vala_code_node_unref0 (constructor_sym);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp109_ = cl;
		_tmp110_ = vala_class_get_is_abstract (_tmp109_);
		_tmp111_ = _tmp110_;
		if (_tmp111_) {
			ValaSourceReference* _tmp112_;
			ValaSourceReference* _tmp113_;
			ValaClass* _tmp114_;
			gchar* _tmp115_;
			gchar* _tmp116_;
			vala_expression_set_value_type ((ValaExpression*) self, NULL);
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp112_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp113_ = _tmp112_;
			_tmp114_ = cl;
			_tmp115_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp114_);
			_tmp116_ = _tmp115_;
			vala_report_error (_tmp113_, "Can't create instance of abstract class `%s'", _tmp116_);
			_g_free0 (_tmp116_);
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_iterable_unref0 (type_args);
			_vala_code_node_unref0 (type_sym);
			_vala_code_node_unref0 (constructor_sym);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp117_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp118_ = _tmp117_;
		if (_tmp118_ == NULL) {
			ValaClass* _tmp119_;
			ValaCreationMethod* _tmp120_;
			ValaCreationMethod* _tmp121_;
			ValaSymbol* _tmp122_;
			ValaSymbol* _tmp123_;
			ValaSymbol* _tmp129_;
			ValaSymbol* _tmp130_;
			ValaSymbol* _tmp131_;
			ValaSymbol* _tmp132_;
			ValaVersionAttribute* _tmp133_;
			ValaVersionAttribute* _tmp134_;
			ValaSourceReference* _tmp135_;
			ValaSourceReference* _tmp136_;
			_tmp119_ = cl;
			_tmp120_ = vala_class_get_default_construction_method (_tmp119_);
			_tmp121_ = _tmp120_;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp121_);
			_tmp122_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp123_ = _tmp122_;
			if (_tmp123_ == NULL) {
				ValaSourceReference* _tmp124_;
				ValaSourceReference* _tmp125_;
				ValaClass* _tmp126_;
				gchar* _tmp127_;
				gchar* _tmp128_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp124_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp125_ = _tmp124_;
				_tmp126_ = cl;
				_tmp127_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp126_);
				_tmp128_ = _tmp127_;
				vala_report_error (_tmp125_, "`%s' does not have a default constructor", _tmp128_);
				_g_free0 (_tmp128_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_iterable_unref0 (type_args);
				_vala_code_node_unref0 (type_sym);
				_vala_code_node_unref0 (constructor_sym);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp129_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp130_ = _tmp129_;
			vala_symbol_set_used (_tmp130_, TRUE);
			_tmp131_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp132_ = _tmp131_;
			_tmp133_ = vala_symbol_get_version (_tmp132_);
			_tmp134_ = _tmp133_;
			_tmp135_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp136_ = _tmp135_;
			vala_version_attribute_check (_tmp134_, context, _tmp136_);
		}
		_tmp138_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp139_ = _tmp138_;
		if (_tmp139_ != NULL) {
			gboolean _tmp140_ = FALSE;
			ValaSymbol* _tmp141_;
			ValaSymbol* _tmp142_;
			ValaSymbolAccessibility _tmp143_;
			ValaSymbolAccessibility _tmp144_;
			_tmp141_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp142_ = _tmp141_;
			_tmp143_ = vala_symbol_get_access (_tmp142_);
			_tmp144_ = _tmp143_;
			if (_tmp144_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				_tmp140_ = TRUE;
			} else {
				ValaSymbol* _tmp145_;
				ValaSymbol* _tmp146_;
				ValaSymbolAccessibility _tmp147_;
				ValaSymbolAccessibility _tmp148_;
				_tmp145_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp146_ = _tmp145_;
				_tmp147_ = vala_symbol_get_access (_tmp146_);
				_tmp148_ = _tmp147_;
				_tmp140_ = _tmp148_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
			}
			_tmp137_ = _tmp140_;
		} else {
			_tmp137_ = FALSE;
		}
		if (_tmp137_) {
			gboolean in_target_type = FALSE;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp149_;
				ValaSemanticAnalyzer* _tmp150_;
				ValaSymbol* _tmp151_;
				ValaSymbol* _tmp152_;
				ValaSymbol* _tmp153_;
				_tmp149_ = vala_code_context_get_analyzer (context);
				_tmp150_ = _tmp149_;
				_tmp151_ = vala_semantic_analyzer_get_current_symbol (_tmp150_);
				_tmp152_ = _tmp151_;
				_tmp153_ = _vala_code_node_ref0 (_tmp152_);
				this_symbol = _tmp153_;
				{
					gboolean _tmp154_ = FALSE;
					_tmp154_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp159_;
						ValaSymbol* _tmp160_;
						ValaClass* _tmp161_;
						if (!_tmp154_) {
							ValaSymbol* _tmp155_;
							ValaSymbol* _tmp156_;
							ValaSymbol* _tmp157_;
							ValaSymbol* _tmp158_;
							_tmp155_ = this_symbol;
							_tmp156_ = vala_symbol_get_parent_symbol (_tmp155_);
							_tmp157_ = _tmp156_;
							_tmp158_ = _vala_code_node_ref0 (_tmp157_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp158_;
						}
						_tmp154_ = FALSE;
						_tmp159_ = this_symbol;
						if (!(_tmp159_ != NULL)) {
							break;
						}
						_tmp160_ = this_symbol;
						_tmp161_ = cl;
						if (_tmp160_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp161_, VALA_TYPE_SYMBOL, ValaSymbol)) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp162_;
				ValaSourceReference* _tmp163_;
				ValaSymbol* _tmp164_;
				ValaSymbol* _tmp165_;
				gchar* _tmp166_;
				gchar* _tmp167_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp162_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp163_ = _tmp162_;
				_tmp164_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp165_ = _tmp164_;
				_tmp166_ = vala_symbol_get_full_name (_tmp165_);
				_tmp167_ = _tmp166_;
				vala_report_error (_tmp163_, "Access to non-public constructor `%s' denied", _tmp167_);
				_g_free0 (_tmp167_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_iterable_unref0 (type_args);
				_vala_code_node_unref0 (type_sym);
				_vala_code_node_unref0 (constructor_sym);
				_vala_code_node_unref0 (type);
				return result;
			}
		}
		while (TRUE) {
			ValaClass* _tmp168_;
			ValaClass* _tmp169_;
			gchar* _tmp170_;
			gchar* _tmp171_;
			gboolean _tmp172_;
			ValaClass* _tmp175_;
			ValaClass* _tmp176_;
			ValaClass* _tmp177_;
			ValaClass* _tmp178_;
			_tmp168_ = cl;
			if (!(_tmp168_ != NULL)) {
				break;
			}
			_tmp169_ = cl;
			_tmp170_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp169_, "CCode", "ref_sink_function", NULL);
			_tmp171_ = _tmp170_;
			_tmp172_ = _tmp171_ != NULL;
			_g_free0 (_tmp171_);
			if (_tmp172_) {
				ValaDataType* _tmp173_;
				ValaDataType* _tmp174_;
				_tmp173_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp174_ = _tmp173_;
				vala_data_type_set_floating_reference (_tmp174_, TRUE);
				break;
			}
			_tmp175_ = cl;
			_tmp176_ = vala_class_get_base_class (_tmp175_);
			_tmp177_ = _tmp176_;
			_tmp178_ = _vala_code_node_ref0 (_tmp177_);
			_vala_code_node_unref0 (cl);
			cl = _tmp178_;
		}
		_vala_code_node_unref0 (cl);
	} else {
		ValaTypeSymbol* _tmp179_;
		_tmp179_ = type;
		if (VALA_IS_STRUCT (_tmp179_)) {
			ValaStruct* st = NULL;
			ValaTypeSymbol* _tmp180_;
			ValaStruct* _tmp181_;
			gboolean _tmp182_ = FALSE;
			gboolean _tmp183_;
			ValaSymbol* _tmp188_;
			ValaSymbol* _tmp189_;
			gboolean _tmp193_ = FALSE;
			gboolean _tmp194_ = FALSE;
			gboolean _tmp195_ = FALSE;
			ValaProfile _tmp196_;
			ValaProfile _tmp197_;
			_tmp180_ = type;
			_tmp181_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp180_, VALA_TYPE_STRUCT, ValaStruct));
			st = _tmp181_;
			_tmp183_ = self->priv->_struct_creation;
			if (!_tmp183_) {
				gboolean _tmp184_;
				gboolean _tmp185_;
				_tmp184_ = vala_code_context_get_deprecated (context);
				_tmp185_ = _tmp184_;
				_tmp182_ = !_tmp185_;
			} else {
				_tmp182_ = FALSE;
			}
			if (_tmp182_) {
				ValaSourceReference* _tmp186_;
				ValaSourceReference* _tmp187_;
				_tmp186_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp187_ = _tmp186_;
				vala_report_warning (_tmp187_, "deprecated syntax, don't use `new' to initialize structs");
			}
			_tmp188_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp189_ = _tmp188_;
			if (_tmp189_ == NULL) {
				ValaStruct* _tmp190_;
				ValaCreationMethod* _tmp191_;
				ValaCreationMethod* _tmp192_;
				_tmp190_ = st;
				_tmp191_ = vala_struct_get_default_construction_method (_tmp190_);
				_tmp192_ = _tmp191_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp192_);
			}
			_tmp196_ = vala_code_context_get_profile (context);
			_tmp197_ = _tmp196_;
			if (_tmp197_ == VALA_PROFILE_GOBJECT) {
				ValaStruct* _tmp198_;
				_tmp198_ = st;
				_tmp195_ = vala_struct_is_simple_type (_tmp198_);
			} else {
				_tmp195_ = FALSE;
			}
			if (_tmp195_) {
				ValaSymbol* _tmp199_;
				ValaSymbol* _tmp200_;
				_tmp199_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp200_ = _tmp199_;
				_tmp194_ = _tmp200_ == NULL;
			} else {
				_tmp194_ = FALSE;
			}
			if (_tmp194_) {
				ValaList* _tmp201_;
				gint _tmp202_;
				gint _tmp203_;
				_tmp201_ = self->priv->object_initializer;
				_tmp202_ = vala_collection_get_size ((ValaCollection*) _tmp201_);
				_tmp203_ = _tmp202_;
				_tmp193_ = _tmp203_ == 0;
			} else {
				_tmp193_ = FALSE;
			}
			if (_tmp193_) {
				ValaSourceReference* _tmp204_;
				ValaSourceReference* _tmp205_;
				ValaStruct* _tmp206_;
				gchar* _tmp207_;
				gchar* _tmp208_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp204_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp205_ = _tmp204_;
				_tmp206_ = st;
				_tmp207_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp206_);
				_tmp208_ = _tmp207_;
				vala_report_error (_tmp205_, "`%s' does not have a default constructor", _tmp208_);
				_g_free0 (_tmp208_);
				result = FALSE;
				_vala_code_node_unref0 (st);
				_vala_iterable_unref0 (type_args);
				_vala_code_node_unref0 (type_sym);
				_vala_code_node_unref0 (constructor_sym);
				_vala_code_node_unref0 (type);
				return result;
			}
			_vala_code_node_unref0 (st);
		}
	}
	_tmp209_ = vala_object_creation_expression_get_type_reference (self);
	_tmp210_ = _tmp209_;
	if (!vala_data_type_check_type_arguments (_tmp210_, context, FALSE)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_iterable_unref0 (type_args);
		_vala_code_node_unref0 (type_sym);
		_vala_code_node_unref0 (constructor_sym);
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp212_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp213_ = _tmp212_;
	if (_tmp213_ == NULL) {
		ValaList* _tmp214_;
		gint _tmp215_;
		gint _tmp216_;
		_tmp214_ = self->priv->argument_list;
		_tmp215_ = vala_collection_get_size ((ValaCollection*) _tmp214_);
		_tmp216_ = _tmp215_;
		_tmp211_ = _tmp216_ != 0;
	} else {
		_tmp211_ = FALSE;
	}
	if (_tmp211_) {
		ValaSourceReference* _tmp217_;
		ValaSourceReference* _tmp218_;
		ValaTypeSymbol* _tmp219_;
		gchar* _tmp220_;
		gchar* _tmp221_;
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp217_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp218_ = _tmp217_;
		_tmp219_ = type;
		_tmp220_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp219_);
		_tmp221_ = _tmp220_;
		vala_report_error (_tmp218_, "No arguments allowed when constructing type `%s'", _tmp221_);
		_g_free0 (_tmp221_);
		result = FALSE;
		_vala_iterable_unref0 (type_args);
		_vala_code_node_unref0 (type_sym);
		_vala_code_node_unref0 (constructor_sym);
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp222_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp223_ = _tmp222_;
	if (VALA_IS_METHOD (_tmp223_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp224_;
		ValaSymbol* _tmp225_;
		ValaMethod* _tmp226_;
		gboolean _tmp227_;
		gboolean _tmp228_;
		ValaExpression* last_arg = NULL;
		ValaIterator* arg_it = NULL;
		ValaList* _tmp253_;
		ValaIterator* _tmp254_;
		ValaMethod* _tmp305_;
		gboolean _tmp306_;
		gboolean _tmp307_;
		ValaSemanticAnalyzer* _tmp370_;
		ValaSemanticAnalyzer* _tmp371_;
		ValaMethod* _tmp372_;
		ValaMethodType* _tmp373_;
		ValaMethodType* _tmp374_;
		ValaMethod* _tmp375_;
		ValaList* _tmp376_;
		ValaList* _tmp377_;
		_tmp224_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp225_ = _tmp224_;
		_tmp226_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp225_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp226_;
		_tmp227_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
		_tmp228_ = _tmp227_;
		if (_tmp228_) {
			ValaMethod* _tmp229_;
			gboolean _tmp230_;
			gboolean _tmp231_;
			gboolean _tmp234_ = FALSE;
			ValaSemanticAnalyzer* _tmp235_;
			ValaSemanticAnalyzer* _tmp236_;
			ValaMethod* _tmp237_;
			ValaMethod* _tmp238_;
			_tmp229_ = m;
			_tmp230_ = vala_method_get_coroutine (_tmp229_);
			_tmp231_ = _tmp230_;
			if (!_tmp231_) {
				ValaSourceReference* _tmp232_;
				ValaSourceReference* _tmp233_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp232_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp233_ = _tmp232_;
				vala_report_error (_tmp233_, "yield expression requires async method");
			}
			_tmp235_ = vala_code_context_get_analyzer (context);
			_tmp236_ = _tmp235_;
			_tmp237_ = vala_semantic_analyzer_get_current_method (_tmp236_);
			_tmp238_ = _tmp237_;
			if (_tmp238_ == NULL) {
				_tmp234_ = TRUE;
			} else {
				ValaSemanticAnalyzer* _tmp239_;
				ValaSemanticAnalyzer* _tmp240_;
				ValaMethod* _tmp241_;
				ValaMethod* _tmp242_;
				gboolean _tmp243_;
				gboolean _tmp244_;
				_tmp239_ = vala_code_context_get_analyzer (context);
				_tmp240_ = _tmp239_;
				_tmp241_ = vala_semantic_analyzer_get_current_method (_tmp240_);
				_tmp242_ = _tmp241_;
				_tmp243_ = vala_method_get_coroutine (_tmp242_);
				_tmp244_ = _tmp243_;
				_tmp234_ = !_tmp244_;
			}
			if (_tmp234_) {
				ValaSourceReference* _tmp245_;
				ValaSourceReference* _tmp246_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp245_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp246_ = _tmp245_;
				vala_report_error (_tmp246_, "yield expression not available outside async method");
			}
		} else {
			ValaMethod* _tmp247_;
			_tmp247_ = m;
			if (VALA_IS_CREATION_METHOD (_tmp247_)) {
				ValaMethod* _tmp248_;
				gboolean _tmp249_;
				gboolean _tmp250_;
				_tmp248_ = m;
				_tmp249_ = vala_method_get_coroutine (_tmp248_);
				_tmp250_ = _tmp249_;
				if (_tmp250_) {
					ValaSourceReference* _tmp251_;
					ValaSourceReference* _tmp252_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp251_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp252_ = _tmp251_;
					vala_report_error (_tmp252_, "missing `yield' before async creation expression");
				}
			}
		}
		last_arg = NULL;
		_tmp253_ = self->priv->argument_list;
		_tmp254_ = vala_iterable_iterator ((ValaIterable*) _tmp253_);
		arg_it = _tmp254_;
		{
			ValaList* _param_list = NULL;
			ValaMethod* _tmp255_;
			ValaList* _tmp256_;
			gint _param_size = 0;
			ValaList* _tmp257_;
			gint _tmp258_;
			gint _tmp259_;
			gint _param_index = 0;
			_tmp255_ = m;
			_tmp256_ = vala_callable_get_parameters ((ValaCallable*) _tmp255_);
			_param_list = _tmp256_;
			_tmp257_ = _param_list;
			_tmp258_ = vala_collection_get_size ((ValaCollection*) _tmp257_);
			_tmp259_ = _tmp258_;
			_param_size = _tmp259_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp260_;
				gint _tmp261_;
				ValaParameter* param = NULL;
				ValaList* _tmp262_;
				gpointer _tmp263_;
				ValaParameter* _tmp264_;
				ValaParameter* _tmp265_;
				gboolean _tmp266_;
				gboolean _tmp267_;
				ValaParameter* _tmp268_;
				gboolean _tmp269_;
				gboolean _tmp270_;
				ValaIterator* _tmp288_;
				_param_index = _param_index + 1;
				_tmp260_ = _param_index;
				_tmp261_ = _param_size;
				if (!(_tmp260_ < _tmp261_)) {
					break;
				}
				_tmp262_ = _param_list;
				_tmp263_ = vala_list_get (_tmp262_, _param_index);
				param = (ValaParameter*) _tmp263_;
				_tmp264_ = param;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp264_, context)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp265_ = param;
				_tmp266_ = vala_parameter_get_ellipsis (_tmp265_);
				_tmp267_ = _tmp266_;
				if (_tmp267_) {
					_vala_code_node_unref0 (param);
					break;
				}
				_tmp268_ = param;
				_tmp269_ = vala_parameter_get_params_array (_tmp268_);
				_tmp270_ = _tmp269_;
				if (_tmp270_) {
					ValaArrayType* array_type = NULL;
					ValaParameter* _tmp271_;
					ValaDataType* _tmp272_;
					ValaDataType* _tmp273_;
					ValaArrayType* _tmp274_;
					_tmp271_ = param;
					_tmp272_ = vala_variable_get_variable_type ((ValaVariable*) _tmp271_);
					_tmp273_ = _tmp272_;
					_tmp274_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp273_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					array_type = _tmp274_;
					while (TRUE) {
						ValaIterator* _tmp275_;
						ValaExpression* arg = NULL;
						ValaIterator* _tmp276_;
						gpointer _tmp277_;
						ValaExpression* _tmp278_;
						ValaArrayType* _tmp279_;
						ValaDataType* _tmp280_;
						ValaDataType* _tmp281_;
						ValaExpression* _tmp282_;
						ValaDataType* _tmp283_;
						ValaDataType* _tmp284_;
						ValaArrayType* _tmp285_;
						gboolean _tmp286_;
						gboolean _tmp287_;
						_tmp275_ = arg_it;
						if (!vala_iterator_next (_tmp275_)) {
							break;
						}
						_tmp276_ = arg_it;
						_tmp277_ = vala_iterator_get (_tmp276_);
						arg = (ValaExpression*) _tmp277_;
						_tmp278_ = arg;
						_tmp279_ = array_type;
						_tmp280_ = vala_array_type_get_element_type (_tmp279_);
						_tmp281_ = _tmp280_;
						vala_expression_set_target_type (_tmp278_, _tmp281_);
						_tmp282_ = arg;
						_tmp283_ = vala_expression_get_target_type (_tmp282_);
						_tmp284_ = _tmp283_;
						_tmp285_ = array_type;
						_tmp286_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp285_);
						_tmp287_ = _tmp286_;
						vala_data_type_set_value_owned (_tmp284_, _tmp287_);
						_vala_code_node_unref0 (arg);
					}
					_vala_code_node_unref0 (array_type);
					_vala_code_node_unref0 (param);
					break;
				}
				_tmp288_ = arg_it;
				if (vala_iterator_next (_tmp288_)) {
					ValaExpression* arg = NULL;
					ValaIterator* _tmp289_;
					gpointer _tmp290_;
					ValaExpression* _tmp291_;
					ValaParameter* _tmp292_;
					ValaDataType* _tmp293_;
					ValaDataType* _tmp294_;
					ValaExpression* _tmp295_;
					ValaExpression* _tmp296_;
					ValaDataType* _tmp297_;
					ValaDataType* _tmp298_;
					ValaDataType* _tmp299_;
					ValaDataType* _tmp300_;
					ValaDataType* _tmp301_;
					ValaDataType* _tmp302_;
					ValaExpression* _tmp303_;
					ValaExpression* _tmp304_;
					_tmp289_ = arg_it;
					_tmp290_ = vala_iterator_get (_tmp289_);
					arg = (ValaExpression*) _tmp290_;
					_tmp291_ = arg;
					_tmp292_ = param;
					_tmp293_ = vala_variable_get_variable_type ((ValaVariable*) _tmp292_);
					_tmp294_ = _tmp293_;
					vala_expression_set_formal_target_type (_tmp291_, _tmp294_);
					_tmp295_ = arg;
					_tmp296_ = arg;
					_tmp297_ = vala_expression_get_formal_target_type (_tmp296_);
					_tmp298_ = _tmp297_;
					_tmp299_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp300_ = _tmp299_;
					_tmp301_ = vala_data_type_get_actual_type (_tmp298_, _tmp300_, NULL, (ValaCodeNode*) self);
					_tmp302_ = _tmp301_;
					vala_expression_set_target_type (_tmp295_, _tmp302_);
					_vala_code_node_unref0 (_tmp302_);
					_tmp303_ = arg;
					_tmp304_ = _vala_code_node_ref0 (_tmp303_);
					_vala_code_node_unref0 (last_arg);
					last_arg = _tmp304_;
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (param);
			}
		}
		_tmp305_ = m;
		_tmp306_ = vala_method_get_printf_format (_tmp305_);
		_tmp307_ = _tmp306_;
		if (_tmp307_) {
			ValaStringLiteral* format_literal = NULL;
			ValaExpression* _tmp308_;
			ValaStringLiteral* _tmp352_;
			format_literal = NULL;
			_tmp308_ = last_arg;
			if (VALA_IS_NULL_LITERAL (_tmp308_)) {
			} else {
				ValaExpression* _tmp309_;
				_tmp309_ = last_arg;
				if (_tmp309_ != NULL) {
					ValaExpression* _tmp310_;
					ValaStringLiteral* _tmp311_;
					gboolean _tmp312_ = FALSE;
					ValaStringLiteral* _tmp313_;
					_tmp310_ = last_arg;
					_tmp311_ = vala_string_literal_get_format_literal (_tmp310_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp311_;
					_tmp313_ = format_literal;
					if (_tmp313_ == NULL) {
						ValaList* _tmp314_;
						gint _tmp315_;
						gint _tmp316_;
						ValaMethod* _tmp317_;
						ValaList* _tmp318_;
						gint _tmp319_;
						gint _tmp320_;
						_tmp314_ = self->priv->argument_list;
						_tmp315_ = vala_collection_get_size ((ValaCollection*) _tmp314_);
						_tmp316_ = _tmp315_;
						_tmp317_ = m;
						_tmp318_ = vala_callable_get_parameters ((ValaCallable*) _tmp317_);
						_tmp319_ = vala_collection_get_size ((ValaCollection*) _tmp318_);
						_tmp320_ = _tmp319_;
						_tmp312_ = _tmp316_ == (_tmp320_ - 1);
					} else {
						_tmp312_ = FALSE;
					}
					if (_tmp312_) {
						ValaStringLiteral* _tmp321_;
						ValaStringLiteral* _tmp322_;
						ValaSemanticAnalyzer* _tmp323_;
						ValaSemanticAnalyzer* _tmp324_;
						ValaDataType* _tmp325_;
						ValaDataType* _tmp326_;
						ValaDataType* _tmp327_;
						ValaList* _tmp328_;
						ValaList* _tmp329_;
						gint _tmp330_;
						gint _tmp331_;
						ValaStringLiteral* _tmp332_;
						ValaList* _tmp333_;
						ValaIterator* _tmp334_;
						_tmp321_ = vala_string_literal_new ("\"%s\"", NULL);
						_vala_code_node_unref0 (format_literal);
						format_literal = _tmp321_;
						_tmp322_ = format_literal;
						_tmp323_ = vala_code_context_get_analyzer (context);
						_tmp324_ = _tmp323_;
						_tmp325_ = _tmp324_->string_type;
						_tmp326_ = vala_data_type_copy (_tmp325_);
						_tmp327_ = _tmp326_;
						vala_expression_set_target_type ((ValaExpression*) _tmp322_, _tmp327_);
						_vala_code_node_unref0 (_tmp327_);
						_tmp328_ = self->priv->argument_list;
						_tmp329_ = self->priv->argument_list;
						_tmp330_ = vala_collection_get_size ((ValaCollection*) _tmp329_);
						_tmp331_ = _tmp330_;
						_tmp332_ = format_literal;
						vala_list_insert (_tmp328_, _tmp331_ - 1, (ValaExpression*) _tmp332_);
						_tmp333_ = self->priv->argument_list;
						_tmp334_ = vala_iterable_iterator ((ValaIterable*) _tmp333_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp334_;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp335_;
							ValaList* _tmp336_;
							gint _param_size = 0;
							ValaList* _tmp337_;
							gint _tmp338_;
							gint _tmp339_;
							gint _param_index = 0;
							_tmp335_ = m;
							_tmp336_ = vala_callable_get_parameters ((ValaCallable*) _tmp335_);
							_param_list = _tmp336_;
							_tmp337_ = _param_list;
							_tmp338_ = vala_collection_get_size ((ValaCollection*) _tmp337_);
							_tmp339_ = _tmp338_;
							_param_size = _tmp339_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp340_;
								gint _tmp341_;
								ValaParameter* param = NULL;
								ValaList* _tmp342_;
								gpointer _tmp343_;
								gboolean _tmp344_ = FALSE;
								ValaParameter* _tmp345_;
								gboolean _tmp346_;
								gboolean _tmp347_;
								ValaIterator* _tmp351_;
								_param_index = _param_index + 1;
								_tmp340_ = _param_index;
								_tmp341_ = _param_size;
								if (!(_tmp340_ < _tmp341_)) {
									break;
								}
								_tmp342_ = _param_list;
								_tmp343_ = vala_list_get (_tmp342_, _param_index);
								param = (ValaParameter*) _tmp343_;
								_tmp345_ = param;
								_tmp346_ = vala_parameter_get_ellipsis (_tmp345_);
								_tmp347_ = _tmp346_;
								if (_tmp347_) {
									_tmp344_ = TRUE;
								} else {
									ValaParameter* _tmp348_;
									gboolean _tmp349_;
									gboolean _tmp350_;
									_tmp348_ = param;
									_tmp349_ = vala_parameter_get_params_array (_tmp348_);
									_tmp350_ = _tmp349_;
									_tmp344_ = _tmp350_;
								}
								if (_tmp344_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp351_ = arg_it;
								vala_iterator_next (_tmp351_);
								_vala_code_node_unref0 (param);
							}
						}
					}
				}
			}
			_tmp352_ = format_literal;
			if (_tmp352_ != NULL) {
				gchar* format = NULL;
				ValaStringLiteral* _tmp353_;
				gchar* _tmp354_;
				ValaSemanticAnalyzer* _tmp355_;
				ValaSemanticAnalyzer* _tmp356_;
				const gchar* _tmp357_;
				ValaIterator* _tmp358_;
				ValaSourceReference* _tmp359_;
				ValaSourceReference* _tmp360_;
				_tmp353_ = format_literal;
				_tmp354_ = vala_string_literal_eval (_tmp353_);
				format = _tmp354_;
				_tmp355_ = vala_code_context_get_analyzer (context);
				_tmp356_ = _tmp355_;
				_tmp357_ = format;
				_tmp358_ = arg_it;
				_tmp359_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp360_ = _tmp359_;
				if (!vala_semantic_analyzer_check_print_format (_tmp356_, _tmp357_, _tmp358_, _tmp360_)) {
					result = FALSE;
					_g_free0 (format);
					_vala_code_node_unref0 (format_literal);
					_vala_iterator_unref0 (arg_it);
					_vala_code_node_unref0 (last_arg);
					_vala_code_node_unref0 (m);
					_vala_iterable_unref0 (type_args);
					_vala_code_node_unref0 (type_sym);
					_vala_code_node_unref0 (constructor_sym);
					_vala_code_node_unref0 (type);
					return result;
				}
				_g_free0 (format);
			}
			_vala_code_node_unref0 (format_literal);
		}
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp361_;
			gint _arg_size = 0;
			ValaList* _tmp362_;
			gint _tmp363_;
			gint _tmp364_;
			gint _arg_index = 0;
			_tmp361_ = self->priv->argument_list;
			_arg_list = _tmp361_;
			_tmp362_ = _arg_list;
			_tmp363_ = vala_collection_get_size ((ValaCollection*) _tmp362_);
			_tmp364_ = _tmp363_;
			_arg_size = _tmp364_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp365_;
				gint _tmp366_;
				ValaExpression* arg = NULL;
				ValaList* _tmp367_;
				gpointer _tmp368_;
				ValaExpression* _tmp369_;
				_arg_index = _arg_index + 1;
				_tmp365_ = _arg_index;
				_tmp366_ = _arg_size;
				if (!(_tmp365_ < _tmp366_)) {
					break;
				}
				_tmp367_ = _arg_list;
				_tmp368_ = vala_list_get (_tmp367_, _arg_index);
				arg = (ValaExpression*) _tmp368_;
				_tmp369_ = arg;
				vala_code_node_check ((ValaCodeNode*) _tmp369_, context);
				_vala_code_node_unref0 (arg);
			}
		}
		_tmp370_ = vala_code_context_get_analyzer (context);
		_tmp371_ = _tmp370_;
		_tmp372_ = m;
		_tmp373_ = vala_method_type_new (_tmp372_, NULL);
		_tmp374_ = _tmp373_;
		_tmp375_ = m;
		_tmp376_ = vala_callable_get_parameters ((ValaCallable*) _tmp375_);
		_tmp377_ = self->priv->argument_list;
		vala_semantic_analyzer_check_arguments (_tmp371_, (ValaExpression*) self, (ValaDataType*) _tmp374_, _tmp376_, _tmp377_);
		_vala_code_node_unref0 (_tmp374_);
		_vala_iterator_unref0 (arg_it);
		_vala_code_node_unref0 (last_arg);
		_vala_code_node_unref0 (m);
	} else {
		ValaDataType* _tmp378_;
		ValaDataType* _tmp379_;
		_tmp378_ = vala_object_creation_expression_get_type_reference (self);
		_tmp379_ = _tmp378_;
		if (VALA_IS_ERROR_TYPE (_tmp379_)) {
			ValaDataType* _tmp380_;
			ValaDataType* _tmp381_;
			ValaMemberAccess* _tmp384_;
			ValaMemberAccess* _tmp385_;
			ValaList* _tmp406_;
			gint _tmp407_;
			gint _tmp408_;
			_tmp380_ = vala_object_creation_expression_get_type_reference (self);
			_tmp381_ = _tmp380_;
			if (_tmp381_ != NULL) {
				ValaDataType* _tmp382_;
				ValaDataType* _tmp383_;
				_tmp382_ = vala_object_creation_expression_get_type_reference (self);
				_tmp383_ = _tmp382_;
				vala_code_node_check ((ValaCodeNode*) _tmp383_, context);
			}
			_tmp384_ = vala_object_creation_expression_get_member_name (self);
			_tmp385_ = _tmp384_;
			if (_tmp385_ != NULL) {
				ValaMemberAccess* _tmp386_;
				ValaMemberAccess* _tmp387_;
				_tmp386_ = vala_object_creation_expression_get_member_name (self);
				_tmp387_ = _tmp386_;
				vala_code_node_check ((ValaCodeNode*) _tmp387_, context);
			}
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp388_;
				gint _arg_size = 0;
				ValaList* _tmp389_;
				gint _tmp390_;
				gint _tmp391_;
				gint _arg_index = 0;
				_tmp388_ = self->priv->argument_list;
				_arg_list = _tmp388_;
				_tmp389_ = _arg_list;
				_tmp390_ = vala_collection_get_size ((ValaCollection*) _tmp389_);
				_tmp391_ = _tmp390_;
				_arg_size = _tmp391_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp392_;
					gint _tmp393_;
					ValaExpression* arg = NULL;
					ValaList* _tmp394_;
					gpointer _tmp395_;
					ValaExpression* _tmp396_;
					_arg_index = _arg_index + 1;
					_tmp392_ = _arg_index;
					_tmp393_ = _arg_size;
					if (!(_tmp392_ < _tmp393_)) {
						break;
					}
					_tmp394_ = _arg_list;
					_tmp395_ = vala_list_get (_tmp394_, _arg_index);
					arg = (ValaExpression*) _tmp395_;
					_tmp396_ = arg;
					vala_code_node_check ((ValaCodeNode*) _tmp396_, context);
					_vala_code_node_unref0 (arg);
				}
			}
			{
				ValaList* _init_list = NULL;
				ValaList* _tmp397_;
				gint _init_size = 0;
				ValaList* _tmp398_;
				gint _tmp399_;
				gint _tmp400_;
				gint _init_index = 0;
				_tmp397_ = self->priv->object_initializer;
				_init_list = _tmp397_;
				_tmp398_ = _init_list;
				_tmp399_ = vala_collection_get_size ((ValaCollection*) _tmp398_);
				_tmp400_ = _tmp399_;
				_init_size = _tmp400_;
				_init_index = -1;
				while (TRUE) {
					gint _tmp401_;
					gint _tmp402_;
					ValaMemberInitializer* init = NULL;
					ValaList* _tmp403_;
					gpointer _tmp404_;
					ValaMemberInitializer* _tmp405_;
					_init_index = _init_index + 1;
					_tmp401_ = _init_index;
					_tmp402_ = _init_size;
					if (!(_tmp401_ < _tmp402_)) {
						break;
					}
					_tmp403_ = _init_list;
					_tmp404_ = vala_list_get (_tmp403_, _init_index);
					init = (ValaMemberInitializer*) _tmp404_;
					_tmp405_ = init;
					vala_code_node_check ((ValaCodeNode*) _tmp405_, context);
					_vala_code_node_unref0 (init);
				}
			}
			_tmp406_ = self->priv->argument_list;
			_tmp407_ = vala_collection_get_size ((ValaCollection*) _tmp406_);
			_tmp408_ = _tmp407_;
			if (_tmp408_ == 0) {
				ValaSourceReference* _tmp409_;
				ValaSourceReference* _tmp410_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp409_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp410_ = _tmp409_;
				vala_report_error (_tmp410_, "Too few arguments, errors need at least 1 argument");
			} else {
				ValaIterator* arg_it = NULL;
				ValaList* _tmp411_;
				ValaIterator* _tmp412_;
				ValaIterator* _tmp413_;
				ValaExpression* ex = NULL;
				ValaIterator* _tmp414_;
				gpointer _tmp415_;
				gboolean _tmp416_ = FALSE;
				ValaExpression* _tmp417_;
				ValaDataType* _tmp418_;
				ValaDataType* _tmp419_;
				ValaStringLiteral* format_literal = NULL;
				ValaExpression* _tmp428_;
				ValaStringLiteral* _tmp429_;
				ValaStringLiteral* _tmp430_;
				ValaList* _tmp439_;
				ValaIterator* _tmp440_;
				ValaIterator* _tmp441_;
				ValaSemanticAnalyzer* _tmp442_;
				ValaSemanticAnalyzer* _tmp443_;
				ValaIterator* _tmp444_;
				ValaSourceReference* _tmp445_;
				ValaSourceReference* _tmp446_;
				_tmp411_ = self->priv->argument_list;
				_tmp412_ = vala_iterable_iterator ((ValaIterable*) _tmp411_);
				arg_it = _tmp412_;
				_tmp413_ = arg_it;
				vala_iterator_next (_tmp413_);
				_tmp414_ = arg_it;
				_tmp415_ = vala_iterator_get (_tmp414_);
				ex = (ValaExpression*) _tmp415_;
				_tmp417_ = ex;
				_tmp418_ = vala_expression_get_value_type (_tmp417_);
				_tmp419_ = _tmp418_;
				if (_tmp419_ == NULL) {
					_tmp416_ = TRUE;
				} else {
					ValaExpression* _tmp420_;
					ValaDataType* _tmp421_;
					ValaDataType* _tmp422_;
					ValaSemanticAnalyzer* _tmp423_;
					ValaSemanticAnalyzer* _tmp424_;
					ValaDataType* _tmp425_;
					_tmp420_ = ex;
					_tmp421_ = vala_expression_get_value_type (_tmp420_);
					_tmp422_ = _tmp421_;
					_tmp423_ = vala_code_context_get_analyzer (context);
					_tmp424_ = _tmp423_;
					_tmp425_ = _tmp424_->string_type;
					_tmp416_ = !vala_data_type_compatible (_tmp422_, _tmp425_);
				}
				if (_tmp416_) {
					ValaSourceReference* _tmp426_;
					ValaSourceReference* _tmp427_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp426_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp427_ = _tmp426_;
					vala_report_error (_tmp427_, "Invalid type for argument 1");
				}
				_tmp428_ = ex;
				_tmp429_ = vala_string_literal_get_format_literal (_tmp428_);
				format_literal = _tmp429_;
				_tmp430_ = format_literal;
				if (_tmp430_ != NULL) {
					gchar* format = NULL;
					ValaStringLiteral* _tmp431_;
					gchar* _tmp432_;
					ValaSemanticAnalyzer* _tmp433_;
					ValaSemanticAnalyzer* _tmp434_;
					const gchar* _tmp435_;
					ValaIterator* _tmp436_;
					ValaSourceReference* _tmp437_;
					ValaSourceReference* _tmp438_;
					_tmp431_ = format_literal;
					_tmp432_ = vala_string_literal_eval (_tmp431_);
					format = _tmp432_;
					_tmp433_ = vala_code_context_get_analyzer (context);
					_tmp434_ = _tmp433_;
					_tmp435_ = format;
					_tmp436_ = arg_it;
					_tmp437_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp438_ = _tmp437_;
					if (!vala_semantic_analyzer_check_print_format (_tmp434_, _tmp435_, _tmp436_, _tmp438_)) {
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						result = FALSE;
						_g_free0 (format);
						_vala_code_node_unref0 (format_literal);
						_vala_code_node_unref0 (ex);
						_vala_iterator_unref0 (arg_it);
						_vala_iterable_unref0 (type_args);
						_vala_code_node_unref0 (type_sym);
						_vala_code_node_unref0 (constructor_sym);
						_vala_code_node_unref0 (type);
						return result;
					}
					_g_free0 (format);
				}
				_tmp439_ = self->priv->argument_list;
				_tmp440_ = vala_iterable_iterator ((ValaIterable*) _tmp439_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp440_;
				_tmp441_ = arg_it;
				vala_iterator_next (_tmp441_);
				_tmp442_ = vala_code_context_get_analyzer (context);
				_tmp443_ = _tmp442_;
				_tmp444_ = arg_it;
				_tmp445_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp446_ = _tmp445_;
				if (!vala_semantic_analyzer_check_variadic_arguments (_tmp443_, _tmp444_, 1, _tmp446_)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					result = FALSE;
					_vala_code_node_unref0 (format_literal);
					_vala_code_node_unref0 (ex);
					_vala_iterator_unref0 (arg_it);
					_vala_iterable_unref0 (type_args);
					_vala_code_node_unref0 (type_sym);
					_vala_code_node_unref0 (constructor_sym);
					_vala_code_node_unref0 (type);
					return result;
				}
				_vala_code_node_unref0 (format_literal);
				_vala_code_node_unref0 (ex);
				_vala_iterator_unref0 (arg_it);
			}
		}
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp447_;
		gint _arg_size = 0;
		ValaList* _tmp448_;
		gint _tmp449_;
		gint _tmp450_;
		gint _arg_index = 0;
		_tmp447_ = self->priv->argument_list;
		_arg_list = _tmp447_;
		_tmp448_ = _arg_list;
		_tmp449_ = vala_collection_get_size ((ValaCollection*) _tmp448_);
		_tmp450_ = _tmp449_;
		_arg_size = _tmp450_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp451_;
			gint _tmp452_;
			ValaExpression* arg = NULL;
			ValaList* _tmp453_;
			gpointer _tmp454_;
			ValaSizeofExpression* sizeof_expr = NULL;
			ValaExpression* _tmp455_;
			gboolean _tmp456_ = FALSE;
			ValaSizeofExpression* _tmp457_;
			_arg_index = _arg_index + 1;
			_tmp451_ = _arg_index;
			_tmp452_ = _arg_size;
			if (!(_tmp451_ < _tmp452_)) {
				break;
			}
			_tmp453_ = _arg_list;
			_tmp454_ = vala_list_get (_tmp453_, _arg_index);
			arg = (ValaExpression*) _tmp454_;
			_tmp455_ = arg;
			sizeof_expr = VALA_IS_SIZEOF_EXPRESSION (_tmp455_) ? ((ValaSizeofExpression*) _tmp455_) : NULL;
			_tmp457_ = sizeof_expr;
			if (_tmp457_ != NULL) {
				ValaSizeofExpression* _tmp458_;
				ValaDataType* _tmp459_;
				ValaDataType* _tmp460_;
				_tmp458_ = sizeof_expr;
				_tmp459_ = vala_sizeof_expression_get_type_reference (_tmp458_);
				_tmp460_ = _tmp459_;
				_tmp456_ = VALA_IS_GENERIC_TYPE (_tmp460_);
			} else {
				_tmp456_ = FALSE;
			}
			if (_tmp456_) {
				ValaDataType* sizeof_type = NULL;
				ValaSizeofExpression* _tmp461_;
				ValaDataType* _tmp462_;
				ValaDataType* _tmp463_;
				ValaDataType* _tmp464_;
				ValaDataType* _tmp465_;
				ValaDataType* _tmp466_;
				ValaDataType* _tmp467_;
				ValaList* _tmp468_;
				ValaDataType* _tmp469_;
				ValaExpression* _tmp470_;
				ValaDataType* _tmp471_;
				ValaSourceReference* _tmp472_;
				ValaSourceReference* _tmp473_;
				ValaSizeofExpression* _tmp474_;
				ValaSizeofExpression* _tmp475_;
				_tmp461_ = sizeof_expr;
				_tmp462_ = vala_sizeof_expression_get_type_reference (_tmp461_);
				_tmp463_ = _tmp462_;
				_tmp464_ = vala_object_creation_expression_get_type_reference (self);
				_tmp465_ = _tmp464_;
				_tmp466_ = vala_object_creation_expression_get_type_reference (self);
				_tmp467_ = _tmp466_;
				_tmp468_ = vala_data_type_get_type_arguments (_tmp467_);
				_tmp469_ = vala_data_type_get_actual_type (_tmp463_, _tmp465_, _tmp468_, (ValaCodeNode*) self);
				sizeof_type = _tmp469_;
				_tmp470_ = arg;
				_tmp471_ = sizeof_type;
				_tmp472_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp473_ = _tmp472_;
				_tmp474_ = vala_sizeof_expression_new (_tmp471_, _tmp473_);
				_tmp475_ = _tmp474_;
				vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp470_, (ValaExpression*) _tmp475_);
				_vala_code_node_unref0 (_tmp475_);
				_vala_code_node_unref0 (sizeof_type);
			}
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp476_ = type;
	_tmp477_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp476_);
	_tmp478_ = _tmp477_;
	if (!_tmp478_) {
		ValaSemanticAnalyzer* _tmp479_;
		ValaSemanticAnalyzer* _tmp480_;
		ValaDataType* _tmp481_;
		ValaDataType* _tmp482_;
		_tmp479_ = vala_code_context_get_analyzer (context);
		_tmp480_ = _tmp479_;
		_tmp481_ = vala_object_creation_expression_get_type_reference (self);
		_tmp482_ = _tmp481_;
		vala_semantic_analyzer_check_type (_tmp480_, _tmp482_);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp483_;
		gint _init_size = 0;
		ValaList* _tmp484_;
		gint _tmp485_;
		gint _tmp486_;
		gint _init_index = 0;
		_tmp483_ = vala_object_creation_expression_get_object_initializer (self);
		_init_list = _tmp483_;
		_tmp484_ = _init_list;
		_tmp485_ = vala_collection_get_size ((ValaCollection*) _tmp484_);
		_tmp486_ = _tmp485_;
		_init_size = _tmp486_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp487_;
			gint _tmp488_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp489_;
			gpointer _tmp490_;
			ValaMemberInitializer* _tmp491_;
			ValaExpression* _tmp492_;
			ValaExpression* _tmp493_;
			gint index = 0;
			ValaList* _tmp494_;
			ValaMemberInitializer* _tmp495_;
			ValaList* _tmp496_;
			gpointer _tmp497_;
			ValaMemberInitializer* _tmp498_;
			ValaMemberInitializer* inner_mi = NULL;
			ValaMemberInitializer* _tmp499_;
			ValaExpression* _tmp500_;
			ValaExpression* _tmp501_;
			ValaLocalVariable* local = NULL;
			gchar* _tmp508_;
			gchar* _tmp509_;
			ValaMemberInitializer* _tmp510_;
			ValaExpression* _tmp511_;
			ValaExpression* _tmp512_;
			ValaMemberInitializer* _tmp513_;
			ValaExpression* _tmp514_;
			ValaExpression* _tmp515_;
			ValaSourceReference* _tmp516_;
			ValaSourceReference* _tmp517_;
			ValaLocalVariable* _tmp518_;
			ValaLocalVariable* _tmp519_;
			ValaDeclarationStatement* decl = NULL;
			ValaLocalVariable* _tmp520_;
			ValaMemberInitializer* _tmp521_;
			ValaExpression* _tmp522_;
			ValaExpression* _tmp523_;
			ValaSourceReference* _tmp524_;
			ValaSourceReference* _tmp525_;
			ValaDeclarationStatement* _tmp526_;
			ValaDeclarationStatement* _tmp527_;
			ValaSemanticAnalyzer* _tmp528_;
			ValaSemanticAnalyzer* _tmp529_;
			ValaBlock* _tmp530_;
			ValaDeclarationStatement* _tmp531_;
			_init_index = _init_index + 1;
			_tmp487_ = _init_index;
			_tmp488_ = _init_size;
			if (!(_tmp487_ < _tmp488_)) {
				break;
			}
			_tmp489_ = _init_list;
			_tmp490_ = vala_list_get (_tmp489_, _init_index);
			init = (ValaMemberInitializer*) _tmp490_;
			_tmp491_ = init;
			_tmp492_ = vala_member_initializer_get_initializer (_tmp491_);
			_tmp493_ = _tmp492_;
			if (!VALA_IS_MEMBER_INITIALIZER (_tmp493_)) {
				_vala_code_node_unref0 (init);
				continue;
			}
			_tmp494_ = self->priv->object_initializer;
			_tmp495_ = init;
			index = vala_list_index_of (_tmp494_, _tmp495_);
			_tmp496_ = self->priv->object_initializer;
			_tmp497_ = vala_list_remove_at (_tmp496_, index);
			_tmp498_ = (ValaMemberInitializer*) _tmp497_;
			_vala_code_node_unref0 (_tmp498_);
			_vala_assert (index >= 0, "index >= 0");
			_tmp499_ = init;
			_tmp500_ = vala_member_initializer_get_initializer (_tmp499_);
			_tmp501_ = _tmp500_;
			inner_mi = G_TYPE_CHECK_INSTANCE_CAST (_tmp501_, VALA_TYPE_MEMBER_INITIALIZER, ValaMemberInitializer);
			while (TRUE) {
				ValaMemberInitializer* _tmp502_;
				ValaExpression* _tmp503_;
				ValaExpression* _tmp504_;
				ValaMemberInitializer* _tmp505_;
				ValaExpression* _tmp506_;
				ValaExpression* _tmp507_;
				_tmp502_ = inner_mi;
				_tmp503_ = vala_member_initializer_get_initializer (_tmp502_);
				_tmp504_ = _tmp503_;
				if (!VALA_IS_MEMBER_INITIALIZER (_tmp504_)) {
					break;
				}
				_tmp505_ = inner_mi;
				_tmp506_ = vala_member_initializer_get_initializer (_tmp505_);
				_tmp507_ = _tmp506_;
				inner_mi = G_TYPE_CHECK_INSTANCE_CAST (_tmp507_, VALA_TYPE_MEMBER_INITIALIZER, ValaMemberInitializer);
			}
			_tmp508_ = vala_code_node_get_temp_name ();
			_tmp509_ = _tmp508_;
			_tmp510_ = inner_mi;
			_tmp511_ = vala_member_initializer_get_initializer (_tmp510_);
			_tmp512_ = _tmp511_;
			_tmp513_ = inner_mi;
			_tmp514_ = vala_member_initializer_get_initializer (_tmp513_);
			_tmp515_ = _tmp514_;
			_tmp516_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp515_);
			_tmp517_ = _tmp516_;
			_tmp518_ = vala_local_variable_new (NULL, _tmp509_, _tmp512_, _tmp517_);
			_tmp519_ = _tmp518_;
			_g_free0 (_tmp509_);
			local = _tmp519_;
			_tmp520_ = local;
			_tmp521_ = inner_mi;
			_tmp522_ = vala_member_initializer_get_initializer (_tmp521_);
			_tmp523_ = _tmp522_;
			_tmp524_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp523_);
			_tmp525_ = _tmp524_;
			_tmp526_ = vala_declaration_statement_new ((ValaSymbol*) _tmp520_, _tmp525_);
			decl = _tmp526_;
			_tmp527_ = decl;
			vala_code_node_check ((ValaCodeNode*) _tmp527_, context);
			_tmp528_ = vala_code_context_get_analyzer (context);
			_tmp529_ = _tmp528_;
			_tmp530_ = _tmp529_->insert_block;
			_tmp531_ = decl;
			vala_expression_insert_statement ((ValaExpression*) self, _tmp530_, (ValaStatement*) _tmp531_);
			{
				gboolean _tmp532_ = FALSE;
				_tmp532_ = TRUE;
				while (TRUE) {
					ValaMemberInitializer* member_init = NULL;
					ValaMemberInitializer* _tmp534_;
					const gchar* _tmp535_;
					const gchar* _tmp536_;
					ValaLocalVariable* _tmp537_;
					const gchar* _tmp538_;
					const gchar* _tmp539_;
					ValaMemberInitializer* _tmp540_;
					ValaSourceReference* _tmp541_;
					ValaSourceReference* _tmp542_;
					ValaMemberAccess* _tmp543_;
					ValaMemberAccess* _tmp544_;
					ValaMemberInitializer* _tmp545_;
					ValaSourceReference* _tmp546_;
					ValaSourceReference* _tmp547_;
					ValaMemberInitializer* _tmp548_;
					ValaMemberInitializer* _tmp549_;
					ValaList* _tmp550_;
					gint _tmp551_;
					ValaMemberInitializer* _tmp552_;
					ValaMemberInitializer* _tmp553_;
					ValaCodeNode* _tmp554_;
					ValaCodeNode* _tmp555_;
					if (!_tmp532_) {
						ValaMemberInitializer* _tmp533_;
						_tmp533_ = inner_mi;
						if (!(_tmp533_ != NULL)) {
							break;
						}
					}
					_tmp532_ = FALSE;
					_tmp534_ = inner_mi;
					_tmp535_ = vala_member_initializer_get_name (_tmp534_);
					_tmp536_ = _tmp535_;
					_tmp537_ = local;
					_tmp538_ = vala_symbol_get_name ((ValaSymbol*) _tmp537_);
					_tmp539_ = _tmp538_;
					_tmp540_ = inner_mi;
					_tmp541_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp540_);
					_tmp542_ = _tmp541_;
					_tmp543_ = vala_member_access_new (NULL, _tmp539_, _tmp542_);
					_tmp544_ = _tmp543_;
					_tmp545_ = inner_mi;
					_tmp546_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp545_);
					_tmp547_ = _tmp546_;
					_tmp548_ = vala_member_initializer_new (_tmp536_, (ValaExpression*) _tmp544_, _tmp547_);
					_tmp549_ = _tmp548_;
					_vala_code_node_unref0 (_tmp544_);
					member_init = _tmp549_;
					_tmp550_ = self->priv->object_initializer;
					_tmp551_ = index;
					index = _tmp551_ + 1;
					_tmp552_ = member_init;
					vala_list_insert (_tmp550_, _tmp551_, _tmp552_);
					_tmp553_ = inner_mi;
					_tmp554_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp553_);
					_tmp555_ = _tmp554_;
					inner_mi = VALA_IS_MEMBER_INITIALIZER (_tmp555_) ? ((ValaMemberInitializer*) _tmp555_) : NULL;
					_vala_code_node_unref0 (member_init);
				}
			}
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (init);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp556_;
		gint _init_size = 0;
		ValaList* _tmp557_;
		gint _tmp558_;
		gint _tmp559_;
		gint _init_index = 0;
		_tmp556_ = vala_object_creation_expression_get_object_initializer (self);
		_init_list = _tmp556_;
		_tmp557_ = _init_list;
		_tmp558_ = vala_collection_get_size ((ValaCollection*) _tmp557_);
		_tmp559_ = _tmp558_;
		_init_size = _tmp559_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp560_;
			gint _tmp561_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp562_;
			gpointer _tmp563_;
			ValaMemberInitializer* _tmp564_;
			ValaMemberInitializer* _tmp565_;
			_init_index = _init_index + 1;
			_tmp560_ = _init_index;
			_tmp561_ = _init_size;
			if (!(_tmp560_ < _tmp561_)) {
				break;
			}
			_tmp562_ = _init_list;
			_tmp563_ = vala_list_get (_tmp562_, _init_index);
			init = (ValaMemberInitializer*) _tmp563_;
			_tmp564_ = init;
			vala_code_node_set_parent_node ((ValaCodeNode*) _tmp564_, (ValaCodeNode*) self);
			_tmp565_ = init;
			vala_code_node_check ((ValaCodeNode*) _tmp565_, context);
			_vala_code_node_unref0 (init);
		}
	}
	_tmp566_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp567_ = _tmp566_;
	if (_tmp567_) {
		gboolean _tmp568_ = FALSE;
		ValaCodeNode* _tmp569_;
		ValaCodeNode* _tmp570_;
		_tmp569_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp570_ = _tmp569_;
		if (VALA_IS_LOCAL_VARIABLE (_tmp570_)) {
			_tmp568_ = TRUE;
		} else {
			ValaCodeNode* _tmp571_;
			ValaCodeNode* _tmp572_;
			_tmp571_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp572_ = _tmp571_;
			_tmp568_ = VALA_IS_EXPRESSION_STATEMENT (_tmp572_);
		}
		if (_tmp568_) {
		} else {
			ValaSemanticAnalyzer* _tmp573_;
			ValaSemanticAnalyzer* _tmp574_;
			ValaSymbol* _tmp575_;
			ValaSymbol* _tmp576_;
			_tmp573_ = vala_code_context_get_analyzer (context);
			_tmp574_ = _tmp573_;
			_tmp575_ = vala_semantic_analyzer_get_current_symbol (_tmp574_);
			_tmp576_ = _tmp575_;
			if (!VALA_IS_BLOCK (_tmp576_)) {
				ValaSourceReference* _tmp577_;
				ValaSourceReference* _tmp578_;
				_tmp577_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp578_ = _tmp577_;
				vala_report_error (_tmp578_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp579_;
				ValaCodeNode* _tmp580_;
				ValaCodeNode* _tmp581_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp582_;
				ValaDataType* _tmp583_;
				ValaDataType* _tmp584_;
				ValaDataType* _tmp585_;
				gchar* _tmp586_;
				gchar* _tmp587_;
				ValaSourceReference* _tmp588_;
				ValaSourceReference* _tmp589_;
				ValaLocalVariable* _tmp590_;
				ValaLocalVariable* _tmp591_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp592_;
				ValaSourceReference* _tmp593_;
				ValaSourceReference* _tmp594_;
				ValaDeclarationStatement* _tmp595_;
				ValaSemanticAnalyzer* _tmp596_;
				ValaSemanticAnalyzer* _tmp597_;
				ValaBlock* _tmp598_;
				ValaDeclarationStatement* _tmp599_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp600_;
				ValaDataType* _tmp601_;
				ValaDataType* _tmp602_;
				ValaExpression* _tmp603_;
				ValaExpression* _tmp604_;
				ValaDataType* _tmp605_;
				ValaDataType* _tmp606_;
				ValaLocalVariable* _tmp607_;
				ValaDeclarationStatement* _tmp608_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp609_;
				ValaSemanticAnalyzer* _tmp610_;
				ValaSymbol* _tmp611_;
				ValaSymbol* _tmp612_;
				ValaBlock* _tmp613_;
				ValaBlock* _tmp614_;
				ValaLocalVariable* _tmp615_;
				ValaSemanticAnalyzer* _tmp616_;
				ValaSemanticAnalyzer* _tmp617_;
				ValaBlock* _tmp618_;
				ValaLocalVariable* _tmp619_;
				ValaCodeNode* _tmp620_;
				ValaExpression* _tmp621_;
				ValaExpression* _tmp622_;
				_tmp579_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp580_ = _tmp579_;
				_tmp581_ = _vala_code_node_ref0 (_tmp580_);
				old_parent_node = _tmp581_;
				_tmp582_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp583_ = _tmp582_;
				_tmp584_ = vala_data_type_copy (_tmp583_);
				_tmp585_ = _tmp584_;
				_tmp586_ = vala_code_node_get_temp_name ();
				_tmp587_ = _tmp586_;
				_tmp588_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp589_ = _tmp588_;
				_tmp590_ = vala_local_variable_new (_tmp585_, _tmp587_, NULL, _tmp589_);
				_tmp591_ = _tmp590_;
				_g_free0 (_tmp587_);
				_vala_code_node_unref0 (_tmp585_);
				local = _tmp591_;
				_tmp592_ = local;
				_tmp593_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp594_ = _tmp593_;
				_tmp595_ = vala_declaration_statement_new ((ValaSymbol*) _tmp592_, _tmp594_);
				decl = _tmp595_;
				_tmp596_ = vala_code_context_get_analyzer (context);
				_tmp597_ = _tmp596_;
				_tmp598_ = _tmp597_->insert_block;
				_tmp599_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp598_, (ValaStatement*) _tmp599_);
				_tmp600_ = local;
				_tmp601_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp602_ = _tmp601_;
				_tmp603_ = vala_semantic_analyzer_create_temp_access (_tmp600_, _tmp602_);
				temp_access = _tmp603_;
				_tmp604_ = temp_access;
				_tmp605_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
				_tmp606_ = _tmp605_;
				vala_expression_set_formal_target_type (_tmp604_, _tmp606_);
				_tmp607_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp607_, (ValaExpression*) self);
				_tmp608_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp608_, context);
				_tmp609_ = vala_code_context_get_analyzer (context);
				_tmp610_ = _tmp609_;
				_tmp611_ = vala_semantic_analyzer_get_current_symbol (_tmp610_);
				_tmp612_ = _tmp611_;
				_tmp613_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp612_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp613_;
				_tmp614_ = block;
				_tmp615_ = local;
				vala_block_remove_local_variable (_tmp614_, _tmp615_);
				_tmp616_ = vala_code_context_get_analyzer (context);
				_tmp617_ = _tmp616_;
				_tmp618_ = _tmp617_->insert_block;
				_tmp619_ = local;
				vala_block_add_local_variable (_tmp618_, _tmp619_);
				_tmp620_ = old_parent_node;
				_tmp621_ = temp_access;
				vala_code_node_replace_expression (_tmp620_, (ValaExpression*) self, _tmp621_);
				_tmp622_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp622_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp623_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp624_ = _tmp623_;
	result = !_tmp624_;
	_vala_iterable_unref0 (type_args);
	_vala_code_node_unref0 (type_sym);
	_vala_code_node_unref0 (constructor_sym);
	_vala_code_node_unref0 (type);
	return result;
}

static void
vala_object_creation_expression_real_get_error_types (ValaCodeNode* base,
                                                      ValaCollection* collection,
                                                      ValaSourceReference* source_reference)
{
	ValaObjectCreationExpression * self;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	if (VALA_IS_METHOD (_tmp1_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp4_;
		ValaSymbol* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		if (source_reference == NULL) {
			ValaSourceReference* _tmp2_;
			ValaSourceReference* _tmp3_;
			_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp3_ = _tmp2_;
			source_reference = _tmp3_;
		}
		_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp6_;
		_tmp7_ = m;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp7_, collection, source_reference);
		_vala_code_node_unref0 (m);
	}
}

static void
vala_object_creation_expression_real_emit (ValaCodeNode* base,
                                           ValaCodeGenerator* codegen)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			vala_code_node_emit ((ValaCodeNode*) _tmp8_, codegen);
			_vala_code_node_unref0 (arg);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp9_;
		gint _init_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _init_index = 0;
		_tmp9_ = self->priv->object_initializer;
		_init_list = _tmp9_;
		_tmp10_ = _init_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_init_size = _tmp12_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			ValaMemberInitializer* _tmp17_;
			_init_index = _init_index + 1;
			_tmp13_ = _init_index;
			_tmp14_ = _init_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _init_list;
			_tmp16_ = vala_list_get (_tmp15_, _init_index);
			init = (ValaMemberInitializer*) _tmp16_;
			_tmp17_ = init;
			vala_code_node_emit ((ValaCodeNode*) _tmp17_, codegen);
			_vala_code_node_unref0 (init);
		}
	}
	vala_code_visitor_visit_object_creation_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base,
                                                            ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp8_, collection);
			_vala_code_node_unref0 (arg);
		}
	}
}

static void
vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                         ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp8_, collection);
			_vala_code_node_unref0 (arg);
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp9_;
		gint _init_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _init_index = 0;
		_tmp9_ = self->priv->object_initializer;
		_init_list = _tmp9_;
		_tmp10_ = _init_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_init_size = _tmp12_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			ValaMemberInitializer* _tmp17_;
			_init_index = _init_index + 1;
			_tmp13_ = _init_index;
			_tmp14_ = _init_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _init_list;
			_tmp16_ = vala_list_get (_tmp15_, _init_index);
			init = (ValaMemberInitializer*) _tmp16_;
			_tmp17_ = init;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp17_, collection);
			_vala_code_node_unref0 (init);
		}
	}
}

static gchar*
vala_object_creation_expression_real_to_string (ValaCodeNode* base)
{
	ValaObjectCreationExpression * self;
	GString* b = NULL;
	GString* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp4_;
	ValaMemberAccess* _tmp6_;
	ValaMemberAccess* _tmp7_;
	GString* _tmp13_;
	gboolean first = FALSE;
	GString* _tmp27_;
	GString* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* result;
	self = (ValaObjectCreationExpression*) base;
	_tmp0_ = g_string_new ("");
	b = _tmp0_;
	_tmp1_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GString* _tmp3_;
		_tmp3_ = b;
		g_string_append (_tmp3_, "yield ");
	}
	_tmp4_ = self->priv->_struct_creation;
	if (!_tmp4_) {
		GString* _tmp5_;
		_tmp5_ = b;
		g_string_append (_tmp5_, "new ");
	}
	_tmp6_ = vala_object_creation_expression_get_member_name (self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		GString* _tmp8_;
		ValaMemberAccess* _tmp9_;
		ValaMemberAccess* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp8_ = b;
		_tmp9_ = vala_object_creation_expression_get_member_name (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_code_node_to_string ((ValaCodeNode*) _tmp10_);
		_tmp12_ = _tmp11_;
		g_string_append (_tmp8_, _tmp12_);
		_g_free0 (_tmp12_);
	}
	_tmp13_ = b;
	g_string_append_c (_tmp13_, '(');
	first = TRUE;
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp14_;
		gint _expr_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _expr_index = 0;
		_tmp14_ = self->priv->argument_list;
		_expr_list = _tmp14_;
		_tmp15_ = _expr_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_expr_size = _tmp17_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			ValaExpression* expr = NULL;
			ValaList* _tmp20_;
			gpointer _tmp21_;
			GString* _tmp23_;
			ValaExpression* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_expr_index = _expr_index + 1;
			_tmp18_ = _expr_index;
			_tmp19_ = _expr_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _expr_list;
			_tmp21_ = vala_list_get (_tmp20_, _expr_index);
			expr = (ValaExpression*) _tmp21_;
			if (!first) {
				GString* _tmp22_;
				_tmp22_ = b;
				g_string_append (_tmp22_, ", ");
			}
			_tmp23_ = b;
			_tmp24_ = expr;
			_tmp25_ = vala_code_node_to_string ((ValaCodeNode*) _tmp24_);
			_tmp26_ = _tmp25_;
			g_string_append (_tmp23_, _tmp26_);
			_g_free0 (_tmp26_);
			first = FALSE;
			_vala_code_node_unref0 (expr);
		}
	}
	_tmp27_ = b;
	g_string_append_c (_tmp27_, ')');
	_tmp28_ = b;
	_tmp29_ = _tmp28_->str;
	_tmp30_ = g_strdup (_tmp29_);
	result = _tmp30_;
	_g_string_free0 (b);
	return result;
}

static void
vala_object_creation_expression_class_init (ValaObjectCreationExpressionClass * klass,
                                            gpointer klass_data)
{
	vala_object_creation_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_object_creation_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaObjectCreationExpression_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_object_creation_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_object_creation_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_object_creation_expression_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_object_creation_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_object_creation_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_object_creation_expression_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_object_creation_expression_real_check;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_object_creation_expression_real_get_error_types;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_object_creation_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_object_creation_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_object_creation_expression_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_object_creation_expression_real_to_string;
}

static void
vala_object_creation_expression_vala_callable_expression_interface_init (ValaCallableExpressionIface * iface,
                                                                         gpointer iface_data)
{
	vala_object_creation_expression_vala_callable_expression_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_argument = (void (*) (ValaCallableExpression*, ValaExpression*)) vala_object_creation_expression_real_add_argument;
	iface->get_argument_list = (ValaList* (*) (ValaCallableExpression*)) vala_object_creation_expression_real_get_argument_list;
	iface->get_call = vala_object_creation_expression_real_get_call;
	iface->get_is_yield_expression = vala_object_creation_expression_real_get_is_yield_expression;
	iface->set_is_yield_expression = vala_object_creation_expression_real_set_is_yield_expression;
	iface->get_is_chainup = vala_object_creation_expression_real_get_is_chainup;
	iface->set_is_chainup = vala_object_creation_expression_real_set_is_chainup;
}

static void
vala_object_creation_expression_instance_init (ValaObjectCreationExpression * self,
                                               gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = vala_object_creation_expression_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_MEMBER_INITIALIZER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->object_initializer = (ValaList*) _tmp3_;
}

static void
vala_object_creation_expression_finalize (ValaCodeNode * obj)
{
	ValaObjectCreationExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpression);
	_vala_iterable_unref0 (self->priv->argument_list);
	_vala_iterable_unref0 (self->priv->object_initializer);
	_vala_code_node_unref0 (self->priv->_data_type);
	_vala_code_node_unref0 (self->priv->_member_name);
	VALA_CODE_NODE_CLASS (vala_object_creation_expression_parent_class)->finalize (obj);
}

/**
 * Represents an object creation expression in the source code.
 */
static GType
vala_object_creation_expression_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaObjectCreationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_object_creation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaObjectCreationExpression), 0, (GInstanceInitFunc) vala_object_creation_expression_instance_init, NULL };
	static const GInterfaceInfo vala_callable_expression_info = { (GInterfaceInitFunc) vala_object_creation_expression_vala_callable_expression_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_object_creation_expression_type_id;
	vala_object_creation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaObjectCreationExpression", &g_define_type_info, 0);
	g_type_add_interface_static (vala_object_creation_expression_type_id, VALA_TYPE_CALLABLE_EXPRESSION, &vala_callable_expression_info);
	ValaObjectCreationExpression_private_offset = g_type_add_instance_private (vala_object_creation_expression_type_id, sizeof (ValaObjectCreationExpressionPrivate));
	return vala_object_creation_expression_type_id;
}

GType
vala_object_creation_expression_get_type (void)
{
	static volatile gsize vala_object_creation_expression_type_id__once = 0;
	if (g_once_init_enter (&vala_object_creation_expression_type_id__once)) {
		GType vala_object_creation_expression_type_id;
		vala_object_creation_expression_type_id = vala_object_creation_expression_get_type_once ();
		g_once_init_leave (&vala_object_creation_expression_type_id__once, vala_object_creation_expression_type_id);
	}
	return vala_object_creation_expression_type_id__once;
}

