---
title: Licensing advisory
...

# Licensing advisory

## How to license the applications you build with GStreamer

The licensing of GStreamer is no different from a lot of other libraries
out there like GTK+ or glibc: we use the LGPL. What complicates things
with regards to GStreamer is its plugin-based design and the heavily
patented and proprietary nature of many multimedia codecs. While patents
on software are currently only allowed in a small minority of world
countries (the US and Australia being the most important of those), the
problem is that due to the central place the US hold in the world
economy and the computing industry, software patents are hard to ignore
wherever you are. Due to this situation, many companies, including major
GNU/Linux distributions, get trapped in a situation where they either
get bad reviews due to lacking out-of-the-box media playback
capabilities (and attempts to educate the reviewers have met with little
success so far), or go against their own - and the free software
movement's - wish to avoid proprietary software. Due to competitive
pressure, most choose to add some support. Doing that through pure free
software solutions would have them risk heavy litigation and punishment
from patent owners. So when the decision is made to include support for
patented codecs, it leaves them the choice of either using special
proprietary applications, or try to integrate the support for these
codecs through proprietary plugins into the multimedia infrastructure
provided by GStreamer. Faced with one of these two evils the GStreamer
community of course prefer the second option.

The problem which arises is that most free software and open source
applications developed use the GPL as their license. While this is
generally a good thing, it creates a dilemma for people who want to put
together a distribution. The dilemma they face is that if they include
proprietary plugins in GStreamer to support patented formats in a way
that is legal for them, they do risk running afoul of the GPL license of
the applications. We have gotten some conflicting reports from lawyers
on whether this is actually a problem, but the official stance of the
FSF is that it is a problem. We view the FSF as an authority on this
matter, so we are inclined to follow their interpretation of the GPL
license.

So what does this mean for you as an application developer? Well, it
means you have to make an active decision on whether you want your
application to be used together with proprietary plugins or not. What
you decide here will also influence the chances of commercial
distributions and Unix vendors shipping your application. The GStreamer
community suggest you license your software using a license that will
allow proprietary plugins to be bundled with GStreamer and your
applications, in order to make sure that as many vendors as possible go
with GStreamer instead of less free solutions. This in turn we hope and
think will let GStreamer be a vehicle for wider use of free formats like
the Xiph.org formats.

If you do decide that you want to allow for non-free plugins to be used
with your application you have a variety of choices. One of the simplest
is using licenses like LGPL, MPL or BSD for your application instead of
the GPL. Or you can add an exception clause to your GPL license stating
that you except GStreamer plugins from the obligations of the GPL.

A good example of such a GPL exception clause would be, using the Totem
video player project as an example: The authors of the Totem video
player project hereby grants permission for non-GPL-compatible GStreamer
plugins to be used and distributed together with GStreamer and Totem.
This permission goes above and beyond the permissions granted by the GPL
license Totem is covered by.

Our suggestion among these choices is to use the LGPL license, as it is
what resembles the GPL most and it makes it a good licensing fit with
the major GNU/Linux desktop projects like GNOME and KDE. It also allows
you to share code more openly with projects that have compatible
licenses. Obviously, pure GPL code without the above-mentioned clause is
not usable in your application as such. By choosing the LGPL, there is
no need for an exception clause and thus code can be shared more freely.

I have above outlined the practical reasons for why the GStreamer
community suggests you allow non-free plugins to be used with your
applications. We feel that in the multimedia arena, the free software
community is still not strong enough to set the agenda and that blocking
non-free plugins to be used in our infrastructure hurts us more than it
hurts the patent owners and their ilk.

This view is not shared by everyone. The Free Software Foundation urges
you to use an unmodified GPL for your applications, so as to push back
against the temptation to use non-free plug-ins. They say that since not
everyone else has the strength to reject them because they are
unethical, they ask your help to give them a legal reason to do so.

This advisory is part of a bigger advisory with a FAQ which you can find
on the [GStreamer
website](http://gstreamer.freedesktop.org/documentation/licensing.html)
