/*
 * Copyright (c) 2017, the Dart project authors.
 *
 * Licensed under the Eclipse Public License v1.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
package org.dartlang.vm.service;

import com.google.gson.JsonObject;

public interface RemoteServiceCompleter {
  /**
   * Should be called when a service request completes successfully.
   *
   * @param result the result of the request
   */
  void result(JsonObject result);

  /**
   * Should be called when a service request completes with an error.
   *
   * @param code    the error code generated by the request
   * @param message the description of the error
   * @param data    [optional] the description of the error
   */
  void error(int code, String message, JsonObject data);
}
