# Make Autoconf-related libraries.

# Copyright (C) 2001-2005, 2009-2017, 2020-2021 Free Software
# Foundation, Inc.

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

ETAGS_ARGS += $(ETAGS_FOR_AUTOCONF)
TAGS_FILES = # Incrementally updated later.

# Additional checks.
check-local: check-forbidden-patterns
forbidden_patterns = -e '^_*EOF' -e ' cmp '
forbidden_patterns_files = # Incrementally updated later.

## ---------------------------------------------------------------- ##
## Auxiliary perl modules used by autom4te and other perl scripts.  ##
## ---------------------------------------------------------------- ##

perllibdir = $(pkgdatadir)/Autom4te

dist_perllib_DATA = \
  lib/Autom4te/C4che.pm \
  lib/Autom4te/ChannelDefs.pm \
  lib/Autom4te/Channels.pm \
  lib/Autom4te/Config.pm \
  lib/Autom4te/Configure_ac.pm \
  lib/Autom4te/FileUtils.pm \
  lib/Autom4te/General.pm \
  lib/Autom4te/Getopt.pm \
  lib/Autom4te/Request.pm \
  lib/Autom4te/XFile.pm

TAGS_FILES += $(dist_perllib_DATA)
# Note: ETAGS_ARGS should have already been extended to handle perl files.

## ------------------------------------------ ##
## Make Autom4te default configuration file.  ##
## ------------------------------------------ ##

nodist_pkgdata_DATA = lib/autom4te.cfg
EXTRA_DIST += lib/autom4te.in

# All the files below depend on Makefile so that they are rebuilt
# when the prefix, etc. changes. Unfortunately, suffix rules
# cannot have additional dependencies, so we have to use explicit rules.
CLEANFILES += lib/autom4te.cfg
lib/autom4te.cfg: $(srcdir)/lib/autom4te.in Makefile
	rm -f $@ $@-t
	$(MKDIR_P) $(@D)
	$(edit) $(srcdir)/lib/autom4te.in >$@-t
	chmod a-w $@-t
	mv -f $@-t $@

## ----------------------------- ##
## Make Autoconf Emacs library.  ##
## ----------------------------- ##

dist_lisp_LISP = lib/emacs/autoconf-mode.el lib/emacs/autotest-mode.el

# TODO: This is required to work around a limitation in older
#	Automake.  Remove once we can assume Automake 1.13 or later.
CLEANFILES += autoconf-mode.elc autotest-mode.elc

## ----------------------- ##
## Make Autoconf library.  ##
## ----------------------- ##

autoconflibdir = $(pkgdatadir)/autoconf

dist_autoconflib_DATA = \
  lib/autoconf/autoconf.m4 \
  lib/autoconf/general.m4 \
  lib/autoconf/status.m4 \
  lib/autoconf/oldnames.m4 \
  lib/autoconf/specific.m4 \
  lib/autoconf/autoheader.m4 \
  lib/autoconf/autoupdate.m4 \
  lib/autoconf/autotest.m4 \
  lib/autoconf/autoscan.m4 \
  lib/autoconf/lang.m4 \
  lib/autoconf/c.m4 \
  lib/autoconf/erlang.m4 \
  lib/autoconf/fortran.m4 \
  lib/autoconf/functions.m4 \
  lib/autoconf/go.m4 \
  lib/autoconf/headers.m4 \
  lib/autoconf/types.m4 \
  lib/autoconf/libs.m4 \
  lib/autoconf/programs.m4 \
  lib/autoconf/trailer.m4

nodist_autoconflib_DATA = lib/autoconf/autoconf.m4f
CLEANFILES += $(nodist_autoconflib_DATA)

TAGS_FILES += $(dist_autoconflib_DATA)

forbidden_patterns_files += $(dist_autoconflib_DATA)

lib/autoconf/autoconf.m4f: $(autoconf_m4f_dependencies)

## ------------------------ ##
##  Make Autoscan library.  ##
## ------------------------ ##

autoscanlibdir = $(pkgdatadir)/autoscan

EXTRA_DIST += lib/autoscan/autoscan.pre
nodist_autoscanlib_DATA = lib/autoscan/autoscan.list
CLEANFILES += lib/autoscan/autoscan.list

lib/autoscan/autoscan.list: $(srcdir)/lib/autoscan/autoscan.pre
	$(MKDIR_P) $(@D)
	echo '# Automatically Generated: do not edit this file' >$@
	sed '/^[#]/!q' $(srcdir)/lib/autoscan/autoscan.pre >>$@
	( \
	  sed -n '/^[^#]/p' $(srcdir)/lib/autoscan/autoscan.pre; \
	  $(MY_AUTOM4TE) --cache '' -M -l autoconf-without-aclocal-m4 \
	    -t'AN_OUTPUT:$$1: $$2		$$3' \
	) | LC_ALL=C sort >>$@

lib/autoscan/autoscan.list: $(autoconf_m4f_dependencies) Makefile

## ----------------------------------- ##
## Make Autoconf library for M4sugar.  ##
## ----------------------------------- ##

m4sugarlibdir = $(pkgdatadir)/m4sugar

dist_m4sugarlib_DATA = \
  lib/m4sugar/m4sugar.m4 \
  lib/m4sugar/foreach.m4 \
  lib/m4sugar/m4sh.m4

nodist_m4sugarlib_DATA = \
  lib/m4sugar/version.m4 \
  lib/m4sugar/m4sugar.m4f \
  lib/m4sugar/m4sh.m4f

CLEANFILES += $(nodist_m4sugarlib_DATA)

# The ':;' in the second line of the recipe works around a redirected
# compound command bash exit status bug.
lib/m4sugar/version.m4: Makefile
	$(MKDIR_P) $(@D)
	:;{ \
	  echo '# This file is part of -*- Autoconf -*-.' && \
	  echo '# Version of Autoconf.' && \
	  echo '# Copyright (C) 1999, 2000, 2001, 2002, 2006, 2007, 2009' && \
	  echo '# Free Software Foundation, Inc.' && \
	  echo  &&\
	  echo 'm4_define([m4_PACKAGE_NAME],      [$(PACKAGE_NAME)])' && \
	  echo 'm4_define([m4_PACKAGE_TARNAME],   [$(PACKAGE_TARNAME)])' && \
	  echo 'm4_define([m4_PACKAGE_VERSION],   [$(PACKAGE_VERSION)])' && \
	  echo 'm4_define([m4_PACKAGE_STRING],    [$(PACKAGE_STRING)])' && \
	  echo 'm4_define([m4_PACKAGE_BUGREPORT], [$(PACKAGE_BUGREPORT)])' && \
	  echo 'm4_define([m4_PACKAGE_URL],       [$(PACKAGE_URL)])' && \
	  echo 'm4_define([m4_PACKAGE_YEAR],      [$(RELEASE_YEAR)])'; \
	} > $@-t
	mv $@-t $@

TAGS_FILES += $(dist_m4sugarlib_DATA)

forbidden_patterns_files += $(dist_m4sugarlib_DATA)

lib/m4sugar/m4sugar.m4f: $(m4sugar_m4f_dependencies)
lib/m4sugar/m4sh.m4f: $(m4sh_m4f_dependencies)

## ----------------------- ##
## Make Autotest library.  ##
## ----------------------- ##

autotestlibdir = $(pkgdatadir)/autotest

dist_autotestlib_DATA = \
  lib/autotest/autotest.m4 \
  lib/autotest/general.m4 \
  lib/autotest/specific.m4

nodist_autotestlib_DATA = lib/autotest/autotest.m4f
CLEANFILES += $(nodist_autotestlib_DATA)

TAGS_FILES += $(dist_autotestlib_DATA)

forbidden_patterns_files += $(dist_autotestlib_DATA)

lib/autotest/autotest.m4f: $(autotest_m4f_dependencies)

## --------------------------- ##
## Install auxiliary scripts.  ##
## --------------------------- ##

# These are declared as _DATA so that they are not subject to
# --program-transform-name; $(pkgdatadir) is sufficient to keep
# multiple installations separate, and autoreconf looks for them by
# their unadorned names.  However, autoreconf copies the executable
# bit when it copies these files into a source tree, and _DATA items
# are installed as not-executable, so we have to make them executable
# in a hook rule.

AUXSCRIPTS = \
  build-aux/config.guess \
  build-aux/config.sub \
  build-aux/install-sh

buildauxdir = $(pkgdatadir)/build-aux
dist_buildaux_DATA = \
  $(AUXSCRIPTS)

install-data-hook: install-data-hook-make-aux-scripts-executable
install-data-hook-make-aux-scripts-executable:
	for s in $(AUXSCRIPTS); do \
	  chmod +x "$(DESTDIR)$(pkgdatadir)/$$s"; \
	done

.PHONY: install-data-hook install-data-hook-make-aux-scripts-executable
