/* valacompiler.c generated by valac, the Vala compiler
 * generated from valacompiler.vala, do not modify */

/* valacompiler.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 * Copyright (C) 1996-2002, 2004, 2005, 2006 Free Software Foundation, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <stdio.h>
#include <valacodegen.h>
#include <valagee.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <locale.h>
#include <config.h>
#include <gobject/gvaluecollector.h>

#define VALA_COMPILER_DEFAULT_COLORS "error=01;31:warning=01;35:note=01;36:caret=01;32:locus=01:quote=01"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define VALA_TYPE_COMPILER (vala_compiler_get_type ())
#define VALA_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMPILER, ValaCompiler))
#define VALA_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMPILER, ValaCompilerClass))
#define VALA_IS_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMPILER))
#define VALA_IS_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMPILER))
#define VALA_COMPILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMPILER, ValaCompilerClass))

typedef struct _ValaCompiler ValaCompiler;
typedef struct _ValaCompilerClass ValaCompilerClass;
typedef struct _ValaCompilerPrivate ValaCompilerPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_ccode_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_compiler_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_compiler_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _ValaParamSpecCompiler ValaParamSpecCompiler;

struct _ValaCompiler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCompilerPrivate * priv;
};

struct _ValaCompilerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCompiler *self);
};

struct _ValaCompilerPrivate {
	ValaCodeContext* context;
};

struct _Block1Data {
	int _ref_count_;
	GMainLoop* loop;
	gint child_status;
};

struct _ValaParamSpecCompiler {
	GParamSpec parent_instance;
};

static gint ValaCompiler_private_offset;
static gpointer vala_compiler_parent_class = NULL;
static gchar** vala_compiler_vapi_directories;
static gchar** vala_compiler_gir_directories;
static gchar** vala_compiler_metadata_directories;
static gchar** vala_compiler_packages;
static gchar* vala_compiler_vapi_filename;
static gchar* vala_compiler_library;
static gchar* vala_compiler_shared_library;
static gchar* vala_compiler_gir;
static gchar* vala_compiler_basedir;
static gchar* vala_compiler_directory;
static gboolean vala_compiler_version;
static gboolean vala_compiler_api_version;
static gboolean vala_compiler_ccode_only;
static gchar* vala_compiler_header_filename;
static gchar* vala_compiler_includedir;
static gchar* vala_compiler_internal_header_filename;
static gchar* vala_compiler_internal_vapi_filename;
static gchar* vala_compiler_fast_vapi_filename;
static gchar** vala_compiler_fast_vapis;
static gboolean vala_compiler_vapi_comments;
static gchar* vala_compiler_dependencies;
static gchar* vala_compiler_depfile;
static gboolean vala_compiler_list_sources;
static gchar* vala_compiler_symbols_filename;
static gboolean vala_compiler_compile_only;
static gchar* vala_compiler_output;
static gboolean vala_compiler_debug;
static gboolean vala_compiler_mem_profiler;
static gchar** vala_compiler_defines;
static gchar* vala_compiler_entry_point;
static gboolean vala_compiler_nostdpkg;
static gboolean vala_compiler_disable_assert;
static gboolean vala_compiler_enable_checking;
static gboolean vala_compiler_deprecated;
static gboolean vala_compiler_hide_internal;
static gboolean vala_compiler_experimental;
static gboolean vala_compiler_disable_warnings;
static gboolean vala_compiler_fatal_warnings;
static gboolean vala_compiler_disable_since_check;
static gboolean vala_compiler_keep_going;
static gboolean vala_compiler_experimental_non_null;
static gboolean vala_compiler_gobject_tracing;
static gchar* vala_compiler_cc_command;
static gchar** vala_compiler_cc_options;
static gchar* vala_compiler_pkg_config_command;
static gchar* vala_compiler_dump_tree;
static gboolean vala_compiler_save_temps;
static gboolean vala_compiler_quiet_mode;
static gboolean vala_compiler_verbose_mode;
static gboolean vala_compiler_disable_colored_output;
static gchar* vala_compiler_target_glib;
static gchar** vala_compiler_gresources;
static gchar** vala_compiler_gresources_directories;
static gboolean vala_compiler_enable_version_header;
static gboolean vala_compiler_disable_version_header;
static gchar* vala_compiler_run_args;
static gboolean vala_compiler_abi_stability;
static gchar** vala_compiler_sources;
static gchar* vala_compiler_basedir = NULL;
static gchar* vala_compiler_directory = NULL;
static gboolean vala_compiler_version = FALSE;
static gboolean vala_compiler_api_version = FALSE;
static gchar** vala_compiler_sources = NULL;
static gchar** vala_compiler_vapi_directories = NULL;
static gchar** vala_compiler_gir_directories = NULL;
static gchar** vala_compiler_metadata_directories = NULL;
static gchar* vala_compiler_vapi_filename = NULL;
static gchar* vala_compiler_library = NULL;
static gchar* vala_compiler_shared_library = NULL;
static gchar* vala_compiler_gir = NULL;
static gchar** vala_compiler_packages = NULL;
static gchar** vala_compiler_fast_vapis = NULL;
static gchar* vala_compiler_target_glib = NULL;
static gchar** vala_compiler_gresources = NULL;
static gchar** vala_compiler_gresources_directories = NULL;
static gboolean vala_compiler_ccode_only = FALSE;
static gboolean vala_compiler_abi_stability = FALSE;
static gchar* vala_compiler_header_filename = NULL;
static gchar* vala_compiler_internal_header_filename = NULL;
static gchar* vala_compiler_internal_vapi_filename = NULL;
static gchar* vala_compiler_fast_vapi_filename = NULL;
static gboolean vala_compiler_vapi_comments = FALSE;
static gchar* vala_compiler_symbols_filename = NULL;
static gchar* vala_compiler_includedir = NULL;
static gboolean vala_compiler_compile_only = FALSE;
static gchar* vala_compiler_output = NULL;
static gboolean vala_compiler_debug = FALSE;
static gboolean vala_compiler_mem_profiler = FALSE;
static gboolean vala_compiler_disable_assert = FALSE;
static gboolean vala_compiler_enable_checking = FALSE;
static gboolean vala_compiler_deprecated = FALSE;
static gboolean vala_compiler_hide_internal = FALSE;
static gboolean vala_compiler_experimental = FALSE;
static gboolean vala_compiler_experimental_non_null = FALSE;
static gboolean vala_compiler_gobject_tracing = FALSE;
static gboolean vala_compiler_disable_since_check = FALSE;
static gboolean vala_compiler_disable_warnings = FALSE;
static gboolean vala_compiler_keep_going = FALSE;
static gboolean vala_compiler_list_sources = FALSE;
static gchar* vala_compiler_cc_command = NULL;
static gchar** vala_compiler_cc_options = NULL;
static gchar* vala_compiler_pkg_config_command = NULL;
static gchar* vala_compiler_dump_tree = NULL;
static gboolean vala_compiler_save_temps = FALSE;
static gchar** vala_compiler_defines = NULL;
static gboolean vala_compiler_quiet_mode = FALSE;
static gboolean vala_compiler_verbose_mode = FALSE;
static ValaProfile vala_compiler_profile;
static ValaProfile vala_compiler_profile = 0;
static gboolean vala_compiler_nostdpkg = FALSE;
static gboolean vala_compiler_enable_version_header = FALSE;
static gboolean vala_compiler_disable_version_header = FALSE;
static gboolean vala_compiler_fatal_warnings = FALSE;
static gboolean vala_compiler_disable_colored_output = FALSE;
static ValaReportColored vala_compiler_colored_output;
static ValaReportColored vala_compiler_colored_output = VALA_REPORT_COLORED_AUTO;
static gchar* vala_compiler_dependencies = NULL;
static gchar* vala_compiler_depfile = NULL;
static gchar* vala_compiler_entry_point = NULL;
static gboolean vala_compiler_run_output;
static gboolean vala_compiler_run_output = FALSE;
static gchar* vala_compiler_run_args = NULL;

 G_GNUC_INTERNAL gpointer vala_compiler_ref (gpointer instance);
 G_GNUC_INTERNAL void vala_compiler_unref (gpointer instance);
 G_GNUC_INTERNAL GParamSpec* vala_param_spec_compiler (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
 G_GNUC_INTERNAL void vala_value_set_compiler (GValue* value,
                              gpointer v_object) G_GNUC_UNUSED ;
 G_GNUC_INTERNAL void vala_value_take_compiler (GValue* value,
                               gpointer v_object);
 G_GNUC_INTERNAL gpointer vala_value_get_compiler (const GValue* value) G_GNUC_UNUSED ;
 G_GNUC_INTERNAL GType vala_compiler_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ValaCompiler, vala_compiler_unref)
static gboolean vala_compiler_option_deprecated (const gchar* option_name,
                                          const gchar* val,
                                          void* data,
                                          GError** error);
static gboolean vala_compiler_option_parse_profile (const gchar* option_name,
                                             const gchar* val,
                                             void* data,
                                             GError** error);
static gboolean vala_compiler_option_parse_color (const gchar* option_name,
                                           const gchar* val,
                                           void* data,
                                           GError** error);
static gint vala_compiler_quit (ValaCompiler* self);
static gint vala_compiler_run (ValaCompiler* self);
static gint vala_compiler_run_source (gchar** args,
                               gint args_length1);
 G_GNUC_INTERNAL ValaCompiler* vala_compiler_new (void);
 G_GNUC_INTERNAL ValaCompiler* vala_compiler_construct (GType object_type);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda4_ (Block1Data* _data1_,
                  GPid pid,
                  gint status);
static void ____lambda4__gchild_watch_func (GPid pid,
                                     gint wait_status,
                                     gpointer self);
static gint vala_compiler_main (gchar** args,
                         gint args_length1);
static void vala_compiler_finalize (ValaCompiler * obj);
static GType vala_compiler_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GOptionEntry VALA_COMPILER_options[63] = {{"vapidir", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gir_directories, "Look for .gir files in DIRECTORY", "DIRECTORY..."}, {"metadatadir", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_metadata_directories, "Look for GIR .metadata files in DIRECTORY", "DIRECTORY..."}, {"pkg", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"vapi", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME, &vala_compiler_vapi_filename, "Output VAPI file name", "FILE"}, {"library", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &vala_compiler_library, "Library name", "NAME"}, {"shared-library", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &vala_compiler_shared_library, "Shared library name used in generated gir", "NAME"}, {"gir", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &vala_compiler_gir, "GObject-Introspection repository file name", "NAME-VERSION.gir"}, {"basedir", 'b', (gint) 0, G_OPTION_ARG_FILENAME, &vala_compiler_basedir, "Base source directory", "DIRECTORY"}, {"directory", 'd', (gint) 0, G_OPTION_ARG_FILENAME, &vala_compiler_directory, "Change output directory from current working directory", "DIRECTORY"}, {"version", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_version, "Display version number", NULL}, {"api-version", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_api_version, "Display API version number", NULL}, {"ccode", 'C', (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_ccode_only, "Output C code", NULL}, {"header", 'H', (gint) 0, G_OPTION_ARG_FILENAME, &vala_compiler_header_filename, "Output C header file", "FILE"}, {"use-header", (gchar) 0, (gint) (G_OPTION_FLAG_OPTIONAL_ARG | G_OPTION_FLAG_NO_ARG), G_OPTION_ARG_CALLBACK, (void*) vala_compiler_option_deprecated, "Use C header file (DEPRECATED AND IGNORED)", NULL}, {"includedir", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME, &vala_compiler_includedir, "Directory used to include the C header file", "DIRECTORY"}, {"internal-header", 'h', (gint) 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_header_filename, "Output internal C header file", "FILE"}, {"internal-vapi", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_vapi_filename, "Output vapi with internal api", "FILE"}, {"fast-vapi", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &vala_compiler_fast_vapi_filename, "Output vapi without performing symbol resolution", NULL}, {"use-fast-vapi", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_fast_vapis, "Use --fast-vapi output during this compile", NULL}, {"vapi-comments", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_vapi_comments, "Include comments in generated vapi", NULL}, {"deps", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &vala_compiler_dependencies, "Write make-style dependency information to this file", NULL}, {"depfile", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &vala_compiler_depfile, "Write make-style external dependency information for build systems to " \
"this file", NULL}, {"list-sources", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_list_sources, "Output a list of all source and binding files which are used", NULL}, {"symbols", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME, &vala_compiler_symbols_filename, "Output symbols file", "FILE"}, {"compile", 'c', (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_compile_only, "Compile but do not link", NULL}, {"output", 'o', (gint) 0, G_OPTION_ARG_FILENAME, &vala_compiler_output, "Place output in file FILE", "FILE"}, {"debug", 'g', (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_debug, "Produce debug information", NULL}, {"thread", (gchar) 0, (gint) (G_OPTION_FLAG_OPTIONAL_ARG | G_OPTION_FLAG_NO_ARG), G_OPTION_ARG_CALLBACK, (void*) vala_compiler_option_deprecated, "Enable multithreading support (DEPRECATED AND IGNORED)", NULL}, {"enable-mem-profiler", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_mem_profiler, "Enable GLib memory profiler", NULL}, {"define", 'D', (gint) 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_defines, "Define SYMBOL", "SYMBOL..."}, {"main", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &vala_compiler_entry_point, "Use SYMBOL as entry point", "SYMBOL..."}, {"nostdpkg", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_nostdpkg, "Do not include standard packages", NULL}, {"disable-assert", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_disable_assert, "Disable assertions", NULL}, {"enable-checking", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_enable_checking, "Enable additional run-time checks", NULL}, {"enable-deprecated", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_deprecated, "Enable deprecated features", NULL}, {"hide-internal", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_hide_internal, "Hide symbols marked as internal", NULL}, {"enable-experimental", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_experimental, "Enable experimental features", NULL}, {"disable-warnings", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_disable_warnings, "Disable warnings", NULL}, {"fatal-warnings", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_fatal_warnings, "Treat warnings as fatal", NULL}, {"disable-since-check", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_disable_since_check, "Do not check whether used symbols exist in local packages", NULL}, {"keep-going", 'k', (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_keep_going, "Continue as much as possible after an error", NULL}, {"enable-experimental-non-null", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_experimental_non_null, "Enable experimental enhancements for non-null types", NULL}, {"enable-gobject-tracing", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_gobject_tracing, "Enable GObject creation tracing", NULL}, {"cc", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &vala_compiler_cc_command, "Use COMMAND as C compiler command", "COMMAND"}, {"Xcc", 'X', (gint) 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_cc_options, "Pass OPTION to the C compiler", "OPTION..."}, {"pkg-config", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &vala_compiler_pkg_config_command, "Use COMMAND as pkg-config command", "COMMAND"}, {"dump-tree", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME, &vala_compiler_dump_tree, "Write code tree to FILE", "FILE"}, {"save-temps", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_save_temps, "Keep temporary files", NULL}, {"profile", (gchar) 0, (gint) G_OPTION_FLAG_OPTIONAL_ARG, G_OPTION_ARG_CALLBACK, (void*) vala_compiler_option_parse_profile, "Minimum runtime dependency: 'gobject' (default) or 'posix' (minimal li" \
"bc)", "PROFILE"}, {"quiet", 'q', (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_quiet_mode, "Do not print messages to the console", NULL}, {"verbose", 'v', (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_verbose_mode, "Print additional messages to the console", NULL}, {"no-color", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_disable_colored_output, "Disable colored output, alias for --color=never", NULL}, {"color", (gchar) 0, (gint) G_OPTION_FLAG_OPTIONAL_ARG, G_OPTION_ARG_CALLBACK, (void*) vala_compiler_option_parse_color, "Enable color output, options are 'always', 'never', or 'auto'", "WHEN"}, {"target-glib", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &vala_compiler_target_glib, "Target version of glib for code generation", "'MAJOR.MINOR', or 'auto'"}, {"gresources", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gresources, "XML of gresources", "FILE..."}, {"gresourcesdir", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gresources_directories, "Look for resources in DIRECTORY", "DIRECTORY..."}, {"enable-version-header", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_enable_version_header, "Write vala build version in generated files", NULL}, {"disable-version-header", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_disable_version_header, "Do not write vala build version in generated files", NULL}, {"run-args", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &vala_compiler_run_args, "Arguments passed to directly compiled executable", NULL}, {"abi-stability", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &vala_compiler_abi_stability, "Enable support for ABI stability", NULL}, {G_OPTION_REMAINING, (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_sources, NULL, "FILE..."}, {NULL}};

static inline gpointer
vala_compiler_get_instance_private (ValaCompiler* self)
{
	return G_STRUCT_MEMBER_P (self, ValaCompiler_private_offset);
}

static gboolean
vala_compiler_option_parse_color (const gchar* option_name,
                                  const gchar* val,
                                  void* data,
                                  GError** error)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (option_name != NULL, FALSE);
	_tmp0_ = val;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("auto")))) {
		switch (0) {
			default:
			{
				vala_compiler_colored_output = VALA_REPORT_COLORED_AUTO;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("never")))) {
		switch (0) {
			default:
			{
				vala_compiler_colored_output = VALA_REPORT_COLORED_NEVER;
				break;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string (NULL)))) || (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("always"))))) {
		switch (0) {
			default:
			{
				vala_compiler_colored_output = VALA_REPORT_COLORED_ALWAYS;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GError* _tmp3_;
				_tmp3_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_FAILED, "Invalid --color argument '%s'", val);
				_inner_error0_ = _tmp3_;
				if (_inner_error0_->domain == G_OPTION_ERROR) {
					gboolean _tmp4_ = FALSE;
					g_propagate_error (error, _inner_error0_);
					return _tmp4_;
				} else {
					gboolean _tmp5_ = FALSE;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp5_;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
vala_compiler_option_parse_profile (const gchar* option_name,
                                    const gchar* val,
                                    void* data,
                                    GError** error)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (option_name != NULL, FALSE);
	_tmp0_ = val;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (((_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string (NULL)))) || (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("gobject-2.0"))))) || (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("gobject"))))) {
		switch (0) {
			default:
			{
				vala_compiler_profile = VALA_PROFILE_GOBJECT;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("libc")))) {
		switch (0) {
			default:
			{
				vala_compiler_profile = VALA_PROFILE_LIBC;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("posix")))) {
		switch (0) {
			default:
			{
				vala_compiler_profile = VALA_PROFILE_POSIX;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GError* _tmp3_;
				_tmp3_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_FAILED, "Invalid --profile argument '%s'", val);
				_inner_error0_ = _tmp3_;
				if (_inner_error0_->domain == G_OPTION_ERROR) {
					gboolean _tmp4_ = FALSE;
					g_propagate_error (error, _inner_error0_);
					return _tmp4_;
				} else {
					gboolean _tmp5_ = FALSE;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp5_;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
vala_compiler_option_deprecated (const gchar* option_name,
                                 const gchar* val,
                                 void* data,
                                 GError** error)
{
	FILE* _tmp0_;
	gboolean result;
	g_return_val_if_fail (option_name != NULL, FALSE);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "Command-line option `%s` is deprecated and will be ignored\n", option_name);
	result = TRUE;
	return result;
}

static gint
vala_compiler_quit (ValaCompiler* self)
{
	gboolean _tmp0_ = FALSE;
	ValaCodeContext* _tmp1_;
	ValaReport* _tmp2_;
	ValaReport* _tmp3_;
	gboolean _tmp7_ = FALSE;
	ValaCodeContext* _tmp8_;
	ValaReport* _tmp9_;
	ValaReport* _tmp10_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->context;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	if (vala_report_get_errors (_tmp3_) == 0) {
		ValaCodeContext* _tmp4_;
		ValaReport* _tmp5_;
		ValaReport* _tmp6_;
		_tmp4_ = self->priv->context;
		_tmp5_ = vala_code_context_get_report (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = vala_report_get_warnings (_tmp6_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		vala_code_context_pop ();
		result = 0;
		return result;
	}
	_tmp8_ = self->priv->context;
	_tmp9_ = vala_code_context_get_report (_tmp8_);
	_tmp10_ = _tmp9_;
	if (vala_report_get_errors (_tmp10_) == 0) {
		gboolean _tmp11_ = FALSE;
		if (!vala_compiler_fatal_warnings) {
			_tmp11_ = TRUE;
		} else {
			ValaCodeContext* _tmp12_;
			ValaReport* _tmp13_;
			ValaReport* _tmp14_;
			_tmp12_ = self->priv->context;
			_tmp13_ = vala_code_context_get_report (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp11_ = vala_report_get_warnings (_tmp14_) == 0;
		}
		_tmp7_ = _tmp11_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		if (!vala_compiler_quiet_mode) {
			FILE* _tmp15_;
			ValaCodeContext* _tmp16_;
			ValaReport* _tmp17_;
			ValaReport* _tmp18_;
			_tmp15_ = stdout;
			_tmp16_ = self->priv->context;
			_tmp17_ = vala_code_context_get_report (_tmp16_);
			_tmp18_ = _tmp17_;
			fprintf (_tmp15_, "Compilation succeeded - %d warning(s)\n", vala_report_get_warnings (_tmp18_));
		}
		vala_code_context_pop ();
		result = 0;
		return result;
	} else {
		if (!vala_compiler_quiet_mode) {
			FILE* _tmp19_;
			ValaCodeContext* _tmp20_;
			ValaReport* _tmp21_;
			ValaReport* _tmp22_;
			ValaCodeContext* _tmp23_;
			ValaReport* _tmp24_;
			ValaReport* _tmp25_;
			_tmp19_ = stdout;
			_tmp20_ = self->priv->context;
			_tmp21_ = vala_code_context_get_report (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = self->priv->context;
			_tmp24_ = vala_code_context_get_report (_tmp23_);
			_tmp25_ = _tmp24_;
			fprintf (_tmp19_, "Compilation failed: %d error(s), %d warning(s)\n", vala_report_get_errors (_tmp22_), vala_report_get_warnings (_tmp25_));
		}
		vala_code_context_pop ();
		result = 1;
		return result;
	}
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gint
vala_compiler_run (ValaCompiler* self)
{
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	ValaCodeContext* _tmp23_;
	ValaCodeContext* _tmp24_;
	ValaCodeContext* _tmp25_;
	ValaCodeContext* _tmp26_;
	ValaCodeContext* _tmp27_;
	ValaCodeContext* _tmp28_;
	ValaCodeContext* _tmp29_;
	ValaCodeContext* _tmp30_;
	ValaCodeContext* _tmp31_;
	ValaCodeContext* _tmp32_;
	ValaReport* _tmp33_;
	ValaReport* _tmp34_;
	ValaCodeContext* _tmp35_;
	ValaReport* _tmp36_;
	ValaReport* _tmp37_;
	ValaCodeContext* _tmp38_;
	ValaCodeContext* _tmp39_;
	ValaCodeContext* _tmp40_;
	gboolean _tmp41_ = FALSE;
	ValaCodeContext* _tmp43_;
	ValaCodeContext* _tmp44_;
	ValaCodeContext* _tmp45_;
	const gchar* _tmp46_;
	ValaCodeContext* _tmp47_;
	const gchar* _tmp48_;
	ValaCodeContext* _tmp49_;
	const gchar* _tmp50_;
	ValaCodeContext* _tmp51_;
	const gchar* _tmp52_;
	ValaCodeContext* _tmp53_;
	const gchar* _tmp54_;
	gboolean _tmp55_ = FALSE;
	const gchar* _tmp56_;
	const gchar* _tmp57_;
	const gchar* _tmp65_;
	ValaCodeContext* _tmp74_;
	gchar** _tmp75_;
	gint _tmp75__length1;
	ValaCodeContext* _tmp76_;
	ValaCodeContext* _tmp77_;
	gchar** _tmp78_;
	gint _tmp78__length1;
	ValaCodeContext* _tmp79_;
	gchar** _tmp80_;
	gint _tmp80__length1;
	ValaCodeContext* _tmp81_;
	ValaCodeContext* _tmp82_;
	ValaCodeContext* _tmp83_;
	gboolean _tmp84_ = FALSE;
	const gchar* _tmp85_;
	ValaCodeContext* _tmp86_;
	const gchar* _tmp87_;
	ValaCodeContext* _tmp88_;
	const gchar* _tmp89_;
	ValaCodeContext* _tmp93_;
	const gchar* _tmp94_;
	ValaCodeContext* _tmp95_;
	const gchar* _tmp96_;
	gchar** _tmp99_;
	gint _tmp99__length1;
	gchar** _tmp104_;
	gint _tmp104__length1;
	gchar** _tmp109_;
	gint _tmp109__length1;
	ValaCodeContext* _tmp120_;
	gchar** _tmp121_;
	gint _tmp121__length1;
	ValaCodeContext* _tmp122_;
	gchar** _tmp123_;
	gint _tmp123__length1;
	gboolean _tmp124_ = FALSE;
	ValaCodeContext* _tmp125_;
	ValaReport* _tmp126_;
	ValaReport* _tmp127_;
	ValaCodeContext* _tmp132_;
	ValaProfile _tmp133_;
	ValaProfile _tmp134_;
	gboolean has_c_files = FALSE;
	gboolean has_h_files = FALSE;
	gchar** _tmp141_;
	gint _tmp141__length1;
	gboolean _tmp147_ = FALSE;
	gboolean _tmp149_ = FALSE;
	ValaCodeContext* _tmp150_;
	ValaReport* _tmp151_;
	ValaReport* _tmp152_;
	ValaParser* parser = NULL;
	ValaParser* _tmp179_;
	ValaParser* _tmp180_;
	ValaCodeContext* _tmp181_;
	ValaGenieParser* genie_parser = NULL;
	ValaGenieParser* _tmp182_;
	ValaGenieParser* _tmp183_;
	ValaCodeContext* _tmp184_;
	ValaGirParser* gir_parser = NULL;
	ValaGirParser* _tmp185_;
	ValaGirParser* _tmp186_;
	ValaCodeContext* _tmp187_;
	gboolean _tmp188_ = FALSE;
	ValaCodeContext* _tmp189_;
	ValaReport* _tmp190_;
	ValaReport* _tmp191_;
	const gchar* _tmp196_;
	ValaCodeContext* _tmp201_;
	gboolean _tmp202_ = FALSE;
	ValaCodeContext* _tmp203_;
	ValaReport* _tmp204_;
	ValaReport* _tmp205_;
	gboolean _tmp210_ = FALSE;
	gboolean _tmp211_ = FALSE;
	const gchar* _tmp217_;
	gboolean _tmp222_ = FALSE;
	ValaCodeContext* _tmp223_;
	ValaReport* _tmp224_;
	ValaReport* _tmp225_;
	ValaCodeContext* _tmp230_;
	ValaCodeGenerator* _tmp231_;
	ValaCodeGenerator* _tmp232_;
	ValaCodeContext* _tmp233_;
	gboolean _tmp234_ = FALSE;
	ValaCodeContext* _tmp235_;
	ValaReport* _tmp236_;
	ValaReport* _tmp237_;
	gboolean _tmp242_ = FALSE;
	const gchar* _tmp243_;
	const gchar* _tmp247_;
	const gchar* _tmp290_;
	const gchar* _tmp303_;
	const gchar* _tmp346_;
	const gchar* _tmp349_;
	gboolean _tmp352_ = FALSE;
	ValaCodeContext* _tmp353_;
	ValaReport* _tmp354_;
	ValaReport* _tmp355_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_new ();
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = self->priv->context;
	vala_code_context_push (_tmp1_);
	if (vala_compiler_disable_colored_output) {
		vala_compiler_colored_output = VALA_REPORT_COLORED_NEVER;
	}
	if (vala_compiler_colored_output != VALA_REPORT_COLORED_NEVER) {
		const gchar* env_colors = NULL;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = g_getenv ("VALA_COLORS");
		env_colors = _tmp2_;
		_tmp3_ = env_colors;
		if (_tmp3_ != NULL) {
			ValaCodeContext* _tmp4_;
			ValaReport* _tmp5_;
			ValaReport* _tmp6_;
			const gchar* _tmp7_;
			_tmp4_ = self->priv->context;
			_tmp5_ = vala_code_context_get_report (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = env_colors;
			vala_report_set_colors (_tmp6_, _tmp7_, vala_compiler_colored_output);
		} else {
			ValaCodeContext* _tmp8_;
			ValaReport* _tmp9_;
			ValaReport* _tmp10_;
			_tmp8_ = self->priv->context;
			_tmp9_ = vala_code_context_get_report (_tmp8_);
			_tmp10_ = _tmp9_;
			vala_report_set_colors (_tmp10_, VALA_COMPILER_DEFAULT_COLORS, vala_compiler_colored_output);
		}
	}
	if (!vala_compiler_ccode_only) {
		_tmp12_ = !vala_compiler_compile_only;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		const gchar* _tmp13_;
		_tmp13_ = vala_compiler_output;
		_tmp11_ = _tmp13_ == NULL;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		gchar** _tmp14_;
		gint _tmp14__length1;
		const gchar* _tmp15_;
		_tmp14_ = vala_compiler_sources;
		_tmp14__length1 = _vala_array_length (vala_compiler_sources);
		_tmp15_ = _tmp14_[0];
		if (string_last_index_of_char (_tmp15_, (gunichar) '.', 0) != -1) {
			gint dot = 0;
			gchar** _tmp16_;
			gint _tmp16__length1;
			const gchar* _tmp17_;
			gchar** _tmp18_;
			gint _tmp18__length1;
			const gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			_tmp16_ = vala_compiler_sources;
			_tmp16__length1 = _vala_array_length (vala_compiler_sources);
			_tmp17_ = _tmp16_[0];
			dot = string_last_index_of_char (_tmp17_, (gunichar) '.', 0);
			_tmp18_ = vala_compiler_sources;
			_tmp18__length1 = _vala_array_length (vala_compiler_sources);
			_tmp19_ = _tmp18_[0];
			_tmp20_ = string_substring (_tmp19_, (glong) 0, (glong) dot);
			_tmp21_ = _tmp20_;
			_tmp22_ = g_path_get_basename (_tmp21_);
			_g_free0 (vala_compiler_output);
			vala_compiler_output = _tmp22_;
			_g_free0 (_tmp21_);
		}
	}
	_tmp23_ = self->priv->context;
	vala_code_context_set_assert (_tmp23_, !vala_compiler_disable_assert);
	_tmp24_ = self->priv->context;
	vala_code_context_set_checking (_tmp24_, vala_compiler_enable_checking);
	_tmp25_ = self->priv->context;
	vala_code_context_set_deprecated (_tmp25_, vala_compiler_deprecated);
	_tmp26_ = self->priv->context;
	vala_code_context_set_since_check (_tmp26_, !vala_compiler_disable_since_check);
	_tmp27_ = self->priv->context;
	vala_code_context_set_hide_internal (_tmp27_, vala_compiler_hide_internal);
	_tmp28_ = self->priv->context;
	vala_code_context_set_experimental (_tmp28_, vala_compiler_experimental);
	_tmp29_ = self->priv->context;
	vala_code_context_set_experimental_non_null (_tmp29_, vala_compiler_experimental_non_null);
	_tmp30_ = self->priv->context;
	vala_code_context_set_gobject_tracing (_tmp30_, vala_compiler_gobject_tracing);
	_tmp31_ = self->priv->context;
	vala_code_context_set_keep_going (_tmp31_, vala_compiler_keep_going);
	_tmp32_ = self->priv->context;
	_tmp33_ = vala_code_context_get_report (_tmp32_);
	_tmp34_ = _tmp33_;
	vala_report_set_enable_warnings (_tmp34_, !vala_compiler_disable_warnings);
	_tmp35_ = self->priv->context;
	_tmp36_ = vala_code_context_get_report (_tmp35_);
	_tmp37_ = _tmp36_;
	vala_report_set_verbose_errors (_tmp37_, !vala_compiler_quiet_mode);
	_tmp38_ = self->priv->context;
	vala_code_context_set_verbose_mode (_tmp38_, vala_compiler_verbose_mode);
	_tmp39_ = self->priv->context;
	vala_code_context_set_version_header (_tmp39_, !vala_compiler_disable_version_header);
	_tmp40_ = self->priv->context;
	vala_code_context_set_ccode_only (_tmp40_, vala_compiler_ccode_only);
	if (vala_compiler_ccode_only) {
		gchar** _tmp42_;
		gint _tmp42__length1;
		_tmp42_ = vala_compiler_cc_options;
		_tmp42__length1 = _vala_array_length (vala_compiler_cc_options);
		_tmp41_ = _tmp42_ != NULL;
	} else {
		_tmp41_ = FALSE;
	}
	if (_tmp41_) {
		vala_report_warning (NULL, "-X has no effect when -C or --ccode is set");
	}
	_tmp43_ = self->priv->context;
	vala_code_context_set_abi_stability (_tmp43_, vala_compiler_abi_stability);
	_tmp44_ = self->priv->context;
	vala_code_context_set_compile_only (_tmp44_, vala_compiler_compile_only);
	_tmp45_ = self->priv->context;
	_tmp46_ = vala_compiler_header_filename;
	vala_code_context_set_header_filename (_tmp45_, _tmp46_);
	_tmp47_ = self->priv->context;
	_tmp48_ = vala_compiler_internal_header_filename;
	vala_code_context_set_internal_header_filename (_tmp47_, _tmp48_);
	_tmp49_ = self->priv->context;
	_tmp50_ = vala_compiler_symbols_filename;
	vala_code_context_set_symbols_filename (_tmp49_, _tmp50_);
	_tmp51_ = self->priv->context;
	_tmp52_ = vala_compiler_includedir;
	vala_code_context_set_includedir (_tmp51_, _tmp52_);
	_tmp53_ = self->priv->context;
	_tmp54_ = vala_compiler_output;
	vala_code_context_set_output (_tmp53_, _tmp54_);
	_tmp56_ = vala_compiler_output;
	if (_tmp56_ != NULL) {
		_tmp55_ = vala_compiler_ccode_only;
	} else {
		_tmp55_ = FALSE;
	}
	if (_tmp55_) {
		vala_report_warning (NULL, "--output and -o have no effect when -C or --ccode is set");
	}
	_tmp57_ = vala_compiler_basedir;
	if (_tmp57_ == NULL) {
		ValaCodeContext* _tmp58_;
		gchar* _tmp59_;
		gchar* _tmp60_;
		_tmp58_ = self->priv->context;
		_tmp59_ = vala_code_context_realpath (".");
		_tmp60_ = _tmp59_;
		vala_code_context_set_basedir (_tmp58_, _tmp60_);
		_g_free0 (_tmp60_);
	} else {
		ValaCodeContext* _tmp61_;
		const gchar* _tmp62_;
		gchar* _tmp63_;
		gchar* _tmp64_;
		_tmp61_ = self->priv->context;
		_tmp62_ = vala_compiler_basedir;
		_tmp63_ = vala_code_context_realpath (_tmp62_);
		_tmp64_ = _tmp63_;
		vala_code_context_set_basedir (_tmp61_, _tmp64_);
		_g_free0 (_tmp64_);
	}
	_tmp65_ = vala_compiler_directory;
	if (_tmp65_ != NULL) {
		ValaCodeContext* _tmp66_;
		const gchar* _tmp67_;
		gchar* _tmp68_;
		gchar* _tmp69_;
		_tmp66_ = self->priv->context;
		_tmp67_ = vala_compiler_directory;
		_tmp68_ = vala_code_context_realpath (_tmp67_);
		_tmp69_ = _tmp68_;
		vala_code_context_set_directory (_tmp66_, _tmp69_);
		_g_free0 (_tmp69_);
	} else {
		ValaCodeContext* _tmp70_;
		ValaCodeContext* _tmp71_;
		const gchar* _tmp72_;
		const gchar* _tmp73_;
		_tmp70_ = self->priv->context;
		_tmp71_ = self->priv->context;
		_tmp72_ = vala_code_context_get_basedir (_tmp71_);
		_tmp73_ = _tmp72_;
		vala_code_context_set_directory (_tmp70_, _tmp73_);
	}
	_tmp74_ = self->priv->context;
	_tmp75_ = vala_compiler_vapi_directories;
	_tmp75__length1 = _vala_array_length (vala_compiler_vapi_directories);
	vala_code_context_set_vapi_directories (_tmp74_, _tmp75_, _tmp75__length1);
	_tmp76_ = self->priv->context;
	vala_code_context_set_vapi_comments (_tmp76_, vala_compiler_vapi_comments);
	_tmp77_ = self->priv->context;
	_tmp78_ = vala_compiler_gir_directories;
	_tmp78__length1 = _vala_array_length (vala_compiler_gir_directories);
	vala_code_context_set_gir_directories (_tmp77_, _tmp78_, _tmp78__length1);
	_tmp79_ = self->priv->context;
	_tmp80_ = vala_compiler_metadata_directories;
	_tmp80__length1 = _vala_array_length (vala_compiler_metadata_directories);
	vala_code_context_set_metadata_directories (_tmp79_, _tmp80_, _tmp80__length1);
	_tmp81_ = self->priv->context;
	vala_code_context_set_debug (_tmp81_, vala_compiler_debug);
	_tmp82_ = self->priv->context;
	vala_code_context_set_mem_profiler (_tmp82_, vala_compiler_mem_profiler);
	_tmp83_ = self->priv->context;
	vala_code_context_set_save_temps (_tmp83_, vala_compiler_save_temps);
	if (vala_compiler_ccode_only) {
		_tmp84_ = vala_compiler_save_temps;
	} else {
		_tmp84_ = FALSE;
	}
	if (_tmp84_) {
		vala_report_warning (NULL, "--save-temps has no effect when -C or --ccode is set");
	}
	_tmp85_ = vala_compiler_fast_vapi_filename;
	vala_compiler_nostdpkg = vala_compiler_nostdpkg | (_tmp85_ != NULL);
	_tmp86_ = self->priv->context;
	_tmp87_ = vala_compiler_entry_point;
	vala_code_context_set_entry_point_name (_tmp86_, _tmp87_);
	_tmp88_ = self->priv->context;
	vala_code_context_set_run_output (_tmp88_, vala_compiler_run_output);
	_tmp89_ = vala_compiler_pkg_config_command;
	if (_tmp89_ == NULL) {
		const gchar* _tmp90_ = NULL;
		const gchar* _tmp91_;
		gchar* _tmp92_;
		_tmp91_ = g_getenv ("PKG_CONFIG");
		_tmp90_ = _tmp91_;
		if (_tmp90_ == NULL) {
			_tmp90_ = "pkg-config";
		}
		_tmp92_ = g_strdup (_tmp90_);
		_g_free0 (vala_compiler_pkg_config_command);
		vala_compiler_pkg_config_command = _tmp92_;
	}
	_tmp93_ = self->priv->context;
	_tmp94_ = vala_compiler_pkg_config_command;
	vala_code_context_set_pkg_config_command (_tmp93_, _tmp94_);
	_tmp95_ = self->priv->context;
	vala_code_context_set_target_profile (_tmp95_, vala_compiler_profile, !vala_compiler_nostdpkg);
	_tmp96_ = vala_compiler_target_glib;
	if (_tmp96_ != NULL) {
		ValaCodeContext* _tmp97_;
		const gchar* _tmp98_;
		_tmp97_ = self->priv->context;
		_tmp98_ = vala_compiler_target_glib;
		vala_code_context_set_target_glib_version (_tmp97_, _tmp98_);
	}
	_tmp99_ = vala_compiler_defines;
	_tmp99__length1 = _vala_array_length (vala_compiler_defines);
	if (_tmp99_ != NULL) {
		gchar** _tmp100_;
		gint _tmp100__length1;
		_tmp100_ = vala_compiler_defines;
		_tmp100__length1 = _vala_array_length (vala_compiler_defines);
		{
			gchar** define_collection = NULL;
			gint define_collection_length1 = 0;
			gint _define_collection_size_ = 0;
			gint define_it = 0;
			define_collection = _tmp100_;
			define_collection_length1 = _tmp100__length1;
			for (define_it = 0; define_it < define_collection_length1; define_it = define_it + 1) {
				gchar* _tmp101_;
				gchar* define = NULL;
				_tmp101_ = g_strdup (define_collection[define_it]);
				define = _tmp101_;
				{
					ValaCodeContext* _tmp102_;
					const gchar* _tmp103_;
					_tmp102_ = self->priv->context;
					_tmp103_ = define;
					vala_code_context_add_define (_tmp102_, _tmp103_);
					_g_free0 (define);
				}
			}
		}
	}
	_tmp104_ = vala_compiler_packages;
	_tmp104__length1 = _vala_array_length (vala_compiler_packages);
	if (_tmp104_ != NULL) {
		gchar** _tmp105_;
		gint _tmp105__length1;
		_tmp105_ = vala_compiler_packages;
		_tmp105__length1 = _vala_array_length (vala_compiler_packages);
		{
			gchar** package_collection = NULL;
			gint package_collection_length1 = 0;
			gint _package_collection_size_ = 0;
			gint package_it = 0;
			package_collection = _tmp105_;
			package_collection_length1 = _tmp105__length1;
			for (package_it = 0; package_it < package_collection_length1; package_it = package_it + 1) {
				gchar* _tmp106_;
				gchar* package = NULL;
				_tmp106_ = g_strdup (package_collection[package_it]);
				package = _tmp106_;
				{
					ValaCodeContext* _tmp107_;
					const gchar* _tmp108_;
					_tmp107_ = self->priv->context;
					_tmp108_ = package;
					vala_code_context_add_external_package (_tmp107_, _tmp108_);
					_g_free0 (package);
				}
			}
		}
		vala_compiler_packages = (_vala_array_free (vala_compiler_packages, _vala_array_length (vala_compiler_packages), (GDestroyNotify) g_free), NULL);
		vala_compiler_packages = NULL;
	}
	_tmp109_ = vala_compiler_fast_vapis;
	_tmp109__length1 = _vala_array_length (vala_compiler_fast_vapis);
	if (_tmp109_ != NULL) {
		gchar** _tmp110_;
		gint _tmp110__length1;
		ValaCodeContext* _tmp119_;
		_tmp110_ = vala_compiler_fast_vapis;
		_tmp110__length1 = _vala_array_length (vala_compiler_fast_vapis);
		{
			gchar** vapi_collection = NULL;
			gint vapi_collection_length1 = 0;
			gint _vapi_collection_size_ = 0;
			gint vapi_it = 0;
			vapi_collection = _tmp110_;
			vapi_collection_length1 = _tmp110__length1;
			for (vapi_it = 0; vapi_it < vapi_collection_length1; vapi_it = vapi_it + 1) {
				gchar* _tmp111_;
				gchar* vapi = NULL;
				_tmp111_ = g_strdup (vapi_collection[vapi_it]);
				vapi = _tmp111_;
				{
					gchar* rpath = NULL;
					const gchar* _tmp112_;
					gchar* _tmp113_;
					ValaSourceFile* source_file = NULL;
					ValaCodeContext* _tmp114_;
					const gchar* _tmp115_;
					ValaSourceFile* _tmp116_;
					ValaCodeContext* _tmp117_;
					ValaSourceFile* _tmp118_;
					_tmp112_ = vapi;
					_tmp113_ = vala_code_context_realpath (_tmp112_);
					rpath = _tmp113_;
					_tmp114_ = self->priv->context;
					_tmp115_ = rpath;
					_tmp116_ = vala_source_file_new (_tmp114_, VALA_SOURCE_FILE_TYPE_FAST, _tmp115_, NULL, FALSE);
					source_file = _tmp116_;
					_tmp117_ = self->priv->context;
					_tmp118_ = source_file;
					vala_code_context_add_source_file (_tmp117_, _tmp118_);
					_vala_source_file_unref0 (source_file);
					_g_free0 (rpath);
					_g_free0 (vapi);
				}
			}
		}
		_tmp119_ = self->priv->context;
		vala_code_context_set_use_fast_vapi (_tmp119_, TRUE);
	}
	_tmp120_ = self->priv->context;
	_tmp121_ = vala_compiler_gresources;
	_tmp121__length1 = _vala_array_length (vala_compiler_gresources);
	vala_code_context_set_gresources (_tmp120_, _tmp121_, _tmp121__length1);
	_tmp122_ = self->priv->context;
	_tmp123_ = vala_compiler_gresources_directories;
	_tmp123__length1 = _vala_array_length (vala_compiler_gresources_directories);
	vala_code_context_set_gresources_directories (_tmp122_, _tmp123_, _tmp123__length1);
	_tmp125_ = self->priv->context;
	_tmp126_ = vala_code_context_get_report (_tmp125_);
	_tmp127_ = _tmp126_;
	if (vala_report_get_errors (_tmp127_) > 0) {
		_tmp124_ = TRUE;
	} else {
		gboolean _tmp128_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			ValaCodeContext* _tmp129_;
			ValaReport* _tmp130_;
			ValaReport* _tmp131_;
			_tmp129_ = self->priv->context;
			_tmp130_ = vala_code_context_get_report (_tmp129_);
			_tmp131_ = _tmp130_;
			_tmp128_ = vala_report_get_warnings (_tmp131_) > 0;
		} else {
			_tmp128_ = FALSE;
		}
		_tmp124_ = _tmp128_;
	}
	if (_tmp124_) {
		result = vala_compiler_quit (self);
		return result;
	}
	_tmp132_ = self->priv->context;
	_tmp133_ = vala_code_context_get_profile (_tmp132_);
	_tmp134_ = _tmp133_;
	if (_tmp134_ == VALA_PROFILE_GOBJECT) {
		ValaCodeContext* _tmp135_;
		ValaGDBusServerModule* _tmp136_;
		ValaGDBusServerModule* _tmp137_;
		_tmp135_ = self->priv->context;
		_tmp136_ = vala_gd_bus_server_module_new ();
		_tmp137_ = _tmp136_;
		vala_code_context_set_codegen (_tmp135_, (ValaCodeGenerator*) _tmp137_);
		_vala_code_visitor_unref0 (_tmp137_);
	} else {
		ValaCodeContext* _tmp138_;
		ValaCCodeDelegateModule* _tmp139_;
		ValaCCodeDelegateModule* _tmp140_;
		_tmp138_ = self->priv->context;
		_tmp139_ = vala_ccode_delegate_module_new ();
		_tmp140_ = _tmp139_;
		vala_code_context_set_codegen (_tmp138_, (ValaCodeGenerator*) _tmp140_);
		_vala_code_visitor_unref0 (_tmp140_);
	}
	has_c_files = FALSE;
	has_h_files = FALSE;
	_tmp141_ = vala_compiler_sources;
	_tmp141__length1 = _vala_array_length (vala_compiler_sources);
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp141_;
		source_collection_length1 = _tmp141__length1;
		for (source_it = 0; source_it < source_collection_length1; source_it = source_it + 1) {
			gchar* _tmp142_;
			gchar* source = NULL;
			_tmp142_ = g_strdup (source_collection[source_it]);
			source = _tmp142_;
			{
				ValaCodeContext* _tmp143_;
				const gchar* _tmp144_;
				_tmp143_ = self->priv->context;
				_tmp144_ = source;
				if (vala_code_context_add_source_filename (_tmp143_, _tmp144_, vala_compiler_run_output, TRUE)) {
					const gchar* _tmp145_;
					_tmp145_ = source;
					if (g_str_has_suffix (_tmp145_, ".c")) {
						has_c_files = TRUE;
					} else {
						const gchar* _tmp146_;
						_tmp146_ = source;
						if (g_str_has_suffix (_tmp146_, ".h")) {
							has_h_files = TRUE;
						}
					}
				}
				_g_free0 (source);
			}
		}
	}
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = NULL;
	if (vala_compiler_ccode_only) {
		gboolean _tmp148_ = FALSE;
		if (has_c_files) {
			_tmp148_ = TRUE;
		} else {
			_tmp148_ = has_h_files;
		}
		_tmp147_ = _tmp148_;
	} else {
		_tmp147_ = FALSE;
	}
	if (_tmp147_) {
		vala_report_warning (NULL, "C header and source files are ignored when -C or --ccode is set");
	}
	_tmp150_ = self->priv->context;
	_tmp151_ = vala_code_context_get_report (_tmp150_);
	_tmp152_ = _tmp151_;
	if (vala_report_get_errors (_tmp152_) > 0) {
		_tmp149_ = TRUE;
	} else {
		gboolean _tmp153_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			ValaCodeContext* _tmp154_;
			ValaReport* _tmp155_;
			ValaReport* _tmp156_;
			_tmp154_ = self->priv->context;
			_tmp155_ = vala_code_context_get_report (_tmp154_);
			_tmp156_ = _tmp155_;
			_tmp153_ = vala_report_get_warnings (_tmp156_) > 0;
		} else {
			_tmp153_ = FALSE;
		}
		_tmp149_ = _tmp153_;
	}
	if (_tmp149_) {
		result = vala_compiler_quit (self);
		return result;
	}
	if (vala_compiler_list_sources) {
		{
			ValaList* _file_list = NULL;
			ValaCodeContext* _tmp157_;
			ValaList* _tmp158_;
			gint _file_size = 0;
			ValaList* _tmp159_;
			gint _tmp160_;
			gint _tmp161_;
			gint _file_index = 0;
			_tmp157_ = self->priv->context;
			_tmp158_ = vala_code_context_get_source_files (_tmp157_);
			_file_list = _tmp158_;
			_tmp159_ = _file_list;
			_tmp160_ = vala_collection_get_size ((ValaCollection*) _tmp159_);
			_tmp161_ = _tmp160_;
			_file_size = _tmp161_;
			_file_index = -1;
			while (TRUE) {
				gint _tmp162_;
				gint _tmp163_;
				ValaSourceFile* file = NULL;
				ValaList* _tmp164_;
				gpointer _tmp165_;
				ValaSourceFile* _tmp166_;
				const gchar* _tmp167_;
				const gchar* _tmp168_;
				_file_index = _file_index + 1;
				_tmp162_ = _file_index;
				_tmp163_ = _file_size;
				if (!(_tmp162_ < _tmp163_)) {
					break;
				}
				_tmp164_ = _file_list;
				_tmp165_ = vala_list_get (_tmp164_, _file_index);
				file = (ValaSourceFile*) _tmp165_;
				_tmp166_ = file;
				_tmp167_ = vala_source_file_get_filename (_tmp166_);
				_tmp168_ = _tmp167_;
				g_print ("%s\n", _tmp168_);
				_vala_source_file_unref0 (file);
			}
		}
		if (!vala_compiler_ccode_only) {
			{
				ValaList* _filename_list = NULL;
				ValaCodeContext* _tmp169_;
				ValaList* _tmp170_;
				gint _filename_size = 0;
				ValaList* _tmp171_;
				gint _tmp172_;
				gint _tmp173_;
				gint _filename_index = 0;
				_tmp169_ = self->priv->context;
				_tmp170_ = vala_code_context_get_c_source_files (_tmp169_);
				_filename_list = _tmp170_;
				_tmp171_ = _filename_list;
				_tmp172_ = vala_collection_get_size ((ValaCollection*) _tmp171_);
				_tmp173_ = _tmp172_;
				_filename_size = _tmp173_;
				_filename_index = -1;
				while (TRUE) {
					gint _tmp174_;
					gint _tmp175_;
					gchar* filename = NULL;
					ValaList* _tmp176_;
					gpointer _tmp177_;
					const gchar* _tmp178_;
					_filename_index = _filename_index + 1;
					_tmp174_ = _filename_index;
					_tmp175_ = _filename_size;
					if (!(_tmp174_ < _tmp175_)) {
						break;
					}
					_tmp176_ = _filename_list;
					_tmp177_ = vala_list_get (_tmp176_, _filename_index);
					filename = (gchar*) _tmp177_;
					_tmp178_ = filename;
					g_print ("%s\n", _tmp178_);
					_g_free0 (filename);
				}
			}
		}
		result = 0;
		return result;
	}
	_tmp179_ = vala_parser_new ();
	parser = _tmp179_;
	_tmp180_ = parser;
	_tmp181_ = self->priv->context;
	vala_parser_parse (_tmp180_, _tmp181_);
	_tmp182_ = vala_genie_parser_new ();
	genie_parser = _tmp182_;
	_tmp183_ = genie_parser;
	_tmp184_ = self->priv->context;
	vala_genie_parser_parse (_tmp183_, _tmp184_);
	_tmp185_ = vala_gir_parser_new ();
	gir_parser = _tmp185_;
	_tmp186_ = gir_parser;
	_tmp187_ = self->priv->context;
	vala_gir_parser_parse (_tmp186_, _tmp187_);
	_tmp189_ = self->priv->context;
	_tmp190_ = vala_code_context_get_report (_tmp189_);
	_tmp191_ = _tmp190_;
	if (vala_report_get_errors (_tmp191_) > 0) {
		_tmp188_ = TRUE;
	} else {
		gboolean _tmp192_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			ValaCodeContext* _tmp193_;
			ValaReport* _tmp194_;
			ValaReport* _tmp195_;
			_tmp193_ = self->priv->context;
			_tmp194_ = vala_code_context_get_report (_tmp193_);
			_tmp195_ = _tmp194_;
			_tmp192_ = vala_report_get_warnings (_tmp195_) > 0;
		} else {
			_tmp192_ = FALSE;
		}
		_tmp188_ = _tmp192_;
	}
	if (_tmp188_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp196_ = vala_compiler_fast_vapi_filename;
	if (_tmp196_ != NULL) {
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp197_;
		ValaCodeWriter* _tmp198_;
		ValaCodeContext* _tmp199_;
		const gchar* _tmp200_;
		_tmp197_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_FAST);
		interface_writer = _tmp197_;
		_tmp198_ = interface_writer;
		_tmp199_ = self->priv->context;
		_tmp200_ = vala_compiler_fast_vapi_filename;
		vala_code_writer_write_file (_tmp198_, _tmp199_, _tmp200_);
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (interface_writer);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp201_ = self->priv->context;
	vala_code_context_check (_tmp201_);
	_tmp203_ = self->priv->context;
	_tmp204_ = vala_code_context_get_report (_tmp203_);
	_tmp205_ = _tmp204_;
	if (vala_report_get_errors (_tmp205_) > 0) {
		_tmp202_ = TRUE;
	} else {
		gboolean _tmp206_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			ValaCodeContext* _tmp207_;
			ValaReport* _tmp208_;
			ValaReport* _tmp209_;
			_tmp207_ = self->priv->context;
			_tmp208_ = vala_code_context_get_report (_tmp207_);
			_tmp209_ = _tmp208_;
			_tmp206_ = vala_report_get_warnings (_tmp209_) > 0;
		} else {
			_tmp206_ = FALSE;
		}
		_tmp202_ = _tmp206_;
	}
	if (_tmp202_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	if (!vala_compiler_ccode_only) {
		_tmp211_ = !vala_compiler_compile_only;
	} else {
		_tmp211_ = FALSE;
	}
	if (_tmp211_) {
		const gchar* _tmp212_;
		_tmp212_ = vala_compiler_library;
		_tmp210_ = _tmp212_ == NULL;
	} else {
		_tmp210_ = FALSE;
	}
	if (_tmp210_) {
		gboolean _tmp213_ = FALSE;
		if (!has_c_files) {
			ValaCodeContext* _tmp214_;
			ValaMethod* _tmp215_;
			ValaMethod* _tmp216_;
			_tmp214_ = self->priv->context;
			_tmp215_ = vala_code_context_get_entry_point (_tmp214_);
			_tmp216_ = _tmp215_;
			_tmp213_ = _tmp216_ == NULL;
		} else {
			_tmp213_ = FALSE;
		}
		if (_tmp213_) {
			vala_report_error (NULL, "program does not contain a static `main' method");
		}
	}
	_tmp217_ = vala_compiler_dump_tree;
	if (_tmp217_ != NULL) {
		ValaCodeWriter* code_writer = NULL;
		ValaCodeWriter* _tmp218_;
		ValaCodeWriter* _tmp219_;
		ValaCodeContext* _tmp220_;
		const gchar* _tmp221_;
		_tmp218_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_DUMP);
		code_writer = _tmp218_;
		_tmp219_ = code_writer;
		_tmp220_ = self->priv->context;
		_tmp221_ = vala_compiler_dump_tree;
		vala_code_writer_write_file (_tmp219_, _tmp220_, _tmp221_);
		_vala_code_visitor_unref0 (code_writer);
	}
	_tmp223_ = self->priv->context;
	_tmp224_ = vala_code_context_get_report (_tmp223_);
	_tmp225_ = _tmp224_;
	if (vala_report_get_errors (_tmp225_) > 0) {
		_tmp222_ = TRUE;
	} else {
		gboolean _tmp226_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			ValaCodeContext* _tmp227_;
			ValaReport* _tmp228_;
			ValaReport* _tmp229_;
			_tmp227_ = self->priv->context;
			_tmp228_ = vala_code_context_get_report (_tmp227_);
			_tmp229_ = _tmp228_;
			_tmp226_ = vala_report_get_warnings (_tmp229_) > 0;
		} else {
			_tmp226_ = FALSE;
		}
		_tmp222_ = _tmp226_;
	}
	if (_tmp222_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp230_ = self->priv->context;
	_tmp231_ = vala_code_context_get_codegen (_tmp230_);
	_tmp232_ = _tmp231_;
	_tmp233_ = self->priv->context;
	vala_code_generator_emit (_tmp232_, _tmp233_);
	_tmp235_ = self->priv->context;
	_tmp236_ = vala_code_context_get_report (_tmp235_);
	_tmp237_ = _tmp236_;
	if (vala_report_get_errors (_tmp237_) > 0) {
		_tmp234_ = TRUE;
	} else {
		gboolean _tmp238_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			ValaCodeContext* _tmp239_;
			ValaReport* _tmp240_;
			ValaReport* _tmp241_;
			_tmp239_ = self->priv->context;
			_tmp240_ = vala_code_context_get_report (_tmp239_);
			_tmp241_ = _tmp240_;
			_tmp238_ = vala_report_get_warnings (_tmp241_) > 0;
		} else {
			_tmp238_ = FALSE;
		}
		_tmp234_ = _tmp238_;
	}
	if (_tmp234_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp243_ = vala_compiler_vapi_filename;
	if (_tmp243_ == NULL) {
		const gchar* _tmp244_;
		_tmp244_ = vala_compiler_library;
		_tmp242_ = _tmp244_ != NULL;
	} else {
		_tmp242_ = FALSE;
	}
	if (_tmp242_) {
		const gchar* _tmp245_;
		gchar* _tmp246_;
		_tmp245_ = vala_compiler_library;
		_tmp246_ = g_strdup_printf ("%s.vapi", _tmp245_);
		_g_free0 (vala_compiler_vapi_filename);
		vala_compiler_vapi_filename = _tmp246_;
	}
	_tmp247_ = vala_compiler_library;
	if (_tmp247_ != NULL) {
		const gchar* _tmp248_;
		_tmp248_ = vala_compiler_gir;
		if (_tmp248_ != NULL) {
			ValaCodeContext* _tmp249_;
			ValaProfile _tmp250_;
			ValaProfile _tmp251_;
			_tmp249_ = self->priv->context;
			_tmp250_ = vala_code_context_get_profile (_tmp249_);
			_tmp251_ = _tmp250_;
			if (_tmp251_ == VALA_PROFILE_GOBJECT) {
				gchar* gir_base = NULL;
				const gchar* _tmp252_;
				gchar* _tmp253_;
				glong gir_len = 0L;
				const gchar* _tmp254_;
				gint _tmp255_;
				gint _tmp256_;
				gint last_hyphen = 0;
				const gchar* _tmp257_;
				gboolean _tmp258_ = FALSE;
				_tmp252_ = vala_compiler_gir;
				_tmp253_ = g_path_get_basename (_tmp252_);
				gir_base = _tmp253_;
				_tmp254_ = gir_base;
				_tmp255_ = strlen (_tmp254_);
				_tmp256_ = _tmp255_;
				gir_len = (glong) _tmp256_;
				_tmp257_ = gir_base;
				last_hyphen = string_last_index_of_char (_tmp257_, (gunichar) '-', 0);
				if (last_hyphen == -1) {
					_tmp258_ = TRUE;
				} else {
					const gchar* _tmp259_;
					_tmp259_ = gir_base;
					_tmp258_ = !g_str_has_suffix (_tmp259_, ".gir");
				}
				if (_tmp258_) {
					const gchar* _tmp260_;
					_tmp260_ = vala_compiler_gir;
					vala_report_error (NULL, "GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp260_);
				} else {
					gchar* gir_namespace = NULL;
					const gchar* _tmp261_;
					gchar* _tmp262_;
					gchar* gir_version = NULL;
					const gchar* _tmp263_;
					gchar* _tmp264_;
					const gchar* _tmp265_;
					gboolean _tmp266_ = FALSE;
					gboolean _tmp267_ = FALSE;
					gboolean _tmp268_ = FALSE;
					const gchar* _tmp269_;
					_tmp261_ = gir_base;
					_tmp262_ = string_substring (_tmp261_, (glong) 0, (glong) last_hyphen);
					gir_namespace = _tmp262_;
					_tmp263_ = gir_base;
					_tmp264_ = string_substring (_tmp263_, (glong) (last_hyphen + 1), (gir_len - last_hyphen) - 5);
					gir_version = _tmp264_;
					_tmp265_ = gir_version;
					g_strcanon (_tmp265_, "0123456789.", '?');
					_tmp269_ = gir_namespace;
					if (g_strcmp0 (_tmp269_, "") == 0) {
						_tmp268_ = TRUE;
					} else {
						const gchar* _tmp270_;
						_tmp270_ = gir_version;
						_tmp268_ = g_strcmp0 (_tmp270_, "") == 0;
					}
					if (_tmp268_) {
						_tmp267_ = TRUE;
					} else {
						const gchar* _tmp271_;
						_tmp271_ = gir_version;
						_tmp267_ = !g_ascii_isdigit (string_get (_tmp271_, (glong) 0));
					}
					if (_tmp267_) {
						_tmp266_ = TRUE;
					} else {
						const gchar* _tmp272_;
						_tmp272_ = gir_version;
						_tmp266_ = string_contains (_tmp272_, "?");
					}
					if (_tmp266_) {
						const gchar* _tmp273_;
						_tmp273_ = vala_compiler_gir;
						vala_report_error (NULL, "GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp273_);
					} else {
						ValaGIRWriter* gir_writer = NULL;
						ValaGIRWriter* _tmp274_;
						gchar* gir_directory = NULL;
						gchar* _tmp275_;
						const gchar* _tmp276_;
						ValaGIRWriter* _tmp281_;
						ValaCodeContext* _tmp282_;
						const gchar* _tmp283_;
						const gchar* _tmp284_;
						const gchar* _tmp285_;
						const gchar* _tmp286_;
						const gchar* _tmp287_;
						const gchar* _tmp288_;
						_tmp274_ = vala_gir_writer_new ();
						gir_writer = _tmp274_;
						_tmp275_ = g_strdup (".");
						gir_directory = _tmp275_;
						_tmp276_ = vala_compiler_directory;
						if (_tmp276_ != NULL) {
							ValaCodeContext* _tmp277_;
							const gchar* _tmp278_;
							const gchar* _tmp279_;
							gchar* _tmp280_;
							_tmp277_ = self->priv->context;
							_tmp278_ = vala_code_context_get_directory (_tmp277_);
							_tmp279_ = _tmp278_;
							_tmp280_ = g_strdup (_tmp279_);
							_g_free0 (gir_directory);
							gir_directory = _tmp280_;
						}
						_tmp281_ = gir_writer;
						_tmp282_ = self->priv->context;
						_tmp283_ = gir_directory;
						_tmp284_ = vala_compiler_gir;
						_tmp285_ = gir_namespace;
						_tmp286_ = gir_version;
						_tmp287_ = vala_compiler_library;
						_tmp288_ = vala_compiler_shared_library;
						vala_gir_writer_write_file (_tmp281_, _tmp282_, _tmp283_, _tmp284_, _tmp285_, _tmp286_, _tmp287_, _tmp288_);
						_g_free0 (gir_directory);
						_vala_code_visitor_unref0 (gir_writer);
					}
					_g_free0 (gir_version);
					_g_free0 (gir_namespace);
				}
				_g_free0 (gir_base);
			}
			_g_free0 (vala_compiler_gir);
			vala_compiler_gir = NULL;
		}
		_g_free0 (vala_compiler_library);
		vala_compiler_library = NULL;
	} else {
		const gchar* _tmp289_;
		_tmp289_ = vala_compiler_gir;
		if (_tmp289_ != NULL) {
			vala_report_warning (NULL, "--gir has no effect without --library");
			_g_free0 (vala_compiler_gir);
			vala_compiler_gir = NULL;
		}
	}
	_tmp290_ = vala_compiler_vapi_filename;
	if (_tmp290_ != NULL) {
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp291_;
		gboolean _tmp292_ = FALSE;
		const gchar* _tmp293_;
		ValaCodeWriter* _tmp300_;
		ValaCodeContext* _tmp301_;
		const gchar* _tmp302_;
		_tmp291_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_EXTERNAL);
		interface_writer = _tmp291_;
		_tmp293_ = vala_compiler_directory;
		if (_tmp293_ != NULL) {
			const gchar* _tmp294_;
			_tmp294_ = vala_compiler_vapi_filename;
			_tmp292_ = !g_path_is_absolute (_tmp294_);
		} else {
			_tmp292_ = FALSE;
		}
		if (_tmp292_) {
			ValaCodeContext* _tmp295_;
			const gchar* _tmp296_;
			const gchar* _tmp297_;
			const gchar* _tmp298_;
			gchar* _tmp299_;
			_tmp295_ = self->priv->context;
			_tmp296_ = vala_code_context_get_directory (_tmp295_);
			_tmp297_ = _tmp296_;
			_tmp298_ = vala_compiler_vapi_filename;
			_tmp299_ = g_strdup_printf ("%s%c%s", _tmp297_, (gint) G_DIR_SEPARATOR, _tmp298_);
			_g_free0 (vala_compiler_vapi_filename);
			vala_compiler_vapi_filename = _tmp299_;
		}
		_tmp300_ = interface_writer;
		_tmp301_ = self->priv->context;
		_tmp302_ = vala_compiler_vapi_filename;
		vala_code_writer_write_file (_tmp300_, _tmp301_, _tmp302_);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp303_ = vala_compiler_internal_vapi_filename;
	if (_tmp303_ != NULL) {
		gboolean _tmp304_ = FALSE;
		const gchar* _tmp305_;
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp307_;
		ValaCodeContext* _tmp308_;
		const gchar* _tmp309_;
		const gchar* _tmp310_;
		gchar* vapi_filename = NULL;
		const gchar* _tmp333_;
		gchar* _tmp334_;
		gboolean _tmp335_ = FALSE;
		const gchar* _tmp336_;
		ValaCodeWriter* _tmp343_;
		ValaCodeContext* _tmp344_;
		const gchar* _tmp345_;
		_tmp305_ = vala_compiler_internal_header_filename;
		if (_tmp305_ == NULL) {
			_tmp304_ = TRUE;
		} else {
			const gchar* _tmp306_;
			_tmp306_ = vala_compiler_header_filename;
			_tmp304_ = _tmp306_ == NULL;
		}
		if (_tmp304_) {
			vala_report_error (NULL, "--internal-vapi may only be used in combination with --header and --in" \
"ternal-header");
			result = vala_compiler_quit (self);
			_vala_code_visitor_unref0 (gir_parser);
			_vala_code_visitor_unref0 (genie_parser);
			_vala_code_visitor_unref0 (parser);
			return result;
		}
		_tmp307_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_INTERNAL);
		interface_writer = _tmp307_;
		_tmp308_ = self->priv->context;
		_tmp309_ = vala_code_context_get_includedir (_tmp308_);
		_tmp310_ = _tmp309_;
		if (_tmp310_ != NULL) {
			gchar* prefixed_header_filename = NULL;
			ValaCodeContext* _tmp311_;
			const gchar* _tmp312_;
			const gchar* _tmp313_;
			const gchar* _tmp314_;
			gchar* _tmp315_;
			gchar* _tmp316_;
			gchar* _tmp317_;
			gchar* _tmp318_;
			gchar* prefixed_internal_header_filename = NULL;
			ValaCodeContext* _tmp319_;
			const gchar* _tmp320_;
			const gchar* _tmp321_;
			const gchar* _tmp322_;
			gchar* _tmp323_;
			gchar* _tmp324_;
			gchar* _tmp325_;
			gchar* _tmp326_;
			ValaCodeWriter* _tmp327_;
			const gchar* _tmp328_;
			const gchar* _tmp329_;
			_tmp311_ = self->priv->context;
			_tmp312_ = vala_code_context_get_includedir (_tmp311_);
			_tmp313_ = _tmp312_;
			_tmp314_ = vala_compiler_header_filename;
			_tmp315_ = g_path_get_basename (_tmp314_);
			_tmp316_ = _tmp315_;
			_tmp317_ = g_build_path ("/", _tmp313_, _tmp316_, NULL);
			_tmp318_ = _tmp317_;
			_g_free0 (_tmp316_);
			prefixed_header_filename = _tmp318_;
			_tmp319_ = self->priv->context;
			_tmp320_ = vala_code_context_get_includedir (_tmp319_);
			_tmp321_ = _tmp320_;
			_tmp322_ = vala_compiler_internal_header_filename;
			_tmp323_ = g_path_get_basename (_tmp322_);
			_tmp324_ = _tmp323_;
			_tmp325_ = g_build_path ("/", _tmp321_, _tmp324_, NULL);
			_tmp326_ = _tmp325_;
			_g_free0 (_tmp324_);
			prefixed_internal_header_filename = _tmp326_;
			_tmp327_ = interface_writer;
			_tmp328_ = prefixed_header_filename;
			_tmp329_ = prefixed_internal_header_filename;
			vala_code_writer_set_cheader_override (_tmp327_, _tmp328_, _tmp329_);
			_g_free0 (prefixed_internal_header_filename);
			_g_free0 (prefixed_header_filename);
		} else {
			ValaCodeWriter* _tmp330_;
			const gchar* _tmp331_;
			const gchar* _tmp332_;
			_tmp330_ = interface_writer;
			_tmp331_ = vala_compiler_header_filename;
			_tmp332_ = vala_compiler_internal_header_filename;
			vala_code_writer_set_cheader_override (_tmp330_, _tmp331_, _tmp332_);
		}
		_tmp333_ = vala_compiler_internal_vapi_filename;
		_tmp334_ = g_strdup (_tmp333_);
		vapi_filename = _tmp334_;
		_tmp336_ = vala_compiler_directory;
		if (_tmp336_ != NULL) {
			const gchar* _tmp337_;
			_tmp337_ = vapi_filename;
			_tmp335_ = !g_path_is_absolute (_tmp337_);
		} else {
			_tmp335_ = FALSE;
		}
		if (_tmp335_) {
			ValaCodeContext* _tmp338_;
			const gchar* _tmp339_;
			const gchar* _tmp340_;
			const gchar* _tmp341_;
			gchar* _tmp342_;
			_tmp338_ = self->priv->context;
			_tmp339_ = vala_code_context_get_directory (_tmp338_);
			_tmp340_ = _tmp339_;
			_tmp341_ = vapi_filename;
			_tmp342_ = g_strdup_printf ("%s%c%s", _tmp340_, (gint) G_DIR_SEPARATOR, _tmp341_);
			_g_free0 (vapi_filename);
			vapi_filename = _tmp342_;
		}
		_tmp343_ = interface_writer;
		_tmp344_ = self->priv->context;
		_tmp345_ = vapi_filename;
		vala_code_writer_write_file (_tmp343_, _tmp344_, _tmp345_);
		_g_free0 (vala_compiler_internal_vapi_filename);
		vala_compiler_internal_vapi_filename = NULL;
		_g_free0 (vapi_filename);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp346_ = vala_compiler_dependencies;
	if (_tmp346_ != NULL) {
		ValaCodeContext* _tmp347_;
		const gchar* _tmp348_;
		_tmp347_ = self->priv->context;
		_tmp348_ = vala_compiler_dependencies;
		vala_code_context_write_dependencies (_tmp347_, _tmp348_);
	}
	_tmp349_ = vala_compiler_depfile;
	if (_tmp349_ != NULL) {
		ValaCodeContext* _tmp350_;
		const gchar* _tmp351_;
		_tmp350_ = self->priv->context;
		_tmp351_ = vala_compiler_depfile;
		vala_code_context_write_external_dependencies (_tmp350_, _tmp351_);
	}
	_tmp353_ = self->priv->context;
	_tmp354_ = vala_code_context_get_report (_tmp353_);
	_tmp355_ = _tmp354_;
	if (vala_report_get_errors (_tmp355_) > 0) {
		_tmp352_ = TRUE;
	} else {
		gboolean _tmp356_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			ValaCodeContext* _tmp357_;
			ValaReport* _tmp358_;
			ValaReport* _tmp359_;
			_tmp357_ = self->priv->context;
			_tmp358_ = vala_code_context_get_report (_tmp357_);
			_tmp359_ = _tmp358_;
			_tmp356_ = vala_report_get_warnings (_tmp359_) > 0;
		} else {
			_tmp356_ = FALSE;
		}
		_tmp352_ = _tmp356_;
	}
	if (_tmp352_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	if (!vala_compiler_ccode_only) {
		ValaCCodeCompiler* ccompiler = NULL;
		ValaCCodeCompiler* _tmp360_;
		gboolean _tmp361_ = FALSE;
		const gchar* _tmp362_;
		gchar** _tmp366_;
		gint _tmp366__length1;
		_tmp360_ = vala_ccode_compiler_new ();
		ccompiler = _tmp360_;
		_tmp362_ = vala_compiler_cc_command;
		if (_tmp362_ == NULL) {
			const gchar* _tmp363_;
			_tmp363_ = g_getenv ("CC");
			_tmp361_ = _tmp363_ != NULL;
		} else {
			_tmp361_ = FALSE;
		}
		if (_tmp361_) {
			const gchar* _tmp364_;
			gchar* _tmp365_;
			_tmp364_ = g_getenv ("CC");
			_tmp365_ = g_strdup (_tmp364_);
			_g_free0 (vala_compiler_cc_command);
			vala_compiler_cc_command = _tmp365_;
		}
		_tmp366_ = vala_compiler_cc_options;
		_tmp366__length1 = _vala_array_length (vala_compiler_cc_options);
		if (_tmp366_ == NULL) {
			ValaCCodeCompiler* _tmp367_;
			ValaCodeContext* _tmp368_;
			const gchar* _tmp369_;
			gchar** _tmp370_;
			gchar** _tmp371_;
			gint _tmp371__length1;
			_tmp367_ = ccompiler;
			_tmp368_ = self->priv->context;
			_tmp369_ = vala_compiler_cc_command;
			_tmp370_ = g_new0 (gchar*, 0 + 1);
			_tmp371_ = _tmp370_;
			_tmp371__length1 = 0;
			vala_ccode_compiler_compile (_tmp367_, _tmp368_, _tmp369_, _tmp371_, (gint) 0);
			_tmp371_ = (_vala_array_free (_tmp371_, _tmp371__length1, (GDestroyNotify) g_free), NULL);
		} else {
			ValaCCodeCompiler* _tmp372_;
			ValaCodeContext* _tmp373_;
			const gchar* _tmp374_;
			gchar** _tmp375_;
			gint _tmp375__length1;
			_tmp372_ = ccompiler;
			_tmp373_ = self->priv->context;
			_tmp374_ = vala_compiler_cc_command;
			_tmp375_ = vala_compiler_cc_options;
			_tmp375__length1 = _vala_array_length (vala_compiler_cc_options);
			vala_ccode_compiler_compile (_tmp372_, _tmp373_, _tmp374_, _tmp375_, (gint) _tmp375__length1);
		}
		_vala_ccode_compiler_unref0 (ccompiler);
	}
	result = vala_compiler_quit (self);
	_vala_code_visitor_unref0 (gir_parser);
	_vala_code_visitor_unref0 (genie_parser);
	_vala_code_visitor_unref0 (parser);
	return result;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_main_loop_unref0 (_data1_->loop);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
___lambda4_ (Block1Data* _data1_,
             GPid pid,
             gint status)
{
	GMainLoop* _tmp0_;
	_data1_->child_status = (status & 0xff00) >> 8;
	_tmp0_ = _data1_->loop;
	g_main_loop_quit (_tmp0_);
}

static void
____lambda4__gchild_watch_func (GPid pid,
                                gint wait_status,
                                gpointer self)
{
	___lambda4_ (self, pid, wait_status);
}

static gint
vala_compiler_run_source (gchar** args,
                          gint args_length1)
{
	gchar** _tmp13_;
	gint _tmp13__length1;
	const gchar* _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gint outputfd = 0;
	const gchar* _tmp21_;
	ValaCompiler* compiler = NULL;
	ValaCompiler* _tmp22_;
	gint ret = 0;
	ValaCompiler* _tmp23_;
	const gchar* _tmp24_;
	gchar** target_args = NULL;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar** _tmp28_;
	gint target_args_length1;
	gint _target_args_size_;
	const gchar* _tmp29_;
	gint _tmp46_ = -1;
	GError* _inner_error0_ = NULL;
	gint result;
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp0_;
		GOptionContext* _tmp1_;
		GOptionContext* _tmp2_;
		GOptionContext* _tmp3_;
		_tmp0_ = g_option_context_new ("- Vala Interpreter");
		opt_context = _tmp0_;
		_tmp1_ = opt_context;
		g_option_context_set_help_enabled (_tmp1_, TRUE);
		_tmp2_ = opt_context;
		g_option_context_add_main_entries (_tmp2_, VALA_COMPILER_options, NULL);
		_tmp3_ = opt_context;
		g_option_context_parse (_tmp3_, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp4_ = -1;
			_g_option_context_free0 (opt_context);
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		FILE* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = stdout;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp5_, "%s\n", _tmp7_);
		_tmp8_ = stdout;
		_tmp9_ = args[0];
		fprintf (_tmp8_, "Run '%s --help' to see a full list of available command line options.\n", _tmp9_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp10_ = -1;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp10_;
	}
	if (vala_compiler_version) {
		FILE* _tmp11_;
		_tmp11_ = stdout;
		fprintf (_tmp11_, "Vala %s\n", VALA_BUILD_VERSION);
		result = 0;
		return result;
	} else {
		if (vala_compiler_api_version) {
			FILE* _tmp12_;
			_tmp12_ = stdout;
			fprintf (_tmp12_, "%s\n", VALA_API_VERSION);
			result = 0;
			return result;
		}
	}
	_tmp13_ = vala_compiler_sources;
	_tmp13__length1 = _vala_array_length (vala_compiler_sources);
	if (_tmp13_ == NULL) {
		FILE* _tmp14_;
		_tmp14_ = stderr;
		fprintf (_tmp14_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp15_ = g_get_tmp_dir ();
	_tmp16_ = vala_compiler_sources;
	_tmp16__length1 = _vala_array_length (vala_compiler_sources);
	_tmp17_ = _tmp16_[0];
	_tmp18_ = g_path_get_basename (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strdup_printf ("%s/%s.XXXXXX", _tmp15_, _tmp19_);
	_g_free0 (vala_compiler_output);
	vala_compiler_output = _tmp20_;
	_g_free0 (_tmp19_);
	_tmp21_ = vala_compiler_output;
	outputfd = g_mkstemp (_tmp21_);
	if (outputfd < 0) {
		result = 1;
		return result;
	}
	vala_compiler_ccode_only = FALSE;
	vala_compiler_compile_only = FALSE;
	vala_compiler_run_output = TRUE;
	vala_compiler_disable_warnings = TRUE;
	vala_compiler_quiet_mode = TRUE;
	_g_free0 (vala_compiler_library);
	vala_compiler_library = NULL;
	_g_free0 (vala_compiler_shared_library);
	vala_compiler_shared_library = NULL;
	_tmp22_ = vala_compiler_new ();
	compiler = _tmp22_;
	_tmp23_ = compiler;
	ret = vala_compiler_run (_tmp23_);
	if (ret != 0) {
		result = ret;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	close (outputfd);
	_tmp24_ = vala_compiler_output;
	if (g_chmod (_tmp24_, 0700) != 0) {
		const gchar* _tmp25_;
		_tmp25_ = vala_compiler_output;
		g_unlink (_tmp25_);
		result = 1;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp26_ = vala_compiler_output;
	_tmp27_ = g_strdup (_tmp26_);
	_tmp28_ = g_new0 (gchar*, 1 + 1);
	_tmp28_[0] = _tmp27_;
	target_args = _tmp28_;
	target_args_length1 = 1;
	_target_args_size_ = target_args_length1;
	_tmp29_ = vala_compiler_run_args;
	if (_tmp29_ != NULL) {
		gchar** target_run_args = NULL;
		const gchar* _tmp30_;
		gchar** _tmp31_;
		gchar** _tmp32_;
		gint target_run_args_length1;
		gint _target_run_args_size_;
		gchar** _tmp33_;
		gint _tmp33__length1;
		_tmp30_ = vala_compiler_run_args;
		_tmp32_ = _tmp31_ = g_strsplit (_tmp30_, " ", 0);
		target_run_args = _tmp32_;
		target_run_args_length1 = _vala_array_length (_tmp31_);
		_target_run_args_size_ = target_run_args_length1;
		_tmp33_ = target_run_args;
		_tmp33__length1 = target_run_args_length1;
		{
			gchar** arg_collection = NULL;
			gint arg_collection_length1 = 0;
			gint _arg_collection_size_ = 0;
			gint arg_it = 0;
			arg_collection = _tmp33_;
			arg_collection_length1 = _tmp33__length1;
			for (arg_it = 0; arg_it < arg_collection_length1; arg_it = arg_it + 1) {
				gchar* _tmp34_;
				gchar* arg = NULL;
				_tmp34_ = g_strdup (arg_collection[arg_it]);
				arg = _tmp34_;
				{
					const gchar* _tmp35_;
					gchar* _tmp36_;
					_tmp35_ = arg;
					_tmp36_ = g_strdup (_tmp35_);
					_vala_array_add1 (&target_args, &target_args_length1, &_target_args_size_, _tmp36_);
					_g_free0 (arg);
				}
			}
		}
		target_run_args = (_vala_array_free (target_run_args, target_run_args_length1, (GDestroyNotify) g_free), NULL);
	}
	{
		Block1Data* _data1_;
		GPid pid = 0;
		GMainLoop* _tmp37_;
		gchar** _tmp38_;
		gint _tmp38__length1;
		GPid _tmp39_ = 0;
		const gchar* _tmp41_;
		GMainLoop* _tmp42_;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_tmp37_ = g_main_loop_new (NULL, FALSE);
		_data1_->loop = _tmp37_;
		_data1_->child_status = 0;
		_tmp38_ = target_args;
		_tmp38__length1 = target_args_length1;
		g_spawn_async (NULL, _tmp38_, NULL, G_SPAWN_CHILD_INHERITS_STDIN | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp39_, &_inner_error0_);
		pid = _tmp39_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp40_ = -1;
			block1_data_unref (_data1_);
			_data1_ = NULL;
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch1_g_spawn_error;
			}
			target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
			_vala_compiler_unref0 (compiler);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp40_;
		}
		_tmp41_ = vala_compiler_output;
		g_unlink (_tmp41_);
		g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, pid, ____lambda4__gchild_watch_func, block1_data_ref (_data1_), block1_data_unref);
		_tmp42_ = _data1_->loop;
		g_main_loop_run (_tmp42_);
		result = _data1_->child_status;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	goto __finally1;
	__catch1_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp43_;
		GError* _tmp44_;
		const gchar* _tmp45_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp43_ = stdout;
		_tmp44_ = e;
		_tmp45_ = _tmp44_->message;
		fprintf (_tmp43_, "%s\n", _tmp45_);
		result = 1;
		_g_error_free0 (e);
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	__finally1:
	target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
	_vala_compiler_unref0 (compiler);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp46_;
}

static gint
vala_compiler_main (gchar** args,
                    gint args_length1)
{
	const gchar* _tmp0_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp24_ = FALSE;
	gchar** _tmp25_;
	gint _tmp25__length1;
	ValaCompiler* compiler = NULL;
	ValaCompiler* _tmp28_;
	ValaCompiler* _tmp29_;
	GError* _inner_error0_ = NULL;
	gint result;
	setlocale (LC_ALL, "");
	_tmp0_ = vala_get_build_version ();
	if (g_strcmp0 (_tmp0_, VALA_BUILD_VERSION) != 0) {
		FILE* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = stderr;
		_tmp2_ = vala_get_build_version ();
		fprintf (_tmp1_, "Integrity check failed (libvala %s doesn't match valac %s)\n", _tmp2_, VALA_BUILD_VERSION);
		result = 1;
		return result;
	}
	_tmp4_ = args[0];
	_tmp5_ = g_path_get_basename (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strcmp0 (_tmp6_, "vala") == 0;
	_g_free0 (_tmp6_);
	if (_tmp7_) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = args[0];
		_tmp9_ = g_path_get_basename (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp3_ = g_strcmp0 (_tmp10_, "vala" PACKAGE_SUFFIX) == 0;
		_g_free0 (_tmp10_);
	}
	if (_tmp3_) {
		result = vala_compiler_run_source (args, (gint) args_length1);
		return result;
	}
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp11_;
		GOptionContext* _tmp12_;
		GOptionContext* _tmp13_;
		GOptionContext* _tmp14_;
		_tmp11_ = g_option_context_new ("- Vala Compiler");
		opt_context = _tmp11_;
		_tmp12_ = opt_context;
		g_option_context_set_help_enabled (_tmp12_, TRUE);
		_tmp13_ = opt_context;
		g_option_context_add_main_entries (_tmp13_, VALA_COMPILER_options, NULL);
		_tmp14_ = opt_context;
		g_option_context_parse (_tmp14_, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp15_ = -1;
			_g_option_context_free0 (opt_context);
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp15_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp16_;
		GError* _tmp17_;
		const gchar* _tmp18_;
		FILE* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = stdout;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		fprintf (_tmp16_, "%s\n", _tmp18_);
		_tmp19_ = stdout;
		_tmp20_ = args[0];
		fprintf (_tmp19_, "Run '%s --help' to see a full list of available command line options.\n", _tmp20_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp21_ = -1;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp21_;
	}
	if (vala_compiler_version) {
		FILE* _tmp22_;
		_tmp22_ = stdout;
		fprintf (_tmp22_, "Vala %s\n", VALA_BUILD_VERSION);
		result = 0;
		return result;
	} else {
		if (vala_compiler_api_version) {
			FILE* _tmp23_;
			_tmp23_ = stdout;
			fprintf (_tmp23_, "%s\n", VALA_API_VERSION);
			result = 0;
			return result;
		}
	}
	_tmp25_ = vala_compiler_sources;
	_tmp25__length1 = _vala_array_length (vala_compiler_sources);
	if (_tmp25_ == NULL) {
		gchar** _tmp26_;
		gint _tmp26__length1;
		_tmp26_ = vala_compiler_fast_vapis;
		_tmp26__length1 = _vala_array_length (vala_compiler_fast_vapis);
		_tmp24_ = _tmp26_ == NULL;
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		FILE* _tmp27_;
		_tmp27_ = stderr;
		fprintf (_tmp27_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp28_ = vala_compiler_new ();
	compiler = _tmp28_;
	_tmp29_ = compiler;
	result = vala_compiler_run (_tmp29_);
	_vala_compiler_unref0 (compiler);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return vala_compiler_main (argv, argc);
}

 G_GNUC_INTERNAL ValaCompiler*
vala_compiler_construct (GType object_type)
{
	ValaCompiler* self = NULL;
	self = (ValaCompiler*) g_type_create_instance (object_type);
	return self;
}

 G_GNUC_INTERNAL ValaCompiler*
vala_compiler_new (void)
{
	return vala_compiler_construct (VALA_TYPE_COMPILER);
}

static void
vala_value_compiler_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_value_compiler_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_compiler_unref (value->data[0].v_pointer);
	}
}

static void
vala_value_compiler_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_compiler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_value_compiler_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_value_compiler_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaCompiler * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_compiler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_value_compiler_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	ValaCompiler ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_compiler_ref (value->data[0].v_pointer);
	}
	return NULL;
}

 G_GNUC_INTERNAL GParamSpec*
vala_param_spec_compiler (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	ValaParamSpecCompiler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_COMPILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

 G_GNUC_INTERNAL gpointer
vala_value_get_compiler (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER), NULL);
	return value->data[0].v_pointer;
}

 G_GNUC_INTERNAL void
vala_value_set_compiler (GValue* value,
                         gpointer v_object)
{
	ValaCompiler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_compiler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}

 G_GNUC_INTERNAL void
vala_value_take_compiler (GValue* value,
                          gpointer v_object)
{
	ValaCompiler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}

static void
vala_compiler_class_init (ValaCompilerClass * klass,
                          gpointer klass_data)
{
	vala_compiler_parent_class = g_type_class_peek_parent (klass);
	((ValaCompilerClass *) klass)->finalize = vala_compiler_finalize;
	g_type_class_adjust_private_offset (klass, &ValaCompiler_private_offset);
}

static void
vala_compiler_instance_init (ValaCompiler * self,
                             gpointer klass)
{
	self->priv = vala_compiler_get_instance_private (self);
	self->ref_count = 1;
}

static void
vala_compiler_finalize (ValaCompiler * obj)
{
	ValaCompiler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_COMPILER, ValaCompiler);
	g_signal_handlers_destroy (self);
	_vala_code_context_unref0 (self->priv->context);
}

static GType
vala_compiler_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_value_compiler_init, vala_value_compiler_free_value, vala_value_compiler_copy_value, vala_value_compiler_peek_pointer, "p", vala_value_compiler_collect_value, "p", vala_value_compiler_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaCompilerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_compiler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCompiler), 0, (GInstanceInitFunc) vala_compiler_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_compiler_type_id;
	vala_compiler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCompiler", &g_define_type_info, &g_define_type_fundamental_info, 0);
	ValaCompiler_private_offset = g_type_add_instance_private (vala_compiler_type_id, sizeof (ValaCompilerPrivate));
	return vala_compiler_type_id;
}

 G_GNUC_INTERNAL GType
vala_compiler_get_type (void)
{
	static volatile gsize vala_compiler_type_id__once = 0;
	if (g_once_init_enter (&vala_compiler_type_id__once)) {
		GType vala_compiler_type_id;
		vala_compiler_type_id = vala_compiler_get_type_once ();
		g_once_init_leave (&vala_compiler_type_id__once, vala_compiler_type_id);
	}
	return vala_compiler_type_id__once;
}

 G_GNUC_INTERNAL gpointer
vala_compiler_ref (gpointer instance)
{
	ValaCompiler * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

 G_GNUC_INTERNAL void
vala_compiler_unref (gpointer instance)
{
	ValaCompiler * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_COMPILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

