/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.dart;

import android.content.res.AssetManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import io.flutter.FlutterInjector;
import io.flutter.Log;
import io.flutter.embedding.engine.FlutterJNI;
import io.flutter.embedding.engine.dart.DartMessenger;
import io.flutter.embedding.engine.loader.FlutterLoader;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.StringCodec;
import io.flutter.util.TraceSection;
import io.flutter.view.FlutterCallbackInformation;
import java.nio.ByteBuffer;
import java.util.List;

public class DartExecutor
implements BinaryMessenger {
    private static final String TAG = "DartExecutor";
    @NonNull
    private final FlutterJNI flutterJNI;
    @NonNull
    private final AssetManager assetManager;
    @NonNull
    private final DartMessenger dartMessenger;
    @NonNull
    private final BinaryMessenger binaryMessenger;
    private boolean isApplicationRunning = false;
    @Nullable
    private String isolateServiceId;
    @Nullable
    private IsolateServiceIdListener isolateServiceIdListener;
    private final BinaryMessenger.BinaryMessageHandler isolateChannelMessageHandler = new BinaryMessenger.BinaryMessageHandler(){

        @Override
        public void onMessage(ByteBuffer message, BinaryMessenger.BinaryReply callback) {
            DartExecutor.this.isolateServiceId = StringCodec.INSTANCE.decodeMessage(message);
            if (DartExecutor.this.isolateServiceIdListener != null) {
                DartExecutor.this.isolateServiceIdListener.onIsolateServiceIdAvailable(DartExecutor.this.isolateServiceId);
            }
        }
    };

    public DartExecutor(@NonNull FlutterJNI flutterJNI, @NonNull AssetManager assetManager) {
        this.flutterJNI = flutterJNI;
        this.assetManager = assetManager;
        this.dartMessenger = new DartMessenger(flutterJNI);
        this.dartMessenger.setMessageHandler("flutter/isolate", this.isolateChannelMessageHandler);
        this.binaryMessenger = new DefaultBinaryMessenger(this.dartMessenger);
        if (flutterJNI.isAttached()) {
            this.isApplicationRunning = true;
        }
    }

    public void onAttachedToJNI() {
        Log.v(TAG, "Attached to JNI. Registering the platform message handler for this Dart execution context.");
        this.flutterJNI.setPlatformMessageHandler(this.dartMessenger);
    }

    public void onDetachedFromJNI() {
        Log.v(TAG, "Detached from JNI. De-registering the platform message handler for this Dart execution context.");
        this.flutterJNI.setPlatformMessageHandler(null);
    }

    public boolean isExecutingDart() {
        return this.isApplicationRunning;
    }

    public void executeDartEntrypoint(@NonNull DartEntrypoint dartEntrypoint) {
        this.executeDartEntrypoint(dartEntrypoint, null);
    }

    public void executeDartEntrypoint(@NonNull DartEntrypoint dartEntrypoint, @Nullable List<String> dartEntrypointArgs) {
        if (this.isApplicationRunning) {
            Log.w(TAG, "Attempted to run a DartExecutor that is already running.");
            return;
        }
        try (TraceSection e = TraceSection.scoped("DartExecutor#executeDartEntrypoint");){
            Log.v(TAG, "Executing Dart entrypoint: " + dartEntrypoint);
            this.flutterJNI.runBundleAndSnapshotFromLibrary(dartEntrypoint.pathToBundle, dartEntrypoint.dartEntrypointFunctionName, dartEntrypoint.dartEntrypointLibrary, this.assetManager, dartEntrypointArgs);
            this.isApplicationRunning = true;
        }
    }

    public void executeDartCallback(@NonNull DartCallback dartCallback) {
        if (this.isApplicationRunning) {
            Log.w(TAG, "Attempted to run a DartExecutor that is already running.");
            return;
        }
        try (TraceSection e = TraceSection.scoped("DartExecutor#executeDartCallback");){
            Log.v(TAG, "Executing Dart callback: " + dartCallback);
            this.flutterJNI.runBundleAndSnapshotFromLibrary(dartCallback.pathToBundle, dartCallback.callbackHandle.callbackName, dartCallback.callbackHandle.callbackLibraryPath, dartCallback.androidAssetManager, null);
            this.isApplicationRunning = true;
        }
    }

    @NonNull
    public BinaryMessenger getBinaryMessenger() {
        return this.binaryMessenger;
    }

    @Override
    @Deprecated
    @UiThread
    public BinaryMessenger.TaskQueue makeBackgroundTaskQueue(BinaryMessenger.TaskQueueOptions options) {
        return this.binaryMessenger.makeBackgroundTaskQueue(options);
    }

    @Override
    @Deprecated
    @UiThread
    public void send(@NonNull String channel, @Nullable ByteBuffer message) {
        this.binaryMessenger.send(channel, message);
    }

    @Override
    @Deprecated
    @UiThread
    public void send(@NonNull String channel, @Nullable ByteBuffer message, @Nullable BinaryMessenger.BinaryReply callback) {
        this.binaryMessenger.send(channel, message, callback);
    }

    @Override
    @Deprecated
    @UiThread
    public void setMessageHandler(@NonNull String channel, @Nullable BinaryMessenger.BinaryMessageHandler handler) {
        this.binaryMessenger.setMessageHandler(channel, handler);
    }

    @Override
    @Deprecated
    @UiThread
    public void setMessageHandler(@NonNull String channel, @Nullable BinaryMessenger.BinaryMessageHandler handler, @Nullable BinaryMessenger.TaskQueue taskQueue) {
        this.binaryMessenger.setMessageHandler(channel, handler, taskQueue);
    }

    @Override
    @Deprecated
    public void enableBufferingIncomingMessages() {
        this.dartMessenger.enableBufferingIncomingMessages();
    }

    @Override
    @Deprecated
    public void disableBufferingIncomingMessages() {
        this.dartMessenger.disableBufferingIncomingMessages();
    }

    @UiThread
    public int getPendingChannelResponseCount() {
        return this.dartMessenger.getPendingChannelResponseCount();
    }

    @Nullable
    public String getIsolateServiceId() {
        return this.isolateServiceId;
    }

    public void setIsolateServiceIdListener(@Nullable IsolateServiceIdListener listener) {
        this.isolateServiceIdListener = listener;
        if (this.isolateServiceIdListener != null && this.isolateServiceId != null) {
            this.isolateServiceIdListener.onIsolateServiceIdAvailable(this.isolateServiceId);
        }
    }

    public void notifyLowMemoryWarning() {
        if (this.flutterJNI.isAttached()) {
            this.flutterJNI.notifyLowMemoryWarning();
        }
    }

    public static interface IsolateServiceIdListener {
        public void onIsolateServiceIdAvailable(@NonNull String var1);
    }

    private static class DefaultBinaryMessenger
    implements BinaryMessenger {
        private final DartMessenger messenger;

        private DefaultBinaryMessenger(@NonNull DartMessenger messenger) {
            this.messenger = messenger;
        }

        @Override
        public BinaryMessenger.TaskQueue makeBackgroundTaskQueue(BinaryMessenger.TaskQueueOptions options) {
            return this.messenger.makeBackgroundTaskQueue(options);
        }

        @Override
        @UiThread
        public void send(@NonNull String channel, @Nullable ByteBuffer message) {
            this.messenger.send(channel, message, null);
        }

        @Override
        @UiThread
        public void send(@NonNull String channel, @Nullable ByteBuffer message, @Nullable BinaryMessenger.BinaryReply callback) {
            this.messenger.send(channel, message, callback);
        }

        @Override
        @UiThread
        public void setMessageHandler(@NonNull String channel, @Nullable BinaryMessenger.BinaryMessageHandler handler) {
            this.messenger.setMessageHandler(channel, handler);
        }

        @Override
        @UiThread
        public void setMessageHandler(@NonNull String channel, @Nullable BinaryMessenger.BinaryMessageHandler handler, @Nullable BinaryMessenger.TaskQueue taskQueue) {
            this.messenger.setMessageHandler(channel, handler, taskQueue);
        }

        @Override
        public void enableBufferingIncomingMessages() {
            this.messenger.enableBufferingIncomingMessages();
        }

        @Override
        public void disableBufferingIncomingMessages() {
            this.messenger.disableBufferingIncomingMessages();
        }
    }

    public static class DartEntrypoint {
        @NonNull
        public final String pathToBundle;
        @Nullable
        public final String dartEntrypointLibrary;
        @NonNull
        public final String dartEntrypointFunctionName;

        @NonNull
        public static DartEntrypoint createDefault() {
            FlutterLoader flutterLoader = FlutterInjector.instance().flutterLoader();
            if (!flutterLoader.initialized()) {
                throw new AssertionError((Object)"DartEntrypoints can only be created once a FlutterEngine is created.");
            }
            return new DartEntrypoint(flutterLoader.findAppBundlePath(), "main");
        }

        public DartEntrypoint(@NonNull String pathToBundle, @NonNull String dartEntrypointFunctionName) {
            this.pathToBundle = pathToBundle;
            this.dartEntrypointLibrary = null;
            this.dartEntrypointFunctionName = dartEntrypointFunctionName;
        }

        public DartEntrypoint(@NonNull String pathToBundle, @NonNull String dartEntrypointLibrary, @NonNull String dartEntrypointFunctionName) {
            this.pathToBundle = pathToBundle;
            this.dartEntrypointLibrary = dartEntrypointLibrary;
            this.dartEntrypointFunctionName = dartEntrypointFunctionName;
        }

        @NonNull
        public String toString() {
            return "DartEntrypoint( bundle path: " + this.pathToBundle + ", function: " + this.dartEntrypointFunctionName + " )";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DartEntrypoint that = (DartEntrypoint)o;
            if (!this.pathToBundle.equals(that.pathToBundle)) {
                return false;
            }
            return this.dartEntrypointFunctionName.equals(that.dartEntrypointFunctionName);
        }

        public int hashCode() {
            int result = this.pathToBundle.hashCode();
            result = 31 * result + this.dartEntrypointFunctionName.hashCode();
            return result;
        }
    }

    public static class DartCallback {
        public final AssetManager androidAssetManager;
        public final String pathToBundle;
        public final FlutterCallbackInformation callbackHandle;

        public DartCallback(@NonNull AssetManager androidAssetManager, @NonNull String pathToBundle, @NonNull FlutterCallbackInformation callbackHandle) {
            this.androidAssetManager = androidAssetManager;
            this.pathToBundle = pathToBundle;
            this.callbackHandle = callbackHandle;
        }

        @NonNull
        public String toString() {
            return "DartCallback( bundle path: " + this.pathToBundle + ", library path: " + this.callbackHandle.callbackLibraryPath + ", function: " + this.callbackHandle.callbackName + " )";
        }
    }
}

