/* valafield.c generated by valac, the Vala compiler
 * generated from valafield.vala, do not modify */

/* valafield.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaFieldPrivate {
	ValaMemberBinding _binding;
	gboolean _is_volatile;
	gboolean _lock_used;
};

static gint ValaField_private_offset;
static gpointer vala_field_parent_class = NULL;
static ValaLockableIface * vala_field_vala_lockable_parent_iface = NULL;

static void vala_field_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor);
static void vala_field_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static void vala_field_real_replace_expression (ValaCodeNode* base,
                                         ValaExpression* old_node,
                                         ValaExpression* new_node);
static void vala_field_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type);
static gboolean vala_field_real_check (ValaCodeNode* base,
                                ValaCodeContext* context);
static void vala_field_finalize (ValaCodeNode * obj);
static GType vala_field_get_type_once (void);

static inline gpointer
vala_field_get_instance_private (ValaField* self)
{
	return G_STRUCT_MEMBER_P (self, ValaField_private_offset);
}

ValaMemberBinding
vala_field_get_binding (ValaField* self)
{
	ValaMemberBinding result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_binding;
	return result;
}

void
vala_field_set_binding (ValaField* self,
                        ValaMemberBinding value)
{
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}

gboolean
vala_field_get_is_volatile (ValaField* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_volatile;
	return result;
}

void
vala_field_set_is_volatile (ValaField* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_volatile = value;
}

static gboolean
vala_field_real_get_lock_used (ValaLockable* base)
{
	gboolean result;
	ValaField* self;
	self = (ValaField*) base;
	result = self->priv->_lock_used;
	return result;
}

static void
vala_field_real_set_lock_used (ValaLockable* base,
                               gboolean value)
{
	ValaField* self;
	self = (ValaField*) base;
	self->priv->_lock_used = value;
}

/**
 * Creates a new field.
 *
 * @param name              field name
 * @param variable_type     field type
 * @param initializer       initializer expression
 * @param source_reference  reference to source code
 * @return                  newly created field
 */
ValaField*
vala_field_construct (GType object_type,
                      const gchar* name,
                      ValaDataType* variable_type,
                      ValaExpression* initializer,
                      ValaSourceReference* source_reference,
                      ValaComment* comment)
{
	ValaField* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (variable_type != NULL, NULL);
	self = (ValaField*) vala_variable_construct (object_type, variable_type, name, initializer, source_reference, comment);
	return self;
}

ValaField*
vala_field_new (const gchar* name,
                ValaDataType* variable_type,
                ValaExpression* initializer,
                ValaSourceReference* source_reference,
                ValaComment* comment)
{
	return vala_field_construct (VALA_TYPE_FIELD, name, variable_type, initializer, source_reference, comment);
}

static void
vala_field_real_accept (ValaCodeNode* base,
                        ValaCodeVisitor* visitor)
{
	ValaField * self;
	self = (ValaField*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_field (visitor, self);
}

static void
vala_field_real_accept_children (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaField * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaField*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp5_ = _tmp4_;
		vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
	}
}

static void
vala_field_real_replace_expression (ValaCodeNode* base,
                                    ValaExpression* old_node,
                                    ValaExpression* new_node)
{
	ValaField * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaField*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}

static void
vala_field_real_replace_type (ValaCodeNode* base,
                              ValaDataType* old_type,
                              ValaDataType* new_type)
{
	ValaField * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaField*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_field_real_check (ValaCodeNode* base,
                       ValaCodeContext* context)
{
	ValaField * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp28_;
	ValaDataType* _tmp29_;
	ValaTypeSymbol* _tmp30_;
	ValaTypeSymbol* _tmp31_;
	ValaSemanticAnalyzer* _tmp32_;
	ValaSemanticAnalyzer* _tmp33_;
	ValaDataType* _tmp34_;
	ValaTypeSymbol* _tmp35_;
	ValaTypeSymbol* _tmp36_;
	gboolean _tmp45_ = FALSE;
	ValaDataType* _tmp54_;
	ValaDataType* _tmp55_;
	gboolean _tmp56_;
	gboolean _tmp57_;
	ValaDataType* _tmp74_;
	ValaDataType* _tmp75_;
	ValaArrayType* variable_array_type = NULL;
	ValaDataType* _tmp84_;
	ValaDataType* _tmp85_;
	gboolean _tmp86_ = FALSE;
	gboolean _tmp87_ = FALSE;
	gboolean _tmp88_ = FALSE;
	ValaArrayType* _tmp89_;
	gboolean _tmp101_ = FALSE;
	gboolean _tmp102_ = FALSE;
	ValaArrayType* _tmp103_;
	ValaExpression* _tmp112_;
	ValaExpression* _tmp113_;
	gboolean _tmp234_ = FALSE;
	ValaMemberBinding _tmp235_;
	gboolean field_in_header = FALSE;
	ValaSymbol* _tmp240_;
	ValaSymbol* _tmp241_;
	gboolean _tmp250_ = FALSE;
	gboolean _tmp251_ = FALSE;
	gboolean _tmp252_;
	gboolean _tmp253_;
	ValaSemanticAnalyzer* _tmp266_;
	ValaSemanticAnalyzer* _tmp267_;
	ValaSourceFile* _tmp268_;
	ValaSemanticAnalyzer* _tmp269_;
	ValaSemanticAnalyzer* _tmp270_;
	ValaSymbol* _tmp271_;
	gboolean _tmp272_;
	gboolean _tmp273_;
	gboolean result;
	self = (ValaField*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	_tmp24_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp25_ = _tmp24_;
	if (VALA_IS_VOID_TYPE (_tmp25_)) {
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp27_ = _tmp26_;
		vala_report_error (_tmp27_, "'void' not supported as field type");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp28_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp29_ = _tmp28_;
	_tmp30_ = vala_data_type_get_type_symbol (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_code_context_get_analyzer (context);
	_tmp33_ = _tmp32_;
	_tmp34_ = _tmp33_->va_list_type;
	_tmp35_ = vala_data_type_get_type_symbol (_tmp34_);
	_tmp36_ = _tmp35_;
	if (_tmp31_ == _tmp36_) {
		ValaSourceReference* _tmp37_;
		ValaSourceReference* _tmp38_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		ValaTypeSymbol* _tmp41_;
		ValaTypeSymbol* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_data_type_get_type_symbol (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp42_);
		_tmp44_ = _tmp43_;
		vala_report_error (_tmp38_, "`%s' not supported as field type", _tmp44_);
		_g_free0 (_tmp44_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	if (vala_code_node_has_attribute ((ValaCodeNode*) self, "GtkChild")) {
		ValaDataType* _tmp46_;
		ValaDataType* _tmp47_;
		gboolean _tmp48_;
		gboolean _tmp49_;
		_tmp46_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_data_type_get_value_owned (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp45_ = _tmp49_;
	} else {
		_tmp45_ = FALSE;
	}
	if (_tmp45_) {
		ValaSourceReference* _tmp50_;
		ValaSourceReference* _tmp51_;
		ValaDataType* _tmp52_;
		ValaDataType* _tmp53_;
		_tmp50_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp51_ = _tmp50_;
		vala_report_warning (_tmp51_, "[GtkChild] fields must be declared as `unowned'");
		_tmp52_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp53_ = _tmp52_;
		vala_data_type_set_value_owned (_tmp53_, FALSE);
	}
	_tmp54_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp55_ = _tmp54_;
	vala_code_node_check ((ValaCodeNode*) _tmp55_, context);
	_tmp56_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp57_ = _tmp56_;
	if (!_tmp57_) {
		ValaSemanticAnalyzer* _tmp58_;
		ValaSemanticAnalyzer* _tmp59_;
		ValaDataType* _tmp60_;
		ValaDataType* _tmp61_;
		ValaDataType* _tmp62_;
		ValaDataType* _tmp63_;
		ValaTypeSymbol* _tmp64_;
		ValaTypeSymbol* _tmp65_;
		_tmp58_ = vala_code_context_get_analyzer (context);
		_tmp59_ = _tmp58_;
		_tmp60_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp61_ = _tmp60_;
		vala_semantic_analyzer_check_type (_tmp59_, _tmp61_);
		_tmp62_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp63_ = _tmp62_;
		_tmp64_ = vala_data_type_get_type_symbol (_tmp63_);
		_tmp65_ = _tmp64_;
		if (_tmp65_ != NULL) {
			ValaDataType* _tmp66_;
			ValaDataType* _tmp67_;
			ValaTypeSymbol* _tmp68_;
			ValaTypeSymbol* _tmp69_;
			ValaVersionAttribute* _tmp70_;
			ValaVersionAttribute* _tmp71_;
			ValaSourceReference* _tmp72_;
			ValaSourceReference* _tmp73_;
			_tmp66_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp67_ = _tmp66_;
			_tmp68_ = vala_data_type_get_type_symbol (_tmp67_);
			_tmp69_ = _tmp68_;
			_tmp70_ = vala_symbol_get_version ((ValaSymbol*) _tmp69_);
			_tmp71_ = _tmp70_;
			_tmp72_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp73_ = _tmp72_;
			vala_version_attribute_check (_tmp71_, context, _tmp73_);
		}
	}
	_tmp74_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp75_ = _tmp74_;
	if (!vala_data_type_is_accessible (_tmp75_, (ValaSymbol*) self)) {
		ValaSourceReference* _tmp76_;
		ValaSourceReference* _tmp77_;
		ValaDataType* _tmp78_;
		ValaDataType* _tmp79_;
		gchar* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		gchar* _tmp83_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp77_ = _tmp76_;
		_tmp78_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp79_ = _tmp78_;
		_tmp80_ = vala_code_node_to_string ((ValaCodeNode*) _tmp79_);
		_tmp81_ = _tmp80_;
		_tmp82_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp83_ = _tmp82_;
		vala_report_error (_tmp77_, "field type `%s' is less accessible than field `%s'", _tmp81_, _tmp83_);
		_g_free0 (_tmp83_);
		_g_free0 (_tmp81_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp84_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp85_ = _tmp84_;
	variable_array_type = VALA_IS_ARRAY_TYPE (_tmp85_) ? ((ValaArrayType*) _tmp85_) : NULL;
	_tmp89_ = variable_array_type;
	if (_tmp89_ != NULL) {
		ValaArrayType* _tmp90_;
		gboolean _tmp91_;
		gboolean _tmp92_;
		_tmp90_ = variable_array_type;
		_tmp91_ = vala_array_type_get_inline_allocated (_tmp90_);
		_tmp92_ = _tmp91_;
		_tmp88_ = _tmp92_;
	} else {
		_tmp88_ = FALSE;
	}
	if (_tmp88_) {
		ValaExpression* _tmp93_;
		ValaExpression* _tmp94_;
		_tmp93_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp94_ = _tmp93_;
		_tmp87_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp94_);
	} else {
		_tmp87_ = FALSE;
	}
	if (_tmp87_) {
		ValaExpression* _tmp95_;
		ValaExpression* _tmp96_;
		ValaInitializerList* _tmp97_;
		ValaInitializerList* _tmp98_;
		_tmp95_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp96_ = _tmp95_;
		_tmp97_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp96_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
		_tmp98_ = _tmp97_;
		_tmp86_ = _tmp98_ == NULL;
	} else {
		_tmp86_ = FALSE;
	}
	if (_tmp86_) {
		ValaSourceReference* _tmp99_;
		ValaSourceReference* _tmp100_;
		_tmp99_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp100_ = _tmp99_;
		vala_report_warning (_tmp100_, "Inline allocated arrays don't require an explicit instantiation");
		vala_variable_set_initializer ((ValaVariable*) self, NULL);
	}
	_tmp103_ = variable_array_type;
	if (_tmp103_ != NULL) {
		ValaArrayType* _tmp104_;
		gboolean _tmp105_;
		gboolean _tmp106_;
		_tmp104_ = variable_array_type;
		_tmp105_ = vala_array_type_get_inline_allocated (_tmp104_);
		_tmp106_ = _tmp105_;
		_tmp102_ = _tmp106_;
	} else {
		_tmp102_ = FALSE;
	}
	if (_tmp102_) {
		ValaArrayType* _tmp107_;
		gboolean _tmp108_;
		gboolean _tmp109_;
		_tmp107_ = variable_array_type;
		_tmp108_ = vala_array_type_get_fixed_length (_tmp107_);
		_tmp109_ = _tmp108_;
		_tmp101_ = !_tmp109_;
	} else {
		_tmp101_ = FALSE;
	}
	if (_tmp101_) {
		ValaSourceReference* _tmp110_;
		ValaSourceReference* _tmp111_;
		_tmp110_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp111_ = _tmp110_;
		vala_report_error (_tmp111_, "Inline allocated array as field requires to have fixed length");
	}
	_tmp112_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp113_ = _tmp112_;
	if (_tmp113_ != NULL) {
		ValaExpression* _tmp114_;
		ValaExpression* _tmp115_;
		ValaDataType* _tmp116_;
		ValaDataType* _tmp117_;
		gboolean is_initializer_list = FALSE;
		gint initializer_size = 0;
		ValaExpression* _tmp118_;
		ValaExpression* _tmp119_;
		ValaExpression* _tmp124_;
		ValaExpression* _tmp125_;
		ValaExpression* _tmp126_;
		ValaExpression* _tmp127_;
		ValaDataType* _tmp128_;
		ValaDataType* _tmp129_;
		ValaExpression* _tmp132_;
		ValaExpression* _tmp133_;
		ValaDataType* _tmp134_;
		ValaDataType* _tmp135_;
		ValaDataType* _tmp136_;
		ValaDataType* _tmp137_;
		gboolean _tmp150_ = FALSE;
		gboolean _tmp151_ = FALSE;
		gboolean _tmp152_ = FALSE;
		ValaArrayType* _tmp153_;
		gboolean _tmp167_ = FALSE;
		gboolean _tmp168_ = FALSE;
		ValaArrayType* _tmp169_;
		ValaExpression* _tmp179_;
		ValaExpression* _tmp180_;
		ValaDataType* _tmp181_;
		ValaDataType* _tmp182_;
		gboolean _tmp192_ = FALSE;
		ValaSymbol* _tmp193_;
		ValaSymbol* _tmp194_;
		gboolean _tmp199_ = FALSE;
		gboolean _tmp200_ = FALSE;
		ValaSymbol* _tmp201_;
		ValaSymbol* _tmp202_;
		gboolean _tmp216_ = FALSE;
		gboolean _tmp217_ = FALSE;
		gboolean _tmp218_ = FALSE;
		ValaMemberBinding _tmp219_;
		gboolean _tmp230_;
		gboolean _tmp231_;
		_tmp114_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp115_ = _tmp114_;
		_tmp116_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp117_ = _tmp116_;
		vala_expression_set_target_type (_tmp115_, _tmp117_);
		is_initializer_list = FALSE;
		initializer_size = -1;
		_tmp118_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp119_ = _tmp118_;
		if (VALA_IS_INITIALIZER_LIST (_tmp119_)) {
			ValaExpression* _tmp120_;
			ValaExpression* _tmp121_;
			gint _tmp122_;
			gint _tmp123_;
			_tmp120_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp121_ = _tmp120_;
			_tmp122_ = vala_initializer_list_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp121_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
			_tmp123_ = _tmp122_;
			initializer_size = _tmp123_;
			is_initializer_list = TRUE;
		}
		_tmp124_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp125_ = _tmp124_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp125_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp126_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp127_ = _tmp126_;
		_tmp128_ = vala_expression_get_value_type (_tmp127_);
		_tmp129_ = _tmp128_;
		if (_tmp129_ == NULL) {
			ValaSourceReference* _tmp130_;
			ValaSourceReference* _tmp131_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp130_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp131_ = _tmp130_;
			vala_report_error (_tmp131_, "expression type not allowed as initializer");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp132_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp133_ = _tmp132_;
		_tmp134_ = vala_expression_get_value_type (_tmp133_);
		_tmp135_ = _tmp134_;
		_tmp136_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp137_ = _tmp136_;
		if (!vala_data_type_compatible (_tmp135_, _tmp137_)) {
			ValaSourceReference* _tmp138_;
			ValaSourceReference* _tmp139_;
			ValaExpression* _tmp140_;
			ValaExpression* _tmp141_;
			ValaDataType* _tmp142_;
			ValaDataType* _tmp143_;
			gchar* _tmp144_;
			gchar* _tmp145_;
			ValaDataType* _tmp146_;
			ValaDataType* _tmp147_;
			gchar* _tmp148_;
			gchar* _tmp149_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp138_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp139_ = _tmp138_;
			_tmp140_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp141_ = _tmp140_;
			_tmp142_ = vala_expression_get_value_type (_tmp141_);
			_tmp143_ = _tmp142_;
			_tmp144_ = vala_code_node_to_string ((ValaCodeNode*) _tmp143_);
			_tmp145_ = _tmp144_;
			_tmp146_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp147_ = _tmp146_;
			_tmp148_ = vala_code_node_to_string ((ValaCodeNode*) _tmp147_);
			_tmp149_ = _tmp148_;
			vala_report_error (_tmp139_, "Cannot convert from `%s' to `%s'", _tmp145_, _tmp149_);
			_g_free0 (_tmp149_);
			_g_free0 (_tmp145_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp153_ = variable_array_type;
		if (_tmp153_ != NULL) {
			ValaArrayType* _tmp154_;
			gboolean _tmp155_;
			gboolean _tmp156_;
			_tmp154_ = variable_array_type;
			_tmp155_ = vala_array_type_get_inline_allocated (_tmp154_);
			_tmp156_ = _tmp155_;
			_tmp152_ = _tmp156_;
		} else {
			_tmp152_ = FALSE;
		}
		if (_tmp152_) {
			ValaArrayType* _tmp157_;
			gboolean _tmp158_;
			gboolean _tmp159_;
			_tmp157_ = variable_array_type;
			_tmp158_ = vala_array_type_get_fixed_length (_tmp157_);
			_tmp159_ = _tmp158_;
			_tmp151_ = !_tmp159_;
		} else {
			_tmp151_ = FALSE;
		}
		if (_tmp151_) {
			_tmp150_ = is_initializer_list;
		} else {
			_tmp150_ = FALSE;
		}
		if (_tmp150_) {
			ValaArrayType* _tmp160_;
			gchar* _tmp161_;
			gchar* _tmp162_;
			ValaIntegerLiteral* _tmp163_;
			ValaIntegerLiteral* _tmp164_;
			ValaArrayType* _tmp165_;
			ValaArrayType* _tmp166_;
			_tmp160_ = variable_array_type;
			_tmp161_ = g_strdup_printf ("%i", initializer_size);
			_tmp162_ = _tmp161_;
			_tmp163_ = vala_integer_literal_new (_tmp162_, NULL);
			_tmp164_ = _tmp163_;
			vala_array_type_set_length (_tmp160_, (ValaExpression*) _tmp164_);
			_vala_code_node_unref0 (_tmp164_);
			_g_free0 (_tmp162_);
			_tmp165_ = variable_array_type;
			vala_array_type_set_fixed_length (_tmp165_, TRUE);
			_tmp166_ = variable_array_type;
			vala_data_type_set_nullable ((ValaDataType*) _tmp166_, FALSE);
		}
		_tmp169_ = variable_array_type;
		if (_tmp169_ != NULL) {
			ValaArrayType* _tmp170_;
			gboolean _tmp171_;
			gboolean _tmp172_;
			_tmp170_ = variable_array_type;
			_tmp171_ = vala_array_type_get_inline_allocated (_tmp170_);
			_tmp172_ = _tmp171_;
			_tmp168_ = _tmp172_;
		} else {
			_tmp168_ = FALSE;
		}
		if (_tmp168_) {
			ValaExpression* _tmp173_;
			ValaExpression* _tmp174_;
			ValaDataType* _tmp175_;
			ValaDataType* _tmp176_;
			_tmp173_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp174_ = _tmp173_;
			_tmp175_ = vala_expression_get_value_type (_tmp174_);
			_tmp176_ = _tmp175_;
			_tmp167_ = !VALA_IS_ARRAY_TYPE (_tmp176_);
		} else {
			_tmp167_ = FALSE;
		}
		if (_tmp167_) {
			ValaSourceReference* _tmp177_;
			ValaSourceReference* _tmp178_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp177_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp178_ = _tmp177_;
			vala_report_error (_tmp178_, "only arrays are allowed as initializer for arrays with fixed length");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp179_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp180_ = _tmp179_;
		_tmp181_ = vala_expression_get_value_type (_tmp180_);
		_tmp182_ = _tmp181_;
		if (vala_data_type_is_disposable (_tmp182_)) {
			gboolean _tmp183_ = FALSE;
			ValaDataType* _tmp184_;
			ValaDataType* _tmp185_;
			_tmp184_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp185_ = _tmp184_;
			if (!VALA_IS_POINTER_TYPE (_tmp185_)) {
				ValaDataType* _tmp186_;
				ValaDataType* _tmp187_;
				gboolean _tmp188_;
				gboolean _tmp189_;
				_tmp186_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp187_ = _tmp186_;
				_tmp188_ = vala_data_type_get_value_owned (_tmp187_);
				_tmp189_ = _tmp188_;
				_tmp183_ = !_tmp189_;
			} else {
				_tmp183_ = FALSE;
			}
			if (_tmp183_) {
				ValaSourceReference* _tmp190_;
				ValaSourceReference* _tmp191_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp190_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp191_ = _tmp190_;
				vala_report_error (_tmp191_, "Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
		_tmp193_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp194_ = _tmp193_;
		if (VALA_IS_NAMESPACE (_tmp194_)) {
			ValaExpression* _tmp195_;
			ValaExpression* _tmp196_;
			_tmp195_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp196_ = _tmp195_;
			_tmp192_ = !vala_expression_is_constant (_tmp196_);
		} else {
			_tmp192_ = FALSE;
		}
		if (_tmp192_) {
			ValaSourceReference* _tmp197_;
			ValaSourceReference* _tmp198_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp197_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp198_ = _tmp197_;
			vala_report_error (_tmp198_, "Non-constant field initializers not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp201_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp202_ = _tmp201_;
		if (VALA_IS_NAMESPACE (_tmp202_)) {
			ValaExpression* _tmp203_;
			ValaExpression* _tmp204_;
			_tmp203_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp204_ = _tmp203_;
			_tmp200_ = vala_expression_is_constant (_tmp204_);
		} else {
			_tmp200_ = FALSE;
		}
		if (_tmp200_) {
			ValaExpression* _tmp205_;
			ValaExpression* _tmp206_;
			_tmp205_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp206_ = _tmp205_;
			_tmp199_ = vala_expression_is_non_null (_tmp206_);
		} else {
			_tmp199_ = FALSE;
		}
		if (_tmp199_) {
			gboolean _tmp207_ = FALSE;
			ValaDataType* _tmp208_;
			ValaDataType* _tmp209_;
			_tmp208_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp209_ = _tmp208_;
			if (vala_data_type_is_disposable (_tmp209_)) {
				ValaDataType* _tmp210_;
				ValaDataType* _tmp211_;
				gboolean _tmp212_;
				gboolean _tmp213_;
				_tmp210_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp211_ = _tmp210_;
				_tmp212_ = vala_data_type_get_value_owned (_tmp211_);
				_tmp213_ = _tmp212_;
				_tmp207_ = _tmp213_;
			} else {
				_tmp207_ = FALSE;
			}
			if (_tmp207_) {
				ValaSourceReference* _tmp214_;
				ValaSourceReference* _tmp215_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp214_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp215_ = _tmp214_;
				vala_report_error (_tmp215_, "Owned namespace fields can only be initialized in a function or method");
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
		_tmp219_ = self->priv->_binding;
		if (_tmp219_ == VALA_MEMBER_BINDING_STATIC) {
			ValaSymbol* _tmp220_;
			ValaSymbol* _tmp221_;
			_tmp220_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp221_ = _tmp220_;
			_tmp218_ = VALA_IS_CLASS (_tmp221_);
		} else {
			_tmp218_ = FALSE;
		}
		if (_tmp218_) {
			ValaSymbol* _tmp222_;
			ValaSymbol* _tmp223_;
			gboolean _tmp224_;
			gboolean _tmp225_;
			_tmp222_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp223_ = _tmp222_;
			_tmp224_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp223_, VALA_TYPE_CLASS, ValaClass));
			_tmp225_ = _tmp224_;
			_tmp217_ = _tmp225_;
		} else {
			_tmp217_ = FALSE;
		}
		if (_tmp217_) {
			ValaExpression* _tmp226_;
			ValaExpression* _tmp227_;
			_tmp226_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp227_ = _tmp226_;
			_tmp216_ = !vala_expression_is_constant (_tmp227_);
		} else {
			_tmp216_ = FALSE;
		}
		if (_tmp216_) {
			ValaSourceReference* _tmp228_;
			ValaSourceReference* _tmp229_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp228_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp229_ = _tmp228_;
			vala_report_error (_tmp229_, "Static fields in compact classes cannot have non-constant initializers");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp230_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp231_ = _tmp230_;
		if (_tmp231_) {
			ValaSourceReference* _tmp232_;
			ValaSourceReference* _tmp233_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp232_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp233_ = _tmp232_;
			vala_report_error (_tmp233_, "External fields cannot use initializers");
		}
	}
	_tmp235_ = self->priv->_binding;
	if (_tmp235_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaSymbol* _tmp236_;
		ValaSymbol* _tmp237_;
		_tmp236_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp237_ = _tmp236_;
		_tmp234_ = VALA_IS_INTERFACE (_tmp237_);
	} else {
		_tmp234_ = FALSE;
	}
	if (_tmp234_) {
		ValaSourceReference* _tmp238_;
		ValaSourceReference* _tmp239_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp238_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp239_ = _tmp238_;
		vala_report_error (_tmp239_, "Interfaces may not have instance fields");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	field_in_header = !vala_symbol_is_internal_symbol ((ValaSymbol*) self);
	_tmp240_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp241_ = _tmp240_;
	if (VALA_IS_CLASS (_tmp241_)) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp242_;
		ValaSymbol* _tmp243_;
		ValaClass* _tmp244_;
		gboolean _tmp245_ = FALSE;
		ValaClass* _tmp246_;
		gboolean _tmp247_;
		gboolean _tmp248_;
		_tmp242_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp243_ = _tmp242_;
		_tmp244_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp243_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp244_;
		_tmp246_ = cl;
		_tmp247_ = vala_class_get_is_compact (_tmp246_);
		_tmp248_ = _tmp247_;
		if (_tmp248_) {
			ValaClass* _tmp249_;
			_tmp249_ = cl;
			_tmp245_ = !vala_symbol_is_internal_symbol ((ValaSymbol*) _tmp249_);
		} else {
			_tmp245_ = FALSE;
		}
		if (_tmp245_) {
			field_in_header = TRUE;
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp252_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp253_ = _tmp252_;
	if (!_tmp253_) {
		gboolean _tmp254_;
		gboolean _tmp255_;
		_tmp254_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp255_ = _tmp254_;
		_tmp251_ = !_tmp255_;
	} else {
		_tmp251_ = FALSE;
	}
	if (_tmp251_) {
		ValaSymbol* _tmp256_;
		ValaSymbol* _tmp257_;
		_tmp256_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp257_ = _tmp256_;
		_tmp250_ = _tmp257_ != NULL;
		_vala_code_node_unref0 (_tmp257_);
	} else {
		_tmp250_ = FALSE;
	}
	if (_tmp250_) {
		ValaSourceReference* _tmp258_;
		ValaSourceReference* _tmp259_;
		gchar* _tmp260_;
		gchar* _tmp261_;
		ValaSymbol* _tmp262_;
		ValaSymbol* _tmp263_;
		gchar* _tmp264_;
		gchar* _tmp265_;
		_tmp258_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp259_ = _tmp258_;
		_tmp260_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp261_ = _tmp260_;
		_tmp262_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp263_ = _tmp262_;
		_tmp264_ = vala_symbol_get_full_name (_tmp263_);
		_tmp265_ = _tmp264_;
		vala_report_warning (_tmp259_, "%s hides inherited field `%s'. Use the `new' keyword if hiding was int" \
"entional", _tmp261_, _tmp265_);
		_g_free0 (_tmp265_);
		_vala_code_node_unref0 (_tmp263_);
		_g_free0 (_tmp261_);
	}
	_tmp266_ = vala_code_context_get_analyzer (context);
	_tmp267_ = _tmp266_;
	_tmp268_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp267_, _tmp268_);
	_tmp269_ = vala_code_context_get_analyzer (context);
	_tmp270_ = _tmp269_;
	_tmp271_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp270_, _tmp271_);
	_tmp272_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp273_ = _tmp272_;
	result = !_tmp273_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_field_class_init (ValaFieldClass * klass,
                       gpointer klass_data)
{
	vala_field_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_field_finalize;
	g_type_class_adjust_private_offset (klass, &ValaField_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_field_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_field_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_field_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_field_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_field_real_check;
}

static void
vala_field_vala_lockable_interface_init (ValaLockableIface * iface,
                                         gpointer iface_data)
{
	vala_field_vala_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_lock_used = vala_field_real_get_lock_used;
	iface->set_lock_used = vala_field_real_set_lock_used;
}

static void
vala_field_instance_init (ValaField * self,
                          gpointer klass)
{
	self->priv = vala_field_get_instance_private (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
}

static void
vala_field_finalize (ValaCodeNode * obj)
{
	ValaField * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_FIELD, ValaField);
	VALA_CODE_NODE_CLASS (vala_field_parent_class)->finalize (obj);
}

/**
 * Represents a type or namespace field.
 */
static GType
vala_field_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaFieldClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_field_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaField), 0, (GInstanceInitFunc) vala_field_instance_init, NULL };
	static const GInterfaceInfo vala_lockable_info = { (GInterfaceInitFunc) vala_field_vala_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_field_type_id;
	vala_field_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaField", &g_define_type_info, 0);
	g_type_add_interface_static (vala_field_type_id, VALA_TYPE_LOCKABLE, &vala_lockable_info);
	ValaField_private_offset = g_type_add_instance_private (vala_field_type_id, sizeof (ValaFieldPrivate));
	return vala_field_type_id;
}

GType
vala_field_get_type (void)
{
	static volatile gsize vala_field_type_id__once = 0;
	if (g_once_init_enter (&vala_field_type_id__once)) {
		GType vala_field_type_id;
		vala_field_type_id = vala_field_get_type_once ();
		g_once_init_leave (&vala_field_type_id__once, vala_field_type_id);
	}
	return vala_field_type_id__once;
}

