// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 2
// REQUIRES: bpf-registered-target
// RUN: %clang -cc1 -triple bpf -disable-llvm-passes -S -emit-llvm -o - %s \
// RUN: | FileCheck %s

// Verify that preserve_static_offset does not interfere with
// preserve_access_index at IR generation stage.

#define __ctx __attribute__((preserve_static_offset))
#define __pai __attribute__((preserve_access_index))

struct foo {
  int a;
} __ctx __pai;

// CHECK-LABEL: define dso_local i32 @bar
// CHECK-SAME: (ptr noundef [[P:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[P_ADDR:%.*]] = alloca ptr, align 8
// CHECK-NEXT:    store ptr [[P]], ptr [[P_ADDR]], align 8
// CHECK-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[P_ADDR]], align 8
// CHECK-NEXT:    [[TMP1:%.*]] = call ptr @llvm.preserve.static.offset(ptr [[TMP0]])
// CHECK-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_FOO:%.*]], ptr [[TMP1]], i32 0, i32 0
// CHECK-NEXT:    [[TMP2:%.*]] = load i32, ptr [[A]], align 4
// CHECK-NEXT:    ret i32 [[TMP2]]
//
int bar(struct foo *p) {
  return p->a;
}
