.TH libinput-analyze-per-slot-delta "1"
.SH NAME
libinput\-analyze\-per\-slot\-delta \- analyze the per-event delta movement for touch slots
.SH SYNOPSIS
.B libinput analyze per-slot-delta [\-\-help] [options] \fIrecording.yml\fI
.SH DESCRIPTION
.PP
The
.B "libinput analyze per\-slot\-delta"
tool analyzes a recording made with
.B "libinput record"
and prints the delta movement per touch slot.
.PP
This is a debugging tool only, its output may change at any time. Do not
rely on the output.
.SH OPTIONS
.TP 8
.B \-\-help
Print help
.TP 8
.B \-\-ignore-below=<units or mm>
Ignore any movement below the given threshold. The threshold is in
mm if \fB\-\-use-mm\fR is selected or in device units otherwise.
.TP 8
.B \-\-threshold=<units or mm>
Color any movement above this threshold in red. The threshold is in
mm if \fB\-\-use-mm\fR is selected or in device units otherwise.
.TP 8
.B \-\-use-mm
Print data in mm instead of device units
.TP 8
.B \-\-use-st
Use the single-touch ABS_X/ABS_Y instead of the multitouch axes
.TP 8
.B \-\-use-absolute
Print absolute coordinates, not deltas
.SH OUTPUT
An example output for a single finger touch on a touchpad supporting two
slots is below. This output is with the use of the
.B --use-mm
flag.
.PP
.nf
.sf
 0.000000   +0ms TOU:     ++++++     |  ************* |
 0.021900  +21ms TOU: →↘ +1.10/+0.14 |  ************* |
 0.033468  +11ms TOU: →↘ +1.15/+0.19 |  ************* |
 0.043856  +10ms TOU: →↘ +1.76/+0.22 |  ************* |
 0.053237   +9ms TOU: →↘ +2.20/+0.19 |  ************* |
.fi
.in
.PP
The entry
.B ++++++
indicates a finger has been put down,
.B ------
indicates the finger has lifted.
The left-most column is the absolute timestamp in seconds.microseconds
followed by the relative time of the event to the previous event.
.PP
The word
.B TOU
in this example represents
BTN_TOUCH, similar abbreviations exist for
BTN_TOOL_DOUBLETAP, BTN_TOOL_TRIPLETAP, BTN_TOOL_QUADTAP, and
BTN_TOOL_QUINTTAP.
.PP
The arrows
indicate the approximate direction on a 16-point compass, in this example
EastSouthEast.
.PP
Each multitouch slot supported by the hardware has one column, where the
column shows asterisk
.B ********
no finger is down for that slot. Where the column shows spaces only, a
finger is down but no data is currently available.
.PP
In the above example, the third events occurs ~33ms into the recording, is
11ms after the previous event and has an east south-east direction. The
movement for this event was x: 1.15 and y: 0.19 mm. A second finger is not
currently down.
.SH LIBINPUT
Part of the
.B libinput(1)
suite


