# Messages

Messages are refcounted lightweight objects to signal the application of
pipeline events.

Messages are implemented as a subclass of `GstMiniObject` with a generic
`GstStructure` as the content. This allows for writing custom messages
without requiring an API change while allowing a wide range of different
types of messages.

Messages are posted by objects in the pipeline and are passed to the
application using the `GstBus` (See also [gstbus](additional/design/gstbus.md)
and [gstpipeline](additional/design/gstpipeline.md)).

## Message types

**`GST_MESSAGE_EOS`**: Posted by sink elements. This message is posted to the
application when all the sinks in a pipeline have posted an EOS message. When
performing a flushing seek, the EOS state of the pipeline and sinks is reset.

**`GST_MESSAGE_ERROR`**: An element in the pipeline got into an error state.
The message carries a GError and a debug string describing the error. This
usually means that part of the pipeline is not streaming anymore.

**`GST_MESSAGE_WARNING`**: An element in the pipeline encountered a condition
that made it produce a warning. This could be a recoverable decoding error or
some other non fatal event. The pipeline continues streaming after a warning.

**`GST_MESSAGE_INFO`**: An element produced an informational message.

**`GST_MESSAGE_TAG`**: An element decoded metadata about the stream. The
message carries a `GstTagList` with the tag information.

**`GST_MESSAGE_BUFFERING`**: An element is buffering data and that could
potentially take some time. This message is typically emitted by elements that
perform some sort of network buffering. While the pipeline is buffering it
should remain in the `PAUSED` state. When the buffering is finished, it can
resume `PLAYING`.

**`GST_MESSAGE_STATE_CHANGED`**: An element changed state in the pipeline.
The message carries the old, new and pending state of the element.

**`GST_MESSAGE_STATE_DIRTY`**: An internal message used to instruct
a pipeline hierarchy that a state recalculation must be performed because of an
ASYNC state change completed. This message is not used anymore.

**`GST_MESSAGE_STEP_DONE`**: An element stepping frames has finished. This is
currently not used.

**`GST_MESSAGE_CLOCK_PROVIDE`**: An element notifies its capability of
providing a clock for the pipeline.

**`GST_MESSAGE_CLOCK_LOST`**: The current clock, as selected by the pipeline,
became unusable. The pipeline will select a new clock on the next PLAYING state
change.

**`GST_MESSAGE_NEW_CLOCK`**: A new clock was selected for the pipeline.

**`GST_MESSAGE_STRUCTURE_CHANGE`**: The pipeline changed its structure, This
means elements were added or removed or pads were linked or unlinked. This
message is not yet used.

**`GST_MESSAGE_STREAM_STATUS`**: Posted by an element when it
starts/stops/pauses a streaming task. It contains information about the reason
why the stream state changed along with the thread id. The application can use
this information to detect failures in streaming threads and/or to adjust
streaming thread priorities.

**`GST_MESSAGE_APPLICATION`**: The application posted a message. This message
must be used when the application posts a message on the bus.

**`GST_MESSAGE_ELEMENT`**: Element-specific message. See the specific
element's documentation

**`GST_MESSAGE_SEGMENT_START`**: An element started playback of a new
segment. This message is not forwarded to applications but is used internally
to schedule `SEGMENT_DONE` messages.

**`GST_MESSAGE_SEGMENT_DONE`**: An element or bin completed playback of
a segment. This message is only posted on the bus if a `SEGMENT` seek is
performed on a pipeline.

**`GST_MESSAGE_DURATION_CHANGED`**: An element posts this message when it has
detected or updated the stream duration.

**`GST_MESSAGE_ASYNC_START`**: Posted by sinks when they start an
asynchronous state change.

**`GST_MESSAGE_ASYNC_DONE`**: Posted by sinks when they receive the first
data buffer and complete the asynchronous state change.

**`GST_MESSAGE_LATENCY`**: Posted by elements when the latency in a pipeline
changed and a new global latency should be calculated by the pipeline or
application.

**`GST_MESSAGE_REQUEST_STATE`**: Posted by elements when they want to change
the state of the pipeline they are in. A typical use case would be an audio
sink that requests the pipeline to pause in order to play a higher priority
stream.

**`GST_MESSAGE_STEP_START`**: A stepping operation has started.

**`GST_MESSAGE_QOS`**: A buffer was dropped or an element changed its
processing strategy for Quality of Service reasons.

**`GST_MESSAGE_PROGRESS`**: A progress message was posted. Progress messages
inform the application about the state of asynchronous operations.

**`GST_MESSAGE_TOC`**: A new table of contents (TOC) was found or a previously
found one was updated.

**`GST_MESSAGE_STREAM_START`**: Signals the start of a new stream.

**`GST_MESSAGE_NEED_CONTEXT`**: Signals that an element wants a specific context (Since 1.2)

**`GST_MESSAGE_HAVE_CONTEXT`**: Signals that an element created a context (Since 1.2)
