/* Unit testing for outcomes
(C) 2013-2023 Niall Douglas <http://www.nedproductions.biz/> (7 commits)


Boost Software License - Version 1.0 - August 17th, 2003

Permission is hereby granted, free of charge, to any person or organization
obtaining a copy of the software and accompanying documentation covered by
this license (the "Software") to use, reproduce, display, distribute,
execute, and transmit the Software, and to prepare derivative works of the
Software, and to permit third-parties to whom the Software is furnished to
do so, all subject to the following:

The copyright notices in the Software and this entire statement, including
the above license grant, this restriction and the following disclaimer,
must be included in all copies of the Software, in whole or in part, and
all derivative works of the Software, unless such copies or derivative
works are solely in the form of machine-executable object code generated by
a source language processor.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
*/

#include <boost/outcome.hpp>
#include <boost/outcome/try.hpp>
#include <boost/test/unit_test.hpp>
#include <boost/test/unit_test_monitor.hpp>

BOOST_OUTCOME_AUTO_TEST_CASE(works_outcome_propagate, "Tests that the outcome propagates errors between different editions of itself")
{
  using namespace BOOST_OUTCOME_V2_NAMESPACE;
  {
    auto t0 = [&](int a) { return result<long>(boost::system::error_code(a, boost::system::generic_category())); };
    auto t1 = [&](int a) {
      result<double> f(t0(a));  // double is constructible from long
      BOOST_CHECK(!f.has_value());
      BOOST_CHECK(f.has_error());
      return f;
    };
    auto t2 = [&](int a) {
      result<void> f(t1(a).error());
      BOOST_CHECK(!f.has_value());
      BOOST_CHECK(f.has_error());
      return f;
    };
    auto t3 = [&](int a) {
      outcome<std::string> f(t2(a));
      BOOST_CHECK(!f.has_value());
      BOOST_CHECK(f.has_error());
      return f;
    };
    BOOST_CHECK(t3(5).error().value() == 5);
    result<int> a2{result<void>(in_place_type<void>)};
    result<int> a3{result<void>(boost::system::error_code(5, boost::system::generic_category()))};
    BOOST_CHECK(a2.has_value());
    BOOST_CHECK(!a2.has_error());
    BOOST_CHECK(!a3.has_value());
    BOOST_CHECK(a3.has_error());
  }
  {
    auto t0 = [&](int a) { return result<long>(a); };
    auto t1 = [&](int a) -> result<std::string> {
      BOOST_OUTCOME_TRY(auto &&f, (t0(a)));
      return std::to_string(f);
    };
    BOOST_CHECK(t1(5).value() == "5");
  }
  {
    auto t0 = [&](int a) { return result<long>(a); };
    auto t1 = [&](int a) -> outcome<std::string> {
      BOOST_OUTCOME_TRY(auto &&f, (t0(a)));
      return std::to_string(f);
    };
    BOOST_CHECK(t1(5).value() == "5");
  }
  {
    auto t0 = [&](int a) -> result<long> { return result<long>(a); };
    auto t1 = [&](int a) -> outcome<void> {
      BOOST_OUTCOME_TRY((t0(a)));
      return outcome<void>(in_place_type<void>);
    };
    (void) t1(5);
  }
}
