/* loudmouth-1.0.vapi generated by vapigen, do not modify. */

namespace Lm {
	[CCode (cheader_filename = "loudmouth/loudmouth.h", ref_function = "lm_connection_ref", unref_function = "lm_connection_unref")]
	[Compact]
	public class Connection {
		public const int DEFAULT_PORT;
		public const int DEFAULT_PORT_SSL;
		[CCode (has_construct_function = false)]
		public Connection (string server);
		public bool authenticate (string username, string password, string resource, Lm.ResultFunction function, GLib.DestroyNotify? notify) throws GLib.Error;
		public bool authenticate_and_block (string username, string password, string resource) throws GLib.Error;
		public void cancel_open ();
		public bool close () throws GLib.Error;
		public unowned string get_full_jid ();
		public unowned string get_jid ();
		public uint get_keep_alive_rate ();
		public string get_local_host ();
		public uint get_port ();
		public unowned Lm.Proxy get_proxy ();
		public unowned string get_server ();
		public unowned Lm.SSL get_ssl ();
		public Lm.ConnectionState get_state ();
		public bool is_authenticated ();
		public bool is_open ();
		public bool open (Lm.ResultFunction function, GLib.DestroyNotify? notify) throws GLib.Error;
		public bool open_and_block () throws GLib.Error;
		public void register_message_handler (Lm.MessageHandler handler, Lm.MessageType type, Lm.HandlerPriority priority);
		public bool send (Lm.Message message) throws GLib.Error;
		public bool send_raw (string str) throws GLib.Error;
		public bool send_with_reply (Lm.Message message, Lm.MessageHandler handler) throws GLib.Error;
		public Lm.Message send_with_reply_and_block (Lm.Message message) throws GLib.Error;
		public void set_disconnect_function (Lm.DisconnectFunction function, GLib.DestroyNotify? notify);
		public void set_jid (string jid);
		public void set_keep_alive_rate (uint rate);
		public void set_port (uint port);
		public void set_proxy (Lm.Proxy proxy);
		public void set_server (string server);
		public void set_ssl (Lm.SSL ssl);
		public void unregister_message_handler (Lm.MessageHandler handler, Lm.MessageType type);
		[CCode (has_construct_function = false)]
		public Connection.with_context (string server, GLib.MainContext context);
	}
	[CCode (cheader_filename = "loudmouth/loudmouth.h", ref_function = "lm_message_ref", unref_function = "lm_message_unref")]
	[Compact]
	public class Message {
		public Lm.MessageNode node;
		[CCode (has_construct_function = false)]
		public Message (string? to, Lm.MessageType type);
		public unowned Lm.MessageNode get_node ();
		public Lm.MessageSubType get_sub_type ();
		public Lm.MessageType get_type ();
		[CCode (has_construct_function = false)]
		public Message.with_sub_type (string? to, Lm.MessageType type, Lm.MessageSubType sub_type);
	}
	[CCode (cheader_filename = "loudmouth/loudmouth.h", ref_function = "lm_message_handler_ref", unref_function = "lm_message_handler_unref")]
	[Compact]
	public class MessageHandler {
		[CCode (has_construct_function = false)]
		public MessageHandler (Lm.HandleMessageFunction function, GLib.DestroyNotify? notify);
		public void invalidate ();
		public bool is_valid ();
	}
	[CCode (cheader_filename = "loudmouth/loudmouth.h", ref_function = "lm_message_node_ref", unref_function = "lm_message_node_unref")]
	[Compact]
	public class MessageNode {
		public Lm.MessageNode children;
		public string name;
		public weak Lm.MessageNode next;
		public weak Lm.MessageNode parent;
		public weak Lm.MessageNode prev;
		public bool raw_mode;
		public string value;
		public unowned Lm.MessageNode add_child (string name, string? value);
		public unowned Lm.MessageNode? find_child (string child_name);
		public unowned string get_attribute (string name);
		public unowned Lm.MessageNode? get_child (string child_name);
		public bool get_raw_mode ();
		public unowned string get_value ();
		public void set_attribute (string name, string value);
		public void set_attributes (string name, ...);
		public void set_raw_mode (bool raw_mode);
		public void set_value (string value);
		public string to_string ();
	}
	[CCode (cheader_filename = "loudmouth/loudmouth.h", ref_function = "lm_proxy_ref", unref_function = "lm_proxy_unref")]
	[Compact]
	public class Proxy {
		[CCode (has_construct_function = false)]
		public Proxy (Lm.ProxyType type);
		public unowned string get_password ();
		public uint get_port ();
		public unowned string get_server ();
		public unowned string get_username ();
		public void set_password (string password);
		public void set_port (uint port);
		public void set_server (string server);
		public void set_type (Lm.ProxyType type);
		public void set_username (string username);
		[CCode (has_construct_function = false)]
		public Proxy.with_server (Lm.ProxyType type, string server, uint port);
	}
	[CCode (cheader_filename = "loudmouth/loudmouth.h", ref_function = "lm_ssl_ref", unref_function = "lm_ssl_unref")]
	[Compact]
	public class SSL {
		[CCode (has_construct_function = false)]
		public SSL (string expected_fingerprint, Lm.SSLFunction ssl_function, GLib.DestroyNotify? notify);
		public unowned string get_fingerprint ();
		public bool get_require_starttls ();
		public bool get_use_starttls ();
		public static bool is_supported ();
		public void use_starttls (bool use_starttls, bool require);
	}
	[CCode (cheader_filename = "loudmouth/loudmouth.h", cprefix = "LM_CERT_", has_type_id = false)]
	public enum CertificateStatus {
		INVALID,
		ISSUER_NOT_FOUND,
		REVOKED
	}
	[CCode (cheader_filename = "loudmouth/loudmouth.h", cprefix = "LM_CONNECTION_STATE_", has_type_id = false)]
	public enum ConnectionState {
		CLOSED,
		OPENING,
		OPEN,
		AUTHENTICATING,
		AUTHENTICATED
	}
	[CCode (cheader_filename = "loudmouth/loudmouth.h", cprefix = "LM_DISCONNECT_REASON_", has_type_id = false)]
	public enum DisconnectReason {
		OK,
		PING_TIME_OUT,
		HUP,
		ERROR,
		RESOURCE_CONFLICT,
		INVALID_XML,
		UNKNOWN
	}
	[CCode (cheader_filename = "loudmouth/loudmouth.h", cprefix = "LM_ERROR_", has_type_id = false)]
	public enum Error {
		CONNECTION_NOT_OPEN,
		CONNECTION_OPEN,
		AUTH_FAILED,
		CONNECTION_FAILED
	}
	[CCode (cheader_filename = "loudmouth/loudmouth.h", cprefix = "LM_HANDLER_PRIORITY_", has_type_id = false)]
	public enum HandlerPriority {
		LAST,
		NORMAL,
		FIRST
	}
	[CCode (cheader_filename = "loudmouth/loudmouth.h", cprefix = "LM_HANDLER_RESULT_", has_type_id = false)]
	public enum HandlerResult {
		REMOVE_MESSAGE,
		ALLOW_MORE_HANDLERS
	}
	[CCode (cheader_filename = "loudmouth/loudmouth.h", cprefix = "LM_MESSAGE_SUB_TYPE_", has_type_id = false)]
	public enum MessageSubType {
		NOT_SET,
		AVAILABLE,
		NORMAL,
		CHAT,
		GROUPCHAT,
		HEADLINE,
		UNAVAILABLE,
		PROBE,
		SUBSCRIBE,
		UNSUBSCRIBE,
		SUBSCRIBED,
		UNSUBSCRIBED,
		GET,
		SET,
		RESULT,
		ERROR
	}
	[CCode (cheader_filename = "loudmouth/loudmouth.h", cprefix = "LM_MESSAGE_TYPE_", has_type_id = false)]
	public enum MessageType {
		MESSAGE,
		PRESENCE,
		IQ,
		STREAM,
		STREAM_ERROR,
		STREAM_FEATURES,
		AUTH,
		CHALLENGE,
		RESPONSE,
		SUCCESS,
		FAILURE,
		PROCEED,
		STARTTLS,
		UNKNOWN
	}
	[CCode (cheader_filename = "loudmouth/loudmouth.h", cprefix = "LM_PROXY_TYPE_", has_type_id = false)]
	public enum ProxyType {
		NONE,
		HTTP
	}
	[CCode (cheader_filename = "loudmouth/loudmouth.h", cprefix = "LM_SSL_RESPONSE_", has_type_id = false)]
	public enum SSLResponse {
		CONTINUE,
		STOP
	}
	[CCode (cheader_filename = "loudmouth/loudmouth.h", cprefix = "LM_SSL_STATUS_", has_type_id = false)]
	public enum SSLStatus {
		NO_CERT_FOUND,
		UNTRUSTED_CERT,
		CERT_EXPIRED,
		CERT_NOT_ACTIVATED,
		CERT_HOSTNAME_MISMATCH,
		CERT_FINGERPRINT_MISMATCH,
		GENERIC_ERROR
	}
	[CCode (cheader_filename = "loudmouth/loudmouth.h")]
	public delegate void DisconnectFunction (Lm.Connection connection, Lm.DisconnectReason reason);
	[CCode (cheader_filename = "loudmouth/loudmouth.h")]
	public delegate Lm.HandlerResult HandleMessageFunction (Lm.MessageHandler handler, Lm.Connection connection, Lm.Message message);
	[CCode (cheader_filename = "loudmouth/loudmouth.h")]
	public delegate void ResultFunction (Lm.Connection connection, bool success);
	[CCode (cheader_filename = "loudmouth/loudmouth.h")]
	public delegate Lm.SSLResponse SSLFunction (Lm.SSL ssl, Lm.SSLStatus status);
	[CCode (cheader_filename = "loudmouth/loudmouth.h")]
	public static GLib.Quark error_quark ();
}
