// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -x c++ -emit-llvm %s -o - -triple x86_64-linux-gnu | FileCheck %s
// RUN: %clang_cc1 -x c++ -fsanitize=pointer-overflow -fno-sanitize-recover=pointer-overflow -emit-llvm %s -o - -triple x86_64-linux-gnu | FileCheck %s

#include <stdint.h>

struct S {
  int x, y;
};

// CHECK-LABEL: @_Z23get_offset_of_y_naivelyv(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i64 ptrtoint (ptr getelementptr inbounds ([[STRUCT_S:%.*]], ptr null, i32 0, i32 1) to i64)
//
uintptr_t get_offset_of_y_naively() {
  return ((uintptr_t)(&(((S *)nullptr)->y)));
}

// CHECK-LABEL: @_Z27get_offset_of_y_via_builtinv(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    ret i64 4
//
uintptr_t get_offset_of_y_via_builtin() {
  return __builtin_offsetof(S, y);
}
