Want to contribute? Great! First, read this page (including
the small print at the end).

### Get in touch

If your idea will take you more than, say, 30 minutes to
implement, please get in touch first via the issue tracker
to touch base about your plan.  That will give an
opportunity for early feedback and help avoid wasting your
time.

### Add tests

Please add tests for any new features or bugfixes.  Bloaty
has a lot of functionality (different data sources, file
formats, diff mode, hierarchical reports, etc).  Having
tests helps ensure that we don't regress any of these
features.

### Coding style

Please follow the [Google C++ Style
Guide](https://google.github.io/styleguide/cppguide.html). I
recommend using `clang-format`, [which has a preset for the
Google Style
Guide](http://clang.llvm.org/docs/ClangFormatStyleOptions.html)

### Code reviews

All submissions, including submissions by project members,
require review. We use Github pull requests for this
purpose.

### Legal Requirements
Before we can use your code, you must sign the [Google
Individual Contributor License
Agreement](https://cla.developers.google.com/about/google-individual)
(CLA), which you can do online. The CLA is necessary mainly
because you own the copyright to your changes, even after
your contribution becomes part of our codebase, so we need
your permission to use and distribute your code. We also
need to be sure of various other things—for instance that
you'll tell us if you know that your code infringes on other
people's patents. You don't have to sign the CLA until after
you've submitted your code for review and a member has
approved it, but you must do it before we can put your code
into our codebase.

### The small print
Contributions made by corporations are covered by a
different agreement than the one above, the [Software Grant
and Corporate Contributor License
Agreement](https://cla.developers.google.com/about/google-corporate).
