// Copyright 2023 gRPC authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This file is autogenerated: see
// tools/codegen/core/gen_huffman_decompressor.cc

#include <grpc/support/port_platform.h>

#include "test/cpp/microbenchmarks/huffman_geometries/decode_huff_12_6_12.h"
namespace grpc_core {
namespace geometry_12_6_12 {
const uint8_t HuffDecoderCommon::table2_0_emit_[10] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74};
const uint8_t HuffDecoderCommon::table2_0_ops_[32] = {
    0x00, 0x04, 0x08, 0x0c, 0x10, 0x14, 0x18, 0x1c, 0x20, 0x24, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02};
const uint8_t HuffDecoderCommon::table3_0_emit_[36] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74, 0x20, 0x25,
    0x2d, 0x2e, 0x2f, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3d, 0x41,
    0x5f, 0x62, 0x64, 0x66, 0x67, 0x68, 0x6c, 0x6d, 0x6e, 0x70, 0x72, 0x75};
const uint8_t HuffDecoderCommon::table3_0_ops_[64] = {
    0x00, 0x01, 0x00, 0x05, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x11, 0x00,
    0x15, 0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x29, 0x2d,
    0x31, 0x35, 0x39, 0x3d, 0x41, 0x45, 0x49, 0x4d, 0x51, 0x55, 0x59,
    0x5d, 0x61, 0x65, 0x69, 0x6d, 0x71, 0x75, 0x79, 0x7d, 0x81, 0x85,
    0x89, 0x8d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table4_0_emit_[22] = {
    0x30, 0x31, 0x32, 0x61, 0x63, 0x65, 0x69, 0x6f, 0x73, 0x74, 0x20,
    0x25, 0x2d, 0x2e, 0x2f, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39};
const uint8_t HuffDecoderCommon::table4_0_ops_[64] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x09, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00,
    0x00, 0x15, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d, 0x00,
    0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x25, 0x00, 0x29, 0x00, 0x2d,
    0x00, 0x31, 0x00, 0x35, 0x00, 0x39, 0x00, 0x3d, 0x00, 0x41, 0x00,
    0x45, 0x00, 0x49, 0x00, 0x4d, 0x00, 0x51, 0x00, 0x55};
const uint8_t HuffDecoderCommon::table4_1_emit_[46] = {
    0x3d, 0x41, 0x5f, 0x62, 0x64, 0x66, 0x67, 0x68, 0x6c, 0x6d, 0x6e, 0x70,
    0x72, 0x75, 0x3a, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a,
    0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56,
    0x57, 0x59, 0x6a, 0x6b, 0x71, 0x76, 0x77, 0x78, 0x79, 0x7a};
const uint8_t HuffDecoderCommon::table4_1_ops_[64] = {
    0x00, 0x01, 0x00, 0x05, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x11, 0x00,
    0x15, 0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x00, 0x29,
    0x00, 0x2d, 0x00, 0x31, 0x00, 0x35, 0x39, 0x3d, 0x41, 0x45, 0x49,
    0x4d, 0x51, 0x55, 0x59, 0x5d, 0x61, 0x65, 0x69, 0x6d, 0x71, 0x75,
    0x79, 0x7d, 0x81, 0x85, 0x89, 0x8d, 0x91, 0x95, 0x99, 0x9d, 0xa1,
    0xa5, 0xa9, 0xad, 0xb1, 0xb5, 0x00, 0x00, 0x00, 0x02};
const uint8_t* const HuffDecoderCommon::table4_emit_[2] = {
    table4_0_emit_,
    table4_1_emit_,
};
const uint8_t* const HuffDecoderCommon::table4_ops_[2] = {
    table4_0_ops_,
    table4_1_ops_,
};
const uint8_t HuffDecoderCommon::table5_0_ops_[128] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x29,
    0x00, 0x00, 0x00, 0x2d, 0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x35,
    0x00, 0x00, 0x00, 0x39, 0x00, 0x00, 0x00, 0x3d, 0x00, 0x00, 0x00, 0x41,
    0x00, 0x00, 0x00, 0x45, 0x00, 0x00, 0x00, 0x49, 0x00, 0x00, 0x00, 0x4d,
    0x00, 0x00, 0x00, 0x51, 0x00, 0x00, 0x00, 0x55};
const uint8_t HuffDecoderCommon::table5_1_emit_[52] = {
    0x3d, 0x41, 0x5f, 0x62, 0x64, 0x66, 0x67, 0x68, 0x6c, 0x6d, 0x6e,
    0x70, 0x72, 0x75, 0x3a, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48,
    0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53,
    0x54, 0x55, 0x56, 0x57, 0x59, 0x6a, 0x6b, 0x71, 0x76, 0x77, 0x78,
    0x79, 0x7a, 0x26, 0x2a, 0x2c, 0x3b, 0x58, 0x5a};
const uint8_t HuffDecoderCommon::table5_1_ops_[128] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x09,
    0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x15,
    0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x21,
    0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x29, 0x00, 0x00, 0x00, 0x2d,
    0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x35, 0x00, 0x39, 0x00, 0x3d,
    0x00, 0x41, 0x00, 0x45, 0x00, 0x49, 0x00, 0x4d, 0x00, 0x51, 0x00, 0x55,
    0x00, 0x59, 0x00, 0x5d, 0x00, 0x61, 0x00, 0x65, 0x00, 0x69, 0x00, 0x6d,
    0x00, 0x71, 0x00, 0x75, 0x00, 0x79, 0x00, 0x7d, 0x00, 0x81, 0x00, 0x85,
    0x00, 0x89, 0x00, 0x8d, 0x00, 0x91, 0x00, 0x95, 0x00, 0x99, 0x00, 0x9d,
    0x00, 0xa1, 0x00, 0xa5, 0x00, 0xa9, 0x00, 0xad, 0x00, 0xb1, 0x00, 0xb5,
    0xb9, 0xbd, 0xc1, 0xc5, 0xc9, 0xcd, 0x00, 0x02};
const uint8_t* const HuffDecoderCommon::table5_emit_[2] = {
    table4_0_emit_,
    table5_1_emit_,
};
const uint8_t* const HuffDecoderCommon::table5_ops_[2] = {
    table5_0_ops_,
    table5_1_ops_,
};
const uint8_t HuffDecoderCommon::table6_0_emit_[2] = {0x30, 0x31};
const uint8_t HuffDecoderCommon::table6_0_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05};
const uint8_t HuffDecoderCommon::table6_1_emit_[2] = {0x32, 0x61};
const uint8_t HuffDecoderCommon::table6_2_emit_[2] = {0x63, 0x65};
const uint8_t HuffDecoderCommon::table6_3_emit_[2] = {0x69, 0x6f};
const uint8_t HuffDecoderCommon::table6_4_emit_[2] = {0x73, 0x74};
const uint8_t HuffDecoderCommon::table6_5_emit_[4] = {0x20, 0x25, 0x2d, 0x2e};
const uint8_t HuffDecoderCommon::table6_5_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d};
const uint8_t HuffDecoderCommon::table6_6_emit_[4] = {0x2f, 0x33, 0x34, 0x35};
const uint8_t HuffDecoderCommon::table6_7_emit_[4] = {0x36, 0x37, 0x38, 0x39};
const uint8_t HuffDecoderCommon::table6_8_emit_[4] = {0x3d, 0x41, 0x5f, 0x62};
const uint8_t HuffDecoderCommon::table6_9_emit_[4] = {0x64, 0x66, 0x67, 0x68};
const uint8_t HuffDecoderCommon::table6_10_emit_[4] = {0x6c, 0x6d, 0x6e, 0x70};
const uint8_t HuffDecoderCommon::table6_11_emit_[6] = {0x72, 0x75, 0x3a,
                                                       0x42, 0x43, 0x44};
const uint8_t HuffDecoderCommon::table6_11_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00,
    0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x15};
const uint8_t HuffDecoderCommon::table6_12_emit_[8] = {0x45, 0x46, 0x47, 0x48,
                                                       0x49, 0x4a, 0x4b, 0x4c};
const uint8_t HuffDecoderCommon::table6_12_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x09, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00,
    0x00, 0x15, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d};
const uint8_t HuffDecoderCommon::table6_13_emit_[8] = {0x4d, 0x4e, 0x4f, 0x50,
                                                       0x51, 0x52, 0x53, 0x54};
const uint8_t HuffDecoderCommon::table6_14_emit_[8] = {0x55, 0x56, 0x57, 0x59,
                                                       0x6a, 0x6b, 0x71, 0x76};
const uint8_t HuffDecoderCommon::table6_15_emit_[10] = {
    0x77, 0x78, 0x79, 0x7a, 0x26, 0x2a, 0x2c, 0x3b, 0x58, 0x5a};
const uint8_t HuffDecoderCommon::table6_15_ops_[32] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
    0x09, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x11, 0x00, 0x15, 0x00, 0x19,
    0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x00, 0x00, 0x00, 0x02};
const uint8_t* const HuffDecoderCommon::table6_emit_[16] = {
    table6_0_emit_,  table6_1_emit_,  table6_2_emit_,  table6_3_emit_,
    table6_4_emit_,  table6_5_emit_,  table6_6_emit_,  table6_7_emit_,
    table6_8_emit_,  table6_9_emit_,  table6_10_emit_, table6_11_emit_,
    table6_12_emit_, table6_13_emit_, table6_14_emit_, table6_15_emit_,
};
const uint8_t* const HuffDecoderCommon::table6_ops_[16] = {
    table6_0_ops_,  table6_0_ops_,  table6_0_ops_,  table6_0_ops_,
    table6_0_ops_,  table6_5_ops_,  table6_5_ops_,  table6_5_ops_,
    table6_5_ops_,  table6_5_ops_,  table6_5_ops_,  table6_11_ops_,
    table6_12_ops_, table6_12_ops_, table6_12_ops_, table6_15_ops_,
};
const uint8_t HuffDecoderCommon::table7_0_emit_[36] = {
    0x30, 0x30, 0x31, 0x30, 0x32, 0x30, 0x61, 0x30, 0x63, 0x30, 0x65, 0x30,
    0x69, 0x30, 0x6f, 0x30, 0x73, 0x30, 0x74, 0x31, 0x31, 0x32, 0x31, 0x61,
    0x31, 0x63, 0x31, 0x65, 0x31, 0x69, 0x31, 0x6f, 0x31, 0x73, 0x31, 0x74};
const uint8_t HuffDecoderCommon::table7_0_ops_[64] = {
    0x00, 0x04, 0x0c, 0x14, 0x1c, 0x24, 0x2c, 0x34, 0x3c, 0x44, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x08,
    0x4c, 0x50, 0x58, 0x60, 0x68, 0x70, 0x78, 0x80, 0x88, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0a};
const uint8_t HuffDecoderCommon::table7_1_emit_[36] = {
    0x32, 0x30, 0x32, 0x31, 0x32, 0x32, 0x61, 0x32, 0x63, 0x32, 0x65, 0x32,
    0x69, 0x32, 0x6f, 0x32, 0x73, 0x32, 0x74, 0x61, 0x30, 0x61, 0x31, 0x61,
    0x61, 0x63, 0x61, 0x65, 0x61, 0x69, 0x61, 0x6f, 0x61, 0x73, 0x61, 0x74};
const uint8_t HuffDecoderCommon::table7_1_ops_[64] = {
    0x00, 0x08, 0x10, 0x14, 0x1c, 0x24, 0x2c, 0x34, 0x3c, 0x44, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x4c,
    0x54, 0x18, 0x5c, 0x60, 0x68, 0x70, 0x78, 0x80, 0x88, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1a};
const uint8_t HuffDecoderCommon::table7_2_emit_[36] = {
    0x63, 0x30, 0x63, 0x31, 0x63, 0x32, 0x63, 0x61, 0x63, 0x63, 0x65, 0x63,
    0x69, 0x63, 0x6f, 0x63, 0x73, 0x63, 0x74, 0x65, 0x30, 0x65, 0x31, 0x65,
    0x32, 0x65, 0x61, 0x65, 0x65, 0x69, 0x65, 0x6f, 0x65, 0x73, 0x65, 0x74};
const uint8_t HuffDecoderCommon::table7_2_ops_[64] = {
    0x00, 0x08, 0x10, 0x18, 0x20, 0x24, 0x2c, 0x34, 0x3c, 0x44, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x4c,
    0x54, 0x5c, 0x64, 0x28, 0x6c, 0x70, 0x78, 0x80, 0x88, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x2a};
const uint8_t HuffDecoderCommon::table7_3_emit_[36] = {
    0x69, 0x30, 0x69, 0x31, 0x69, 0x32, 0x69, 0x61, 0x69, 0x63, 0x69, 0x65,
    0x69, 0x69, 0x6f, 0x69, 0x73, 0x69, 0x74, 0x6f, 0x30, 0x6f, 0x31, 0x6f,
    0x32, 0x6f, 0x61, 0x6f, 0x63, 0x6f, 0x65, 0x6f, 0x6f, 0x73, 0x6f, 0x74};
const uint8_t HuffDecoderCommon::table7_3_ops_[64] = {
    0x00, 0x08, 0x10, 0x18, 0x20, 0x28, 0x30, 0x34, 0x3c, 0x44, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x4c,
    0x54, 0x5c, 0x64, 0x6c, 0x74, 0x38, 0x7c, 0x80, 0x88, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x3a};
const uint8_t HuffDecoderCommon::table7_4_emit_[38] = {
    0x73, 0x30, 0x73, 0x31, 0x73, 0x32, 0x73, 0x61, 0x73, 0x63,
    0x73, 0x65, 0x73, 0x69, 0x73, 0x6f, 0x73, 0x73, 0x74, 0x30,
    0x74, 0x31, 0x74, 0x32, 0x74, 0x61, 0x74, 0x63, 0x74, 0x65,
    0x74, 0x69, 0x74, 0x6f, 0x74, 0x73, 0x74, 0x74};
const uint8_t HuffDecoderCommon::table7_4_ops_[64] = {
    0x00, 0x08, 0x10, 0x18, 0x20, 0x28, 0x30, 0x38, 0x40, 0x44, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x48,
    0x50, 0x58, 0x60, 0x68, 0x70, 0x78, 0x80, 0x88, 0x90, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x4a};
const uint8_t HuffDecoderCommon::table7_5_ops_[64] = {
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x0a, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0e};
const uint8_t HuffDecoderCommon::table7_11_ops_[64] = {
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x06, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0a, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x0e, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x12, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x16};
const uint8_t HuffDecoderCommon::table7_12_ops_[64] = {
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x0a, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0e, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x12, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x16, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x1a, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x1e};
const uint8_t HuffDecoderCommon::table7_15_emit_[15] = {
    0x77, 0x78, 0x79, 0x7a, 0x26, 0x2a, 0x2c, 0x3b,
    0x58, 0x5a, 0x21, 0x22, 0x28, 0x29, 0x3f};
const uint8_t HuffDecoderCommon::table7_15_ops_[64] = {
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x0a, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0e, 0x01,
    0x01, 0x01, 0x12, 0x01, 0x01, 0x01, 0x16, 0x01, 0x01, 0x01, 0x1a,
    0x01, 0x01, 0x01, 0x1e, 0x01, 0x01, 0x01, 0x22, 0x01, 0x01, 0x01,
    0x26, 0x2a, 0x2e, 0x32, 0x36, 0x3a, 0x01, 0x01, 0x03};
const uint8_t* const HuffDecoderCommon::table7_emit_[16] = {
    table7_0_emit_,  table7_1_emit_,  table7_2_emit_,  table7_3_emit_,
    table7_4_emit_,  table6_5_emit_,  table6_6_emit_,  table6_7_emit_,
    table6_8_emit_,  table6_9_emit_,  table6_10_emit_, table6_11_emit_,
    table6_12_emit_, table6_13_emit_, table6_14_emit_, table7_15_emit_,
};
const uint8_t* const HuffDecoderCommon::table7_ops_[16] = {
    table7_0_ops_,  table7_1_ops_,  table7_2_ops_,  table7_3_ops_,
    table7_4_ops_,  table7_5_ops_,  table7_5_ops_,  table7_5_ops_,
    table7_5_ops_,  table7_5_ops_,  table7_5_ops_,  table7_11_ops_,
    table7_12_ops_, table7_12_ops_, table7_12_ops_, table7_15_ops_,
};
const uint8_t HuffDecoderCommon::table8_0_emit_[71] = {
    0x30, 0x30, 0x31, 0x30, 0x32, 0x30, 0x61, 0x30, 0x63, 0x30, 0x65, 0x30,
    0x69, 0x30, 0x6f, 0x30, 0x73, 0x30, 0x74, 0x30, 0x20, 0x30, 0x25, 0x30,
    0x2d, 0x30, 0x2e, 0x30, 0x2f, 0x30, 0x33, 0x30, 0x34, 0x30, 0x35, 0x30,
    0x36, 0x30, 0x37, 0x30, 0x38, 0x30, 0x39, 0x30, 0x3d, 0x30, 0x41, 0x30,
    0x5f, 0x30, 0x62, 0x30, 0x64, 0x30, 0x66, 0x30, 0x67, 0x30, 0x68, 0x30,
    0x6c, 0x30, 0x6d, 0x30, 0x6e, 0x30, 0x70, 0x30, 0x72, 0x30, 0x75};
const uint16_t HuffDecoderCommon::table8_0_inner_[38] = {
    0x0000, 0x0001, 0x0005, 0x000d, 0x0015, 0x001d, 0x0025, 0x002d,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x0002};
const uint8_t HuffDecoderCommon::table8_0_outer_[64] = {
    0,  1,  0,  2,  0,  3,  0,  4,  0,  5,  0,  6,  0,  7,  0,  8,
    0,  9,  0,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22,
    23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  37};
const uint8_t HuffDecoderCommon::table8_1_emit_[71] = {
    0x31, 0x30, 0x31, 0x31, 0x32, 0x31, 0x61, 0x31, 0x63, 0x31, 0x65, 0x31,
    0x69, 0x31, 0x6f, 0x31, 0x73, 0x31, 0x74, 0x31, 0x20, 0x31, 0x25, 0x31,
    0x2d, 0x31, 0x2e, 0x31, 0x2f, 0x31, 0x33, 0x31, 0x34, 0x31, 0x35, 0x31,
    0x36, 0x31, 0x37, 0x31, 0x38, 0x31, 0x39, 0x31, 0x3d, 0x31, 0x41, 0x31,
    0x5f, 0x31, 0x62, 0x31, 0x64, 0x31, 0x66, 0x31, 0x67, 0x31, 0x68, 0x31,
    0x6c, 0x31, 0x6d, 0x31, 0x6e, 0x31, 0x70, 0x31, 0x72, 0x31, 0x75};
const uint16_t HuffDecoderCommon::table8_1_inner_[38] = {
    0x0000, 0x0001, 0x0009, 0x000d, 0x0015, 0x001d, 0x0025, 0x002d,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x0002};
const uint8_t HuffDecoderCommon::table8_2_emit_[71] = {
    0x32, 0x30, 0x32, 0x31, 0x32, 0x32, 0x61, 0x32, 0x63, 0x32, 0x65, 0x32,
    0x69, 0x32, 0x6f, 0x32, 0x73, 0x32, 0x74, 0x32, 0x20, 0x32, 0x25, 0x32,
    0x2d, 0x32, 0x2e, 0x32, 0x2f, 0x32, 0x33, 0x32, 0x34, 0x32, 0x35, 0x32,
    0x36, 0x32, 0x37, 0x32, 0x38, 0x32, 0x39, 0x32, 0x3d, 0x32, 0x41, 0x32,
    0x5f, 0x32, 0x62, 0x32, 0x64, 0x32, 0x66, 0x32, 0x67, 0x32, 0x68, 0x32,
    0x6c, 0x32, 0x6d, 0x32, 0x6e, 0x32, 0x70, 0x32, 0x72, 0x32, 0x75};
const uint16_t HuffDecoderCommon::table8_2_inner_[38] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0015, 0x001d, 0x0025, 0x002d,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x0002};
const uint8_t HuffDecoderCommon::table8_3_emit_[71] = {
    0x61, 0x30, 0x61, 0x31, 0x61, 0x32, 0x61, 0x61, 0x63, 0x61, 0x65, 0x61,
    0x69, 0x61, 0x6f, 0x61, 0x73, 0x61, 0x74, 0x61, 0x20, 0x61, 0x25, 0x61,
    0x2d, 0x61, 0x2e, 0x61, 0x2f, 0x61, 0x33, 0x61, 0x34, 0x61, 0x35, 0x61,
    0x36, 0x61, 0x37, 0x61, 0x38, 0x61, 0x39, 0x61, 0x3d, 0x61, 0x41, 0x61,
    0x5f, 0x61, 0x62, 0x61, 0x64, 0x61, 0x66, 0x61, 0x67, 0x61, 0x68, 0x61,
    0x6c, 0x61, 0x6d, 0x61, 0x6e, 0x61, 0x70, 0x61, 0x72, 0x61, 0x75};
const uint16_t HuffDecoderCommon::table8_3_inner_[38] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x001d, 0x0025, 0x002d,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x0002};
const uint8_t HuffDecoderCommon::table8_4_emit_[71] = {
    0x63, 0x30, 0x63, 0x31, 0x63, 0x32, 0x63, 0x61, 0x63, 0x63, 0x65, 0x63,
    0x69, 0x63, 0x6f, 0x63, 0x73, 0x63, 0x74, 0x63, 0x20, 0x63, 0x25, 0x63,
    0x2d, 0x63, 0x2e, 0x63, 0x2f, 0x63, 0x33, 0x63, 0x34, 0x63, 0x35, 0x63,
    0x36, 0x63, 0x37, 0x63, 0x38, 0x63, 0x39, 0x63, 0x3d, 0x63, 0x41, 0x63,
    0x5f, 0x63, 0x62, 0x63, 0x64, 0x63, 0x66, 0x63, 0x67, 0x63, 0x68, 0x63,
    0x6c, 0x63, 0x6d, 0x63, 0x6e, 0x63, 0x70, 0x63, 0x72, 0x63, 0x75};
const uint16_t HuffDecoderCommon::table8_4_inner_[38] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0025, 0x002d,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x0002};
const uint8_t HuffDecoderCommon::table8_5_emit_[71] = {
    0x65, 0x30, 0x65, 0x31, 0x65, 0x32, 0x65, 0x61, 0x65, 0x63, 0x65, 0x65,
    0x69, 0x65, 0x6f, 0x65, 0x73, 0x65, 0x74, 0x65, 0x20, 0x65, 0x25, 0x65,
    0x2d, 0x65, 0x2e, 0x65, 0x2f, 0x65, 0x33, 0x65, 0x34, 0x65, 0x35, 0x65,
    0x36, 0x65, 0x37, 0x65, 0x38, 0x65, 0x39, 0x65, 0x3d, 0x65, 0x41, 0x65,
    0x5f, 0x65, 0x62, 0x65, 0x64, 0x65, 0x66, 0x65, 0x67, 0x65, 0x68, 0x65,
    0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x65, 0x70, 0x65, 0x72, 0x65, 0x75};
const uint16_t HuffDecoderCommon::table8_5_inner_[38] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x002d,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x0002};
const uint8_t HuffDecoderCommon::table8_6_emit_[71] = {
    0x69, 0x30, 0x69, 0x31, 0x69, 0x32, 0x69, 0x61, 0x69, 0x63, 0x69, 0x65,
    0x69, 0x69, 0x6f, 0x69, 0x73, 0x69, 0x74, 0x69, 0x20, 0x69, 0x25, 0x69,
    0x2d, 0x69, 0x2e, 0x69, 0x2f, 0x69, 0x33, 0x69, 0x34, 0x69, 0x35, 0x69,
    0x36, 0x69, 0x37, 0x69, 0x38, 0x69, 0x39, 0x69, 0x3d, 0x69, 0x41, 0x69,
    0x5f, 0x69, 0x62, 0x69, 0x64, 0x69, 0x66, 0x69, 0x67, 0x69, 0x68, 0x69,
    0x6c, 0x69, 0x6d, 0x69, 0x6e, 0x69, 0x70, 0x69, 0x72, 0x69, 0x75};
const uint16_t HuffDecoderCommon::table8_6_inner_[38] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0035, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x0002};
const uint8_t HuffDecoderCommon::table8_7_emit_[71] = {
    0x6f, 0x30, 0x6f, 0x31, 0x6f, 0x32, 0x6f, 0x61, 0x6f, 0x63, 0x6f, 0x65,
    0x6f, 0x69, 0x6f, 0x6f, 0x73, 0x6f, 0x74, 0x6f, 0x20, 0x6f, 0x25, 0x6f,
    0x2d, 0x6f, 0x2e, 0x6f, 0x2f, 0x6f, 0x33, 0x6f, 0x34, 0x6f, 0x35, 0x6f,
    0x36, 0x6f, 0x37, 0x6f, 0x38, 0x6f, 0x39, 0x6f, 0x3d, 0x6f, 0x41, 0x6f,
    0x5f, 0x6f, 0x62, 0x6f, 0x64, 0x6f, 0x66, 0x6f, 0x67, 0x6f, 0x68, 0x6f,
    0x6c, 0x6f, 0x6d, 0x6f, 0x6e, 0x6f, 0x70, 0x6f, 0x72, 0x6f, 0x75};
const uint16_t HuffDecoderCommon::table8_7_inner_[38] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x003d, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x0002};
const uint8_t HuffDecoderCommon::table8_8_emit_[71] = {
    0x73, 0x30, 0x73, 0x31, 0x73, 0x32, 0x73, 0x61, 0x73, 0x63, 0x73, 0x65,
    0x73, 0x69, 0x73, 0x6f, 0x73, 0x73, 0x74, 0x73, 0x20, 0x73, 0x25, 0x73,
    0x2d, 0x73, 0x2e, 0x73, 0x2f, 0x73, 0x33, 0x73, 0x34, 0x73, 0x35, 0x73,
    0x36, 0x73, 0x37, 0x73, 0x38, 0x73, 0x39, 0x73, 0x3d, 0x73, 0x41, 0x73,
    0x5f, 0x73, 0x62, 0x73, 0x64, 0x73, 0x66, 0x73, 0x67, 0x73, 0x68, 0x73,
    0x6c, 0x73, 0x6d, 0x73, 0x6e, 0x73, 0x70, 0x73, 0x72, 0x73, 0x75};
const uint16_t HuffDecoderCommon::table8_8_inner_[38] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0045, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x0002};
const uint8_t HuffDecoderCommon::table8_9_emit_[71] = {
    0x74, 0x30, 0x74, 0x31, 0x74, 0x32, 0x74, 0x61, 0x74, 0x63, 0x74, 0x65,
    0x74, 0x69, 0x74, 0x6f, 0x74, 0x73, 0x74, 0x74, 0x20, 0x74, 0x25, 0x74,
    0x2d, 0x74, 0x2e, 0x74, 0x2f, 0x74, 0x33, 0x74, 0x34, 0x74, 0x35, 0x74,
    0x36, 0x74, 0x37, 0x74, 0x38, 0x74, 0x39, 0x74, 0x3d, 0x74, 0x41, 0x74,
    0x5f, 0x74, 0x62, 0x74, 0x64, 0x74, 0x66, 0x74, 0x67, 0x74, 0x68, 0x74,
    0x6c, 0x74, 0x6d, 0x74, 0x6e, 0x74, 0x70, 0x74, 0x72, 0x74, 0x75};
const uint16_t HuffDecoderCommon::table8_9_inner_[38] = {
    0x0000, 0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031,
    0x0039, 0x0041, 0x0049, 0x004d, 0x0055, 0x005d, 0x0065, 0x006d,
    0x0075, 0x007d, 0x0085, 0x008d, 0x0095, 0x009d, 0x00a5, 0x00ad,
    0x00b5, 0x00bd, 0x00c5, 0x00cd, 0x00d5, 0x00dd, 0x00e5, 0x00ed,
    0x00f5, 0x00fd, 0x0105, 0x010d, 0x0115, 0x0002};
const uint8_t HuffDecoderCommon::table8_10_emit_[40] = {
    0x20, 0x30, 0x20, 0x31, 0x20, 0x32, 0x20, 0x61, 0x20, 0x63,
    0x20, 0x65, 0x20, 0x69, 0x20, 0x6f, 0x20, 0x73, 0x20, 0x74,
    0x25, 0x30, 0x25, 0x31, 0x25, 0x32, 0x25, 0x61, 0x25, 0x63,
    0x25, 0x65, 0x25, 0x69, 0x25, 0x6f, 0x25, 0x73, 0x25, 0x74};
const uint16_t HuffDecoderCommon::table8_10_inner_[23] = {
    0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031, 0x0039,
    0x0041, 0x0049, 0x0000, 0x0002, 0x0051, 0x0059, 0x0061, 0x0069,
    0x0071, 0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x0052};
const uint8_t HuffDecoderCommon::table8_10_outer_[64] = {
    0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11,
    12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 22};
const uint8_t HuffDecoderCommon::table8_11_emit_[40] = {
    0x2d, 0x30, 0x2d, 0x31, 0x2d, 0x32, 0x2d, 0x61, 0x2d, 0x63,
    0x2d, 0x65, 0x2d, 0x69, 0x2d, 0x6f, 0x2d, 0x73, 0x2d, 0x74,
    0x2e, 0x30, 0x2e, 0x31, 0x2e, 0x32, 0x2e, 0x61, 0x2e, 0x63,
    0x2e, 0x65, 0x2e, 0x69, 0x2e, 0x6f, 0x2e, 0x73, 0x2e, 0x74};
const uint8_t HuffDecoderCommon::table8_12_emit_[40] = {
    0x2f, 0x30, 0x2f, 0x31, 0x2f, 0x32, 0x2f, 0x61, 0x2f, 0x63,
    0x2f, 0x65, 0x2f, 0x69, 0x2f, 0x6f, 0x2f, 0x73, 0x2f, 0x74,
    0x33, 0x30, 0x33, 0x31, 0x33, 0x32, 0x33, 0x61, 0x33, 0x63,
    0x33, 0x65, 0x33, 0x69, 0x33, 0x6f, 0x33, 0x73, 0x33, 0x74};
const uint8_t HuffDecoderCommon::table8_13_emit_[40] = {
    0x34, 0x30, 0x34, 0x31, 0x34, 0x32, 0x34, 0x61, 0x34, 0x63,
    0x34, 0x65, 0x34, 0x69, 0x34, 0x6f, 0x34, 0x73, 0x34, 0x74,
    0x35, 0x30, 0x35, 0x31, 0x35, 0x32, 0x35, 0x61, 0x35, 0x63,
    0x35, 0x65, 0x35, 0x69, 0x35, 0x6f, 0x35, 0x73, 0x35, 0x74};
const uint8_t HuffDecoderCommon::table8_14_emit_[40] = {
    0x36, 0x30, 0x36, 0x31, 0x36, 0x32, 0x36, 0x61, 0x36, 0x63,
    0x36, 0x65, 0x36, 0x69, 0x36, 0x6f, 0x36, 0x73, 0x36, 0x74,
    0x37, 0x30, 0x37, 0x31, 0x37, 0x32, 0x37, 0x61, 0x37, 0x63,
    0x37, 0x65, 0x37, 0x69, 0x37, 0x6f, 0x37, 0x73, 0x37, 0x74};
const uint8_t HuffDecoderCommon::table8_15_emit_[40] = {
    0x38, 0x30, 0x38, 0x31, 0x38, 0x32, 0x38, 0x61, 0x38, 0x63,
    0x38, 0x65, 0x38, 0x69, 0x38, 0x6f, 0x38, 0x73, 0x38, 0x74,
    0x39, 0x30, 0x39, 0x31, 0x39, 0x32, 0x39, 0x61, 0x39, 0x63,
    0x39, 0x65, 0x39, 0x69, 0x39, 0x6f, 0x39, 0x73, 0x39, 0x74};
const uint8_t HuffDecoderCommon::table8_16_emit_[40] = {
    0x3d, 0x30, 0x3d, 0x31, 0x3d, 0x32, 0x3d, 0x61, 0x3d, 0x63,
    0x3d, 0x65, 0x3d, 0x69, 0x3d, 0x6f, 0x3d, 0x73, 0x3d, 0x74,
    0x41, 0x30, 0x41, 0x31, 0x41, 0x32, 0x41, 0x61, 0x41, 0x63,
    0x41, 0x65, 0x41, 0x69, 0x41, 0x6f, 0x41, 0x73, 0x41, 0x74};
const uint8_t HuffDecoderCommon::table8_17_emit_[40] = {
    0x5f, 0x30, 0x5f, 0x31, 0x5f, 0x32, 0x5f, 0x61, 0x5f, 0x63,
    0x5f, 0x65, 0x5f, 0x69, 0x5f, 0x6f, 0x5f, 0x73, 0x5f, 0x74,
    0x62, 0x30, 0x62, 0x31, 0x62, 0x32, 0x62, 0x61, 0x62, 0x63,
    0x62, 0x65, 0x62, 0x69, 0x62, 0x6f, 0x62, 0x73, 0x62, 0x74};
const uint8_t HuffDecoderCommon::table8_18_emit_[40] = {
    0x64, 0x30, 0x64, 0x31, 0x64, 0x32, 0x64, 0x61, 0x64, 0x63,
    0x64, 0x65, 0x64, 0x69, 0x64, 0x6f, 0x64, 0x73, 0x64, 0x74,
    0x66, 0x30, 0x66, 0x31, 0x66, 0x32, 0x66, 0x61, 0x66, 0x63,
    0x66, 0x65, 0x66, 0x69, 0x66, 0x6f, 0x66, 0x73, 0x66, 0x74};
const uint8_t HuffDecoderCommon::table8_19_emit_[40] = {
    0x67, 0x30, 0x67, 0x31, 0x67, 0x32, 0x67, 0x61, 0x67, 0x63,
    0x67, 0x65, 0x67, 0x69, 0x67, 0x6f, 0x67, 0x73, 0x67, 0x74,
    0x68, 0x30, 0x68, 0x31, 0x68, 0x32, 0x68, 0x61, 0x68, 0x63,
    0x68, 0x65, 0x68, 0x69, 0x68, 0x6f, 0x68, 0x73, 0x68, 0x74};
const uint8_t HuffDecoderCommon::table8_20_emit_[40] = {
    0x6c, 0x30, 0x6c, 0x31, 0x6c, 0x32, 0x6c, 0x61, 0x6c, 0x63,
    0x6c, 0x65, 0x6c, 0x69, 0x6c, 0x6f, 0x6c, 0x73, 0x6c, 0x74,
    0x6d, 0x30, 0x6d, 0x31, 0x6d, 0x32, 0x6d, 0x61, 0x6d, 0x63,
    0x6d, 0x65, 0x6d, 0x69, 0x6d, 0x6f, 0x6d, 0x73, 0x6d, 0x74};
const uint8_t HuffDecoderCommon::table8_21_emit_[40] = {
    0x6e, 0x30, 0x6e, 0x31, 0x6e, 0x32, 0x6e, 0x61, 0x6e, 0x63,
    0x6e, 0x65, 0x6e, 0x69, 0x6e, 0x6f, 0x6e, 0x73, 0x6e, 0x74,
    0x70, 0x30, 0x70, 0x31, 0x70, 0x32, 0x70, 0x61, 0x70, 0x63,
    0x70, 0x65, 0x70, 0x69, 0x70, 0x6f, 0x70, 0x73, 0x70, 0x74};
const uint8_t HuffDecoderCommon::table8_22_emit_[40] = {
    0x72, 0x30, 0x72, 0x31, 0x72, 0x32, 0x72, 0x61, 0x72, 0x63,
    0x72, 0x65, 0x72, 0x69, 0x72, 0x6f, 0x72, 0x73, 0x72, 0x74,
    0x75, 0x30, 0x75, 0x31, 0x75, 0x32, 0x75, 0x61, 0x75, 0x63,
    0x75, 0x65, 0x75, 0x69, 0x75, 0x6f, 0x75, 0x73, 0x75, 0x74};
const uint8_t HuffDecoderCommon::table8_23_emit_[4] = {0x3a, 0x42, 0x43, 0x44};
const uint16_t HuffDecoderCommon::table8_23_inner_[5] = {0x0000, 0x0002, 0x0006,
                                                         0x000a, 0x000e};
const uint8_t HuffDecoderCommon::table8_23_outer_[64] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4};
const uint8_t HuffDecoderCommon::table8_24_emit_[4] = {0x45, 0x46, 0x47, 0x48};
const uint8_t HuffDecoderCommon::table8_25_emit_[4] = {0x49, 0x4a, 0x4b, 0x4c};
const uint8_t HuffDecoderCommon::table8_26_emit_[4] = {0x4d, 0x4e, 0x4f, 0x50};
const uint8_t HuffDecoderCommon::table8_27_emit_[4] = {0x51, 0x52, 0x53, 0x54};
const uint8_t HuffDecoderCommon::table8_28_emit_[4] = {0x55, 0x56, 0x57, 0x59};
const uint8_t HuffDecoderCommon::table8_29_emit_[4] = {0x6a, 0x6b, 0x71, 0x76};
const uint8_t HuffDecoderCommon::table8_30_emit_[4] = {0x77, 0x78, 0x79, 0x7a};
const uint8_t HuffDecoderCommon::table8_31_emit_[14] = {
    0x26, 0x2a, 0x2c, 0x3b, 0x58, 0x5a, 0x21,
    0x22, 0x28, 0x29, 0x3f, 0x27, 0x2b, 0x7c};
const uint16_t HuffDecoderCommon::table8_31_inner_[16] = {
    0x0000, 0x0002, 0x0006, 0x000a, 0x000e, 0x0012, 0x0016, 0x001a,
    0x001e, 0x0022, 0x0026, 0x002a, 0x002e, 0x0032, 0x0036, 0x0003};
const uint8_t HuffDecoderCommon::table8_31_outer_[64] = {
    0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0,  0, 0,  0,  2,  0,  0, 0, 0, 0, 0,
    0, 3, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0,  0, 0,  0,  0,  0,  5, 0, 0, 0, 0,
    0, 0, 0, 6, 0, 7, 0, 8, 0, 9, 0, 10, 0, 11, 12, 13, 14, 0, 0, 15};
const uint8_t* const HuffDecoderCommon::table8_emit_[32] = {
    table8_0_emit_,  table8_1_emit_,  table8_2_emit_,  table8_3_emit_,
    table8_4_emit_,  table8_5_emit_,  table8_6_emit_,  table8_7_emit_,
    table8_8_emit_,  table8_9_emit_,  table8_10_emit_, table8_11_emit_,
    table8_12_emit_, table8_13_emit_, table8_14_emit_, table8_15_emit_,
    table8_16_emit_, table8_17_emit_, table8_18_emit_, table8_19_emit_,
    table8_20_emit_, table8_21_emit_, table8_22_emit_, table8_23_emit_,
    table8_24_emit_, table8_25_emit_, table8_26_emit_, table8_27_emit_,
    table8_28_emit_, table8_29_emit_, table8_30_emit_, table8_31_emit_,
};
const uint16_t* const HuffDecoderCommon::table8_inner_[32] = {
    table8_0_inner_,  table8_1_inner_,  table8_2_inner_,  table8_3_inner_,
    table8_4_inner_,  table8_5_inner_,  table8_6_inner_,  table8_7_inner_,
    table8_8_inner_,  table8_9_inner_,  table8_10_inner_, table8_10_inner_,
    table8_10_inner_, table8_10_inner_, table8_10_inner_, table8_10_inner_,
    table8_10_inner_, table8_10_inner_, table8_10_inner_, table8_10_inner_,
    table8_10_inner_, table8_10_inner_, table8_10_inner_, table8_23_inner_,
    table8_23_inner_, table8_23_inner_, table8_23_inner_, table8_23_inner_,
    table8_23_inner_, table8_23_inner_, table8_23_inner_, table8_31_inner_,
};
const uint8_t* const HuffDecoderCommon::table8_outer_[32] = {
    table8_0_outer_,  table8_0_outer_,  table8_0_outer_,  table8_0_outer_,
    table8_0_outer_,  table8_0_outer_,  table8_0_outer_,  table8_0_outer_,
    table8_0_outer_,  table8_0_outer_,  table8_10_outer_, table8_10_outer_,
    table8_10_outer_, table8_10_outer_, table8_10_outer_, table8_10_outer_,
    table8_10_outer_, table8_10_outer_, table8_10_outer_, table8_10_outer_,
    table8_10_outer_, table8_10_outer_, table8_10_outer_, table8_23_outer_,
    table8_23_outer_, table8_23_outer_, table8_23_outer_, table8_23_outer_,
    table8_23_outer_, table8_23_outer_, table8_23_outer_, table8_31_outer_,
};
const uint8_t HuffDecoderCommon::table1_0_emit_[135] = {
    0x30, 0x30, 0x31, 0x30, 0x32, 0x30, 0x61, 0x30, 0x63, 0x30, 0x65, 0x30,
    0x69, 0x30, 0x6f, 0x30, 0x73, 0x30, 0x74, 0x30, 0x20, 0x30, 0x25, 0x30,
    0x2d, 0x30, 0x2e, 0x30, 0x2f, 0x30, 0x33, 0x30, 0x34, 0x30, 0x35, 0x30,
    0x36, 0x30, 0x37, 0x30, 0x38, 0x30, 0x39, 0x30, 0x3d, 0x30, 0x41, 0x30,
    0x5f, 0x30, 0x62, 0x30, 0x64, 0x30, 0x66, 0x30, 0x67, 0x30, 0x68, 0x30,
    0x6c, 0x30, 0x6d, 0x30, 0x6e, 0x30, 0x70, 0x30, 0x72, 0x30, 0x75, 0x30,
    0x3a, 0x30, 0x42, 0x30, 0x43, 0x30, 0x44, 0x30, 0x45, 0x30, 0x46, 0x30,
    0x47, 0x30, 0x48, 0x30, 0x49, 0x30, 0x4a, 0x30, 0x4b, 0x30, 0x4c, 0x30,
    0x4d, 0x30, 0x4e, 0x30, 0x4f, 0x30, 0x50, 0x30, 0x51, 0x30, 0x52, 0x30,
    0x53, 0x30, 0x54, 0x30, 0x55, 0x30, 0x56, 0x30, 0x57, 0x30, 0x59, 0x30,
    0x6a, 0x30, 0x6b, 0x30, 0x71, 0x30, 0x76, 0x30, 0x77, 0x30, 0x78, 0x30,
    0x79, 0x30, 0x7a};
const uint16_t HuffDecoderCommon::table1_0_inner_[69] = {
    0x000a, 0x008a, 0x018a, 0x028a, 0x038a, 0x048a, 0x058a, 0x068a, 0x078a,
    0x088a, 0x098b, 0x0a8b, 0x0b8b, 0x0c8b, 0x0d8b, 0x0e8b, 0x0f8b, 0x108b,
    0x118b, 0x128b, 0x138b, 0x148b, 0x158b, 0x168b, 0x178b, 0x188b, 0x198b,
    0x1a8b, 0x1b8b, 0x1c8b, 0x1d8b, 0x1e8b, 0x1f8b, 0x208b, 0x218b, 0x228b,
    0x238c, 0x248c, 0x258c, 0x268c, 0x278c, 0x288c, 0x298c, 0x2a8c, 0x2b8c,
    0x2c8c, 0x2d8c, 0x2e8c, 0x2f8c, 0x308c, 0x318c, 0x328c, 0x338c, 0x348c,
    0x358c, 0x368c, 0x378c, 0x388c, 0x398c, 0x3a8c, 0x3b8c, 0x3c8c, 0x3d8c,
    0x3e8c, 0x3f8c, 0x408c, 0x418c, 0x428c, 0x0015};
const uint8_t HuffDecoderCommon::table1_0_outer_[128] = {
    0,  0,  0,  0,  1,  1,  1,  1,  2,  2,  2,  2,  3,  3,  3,  3,  4,  4,  4,
    4,  5,  5,  5,  5,  6,  6,  6,  6,  7,  7,  7,  7,  8,  8,  8,  8,  9,  9,
    9,  9,  10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 16, 16, 17, 17, 18,
    18, 19, 19, 20, 20, 21, 21, 22, 22, 23, 23, 24, 24, 25, 25, 26, 26, 27, 27,
    28, 28, 29, 29, 30, 30, 31, 31, 32, 32, 33, 33, 34, 34, 35, 35, 36, 37, 38,
    39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57,
    58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 68, 68, 68};
const uint8_t HuffDecoderCommon::table1_1_emit_[135] = {
    0x31, 0x30, 0x31, 0x31, 0x32, 0x31, 0x61, 0x31, 0x63, 0x31, 0x65, 0x31,
    0x69, 0x31, 0x6f, 0x31, 0x73, 0x31, 0x74, 0x31, 0x20, 0x31, 0x25, 0x31,
    0x2d, 0x31, 0x2e, 0x31, 0x2f, 0x31, 0x33, 0x31, 0x34, 0x31, 0x35, 0x31,
    0x36, 0x31, 0x37, 0x31, 0x38, 0x31, 0x39, 0x31, 0x3d, 0x31, 0x41, 0x31,
    0x5f, 0x31, 0x62, 0x31, 0x64, 0x31, 0x66, 0x31, 0x67, 0x31, 0x68, 0x31,
    0x6c, 0x31, 0x6d, 0x31, 0x6e, 0x31, 0x70, 0x31, 0x72, 0x31, 0x75, 0x31,
    0x3a, 0x31, 0x42, 0x31, 0x43, 0x31, 0x44, 0x31, 0x45, 0x31, 0x46, 0x31,
    0x47, 0x31, 0x48, 0x31, 0x49, 0x31, 0x4a, 0x31, 0x4b, 0x31, 0x4c, 0x31,
    0x4d, 0x31, 0x4e, 0x31, 0x4f, 0x31, 0x50, 0x31, 0x51, 0x31, 0x52, 0x31,
    0x53, 0x31, 0x54, 0x31, 0x55, 0x31, 0x56, 0x31, 0x57, 0x31, 0x59, 0x31,
    0x6a, 0x31, 0x6b, 0x31, 0x71, 0x31, 0x76, 0x31, 0x77, 0x31, 0x78, 0x31,
    0x79, 0x31, 0x7a};
const uint16_t HuffDecoderCommon::table1_1_inner_[69] = {
    0x000a, 0x010a, 0x018a, 0x028a, 0x038a, 0x048a, 0x058a, 0x068a, 0x078a,
    0x088a, 0x098b, 0x0a8b, 0x0b8b, 0x0c8b, 0x0d8b, 0x0e8b, 0x0f8b, 0x108b,
    0x118b, 0x128b, 0x138b, 0x148b, 0x158b, 0x168b, 0x178b, 0x188b, 0x198b,
    0x1a8b, 0x1b8b, 0x1c8b, 0x1d8b, 0x1e8b, 0x1f8b, 0x208b, 0x218b, 0x228b,
    0x238c, 0x248c, 0x258c, 0x268c, 0x278c, 0x288c, 0x298c, 0x2a8c, 0x2b8c,
    0x2c8c, 0x2d8c, 0x2e8c, 0x2f8c, 0x308c, 0x318c, 0x328c, 0x338c, 0x348c,
    0x358c, 0x368c, 0x378c, 0x388c, 0x398c, 0x3a8c, 0x3b8c, 0x3c8c, 0x3d8c,
    0x3e8c, 0x3f8c, 0x408c, 0x418c, 0x428c, 0x0015};
const uint8_t HuffDecoderCommon::table1_2_emit_[135] = {
    0x32, 0x30, 0x32, 0x31, 0x32, 0x32, 0x61, 0x32, 0x63, 0x32, 0x65, 0x32,
    0x69, 0x32, 0x6f, 0x32, 0x73, 0x32, 0x74, 0x32, 0x20, 0x32, 0x25, 0x32,
    0x2d, 0x32, 0x2e, 0x32, 0x2f, 0x32, 0x33, 0x32, 0x34, 0x32, 0x35, 0x32,
    0x36, 0x32, 0x37, 0x32, 0x38, 0x32, 0x39, 0x32, 0x3d, 0x32, 0x41, 0x32,
    0x5f, 0x32, 0x62, 0x32, 0x64, 0x32, 0x66, 0x32, 0x67, 0x32, 0x68, 0x32,
    0x6c, 0x32, 0x6d, 0x32, 0x6e, 0x32, 0x70, 0x32, 0x72, 0x32, 0x75, 0x32,
    0x3a, 0x32, 0x42, 0x32, 0x43, 0x32, 0x44, 0x32, 0x45, 0x32, 0x46, 0x32,
    0x47, 0x32, 0x48, 0x32, 0x49, 0x32, 0x4a, 0x32, 0x4b, 0x32, 0x4c, 0x32,
    0x4d, 0x32, 0x4e, 0x32, 0x4f, 0x32, 0x50, 0x32, 0x51, 0x32, 0x52, 0x32,
    0x53, 0x32, 0x54, 0x32, 0x55, 0x32, 0x56, 0x32, 0x57, 0x32, 0x59, 0x32,
    0x6a, 0x32, 0x6b, 0x32, 0x71, 0x32, 0x76, 0x32, 0x77, 0x32, 0x78, 0x32,
    0x79, 0x32, 0x7a};
const uint16_t HuffDecoderCommon::table1_2_inner_[69] = {
    0x000a, 0x010a, 0x020a, 0x028a, 0x038a, 0x048a, 0x058a, 0x068a, 0x078a,
    0x088a, 0x098b, 0x0a8b, 0x0b8b, 0x0c8b, 0x0d8b, 0x0e8b, 0x0f8b, 0x108b,
    0x118b, 0x128b, 0x138b, 0x148b, 0x158b, 0x168b, 0x178b, 0x188b, 0x198b,
    0x1a8b, 0x1b8b, 0x1c8b, 0x1d8b, 0x1e8b, 0x1f8b, 0x208b, 0x218b, 0x228b,
    0x238c, 0x248c, 0x258c, 0x268c, 0x278c, 0x288c, 0x298c, 0x2a8c, 0x2b8c,
    0x2c8c, 0x2d8c, 0x2e8c, 0x2f8c, 0x308c, 0x318c, 0x328c, 0x338c, 0x348c,
    0x358c, 0x368c, 0x378c, 0x388c, 0x398c, 0x3a8c, 0x3b8c, 0x3c8c, 0x3d8c,
    0x3e8c, 0x3f8c, 0x408c, 0x418c, 0x428c, 0x0015};
const uint8_t HuffDecoderCommon::table1_3_emit_[135] = {
    0x61, 0x30, 0x61, 0x31, 0x61, 0x32, 0x61, 0x61, 0x63, 0x61, 0x65, 0x61,
    0x69, 0x61, 0x6f, 0x61, 0x73, 0x61, 0x74, 0x61, 0x20, 0x61, 0x25, 0x61,
    0x2d, 0x61, 0x2e, 0x61, 0x2f, 0x61, 0x33, 0x61, 0x34, 0x61, 0x35, 0x61,
    0x36, 0x61, 0x37, 0x61, 0x38, 0x61, 0x39, 0x61, 0x3d, 0x61, 0x41, 0x61,
    0x5f, 0x61, 0x62, 0x61, 0x64, 0x61, 0x66, 0x61, 0x67, 0x61, 0x68, 0x61,
    0x6c, 0x61, 0x6d, 0x61, 0x6e, 0x61, 0x70, 0x61, 0x72, 0x61, 0x75, 0x61,
    0x3a, 0x61, 0x42, 0x61, 0x43, 0x61, 0x44, 0x61, 0x45, 0x61, 0x46, 0x61,
    0x47, 0x61, 0x48, 0x61, 0x49, 0x61, 0x4a, 0x61, 0x4b, 0x61, 0x4c, 0x61,
    0x4d, 0x61, 0x4e, 0x61, 0x4f, 0x61, 0x50, 0x61, 0x51, 0x61, 0x52, 0x61,
    0x53, 0x61, 0x54, 0x61, 0x55, 0x61, 0x56, 0x61, 0x57, 0x61, 0x59, 0x61,
    0x6a, 0x61, 0x6b, 0x61, 0x71, 0x61, 0x76, 0x61, 0x77, 0x61, 0x78, 0x61,
    0x79, 0x61, 0x7a};
const uint16_t HuffDecoderCommon::table1_3_inner_[69] = {
    0x000a, 0x010a, 0x020a, 0x030a, 0x038a, 0x048a, 0x058a, 0x068a, 0x078a,
    0x088a, 0x098b, 0x0a8b, 0x0b8b, 0x0c8b, 0x0d8b, 0x0e8b, 0x0f8b, 0x108b,
    0x118b, 0x128b, 0x138b, 0x148b, 0x158b, 0x168b, 0x178b, 0x188b, 0x198b,
    0x1a8b, 0x1b8b, 0x1c8b, 0x1d8b, 0x1e8b, 0x1f8b, 0x208b, 0x218b, 0x228b,
    0x238c, 0x248c, 0x258c, 0x268c, 0x278c, 0x288c, 0x298c, 0x2a8c, 0x2b8c,
    0x2c8c, 0x2d8c, 0x2e8c, 0x2f8c, 0x308c, 0x318c, 0x328c, 0x338c, 0x348c,
    0x358c, 0x368c, 0x378c, 0x388c, 0x398c, 0x3a8c, 0x3b8c, 0x3c8c, 0x3d8c,
    0x3e8c, 0x3f8c, 0x408c, 0x418c, 0x428c, 0x0015};
const uint8_t HuffDecoderCommon::table1_4_emit_[135] = {
    0x63, 0x30, 0x63, 0x31, 0x63, 0x32, 0x63, 0x61, 0x63, 0x63, 0x65, 0x63,
    0x69, 0x63, 0x6f, 0x63, 0x73, 0x63, 0x74, 0x63, 0x20, 0x63, 0x25, 0x63,
    0x2d, 0x63, 0x2e, 0x63, 0x2f, 0x63, 0x33, 0x63, 0x34, 0x63, 0x35, 0x63,
    0x36, 0x63, 0x37, 0x63, 0x38, 0x63, 0x39, 0x63, 0x3d, 0x63, 0x41, 0x63,
    0x5f, 0x63, 0x62, 0x63, 0x64, 0x63, 0x66, 0x63, 0x67, 0x63, 0x68, 0x63,
    0x6c, 0x63, 0x6d, 0x63, 0x6e, 0x63, 0x70, 0x63, 0x72, 0x63, 0x75, 0x63,
    0x3a, 0x63, 0x42, 0x63, 0x43, 0x63, 0x44, 0x63, 0x45, 0x63, 0x46, 0x63,
    0x47, 0x63, 0x48, 0x63, 0x49, 0x63, 0x4a, 0x63, 0x4b, 0x63, 0x4c, 0x63,
    0x4d, 0x63, 0x4e, 0x63, 0x4f, 0x63, 0x50, 0x63, 0x51, 0x63, 0x52, 0x63,
    0x53, 0x63, 0x54, 0x63, 0x55, 0x63, 0x56, 0x63, 0x57, 0x63, 0x59, 0x63,
    0x6a, 0x63, 0x6b, 0x63, 0x71, 0x63, 0x76, 0x63, 0x77, 0x63, 0x78, 0x63,
    0x79, 0x63, 0x7a};
const uint16_t HuffDecoderCommon::table1_4_inner_[69] = {
    0x000a, 0x010a, 0x020a, 0x030a, 0x040a, 0x048a, 0x058a, 0x068a, 0x078a,
    0x088a, 0x098b, 0x0a8b, 0x0b8b, 0x0c8b, 0x0d8b, 0x0e8b, 0x0f8b, 0x108b,
    0x118b, 0x128b, 0x138b, 0x148b, 0x158b, 0x168b, 0x178b, 0x188b, 0x198b,
    0x1a8b, 0x1b8b, 0x1c8b, 0x1d8b, 0x1e8b, 0x1f8b, 0x208b, 0x218b, 0x228b,
    0x238c, 0x248c, 0x258c, 0x268c, 0x278c, 0x288c, 0x298c, 0x2a8c, 0x2b8c,
    0x2c8c, 0x2d8c, 0x2e8c, 0x2f8c, 0x308c, 0x318c, 0x328c, 0x338c, 0x348c,
    0x358c, 0x368c, 0x378c, 0x388c, 0x398c, 0x3a8c, 0x3b8c, 0x3c8c, 0x3d8c,
    0x3e8c, 0x3f8c, 0x408c, 0x418c, 0x428c, 0x0015};
const uint8_t HuffDecoderCommon::table1_5_emit_[135] = {
    0x65, 0x30, 0x65, 0x31, 0x65, 0x32, 0x65, 0x61, 0x65, 0x63, 0x65, 0x65,
    0x69, 0x65, 0x6f, 0x65, 0x73, 0x65, 0x74, 0x65, 0x20, 0x65, 0x25, 0x65,
    0x2d, 0x65, 0x2e, 0x65, 0x2f, 0x65, 0x33, 0x65, 0x34, 0x65, 0x35, 0x65,
    0x36, 0x65, 0x37, 0x65, 0x38, 0x65, 0x39, 0x65, 0x3d, 0x65, 0x41, 0x65,
    0x5f, 0x65, 0x62, 0x65, 0x64, 0x65, 0x66, 0x65, 0x67, 0x65, 0x68, 0x65,
    0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x65, 0x70, 0x65, 0x72, 0x65, 0x75, 0x65,
    0x3a, 0x65, 0x42, 0x65, 0x43, 0x65, 0x44, 0x65, 0x45, 0x65, 0x46, 0x65,
    0x47, 0x65, 0x48, 0x65, 0x49, 0x65, 0x4a, 0x65, 0x4b, 0x65, 0x4c, 0x65,
    0x4d, 0x65, 0x4e, 0x65, 0x4f, 0x65, 0x50, 0x65, 0x51, 0x65, 0x52, 0x65,
    0x53, 0x65, 0x54, 0x65, 0x55, 0x65, 0x56, 0x65, 0x57, 0x65, 0x59, 0x65,
    0x6a, 0x65, 0x6b, 0x65, 0x71, 0x65, 0x76, 0x65, 0x77, 0x65, 0x78, 0x65,
    0x79, 0x65, 0x7a};
const uint16_t HuffDecoderCommon::table1_5_inner_[69] = {
    0x000a, 0x010a, 0x020a, 0x030a, 0x040a, 0x050a, 0x058a, 0x068a, 0x078a,
    0x088a, 0x098b, 0x0a8b, 0x0b8b, 0x0c8b, 0x0d8b, 0x0e8b, 0x0f8b, 0x108b,
    0x118b, 0x128b, 0x138b, 0x148b, 0x158b, 0x168b, 0x178b, 0x188b, 0x198b,
    0x1a8b, 0x1b8b, 0x1c8b, 0x1d8b, 0x1e8b, 0x1f8b, 0x208b, 0x218b, 0x228b,
    0x238c, 0x248c, 0x258c, 0x268c, 0x278c, 0x288c, 0x298c, 0x2a8c, 0x2b8c,
    0x2c8c, 0x2d8c, 0x2e8c, 0x2f8c, 0x308c, 0x318c, 0x328c, 0x338c, 0x348c,
    0x358c, 0x368c, 0x378c, 0x388c, 0x398c, 0x3a8c, 0x3b8c, 0x3c8c, 0x3d8c,
    0x3e8c, 0x3f8c, 0x408c, 0x418c, 0x428c, 0x0015};
const uint8_t HuffDecoderCommon::table1_6_emit_[135] = {
    0x69, 0x30, 0x69, 0x31, 0x69, 0x32, 0x69, 0x61, 0x69, 0x63, 0x69, 0x65,
    0x69, 0x69, 0x6f, 0x69, 0x73, 0x69, 0x74, 0x69, 0x20, 0x69, 0x25, 0x69,
    0x2d, 0x69, 0x2e, 0x69, 0x2f, 0x69, 0x33, 0x69, 0x34, 0x69, 0x35, 0x69,
    0x36, 0x69, 0x37, 0x69, 0x38, 0x69, 0x39, 0x69, 0x3d, 0x69, 0x41, 0x69,
    0x5f, 0x69, 0x62, 0x69, 0x64, 0x69, 0x66, 0x69, 0x67, 0x69, 0x68, 0x69,
    0x6c, 0x69, 0x6d, 0x69, 0x6e, 0x69, 0x70, 0x69, 0x72, 0x69, 0x75, 0x69,
    0x3a, 0x69, 0x42, 0x69, 0x43, 0x69, 0x44, 0x69, 0x45, 0x69, 0x46, 0x69,
    0x47, 0x69, 0x48, 0x69, 0x49, 0x69, 0x4a, 0x69, 0x4b, 0x69, 0x4c, 0x69,
    0x4d, 0x69, 0x4e, 0x69, 0x4f, 0x69, 0x50, 0x69, 0x51, 0x69, 0x52, 0x69,
    0x53, 0x69, 0x54, 0x69, 0x55, 0x69, 0x56, 0x69, 0x57, 0x69, 0x59, 0x69,
    0x6a, 0x69, 0x6b, 0x69, 0x71, 0x69, 0x76, 0x69, 0x77, 0x69, 0x78, 0x69,
    0x79, 0x69, 0x7a};
const uint16_t HuffDecoderCommon::table1_6_inner_[69] = {
    0x000a, 0x010a, 0x020a, 0x030a, 0x040a, 0x050a, 0x060a, 0x068a, 0x078a,
    0x088a, 0x098b, 0x0a8b, 0x0b8b, 0x0c8b, 0x0d8b, 0x0e8b, 0x0f8b, 0x108b,
    0x118b, 0x128b, 0x138b, 0x148b, 0x158b, 0x168b, 0x178b, 0x188b, 0x198b,
    0x1a8b, 0x1b8b, 0x1c8b, 0x1d8b, 0x1e8b, 0x1f8b, 0x208b, 0x218b, 0x228b,
    0x238c, 0x248c, 0x258c, 0x268c, 0x278c, 0x288c, 0x298c, 0x2a8c, 0x2b8c,
    0x2c8c, 0x2d8c, 0x2e8c, 0x2f8c, 0x308c, 0x318c, 0x328c, 0x338c, 0x348c,
    0x358c, 0x368c, 0x378c, 0x388c, 0x398c, 0x3a8c, 0x3b8c, 0x3c8c, 0x3d8c,
    0x3e8c, 0x3f8c, 0x408c, 0x418c, 0x428c, 0x0015};
const uint8_t HuffDecoderCommon::table1_7_emit_[135] = {
    0x6f, 0x30, 0x6f, 0x31, 0x6f, 0x32, 0x6f, 0x61, 0x6f, 0x63, 0x6f, 0x65,
    0x6f, 0x69, 0x6f, 0x6f, 0x73, 0x6f, 0x74, 0x6f, 0x20, 0x6f, 0x25, 0x6f,
    0x2d, 0x6f, 0x2e, 0x6f, 0x2f, 0x6f, 0x33, 0x6f, 0x34, 0x6f, 0x35, 0x6f,
    0x36, 0x6f, 0x37, 0x6f, 0x38, 0x6f, 0x39, 0x6f, 0x3d, 0x6f, 0x41, 0x6f,
    0x5f, 0x6f, 0x62, 0x6f, 0x64, 0x6f, 0x66, 0x6f, 0x67, 0x6f, 0x68, 0x6f,
    0x6c, 0x6f, 0x6d, 0x6f, 0x6e, 0x6f, 0x70, 0x6f, 0x72, 0x6f, 0x75, 0x6f,
    0x3a, 0x6f, 0x42, 0x6f, 0x43, 0x6f, 0x44, 0x6f, 0x45, 0x6f, 0x46, 0x6f,
    0x47, 0x6f, 0x48, 0x6f, 0x49, 0x6f, 0x4a, 0x6f, 0x4b, 0x6f, 0x4c, 0x6f,
    0x4d, 0x6f, 0x4e, 0x6f, 0x4f, 0x6f, 0x50, 0x6f, 0x51, 0x6f, 0x52, 0x6f,
    0x53, 0x6f, 0x54, 0x6f, 0x55, 0x6f, 0x56, 0x6f, 0x57, 0x6f, 0x59, 0x6f,
    0x6a, 0x6f, 0x6b, 0x6f, 0x71, 0x6f, 0x76, 0x6f, 0x77, 0x6f, 0x78, 0x6f,
    0x79, 0x6f, 0x7a};
const uint16_t HuffDecoderCommon::table1_7_inner_[69] = {
    0x000a, 0x010a, 0x020a, 0x030a, 0x040a, 0x050a, 0x060a, 0x070a, 0x078a,
    0x088a, 0x098b, 0x0a8b, 0x0b8b, 0x0c8b, 0x0d8b, 0x0e8b, 0x0f8b, 0x108b,
    0x118b, 0x128b, 0x138b, 0x148b, 0x158b, 0x168b, 0x178b, 0x188b, 0x198b,
    0x1a8b, 0x1b8b, 0x1c8b, 0x1d8b, 0x1e8b, 0x1f8b, 0x208b, 0x218b, 0x228b,
    0x238c, 0x248c, 0x258c, 0x268c, 0x278c, 0x288c, 0x298c, 0x2a8c, 0x2b8c,
    0x2c8c, 0x2d8c, 0x2e8c, 0x2f8c, 0x308c, 0x318c, 0x328c, 0x338c, 0x348c,
    0x358c, 0x368c, 0x378c, 0x388c, 0x398c, 0x3a8c, 0x3b8c, 0x3c8c, 0x3d8c,
    0x3e8c, 0x3f8c, 0x408c, 0x418c, 0x428c, 0x0015};
const uint8_t HuffDecoderCommon::table1_8_emit_[135] = {
    0x73, 0x30, 0x73, 0x31, 0x73, 0x32, 0x73, 0x61, 0x73, 0x63, 0x73, 0x65,
    0x73, 0x69, 0x73, 0x6f, 0x73, 0x73, 0x74, 0x73, 0x20, 0x73, 0x25, 0x73,
    0x2d, 0x73, 0x2e, 0x73, 0x2f, 0x73, 0x33, 0x73, 0x34, 0x73, 0x35, 0x73,
    0x36, 0x73, 0x37, 0x73, 0x38, 0x73, 0x39, 0x73, 0x3d, 0x73, 0x41, 0x73,
    0x5f, 0x73, 0x62, 0x73, 0x64, 0x73, 0x66, 0x73, 0x67, 0x73, 0x68, 0x73,
    0x6c, 0x73, 0x6d, 0x73, 0x6e, 0x73, 0x70, 0x73, 0x72, 0x73, 0x75, 0x73,
    0x3a, 0x73, 0x42, 0x73, 0x43, 0x73, 0x44, 0x73, 0x45, 0x73, 0x46, 0x73,
    0x47, 0x73, 0x48, 0x73, 0x49, 0x73, 0x4a, 0x73, 0x4b, 0x73, 0x4c, 0x73,
    0x4d, 0x73, 0x4e, 0x73, 0x4f, 0x73, 0x50, 0x73, 0x51, 0x73, 0x52, 0x73,
    0x53, 0x73, 0x54, 0x73, 0x55, 0x73, 0x56, 0x73, 0x57, 0x73, 0x59, 0x73,
    0x6a, 0x73, 0x6b, 0x73, 0x71, 0x73, 0x76, 0x73, 0x77, 0x73, 0x78, 0x73,
    0x79, 0x73, 0x7a};
const uint16_t HuffDecoderCommon::table1_8_inner_[69] = {
    0x000a, 0x010a, 0x020a, 0x030a, 0x040a, 0x050a, 0x060a, 0x070a, 0x080a,
    0x088a, 0x098b, 0x0a8b, 0x0b8b, 0x0c8b, 0x0d8b, 0x0e8b, 0x0f8b, 0x108b,
    0x118b, 0x128b, 0x138b, 0x148b, 0x158b, 0x168b, 0x178b, 0x188b, 0x198b,
    0x1a8b, 0x1b8b, 0x1c8b, 0x1d8b, 0x1e8b, 0x1f8b, 0x208b, 0x218b, 0x228b,
    0x238c, 0x248c, 0x258c, 0x268c, 0x278c, 0x288c, 0x298c, 0x2a8c, 0x2b8c,
    0x2c8c, 0x2d8c, 0x2e8c, 0x2f8c, 0x308c, 0x318c, 0x328c, 0x338c, 0x348c,
    0x358c, 0x368c, 0x378c, 0x388c, 0x398c, 0x3a8c, 0x3b8c, 0x3c8c, 0x3d8c,
    0x3e8c, 0x3f8c, 0x408c, 0x418c, 0x428c, 0x0015};
const uint8_t HuffDecoderCommon::table1_9_emit_[135] = {
    0x74, 0x30, 0x74, 0x31, 0x74, 0x32, 0x74, 0x61, 0x74, 0x63, 0x74, 0x65,
    0x74, 0x69, 0x74, 0x6f, 0x74, 0x73, 0x74, 0x74, 0x20, 0x74, 0x25, 0x74,
    0x2d, 0x74, 0x2e, 0x74, 0x2f, 0x74, 0x33, 0x74, 0x34, 0x74, 0x35, 0x74,
    0x36, 0x74, 0x37, 0x74, 0x38, 0x74, 0x39, 0x74, 0x3d, 0x74, 0x41, 0x74,
    0x5f, 0x74, 0x62, 0x74, 0x64, 0x74, 0x66, 0x74, 0x67, 0x74, 0x68, 0x74,
    0x6c, 0x74, 0x6d, 0x74, 0x6e, 0x74, 0x70, 0x74, 0x72, 0x74, 0x75, 0x74,
    0x3a, 0x74, 0x42, 0x74, 0x43, 0x74, 0x44, 0x74, 0x45, 0x74, 0x46, 0x74,
    0x47, 0x74, 0x48, 0x74, 0x49, 0x74, 0x4a, 0x74, 0x4b, 0x74, 0x4c, 0x74,
    0x4d, 0x74, 0x4e, 0x74, 0x4f, 0x74, 0x50, 0x74, 0x51, 0x74, 0x52, 0x74,
    0x53, 0x74, 0x54, 0x74, 0x55, 0x74, 0x56, 0x74, 0x57, 0x74, 0x59, 0x74,
    0x6a, 0x74, 0x6b, 0x74, 0x71, 0x74, 0x76, 0x74, 0x77, 0x74, 0x78, 0x74,
    0x79, 0x74, 0x7a};
const uint16_t HuffDecoderCommon::table1_9_inner_[69] = {
    0x000a, 0x010a, 0x020a, 0x030a, 0x040a, 0x050a, 0x060a, 0x070a, 0x080a,
    0x090a, 0x098b, 0x0a8b, 0x0b8b, 0x0c8b, 0x0d8b, 0x0e8b, 0x0f8b, 0x108b,
    0x118b, 0x128b, 0x138b, 0x148b, 0x158b, 0x168b, 0x178b, 0x188b, 0x198b,
    0x1a8b, 0x1b8b, 0x1c8b, 0x1d8b, 0x1e8b, 0x1f8b, 0x208b, 0x218b, 0x228b,
    0x238c, 0x248c, 0x258c, 0x268c, 0x278c, 0x288c, 0x298c, 0x2a8c, 0x2b8c,
    0x2c8c, 0x2d8c, 0x2e8c, 0x2f8c, 0x308c, 0x318c, 0x328c, 0x338c, 0x348c,
    0x358c, 0x368c, 0x378c, 0x388c, 0x398c, 0x3a8c, 0x3b8c, 0x3c8c, 0x3d8c,
    0x3e8c, 0x3f8c, 0x408c, 0x418c, 0x428c, 0x0015};
const uint8_t HuffDecoderCommon::table1_10_emit_[140] = {
    0x20, 0x30, 0x20, 0x31, 0x20, 0x32, 0x20, 0x61, 0x20, 0x63, 0x20, 0x65,
    0x20, 0x69, 0x20, 0x6f, 0x20, 0x73, 0x20, 0x74, 0x20, 0x20, 0x25, 0x20,
    0x2d, 0x20, 0x2e, 0x20, 0x2f, 0x20, 0x33, 0x20, 0x34, 0x20, 0x35, 0x20,
    0x36, 0x20, 0x37, 0x20, 0x38, 0x20, 0x39, 0x20, 0x3d, 0x20, 0x41, 0x20,
    0x5f, 0x20, 0x62, 0x20, 0x64, 0x20, 0x66, 0x20, 0x67, 0x20, 0x68, 0x20,
    0x6c, 0x20, 0x6d, 0x20, 0x6e, 0x20, 0x70, 0x20, 0x72, 0x20, 0x75, 0x25,
    0x30, 0x25, 0x31, 0x25, 0x32, 0x25, 0x61, 0x25, 0x63, 0x25, 0x65, 0x25,
    0x69, 0x25, 0x6f, 0x25, 0x73, 0x25, 0x74, 0x25, 0x25, 0x2d, 0x25, 0x2e,
    0x25, 0x2f, 0x25, 0x33, 0x25, 0x34, 0x25, 0x35, 0x25, 0x36, 0x25, 0x37,
    0x25, 0x38, 0x25, 0x39, 0x25, 0x3d, 0x25, 0x41, 0x25, 0x5f, 0x25, 0x62,
    0x25, 0x64, 0x25, 0x66, 0x25, 0x67, 0x25, 0x68, 0x25, 0x6c, 0x25, 0x6d,
    0x25, 0x6e, 0x25, 0x70, 0x25, 0x72, 0x25, 0x75};
const uint16_t HuffDecoderCommon::table1_10_inner_[74] = {
    0x000b, 0x010b, 0x020b, 0x030b, 0x040b, 0x050b, 0x060b, 0x070b, 0x080b,
    0x090b, 0x0a0c, 0x0a8c, 0x0b8c, 0x0c8c, 0x0d8c, 0x0e8c, 0x0f8c, 0x108c,
    0x118c, 0x128c, 0x138c, 0x148c, 0x158c, 0x168c, 0x178c, 0x188c, 0x198c,
    0x1a8c, 0x1b8c, 0x1c8c, 0x1d8c, 0x1e8c, 0x1f8c, 0x208c, 0x218c, 0x228c,
    0x0016, 0x238b, 0x248b, 0x258b, 0x268b, 0x278b, 0x288b, 0x298b, 0x2a8b,
    0x2b8b, 0x2c8b, 0x0b0c, 0x2d8c, 0x2e0c, 0x2f0c, 0x300c, 0x310c, 0x320c,
    0x330c, 0x340c, 0x350c, 0x360c, 0x370c, 0x380c, 0x390c, 0x3a0c, 0x3b0c,
    0x3c0c, 0x3d0c, 0x3e0c, 0x3f0c, 0x400c, 0x410c, 0x420c, 0x430c, 0x440c,
    0x450c, 0x0b16};
const uint8_t HuffDecoderCommon::table1_10_outer_[128] = {
    0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7,  8,  8,  9,
    9,  10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27,
    28, 29, 30, 31, 32, 33, 34, 35, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
    36, 36, 36, 36, 36, 36, 36, 37, 37, 38, 38, 39, 39, 40, 40, 41, 41, 42, 42,
    43, 43, 44, 44, 45, 45, 46, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57,
    58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 73, 73, 73,
    73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73};
const uint8_t HuffDecoderCommon::table1_11_emit_[140] = {
    0x2d, 0x30, 0x2d, 0x31, 0x2d, 0x32, 0x2d, 0x61, 0x2d, 0x63, 0x2d, 0x65,
    0x2d, 0x69, 0x2d, 0x6f, 0x2d, 0x73, 0x2d, 0x74, 0x2d, 0x20, 0x2d, 0x25,
    0x2d, 0x2d, 0x2e, 0x2d, 0x2f, 0x2d, 0x33, 0x2d, 0x34, 0x2d, 0x35, 0x2d,
    0x36, 0x2d, 0x37, 0x2d, 0x38, 0x2d, 0x39, 0x2d, 0x3d, 0x2d, 0x41, 0x2d,
    0x5f, 0x2d, 0x62, 0x2d, 0x64, 0x2d, 0x66, 0x2d, 0x67, 0x2d, 0x68, 0x2d,
    0x6c, 0x2d, 0x6d, 0x2d, 0x6e, 0x2d, 0x70, 0x2d, 0x72, 0x2d, 0x75, 0x2e,
    0x30, 0x2e, 0x31, 0x2e, 0x32, 0x2e, 0x61, 0x2e, 0x63, 0x2e, 0x65, 0x2e,
    0x69, 0x2e, 0x6f, 0x2e, 0x73, 0x2e, 0x74, 0x2e, 0x20, 0x2e, 0x25, 0x2e,
    0x2e, 0x2f, 0x2e, 0x33, 0x2e, 0x34, 0x2e, 0x35, 0x2e, 0x36, 0x2e, 0x37,
    0x2e, 0x38, 0x2e, 0x39, 0x2e, 0x3d, 0x2e, 0x41, 0x2e, 0x5f, 0x2e, 0x62,
    0x2e, 0x64, 0x2e, 0x66, 0x2e, 0x67, 0x2e, 0x68, 0x2e, 0x6c, 0x2e, 0x6d,
    0x2e, 0x6e, 0x2e, 0x70, 0x2e, 0x72, 0x2e, 0x75};
const uint16_t HuffDecoderCommon::table1_11_inner_[74] = {
    0x000b, 0x010b, 0x020b, 0x030b, 0x040b, 0x050b, 0x060b, 0x070b, 0x080b,
    0x090b, 0x0a0c, 0x0b0c, 0x0c0c, 0x0c8c, 0x0d8c, 0x0e8c, 0x0f8c, 0x108c,
    0x118c, 0x128c, 0x138c, 0x148c, 0x158c, 0x168c, 0x178c, 0x188c, 0x198c,
    0x1a8c, 0x1b8c, 0x1c8c, 0x1d8c, 0x1e8c, 0x1f8c, 0x208c, 0x218c, 0x228c,
    0x0016, 0x238b, 0x248b, 0x258b, 0x268b, 0x278b, 0x288b, 0x298b, 0x2a8b,
    0x2b8b, 0x2c8b, 0x2d8c, 0x2e8c, 0x0d0c, 0x2f8c, 0x300c, 0x310c, 0x320c,
    0x330c, 0x340c, 0x350c, 0x360c, 0x370c, 0x380c, 0x390c, 0x3a0c, 0x3b0c,
    0x3c0c, 0x3d0c, 0x3e0c, 0x3f0c, 0x400c, 0x410c, 0x420c, 0x430c, 0x440c,
    0x450c, 0x0d16};
const uint8_t HuffDecoderCommon::table1_12_emit_[140] = {
    0x2f, 0x30, 0x2f, 0x31, 0x2f, 0x32, 0x2f, 0x61, 0x2f, 0x63, 0x2f, 0x65,
    0x2f, 0x69, 0x2f, 0x6f, 0x2f, 0x73, 0x2f, 0x74, 0x2f, 0x20, 0x2f, 0x25,
    0x2f, 0x2d, 0x2f, 0x2e, 0x2f, 0x2f, 0x33, 0x2f, 0x34, 0x2f, 0x35, 0x2f,
    0x36, 0x2f, 0x37, 0x2f, 0x38, 0x2f, 0x39, 0x2f, 0x3d, 0x2f, 0x41, 0x2f,
    0x5f, 0x2f, 0x62, 0x2f, 0x64, 0x2f, 0x66, 0x2f, 0x67, 0x2f, 0x68, 0x2f,
    0x6c, 0x2f, 0x6d, 0x2f, 0x6e, 0x2f, 0x70, 0x2f, 0x72, 0x2f, 0x75, 0x33,
    0x30, 0x33, 0x31, 0x33, 0x32, 0x33, 0x61, 0x33, 0x63, 0x33, 0x65, 0x33,
    0x69, 0x33, 0x6f, 0x33, 0x73, 0x33, 0x74, 0x33, 0x20, 0x33, 0x25, 0x33,
    0x2d, 0x33, 0x2e, 0x33, 0x33, 0x34, 0x33, 0x35, 0x33, 0x36, 0x33, 0x37,
    0x33, 0x38, 0x33, 0x39, 0x33, 0x3d, 0x33, 0x41, 0x33, 0x5f, 0x33, 0x62,
    0x33, 0x64, 0x33, 0x66, 0x33, 0x67, 0x33, 0x68, 0x33, 0x6c, 0x33, 0x6d,
    0x33, 0x6e, 0x33, 0x70, 0x33, 0x72, 0x33, 0x75};
const uint16_t HuffDecoderCommon::table1_12_inner_[74] = {
    0x000b, 0x010b, 0x020b, 0x030b, 0x040b, 0x050b, 0x060b, 0x070b, 0x080b,
    0x090b, 0x0a0c, 0x0b0c, 0x0c0c, 0x0d0c, 0x0e0c, 0x0e8c, 0x0f8c, 0x108c,
    0x118c, 0x128c, 0x138c, 0x148c, 0x158c, 0x168c, 0x178c, 0x188c, 0x198c,
    0x1a8c, 0x1b8c, 0x1c8c, 0x1d8c, 0x1e8c, 0x1f8c, 0x208c, 0x218c, 0x228c,
    0x0016, 0x238b, 0x248b, 0x258b, 0x268b, 0x278b, 0x288b, 0x298b, 0x2a8b,
    0x2b8b, 0x2c8b, 0x2d8c, 0x2e8c, 0x2f8c, 0x308c, 0x0f0c, 0x318c, 0x320c,
    0x330c, 0x340c, 0x350c, 0x360c, 0x370c, 0x380c, 0x390c, 0x3a0c, 0x3b0c,
    0x3c0c, 0x3d0c, 0x3e0c, 0x3f0c, 0x400c, 0x410c, 0x420c, 0x430c, 0x440c,
    0x450c, 0x0f16};
const uint8_t HuffDecoderCommon::table1_13_emit_[140] = {
    0x34, 0x30, 0x34, 0x31, 0x34, 0x32, 0x34, 0x61, 0x34, 0x63, 0x34, 0x65,
    0x34, 0x69, 0x34, 0x6f, 0x34, 0x73, 0x34, 0x74, 0x34, 0x20, 0x34, 0x25,
    0x34, 0x2d, 0x34, 0x2e, 0x34, 0x2f, 0x34, 0x33, 0x34, 0x34, 0x35, 0x34,
    0x36, 0x34, 0x37, 0x34, 0x38, 0x34, 0x39, 0x34, 0x3d, 0x34, 0x41, 0x34,
    0x5f, 0x34, 0x62, 0x34, 0x64, 0x34, 0x66, 0x34, 0x67, 0x34, 0x68, 0x34,
    0x6c, 0x34, 0x6d, 0x34, 0x6e, 0x34, 0x70, 0x34, 0x72, 0x34, 0x75, 0x35,
    0x30, 0x35, 0x31, 0x35, 0x32, 0x35, 0x61, 0x35, 0x63, 0x35, 0x65, 0x35,
    0x69, 0x35, 0x6f, 0x35, 0x73, 0x35, 0x74, 0x35, 0x20, 0x35, 0x25, 0x35,
    0x2d, 0x35, 0x2e, 0x35, 0x2f, 0x35, 0x33, 0x35, 0x35, 0x36, 0x35, 0x37,
    0x35, 0x38, 0x35, 0x39, 0x35, 0x3d, 0x35, 0x41, 0x35, 0x5f, 0x35, 0x62,
    0x35, 0x64, 0x35, 0x66, 0x35, 0x67, 0x35, 0x68, 0x35, 0x6c, 0x35, 0x6d,
    0x35, 0x6e, 0x35, 0x70, 0x35, 0x72, 0x35, 0x75};
const uint16_t HuffDecoderCommon::table1_13_inner_[74] = {
    0x000b, 0x010b, 0x020b, 0x030b, 0x040b, 0x050b, 0x060b, 0x070b, 0x080b,
    0x090b, 0x0a0c, 0x0b0c, 0x0c0c, 0x0d0c, 0x0e0c, 0x0f0c, 0x100c, 0x108c,
    0x118c, 0x128c, 0x138c, 0x148c, 0x158c, 0x168c, 0x178c, 0x188c, 0x198c,
    0x1a8c, 0x1b8c, 0x1c8c, 0x1d8c, 0x1e8c, 0x1f8c, 0x208c, 0x218c, 0x228c,
    0x0016, 0x238b, 0x248b, 0x258b, 0x268b, 0x278b, 0x288b, 0x298b, 0x2a8b,
    0x2b8b, 0x2c8b, 0x2d8c, 0x2e8c, 0x2f8c, 0x308c, 0x318c, 0x328c, 0x110c,
    0x338c, 0x340c, 0x350c, 0x360c, 0x370c, 0x380c, 0x390c, 0x3a0c, 0x3b0c,
    0x3c0c, 0x3d0c, 0x3e0c, 0x3f0c, 0x400c, 0x410c, 0x420c, 0x430c, 0x440c,
    0x450c, 0x1116};
const uint8_t HuffDecoderCommon::table1_14_emit_[140] = {
    0x36, 0x30, 0x36, 0x31, 0x36, 0x32, 0x36, 0x61, 0x36, 0x63, 0x36, 0x65,
    0x36, 0x69, 0x36, 0x6f, 0x36, 0x73, 0x36, 0x74, 0x36, 0x20, 0x36, 0x25,
    0x36, 0x2d, 0x36, 0x2e, 0x36, 0x2f, 0x36, 0x33, 0x36, 0x34, 0x36, 0x35,
    0x36, 0x36, 0x37, 0x36, 0x38, 0x36, 0x39, 0x36, 0x3d, 0x36, 0x41, 0x36,
    0x5f, 0x36, 0x62, 0x36, 0x64, 0x36, 0x66, 0x36, 0x67, 0x36, 0x68, 0x36,
    0x6c, 0x36, 0x6d, 0x36, 0x6e, 0x36, 0x70, 0x36, 0x72, 0x36, 0x75, 0x37,
    0x30, 0x37, 0x31, 0x37, 0x32, 0x37, 0x61, 0x37, 0x63, 0x37, 0x65, 0x37,
    0x69, 0x37, 0x6f, 0x37, 0x73, 0x37, 0x74, 0x37, 0x20, 0x37, 0x25, 0x37,
    0x2d, 0x37, 0x2e, 0x37, 0x2f, 0x37, 0x33, 0x37, 0x34, 0x37, 0x35, 0x37,
    0x37, 0x38, 0x37, 0x39, 0x37, 0x3d, 0x37, 0x41, 0x37, 0x5f, 0x37, 0x62,
    0x37, 0x64, 0x37, 0x66, 0x37, 0x67, 0x37, 0x68, 0x37, 0x6c, 0x37, 0x6d,
    0x37, 0x6e, 0x37, 0x70, 0x37, 0x72, 0x37, 0x75};
const uint16_t HuffDecoderCommon::table1_14_inner_[74] = {
    0x000b, 0x010b, 0x020b, 0x030b, 0x040b, 0x050b, 0x060b, 0x070b, 0x080b,
    0x090b, 0x0a0c, 0x0b0c, 0x0c0c, 0x0d0c, 0x0e0c, 0x0f0c, 0x100c, 0x110c,
    0x120c, 0x128c, 0x138c, 0x148c, 0x158c, 0x168c, 0x178c, 0x188c, 0x198c,
    0x1a8c, 0x1b8c, 0x1c8c, 0x1d8c, 0x1e8c, 0x1f8c, 0x208c, 0x218c, 0x228c,
    0x0016, 0x238b, 0x248b, 0x258b, 0x268b, 0x278b, 0x288b, 0x298b, 0x2a8b,
    0x2b8b, 0x2c8b, 0x2d8c, 0x2e8c, 0x2f8c, 0x308c, 0x318c, 0x328c, 0x338c,
    0x348c, 0x130c, 0x358c, 0x360c, 0x370c, 0x380c, 0x390c, 0x3a0c, 0x3b0c,
    0x3c0c, 0x3d0c, 0x3e0c, 0x3f0c, 0x400c, 0x410c, 0x420c, 0x430c, 0x440c,
    0x450c, 0x1316};
const uint8_t HuffDecoderCommon::table1_15_emit_[140] = {
    0x38, 0x30, 0x38, 0x31, 0x38, 0x32, 0x38, 0x61, 0x38, 0x63, 0x38, 0x65,
    0x38, 0x69, 0x38, 0x6f, 0x38, 0x73, 0x38, 0x74, 0x38, 0x20, 0x38, 0x25,
    0x38, 0x2d, 0x38, 0x2e, 0x38, 0x2f, 0x38, 0x33, 0x38, 0x34, 0x38, 0x35,
    0x38, 0x36, 0x38, 0x37, 0x38, 0x38, 0x39, 0x38, 0x3d, 0x38, 0x41, 0x38,
    0x5f, 0x38, 0x62, 0x38, 0x64, 0x38, 0x66, 0x38, 0x67, 0x38, 0x68, 0x38,
    0x6c, 0x38, 0x6d, 0x38, 0x6e, 0x38, 0x70, 0x38, 0x72, 0x38, 0x75, 0x39,
    0x30, 0x39, 0x31, 0x39, 0x32, 0x39, 0x61, 0x39, 0x63, 0x39, 0x65, 0x39,
    0x69, 0x39, 0x6f, 0x39, 0x73, 0x39, 0x74, 0x39, 0x20, 0x39, 0x25, 0x39,
    0x2d, 0x39, 0x2e, 0x39, 0x2f, 0x39, 0x33, 0x39, 0x34, 0x39, 0x35, 0x39,
    0x36, 0x39, 0x37, 0x39, 0x39, 0x3d, 0x39, 0x41, 0x39, 0x5f, 0x39, 0x62,
    0x39, 0x64, 0x39, 0x66, 0x39, 0x67, 0x39, 0x68, 0x39, 0x6c, 0x39, 0x6d,
    0x39, 0x6e, 0x39, 0x70, 0x39, 0x72, 0x39, 0x75};
const uint16_t HuffDecoderCommon::table1_15_inner_[74] = {
    0x000b, 0x010b, 0x020b, 0x030b, 0x040b, 0x050b, 0x060b, 0x070b, 0x080b,
    0x090b, 0x0a0c, 0x0b0c, 0x0c0c, 0x0d0c, 0x0e0c, 0x0f0c, 0x100c, 0x110c,
    0x120c, 0x130c, 0x140c, 0x148c, 0x158c, 0x168c, 0x178c, 0x188c, 0x198c,
    0x1a8c, 0x1b8c, 0x1c8c, 0x1d8c, 0x1e8c, 0x1f8c, 0x208c, 0x218c, 0x228c,
    0x0016, 0x238b, 0x248b, 0x258b, 0x268b, 0x278b, 0x288b, 0x298b, 0x2a8b,
    0x2b8b, 0x2c8b, 0x2d8c, 0x2e8c, 0x2f8c, 0x308c, 0x318c, 0x328c, 0x338c,
    0x348c, 0x358c, 0x368c, 0x150c, 0x378c, 0x380c, 0x390c, 0x3a0c, 0x3b0c,
    0x3c0c, 0x3d0c, 0x3e0c, 0x3f0c, 0x400c, 0x410c, 0x420c, 0x430c, 0x440c,
    0x450c, 0x1516};
const uint8_t HuffDecoderCommon::table1_16_emit_[140] = {
    0x3d, 0x30, 0x3d, 0x31, 0x3d, 0x32, 0x3d, 0x61, 0x3d, 0x63, 0x3d, 0x65,
    0x3d, 0x69, 0x3d, 0x6f, 0x3d, 0x73, 0x3d, 0x74, 0x3d, 0x20, 0x3d, 0x25,
    0x3d, 0x2d, 0x3d, 0x2e, 0x3d, 0x2f, 0x3d, 0x33, 0x3d, 0x34, 0x3d, 0x35,
    0x3d, 0x36, 0x3d, 0x37, 0x3d, 0x38, 0x3d, 0x39, 0x3d, 0x3d, 0x41, 0x3d,
    0x5f, 0x3d, 0x62, 0x3d, 0x64, 0x3d, 0x66, 0x3d, 0x67, 0x3d, 0x68, 0x3d,
    0x6c, 0x3d, 0x6d, 0x3d, 0x6e, 0x3d, 0x70, 0x3d, 0x72, 0x3d, 0x75, 0x41,
    0x30, 0x41, 0x31, 0x41, 0x32, 0x41, 0x61, 0x41, 0x63, 0x41, 0x65, 0x41,
    0x69, 0x41, 0x6f, 0x41, 0x73, 0x41, 0x74, 0x41, 0x20, 0x41, 0x25, 0x41,
    0x2d, 0x41, 0x2e, 0x41, 0x2f, 0x41, 0x33, 0x41, 0x34, 0x41, 0x35, 0x41,
    0x36, 0x41, 0x37, 0x41, 0x38, 0x41, 0x39, 0x41, 0x41, 0x5f, 0x41, 0x62,
    0x41, 0x64, 0x41, 0x66, 0x41, 0x67, 0x41, 0x68, 0x41, 0x6c, 0x41, 0x6d,
    0x41, 0x6e, 0x41, 0x70, 0x41, 0x72, 0x41, 0x75};
const uint16_t HuffDecoderCommon::table1_16_inner_[74] = {
    0x000b, 0x010b, 0x020b, 0x030b, 0x040b, 0x050b, 0x060b, 0x070b, 0x080b,
    0x090b, 0x0a0c, 0x0b0c, 0x0c0c, 0x0d0c, 0x0e0c, 0x0f0c, 0x100c, 0x110c,
    0x120c, 0x130c, 0x140c, 0x150c, 0x160c, 0x168c, 0x178c, 0x188c, 0x198c,
    0x1a8c, 0x1b8c, 0x1c8c, 0x1d8c, 0x1e8c, 0x1f8c, 0x208c, 0x218c, 0x228c,
    0x0016, 0x238b, 0x248b, 0x258b, 0x268b, 0x278b, 0x288b, 0x298b, 0x2a8b,
    0x2b8b, 0x2c8b, 0x2d8c, 0x2e8c, 0x2f8c, 0x308c, 0x318c, 0x328c, 0x338c,
    0x348c, 0x358c, 0x368c, 0x378c, 0x388c, 0x170c, 0x398c, 0x3a0c, 0x3b0c,
    0x3c0c, 0x3d0c, 0x3e0c, 0x3f0c, 0x400c, 0x410c, 0x420c, 0x430c, 0x440c,
    0x450c, 0x1716};
const uint8_t HuffDecoderCommon::table1_17_emit_[140] = {
    0x5f, 0x30, 0x5f, 0x31, 0x5f, 0x32, 0x5f, 0x61, 0x5f, 0x63, 0x5f, 0x65,
    0x5f, 0x69, 0x5f, 0x6f, 0x5f, 0x73, 0x5f, 0x74, 0x5f, 0x20, 0x5f, 0x25,
    0x5f, 0x2d, 0x5f, 0x2e, 0x5f, 0x2f, 0x5f, 0x33, 0x5f, 0x34, 0x5f, 0x35,
    0x5f, 0x36, 0x5f, 0x37, 0x5f, 0x38, 0x5f, 0x39, 0x5f, 0x3d, 0x5f, 0x41,
    0x5f, 0x5f, 0x62, 0x5f, 0x64, 0x5f, 0x66, 0x5f, 0x67, 0x5f, 0x68, 0x5f,
    0x6c, 0x5f, 0x6d, 0x5f, 0x6e, 0x5f, 0x70, 0x5f, 0x72, 0x5f, 0x75, 0x62,
    0x30, 0x62, 0x31, 0x62, 0x32, 0x62, 0x61, 0x62, 0x63, 0x62, 0x65, 0x62,
    0x69, 0x62, 0x6f, 0x62, 0x73, 0x62, 0x74, 0x62, 0x20, 0x62, 0x25, 0x62,
    0x2d, 0x62, 0x2e, 0x62, 0x2f, 0x62, 0x33, 0x62, 0x34, 0x62, 0x35, 0x62,
    0x36, 0x62, 0x37, 0x62, 0x38, 0x62, 0x39, 0x62, 0x3d, 0x62, 0x41, 0x62,
    0x62, 0x64, 0x62, 0x66, 0x62, 0x67, 0x62, 0x68, 0x62, 0x6c, 0x62, 0x6d,
    0x62, 0x6e, 0x62, 0x70, 0x62, 0x72, 0x62, 0x75};
const uint16_t HuffDecoderCommon::table1_17_inner_[74] = {
    0x000b, 0x010b, 0x020b, 0x030b, 0x040b, 0x050b, 0x060b, 0x070b, 0x080b,
    0x090b, 0x0a0c, 0x0b0c, 0x0c0c, 0x0d0c, 0x0e0c, 0x0f0c, 0x100c, 0x110c,
    0x120c, 0x130c, 0x140c, 0x150c, 0x160c, 0x170c, 0x180c, 0x188c, 0x198c,
    0x1a8c, 0x1b8c, 0x1c8c, 0x1d8c, 0x1e8c, 0x1f8c, 0x208c, 0x218c, 0x228c,
    0x0016, 0x238b, 0x248b, 0x258b, 0x268b, 0x278b, 0x288b, 0x298b, 0x2a8b,
    0x2b8b, 0x2c8b, 0x2d8c, 0x2e8c, 0x2f8c, 0x308c, 0x318c, 0x328c, 0x338c,
    0x348c, 0x358c, 0x368c, 0x378c, 0x388c, 0x398c, 0x3a8c, 0x190c, 0x3b8c,
    0x3c0c, 0x3d0c, 0x3e0c, 0x3f0c, 0x400c, 0x410c, 0x420c, 0x430c, 0x440c,
    0x450c, 0x1916};
const uint8_t HuffDecoderCommon::table1_18_emit_[140] = {
    0x64, 0x30, 0x64, 0x31, 0x64, 0x32, 0x64, 0x61, 0x64, 0x63, 0x64, 0x65,
    0x64, 0x69, 0x64, 0x6f, 0x64, 0x73, 0x64, 0x74, 0x64, 0x20, 0x64, 0x25,
    0x64, 0x2d, 0x64, 0x2e, 0x64, 0x2f, 0x64, 0x33, 0x64, 0x34, 0x64, 0x35,
    0x64, 0x36, 0x64, 0x37, 0x64, 0x38, 0x64, 0x39, 0x64, 0x3d, 0x64, 0x41,
    0x64, 0x5f, 0x64, 0x62, 0x64, 0x64, 0x66, 0x64, 0x67, 0x64, 0x68, 0x64,
    0x6c, 0x64, 0x6d, 0x64, 0x6e, 0x64, 0x70, 0x64, 0x72, 0x64, 0x75, 0x66,
    0x30, 0x66, 0x31, 0x66, 0x32, 0x66, 0x61, 0x66, 0x63, 0x66, 0x65, 0x66,
    0x69, 0x66, 0x6f, 0x66, 0x73, 0x66, 0x74, 0x66, 0x20, 0x66, 0x25, 0x66,
    0x2d, 0x66, 0x2e, 0x66, 0x2f, 0x66, 0x33, 0x66, 0x34, 0x66, 0x35, 0x66,
    0x36, 0x66, 0x37, 0x66, 0x38, 0x66, 0x39, 0x66, 0x3d, 0x66, 0x41, 0x66,
    0x5f, 0x66, 0x62, 0x66, 0x66, 0x67, 0x66, 0x68, 0x66, 0x6c, 0x66, 0x6d,
    0x66, 0x6e, 0x66, 0x70, 0x66, 0x72, 0x66, 0x75};
const uint16_t HuffDecoderCommon::table1_18_inner_[74] = {
    0x000b, 0x010b, 0x020b, 0x030b, 0x040b, 0x050b, 0x060b, 0x070b, 0x080b,
    0x090b, 0x0a0c, 0x0b0c, 0x0c0c, 0x0d0c, 0x0e0c, 0x0f0c, 0x100c, 0x110c,
    0x120c, 0x130c, 0x140c, 0x150c, 0x160c, 0x170c, 0x180c, 0x190c, 0x1a0c,
    0x1a8c, 0x1b8c, 0x1c8c, 0x1d8c, 0x1e8c, 0x1f8c, 0x208c, 0x218c, 0x228c,
    0x0016, 0x238b, 0x248b, 0x258b, 0x268b, 0x278b, 0x288b, 0x298b, 0x2a8b,
    0x2b8b, 0x2c8b, 0x2d8c, 0x2e8c, 0x2f8c, 0x308c, 0x318c, 0x328c, 0x338c,
    0x348c, 0x358c, 0x368c, 0x378c, 0x388c, 0x398c, 0x3a8c, 0x3b8c, 0x3c8c,
    0x1b0c, 0x3d8c, 0x3e0c, 0x3f0c, 0x400c, 0x410c, 0x420c, 0x430c, 0x440c,
    0x450c, 0x1b16};
const uint8_t HuffDecoderCommon::table1_19_emit_[140] = {
    0x67, 0x30, 0x67, 0x31, 0x67, 0x32, 0x67, 0x61, 0x67, 0x63, 0x67, 0x65,
    0x67, 0x69, 0x67, 0x6f, 0x67, 0x73, 0x67, 0x74, 0x67, 0x20, 0x67, 0x25,
    0x67, 0x2d, 0x67, 0x2e, 0x67, 0x2f, 0x67, 0x33, 0x67, 0x34, 0x67, 0x35,
    0x67, 0x36, 0x67, 0x37, 0x67, 0x38, 0x67, 0x39, 0x67, 0x3d, 0x67, 0x41,
    0x67, 0x5f, 0x67, 0x62, 0x67, 0x64, 0x67, 0x66, 0x67, 0x67, 0x68, 0x67,
    0x6c, 0x67, 0x6d, 0x67, 0x6e, 0x67, 0x70, 0x67, 0x72, 0x67, 0x75, 0x68,
    0x30, 0x68, 0x31, 0x68, 0x32, 0x68, 0x61, 0x68, 0x63, 0x68, 0x65, 0x68,
    0x69, 0x68, 0x6f, 0x68, 0x73, 0x68, 0x74, 0x68, 0x20, 0x68, 0x25, 0x68,
    0x2d, 0x68, 0x2e, 0x68, 0x2f, 0x68, 0x33, 0x68, 0x34, 0x68, 0x35, 0x68,
    0x36, 0x68, 0x37, 0x68, 0x38, 0x68, 0x39, 0x68, 0x3d, 0x68, 0x41, 0x68,
    0x5f, 0x68, 0x62, 0x68, 0x64, 0x68, 0x66, 0x68, 0x68, 0x6c, 0x68, 0x6d,
    0x68, 0x6e, 0x68, 0x70, 0x68, 0x72, 0x68, 0x75};
const uint16_t HuffDecoderCommon::table1_19_inner_[74] = {
    0x000b, 0x010b, 0x020b, 0x030b, 0x040b, 0x050b, 0x060b, 0x070b, 0x080b,
    0x090b, 0x0a0c, 0x0b0c, 0x0c0c, 0x0d0c, 0x0e0c, 0x0f0c, 0x100c, 0x110c,
    0x120c, 0x130c, 0x140c, 0x150c, 0x160c, 0x170c, 0x180c, 0x190c, 0x1a0c,
    0x1b0c, 0x1c0c, 0x1c8c, 0x1d8c, 0x1e8c, 0x1f8c, 0x208c, 0x218c, 0x228c,
    0x0016, 0x238b, 0x248b, 0x258b, 0x268b, 0x278b, 0x288b, 0x298b, 0x2a8b,
    0x2b8b, 0x2c8b, 0x2d8c, 0x2e8c, 0x2f8c, 0x308c, 0x318c, 0x328c, 0x338c,
    0x348c, 0x358c, 0x368c, 0x378c, 0x388c, 0x398c, 0x3a8c, 0x3b8c, 0x3c8c,
    0x3d8c, 0x3e8c, 0x1d0c, 0x3f8c, 0x400c, 0x410c, 0x420c, 0x430c, 0x440c,
    0x450c, 0x1d16};
const uint8_t HuffDecoderCommon::table1_20_emit_[140] = {
    0x6c, 0x30, 0x6c, 0x31, 0x6c, 0x32, 0x6c, 0x61, 0x6c, 0x63, 0x6c, 0x65,
    0x6c, 0x69, 0x6c, 0x6f, 0x6c, 0x73, 0x6c, 0x74, 0x6c, 0x20, 0x6c, 0x25,
    0x6c, 0x2d, 0x6c, 0x2e, 0x6c, 0x2f, 0x6c, 0x33, 0x6c, 0x34, 0x6c, 0x35,
    0x6c, 0x36, 0x6c, 0x37, 0x6c, 0x38, 0x6c, 0x39, 0x6c, 0x3d, 0x6c, 0x41,
    0x6c, 0x5f, 0x6c, 0x62, 0x6c, 0x64, 0x6c, 0x66, 0x6c, 0x67, 0x6c, 0x68,
    0x6c, 0x6c, 0x6d, 0x6c, 0x6e, 0x6c, 0x70, 0x6c, 0x72, 0x6c, 0x75, 0x6d,
    0x30, 0x6d, 0x31, 0x6d, 0x32, 0x6d, 0x61, 0x6d, 0x63, 0x6d, 0x65, 0x6d,
    0x69, 0x6d, 0x6f, 0x6d, 0x73, 0x6d, 0x74, 0x6d, 0x20, 0x6d, 0x25, 0x6d,
    0x2d, 0x6d, 0x2e, 0x6d, 0x2f, 0x6d, 0x33, 0x6d, 0x34, 0x6d, 0x35, 0x6d,
    0x36, 0x6d, 0x37, 0x6d, 0x38, 0x6d, 0x39, 0x6d, 0x3d, 0x6d, 0x41, 0x6d,
    0x5f, 0x6d, 0x62, 0x6d, 0x64, 0x6d, 0x66, 0x6d, 0x67, 0x6d, 0x68, 0x6d,
    0x6d, 0x6e, 0x6d, 0x70, 0x6d, 0x72, 0x6d, 0x75};
const uint16_t HuffDecoderCommon::table1_20_inner_[74] = {
    0x000b, 0x010b, 0x020b, 0x030b, 0x040b, 0x050b, 0x060b, 0x070b, 0x080b,
    0x090b, 0x0a0c, 0x0b0c, 0x0c0c, 0x0d0c, 0x0e0c, 0x0f0c, 0x100c, 0x110c,
    0x120c, 0x130c, 0x140c, 0x150c, 0x160c, 0x170c, 0x180c, 0x190c, 0x1a0c,
    0x1b0c, 0x1c0c, 0x1d0c, 0x1e0c, 0x1e8c, 0x1f8c, 0x208c, 0x218c, 0x228c,
    0x0016, 0x238b, 0x248b, 0x258b, 0x268b, 0x278b, 0x288b, 0x298b, 0x2a8b,
    0x2b8b, 0x2c8b, 0x2d8c, 0x2e8c, 0x2f8c, 0x308c, 0x318c, 0x328c, 0x338c,
    0x348c, 0x358c, 0x368c, 0x378c, 0x388c, 0x398c, 0x3a8c, 0x3b8c, 0x3c8c,
    0x3d8c, 0x3e8c, 0x3f8c, 0x408c, 0x1f0c, 0x418c, 0x420c, 0x430c, 0x440c,
    0x450c, 0x1f16};
const uint8_t HuffDecoderCommon::table1_21_emit_[140] = {
    0x6e, 0x30, 0x6e, 0x31, 0x6e, 0x32, 0x6e, 0x61, 0x6e, 0x63, 0x6e, 0x65,
    0x6e, 0x69, 0x6e, 0x6f, 0x6e, 0x73, 0x6e, 0x74, 0x6e, 0x20, 0x6e, 0x25,
    0x6e, 0x2d, 0x6e, 0x2e, 0x6e, 0x2f, 0x6e, 0x33, 0x6e, 0x34, 0x6e, 0x35,
    0x6e, 0x36, 0x6e, 0x37, 0x6e, 0x38, 0x6e, 0x39, 0x6e, 0x3d, 0x6e, 0x41,
    0x6e, 0x5f, 0x6e, 0x62, 0x6e, 0x64, 0x6e, 0x66, 0x6e, 0x67, 0x6e, 0x68,
    0x6e, 0x6c, 0x6e, 0x6d, 0x6e, 0x6e, 0x70, 0x6e, 0x72, 0x6e, 0x75, 0x70,
    0x30, 0x70, 0x31, 0x70, 0x32, 0x70, 0x61, 0x70, 0x63, 0x70, 0x65, 0x70,
    0x69, 0x70, 0x6f, 0x70, 0x73, 0x70, 0x74, 0x70, 0x20, 0x70, 0x25, 0x70,
    0x2d, 0x70, 0x2e, 0x70, 0x2f, 0x70, 0x33, 0x70, 0x34, 0x70, 0x35, 0x70,
    0x36, 0x70, 0x37, 0x70, 0x38, 0x70, 0x39, 0x70, 0x3d, 0x70, 0x41, 0x70,
    0x5f, 0x70, 0x62, 0x70, 0x64, 0x70, 0x66, 0x70, 0x67, 0x70, 0x68, 0x70,
    0x6c, 0x70, 0x6d, 0x70, 0x70, 0x72, 0x70, 0x75};
const uint16_t HuffDecoderCommon::table1_21_inner_[74] = {
    0x000b, 0x010b, 0x020b, 0x030b, 0x040b, 0x050b, 0x060b, 0x070b, 0x080b,
    0x090b, 0x0a0c, 0x0b0c, 0x0c0c, 0x0d0c, 0x0e0c, 0x0f0c, 0x100c, 0x110c,
    0x120c, 0x130c, 0x140c, 0x150c, 0x160c, 0x170c, 0x180c, 0x190c, 0x1a0c,
    0x1b0c, 0x1c0c, 0x1d0c, 0x1e0c, 0x1f0c, 0x200c, 0x208c, 0x218c, 0x228c,
    0x0016, 0x238b, 0x248b, 0x258b, 0x268b, 0x278b, 0x288b, 0x298b, 0x2a8b,
    0x2b8b, 0x2c8b, 0x2d8c, 0x2e8c, 0x2f8c, 0x308c, 0x318c, 0x328c, 0x338c,
    0x348c, 0x358c, 0x368c, 0x378c, 0x388c, 0x398c, 0x3a8c, 0x3b8c, 0x3c8c,
    0x3d8c, 0x3e8c, 0x3f8c, 0x408c, 0x418c, 0x428c, 0x210c, 0x438c, 0x440c,
    0x450c, 0x2116};
const uint8_t HuffDecoderCommon::table1_22_emit_[142] = {
    0x72, 0x30, 0x72, 0x31, 0x72, 0x32, 0x72, 0x61, 0x72, 0x63, 0x72, 0x65,
    0x72, 0x69, 0x72, 0x6f, 0x72, 0x73, 0x72, 0x74, 0x72, 0x20, 0x72, 0x25,
    0x72, 0x2d, 0x72, 0x2e, 0x72, 0x2f, 0x72, 0x33, 0x72, 0x34, 0x72, 0x35,
    0x72, 0x36, 0x72, 0x37, 0x72, 0x38, 0x72, 0x39, 0x72, 0x3d, 0x72, 0x41,
    0x72, 0x5f, 0x72, 0x62, 0x72, 0x64, 0x72, 0x66, 0x72, 0x67, 0x72, 0x68,
    0x72, 0x6c, 0x72, 0x6d, 0x72, 0x6e, 0x72, 0x70, 0x72, 0x72, 0x75, 0x30,
    0x75, 0x31, 0x75, 0x32, 0x75, 0x61, 0x75, 0x63, 0x75, 0x65, 0x75, 0x69,
    0x75, 0x6f, 0x75, 0x73, 0x75, 0x74, 0x75, 0x20, 0x75, 0x25, 0x75, 0x2d,
    0x75, 0x2e, 0x75, 0x2f, 0x75, 0x33, 0x75, 0x34, 0x75, 0x35, 0x75, 0x36,
    0x75, 0x37, 0x75, 0x38, 0x75, 0x39, 0x75, 0x3d, 0x75, 0x41, 0x75, 0x5f,
    0x75, 0x62, 0x75, 0x64, 0x75, 0x66, 0x75, 0x67, 0x75, 0x68, 0x75, 0x6c,
    0x75, 0x6d, 0x75, 0x6e, 0x75, 0x70, 0x75, 0x72, 0x75, 0x75};
const uint16_t HuffDecoderCommon::table1_22_inner_[74] = {
    0x000b, 0x010b, 0x020b, 0x030b, 0x040b, 0x050b, 0x060b, 0x070b, 0x080b,
    0x090b, 0x0a0c, 0x0b0c, 0x0c0c, 0x0d0c, 0x0e0c, 0x0f0c, 0x100c, 0x110c,
    0x120c, 0x130c, 0x140c, 0x150c, 0x160c, 0x170c, 0x180c, 0x190c, 0x1a0c,
    0x1b0c, 0x1c0c, 0x1d0c, 0x1e0c, 0x1f0c, 0x200c, 0x210c, 0x220c, 0x228c,
    0x0016, 0x230b, 0x240b, 0x250b, 0x260b, 0x270b, 0x280b, 0x290b, 0x2a0b,
    0x2b0b, 0x2c0b, 0x2d0c, 0x2e0c, 0x2f0c, 0x300c, 0x310c, 0x320c, 0x330c,
    0x340c, 0x350c, 0x360c, 0x370c, 0x380c, 0x390c, 0x3a0c, 0x3b0c, 0x3c0c,
    0x3d0c, 0x3e0c, 0x3f0c, 0x400c, 0x410c, 0x420c, 0x430c, 0x440c, 0x450c,
    0x460c, 0x2316};
const uint8_t HuffDecoderCommon::table1_23_emit_[80] = {
    0x3a, 0x30, 0x3a, 0x31, 0x3a, 0x32, 0x3a, 0x61, 0x3a, 0x63, 0x3a, 0x65,
    0x3a, 0x69, 0x3a, 0x6f, 0x3a, 0x73, 0x3a, 0x74, 0x42, 0x30, 0x42, 0x31,
    0x42, 0x32, 0x42, 0x61, 0x42, 0x63, 0x42, 0x65, 0x42, 0x69, 0x42, 0x6f,
    0x42, 0x73, 0x42, 0x74, 0x43, 0x30, 0x43, 0x31, 0x43, 0x32, 0x43, 0x61,
    0x43, 0x63, 0x43, 0x65, 0x43, 0x69, 0x43, 0x6f, 0x43, 0x73, 0x43, 0x74,
    0x44, 0x30, 0x44, 0x31, 0x44, 0x32, 0x44, 0x61, 0x44, 0x63, 0x44, 0x65,
    0x44, 0x69, 0x44, 0x6f, 0x44, 0x73, 0x44, 0x74};
const uint16_t HuffDecoderCommon::table1_23_inner_[44] = {
    0x000c, 0x010c, 0x020c, 0x030c, 0x040c, 0x050c, 0x060c, 0x070c, 0x080c,
    0x090c, 0x0017, 0x0a0c, 0x0b0c, 0x0c0c, 0x0d0c, 0x0e0c, 0x0f0c, 0x100c,
    0x110c, 0x120c, 0x130c, 0x0a17, 0x140c, 0x150c, 0x160c, 0x170c, 0x180c,
    0x190c, 0x1a0c, 0x1b0c, 0x1c0c, 0x1d0c, 0x1417, 0x1e0c, 0x1f0c, 0x200c,
    0x210c, 0x220c, 0x230c, 0x240c, 0x250c, 0x260c, 0x270c, 0x1e17};
const uint8_t HuffDecoderCommon::table1_23_outer_[128] = {
    0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 12, 13, 14, 15, 16,
    17, 18, 19, 20, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21,
    21, 21, 21, 21, 21, 21, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 32,
    32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
    32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 43, 43, 43, 43, 43, 43, 43,
    43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43};
const uint8_t HuffDecoderCommon::table1_24_emit_[80] = {
    0x45, 0x30, 0x45, 0x31, 0x45, 0x32, 0x45, 0x61, 0x45, 0x63, 0x45, 0x65,
    0x45, 0x69, 0x45, 0x6f, 0x45, 0x73, 0x45, 0x74, 0x46, 0x30, 0x46, 0x31,
    0x46, 0x32, 0x46, 0x61, 0x46, 0x63, 0x46, 0x65, 0x46, 0x69, 0x46, 0x6f,
    0x46, 0x73, 0x46, 0x74, 0x47, 0x30, 0x47, 0x31, 0x47, 0x32, 0x47, 0x61,
    0x47, 0x63, 0x47, 0x65, 0x47, 0x69, 0x47, 0x6f, 0x47, 0x73, 0x47, 0x74,
    0x48, 0x30, 0x48, 0x31, 0x48, 0x32, 0x48, 0x61, 0x48, 0x63, 0x48, 0x65,
    0x48, 0x69, 0x48, 0x6f, 0x48, 0x73, 0x48, 0x74};
const uint8_t HuffDecoderCommon::table1_25_emit_[80] = {
    0x49, 0x30, 0x49, 0x31, 0x49, 0x32, 0x49, 0x61, 0x49, 0x63, 0x49, 0x65,
    0x49, 0x69, 0x49, 0x6f, 0x49, 0x73, 0x49, 0x74, 0x4a, 0x30, 0x4a, 0x31,
    0x4a, 0x32, 0x4a, 0x61, 0x4a, 0x63, 0x4a, 0x65, 0x4a, 0x69, 0x4a, 0x6f,
    0x4a, 0x73, 0x4a, 0x74, 0x4b, 0x30, 0x4b, 0x31, 0x4b, 0x32, 0x4b, 0x61,
    0x4b, 0x63, 0x4b, 0x65, 0x4b, 0x69, 0x4b, 0x6f, 0x4b, 0x73, 0x4b, 0x74,
    0x4c, 0x30, 0x4c, 0x31, 0x4c, 0x32, 0x4c, 0x61, 0x4c, 0x63, 0x4c, 0x65,
    0x4c, 0x69, 0x4c, 0x6f, 0x4c, 0x73, 0x4c, 0x74};
const uint8_t HuffDecoderCommon::table1_26_emit_[80] = {
    0x4d, 0x30, 0x4d, 0x31, 0x4d, 0x32, 0x4d, 0x61, 0x4d, 0x63, 0x4d, 0x65,
    0x4d, 0x69, 0x4d, 0x6f, 0x4d, 0x73, 0x4d, 0x74, 0x4e, 0x30, 0x4e, 0x31,
    0x4e, 0x32, 0x4e, 0x61, 0x4e, 0x63, 0x4e, 0x65, 0x4e, 0x69, 0x4e, 0x6f,
    0x4e, 0x73, 0x4e, 0x74, 0x4f, 0x30, 0x4f, 0x31, 0x4f, 0x32, 0x4f, 0x61,
    0x4f, 0x63, 0x4f, 0x65, 0x4f, 0x69, 0x4f, 0x6f, 0x4f, 0x73, 0x4f, 0x74,
    0x50, 0x30, 0x50, 0x31, 0x50, 0x32, 0x50, 0x61, 0x50, 0x63, 0x50, 0x65,
    0x50, 0x69, 0x50, 0x6f, 0x50, 0x73, 0x50, 0x74};
const uint8_t HuffDecoderCommon::table1_27_emit_[80] = {
    0x51, 0x30, 0x51, 0x31, 0x51, 0x32, 0x51, 0x61, 0x51, 0x63, 0x51, 0x65,
    0x51, 0x69, 0x51, 0x6f, 0x51, 0x73, 0x51, 0x74, 0x52, 0x30, 0x52, 0x31,
    0x52, 0x32, 0x52, 0x61, 0x52, 0x63, 0x52, 0x65, 0x52, 0x69, 0x52, 0x6f,
    0x52, 0x73, 0x52, 0x74, 0x53, 0x30, 0x53, 0x31, 0x53, 0x32, 0x53, 0x61,
    0x53, 0x63, 0x53, 0x65, 0x53, 0x69, 0x53, 0x6f, 0x53, 0x73, 0x53, 0x74,
    0x54, 0x30, 0x54, 0x31, 0x54, 0x32, 0x54, 0x61, 0x54, 0x63, 0x54, 0x65,
    0x54, 0x69, 0x54, 0x6f, 0x54, 0x73, 0x54, 0x74};
const uint8_t HuffDecoderCommon::table1_28_emit_[80] = {
    0x55, 0x30, 0x55, 0x31, 0x55, 0x32, 0x55, 0x61, 0x55, 0x63, 0x55, 0x65,
    0x55, 0x69, 0x55, 0x6f, 0x55, 0x73, 0x55, 0x74, 0x56, 0x30, 0x56, 0x31,
    0x56, 0x32, 0x56, 0x61, 0x56, 0x63, 0x56, 0x65, 0x56, 0x69, 0x56, 0x6f,
    0x56, 0x73, 0x56, 0x74, 0x57, 0x30, 0x57, 0x31, 0x57, 0x32, 0x57, 0x61,
    0x57, 0x63, 0x57, 0x65, 0x57, 0x69, 0x57, 0x6f, 0x57, 0x73, 0x57, 0x74,
    0x59, 0x30, 0x59, 0x31, 0x59, 0x32, 0x59, 0x61, 0x59, 0x63, 0x59, 0x65,
    0x59, 0x69, 0x59, 0x6f, 0x59, 0x73, 0x59, 0x74};
const uint8_t HuffDecoderCommon::table1_29_emit_[80] = {
    0x6a, 0x30, 0x6a, 0x31, 0x6a, 0x32, 0x6a, 0x61, 0x6a, 0x63, 0x6a, 0x65,
    0x6a, 0x69, 0x6a, 0x6f, 0x6a, 0x73, 0x6a, 0x74, 0x6b, 0x30, 0x6b, 0x31,
    0x6b, 0x32, 0x6b, 0x61, 0x6b, 0x63, 0x6b, 0x65, 0x6b, 0x69, 0x6b, 0x6f,
    0x6b, 0x73, 0x6b, 0x74, 0x71, 0x30, 0x71, 0x31, 0x71, 0x32, 0x71, 0x61,
    0x71, 0x63, 0x71, 0x65, 0x71, 0x69, 0x71, 0x6f, 0x71, 0x73, 0x71, 0x74,
    0x76, 0x30, 0x76, 0x31, 0x76, 0x32, 0x76, 0x61, 0x76, 0x63, 0x76, 0x65,
    0x76, 0x69, 0x76, 0x6f, 0x76, 0x73, 0x76, 0x74};
const uint8_t HuffDecoderCommon::table1_30_emit_[80] = {
    0x77, 0x30, 0x77, 0x31, 0x77, 0x32, 0x77, 0x61, 0x77, 0x63, 0x77, 0x65,
    0x77, 0x69, 0x77, 0x6f, 0x77, 0x73, 0x77, 0x74, 0x78, 0x30, 0x78, 0x31,
    0x78, 0x32, 0x78, 0x61, 0x78, 0x63, 0x78, 0x65, 0x78, 0x69, 0x78, 0x6f,
    0x78, 0x73, 0x78, 0x74, 0x79, 0x30, 0x79, 0x31, 0x79, 0x32, 0x79, 0x61,
    0x79, 0x63, 0x79, 0x65, 0x79, 0x69, 0x79, 0x6f, 0x79, 0x73, 0x79, 0x74,
    0x7a, 0x30, 0x7a, 0x31, 0x7a, 0x32, 0x7a, 0x61, 0x7a, 0x63, 0x7a, 0x65,
    0x7a, 0x69, 0x7a, 0x6f, 0x7a, 0x73, 0x7a, 0x74};
const uint8_t HuffDecoderCommon::table1_31_emit_[16] = {
    0x26, 0x2a, 0x2c, 0x3b, 0x58, 0x5a, 0x21, 0x22,
    0x28, 0x29, 0x3f, 0x27, 0x2b, 0x7c, 0x23, 0x3e};
const uint16_t HuffDecoderCommon::table1_31_inner_[20] = {
    0x0018, 0x0098, 0x0118, 0x0198, 0x0218, 0x0298, 0x031a,
    0x039a, 0x041a, 0x049a, 0x051a, 0x059b, 0x061b, 0x069b,
    0x071c, 0x079c, 0x002c, 0x003c, 0x004c, 0x005c};
const uint8_t HuffDecoderCommon::table1_31_outer_[128] = {
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0, 0, 1, 1,  1,
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  2, 2, 2, 2, 2,  2,
    2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  3,  3,  3,  3, 3, 3, 3, 3,  3,
    3,  3,  3,  3,  3,  3,  3,  4,  4,  4,  4,  4,  4,  4, 4, 4, 4, 4,  4,
    4,  4,  4,  4,  5,  5,  5,  5,  5,  5,  5,  5,  5,  5, 5, 5, 5, 5,  5,
    5,  6,  6,  6,  6,  7,  7,  7,  7,  8,  8,  8,  8,  9, 9, 9, 9, 10, 10,
    10, 10, 11, 11, 12, 12, 13, 13, 14, 15, 16, 17, 18, 19};
const uint8_t* const HuffDecoderCommon::table1_emit_[32] = {
    table1_0_emit_,  table1_1_emit_,  table1_2_emit_,  table1_3_emit_,
    table1_4_emit_,  table1_5_emit_,  table1_6_emit_,  table1_7_emit_,
    table1_8_emit_,  table1_9_emit_,  table1_10_emit_, table1_11_emit_,
    table1_12_emit_, table1_13_emit_, table1_14_emit_, table1_15_emit_,
    table1_16_emit_, table1_17_emit_, table1_18_emit_, table1_19_emit_,
    table1_20_emit_, table1_21_emit_, table1_22_emit_, table1_23_emit_,
    table1_24_emit_, table1_25_emit_, table1_26_emit_, table1_27_emit_,
    table1_28_emit_, table1_29_emit_, table1_30_emit_, table1_31_emit_,
};
const uint16_t* const HuffDecoderCommon::table1_inner_[32] = {
    table1_0_inner_,  table1_1_inner_,  table1_2_inner_,  table1_3_inner_,
    table1_4_inner_,  table1_5_inner_,  table1_6_inner_,  table1_7_inner_,
    table1_8_inner_,  table1_9_inner_,  table1_10_inner_, table1_11_inner_,
    table1_12_inner_, table1_13_inner_, table1_14_inner_, table1_15_inner_,
    table1_16_inner_, table1_17_inner_, table1_18_inner_, table1_19_inner_,
    table1_20_inner_, table1_21_inner_, table1_22_inner_, table1_23_inner_,
    table1_23_inner_, table1_23_inner_, table1_23_inner_, table1_23_inner_,
    table1_23_inner_, table1_23_inner_, table1_23_inner_, table1_31_inner_,
};
const uint8_t* const HuffDecoderCommon::table1_outer_[32] = {
    table1_0_outer_,  table1_0_outer_,  table1_0_outer_,  table1_0_outer_,
    table1_0_outer_,  table1_0_outer_,  table1_0_outer_,  table1_0_outer_,
    table1_0_outer_,  table1_0_outer_,  table1_10_outer_, table1_10_outer_,
    table1_10_outer_, table1_10_outer_, table1_10_outer_, table1_10_outer_,
    table1_10_outer_, table1_10_outer_, table1_10_outer_, table1_10_outer_,
    table1_10_outer_, table1_10_outer_, table1_10_outer_, table1_23_outer_,
    table1_23_outer_, table1_23_outer_, table1_23_outer_, table1_23_outer_,
    table1_23_outer_, table1_23_outer_, table1_23_outer_, table1_31_outer_,
};
const uint8_t HuffDecoderCommon::table14_0_emit_[5] = {0x5e, 0x7d, 0x3c, 0x60,
                                                       0x7b};
const uint8_t HuffDecoderCommon::table14_0_inner_[7] = {0x00, 0x01, 0x05, 0x09,
                                                        0x0d, 0x11, 0x02};
const uint8_t HuffDecoderCommon::table14_0_outer_[8] = {0, 1, 0, 2, 3, 4, 5, 6};
const uint8_t HuffDecoderCommon::table15_0_outer_[16] = {
    0, 0, 0, 1, 0, 0, 0, 2, 0, 3, 0, 4, 0, 5, 0, 6};
const uint8_t HuffDecoderCommon::table16_0_ops_[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00,
    0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x02};
const uint16_t HuffDecoderCommon::table12_0_inner_[13] = {
    0x0002, 0x0082, 0x0103, 0x0183, 0x0203, 0x000e, 0x0016,
    0x001e, 0x0026, 0x002e, 0x0036, 0x003e, 0x0046};
const uint8_t HuffDecoderCommon::table12_0_outer_[64] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1,  1,  1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2,  3,  3, 3, 3,
    3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12};
const uint8_t HuffDecoderCommon::table19_0_emit_[8] = {0xb0, 0xb1, 0xb3, 0xd1,
                                                       0xd8, 0xd9, 0xe3, 0xe5};
const uint8_t HuffDecoderCommon::table19_0_inner_[8] = {0x03, 0x07, 0x0b, 0x0f,
                                                        0x13, 0x17, 0x1b, 0x1f};
const uint8_t HuffDecoderCommon::table22_0_emit_[15] = {
    0xe6, 0x81, 0x84, 0x85, 0x86, 0x88, 0x92, 0x9a,
    0x9c, 0xa0, 0xa3, 0xa4, 0xa9, 0xaa, 0xad};
const uint8_t HuffDecoderCommon::table22_0_inner_[15] = {
    0x03, 0x0c, 0x14, 0x1c, 0x24, 0x2c, 0x34, 0x3c,
    0x44, 0x4c, 0x54, 0x5c, 0x64, 0x6c, 0x74};
const uint8_t HuffDecoderCommon::table24_0_emit_[6] = {0xe0, 0xe2, 0x99,
                                                       0xa1, 0xa7, 0xac};
const uint8_t HuffDecoderCommon::table24_0_inner_[6] = {0x02, 0x06, 0x0b,
                                                        0x0f, 0x13, 0x17};
const uint8_t HuffDecoderCommon::table27_0_emit_[12] = {
    0xb2, 0xb5, 0xb9, 0xba, 0xbb, 0xbd, 0xbe, 0xc4, 0xc6, 0xe4, 0xe8, 0xe9};
const uint8_t HuffDecoderCommon::table27_0_inner_[13] = {
    0x00, 0x02, 0x04, 0x06, 0x08, 0x0a, 0x0c,
    0x0e, 0x10, 0x12, 0x14, 0x16, 0x01};
const uint8_t HuffDecoderCommon::table26_0_emit_[20] = {
    0xb2, 0xb5, 0xb9, 0xba, 0xbb, 0xbd, 0xbe, 0xc4, 0xc6, 0xe4,
    0xe8, 0xe9, 0x01, 0x87, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8f};
const uint8_t HuffDecoderCommon::table26_0_ops_[32] = {
    0x04, 0x04, 0x0c, 0x0c, 0x14, 0x14, 0x1c, 0x1c, 0x24, 0x24, 0x2c,
    0x2c, 0x34, 0x34, 0x3c, 0x3c, 0x44, 0x44, 0x4c, 0x4c, 0x54, 0x54,
    0x5c, 0x5c, 0x65, 0x6d, 0x75, 0x7d, 0x85, 0x8d, 0x95, 0x9d};
const uint8_t HuffDecoderCommon::table29_0_emit_[21] = {
    0x93, 0x95, 0x96, 0x97, 0x98, 0x9b, 0x9d, 0x9e, 0xa5, 0xa6, 0xa8,
    0xae, 0xaf, 0xb4, 0xb6, 0xb7, 0xbc, 0xbf, 0xc5, 0xe7, 0xef};
const uint8_t HuffDecoderCommon::table29_0_ops_[32] = {
    0x00, 0x04, 0x08, 0x0c, 0x10, 0x14, 0x18, 0x1c, 0x20, 0x24, 0x28,
    0x2c, 0x30, 0x34, 0x38, 0x3c, 0x40, 0x44, 0x48, 0x4c, 0x50, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02};
const uint8_t HuffDecoderCommon::table30_0_emit_[33] = {
    0x93, 0x95, 0x96, 0x97, 0x98, 0x9b, 0x9d, 0x9e, 0xa5, 0xa6, 0xa8,
    0xae, 0xaf, 0xb4, 0xb6, 0xb7, 0xbc, 0xbf, 0xc5, 0xe7, 0xef, 0x09,
    0x8e, 0x90, 0x91, 0x94, 0x9f, 0xab, 0xce, 0xd7, 0xe1, 0xec, 0xed};
const uint8_t HuffDecoderCommon::table30_0_ops_[64] = {
    0x00, 0x01, 0x00, 0x05, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x11, 0x00,
    0x15, 0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x00, 0x29,
    0x00, 0x2d, 0x00, 0x31, 0x00, 0x35, 0x00, 0x39, 0x00, 0x3d, 0x00,
    0x41, 0x00, 0x45, 0x00, 0x49, 0x00, 0x4d, 0x00, 0x51, 0x55, 0x59,
    0x5d, 0x61, 0x65, 0x69, 0x6d, 0x71, 0x75, 0x79, 0x7d, 0x81, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table31_0_emit_[37] = {
    0x93, 0x95, 0x96, 0x97, 0x98, 0x9b, 0x9d, 0x9e, 0xa5, 0xa6,
    0xa8, 0xae, 0xaf, 0xb4, 0xb6, 0xb7, 0xbc, 0xbf, 0xc5, 0xe7,
    0xef, 0x09, 0x8e, 0x90, 0x91, 0x94, 0x9f, 0xab, 0xce, 0xd7,
    0xe1, 0xec, 0xed, 0xc7, 0xcf, 0xea, 0xeb};
const uint8_t HuffDecoderCommon::table31_0_ops_[128] = {
    0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x09,
    0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x15,
    0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x21,
    0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x29, 0x00, 0x00, 0x00, 0x2d,
    0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x35, 0x00, 0x00, 0x00, 0x39,
    0x00, 0x00, 0x00, 0x3d, 0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00, 0x45,
    0x00, 0x00, 0x00, 0x49, 0x00, 0x00, 0x00, 0x4d, 0x00, 0x00, 0x00, 0x51,
    0x00, 0x55, 0x00, 0x59, 0x00, 0x5d, 0x00, 0x61, 0x00, 0x65, 0x00, 0x69,
    0x00, 0x6d, 0x00, 0x71, 0x00, 0x75, 0x00, 0x79, 0x00, 0x7d, 0x00, 0x81,
    0x85, 0x89, 0x8d, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table32_0_emit_[52] = {
    0x93, 0x95, 0x96, 0x97, 0x98, 0x9b, 0x9d, 0x9e, 0xa5, 0xa6, 0xa8,
    0xae, 0xaf, 0xb4, 0xb6, 0xb7, 0xbc, 0xbf, 0xc5, 0xe7, 0xef, 0x09,
    0x8e, 0x90, 0x91, 0x94, 0x9f, 0xab, 0xce, 0xd7, 0xe1, 0xec, 0xed,
    0xc7, 0xcf, 0xea, 0xeb, 0xc0, 0xc1, 0xc8, 0xc9, 0xca, 0xcd, 0xd2,
    0xd5, 0xda, 0xdb, 0xee, 0xf0, 0xf2, 0xf3, 0xff};
const uint8_t HuffDecoderCommon::table32_0_ops_[256] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x25, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2d,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x31, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3d, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x45,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x51,
    0x00, 0x00, 0x00, 0x55, 0x00, 0x00, 0x00, 0x59, 0x00, 0x00, 0x00, 0x5d,
    0x00, 0x00, 0x00, 0x61, 0x00, 0x00, 0x00, 0x65, 0x00, 0x00, 0x00, 0x69,
    0x00, 0x00, 0x00, 0x6d, 0x00, 0x00, 0x00, 0x71, 0x00, 0x00, 0x00, 0x75,
    0x00, 0x00, 0x00, 0x79, 0x00, 0x00, 0x00, 0x7d, 0x00, 0x00, 0x00, 0x81,
    0x00, 0x85, 0x00, 0x89, 0x00, 0x8d, 0x00, 0x91, 0x95, 0x99, 0x9d, 0xa1,
    0xa5, 0xa9, 0xad, 0xb1, 0xb5, 0xb9, 0xbd, 0xc1, 0xc5, 0xc9, 0xcd, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x02};
const uint8_t HuffDecoderCommon::table33_0_emit_[4] = {0x93, 0x95, 0x96, 0x97};
const uint8_t HuffDecoderCommon::table33_0_ops_[64] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d};
const uint8_t HuffDecoderCommon::table33_1_emit_[4] = {0x98, 0x9b, 0x9d, 0x9e};
const uint8_t HuffDecoderCommon::table33_2_emit_[4] = {0xa5, 0xa6, 0xa8, 0xae};
const uint8_t HuffDecoderCommon::table33_3_emit_[4] = {0xaf, 0xb4, 0xb6, 0xb7};
const uint8_t HuffDecoderCommon::table33_4_emit_[4] = {0xbc, 0xbf, 0xc5, 0xe7};
const uint8_t HuffDecoderCommon::table33_5_emit_[7] = {0xef, 0x09, 0x8e, 0x90,
                                                       0x91, 0x94, 0x9f};
const uint8_t HuffDecoderCommon::table33_5_ops_[64] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x19};
const uint8_t HuffDecoderCommon::table33_6_emit_[10] = {
    0xab, 0xce, 0xd7, 0xe1, 0xec, 0xed, 0xc7, 0xcf, 0xea, 0xeb};
const uint8_t HuffDecoderCommon::table33_6_ops_[64] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0d, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00,
    0x1d, 0x00, 0x00, 0x00, 0x21, 0x00, 0x00, 0x00, 0x25};
const uint8_t HuffDecoderCommon::table33_7_emit_[34] = {
    0xc0, 0xc1, 0xc8, 0xc9, 0xca, 0xcd, 0xd2, 0xd5, 0xda, 0xdb, 0xee, 0xf0,
    0xf2, 0xf3, 0xff, 0xcb, 0xcc, 0xd3, 0xd4, 0xd6, 0xdd, 0xde, 0xdf, 0xf1,
    0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe};
const uint8_t HuffDecoderCommon::table33_7_ops_[64] = {
    0x00, 0x01, 0x00, 0x05, 0x00, 0x09, 0x00, 0x0d, 0x00, 0x11, 0x00,
    0x15, 0x00, 0x19, 0x00, 0x1d, 0x00, 0x21, 0x00, 0x25, 0x00, 0x29,
    0x00, 0x2d, 0x00, 0x31, 0x00, 0x35, 0x00, 0x39, 0x3d, 0x41, 0x45,
    0x49, 0x4d, 0x51, 0x55, 0x59, 0x5d, 0x61, 0x65, 0x69, 0x6d, 0x71,
    0x75, 0x79, 0x7d, 0x81, 0x85, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02};
const uint8_t* const HuffDecoderCommon::table33_emit_[8] = {
    table33_0_emit_, table33_1_emit_, table33_2_emit_, table33_3_emit_,
    table33_4_emit_, table33_5_emit_, table33_6_emit_, table33_7_emit_,
};
const uint8_t* const HuffDecoderCommon::table33_ops_[8] = {
    table33_0_ops_, table33_0_ops_, table33_0_ops_, table33_0_ops_,
    table33_0_ops_, table33_5_ops_, table33_6_ops_, table33_7_ops_,
};
const uint8_t HuffDecoderCommon::table34_0_emit_[40] = {
    0x93, 0x30, 0x93, 0x31, 0x93, 0x32, 0x93, 0x61, 0x93, 0x63,
    0x93, 0x65, 0x93, 0x69, 0x93, 0x6f, 0x93, 0x73, 0x93, 0x74,
    0x95, 0x30, 0x95, 0x31, 0x95, 0x32, 0x95, 0x61, 0x95, 0x63,
    0x95, 0x65, 0x95, 0x69, 0x95, 0x6f, 0x95, 0x73, 0x95, 0x74};
const uint8_t HuffDecoderCommon::table34_0_ops_[64] = {
    0x00, 0x08, 0x10, 0x18, 0x20, 0x28, 0x30, 0x38, 0x40, 0x48, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x50,
    0x58, 0x60, 0x68, 0x70, 0x78, 0x80, 0x88, 0x90, 0x98, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x52};
const uint8_t HuffDecoderCommon::table34_1_emit_[40] = {
    0x96, 0x30, 0x96, 0x31, 0x96, 0x32, 0x96, 0x61, 0x96, 0x63,
    0x96, 0x65, 0x96, 0x69, 0x96, 0x6f, 0x96, 0x73, 0x96, 0x74,
    0x97, 0x30, 0x97, 0x31, 0x97, 0x32, 0x97, 0x61, 0x97, 0x63,
    0x97, 0x65, 0x97, 0x69, 0x97, 0x6f, 0x97, 0x73, 0x97, 0x74};
const uint8_t HuffDecoderCommon::table34_2_emit_[40] = {
    0x98, 0x30, 0x98, 0x31, 0x98, 0x32, 0x98, 0x61, 0x98, 0x63,
    0x98, 0x65, 0x98, 0x69, 0x98, 0x6f, 0x98, 0x73, 0x98, 0x74,
    0x9b, 0x30, 0x9b, 0x31, 0x9b, 0x32, 0x9b, 0x61, 0x9b, 0x63,
    0x9b, 0x65, 0x9b, 0x69, 0x9b, 0x6f, 0x9b, 0x73, 0x9b, 0x74};
const uint8_t HuffDecoderCommon::table34_3_emit_[40] = {
    0x9d, 0x30, 0x9d, 0x31, 0x9d, 0x32, 0x9d, 0x61, 0x9d, 0x63,
    0x9d, 0x65, 0x9d, 0x69, 0x9d, 0x6f, 0x9d, 0x73, 0x9d, 0x74,
    0x9e, 0x30, 0x9e, 0x31, 0x9e, 0x32, 0x9e, 0x61, 0x9e, 0x63,
    0x9e, 0x65, 0x9e, 0x69, 0x9e, 0x6f, 0x9e, 0x73, 0x9e, 0x74};
const uint8_t HuffDecoderCommon::table34_4_emit_[40] = {
    0xa5, 0x30, 0xa5, 0x31, 0xa5, 0x32, 0xa5, 0x61, 0xa5, 0x63,
    0xa5, 0x65, 0xa5, 0x69, 0xa5, 0x6f, 0xa5, 0x73, 0xa5, 0x74,
    0xa6, 0x30, 0xa6, 0x31, 0xa6, 0x32, 0xa6, 0x61, 0xa6, 0x63,
    0xa6, 0x65, 0xa6, 0x69, 0xa6, 0x6f, 0xa6, 0x73, 0xa6, 0x74};
const uint8_t HuffDecoderCommon::table34_5_emit_[40] = {
    0xa8, 0x30, 0xa8, 0x31, 0xa8, 0x32, 0xa8, 0x61, 0xa8, 0x63,
    0xa8, 0x65, 0xa8, 0x69, 0xa8, 0x6f, 0xa8, 0x73, 0xa8, 0x74,
    0xae, 0x30, 0xae, 0x31, 0xae, 0x32, 0xae, 0x61, 0xae, 0x63,
    0xae, 0x65, 0xae, 0x69, 0xae, 0x6f, 0xae, 0x73, 0xae, 0x74};
const uint8_t HuffDecoderCommon::table34_6_emit_[40] = {
    0xaf, 0x30, 0xaf, 0x31, 0xaf, 0x32, 0xaf, 0x61, 0xaf, 0x63,
    0xaf, 0x65, 0xaf, 0x69, 0xaf, 0x6f, 0xaf, 0x73, 0xaf, 0x74,
    0xb4, 0x30, 0xb4, 0x31, 0xb4, 0x32, 0xb4, 0x61, 0xb4, 0x63,
    0xb4, 0x65, 0xb4, 0x69, 0xb4, 0x6f, 0xb4, 0x73, 0xb4, 0x74};
const uint8_t HuffDecoderCommon::table34_7_emit_[40] = {
    0xb6, 0x30, 0xb6, 0x31, 0xb6, 0x32, 0xb6, 0x61, 0xb6, 0x63,
    0xb6, 0x65, 0xb6, 0x69, 0xb6, 0x6f, 0xb6, 0x73, 0xb6, 0x74,
    0xb7, 0x30, 0xb7, 0x31, 0xb7, 0x32, 0xb7, 0x61, 0xb7, 0x63,
    0xb7, 0x65, 0xb7, 0x69, 0xb7, 0x6f, 0xb7, 0x73, 0xb7, 0x74};
const uint8_t HuffDecoderCommon::table34_8_emit_[40] = {
    0xbc, 0x30, 0xbc, 0x31, 0xbc, 0x32, 0xbc, 0x61, 0xbc, 0x63,
    0xbc, 0x65, 0xbc, 0x69, 0xbc, 0x6f, 0xbc, 0x73, 0xbc, 0x74,
    0xbf, 0x30, 0xbf, 0x31, 0xbf, 0x32, 0xbf, 0x61, 0xbf, 0x63,
    0xbf, 0x65, 0xbf, 0x69, 0xbf, 0x6f, 0xbf, 0x73, 0xbf, 0x74};
const uint8_t HuffDecoderCommon::table34_9_emit_[40] = {
    0xc5, 0x30, 0xc5, 0x31, 0xc5, 0x32, 0xc5, 0x61, 0xc5, 0x63,
    0xc5, 0x65, 0xc5, 0x69, 0xc5, 0x6f, 0xc5, 0x73, 0xc5, 0x74,
    0xe7, 0x30, 0xe7, 0x31, 0xe7, 0x32, 0xe7, 0x61, 0xe7, 0x63,
    0xe7, 0x65, 0xe7, 0x69, 0xe7, 0x6f, 0xe7, 0x73, 0xe7, 0x74};
const uint8_t HuffDecoderCommon::table34_10_emit_[22] = {
    0xef, 0x30, 0xef, 0x31, 0xef, 0x32, 0xef, 0x61, 0xef, 0x63, 0xef,
    0x65, 0xef, 0x69, 0xef, 0x6f, 0xef, 0x73, 0xef, 0x74, 0x09, 0x8e};
const uint8_t HuffDecoderCommon::table34_10_ops_[64] = {
    0x00, 0x08, 0x10, 0x18, 0x20, 0x28, 0x30, 0x38, 0x40, 0x48, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x52, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x56};
const uint8_t HuffDecoderCommon::table34_11_emit_[4] = {0x90, 0x91, 0x94, 0x9f};
const uint8_t HuffDecoderCommon::table34_12_emit_[4] = {0xab, 0xce, 0xd7, 0xe1};
const uint8_t HuffDecoderCommon::table34_13_emit_[6] = {0xec, 0xed, 0xc7,
                                                        0xcf, 0xea, 0xeb};
const uint8_t HuffDecoderCommon::table34_14_emit_[17] = {
    0xc0, 0xc1, 0xc8, 0xc9, 0xca, 0xcd, 0xd2, 0xd5, 0xda,
    0xdb, 0xee, 0xf0, 0xf2, 0xf3, 0xff, 0xcb, 0xcc};
const uint8_t HuffDecoderCommon::table34_14_ops_[64] = {
    0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x06, 0x01, 0x01, 0x01,
    0x0a, 0x01, 0x01, 0x01, 0x0e, 0x01, 0x01, 0x01, 0x12, 0x01, 0x01,
    0x01, 0x16, 0x01, 0x01, 0x01, 0x1a, 0x01, 0x01, 0x01, 0x1e, 0x01,
    0x01, 0x01, 0x22, 0x01, 0x01, 0x01, 0x26, 0x01, 0x01, 0x01, 0x2a,
    0x01, 0x01, 0x01, 0x2e, 0x01, 0x01, 0x01, 0x32, 0x01, 0x01, 0x01,
    0x36, 0x01, 0x01, 0x01, 0x3a, 0x01, 0x3e, 0x01, 0x42};
const uint8_t HuffDecoderCommon::table34_15_emit_[46] = {
    0xd3, 0xd4, 0xd6, 0xdd, 0xde, 0xdf, 0xf1, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8,
    0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
    0x0b, 0x0c, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x17, 0x18,
    0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x7f, 0xdc, 0xf9};
const uint8_t HuffDecoderCommon::table34_15_ops_[64] = {
    0x01, 0x02, 0x01, 0x06, 0x01, 0x0a, 0x01, 0x0e, 0x01, 0x12, 0x01,
    0x16, 0x01, 0x1a, 0x01, 0x1e, 0x01, 0x22, 0x01, 0x26, 0x01, 0x2a,
    0x01, 0x2e, 0x01, 0x32, 0x01, 0x36, 0x01, 0x3a, 0x01, 0x3e, 0x01,
    0x42, 0x46, 0x4a, 0x4e, 0x52, 0x56, 0x5a, 0x5e, 0x62, 0x66, 0x6a,
    0x6e, 0x72, 0x76, 0x7a, 0x7e, 0x82, 0x86, 0x8a, 0x8e, 0x92, 0x96,
    0x9a, 0x9e, 0xa2, 0xa6, 0xaa, 0xae, 0xb2, 0xb6, 0x03};
const uint8_t* const HuffDecoderCommon::table34_emit_[16] = {
    table34_0_emit_,  table34_1_emit_,  table34_2_emit_,  table34_3_emit_,
    table34_4_emit_,  table34_5_emit_,  table34_6_emit_,  table34_7_emit_,
    table34_8_emit_,  table34_9_emit_,  table34_10_emit_, table34_11_emit_,
    table34_12_emit_, table34_13_emit_, table34_14_emit_, table34_15_emit_,
};
const uint8_t* const HuffDecoderCommon::table34_ops_[16] = {
    table34_0_ops_, table34_0_ops_, table34_0_ops_,  table34_0_ops_,
    table34_0_ops_, table34_0_ops_, table34_0_ops_,  table34_0_ops_,
    table34_0_ops_, table34_0_ops_, table34_10_ops_, table7_5_ops_,
    table7_5_ops_,  table7_11_ops_, table34_14_ops_, table34_15_ops_,
};
const uint8_t HuffDecoderCommon::table35_0_emit_[72] = {
    0x93, 0x30, 0x93, 0x31, 0x93, 0x32, 0x93, 0x61, 0x93, 0x63, 0x93, 0x65,
    0x93, 0x69, 0x93, 0x6f, 0x93, 0x73, 0x93, 0x74, 0x93, 0x20, 0x93, 0x25,
    0x93, 0x2d, 0x93, 0x2e, 0x93, 0x2f, 0x93, 0x33, 0x93, 0x34, 0x93, 0x35,
    0x93, 0x36, 0x93, 0x37, 0x93, 0x38, 0x93, 0x39, 0x93, 0x3d, 0x93, 0x41,
    0x93, 0x5f, 0x93, 0x62, 0x93, 0x64, 0x93, 0x66, 0x93, 0x67, 0x93, 0x68,
    0x93, 0x6c, 0x93, 0x6d, 0x93, 0x6e, 0x93, 0x70, 0x93, 0x72, 0x93, 0x75};
const uint16_t HuffDecoderCommon::table35_0_ops_[64] = {
    0x0000, 0x0001, 0x0000, 0x0009, 0x0000, 0x0011, 0x0000, 0x0019,
    0x0000, 0x0021, 0x0000, 0x0029, 0x0000, 0x0031, 0x0000, 0x0039,
    0x0000, 0x0041, 0x0000, 0x0049, 0x0051, 0x0059, 0x0061, 0x0069,
    0x0071, 0x0079, 0x0081, 0x0089, 0x0091, 0x0099, 0x00a1, 0x00a9,
    0x00b1, 0x00b9, 0x00c1, 0x00c9, 0x00d1, 0x00d9, 0x00e1, 0x00e9,
    0x00f1, 0x00f9, 0x0101, 0x0109, 0x0111, 0x0119, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002};
const uint8_t HuffDecoderCommon::table35_1_emit_[72] = {
    0x95, 0x30, 0x95, 0x31, 0x95, 0x32, 0x95, 0x61, 0x95, 0x63, 0x95, 0x65,
    0x95, 0x69, 0x95, 0x6f, 0x95, 0x73, 0x95, 0x74, 0x95, 0x20, 0x95, 0x25,
    0x95, 0x2d, 0x95, 0x2e, 0x95, 0x2f, 0x95, 0x33, 0x95, 0x34, 0x95, 0x35,
    0x95, 0x36, 0x95, 0x37, 0x95, 0x38, 0x95, 0x39, 0x95, 0x3d, 0x95, 0x41,
    0x95, 0x5f, 0x95, 0x62, 0x95, 0x64, 0x95, 0x66, 0x95, 0x67, 0x95, 0x68,
    0x95, 0x6c, 0x95, 0x6d, 0x95, 0x6e, 0x95, 0x70, 0x95, 0x72, 0x95, 0x75};
const uint8_t HuffDecoderCommon::table35_2_emit_[72] = {
    0x96, 0x30, 0x96, 0x31, 0x96, 0x32, 0x96, 0x61, 0x96, 0x63, 0x96, 0x65,
    0x96, 0x69, 0x96, 0x6f, 0x96, 0x73, 0x96, 0x74, 0x96, 0x20, 0x96, 0x25,
    0x96, 0x2d, 0x96, 0x2e, 0x96, 0x2f, 0x96, 0x33, 0x96, 0x34, 0x96, 0x35,
    0x96, 0x36, 0x96, 0x37, 0x96, 0x38, 0x96, 0x39, 0x96, 0x3d, 0x96, 0x41,
    0x96, 0x5f, 0x96, 0x62, 0x96, 0x64, 0x96, 0x66, 0x96, 0x67, 0x96, 0x68,
    0x96, 0x6c, 0x96, 0x6d, 0x96, 0x6e, 0x96, 0x70, 0x96, 0x72, 0x96, 0x75};
const uint8_t HuffDecoderCommon::table35_3_emit_[72] = {
    0x97, 0x30, 0x97, 0x31, 0x97, 0x32, 0x97, 0x61, 0x97, 0x63, 0x97, 0x65,
    0x97, 0x69, 0x97, 0x6f, 0x97, 0x73, 0x97, 0x74, 0x97, 0x20, 0x97, 0x25,
    0x97, 0x2d, 0x97, 0x2e, 0x97, 0x2f, 0x97, 0x33, 0x97, 0x34, 0x97, 0x35,
    0x97, 0x36, 0x97, 0x37, 0x97, 0x38, 0x97, 0x39, 0x97, 0x3d, 0x97, 0x41,
    0x97, 0x5f, 0x97, 0x62, 0x97, 0x64, 0x97, 0x66, 0x97, 0x67, 0x97, 0x68,
    0x97, 0x6c, 0x97, 0x6d, 0x97, 0x6e, 0x97, 0x70, 0x97, 0x72, 0x97, 0x75};
const uint8_t HuffDecoderCommon::table35_4_emit_[72] = {
    0x98, 0x30, 0x98, 0x31, 0x98, 0x32, 0x98, 0x61, 0x98, 0x63, 0x98, 0x65,
    0x98, 0x69, 0x98, 0x6f, 0x98, 0x73, 0x98, 0x74, 0x98, 0x20, 0x98, 0x25,
    0x98, 0x2d, 0x98, 0x2e, 0x98, 0x2f, 0x98, 0x33, 0x98, 0x34, 0x98, 0x35,
    0x98, 0x36, 0x98, 0x37, 0x98, 0x38, 0x98, 0x39, 0x98, 0x3d, 0x98, 0x41,
    0x98, 0x5f, 0x98, 0x62, 0x98, 0x64, 0x98, 0x66, 0x98, 0x67, 0x98, 0x68,
    0x98, 0x6c, 0x98, 0x6d, 0x98, 0x6e, 0x98, 0x70, 0x98, 0x72, 0x98, 0x75};
const uint8_t HuffDecoderCommon::table35_5_emit_[72] = {
    0x9b, 0x30, 0x9b, 0x31, 0x9b, 0x32, 0x9b, 0x61, 0x9b, 0x63, 0x9b, 0x65,
    0x9b, 0x69, 0x9b, 0x6f, 0x9b, 0x73, 0x9b, 0x74, 0x9b, 0x20, 0x9b, 0x25,
    0x9b, 0x2d, 0x9b, 0x2e, 0x9b, 0x2f, 0x9b, 0x33, 0x9b, 0x34, 0x9b, 0x35,
    0x9b, 0x36, 0x9b, 0x37, 0x9b, 0x38, 0x9b, 0x39, 0x9b, 0x3d, 0x9b, 0x41,
    0x9b, 0x5f, 0x9b, 0x62, 0x9b, 0x64, 0x9b, 0x66, 0x9b, 0x67, 0x9b, 0x68,
    0x9b, 0x6c, 0x9b, 0x6d, 0x9b, 0x6e, 0x9b, 0x70, 0x9b, 0x72, 0x9b, 0x75};
const uint8_t HuffDecoderCommon::table35_6_emit_[72] = {
    0x9d, 0x30, 0x9d, 0x31, 0x9d, 0x32, 0x9d, 0x61, 0x9d, 0x63, 0x9d, 0x65,
    0x9d, 0x69, 0x9d, 0x6f, 0x9d, 0x73, 0x9d, 0x74, 0x9d, 0x20, 0x9d, 0x25,
    0x9d, 0x2d, 0x9d, 0x2e, 0x9d, 0x2f, 0x9d, 0x33, 0x9d, 0x34, 0x9d, 0x35,
    0x9d, 0x36, 0x9d, 0x37, 0x9d, 0x38, 0x9d, 0x39, 0x9d, 0x3d, 0x9d, 0x41,
    0x9d, 0x5f, 0x9d, 0x62, 0x9d, 0x64, 0x9d, 0x66, 0x9d, 0x67, 0x9d, 0x68,
    0x9d, 0x6c, 0x9d, 0x6d, 0x9d, 0x6e, 0x9d, 0x70, 0x9d, 0x72, 0x9d, 0x75};
const uint8_t HuffDecoderCommon::table35_7_emit_[72] = {
    0x9e, 0x30, 0x9e, 0x31, 0x9e, 0x32, 0x9e, 0x61, 0x9e, 0x63, 0x9e, 0x65,
    0x9e, 0x69, 0x9e, 0x6f, 0x9e, 0x73, 0x9e, 0x74, 0x9e, 0x20, 0x9e, 0x25,
    0x9e, 0x2d, 0x9e, 0x2e, 0x9e, 0x2f, 0x9e, 0x33, 0x9e, 0x34, 0x9e, 0x35,
    0x9e, 0x36, 0x9e, 0x37, 0x9e, 0x38, 0x9e, 0x39, 0x9e, 0x3d, 0x9e, 0x41,
    0x9e, 0x5f, 0x9e, 0x62, 0x9e, 0x64, 0x9e, 0x66, 0x9e, 0x67, 0x9e, 0x68,
    0x9e, 0x6c, 0x9e, 0x6d, 0x9e, 0x6e, 0x9e, 0x70, 0x9e, 0x72, 0x9e, 0x75};
const uint8_t HuffDecoderCommon::table35_8_emit_[72] = {
    0xa5, 0x30, 0xa5, 0x31, 0xa5, 0x32, 0xa5, 0x61, 0xa5, 0x63, 0xa5, 0x65,
    0xa5, 0x69, 0xa5, 0x6f, 0xa5, 0x73, 0xa5, 0x74, 0xa5, 0x20, 0xa5, 0x25,
    0xa5, 0x2d, 0xa5, 0x2e, 0xa5, 0x2f, 0xa5, 0x33, 0xa5, 0x34, 0xa5, 0x35,
    0xa5, 0x36, 0xa5, 0x37, 0xa5, 0x38, 0xa5, 0x39, 0xa5, 0x3d, 0xa5, 0x41,
    0xa5, 0x5f, 0xa5, 0x62, 0xa5, 0x64, 0xa5, 0x66, 0xa5, 0x67, 0xa5, 0x68,
    0xa5, 0x6c, 0xa5, 0x6d, 0xa5, 0x6e, 0xa5, 0x70, 0xa5, 0x72, 0xa5, 0x75};
const uint8_t HuffDecoderCommon::table35_9_emit_[72] = {
    0xa6, 0x30, 0xa6, 0x31, 0xa6, 0x32, 0xa6, 0x61, 0xa6, 0x63, 0xa6, 0x65,
    0xa6, 0x69, 0xa6, 0x6f, 0xa6, 0x73, 0xa6, 0x74, 0xa6, 0x20, 0xa6, 0x25,
    0xa6, 0x2d, 0xa6, 0x2e, 0xa6, 0x2f, 0xa6, 0x33, 0xa6, 0x34, 0xa6, 0x35,
    0xa6, 0x36, 0xa6, 0x37, 0xa6, 0x38, 0xa6, 0x39, 0xa6, 0x3d, 0xa6, 0x41,
    0xa6, 0x5f, 0xa6, 0x62, 0xa6, 0x64, 0xa6, 0x66, 0xa6, 0x67, 0xa6, 0x68,
    0xa6, 0x6c, 0xa6, 0x6d, 0xa6, 0x6e, 0xa6, 0x70, 0xa6, 0x72, 0xa6, 0x75};
const uint8_t HuffDecoderCommon::table35_10_emit_[72] = {
    0xa8, 0x30, 0xa8, 0x31, 0xa8, 0x32, 0xa8, 0x61, 0xa8, 0x63, 0xa8, 0x65,
    0xa8, 0x69, 0xa8, 0x6f, 0xa8, 0x73, 0xa8, 0x74, 0xa8, 0x20, 0xa8, 0x25,
    0xa8, 0x2d, 0xa8, 0x2e, 0xa8, 0x2f, 0xa8, 0x33, 0xa8, 0x34, 0xa8, 0x35,
    0xa8, 0x36, 0xa8, 0x37, 0xa8, 0x38, 0xa8, 0x39, 0xa8, 0x3d, 0xa8, 0x41,
    0xa8, 0x5f, 0xa8, 0x62, 0xa8, 0x64, 0xa8, 0x66, 0xa8, 0x67, 0xa8, 0x68,
    0xa8, 0x6c, 0xa8, 0x6d, 0xa8, 0x6e, 0xa8, 0x70, 0xa8, 0x72, 0xa8, 0x75};
const uint8_t HuffDecoderCommon::table35_11_emit_[72] = {
    0xae, 0x30, 0xae, 0x31, 0xae, 0x32, 0xae, 0x61, 0xae, 0x63, 0xae, 0x65,
    0xae, 0x69, 0xae, 0x6f, 0xae, 0x73, 0xae, 0x74, 0xae, 0x20, 0xae, 0x25,
    0xae, 0x2d, 0xae, 0x2e, 0xae, 0x2f, 0xae, 0x33, 0xae, 0x34, 0xae, 0x35,
    0xae, 0x36, 0xae, 0x37, 0xae, 0x38, 0xae, 0x39, 0xae, 0x3d, 0xae, 0x41,
    0xae, 0x5f, 0xae, 0x62, 0xae, 0x64, 0xae, 0x66, 0xae, 0x67, 0xae, 0x68,
    0xae, 0x6c, 0xae, 0x6d, 0xae, 0x6e, 0xae, 0x70, 0xae, 0x72, 0xae, 0x75};
const uint8_t HuffDecoderCommon::table35_12_emit_[72] = {
    0xaf, 0x30, 0xaf, 0x31, 0xaf, 0x32, 0xaf, 0x61, 0xaf, 0x63, 0xaf, 0x65,
    0xaf, 0x69, 0xaf, 0x6f, 0xaf, 0x73, 0xaf, 0x74, 0xaf, 0x20, 0xaf, 0x25,
    0xaf, 0x2d, 0xaf, 0x2e, 0xaf, 0x2f, 0xaf, 0x33, 0xaf, 0x34, 0xaf, 0x35,
    0xaf, 0x36, 0xaf, 0x37, 0xaf, 0x38, 0xaf, 0x39, 0xaf, 0x3d, 0xaf, 0x41,
    0xaf, 0x5f, 0xaf, 0x62, 0xaf, 0x64, 0xaf, 0x66, 0xaf, 0x67, 0xaf, 0x68,
    0xaf, 0x6c, 0xaf, 0x6d, 0xaf, 0x6e, 0xaf, 0x70, 0xaf, 0x72, 0xaf, 0x75};
const uint8_t HuffDecoderCommon::table35_13_emit_[72] = {
    0xb4, 0x30, 0xb4, 0x31, 0xb4, 0x32, 0xb4, 0x61, 0xb4, 0x63, 0xb4, 0x65,
    0xb4, 0x69, 0xb4, 0x6f, 0xb4, 0x73, 0xb4, 0x74, 0xb4, 0x20, 0xb4, 0x25,
    0xb4, 0x2d, 0xb4, 0x2e, 0xb4, 0x2f, 0xb4, 0x33, 0xb4, 0x34, 0xb4, 0x35,
    0xb4, 0x36, 0xb4, 0x37, 0xb4, 0x38, 0xb4, 0x39, 0xb4, 0x3d, 0xb4, 0x41,
    0xb4, 0x5f, 0xb4, 0x62, 0xb4, 0x64, 0xb4, 0x66, 0xb4, 0x67, 0xb4, 0x68,
    0xb4, 0x6c, 0xb4, 0x6d, 0xb4, 0x6e, 0xb4, 0x70, 0xb4, 0x72, 0xb4, 0x75};
const uint8_t HuffDecoderCommon::table35_14_emit_[72] = {
    0xb6, 0x30, 0xb6, 0x31, 0xb6, 0x32, 0xb6, 0x61, 0xb6, 0x63, 0xb6, 0x65,
    0xb6, 0x69, 0xb6, 0x6f, 0xb6, 0x73, 0xb6, 0x74, 0xb6, 0x20, 0xb6, 0x25,
    0xb6, 0x2d, 0xb6, 0x2e, 0xb6, 0x2f, 0xb6, 0x33, 0xb6, 0x34, 0xb6, 0x35,
    0xb6, 0x36, 0xb6, 0x37, 0xb6, 0x38, 0xb6, 0x39, 0xb6, 0x3d, 0xb6, 0x41,
    0xb6, 0x5f, 0xb6, 0x62, 0xb6, 0x64, 0xb6, 0x66, 0xb6, 0x67, 0xb6, 0x68,
    0xb6, 0x6c, 0xb6, 0x6d, 0xb6, 0x6e, 0xb6, 0x70, 0xb6, 0x72, 0xb6, 0x75};
const uint8_t HuffDecoderCommon::table35_15_emit_[72] = {
    0xb7, 0x30, 0xb7, 0x31, 0xb7, 0x32, 0xb7, 0x61, 0xb7, 0x63, 0xb7, 0x65,
    0xb7, 0x69, 0xb7, 0x6f, 0xb7, 0x73, 0xb7, 0x74, 0xb7, 0x20, 0xb7, 0x25,
    0xb7, 0x2d, 0xb7, 0x2e, 0xb7, 0x2f, 0xb7, 0x33, 0xb7, 0x34, 0xb7, 0x35,
    0xb7, 0x36, 0xb7, 0x37, 0xb7, 0x38, 0xb7, 0x39, 0xb7, 0x3d, 0xb7, 0x41,
    0xb7, 0x5f, 0xb7, 0x62, 0xb7, 0x64, 0xb7, 0x66, 0xb7, 0x67, 0xb7, 0x68,
    0xb7, 0x6c, 0xb7, 0x6d, 0xb7, 0x6e, 0xb7, 0x70, 0xb7, 0x72, 0xb7, 0x75};
const uint8_t HuffDecoderCommon::table35_16_emit_[72] = {
    0xbc, 0x30, 0xbc, 0x31, 0xbc, 0x32, 0xbc, 0x61, 0xbc, 0x63, 0xbc, 0x65,
    0xbc, 0x69, 0xbc, 0x6f, 0xbc, 0x73, 0xbc, 0x74, 0xbc, 0x20, 0xbc, 0x25,
    0xbc, 0x2d, 0xbc, 0x2e, 0xbc, 0x2f, 0xbc, 0x33, 0xbc, 0x34, 0xbc, 0x35,
    0xbc, 0x36, 0xbc, 0x37, 0xbc, 0x38, 0xbc, 0x39, 0xbc, 0x3d, 0xbc, 0x41,
    0xbc, 0x5f, 0xbc, 0x62, 0xbc, 0x64, 0xbc, 0x66, 0xbc, 0x67, 0xbc, 0x68,
    0xbc, 0x6c, 0xbc, 0x6d, 0xbc, 0x6e, 0xbc, 0x70, 0xbc, 0x72, 0xbc, 0x75};
const uint8_t HuffDecoderCommon::table35_17_emit_[72] = {
    0xbf, 0x30, 0xbf, 0x31, 0xbf, 0x32, 0xbf, 0x61, 0xbf, 0x63, 0xbf, 0x65,
    0xbf, 0x69, 0xbf, 0x6f, 0xbf, 0x73, 0xbf, 0x74, 0xbf, 0x20, 0xbf, 0x25,
    0xbf, 0x2d, 0xbf, 0x2e, 0xbf, 0x2f, 0xbf, 0x33, 0xbf, 0x34, 0xbf, 0x35,
    0xbf, 0x36, 0xbf, 0x37, 0xbf, 0x38, 0xbf, 0x39, 0xbf, 0x3d, 0xbf, 0x41,
    0xbf, 0x5f, 0xbf, 0x62, 0xbf, 0x64, 0xbf, 0x66, 0xbf, 0x67, 0xbf, 0x68,
    0xbf, 0x6c, 0xbf, 0x6d, 0xbf, 0x6e, 0xbf, 0x70, 0xbf, 0x72, 0xbf, 0x75};
const uint8_t HuffDecoderCommon::table35_18_emit_[72] = {
    0xc5, 0x30, 0xc5, 0x31, 0xc5, 0x32, 0xc5, 0x61, 0xc5, 0x63, 0xc5, 0x65,
    0xc5, 0x69, 0xc5, 0x6f, 0xc5, 0x73, 0xc5, 0x74, 0xc5, 0x20, 0xc5, 0x25,
    0xc5, 0x2d, 0xc5, 0x2e, 0xc5, 0x2f, 0xc5, 0x33, 0xc5, 0x34, 0xc5, 0x35,
    0xc5, 0x36, 0xc5, 0x37, 0xc5, 0x38, 0xc5, 0x39, 0xc5, 0x3d, 0xc5, 0x41,
    0xc5, 0x5f, 0xc5, 0x62, 0xc5, 0x64, 0xc5, 0x66, 0xc5, 0x67, 0xc5, 0x68,
    0xc5, 0x6c, 0xc5, 0x6d, 0xc5, 0x6e, 0xc5, 0x70, 0xc5, 0x72, 0xc5, 0x75};
const uint8_t HuffDecoderCommon::table35_19_emit_[72] = {
    0xe7, 0x30, 0xe7, 0x31, 0xe7, 0x32, 0xe7, 0x61, 0xe7, 0x63, 0xe7, 0x65,
    0xe7, 0x69, 0xe7, 0x6f, 0xe7, 0x73, 0xe7, 0x74, 0xe7, 0x20, 0xe7, 0x25,
    0xe7, 0x2d, 0xe7, 0x2e, 0xe7, 0x2f, 0xe7, 0x33, 0xe7, 0x34, 0xe7, 0x35,
    0xe7, 0x36, 0xe7, 0x37, 0xe7, 0x38, 0xe7, 0x39, 0xe7, 0x3d, 0xe7, 0x41,
    0xe7, 0x5f, 0xe7, 0x62, 0xe7, 0x64, 0xe7, 0x66, 0xe7, 0x67, 0xe7, 0x68,
    0xe7, 0x6c, 0xe7, 0x6d, 0xe7, 0x6e, 0xe7, 0x70, 0xe7, 0x72, 0xe7, 0x75};
const uint8_t HuffDecoderCommon::table35_20_emit_[72] = {
    0xef, 0x30, 0xef, 0x31, 0xef, 0x32, 0xef, 0x61, 0xef, 0x63, 0xef, 0x65,
    0xef, 0x69, 0xef, 0x6f, 0xef, 0x73, 0xef, 0x74, 0xef, 0x20, 0xef, 0x25,
    0xef, 0x2d, 0xef, 0x2e, 0xef, 0x2f, 0xef, 0x33, 0xef, 0x34, 0xef, 0x35,
    0xef, 0x36, 0xef, 0x37, 0xef, 0x38, 0xef, 0x39, 0xef, 0x3d, 0xef, 0x41,
    0xef, 0x5f, 0xef, 0x62, 0xef, 0x64, 0xef, 0x66, 0xef, 0x67, 0xef, 0x68,
    0xef, 0x6c, 0xef, 0x6d, 0xef, 0x6e, 0xef, 0x70, 0xef, 0x72, 0xef, 0x75};
const uint8_t HuffDecoderCommon::table35_21_emit_[40] = {
    0x09, 0x30, 0x09, 0x31, 0x09, 0x32, 0x09, 0x61, 0x09, 0x63,
    0x09, 0x65, 0x09, 0x69, 0x09, 0x6f, 0x09, 0x73, 0x09, 0x74,
    0x8e, 0x30, 0x8e, 0x31, 0x8e, 0x32, 0x8e, 0x61, 0x8e, 0x63,
    0x8e, 0x65, 0x8e, 0x69, 0x8e, 0x6f, 0x8e, 0x73, 0x8e, 0x74};
const uint16_t HuffDecoderCommon::table35_21_ops_[64] = {
    0x0001, 0x0009, 0x0011, 0x0019, 0x0021, 0x0029, 0x0031, 0x0039,
    0x0041, 0x0049, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0051, 0x0059, 0x0061, 0x0069, 0x0071, 0x0079, 0x0081, 0x0089,
    0x0091, 0x0099, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0052};
const uint8_t HuffDecoderCommon::table35_22_emit_[40] = {
    0x90, 0x30, 0x90, 0x31, 0x90, 0x32, 0x90, 0x61, 0x90, 0x63,
    0x90, 0x65, 0x90, 0x69, 0x90, 0x6f, 0x90, 0x73, 0x90, 0x74,
    0x91, 0x30, 0x91, 0x31, 0x91, 0x32, 0x91, 0x61, 0x91, 0x63,
    0x91, 0x65, 0x91, 0x69, 0x91, 0x6f, 0x91, 0x73, 0x91, 0x74};
const uint8_t HuffDecoderCommon::table35_23_emit_[40] = {
    0x94, 0x30, 0x94, 0x31, 0x94, 0x32, 0x94, 0x61, 0x94, 0x63,
    0x94, 0x65, 0x94, 0x69, 0x94, 0x6f, 0x94, 0x73, 0x94, 0x74,
    0x9f, 0x30, 0x9f, 0x31, 0x9f, 0x32, 0x9f, 0x61, 0x9f, 0x63,
    0x9f, 0x65, 0x9f, 0x69, 0x9f, 0x6f, 0x9f, 0x73, 0x9f, 0x74};
const uint8_t HuffDecoderCommon::table35_24_emit_[40] = {
    0xab, 0x30, 0xab, 0x31, 0xab, 0x32, 0xab, 0x61, 0xab, 0x63,
    0xab, 0x65, 0xab, 0x69, 0xab, 0x6f, 0xab, 0x73, 0xab, 0x74,
    0xce, 0x30, 0xce, 0x31, 0xce, 0x32, 0xce, 0x61, 0xce, 0x63,
    0xce, 0x65, 0xce, 0x69, 0xce, 0x6f, 0xce, 0x73, 0xce, 0x74};
const uint8_t HuffDecoderCommon::table35_25_emit_[40] = {
    0xd7, 0x30, 0xd7, 0x31, 0xd7, 0x32, 0xd7, 0x61, 0xd7, 0x63,
    0xd7, 0x65, 0xd7, 0x69, 0xd7, 0x6f, 0xd7, 0x73, 0xd7, 0x74,
    0xe1, 0x30, 0xe1, 0x31, 0xe1, 0x32, 0xe1, 0x61, 0xe1, 0x63,
    0xe1, 0x65, 0xe1, 0x69, 0xe1, 0x6f, 0xe1, 0x73, 0xe1, 0x74};
const uint8_t HuffDecoderCommon::table35_26_emit_[40] = {
    0xec, 0x30, 0xec, 0x31, 0xec, 0x32, 0xec, 0x61, 0xec, 0x63,
    0xec, 0x65, 0xec, 0x69, 0xec, 0x6f, 0xec, 0x73, 0xec, 0x74,
    0xed, 0x30, 0xed, 0x31, 0xed, 0x32, 0xed, 0x61, 0xed, 0x63,
    0xed, 0x65, 0xed, 0x69, 0xed, 0x6f, 0xed, 0x73, 0xed, 0x74};
const uint8_t HuffDecoderCommon::table35_27_emit_[4] = {0xc7, 0xcf, 0xea, 0xeb};
const uint16_t HuffDecoderCommon::table35_27_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000e};
const uint8_t HuffDecoderCommon::table35_28_emit_[8] = {0xc0, 0xc1, 0xc8, 0xc9,
                                                        0xca, 0xcd, 0xd2, 0xd5};
const uint16_t HuffDecoderCommon::table35_28_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000e,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0016,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x001a,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x001e};
const uint8_t HuffDecoderCommon::table35_29_emit_[9] = {
    0xda, 0xdb, 0xee, 0xf0, 0xf2, 0xf3, 0xff, 0xcb, 0xcc};
const uint16_t HuffDecoderCommon::table35_29_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0006,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000a,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x000e,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0012,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0016,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x001a,
    0x0000, 0x0000, 0x0000, 0x001e, 0x0000, 0x0000, 0x0000, 0x0022};
const uint8_t HuffDecoderCommon::table35_30_emit_[16] = {
    0xd3, 0xd4, 0xd6, 0xdd, 0xde, 0xdf, 0xf1, 0xf4,
    0xf5, 0xf6, 0xf7, 0xf8, 0xfa, 0xfb, 0xfc, 0xfd};
const uint16_t HuffDecoderCommon::table35_30_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0000, 0x0000, 0x0006,
    0x0000, 0x0000, 0x0000, 0x000a, 0x0000, 0x0000, 0x0000, 0x000e,
    0x0000, 0x0000, 0x0000, 0x0012, 0x0000, 0x0000, 0x0000, 0x0016,
    0x0000, 0x0000, 0x0000, 0x001a, 0x0000, 0x0000, 0x0000, 0x001e,
    0x0000, 0x0000, 0x0000, 0x0022, 0x0000, 0x0000, 0x0000, 0x0026,
    0x0000, 0x0000, 0x0000, 0x002a, 0x0000, 0x0000, 0x0000, 0x002e,
    0x0000, 0x0000, 0x0000, 0x0032, 0x0000, 0x0000, 0x0000, 0x0036,
    0x0000, 0x0000, 0x0000, 0x003a, 0x0000, 0x0000, 0x0000, 0x003e};
const uint8_t HuffDecoderCommon::table35_31_emit_[30] = {
    0xfe, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0b, 0x0c,
    0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x17, 0x18,
    0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x7f, 0xdc, 0xf9};
const uint16_t HuffDecoderCommon::table35_31_ops_[64] = {
    0x0000, 0x0000, 0x0000, 0x0002, 0x0000, 0x0006, 0x0000, 0x000a,
    0x0000, 0x000e, 0x0000, 0x0012, 0x0000, 0x0016, 0x0000, 0x001a,
    0x0000, 0x001e, 0x0000, 0x0022, 0x0000, 0x0026, 0x0000, 0x002a,
    0x0000, 0x002e, 0x0000, 0x0032, 0x0000, 0x0036, 0x0000, 0x003a,
    0x0000, 0x003e, 0x0000, 0x0042, 0x0000, 0x0046, 0x0000, 0x004a,
    0x0000, 0x004e, 0x0000, 0x0052, 0x0000, 0x0056, 0x0000, 0x005a,
    0x0000, 0x005e, 0x0000, 0x0062, 0x0000, 0x0066, 0x0000, 0x006a,
    0x0000, 0x006e, 0x0000, 0x0072, 0x0000, 0x0076, 0x0000, 0x0003};
const uint8_t* const HuffDecoderCommon::table35_emit_[32] = {
    table35_0_emit_,  table35_1_emit_,  table35_2_emit_,  table35_3_emit_,
    table35_4_emit_,  table35_5_emit_,  table35_6_emit_,  table35_7_emit_,
    table35_8_emit_,  table35_9_emit_,  table35_10_emit_, table35_11_emit_,
    table35_12_emit_, table35_13_emit_, table35_14_emit_, table35_15_emit_,
    table35_16_emit_, table35_17_emit_, table35_18_emit_, table35_19_emit_,
    table35_20_emit_, table35_21_emit_, table35_22_emit_, table35_23_emit_,
    table35_24_emit_, table35_25_emit_, table35_26_emit_, table35_27_emit_,
    table35_28_emit_, table35_29_emit_, table35_30_emit_, table35_31_emit_,
};
const uint16_t* const HuffDecoderCommon::table35_ops_[32] = {
    table35_0_ops_,  table35_0_ops_,  table35_0_ops_,  table35_0_ops_,
    table35_0_ops_,  table35_0_ops_,  table35_0_ops_,  table35_0_ops_,
    table35_0_ops_,  table35_0_ops_,  table35_0_ops_,  table35_0_ops_,
    table35_0_ops_,  table35_0_ops_,  table35_0_ops_,  table35_0_ops_,
    table35_0_ops_,  table35_0_ops_,  table35_0_ops_,  table35_0_ops_,
    table35_0_ops_,  table35_21_ops_, table35_21_ops_, table35_21_ops_,
    table35_21_ops_, table35_21_ops_, table35_21_ops_, table35_27_ops_,
    table35_28_ops_, table35_29_ops_, table35_30_ops_, table35_31_ops_,
};
const uint8_t HuffDecoderCommon::table28_0_emit_[1] = {0x93};
const uint16_t HuffDecoderCommon::table28_0_ops_[128] = {
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005, 0x0005,
    0x0005, 0x0005};
const uint8_t HuffDecoderCommon::table28_1_emit_[1] = {0x95};
const uint8_t HuffDecoderCommon::table28_2_emit_[1] = {0x96};
const uint8_t HuffDecoderCommon::table28_3_emit_[1] = {0x97};
const uint8_t HuffDecoderCommon::table28_4_emit_[1] = {0x98};
const uint8_t HuffDecoderCommon::table28_5_emit_[1] = {0x9b};
const uint8_t HuffDecoderCommon::table28_6_emit_[1] = {0x9d};
const uint8_t HuffDecoderCommon::table28_7_emit_[1] = {0x9e};
const uint8_t HuffDecoderCommon::table28_8_emit_[1] = {0xa5};
const uint8_t HuffDecoderCommon::table28_9_emit_[1] = {0xa6};
const uint8_t HuffDecoderCommon::table28_10_emit_[1] = {0xa8};
const uint8_t HuffDecoderCommon::table28_11_emit_[1] = {0xae};
const uint8_t HuffDecoderCommon::table28_12_emit_[1] = {0xaf};
const uint8_t HuffDecoderCommon::table28_13_emit_[1] = {0xb4};
const uint8_t HuffDecoderCommon::table28_14_emit_[1] = {0xb6};
const uint8_t HuffDecoderCommon::table28_15_emit_[1] = {0xb7};
const uint8_t HuffDecoderCommon::table28_16_emit_[1] = {0xbc};
const uint8_t HuffDecoderCommon::table28_17_emit_[1] = {0xbf};
const uint8_t HuffDecoderCommon::table28_18_emit_[1] = {0xc5};
const uint8_t HuffDecoderCommon::table28_19_emit_[1] = {0xe7};
const uint8_t HuffDecoderCommon::table28_20_emit_[1] = {0xef};
const uint8_t HuffDecoderCommon::table28_21_emit_[2] = {0x09, 0x8e};
const uint16_t HuffDecoderCommon::table28_21_ops_[128] = {
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006,
    0x0006, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026,
    0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026,
    0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026,
    0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026,
    0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026,
    0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026,
    0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026, 0x0026,
    0x0026, 0x0026};
const uint8_t HuffDecoderCommon::table28_22_emit_[2] = {0x90, 0x91};
const uint8_t HuffDecoderCommon::table28_23_emit_[2] = {0x94, 0x9f};
const uint8_t HuffDecoderCommon::table28_24_emit_[2] = {0xab, 0xce};
const uint8_t HuffDecoderCommon::table28_25_emit_[2] = {0xd7, 0xe1};
const uint8_t HuffDecoderCommon::table28_26_emit_[2] = {0xec, 0xed};
const uint16_t HuffDecoderCommon::table28_27_ops_[128] = {
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0007,
    0x0007, 0x0007, 0x0007, 0x0007, 0x0007, 0x0027, 0x0027, 0x0027, 0x0027,
    0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027,
    0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027,
    0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027, 0x0027,
    0x0027, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047,
    0x0047, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047,
    0x0047, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047,
    0x0047, 0x0047, 0x0047, 0x0047, 0x0047, 0x0047, 0x0067, 0x0067, 0x0067,
    0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x0067,
    0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x0067,
    0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x0067, 0x0067,
    0x0067, 0x0067};
const uint16_t HuffDecoderCommon::table28_28_ops_[128] = {
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0028, 0x0028,
    0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
    0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068,
    0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068,
    0x0068, 0x0088, 0x0088, 0x0088, 0x0088, 0x0088, 0x0088, 0x0088, 0x0088,
    0x0088, 0x0088, 0x0088, 0x0088, 0x0088, 0x0088, 0x0088, 0x0088, 0x00a8,
    0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00a8,
    0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00c8, 0x00c8, 0x00c8,
    0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8,
    0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8,
    0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8, 0x00e8,
    0x00e8, 0x00e8};
const uint16_t HuffDecoderCommon::table28_29_ops_[128] = {
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008,
    0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0008, 0x0028, 0x0028,
    0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0028,
    0x0028, 0x0028, 0x0028, 0x0028, 0x0028, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048, 0x0048,
    0x0048, 0x0048, 0x0048, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068,
    0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068, 0x0068,
    0x0068, 0x0088, 0x0088, 0x0088, 0x0088, 0x0088, 0x0088, 0x0088, 0x0088,
    0x0088, 0x0088, 0x0088, 0x0088, 0x0088, 0x0088, 0x0088, 0x0088, 0x00a8,
    0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00a8,
    0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00a8, 0x00c8, 0x00c8, 0x00c8,
    0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00c8,
    0x00c8, 0x00c8, 0x00c8, 0x00c8, 0x00e9, 0x00e9, 0x00e9, 0x00e9, 0x00e9,
    0x00e9, 0x00e9, 0x00e9, 0x0109, 0x0109, 0x0109, 0x0109, 0x0109, 0x0109,
    0x0109, 0x0109};
const uint16_t HuffDecoderCommon::table28_30_ops_[128] = {
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0029,
    0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0029, 0x0049, 0x0049,
    0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0049, 0x0069, 0x0069, 0x0069,
    0x0069, 0x0069, 0x0069, 0x0069, 0x0069, 0x0089, 0x0089, 0x0089, 0x0089,
    0x0089, 0x0089, 0x0089, 0x0089, 0x00a9, 0x00a9, 0x00a9, 0x00a9, 0x00a9,
    0x00a9, 0x00a9, 0x00a9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9, 0x00c9,
    0x00c9, 0x00c9, 0x00e9, 0x00e9, 0x00e9, 0x00e9, 0x00e9, 0x00e9, 0x00e9,
    0x00e9, 0x0109, 0x0109, 0x0109, 0x0109, 0x0109, 0x0109, 0x0109, 0x0109,
    0x0129, 0x0129, 0x0129, 0x0129, 0x0129, 0x0129, 0x0129, 0x0129, 0x0149,
    0x0149, 0x0149, 0x0149, 0x0149, 0x0149, 0x0149, 0x0149, 0x0169, 0x0169,
    0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x0189, 0x0189, 0x0189,
    0x0189, 0x0189, 0x0189, 0x0189, 0x0189, 0x01a9, 0x01a9, 0x01a9, 0x01a9,
    0x01a9, 0x01a9, 0x01a9, 0x01a9, 0x01c9, 0x01c9, 0x01c9, 0x01c9, 0x01c9,
    0x01c9, 0x01c9, 0x01c9, 0x01e9, 0x01e9, 0x01e9, 0x01e9, 0x01e9, 0x01e9,
    0x01e9, 0x01e9};
const uint8_t HuffDecoderCommon::table28_31_emit_[33] = {
    0xfe, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0b, 0x0c, 0x0e,
    0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x17, 0x18, 0x19, 0x1a,
    0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x7f, 0xdc, 0xf9, 0x0a, 0x0d, 0x16};
const uint16_t HuffDecoderCommon::table28_31_ops_[128] = {
    0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x0009, 0x002a,
    0x002a, 0x002a, 0x002a, 0x004a, 0x004a, 0x004a, 0x004a, 0x006a, 0x006a,
    0x006a, 0x006a, 0x008a, 0x008a, 0x008a, 0x008a, 0x00aa, 0x00aa, 0x00aa,
    0x00aa, 0x00ca, 0x00ca, 0x00ca, 0x00ca, 0x00ea, 0x00ea, 0x00ea, 0x00ea,
    0x010a, 0x010a, 0x010a, 0x010a, 0x012a, 0x012a, 0x012a, 0x012a, 0x014a,
    0x014a, 0x014a, 0x014a, 0x016a, 0x016a, 0x016a, 0x016a, 0x018a, 0x018a,
    0x018a, 0x018a, 0x01aa, 0x01aa, 0x01aa, 0x01aa, 0x01ca, 0x01ca, 0x01ca,
    0x01ca, 0x01ea, 0x01ea, 0x01ea, 0x01ea, 0x020a, 0x020a, 0x020a, 0x020a,
    0x022a, 0x022a, 0x022a, 0x022a, 0x024a, 0x024a, 0x024a, 0x024a, 0x026a,
    0x026a, 0x026a, 0x026a, 0x028a, 0x028a, 0x028a, 0x028a, 0x02aa, 0x02aa,
    0x02aa, 0x02aa, 0x02ca, 0x02ca, 0x02ca, 0x02ca, 0x02ea, 0x02ea, 0x02ea,
    0x02ea, 0x030a, 0x030a, 0x030a, 0x030a, 0x032a, 0x032a, 0x032a, 0x032a,
    0x034a, 0x034a, 0x034a, 0x034a, 0x036a, 0x036a, 0x036a, 0x036a, 0x038a,
    0x038a, 0x038a, 0x038a, 0x03aa, 0x03aa, 0x03aa, 0x03aa, 0x03cc, 0x03ec,
    0x040c, 0x001c};
const uint8_t* const HuffDecoderCommon::table28_emit_[32] = {
    table28_0_emit_,  table28_1_emit_,  table28_2_emit_,  table28_3_emit_,
    table28_4_emit_,  table28_5_emit_,  table28_6_emit_,  table28_7_emit_,
    table28_8_emit_,  table28_9_emit_,  table28_10_emit_, table28_11_emit_,
    table28_12_emit_, table28_13_emit_, table28_14_emit_, table28_15_emit_,
    table28_16_emit_, table28_17_emit_, table28_18_emit_, table28_19_emit_,
    table28_20_emit_, table28_21_emit_, table28_22_emit_, table28_23_emit_,
    table28_24_emit_, table28_25_emit_, table28_26_emit_, table35_27_emit_,
    table35_28_emit_, table35_29_emit_, table35_30_emit_, table28_31_emit_,
};
const uint16_t* const HuffDecoderCommon::table28_ops_[32] = {
    table28_0_ops_,  table28_0_ops_,  table28_0_ops_,  table28_0_ops_,
    table28_0_ops_,  table28_0_ops_,  table28_0_ops_,  table28_0_ops_,
    table28_0_ops_,  table28_0_ops_,  table28_0_ops_,  table28_0_ops_,
    table28_0_ops_,  table28_0_ops_,  table28_0_ops_,  table28_0_ops_,
    table28_0_ops_,  table28_0_ops_,  table28_0_ops_,  table28_0_ops_,
    table28_0_ops_,  table28_21_ops_, table28_21_ops_, table28_21_ops_,
    table28_21_ops_, table28_21_ops_, table28_21_ops_, table28_27_ops_,
    table28_28_ops_, table28_29_ops_, table28_30_ops_, table28_31_ops_,
};
}  // namespace geometry_12_6_12
}  // namespace grpc_core
