package cc

const moduleFileTpl = `// Code generated by protoc-gen-validate
// source: {{ .InputPath }}
// DO NOT EDIT!!!

#include "{{ output .File ".validate.h" }}"

#include <google/protobuf/message.h>
#include <google/protobuf/util/time_util.h>
#include "re2/re2.h"

namespace pgv {

namespace protobuf = google::protobuf;
namespace protobuf_wkt = google::protobuf;

namespace validate {
using std::string;

// define the regex for a UUID once up-front
const re2::RE2 _uuidPattern("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$");

{{ range .AllMessages }}
{{- if not (ignored .) -}}
{{- if not (disabled .) -}}

pgv::Validator<{{ class . }}> {{ staticVarName . }}(static_cast<bool(*)(const {{ class .}}&, pgv::ValidationMsg*)>({{ package .}}::Validate));

{{- end -}}
{{ end }}
{{ end }}

} // namespace validate
} // namespace pgv

{{ range .Package.ProtoName.Split }}
namespace {{ . }} {
{{- end }}

{{ range .AllMessages }}
	{{- template "msg" . }}
{{ end }}

{{ range .Package.ProtoName.Split -}}
} // namespace
{{ end }}
`

const headerFileTpl = `// Code generated by protoc-gen-validate
// source: {{ .InputPath }}
// DO NOT EDIT!!!

#pragma once

#include <algorithm>
#include <string>
#include <sstream>
#include <unordered_set>
#include <vector>

#include "validate/validate.h"
#include "{{ output .File ".h" }}"

{{ range .Package.ProtoName.Split }}
namespace {{ . }} {
{{- end }}

using std::string;

{{ range .AllMessages }}
	{{- template "decl" . }}
{{ end }}

{{ range .Package.ProtoName.Split -}}
} // namespace
{{ end }}

#define X_{{ .Package.ProtoName.ScreamingSnakeCase }}_{{ .File.InputPath.BaseName | screaming_snake_case }}(X) \
{{ range .AllMessages -}}
{{- if not (ignored .) -}}
	X({{class . }}) \
{{ end -}}
{{ end }}
`
