/*
 * Copyright 2022 Rive
 */

#pragma once

#include "rive/factory.hpp"

namespace rive::gpu
{
// Partial rive::Factory implementation for the PLS objects that are backend-agnostic.
class RiveRenderFactory : public Factory
{
public:
    rcp<RenderShader> makeLinearGradient(float sx,
                                         float sy,
                                         float ex,
                                         float ey,
                                         const ColorInt colors[], // [count]
                                         const float stops[],     // [count]
                                         size_t count) override;

    rcp<RenderShader> makeRadialGradient(float cx,
                                         float cy,
                                         float radius,
                                         const ColorInt colors[], // [count]
                                         const float stops[],     // [count]
                                         size_t count) override;

    rcp<RenderPath> makeRenderPath(RawPath&, FillRule) override;

    rcp<RenderPath> makeEmptyRenderPath() override;

    rcp<RenderPaint> makeRenderPaint() override;
};
} // namespace rive::gpu
