meta-virtualization
===================

This layer provides support for building Xen, KVM, Libvirt, and associated
packages necessary for constructing OE-based virtualized solutions.

The bbappend files for some recipes (e.g. linux-yocto) in this layer need to
have 'virtualization' in DISTRO_FEATURES to have effect. To enable them, add
in configuration file the following line.

  DISTRO_FEATURES:append = " virtualization"

If meta-virtualization is included, but virtualization is not enabled as a
distro feature a warning is printed at parse time:

    You have included the meta-virtualization layer, but
    'virtualization' has not been enabled in your DISTRO_FEATURES. Some bbappend files
    may not take effect. See the meta-virtualization README for details on enabling
    virtualization support.

If you know what you are doing, this warning can be disabled by setting the following
variable in your configuration:

  SKIP_META_VIRT_SANITY_CHECK = 1

Depending on your use case, there are other distro features in meta-virtualization
that may also be enabled:

 - xen: enables xen functionality in various packages (kernel, libvirt, etc)
 - kvm: enables KVM configurations in the kernel and autoloads modules
 - k8s: enables kubernets configurations in the kernel, tools and configuration
 - aufs: enables aufs support in docker and linux-yocto
 - x11: enable xen and libvirt functionality related to x11
 - selinux: enables functionality in libvirt and lxc
 - systemd: enable systemd services and unit files (for recipes for support)
 - sysvinit: enable sysvinit scripts (for recipes with support)
 - seccomp: enable seccomp support for packages that have the capability.

Dependencies
------------
This layer depends on:

URI: git://github.com/openembedded/openembedded-core.git
branch: master
revision: HEAD
prio: default

URI: git://github.com/openembedded/meta-openembedded.git
branch: master
revision: HEAD
layers: meta-oe
        meta-networking
        meta-filesystems
        meta-python

Required for Xen XSM policy:
URI: git://git.yoctoproject.org/meta-selinux
branch: master
revision: HEAD
prio: default

Required for Ceph:
URI: git://git.yoctoproject.org/meta-cloud-services
branch: master
revision: HEAD
prio: default

Required for cri-o:
URI: git://git.yoctoproject.org/meta-selinux
branch: master
revision: HEAD
prio: default

Community / Colaboration
------------------------

Repository: https://git.yoctoproject.org/cgit/cgit.cgi/meta-virtualization/
Mailing list: https://lists.yoctoproject.org/g/meta-virtualization
IRC: libera.chat #meta-virt channel

Maintenance
-----------

Send pull requests, patches, comments or questions to meta-virtualization@lists.yoctoproject.org

Maintainer: Bruce Ashfield <bruce.ashfield@gmail.com>
see MAINTAINERS for more specific information

When sending single patches, please using something like:
$ git send-email -1 -M --to meta-virtualization@lists.yoctoproject.org --subject-prefix='meta-virtualization][PATCH'

License
-------

All metadata is MIT licensed unless otherwise stated. Source code included
in tree for individual recipes is under the LICENSE stated in each recipe
(.bb file) unless otherwise stated.

