/**
 * The MIT License (MIT)
 *
 * Copyright (c) 2018-2019 Erik Moqvist
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/**

 */

#ifndef VEHICLE_H
#define VEHICLE_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>
#include <stdbool.h>
#include <stddef.h>

#ifndef EINVAL
#    define EINVAL 22
#endif

/* Frame ids. */
#define VEHICLE_RT_SB_INS_VEL_BODY_AXES_FRAME_ID (0x9588322u)
#define VEHICLE_RT_DL1_MK3_SPEED_FRAME_ID (0x94a7c24u)
#define VEHICLE_RT_DL1_MK3_GPS_TIME_FRAME_ID (0x9566d24u)
#define VEHICLE_RT_DL1_MK3_GPS_POS_LLH_2_FRAME_ID (0x9566f24u)
#define VEHICLE_RT_DL1_MK3_GPS_POS_LLH_1_FRAME_ID (0x9566e24u)
#define VEHICLE_RT_DL1_MK3_GPS_SPEED_FRAME_ID (0x9567c24u)
#define VEHICLE_RT_IR_TEMP_TEMP_7_FRAME_ID (0x95b7325u)
#define VEHICLE_RT_IR_TEMP_TEMP_RR_2_FRAME_ID (0x9627425u)
#define VEHICLE_RT_IR_TEMP_TEMP_RL_2_FRAME_ID (0x9627225u)
#define VEHICLE_RT_IR_TEMP_TEMP_FR_2_FRAME_ID (0x9627025u)
#define VEHICLE_RT_IR_TEMP_TEMP_FL_2_FRAME_ID (0x9626e25u)
#define VEHICLE_RT_IR_TEMP_TEMP_RR_1_FRAME_ID (0x9627325u)
#define VEHICLE_RT_IR_TEMP_TEMP_RL_1_FRAME_ID (0x9627125u)
#define VEHICLE_RT_IR_TEMP_TEMP_FR_1_FRAME_ID (0x9626f25u)
#define VEHICLE_RT_IR_TEMP_TEMP_FL_1_FRAME_ID (0x9626d25u)
#define VEHICLE_RT_IR_TEMP_TEMP_32_FRAME_ID (0x95b8c25u)
#define VEHICLE_RT_IR_TEMP_TEMP_31_FRAME_ID (0x95b8b25u)
#define VEHICLE_RT_IR_TEMP_TEMP_30_FRAME_ID (0x95b8a25u)
#define VEHICLE_RT_IR_TEMP_TEMP_29_FRAME_ID (0x95b8925u)
#define VEHICLE_RT_IR_TEMP_TEMP_28_FRAME_ID (0x95b8825u)
#define VEHICLE_RT_IR_TEMP_TEMP_27_FRAME_ID (0x95b8725u)
#define VEHICLE_RT_IR_TEMP_TEMP_26_FRAME_ID (0x95b8625u)
#define VEHICLE_RT_IR_TEMP_TEMP_25_FRAME_ID (0x95b8525u)
#define VEHICLE_RT_IR_TEMP_TEMP_24_FRAME_ID (0x95b8425u)
#define VEHICLE_RT_IR_TEMP_TEMP_22_FRAME_ID (0x95b8225u)
#define VEHICLE_RT_IR_TEMP_TEMP_23_FRAME_ID (0x95b8325u)
#define VEHICLE_RT_IR_TEMP_TEMP_21_FRAME_ID (0x95b8125u)
#define VEHICLE_RT_IR_TEMP_TEMP_20_FRAME_ID (0x95b8025u)
#define VEHICLE_RT_IR_TEMP_TEMP_19_FRAME_ID (0x95b7f25u)
#define VEHICLE_RT_IR_TEMP_TEMP_18_FRAME_ID (0x95b7e25u)
#define VEHICLE_RT_IR_TEMP_TEMP_16_FRAME_ID (0x95b7c25u)
#define VEHICLE_RT_IR_TEMP_TEMP_15_FRAME_ID (0x95b7b25u)
#define VEHICLE_RT_IR_TEMP_TEMP_14_FRAME_ID (0x95b7a25u)
#define VEHICLE_RT_IR_TEMP_TEMP_13_FRAME_ID (0x95b7925u)
#define VEHICLE_RT_IR_TEMP_TEMP_12_FRAME_ID (0x95b7825u)
#define VEHICLE_RT_IR_TEMP_TEMP_11_FRAME_ID (0x95b7725u)
#define VEHICLE_RT_IR_TEMP_TEMP_10_FRAME_ID (0x95b7625u)
#define VEHICLE_RT_IR_TEMP_TEMP_8_FRAME_ID (0x95b7425u)
#define VEHICLE_RT_IR_TEMP_TEMP_9_FRAME_ID (0x95b7525u)
#define VEHICLE_RT_IR_TEMP_TEMP_17_FRAME_ID (0x95b7d25u)
#define VEHICLE_RT_IR_TEMP_TEMP_6_FRAME_ID (0x95b7225u)
#define VEHICLE_RT_IR_TEMP_TEMP_5_FRAME_ID (0x95b7125u)
#define VEHICLE_RT_IR_TEMP_TEMP_4_FRAME_ID (0x95b7025u)
#define VEHICLE_RT_IR_TEMP_TEMP_3_FRAME_ID (0x95b6f25u)
#define VEHICLE_RT_IR_TEMP_TEMP_2_FRAME_ID (0x95b6e25u)
#define VEHICLE_RT_IR_TEMP_TEMP_1_FRAME_ID (0x95b6d25u)
#define VEHICLE_RT_SB_TRIG_FINAL_CONDITION_FRAME_ID (0x9577322u)
#define VEHICLE_RT_SB_TRIG_INITIAL_CONDITION_FRAME_ID (0x9577222u)
#define VEHICLE_RT_SB_TRIG_DIRECT_DIST_FRAME_ID (0x9577122u)
#define VEHICLE_RT_SB_TRIG_FORWARD_DIST_FRAME_ID (0x9577022u)
#define VEHICLE_RT_SB_TRIG_PATH_DIST_FRAME_ID (0x9576f22u)
#define VEHICLE_RT_SB_TRIG_ACCEL_FRAME_ID (0x9576e22u)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_12_FRAME_ID (0x9607824u)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_11_FRAME_ID (0x9607724u)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_10_FRAME_ID (0x9607624u)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_9_FRAME_ID (0x9607524u)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_8_FRAME_ID (0x9607424u)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_7_FRAME_ID (0x9607324u)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_6_FRAME_ID (0x9607224u)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_5_FRAME_ID (0x9607124u)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_4_FRAME_ID (0x9607024u)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_3_FRAME_ID (0x9606f24u)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_2_FRAME_ID (0x9606e24u)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_1_FRAME_ID (0x9606d24u)
#define VEHICLE_RT_DL1_MK3_RPM_FRAME_ID (0x95f7824u)
#define VEHICLE_RT_DL1_MK3_FREQ_4_FRAME_ID (0x95f7724u)
#define VEHICLE_RT_DL1_MK3_FREQ_3_FRAME_ID (0x95f7624u)
#define VEHICLE_RT_DL1_MK3_FREQ_2_FRAME_ID (0x95f7524u)
#define VEHICLE_RT_DL1_MK3_MISC_3_FRAME_ID (0x9616f24u)
#define VEHICLE_RT_DL1_MK3_MISC_2_FRAME_ID (0x9616e24u)
#define VEHICLE_RT_DL1_MK3_MISC_1_FRAME_ID (0x9616d24u)
#define VEHICLE_RT_DL1_MK3_AUX_31_FRAME_ID (0x95e8b24u)
#define VEHICLE_RT_DL1_MK3_AUX_30_FRAME_ID (0x95e8a24u)
#define VEHICLE_RT_DL1_MK3_AUX_29_FRAME_ID (0x95e8924u)
#define VEHICLE_RT_DL1_MK3_AUX_28_FRAME_ID (0x95e8824u)
#define VEHICLE_RT_DL1_MK3_AUX_27_FRAME_ID (0x95e8724u)
#define VEHICLE_RT_DL1_MK3_AUX_26_FRAME_ID (0x95e8624u)
#define VEHICLE_RT_DL1_MK3_AUX_25_FRAME_ID (0x95e8524u)
#define VEHICLE_RT_DL1_MK3_AUX_24_FRAME_ID (0x95e8424u)
#define VEHICLE_RT_DL1_MK3_AUX_23_FRAME_ID (0x95e8324u)
#define VEHICLE_RT_DL1_MK3_AUX_22_FRAME_ID (0x95e8224u)
#define VEHICLE_RT_DL1_MK3_AUX_21_FRAME_ID (0x95e8124u)
#define VEHICLE_RT_DL1_MK3_AUX_20_FRAME_ID (0x95e8024u)
#define VEHICLE_RT_DL1_MK3_AUX_19_FRAME_ID (0x95e7f24u)
#define VEHICLE_RT_DL1_MK3_AUX_18_FRAME_ID (0x95e7e24u)
#define VEHICLE_RT_DL1_MK3_AUX_17_FRAME_ID (0x95e7d24u)
#define VEHICLE_RT_DL1_MK3_AUX_16_FRAME_ID (0x95e7c24u)
#define VEHICLE_RT_DL1_MK3_AUX_15_FRAME_ID (0x95e7b24u)
#define VEHICLE_RT_DL1_MK3_AUX_14_FRAME_ID (0x95e7a24u)
#define VEHICLE_RT_DL1_MK3_AUX_13_FRAME_ID (0x95e7924u)
#define VEHICLE_RT_DL1_MK3_AUX_12_FRAME_ID (0x95e7824u)
#define VEHICLE_RT_DL1_MK3_AUX_11_FRAME_ID (0x95e7724u)
#define VEHICLE_RT_DL1_MK3_AUX_9_FRAME_ID (0x95e7524u)
#define VEHICLE_RT_DL1_MK3_AUX_10_FRAME_ID (0x95e7624u)
#define VEHICLE_RT_DL1_MK3_AUX_8_FRAME_ID (0x95e7424u)
#define VEHICLE_RT_DL1_MK3_AUX_7_FRAME_ID (0x95e7324u)
#define VEHICLE_RT_DL1_MK3_AUX_6_FRAME_ID (0x95e7224u)
#define VEHICLE_RT_DL1_MK3_AUX_5_FRAME_ID (0x95e7124u)
#define VEHICLE_RT_DL1_MK3_AUX_4_FRAME_ID (0x95e7024u)
#define VEHICLE_RT_DL1_MK3_AUX_3_FRAME_ID (0x95e6f24u)
#define VEHICLE_RT_DL1_MK3_AUX_2_FRAME_ID (0x95e6e24u)
#define VEHICLE_RT_DL1_MK3_AUX_1_FRAME_ID (0x95e6d24u)
#define VEHICLE_RT_DL1_MK3_PRESSURE_5_FRAME_ID (0x95a7124u)
#define VEHICLE_RT_DL1_MK3_PRESSURE_4_FRAME_ID (0x95a7024u)
#define VEHICLE_RT_DL1_MK3_PRESSURE_3_FRAME_ID (0x95a6f24u)
#define VEHICLE_RT_DL1_MK3_PRESSURE_2_FRAME_ID (0x95a6e24u)
#define VEHICLE_RT_DL1_MK3_PRESSURE_1_FRAME_ID (0x95a6d24u)
#define VEHICLE_RT_DL1_MK3_ANGLE_3_FRAME_ID (0x95c6f24u)
#define VEHICLE_RT_DL1_MK3_ANGLE_2_FRAME_ID (0x95c6e24u)
#define VEHICLE_RT_DL1_MK3_ANGLE_1_FRAME_ID (0x95c6d24u)
#define VEHICLE_RT_DL1_MK3_TEMP_25_FRAME_ID (0x95b8524u)
#define VEHICLE_RT_DL1_MK3_TEMP_24_FRAME_ID (0x95b8424u)
#define VEHICLE_RT_DL1_MK3_TEMP_23_FRAME_ID (0x95b8324u)
#define VEHICLE_RT_DL1_MK3_TEMP_22_FRAME_ID (0x95b8224u)
#define VEHICLE_RT_DL1_MK3_TEMP_21_FRAME_ID (0x95b8124u)
#define VEHICLE_RT_DL1_MK3_TEMP_20_FRAME_ID (0x95b8024u)
#define VEHICLE_RT_DL1_MK3_TEMP_19_FRAME_ID (0x95b7f24u)
#define VEHICLE_RT_DL1_MK3_TEMP_18_FRAME_ID (0x95b7e24u)
#define VEHICLE_RT_DL1_MK3_TEMP_17_FRAME_ID (0x95b7d24u)
#define VEHICLE_RT_DL1_MK3_TEMP_16_FRAME_ID (0x95b7c24u)
#define VEHICLE_RT_DL1_MK3_TEMP_15_FRAME_ID (0x95b7b24u)
#define VEHICLE_RT_DL1_MK3_TEMP_14_FRAME_ID (0x95b7a24u)
#define VEHICLE_RT_DL1_MK3_TEMP_13_FRAME_ID (0x95b7924u)
#define VEHICLE_RT_DL1_MK3_TEMP_12_FRAME_ID (0x95b7824u)
#define VEHICLE_RT_DL1_MK3_TEMP_11_FRAME_ID (0x95b7724u)
#define VEHICLE_RT_DL1_MK3_TEMP_10_FRAME_ID (0x95b7624u)
#define VEHICLE_RT_DL1_MK3_TEMP_9_FRAME_ID (0x95b7524u)
#define VEHICLE_RT_DL1_MK3_TEMP_8_FRAME_ID (0x95b7424u)
#define VEHICLE_RT_DL1_MK3_TEMP_7_FRAME_ID (0x95b7324u)
#define VEHICLE_RT_DL1_MK3_TEMP_6_FRAME_ID (0x95b7224u)
#define VEHICLE_RT_DL1_MK3_TEMP_5_FRAME_ID (0x95b7124u)
#define VEHICLE_RT_DL1_MK3_TEMP_4_FRAME_ID (0x95b7024u)
#define VEHICLE_RT_DL1_MK3_TEMP_3_FRAME_ID (0x95b6f24u)
#define VEHICLE_RT_DL1_MK3_TEMP_2_FRAME_ID (0x95b6e24u)
#define VEHICLE_RT_DL1_MK3_TEMP_1_FRAME_ID (0x95b6d24u)
#define VEHICLE_RT_DL1_MK3_ANALOG_32_FRAME_ID (0x94c8b24u)
#define VEHICLE_RT_DL1_MK3_ANALOG_31_FRAME_ID (0x94c8a24u)
#define VEHICLE_RT_DL1_MK3_ANALOG_30_FRAME_ID (0x94c8924u)
#define VEHICLE_RT_DL1_MK3_ANALOG_29_FRAME_ID (0x94c8824u)
#define VEHICLE_RT_DL1_MK3_ANALOG_28_FRAME_ID (0x94c8724u)
#define VEHICLE_RT_DL1_MK3_ANALOG_27_FRAME_ID (0x94c8624u)
#define VEHICLE_RT_DL1_MK3_ANALOG_26_FRAME_ID (0x94c8524u)
#define VEHICLE_RT_DL1_MK3_ANALOG_25_FRAME_ID (0x94c8424u)
#define VEHICLE_RT_DL1_MK3_ANALOG_15_FRAME_ID (0x94c7a24u)
#define VEHICLE_RT_DL1_MK3_ANALOG_14_FRAME_ID (0x94c7924u)
#define VEHICLE_RT_DL1_MK3_ANALOG_17_FRAME_ID (0x94c7c24u)
#define VEHICLE_RT_DL1_MK3_ANALOG_24_FRAME_ID (0x94c8324u)
#define VEHICLE_RT_DL1_MK3_ANALOG_23_FRAME_ID (0x94c8224u)
#define VEHICLE_RT_DL1_MK3_ANALOG_22_FRAME_ID (0x94c8124u)
#define VEHICLE_RT_DL1_MK3_ANALOG_21_FRAME_ID (0x94c8024u)
#define VEHICLE_RT_DL1_MK3_ANALOG_20_FRAME_ID (0x94c7f24u)
#define VEHICLE_RT_DL1_MK3_ANALOG_19_FRAME_ID (0x94c7e24u)
#define VEHICLE_RT_DL1_MK3_ANALOG_16_FRAME_ID (0x94c7b24u)
#define VEHICLE_RT_DL1_MK3_ANALOG_18_FRAME_ID (0x94c7d24u)
#define VEHICLE_RT_DL1_MK3_ANALOG_12_FRAME_ID (0x94c7724u)
#define VEHICLE_RT_DL1_MK3_ANALOG_11_FRAME_ID (0x94c7624u)
#define VEHICLE_RT_DL1_MK3_ANALOG_10_FRAME_ID (0x94c7524u)
#define VEHICLE_RT_DL1_MK3_ANALOG_9_FRAME_ID (0x94c7424u)
#define VEHICLE_RT_DL1_MK3_ANALOG_8_FRAME_ID (0x94c7324u)
#define VEHICLE_RT_DL1_MK3_ANALOG_7_FRAME_ID (0x94c7224u)
#define VEHICLE_RT_DL1_MK3_ANALOG_6_FRAME_ID (0x94c7124u)
#define VEHICLE_RT_DL1_MK3_ANALOG_5_FRAME_ID (0x94c7024u)
#define VEHICLE_RT_DL1_MK3_ANALOG_4_FRAME_ID (0x94c6f24u)
#define VEHICLE_RT_DL1_MK3_ANALOG_3_FRAME_ID (0x94c6e24u)
#define VEHICLE_RT_DL1_MK3_ANALOG_2_FRAME_ID (0x94c6d24u)
#define VEHICLE_RT_DL1_MK3_ANALOG_1_FRAME_ID (0x94c6c24u)
#define VEHICLE_RT_DL1_MK3_ACCEL_FRAME_ID (0x94a6c24u)
#define VEHICLE_RT_SB_INS_VPT_4_VEL_NED_2_FRAME_ID (0x9599e22u)
#define VEHICLE_RT_SB_INS_VPT_4_VEL_NED_1_FRAME_ID (0x9599d22u)
#define VEHICLE_RT_SB_INS_VPT_4_OFFSET_FRAME_ID (0x9599c22u)
#define VEHICLE_RT_SB_INS_VPT_3_VEL_NED_2_FRAME_ID (0x9598e22u)
#define VEHICLE_RT_SB_INS_VPT_3_VEL_NED_1_FRAME_ID (0x9598d22u)
#define VEHICLE_RT_SB_INS_VPT_3_OFFSET_FRAME_ID (0x9598c22u)
#define VEHICLE_RT_SB_INS_VPT_2_VEL_NED_2_FRAME_ID (0x9597e22u)
#define VEHICLE_RT_SB_INS_VPT_2_VEL_NED_1_FRAME_ID (0x9597d22u)
#define VEHICLE_RT_SB_INS_VPT_2_OFFSET_FRAME_ID (0x9597c22u)
#define VEHICLE_RT_SB_INS_VPT_1_VEL_NED_2_FRAME_ID (0x9596e22u)
#define VEHICLE_RT_SB_INS_VPT_1_VEL_NED_1_FRAME_ID (0x9596d22u)
#define VEHICLE_RT_SB_INS_VPT_1_OFFSET_FRAME_ID (0x9596c22u)
#define VEHICLE_RT_SB_INS_SLIP_FRAME_ID (0x9588222u)
#define VEHICLE_RT_SB_INS_VEL_ECEF_2_FRAME_ID (0x9587f22u)
#define VEHICLE_RT_SB_INS_VEL_ECEF_1_FRAME_ID (0x9587e22u)
#define VEHICLE_RT_SB_INS_VEL_NED_2_FRAME_ID (0x9587d22u)
#define VEHICLE_RT_SB_INS_VEL_NED_1_FRAME_ID (0x9587c22u)
#define VEHICLE_RT_SB_INS_POS_ECEF_2_FRAME_ID (0x9587122u)
#define VEHICLE_RT_SB_INS_POS_ECEF_1_FRAME_ID (0x9587022u)
#define VEHICLE_RT_SB_INS_POS_LLH_2_FRAME_ID (0x9586f22u)
#define VEHICLE_RT_SB_INS_POS_LLH_1_FRAME_ID (0x9586e22u)
#define VEHICLE_RT_SB_INS_HEADING_GRADIENT_2_FRAME_ID (0x9588122u)
#define VEHICLE_RT_SB_INS_HEADING_GRADIENT_FRAME_ID (0x9588022u)
#define VEHICLE_RT_SB_INS_STATUS_FRAME_ID (0x9586c22u)
#define VEHICLE_RT_SB_INS_ATTITUDE_FRAME_ID (0x9586d22u)
#define VEHICLE_RT_SB_OUTPUT_STATUS_FRAME_ID (0x9576d22u)
#define VEHICLE_RT_SB_GPS_HEADING_GRADIENT_2_FRAME_ID (0x9568222u)
#define VEHICLE_RT_SB_CUMULATIVE_DISTANCE_2_FRAME_ID (0x94a8d22u)
#define VEHICLE_RT_SB_CUMULATIVE_DISTANCE_1_FRAME_ID (0x94a8c22u)
#define VEHICLE_RT_SB_TRIGGER_TIMESTAMP_FRAME_ID (0x9576c22u)
#define VEHICLE_RT_IMU06_GYRO_RATES_FRAME_ID (0x94a6d21u)
#define VEHICLE_RT_IMU06_ACCEL_FRAME_ID (0x94a6c21u)
#define VEHICLE_RT_SB_SPEED_FRAME_ID (0x94a7c22u)
#define VEHICLE_RT_SB_RTK_SLIP_FRAME_ID (0x9568d22u)
#define VEHICLE_RT_SB_RTK_ATTITUDE_FRAME_ID (0x9568c22u)
#define VEHICLE_RT_SB_GPS_MCYCLE_LEAN_FRAME_ID (0x9569c22u)
#define VEHICLE_RT_SB_GPS_STATUS_FRAME_ID (0x9566c22u)
#define VEHICLE_RT_SB_GPS_POS_ECEF_2_FRAME_ID (0x9567122u)
#define VEHICLE_RT_SB_GPS_POS_ECEF_1_FRAME_ID (0x9567022u)
#define VEHICLE_RT_SB_GPS_POS_LLH_2_FRAME_ID (0x9566f22u)
#define VEHICLE_RT_SB_GPS_POS_LLH_1_FRAME_ID (0x9566e22u)
#define VEHICLE_RT_SB_GPS_HEADING_GRADIENT_FRAME_ID (0x9568122u)
#define VEHICLE_RT_SB_GPS_VEL_ECEF_2_FRAME_ID (0x9568022u)
#define VEHICLE_RT_SB_GPS_VEL_ECEF_1_FRAME_ID (0x9567f22u)
#define VEHICLE_RT_SB_GPS_VEL_NED_2_FRAME_ID (0x9567e22u)
#define VEHICLE_RT_SB_GPS_VEL_NED_1_FRAME_ID (0x9567d22u)
#define VEHICLE_RT_SB_GPS_SPEED_FRAME_ID (0x9567c22u)
#define VEHICLE_RT_SB_GPS_TIME_FRAME_ID (0x9566d22u)
#define VEHICLE_RT_SB_ACCEL_FRAME_ID (0x94a6c22u)
#define VEHICLE_RT_SB_GYRO_RATES_FRAME_ID (0x94a6d22u)

/* Frame lengths in bytes. */
#define VEHICLE_RT_SB_INS_VEL_BODY_AXES_LENGTH (8u)
#define VEHICLE_RT_DL1_MK3_SPEED_LENGTH (8u)
#define VEHICLE_RT_DL1_MK3_GPS_TIME_LENGTH (8u)
#define VEHICLE_RT_DL1_MK3_GPS_POS_LLH_2_LENGTH (8u)
#define VEHICLE_RT_DL1_MK3_GPS_POS_LLH_1_LENGTH (8u)
#define VEHICLE_RT_DL1_MK3_GPS_SPEED_LENGTH (8u)
#define VEHICLE_RT_IR_TEMP_TEMP_7_LENGTH (2u)
#define VEHICLE_RT_IR_TEMP_TEMP_RR_2_LENGTH (8u)
#define VEHICLE_RT_IR_TEMP_TEMP_RL_2_LENGTH (8u)
#define VEHICLE_RT_IR_TEMP_TEMP_FR_2_LENGTH (8u)
#define VEHICLE_RT_IR_TEMP_TEMP_FL_2_LENGTH (8u)
#define VEHICLE_RT_IR_TEMP_TEMP_RR_1_LENGTH (8u)
#define VEHICLE_RT_IR_TEMP_TEMP_RL_1_LENGTH (8u)
#define VEHICLE_RT_IR_TEMP_TEMP_FR_1_LENGTH (8u)
#define VEHICLE_RT_IR_TEMP_TEMP_FL_1_LENGTH (8u)
#define VEHICLE_RT_IR_TEMP_TEMP_32_LENGTH (2u)
#define VEHICLE_RT_IR_TEMP_TEMP_31_LENGTH (2u)
#define VEHICLE_RT_IR_TEMP_TEMP_30_LENGTH (2u)
#define VEHICLE_RT_IR_TEMP_TEMP_29_LENGTH (2u)
#define VEHICLE_RT_IR_TEMP_TEMP_28_LENGTH (2u)
#define VEHICLE_RT_IR_TEMP_TEMP_27_LENGTH (2u)
#define VEHICLE_RT_IR_TEMP_TEMP_26_LENGTH (2u)
#define VEHICLE_RT_IR_TEMP_TEMP_25_LENGTH (2u)
#define VEHICLE_RT_IR_TEMP_TEMP_24_LENGTH (2u)
#define VEHICLE_RT_IR_TEMP_TEMP_22_LENGTH (2u)
#define VEHICLE_RT_IR_TEMP_TEMP_23_LENGTH (2u)
#define VEHICLE_RT_IR_TEMP_TEMP_21_LENGTH (2u)
#define VEHICLE_RT_IR_TEMP_TEMP_20_LENGTH (2u)
#define VEHICLE_RT_IR_TEMP_TEMP_19_LENGTH (2u)
#define VEHICLE_RT_IR_TEMP_TEMP_18_LENGTH (2u)
#define VEHICLE_RT_IR_TEMP_TEMP_16_LENGTH (2u)
#define VEHICLE_RT_IR_TEMP_TEMP_15_LENGTH (2u)
#define VEHICLE_RT_IR_TEMP_TEMP_14_LENGTH (2u)
#define VEHICLE_RT_IR_TEMP_TEMP_13_LENGTH (2u)
#define VEHICLE_RT_IR_TEMP_TEMP_12_LENGTH (2u)
#define VEHICLE_RT_IR_TEMP_TEMP_11_LENGTH (2u)
#define VEHICLE_RT_IR_TEMP_TEMP_10_LENGTH (2u)
#define VEHICLE_RT_IR_TEMP_TEMP_8_LENGTH (2u)
#define VEHICLE_RT_IR_TEMP_TEMP_9_LENGTH (2u)
#define VEHICLE_RT_IR_TEMP_TEMP_17_LENGTH (2u)
#define VEHICLE_RT_IR_TEMP_TEMP_6_LENGTH (2u)
#define VEHICLE_RT_IR_TEMP_TEMP_5_LENGTH (2u)
#define VEHICLE_RT_IR_TEMP_TEMP_4_LENGTH (2u)
#define VEHICLE_RT_IR_TEMP_TEMP_3_LENGTH (2u)
#define VEHICLE_RT_IR_TEMP_TEMP_2_LENGTH (2u)
#define VEHICLE_RT_IR_TEMP_TEMP_1_LENGTH (2u)
#define VEHICLE_RT_SB_TRIG_FINAL_CONDITION_LENGTH (8u)
#define VEHICLE_RT_SB_TRIG_INITIAL_CONDITION_LENGTH (8u)
#define VEHICLE_RT_SB_TRIG_DIRECT_DIST_LENGTH (8u)
#define VEHICLE_RT_SB_TRIG_FORWARD_DIST_LENGTH (8u)
#define VEHICLE_RT_SB_TRIG_PATH_DIST_LENGTH (8u)
#define VEHICLE_RT_SB_TRIG_ACCEL_LENGTH (8u)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_12_LENGTH (3u)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_11_LENGTH (3u)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_10_LENGTH (3u)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_9_LENGTH (3u)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_8_LENGTH (3u)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_7_LENGTH (3u)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_6_LENGTH (3u)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_5_LENGTH (3u)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_4_LENGTH (3u)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_3_LENGTH (3u)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_2_LENGTH (3u)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_1_LENGTH (3u)
#define VEHICLE_RT_DL1_MK3_RPM_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_FREQ_4_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_FREQ_3_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_FREQ_2_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_MISC_3_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_MISC_2_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_MISC_1_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_AUX_31_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_AUX_30_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_AUX_29_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_AUX_28_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_AUX_27_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_AUX_26_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_AUX_25_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_AUX_24_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_AUX_23_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_AUX_22_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_AUX_21_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_AUX_20_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_AUX_19_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_AUX_18_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_AUX_17_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_AUX_16_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_AUX_15_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_AUX_14_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_AUX_13_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_AUX_12_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_AUX_11_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_AUX_9_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_AUX_10_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_AUX_8_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_AUX_7_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_AUX_6_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_AUX_5_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_AUX_4_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_AUX_3_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_AUX_2_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_AUX_1_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_PRESSURE_5_LENGTH (3u)
#define VEHICLE_RT_DL1_MK3_PRESSURE_4_LENGTH (3u)
#define VEHICLE_RT_DL1_MK3_PRESSURE_3_LENGTH (3u)
#define VEHICLE_RT_DL1_MK3_PRESSURE_2_LENGTH (3u)
#define VEHICLE_RT_DL1_MK3_PRESSURE_1_LENGTH (3u)
#define VEHICLE_RT_DL1_MK3_ANGLE_3_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_ANGLE_2_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_ANGLE_1_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_TEMP_25_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_TEMP_24_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_TEMP_23_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_TEMP_22_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_TEMP_21_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_TEMP_20_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_TEMP_19_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_TEMP_18_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_TEMP_17_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_TEMP_16_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_TEMP_15_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_TEMP_14_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_TEMP_13_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_TEMP_12_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_TEMP_11_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_TEMP_10_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_TEMP_9_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_TEMP_8_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_TEMP_7_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_TEMP_6_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_TEMP_5_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_TEMP_4_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_TEMP_3_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_TEMP_2_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_TEMP_1_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_ANALOG_32_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_ANALOG_31_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_ANALOG_30_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_ANALOG_29_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_ANALOG_28_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_ANALOG_27_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_ANALOG_26_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_ANALOG_25_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_ANALOG_15_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_ANALOG_14_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_ANALOG_17_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_ANALOG_24_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_ANALOG_23_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_ANALOG_22_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_ANALOG_21_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_ANALOG_20_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_ANALOG_19_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_ANALOG_16_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_ANALOG_18_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_ANALOG_12_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_ANALOG_11_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_ANALOG_10_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_ANALOG_9_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_ANALOG_8_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_ANALOG_7_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_ANALOG_6_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_ANALOG_5_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_ANALOG_4_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_ANALOG_3_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_ANALOG_2_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_ANALOG_1_LENGTH (2u)
#define VEHICLE_RT_DL1_MK3_ACCEL_LENGTH (8u)
#define VEHICLE_RT_SB_INS_VPT_4_VEL_NED_2_LENGTH (8u)
#define VEHICLE_RT_SB_INS_VPT_4_VEL_NED_1_LENGTH (8u)
#define VEHICLE_RT_SB_INS_VPT_4_OFFSET_LENGTH (8u)
#define VEHICLE_RT_SB_INS_VPT_3_VEL_NED_2_LENGTH (8u)
#define VEHICLE_RT_SB_INS_VPT_3_VEL_NED_1_LENGTH (8u)
#define VEHICLE_RT_SB_INS_VPT_3_OFFSET_LENGTH (8u)
#define VEHICLE_RT_SB_INS_VPT_2_VEL_NED_2_LENGTH (8u)
#define VEHICLE_RT_SB_INS_VPT_2_VEL_NED_1_LENGTH (8u)
#define VEHICLE_RT_SB_INS_VPT_2_OFFSET_LENGTH (8u)
#define VEHICLE_RT_SB_INS_VPT_1_VEL_NED_2_LENGTH (8u)
#define VEHICLE_RT_SB_INS_VPT_1_VEL_NED_1_LENGTH (8u)
#define VEHICLE_RT_SB_INS_VPT_1_OFFSET_LENGTH (8u)
#define VEHICLE_RT_SB_INS_SLIP_LENGTH (8u)
#define VEHICLE_RT_SB_INS_VEL_ECEF_2_LENGTH (8u)
#define VEHICLE_RT_SB_INS_VEL_ECEF_1_LENGTH (8u)
#define VEHICLE_RT_SB_INS_VEL_NED_2_LENGTH (8u)
#define VEHICLE_RT_SB_INS_VEL_NED_1_LENGTH (8u)
#define VEHICLE_RT_SB_INS_POS_ECEF_2_LENGTH (8u)
#define VEHICLE_RT_SB_INS_POS_ECEF_1_LENGTH (8u)
#define VEHICLE_RT_SB_INS_POS_LLH_2_LENGTH (8u)
#define VEHICLE_RT_SB_INS_POS_LLH_1_LENGTH (8u)
#define VEHICLE_RT_SB_INS_HEADING_GRADIENT_2_LENGTH (8u)
#define VEHICLE_RT_SB_INS_HEADING_GRADIENT_LENGTH (8u)
#define VEHICLE_RT_SB_INS_STATUS_LENGTH (8u)
#define VEHICLE_RT_SB_INS_ATTITUDE_LENGTH (8u)
#define VEHICLE_RT_SB_OUTPUT_STATUS_LENGTH (8u)
#define VEHICLE_RT_SB_GPS_HEADING_GRADIENT_2_LENGTH (8u)
#define VEHICLE_RT_SB_CUMULATIVE_DISTANCE_2_LENGTH (8u)
#define VEHICLE_RT_SB_CUMULATIVE_DISTANCE_1_LENGTH (8u)
#define VEHICLE_RT_SB_TRIGGER_TIMESTAMP_LENGTH (8u)
#define VEHICLE_RT_IMU06_GYRO_RATES_LENGTH (8u)
#define VEHICLE_RT_IMU06_ACCEL_LENGTH (8u)
#define VEHICLE_RT_SB_SPEED_LENGTH (8u)
#define VEHICLE_RT_SB_RTK_SLIP_LENGTH (8u)
#define VEHICLE_RT_SB_RTK_ATTITUDE_LENGTH (8u)
#define VEHICLE_RT_SB_GPS_MCYCLE_LEAN_LENGTH (8u)
#define VEHICLE_RT_SB_GPS_STATUS_LENGTH (8u)
#define VEHICLE_RT_SB_GPS_POS_ECEF_2_LENGTH (8u)
#define VEHICLE_RT_SB_GPS_POS_ECEF_1_LENGTH (8u)
#define VEHICLE_RT_SB_GPS_POS_LLH_2_LENGTH (8u)
#define VEHICLE_RT_SB_GPS_POS_LLH_1_LENGTH (8u)
#define VEHICLE_RT_SB_GPS_HEADING_GRADIENT_LENGTH (8u)
#define VEHICLE_RT_SB_GPS_VEL_ECEF_2_LENGTH (8u)
#define VEHICLE_RT_SB_GPS_VEL_ECEF_1_LENGTH (8u)
#define VEHICLE_RT_SB_GPS_VEL_NED_2_LENGTH (8u)
#define VEHICLE_RT_SB_GPS_VEL_NED_1_LENGTH (8u)
#define VEHICLE_RT_SB_GPS_SPEED_LENGTH (8u)
#define VEHICLE_RT_SB_GPS_TIME_LENGTH (8u)
#define VEHICLE_RT_SB_ACCEL_LENGTH (8u)
#define VEHICLE_RT_SB_GYRO_RATES_LENGTH (8u)

/* Extended or standard frame types. */
#define VEHICLE_RT_SB_INS_VEL_BODY_AXES_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_SPEED_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_GPS_TIME_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_GPS_POS_LLH_2_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_GPS_POS_LLH_1_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_GPS_SPEED_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_7_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_RR_2_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_RL_2_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_FR_2_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_FL_2_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_RR_1_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_RL_1_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_FR_1_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_FL_1_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_32_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_31_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_30_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_29_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_28_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_27_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_26_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_25_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_24_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_22_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_23_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_21_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_20_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_19_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_18_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_16_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_15_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_14_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_13_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_12_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_11_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_10_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_8_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_9_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_17_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_6_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_5_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_4_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_3_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_2_IS_EXTENDED (1)
#define VEHICLE_RT_IR_TEMP_TEMP_1_IS_EXTENDED (1)
#define VEHICLE_RT_SB_TRIG_FINAL_CONDITION_IS_EXTENDED (1)
#define VEHICLE_RT_SB_TRIG_INITIAL_CONDITION_IS_EXTENDED (1)
#define VEHICLE_RT_SB_TRIG_DIRECT_DIST_IS_EXTENDED (1)
#define VEHICLE_RT_SB_TRIG_FORWARD_DIST_IS_EXTENDED (1)
#define VEHICLE_RT_SB_TRIG_PATH_DIST_IS_EXTENDED (1)
#define VEHICLE_RT_SB_TRIG_ACCEL_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_12_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_11_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_10_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_9_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_8_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_7_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_6_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_5_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_4_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_3_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_2_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_1_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_RPM_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_FREQ_4_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_FREQ_3_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_FREQ_2_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_MISC_3_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_MISC_2_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_MISC_1_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_AUX_31_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_AUX_30_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_AUX_29_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_AUX_28_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_AUX_27_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_AUX_26_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_AUX_25_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_AUX_24_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_AUX_23_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_AUX_22_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_AUX_21_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_AUX_20_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_AUX_19_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_AUX_18_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_AUX_17_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_AUX_16_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_AUX_15_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_AUX_14_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_AUX_13_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_AUX_12_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_AUX_11_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_AUX_9_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_AUX_10_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_AUX_8_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_AUX_7_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_AUX_6_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_AUX_5_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_AUX_4_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_AUX_3_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_AUX_2_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_AUX_1_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_PRESSURE_5_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_PRESSURE_4_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_PRESSURE_3_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_PRESSURE_2_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_PRESSURE_1_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ANGLE_3_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ANGLE_2_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ANGLE_1_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_TEMP_25_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_TEMP_24_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_TEMP_23_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_TEMP_22_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_TEMP_21_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_TEMP_20_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_TEMP_19_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_TEMP_18_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_TEMP_17_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_TEMP_16_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_TEMP_15_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_TEMP_14_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_TEMP_13_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_TEMP_12_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_TEMP_11_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_TEMP_10_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_TEMP_9_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_TEMP_8_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_TEMP_7_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_TEMP_6_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_TEMP_5_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_TEMP_4_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_TEMP_3_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_TEMP_2_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_TEMP_1_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ANALOG_32_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ANALOG_31_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ANALOG_30_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ANALOG_29_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ANALOG_28_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ANALOG_27_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ANALOG_26_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ANALOG_25_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ANALOG_15_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ANALOG_14_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ANALOG_17_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ANALOG_24_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ANALOG_23_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ANALOG_22_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ANALOG_21_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ANALOG_20_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ANALOG_19_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ANALOG_16_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ANALOG_18_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ANALOG_12_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ANALOG_11_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ANALOG_10_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ANALOG_9_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ANALOG_8_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ANALOG_7_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ANALOG_6_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ANALOG_5_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ANALOG_4_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ANALOG_3_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ANALOG_2_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ANALOG_1_IS_EXTENDED (1)
#define VEHICLE_RT_DL1_MK3_ACCEL_IS_EXTENDED (1)
#define VEHICLE_RT_SB_INS_VPT_4_VEL_NED_2_IS_EXTENDED (1)
#define VEHICLE_RT_SB_INS_VPT_4_VEL_NED_1_IS_EXTENDED (1)
#define VEHICLE_RT_SB_INS_VPT_4_OFFSET_IS_EXTENDED (1)
#define VEHICLE_RT_SB_INS_VPT_3_VEL_NED_2_IS_EXTENDED (1)
#define VEHICLE_RT_SB_INS_VPT_3_VEL_NED_1_IS_EXTENDED (1)
#define VEHICLE_RT_SB_INS_VPT_3_OFFSET_IS_EXTENDED (1)
#define VEHICLE_RT_SB_INS_VPT_2_VEL_NED_2_IS_EXTENDED (1)
#define VEHICLE_RT_SB_INS_VPT_2_VEL_NED_1_IS_EXTENDED (1)
#define VEHICLE_RT_SB_INS_VPT_2_OFFSET_IS_EXTENDED (1)
#define VEHICLE_RT_SB_INS_VPT_1_VEL_NED_2_IS_EXTENDED (1)
#define VEHICLE_RT_SB_INS_VPT_1_VEL_NED_1_IS_EXTENDED (1)
#define VEHICLE_RT_SB_INS_VPT_1_OFFSET_IS_EXTENDED (1)
#define VEHICLE_RT_SB_INS_SLIP_IS_EXTENDED (1)
#define VEHICLE_RT_SB_INS_VEL_ECEF_2_IS_EXTENDED (1)
#define VEHICLE_RT_SB_INS_VEL_ECEF_1_IS_EXTENDED (1)
#define VEHICLE_RT_SB_INS_VEL_NED_2_IS_EXTENDED (1)
#define VEHICLE_RT_SB_INS_VEL_NED_1_IS_EXTENDED (1)
#define VEHICLE_RT_SB_INS_POS_ECEF_2_IS_EXTENDED (1)
#define VEHICLE_RT_SB_INS_POS_ECEF_1_IS_EXTENDED (1)
#define VEHICLE_RT_SB_INS_POS_LLH_2_IS_EXTENDED (1)
#define VEHICLE_RT_SB_INS_POS_LLH_1_IS_EXTENDED (1)
#define VEHICLE_RT_SB_INS_HEADING_GRADIENT_2_IS_EXTENDED (1)
#define VEHICLE_RT_SB_INS_HEADING_GRADIENT_IS_EXTENDED (1)
#define VEHICLE_RT_SB_INS_STATUS_IS_EXTENDED (1)
#define VEHICLE_RT_SB_INS_ATTITUDE_IS_EXTENDED (1)
#define VEHICLE_RT_SB_OUTPUT_STATUS_IS_EXTENDED (1)
#define VEHICLE_RT_SB_GPS_HEADING_GRADIENT_2_IS_EXTENDED (1)
#define VEHICLE_RT_SB_CUMULATIVE_DISTANCE_2_IS_EXTENDED (1)
#define VEHICLE_RT_SB_CUMULATIVE_DISTANCE_1_IS_EXTENDED (1)
#define VEHICLE_RT_SB_TRIGGER_TIMESTAMP_IS_EXTENDED (1)
#define VEHICLE_RT_IMU06_GYRO_RATES_IS_EXTENDED (1)
#define VEHICLE_RT_IMU06_ACCEL_IS_EXTENDED (1)
#define VEHICLE_RT_SB_SPEED_IS_EXTENDED (1)
#define VEHICLE_RT_SB_RTK_SLIP_IS_EXTENDED (1)
#define VEHICLE_RT_SB_RTK_ATTITUDE_IS_EXTENDED (1)
#define VEHICLE_RT_SB_GPS_MCYCLE_LEAN_IS_EXTENDED (1)
#define VEHICLE_RT_SB_GPS_STATUS_IS_EXTENDED (1)
#define VEHICLE_RT_SB_GPS_POS_ECEF_2_IS_EXTENDED (1)
#define VEHICLE_RT_SB_GPS_POS_ECEF_1_IS_EXTENDED (1)
#define VEHICLE_RT_SB_GPS_POS_LLH_2_IS_EXTENDED (1)
#define VEHICLE_RT_SB_GPS_POS_LLH_1_IS_EXTENDED (1)
#define VEHICLE_RT_SB_GPS_HEADING_GRADIENT_IS_EXTENDED (1)
#define VEHICLE_RT_SB_GPS_VEL_ECEF_2_IS_EXTENDED (1)
#define VEHICLE_RT_SB_GPS_VEL_ECEF_1_IS_EXTENDED (1)
#define VEHICLE_RT_SB_GPS_VEL_NED_2_IS_EXTENDED (1)
#define VEHICLE_RT_SB_GPS_VEL_NED_1_IS_EXTENDED (1)
#define VEHICLE_RT_SB_GPS_SPEED_IS_EXTENDED (1)
#define VEHICLE_RT_SB_GPS_TIME_IS_EXTENDED (1)
#define VEHICLE_RT_SB_ACCEL_IS_EXTENDED (1)
#define VEHICLE_RT_SB_GYRO_RATES_IS_EXTENDED (1)

/* Frame cycle times in milliseconds. */


/* Signal choices. */
#define VEHICLE_RT_SB_INS_STATUS_INS_STATUS_UNINITIALISED_CHOICE (0u)
#define VEHICLE_RT_SB_INS_STATUS_INS_STATUS_INITIALISED_CHOICE (1u)
#define VEHICLE_RT_SB_INS_STATUS_INS_STATUS_CONVERGED_CHOICE (2u)

#define VEHICLE_RT_SB_INS_ATTITUDE_VALIDITY_YAW_INVALID_CHOICE (0u)
#define VEHICLE_RT_SB_INS_ATTITUDE_VALIDITY_YAW_VALID_CHOICE (1u)

#define VEHICLE_RT_SB_INS_ATTITUDE_VALIDITY_PITCH_INVALID_CHOICE (0u)
#define VEHICLE_RT_SB_INS_ATTITUDE_VALIDITY_PITCH_VALID_CHOICE (1u)

#define VEHICLE_RT_SB_INS_ATTITUDE_VALIDITY_ROLL_INVALID_CHOICE (0u)
#define VEHICLE_RT_SB_INS_ATTITUDE_VALIDITY_ROLL_VALID_CHOICE (1u)

#define VEHICLE_RT_SB_OUTPUT_STATUS_STATUS_ANALOGUE_1_INACTIVE_CHOICE (0u)
#define VEHICLE_RT_SB_OUTPUT_STATUS_STATUS_ANALOGUE_1_ACTIVE_CHOICE (1u)

#define VEHICLE_RT_SB_OUTPUT_STATUS_STATUS_ANALOGUE_2_INACTIVE_CHOICE (0u)
#define VEHICLE_RT_SB_OUTPUT_STATUS_STATUS_ANALOGUE_2_ACTIVE_CHOICE (1u)

#define VEHICLE_RT_SB_OUTPUT_STATUS_STATUS_ANALOGUE_3_INACTIVE_CHOICE (0u)
#define VEHICLE_RT_SB_OUTPUT_STATUS_STATUS_ANALOGUE_3_ACTIVE_CHOICE (1u)

#define VEHICLE_RT_SB_OUTPUT_STATUS_STATUS_ANALOGUE_4_INACTIVE_CHOICE (0u)
#define VEHICLE_RT_SB_OUTPUT_STATUS_STATUS_ANALOGUE_4_ACTIVE_CHOICE (1u)

#define VEHICLE_RT_SB_OUTPUT_STATUS_STATUS_PULSE_OUTPUT_INACTIVE_CHOICE (0u)
#define VEHICLE_RT_SB_OUTPUT_STATUS_STATUS_PULSE_OUTPUT_ACTIVE_CHOICE (1u)

#define VEHICLE_RT_SB_OUTPUT_STATUS_STATUS_SERIAL_OUTPUT_1_INACTIVE_CHOICE (0u)
#define VEHICLE_RT_SB_OUTPUT_STATUS_STATUS_SERIAL_OUTPUT_1_ACTIVE_CHOICE (1u)

#define VEHICLE_RT_SB_OUTPUT_STATUS_STATUS_SERIAL_OUTPUT_2_INACTIVE_CHOICE (0u)
#define VEHICLE_RT_SB_OUTPUT_STATUS_STATUS_SERIAL_OUTPUT_2_ACTIVE_CHOICE (1u)

#define VEHICLE_RT_SB_OUTPUT_STATUS_STATUS_TRIGGER_INACTIVE_CHOICE (0u)
#define VEHICLE_RT_SB_OUTPUT_STATUS_STATUS_TRIGGER_ACTIVE_CHOICE (1u)

#define VEHICLE_RT_SB_TRIGGER_TIMESTAMP_TRIGGER_TIMESTAMP_TYPE_FALLING_EDGE_CHOICE (0u)
#define VEHICLE_RT_SB_TRIGGER_TIMESTAMP_TRIGGER_TIMESTAMP_TYPE_RISING_EDGE_CHOICE (1u)

#define VEHICLE_RT_SB_GPS_STATUS_GPS_STATUS_GPS_MODULE_NOT_DETECTED_CHOICE (0u)
#define VEHICLE_RT_SB_GPS_STATUS_GPS_STATUS_SEARCHING_FOR_SATELLITES_CHOICE (1u)
#define VEHICLE_RT_SB_GPS_STATUS_GPS_STATUS_INSUFFICIENT_SATELLITES_CHOICE (2u)
#define VEHICLE_RT_SB_GPS_STATUS_GPS_STATUS_SOLUTION_ABORTED_CHOICE (3u)
#define VEHICLE_RT_SB_GPS_STATUS_GPS_STATUS_SOLUTION_FAILED_CHOICE (4u)
#define VEHICLE_RT_SB_GPS_STATUS_GPS_STATUS_EXCEEDED_MAX__SPEED_OR_ALT__CHOICE (5u)
#define VEHICLE_RT_SB_GPS_STATUS_GPS_STATUS_UNUSED_6_CHOICE (6u)
#define VEHICLE_RT_SB_GPS_STATUS_GPS_STATUS_UNUSED_7_CHOICE (7u)
#define VEHICLE_RT_SB_GPS_STATUS_GPS_STATUS_UNUSED_8_CHOICE (8u)
#define VEHICLE_RT_SB_GPS_STATUS_GPS_STATUS_UNUSED_9_CHOICE (9u)
#define VEHICLE_RT_SB_GPS_STATUS_GPS_STATUS_LOCK___POSITION_BUT_NO_SPEED_CHOICE (10u)
#define VEHICLE_RT_SB_GPS_STATUS_GPS_STATUS_LOCK___DOPPLER_SPEED_AND_POSITION_CHOICE (11u)
#define VEHICLE_RT_SB_GPS_STATUS_GPS_STATUS_LOCK___CARRIER_SPEED_AND_POSITION_CHOICE (12u)

#define VEHICLE_RT_SB_GPS_STATUS_RTK_STATUS_NOT_ATTEMPTING_RTK_SOLUTION_CHOICE (0u)
#define VEHICLE_RT_SB_GPS_STATUS_RTK_STATUS_NOT_ENOUGH_COMMON_SATELLITES_CHOICE (1u)
#define VEHICLE_RT_SB_GPS_STATUS_RTK_STATUS_RTK_SOLUTION_FAILED_CHOICE (2u)
#define VEHICLE_RT_SB_GPS_STATUS_RTK_STATUS_RTK_SOLUTION_OK_CHOICE (3u)
#define VEHICLE_RT_SB_GPS_STATUS_RTK_STATUS_MULTIPLE_RTK_SOLUTIONS_FOUND_CHOICE (4u)

/* Frame Names. */
#define VEHICLE_RT_SB_INS_VEL_BODY_AXES_NAME "RT_SB_INS_Vel_Body_Axes"
#define VEHICLE_RT_DL1_MK3_SPEED_NAME "RT_DL1MK3_Speed"
#define VEHICLE_RT_DL1_MK3_GPS_TIME_NAME "RT_DL1MK3_GPS_Time"
#define VEHICLE_RT_DL1_MK3_GPS_POS_LLH_2_NAME "RT_DL1MK3_GPS_Pos_LLH_2"
#define VEHICLE_RT_DL1_MK3_GPS_POS_LLH_1_NAME "RT_DL1MK3_GPS_Pos_LLH_1"
#define VEHICLE_RT_DL1_MK3_GPS_SPEED_NAME "RT_DL1MK3_GPS_Speed"
#define VEHICLE_RT_IR_TEMP_TEMP_7_NAME "RT_IRTemp_Temp_7"
#define VEHICLE_RT_IR_TEMP_TEMP_RR_2_NAME "RT_IRTemp_Temp_RR_2"
#define VEHICLE_RT_IR_TEMP_TEMP_RL_2_NAME "RT_IRTemp_Temp_RL_2"
#define VEHICLE_RT_IR_TEMP_TEMP_FR_2_NAME "RT_IRTemp_Temp_FR_2"
#define VEHICLE_RT_IR_TEMP_TEMP_FL_2_NAME "RT_IRTemp_Temp_FL_2"
#define VEHICLE_RT_IR_TEMP_TEMP_RR_1_NAME "RT_IRTemp_Temp_RR_1"
#define VEHICLE_RT_IR_TEMP_TEMP_RL_1_NAME "RT_IRTemp_Temp_RL_1"
#define VEHICLE_RT_IR_TEMP_TEMP_FR_1_NAME "RT_IRTemp_Temp_FR_1"
#define VEHICLE_RT_IR_TEMP_TEMP_FL_1_NAME "RT_IRTemp_Temp_FL_1"
#define VEHICLE_RT_IR_TEMP_TEMP_32_NAME "RT_IRTemp_Temp_32"
#define VEHICLE_RT_IR_TEMP_TEMP_31_NAME "RT_IRTemp_Temp_31"
#define VEHICLE_RT_IR_TEMP_TEMP_30_NAME "RT_IRTemp_Temp_30"
#define VEHICLE_RT_IR_TEMP_TEMP_29_NAME "RT_IRTemp_Temp_29"
#define VEHICLE_RT_IR_TEMP_TEMP_28_NAME "RT_IRTemp_Temp_28"
#define VEHICLE_RT_IR_TEMP_TEMP_27_NAME "RT_IRTemp_Temp_27"
#define VEHICLE_RT_IR_TEMP_TEMP_26_NAME "RT_IRTemp_Temp_26"
#define VEHICLE_RT_IR_TEMP_TEMP_25_NAME "RT_IRTemp_Temp_25"
#define VEHICLE_RT_IR_TEMP_TEMP_24_NAME "RT_IRTemp_Temp_24"
#define VEHICLE_RT_IR_TEMP_TEMP_22_NAME "RT_IRTemp_Temp_22"
#define VEHICLE_RT_IR_TEMP_TEMP_23_NAME "RT_IRTemp_Temp_23"
#define VEHICLE_RT_IR_TEMP_TEMP_21_NAME "RT_IRTemp_Temp_21"
#define VEHICLE_RT_IR_TEMP_TEMP_20_NAME "RT_IRTemp_Temp_20"
#define VEHICLE_RT_IR_TEMP_TEMP_19_NAME "RT_IRTemp_Temp_19"
#define VEHICLE_RT_IR_TEMP_TEMP_18_NAME "RT_IRTemp_Temp_18"
#define VEHICLE_RT_IR_TEMP_TEMP_16_NAME "RT_IRTemp_Temp_16"
#define VEHICLE_RT_IR_TEMP_TEMP_15_NAME "RT_IRTemp_Temp_15"
#define VEHICLE_RT_IR_TEMP_TEMP_14_NAME "RT_IRTemp_Temp_14"
#define VEHICLE_RT_IR_TEMP_TEMP_13_NAME "RT_IRTemp_Temp_13"
#define VEHICLE_RT_IR_TEMP_TEMP_12_NAME "RT_IRTemp_Temp_12"
#define VEHICLE_RT_IR_TEMP_TEMP_11_NAME "RT_IRTemp_Temp_11"
#define VEHICLE_RT_IR_TEMP_TEMP_10_NAME "RT_IRTemp_Temp_10"
#define VEHICLE_RT_IR_TEMP_TEMP_8_NAME "RT_IRTemp_Temp_8"
#define VEHICLE_RT_IR_TEMP_TEMP_9_NAME "RT_IRTemp_Temp_9"
#define VEHICLE_RT_IR_TEMP_TEMP_17_NAME "RT_IRTemp_Temp_17"
#define VEHICLE_RT_IR_TEMP_TEMP_6_NAME "RT_IRTemp_Temp_6"
#define VEHICLE_RT_IR_TEMP_TEMP_5_NAME "RT_IRTemp_Temp_5"
#define VEHICLE_RT_IR_TEMP_TEMP_4_NAME "RT_IRTemp_Temp_4"
#define VEHICLE_RT_IR_TEMP_TEMP_3_NAME "RT_IRTemp_Temp_3"
#define VEHICLE_RT_IR_TEMP_TEMP_2_NAME "RT_IRTemp_Temp_2"
#define VEHICLE_RT_IR_TEMP_TEMP_1_NAME "RT_IRTemp_Temp_1"
#define VEHICLE_RT_SB_TRIG_FINAL_CONDITION_NAME "RT_SB_Trig_Final_Condition"
#define VEHICLE_RT_SB_TRIG_INITIAL_CONDITION_NAME "RT_SB_Trig_Initial_Condition"
#define VEHICLE_RT_SB_TRIG_DIRECT_DIST_NAME "RT_SB_Trig_Direct_Dist"
#define VEHICLE_RT_SB_TRIG_FORWARD_DIST_NAME "RT_SB_Trig_Forward_Dist"
#define VEHICLE_RT_SB_TRIG_PATH_DIST_NAME "RT_SB_Trig_Path_Dist"
#define VEHICLE_RT_SB_TRIG_ACCEL_NAME "RT_SB_Trig_Accel"
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_12_NAME "RT_DL1MK3_Measure_Time_12"
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_11_NAME "RT_DL1MK3_Measure_Time_11"
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_10_NAME "RT_DL1MK3_Measure_Time_10"
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_9_NAME "RT_DL1MK3_Measure_Time_9"
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_8_NAME "RT_DL1MK3_Measure_Time_8"
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_7_NAME "RT_DL1MK3_Measure_Time_7"
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_6_NAME "RT_DL1MK3_Measure_Time_6"
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_5_NAME "RT_DL1MK3_Measure_Time_5"
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_4_NAME "RT_DL1MK3_Measure_Time_4"
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_3_NAME "RT_DL1MK3_Measure_Time_3"
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_2_NAME "RT_DL1MK3_Measure_Time_2"
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_1_NAME "RT_DL1MK3_Measure_Time_1"
#define VEHICLE_RT_DL1_MK3_RPM_NAME "RT_DL1MK3_RPM"
#define VEHICLE_RT_DL1_MK3_FREQ_4_NAME "RT_DL1MK3_Freq_4"
#define VEHICLE_RT_DL1_MK3_FREQ_3_NAME "RT_DL1MK3_Freq_3"
#define VEHICLE_RT_DL1_MK3_FREQ_2_NAME "RT_DL1MK3_Freq_2"
#define VEHICLE_RT_DL1_MK3_MISC_3_NAME "RT_DL1MK3_Misc_3"
#define VEHICLE_RT_DL1_MK3_MISC_2_NAME "RT_DL1MK3_Misc_2"
#define VEHICLE_RT_DL1_MK3_MISC_1_NAME "RT_DL1MK3_Misc_1"
#define VEHICLE_RT_DL1_MK3_AUX_31_NAME "RT_DL1MK3_Aux_31"
#define VEHICLE_RT_DL1_MK3_AUX_30_NAME "RT_DL1MK3_Aux_30"
#define VEHICLE_RT_DL1_MK3_AUX_29_NAME "RT_DL1MK3_Aux_29"
#define VEHICLE_RT_DL1_MK3_AUX_28_NAME "RT_DL1MK3_Aux_28"
#define VEHICLE_RT_DL1_MK3_AUX_27_NAME "RT_DL1MK3_Aux_27"
#define VEHICLE_RT_DL1_MK3_AUX_26_NAME "RT_DL1MK3_Aux_26"
#define VEHICLE_RT_DL1_MK3_AUX_25_NAME "RT_DL1MK3_Aux_25"
#define VEHICLE_RT_DL1_MK3_AUX_24_NAME "RT_DL1MK3_Aux_24"
#define VEHICLE_RT_DL1_MK3_AUX_23_NAME "RT_DL1MK3_Aux_23"
#define VEHICLE_RT_DL1_MK3_AUX_22_NAME "RT_DL1MK3_Aux_22"
#define VEHICLE_RT_DL1_MK3_AUX_21_NAME "RT_DL1MK3_Aux_21"
#define VEHICLE_RT_DL1_MK3_AUX_20_NAME "RT_DL1MK3_Aux_20"
#define VEHICLE_RT_DL1_MK3_AUX_19_NAME "RT_DL1MK3_Aux_19"
#define VEHICLE_RT_DL1_MK3_AUX_18_NAME "RT_DL1MK3_Aux_18"
#define VEHICLE_RT_DL1_MK3_AUX_17_NAME "RT_DL1MK3_Aux_17"
#define VEHICLE_RT_DL1_MK3_AUX_16_NAME "RT_DL1MK3_Aux_16"
#define VEHICLE_RT_DL1_MK3_AUX_15_NAME "RT_DL1MK3_Aux_15"
#define VEHICLE_RT_DL1_MK3_AUX_14_NAME "RT_DL1MK3_Aux_14"
#define VEHICLE_RT_DL1_MK3_AUX_13_NAME "RT_DL1MK3_Aux_13"
#define VEHICLE_RT_DL1_MK3_AUX_12_NAME "RT_DL1MK3_Aux_12"
#define VEHICLE_RT_DL1_MK3_AUX_11_NAME "RT_DL1MK3_Aux_11"
#define VEHICLE_RT_DL1_MK3_AUX_9_NAME "RT_DL1MK3_Aux_9"
#define VEHICLE_RT_DL1_MK3_AUX_10_NAME "RT_DL1MK3_Aux_10"
#define VEHICLE_RT_DL1_MK3_AUX_8_NAME "RT_DL1MK3_Aux_8"
#define VEHICLE_RT_DL1_MK3_AUX_7_NAME "RT_DL1MK3_Aux_7"
#define VEHICLE_RT_DL1_MK3_AUX_6_NAME "RT_DL1MK3_Aux_6"
#define VEHICLE_RT_DL1_MK3_AUX_5_NAME "RT_DL1MK3_Aux_5"
#define VEHICLE_RT_DL1_MK3_AUX_4_NAME "RT_DL1MK3_Aux_4"
#define VEHICLE_RT_DL1_MK3_AUX_3_NAME "RT_DL1MK3_Aux_3"
#define VEHICLE_RT_DL1_MK3_AUX_2_NAME "RT_DL1MK3_Aux_2"
#define VEHICLE_RT_DL1_MK3_AUX_1_NAME "RT_DL1MK3_Aux_1"
#define VEHICLE_RT_DL1_MK3_PRESSURE_5_NAME "RT_DL1MK3_Pressure_5"
#define VEHICLE_RT_DL1_MK3_PRESSURE_4_NAME "RT_DL1MK3_Pressure_4"
#define VEHICLE_RT_DL1_MK3_PRESSURE_3_NAME "RT_DL1MK3_Pressure_3"
#define VEHICLE_RT_DL1_MK3_PRESSURE_2_NAME "RT_DL1MK3_Pressure_2"
#define VEHICLE_RT_DL1_MK3_PRESSURE_1_NAME "RT_DL1MK3_Pressure_1"
#define VEHICLE_RT_DL1_MK3_ANGLE_3_NAME "RT_DL1MK3_Angle_3"
#define VEHICLE_RT_DL1_MK3_ANGLE_2_NAME "RT_DL1MK3_Angle_2"
#define VEHICLE_RT_DL1_MK3_ANGLE_1_NAME "RT_DL1MK3_Angle_1"
#define VEHICLE_RT_DL1_MK3_TEMP_25_NAME "RT_DL1MK3_Temp_25"
#define VEHICLE_RT_DL1_MK3_TEMP_24_NAME "RT_DL1MK3_Temp_24"
#define VEHICLE_RT_DL1_MK3_TEMP_23_NAME "RT_DL1MK3_Temp_23"
#define VEHICLE_RT_DL1_MK3_TEMP_22_NAME "RT_DL1MK3_Temp_22"
#define VEHICLE_RT_DL1_MK3_TEMP_21_NAME "RT_DL1MK3_Temp_21"
#define VEHICLE_RT_DL1_MK3_TEMP_20_NAME "RT_DL1MK3_Temp_20"
#define VEHICLE_RT_DL1_MK3_TEMP_19_NAME "RT_DL1MK3_Temp_19"
#define VEHICLE_RT_DL1_MK3_TEMP_18_NAME "RT_DL1MK3_Temp_18"
#define VEHICLE_RT_DL1_MK3_TEMP_17_NAME "RT_DL1MK3_Temp_17"
#define VEHICLE_RT_DL1_MK3_TEMP_16_NAME "RT_DL1MK3_Temp_16"
#define VEHICLE_RT_DL1_MK3_TEMP_15_NAME "RT_DL1MK3_Temp_15"
#define VEHICLE_RT_DL1_MK3_TEMP_14_NAME "RT_DL1MK3_Temp_14"
#define VEHICLE_RT_DL1_MK3_TEMP_13_NAME "RT_DL1MK3_Temp_13"
#define VEHICLE_RT_DL1_MK3_TEMP_12_NAME "RT_DL1MK3_Temp_12"
#define VEHICLE_RT_DL1_MK3_TEMP_11_NAME "RT_DL1MK3_Temp_11"
#define VEHICLE_RT_DL1_MK3_TEMP_10_NAME "RT_DL1MK3_Temp_10"
#define VEHICLE_RT_DL1_MK3_TEMP_9_NAME "RT_DL1MK3_Temp_9"
#define VEHICLE_RT_DL1_MK3_TEMP_8_NAME "RT_DL1MK3_Temp_8"
#define VEHICLE_RT_DL1_MK3_TEMP_7_NAME "RT_DL1MK3_Temp_7"
#define VEHICLE_RT_DL1_MK3_TEMP_6_NAME "RT_DL1MK3_Temp_6"
#define VEHICLE_RT_DL1_MK3_TEMP_5_NAME "RT_DL1MK3_Temp_5"
#define VEHICLE_RT_DL1_MK3_TEMP_4_NAME "RT_DL1MK3_Temp_4"
#define VEHICLE_RT_DL1_MK3_TEMP_3_NAME "RT_DL1MK3_Temp_3"
#define VEHICLE_RT_DL1_MK3_TEMP_2_NAME "RT_DL1MK3_Temp_2"
#define VEHICLE_RT_DL1_MK3_TEMP_1_NAME "RT_DL1MK3_Temp_1"
#define VEHICLE_RT_DL1_MK3_ANALOG_32_NAME "RT_DL1MK3_Analog_32"
#define VEHICLE_RT_DL1_MK3_ANALOG_31_NAME "RT_DL1MK3_Analog_31"
#define VEHICLE_RT_DL1_MK3_ANALOG_30_NAME "RT_DL1MK3_Analog_30"
#define VEHICLE_RT_DL1_MK3_ANALOG_29_NAME "RT_DL1MK3_Analog_29"
#define VEHICLE_RT_DL1_MK3_ANALOG_28_NAME "RT_DL1MK3_Analog_28"
#define VEHICLE_RT_DL1_MK3_ANALOG_27_NAME "RT_DL1MK3_Analog_27"
#define VEHICLE_RT_DL1_MK3_ANALOG_26_NAME "RT_DL1MK3_Analog_26"
#define VEHICLE_RT_DL1_MK3_ANALOG_25_NAME "RT_DL1MK3_Analog_25"
#define VEHICLE_RT_DL1_MK3_ANALOG_15_NAME "RT_DL1MK3_Analog_15"
#define VEHICLE_RT_DL1_MK3_ANALOG_14_NAME "RT_DL1MK3_Analog_14"
#define VEHICLE_RT_DL1_MK3_ANALOG_17_NAME "RT_DL1MK3_Analog_17"
#define VEHICLE_RT_DL1_MK3_ANALOG_24_NAME "RT_DL1MK3_Analog_24"
#define VEHICLE_RT_DL1_MK3_ANALOG_23_NAME "RT_DL1MK3_Analog_23"
#define VEHICLE_RT_DL1_MK3_ANALOG_22_NAME "RT_DL1MK3_Analog_22"
#define VEHICLE_RT_DL1_MK3_ANALOG_21_NAME "RT_DL1MK3_Analog_21"
#define VEHICLE_RT_DL1_MK3_ANALOG_20_NAME "RT_DL1MK3_Analog_20"
#define VEHICLE_RT_DL1_MK3_ANALOG_19_NAME "RT_DL1MK3_Analog_19"
#define VEHICLE_RT_DL1_MK3_ANALOG_16_NAME "RT_DL1MK3_Analog_16"
#define VEHICLE_RT_DL1_MK3_ANALOG_18_NAME "RT_DL1MK3_Analog_18"
#define VEHICLE_RT_DL1_MK3_ANALOG_12_NAME "RT_DL1MK3_Analog_12"
#define VEHICLE_RT_DL1_MK3_ANALOG_11_NAME "RT_DL1MK3_Analog_11"
#define VEHICLE_RT_DL1_MK3_ANALOG_10_NAME "RT_DL1MK3_Analog_10"
#define VEHICLE_RT_DL1_MK3_ANALOG_9_NAME "RT_DL1MK3_Analog_9"
#define VEHICLE_RT_DL1_MK3_ANALOG_8_NAME "RT_DL1MK3_Analog_8"
#define VEHICLE_RT_DL1_MK3_ANALOG_7_NAME "RT_DL1MK3_Analog_7"
#define VEHICLE_RT_DL1_MK3_ANALOG_6_NAME "RT_DL1MK3_Analog_6"
#define VEHICLE_RT_DL1_MK3_ANALOG_5_NAME "RT_DL1MK3_Analog_5"
#define VEHICLE_RT_DL1_MK3_ANALOG_4_NAME "RT_DL1MK3_Analog_4"
#define VEHICLE_RT_DL1_MK3_ANALOG_3_NAME "RT_DL1MK3_Analog_3"
#define VEHICLE_RT_DL1_MK3_ANALOG_2_NAME "RT_DL1MK3_Analog_2"
#define VEHICLE_RT_DL1_MK3_ANALOG_1_NAME "RT_DL1MK3_Analog_1"
#define VEHICLE_RT_DL1_MK3_ACCEL_NAME "RT_DL1MK3_Accel"
#define VEHICLE_RT_SB_INS_VPT_4_VEL_NED_2_NAME "RT_SB_INS_Vpt_4_Vel_NED_2"
#define VEHICLE_RT_SB_INS_VPT_4_VEL_NED_1_NAME "RT_SB_INS_Vpt_4_Vel_NED_1"
#define VEHICLE_RT_SB_INS_VPT_4_OFFSET_NAME "RT_SB_INS_Vpt_4_Offset"
#define VEHICLE_RT_SB_INS_VPT_3_VEL_NED_2_NAME "RT_SB_INS_Vpt_3_Vel_NED_2"
#define VEHICLE_RT_SB_INS_VPT_3_VEL_NED_1_NAME "RT_SB_INS_Vpt_3_Vel_NED_1"
#define VEHICLE_RT_SB_INS_VPT_3_OFFSET_NAME "RT_SB_INS_Vpt_3_Offset"
#define VEHICLE_RT_SB_INS_VPT_2_VEL_NED_2_NAME "RT_SB_INS_Vpt_2_Vel_NED_2"
#define VEHICLE_RT_SB_INS_VPT_2_VEL_NED_1_NAME "RT_SB_INS_Vpt_2_Vel_NED_1"
#define VEHICLE_RT_SB_INS_VPT_2_OFFSET_NAME "RT_SB_INS_Vpt_2_Offset"
#define VEHICLE_RT_SB_INS_VPT_1_VEL_NED_2_NAME "RT_SB_INS_Vpt_1_Vel_NED_2"
#define VEHICLE_RT_SB_INS_VPT_1_VEL_NED_1_NAME "RT_SB_INS_Vpt_1_Vel_NED_1"
#define VEHICLE_RT_SB_INS_VPT_1_OFFSET_NAME "RT_SB_INS_Vpt_1_Offset"
#define VEHICLE_RT_SB_INS_SLIP_NAME "RT_SB_INS_Slip"
#define VEHICLE_RT_SB_INS_VEL_ECEF_2_NAME "RT_SB_INS_Vel_ECEF_2"
#define VEHICLE_RT_SB_INS_VEL_ECEF_1_NAME "RT_SB_INS_Vel_ECEF_1"
#define VEHICLE_RT_SB_INS_VEL_NED_2_NAME "RT_SB_INS_Vel_NED_2"
#define VEHICLE_RT_SB_INS_VEL_NED_1_NAME "RT_SB_INS_Vel_NED_1"
#define VEHICLE_RT_SB_INS_POS_ECEF_2_NAME "RT_SB_INS_Pos_ECEF_2"
#define VEHICLE_RT_SB_INS_POS_ECEF_1_NAME "RT_SB_INS_Pos_ECEF_1"
#define VEHICLE_RT_SB_INS_POS_LLH_2_NAME "RT_SB_INS_Pos_LLH_2"
#define VEHICLE_RT_SB_INS_POS_LLH_1_NAME "RT_SB_INS_Pos_LLH_1"
#define VEHICLE_RT_SB_INS_HEADING_GRADIENT_2_NAME "RT_SB_INS_Heading_Gradient_2"
#define VEHICLE_RT_SB_INS_HEADING_GRADIENT_NAME "RT_SB_INS_Heading_Gradient"
#define VEHICLE_RT_SB_INS_STATUS_NAME "RT_SB_INS_Status"
#define VEHICLE_RT_SB_INS_ATTITUDE_NAME "RT_SB_INS_Attitude"
#define VEHICLE_RT_SB_OUTPUT_STATUS_NAME "RT_SB_Output_Status"
#define VEHICLE_RT_SB_GPS_HEADING_GRADIENT_2_NAME "RT_SB_GPS_Heading_Gradient_2"
#define VEHICLE_RT_SB_CUMULATIVE_DISTANCE_2_NAME "RT_SB_Cumulative_Distance_2"
#define VEHICLE_RT_SB_CUMULATIVE_DISTANCE_1_NAME "RT_SB_Cumulative_Distance_1"
#define VEHICLE_RT_SB_TRIGGER_TIMESTAMP_NAME "RT_SB_Trigger_Timestamp"
#define VEHICLE_RT_IMU06_GYRO_RATES_NAME "RT_IMU06_Gyro_Rates"
#define VEHICLE_RT_IMU06_ACCEL_NAME "RT_IMU06_Accel"
#define VEHICLE_RT_SB_SPEED_NAME "RT_SB_Speed"
#define VEHICLE_RT_SB_RTK_SLIP_NAME "RT_SB_RTK_Slip"
#define VEHICLE_RT_SB_RTK_ATTITUDE_NAME "RT_SB_RTK_Attitude"
#define VEHICLE_RT_SB_GPS_MCYCLE_LEAN_NAME "RT_SB_GPS_Mcycle_Lean"
#define VEHICLE_RT_SB_GPS_STATUS_NAME "RT_SB_GPS_Status"
#define VEHICLE_RT_SB_GPS_POS_ECEF_2_NAME "RT_SB_GPS_Pos_ECEF_2"
#define VEHICLE_RT_SB_GPS_POS_ECEF_1_NAME "RT_SB_GPS_Pos_ECEF_1"
#define VEHICLE_RT_SB_GPS_POS_LLH_2_NAME "RT_SB_GPS_Pos_LLH_2"
#define VEHICLE_RT_SB_GPS_POS_LLH_1_NAME "RT_SB_GPS_Pos_LLH_1"
#define VEHICLE_RT_SB_GPS_HEADING_GRADIENT_NAME "RT_SB_GPS_Heading_Gradient"
#define VEHICLE_RT_SB_GPS_VEL_ECEF_2_NAME "RT_SB_GPS_Vel_ECEF_2"
#define VEHICLE_RT_SB_GPS_VEL_ECEF_1_NAME "RT_SB_GPS_Vel_ECEF_1"
#define VEHICLE_RT_SB_GPS_VEL_NED_2_NAME "RT_SB_GPS_Vel_NED_2"
#define VEHICLE_RT_SB_GPS_VEL_NED_1_NAME "RT_SB_GPS_Vel_NED_1"
#define VEHICLE_RT_SB_GPS_SPEED_NAME "RT_SB_GPS_Speed"
#define VEHICLE_RT_SB_GPS_TIME_NAME "RT_SB_GPS_Time"
#define VEHICLE_RT_SB_ACCEL_NAME "RT_SB_Accel"
#define VEHICLE_RT_SB_GYRO_RATES_NAME "RT_SB_Gyro_Rates"

/* Signal Names. */
#define VEHICLE_RT_SB_INS_VEL_BODY_AXES_VALIDITY_INS_VEL_FORWARDS_NAME "Validity_INS_Vel_Forwards"
#define VEHICLE_RT_SB_INS_VEL_BODY_AXES_VALIDITY_INS_VEL_SIDEWAYS_NAME "Validity_INS_Vel_Sideways"
#define VEHICLE_RT_SB_INS_VEL_BODY_AXES_ACCURACY_INS_VEL_BODY_NAME "Accuracy_INS_Vel_Body"
#define VEHICLE_RT_SB_INS_VEL_BODY_AXES_INS_VEL_FORWARDS_2_D_NAME "INS_Vel_Forwards_2D"
#define VEHICLE_RT_SB_INS_VEL_BODY_AXES_INS_VEL_SIDEWAYS_2_D_NAME "INS_Vel_Sideways_2D"
#define VEHICLE_RT_DL1_MK3_SPEED_VALIDITY_SPEED_NAME "Validity_Speed"
#define VEHICLE_RT_DL1_MK3_SPEED_ACCURACY_SPEED_NAME "Accuracy_Speed"
#define VEHICLE_RT_DL1_MK3_SPEED_SPEED_NAME "Speed"
#define VEHICLE_RT_DL1_MK3_GPS_TIME_VALIDITY_GPS_TIME_NAME "Validity_GPS_Time"
#define VEHICLE_RT_DL1_MK3_GPS_TIME_VALIDITY_GPS_WEEK_NAME "Validity_GPS_Week"
#define VEHICLE_RT_DL1_MK3_GPS_TIME_ACCURACY_GPS_TIME_NAME "Accuracy_GPS_Time"
#define VEHICLE_RT_DL1_MK3_GPS_TIME_GPS_TIME_NAME "GPS_Time"
#define VEHICLE_RT_DL1_MK3_GPS_TIME_GPS_WEEK_NAME "GPS_Week"
#define VEHICLE_RT_DL1_MK3_GPS_POS_LLH_2_GPS_POS_LLH_LONGITUDE_NAME "GPS_Pos_LLH_Longitude"
#define VEHICLE_RT_DL1_MK3_GPS_POS_LLH_2_GPS_POS_LLH_ALTITUDE_NAME "GPS_Pos_LLH_Altitude"
#define VEHICLE_RT_DL1_MK3_GPS_POS_LLH_1_VALIDITY_GPS_POS_LLH_LATITUDE_NAME "Validity_GPS_Pos_LLH_Latitude"
#define VEHICLE_RT_DL1_MK3_GPS_POS_LLH_1_VALIDITY_GPS_POS_LLH_LONGITUDE_NAME "Validity_GPS_Pos_LLH_Longitude"
#define VEHICLE_RT_DL1_MK3_GPS_POS_LLH_1_VALIDITY_GPS_POS_LLH_ALTITUDE_NAME "Validity_GPS_Pos_LLH_Altitude"
#define VEHICLE_RT_DL1_MK3_GPS_POS_LLH_1_ACCURACY_GPS_POS_LLH_LATITUDE_NAME "Accuracy_GPS_Pos_LLH_Latitude"
#define VEHICLE_RT_DL1_MK3_GPS_POS_LLH_1_ACCURACY_GPS_POS_LLH_LONGITUDE_NAME "Accuracy_GPS_Pos_LLH_Longitude"
#define VEHICLE_RT_DL1_MK3_GPS_POS_LLH_1_ACCURACY_GPS_POS_LLH_ALTITUDE_NAME "Accuracy_GPS_Pos_LLH_Altitude"
#define VEHICLE_RT_DL1_MK3_GPS_POS_LLH_1_GPS_POS_LLH_LATITUDE_NAME "GPS_Pos_LLH_Latitude"
#define VEHICLE_RT_DL1_MK3_GPS_SPEED_VALIDITY_GPS_SPEED_2_D_NAME "Validity_GPS_Speed_2D"
#define VEHICLE_RT_DL1_MK3_GPS_SPEED_VALIDITY_GPS_SPEED_3_D_NAME "Validity_GPS_Speed_3D"
#define VEHICLE_RT_DL1_MK3_GPS_SPEED_ACCURACY_GPS_SPEED_NAME "Accuracy_GPS_Speed"
#define VEHICLE_RT_DL1_MK3_GPS_SPEED_GPS_SPEED_2_D_NAME "GPS_Speed_2D"
#define VEHICLE_RT_DL1_MK3_GPS_SPEED_GPS_SPEED_3_D_NAME "GPS_Speed_3D"
#define VEHICLE_RT_IR_TEMP_TEMP_7_IR_TEMPERATURE_7_NAME "IR_Temperature_7"
#define VEHICLE_RT_IR_TEMP_TEMP_RR_2_IR_TEMPERATURE_29_NAME "IR_Temperature_29"
#define VEHICLE_RT_IR_TEMP_TEMP_RR_2_IR_TEMPERATURE_30_NAME "IR_Temperature_30"
#define VEHICLE_RT_IR_TEMP_TEMP_RR_2_IR_TEMPERATURE_31_NAME "IR_Temperature_31"
#define VEHICLE_RT_IR_TEMP_TEMP_RR_2_IR_TEMPERATURE_32_NAME "IR_Temperature_32"
#define VEHICLE_RT_IR_TEMP_TEMP_RL_2_IR_TEMPERATURE_21_NAME "IR_Temperature_21"
#define VEHICLE_RT_IR_TEMP_TEMP_RL_2_IR_TEMPERATURE_22_NAME "IR_Temperature_22"
#define VEHICLE_RT_IR_TEMP_TEMP_RL_2_IR_TEMPERATURE_23_NAME "IR_Temperature_23"
#define VEHICLE_RT_IR_TEMP_TEMP_RL_2_IR_TEMPERATURE_24_NAME "IR_Temperature_24"
#define VEHICLE_RT_IR_TEMP_TEMP_FR_2_IR_TEMPERATURE_13_NAME "IR_Temperature_13"
#define VEHICLE_RT_IR_TEMP_TEMP_FR_2_IR_TEMPERATURE_14_NAME "IR_Temperature_14"
#define VEHICLE_RT_IR_TEMP_TEMP_FR_2_IR_TEMPERATURE_15_NAME "IR_Temperature_15"
#define VEHICLE_RT_IR_TEMP_TEMP_FR_2_IR_TEMPERATURE_16_NAME "IR_Temperature_16"
#define VEHICLE_RT_IR_TEMP_TEMP_FL_2_IR_TEMPERATURE_5_NAME "IR_Temperature_5"
#define VEHICLE_RT_IR_TEMP_TEMP_FL_2_IR_TEMPERATURE_6_NAME "IR_Temperature_6"
#define VEHICLE_RT_IR_TEMP_TEMP_FL_2_IR_TEMPERATURE_7_NAME "IR_Temperature_7"
#define VEHICLE_RT_IR_TEMP_TEMP_FL_2_IR_TEMPERATURE_8_NAME "IR_Temperature_8"
#define VEHICLE_RT_IR_TEMP_TEMP_RR_1_IR_TEMPERATURE_25_NAME "IR_Temperature_25"
#define VEHICLE_RT_IR_TEMP_TEMP_RR_1_IR_TEMPERATURE_26_NAME "IR_Temperature_26"
#define VEHICLE_RT_IR_TEMP_TEMP_RR_1_IR_TEMPERATURE_27_NAME "IR_Temperature_27"
#define VEHICLE_RT_IR_TEMP_TEMP_RR_1_IR_TEMPERATURE_28_NAME "IR_Temperature_28"
#define VEHICLE_RT_IR_TEMP_TEMP_RL_1_IR_TEMPERATURE_17_NAME "IR_Temperature_17"
#define VEHICLE_RT_IR_TEMP_TEMP_RL_1_IR_TEMPERATURE_18_NAME "IR_Temperature_18"
#define VEHICLE_RT_IR_TEMP_TEMP_RL_1_IR_TEMPERATURE_19_NAME "IR_Temperature_19"
#define VEHICLE_RT_IR_TEMP_TEMP_RL_1_IR_TEMPERATURE_20_NAME "IR_Temperature_20"
#define VEHICLE_RT_IR_TEMP_TEMP_FR_1_IR_TEMPERATURE_9_NAME "IR_Temperature_9"
#define VEHICLE_RT_IR_TEMP_TEMP_FR_1_IR_TEMPERATURE_10_NAME "IR_Temperature_10"
#define VEHICLE_RT_IR_TEMP_TEMP_FR_1_IR_TEMPERATURE_11_NAME "IR_Temperature_11"
#define VEHICLE_RT_IR_TEMP_TEMP_FR_1_IR_TEMPERATURE_12_NAME "IR_Temperature_12"
#define VEHICLE_RT_IR_TEMP_TEMP_FL_1_IR_TEMPERATURE_1_NAME "IR_Temperature_1"
#define VEHICLE_RT_IR_TEMP_TEMP_FL_1_IR_TEMPERATURE_2_NAME "IR_Temperature_2"
#define VEHICLE_RT_IR_TEMP_TEMP_FL_1_IR_TEMPERATURE_3_NAME "IR_Temperature_3"
#define VEHICLE_RT_IR_TEMP_TEMP_FL_1_IR_TEMPERATURE_4_NAME "IR_Temperature_4"
#define VEHICLE_RT_IR_TEMP_TEMP_32_IR_TEMPERATURE_32_NAME "IR_Temperature_32"
#define VEHICLE_RT_IR_TEMP_TEMP_31_IR_TEMPERATURE_31_NAME "IR_Temperature_31"
#define VEHICLE_RT_IR_TEMP_TEMP_30_IR_TEMPERATURE_30_NAME "IR_Temperature_30"
#define VEHICLE_RT_IR_TEMP_TEMP_29_IR_TEMPERATURE_29_NAME "IR_Temperature_29"
#define VEHICLE_RT_IR_TEMP_TEMP_28_IR_TEMPERATURE_28_NAME "IR_Temperature_28"
#define VEHICLE_RT_IR_TEMP_TEMP_27_IR_TEMPERATURE_27_NAME "IR_Temperature_27"
#define VEHICLE_RT_IR_TEMP_TEMP_26_IR_TEMPERATURE_26_NAME "IR_Temperature_26"
#define VEHICLE_RT_IR_TEMP_TEMP_25_IR_TEMPERATURE_25_NAME "IR_Temperature_25"
#define VEHICLE_RT_IR_TEMP_TEMP_24_IR_TEMPERATURE_24_NAME "IR_Temperature_24"
#define VEHICLE_RT_IR_TEMP_TEMP_22_IR_TEMPERATURE_22_NAME "IR_Temperature_22"
#define VEHICLE_RT_IR_TEMP_TEMP_23_IR_TEMPERATURE_23_NAME "IR_Temperature_23"
#define VEHICLE_RT_IR_TEMP_TEMP_21_IR_TEMPERATURE_21_NAME "IR_Temperature_21"
#define VEHICLE_RT_IR_TEMP_TEMP_20_IR_TEMPERATURE_20_NAME "IR_Temperature_20"
#define VEHICLE_RT_IR_TEMP_TEMP_19_IR_TEMPERATURE_19_NAME "IR_Temperature_19"
#define VEHICLE_RT_IR_TEMP_TEMP_18_IR_TEMPERATURE_18_NAME "IR_Temperature_18"
#define VEHICLE_RT_IR_TEMP_TEMP_16_IR_TEMPERATURE_16_NAME "IR_Temperature_16"
#define VEHICLE_RT_IR_TEMP_TEMP_15_IR_TEMPERATURE_15_NAME "IR_Temperature_15"
#define VEHICLE_RT_IR_TEMP_TEMP_14_IR_TEMPERATURE_14_NAME "IR_Temperature_14"
#define VEHICLE_RT_IR_TEMP_TEMP_13_IR_TEMPERATURE_13_NAME "IR_Temperature_13"
#define VEHICLE_RT_IR_TEMP_TEMP_12_IR_TEMPERATURE_12_NAME "IR_Temperature_12"
#define VEHICLE_RT_IR_TEMP_TEMP_11_IR_TEMPERATURE_11_NAME "IR_Temperature_11"
#define VEHICLE_RT_IR_TEMP_TEMP_10_IR_TEMPERATURE_10_NAME "IR_Temperature_10"
#define VEHICLE_RT_IR_TEMP_TEMP_8_IR_TEMPERATURE_8_NAME "IR_Temperature_8"
#define VEHICLE_RT_IR_TEMP_TEMP_9_IR_TEMPERATURE_9_NAME "IR_Temperature_9"
#define VEHICLE_RT_IR_TEMP_TEMP_17_IR_TEMPERATURE_17_NAME "IR_Temperature_17"
#define VEHICLE_RT_IR_TEMP_TEMP_6_IR_TEMPERATURE_6_NAME "IR_Temperature_6"
#define VEHICLE_RT_IR_TEMP_TEMP_5_IR_TEMPERATURE_5_NAME "IR_Temperature_5"
#define VEHICLE_RT_IR_TEMP_TEMP_4_IR_TEMPERATURE_4_NAME "IR_Temperature_4"
#define VEHICLE_RT_IR_TEMP_TEMP_3_IR_TEMPERATURE_3_NAME "IR_Temperature_3"
#define VEHICLE_RT_IR_TEMP_TEMP_2_IR_TEMPERATURE_2_NAME "IR_Temperature_2"
#define VEHICLE_RT_IR_TEMP_TEMP_1_IR_TEMPERATURE_1_NAME "IR_Temperature_1"
#define VEHICLE_RT_SB_TRIG_FINAL_CONDITION_VALIDITY_FINAL_SPEED_NAME "Validity_Final_Speed"
#define VEHICLE_RT_SB_TRIG_FINAL_CONDITION_FINAL_SPEED_NAME "Final_Speed"
#define VEHICLE_RT_SB_TRIG_INITIAL_CONDITION_VALIDITY_INITIAL_SPEED_NAME "Validity_Initial_Speed"
#define VEHICLE_RT_SB_TRIG_INITIAL_CONDITION_VALIDITY_INITIAL_HEADING_NAME "Validity_Initial_Heading"
#define VEHICLE_RT_SB_TRIG_INITIAL_CONDITION_INITIAL_SPEED_NAME "Initial_Speed"
#define VEHICLE_RT_SB_TRIG_INITIAL_CONDITION_INITIAL_HEADING_NAME "Initial_Heading"
#define VEHICLE_RT_SB_TRIG_INITIAL_CONDITION_MFDD_START_THRESHOLD_NAME "MFDD_Start_Threshold"
#define VEHICLE_RT_SB_TRIG_INITIAL_CONDITION_MFDD_END_THRESHOLD_NAME "MFDD_End_Threshold"
#define VEHICLE_RT_SB_TRIG_DIRECT_DIST_DIRECT_DISTANCE_NAME "Direct_Distance"
#define VEHICLE_RT_SB_TRIG_DIRECT_DIST_PATH_DISTANCE_2_D_NAME "Path_Distance_2D"
#define VEHICLE_RT_SB_TRIG_FORWARD_DIST_FORWARD_DISTANCE_NAME "Forward_Distance"
#define VEHICLE_RT_SB_TRIG_FORWARD_DIST_DEVIATION_DISTANCE_NAME "Deviation_Distance"
#define VEHICLE_RT_SB_TRIG_PATH_DIST_PATH_DISTANCE_3_D_NAME "Path_Distance_3D"
#define VEHICLE_RT_SB_TRIG_ACCEL_VALIDITY_MFDD_NAME "Validity_MFDD"
#define VEHICLE_RT_SB_TRIG_ACCEL_VALIDITY_AVERAGE_ACCEL_NAME "Validity_Average_Accel"
#define VEHICLE_RT_SB_TRIG_ACCEL_VALIDITY_TRIGGERED_TIME_NAME "Validity_Triggered_Time"
#define VEHICLE_RT_SB_TRIG_ACCEL_MFDD_NAME "MFDD"
#define VEHICLE_RT_SB_TRIG_ACCEL_AVERAGE_ACCEL_NAME "Average_Accel"
#define VEHICLE_RT_SB_TRIG_ACCEL_TRIGGERED_TIME_NAME "Triggered_Time"
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_12_MEASURED_TIME_12_NAME "Measured_Time_12"
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_11_MEASURED_TIME_11_NAME "Measured_Time_11"
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_10_MEASURED_TIME_10_NAME "Measured_Time_10"
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_9_MEASURED_TIME_9_NAME "Measured_Time_9"
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_8_MEASURED_TIME_8_NAME "Measured_Time_8"
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_7_MEASURED_TIME_7_NAME "Measured_Time_7"
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_6_MEASURED_TIME_6_NAME "Measured_Time_6"
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_5_MEASURED_TIME_5_NAME "Measured_Time_5"
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_4_MEASURED_TIME_4_NAME "Measured_Time_4"
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_3_MEASURED_TIME_3_NAME "Measured_Time_3"
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_2_MEASURED_TIME_2_NAME "Measured_Time_2"
#define VEHICLE_RT_DL1_MK3_MEASURE_TIME_1_MEASURED_TIME_1_NAME "Measured_Time_1"
#define VEHICLE_RT_DL1_MK3_RPM_RPM_NAME "RPM"
#define VEHICLE_RT_DL1_MK3_FREQ_4_FREQUENCY_4_NAME "Frequency_4"
#define VEHICLE_RT_DL1_MK3_FREQ_3_FREQUENCY_3_NAME "Frequency_3"
#define VEHICLE_RT_DL1_MK3_FREQ_2_FREQUENCY_2_NAME "Frequency_2"
#define VEHICLE_RT_DL1_MK3_MISC_3_MISC_3_NAME "Misc_3"
#define VEHICLE_RT_DL1_MK3_MISC_2_MISC_2_NAME "Misc_2"
#define VEHICLE_RT_DL1_MK3_MISC_1_MISC_1_NAME "Misc_1"
#define VEHICLE_RT_DL1_MK3_AUX_31_AUX_31_NAME "AUX_31"
#define VEHICLE_RT_DL1_MK3_AUX_30_AUX_30_NAME "AUX_30"
#define VEHICLE_RT_DL1_MK3_AUX_29_AUX_29_NAME "AUX_29"
#define VEHICLE_RT_DL1_MK3_AUX_28_AUX_28_NAME "AUX_28"
#define VEHICLE_RT_DL1_MK3_AUX_27_AUX_27_NAME "AUX_27"
#define VEHICLE_RT_DL1_MK3_AUX_26_AUX_26_NAME "AUX_26"
#define VEHICLE_RT_DL1_MK3_AUX_25_AUX_25_NAME "AUX_25"
#define VEHICLE_RT_DL1_MK3_AUX_24_AUX_24_NAME "AUX_24"
#define VEHICLE_RT_DL1_MK3_AUX_23_AUX_23_NAME "AUX_23"
#define VEHICLE_RT_DL1_MK3_AUX_22_AUX_22_NAME "AUX_22"
#define VEHICLE_RT_DL1_MK3_AUX_21_AUX_21_NAME "AUX_21"
#define VEHICLE_RT_DL1_MK3_AUX_20_AUX_20_NAME "AUX_20"
#define VEHICLE_RT_DL1_MK3_AUX_19_AUX_19_NAME "AUX_19"
#define VEHICLE_RT_DL1_MK3_AUX_18_AUX_18_NAME "AUX_18"
#define VEHICLE_RT_DL1_MK3_AUX_17_AUX_17_NAME "AUX_17"
#define VEHICLE_RT_DL1_MK3_AUX_16_AUX_16_NAME "AUX_16"
#define VEHICLE_RT_DL1_MK3_AUX_15_AUX_15_NAME "AUX_15"
#define VEHICLE_RT_DL1_MK3_AUX_14_AUX_14_NAME "AUX_14"
#define VEHICLE_RT_DL1_MK3_AUX_13_AUX_13_NAME "AUX_13"
#define VEHICLE_RT_DL1_MK3_AUX_12_AUX_12_NAME "AUX_12"
#define VEHICLE_RT_DL1_MK3_AUX_11_AUX_11_NAME "AUX_11"
#define VEHICLE_RT_DL1_MK3_AUX_9_AUX_9_NAME "AUX_9"
#define VEHICLE_RT_DL1_MK3_AUX_10_AUX_10_NAME "AUX_10"
#define VEHICLE_RT_DL1_MK3_AUX_8_AUX_8_NAME "AUX_8"
#define VEHICLE_RT_DL1_MK3_AUX_7_AUX_7_NAME "AUX_7"
#define VEHICLE_RT_DL1_MK3_AUX_6_AUX_6_NAME "AUX_6"
#define VEHICLE_RT_DL1_MK3_AUX_5_AUX_5_NAME "AUX_5"
#define VEHICLE_RT_DL1_MK3_AUX_4_AUX_4_NAME "AUX_4"
#define VEHICLE_RT_DL1_MK3_AUX_3_AUX_3_NAME "AUX_3"
#define VEHICLE_RT_DL1_MK3_AUX_2_AUX_2_NAME "AUX_2"
#define VEHICLE_RT_DL1_MK3_AUX_1_AUX_1_NAME "AUX_1"
#define VEHICLE_RT_DL1_MK3_PRESSURE_5_PRESSURE_5_NAME "Pressure_5"
#define VEHICLE_RT_DL1_MK3_PRESSURE_4_PRESSURE_4_NAME "Pressure_4"
#define VEHICLE_RT_DL1_MK3_PRESSURE_3_PRESSURE_3_NAME "Pressure_3"
#define VEHICLE_RT_DL1_MK3_PRESSURE_2_PRESSURE_2_NAME "Pressure_2"
#define VEHICLE_RT_DL1_MK3_PRESSURE_1_PRESSURE_1_NAME "Pressure_1"
#define VEHICLE_RT_DL1_MK3_ANGLE_3_ANGLE_3_NAME "Angle_3"
#define VEHICLE_RT_DL1_MK3_ANGLE_2_ANGLE_2_NAME "Angle_2"
#define VEHICLE_RT_DL1_MK3_ANGLE_1_ANGLE_1_NAME "Angle_1"
#define VEHICLE_RT_DL1_MK3_TEMP_25_TEMPERATURE_25_NAME "Temperature_25"
#define VEHICLE_RT_DL1_MK3_TEMP_24_TEMPERATURE_24_NAME "Temperature_24"
#define VEHICLE_RT_DL1_MK3_TEMP_23_TEMPERATURE_23_NAME "Temperature_23"
#define VEHICLE_RT_DL1_MK3_TEMP_22_TEMPERATURE_22_NAME "Temperature_22"
#define VEHICLE_RT_DL1_MK3_TEMP_21_TEMPERATURE_21_NAME "Temperature_21"
#define VEHICLE_RT_DL1_MK3_TEMP_20_TEMPERATURE_20_NAME "Temperature_20"
#define VEHICLE_RT_DL1_MK3_TEMP_19_TEMPERATURE_19_NAME "Temperature_19"
#define VEHICLE_RT_DL1_MK3_TEMP_18_TEMPERATURE_18_NAME "Temperature_18"
#define VEHICLE_RT_DL1_MK3_TEMP_17_TEMPERATURE_17_NAME "Temperature_17"
#define VEHICLE_RT_DL1_MK3_TEMP_16_TEMPERATURE_16_NAME "Temperature_16"
#define VEHICLE_RT_DL1_MK3_TEMP_15_TEMPERATURE_15_NAME "Temperature_15"
#define VEHICLE_RT_DL1_MK3_TEMP_14_TEMPERATURE_14_NAME "Temperature_14"
#define VEHICLE_RT_DL1_MK3_TEMP_13_TEMPERATURE_13_NAME "Temperature_13"
#define VEHICLE_RT_DL1_MK3_TEMP_12_TEMPERATURE_12_NAME "Temperature_12"
#define VEHICLE_RT_DL1_MK3_TEMP_11_TEMPERATURE_11_NAME "Temperature_11"
#define VEHICLE_RT_DL1_MK3_TEMP_10_TEMPERATURE_10_NAME "Temperature_10"
#define VEHICLE_RT_DL1_MK3_TEMP_9_TEMPERATURE_9_NAME "Temperature_9"
#define VEHICLE_RT_DL1_MK3_TEMP_8_TEMPERATURE_8_NAME "Temperature_8"
#define VEHICLE_RT_DL1_MK3_TEMP_7_TEMPERATURE_7_NAME "Temperature_7"
#define VEHICLE_RT_DL1_MK3_TEMP_6_TEMPERATURE_6_NAME "Temperature_6"
#define VEHICLE_RT_DL1_MK3_TEMP_5_TEMPERATURE_5_NAME "Temperature_5"
#define VEHICLE_RT_DL1_MK3_TEMP_4_TEMPERATURE_4_NAME "Temperature_4"
#define VEHICLE_RT_DL1_MK3_TEMP_3_TEMPERATURE_3_NAME "Temperature_3"
#define VEHICLE_RT_DL1_MK3_TEMP_2_TEMPERATURE_2_NAME "Temperature_2"
#define VEHICLE_RT_DL1_MK3_TEMP_1_TEMPERATURE_1_NAME "Temperature_1"
#define VEHICLE_RT_DL1_MK3_ANALOG_32_ANALOG_32_NAME "Analog_32"
#define VEHICLE_RT_DL1_MK3_ANALOG_31_ANALOG_31_NAME "Analog_31"
#define VEHICLE_RT_DL1_MK3_ANALOG_30_ANALOG_30_NAME "Analog_30"
#define VEHICLE_RT_DL1_MK3_ANALOG_29_ANALOG_29_NAME "Analog_29"
#define VEHICLE_RT_DL1_MK3_ANALOG_28_ANALOG_28_NAME "Analog_28"
#define VEHICLE_RT_DL1_MK3_ANALOG_27_ANALOG_27_NAME "Analog_27"
#define VEHICLE_RT_DL1_MK3_ANALOG_26_ANALOG_26_NAME "Analog_26"
#define VEHICLE_RT_DL1_MK3_ANALOG_25_ANALOG_25_NAME "Analog_25"
#define VEHICLE_RT_DL1_MK3_ANALOG_15_ANALOG_15_NAME "Analog_15"
#define VEHICLE_RT_DL1_MK3_ANALOG_14_ANALOG_14_NAME "Analog_14"
#define VEHICLE_RT_DL1_MK3_ANALOG_17_ANALOG_17_NAME "Analog_17"
#define VEHICLE_RT_DL1_MK3_ANALOG_24_ANALOG_24_NAME "Analog_24"
#define VEHICLE_RT_DL1_MK3_ANALOG_23_ANALOG_23_NAME "Analog_23"
#define VEHICLE_RT_DL1_MK3_ANALOG_22_ANALOG_22_NAME "Analog_22"
#define VEHICLE_RT_DL1_MK3_ANALOG_21_ANALOG_21_NAME "Analog_21"
#define VEHICLE_RT_DL1_MK3_ANALOG_20_ANALOG_20_NAME "Analog_20"
#define VEHICLE_RT_DL1_MK3_ANALOG_19_ANALOG_19_NAME "Analog_19"
#define VEHICLE_RT_DL1_MK3_ANALOG_16_ANALOG_16_NAME "Analog_16"
#define VEHICLE_RT_DL1_MK3_ANALOG_18_ANALOG_18_NAME "Analog_18"
#define VEHICLE_RT_DL1_MK3_ANALOG_12_ANALOG_12_NAME "Analog_12"
#define VEHICLE_RT_DL1_MK3_ANALOG_11_ANALOG_11_NAME "Analog_11"
#define VEHICLE_RT_DL1_MK3_ANALOG_10_ANALOG_10_NAME "Analog_10"
#define VEHICLE_RT_DL1_MK3_ANALOG_9_ANALOG_9_NAME "Analog_9"
#define VEHICLE_RT_DL1_MK3_ANALOG_8_ANALOG_8_NAME "Analog_8"
#define VEHICLE_RT_DL1_MK3_ANALOG_7_ANALOG_7_NAME "Analog_7"
#define VEHICLE_RT_DL1_MK3_ANALOG_6_ANALOG_6_NAME "Analog_6"
#define VEHICLE_RT_DL1_MK3_ANALOG_5_ANALOG_5_NAME "Analog_5"
#define VEHICLE_RT_DL1_MK3_ANALOG_4_ANALOG_4_NAME "Analog_4"
#define VEHICLE_RT_DL1_MK3_ANALOG_3_ANALOG_3_NAME "Analog_3"
#define VEHICLE_RT_DL1_MK3_ANALOG_2_ANALOG_2_NAME "Analog_2"
#define VEHICLE_RT_DL1_MK3_ANALOG_1_ANALOG_1_NAME "Analog_1"
#define VEHICLE_RT_DL1_MK3_ACCEL_VALIDITY_ACCEL_LONGITUDINAL_NAME "Validity_Accel_Longitudinal"
#define VEHICLE_RT_DL1_MK3_ACCEL_VALIDITY_ACCEL_LATERAL_NAME "Validity_Accel_Lateral"
#define VEHICLE_RT_DL1_MK3_ACCEL_VALIDITY_ACCEL_VERTICAL_NAME "Validity_Accel_Vertical"
#define VEHICLE_RT_DL1_MK3_ACCEL_ACCURACY_ACCEL_NAME "Accuracy_Accel"
#define VEHICLE_RT_DL1_MK3_ACCEL_ACCEL_LONGITUDINAL_NAME "Accel_Longitudinal"
#define VEHICLE_RT_DL1_MK3_ACCEL_ACCEL_LATERAL_NAME "Accel_Lateral"
#define VEHICLE_RT_DL1_MK3_ACCEL_ACCEL_VERTICAL_NAME "Accel_Vertical"
#define VEHICLE_RT_SB_INS_VPT_4_VEL_NED_2_VIRTUAL_4_VEL_NED_D_NAME "Virtual_4_Vel_NED_D"
#define VEHICLE_RT_SB_INS_VPT_4_VEL_NED_2_VIRTUAL_4_HEADING_NAME "Virtual_4_Heading"
#define VEHICLE_RT_SB_INS_VPT_4_VEL_NED_2_VIRTUAL_4_SLIP_NAME "Virtual_4_Slip"
#define VEHICLE_RT_SB_INS_VPT_4_VEL_NED_1_VIRTUAL_4_VEL_NED_N_NAME "Virtual_4_Vel_NED_N"
#define VEHICLE_RT_SB_INS_VPT_4_VEL_NED_1_VIRTUAL_4_VEL_NED_E_NAME "Virtual_4_Vel_NED_E"
#define VEHICLE_RT_SB_INS_VPT_4_OFFSET_VIRTUAL_4_OFFSET_X_NAME "Virtual_4_Offset_X"
#define VEHICLE_RT_SB_INS_VPT_4_OFFSET_VIRTUAL_4_OFFSET_Y_NAME "Virtual_4_Offset_Y"
#define VEHICLE_RT_SB_INS_VPT_4_OFFSET_VIRTUAL_4_OFFSET_Z_NAME "Virtual_4_Offset_Z"
#define VEHICLE_RT_SB_INS_VPT_3_VEL_NED_2_VIRTUAL_3_VEL_NED_D_NAME "Virtual_3_Vel_NED_D"
#define VEHICLE_RT_SB_INS_VPT_3_VEL_NED_2_VIRTUAL_3_HEADING_NAME "Virtual_3_Heading"
#define VEHICLE_RT_SB_INS_VPT_3_VEL_NED_2_VIRTUAL_3_SLIP_NAME "Virtual_3_Slip"
#define VEHICLE_RT_SB_INS_VPT_3_VEL_NED_1_VIRTUAL_3_VEL_NED_N_NAME "Virtual_3_Vel_NED_N"
#define VEHICLE_RT_SB_INS_VPT_3_VEL_NED_1_VIRTUAL_3_VEL_NED_E_NAME "Virtual_3_Vel_NED_E"
#define VEHICLE_RT_SB_INS_VPT_3_OFFSET_VIRTUAL_3_OFFSET_X_NAME "Virtual_3_Offset_X"
#define VEHICLE_RT_SB_INS_VPT_3_OFFSET_VIRTUAL_3_OFFSET_Y_NAME "Virtual_3_Offset_Y"
#define VEHICLE_RT_SB_INS_VPT_3_OFFSET_VIRTUAL_3_OFFSET_Z_NAME "Virtual_3_Offset_Z"
#define VEHICLE_RT_SB_INS_VPT_2_VEL_NED_2_VIRTUAL_2_VEL_NED_D_NAME "Virtual_2_Vel_NED_D"
#define VEHICLE_RT_SB_INS_VPT_2_VEL_NED_2_VIRTUAL_2_HEADING_NAME "Virtual_2_Heading"
#define VEHICLE_RT_SB_INS_VPT_2_VEL_NED_2_VIRTUAL_2_SLIP_NAME "Virtual_2_Slip"
#define VEHICLE_RT_SB_INS_VPT_2_VEL_NED_1_VIRTUAL_2_VEL_NED_N_NAME "Virtual_2_Vel_NED_N"
#define VEHICLE_RT_SB_INS_VPT_2_VEL_NED_1_VIRTUAL_2_VEL_NED_E_NAME "Virtual_2_Vel_NED_E"
#define VEHICLE_RT_SB_INS_VPT_2_OFFSET_VIRTUAL_2_OFFSET_X_NAME "Virtual_2_Offset_X"
#define VEHICLE_RT_SB_INS_VPT_2_OFFSET_VIRTUAL_2_OFFSET_Y_NAME "Virtual_2_Offset_Y"
#define VEHICLE_RT_SB_INS_VPT_2_OFFSET_VIRTUAL_2_OFFSET_Z_NAME "Virtual_2_Offset_Z"
#define VEHICLE_RT_SB_INS_VPT_1_VEL_NED_2_VIRTUAL_1_VEL_NED_D_NAME "Virtual_1_Vel_NED_D"
#define VEHICLE_RT_SB_INS_VPT_1_VEL_NED_2_VIRTUAL_1_HEADING_NAME "Virtual_1_Heading"
#define VEHICLE_RT_SB_INS_VPT_1_VEL_NED_2_VIRTUAL_1_SLIP_NAME "Virtual_1_Slip"
#define VEHICLE_RT_SB_INS_VPT_1_VEL_NED_1_VIRTUAL_1_VEL_NED_N_NAME "Virtual_1_Vel_NED_N"
#define VEHICLE_RT_SB_INS_VPT_1_VEL_NED_1_VIRTUAL_1_VEL_NED_E_NAME "Virtual_1_Vel_NED_E"
#define VEHICLE_RT_SB_INS_VPT_1_OFFSET_VIRTUAL_1_OFFSET_X_NAME "Virtual_1_Offset_X"
#define VEHICLE_RT_SB_INS_VPT_1_OFFSET_VIRTUAL_1_OFFSET_Y_NAME "Virtual_1_Offset_Y"
#define VEHICLE_RT_SB_INS_VPT_1_OFFSET_VIRTUAL_1_OFFSET_Z_NAME "Virtual_1_Offset_Z"
#define VEHICLE_RT_SB_INS_SLIP_VALIDITY_INS_SLIP_NAME "Validity_INS_Slip"
#define VEHICLE_RT_SB_INS_SLIP_VALIDITY_INS_SQUAT_NAME "Validity_INS_Squat"
#define VEHICLE_RT_SB_INS_SLIP_ACCURACY_INS_SLIP_NAME "Accuracy_INS_Slip"
#define VEHICLE_RT_SB_INS_SLIP_INS_SLIP_NAME "INS_Slip"
#define VEHICLE_RT_SB_INS_SLIP_ACCURACY_INS_SQUAT_NAME "Accuracy_INS_Squat"
#define VEHICLE_RT_SB_INS_SLIP_INS_SQUAT_NAME "INS_Squat"
#define VEHICLE_RT_SB_INS_VEL_ECEF_2_VALIDITY_INS_VEL_ECEF_Y_NAME "Validity_INS_Vel_ECEF_Y"
#define VEHICLE_RT_SB_INS_VEL_ECEF_2_VALIDITY_INS_VEL_ECEF_Z_NAME "Validity_INS_Vel_ECEF_Z"
#define VEHICLE_RT_SB_INS_VEL_ECEF_2_INS_VEL_ECEF_Y_NAME "INS_Vel_ECEF_Y"
#define VEHICLE_RT_SB_INS_VEL_ECEF_2_INS_VEL_ECEF_Z_NAME "INS_Vel_ECEF_Z"
#define VEHICLE_RT_SB_INS_VEL_ECEF_1_VALIDITY_INS_VEL_ECEF_X_NAME "Validity_INS_Vel_ECEF_X"
#define VEHICLE_RT_SB_INS_VEL_ECEF_1_ACCURACY_INS_VEL_ECEF_X_NAME "Accuracy_INS_Vel_ECEF_X"
#define VEHICLE_RT_SB_INS_VEL_ECEF_1_ACCURACY_INS_VEL_ECEF_Y_NAME "Accuracy_INS_Vel_ECEF_Y"
#define VEHICLE_RT_SB_INS_VEL_ECEF_1_ACCURACY_INS_VEL_ECEF_Z_NAME "Accuracy_INS_Vel_ECEF_Z"
#define VEHICLE_RT_SB_INS_VEL_ECEF_1_INS_VEL_ECEF_X_NAME "INS_Vel_ECEF_X"
#define VEHICLE_RT_SB_INS_VEL_NED_2_VALIDITY_INS_VEL_NED_D_NAME "Validity_INS_Vel_NED_D"
#define VEHICLE_RT_SB_INS_VEL_NED_2_ACCURACY_INS_VEL_D_NAME "Accuracy_INS_Vel_D"
#define VEHICLE_RT_SB_INS_VEL_NED_2_INS_VEL_NED_D_NAME "INS_Vel_NED_D"
#define VEHICLE_RT_SB_INS_VEL_NED_1_VALIDITY_INS_VEL_NED_N_NAME "Validity_INS_Vel_NED_N"
#define VEHICLE_RT_SB_INS_VEL_NED_1_VALIDITY_INS_VEL_NED_E_NAME "Validity_INS_Vel_NED_E"
#define VEHICLE_RT_SB_INS_VEL_NED_1_ACCURACY_INS_VEL_NE_NAME "Accuracy_INS_Vel_NE"
#define VEHICLE_RT_SB_INS_VEL_NED_1_INS_VEL_NED_N_NAME "INS_Vel_NED_N"
#define VEHICLE_RT_SB_INS_VEL_NED_1_INS_VEL_NED_E_NAME "INS_Vel_NED_E"
#define VEHICLE_RT_SB_INS_POS_ECEF_2_INS_POS_ECEF_Y_NAME "INS_Pos_ECEF_Y"
#define VEHICLE_RT_SB_INS_POS_ECEF_2_INS_POS_ECEF_Z_NAME "INS_Pos_ECEF_Z"
#define VEHICLE_RT_SB_INS_POS_ECEF_1_VALIDITY_INS_POS_ECEF_X_NAME "Validity_INS_Pos_ECEF_X"
#define VEHICLE_RT_SB_INS_POS_ECEF_1_VALIDITY_INS_POS_ECEF_Y_NAME "Validity_INS_Pos_ECEF_Y"
#define VEHICLE_RT_SB_INS_POS_ECEF_1_VALIDITY_INS_POS_ECEF_Z_NAME "Validity_INS_Pos_ECEF_Z"
#define VEHICLE_RT_SB_INS_POS_ECEF_1_ACCURACY_INS_POS_ECEF_X_NAME "Accuracy_INS_Pos_ECEF_X"
#define VEHICLE_RT_SB_INS_POS_ECEF_1_ACCURACY_INS_POS_ECEF_Y_NAME "Accuracy_INS_Pos_ECEF_Y"
#define VEHICLE_RT_SB_INS_POS_ECEF_1_ACCURACY_INS_POS_ECEF_Z_NAME "Accuracy_INS_Pos_ECEF_Z"
#define VEHICLE_RT_SB_INS_POS_ECEF_1_INS_POS_ECEF_X_NAME "INS_Pos_ECEF_X"
#define VEHICLE_RT_SB_INS_POS_LLH_2_INS_POS_LLH_LONGITUDE_NAME "INS_Pos_LLH_Longitude"
#define VEHICLE_RT_SB_INS_POS_LLH_2_INS_POS_LLH_ALTITUDE_NAME "INS_Pos_LLH_Altitude"
#define VEHICLE_RT_SB_INS_POS_LLH_1_VALIDITY_INS_POS_LLH_LATITUDE_NAME "Validity_INS_Pos_LLH_Latitude"
#define VEHICLE_RT_SB_INS_POS_LLH_1_VALIDITY_INS_POS_LLH_LONGITUDE_NAME "Validity_INS_Pos_LLH_Longitude"
#define VEHICLE_RT_SB_INS_POS_LLH_1_VALIDITY_INS_POS_LLH_ALTITUDE_NAME "Validity_INS_Pos_LLH_Altitude"
#define VEHICLE_RT_SB_INS_POS_LLH_1_ACCURACY_INS_POS_LLH_LATITUDE_NAME "Accuracy_INS_Pos_LLH_Latitude"
#define VEHICLE_RT_SB_INS_POS_LLH_1_ACCURACY_INS_POS_LLH_LONGITUDE_NAME "Accuracy_INS_Pos_LLH_Longitude"
#define VEHICLE_RT_SB_INS_POS_LLH_1_ACCURACY_INS_POS_LLH_ALTITUDE_NAME "Accuracy_INS_Pos_LLH_Altitude"
#define VEHICLE_RT_SB_INS_POS_LLH_1_INS_POS_LLH_LATITUDE_NAME "INS_Pos_LLH_Latitude"
#define VEHICLE_RT_SB_INS_HEADING_GRADIENT_2_VALIDITY_INS_HEADING_NAME "Validity_INS_Heading"
#define VEHICLE_RT_SB_INS_HEADING_GRADIENT_2_VALIDITY_INS_GRADIENT_NAME "Validity_INS_Gradient"
#define VEHICLE_RT_SB_INS_HEADING_GRADIENT_2_ACCURACY_INS_HEADING_NAME "Accuracy_INS_Heading"
#define VEHICLE_RT_SB_INS_HEADING_GRADIENT_2_INS_HEADING_2_NAME "INS_Heading_2"
#define VEHICLE_RT_SB_INS_HEADING_GRADIENT_2_ACCURACY_INS_GRADIENT_NAME "Accuracy_INS_Gradient"
#define VEHICLE_RT_SB_INS_HEADING_GRADIENT_2_INS_GRADIENT_NAME "INS_Gradient"
#define VEHICLE_RT_SB_INS_HEADING_GRADIENT_VALIDITY_INS_HEADING_NAME "Validity_INS_Heading"
#define VEHICLE_RT_SB_INS_HEADING_GRADIENT_VALIDITY_INS_GRADIENT_NAME "Validity_INS_Gradient"
#define VEHICLE_RT_SB_INS_HEADING_GRADIENT_ACCURACY_INS_HEADING_NAME "Accuracy_INS_Heading"
#define VEHICLE_RT_SB_INS_HEADING_GRADIENT_INS_HEADING_NAME "INS_Heading"
#define VEHICLE_RT_SB_INS_HEADING_GRADIENT_ACCURACY_INS_GRADIENT_NAME "Accuracy_INS_Gradient"
#define VEHICLE_RT_SB_INS_HEADING_GRADIENT_INS_GRADIENT_NAME "INS_Gradient"
#define VEHICLE_RT_SB_INS_STATUS_INS_STATUS_NAME "INS_Status"
#define VEHICLE_RT_SB_INS_ATTITUDE_VALIDITY_YAW_NAME "Validity_Yaw"
#define VEHICLE_RT_SB_INS_ATTITUDE_VALIDITY_PITCH_NAME "Validity_Pitch"
#define VEHICLE_RT_SB_INS_ATTITUDE_VALIDITY_ROLL_NAME "Validity_Roll"
#define VEHICLE_RT_SB_INS_ATTITUDE_ACCURACY_ATTITUDE_NAME "Accuracy_Attitude"
#define VEHICLE_RT_SB_INS_ATTITUDE_ATTITUDE_YAW_NAME "Attitude_Yaw"
#define VEHICLE_RT_SB_INS_ATTITUDE_ATTITUDE_PITCH_NAME "Attitude_Pitch"
#define VEHICLE_RT_SB_INS_ATTITUDE_ATTITUDE_ROLL_NAME "Attitude_Roll"
#define VEHICLE_RT_SB_OUTPUT_STATUS_VALIDITY_STATUS_TIMESTAMP_NAME "Validity_Status_Timestamp"
#define VEHICLE_RT_SB_OUTPUT_STATUS_STATUS_ANALOGUE_1_NAME "Status_Analogue_1"
#define VEHICLE_RT_SB_OUTPUT_STATUS_STATUS_ANALOGUE_2_NAME "Status_Analogue_2"
#define VEHICLE_RT_SB_OUTPUT_STATUS_STATUS_ANALOGUE_3_NAME "Status_Analogue_3"
#define VEHICLE_RT_SB_OUTPUT_STATUS_STATUS_ANALOGUE_4_NAME "Status_Analogue_4"
#define VEHICLE_RT_SB_OUTPUT_STATUS_STATUS_PULSE_OUTPUT_NAME "Status_Pulse_Output"
#define VEHICLE_RT_SB_OUTPUT_STATUS_STATUS_SERIAL_OUTPUT_1_NAME "Status_Serial_Output_1"
#define VEHICLE_RT_SB_OUTPUT_STATUS_STATUS_SERIAL_OUTPUT_2_NAME "Status_Serial_Output_2"
#define VEHICLE_RT_SB_OUTPUT_STATUS_STATUS_TRIGGER_NAME "Status_Trigger"
#define VEHICLE_RT_SB_OUTPUT_STATUS_GPS_TIME_NAME "GPS_Time"
#define VEHICLE_RT_SB_GPS_HEADING_GRADIENT_2_VALIDITY_GPS_HEADING_NAME "Validity_GPS_Heading"
#define VEHICLE_RT_SB_GPS_HEADING_GRADIENT_2_VALIDITY_GPS_GRADIENT_NAME "Validity_GPS_Gradient"
#define VEHICLE_RT_SB_GPS_HEADING_GRADIENT_2_ACCURACY_GPS_HEADING_NAME "Accuracy_GPS_Heading"
#define VEHICLE_RT_SB_GPS_HEADING_GRADIENT_2_GPS_HEADING_2_NAME "GPS_Heading_2"
#define VEHICLE_RT_SB_GPS_HEADING_GRADIENT_2_ACCURACY_GPS_GRADIENT_NAME "Accuracy_GPS_Gradient"
#define VEHICLE_RT_SB_GPS_HEADING_GRADIENT_2_GPS_GRADIENT_NAME "GPS_Gradient"
#define VEHICLE_RT_SB_CUMULATIVE_DISTANCE_2_VALIDITY_CUMULATIVE_TIME_NAME "Validity_Cumulative_Time"
#define VEHICLE_RT_SB_CUMULATIVE_DISTANCE_2_VALIDITY_CUMULATIVE_DISTANCE_NAME "Validity_Cumulative_Distance"
#define VEHICLE_RT_SB_CUMULATIVE_DISTANCE_2_CUMULATIVE_TIME_NAME "Cumulative_Time"
#define VEHICLE_RT_SB_CUMULATIVE_DISTANCE_2_CUMULATIVE_DISTANCE_NAME "Cumulative_Distance"
#define VEHICLE_RT_SB_CUMULATIVE_DISTANCE_1_VALIDITY_CUMULATIVE_TIME_NAME "Validity_Cumulative_Time"
#define VEHICLE_RT_SB_CUMULATIVE_DISTANCE_1_VALIDITY_CUMULATIVE_DISTANCE_NAME "Validity_Cumulative_Distance"
#define VEHICLE_RT_SB_CUMULATIVE_DISTANCE_1_CUMULATIVE_TIME_NAME "Cumulative_Time"
#define VEHICLE_RT_SB_CUMULATIVE_DISTANCE_1_CUMULATIVE_DISTANCE_NAME "Cumulative_Distance"
#define VEHICLE_RT_SB_TRIGGER_TIMESTAMP_VALIDITY_TRIGGER_TIMESTAMP_NAME "Validity_Trigger_Timestamp"
#define VEHICLE_RT_SB_TRIGGER_TIMESTAMP_ACCURACY_TRIGGER_TIMESTAMP_NAME "Accuracy_Trigger_Timestamp"
#define VEHICLE_RT_SB_TRIGGER_TIMESTAMP_TRIGGER_NUMBER_NAME "Trigger_Number"
#define VEHICLE_RT_SB_TRIGGER_TIMESTAMP_TRIGGER_TIMESTAMP_TYPE_NAME "Trigger_Timestamp_Type"
#define VEHICLE_RT_SB_TRIGGER_TIMESTAMP_GPS_HIGH_RESOLUTION_TIME_NAME "GPS_High_Resolution_Time"
#define VEHICLE_RT_IMU06_GYRO_RATES_VALIDITY_GYRO_RATE_YAW_NAME "Validity_Gyro_Rate_Yaw"
#define VEHICLE_RT_IMU06_GYRO_RATES_VALIDITY_GYRO_RATE_PITCH_NAME "Validity_Gyro_Rate_Pitch"
#define VEHICLE_RT_IMU06_GYRO_RATES_VALIDITY_GYRO_RATE_ROLL_NAME "Validity_Gyro_Rate_Roll"
#define VEHICLE_RT_IMU06_GYRO_RATES_ACCURACY_GYRO_RATES_NAME "Accuracy_Gyro_Rates"
#define VEHICLE_RT_IMU06_GYRO_RATES_GYRO_RATE_YAW_NAME "Gyro_Rate_Yaw"
#define VEHICLE_RT_IMU06_GYRO_RATES_GYRO_RATE_PITCH_NAME "Gyro_Rate_Pitch"
#define VEHICLE_RT_IMU06_GYRO_RATES_GYRO_RATE_ROLL_NAME "Gyro_Rate_Roll"
#define VEHICLE_RT_IMU06_ACCEL_VALIDITY_ACCEL_LONGITUDINAL_NAME "Validity_Accel_Longitudinal"
#define VEHICLE_RT_IMU06_ACCEL_VALIDITY_ACCEL_LATERAL_NAME "Validity_Accel_Lateral"
#define VEHICLE_RT_IMU06_ACCEL_VALIDITY_ACCEL_VERTICAL_NAME "Validity_Accel_Vertical"
#define VEHICLE_RT_IMU06_ACCEL_ACCURACY_ACCEL_NAME "Accuracy_Accel"
#define VEHICLE_RT_IMU06_ACCEL_ACCEL_LONGITUDINAL_NAME "Accel_Longitudinal"
#define VEHICLE_RT_IMU06_ACCEL_ACCEL_LATERAL_NAME "Accel_Lateral"
#define VEHICLE_RT_IMU06_ACCEL_ACCEL_VERTICAL_NAME "Accel_Vertical"
#define VEHICLE_RT_SB_SPEED_VALIDITY_SPEED_NAME "Validity_Speed"
#define VEHICLE_RT_SB_SPEED_ACCURACY_SPEED_NAME "Accuracy_Speed"
#define VEHICLE_RT_SB_SPEED_SPEED_NAME "Speed"
#define VEHICLE_RT_SB_RTK_SLIP_VALIDITY_RTK_SLIP_NAME "Validity_RTK_Slip"
#define VEHICLE_RT_SB_RTK_SLIP_VALIDITY_RTK_SQUAT_NAME "Validity_RTK_Squat"
#define VEHICLE_RT_SB_RTK_SLIP_VALIDITY_RTK_BASELINE_NAME "Validity_RTK_Baseline"
#define VEHICLE_RT_SB_RTK_SLIP_ACCURACY_RTK_BASELINE_NAME "Accuracy_RTK_Baseline"
#define VEHICLE_RT_SB_RTK_SLIP_RTK_SLIP_NAME "RTK_Slip"
#define VEHICLE_RT_SB_RTK_SLIP_RTK_SQUAT_NAME "RTK_Squat"
#define VEHICLE_RT_SB_RTK_SLIP_RTK_BASELINE_NAME "RTK_Baseline"
#define VEHICLE_RT_SB_RTK_ATTITUDE_VALIDITY_RTK_YAW_NAME "Validity_RTK_Yaw"
#define VEHICLE_RT_SB_RTK_ATTITUDE_VALIDITY_RTK_PITCH_NAME "Validity_RTK_Pitch"
#define VEHICLE_RT_SB_RTK_ATTITUDE_VALIDITY_RTK_ROLL_NAME "Validity_RTK_Roll"
#define VEHICLE_RT_SB_RTK_ATTITUDE_ACCURACY_RTK_ATTITUDE_NAME "Accuracy_RTK_Attitude"
#define VEHICLE_RT_SB_RTK_ATTITUDE_RTK_ATTITUDE_YAW_NAME "RTK_Attitude_Yaw"
#define VEHICLE_RT_SB_RTK_ATTITUDE_RTK_ATTITUDE_PITCH_NAME "RTK_Attitude_Pitch"
#define VEHICLE_RT_SB_RTK_ATTITUDE_RTK_ATTITUDE_ROLL_NAME "RTK_Attitude_Roll"
#define VEHICLE_RT_SB_GPS_MCYCLE_LEAN_VALIDITY_GPS_LATERAL_ACCEL_NAME "Validity_GPS_Lateral_Accel"
#define VEHICLE_RT_SB_GPS_MCYCLE_LEAN_VALIDITY_GPS_MCYCLE_LEAN_NAME "Validity_GPS_Mcycle_Lean"
#define VEHICLE_RT_SB_GPS_MCYCLE_LEAN_ACCURACY_GPS_LATERAL_ACCEL_NAME "Accuracy_GPS_Lateral_Accel"
#define VEHICLE_RT_SB_GPS_MCYCLE_LEAN_GPS_LATERAL_ACCEL_NAME "GPS_Lateral_Accel"
#define VEHICLE_RT_SB_GPS_MCYCLE_LEAN_GPS_MCYCLE_LEAN_ANGLE_NAME "GPS_Mcycle_Lean_Angle"
#define VEHICLE_RT_SB_GPS_STATUS_GPS_STATUS_NAME "GPS_Status"
#define VEHICLE_RT_SB_GPS_STATUS_FIRMWARE_VERSION_MAJOR_NAME "Firmware_Version_Major"
#define VEHICLE_RT_SB_GPS_STATUS_FIRMWARE_VERSION_INTERMEDIATE_NAME "Firmware_Version_Intermediate"
#define VEHICLE_RT_SB_GPS_STATUS_FIRMWARE_VERSION_MINOR_NAME "Firmware_Version_Minor"
#define VEHICLE_RT_SB_GPS_STATUS_GPS_N_SV_NAME "GPS_nSv"
#define VEHICLE_RT_SB_GPS_STATUS_GPS_N_SV_2_NAME "GPS_nSv_2"
#define VEHICLE_RT_SB_GPS_STATUS_GPS_N_SV_RTK_NAME "GPS_nSv_RTK"
#define VEHICLE_RT_SB_GPS_STATUS_RTK_STATUS_NAME "RTK_Status"
#define VEHICLE_RT_SB_GPS_POS_ECEF_2_GPS_POS_ECEF_Y_NAME "GPS_Pos_ECEF_Y"
#define VEHICLE_RT_SB_GPS_POS_ECEF_2_GPS_POS_ECEF_Z_NAME "GPS_Pos_ECEF_Z"
#define VEHICLE_RT_SB_GPS_POS_ECEF_1_VALIDITY_GPS_POS_ECEF_X_NAME "Validity_GPS_Pos_ECEF_X"
#define VEHICLE_RT_SB_GPS_POS_ECEF_1_VALIDITY_GPS_POS_ECEF_Y_NAME "Validity_GPS_Pos_ECEF_Y"
#define VEHICLE_RT_SB_GPS_POS_ECEF_1_VALIDITY_GPS_POS_ECEF_Z_NAME "Validity_GPS_Pos_ECEF_Z"
#define VEHICLE_RT_SB_GPS_POS_ECEF_1_ACCURACY_GPS_POS_ECEF_X_NAME "Accuracy_GPS_Pos_ECEF_X"
#define VEHICLE_RT_SB_GPS_POS_ECEF_1_ACCURACY_GPS_POS_ECEF_Y_NAME "Accuracy_GPS_Pos_ECEF_Y"
#define VEHICLE_RT_SB_GPS_POS_ECEF_1_ACCURACY_GPS_POS_ECEF_Z_NAME "Accuracy_GPS_Pos_ECEF_Z"
#define VEHICLE_RT_SB_GPS_POS_ECEF_1_GPS_POS_ECEF_X_NAME "GPS_Pos_ECEF_X"
#define VEHICLE_RT_SB_GPS_POS_LLH_2_GPS_POS_LLH_LONGITUDE_NAME "GPS_Pos_LLH_Longitude"
#define VEHICLE_RT_SB_GPS_POS_LLH_2_GPS_POS_LLH_ALTITUDE_NAME "GPS_Pos_LLH_Altitude"
#define VEHICLE_RT_SB_GPS_POS_LLH_1_VALIDITY_GPS_POS_LLH_LATITUDE_NAME "Validity_GPS_Pos_LLH_Latitude"
#define VEHICLE_RT_SB_GPS_POS_LLH_1_VALIDITY_GPS_POS_LLH_LONGITUDE_NAME "Validity_GPS_Pos_LLH_Longitude"
#define VEHICLE_RT_SB_GPS_POS_LLH_1_VALIDITY_GPS_POS_LLH_ALTITUDE_NAME "Validity_GPS_Pos_LLH_Altitude"
#define VEHICLE_RT_SB_GPS_POS_LLH_1_ACCURACY_GPS_POS_LLH_LATITUDE_NAME "Accuracy_GPS_Pos_LLH_Latitude"
#define VEHICLE_RT_SB_GPS_POS_LLH_1_ACCURACY_GPS_POS_LLH_LONGITUDE_NAME "Accuracy_GPS_Pos_LLH_Longitude"
#define VEHICLE_RT_SB_GPS_POS_LLH_1_ACCURACY_GPS_POS_LLH_ALTITUDE_NAME "Accuracy_GPS_Pos_LLH_Altitude"
#define VEHICLE_RT_SB_GPS_POS_LLH_1_GPS_POS_LLH_LATITUDE_NAME "GPS_Pos_LLH_Latitude"
#define VEHICLE_RT_SB_GPS_HEADING_GRADIENT_VALIDITY_GPS_HEADING_NAME "Validity_GPS_Heading"
#define VEHICLE_RT_SB_GPS_HEADING_GRADIENT_VALIDITY_GPS_GRADIENT_NAME "Validity_GPS_Gradient"
#define VEHICLE_RT_SB_GPS_HEADING_GRADIENT_ACCURACY_GPS_HEADING_NAME "Accuracy_GPS_Heading"
#define VEHICLE_RT_SB_GPS_HEADING_GRADIENT_GPS_HEADING_NAME "GPS_Heading"
#define VEHICLE_RT_SB_GPS_HEADING_GRADIENT_ACCURACY_GPS_GRADIENT_NAME "Accuracy_GPS_Gradient"
#define VEHICLE_RT_SB_GPS_HEADING_GRADIENT_GPS_GRADIENT_NAME "GPS_Gradient"
#define VEHICLE_RT_SB_GPS_VEL_ECEF_2_VALIDITY_GPS_VEL_ECEF_Y_NAME "Validity_GPS_Vel_ECEF_Y"
#define VEHICLE_RT_SB_GPS_VEL_ECEF_2_VALIDITY_GPS_VEL_ECEF_Z_NAME "Validity_GPS_Vel_ECEF_Z"
#define VEHICLE_RT_SB_GPS_VEL_ECEF_2_GPS_VEL_ECEF_Y_NAME "GPS_Vel_ECEF_Y"
#define VEHICLE_RT_SB_GPS_VEL_ECEF_2_GPS_VEL_ECEF_Z_NAME "GPS_Vel_ECEF_Z"
#define VEHICLE_RT_SB_GPS_VEL_ECEF_1_VALIDITY_GPS_VEL_ECEF_X_NAME "Validity_GPS_Vel_ECEF_X"
#define VEHICLE_RT_SB_GPS_VEL_ECEF_1_ACCURACY_GPS_VEL_ECEF_X_NAME "Accuracy_GPS_Vel_ECEF_X"
#define VEHICLE_RT_SB_GPS_VEL_ECEF_1_ACCURACY_GPS_VEL_ECEF_Y_NAME "Accuracy_GPS_Vel_ECEF_Y"
#define VEHICLE_RT_SB_GPS_VEL_ECEF_1_ACCURACY_GPS_VEL_ECEF_Z_NAME "Accuracy_GPS_Vel_ECEF_Z"
#define VEHICLE_RT_SB_GPS_VEL_ECEF_1_GPS_VEL_ECEF_X_NAME "GPS_Vel_ECEF_X"
#define VEHICLE_RT_SB_GPS_VEL_NED_2_VALIDITY_GPS_VEL_NED_D_NAME "Validity_GPS_Vel_NED_D"
#define VEHICLE_RT_SB_GPS_VEL_NED_2_ACCURACY_GPS_VEL_D_NAME "Accuracy_GPS_Vel_D"
#define VEHICLE_RT_SB_GPS_VEL_NED_2_GPS_VEL_NED_D_NAME "GPS_Vel_NED_D"
#define VEHICLE_RT_SB_GPS_VEL_NED_1_VALIDITY_GPS_VEL_NED_N_NAME "Validity_GPS_Vel_NED_N"
#define VEHICLE_RT_SB_GPS_VEL_NED_1_VALIDITY_GPS_VEL_NED_E_NAME "Validity_GPS_Vel_NED_E"
#define VEHICLE_RT_SB_GPS_VEL_NED_1_ACCURACY_GPS_VEL_NE_NAME "Accuracy_GPS_Vel_NE"
#define VEHICLE_RT_SB_GPS_VEL_NED_1_GPS_VEL_NED_N_NAME "GPS_Vel_NED_N"
#define VEHICLE_RT_SB_GPS_VEL_NED_1_GPS_VEL_NED_E_NAME "GPS_Vel_NED_E"
#define VEHICLE_RT_SB_GPS_SPEED_VALIDITY_GPS_SPEED_2_D_NAME "Validity_GPS_Speed_2D"
#define VEHICLE_RT_SB_GPS_SPEED_VALIDITY_GPS_SPEED_3_D_NAME "Validity_GPS_Speed_3D"
#define VEHICLE_RT_SB_GPS_SPEED_ACCURACY_GPS_SPEED_NAME "Accuracy_GPS_Speed"
#define VEHICLE_RT_SB_GPS_SPEED_GPS_SPEED_2_D_NAME "GPS_Speed_2D"
#define VEHICLE_RT_SB_GPS_SPEED_GPS_SPEED_3_D_NAME "GPS_Speed_3D"
#define VEHICLE_RT_SB_GPS_TIME_VALIDITY_GPS_TIME_NAME "Validity_GPS_Time"
#define VEHICLE_RT_SB_GPS_TIME_VALIDITY_GPS_WEEK_NAME "Validity_GPS_Week"
#define VEHICLE_RT_SB_GPS_TIME_ACCURACY_GPS_TIME_NAME "Accuracy_GPS_Time"
#define VEHICLE_RT_SB_GPS_TIME_GPS_TIME_NAME "GPS_Time"
#define VEHICLE_RT_SB_GPS_TIME_GPS_WEEK_NAME "GPS_Week"
#define VEHICLE_RT_SB_ACCEL_VALIDITY_ACCEL_LONGITUDINAL_NAME "Validity_Accel_Longitudinal"
#define VEHICLE_RT_SB_ACCEL_VALIDITY_ACCEL_LATERAL_NAME "Validity_Accel_Lateral"
#define VEHICLE_RT_SB_ACCEL_VALIDITY_ACCEL_VERTICAL_NAME "Validity_Accel_Vertical"
#define VEHICLE_RT_SB_ACCEL_ACCURACY_ACCEL_NAME "Accuracy_Accel"
#define VEHICLE_RT_SB_ACCEL_ACCEL_LONGITUDINAL_NAME "Accel_Longitudinal"
#define VEHICLE_RT_SB_ACCEL_ACCEL_LATERAL_NAME "Accel_Lateral"
#define VEHICLE_RT_SB_ACCEL_ACCEL_VERTICAL_NAME "Accel_Vertical"
#define VEHICLE_RT_SB_GYRO_RATES_VALIDITY_GYRO_RATE_YAW_NAME "Validity_Gyro_Rate_Yaw"
#define VEHICLE_RT_SB_GYRO_RATES_VALIDITY_GYRO_RATE_PITCH_NAME "Validity_Gyro_Rate_Pitch"
#define VEHICLE_RT_SB_GYRO_RATES_VALIDITY_GYRO_RATE_ROLL_NAME "Validity_Gyro_Rate_Roll"
#define VEHICLE_RT_SB_GYRO_RATES_ACCURACY_GYRO_RATES_NAME "Accuracy_Gyro_Rates"
#define VEHICLE_RT_SB_GYRO_RATES_GYRO_RATE_YAW_NAME "Gyro_Rate_Yaw"
#define VEHICLE_RT_SB_GYRO_RATES_GYRO_RATE_PITCH_NAME "Gyro_Rate_Pitch"
#define VEHICLE_RT_SB_GYRO_RATES_GYRO_RATE_ROLL_NAME "Gyro_Rate_Roll"

/**
 * Signals in message RT_SB_INS_Vel_Body_Axes.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_ins_vel_body_axes_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_ins_vel_forwards;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_ins_vel_sideways;

    /**
     * Accuracy of INS body axis velocities (forward velocity and sideways velocity)
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_ins_vel_body;

    /**
     * Forwards Velocity in the vehicle body axes, 2D (no vertical component) .
     *
     * Range: -8380000..8380000 (-838..838 m/s)
     * Scale: 0.0001
     * Offset: 0
     */
    int32_t ins_vel_forwards_2_d;

    /**
     * Sideways Velocity in the vehicle body axes, 2D (no vertical component) .  +ve for motion to the vehicle RHS.
     *
     * Range: -8380000..8380000 (-838..838 m/s)
     * Scale: 0.0001
     * Offset: 0
     */
    int32_t ins_vel_sideways_2_d;
};

/**
 * Signals in message RT_DL1MK3_Speed.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_speed_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_speed;

    /**
     * Dimensionless.  Lower values imply but do not guarantee better accuracy than higher values.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_speed;

    /**
     * Range: -2000000000..2000000000 (-20000..20000 m/s)
     * Scale: 1e-05
     * Offset: 0
     */
    int32_t speed;
};

/**
 * Signals in message RT_DL1MK3_GPS_Time.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_gps_time_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gps_time;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gps_week;

    /**
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_gps_time;

    /**
     * GPS time is the time in seconds since midnight GMT on Saturday night.
     *
     * Range: 0..604800000 (0..604800 s)
     * Scale: 0.001
     * Offset: 0
     */
    uint32_t gps_time;

    /**
     * Range: 0..65535 (0..65535 -)
     * Scale: 1
     * Offset: 0
     */
    uint16_t gps_week;
};

/**
 * Signals in message RT_DL1MK3_GPS_Pos_LLH_2.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_gps_pos_llh_2_t {
    /**
     * Range: -1800000000..1800000000 (-180..180 degrees)
     * Scale: 1e-07
     * Offset: 0
     */
    int32_t gps_pos_llh_longitude;

    /**
     * Range: -1000000..100000000 (-1000..100000 m)
     * Scale: 0.001
     * Offset: 0
     */
    int32_t gps_pos_llh_altitude;
};

/**
 * Signals in message RT_DL1MK3_GPS_Pos_LLH_1.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_gps_pos_llh_1_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gps_pos_llh_latitude;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gps_pos_llh_longitude;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gps_pos_llh_altitude;

    /**
     * This accuracy value applies to both 2D and 3D GPS speed.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_gps_pos_llh_latitude;

    /**
     * This accuracy value applies to both 2D and 3D GPS speed.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_gps_pos_llh_longitude;

    /**
     * This accuracy value applies to both 2D and 3D GPS speed.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_gps_pos_llh_altitude;

    /**
     * Range: -900000000..900000000 (-90..90 degrees)
     * Scale: 1e-07
     * Offset: 0
     */
    int32_t gps_pos_llh_latitude;
};

/**
 * Signals in message RT_DL1MK3_GPS_Speed.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_gps_speed_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gps_speed_2_d;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gps_speed_3_d;

    /**
     * This accuracy value applies to both 2D and 3D GPS speed.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_gps_speed;

    /**
     * This is GPS scalar 2D speed - scalar speed with no local Z axis component included.
     *
     * Range: 0..16750000 (0..1675 m/s)
     * Scale: 0.0001
     * Offset: 0
     */
    uint32_t gps_speed_2_d;

    /**
     * This is GPS scalar 3D speed - scalar speed with the local Z axis component included.
     *
     * Range: 0..16750000 (0..1675 m/s)
     * Scale: 0.0001
     * Offset: 0
     */
    uint32_t gps_speed_3_d;
};

/**
 * Signals in message RT_IRTemp_Temp_7.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_7_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_7;
};

/**
 * Signals in message RT_IRTemp_Temp_RR_2.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_rr_2_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_29;

    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_30;

    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_31;

    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_32;
};

/**
 * Signals in message RT_IRTemp_Temp_RL_2.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_rl_2_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_21;

    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_22;

    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_23;

    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_24;
};

/**
 * Signals in message RT_IRTemp_Temp_FR_2.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_fr_2_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_13;

    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_14;

    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_15;

    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_16;
};

/**
 * Signals in message RT_IRTemp_Temp_FL_2.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_fl_2_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_5;

    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_6;

    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_7;

    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_8;
};

/**
 * Signals in message RT_IRTemp_Temp_RR_1.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_rr_1_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_25;

    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_26;

    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_27;

    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_28;
};

/**
 * Signals in message RT_IRTemp_Temp_RL_1.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_rl_1_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_17;

    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_18;

    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_19;

    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_20;
};

/**
 * Signals in message RT_IRTemp_Temp_FR_1.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_fr_1_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_9;

    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_10;

    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_11;

    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_12;
};

/**
 * Signals in message RT_IRTemp_Temp_FL_1.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_fl_1_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_1;

    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_2;

    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_3;

    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_4;
};

/**
 * Signals in message RT_IRTemp_Temp_32.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_32_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_32;
};

/**
 * Signals in message RT_IRTemp_Temp_31.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_31_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_31;
};

/**
 * Signals in message RT_IRTemp_Temp_30.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_30_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_30;
};

/**
 * Signals in message RT_IRTemp_Temp_29.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_29_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_29;
};

/**
 * Signals in message RT_IRTemp_Temp_28.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_28_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_28;
};

/**
 * Signals in message RT_IRTemp_Temp_27.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_27_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_27;
};

/**
 * Signals in message RT_IRTemp_Temp_26.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_26_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_26;
};

/**
 * Signals in message RT_IRTemp_Temp_25.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_25_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_25;
};

/**
 * Signals in message RT_IRTemp_Temp_24.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_24_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_24;
};

/**
 * Signals in message RT_IRTemp_Temp_22.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_22_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_22;
};

/**
 * Signals in message RT_IRTemp_Temp_23.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_23_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_23;
};

/**
 * Signals in message RT_IRTemp_Temp_21.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_21_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_21;
};

/**
 * Signals in message RT_IRTemp_Temp_20.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_20_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_20;
};

/**
 * Signals in message RT_IRTemp_Temp_19.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_19_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_19;
};

/**
 * Signals in message RT_IRTemp_Temp_18.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_18_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_18;
};

/**
 * Signals in message RT_IRTemp_Temp_16.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_16_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_16;
};

/**
 * Signals in message RT_IRTemp_Temp_15.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_15_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_15;
};

/**
 * Signals in message RT_IRTemp_Temp_14.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_14_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_14;
};

/**
 * Signals in message RT_IRTemp_Temp_13.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_13_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_13;
};

/**
 * Signals in message RT_IRTemp_Temp_12.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_12_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_12;
};

/**
 * Signals in message RT_IRTemp_Temp_11.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_11_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_11;
};

/**
 * Signals in message RT_IRTemp_Temp_10.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_10_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_10;
};

/**
 * Signals in message RT_IRTemp_Temp_8.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_8_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_8;
};

/**
 * Signals in message RT_IRTemp_Temp_9.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_9_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_9;
};

/**
 * Signals in message RT_IRTemp_Temp_17.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_17_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_17;
};

/**
 * Signals in message RT_IRTemp_Temp_6.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_6_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_6;
};

/**
 * Signals in message RT_IRTemp_Temp_5.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_5_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_5;
};

/**
 * Signals in message RT_IRTemp_Temp_4.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_4_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_4;
};

/**
 * Signals in message RT_IRTemp_Temp_3.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_3_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_3;
};

/**
 * Signals in message RT_IRTemp_Temp_2.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_2_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_2;
};

/**
 * Signals in message RT_IRTemp_Temp_1.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_ir_temp_temp_1_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t ir_temperature_1;
};

/**
 * Signals in message RT_SB_Trig_Final_Condition.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_trig_final_condition_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_final_speed;

    /**
     * Speed at end of triggered test
     *
     * Range: 0..16750000 (0..1675 m/s)
     * Scale: 0.0001
     * Offset: 0
     */
    uint32_t final_speed;
};

/**
 * Signals in message RT_SB_Trig_Initial_Condition.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_trig_initial_condition_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_initial_speed;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_initial_heading;

    /**
     * Speed at start of triggered test
     *
     * Range: 0..16750000 (0..1675 m/s)
     * Scale: 0.0001
     * Offset: 0
     */
    uint32_t initial_speed;

    /**
     * Heading (track) at start of triggered test
     *
     * Range: -18000..18000 (-180..180 degrees)
     * Scale: 0.01
     * Offset: 0
     */
    int16_t initial_heading;

    /**
     * Range: 0..100 (0..100 %)
     * Scale: 1
     * Offset: 0
     */
    uint8_t mfdd_start_threshold;

    /**
     * Range: 0..100 (0..100 %)
     * Scale: 1
     * Offset: 0
     */
    uint8_t mfdd_end_threshold;
};

/**
 * Signals in message RT_SB_Trig_Direct_Dist.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_trig_direct_dist_t {
    /**
     * Direct distance from start of test to current position
     *
     * Range: 0..4294967000 (0..4294967 m)
     * Scale: 0.001
     * Offset: 0
     */
    uint32_t direct_distance;

    /**
     * 2D path distance (horizontal components only)
     *
     * Range: 0..4294967000 (0..4294967 m)
     * Scale: 0.001
     * Offset: 0
     */
    uint32_t path_distance_2_d;
};

/**
 * Signals in message RT_SB_Trig_Forward_Dist.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_trig_forward_dist_t {
    /**
     * Current forward distance from start of test in direction of initial heading at start of test
     *
     * Range: -2147483648..2147483647 (-2147483.648..2147483.647 m)
     * Scale: 0.001
     * Offset: 0
     */
    int32_t forward_distance;

    /**
     * Current deviation distance from a line projected along the initial heading at start of test, +ve for deviation to the right.
     *
     * Range: -2147483648..2147483647 (-2147483.648..2147483.647 m)
     * Scale: 0.001
     * Offset: 0
     */
    int32_t deviation_distance;
};

/**
 * Signals in message RT_SB_Trig_Path_Dist.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_trig_path_dist_t {
    /**
     * 3D path distance
     *
     * Range: 0..4294967000 (0..4294967 m)
     * Scale: 0.001
     * Offset: 0
     */
    uint32_t path_distance_3_d;
};

/**
 * Signals in message RT_SB_Trig_Accel.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_trig_accel_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_mfdd;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_average_accel;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_triggered_time;

    /**
     * Mean fully-developed decelleration of triggered test.  Thresholds used are as set in the logger configuration.
     *
     * Range: -65000..65000 (-65..65 g)
     * Scale: 0.001
     * Offset: 0
     */
    int16_t mfdd;

    /**
     * Average acceleration from start of triggered test to current time.
     *
     * Range: -65000..65000 (-65..65 g)
     * Scale: 0.001
     * Offset: 0
     */
    int16_t average_accel;

    /**
     * Cumulative time from start of triggered test to current time.
     *
     * Range: 0..16777200 (0..167772 s)
     * Scale: 0.01
     * Offset: 0
     */
    uint32_t triggered_time;
};

/**
 * Signals in message RT_DL1MK3_Measure_Time_12.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_measure_time_12_t {
    /**
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint32_t measured_time_12;
};

/**
 * Signals in message RT_DL1MK3_Measure_Time_11.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_measure_time_11_t {
    /**
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint32_t measured_time_11;
};

/**
 * Signals in message RT_DL1MK3_Measure_Time_10.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_measure_time_10_t {
    /**
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint32_t measured_time_10;
};

/**
 * Signals in message RT_DL1MK3_Measure_Time_9.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_measure_time_9_t {
    /**
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint32_t measured_time_9;
};

/**
 * Signals in message RT_DL1MK3_Measure_Time_8.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_measure_time_8_t {
    /**
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint32_t measured_time_8;
};

/**
 * Signals in message RT_DL1MK3_Measure_Time_7.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_measure_time_7_t {
    /**
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint32_t measured_time_7;
};

/**
 * Signals in message RT_DL1MK3_Measure_Time_6.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_measure_time_6_t {
    /**
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint32_t measured_time_6;
};

/**
 * Signals in message RT_DL1MK3_Measure_Time_5.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_measure_time_5_t {
    /**
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint32_t measured_time_5;
};

/**
 * Signals in message RT_DL1MK3_Measure_Time_4.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_measure_time_4_t {
    /**
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint32_t measured_time_4;
};

/**
 * Signals in message RT_DL1MK3_Measure_Time_3.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_measure_time_3_t {
    /**
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint32_t measured_time_3;
};

/**
 * Signals in message RT_DL1MK3_Measure_Time_2.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_measure_time_2_t {
    /**
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint32_t measured_time_2;
};

/**
 * Signals in message RT_DL1MK3_Measure_Time_1.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_measure_time_1_t {
    /**
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint32_t measured_time_1;
};

/**
 * Signals in message RT_DL1MK3_RPM.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_rpm_t {
    /**
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint16_t rpm;
};

/**
 * Signals in message RT_DL1MK3_Freq_4.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_freq_4_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint16_t frequency_4;
};

/**
 * Signals in message RT_DL1MK3_Freq_3.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_freq_3_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint16_t frequency_3;
};

/**
 * Signals in message RT_DL1MK3_Freq_2.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_freq_2_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint16_t frequency_2;
};

/**
 * Signals in message RT_DL1MK3_Misc_3.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_misc_3_t {
    /**
     * Range: -
     * Scale: 0.001
     * Offset: 0
     */
    uint16_t misc_3;
};

/**
 * Signals in message RT_DL1MK3_Misc_2.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_misc_2_t {
    /**
     * Range: -
     * Scale: 0.001
     * Offset: 0
     */
    uint16_t misc_2;
};

/**
 * Signals in message RT_DL1MK3_Misc_1.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_misc_1_t {
    /**
     * Range: -
     * Scale: 0.001
     * Offset: 0
     */
    uint16_t misc_1;
};

/**
 * Signals in message RT_DL1MK3_Aux_31.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_aux_31_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint16_t aux_31;
};

/**
 * Signals in message RT_DL1MK3_Aux_30.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_aux_30_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint16_t aux_30;
};

/**
 * Signals in message RT_DL1MK3_Aux_29.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_aux_29_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint16_t aux_29;
};

/**
 * Signals in message RT_DL1MK3_Aux_28.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_aux_28_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint16_t aux_28;
};

/**
 * Signals in message RT_DL1MK3_Aux_27.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_aux_27_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint16_t aux_27;
};

/**
 * Signals in message RT_DL1MK3_Aux_26.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_aux_26_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint16_t aux_26;
};

/**
 * Signals in message RT_DL1MK3_Aux_25.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_aux_25_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint16_t aux_25;
};

/**
 * Signals in message RT_DL1MK3_Aux_24.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_aux_24_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint16_t aux_24;
};

/**
 * Signals in message RT_DL1MK3_Aux_23.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_aux_23_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint16_t aux_23;
};

/**
 * Signals in message RT_DL1MK3_Aux_22.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_aux_22_t {
    /**
     * Range: -
     * Scale: 10
     * Offset: 0
     */
    uint16_t aux_22;
};

/**
 * Signals in message RT_DL1MK3_Aux_21.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_aux_21_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint16_t aux_21;
};

/**
 * Signals in message RT_DL1MK3_Aux_20.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_aux_20_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint16_t aux_20;
};

/**
 * Signals in message RT_DL1MK3_Aux_19.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_aux_19_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint16_t aux_19;
};

/**
 * Signals in message RT_DL1MK3_Aux_18.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_aux_18_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint16_t aux_18;
};

/**
 * Signals in message RT_DL1MK3_Aux_17.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_aux_17_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint16_t aux_17;
};

/**
 * Signals in message RT_DL1MK3_Aux_16.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_aux_16_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint16_t aux_16;
};

/**
 * Signals in message RT_DL1MK3_Aux_15.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_aux_15_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint16_t aux_15;
};

/**
 * Signals in message RT_DL1MK3_Aux_14.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_aux_14_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint16_t aux_14;
};

/**
 * Signals in message RT_DL1MK3_Aux_13.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_aux_13_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint16_t aux_13;
};

/**
 * Signals in message RT_DL1MK3_Aux_12.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_aux_12_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint16_t aux_12;
};

/**
 * Signals in message RT_DL1MK3_Aux_11.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_aux_11_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint16_t aux_11;
};

/**
 * Signals in message RT_DL1MK3_Aux_9.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_aux_9_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint16_t aux_9;
};

/**
 * Signals in message RT_DL1MK3_Aux_10.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_aux_10_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint16_t aux_10;
};

/**
 * Signals in message RT_DL1MK3_Aux_8.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_aux_8_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint16_t aux_8;
};

/**
 * Signals in message RT_DL1MK3_Aux_7.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_aux_7_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint16_t aux_7;
};

/**
 * Signals in message RT_DL1MK3_Aux_6.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_aux_6_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint16_t aux_6;
};

/**
 * Signals in message RT_DL1MK3_Aux_5.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_aux_5_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint16_t aux_5;
};

/**
 * Signals in message RT_DL1MK3_Aux_4.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_aux_4_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint16_t aux_4;
};

/**
 * Signals in message RT_DL1MK3_Aux_3.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_aux_3_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint16_t aux_3;
};

/**
 * Signals in message RT_DL1MK3_Aux_2.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_aux_2_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint16_t aux_2;
};

/**
 * Signals in message RT_DL1MK3_Aux_1.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_aux_1_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint16_t aux_1;
};

/**
 * Signals in message RT_DL1MK3_Pressure_5.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_pressure_5_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint32_t pressure_5;
};

/**
 * Signals in message RT_DL1MK3_Pressure_4.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_pressure_4_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint32_t pressure_4;
};

/**
 * Signals in message RT_DL1MK3_Pressure_3.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_pressure_3_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint32_t pressure_3;
};

/**
 * Signals in message RT_DL1MK3_Pressure_2.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_pressure_2_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint32_t pressure_2;
};

/**
 * Signals in message RT_DL1MK3_Pressure_1.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_pressure_1_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    uint32_t pressure_1;
};

/**
 * Signals in message RT_DL1MK3_Angle_3.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_angle_3_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t angle_3;
};

/**
 * Signals in message RT_DL1MK3_Angle_2.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_angle_2_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t angle_2;
};

/**
 * Signals in message RT_DL1MK3_Angle_1.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_angle_1_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t angle_1;
};

/**
 * Signals in message RT_DL1MK3_Temp_25.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_temp_25_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t temperature_25;
};

/**
 * Signals in message RT_DL1MK3_Temp_24.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_temp_24_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t temperature_24;
};

/**
 * Signals in message RT_DL1MK3_Temp_23.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_temp_23_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t temperature_23;
};

/**
 * Signals in message RT_DL1MK3_Temp_22.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_temp_22_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t temperature_22;
};

/**
 * Signals in message RT_DL1MK3_Temp_21.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_temp_21_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t temperature_21;
};

/**
 * Signals in message RT_DL1MK3_Temp_20.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_temp_20_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t temperature_20;
};

/**
 * Signals in message RT_DL1MK3_Temp_19.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_temp_19_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t temperature_19;
};

/**
 * Signals in message RT_DL1MK3_Temp_18.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_temp_18_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t temperature_18;
};

/**
 * Signals in message RT_DL1MK3_Temp_17.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_temp_17_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t temperature_17;
};

/**
 * Signals in message RT_DL1MK3_Temp_16.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_temp_16_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t temperature_16;
};

/**
 * Signals in message RT_DL1MK3_Temp_15.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_temp_15_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t temperature_15;
};

/**
 * Signals in message RT_DL1MK3_Temp_14.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_temp_14_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t temperature_14;
};

/**
 * Signals in message RT_DL1MK3_Temp_13.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_temp_13_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t temperature_13;
};

/**
 * Signals in message RT_DL1MK3_Temp_12.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_temp_12_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t temperature_12;
};

/**
 * Signals in message RT_DL1MK3_Temp_11.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_temp_11_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t temperature_11;
};

/**
 * Signals in message RT_DL1MK3_Temp_10.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_temp_10_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t temperature_10;
};

/**
 * Signals in message RT_DL1MK3_Temp_9.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_temp_9_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t temperature_9;
};

/**
 * Signals in message RT_DL1MK3_Temp_8.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_temp_8_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t temperature_8;
};

/**
 * Signals in message RT_DL1MK3_Temp_7.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_temp_7_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t temperature_7;
};

/**
 * Signals in message RT_DL1MK3_Temp_6.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_temp_6_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t temperature_6;
};

/**
 * Signals in message RT_DL1MK3_Temp_5.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_temp_5_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t temperature_5;
};

/**
 * Signals in message RT_DL1MK3_Temp_4.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_temp_4_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t temperature_4;
};

/**
 * Signals in message RT_DL1MK3_Temp_3.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_temp_3_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t temperature_3;
};

/**
 * Signals in message RT_DL1MK3_Temp_2.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_temp_2_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t temperature_2;
};

/**
 * Signals in message RT_DL1MK3_Temp_1.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_temp_1_t {
    /**
     * Range: -
     * Scale: 0.1
     * Offset: 0
     */
    int16_t temperature_1;
};

/**
 * Signals in message RT_DL1MK3_Analog_32.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_analog_32_t {
    /**
     * Range: -
     * Scale: 0.001
     * Offset: 0
     */
    uint16_t analog_32;
};

/**
 * Signals in message RT_DL1MK3_Analog_31.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_analog_31_t {
    /**
     * Range: -
     * Scale: 0.001
     * Offset: 0
     */
    uint16_t analog_31;
};

/**
 * Signals in message RT_DL1MK3_Analog_30.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_analog_30_t {
    /**
     * Range: -
     * Scale: 0.001
     * Offset: 0
     */
    uint16_t analog_30;
};

/**
 * Signals in message RT_DL1MK3_Analog_29.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_analog_29_t {
    /**
     * Range: -
     * Scale: 0.001
     * Offset: 0
     */
    uint16_t analog_29;
};

/**
 * Signals in message RT_DL1MK3_Analog_28.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_analog_28_t {
    /**
     * Range: -
     * Scale: 0.001
     * Offset: 0
     */
    uint16_t analog_28;
};

/**
 * Signals in message RT_DL1MK3_Analog_27.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_analog_27_t {
    /**
     * Range: -
     * Scale: 0.001
     * Offset: 0
     */
    uint16_t analog_27;
};

/**
 * Signals in message RT_DL1MK3_Analog_26.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_analog_26_t {
    /**
     * Range: -
     * Scale: 0.001
     * Offset: 0
     */
    uint16_t analog_26;
};

/**
 * Signals in message RT_DL1MK3_Analog_25.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_analog_25_t {
    /**
     * Range: -
     * Scale: 0.001
     * Offset: 0
     */
    uint16_t analog_25;
};

/**
 * Signals in message RT_DL1MK3_Analog_15.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_analog_15_t {
    /**
     * Range: -
     * Scale: 0.001
     * Offset: 0
     */
    uint16_t analog_15;
};

/**
 * Signals in message RT_DL1MK3_Analog_14.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_analog_14_t {
    /**
     * Range: -
     * Scale: 0.001
     * Offset: 0
     */
    uint16_t analog_14;
};

/**
 * Signals in message RT_DL1MK3_Analog_17.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_analog_17_t {
    /**
     * Range: -
     * Scale: 0.001
     * Offset: 0
     */
    uint16_t analog_17;
};

/**
 * Signals in message RT_DL1MK3_Analog_24.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_analog_24_t {
    /**
     * Range: -
     * Scale: 0.001
     * Offset: 0
     */
    uint16_t analog_24;
};

/**
 * Signals in message RT_DL1MK3_Analog_23.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_analog_23_t {
    /**
     * Range: -
     * Scale: 0.001
     * Offset: 0
     */
    uint16_t analog_23;
};

/**
 * Signals in message RT_DL1MK3_Analog_22.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_analog_22_t {
    /**
     * Range: -
     * Scale: 0.001
     * Offset: 0
     */
    uint16_t analog_22;
};

/**
 * Signals in message RT_DL1MK3_Analog_21.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_analog_21_t {
    /**
     * Range: -
     * Scale: 0.001
     * Offset: 0
     */
    uint16_t analog_21;
};

/**
 * Signals in message RT_DL1MK3_Analog_20.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_analog_20_t {
    /**
     * Range: -
     * Scale: 0.001
     * Offset: 0
     */
    uint16_t analog_20;
};

/**
 * Signals in message RT_DL1MK3_Analog_19.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_analog_19_t {
    /**
     * Range: -
     * Scale: 0.001
     * Offset: 0
     */
    uint16_t analog_19;
};

/**
 * Signals in message RT_DL1MK3_Analog_16.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_analog_16_t {
    /**
     * Range: -
     * Scale: 0.001
     * Offset: 0
     */
    uint16_t analog_16;
};

/**
 * Signals in message RT_DL1MK3_Analog_18.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_analog_18_t {
    /**
     * Range: -
     * Scale: 0.001
     * Offset: 0
     */
    uint16_t analog_18;
};

/**
 * Signals in message RT_DL1MK3_Analog_12.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_analog_12_t {
    /**
     * Range: -
     * Scale: 0.001
     * Offset: 0
     */
    uint16_t analog_12;
};

/**
 * Signals in message RT_DL1MK3_Analog_11.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_analog_11_t {
    /**
     * Range: -
     * Scale: 0.001
     * Offset: 0
     */
    uint16_t analog_11;
};

/**
 * Signals in message RT_DL1MK3_Analog_10.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_analog_10_t {
    /**
     * Range: -
     * Scale: 0.001
     * Offset: 0
     */
    uint16_t analog_10;
};

/**
 * Signals in message RT_DL1MK3_Analog_9.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_analog_9_t {
    /**
     * Range: -
     * Scale: 0.001
     * Offset: 0
     */
    uint16_t analog_9;
};

/**
 * Signals in message RT_DL1MK3_Analog_8.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_analog_8_t {
    /**
     * Range: -
     * Scale: 0.001
     * Offset: 0
     */
    uint16_t analog_8;
};

/**
 * Signals in message RT_DL1MK3_Analog_7.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_analog_7_t {
    /**
     * Range: -
     * Scale: 0.001
     * Offset: 0
     */
    uint16_t analog_7;
};

/**
 * Signals in message RT_DL1MK3_Analog_6.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_analog_6_t {
    /**
     * Range: -
     * Scale: 0.001
     * Offset: 0
     */
    uint16_t analog_6;
};

/**
 * Signals in message RT_DL1MK3_Analog_5.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_analog_5_t {
    /**
     * Range: -
     * Scale: 0.001
     * Offset: 0
     */
    uint16_t analog_5;
};

/**
 * Signals in message RT_DL1MK3_Analog_4.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_analog_4_t {
    /**
     * Range: -
     * Scale: 0.001
     * Offset: 0
     */
    uint16_t analog_4;
};

/**
 * Signals in message RT_DL1MK3_Analog_3.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_analog_3_t {
    /**
     * Range: -
     * Scale: 0.001
     * Offset: 0
     */
    uint16_t analog_3;
};

/**
 * Signals in message RT_DL1MK3_Analog_2.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_analog_2_t {
    /**
     * Range: -
     * Scale: 0.001
     * Offset: 0
     */
    uint16_t analog_2;
};

/**
 * Signals in message RT_DL1MK3_Analog_1.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_analog_1_t {
    /**
     * Range: -
     * Scale: 0.001
     * Offset: 0
     */
    uint16_t analog_1;
};

/**
 * Signals in message RT_DL1MK3_Accel.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_dl1_mk3_accel_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_accel_longitudinal;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_accel_lateral;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_accel_vertical;

    /**
     * Dimensionless.  Lower values imply but do not guarantee better accuracy than higher values.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_accel;

    /**
     * Longitudinal acceleration.  This is positive when the vehicle accelerates in a forwards direction.
     *
     * Range: -65000..65000 (-65..65 g)
     * Scale: 0.001
     * Offset: 0
     */
    int16_t accel_longitudinal;

    /**
     * Lateral acceleration.  This is positive when the vehicle accelerates towards the right, e.g. when cornering around a right-hand bend.
     *
     * Range: -65000..65000 (-65..65 g)
     * Scale: 0.001
     * Offset: 0
     */
    int16_t accel_lateral;

    /**
     * Vertical acceleration.  This is positive when the vehicle accelerates in an upwards direction, e.g. when travelling through a dip.
     *
     * Range: -65000..65000 (-65..65 g)
     * Scale: 0.001
     * Offset: 0
     */
    int16_t accel_vertical;
};

/**
 * Signals in message RT_SB_INS_Vpt_4_Vel_NED_2.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_ins_vpt_4_vel_ned_2_t {
    /**
     * VELNED D velocity.  This is the velocity vector directly downwards towards the Earth centre at the current local Earth surface position.
     *
     * Range: -8380000..8380000 (-838..838 m/s)
     * Scale: 0.0001
     * Offset: 0
     */
    int32_t virtual_4_vel_ned_d;

    /**
     * This is GPS heading, the direction that the vehicle is travelling in the local horizontal plane.
     *
     * Range: -18000..18000 (-180..180 degrees)
     * Scale: 0.01
     * Offset: 0
     */
    int16_t virtual_4_heading;

    /**
     * Slip is defined as the difference between yaw and heading.
     *
     * Range: -18000..18000 (-180..180 degrees)
     * Scale: 0.01
     * Offset: 0
     */
    int16_t virtual_4_slip;
};

/**
 * Signals in message RT_SB_INS_Vpt_4_Vel_NED_1.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_ins_vpt_4_vel_ned_1_t {
    /**
     * VELNED N velocity.  This is the velocity vector directly North at the current local Earth surface position.
     *
     * Range: -8380000..8380000 (-838..838 m/s)
     * Scale: 0.0001
     * Offset: 0
     */
    int32_t virtual_4_vel_ned_n;

    /**
     * VELNED E velocity.  This is the velocity vector directly East at the current local Earth surface position.
     *
     * Range: -8380000..8380000 (-838..838 m/s)
     * Scale: 0.0001
     * Offset: 0
     */
    int32_t virtual_4_vel_ned_e;
};

/**
 * Signals in message RT_SB_INS_Vpt_4_Offset.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_ins_vpt_4_offset_t {
    /**
     * X offset of the virtual point in the vehicle body frame.
     *
     * Range: -32768..32767 (-32.768..32.767 m)
     * Scale: 0.001
     * Offset: 0
     */
    int16_t virtual_4_offset_x;

    /**
     * Y offset of the virtual point in the vehicle body frame.
     *
     * Range: -32768..32767 (-32.768..32.767 m)
     * Scale: 0.001
     * Offset: 0
     */
    int16_t virtual_4_offset_y;

    /**
     * Z offset (+ve downwards) of the virtual point in the vehicle body frame.
     *
     * Range: -32768..32767 (-32.768..32.767 m)
     * Scale: 0.001
     * Offset: 0
     */
    int16_t virtual_4_offset_z;
};

/**
 * Signals in message RT_SB_INS_Vpt_3_Vel_NED_2.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_ins_vpt_3_vel_ned_2_t {
    /**
     * VELNED D velocity.  This is the velocity vector directly downwards towards the Earth centre at the current local Earth surface position.
     *
     * Range: -8380000..8380000 (-838..838 m/s)
     * Scale: 0.0001
     * Offset: 0
     */
    int32_t virtual_3_vel_ned_d;

    /**
     * This is GPS heading, the direction that the vehicle is travelling in the local horizontal plane.
     *
     * Range: -18000..18000 (-180..180 degrees)
     * Scale: 0.01
     * Offset: 0
     */
    int16_t virtual_3_heading;

    /**
     * Slip is defined as the difference between yaw and heading.
     *
     * Range: -18000..18000 (-180..180 degrees)
     * Scale: 0.01
     * Offset: 0
     */
    int16_t virtual_3_slip;
};

/**
 * Signals in message RT_SB_INS_Vpt_3_Vel_NED_1.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_ins_vpt_3_vel_ned_1_t {
    /**
     * VELNED N velocity.  This is the velocity vector directly North at the current local Earth surface position.
     *
     * Range: -8380000..8380000 (-838..838 m/s)
     * Scale: 0.0001
     * Offset: 0
     */
    int32_t virtual_3_vel_ned_n;

    /**
     * VELNED E velocity.  This is the velocity vector directly East at the current local Earth surface position.
     *
     * Range: -8380000..8380000 (-838..838 m/s)
     * Scale: 0.0001
     * Offset: 0
     */
    int32_t virtual_3_vel_ned_e;
};

/**
 * Signals in message RT_SB_INS_Vpt_3_Offset.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_ins_vpt_3_offset_t {
    /**
     * X offset of the virtual point in the vehicle body frame.
     *
     * Range: -32768..32767 (-32.768..32.767 m)
     * Scale: 0.001
     * Offset: 0
     */
    int16_t virtual_3_offset_x;

    /**
     * Y offset of the virtual point in the vehicle body frame.
     *
     * Range: -32768..32767 (-32.768..32.767 m)
     * Scale: 0.001
     * Offset: 0
     */
    int16_t virtual_3_offset_y;

    /**
     * Z offset (+ve downwards) of the virtual point in the vehicle body frame.
     *
     * Range: -32768..32767 (-32.768..32.767 m)
     * Scale: 0.001
     * Offset: 0
     */
    int16_t virtual_3_offset_z;
};

/**
 * Signals in message RT_SB_INS_Vpt_2_Vel_NED_2.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_ins_vpt_2_vel_ned_2_t {
    /**
     * VELNED D velocity.  This is the velocity vector directly downwards towards the Earth centre at the current local Earth surface position.
     *
     * Range: -8380000..8380000 (-838..838 m/s)
     * Scale: 0.0001
     * Offset: 0
     */
    int32_t virtual_2_vel_ned_d;

    /**
     * This is GPS heading, the direction that the vehicle is travelling in the local horizontal plane.
     *
     * Range: -18000..18000 (-180..180 degrees)
     * Scale: 0.01
     * Offset: 0
     */
    int16_t virtual_2_heading;

    /**
     * Slip is defined as the difference between yaw and heading.
     *
     * Range: -18000..18000 (-180..180 degrees)
     * Scale: 0.01
     * Offset: 0
     */
    int16_t virtual_2_slip;
};

/**
 * Signals in message RT_SB_INS_Vpt_2_Vel_NED_1.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_ins_vpt_2_vel_ned_1_t {
    /**
     * VELNED N velocity.  This is the velocity vector directly North at the current local Earth surface position.
     *
     * Range: -8380000..8380000 (-838..838 m/s)
     * Scale: 0.0001
     * Offset: 0
     */
    int32_t virtual_2_vel_ned_n;

    /**
     * VELNED E velocity.  This is the velocity vector directly East at the current local Earth surface position.
     *
     * Range: -8380000..8380000 (-838..838 m/s)
     * Scale: 0.0001
     * Offset: 0
     */
    int32_t virtual_2_vel_ned_e;
};

/**
 * Signals in message RT_SB_INS_Vpt_2_Offset.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_ins_vpt_2_offset_t {
    /**
     * X offset of the virtual point in the vehicle body frame.
     *
     * Range: -32768..32767 (-32.768..32.767 m)
     * Scale: 0.001
     * Offset: 0
     */
    int16_t virtual_2_offset_x;

    /**
     * Y offset of the virtual point in the vehicle body frame.
     *
     * Range: -32768..32767 (-32.768..32.767 m)
     * Scale: 0.001
     * Offset: 0
     */
    int16_t virtual_2_offset_y;

    /**
     * Z offset (+ve downwards) of the virtual point in the vehicle body frame.
     *
     * Range: -32768..32767 (-32.768..32.767 m)
     * Scale: 0.001
     * Offset: 0
     */
    int16_t virtual_2_offset_z;
};

/**
 * Signals in message RT_SB_INS_Vpt_1_Vel_NED_2.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_ins_vpt_1_vel_ned_2_t {
    /**
     * VELNED D velocity.  This is the velocity vector directly downwards towards the Earth centre at the current local Earth surface position.
     *
     * Range: -8380000..8380000 (-838..838 m/s)
     * Scale: 0.0001
     * Offset: 0
     */
    int32_t virtual_1_vel_ned_d;

    /**
     * This is GPS heading, the direction that the vehicle is travelling in the local horizontal plane.
     *
     * Range: -18000..18000 (-180..180 degrees)
     * Scale: 0.01
     * Offset: 0
     */
    int16_t virtual_1_heading;

    /**
     * Slip is defined as the difference between yaw and heading.
     *
     * Range: -18000..18000 (-180..180 degrees)
     * Scale: 0.01
     * Offset: 0
     */
    int16_t virtual_1_slip;
};

/**
 * Signals in message RT_SB_INS_Vpt_1_Vel_NED_1.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_ins_vpt_1_vel_ned_1_t {
    /**
     * VELNED N velocity.  This is the velocity vector directly North at the current local Earth surface position.
     *
     * Range: -8380000..8380000 (-838..838 m/s)
     * Scale: 0.0001
     * Offset: 0
     */
    int32_t virtual_1_vel_ned_n;

    /**
     * VELNED E velocity.  This is the velocity vector directly East at the current local Earth surface position.
     *
     * Range: -8380000..8380000 (-838..838 m/s)
     * Scale: 0.0001
     * Offset: 0
     */
    int32_t virtual_1_vel_ned_e;
};

/**
 * Signals in message RT_SB_INS_Vpt_1_Offset.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_ins_vpt_1_offset_t {
    /**
     * X offset of the virtual point in the vehicle body frame.
     *
     * Range: -32768..32767 (-32.768..32.767 m)
     * Scale: 0.001
     * Offset: 0
     */
    int16_t virtual_1_offset_x;

    /**
     * Y offset of the virtual point in the vehicle body frame.
     *
     * Range: -32768..32767 (-32.768..32.767 m)
     * Scale: 0.001
     * Offset: 0
     */
    int16_t virtual_1_offset_y;

    /**
     * Z offset (+ve downwards) of the virtual point in the vehicle body frame.
     *
     * Range: -32768..32767 (-32.768..32.767 m)
     * Scale: 0.001
     * Offset: 0
     */
    int16_t virtual_1_offset_z;
};

/**
 * Signals in message RT_SB_INS_Slip.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_ins_slip_t {
    /**
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_ins_slip;

    /**
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_ins_squat;

    /**
     * Dimensionless.  Lower values imply but do not guarantee better accuracy than higher values.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_ins_slip;

    /**
     * Slip is defined as the difference between yaw and heading
     *
     * Range: -36000..36000 (-360..360 degrees)
     * Scale: 0.01
     * Offset: 0
     */
    int16_t ins_slip;

    /**
     * Dimensionless.  Lower values imply but do not guarantee better accuracy than higher values.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_ins_squat;

    /**
     * Squat is defined as the difference between pitch and gradient
     *
     * Range: -36000..36000 (-360..360 degrees)
     * Scale: 0.01
     * Offset: 0
     */
    int16_t ins_squat;
};

/**
 * Signals in message RT_SB_INS_Vel_ECEF_2.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_ins_vel_ecef_2_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_ins_vel_ecef_y;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_ins_vel_ecef_z;

    /**
     * ECEF Y velocity.  The ECEF Y axis originates from the Earth centre, and the positive Y axis intersects the Earth surface at zero degrees latittude and 90 degrees longitude.
     *
     * Range: -8380000..8380000 (-838..838 m/s)
     * Scale: 0.0001
     * Offset: 0
     */
    int32_t ins_vel_ecef_y;

    /**
     * ECEF Z velocity.  The ECEF Z axis originates from the Earth centre, and the positive Z axis intersects the Earth surface at the North Pole.
     *
     * Range: -8380000..8380000 (-838..838 m/s)
     * Scale: 0.0001
     * Offset: 0
     */
    int32_t ins_vel_ecef_z;
};

/**
 * Signals in message RT_SB_INS_Vel_ECEF_1.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_ins_vel_ecef_1_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_ins_vel_ecef_x;

    /**
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_ins_vel_ecef_x;

    /**
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_ins_vel_ecef_y;

    /**
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_ins_vel_ecef_z;

    /**
     * ECEF X velocity.  The ECEF X axis originates from the Earth centre, and the positive X axis intersects the Earth surface at zero degrees latittude and zero degrees longitude (the intersection of the equator and the prime meridian).
     *
     * Range: -8380000..8380000 (-838..838 m/s)
     * Scale: 0.0001
     * Offset: 0
     */
    int32_t ins_vel_ecef_x;
};

/**
 * Signals in message RT_SB_INS_Vel_NED_2.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_ins_vel_ned_2_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_ins_vel_ned_d;

    /**
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_ins_vel_d;

    /**
     * VELNED D velocity.  This is the velocity vector directly downwards towards the Earth centre at the current local Earth surface position.
     *
     * Range: -8380000..8380000 (-838..838 m/s)
     * Scale: 0.0001
     * Offset: 0
     */
    int32_t ins_vel_ned_d;
};

/**
 * Signals in message RT_SB_INS_Vel_NED_1.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_ins_vel_ned_1_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_ins_vel_ned_n;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_ins_vel_ned_e;

    /**
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_ins_vel_ne;

    /**
     * VELNED N velocity.  This is the velocity vector directly North at the current local Earth surface position.
     *
     * Range: -8380000..8380000 (-838..838 m/s)
     * Scale: 0.0001
     * Offset: 0
     */
    int32_t ins_vel_ned_n;

    /**
     * VELNED E velocity.  This is the velocity vector directly East at the current local Earth surface position.
     *
     * Range: -8380000..8380000 (-838..838 m/s)
     * Scale: 0.0001
     * Offset: 0
     */
    int32_t ins_vel_ned_e;
};

/**
 * Signals in message RT_SB_INS_Pos_ECEF_2.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_ins_pos_ecef_2_t {
    /**
     * ECEF Y position.  The ECEF Y axis originates from the Earth centre, and the positive Y axis intersects the Earth surface at zero degrees latittude and 90 degrees longitude.
     *
     * Range: -1000000000..1000000000 (-10000000..10000000 m)
     * Scale: 0.01
     * Offset: 0
     */
    int32_t ins_pos_ecef_y;

    /**
     * ECEF Z position.  The ECEF Z axis originates from the Earth centre, and the positive Z axis intersects the Earth surface at the North Pole.
     *
     * Range: -1000000000..1000000000 (-10000000..10000000 m)
     * Scale: 0.01
     * Offset: 0
     */
    int32_t ins_pos_ecef_z;
};

/**
 * Signals in message RT_SB_INS_Pos_ECEF_1.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_ins_pos_ecef_1_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_ins_pos_ecef_x;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_ins_pos_ecef_y;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_ins_pos_ecef_z;

    /**
     * Dimensionless.  Lower values imply but do not guarantee better accuracy than higher values.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_ins_pos_ecef_x;

    /**
     * Dimensionless.  Lower values imply but do not guarantee better accuracy than higher values.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_ins_pos_ecef_y;

    /**
     * Dimensionless.  Lower values imply but do not guarantee better accuracy than higher values.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_ins_pos_ecef_z;

    /**
     * ECEF X position.  The ECEF X axis originates from the Earth centre, and the positive X axis intersects the Earth surface at zero degrees latittude and zero degrees longitude (the intersection of the equator and the prime meridian).
     *
     * Range: -1000000000..1000000000 (-10000000..10000000 m)
     * Scale: 0.01
     * Offset: 0
     */
    int32_t ins_pos_ecef_x;
};

/**
 * Signals in message RT_SB_INS_Pos_LLH_2.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_ins_pos_llh_2_t {
    /**
     * Range: -1800000000..1800000000 (-180..180 degrees)
     * Scale: 1e-07
     * Offset: 0
     */
    int32_t ins_pos_llh_longitude;

    /**
     * Range: -1000000..100000000 (-1000..100000 m)
     * Scale: 0.001
     * Offset: 0
     */
    int32_t ins_pos_llh_altitude;
};

/**
 * Signals in message RT_SB_INS_Pos_LLH_1.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_ins_pos_llh_1_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_ins_pos_llh_latitude;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_ins_pos_llh_longitude;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_ins_pos_llh_altitude;

    /**
     * This accuracy value applies to both 2D and 3D GPS speed.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_ins_pos_llh_latitude;

    /**
     * This accuracy value applies to both 2D and 3D GPS speed.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_ins_pos_llh_longitude;

    /**
     * This accuracy value applies to both 2D and 3D GPS speed.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_ins_pos_llh_altitude;

    /**
     * Range: -900000000..900000000 (-90..90 degrees)
     * Scale: 1e-07
     * Offset: 0
     */
    int32_t ins_pos_llh_latitude;
};

/**
 * Signals in message RT_SB_INS_Heading_Gradient_2.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_ins_heading_gradient_2_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_ins_heading;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_ins_gradient;

    /**
     * Dimensionless.  Lower values imply but do not guarantee better accuracy than higher values.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_ins_heading;

    /**
     * This is GPS heading in the range 0 - 360°, the direction that the vehicle is travelling in the local horizontal plane.
     *
     * Range: 0..36000 (0..360 degrees)
     * Scale: 0.01
     * Offset: 0
     */
    uint16_t ins_heading_2;

    /**
     * Dimensionless.  Lower values imply but do not guarantee better accuracy than higher values.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_ins_gradient;

    /**
     * This is GPS gradient, i.e. the vertical direction that the vehicle is travelling, NOT pointing (pitch).
     *
     * Range: -9000..9000 (-90..90 degrees)
     * Scale: 0.01
     * Offset: 0
     */
    int16_t ins_gradient;
};

/**
 * Signals in message RT_SB_INS_Heading_Gradient.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_ins_heading_gradient_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_ins_heading;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_ins_gradient;

    /**
     * Dimensionless.  Lower values imply but do not guarantee better accuracy than higher values.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_ins_heading;

    /**
     * This is GPS heading, the direction that the vehicle is travelling in the local horizontal plane.
     *
     * Range: -18000..18000 (-180..180 degrees)
     * Scale: 0.01
     * Offset: 0
     */
    int16_t ins_heading;

    /**
     * Dimensionless.  Lower values imply but do not guarantee better accuracy than higher values.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_ins_gradient;

    /**
     * This is GPS gradient, i.e. the vertical direction that the vehicle is travelling, NOT pointing (pitch).
     *
     * Range: -9000..9000 (-90..90 degrees)
     * Scale: 0.01
     * Offset: 0
     */
    int16_t ins_gradient;
};

/**
 * Signals in message RT_SB_INS_Status.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_ins_status_t {
    /**
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t ins_status;
};

/**
 * Signals in message RT_SB_INS_Attitude.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_ins_attitude_t {
    /**
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_yaw;

    /**
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_pitch;

    /**
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_roll;

    /**
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_attitude;

    /**
     * Range: -36000..36000 (-360..360 degrees)
     * Scale: 0.01
     * Offset: 0
     */
    int16_t attitude_yaw;

    /**
     * Range: -36000..36000 (-360..360 degrees)
     * Scale: 0.01
     * Offset: 0
     */
    int16_t attitude_pitch;

    /**
     * Range: -36000..36000 (-360..360 degrees)
     * Scale: 0.01
     * Offset: 0
     */
    int16_t attitude_roll;
};

/**
 * Signals in message RT_SB_Output_Status.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_output_status_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_status_timestamp;

    /**
     * Analogue output status for channel 1.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t status_analogue_1;

    /**
     * Analogue output status for channel 1.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t status_analogue_2;

    /**
     * Analogue output status for channel 3.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t status_analogue_3;

    /**
     * Analogue output status for channel 4.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t status_analogue_4;

    /**
     * Pulse output activity status
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t status_pulse_output;

    /**
     * Status output of serial port 1
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t status_serial_output_1;

    /**
     * Status output of serial port 1
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t status_serial_output_2;

    /**
     * Status of the trigger input
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t status_trigger;

    /**
     * GPS time is the time in seconds since midnight GMT on Saturday night.
     *
     * Range: 0..604800000 (0..604800 s)
     * Scale: 0.001
     * Offset: 0
     */
    uint32_t gps_time;
};

/**
 * Signals in message RT_SB_GPS_Heading_Gradient_2.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_gps_heading_gradient_2_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gps_heading;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gps_gradient;

    /**
     * Dimensionless.  Lower values imply but do not guarantee better accuracy than higher values.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_gps_heading;

    /**
     * This is GPS heading in the range 0 - 360°, the direction that the vehicle is travelling in the local horizontal plane.
     *
     * Range: 0..36000 (0..360 degrees)
     * Scale: 0.01
     * Offset: 0
     */
    uint16_t gps_heading_2;

    /**
     * Dimensionless.  Lower values imply but do not guarantee better accuracy than higher values.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_gps_gradient;

    /**
     * This is GPS gradient, i.e. the vertical direction that the vehicle is travelling, NOT pointing (pitch).
     *
     * Range: -9000..9000 (-90..90 degrees)
     * Scale: 0.01
     * Offset: 0
     */
    int16_t gps_gradient;
};

/**
 * Signals in message RT_SB_Cumulative_Distance_2.
 *
 * This cumulative distance calculation is updated when the trigger is active.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_cumulative_distance_2_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_cumulative_time;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_cumulative_distance;

    /**
     * Range: 0..16777200 (0..167772 s)
     * Scale: 0.01
     * Offset: 0
     */
    uint32_t cumulative_time;

    /**
     * Range: 0..4294967000 (0..4294967 m)
     * Scale: 0.001
     * Offset: 0
     */
    uint32_t cumulative_distance;
};

/**
 * Signals in message RT_SB_Cumulative_Distance_1.
 *
 * This cumulative distance calculation is updated continuously once the first good GPS lock is obtained.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_cumulative_distance_1_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_cumulative_time;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_cumulative_distance;

    /**
     * Range: 0..16777200 (0..167772 s)
     * Scale: 0.01
     * Offset: 0
     */
    uint32_t cumulative_time;

    /**
     * Range: 0..4294967000 (0..4294967 m)
     * Scale: 0.001
     * Offset: 0
     */
    uint32_t cumulative_distance;
};

/**
 * Signals in message RT_SB_Trigger_Timestamp.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_trigger_timestamp_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_trigger_timestamp;

    /**
     * Dimensionless.  Lower values imply but do not guarantee better accuracy than higher values.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_trigger_timestamp;

    /**
     * This is the ID of the trigger that generated the event, as marked on the case of the logger
     *
     * Range: -1..127 (0..128 -)
     * Scale: 1
     * Offset: 1
     */
    uint8_t trigger_number;

    /**
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t trigger_timestamp_type;

    /**
     * GPS time of week to micro-second resolution.
     *
     * Range: 0..604800000000 (0..604800 s)
     * Scale: 1e-06
     * Offset: 0
     */
    uint64_t gps_high_resolution_time;
};

/**
 * Signals in message RT_IMU06_Gyro_Rates.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_imu06_gyro_rates_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gyro_rate_yaw;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gyro_rate_pitch;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gyro_rate_roll;

    /**
     * Dimensionless.  Lower values imply but do not guarantee better accuracy than higher values.
     *
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_gyro_rates;

    /**
     * Yaw rate is positive for clockwise rotation when looking down on the vehicle from above.
     *
     * Range: -32700..32700 (-327..327 degrees/s)
     * Scale: 0.01
     * Offset: 0
     */
    int16_t gyro_rate_yaw;

    /**
     * Pitch rate is positive for clockwise rotation when looking at the left hand side of the vehicle from the left of the vehicle.
     *
     * Range: -32700..32700 (-327..327 degrees/s)
     * Scale: 0.01
     * Offset: 0
     */
    int16_t gyro_rate_pitch;

    /**
     * Roll rate is positive for clockwise rotation when looking at the rear of the vehicle from behind the vehicle.
     *
     * Range: -32700..32700 (-327..327 degrees/s)
     * Scale: 0.01
     * Offset: 0
     */
    int16_t gyro_rate_roll;
};

/**
 * Signals in message RT_IMU06_Accel.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_imu06_accel_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_accel_longitudinal;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_accel_lateral;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_accel_vertical;

    /**
     * Dimensionless.  Lower values imply but do not guarantee better accuracy than higher values.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_accel;

    /**
     * Longitudinal acceleration.  This is positive when the vehicle accelerates in a forwards direction.
     *
     * Range: -65000..65000 (-65..65 g)
     * Scale: 0.001
     * Offset: 0
     */
    int16_t accel_longitudinal;

    /**
     * Lateral acceleration.  This is positive when the vehicle accelerates towards the right, e.g. when cornering around a right-hand bend.
     *
     * Range: -65000..65000 (-65..65 g)
     * Scale: 0.001
     * Offset: 0
     */
    int16_t accel_lateral;

    /**
     * Vertical acceleration.  This is positive when the vehicle accelerates in an upwards direction, e.g. when travelling through a dip.
     *
     * Range: -65000..65000 (-65..65 g)
     * Scale: 0.001
     * Offset: 0
     */
    int16_t accel_vertical;
};

/**
 * Signals in message RT_SB_Speed.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_speed_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_speed;

    /**
     * Dimensionless.  Lower values imply but do not guarantee better accuracy than higher values.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_speed;

    /**
     * Range: -2000000000..2000000000 (-20000..20000 m/s)
     * Scale: 1e-05
     * Offset: 0
     */
    int32_t speed;
};

/**
 * Signals in message RT_SB_RTK_Slip.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_rtk_slip_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_rtk_slip;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_rtk_squat;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_rtk_baseline;

    /**
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_rtk_baseline;

    /**
     * Slip is defined as the difference between yaw and heading.
     *
     * Range: -36000..36000 (-360..360 degrees)
     * Scale: 0.01
     * Offset: 0
     */
    int16_t rtk_slip;

    /**
     * Squat is defined as the difference between pitch and gradient.
     *
     * Range: -36000..36000 (-360..360 degrees)
     * Scale: 0.01
     * Offset: 0
     */
    int16_t rtk_squat;

    /**
     * This is the estimated baseline length calculated by the RTK solution.
     *
     * Range: 0..65535 (0..65535 mm)
     * Scale: 1
     * Offset: 0
     */
    uint16_t rtk_baseline;
};

/**
 * Signals in message RT_SB_RTK_Attitude.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_rtk_attitude_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_rtk_yaw;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_rtk_pitch;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_rtk_roll;

    /**
     * Note that RTK yaw is typically up to about 4 times more accurate than RTK pitch or roll.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_rtk_attitude;

    /**
     * RTK attitude is determined from the MB-RTK solution only.  Yaw is positive for a clockwise rotational displacement from due North, looking down on the vehicle from above.
     *
     * Range: -36000..36000 (-360..360 degrees)
     * Scale: 0.01
     * Offset: 0
     */
    int16_t rtk_attitude_yaw;

    /**
     * RTK attitude is determined from the MB-RTK solution only.  Pitch is positive for a clockwise rotational displacement from the local horizontal plane when looking at the vehicle from the left hand side of it.
     *
     * Range: -9000..9000 (-90..90 degrees)
     * Scale: 0.01
     * Offset: 0
     */
    int16_t rtk_attitude_pitch;

    /**
     * RTK attitude is determined from the MB-RTK solution only.  Roll is positive for a clockwise rotational displacement relative to the local horizontal plane when looking at the vehicle from the rear of it.
     *
     * Range: -9000..9000 (-90..90 degrees)
     * Scale: 0.01
     * Offset: 0
     */
    int16_t rtk_attitude_roll;
};

/**
 * Signals in message RT_SB_GPS_Mcycle_Lean.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_gps_mcycle_lean_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gps_lateral_accel;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gps_mcycle_lean;

    /**
     * This accuracy value applies to both GPS-derived lateral acceleration and motorcycle lean angle, since both are derived from the rate of change of GPS heading.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_gps_lateral_accel;

    /**
     * GPS-derived lateral acceleration.  This is derived by differentiating GPS heading - it is much more noisy than lateral accel from the accelerometers, but useful for m/cycle applications.
     *
     * Range: -65000..65000 (-65..65 g)
     * Scale: 0.001
     * Offset: 0
     */
    int16_t gps_lateral_accel;

    /**
     * Motorcycle lean angle, derived from rate of change of heading from GPS.  This is the lean angle of the centre of mass of the combined bike + rider.
     *
     * Range: -9000..9000 (-90..90 degrees)
     * Scale: 0.01
     * Offset: 0
     */
    int16_t gps_mcycle_lean_angle;
};

/**
 * Signals in message RT_SB_GPS_Status.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_gps_status_t {
    /**
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t gps_status;

    /**
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t firmware_version_major;

    /**
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t firmware_version_intermediate;

    /**
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t firmware_version_minor;

    /**
     * Number of satellites used in GPS solution
     *
     * Range: 0..16 (0..16 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t gps_n_sv;

    /**
     * Number of satellites used in GPS solution by module 2 on RTK units.
     *
     * Range: 0..16 (0..16 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t gps_n_sv_2;

    /**
     * Number of common satellites available to RTK solution
     *
     * Range: 0..16 (0..16 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t gps_n_sv_rtk;

    /**
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t rtk_status;
};

/**
 * Signals in message RT_SB_GPS_Pos_ECEF_2.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_gps_pos_ecef_2_t {
    /**
     * ECEF Y position.  The ECEF Y axis originates from the Earth centre, and the positive Y axis intersects the Earth surface at zero degrees latittude and 90 degrees longitude.
     *
     * Range: -1000000000..1000000000 (-10000000..10000000 m)
     * Scale: 0.01
     * Offset: 0
     */
    int32_t gps_pos_ecef_y;

    /**
     * ECEF Z position.  The ECEF Z axis originates from the Earth centre, and the positive Z axis intersects the Earth surface at the North Pole.
     *
     * Range: -1000000000..1000000000 (-10000000..10000000 m)
     * Scale: 0.01
     * Offset: 0
     */
    int32_t gps_pos_ecef_z;
};

/**
 * Signals in message RT_SB_GPS_Pos_ECEF_1.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_gps_pos_ecef_1_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gps_pos_ecef_x;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gps_pos_ecef_y;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gps_pos_ecef_z;

    /**
     * Dimensionless.  Lower values imply but do not guarantee better accuracy than higher values.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_gps_pos_ecef_x;

    /**
     * Dimensionless.  Lower values imply but do not guarantee better accuracy than higher values.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_gps_pos_ecef_y;

    /**
     * Dimensionless.  Lower values imply but do not guarantee better accuracy than higher values.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_gps_pos_ecef_z;

    /**
     * ECEF X position.  The ECEF X axis originates from the Earth centre, and the positive X axis intersects the Earth surface at zero degrees latittude and zero degrees longitude (the intersection of the equator and the prime meridian).
     *
     * Range: -1000000000..1000000000 (-10000000..10000000 m)
     * Scale: 0.01
     * Offset: 0
     */
    int32_t gps_pos_ecef_x;
};

/**
 * Signals in message RT_SB_GPS_Pos_LLH_2.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_gps_pos_llh_2_t {
    /**
     * Range: -1800000000..1800000000 (-180..180 degrees)
     * Scale: 1e-07
     * Offset: 0
     */
    int32_t gps_pos_llh_longitude;

    /**
     * Range: -1000000..100000000 (-1000..100000 m)
     * Scale: 0.001
     * Offset: 0
     */
    int32_t gps_pos_llh_altitude;
};

/**
 * Signals in message RT_SB_GPS_Pos_LLH_1.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_gps_pos_llh_1_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gps_pos_llh_latitude;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gps_pos_llh_longitude;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gps_pos_llh_altitude;

    /**
     * This accuracy value applies to both 2D and 3D GPS speed.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_gps_pos_llh_latitude;

    /**
     * This accuracy value applies to both 2D and 3D GPS speed.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_gps_pos_llh_longitude;

    /**
     * This accuracy value applies to both 2D and 3D GPS speed.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_gps_pos_llh_altitude;

    /**
     * Range: -900000000..900000000 (-90..90 degrees)
     * Scale: 1e-07
     * Offset: 0
     */
    int32_t gps_pos_llh_latitude;
};

/**
 * Signals in message RT_SB_GPS_Heading_Gradient.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_gps_heading_gradient_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gps_heading;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gps_gradient;

    /**
     * Dimensionless.  Lower values imply but do not guarantee better accuracy than higher values.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_gps_heading;

    /**
     * This is GPS heading, the direction that the vehicle is travelling in the local horizontal plane.
     *
     * Range: -18000..18000 (-180..180 degrees)
     * Scale: 0.01
     * Offset: 0
     */
    int16_t gps_heading;

    /**
     * Dimensionless.  Lower values imply but do not guarantee better accuracy than higher values.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_gps_gradient;

    /**
     * This is GPS gradient, i.e. the vertical direction that the vehicle is travelling, NOT pointing (pitch).
     *
     * Range: -9000..9000 (-90..90 degrees)
     * Scale: 0.01
     * Offset: 0
     */
    int16_t gps_gradient;
};

/**
 * Signals in message RT_SB_GPS_Vel_ECEF_2.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_gps_vel_ecef_2_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gps_vel_ecef_y;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gps_vel_ecef_z;

    /**
     * ECEF Y velocity.  The ECEF Y axis originates from the Earth centre, and the positive Y axis intersects the Earth surface at zero degrees latittude and 90 degrees longitude.
     *
     * Range: -8380000..8380000 (-838..838 m/s)
     * Scale: 0.0001
     * Offset: 0
     */
    int32_t gps_vel_ecef_y;

    /**
     * ECEF Z velocity.  The ECEF Z axis originates from the Earth centre, and the positive Z axis intersects the Earth surface at the North Pole.
     *
     * Range: -8380000..8380000 (-838..838 m/s)
     * Scale: 0.0001
     * Offset: 0
     */
    int32_t gps_vel_ecef_z;
};

/**
 * Signals in message RT_SB_GPS_Vel_ECEF_1.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_gps_vel_ecef_1_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gps_vel_ecef_x;

    /**
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_gps_vel_ecef_x;

    /**
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_gps_vel_ecef_y;

    /**
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_gps_vel_ecef_z;

    /**
     * ECEF X velocity.  The ECEF X axis originates from the Earth centre, and the positive X axis intersects the Earth surface at zero degrees latittude and zero degrees longitude (the intersection of the equator and the prime meridian).
     *
     * Range: -8380000..8380000 (-838..838 m/s)
     * Scale: 0.0001
     * Offset: 0
     */
    int32_t gps_vel_ecef_x;
};

/**
 * Signals in message RT_SB_GPS_Vel_NED_2.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_gps_vel_ned_2_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gps_vel_ned_d;

    /**
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_gps_vel_d;

    /**
     * VELNED D velocity.  This is the velocity vector directly downwards towards the Earth centre at the current local Earth surface position.
     *
     * Range: -8380000..8380000 (-838..838 m/s)
     * Scale: 0.0001
     * Offset: 0
     */
    int32_t gps_vel_ned_d;
};

/**
 * Signals in message RT_SB_GPS_Vel_NED_1.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_gps_vel_ned_1_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gps_vel_ned_n;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gps_vel_ned_e;

    /**
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_gps_vel_ne;

    /**
     * VELNED N velocity.  This is the velocity vector directly North at the current local Earth surface position.
     *
     * Range: -8380000..8380000 (-838..838 m/s)
     * Scale: 0.0001
     * Offset: 0
     */
    int32_t gps_vel_ned_n;

    /**
     * VELNED E velocity.  This is the velocity vector directly East at the current local Earth surface position.
     *
     * Range: -8380000..8380000 (-838..838 m/s)
     * Scale: 0.0001
     * Offset: 0
     */
    int32_t gps_vel_ned_e;
};

/**
 * Signals in message RT_SB_GPS_Speed.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_gps_speed_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gps_speed_2_d;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gps_speed_3_d;

    /**
     * This accuracy value applies to both 2D and 3D GPS speed.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_gps_speed;

    /**
     * This is GPS scalar 2D speed - scalar speed with no local Z axis component included.
     *
     * Range: 0..16750000 (0..1675 m/s)
     * Scale: 0.0001
     * Offset: 0
     */
    uint32_t gps_speed_2_d;

    /**
     * This is GPS scalar 3D speed - scalar speed with the local Z axis component included.
     *
     * Range: 0..16750000 (0..1675 m/s)
     * Scale: 0.0001
     * Offset: 0
     */
    uint32_t gps_speed_3_d;
};

/**
 * Signals in message RT_SB_GPS_Time.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_gps_time_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gps_time;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gps_week;

    /**
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_gps_time;

    /**
     * GPS time is the time in seconds since midnight GMT on Saturday night.
     *
     * Range: 0..604800000 (0..604800 s)
     * Scale: 0.001
     * Offset: 0
     */
    uint32_t gps_time;

    /**
     * Range: 0..65535 (0..65535 -)
     * Scale: 1
     * Offset: 0
     */
    uint16_t gps_week;
};

/**
 * Signals in message RT_SB_Accel.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_accel_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_accel_longitudinal;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_accel_lateral;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_accel_vertical;

    /**
     * Dimensionless.  Lower values imply but do not guarantee better accuracy than higher values.
     *
     * Range: 0..255 (0..255 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_accel;

    /**
     * Longitudinal acceleration.  This is positive when the vehicle accelerates in a forwards direction.
     *
     * Range: -65000..65000 (-65..65 g)
     * Scale: 0.001
     * Offset: 0
     */
    int16_t accel_longitudinal;

    /**
     * Lateral acceleration.  This is positive when the vehicle accelerates towards the right, e.g. when cornering around a right-hand bend.
     *
     * Range: -65000..65000 (-65..65 g)
     * Scale: 0.001
     * Offset: 0
     */
    int16_t accel_lateral;

    /**
     * Vertical acceleration.  This is positive when the vehicle accelerates in an upwards direction, e.g. when travelling through a dip.
     *
     * Range: -65000..65000 (-65..65 g)
     * Scale: 0.001
     * Offset: 0
     */
    int16_t accel_vertical;
};

/**
 * Signals in message RT_SB_Gyro_Rates.
 *
 * All signal values are as on the CAN bus.
 */
struct vehicle_rt_sb_gyro_rates_t {
    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gyro_rate_yaw;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gyro_rate_pitch;

    /**
     * Valid when bit is set, invalid when bit is clear.
     *
     * Range: 0..1 (0..1 -)
     * Scale: 1
     * Offset: 0
     */
    uint8_t validity_gyro_rate_roll;

    /**
     * Dimensionless.  Lower values imply but do not guarantee better accuracy than higher values.
     *
     * Range: -
     * Scale: 1
     * Offset: 0
     */
    uint8_t accuracy_gyro_rates;

    /**
     * Yaw rate is positive for clockwise rotation when looking down on the vehicle from above.
     *
     * Range: -32700..32700 (-327..327 degrees/s)
     * Scale: 0.01
     * Offset: 0
     */
    int16_t gyro_rate_yaw;

    /**
     * Pitch rate is positive for clockwise rotation when looking at the left hand side of the vehicle from the left of the vehicle.
     *
     * Range: -32700..32700 (-327..327 degrees/s)
     * Scale: 0.01
     * Offset: 0
     */
    int16_t gyro_rate_pitch;

    /**
     * Roll rate is positive for clockwise rotation when looking at the rear of the vehicle from behind the vehicle.
     *
     * Range: -32700..32700 (-327..327 degrees/s)
     * Scale: 0.01
     * Offset: 0
     */
    int16_t gyro_rate_roll;
};

/**
 * Pack message RT_SB_INS_Vel_Body_Axes.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_ins_vel_body_axes_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_ins_vel_body_axes_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_INS_Vel_Body_Axes.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_ins_vel_body_axes_unpack(
    struct vehicle_rt_sb_ins_vel_body_axes_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_INS_Vel_Body_Axes.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_ins_vel_body_axes_init(struct vehicle_rt_sb_ins_vel_body_axes_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_vel_body_axes_validity_ins_vel_forwards_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vel_body_axes_validity_ins_vel_forwards_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vel_body_axes_validity_ins_vel_forwards_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_vel_body_axes_validity_ins_vel_sideways_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vel_body_axes_validity_ins_vel_sideways_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vel_body_axes_validity_ins_vel_sideways_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_vel_body_axes_accuracy_ins_vel_body_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vel_body_axes_accuracy_ins_vel_body_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vel_body_axes_accuracy_ins_vel_body_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_ins_vel_body_axes_ins_vel_forwards_2_d_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vel_body_axes_ins_vel_forwards_2_d_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vel_body_axes_ins_vel_forwards_2_d_is_in_range(int32_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_ins_vel_body_axes_ins_vel_sideways_2_d_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vel_body_axes_ins_vel_sideways_2_d_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vel_body_axes_ins_vel_sideways_2_d_is_in_range(int32_t value);

/**
 * Pack message RT_DL1MK3_Speed.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_speed_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_speed_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Speed.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_speed_unpack(
    struct vehicle_rt_dl1_mk3_speed_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Speed.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_speed_init(struct vehicle_rt_dl1_mk3_speed_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_dl1_mk3_speed_validity_speed_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_speed_validity_speed_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_speed_validity_speed_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_dl1_mk3_speed_accuracy_speed_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_speed_accuracy_speed_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_speed_accuracy_speed_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_dl1_mk3_speed_speed_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_speed_speed_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_speed_speed_is_in_range(int32_t value);

/**
 * Pack message RT_DL1MK3_GPS_Time.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_gps_time_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_gps_time_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_GPS_Time.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_gps_time_unpack(
    struct vehicle_rt_dl1_mk3_gps_time_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_GPS_Time.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_gps_time_init(struct vehicle_rt_dl1_mk3_gps_time_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_dl1_mk3_gps_time_validity_gps_time_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_gps_time_validity_gps_time_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_gps_time_validity_gps_time_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_dl1_mk3_gps_time_validity_gps_week_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_gps_time_validity_gps_week_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_gps_time_validity_gps_week_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_dl1_mk3_gps_time_accuracy_gps_time_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_gps_time_accuracy_gps_time_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_gps_time_accuracy_gps_time_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint32_t vehicle_rt_dl1_mk3_gps_time_gps_time_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_gps_time_gps_time_decode(uint32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_gps_time_gps_time_is_in_range(uint32_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_gps_time_gps_week_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_gps_time_gps_week_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_gps_time_gps_week_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_GPS_Pos_LLH_2.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_gps_pos_llh_2_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_gps_pos_llh_2_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_GPS_Pos_LLH_2.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_gps_pos_llh_2_unpack(
    struct vehicle_rt_dl1_mk3_gps_pos_llh_2_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_GPS_Pos_LLH_2.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_gps_pos_llh_2_init(struct vehicle_rt_dl1_mk3_gps_pos_llh_2_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_dl1_mk3_gps_pos_llh_2_gps_pos_llh_longitude_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_gps_pos_llh_2_gps_pos_llh_longitude_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_gps_pos_llh_2_gps_pos_llh_longitude_is_in_range(int32_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_dl1_mk3_gps_pos_llh_2_gps_pos_llh_altitude_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_gps_pos_llh_2_gps_pos_llh_altitude_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_gps_pos_llh_2_gps_pos_llh_altitude_is_in_range(int32_t value);

/**
 * Pack message RT_DL1MK3_GPS_Pos_LLH_1.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_gps_pos_llh_1_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_gps_pos_llh_1_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_GPS_Pos_LLH_1.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_gps_pos_llh_1_unpack(
    struct vehicle_rt_dl1_mk3_gps_pos_llh_1_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_GPS_Pos_LLH_1.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_gps_pos_llh_1_init(struct vehicle_rt_dl1_mk3_gps_pos_llh_1_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_dl1_mk3_gps_pos_llh_1_validity_gps_pos_llh_latitude_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_gps_pos_llh_1_validity_gps_pos_llh_latitude_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_gps_pos_llh_1_validity_gps_pos_llh_latitude_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_dl1_mk3_gps_pos_llh_1_validity_gps_pos_llh_longitude_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_gps_pos_llh_1_validity_gps_pos_llh_longitude_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_gps_pos_llh_1_validity_gps_pos_llh_longitude_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_dl1_mk3_gps_pos_llh_1_validity_gps_pos_llh_altitude_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_gps_pos_llh_1_validity_gps_pos_llh_altitude_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_gps_pos_llh_1_validity_gps_pos_llh_altitude_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_dl1_mk3_gps_pos_llh_1_accuracy_gps_pos_llh_latitude_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_gps_pos_llh_1_accuracy_gps_pos_llh_latitude_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_gps_pos_llh_1_accuracy_gps_pos_llh_latitude_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_dl1_mk3_gps_pos_llh_1_accuracy_gps_pos_llh_longitude_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_gps_pos_llh_1_accuracy_gps_pos_llh_longitude_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_gps_pos_llh_1_accuracy_gps_pos_llh_longitude_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_dl1_mk3_gps_pos_llh_1_accuracy_gps_pos_llh_altitude_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_gps_pos_llh_1_accuracy_gps_pos_llh_altitude_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_gps_pos_llh_1_accuracy_gps_pos_llh_altitude_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_dl1_mk3_gps_pos_llh_1_gps_pos_llh_latitude_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_gps_pos_llh_1_gps_pos_llh_latitude_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_gps_pos_llh_1_gps_pos_llh_latitude_is_in_range(int32_t value);

/**
 * Pack message RT_DL1MK3_GPS_Speed.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_gps_speed_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_gps_speed_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_GPS_Speed.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_gps_speed_unpack(
    struct vehicle_rt_dl1_mk3_gps_speed_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_GPS_Speed.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_gps_speed_init(struct vehicle_rt_dl1_mk3_gps_speed_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_dl1_mk3_gps_speed_validity_gps_speed_2_d_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_gps_speed_validity_gps_speed_2_d_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_gps_speed_validity_gps_speed_2_d_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_dl1_mk3_gps_speed_validity_gps_speed_3_d_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_gps_speed_validity_gps_speed_3_d_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_gps_speed_validity_gps_speed_3_d_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_dl1_mk3_gps_speed_accuracy_gps_speed_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_gps_speed_accuracy_gps_speed_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_gps_speed_accuracy_gps_speed_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint32_t vehicle_rt_dl1_mk3_gps_speed_gps_speed_2_d_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_gps_speed_gps_speed_2_d_decode(uint32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_gps_speed_gps_speed_2_d_is_in_range(uint32_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint32_t vehicle_rt_dl1_mk3_gps_speed_gps_speed_3_d_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_gps_speed_gps_speed_3_d_decode(uint32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_gps_speed_gps_speed_3_d_is_in_range(uint32_t value);

/**
 * Pack message RT_IRTemp_Temp_7.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_7_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_7_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_7.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_7_unpack(
    struct vehicle_rt_ir_temp_temp_7_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_7.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_7_init(struct vehicle_rt_ir_temp_temp_7_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_7_ir_temperature_7_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_7_ir_temperature_7_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_7_ir_temperature_7_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_RR_2.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_rr_2_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_rr_2_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_RR_2.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_rr_2_unpack(
    struct vehicle_rt_ir_temp_temp_rr_2_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_RR_2.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_rr_2_init(struct vehicle_rt_ir_temp_temp_rr_2_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_rr_2_ir_temperature_29_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_rr_2_ir_temperature_29_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_rr_2_ir_temperature_29_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_rr_2_ir_temperature_30_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_rr_2_ir_temperature_30_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_rr_2_ir_temperature_30_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_rr_2_ir_temperature_31_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_rr_2_ir_temperature_31_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_rr_2_ir_temperature_31_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_rr_2_ir_temperature_32_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_rr_2_ir_temperature_32_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_rr_2_ir_temperature_32_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_RL_2.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_rl_2_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_rl_2_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_RL_2.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_rl_2_unpack(
    struct vehicle_rt_ir_temp_temp_rl_2_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_RL_2.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_rl_2_init(struct vehicle_rt_ir_temp_temp_rl_2_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_rl_2_ir_temperature_21_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_rl_2_ir_temperature_21_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_rl_2_ir_temperature_21_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_rl_2_ir_temperature_22_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_rl_2_ir_temperature_22_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_rl_2_ir_temperature_22_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_rl_2_ir_temperature_23_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_rl_2_ir_temperature_23_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_rl_2_ir_temperature_23_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_rl_2_ir_temperature_24_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_rl_2_ir_temperature_24_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_rl_2_ir_temperature_24_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_FR_2.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_fr_2_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_fr_2_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_FR_2.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_fr_2_unpack(
    struct vehicle_rt_ir_temp_temp_fr_2_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_FR_2.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_fr_2_init(struct vehicle_rt_ir_temp_temp_fr_2_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_fr_2_ir_temperature_13_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_fr_2_ir_temperature_13_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_fr_2_ir_temperature_13_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_fr_2_ir_temperature_14_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_fr_2_ir_temperature_14_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_fr_2_ir_temperature_14_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_fr_2_ir_temperature_15_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_fr_2_ir_temperature_15_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_fr_2_ir_temperature_15_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_fr_2_ir_temperature_16_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_fr_2_ir_temperature_16_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_fr_2_ir_temperature_16_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_FL_2.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_fl_2_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_fl_2_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_FL_2.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_fl_2_unpack(
    struct vehicle_rt_ir_temp_temp_fl_2_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_FL_2.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_fl_2_init(struct vehicle_rt_ir_temp_temp_fl_2_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_fl_2_ir_temperature_5_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_fl_2_ir_temperature_5_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_fl_2_ir_temperature_5_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_fl_2_ir_temperature_6_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_fl_2_ir_temperature_6_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_fl_2_ir_temperature_6_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_fl_2_ir_temperature_7_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_fl_2_ir_temperature_7_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_fl_2_ir_temperature_7_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_fl_2_ir_temperature_8_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_fl_2_ir_temperature_8_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_fl_2_ir_temperature_8_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_RR_1.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_rr_1_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_rr_1_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_RR_1.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_rr_1_unpack(
    struct vehicle_rt_ir_temp_temp_rr_1_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_RR_1.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_rr_1_init(struct vehicle_rt_ir_temp_temp_rr_1_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_rr_1_ir_temperature_25_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_rr_1_ir_temperature_25_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_rr_1_ir_temperature_25_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_rr_1_ir_temperature_26_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_rr_1_ir_temperature_26_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_rr_1_ir_temperature_26_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_rr_1_ir_temperature_27_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_rr_1_ir_temperature_27_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_rr_1_ir_temperature_27_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_rr_1_ir_temperature_28_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_rr_1_ir_temperature_28_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_rr_1_ir_temperature_28_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_RL_1.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_rl_1_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_rl_1_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_RL_1.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_rl_1_unpack(
    struct vehicle_rt_ir_temp_temp_rl_1_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_RL_1.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_rl_1_init(struct vehicle_rt_ir_temp_temp_rl_1_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_rl_1_ir_temperature_17_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_rl_1_ir_temperature_17_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_rl_1_ir_temperature_17_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_rl_1_ir_temperature_18_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_rl_1_ir_temperature_18_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_rl_1_ir_temperature_18_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_rl_1_ir_temperature_19_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_rl_1_ir_temperature_19_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_rl_1_ir_temperature_19_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_rl_1_ir_temperature_20_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_rl_1_ir_temperature_20_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_rl_1_ir_temperature_20_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_FR_1.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_fr_1_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_fr_1_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_FR_1.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_fr_1_unpack(
    struct vehicle_rt_ir_temp_temp_fr_1_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_FR_1.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_fr_1_init(struct vehicle_rt_ir_temp_temp_fr_1_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_fr_1_ir_temperature_9_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_fr_1_ir_temperature_9_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_fr_1_ir_temperature_9_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_fr_1_ir_temperature_10_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_fr_1_ir_temperature_10_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_fr_1_ir_temperature_10_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_fr_1_ir_temperature_11_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_fr_1_ir_temperature_11_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_fr_1_ir_temperature_11_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_fr_1_ir_temperature_12_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_fr_1_ir_temperature_12_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_fr_1_ir_temperature_12_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_FL_1.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_fl_1_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_fl_1_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_FL_1.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_fl_1_unpack(
    struct vehicle_rt_ir_temp_temp_fl_1_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_FL_1.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_fl_1_init(struct vehicle_rt_ir_temp_temp_fl_1_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_fl_1_ir_temperature_1_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_fl_1_ir_temperature_1_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_fl_1_ir_temperature_1_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_fl_1_ir_temperature_2_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_fl_1_ir_temperature_2_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_fl_1_ir_temperature_2_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_fl_1_ir_temperature_3_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_fl_1_ir_temperature_3_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_fl_1_ir_temperature_3_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_fl_1_ir_temperature_4_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_fl_1_ir_temperature_4_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_fl_1_ir_temperature_4_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_32.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_32_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_32_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_32.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_32_unpack(
    struct vehicle_rt_ir_temp_temp_32_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_32.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_32_init(struct vehicle_rt_ir_temp_temp_32_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_32_ir_temperature_32_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_32_ir_temperature_32_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_32_ir_temperature_32_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_31.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_31_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_31_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_31.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_31_unpack(
    struct vehicle_rt_ir_temp_temp_31_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_31.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_31_init(struct vehicle_rt_ir_temp_temp_31_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_31_ir_temperature_31_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_31_ir_temperature_31_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_31_ir_temperature_31_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_30.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_30_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_30_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_30.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_30_unpack(
    struct vehicle_rt_ir_temp_temp_30_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_30.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_30_init(struct vehicle_rt_ir_temp_temp_30_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_30_ir_temperature_30_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_30_ir_temperature_30_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_30_ir_temperature_30_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_29.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_29_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_29_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_29.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_29_unpack(
    struct vehicle_rt_ir_temp_temp_29_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_29.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_29_init(struct vehicle_rt_ir_temp_temp_29_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_29_ir_temperature_29_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_29_ir_temperature_29_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_29_ir_temperature_29_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_28.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_28_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_28_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_28.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_28_unpack(
    struct vehicle_rt_ir_temp_temp_28_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_28.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_28_init(struct vehicle_rt_ir_temp_temp_28_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_28_ir_temperature_28_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_28_ir_temperature_28_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_28_ir_temperature_28_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_27.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_27_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_27_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_27.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_27_unpack(
    struct vehicle_rt_ir_temp_temp_27_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_27.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_27_init(struct vehicle_rt_ir_temp_temp_27_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_27_ir_temperature_27_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_27_ir_temperature_27_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_27_ir_temperature_27_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_26.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_26_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_26_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_26.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_26_unpack(
    struct vehicle_rt_ir_temp_temp_26_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_26.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_26_init(struct vehicle_rt_ir_temp_temp_26_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_26_ir_temperature_26_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_26_ir_temperature_26_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_26_ir_temperature_26_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_25.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_25_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_25_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_25.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_25_unpack(
    struct vehicle_rt_ir_temp_temp_25_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_25.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_25_init(struct vehicle_rt_ir_temp_temp_25_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_25_ir_temperature_25_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_25_ir_temperature_25_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_25_ir_temperature_25_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_24.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_24_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_24_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_24.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_24_unpack(
    struct vehicle_rt_ir_temp_temp_24_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_24.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_24_init(struct vehicle_rt_ir_temp_temp_24_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_24_ir_temperature_24_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_24_ir_temperature_24_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_24_ir_temperature_24_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_22.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_22_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_22_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_22.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_22_unpack(
    struct vehicle_rt_ir_temp_temp_22_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_22.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_22_init(struct vehicle_rt_ir_temp_temp_22_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_22_ir_temperature_22_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_22_ir_temperature_22_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_22_ir_temperature_22_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_23.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_23_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_23_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_23.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_23_unpack(
    struct vehicle_rt_ir_temp_temp_23_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_23.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_23_init(struct vehicle_rt_ir_temp_temp_23_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_23_ir_temperature_23_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_23_ir_temperature_23_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_23_ir_temperature_23_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_21.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_21_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_21_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_21.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_21_unpack(
    struct vehicle_rt_ir_temp_temp_21_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_21.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_21_init(struct vehicle_rt_ir_temp_temp_21_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_21_ir_temperature_21_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_21_ir_temperature_21_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_21_ir_temperature_21_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_20.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_20_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_20_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_20.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_20_unpack(
    struct vehicle_rt_ir_temp_temp_20_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_20.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_20_init(struct vehicle_rt_ir_temp_temp_20_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_20_ir_temperature_20_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_20_ir_temperature_20_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_20_ir_temperature_20_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_19.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_19_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_19_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_19.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_19_unpack(
    struct vehicle_rt_ir_temp_temp_19_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_19.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_19_init(struct vehicle_rt_ir_temp_temp_19_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_19_ir_temperature_19_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_19_ir_temperature_19_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_19_ir_temperature_19_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_18.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_18_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_18_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_18.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_18_unpack(
    struct vehicle_rt_ir_temp_temp_18_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_18.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_18_init(struct vehicle_rt_ir_temp_temp_18_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_18_ir_temperature_18_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_18_ir_temperature_18_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_18_ir_temperature_18_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_16.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_16_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_16_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_16.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_16_unpack(
    struct vehicle_rt_ir_temp_temp_16_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_16.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_16_init(struct vehicle_rt_ir_temp_temp_16_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_16_ir_temperature_16_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_16_ir_temperature_16_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_16_ir_temperature_16_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_15.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_15_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_15_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_15.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_15_unpack(
    struct vehicle_rt_ir_temp_temp_15_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_15.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_15_init(struct vehicle_rt_ir_temp_temp_15_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_15_ir_temperature_15_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_15_ir_temperature_15_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_15_ir_temperature_15_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_14.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_14_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_14_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_14.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_14_unpack(
    struct vehicle_rt_ir_temp_temp_14_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_14.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_14_init(struct vehicle_rt_ir_temp_temp_14_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_14_ir_temperature_14_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_14_ir_temperature_14_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_14_ir_temperature_14_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_13.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_13_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_13_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_13.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_13_unpack(
    struct vehicle_rt_ir_temp_temp_13_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_13.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_13_init(struct vehicle_rt_ir_temp_temp_13_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_13_ir_temperature_13_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_13_ir_temperature_13_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_13_ir_temperature_13_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_12.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_12_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_12_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_12.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_12_unpack(
    struct vehicle_rt_ir_temp_temp_12_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_12.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_12_init(struct vehicle_rt_ir_temp_temp_12_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_12_ir_temperature_12_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_12_ir_temperature_12_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_12_ir_temperature_12_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_11.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_11_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_11_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_11.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_11_unpack(
    struct vehicle_rt_ir_temp_temp_11_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_11.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_11_init(struct vehicle_rt_ir_temp_temp_11_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_11_ir_temperature_11_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_11_ir_temperature_11_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_11_ir_temperature_11_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_10.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_10_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_10_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_10.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_10_unpack(
    struct vehicle_rt_ir_temp_temp_10_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_10.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_10_init(struct vehicle_rt_ir_temp_temp_10_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_10_ir_temperature_10_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_10_ir_temperature_10_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_10_ir_temperature_10_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_8.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_8_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_8_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_8.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_8_unpack(
    struct vehicle_rt_ir_temp_temp_8_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_8.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_8_init(struct vehicle_rt_ir_temp_temp_8_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_8_ir_temperature_8_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_8_ir_temperature_8_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_8_ir_temperature_8_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_9.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_9_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_9_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_9.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_9_unpack(
    struct vehicle_rt_ir_temp_temp_9_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_9.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_9_init(struct vehicle_rt_ir_temp_temp_9_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_9_ir_temperature_9_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_9_ir_temperature_9_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_9_ir_temperature_9_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_17.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_17_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_17_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_17.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_17_unpack(
    struct vehicle_rt_ir_temp_temp_17_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_17.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_17_init(struct vehicle_rt_ir_temp_temp_17_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_17_ir_temperature_17_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_17_ir_temperature_17_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_17_ir_temperature_17_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_6.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_6_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_6_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_6.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_6_unpack(
    struct vehicle_rt_ir_temp_temp_6_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_6.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_6_init(struct vehicle_rt_ir_temp_temp_6_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_6_ir_temperature_6_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_6_ir_temperature_6_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_6_ir_temperature_6_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_5.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_5_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_5_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_5.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_5_unpack(
    struct vehicle_rt_ir_temp_temp_5_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_5.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_5_init(struct vehicle_rt_ir_temp_temp_5_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_5_ir_temperature_5_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_5_ir_temperature_5_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_5_ir_temperature_5_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_4.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_4_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_4_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_4.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_4_unpack(
    struct vehicle_rt_ir_temp_temp_4_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_4.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_4_init(struct vehicle_rt_ir_temp_temp_4_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_4_ir_temperature_4_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_4_ir_temperature_4_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_4_ir_temperature_4_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_3.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_3_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_3_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_3.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_3_unpack(
    struct vehicle_rt_ir_temp_temp_3_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_3.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_3_init(struct vehicle_rt_ir_temp_temp_3_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_3_ir_temperature_3_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_3_ir_temperature_3_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_3_ir_temperature_3_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_2.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_2_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_2_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_2.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_2_unpack(
    struct vehicle_rt_ir_temp_temp_2_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_2.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_2_init(struct vehicle_rt_ir_temp_temp_2_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_2_ir_temperature_2_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_2_ir_temperature_2_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_2_ir_temperature_2_is_in_range(int16_t value);

/**
 * Pack message RT_IRTemp_Temp_1.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_ir_temp_temp_1_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_ir_temp_temp_1_t *src_p,
    size_t size);

/**
 * Unpack message RT_IRTemp_Temp_1.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_ir_temp_temp_1_unpack(
    struct vehicle_rt_ir_temp_temp_1_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IRTemp_Temp_1.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_ir_temp_temp_1_init(struct vehicle_rt_ir_temp_temp_1_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_ir_temp_temp_1_ir_temperature_1_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_ir_temp_temp_1_ir_temperature_1_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_ir_temp_temp_1_ir_temperature_1_is_in_range(int16_t value);

/**
 * Pack message RT_SB_Trig_Final_Condition.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_trig_final_condition_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_trig_final_condition_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_Trig_Final_Condition.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_trig_final_condition_unpack(
    struct vehicle_rt_sb_trig_final_condition_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_Trig_Final_Condition.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_trig_final_condition_init(struct vehicle_rt_sb_trig_final_condition_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_trig_final_condition_validity_final_speed_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_trig_final_condition_validity_final_speed_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_trig_final_condition_validity_final_speed_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint32_t vehicle_rt_sb_trig_final_condition_final_speed_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_trig_final_condition_final_speed_decode(uint32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_trig_final_condition_final_speed_is_in_range(uint32_t value);

/**
 * Pack message RT_SB_Trig_Initial_Condition.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_trig_initial_condition_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_trig_initial_condition_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_Trig_Initial_Condition.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_trig_initial_condition_unpack(
    struct vehicle_rt_sb_trig_initial_condition_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_Trig_Initial_Condition.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_trig_initial_condition_init(struct vehicle_rt_sb_trig_initial_condition_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_trig_initial_condition_validity_initial_speed_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_trig_initial_condition_validity_initial_speed_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_trig_initial_condition_validity_initial_speed_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_trig_initial_condition_validity_initial_heading_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_trig_initial_condition_validity_initial_heading_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_trig_initial_condition_validity_initial_heading_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint32_t vehicle_rt_sb_trig_initial_condition_initial_speed_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_trig_initial_condition_initial_speed_decode(uint32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_trig_initial_condition_initial_speed_is_in_range(uint32_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_trig_initial_condition_initial_heading_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_trig_initial_condition_initial_heading_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_trig_initial_condition_initial_heading_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_trig_initial_condition_mfdd_start_threshold_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_trig_initial_condition_mfdd_start_threshold_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_trig_initial_condition_mfdd_start_threshold_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_trig_initial_condition_mfdd_end_threshold_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_trig_initial_condition_mfdd_end_threshold_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_trig_initial_condition_mfdd_end_threshold_is_in_range(uint8_t value);

/**
 * Pack message RT_SB_Trig_Direct_Dist.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_trig_direct_dist_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_trig_direct_dist_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_Trig_Direct_Dist.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_trig_direct_dist_unpack(
    struct vehicle_rt_sb_trig_direct_dist_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_Trig_Direct_Dist.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_trig_direct_dist_init(struct vehicle_rt_sb_trig_direct_dist_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint32_t vehicle_rt_sb_trig_direct_dist_direct_distance_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_trig_direct_dist_direct_distance_decode(uint32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_trig_direct_dist_direct_distance_is_in_range(uint32_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint32_t vehicle_rt_sb_trig_direct_dist_path_distance_2_d_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_trig_direct_dist_path_distance_2_d_decode(uint32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_trig_direct_dist_path_distance_2_d_is_in_range(uint32_t value);

/**
 * Pack message RT_SB_Trig_Forward_Dist.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_trig_forward_dist_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_trig_forward_dist_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_Trig_Forward_Dist.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_trig_forward_dist_unpack(
    struct vehicle_rt_sb_trig_forward_dist_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_Trig_Forward_Dist.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_trig_forward_dist_init(struct vehicle_rt_sb_trig_forward_dist_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_trig_forward_dist_forward_distance_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_trig_forward_dist_forward_distance_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_trig_forward_dist_forward_distance_is_in_range(int32_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_trig_forward_dist_deviation_distance_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_trig_forward_dist_deviation_distance_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_trig_forward_dist_deviation_distance_is_in_range(int32_t value);

/**
 * Pack message RT_SB_Trig_Path_Dist.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_trig_path_dist_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_trig_path_dist_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_Trig_Path_Dist.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_trig_path_dist_unpack(
    struct vehicle_rt_sb_trig_path_dist_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_Trig_Path_Dist.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_trig_path_dist_init(struct vehicle_rt_sb_trig_path_dist_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint32_t vehicle_rt_sb_trig_path_dist_path_distance_3_d_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_trig_path_dist_path_distance_3_d_decode(uint32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_trig_path_dist_path_distance_3_d_is_in_range(uint32_t value);

/**
 * Pack message RT_SB_Trig_Accel.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_trig_accel_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_trig_accel_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_Trig_Accel.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_trig_accel_unpack(
    struct vehicle_rt_sb_trig_accel_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_Trig_Accel.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_trig_accel_init(struct vehicle_rt_sb_trig_accel_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_trig_accel_validity_mfdd_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_trig_accel_validity_mfdd_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_trig_accel_validity_mfdd_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_trig_accel_validity_average_accel_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_trig_accel_validity_average_accel_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_trig_accel_validity_average_accel_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_trig_accel_validity_triggered_time_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_trig_accel_validity_triggered_time_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_trig_accel_validity_triggered_time_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_trig_accel_mfdd_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_trig_accel_mfdd_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_trig_accel_mfdd_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_trig_accel_average_accel_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_trig_accel_average_accel_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_trig_accel_average_accel_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint32_t vehicle_rt_sb_trig_accel_triggered_time_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_trig_accel_triggered_time_decode(uint32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_trig_accel_triggered_time_is_in_range(uint32_t value);

/**
 * Pack message RT_DL1MK3_Measure_Time_12.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_measure_time_12_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_measure_time_12_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Measure_Time_12.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_measure_time_12_unpack(
    struct vehicle_rt_dl1_mk3_measure_time_12_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Measure_Time_12.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_measure_time_12_init(struct vehicle_rt_dl1_mk3_measure_time_12_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint32_t vehicle_rt_dl1_mk3_measure_time_12_measured_time_12_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_measure_time_12_measured_time_12_decode(uint32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_measure_time_12_measured_time_12_is_in_range(uint32_t value);

/**
 * Pack message RT_DL1MK3_Measure_Time_11.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_measure_time_11_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_measure_time_11_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Measure_Time_11.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_measure_time_11_unpack(
    struct vehicle_rt_dl1_mk3_measure_time_11_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Measure_Time_11.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_measure_time_11_init(struct vehicle_rt_dl1_mk3_measure_time_11_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint32_t vehicle_rt_dl1_mk3_measure_time_11_measured_time_11_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_measure_time_11_measured_time_11_decode(uint32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_measure_time_11_measured_time_11_is_in_range(uint32_t value);

/**
 * Pack message RT_DL1MK3_Measure_Time_10.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_measure_time_10_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_measure_time_10_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Measure_Time_10.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_measure_time_10_unpack(
    struct vehicle_rt_dl1_mk3_measure_time_10_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Measure_Time_10.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_measure_time_10_init(struct vehicle_rt_dl1_mk3_measure_time_10_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint32_t vehicle_rt_dl1_mk3_measure_time_10_measured_time_10_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_measure_time_10_measured_time_10_decode(uint32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_measure_time_10_measured_time_10_is_in_range(uint32_t value);

/**
 * Pack message RT_DL1MK3_Measure_Time_9.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_measure_time_9_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_measure_time_9_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Measure_Time_9.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_measure_time_9_unpack(
    struct vehicle_rt_dl1_mk3_measure_time_9_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Measure_Time_9.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_measure_time_9_init(struct vehicle_rt_dl1_mk3_measure_time_9_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint32_t vehicle_rt_dl1_mk3_measure_time_9_measured_time_9_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_measure_time_9_measured_time_9_decode(uint32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_measure_time_9_measured_time_9_is_in_range(uint32_t value);

/**
 * Pack message RT_DL1MK3_Measure_Time_8.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_measure_time_8_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_measure_time_8_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Measure_Time_8.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_measure_time_8_unpack(
    struct vehicle_rt_dl1_mk3_measure_time_8_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Measure_Time_8.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_measure_time_8_init(struct vehicle_rt_dl1_mk3_measure_time_8_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint32_t vehicle_rt_dl1_mk3_measure_time_8_measured_time_8_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_measure_time_8_measured_time_8_decode(uint32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_measure_time_8_measured_time_8_is_in_range(uint32_t value);

/**
 * Pack message RT_DL1MK3_Measure_Time_7.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_measure_time_7_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_measure_time_7_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Measure_Time_7.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_measure_time_7_unpack(
    struct vehicle_rt_dl1_mk3_measure_time_7_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Measure_Time_7.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_measure_time_7_init(struct vehicle_rt_dl1_mk3_measure_time_7_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint32_t vehicle_rt_dl1_mk3_measure_time_7_measured_time_7_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_measure_time_7_measured_time_7_decode(uint32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_measure_time_7_measured_time_7_is_in_range(uint32_t value);

/**
 * Pack message RT_DL1MK3_Measure_Time_6.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_measure_time_6_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_measure_time_6_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Measure_Time_6.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_measure_time_6_unpack(
    struct vehicle_rt_dl1_mk3_measure_time_6_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Measure_Time_6.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_measure_time_6_init(struct vehicle_rt_dl1_mk3_measure_time_6_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint32_t vehicle_rt_dl1_mk3_measure_time_6_measured_time_6_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_measure_time_6_measured_time_6_decode(uint32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_measure_time_6_measured_time_6_is_in_range(uint32_t value);

/**
 * Pack message RT_DL1MK3_Measure_Time_5.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_measure_time_5_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_measure_time_5_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Measure_Time_5.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_measure_time_5_unpack(
    struct vehicle_rt_dl1_mk3_measure_time_5_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Measure_Time_5.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_measure_time_5_init(struct vehicle_rt_dl1_mk3_measure_time_5_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint32_t vehicle_rt_dl1_mk3_measure_time_5_measured_time_5_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_measure_time_5_measured_time_5_decode(uint32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_measure_time_5_measured_time_5_is_in_range(uint32_t value);

/**
 * Pack message RT_DL1MK3_Measure_Time_4.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_measure_time_4_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_measure_time_4_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Measure_Time_4.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_measure_time_4_unpack(
    struct vehicle_rt_dl1_mk3_measure_time_4_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Measure_Time_4.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_measure_time_4_init(struct vehicle_rt_dl1_mk3_measure_time_4_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint32_t vehicle_rt_dl1_mk3_measure_time_4_measured_time_4_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_measure_time_4_measured_time_4_decode(uint32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_measure_time_4_measured_time_4_is_in_range(uint32_t value);

/**
 * Pack message RT_DL1MK3_Measure_Time_3.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_measure_time_3_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_measure_time_3_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Measure_Time_3.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_measure_time_3_unpack(
    struct vehicle_rt_dl1_mk3_measure_time_3_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Measure_Time_3.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_measure_time_3_init(struct vehicle_rt_dl1_mk3_measure_time_3_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint32_t vehicle_rt_dl1_mk3_measure_time_3_measured_time_3_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_measure_time_3_measured_time_3_decode(uint32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_measure_time_3_measured_time_3_is_in_range(uint32_t value);

/**
 * Pack message RT_DL1MK3_Measure_Time_2.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_measure_time_2_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_measure_time_2_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Measure_Time_2.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_measure_time_2_unpack(
    struct vehicle_rt_dl1_mk3_measure_time_2_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Measure_Time_2.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_measure_time_2_init(struct vehicle_rt_dl1_mk3_measure_time_2_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint32_t vehicle_rt_dl1_mk3_measure_time_2_measured_time_2_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_measure_time_2_measured_time_2_decode(uint32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_measure_time_2_measured_time_2_is_in_range(uint32_t value);

/**
 * Pack message RT_DL1MK3_Measure_Time_1.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_measure_time_1_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_measure_time_1_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Measure_Time_1.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_measure_time_1_unpack(
    struct vehicle_rt_dl1_mk3_measure_time_1_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Measure_Time_1.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_measure_time_1_init(struct vehicle_rt_dl1_mk3_measure_time_1_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint32_t vehicle_rt_dl1_mk3_measure_time_1_measured_time_1_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_measure_time_1_measured_time_1_decode(uint32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_measure_time_1_measured_time_1_is_in_range(uint32_t value);

/**
 * Pack message RT_DL1MK3_RPM.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_rpm_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_rpm_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_RPM.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_rpm_unpack(
    struct vehicle_rt_dl1_mk3_rpm_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_RPM.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_rpm_init(struct vehicle_rt_dl1_mk3_rpm_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_rpm_rpm_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_rpm_rpm_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_rpm_rpm_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Freq_4.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_freq_4_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_freq_4_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Freq_4.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_freq_4_unpack(
    struct vehicle_rt_dl1_mk3_freq_4_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Freq_4.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_freq_4_init(struct vehicle_rt_dl1_mk3_freq_4_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_freq_4_frequency_4_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_freq_4_frequency_4_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_freq_4_frequency_4_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Freq_3.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_freq_3_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_freq_3_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Freq_3.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_freq_3_unpack(
    struct vehicle_rt_dl1_mk3_freq_3_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Freq_3.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_freq_3_init(struct vehicle_rt_dl1_mk3_freq_3_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_freq_3_frequency_3_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_freq_3_frequency_3_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_freq_3_frequency_3_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Freq_2.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_freq_2_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_freq_2_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Freq_2.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_freq_2_unpack(
    struct vehicle_rt_dl1_mk3_freq_2_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Freq_2.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_freq_2_init(struct vehicle_rt_dl1_mk3_freq_2_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_freq_2_frequency_2_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_freq_2_frequency_2_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_freq_2_frequency_2_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Misc_3.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_misc_3_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_misc_3_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Misc_3.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_misc_3_unpack(
    struct vehicle_rt_dl1_mk3_misc_3_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Misc_3.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_misc_3_init(struct vehicle_rt_dl1_mk3_misc_3_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_misc_3_misc_3_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_misc_3_misc_3_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_misc_3_misc_3_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Misc_2.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_misc_2_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_misc_2_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Misc_2.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_misc_2_unpack(
    struct vehicle_rt_dl1_mk3_misc_2_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Misc_2.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_misc_2_init(struct vehicle_rt_dl1_mk3_misc_2_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_misc_2_misc_2_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_misc_2_misc_2_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_misc_2_misc_2_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Misc_1.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_misc_1_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_misc_1_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Misc_1.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_misc_1_unpack(
    struct vehicle_rt_dl1_mk3_misc_1_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Misc_1.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_misc_1_init(struct vehicle_rt_dl1_mk3_misc_1_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_misc_1_misc_1_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_misc_1_misc_1_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_misc_1_misc_1_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Aux_31.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_31_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_aux_31_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Aux_31.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_31_unpack(
    struct vehicle_rt_dl1_mk3_aux_31_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Aux_31.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_aux_31_init(struct vehicle_rt_dl1_mk3_aux_31_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_aux_31_aux_31_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_aux_31_aux_31_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_aux_31_aux_31_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Aux_30.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_30_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_aux_30_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Aux_30.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_30_unpack(
    struct vehicle_rt_dl1_mk3_aux_30_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Aux_30.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_aux_30_init(struct vehicle_rt_dl1_mk3_aux_30_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_aux_30_aux_30_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_aux_30_aux_30_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_aux_30_aux_30_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Aux_29.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_29_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_aux_29_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Aux_29.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_29_unpack(
    struct vehicle_rt_dl1_mk3_aux_29_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Aux_29.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_aux_29_init(struct vehicle_rt_dl1_mk3_aux_29_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_aux_29_aux_29_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_aux_29_aux_29_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_aux_29_aux_29_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Aux_28.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_28_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_aux_28_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Aux_28.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_28_unpack(
    struct vehicle_rt_dl1_mk3_aux_28_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Aux_28.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_aux_28_init(struct vehicle_rt_dl1_mk3_aux_28_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_aux_28_aux_28_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_aux_28_aux_28_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_aux_28_aux_28_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Aux_27.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_27_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_aux_27_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Aux_27.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_27_unpack(
    struct vehicle_rt_dl1_mk3_aux_27_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Aux_27.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_aux_27_init(struct vehicle_rt_dl1_mk3_aux_27_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_aux_27_aux_27_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_aux_27_aux_27_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_aux_27_aux_27_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Aux_26.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_26_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_aux_26_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Aux_26.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_26_unpack(
    struct vehicle_rt_dl1_mk3_aux_26_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Aux_26.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_aux_26_init(struct vehicle_rt_dl1_mk3_aux_26_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_aux_26_aux_26_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_aux_26_aux_26_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_aux_26_aux_26_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Aux_25.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_25_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_aux_25_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Aux_25.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_25_unpack(
    struct vehicle_rt_dl1_mk3_aux_25_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Aux_25.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_aux_25_init(struct vehicle_rt_dl1_mk3_aux_25_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_aux_25_aux_25_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_aux_25_aux_25_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_aux_25_aux_25_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Aux_24.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_24_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_aux_24_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Aux_24.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_24_unpack(
    struct vehicle_rt_dl1_mk3_aux_24_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Aux_24.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_aux_24_init(struct vehicle_rt_dl1_mk3_aux_24_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_aux_24_aux_24_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_aux_24_aux_24_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_aux_24_aux_24_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Aux_23.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_23_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_aux_23_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Aux_23.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_23_unpack(
    struct vehicle_rt_dl1_mk3_aux_23_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Aux_23.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_aux_23_init(struct vehicle_rt_dl1_mk3_aux_23_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_aux_23_aux_23_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_aux_23_aux_23_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_aux_23_aux_23_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Aux_22.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_22_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_aux_22_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Aux_22.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_22_unpack(
    struct vehicle_rt_dl1_mk3_aux_22_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Aux_22.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_aux_22_init(struct vehicle_rt_dl1_mk3_aux_22_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_aux_22_aux_22_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_aux_22_aux_22_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_aux_22_aux_22_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Aux_21.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_21_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_aux_21_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Aux_21.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_21_unpack(
    struct vehicle_rt_dl1_mk3_aux_21_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Aux_21.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_aux_21_init(struct vehicle_rt_dl1_mk3_aux_21_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_aux_21_aux_21_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_aux_21_aux_21_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_aux_21_aux_21_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Aux_20.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_20_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_aux_20_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Aux_20.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_20_unpack(
    struct vehicle_rt_dl1_mk3_aux_20_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Aux_20.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_aux_20_init(struct vehicle_rt_dl1_mk3_aux_20_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_aux_20_aux_20_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_aux_20_aux_20_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_aux_20_aux_20_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Aux_19.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_19_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_aux_19_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Aux_19.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_19_unpack(
    struct vehicle_rt_dl1_mk3_aux_19_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Aux_19.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_aux_19_init(struct vehicle_rt_dl1_mk3_aux_19_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_aux_19_aux_19_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_aux_19_aux_19_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_aux_19_aux_19_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Aux_18.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_18_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_aux_18_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Aux_18.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_18_unpack(
    struct vehicle_rt_dl1_mk3_aux_18_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Aux_18.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_aux_18_init(struct vehicle_rt_dl1_mk3_aux_18_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_aux_18_aux_18_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_aux_18_aux_18_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_aux_18_aux_18_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Aux_17.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_17_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_aux_17_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Aux_17.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_17_unpack(
    struct vehicle_rt_dl1_mk3_aux_17_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Aux_17.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_aux_17_init(struct vehicle_rt_dl1_mk3_aux_17_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_aux_17_aux_17_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_aux_17_aux_17_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_aux_17_aux_17_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Aux_16.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_16_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_aux_16_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Aux_16.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_16_unpack(
    struct vehicle_rt_dl1_mk3_aux_16_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Aux_16.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_aux_16_init(struct vehicle_rt_dl1_mk3_aux_16_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_aux_16_aux_16_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_aux_16_aux_16_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_aux_16_aux_16_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Aux_15.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_15_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_aux_15_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Aux_15.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_15_unpack(
    struct vehicle_rt_dl1_mk3_aux_15_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Aux_15.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_aux_15_init(struct vehicle_rt_dl1_mk3_aux_15_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_aux_15_aux_15_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_aux_15_aux_15_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_aux_15_aux_15_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Aux_14.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_14_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_aux_14_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Aux_14.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_14_unpack(
    struct vehicle_rt_dl1_mk3_aux_14_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Aux_14.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_aux_14_init(struct vehicle_rt_dl1_mk3_aux_14_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_aux_14_aux_14_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_aux_14_aux_14_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_aux_14_aux_14_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Aux_13.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_13_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_aux_13_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Aux_13.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_13_unpack(
    struct vehicle_rt_dl1_mk3_aux_13_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Aux_13.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_aux_13_init(struct vehicle_rt_dl1_mk3_aux_13_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_aux_13_aux_13_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_aux_13_aux_13_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_aux_13_aux_13_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Aux_12.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_12_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_aux_12_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Aux_12.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_12_unpack(
    struct vehicle_rt_dl1_mk3_aux_12_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Aux_12.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_aux_12_init(struct vehicle_rt_dl1_mk3_aux_12_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_aux_12_aux_12_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_aux_12_aux_12_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_aux_12_aux_12_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Aux_11.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_11_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_aux_11_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Aux_11.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_11_unpack(
    struct vehicle_rt_dl1_mk3_aux_11_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Aux_11.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_aux_11_init(struct vehicle_rt_dl1_mk3_aux_11_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_aux_11_aux_11_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_aux_11_aux_11_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_aux_11_aux_11_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Aux_9.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_9_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_aux_9_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Aux_9.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_9_unpack(
    struct vehicle_rt_dl1_mk3_aux_9_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Aux_9.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_aux_9_init(struct vehicle_rt_dl1_mk3_aux_9_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_aux_9_aux_9_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_aux_9_aux_9_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_aux_9_aux_9_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Aux_10.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_10_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_aux_10_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Aux_10.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_10_unpack(
    struct vehicle_rt_dl1_mk3_aux_10_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Aux_10.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_aux_10_init(struct vehicle_rt_dl1_mk3_aux_10_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_aux_10_aux_10_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_aux_10_aux_10_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_aux_10_aux_10_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Aux_8.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_8_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_aux_8_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Aux_8.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_8_unpack(
    struct vehicle_rt_dl1_mk3_aux_8_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Aux_8.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_aux_8_init(struct vehicle_rt_dl1_mk3_aux_8_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_aux_8_aux_8_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_aux_8_aux_8_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_aux_8_aux_8_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Aux_7.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_7_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_aux_7_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Aux_7.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_7_unpack(
    struct vehicle_rt_dl1_mk3_aux_7_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Aux_7.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_aux_7_init(struct vehicle_rt_dl1_mk3_aux_7_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_aux_7_aux_7_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_aux_7_aux_7_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_aux_7_aux_7_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Aux_6.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_6_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_aux_6_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Aux_6.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_6_unpack(
    struct vehicle_rt_dl1_mk3_aux_6_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Aux_6.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_aux_6_init(struct vehicle_rt_dl1_mk3_aux_6_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_aux_6_aux_6_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_aux_6_aux_6_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_aux_6_aux_6_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Aux_5.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_5_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_aux_5_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Aux_5.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_5_unpack(
    struct vehicle_rt_dl1_mk3_aux_5_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Aux_5.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_aux_5_init(struct vehicle_rt_dl1_mk3_aux_5_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_aux_5_aux_5_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_aux_5_aux_5_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_aux_5_aux_5_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Aux_4.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_4_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_aux_4_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Aux_4.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_4_unpack(
    struct vehicle_rt_dl1_mk3_aux_4_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Aux_4.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_aux_4_init(struct vehicle_rt_dl1_mk3_aux_4_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_aux_4_aux_4_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_aux_4_aux_4_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_aux_4_aux_4_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Aux_3.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_3_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_aux_3_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Aux_3.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_3_unpack(
    struct vehicle_rt_dl1_mk3_aux_3_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Aux_3.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_aux_3_init(struct vehicle_rt_dl1_mk3_aux_3_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_aux_3_aux_3_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_aux_3_aux_3_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_aux_3_aux_3_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Aux_2.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_2_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_aux_2_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Aux_2.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_2_unpack(
    struct vehicle_rt_dl1_mk3_aux_2_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Aux_2.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_aux_2_init(struct vehicle_rt_dl1_mk3_aux_2_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_aux_2_aux_2_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_aux_2_aux_2_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_aux_2_aux_2_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Aux_1.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_1_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_aux_1_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Aux_1.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_aux_1_unpack(
    struct vehicle_rt_dl1_mk3_aux_1_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Aux_1.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_aux_1_init(struct vehicle_rt_dl1_mk3_aux_1_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_aux_1_aux_1_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_aux_1_aux_1_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_aux_1_aux_1_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Pressure_5.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_pressure_5_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_pressure_5_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Pressure_5.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_pressure_5_unpack(
    struct vehicle_rt_dl1_mk3_pressure_5_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Pressure_5.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_pressure_5_init(struct vehicle_rt_dl1_mk3_pressure_5_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint32_t vehicle_rt_dl1_mk3_pressure_5_pressure_5_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_pressure_5_pressure_5_decode(uint32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_pressure_5_pressure_5_is_in_range(uint32_t value);

/**
 * Pack message RT_DL1MK3_Pressure_4.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_pressure_4_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_pressure_4_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Pressure_4.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_pressure_4_unpack(
    struct vehicle_rt_dl1_mk3_pressure_4_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Pressure_4.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_pressure_4_init(struct vehicle_rt_dl1_mk3_pressure_4_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint32_t vehicle_rt_dl1_mk3_pressure_4_pressure_4_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_pressure_4_pressure_4_decode(uint32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_pressure_4_pressure_4_is_in_range(uint32_t value);

/**
 * Pack message RT_DL1MK3_Pressure_3.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_pressure_3_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_pressure_3_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Pressure_3.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_pressure_3_unpack(
    struct vehicle_rt_dl1_mk3_pressure_3_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Pressure_3.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_pressure_3_init(struct vehicle_rt_dl1_mk3_pressure_3_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint32_t vehicle_rt_dl1_mk3_pressure_3_pressure_3_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_pressure_3_pressure_3_decode(uint32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_pressure_3_pressure_3_is_in_range(uint32_t value);

/**
 * Pack message RT_DL1MK3_Pressure_2.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_pressure_2_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_pressure_2_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Pressure_2.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_pressure_2_unpack(
    struct vehicle_rt_dl1_mk3_pressure_2_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Pressure_2.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_pressure_2_init(struct vehicle_rt_dl1_mk3_pressure_2_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint32_t vehicle_rt_dl1_mk3_pressure_2_pressure_2_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_pressure_2_pressure_2_decode(uint32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_pressure_2_pressure_2_is_in_range(uint32_t value);

/**
 * Pack message RT_DL1MK3_Pressure_1.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_pressure_1_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_pressure_1_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Pressure_1.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_pressure_1_unpack(
    struct vehicle_rt_dl1_mk3_pressure_1_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Pressure_1.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_pressure_1_init(struct vehicle_rt_dl1_mk3_pressure_1_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint32_t vehicle_rt_dl1_mk3_pressure_1_pressure_1_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_pressure_1_pressure_1_decode(uint32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_pressure_1_pressure_1_is_in_range(uint32_t value);

/**
 * Pack message RT_DL1MK3_Angle_3.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_angle_3_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_angle_3_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Angle_3.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_angle_3_unpack(
    struct vehicle_rt_dl1_mk3_angle_3_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Angle_3.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_angle_3_init(struct vehicle_rt_dl1_mk3_angle_3_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_dl1_mk3_angle_3_angle_3_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_angle_3_angle_3_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_angle_3_angle_3_is_in_range(int16_t value);

/**
 * Pack message RT_DL1MK3_Angle_2.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_angle_2_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_angle_2_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Angle_2.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_angle_2_unpack(
    struct vehicle_rt_dl1_mk3_angle_2_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Angle_2.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_angle_2_init(struct vehicle_rt_dl1_mk3_angle_2_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_dl1_mk3_angle_2_angle_2_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_angle_2_angle_2_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_angle_2_angle_2_is_in_range(int16_t value);

/**
 * Pack message RT_DL1MK3_Angle_1.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_angle_1_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_angle_1_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Angle_1.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_angle_1_unpack(
    struct vehicle_rt_dl1_mk3_angle_1_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Angle_1.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_angle_1_init(struct vehicle_rt_dl1_mk3_angle_1_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_dl1_mk3_angle_1_angle_1_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_angle_1_angle_1_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_angle_1_angle_1_is_in_range(int16_t value);

/**
 * Pack message RT_DL1MK3_Temp_25.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_25_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_temp_25_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Temp_25.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_25_unpack(
    struct vehicle_rt_dl1_mk3_temp_25_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Temp_25.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_temp_25_init(struct vehicle_rt_dl1_mk3_temp_25_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_dl1_mk3_temp_25_temperature_25_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_temp_25_temperature_25_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_temp_25_temperature_25_is_in_range(int16_t value);

/**
 * Pack message RT_DL1MK3_Temp_24.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_24_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_temp_24_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Temp_24.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_24_unpack(
    struct vehicle_rt_dl1_mk3_temp_24_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Temp_24.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_temp_24_init(struct vehicle_rt_dl1_mk3_temp_24_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_dl1_mk3_temp_24_temperature_24_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_temp_24_temperature_24_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_temp_24_temperature_24_is_in_range(int16_t value);

/**
 * Pack message RT_DL1MK3_Temp_23.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_23_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_temp_23_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Temp_23.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_23_unpack(
    struct vehicle_rt_dl1_mk3_temp_23_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Temp_23.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_temp_23_init(struct vehicle_rt_dl1_mk3_temp_23_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_dl1_mk3_temp_23_temperature_23_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_temp_23_temperature_23_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_temp_23_temperature_23_is_in_range(int16_t value);

/**
 * Pack message RT_DL1MK3_Temp_22.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_22_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_temp_22_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Temp_22.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_22_unpack(
    struct vehicle_rt_dl1_mk3_temp_22_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Temp_22.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_temp_22_init(struct vehicle_rt_dl1_mk3_temp_22_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_dl1_mk3_temp_22_temperature_22_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_temp_22_temperature_22_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_temp_22_temperature_22_is_in_range(int16_t value);

/**
 * Pack message RT_DL1MK3_Temp_21.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_21_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_temp_21_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Temp_21.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_21_unpack(
    struct vehicle_rt_dl1_mk3_temp_21_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Temp_21.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_temp_21_init(struct vehicle_rt_dl1_mk3_temp_21_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_dl1_mk3_temp_21_temperature_21_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_temp_21_temperature_21_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_temp_21_temperature_21_is_in_range(int16_t value);

/**
 * Pack message RT_DL1MK3_Temp_20.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_20_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_temp_20_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Temp_20.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_20_unpack(
    struct vehicle_rt_dl1_mk3_temp_20_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Temp_20.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_temp_20_init(struct vehicle_rt_dl1_mk3_temp_20_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_dl1_mk3_temp_20_temperature_20_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_temp_20_temperature_20_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_temp_20_temperature_20_is_in_range(int16_t value);

/**
 * Pack message RT_DL1MK3_Temp_19.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_19_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_temp_19_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Temp_19.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_19_unpack(
    struct vehicle_rt_dl1_mk3_temp_19_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Temp_19.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_temp_19_init(struct vehicle_rt_dl1_mk3_temp_19_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_dl1_mk3_temp_19_temperature_19_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_temp_19_temperature_19_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_temp_19_temperature_19_is_in_range(int16_t value);

/**
 * Pack message RT_DL1MK3_Temp_18.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_18_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_temp_18_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Temp_18.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_18_unpack(
    struct vehicle_rt_dl1_mk3_temp_18_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Temp_18.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_temp_18_init(struct vehicle_rt_dl1_mk3_temp_18_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_dl1_mk3_temp_18_temperature_18_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_temp_18_temperature_18_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_temp_18_temperature_18_is_in_range(int16_t value);

/**
 * Pack message RT_DL1MK3_Temp_17.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_17_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_temp_17_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Temp_17.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_17_unpack(
    struct vehicle_rt_dl1_mk3_temp_17_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Temp_17.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_temp_17_init(struct vehicle_rt_dl1_mk3_temp_17_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_dl1_mk3_temp_17_temperature_17_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_temp_17_temperature_17_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_temp_17_temperature_17_is_in_range(int16_t value);

/**
 * Pack message RT_DL1MK3_Temp_16.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_16_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_temp_16_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Temp_16.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_16_unpack(
    struct vehicle_rt_dl1_mk3_temp_16_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Temp_16.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_temp_16_init(struct vehicle_rt_dl1_mk3_temp_16_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_dl1_mk3_temp_16_temperature_16_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_temp_16_temperature_16_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_temp_16_temperature_16_is_in_range(int16_t value);

/**
 * Pack message RT_DL1MK3_Temp_15.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_15_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_temp_15_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Temp_15.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_15_unpack(
    struct vehicle_rt_dl1_mk3_temp_15_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Temp_15.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_temp_15_init(struct vehicle_rt_dl1_mk3_temp_15_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_dl1_mk3_temp_15_temperature_15_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_temp_15_temperature_15_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_temp_15_temperature_15_is_in_range(int16_t value);

/**
 * Pack message RT_DL1MK3_Temp_14.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_14_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_temp_14_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Temp_14.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_14_unpack(
    struct vehicle_rt_dl1_mk3_temp_14_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Temp_14.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_temp_14_init(struct vehicle_rt_dl1_mk3_temp_14_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_dl1_mk3_temp_14_temperature_14_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_temp_14_temperature_14_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_temp_14_temperature_14_is_in_range(int16_t value);

/**
 * Pack message RT_DL1MK3_Temp_13.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_13_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_temp_13_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Temp_13.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_13_unpack(
    struct vehicle_rt_dl1_mk3_temp_13_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Temp_13.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_temp_13_init(struct vehicle_rt_dl1_mk3_temp_13_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_dl1_mk3_temp_13_temperature_13_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_temp_13_temperature_13_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_temp_13_temperature_13_is_in_range(int16_t value);

/**
 * Pack message RT_DL1MK3_Temp_12.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_12_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_temp_12_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Temp_12.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_12_unpack(
    struct vehicle_rt_dl1_mk3_temp_12_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Temp_12.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_temp_12_init(struct vehicle_rt_dl1_mk3_temp_12_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_dl1_mk3_temp_12_temperature_12_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_temp_12_temperature_12_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_temp_12_temperature_12_is_in_range(int16_t value);

/**
 * Pack message RT_DL1MK3_Temp_11.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_11_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_temp_11_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Temp_11.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_11_unpack(
    struct vehicle_rt_dl1_mk3_temp_11_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Temp_11.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_temp_11_init(struct vehicle_rt_dl1_mk3_temp_11_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_dl1_mk3_temp_11_temperature_11_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_temp_11_temperature_11_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_temp_11_temperature_11_is_in_range(int16_t value);

/**
 * Pack message RT_DL1MK3_Temp_10.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_10_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_temp_10_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Temp_10.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_10_unpack(
    struct vehicle_rt_dl1_mk3_temp_10_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Temp_10.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_temp_10_init(struct vehicle_rt_dl1_mk3_temp_10_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_dl1_mk3_temp_10_temperature_10_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_temp_10_temperature_10_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_temp_10_temperature_10_is_in_range(int16_t value);

/**
 * Pack message RT_DL1MK3_Temp_9.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_9_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_temp_9_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Temp_9.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_9_unpack(
    struct vehicle_rt_dl1_mk3_temp_9_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Temp_9.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_temp_9_init(struct vehicle_rt_dl1_mk3_temp_9_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_dl1_mk3_temp_9_temperature_9_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_temp_9_temperature_9_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_temp_9_temperature_9_is_in_range(int16_t value);

/**
 * Pack message RT_DL1MK3_Temp_8.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_8_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_temp_8_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Temp_8.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_8_unpack(
    struct vehicle_rt_dl1_mk3_temp_8_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Temp_8.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_temp_8_init(struct vehicle_rt_dl1_mk3_temp_8_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_dl1_mk3_temp_8_temperature_8_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_temp_8_temperature_8_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_temp_8_temperature_8_is_in_range(int16_t value);

/**
 * Pack message RT_DL1MK3_Temp_7.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_7_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_temp_7_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Temp_7.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_7_unpack(
    struct vehicle_rt_dl1_mk3_temp_7_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Temp_7.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_temp_7_init(struct vehicle_rt_dl1_mk3_temp_7_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_dl1_mk3_temp_7_temperature_7_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_temp_7_temperature_7_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_temp_7_temperature_7_is_in_range(int16_t value);

/**
 * Pack message RT_DL1MK3_Temp_6.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_6_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_temp_6_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Temp_6.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_6_unpack(
    struct vehicle_rt_dl1_mk3_temp_6_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Temp_6.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_temp_6_init(struct vehicle_rt_dl1_mk3_temp_6_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_dl1_mk3_temp_6_temperature_6_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_temp_6_temperature_6_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_temp_6_temperature_6_is_in_range(int16_t value);

/**
 * Pack message RT_DL1MK3_Temp_5.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_5_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_temp_5_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Temp_5.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_5_unpack(
    struct vehicle_rt_dl1_mk3_temp_5_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Temp_5.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_temp_5_init(struct vehicle_rt_dl1_mk3_temp_5_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_dl1_mk3_temp_5_temperature_5_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_temp_5_temperature_5_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_temp_5_temperature_5_is_in_range(int16_t value);

/**
 * Pack message RT_DL1MK3_Temp_4.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_4_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_temp_4_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Temp_4.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_4_unpack(
    struct vehicle_rt_dl1_mk3_temp_4_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Temp_4.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_temp_4_init(struct vehicle_rt_dl1_mk3_temp_4_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_dl1_mk3_temp_4_temperature_4_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_temp_4_temperature_4_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_temp_4_temperature_4_is_in_range(int16_t value);

/**
 * Pack message RT_DL1MK3_Temp_3.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_3_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_temp_3_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Temp_3.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_3_unpack(
    struct vehicle_rt_dl1_mk3_temp_3_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Temp_3.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_temp_3_init(struct vehicle_rt_dl1_mk3_temp_3_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_dl1_mk3_temp_3_temperature_3_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_temp_3_temperature_3_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_temp_3_temperature_3_is_in_range(int16_t value);

/**
 * Pack message RT_DL1MK3_Temp_2.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_2_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_temp_2_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Temp_2.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_2_unpack(
    struct vehicle_rt_dl1_mk3_temp_2_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Temp_2.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_temp_2_init(struct vehicle_rt_dl1_mk3_temp_2_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_dl1_mk3_temp_2_temperature_2_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_temp_2_temperature_2_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_temp_2_temperature_2_is_in_range(int16_t value);

/**
 * Pack message RT_DL1MK3_Temp_1.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_1_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_temp_1_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Temp_1.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_temp_1_unpack(
    struct vehicle_rt_dl1_mk3_temp_1_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Temp_1.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_temp_1_init(struct vehicle_rt_dl1_mk3_temp_1_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_dl1_mk3_temp_1_temperature_1_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_temp_1_temperature_1_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_temp_1_temperature_1_is_in_range(int16_t value);

/**
 * Pack message RT_DL1MK3_Analog_32.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_32_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_analog_32_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Analog_32.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_32_unpack(
    struct vehicle_rt_dl1_mk3_analog_32_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Analog_32.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_analog_32_init(struct vehicle_rt_dl1_mk3_analog_32_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_analog_32_analog_32_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_analog_32_analog_32_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_analog_32_analog_32_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Analog_31.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_31_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_analog_31_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Analog_31.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_31_unpack(
    struct vehicle_rt_dl1_mk3_analog_31_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Analog_31.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_analog_31_init(struct vehicle_rt_dl1_mk3_analog_31_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_analog_31_analog_31_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_analog_31_analog_31_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_analog_31_analog_31_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Analog_30.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_30_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_analog_30_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Analog_30.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_30_unpack(
    struct vehicle_rt_dl1_mk3_analog_30_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Analog_30.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_analog_30_init(struct vehicle_rt_dl1_mk3_analog_30_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_analog_30_analog_30_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_analog_30_analog_30_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_analog_30_analog_30_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Analog_29.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_29_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_analog_29_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Analog_29.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_29_unpack(
    struct vehicle_rt_dl1_mk3_analog_29_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Analog_29.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_analog_29_init(struct vehicle_rt_dl1_mk3_analog_29_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_analog_29_analog_29_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_analog_29_analog_29_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_analog_29_analog_29_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Analog_28.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_28_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_analog_28_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Analog_28.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_28_unpack(
    struct vehicle_rt_dl1_mk3_analog_28_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Analog_28.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_analog_28_init(struct vehicle_rt_dl1_mk3_analog_28_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_analog_28_analog_28_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_analog_28_analog_28_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_analog_28_analog_28_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Analog_27.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_27_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_analog_27_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Analog_27.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_27_unpack(
    struct vehicle_rt_dl1_mk3_analog_27_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Analog_27.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_analog_27_init(struct vehicle_rt_dl1_mk3_analog_27_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_analog_27_analog_27_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_analog_27_analog_27_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_analog_27_analog_27_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Analog_26.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_26_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_analog_26_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Analog_26.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_26_unpack(
    struct vehicle_rt_dl1_mk3_analog_26_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Analog_26.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_analog_26_init(struct vehicle_rt_dl1_mk3_analog_26_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_analog_26_analog_26_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_analog_26_analog_26_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_analog_26_analog_26_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Analog_25.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_25_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_analog_25_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Analog_25.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_25_unpack(
    struct vehicle_rt_dl1_mk3_analog_25_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Analog_25.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_analog_25_init(struct vehicle_rt_dl1_mk3_analog_25_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_analog_25_analog_25_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_analog_25_analog_25_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_analog_25_analog_25_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Analog_15.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_15_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_analog_15_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Analog_15.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_15_unpack(
    struct vehicle_rt_dl1_mk3_analog_15_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Analog_15.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_analog_15_init(struct vehicle_rt_dl1_mk3_analog_15_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_analog_15_analog_15_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_analog_15_analog_15_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_analog_15_analog_15_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Analog_14.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_14_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_analog_14_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Analog_14.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_14_unpack(
    struct vehicle_rt_dl1_mk3_analog_14_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Analog_14.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_analog_14_init(struct vehicle_rt_dl1_mk3_analog_14_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_analog_14_analog_14_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_analog_14_analog_14_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_analog_14_analog_14_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Analog_17.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_17_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_analog_17_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Analog_17.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_17_unpack(
    struct vehicle_rt_dl1_mk3_analog_17_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Analog_17.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_analog_17_init(struct vehicle_rt_dl1_mk3_analog_17_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_analog_17_analog_17_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_analog_17_analog_17_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_analog_17_analog_17_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Analog_24.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_24_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_analog_24_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Analog_24.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_24_unpack(
    struct vehicle_rt_dl1_mk3_analog_24_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Analog_24.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_analog_24_init(struct vehicle_rt_dl1_mk3_analog_24_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_analog_24_analog_24_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_analog_24_analog_24_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_analog_24_analog_24_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Analog_23.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_23_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_analog_23_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Analog_23.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_23_unpack(
    struct vehicle_rt_dl1_mk3_analog_23_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Analog_23.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_analog_23_init(struct vehicle_rt_dl1_mk3_analog_23_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_analog_23_analog_23_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_analog_23_analog_23_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_analog_23_analog_23_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Analog_22.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_22_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_analog_22_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Analog_22.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_22_unpack(
    struct vehicle_rt_dl1_mk3_analog_22_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Analog_22.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_analog_22_init(struct vehicle_rt_dl1_mk3_analog_22_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_analog_22_analog_22_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_analog_22_analog_22_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_analog_22_analog_22_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Analog_21.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_21_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_analog_21_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Analog_21.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_21_unpack(
    struct vehicle_rt_dl1_mk3_analog_21_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Analog_21.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_analog_21_init(struct vehicle_rt_dl1_mk3_analog_21_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_analog_21_analog_21_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_analog_21_analog_21_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_analog_21_analog_21_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Analog_20.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_20_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_analog_20_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Analog_20.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_20_unpack(
    struct vehicle_rt_dl1_mk3_analog_20_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Analog_20.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_analog_20_init(struct vehicle_rt_dl1_mk3_analog_20_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_analog_20_analog_20_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_analog_20_analog_20_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_analog_20_analog_20_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Analog_19.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_19_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_analog_19_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Analog_19.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_19_unpack(
    struct vehicle_rt_dl1_mk3_analog_19_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Analog_19.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_analog_19_init(struct vehicle_rt_dl1_mk3_analog_19_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_analog_19_analog_19_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_analog_19_analog_19_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_analog_19_analog_19_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Analog_16.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_16_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_analog_16_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Analog_16.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_16_unpack(
    struct vehicle_rt_dl1_mk3_analog_16_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Analog_16.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_analog_16_init(struct vehicle_rt_dl1_mk3_analog_16_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_analog_16_analog_16_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_analog_16_analog_16_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_analog_16_analog_16_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Analog_18.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_18_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_analog_18_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Analog_18.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_18_unpack(
    struct vehicle_rt_dl1_mk3_analog_18_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Analog_18.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_analog_18_init(struct vehicle_rt_dl1_mk3_analog_18_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_analog_18_analog_18_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_analog_18_analog_18_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_analog_18_analog_18_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Analog_12.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_12_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_analog_12_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Analog_12.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_12_unpack(
    struct vehicle_rt_dl1_mk3_analog_12_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Analog_12.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_analog_12_init(struct vehicle_rt_dl1_mk3_analog_12_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_analog_12_analog_12_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_analog_12_analog_12_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_analog_12_analog_12_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Analog_11.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_11_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_analog_11_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Analog_11.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_11_unpack(
    struct vehicle_rt_dl1_mk3_analog_11_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Analog_11.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_analog_11_init(struct vehicle_rt_dl1_mk3_analog_11_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_analog_11_analog_11_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_analog_11_analog_11_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_analog_11_analog_11_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Analog_10.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_10_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_analog_10_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Analog_10.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_10_unpack(
    struct vehicle_rt_dl1_mk3_analog_10_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Analog_10.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_analog_10_init(struct vehicle_rt_dl1_mk3_analog_10_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_analog_10_analog_10_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_analog_10_analog_10_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_analog_10_analog_10_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Analog_9.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_9_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_analog_9_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Analog_9.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_9_unpack(
    struct vehicle_rt_dl1_mk3_analog_9_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Analog_9.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_analog_9_init(struct vehicle_rt_dl1_mk3_analog_9_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_analog_9_analog_9_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_analog_9_analog_9_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_analog_9_analog_9_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Analog_8.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_8_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_analog_8_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Analog_8.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_8_unpack(
    struct vehicle_rt_dl1_mk3_analog_8_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Analog_8.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_analog_8_init(struct vehicle_rt_dl1_mk3_analog_8_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_analog_8_analog_8_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_analog_8_analog_8_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_analog_8_analog_8_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Analog_7.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_7_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_analog_7_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Analog_7.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_7_unpack(
    struct vehicle_rt_dl1_mk3_analog_7_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Analog_7.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_analog_7_init(struct vehicle_rt_dl1_mk3_analog_7_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_analog_7_analog_7_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_analog_7_analog_7_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_analog_7_analog_7_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Analog_6.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_6_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_analog_6_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Analog_6.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_6_unpack(
    struct vehicle_rt_dl1_mk3_analog_6_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Analog_6.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_analog_6_init(struct vehicle_rt_dl1_mk3_analog_6_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_analog_6_analog_6_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_analog_6_analog_6_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_analog_6_analog_6_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Analog_5.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_5_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_analog_5_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Analog_5.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_5_unpack(
    struct vehicle_rt_dl1_mk3_analog_5_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Analog_5.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_analog_5_init(struct vehicle_rt_dl1_mk3_analog_5_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_analog_5_analog_5_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_analog_5_analog_5_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_analog_5_analog_5_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Analog_4.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_4_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_analog_4_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Analog_4.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_4_unpack(
    struct vehicle_rt_dl1_mk3_analog_4_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Analog_4.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_analog_4_init(struct vehicle_rt_dl1_mk3_analog_4_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_analog_4_analog_4_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_analog_4_analog_4_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_analog_4_analog_4_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Analog_3.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_3_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_analog_3_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Analog_3.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_3_unpack(
    struct vehicle_rt_dl1_mk3_analog_3_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Analog_3.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_analog_3_init(struct vehicle_rt_dl1_mk3_analog_3_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_analog_3_analog_3_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_analog_3_analog_3_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_analog_3_analog_3_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Analog_2.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_2_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_analog_2_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Analog_2.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_2_unpack(
    struct vehicle_rt_dl1_mk3_analog_2_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Analog_2.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_analog_2_init(struct vehicle_rt_dl1_mk3_analog_2_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_analog_2_analog_2_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_analog_2_analog_2_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_analog_2_analog_2_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Analog_1.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_1_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_analog_1_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Analog_1.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_analog_1_unpack(
    struct vehicle_rt_dl1_mk3_analog_1_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Analog_1.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_analog_1_init(struct vehicle_rt_dl1_mk3_analog_1_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_dl1_mk3_analog_1_analog_1_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_analog_1_analog_1_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_analog_1_analog_1_is_in_range(uint16_t value);

/**
 * Pack message RT_DL1MK3_Accel.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_dl1_mk3_accel_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_dl1_mk3_accel_t *src_p,
    size_t size);

/**
 * Unpack message RT_DL1MK3_Accel.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_dl1_mk3_accel_unpack(
    struct vehicle_rt_dl1_mk3_accel_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_DL1MK3_Accel.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_dl1_mk3_accel_init(struct vehicle_rt_dl1_mk3_accel_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_dl1_mk3_accel_validity_accel_longitudinal_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_accel_validity_accel_longitudinal_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_accel_validity_accel_longitudinal_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_dl1_mk3_accel_validity_accel_lateral_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_accel_validity_accel_lateral_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_accel_validity_accel_lateral_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_dl1_mk3_accel_validity_accel_vertical_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_accel_validity_accel_vertical_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_accel_validity_accel_vertical_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_dl1_mk3_accel_accuracy_accel_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_accel_accuracy_accel_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_accel_accuracy_accel_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_dl1_mk3_accel_accel_longitudinal_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_accel_accel_longitudinal_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_accel_accel_longitudinal_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_dl1_mk3_accel_accel_lateral_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_accel_accel_lateral_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_accel_accel_lateral_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_dl1_mk3_accel_accel_vertical_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_dl1_mk3_accel_accel_vertical_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_dl1_mk3_accel_accel_vertical_is_in_range(int16_t value);

/**
 * Pack message RT_SB_INS_Vpt_4_Vel_NED_2.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_ins_vpt_4_vel_ned_2_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_ins_vpt_4_vel_ned_2_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_INS_Vpt_4_Vel_NED_2.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_ins_vpt_4_vel_ned_2_unpack(
    struct vehicle_rt_sb_ins_vpt_4_vel_ned_2_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_INS_Vpt_4_Vel_NED_2.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_ins_vpt_4_vel_ned_2_init(struct vehicle_rt_sb_ins_vpt_4_vel_ned_2_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_ins_vpt_4_vel_ned_2_virtual_4_vel_ned_d_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vpt_4_vel_ned_2_virtual_4_vel_ned_d_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vpt_4_vel_ned_2_virtual_4_vel_ned_d_is_in_range(int32_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_ins_vpt_4_vel_ned_2_virtual_4_heading_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vpt_4_vel_ned_2_virtual_4_heading_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vpt_4_vel_ned_2_virtual_4_heading_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_ins_vpt_4_vel_ned_2_virtual_4_slip_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vpt_4_vel_ned_2_virtual_4_slip_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vpt_4_vel_ned_2_virtual_4_slip_is_in_range(int16_t value);

/**
 * Pack message RT_SB_INS_Vpt_4_Vel_NED_1.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_ins_vpt_4_vel_ned_1_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_ins_vpt_4_vel_ned_1_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_INS_Vpt_4_Vel_NED_1.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_ins_vpt_4_vel_ned_1_unpack(
    struct vehicle_rt_sb_ins_vpt_4_vel_ned_1_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_INS_Vpt_4_Vel_NED_1.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_ins_vpt_4_vel_ned_1_init(struct vehicle_rt_sb_ins_vpt_4_vel_ned_1_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_ins_vpt_4_vel_ned_1_virtual_4_vel_ned_n_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vpt_4_vel_ned_1_virtual_4_vel_ned_n_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vpt_4_vel_ned_1_virtual_4_vel_ned_n_is_in_range(int32_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_ins_vpt_4_vel_ned_1_virtual_4_vel_ned_e_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vpt_4_vel_ned_1_virtual_4_vel_ned_e_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vpt_4_vel_ned_1_virtual_4_vel_ned_e_is_in_range(int32_t value);

/**
 * Pack message RT_SB_INS_Vpt_4_Offset.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_ins_vpt_4_offset_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_ins_vpt_4_offset_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_INS_Vpt_4_Offset.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_ins_vpt_4_offset_unpack(
    struct vehicle_rt_sb_ins_vpt_4_offset_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_INS_Vpt_4_Offset.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_ins_vpt_4_offset_init(struct vehicle_rt_sb_ins_vpt_4_offset_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_ins_vpt_4_offset_virtual_4_offset_x_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vpt_4_offset_virtual_4_offset_x_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vpt_4_offset_virtual_4_offset_x_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_ins_vpt_4_offset_virtual_4_offset_y_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vpt_4_offset_virtual_4_offset_y_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vpt_4_offset_virtual_4_offset_y_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_ins_vpt_4_offset_virtual_4_offset_z_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vpt_4_offset_virtual_4_offset_z_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vpt_4_offset_virtual_4_offset_z_is_in_range(int16_t value);

/**
 * Pack message RT_SB_INS_Vpt_3_Vel_NED_2.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_ins_vpt_3_vel_ned_2_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_ins_vpt_3_vel_ned_2_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_INS_Vpt_3_Vel_NED_2.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_ins_vpt_3_vel_ned_2_unpack(
    struct vehicle_rt_sb_ins_vpt_3_vel_ned_2_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_INS_Vpt_3_Vel_NED_2.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_ins_vpt_3_vel_ned_2_init(struct vehicle_rt_sb_ins_vpt_3_vel_ned_2_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_ins_vpt_3_vel_ned_2_virtual_3_vel_ned_d_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vpt_3_vel_ned_2_virtual_3_vel_ned_d_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vpt_3_vel_ned_2_virtual_3_vel_ned_d_is_in_range(int32_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_ins_vpt_3_vel_ned_2_virtual_3_heading_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vpt_3_vel_ned_2_virtual_3_heading_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vpt_3_vel_ned_2_virtual_3_heading_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_ins_vpt_3_vel_ned_2_virtual_3_slip_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vpt_3_vel_ned_2_virtual_3_slip_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vpt_3_vel_ned_2_virtual_3_slip_is_in_range(int16_t value);

/**
 * Pack message RT_SB_INS_Vpt_3_Vel_NED_1.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_ins_vpt_3_vel_ned_1_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_ins_vpt_3_vel_ned_1_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_INS_Vpt_3_Vel_NED_1.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_ins_vpt_3_vel_ned_1_unpack(
    struct vehicle_rt_sb_ins_vpt_3_vel_ned_1_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_INS_Vpt_3_Vel_NED_1.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_ins_vpt_3_vel_ned_1_init(struct vehicle_rt_sb_ins_vpt_3_vel_ned_1_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_ins_vpt_3_vel_ned_1_virtual_3_vel_ned_n_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vpt_3_vel_ned_1_virtual_3_vel_ned_n_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vpt_3_vel_ned_1_virtual_3_vel_ned_n_is_in_range(int32_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_ins_vpt_3_vel_ned_1_virtual_3_vel_ned_e_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vpt_3_vel_ned_1_virtual_3_vel_ned_e_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vpt_3_vel_ned_1_virtual_3_vel_ned_e_is_in_range(int32_t value);

/**
 * Pack message RT_SB_INS_Vpt_3_Offset.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_ins_vpt_3_offset_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_ins_vpt_3_offset_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_INS_Vpt_3_Offset.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_ins_vpt_3_offset_unpack(
    struct vehicle_rt_sb_ins_vpt_3_offset_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_INS_Vpt_3_Offset.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_ins_vpt_3_offset_init(struct vehicle_rt_sb_ins_vpt_3_offset_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_ins_vpt_3_offset_virtual_3_offset_x_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vpt_3_offset_virtual_3_offset_x_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vpt_3_offset_virtual_3_offset_x_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_ins_vpt_3_offset_virtual_3_offset_y_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vpt_3_offset_virtual_3_offset_y_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vpt_3_offset_virtual_3_offset_y_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_ins_vpt_3_offset_virtual_3_offset_z_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vpt_3_offset_virtual_3_offset_z_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vpt_3_offset_virtual_3_offset_z_is_in_range(int16_t value);

/**
 * Pack message RT_SB_INS_Vpt_2_Vel_NED_2.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_ins_vpt_2_vel_ned_2_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_ins_vpt_2_vel_ned_2_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_INS_Vpt_2_Vel_NED_2.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_ins_vpt_2_vel_ned_2_unpack(
    struct vehicle_rt_sb_ins_vpt_2_vel_ned_2_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_INS_Vpt_2_Vel_NED_2.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_ins_vpt_2_vel_ned_2_init(struct vehicle_rt_sb_ins_vpt_2_vel_ned_2_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_ins_vpt_2_vel_ned_2_virtual_2_vel_ned_d_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vpt_2_vel_ned_2_virtual_2_vel_ned_d_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vpt_2_vel_ned_2_virtual_2_vel_ned_d_is_in_range(int32_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_ins_vpt_2_vel_ned_2_virtual_2_heading_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vpt_2_vel_ned_2_virtual_2_heading_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vpt_2_vel_ned_2_virtual_2_heading_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_ins_vpt_2_vel_ned_2_virtual_2_slip_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vpt_2_vel_ned_2_virtual_2_slip_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vpt_2_vel_ned_2_virtual_2_slip_is_in_range(int16_t value);

/**
 * Pack message RT_SB_INS_Vpt_2_Vel_NED_1.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_ins_vpt_2_vel_ned_1_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_ins_vpt_2_vel_ned_1_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_INS_Vpt_2_Vel_NED_1.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_ins_vpt_2_vel_ned_1_unpack(
    struct vehicle_rt_sb_ins_vpt_2_vel_ned_1_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_INS_Vpt_2_Vel_NED_1.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_ins_vpt_2_vel_ned_1_init(struct vehicle_rt_sb_ins_vpt_2_vel_ned_1_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_ins_vpt_2_vel_ned_1_virtual_2_vel_ned_n_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vpt_2_vel_ned_1_virtual_2_vel_ned_n_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vpt_2_vel_ned_1_virtual_2_vel_ned_n_is_in_range(int32_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_ins_vpt_2_vel_ned_1_virtual_2_vel_ned_e_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vpt_2_vel_ned_1_virtual_2_vel_ned_e_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vpt_2_vel_ned_1_virtual_2_vel_ned_e_is_in_range(int32_t value);

/**
 * Pack message RT_SB_INS_Vpt_2_Offset.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_ins_vpt_2_offset_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_ins_vpt_2_offset_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_INS_Vpt_2_Offset.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_ins_vpt_2_offset_unpack(
    struct vehicle_rt_sb_ins_vpt_2_offset_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_INS_Vpt_2_Offset.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_ins_vpt_2_offset_init(struct vehicle_rt_sb_ins_vpt_2_offset_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_ins_vpt_2_offset_virtual_2_offset_x_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vpt_2_offset_virtual_2_offset_x_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vpt_2_offset_virtual_2_offset_x_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_ins_vpt_2_offset_virtual_2_offset_y_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vpt_2_offset_virtual_2_offset_y_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vpt_2_offset_virtual_2_offset_y_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_ins_vpt_2_offset_virtual_2_offset_z_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vpt_2_offset_virtual_2_offset_z_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vpt_2_offset_virtual_2_offset_z_is_in_range(int16_t value);

/**
 * Pack message RT_SB_INS_Vpt_1_Vel_NED_2.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_ins_vpt_1_vel_ned_2_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_ins_vpt_1_vel_ned_2_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_INS_Vpt_1_Vel_NED_2.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_ins_vpt_1_vel_ned_2_unpack(
    struct vehicle_rt_sb_ins_vpt_1_vel_ned_2_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_INS_Vpt_1_Vel_NED_2.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_ins_vpt_1_vel_ned_2_init(struct vehicle_rt_sb_ins_vpt_1_vel_ned_2_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_ins_vpt_1_vel_ned_2_virtual_1_vel_ned_d_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vpt_1_vel_ned_2_virtual_1_vel_ned_d_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vpt_1_vel_ned_2_virtual_1_vel_ned_d_is_in_range(int32_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_ins_vpt_1_vel_ned_2_virtual_1_heading_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vpt_1_vel_ned_2_virtual_1_heading_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vpt_1_vel_ned_2_virtual_1_heading_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_ins_vpt_1_vel_ned_2_virtual_1_slip_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vpt_1_vel_ned_2_virtual_1_slip_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vpt_1_vel_ned_2_virtual_1_slip_is_in_range(int16_t value);

/**
 * Pack message RT_SB_INS_Vpt_1_Vel_NED_1.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_ins_vpt_1_vel_ned_1_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_ins_vpt_1_vel_ned_1_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_INS_Vpt_1_Vel_NED_1.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_ins_vpt_1_vel_ned_1_unpack(
    struct vehicle_rt_sb_ins_vpt_1_vel_ned_1_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_INS_Vpt_1_Vel_NED_1.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_ins_vpt_1_vel_ned_1_init(struct vehicle_rt_sb_ins_vpt_1_vel_ned_1_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_ins_vpt_1_vel_ned_1_virtual_1_vel_ned_n_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vpt_1_vel_ned_1_virtual_1_vel_ned_n_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vpt_1_vel_ned_1_virtual_1_vel_ned_n_is_in_range(int32_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_ins_vpt_1_vel_ned_1_virtual_1_vel_ned_e_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vpt_1_vel_ned_1_virtual_1_vel_ned_e_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vpt_1_vel_ned_1_virtual_1_vel_ned_e_is_in_range(int32_t value);

/**
 * Pack message RT_SB_INS_Vpt_1_Offset.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_ins_vpt_1_offset_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_ins_vpt_1_offset_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_INS_Vpt_1_Offset.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_ins_vpt_1_offset_unpack(
    struct vehicle_rt_sb_ins_vpt_1_offset_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_INS_Vpt_1_Offset.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_ins_vpt_1_offset_init(struct vehicle_rt_sb_ins_vpt_1_offset_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_ins_vpt_1_offset_virtual_1_offset_x_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vpt_1_offset_virtual_1_offset_x_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vpt_1_offset_virtual_1_offset_x_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_ins_vpt_1_offset_virtual_1_offset_y_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vpt_1_offset_virtual_1_offset_y_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vpt_1_offset_virtual_1_offset_y_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_ins_vpt_1_offset_virtual_1_offset_z_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vpt_1_offset_virtual_1_offset_z_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vpt_1_offset_virtual_1_offset_z_is_in_range(int16_t value);

/**
 * Pack message RT_SB_INS_Slip.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_ins_slip_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_ins_slip_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_INS_Slip.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_ins_slip_unpack(
    struct vehicle_rt_sb_ins_slip_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_INS_Slip.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_ins_slip_init(struct vehicle_rt_sb_ins_slip_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_slip_validity_ins_slip_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_slip_validity_ins_slip_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_slip_validity_ins_slip_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_slip_validity_ins_squat_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_slip_validity_ins_squat_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_slip_validity_ins_squat_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_slip_accuracy_ins_slip_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_slip_accuracy_ins_slip_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_slip_accuracy_ins_slip_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_ins_slip_ins_slip_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_slip_ins_slip_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_slip_ins_slip_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_slip_accuracy_ins_squat_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_slip_accuracy_ins_squat_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_slip_accuracy_ins_squat_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_ins_slip_ins_squat_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_slip_ins_squat_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_slip_ins_squat_is_in_range(int16_t value);

/**
 * Pack message RT_SB_INS_Vel_ECEF_2.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_ins_vel_ecef_2_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_ins_vel_ecef_2_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_INS_Vel_ECEF_2.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_ins_vel_ecef_2_unpack(
    struct vehicle_rt_sb_ins_vel_ecef_2_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_INS_Vel_ECEF_2.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_ins_vel_ecef_2_init(struct vehicle_rt_sb_ins_vel_ecef_2_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_vel_ecef_2_validity_ins_vel_ecef_y_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vel_ecef_2_validity_ins_vel_ecef_y_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vel_ecef_2_validity_ins_vel_ecef_y_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_vel_ecef_2_validity_ins_vel_ecef_z_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vel_ecef_2_validity_ins_vel_ecef_z_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vel_ecef_2_validity_ins_vel_ecef_z_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_ins_vel_ecef_2_ins_vel_ecef_y_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vel_ecef_2_ins_vel_ecef_y_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vel_ecef_2_ins_vel_ecef_y_is_in_range(int32_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_ins_vel_ecef_2_ins_vel_ecef_z_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vel_ecef_2_ins_vel_ecef_z_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vel_ecef_2_ins_vel_ecef_z_is_in_range(int32_t value);

/**
 * Pack message RT_SB_INS_Vel_ECEF_1.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_ins_vel_ecef_1_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_ins_vel_ecef_1_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_INS_Vel_ECEF_1.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_ins_vel_ecef_1_unpack(
    struct vehicle_rt_sb_ins_vel_ecef_1_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_INS_Vel_ECEF_1.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_ins_vel_ecef_1_init(struct vehicle_rt_sb_ins_vel_ecef_1_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_vel_ecef_1_validity_ins_vel_ecef_x_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vel_ecef_1_validity_ins_vel_ecef_x_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vel_ecef_1_validity_ins_vel_ecef_x_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_vel_ecef_1_accuracy_ins_vel_ecef_x_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vel_ecef_1_accuracy_ins_vel_ecef_x_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vel_ecef_1_accuracy_ins_vel_ecef_x_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_vel_ecef_1_accuracy_ins_vel_ecef_y_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vel_ecef_1_accuracy_ins_vel_ecef_y_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vel_ecef_1_accuracy_ins_vel_ecef_y_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_vel_ecef_1_accuracy_ins_vel_ecef_z_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vel_ecef_1_accuracy_ins_vel_ecef_z_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vel_ecef_1_accuracy_ins_vel_ecef_z_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_ins_vel_ecef_1_ins_vel_ecef_x_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vel_ecef_1_ins_vel_ecef_x_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vel_ecef_1_ins_vel_ecef_x_is_in_range(int32_t value);

/**
 * Pack message RT_SB_INS_Vel_NED_2.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_ins_vel_ned_2_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_ins_vel_ned_2_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_INS_Vel_NED_2.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_ins_vel_ned_2_unpack(
    struct vehicle_rt_sb_ins_vel_ned_2_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_INS_Vel_NED_2.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_ins_vel_ned_2_init(struct vehicle_rt_sb_ins_vel_ned_2_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_vel_ned_2_validity_ins_vel_ned_d_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vel_ned_2_validity_ins_vel_ned_d_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vel_ned_2_validity_ins_vel_ned_d_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_vel_ned_2_accuracy_ins_vel_d_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vel_ned_2_accuracy_ins_vel_d_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vel_ned_2_accuracy_ins_vel_d_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_ins_vel_ned_2_ins_vel_ned_d_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vel_ned_2_ins_vel_ned_d_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vel_ned_2_ins_vel_ned_d_is_in_range(int32_t value);

/**
 * Pack message RT_SB_INS_Vel_NED_1.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_ins_vel_ned_1_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_ins_vel_ned_1_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_INS_Vel_NED_1.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_ins_vel_ned_1_unpack(
    struct vehicle_rt_sb_ins_vel_ned_1_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_INS_Vel_NED_1.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_ins_vel_ned_1_init(struct vehicle_rt_sb_ins_vel_ned_1_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_vel_ned_1_validity_ins_vel_ned_n_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vel_ned_1_validity_ins_vel_ned_n_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vel_ned_1_validity_ins_vel_ned_n_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_vel_ned_1_validity_ins_vel_ned_e_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vel_ned_1_validity_ins_vel_ned_e_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vel_ned_1_validity_ins_vel_ned_e_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_vel_ned_1_accuracy_ins_vel_ne_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vel_ned_1_accuracy_ins_vel_ne_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vel_ned_1_accuracy_ins_vel_ne_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_ins_vel_ned_1_ins_vel_ned_n_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vel_ned_1_ins_vel_ned_n_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vel_ned_1_ins_vel_ned_n_is_in_range(int32_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_ins_vel_ned_1_ins_vel_ned_e_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_vel_ned_1_ins_vel_ned_e_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_vel_ned_1_ins_vel_ned_e_is_in_range(int32_t value);

/**
 * Pack message RT_SB_INS_Pos_ECEF_2.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_ins_pos_ecef_2_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_ins_pos_ecef_2_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_INS_Pos_ECEF_2.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_ins_pos_ecef_2_unpack(
    struct vehicle_rt_sb_ins_pos_ecef_2_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_INS_Pos_ECEF_2.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_ins_pos_ecef_2_init(struct vehicle_rt_sb_ins_pos_ecef_2_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_ins_pos_ecef_2_ins_pos_ecef_y_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_pos_ecef_2_ins_pos_ecef_y_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_pos_ecef_2_ins_pos_ecef_y_is_in_range(int32_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_ins_pos_ecef_2_ins_pos_ecef_z_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_pos_ecef_2_ins_pos_ecef_z_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_pos_ecef_2_ins_pos_ecef_z_is_in_range(int32_t value);

/**
 * Pack message RT_SB_INS_Pos_ECEF_1.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_ins_pos_ecef_1_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_ins_pos_ecef_1_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_INS_Pos_ECEF_1.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_ins_pos_ecef_1_unpack(
    struct vehicle_rt_sb_ins_pos_ecef_1_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_INS_Pos_ECEF_1.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_ins_pos_ecef_1_init(struct vehicle_rt_sb_ins_pos_ecef_1_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_pos_ecef_1_validity_ins_pos_ecef_x_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_pos_ecef_1_validity_ins_pos_ecef_x_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_pos_ecef_1_validity_ins_pos_ecef_x_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_pos_ecef_1_validity_ins_pos_ecef_y_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_pos_ecef_1_validity_ins_pos_ecef_y_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_pos_ecef_1_validity_ins_pos_ecef_y_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_pos_ecef_1_validity_ins_pos_ecef_z_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_pos_ecef_1_validity_ins_pos_ecef_z_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_pos_ecef_1_validity_ins_pos_ecef_z_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_pos_ecef_1_accuracy_ins_pos_ecef_x_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_pos_ecef_1_accuracy_ins_pos_ecef_x_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_pos_ecef_1_accuracy_ins_pos_ecef_x_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_pos_ecef_1_accuracy_ins_pos_ecef_y_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_pos_ecef_1_accuracy_ins_pos_ecef_y_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_pos_ecef_1_accuracy_ins_pos_ecef_y_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_pos_ecef_1_accuracy_ins_pos_ecef_z_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_pos_ecef_1_accuracy_ins_pos_ecef_z_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_pos_ecef_1_accuracy_ins_pos_ecef_z_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_ins_pos_ecef_1_ins_pos_ecef_x_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_pos_ecef_1_ins_pos_ecef_x_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_pos_ecef_1_ins_pos_ecef_x_is_in_range(int32_t value);

/**
 * Pack message RT_SB_INS_Pos_LLH_2.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_ins_pos_llh_2_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_ins_pos_llh_2_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_INS_Pos_LLH_2.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_ins_pos_llh_2_unpack(
    struct vehicle_rt_sb_ins_pos_llh_2_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_INS_Pos_LLH_2.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_ins_pos_llh_2_init(struct vehicle_rt_sb_ins_pos_llh_2_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_ins_pos_llh_2_ins_pos_llh_longitude_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_pos_llh_2_ins_pos_llh_longitude_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_pos_llh_2_ins_pos_llh_longitude_is_in_range(int32_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_ins_pos_llh_2_ins_pos_llh_altitude_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_pos_llh_2_ins_pos_llh_altitude_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_pos_llh_2_ins_pos_llh_altitude_is_in_range(int32_t value);

/**
 * Pack message RT_SB_INS_Pos_LLH_1.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_ins_pos_llh_1_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_ins_pos_llh_1_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_INS_Pos_LLH_1.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_ins_pos_llh_1_unpack(
    struct vehicle_rt_sb_ins_pos_llh_1_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_INS_Pos_LLH_1.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_ins_pos_llh_1_init(struct vehicle_rt_sb_ins_pos_llh_1_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_pos_llh_1_validity_ins_pos_llh_latitude_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_pos_llh_1_validity_ins_pos_llh_latitude_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_pos_llh_1_validity_ins_pos_llh_latitude_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_pos_llh_1_validity_ins_pos_llh_longitude_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_pos_llh_1_validity_ins_pos_llh_longitude_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_pos_llh_1_validity_ins_pos_llh_longitude_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_pos_llh_1_validity_ins_pos_llh_altitude_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_pos_llh_1_validity_ins_pos_llh_altitude_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_pos_llh_1_validity_ins_pos_llh_altitude_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_pos_llh_1_accuracy_ins_pos_llh_latitude_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_pos_llh_1_accuracy_ins_pos_llh_latitude_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_pos_llh_1_accuracy_ins_pos_llh_latitude_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_pos_llh_1_accuracy_ins_pos_llh_longitude_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_pos_llh_1_accuracy_ins_pos_llh_longitude_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_pos_llh_1_accuracy_ins_pos_llh_longitude_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_pos_llh_1_accuracy_ins_pos_llh_altitude_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_pos_llh_1_accuracy_ins_pos_llh_altitude_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_pos_llh_1_accuracy_ins_pos_llh_altitude_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_ins_pos_llh_1_ins_pos_llh_latitude_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_pos_llh_1_ins_pos_llh_latitude_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_pos_llh_1_ins_pos_llh_latitude_is_in_range(int32_t value);

/**
 * Pack message RT_SB_INS_Heading_Gradient_2.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_ins_heading_gradient_2_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_ins_heading_gradient_2_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_INS_Heading_Gradient_2.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_ins_heading_gradient_2_unpack(
    struct vehicle_rt_sb_ins_heading_gradient_2_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_INS_Heading_Gradient_2.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_ins_heading_gradient_2_init(struct vehicle_rt_sb_ins_heading_gradient_2_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_heading_gradient_2_validity_ins_heading_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_heading_gradient_2_validity_ins_heading_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_heading_gradient_2_validity_ins_heading_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_heading_gradient_2_validity_ins_gradient_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_heading_gradient_2_validity_ins_gradient_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_heading_gradient_2_validity_ins_gradient_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_heading_gradient_2_accuracy_ins_heading_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_heading_gradient_2_accuracy_ins_heading_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_heading_gradient_2_accuracy_ins_heading_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_sb_ins_heading_gradient_2_ins_heading_2_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_heading_gradient_2_ins_heading_2_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_heading_gradient_2_ins_heading_2_is_in_range(uint16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_heading_gradient_2_accuracy_ins_gradient_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_heading_gradient_2_accuracy_ins_gradient_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_heading_gradient_2_accuracy_ins_gradient_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_ins_heading_gradient_2_ins_gradient_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_heading_gradient_2_ins_gradient_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_heading_gradient_2_ins_gradient_is_in_range(int16_t value);

/**
 * Pack message RT_SB_INS_Heading_Gradient.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_ins_heading_gradient_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_ins_heading_gradient_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_INS_Heading_Gradient.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_ins_heading_gradient_unpack(
    struct vehicle_rt_sb_ins_heading_gradient_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_INS_Heading_Gradient.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_ins_heading_gradient_init(struct vehicle_rt_sb_ins_heading_gradient_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_heading_gradient_validity_ins_heading_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_heading_gradient_validity_ins_heading_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_heading_gradient_validity_ins_heading_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_heading_gradient_validity_ins_gradient_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_heading_gradient_validity_ins_gradient_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_heading_gradient_validity_ins_gradient_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_heading_gradient_accuracy_ins_heading_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_heading_gradient_accuracy_ins_heading_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_heading_gradient_accuracy_ins_heading_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_ins_heading_gradient_ins_heading_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_heading_gradient_ins_heading_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_heading_gradient_ins_heading_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_heading_gradient_accuracy_ins_gradient_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_heading_gradient_accuracy_ins_gradient_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_heading_gradient_accuracy_ins_gradient_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_ins_heading_gradient_ins_gradient_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_heading_gradient_ins_gradient_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_heading_gradient_ins_gradient_is_in_range(int16_t value);

/**
 * Pack message RT_SB_INS_Status.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_ins_status_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_ins_status_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_INS_Status.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_ins_status_unpack(
    struct vehicle_rt_sb_ins_status_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_INS_Status.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_ins_status_init(struct vehicle_rt_sb_ins_status_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_status_ins_status_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_status_ins_status_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_status_ins_status_is_in_range(uint8_t value);

/**
 * Pack message RT_SB_INS_Attitude.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_ins_attitude_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_ins_attitude_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_INS_Attitude.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_ins_attitude_unpack(
    struct vehicle_rt_sb_ins_attitude_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_INS_Attitude.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_ins_attitude_init(struct vehicle_rt_sb_ins_attitude_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_attitude_validity_yaw_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_attitude_validity_yaw_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_attitude_validity_yaw_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_attitude_validity_pitch_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_attitude_validity_pitch_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_attitude_validity_pitch_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_attitude_validity_roll_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_attitude_validity_roll_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_attitude_validity_roll_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_ins_attitude_accuracy_attitude_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_attitude_accuracy_attitude_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_attitude_accuracy_attitude_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_ins_attitude_attitude_yaw_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_attitude_attitude_yaw_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_attitude_attitude_yaw_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_ins_attitude_attitude_pitch_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_attitude_attitude_pitch_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_attitude_attitude_pitch_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_ins_attitude_attitude_roll_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_ins_attitude_attitude_roll_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_ins_attitude_attitude_roll_is_in_range(int16_t value);

/**
 * Pack message RT_SB_Output_Status.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_output_status_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_output_status_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_Output_Status.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_output_status_unpack(
    struct vehicle_rt_sb_output_status_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_Output_Status.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_output_status_init(struct vehicle_rt_sb_output_status_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_output_status_validity_status_timestamp_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_output_status_validity_status_timestamp_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_output_status_validity_status_timestamp_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_output_status_status_analogue_1_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_output_status_status_analogue_1_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_output_status_status_analogue_1_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_output_status_status_analogue_2_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_output_status_status_analogue_2_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_output_status_status_analogue_2_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_output_status_status_analogue_3_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_output_status_status_analogue_3_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_output_status_status_analogue_3_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_output_status_status_analogue_4_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_output_status_status_analogue_4_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_output_status_status_analogue_4_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_output_status_status_pulse_output_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_output_status_status_pulse_output_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_output_status_status_pulse_output_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_output_status_status_serial_output_1_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_output_status_status_serial_output_1_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_output_status_status_serial_output_1_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_output_status_status_serial_output_2_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_output_status_status_serial_output_2_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_output_status_status_serial_output_2_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_output_status_status_trigger_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_output_status_status_trigger_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_output_status_status_trigger_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint32_t vehicle_rt_sb_output_status_gps_time_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_output_status_gps_time_decode(uint32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_output_status_gps_time_is_in_range(uint32_t value);

/**
 * Pack message RT_SB_GPS_Heading_Gradient_2.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_gps_heading_gradient_2_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_gps_heading_gradient_2_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_GPS_Heading_Gradient_2.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_gps_heading_gradient_2_unpack(
    struct vehicle_rt_sb_gps_heading_gradient_2_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_GPS_Heading_Gradient_2.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_gps_heading_gradient_2_init(struct vehicle_rt_sb_gps_heading_gradient_2_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_heading_gradient_2_validity_gps_heading_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_heading_gradient_2_validity_gps_heading_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_heading_gradient_2_validity_gps_heading_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_heading_gradient_2_validity_gps_gradient_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_heading_gradient_2_validity_gps_gradient_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_heading_gradient_2_validity_gps_gradient_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_heading_gradient_2_accuracy_gps_heading_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_heading_gradient_2_accuracy_gps_heading_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_heading_gradient_2_accuracy_gps_heading_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_sb_gps_heading_gradient_2_gps_heading_2_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_heading_gradient_2_gps_heading_2_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_heading_gradient_2_gps_heading_2_is_in_range(uint16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_heading_gradient_2_accuracy_gps_gradient_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_heading_gradient_2_accuracy_gps_gradient_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_heading_gradient_2_accuracy_gps_gradient_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_gps_heading_gradient_2_gps_gradient_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_heading_gradient_2_gps_gradient_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_heading_gradient_2_gps_gradient_is_in_range(int16_t value);

/**
 * Pack message RT_SB_Cumulative_Distance_2.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_cumulative_distance_2_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_cumulative_distance_2_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_Cumulative_Distance_2.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_cumulative_distance_2_unpack(
    struct vehicle_rt_sb_cumulative_distance_2_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_Cumulative_Distance_2.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_cumulative_distance_2_init(struct vehicle_rt_sb_cumulative_distance_2_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_cumulative_distance_2_validity_cumulative_time_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_cumulative_distance_2_validity_cumulative_time_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_cumulative_distance_2_validity_cumulative_time_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_cumulative_distance_2_validity_cumulative_distance_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_cumulative_distance_2_validity_cumulative_distance_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_cumulative_distance_2_validity_cumulative_distance_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint32_t vehicle_rt_sb_cumulative_distance_2_cumulative_time_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_cumulative_distance_2_cumulative_time_decode(uint32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_cumulative_distance_2_cumulative_time_is_in_range(uint32_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint32_t vehicle_rt_sb_cumulative_distance_2_cumulative_distance_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_cumulative_distance_2_cumulative_distance_decode(uint32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_cumulative_distance_2_cumulative_distance_is_in_range(uint32_t value);

/**
 * Pack message RT_SB_Cumulative_Distance_1.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_cumulative_distance_1_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_cumulative_distance_1_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_Cumulative_Distance_1.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_cumulative_distance_1_unpack(
    struct vehicle_rt_sb_cumulative_distance_1_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_Cumulative_Distance_1.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_cumulative_distance_1_init(struct vehicle_rt_sb_cumulative_distance_1_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_cumulative_distance_1_validity_cumulative_time_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_cumulative_distance_1_validity_cumulative_time_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_cumulative_distance_1_validity_cumulative_time_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_cumulative_distance_1_validity_cumulative_distance_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_cumulative_distance_1_validity_cumulative_distance_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_cumulative_distance_1_validity_cumulative_distance_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint32_t vehicle_rt_sb_cumulative_distance_1_cumulative_time_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_cumulative_distance_1_cumulative_time_decode(uint32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_cumulative_distance_1_cumulative_time_is_in_range(uint32_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint32_t vehicle_rt_sb_cumulative_distance_1_cumulative_distance_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_cumulative_distance_1_cumulative_distance_decode(uint32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_cumulative_distance_1_cumulative_distance_is_in_range(uint32_t value);

/**
 * Pack message RT_SB_Trigger_Timestamp.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_trigger_timestamp_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_trigger_timestamp_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_Trigger_Timestamp.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_trigger_timestamp_unpack(
    struct vehicle_rt_sb_trigger_timestamp_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_Trigger_Timestamp.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_trigger_timestamp_init(struct vehicle_rt_sb_trigger_timestamp_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_trigger_timestamp_validity_trigger_timestamp_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_trigger_timestamp_validity_trigger_timestamp_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_trigger_timestamp_validity_trigger_timestamp_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_trigger_timestamp_accuracy_trigger_timestamp_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_trigger_timestamp_accuracy_trigger_timestamp_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_trigger_timestamp_accuracy_trigger_timestamp_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_trigger_timestamp_trigger_number_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_trigger_timestamp_trigger_number_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_trigger_timestamp_trigger_number_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_trigger_timestamp_trigger_timestamp_type_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_trigger_timestamp_trigger_timestamp_type_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_trigger_timestamp_trigger_timestamp_type_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint64_t vehicle_rt_sb_trigger_timestamp_gps_high_resolution_time_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_trigger_timestamp_gps_high_resolution_time_decode(uint64_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_trigger_timestamp_gps_high_resolution_time_is_in_range(uint64_t value);

/**
 * Pack message RT_IMU06_Gyro_Rates.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_imu06_gyro_rates_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_imu06_gyro_rates_t *src_p,
    size_t size);

/**
 * Unpack message RT_IMU06_Gyro_Rates.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_imu06_gyro_rates_unpack(
    struct vehicle_rt_imu06_gyro_rates_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IMU06_Gyro_Rates.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_imu06_gyro_rates_init(struct vehicle_rt_imu06_gyro_rates_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_imu06_gyro_rates_validity_gyro_rate_yaw_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_imu06_gyro_rates_validity_gyro_rate_yaw_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_imu06_gyro_rates_validity_gyro_rate_yaw_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_imu06_gyro_rates_validity_gyro_rate_pitch_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_imu06_gyro_rates_validity_gyro_rate_pitch_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_imu06_gyro_rates_validity_gyro_rate_pitch_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_imu06_gyro_rates_validity_gyro_rate_roll_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_imu06_gyro_rates_validity_gyro_rate_roll_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_imu06_gyro_rates_validity_gyro_rate_roll_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_imu06_gyro_rates_accuracy_gyro_rates_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_imu06_gyro_rates_accuracy_gyro_rates_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_imu06_gyro_rates_accuracy_gyro_rates_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_imu06_gyro_rates_gyro_rate_yaw_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_imu06_gyro_rates_gyro_rate_yaw_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_imu06_gyro_rates_gyro_rate_yaw_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_imu06_gyro_rates_gyro_rate_pitch_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_imu06_gyro_rates_gyro_rate_pitch_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_imu06_gyro_rates_gyro_rate_pitch_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_imu06_gyro_rates_gyro_rate_roll_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_imu06_gyro_rates_gyro_rate_roll_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_imu06_gyro_rates_gyro_rate_roll_is_in_range(int16_t value);

/**
 * Pack message RT_IMU06_Accel.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_imu06_accel_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_imu06_accel_t *src_p,
    size_t size);

/**
 * Unpack message RT_IMU06_Accel.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_imu06_accel_unpack(
    struct vehicle_rt_imu06_accel_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_IMU06_Accel.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_imu06_accel_init(struct vehicle_rt_imu06_accel_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_imu06_accel_validity_accel_longitudinal_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_imu06_accel_validity_accel_longitudinal_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_imu06_accel_validity_accel_longitudinal_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_imu06_accel_validity_accel_lateral_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_imu06_accel_validity_accel_lateral_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_imu06_accel_validity_accel_lateral_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_imu06_accel_validity_accel_vertical_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_imu06_accel_validity_accel_vertical_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_imu06_accel_validity_accel_vertical_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_imu06_accel_accuracy_accel_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_imu06_accel_accuracy_accel_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_imu06_accel_accuracy_accel_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_imu06_accel_accel_longitudinal_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_imu06_accel_accel_longitudinal_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_imu06_accel_accel_longitudinal_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_imu06_accel_accel_lateral_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_imu06_accel_accel_lateral_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_imu06_accel_accel_lateral_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_imu06_accel_accel_vertical_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_imu06_accel_accel_vertical_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_imu06_accel_accel_vertical_is_in_range(int16_t value);

/**
 * Pack message RT_SB_Speed.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_speed_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_speed_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_Speed.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_speed_unpack(
    struct vehicle_rt_sb_speed_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_Speed.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_speed_init(struct vehicle_rt_sb_speed_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_speed_validity_speed_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_speed_validity_speed_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_speed_validity_speed_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_speed_accuracy_speed_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_speed_accuracy_speed_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_speed_accuracy_speed_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_speed_speed_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_speed_speed_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_speed_speed_is_in_range(int32_t value);

/**
 * Pack message RT_SB_RTK_Slip.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_rtk_slip_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_rtk_slip_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_RTK_Slip.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_rtk_slip_unpack(
    struct vehicle_rt_sb_rtk_slip_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_RTK_Slip.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_rtk_slip_init(struct vehicle_rt_sb_rtk_slip_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_rtk_slip_validity_rtk_slip_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_rtk_slip_validity_rtk_slip_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_rtk_slip_validity_rtk_slip_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_rtk_slip_validity_rtk_squat_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_rtk_slip_validity_rtk_squat_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_rtk_slip_validity_rtk_squat_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_rtk_slip_validity_rtk_baseline_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_rtk_slip_validity_rtk_baseline_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_rtk_slip_validity_rtk_baseline_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_rtk_slip_accuracy_rtk_baseline_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_rtk_slip_accuracy_rtk_baseline_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_rtk_slip_accuracy_rtk_baseline_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_rtk_slip_rtk_slip_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_rtk_slip_rtk_slip_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_rtk_slip_rtk_slip_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_rtk_slip_rtk_squat_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_rtk_slip_rtk_squat_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_rtk_slip_rtk_squat_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_sb_rtk_slip_rtk_baseline_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_rtk_slip_rtk_baseline_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_rtk_slip_rtk_baseline_is_in_range(uint16_t value);

/**
 * Pack message RT_SB_RTK_Attitude.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_rtk_attitude_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_rtk_attitude_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_RTK_Attitude.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_rtk_attitude_unpack(
    struct vehicle_rt_sb_rtk_attitude_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_RTK_Attitude.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_rtk_attitude_init(struct vehicle_rt_sb_rtk_attitude_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_rtk_attitude_validity_rtk_yaw_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_rtk_attitude_validity_rtk_yaw_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_rtk_attitude_validity_rtk_yaw_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_rtk_attitude_validity_rtk_pitch_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_rtk_attitude_validity_rtk_pitch_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_rtk_attitude_validity_rtk_pitch_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_rtk_attitude_validity_rtk_roll_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_rtk_attitude_validity_rtk_roll_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_rtk_attitude_validity_rtk_roll_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_rtk_attitude_accuracy_rtk_attitude_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_rtk_attitude_accuracy_rtk_attitude_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_rtk_attitude_accuracy_rtk_attitude_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_rtk_attitude_rtk_attitude_yaw_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_rtk_attitude_rtk_attitude_yaw_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_rtk_attitude_rtk_attitude_yaw_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_rtk_attitude_rtk_attitude_pitch_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_rtk_attitude_rtk_attitude_pitch_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_rtk_attitude_rtk_attitude_pitch_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_rtk_attitude_rtk_attitude_roll_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_rtk_attitude_rtk_attitude_roll_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_rtk_attitude_rtk_attitude_roll_is_in_range(int16_t value);

/**
 * Pack message RT_SB_GPS_Mcycle_Lean.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_gps_mcycle_lean_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_gps_mcycle_lean_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_GPS_Mcycle_Lean.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_gps_mcycle_lean_unpack(
    struct vehicle_rt_sb_gps_mcycle_lean_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_GPS_Mcycle_Lean.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_gps_mcycle_lean_init(struct vehicle_rt_sb_gps_mcycle_lean_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_mcycle_lean_validity_gps_lateral_accel_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_mcycle_lean_validity_gps_lateral_accel_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_mcycle_lean_validity_gps_lateral_accel_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_mcycle_lean_validity_gps_mcycle_lean_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_mcycle_lean_validity_gps_mcycle_lean_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_mcycle_lean_validity_gps_mcycle_lean_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_mcycle_lean_accuracy_gps_lateral_accel_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_mcycle_lean_accuracy_gps_lateral_accel_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_mcycle_lean_accuracy_gps_lateral_accel_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_gps_mcycle_lean_gps_lateral_accel_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_mcycle_lean_gps_lateral_accel_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_mcycle_lean_gps_lateral_accel_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_gps_mcycle_lean_gps_mcycle_lean_angle_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_mcycle_lean_gps_mcycle_lean_angle_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_mcycle_lean_gps_mcycle_lean_angle_is_in_range(int16_t value);

/**
 * Pack message RT_SB_GPS_Status.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_gps_status_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_gps_status_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_GPS_Status.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_gps_status_unpack(
    struct vehicle_rt_sb_gps_status_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_GPS_Status.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_gps_status_init(struct vehicle_rt_sb_gps_status_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_status_gps_status_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_status_gps_status_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_status_gps_status_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_status_firmware_version_major_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_status_firmware_version_major_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_status_firmware_version_major_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_status_firmware_version_intermediate_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_status_firmware_version_intermediate_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_status_firmware_version_intermediate_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_status_firmware_version_minor_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_status_firmware_version_minor_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_status_firmware_version_minor_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_status_gps_n_sv_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_status_gps_n_sv_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_status_gps_n_sv_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_status_gps_n_sv_2_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_status_gps_n_sv_2_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_status_gps_n_sv_2_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_status_gps_n_sv_rtk_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_status_gps_n_sv_rtk_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_status_gps_n_sv_rtk_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_status_rtk_status_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_status_rtk_status_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_status_rtk_status_is_in_range(uint8_t value);

/**
 * Pack message RT_SB_GPS_Pos_ECEF_2.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_gps_pos_ecef_2_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_gps_pos_ecef_2_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_GPS_Pos_ECEF_2.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_gps_pos_ecef_2_unpack(
    struct vehicle_rt_sb_gps_pos_ecef_2_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_GPS_Pos_ECEF_2.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_gps_pos_ecef_2_init(struct vehicle_rt_sb_gps_pos_ecef_2_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_gps_pos_ecef_2_gps_pos_ecef_y_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_pos_ecef_2_gps_pos_ecef_y_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_pos_ecef_2_gps_pos_ecef_y_is_in_range(int32_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_gps_pos_ecef_2_gps_pos_ecef_z_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_pos_ecef_2_gps_pos_ecef_z_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_pos_ecef_2_gps_pos_ecef_z_is_in_range(int32_t value);

/**
 * Pack message RT_SB_GPS_Pos_ECEF_1.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_gps_pos_ecef_1_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_gps_pos_ecef_1_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_GPS_Pos_ECEF_1.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_gps_pos_ecef_1_unpack(
    struct vehicle_rt_sb_gps_pos_ecef_1_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_GPS_Pos_ECEF_1.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_gps_pos_ecef_1_init(struct vehicle_rt_sb_gps_pos_ecef_1_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_pos_ecef_1_validity_gps_pos_ecef_x_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_pos_ecef_1_validity_gps_pos_ecef_x_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_pos_ecef_1_validity_gps_pos_ecef_x_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_pos_ecef_1_validity_gps_pos_ecef_y_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_pos_ecef_1_validity_gps_pos_ecef_y_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_pos_ecef_1_validity_gps_pos_ecef_y_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_pos_ecef_1_validity_gps_pos_ecef_z_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_pos_ecef_1_validity_gps_pos_ecef_z_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_pos_ecef_1_validity_gps_pos_ecef_z_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_pos_ecef_1_accuracy_gps_pos_ecef_x_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_pos_ecef_1_accuracy_gps_pos_ecef_x_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_pos_ecef_1_accuracy_gps_pos_ecef_x_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_pos_ecef_1_accuracy_gps_pos_ecef_y_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_pos_ecef_1_accuracy_gps_pos_ecef_y_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_pos_ecef_1_accuracy_gps_pos_ecef_y_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_pos_ecef_1_accuracy_gps_pos_ecef_z_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_pos_ecef_1_accuracy_gps_pos_ecef_z_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_pos_ecef_1_accuracy_gps_pos_ecef_z_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_gps_pos_ecef_1_gps_pos_ecef_x_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_pos_ecef_1_gps_pos_ecef_x_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_pos_ecef_1_gps_pos_ecef_x_is_in_range(int32_t value);

/**
 * Pack message RT_SB_GPS_Pos_LLH_2.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_gps_pos_llh_2_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_gps_pos_llh_2_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_GPS_Pos_LLH_2.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_gps_pos_llh_2_unpack(
    struct vehicle_rt_sb_gps_pos_llh_2_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_GPS_Pos_LLH_2.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_gps_pos_llh_2_init(struct vehicle_rt_sb_gps_pos_llh_2_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_gps_pos_llh_2_gps_pos_llh_longitude_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_pos_llh_2_gps_pos_llh_longitude_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_pos_llh_2_gps_pos_llh_longitude_is_in_range(int32_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_gps_pos_llh_2_gps_pos_llh_altitude_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_pos_llh_2_gps_pos_llh_altitude_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_pos_llh_2_gps_pos_llh_altitude_is_in_range(int32_t value);

/**
 * Pack message RT_SB_GPS_Pos_LLH_1.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_gps_pos_llh_1_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_gps_pos_llh_1_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_GPS_Pos_LLH_1.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_gps_pos_llh_1_unpack(
    struct vehicle_rt_sb_gps_pos_llh_1_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_GPS_Pos_LLH_1.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_gps_pos_llh_1_init(struct vehicle_rt_sb_gps_pos_llh_1_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_pos_llh_1_validity_gps_pos_llh_latitude_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_pos_llh_1_validity_gps_pos_llh_latitude_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_pos_llh_1_validity_gps_pos_llh_latitude_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_pos_llh_1_validity_gps_pos_llh_longitude_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_pos_llh_1_validity_gps_pos_llh_longitude_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_pos_llh_1_validity_gps_pos_llh_longitude_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_pos_llh_1_validity_gps_pos_llh_altitude_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_pos_llh_1_validity_gps_pos_llh_altitude_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_pos_llh_1_validity_gps_pos_llh_altitude_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_pos_llh_1_accuracy_gps_pos_llh_latitude_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_pos_llh_1_accuracy_gps_pos_llh_latitude_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_pos_llh_1_accuracy_gps_pos_llh_latitude_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_pos_llh_1_accuracy_gps_pos_llh_longitude_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_pos_llh_1_accuracy_gps_pos_llh_longitude_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_pos_llh_1_accuracy_gps_pos_llh_longitude_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_pos_llh_1_accuracy_gps_pos_llh_altitude_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_pos_llh_1_accuracy_gps_pos_llh_altitude_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_pos_llh_1_accuracy_gps_pos_llh_altitude_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_gps_pos_llh_1_gps_pos_llh_latitude_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_pos_llh_1_gps_pos_llh_latitude_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_pos_llh_1_gps_pos_llh_latitude_is_in_range(int32_t value);

/**
 * Pack message RT_SB_GPS_Heading_Gradient.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_gps_heading_gradient_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_gps_heading_gradient_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_GPS_Heading_Gradient.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_gps_heading_gradient_unpack(
    struct vehicle_rt_sb_gps_heading_gradient_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_GPS_Heading_Gradient.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_gps_heading_gradient_init(struct vehicle_rt_sb_gps_heading_gradient_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_heading_gradient_validity_gps_heading_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_heading_gradient_validity_gps_heading_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_heading_gradient_validity_gps_heading_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_heading_gradient_validity_gps_gradient_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_heading_gradient_validity_gps_gradient_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_heading_gradient_validity_gps_gradient_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_heading_gradient_accuracy_gps_heading_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_heading_gradient_accuracy_gps_heading_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_heading_gradient_accuracy_gps_heading_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_gps_heading_gradient_gps_heading_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_heading_gradient_gps_heading_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_heading_gradient_gps_heading_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_heading_gradient_accuracy_gps_gradient_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_heading_gradient_accuracy_gps_gradient_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_heading_gradient_accuracy_gps_gradient_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_gps_heading_gradient_gps_gradient_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_heading_gradient_gps_gradient_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_heading_gradient_gps_gradient_is_in_range(int16_t value);

/**
 * Pack message RT_SB_GPS_Vel_ECEF_2.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_gps_vel_ecef_2_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_gps_vel_ecef_2_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_GPS_Vel_ECEF_2.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_gps_vel_ecef_2_unpack(
    struct vehicle_rt_sb_gps_vel_ecef_2_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_GPS_Vel_ECEF_2.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_gps_vel_ecef_2_init(struct vehicle_rt_sb_gps_vel_ecef_2_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_vel_ecef_2_validity_gps_vel_ecef_y_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_vel_ecef_2_validity_gps_vel_ecef_y_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_vel_ecef_2_validity_gps_vel_ecef_y_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_vel_ecef_2_validity_gps_vel_ecef_z_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_vel_ecef_2_validity_gps_vel_ecef_z_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_vel_ecef_2_validity_gps_vel_ecef_z_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_gps_vel_ecef_2_gps_vel_ecef_y_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_vel_ecef_2_gps_vel_ecef_y_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_vel_ecef_2_gps_vel_ecef_y_is_in_range(int32_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_gps_vel_ecef_2_gps_vel_ecef_z_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_vel_ecef_2_gps_vel_ecef_z_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_vel_ecef_2_gps_vel_ecef_z_is_in_range(int32_t value);

/**
 * Pack message RT_SB_GPS_Vel_ECEF_1.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_gps_vel_ecef_1_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_gps_vel_ecef_1_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_GPS_Vel_ECEF_1.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_gps_vel_ecef_1_unpack(
    struct vehicle_rt_sb_gps_vel_ecef_1_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_GPS_Vel_ECEF_1.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_gps_vel_ecef_1_init(struct vehicle_rt_sb_gps_vel_ecef_1_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_vel_ecef_1_validity_gps_vel_ecef_x_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_vel_ecef_1_validity_gps_vel_ecef_x_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_vel_ecef_1_validity_gps_vel_ecef_x_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_vel_ecef_1_accuracy_gps_vel_ecef_x_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_vel_ecef_1_accuracy_gps_vel_ecef_x_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_vel_ecef_1_accuracy_gps_vel_ecef_x_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_vel_ecef_1_accuracy_gps_vel_ecef_y_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_vel_ecef_1_accuracy_gps_vel_ecef_y_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_vel_ecef_1_accuracy_gps_vel_ecef_y_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_vel_ecef_1_accuracy_gps_vel_ecef_z_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_vel_ecef_1_accuracy_gps_vel_ecef_z_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_vel_ecef_1_accuracy_gps_vel_ecef_z_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_gps_vel_ecef_1_gps_vel_ecef_x_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_vel_ecef_1_gps_vel_ecef_x_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_vel_ecef_1_gps_vel_ecef_x_is_in_range(int32_t value);

/**
 * Pack message RT_SB_GPS_Vel_NED_2.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_gps_vel_ned_2_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_gps_vel_ned_2_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_GPS_Vel_NED_2.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_gps_vel_ned_2_unpack(
    struct vehicle_rt_sb_gps_vel_ned_2_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_GPS_Vel_NED_2.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_gps_vel_ned_2_init(struct vehicle_rt_sb_gps_vel_ned_2_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_vel_ned_2_validity_gps_vel_ned_d_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_vel_ned_2_validity_gps_vel_ned_d_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_vel_ned_2_validity_gps_vel_ned_d_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_vel_ned_2_accuracy_gps_vel_d_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_vel_ned_2_accuracy_gps_vel_d_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_vel_ned_2_accuracy_gps_vel_d_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_gps_vel_ned_2_gps_vel_ned_d_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_vel_ned_2_gps_vel_ned_d_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_vel_ned_2_gps_vel_ned_d_is_in_range(int32_t value);

/**
 * Pack message RT_SB_GPS_Vel_NED_1.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_gps_vel_ned_1_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_gps_vel_ned_1_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_GPS_Vel_NED_1.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_gps_vel_ned_1_unpack(
    struct vehicle_rt_sb_gps_vel_ned_1_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_GPS_Vel_NED_1.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_gps_vel_ned_1_init(struct vehicle_rt_sb_gps_vel_ned_1_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_vel_ned_1_validity_gps_vel_ned_n_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_vel_ned_1_validity_gps_vel_ned_n_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_vel_ned_1_validity_gps_vel_ned_n_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_vel_ned_1_validity_gps_vel_ned_e_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_vel_ned_1_validity_gps_vel_ned_e_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_vel_ned_1_validity_gps_vel_ned_e_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_vel_ned_1_accuracy_gps_vel_ne_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_vel_ned_1_accuracy_gps_vel_ne_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_vel_ned_1_accuracy_gps_vel_ne_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_gps_vel_ned_1_gps_vel_ned_n_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_vel_ned_1_gps_vel_ned_n_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_vel_ned_1_gps_vel_ned_n_is_in_range(int32_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int32_t vehicle_rt_sb_gps_vel_ned_1_gps_vel_ned_e_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_vel_ned_1_gps_vel_ned_e_decode(int32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_vel_ned_1_gps_vel_ned_e_is_in_range(int32_t value);

/**
 * Pack message RT_SB_GPS_Speed.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_gps_speed_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_gps_speed_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_GPS_Speed.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_gps_speed_unpack(
    struct vehicle_rt_sb_gps_speed_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_GPS_Speed.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_gps_speed_init(struct vehicle_rt_sb_gps_speed_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_speed_validity_gps_speed_2_d_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_speed_validity_gps_speed_2_d_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_speed_validity_gps_speed_2_d_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_speed_validity_gps_speed_3_d_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_speed_validity_gps_speed_3_d_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_speed_validity_gps_speed_3_d_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_speed_accuracy_gps_speed_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_speed_accuracy_gps_speed_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_speed_accuracy_gps_speed_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint32_t vehicle_rt_sb_gps_speed_gps_speed_2_d_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_speed_gps_speed_2_d_decode(uint32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_speed_gps_speed_2_d_is_in_range(uint32_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint32_t vehicle_rt_sb_gps_speed_gps_speed_3_d_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_speed_gps_speed_3_d_decode(uint32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_speed_gps_speed_3_d_is_in_range(uint32_t value);

/**
 * Pack message RT_SB_GPS_Time.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_gps_time_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_gps_time_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_GPS_Time.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_gps_time_unpack(
    struct vehicle_rt_sb_gps_time_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_GPS_Time.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_gps_time_init(struct vehicle_rt_sb_gps_time_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_time_validity_gps_time_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_time_validity_gps_time_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_time_validity_gps_time_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_time_validity_gps_week_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_time_validity_gps_week_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_time_validity_gps_week_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gps_time_accuracy_gps_time_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_time_accuracy_gps_time_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_time_accuracy_gps_time_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint32_t vehicle_rt_sb_gps_time_gps_time_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_time_gps_time_decode(uint32_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_time_gps_time_is_in_range(uint32_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint16_t vehicle_rt_sb_gps_time_gps_week_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gps_time_gps_week_decode(uint16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gps_time_gps_week_is_in_range(uint16_t value);

/**
 * Pack message RT_SB_Accel.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_accel_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_accel_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_Accel.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_accel_unpack(
    struct vehicle_rt_sb_accel_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_Accel.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_accel_init(struct vehicle_rt_sb_accel_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_accel_validity_accel_longitudinal_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_accel_validity_accel_longitudinal_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_accel_validity_accel_longitudinal_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_accel_validity_accel_lateral_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_accel_validity_accel_lateral_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_accel_validity_accel_lateral_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_accel_validity_accel_vertical_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_accel_validity_accel_vertical_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_accel_validity_accel_vertical_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_accel_accuracy_accel_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_accel_accuracy_accel_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_accel_accuracy_accel_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_accel_accel_longitudinal_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_accel_accel_longitudinal_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_accel_accel_longitudinal_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_accel_accel_lateral_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_accel_accel_lateral_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_accel_accel_lateral_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_accel_accel_vertical_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_accel_accel_vertical_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_accel_accel_vertical_is_in_range(int16_t value);

/**
 * Pack message RT_SB_Gyro_Rates.
 *
 * @param[out] dst_p Buffer to pack the message into.
 * @param[in] src_p Data to pack.
 * @param[in] size Size of dst_p.
 *
 * @return Size of packed data, or negative error code.
 */
int vehicle_rt_sb_gyro_rates_pack(
    uint8_t *dst_p,
    const struct vehicle_rt_sb_gyro_rates_t *src_p,
    size_t size);

/**
 * Unpack message RT_SB_Gyro_Rates.
 *
 * @param[out] dst_p Object to unpack the message into.
 * @param[in] src_p Message to unpack.
 * @param[in] size Size of src_p.
 *
 * @return zero(0) or negative error code.
 */
int vehicle_rt_sb_gyro_rates_unpack(
    struct vehicle_rt_sb_gyro_rates_t *dst_p,
    const uint8_t *src_p,
    size_t size);

/**
 * Init message fields to default values from RT_SB_Gyro_Rates.
 *
 * @param[in] msg_p Message to init.
 *
 * @return zero(0) on success or (-1) in case of nullptr argument.
 */
int vehicle_rt_sb_gyro_rates_init(struct vehicle_rt_sb_gyro_rates_t *msg_p);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gyro_rates_validity_gyro_rate_yaw_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gyro_rates_validity_gyro_rate_yaw_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gyro_rates_validity_gyro_rate_yaw_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gyro_rates_validity_gyro_rate_pitch_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gyro_rates_validity_gyro_rate_pitch_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gyro_rates_validity_gyro_rate_pitch_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gyro_rates_validity_gyro_rate_roll_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gyro_rates_validity_gyro_rate_roll_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gyro_rates_validity_gyro_rate_roll_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
uint8_t vehicle_rt_sb_gyro_rates_accuracy_gyro_rates_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gyro_rates_accuracy_gyro_rates_decode(uint8_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gyro_rates_accuracy_gyro_rates_is_in_range(uint8_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_gyro_rates_gyro_rate_yaw_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gyro_rates_gyro_rate_yaw_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gyro_rates_gyro_rate_yaw_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_gyro_rates_gyro_rate_pitch_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gyro_rates_gyro_rate_pitch_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gyro_rates_gyro_rate_pitch_is_in_range(int16_t value);

/**
 * Encode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to encode.
 *
 * @return Encoded signal.
 */
int16_t vehicle_rt_sb_gyro_rates_gyro_rate_roll_encode(double value);

/**
 * Decode given signal by applying scaling and offset.
 *
 * @param[in] value Signal to decode.
 *
 * @return Decoded signal.
 */
double vehicle_rt_sb_gyro_rates_gyro_rate_roll_decode(int16_t value);

/**
 * Check that given signal is in allowed range.
 *
 * @param[in] value Signal to check.
 *
 * @return true if in range, false otherwise.
 */
bool vehicle_rt_sb_gyro_rates_gyro_rate_roll_is_in_range(int16_t value);


#ifdef __cplusplus
}
#endif

#endif
