/* This file is generated by venus-protocol.  See vn_protocol_renderer.h. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_RENDERER_FRAMEBUFFER_H
#define VN_PROTOCOL_RENDERER_FRAMEBUFFER_H

#include "vn_protocol_renderer_structs.h"

#pragma GCC diagnostic push
#if !defined(__clang__) && defined(__GNUC__) && __GNUC__ >= 12
#pragma GCC diagnostic ignored "-Wdangling-pointer"
#endif
#pragma GCC diagnostic ignored "-Wpointer-arith"
#pragma GCC diagnostic ignored "-Wunused-parameter"

/* struct VkFramebufferAttachmentImageInfo chain */

static inline void *
vn_decode_VkFramebufferAttachmentImageInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkFramebufferAttachmentImageInfo_self_temp(struct vn_cs_decoder *dec, VkFramebufferAttachmentImageInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_VkFlags(dec, &val->usage);
    vn_decode_uint32_t(dec, &val->width);
    vn_decode_uint32_t(dec, &val->height);
    vn_decode_uint32_t(dec, &val->layerCount);
    vn_decode_uint32_t(dec, &val->viewFormatCount);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->viewFormatCount);
        val->pViewFormats = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pViewFormats), array_size);
        if (!val->pViewFormats) return;
        vn_decode_VkFormat_array(dec, (VkFormat *)val->pViewFormats, array_size);
    } else {
        vn_decode_array_size(dec, val->viewFormatCount);
        val->pViewFormats = NULL;
    }
}

static inline void
vn_decode_VkFramebufferAttachmentImageInfo_temp(struct vn_cs_decoder *dec, VkFramebufferAttachmentImageInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkFramebufferAttachmentImageInfo_pnext_temp(dec);
    vn_decode_VkFramebufferAttachmentImageInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkFramebufferAttachmentImageInfo_handle_self(VkFramebufferAttachmentImageInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->usage */
    /* skip val->width */
    /* skip val->height */
    /* skip val->layerCount */
    /* skip val->viewFormatCount */
    /* skip val->pViewFormats */
}

static inline void
vn_replace_VkFramebufferAttachmentImageInfo_handle(VkFramebufferAttachmentImageInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO:
            vn_replace_VkFramebufferAttachmentImageInfo_handle_self((VkFramebufferAttachmentImageInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkFramebufferAttachmentsCreateInfo chain */

static inline void *
vn_decode_VkFramebufferAttachmentsCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkFramebufferAttachmentsCreateInfo_self_temp(struct vn_cs_decoder *dec, VkFramebufferAttachmentsCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->attachmentImageInfoCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->attachmentImageInfoCount);
        val->pAttachmentImageInfos = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pAttachmentImageInfos), iter_count);
        if (!val->pAttachmentImageInfos) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkFramebufferAttachmentImageInfo_temp(dec, &((VkFramebufferAttachmentImageInfo *)val->pAttachmentImageInfos)[i]);
    } else {
        vn_decode_array_size(dec, val->attachmentImageInfoCount);
        val->pAttachmentImageInfos = NULL;
    }
}

static inline void
vn_decode_VkFramebufferAttachmentsCreateInfo_temp(struct vn_cs_decoder *dec, VkFramebufferAttachmentsCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkFramebufferAttachmentsCreateInfo_pnext_temp(dec);
    vn_decode_VkFramebufferAttachmentsCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkFramebufferAttachmentsCreateInfo_handle_self(VkFramebufferAttachmentsCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->attachmentImageInfoCount */
    if (val->pAttachmentImageInfos) {
       for (uint32_t i = 0; i < val->attachmentImageInfoCount; i++)
            vn_replace_VkFramebufferAttachmentImageInfo_handle(&((VkFramebufferAttachmentImageInfo *)val->pAttachmentImageInfos)[i]);
    }
}

static inline void
vn_replace_VkFramebufferAttachmentsCreateInfo_handle(VkFramebufferAttachmentsCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO:
            vn_replace_VkFramebufferAttachmentsCreateInfo_handle_self((VkFramebufferAttachmentsCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkFramebufferCreateInfo chain */

static inline void *
vn_decode_VkFramebufferCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkFramebufferAttachmentsCreateInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkFramebufferCreateInfo_pnext_temp(dec);
            vn_decode_VkFramebufferAttachmentsCreateInfo_self_temp(dec, (VkFramebufferAttachmentsCreateInfo *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkFramebufferCreateInfo_self_temp(struct vn_cs_decoder *dec, VkFramebufferCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_VkRenderPass_lookup(dec, &val->renderPass);
    vn_decode_uint32_t(dec, &val->attachmentCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->attachmentCount);
        val->pAttachments = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pAttachments), iter_count);
        if (!val->pAttachments) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkImageView_lookup(dec, &((VkImageView *)val->pAttachments)[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        val->pAttachments = NULL;
    }
    vn_decode_uint32_t(dec, &val->width);
    vn_decode_uint32_t(dec, &val->height);
    vn_decode_uint32_t(dec, &val->layers);
}

static inline void
vn_decode_VkFramebufferCreateInfo_temp(struct vn_cs_decoder *dec, VkFramebufferCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkFramebufferCreateInfo_pnext_temp(dec);
    vn_decode_VkFramebufferCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkFramebufferCreateInfo_handle_self(VkFramebufferCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    vn_replace_VkRenderPass_handle(&val->renderPass);
    /* skip val->attachmentCount */
    if (val->pAttachments) {
       for (uint32_t i = 0; i < val->attachmentCount; i++)
            vn_replace_VkImageView_handle(&((VkImageView *)val->pAttachments)[i]);
    }
    /* skip val->width */
    /* skip val->height */
    /* skip val->layers */
}

static inline void
vn_replace_VkFramebufferCreateInfo_handle(VkFramebufferCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO:
            vn_replace_VkFramebufferCreateInfo_handle_self((VkFramebufferCreateInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO:
            vn_replace_VkFramebufferAttachmentsCreateInfo_handle_self((VkFramebufferAttachmentsCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

static inline void vn_decode_vkCreateFramebuffer_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCreateFramebuffer *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    if (vn_decode_simple_pointer(dec)) {
        args->pCreateInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pCreateInfo));
        if (!args->pCreateInfo) return;
        vn_decode_VkFramebufferCreateInfo_temp(dec, (VkFramebufferCreateInfo *)args->pCreateInfo);
    } else {
        args->pCreateInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_decode_simple_pointer(dec)) {
        vn_cs_decoder_set_fatal(dec);
    } else {
        args->pAllocator = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pFramebuffer = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pFramebuffer));
        if (!args->pFramebuffer) return;
        vn_decode_VkFramebuffer(dec, args->pFramebuffer);
    } else {
        args->pFramebuffer = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkCreateFramebuffer_args_handle(struct vn_command_vkCreateFramebuffer *args)
{
    vn_replace_VkDevice_handle(&args->device);
    if (args->pCreateInfo)
        vn_replace_VkFramebufferCreateInfo_handle((VkFramebufferCreateInfo *)args->pCreateInfo);
    /* skip args->pAllocator */
    /* skip args->pFramebuffer */
}

static inline void vn_encode_vkCreateFramebuffer_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCreateFramebuffer *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCreateFramebuffer_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->device */
    /* skip args->pCreateInfo */
    /* skip args->pAllocator */
    if (vn_encode_simple_pointer(enc, args->pFramebuffer))
        vn_encode_VkFramebuffer(enc, args->pFramebuffer);
}

static inline void vn_decode_vkDestroyFramebuffer_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkDestroyFramebuffer *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_VkFramebuffer_lookup(dec, &args->framebuffer);
    if (vn_decode_simple_pointer(dec)) {
        vn_cs_decoder_set_fatal(dec);
    } else {
        args->pAllocator = NULL;
    }
}

static inline void vn_replace_vkDestroyFramebuffer_args_handle(struct vn_command_vkDestroyFramebuffer *args)
{
    vn_replace_VkDevice_handle(&args->device);
    vn_replace_VkFramebuffer_handle(&args->framebuffer);
    /* skip args->pAllocator */
}

static inline void vn_encode_vkDestroyFramebuffer_reply(struct vn_cs_encoder *enc, const struct vn_command_vkDestroyFramebuffer *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkDestroyFramebuffer_EXT});

    /* skip args->device */
    /* skip args->framebuffer */
    /* skip args->pAllocator */
}

static inline void vn_dispatch_vkCreateFramebuffer(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCreateFramebuffer args;

    if (!ctx->dispatch_vkCreateFramebuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCreateFramebuffer_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCreateFramebuffer(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkCreateFramebuffer returned %d", args.ret);
#endif

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder))
        vn_encode_vkCreateFramebuffer_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkDestroyFramebuffer(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkDestroyFramebuffer args;

    if (!ctx->dispatch_vkDestroyFramebuffer) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkDestroyFramebuffer_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkDestroyFramebuffer(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder))
        vn_encode_vkDestroyFramebuffer_reply(ctx->encoder, &args);

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

#pragma GCC diagnostic pop

#endif /* VN_PROTOCOL_RENDERER_FRAMEBUFFER_H */
