/*
 * Copyright (C) 2016 The Qt Company Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import QtQuick 2.6
import QtQuick.Layouts 1.1
import QtQuick.Controls 2.0
import QtQuick.Window 2.13

import 'datetime'
import 'bluetooth'
import 'wifi'
import 'wired'
import 'version'

ApplicationWindow {
    id: root
    width: container.width * container.scale
    height: container.height * container.scale

    onVisibleChanged: {
        if (!visible)
            stack.pop(settings)
    }

    Item {
        id: container
        anchors.centerIn: parent
        width: Window.width
        height: Window.height
        scale: 1

    StackView {
        id: stack
        anchors.fill: parent
        initialItem: settings

        SettingsLauncher {
            id: settings
            onLaunch: {
                stack.push(app)
            }

            Component.onCompleted: {
                for (var a in stack.children) {
                    var app = stack.children[a]
                    if (!app.isSetting) continue
                    settingsModel.append({'icon': app.icon, 'title': app.title, 'checkable': app.checkable, 'app': app})
                    app.visible = false
                }
            }

            model: ListModel { id: settingsModel }
        }

        DateTime {}

        Bluetooth {}

        Wifi {}

        Wired {}

        Version {}
    }
}
}
