/****************************************************************************
**
** Copyright (C) 2015 The Qt Company Ltd and/or its subsidiary(-ies).
** Contact: http://www.qt-project.org/legal
**
** This file is part of the QtSystems module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL21$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see http://www.qt.io/terms-conditions. For further
** information use the contact form at http://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 or version 3 as published by the Free
** Software Foundation and appearing in the file LICENSE.LGPLv21 and
** LICENSE.LGPLv3 included in the packaging of this file. Please review the
** following information to ensure the GNU Lesser General Public License
** requirements will be met: https://www.gnu.org/licenses/lgpl.html and
** http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** As a special exception, The Qt Company gives you certain additional
** rights. These rights are described in The Qt Company LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SAMPLESERVICEPLUGIN_H
#define SAMPLESERVICEPLUGIN_H

#include <QObject>
#include <qserviceplugininterface.h>
#include <qserviceinterfacedescriptor.h>

QT_USE_NAMESPACE

class SampleServicePlugin : public QObject, public QServicePluginInterface
{
    Q_OBJECT
    Q_INTERFACES(QServicePluginInterface)
    Q_PLUGIN_METADATA(IID "com.nokia.qt.QServicePluginInterface/1.0")

public:
    ~SampleServicePlugin();
    QObject* createInstance(const QServiceInterfaceDescriptor& descriptor);

    virtual void installService();
    virtual void uninstallService();
};


class SampleServicePluginClass : public QObject
{
    Q_OBJECT
public:
    SampleServicePluginClass(const QServiceInterfaceDescriptor& descriptor);
    virtual ~SampleServicePluginClass() {}

    QServiceInterfaceDescriptor descriptor() const;

public slots:
    void testSlotOne();
    void testSlotTwo() {}

protected:
    QServiceInterfaceDescriptor m_descriptor;
};

class DerivedSampleServicePluginClass : public SampleServicePluginClass
{
    Q_OBJECT
public:
    DerivedSampleServicePluginClass(const QServiceInterfaceDescriptor& descriptor);
    virtual ~DerivedSampleServicePluginClass() {}
public slots:
    void testSlotOne();
};

#endif
