/*
 * GPS Navigation ---An open source GPS navigation core software
 *
 *
 * Copyright (c) 2016  Aisin AW, Ltd
 *
 * This program is dual licensed under GPL version 2 or a commercial license.
 * See the LICENSE file distributed with this source file.
 */
/*
 *	This file was first automatically generated by dbusxx-xml2cpp;
 *  Then, some conflicting names had to be manually modified
 *  Example: all the GetVersion() methods
 */

#ifndef __dbusxx__genivi_mapviewer_adaptor_h__ADAPTOR_MARSHAL_H
#define __dbusxx__genivi_mapviewer_adaptor_h__ADAPTOR_MARSHAL_H

#include <dbus-c++/dbus.h>
#include <cassert>

namespace org {
namespace genivi {
namespace mapviewer {

class Session_adaptor
: public ::DBus::InterfaceAdaptor
{
public:

    Session_adaptor()
    : ::DBus::InterfaceAdaptor("org.genivi.mapviewer.Session")
    {
        register_method(Session_adaptor, GetVersion, _GetVersion_stub);
        register_method(Session_adaptor, CreateSession, _CreateSession_stub);
        register_method(Session_adaptor, DeleteSession, _DeleteSession_stub);
        register_method(Session_adaptor, GetSessionStatus, _GetSessionStatus_stub);
        register_method(Session_adaptor, GetAllSessions, _GetAllSessions_stub);
    }

    ::DBus::IntrospectedInterface *introspect() const
    {
        static ::DBus::IntrospectedArgument GetVersion_args[] =
        {
            { "version", "(qqqs)", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument CreateSession_args[] =
        {
            { "client", "s", true },
            { "sessionHandle", "u", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument DeleteSession_args[] =
        {
            { "sessionHandle", "u", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetSessionStatus_args[] =
        {
            { "sessionHandle", "u", true },
            { "sessionStatus", "i", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetAllSessions_args[] =
        {
            { "sessionsList", "a(us)", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SessionDeleted_args[] =
        {
            { "sessionHandle", "u", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedMethod Session_adaptor_methods[] =
        {
            { "GetVersion", GetVersion_args },
            { "CreateSession", CreateSession_args },
            { "DeleteSession", DeleteSession_args },
            { "GetSessionStatus", GetSessionStatus_args },
            { "GetAllSessions", GetAllSessions_args },
            { 0, 0 }
        };
        static ::DBus::IntrospectedMethod Session_adaptor_signals[] =
        {
            { "SessionDeleted", SessionDeleted_args },
            { 0, 0 }
        };
        static ::DBus::IntrospectedProperty Session_adaptor_properties[] =
        {
            { 0, 0, 0, 0 }
        };
        static ::DBus::IntrospectedInterface Session_adaptor_interface =
        {
            "org.genivi.mapviewer.Session",
            Session_adaptor_methods,
            Session_adaptor_signals,
            Session_adaptor_properties
        };
        return &Session_adaptor_interface;
    }

public:

    /* properties exposed by this interface, use
     * property() and property(value) to get and set a particular property
     */

public:

    /* methods exported by this interface,
     * you will have to implement them in your ObjectAdaptor
     */
    virtual ::DBus::Struct< uint16_t, uint16_t, uint16_t, std::string > SessionGetVersion() = 0;
    virtual uint32_t CreateSession(const std::string& client) = 0;
    virtual void DeleteSession(const uint32_t& sessionHandle) = 0;
    virtual int32_t GetSessionStatus(const uint32_t& sessionHandle) = 0;
    virtual std::vector< ::DBus::Struct< uint32_t, std::string > > GetAllSessions() = 0;

public:

    /* signal emitters for this interface
     */
    void SessionDeleted(const uint32_t& arg1)
    {
        ::DBus::SignalMessage sig("SessionDeleted");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        emit_signal(sig);
    }

private:

    /* unmarshalers (to unpack the DBus message before calling the actual interface method)
     */
    ::DBus::Message _GetVersion_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        ::DBus::Struct< uint16_t, uint16_t, uint16_t, std::string > argout1 = SessionGetVersion();
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _CreateSession_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        std::string argin1; ri >> argin1;
        uint32_t argout1 = CreateSession(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _DeleteSession_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        DeleteSession(argin1);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetSessionStatus_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        int32_t argout1 = GetSessionStatus(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _GetAllSessions_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        std::vector< ::DBus::Struct< uint32_t, std::string > > argout1 = GetAllSessions();
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
};

} } }
namespace org {
namespace genivi {
namespace mapviewer {

class Configuration_adaptor
: public ::DBus::InterfaceAdaptor
{
public:

    Configuration_adaptor()
    : ::DBus::InterfaceAdaptor("org.genivi.mapviewer.Configuration")
    {
        register_method(Configuration_adaptor, GetVersion, _GetVersion_stub);
        register_method(Configuration_adaptor, SetUnitsOfMeasurement, _SetUnitsOfMeasurement_stub);
        register_method(Configuration_adaptor, GetUnitsOfMeasurement, _GetUnitsOfMeasurement_stub);
        register_method(Configuration_adaptor, GetSupportedUnitsOfMeasurement, _GetSupportedUnitsOfMeasurement_stub);
        register_method(Configuration_adaptor, SetTimeFormat, _SetTimeFormat_stub);
        register_method(Configuration_adaptor, GetTimeFormat, _GetTimeFormat_stub);
        register_method(Configuration_adaptor, GetSupportedTimeFormats, _GetSupportedTimeFormats_stub);
        register_method(Configuration_adaptor, SetCoordinatesFormat, _SetCoordinatesFormat_stub);
        register_method(Configuration_adaptor, GetCoordinatesFormat, _GetCoordinatesFormat_stub);
        register_method(Configuration_adaptor, GetSupportedCoordinatesFormats, _GetSupportedCoordinatesFormats_stub);
        register_method(Configuration_adaptor, SetLocale, _SetLocale_stub);
        register_method(Configuration_adaptor, GetLocale, _GetLocale_stub);
        register_method(Configuration_adaptor, GetSupportedLocales, _GetSupportedLocales_stub);
    }

    ::DBus::IntrospectedInterface *introspect() const
    {
        static ::DBus::IntrospectedArgument GetVersion_args[] =
        {
            { "version", "(qqqs)", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetUnitsOfMeasurement_args[] =
        {
            { "unitsOfMeasurementList", "a{ii}", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetUnitsOfMeasurement_args[] =
        {
            { "unitsOfMeasurementList", "a{ii}", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetSupportedUnitsOfMeasurement_args[] =
        {
            { "unitsOfMeasurementList", "a{iai}", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetTimeFormat_args[] =
        {
            { "timeFormat", "i", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetTimeFormat_args[] =
        {
            { "timeFormat", "i", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetSupportedTimeFormats_args[] =
        {
            { "timeFormatList", "ai", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetCoordinatesFormat_args[] =
        {
            { "coordinatesFormat", "i", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetCoordinatesFormat_args[] =
        {
            { "coordinatesFormat", "i", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetSupportedCoordinatesFormats_args[] =
        {
            { "coordinatesFormatList", "ai", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetLocale_args[] =
        {
            { "languageCode", "s", true },
            { "countryCode", "s", true },
            { "scriptCode", "s", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetLocale_args[] =
        {
            { "languageCode", "s", false },
            { "countryCode", "s", false },
            { "scriptCode", "s", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetSupportedLocales_args[] =
        {
            { "localeList", "a(sss)", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument ConfigurationChanged_args[] =
        {
            { "changedSettings", "ai", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedMethod Configuration_adaptor_methods[] =
        {
            { "GetVersion", GetVersion_args },
            { "SetUnitsOfMeasurement", SetUnitsOfMeasurement_args },
            { "GetUnitsOfMeasurement", GetUnitsOfMeasurement_args },
            { "GetSupportedUnitsOfMeasurement", GetSupportedUnitsOfMeasurement_args },
            { "SetTimeFormat", SetTimeFormat_args },
            { "GetTimeFormat", GetTimeFormat_args },
            { "GetSupportedTimeFormats", GetSupportedTimeFormats_args },
            { "SetCoordinatesFormat", SetCoordinatesFormat_args },
            { "GetCoordinatesFormat", GetCoordinatesFormat_args },
            { "GetSupportedCoordinatesFormats", GetSupportedCoordinatesFormats_args },
            { "SetLocale", SetLocale_args },
            { "GetLocale", GetLocale_args },
            { "GetSupportedLocales", GetSupportedLocales_args },
            { 0, 0 }
        };
        static ::DBus::IntrospectedMethod Configuration_adaptor_signals[] =
        {
            { "ConfigurationChanged", ConfigurationChanged_args },
            { 0, 0 }
        };
        static ::DBus::IntrospectedProperty Configuration_adaptor_properties[] =
        {
            { 0, 0, 0, 0 }
        };
        static ::DBus::IntrospectedInterface Configuration_adaptor_interface =
        {
            "org.genivi.mapviewer.Configuration",
            Configuration_adaptor_methods,
            Configuration_adaptor_signals,
            Configuration_adaptor_properties
        };
        return &Configuration_adaptor_interface;
    }

public:

    /* properties exposed by this interface, use
     * property() and property(value) to get and set a particular property
     */

public:

    /* methods exported by this interface,
     * you will have to implement them in your ObjectAdaptor
     */
    virtual ::DBus::Struct< uint16_t, uint16_t, uint16_t, std::string > ConfigurationGetVersion() = 0;
    virtual void SetUnitsOfMeasurement(const std::map< int32_t, int32_t >& unitsOfMeasurementList) = 0;
    virtual std::map< int32_t, int32_t > GetUnitsOfMeasurement() = 0;
    virtual std::map< int32_t, std::vector< int32_t > > GetSupportedUnitsOfMeasurement() = 0;
    virtual void SetTimeFormat(const int32_t& timeFormat) = 0;
    virtual int32_t GetTimeFormat() = 0;
    virtual std::vector< int32_t > GetSupportedTimeFormats() = 0;
    virtual void SetCoordinatesFormat(const int32_t& coordinatesFormat) = 0;
    virtual int32_t GetCoordinatesFormat() = 0;
    virtual std::vector< int32_t > GetSupportedCoordinatesFormats() = 0;
    virtual void SetLocale(const std::string& languageCode, const std::string& countryCode, const std::string& scriptCode) = 0;
    virtual void GetLocale(std::string& languageCode, std::string& countryCode, std::string& scriptCode) = 0;
    virtual std::vector< ::DBus::Struct< std::string, std::string, std::string > > GetSupportedLocales() = 0;

public:

    /* signal emitters for this interface
     */
    void ConfigurationChanged(const std::vector< int32_t >& arg1)
    {
        ::DBus::SignalMessage sig("ConfigurationChanged");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        emit_signal(sig);
    }

private:

    /* unmarshalers (to unpack the DBus message before calling the actual interface method)
     */
    ::DBus::Message _GetVersion_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        ::DBus::Struct< uint16_t, uint16_t, uint16_t, std::string > argout1 = ConfigurationGetVersion();
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _SetUnitsOfMeasurement_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        std::map< int32_t, int32_t > argin1; ri >> argin1;
        SetUnitsOfMeasurement(argin1);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetUnitsOfMeasurement_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        std::map< int32_t, int32_t > argout1 = GetUnitsOfMeasurement();
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _GetSupportedUnitsOfMeasurement_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        std::map< int32_t, std::vector< int32_t > > argout1 = GetSupportedUnitsOfMeasurement();
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _SetTimeFormat_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        int32_t argin1; ri >> argin1;
        SetTimeFormat(argin1);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetTimeFormat_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        int32_t argout1 = GetTimeFormat();
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _GetSupportedTimeFormats_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        std::vector< int32_t > argout1 = GetSupportedTimeFormats();
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _SetCoordinatesFormat_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        int32_t argin1; ri >> argin1;
        SetCoordinatesFormat(argin1);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetCoordinatesFormat_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        int32_t argout1 = GetCoordinatesFormat();
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _GetSupportedCoordinatesFormats_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        std::vector< int32_t > argout1 = GetSupportedCoordinatesFormats();
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _SetLocale_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        std::string argin1; ri >> argin1;
        std::string argin2; ri >> argin2;
        std::string argin3; ri >> argin3;
        SetLocale(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetLocale_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        std::string argout1;
        std::string argout2;
        std::string argout3;
        GetLocale(argout1, argout2, argout3);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        wi << argout2;
        wi << argout3;
        return reply;
    }
    ::DBus::Message _GetSupportedLocales_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        std::vector< ::DBus::Struct< std::string, std::string, std::string > > argout1 = GetSupportedLocales();
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
};

} } }
namespace org {
namespace genivi {
namespace mapviewer {

class MapViewerControl_adaptor
: public ::DBus::InterfaceAdaptor
{
public:

    MapViewerControl_adaptor()
    : ::DBus::InterfaceAdaptor("org.genivi.mapviewer.MapViewerControl")
    {
        register_method(MapViewerControl_adaptor, GetVersion, _GetVersion_stub);
        register_method(MapViewerControl_adaptor, CreateMapViewInstance, _CreateMapViewInstance_stub);
        register_method(MapViewerControl_adaptor, ReleaseMapViewInstance, _ReleaseMapViewInstance_stub);
        register_method(MapViewerControl_adaptor, GetMapViewType, _GetMapViewType_stub);
        register_method(MapViewerControl_adaptor, GetSupportedMapViewTypes, _GetSupportedMapViewTypes_stub);
        register_method(MapViewerControl_adaptor, SetTargetPoint, _SetTargetPoint_stub);
        register_method(MapViewerControl_adaptor, GetTargetPoint, _GetTargetPoint_stub);
        register_method(MapViewerControl_adaptor, SetFollowCarMode, _SetFollowCarMode_stub);
        register_method(MapViewerControl_adaptor, GetFollowCarMode, _GetFollowCarMode_stub);
        register_method(MapViewerControl_adaptor, SetCameraPosition, _SetCameraPosition_stub);
        register_method(MapViewerControl_adaptor, GetCameraPosition, _GetCameraPosition_stub);
        register_method(MapViewerControl_adaptor, SetCameraHeadingAngle, _SetCameraHeadingAngle_stub);
        register_method(MapViewerControl_adaptor, SetCameraHeadingToTarget, _SetCameraHeadingToTarget_stub);
        register_method(MapViewerControl_adaptor, SetCameraHeadingTrackUp, _SetCameraHeadingTrackUp_stub);
        register_method(MapViewerControl_adaptor, GetCameraHeading, _GetCameraHeading_stub);
        register_method(MapViewerControl_adaptor, SetCameraTiltAngle, _SetCameraTiltAngle_stub);
        register_method(MapViewerControl_adaptor, GetCameraTiltAngle, _GetCameraTiltAngle_stub);
        register_method(MapViewerControl_adaptor, SetCameraRollAngle, _SetCameraRollAngle_stub);
        register_method(MapViewerControl_adaptor, GetCameraRollAngle, _GetCameraRollAngle_stub);
        register_method(MapViewerControl_adaptor, SetCameraDistanceFromTargetPoint, _SetCameraDistanceFromTargetPoint_stub);
        register_method(MapViewerControl_adaptor, GetCameraDistanceFromTargetPoint, _GetCameraDistanceFromTargetPoint_stub);
        register_method(MapViewerControl_adaptor, SetMapViewScaleMode, _SetMapViewScaleMode_stub);
        register_method(MapViewerControl_adaptor, GetMapViewScaleMode, _GetMapViewScaleMode_stub);
        register_method(MapViewerControl_adaptor, GetSupportedMapViewScaleModes, _GetSupportedMapViewScaleModes_stub);
        register_method(MapViewerControl_adaptor, AddMapViewScaleChangedListener, _AddMapViewScaleChangedListener_stub);
        register_method(MapViewerControl_adaptor, RemoveMapViewScaleChangedListener, _RemoveMapViewScaleChangedListener_stub);
        register_method(MapViewerControl_adaptor, SetCameraHeight, _SetCameraHeight_stub);
        register_method(MapViewerControl_adaptor, GetCameraHeight, _GetCameraHeight_stub);
        register_method(MapViewerControl_adaptor, SetMapViewPerspective, _SetMapViewPerspective_stub);
        register_method(MapViewerControl_adaptor, GetMapViewPerspective, _GetMapViewPerspective_stub);
        register_method(MapViewerControl_adaptor, GetSupportedMapViewPerspectives, _GetSupportedMapViewPerspectives_stub);
        register_method(MapViewerControl_adaptor, SetMapViewObjectVisibility, _SetMapViewObjectVisibility_stub);
        register_method(MapViewerControl_adaptor, GetMapViewObjectVisibility, _GetMapViewObjectVisibility_stub);
        register_method(MapViewerControl_adaptor, GetSupportedMapViewObjectVisibilities, _GetSupportedMapViewObjectVisibilities_stub);
        register_method(MapViewerControl_adaptor, GetScaleList, _GetScaleList_stub);
        register_method(MapViewerControl_adaptor, SetMapViewScale, _SetMapViewScale_stub);
        register_method(MapViewerControl_adaptor, SetMapViewScaleByDelta, _SetMapViewScaleByDelta_stub);
        register_method(MapViewerControl_adaptor, SetMapViewScaleByMetersPerPixel, _SetMapViewScaleByMetersPerPixel_stub);
        register_method(MapViewerControl_adaptor, GetMapViewScale, _GetMapViewScale_stub);
        register_method(MapViewerControl_adaptor, SetMapViewBoundingBox, _SetMapViewBoundingBox_stub);
        register_method(MapViewerControl_adaptor, GetMapViewBoundingBox, _GetMapViewBoundingBox_stub);
        register_method(MapViewerControl_adaptor, SetMapViewSaveArea, _SetMapViewSaveArea_stub);
        register_method(MapViewerControl_adaptor, GetMapViewSaveArea, _GetMapViewSaveArea_stub);
        register_method(MapViewerControl_adaptor, SetMapViewPan, _SetMapViewPan_stub);
        register_method(MapViewerControl_adaptor, GetMapViewPan, _GetMapViewPan_stub);
        register_method(MapViewerControl_adaptor, SetMapViewRotation, _SetMapViewRotation_stub);
        register_method(MapViewerControl_adaptor, GetMapViewRotation, _GetMapViewRotation_stub);
        register_method(MapViewerControl_adaptor, SetMapViewVisibilityMode, _SetMapViewVisibilityMode_stub);
        register_method(MapViewerControl_adaptor, GetMapViewVisibilityMode, _GetMapViewVisibilityMode_stub);
        register_method(MapViewerControl_adaptor, GetSupportedMapViewVisibilityModes, _GetSupportedMapViewVisibilityModes_stub);
        register_method(MapViewerControl_adaptor, SetMapViewPerformanceLevel, _SetMapViewPerformanceLevel_stub);
        register_method(MapViewerControl_adaptor, GetMapViewPerformanceLevel, _GetMapViewPerformanceLevel_stub);
        register_method(MapViewerControl_adaptor, GetSupportedMapViewPerformanceLevels, _GetSupportedMapViewPerformanceLevels_stub);
        register_method(MapViewerControl_adaptor, DisplayRoute, _DisplayRoute_stub);
        register_method(MapViewerControl_adaptor, HideRoute, _HideRoute_stub);
        register_method(MapViewerControl_adaptor, GetDisplayedRoutes, _GetDisplayedRoutes_stub);
        register_method(MapViewerControl_adaptor, GetPoiCategoriesVisible, _GetPoiCategoriesVisible_stub);
        register_method(MapViewerControl_adaptor, SetPoiCategoriesVisible, _SetPoiCategoriesVisible_stub);
        register_method(MapViewerControl_adaptor, SetPoiCategoriesVisibleWithinLimits, _SetPoiCategoriesVisibleWithinLimits_stub);
        register_method(MapViewerControl_adaptor, SetPoiCategoriesNotVisible, _SetPoiCategoriesNotVisible_stub);
        register_method(MapViewerControl_adaptor, SetTrafficIncidentsVisibility, _SetTrafficIncidentsVisibility_stub);
        register_method(MapViewerControl_adaptor, SetMapViewTheme, _SetMapViewTheme_stub);
        register_method(MapViewerControl_adaptor, GetMapViewTheme, _GetMapViewTheme_stub);
        register_method(MapViewerControl_adaptor, GetSupportedMapViewThemes, _GetSupportedMapViewThemes_stub);
        register_method(MapViewerControl_adaptor, ConvertPixelCoordsToGeoCoords, _ConvertPixelCoordsToGeoCoords_stub);
        register_method(MapViewerControl_adaptor, ConvertGeoCoordsToPixelCoords, _ConvertGeoCoordsToPixelCoords_stub);
        register_method(MapViewerControl_adaptor, DisplayCustomElements, _DisplayCustomElements_stub);
        register_method(MapViewerControl_adaptor, HideCustomElements, _HideCustomElements_stub);
        register_method(MapViewerControl_adaptor, GetDisplayedCustomElements, _GetDisplayedCustomElements_stub);
        register_method(MapViewerControl_adaptor, SelectElementsOnMap, _SelectElementsOnMap_stub);
    }

    ::DBus::IntrospectedInterface *introspect() const
    {
        static ::DBus::IntrospectedArgument GetVersion_args[] =
        {
            { "version", "(qqqs)", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument CreateMapViewInstance_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewSize", "(qq)", true },
            { "mapViewType", "i", true },
            { "mapViewInstanceHandle", "u", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument ReleaseMapViewInstance_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewInstanceHandle", "u", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetMapViewType_args[] =
        {
            { "mapViewInstanceHandle", "u", true },
            { "mapViewType", "i", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetSupportedMapViewTypes_args[] =
        {
            { "mapViewTypeList", "ai", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetTargetPoint_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewInstanceHandle", "u", true },
            { "targetPoint", "(ddd)", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetTargetPoint_args[] =
        {
            { "mapViewInstanceHandle", "u", true },
            { "targetPoint", "(ddd)", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetFollowCarMode_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewInstanceHandle", "u", true },
            { "followCarMode", "b", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetFollowCarMode_args[] =
        {
            { "mapViewInstanceHandle", "u", true },
            { "followCarMode", "b", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetCameraPosition_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewInstanceHandle", "u", true },
            { "position", "(ddd)", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetCameraPosition_args[] =
        {
            { "mapViewInstanceHandle", "u", true },
            { "position", "(ddd)", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetCameraHeadingAngle_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewInstanceHandle", "u", true },
            { "heading", "i", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetCameraHeadingToTarget_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewInstanceHandle", "u", true },
            { "target", "(dd)", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetCameraHeadingTrackUp_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewInstanceHandle", "u", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetCameraHeading_args[] =
        {
            { "mapViewInstanceHandle", "u", true },
            { "headingType", "i", false },
            { "headingAngle", "i", false },
            { "target", "(dd)", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetCameraTiltAngle_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewInstanceHandle", "u", true },
            { "tilt", "i", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetCameraTiltAngle_args[] =
        {
            { "mapViewInstanceHandle", "u", true },
            { "tilt", "i", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetCameraRollAngle_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewInstanceHandle", "u", true },
            { "roll", "i", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetCameraRollAngle_args[] =
        {
            { "mapViewInstanceHandle", "u", true },
            { "roll", "i", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetCameraDistanceFromTargetPoint_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewInstanceHandle", "u", true },
            { "distance", "u", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetCameraDistanceFromTargetPoint_args[] =
        {
            { "mapViewInstanceHandle", "u", true },
            { "distance", "u", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetMapViewScaleMode_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewInstanceHandle", "u", true },
            { "scaleMode", "i", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetMapViewScaleMode_args[] =
        {
            { "mapViewInstanceHandle", "u", true },
            { "scaleMode", "i", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetSupportedMapViewScaleModes_args[] =
        {
            { "mapViewInstanceHandle", "u", true },
            { "scaleModeList", "ai", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument AddMapViewScaleChangedListener_args[] =
        {
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument RemoveMapViewScaleChangedListener_args[] =
        {
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetCameraHeight_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewInstanceHandle", "u", true },
            { "height", "u", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetCameraHeight_args[] =
        {
            { "mapViewInstanceHandle", "u", true },
            { "height", "u", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetMapViewPerspective_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewInstanceHandle", "u", true },
            { "perspective", "i", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetMapViewPerspective_args[] =
        {
            { "mapViewInstanceHandle", "u", true },
            { "perspective", "i", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetSupportedMapViewPerspectives_args[] =
        {
            { "perspectiveList", "ai", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetMapViewObjectVisibility_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewInstanceHandle", "u", true },
            { "objectVisibilityList", "a{ib}", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetMapViewObjectVisibility_args[] =
        {
            { "mapViewInstanceHandle", "u", true },
            { "objectVisibilityList", "a{ib}", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetSupportedMapViewObjectVisibilities_args[] =
        {
            { "mapViewInstanceHandle", "u", true },
            { "objectVisibilityList", "ai", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetScaleList_args[] =
        {
            { "mapViewInstanceHandle", "u", true },
            { "scaleList", "a(qqiu)", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetMapViewScale_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewInstanceHandle", "u", true },
            { "scaleID", "q", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetMapViewScaleByDelta_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewInstanceHandle", "u", true },
            { "scaleDelta", "n", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetMapViewScaleByMetersPerPixel_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewInstanceHandle", "u", true },
            { "metersPerPixel", "d", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetMapViewScale_args[] =
        {
            { "mapViewInstanceHandle", "u", true },
            { "scaleID", "y", false },
            { "isMinMax", "i", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetMapViewBoundingBox_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewInstanceHandle", "u", true },
            { "boundingBox", "((dd)(dd))", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetMapViewBoundingBox_args[] =
        {
            { "mapViewInstanceHandle", "u", true },
            { "boundingBox", "((dd)(dd))", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetMapViewSaveArea_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewInstanceHandle", "u", true },
            { "saveArea", "(dddd)", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetMapViewSaveArea_args[] =
        {
            { "mapViewInstanceHandle", "u", true },
            { "saveArea", "(dddd)", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetMapViewPan_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewInstanceHandle", "u", true },
            { "panningAction", "i", true },
            { "pixelCoordinates", "a(qq)", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetMapViewPan_args[] =
        {
            { "mapViewInstanceHandle", "u", true },
            { "valueToReturn", "i", true },
            { "pixelCoordinates", "a(qq)", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetMapViewRotation_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewInstanceHandle", "u", true },
            { "rotationAngle", "i", true },
            { "rotationAnglePerSecond", "i", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetMapViewRotation_args[] =
        {
            { "mapViewInstanceHandle", "u", true },
            { "rotationAngle", "i", false },
            { "rotationAnglePerFrame", "i", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetMapViewVisibilityMode_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewInstanceHandle", "u", true },
            { "visibilityMode", "i", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetMapViewVisibilityMode_args[] =
        {
            { "mapViewInstanceHandle", "u", true },
            { "visibilityMode", "i", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetSupportedMapViewVisibilityModes_args[] =
        {
            { "visibilityModeList", "ai", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetMapViewPerformanceLevel_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewInstanceHandle", "u", true },
            { "performanceLevel", "i", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetMapViewPerformanceLevel_args[] =
        {
            { "mapViewInstanceHandle", "u", true },
            { "performanceLevel", "i", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetSupportedMapViewPerformanceLevels_args[] =
        {
            { "performanceLevelList", "ai", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument DisplayRoute_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewInstanceHandle", "u", true },
            { "routeHandle", "u", true },
            { "highlighted", "b", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument HideRoute_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewInstanceHandle", "u", true },
            { "routeHandle", "u", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetDisplayedRoutes_args[] =
        {
            { "mapViewInstanceHandle", "u", true },
            { "displayedRoutes", "a(ub)", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetPoiCategoriesVisible_args[] =
        {
            { "mapViewInstanceHandle", "u", true },
            { "poiCategoryIds", "au", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetPoiCategoriesVisible_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewInstanceHandle", "u", true },
            { "poiCategoryIds", "au", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetPoiCategoriesVisibleWithinLimits_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewInstanceHandle", "u", true },
            { "poiCategoryIds", "au", true },
            { "minScaleID", "y", true },
            { "maxScaleID", "y", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetPoiCategoriesNotVisible_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewInstanceHandle", "u", true },
            { "poiCategoryIds", "au", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetTrafficIncidentsVisibility_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewInstanceHandle", "u", true },
            { "visible", "b", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetMapViewTheme_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewInstanceHandle", "u", true },
            { "mapViewTheme", "i", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetMapViewTheme_args[] =
        {
            { "mapViewInstanceHandle", "u", true },
            { "mapViewTheme", "i", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetSupportedMapViewThemes_args[] =
        {
            { "mapViewThemeList", "ai", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument ConvertPixelCoordsToGeoCoords_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewInstanceHandle", "u", true },
            { "pixelCoordinates", "a(qq)", true },
            { "geoCoordinates", "a(dd)", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument ConvertGeoCoordsToPixelCoords_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewInstanceHandle", "u", true },
            { "geoCoordinates", "a(dd)", true },
            { "pixelCoordinates", "a(qq)", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument DisplayCustomElements_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewInstanceHandle", "u", true },
            { "customElements", "a(ss(dd)(nn))", true },
            { "customElementHandles", "au", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument HideCustomElements_args[] =
        {
            { "sessionHandle", "u", true },
            { "mapViewInstanceHandle", "u", true },
            { "customElementHandles", "au", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetDisplayedCustomElements_args[] =
        {
            { "mapViewInstanceHandle", "u", true },
            { "customElements", "a{u(ss(dd)(nn))}", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SelectElementsOnMap_args[] =
        {
            { "mapViewInstanceHandle", "u", true },
            { "pixelCoordinate", "(qq)", true },
            { "selectableTypes", "ai", true },
            { "maxNumberOfSelectedElements", "q", true },
            { "selectedElements", "a(i(dd)(yv))", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument FollowCarModeChanged_args[] =
        {
            { "mapViewInstanceHandle", "u", false },
            { "followCarMode", "b", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument CameraPositionChanged_args[] =
        {
            { "mapViewInstanceHandle", "u", false },
            { "targetPoint", "(ddd)", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument CameraHeadingChanged_args[] =
        {
            { "mapViewInstanceHandle", "u", false },
            { "headingType", "q", false },
            { "headingAngle", "i", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument CameraTiltAngleChanged_args[] =
        {
            { "mapViewInstanceHandle", "u", false },
            { "tilt", "i", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument CameraDistanceFromTargetPointChanged_args[] =
        {
            { "mapViewInstanceHandle", "u", false },
            { "distance", "u", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument MapViewScaleChanged_args[] =
        {
            { "mapViewInstanceHandle", "u", false },
            { "scaleID", "y", false },
            { "isMinMax", "i", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument MapViewPerspectiveChanged_args[] =
        {
            { "mapViewInstanceHandle", "u", false },
            { "perspective", "q", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument MapViewObjectVisibilityChanged_args[] =
        {
            { "mapViewInstanceHandle", "u", false },
            { "objectVisibilityList", "a{ib}", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument MapViewBoundingBoxChanged_args[] =
        {
            { "mapViewInstanceHandle", "u", false },
            { "boundingBox", "((dd)(dd))", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument MapViewSaveAreaChanged_args[] =
        {
            { "mapViewInstanceHandle", "u", false },
            { "saveArea", "(dddd)", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument MapViewVisibilityChanged_args[] =
        {
            { "mapViewInstanceHandle", "u", false },
            { "visibilityMode", "i", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument MapViewPerformanceLevelChanged_args[] =
        {
            { "mapViewInstanceHandle", "u", false },
            { "performanceLevel", "i", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument DisplayedRoutes_args[] =
        {
            { "mapViewInstanceHandle", "u", false },
            { "displayedRoutes", "a(ub)", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument PoiCategoriesVisibilityChanged_args[] =
        {
            { "mapViewInstanceHandle", "u", false },
            { "poiCategoryIds", "au", false },
            { "visible", "b", false },
            { "minScaleID", "y", false },
            { "maxScaleID", "y", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument MapViewThemeChanged_args[] =
        {
            { "mapViewInstanceHandle", "u", false },
            { "mapViewTheme", "i", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedMethod MapViewerControl_adaptor_methods[] =
        {
            { "GetVersion", GetVersion_args },
            { "CreateMapViewInstance", CreateMapViewInstance_args },
            { "ReleaseMapViewInstance", ReleaseMapViewInstance_args },
            { "GetMapViewType", GetMapViewType_args },
            { "GetSupportedMapViewTypes", GetSupportedMapViewTypes_args },
            { "SetTargetPoint", SetTargetPoint_args },
            { "GetTargetPoint", GetTargetPoint_args },
            { "SetFollowCarMode", SetFollowCarMode_args },
            { "GetFollowCarMode", GetFollowCarMode_args },
            { "SetCameraPosition", SetCameraPosition_args },
            { "GetCameraPosition", GetCameraPosition_args },
            { "SetCameraHeadingAngle", SetCameraHeadingAngle_args },
            { "SetCameraHeadingToTarget", SetCameraHeadingToTarget_args },
            { "SetCameraHeadingTrackUp", SetCameraHeadingTrackUp_args },
            { "GetCameraHeading", GetCameraHeading_args },
            { "SetCameraTiltAngle", SetCameraTiltAngle_args },
            { "GetCameraTiltAngle", GetCameraTiltAngle_args },
            { "SetCameraRollAngle", SetCameraRollAngle_args },
            { "GetCameraRollAngle", GetCameraRollAngle_args },
            { "SetCameraDistanceFromTargetPoint", SetCameraDistanceFromTargetPoint_args },
            { "GetCameraDistanceFromTargetPoint", GetCameraDistanceFromTargetPoint_args },
            { "SetMapViewScaleMode", SetMapViewScaleMode_args },
            { "GetMapViewScaleMode", GetMapViewScaleMode_args },
            { "GetSupportedMapViewScaleModes", GetSupportedMapViewScaleModes_args },
            { "AddMapViewScaleChangedListener", AddMapViewScaleChangedListener_args },
            { "RemoveMapViewScaleChangedListener", RemoveMapViewScaleChangedListener_args },
            { "SetCameraHeight", SetCameraHeight_args },
            { "GetCameraHeight", GetCameraHeight_args },
            { "SetMapViewPerspective", SetMapViewPerspective_args },
            { "GetMapViewPerspective", GetMapViewPerspective_args },
            { "GetSupportedMapViewPerspectives", GetSupportedMapViewPerspectives_args },
            { "SetMapViewObjectVisibility", SetMapViewObjectVisibility_args },
            { "GetMapViewObjectVisibility", GetMapViewObjectVisibility_args },
            { "GetSupportedMapViewObjectVisibilities", GetSupportedMapViewObjectVisibilities_args },
            { "GetScaleList", GetScaleList_args },
            { "SetMapViewScale", SetMapViewScale_args },
            { "SetMapViewScaleByDelta", SetMapViewScaleByDelta_args },
            { "SetMapViewScaleByMetersPerPixel", SetMapViewScaleByMetersPerPixel_args },
            { "GetMapViewScale", GetMapViewScale_args },
            { "SetMapViewBoundingBox", SetMapViewBoundingBox_args },
            { "GetMapViewBoundingBox", GetMapViewBoundingBox_args },
            { "SetMapViewSaveArea", SetMapViewSaveArea_args },
            { "GetMapViewSaveArea", GetMapViewSaveArea_args },
            { "SetMapViewPan", SetMapViewPan_args },
            { "GetMapViewPan", GetMapViewPan_args },
            { "SetMapViewRotation", SetMapViewRotation_args },
            { "GetMapViewRotation", GetMapViewRotation_args },
            { "SetMapViewVisibilityMode", SetMapViewVisibilityMode_args },
            { "GetMapViewVisibilityMode", GetMapViewVisibilityMode_args },
            { "GetSupportedMapViewVisibilityModes", GetSupportedMapViewVisibilityModes_args },
            { "SetMapViewPerformanceLevel", SetMapViewPerformanceLevel_args },
            { "GetMapViewPerformanceLevel", GetMapViewPerformanceLevel_args },
            { "GetSupportedMapViewPerformanceLevels", GetSupportedMapViewPerformanceLevels_args },
            { "DisplayRoute", DisplayRoute_args },
            { "HideRoute", HideRoute_args },
            { "GetDisplayedRoutes", GetDisplayedRoutes_args },
            { "GetPoiCategoriesVisible", GetPoiCategoriesVisible_args },
            { "SetPoiCategoriesVisible", SetPoiCategoriesVisible_args },
            { "SetPoiCategoriesVisibleWithinLimits", SetPoiCategoriesVisibleWithinLimits_args },
            { "SetPoiCategoriesNotVisible", SetPoiCategoriesNotVisible_args },
            { "SetTrafficIncidentsVisibility", SetTrafficIncidentsVisibility_args },
            { "SetMapViewTheme", SetMapViewTheme_args },
            { "GetMapViewTheme", GetMapViewTheme_args },
            { "GetSupportedMapViewThemes", GetSupportedMapViewThemes_args },
            { "ConvertPixelCoordsToGeoCoords", ConvertPixelCoordsToGeoCoords_args },
            { "ConvertGeoCoordsToPixelCoords", ConvertGeoCoordsToPixelCoords_args },
            { "DisplayCustomElements", DisplayCustomElements_args },
            { "HideCustomElements", HideCustomElements_args },
            { "GetDisplayedCustomElements", GetDisplayedCustomElements_args },
            { "SelectElementsOnMap", SelectElementsOnMap_args },
            { 0, 0 }
        };
        static ::DBus::IntrospectedMethod MapViewerControl_adaptor_signals[] =
        {
            { "FollowCarModeChanged", FollowCarModeChanged_args },
            { "CameraPositionChanged", CameraPositionChanged_args },
            { "CameraHeadingChanged", CameraHeadingChanged_args },
            { "CameraTiltAngleChanged", CameraTiltAngleChanged_args },
            { "CameraDistanceFromTargetPointChanged", CameraDistanceFromTargetPointChanged_args },
            { "MapViewScaleChanged", MapViewScaleChanged_args },
            { "MapViewPerspectiveChanged", MapViewPerspectiveChanged_args },
            { "MapViewObjectVisibilityChanged", MapViewObjectVisibilityChanged_args },
            { "MapViewBoundingBoxChanged", MapViewBoundingBoxChanged_args },
            { "MapViewSaveAreaChanged", MapViewSaveAreaChanged_args },
            { "MapViewVisibilityChanged", MapViewVisibilityChanged_args },
            { "MapViewPerformanceLevelChanged", MapViewPerformanceLevelChanged_args },
            { "DisplayedRoutes", DisplayedRoutes_args },
            { "PoiCategoriesVisibilityChanged", PoiCategoriesVisibilityChanged_args },
            { "MapViewThemeChanged", MapViewThemeChanged_args },
            { 0, 0 }
        };
        static ::DBus::IntrospectedProperty MapViewerControl_adaptor_properties[] =
        {
            { 0, 0, 0, 0 }
        };
        static ::DBus::IntrospectedInterface MapViewerControl_adaptor_interface =
        {
            "org.genivi.mapviewer.MapViewerControl",
            MapViewerControl_adaptor_methods,
            MapViewerControl_adaptor_signals,
            MapViewerControl_adaptor_properties
        };
        return &MapViewerControl_adaptor_interface;
    }

public:

    /* properties exposed by this interface, use
     * property() and property(value) to get and set a particular property
     */

public:

    /* methods exported by this interface,
     * you will have to implement them in your ObjectAdaptor
     */
    virtual ::DBus::Struct< uint16_t, uint16_t, uint16_t, std::string > MapViewerControlGetVersion() = 0;
    virtual uint32_t CreateMapViewInstance(const uint32_t& sessionHandle, const ::DBus::Struct< uint16_t, uint16_t >& mapViewSize, const int32_t& mapViewType) = 0;
    virtual void ReleaseMapViewInstance(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle) = 0;
    virtual int32_t GetMapViewType(const uint32_t& mapViewInstanceHandle) = 0;
    virtual std::vector< int32_t > GetSupportedMapViewTypes() = 0;
    virtual void SetTargetPoint(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const ::DBus::Struct< double, double, double >& targetPoint) = 0;
    virtual ::DBus::Struct< double, double, double > GetTargetPoint(const uint32_t& mapViewInstanceHandle) = 0;
    virtual void SetFollowCarMode(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const bool& followCarMode) = 0;
    virtual bool GetFollowCarMode(const uint32_t& mapViewInstanceHandle) = 0;
    virtual void SetCameraPosition(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const ::DBus::Struct< double, double, double >& position) = 0;
    virtual ::DBus::Struct< double, double, double > GetCameraPosition(const uint32_t& mapViewInstanceHandle) = 0;
    virtual void SetCameraHeadingAngle(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const int32_t& heading) = 0;
    virtual void SetCameraHeadingToTarget(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const ::DBus::Struct< double, double >& target) = 0;
    virtual void SetCameraHeadingTrackUp(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle) = 0;
    virtual void GetCameraHeading(const uint32_t& mapViewInstanceHandle, int32_t& headingType, int32_t& headingAngle, ::DBus::Struct< double, double >& target) = 0;
    virtual void SetCameraTiltAngle(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const int32_t& tilt) = 0;
    virtual int32_t GetCameraTiltAngle(const uint32_t& mapViewInstanceHandle) = 0;
    virtual void SetCameraRollAngle(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const int32_t& roll) = 0;
    virtual int32_t GetCameraRollAngle(const uint32_t& mapViewInstanceHandle) = 0;
    virtual void SetCameraDistanceFromTargetPoint(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const uint32_t& distance) = 0;
    virtual uint32_t GetCameraDistanceFromTargetPoint(const uint32_t& mapViewInstanceHandle) = 0;
    virtual void SetMapViewScaleMode(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const int32_t& scaleMode) = 0;
    virtual int32_t GetMapViewScaleMode(const uint32_t& mapViewInstanceHandle) = 0;
    virtual std::vector< int32_t > GetSupportedMapViewScaleModes(const uint32_t& mapViewInstanceHandle) = 0;
    virtual void AddMapViewScaleChangedListener() = 0;
    virtual void RemoveMapViewScaleChangedListener() = 0;
    virtual void SetCameraHeight(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const uint32_t& height) = 0;
    virtual uint32_t GetCameraHeight(const uint32_t& mapViewInstanceHandle) = 0;
    virtual void SetMapViewPerspective(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const int32_t& perspective) = 0;
    virtual int32_t GetMapViewPerspective(const uint32_t& mapViewInstanceHandle) = 0;
    virtual std::vector< int32_t > GetSupportedMapViewPerspectives() = 0;
    virtual void SetMapViewObjectVisibility(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const std::map< int32_t, bool >& objectVisibilityList) = 0;
    virtual std::map< int32_t, bool > GetMapViewObjectVisibility(const uint32_t& mapViewInstanceHandle) = 0;
    virtual std::vector< int32_t > GetSupportedMapViewObjectVisibilities(const uint32_t& mapViewInstanceHandle) = 0;
    virtual std::vector< ::DBus::Struct< uint16_t, uint16_t, int32_t, uint32_t > > GetScaleList(const uint32_t& mapViewInstanceHandle) = 0;
    virtual void SetMapViewScale(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const uint16_t& scaleID) = 0;
    virtual void SetMapViewScaleByDelta(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const int16_t& scaleDelta) = 0;
    virtual void SetMapViewScaleByMetersPerPixel(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const double& metersPerPixel) = 0;
    virtual void GetMapViewScale(const uint32_t& mapViewInstanceHandle, uint8_t& scaleID, int32_t& isMinMax) = 0;
    virtual void SetMapViewBoundingBox(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const ::DBus::Struct< ::DBus::Struct< double, double >, ::DBus::Struct< double, double > >& boundingBox) = 0;
    virtual ::DBus::Struct< ::DBus::Struct< double, double >, ::DBus::Struct< double, double > > GetMapViewBoundingBox(const uint32_t& mapViewInstanceHandle) = 0;
    virtual void SetMapViewSaveArea(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const ::DBus::Struct< double, double, double, double >& saveArea) = 0;
    virtual ::DBus::Struct< double, double, double, double > GetMapViewSaveArea(const uint32_t& mapViewInstanceHandle) = 0;
    virtual void SetMapViewPan(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const int32_t& panningAction, const std::vector< ::DBus::Struct< uint16_t, uint16_t > >& pixelCoordinates) = 0;
    virtual std::vector< ::DBus::Struct< uint16_t, uint16_t > > GetMapViewPan(const uint32_t& mapViewInstanceHandle, const int32_t& valueToReturn) = 0;
    virtual void SetMapViewRotation(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const int32_t& rotationAngle, const int32_t& rotationAnglePerSecond) = 0;
    virtual void GetMapViewRotation(const uint32_t& mapViewInstanceHandle, int32_t& rotationAngle, int32_t& rotationAnglePerFrame) = 0;
    virtual void SetMapViewVisibilityMode(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const int32_t& visibilityMode) = 0;
    virtual int32_t GetMapViewVisibilityMode(const uint32_t& mapViewInstanceHandle) = 0;
    virtual std::vector< int32_t > GetSupportedMapViewVisibilityModes() = 0;
    virtual void SetMapViewPerformanceLevel(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const int32_t& performanceLevel) = 0;
    virtual int32_t GetMapViewPerformanceLevel(const uint32_t& mapViewInstanceHandle) = 0;
    virtual std::vector< int32_t > GetSupportedMapViewPerformanceLevels() = 0;
    virtual void DisplayRoute(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const uint32_t& routeHandle, const bool& highlighted) = 0;
    virtual void HideRoute(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const uint32_t& routeHandle) = 0;
    virtual std::vector< ::DBus::Struct< uint32_t, bool > > GetDisplayedRoutes(const uint32_t& mapViewInstanceHandle) = 0;
    virtual std::vector< uint32_t > GetPoiCategoriesVisible(const uint32_t& mapViewInstanceHandle) = 0;
    virtual void SetPoiCategoriesVisible(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const std::vector< uint32_t >& poiCategoryIds) = 0;
    virtual void SetPoiCategoriesVisibleWithinLimits(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const std::vector< uint32_t >& poiCategoryIds, const uint8_t& minScaleID, const uint8_t& maxScaleID) = 0;
    virtual void SetPoiCategoriesNotVisible(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const std::vector< uint32_t >& poiCategoryIds) = 0;
    virtual void SetTrafficIncidentsVisibility(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const bool& visible) = 0;
    virtual void SetMapViewTheme(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const int32_t& mapViewTheme) = 0;
    virtual int32_t GetMapViewTheme(const uint32_t& mapViewInstanceHandle) = 0;
    virtual std::vector< int32_t > GetSupportedMapViewThemes() = 0;
    virtual std::vector< ::DBus::Struct< double, double > > ConvertPixelCoordsToGeoCoords(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const std::vector< ::DBus::Struct< uint16_t, uint16_t > >& pixelCoordinates) = 0;
    virtual std::vector< ::DBus::Struct< uint16_t, uint16_t > > ConvertGeoCoordsToPixelCoords(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const std::vector< ::DBus::Struct< double, double > >& geoCoordinates) = 0;
    virtual std::vector< uint32_t > DisplayCustomElements(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const std::vector< ::DBus::Struct< std::string, std::string, ::DBus::Struct< double, double >, ::DBus::Struct< int16_t, int16_t > > >& customElements) = 0;
    virtual void HideCustomElements(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const std::vector< uint32_t >& customElementHandles) = 0;
    virtual std::map< uint32_t, ::DBus::Struct< std::string, std::string, ::DBus::Struct< double, double >, ::DBus::Struct< int16_t, int16_t > > > GetDisplayedCustomElements(const uint32_t& mapViewInstanceHandle) = 0;
    virtual std::vector< ::DBus::Struct< int32_t, ::DBus::Struct< double, double >, ::DBus::Struct< uint8_t, ::DBus::Variant > > > SelectElementsOnMap(const uint32_t& mapViewInstanceHandle, const ::DBus::Struct< uint16_t, uint16_t >& pixelCoordinate, const std::vector< int32_t >& selectableTypes, const uint16_t& maxNumberOfSelectedElements) = 0;

public:

    /* signal emitters for this interface
     */
    void FollowCarModeChanged(const uint32_t& arg1, const bool& arg2)
    {
        ::DBus::SignalMessage sig("FollowCarModeChanged");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        wi << arg2;
        emit_signal(sig);
    }
    void CameraPositionChanged(const uint32_t& arg1, const ::DBus::Struct< double, double, double >& arg2)
    {
        ::DBus::SignalMessage sig("CameraPositionChanged");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        wi << arg2;
        emit_signal(sig);
    }
    void CameraHeadingChanged(const uint32_t& arg1, const uint16_t& arg2, const int32_t& arg3)
    {
        ::DBus::SignalMessage sig("CameraHeadingChanged");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        wi << arg2;
        wi << arg3;
        emit_signal(sig);
    }
    void CameraTiltAngleChanged(const uint32_t& arg1, const int32_t& arg2)
    {
        ::DBus::SignalMessage sig("CameraTiltAngleChanged");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        wi << arg2;
        emit_signal(sig);
    }
    void CameraDistanceFromTargetPointChanged(const uint32_t& arg1, const uint32_t& arg2)
    {
        ::DBus::SignalMessage sig("CameraDistanceFromTargetPointChanged");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        wi << arg2;
        emit_signal(sig);
    }
    void MapViewScaleChanged(const uint32_t& arg1, const uint8_t& arg2, const int32_t& arg3)
    {
        ::DBus::SignalMessage sig("MapViewScaleChanged");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        wi << arg2;
        wi << arg3;
        emit_signal(sig);
    }
    void MapViewPerspectiveChanged(const uint32_t& arg1, const uint16_t& arg2)
    {
        ::DBus::SignalMessage sig("MapViewPerspectiveChanged");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        wi << arg2;
        emit_signal(sig);
    }
    void MapViewObjectVisibilityChanged(const uint32_t& arg1, const std::map< int32_t, bool >& arg2)
    {
        ::DBus::SignalMessage sig("MapViewObjectVisibilityChanged");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        wi << arg2;
        emit_signal(sig);
    }
    void MapViewBoundingBoxChanged(const uint32_t& arg1, const ::DBus::Struct< ::DBus::Struct< double, double >, ::DBus::Struct< double, double > >& arg2)
    {
        ::DBus::SignalMessage sig("MapViewBoundingBoxChanged");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        wi << arg2;
        emit_signal(sig);
    }
    void MapViewSaveAreaChanged(const uint32_t& arg1, const ::DBus::Struct< double, double, double, double >& arg2)
    {
        ::DBus::SignalMessage sig("MapViewSaveAreaChanged");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        wi << arg2;
        emit_signal(sig);
    }
    void MapViewVisibilityChanged(const uint32_t& arg1, const int32_t& arg2)
    {
        ::DBus::SignalMessage sig("MapViewVisibilityChanged");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        wi << arg2;
        emit_signal(sig);
    }
    void MapViewPerformanceLevelChanged(const uint32_t& arg1, const int32_t& arg2)
    {
        ::DBus::SignalMessage sig("MapViewPerformanceLevelChanged");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        wi << arg2;
        emit_signal(sig);
    }
    void DisplayedRoutes(const uint32_t& arg1, const std::vector< ::DBus::Struct< uint32_t, bool > >& arg2)
    {
        ::DBus::SignalMessage sig("DisplayedRoutes");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        wi << arg2;
        emit_signal(sig);
    }
    void PoiCategoriesVisibilityChanged(const uint32_t& arg1, const std::vector< uint32_t >& arg2, const bool& arg3, const uint8_t& arg4, const uint8_t& arg5)
    {
        ::DBus::SignalMessage sig("PoiCategoriesVisibilityChanged");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        wi << arg2;
        wi << arg3;
        wi << arg4;
        wi << arg5;
        emit_signal(sig);
    }
    void MapViewThemeChanged(const uint32_t& arg1, const int32_t& arg2)
    {
        ::DBus::SignalMessage sig("MapViewThemeChanged");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        wi << arg2;
        emit_signal(sig);
    }

private:

    /* unmarshalers (to unpack the DBus message before calling the actual interface method)
     */
    ::DBus::Message _GetVersion_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        ::DBus::Struct< uint16_t, uint16_t, uint16_t, std::string > argout1 = MapViewerControlGetVersion();
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _CreateMapViewInstance_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        ::DBus::Struct< uint16_t, uint16_t > argin2; ri >> argin2;
        int32_t argin3; ri >> argin3;
        uint32_t argout1 = CreateMapViewInstance(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _ReleaseMapViewInstance_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        ReleaseMapViewInstance(argin1, argin2);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetMapViewType_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        int32_t argout1 = GetMapViewType(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _GetSupportedMapViewTypes_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        std::vector< int32_t > argout1 = GetSupportedMapViewTypes();
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _SetTargetPoint_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        ::DBus::Struct< double, double, double > argin3; ri >> argin3;
        SetTargetPoint(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetTargetPoint_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        ::DBus::Struct< double, double, double > argout1 = GetTargetPoint(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _SetFollowCarMode_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        bool argin3; ri >> argin3;
        SetFollowCarMode(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetFollowCarMode_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        bool argout1 = GetFollowCarMode(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _SetCameraPosition_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        ::DBus::Struct< double, double, double > argin3; ri >> argin3;
        SetCameraPosition(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetCameraPosition_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        ::DBus::Struct< double, double, double > argout1 = GetCameraPosition(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _SetCameraHeadingAngle_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        int32_t argin3; ri >> argin3;
        SetCameraHeadingAngle(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _SetCameraHeadingToTarget_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        ::DBus::Struct< double, double > argin3; ri >> argin3;
        SetCameraHeadingToTarget(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _SetCameraHeadingTrackUp_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        SetCameraHeadingTrackUp(argin1, argin2);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetCameraHeading_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        int32_t argout1;
        int32_t argout2;
        ::DBus::Struct< double, double > argout3;
        GetCameraHeading(argin1, argout1, argout2, argout3);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        wi << argout2;
        wi << argout3;
        return reply;
    }
    ::DBus::Message _SetCameraTiltAngle_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        int32_t argin3; ri >> argin3;
        SetCameraTiltAngle(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetCameraTiltAngle_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        int32_t argout1 = GetCameraTiltAngle(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _SetCameraRollAngle_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        int32_t argin3; ri >> argin3;
        SetCameraRollAngle(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetCameraRollAngle_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        int32_t argout1 = GetCameraRollAngle(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _SetCameraDistanceFromTargetPoint_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        uint32_t argin3; ri >> argin3;
        SetCameraDistanceFromTargetPoint(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetCameraDistanceFromTargetPoint_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argout1 = GetCameraDistanceFromTargetPoint(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _SetMapViewScaleMode_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        int32_t argin3; ri >> argin3;
        SetMapViewScaleMode(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetMapViewScaleMode_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        int32_t argout1 = GetMapViewScaleMode(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _GetSupportedMapViewScaleModes_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        std::vector< int32_t > argout1 = GetSupportedMapViewScaleModes(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _AddMapViewScaleChangedListener_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        AddMapViewScaleChangedListener();
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _RemoveMapViewScaleChangedListener_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        RemoveMapViewScaleChangedListener();
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _SetCameraHeight_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        uint32_t argin3; ri >> argin3;
        SetCameraHeight(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetCameraHeight_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argout1 = GetCameraHeight(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _SetMapViewPerspective_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        int32_t argin3; ri >> argin3;
        SetMapViewPerspective(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetMapViewPerspective_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        int32_t argout1 = GetMapViewPerspective(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _GetSupportedMapViewPerspectives_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        std::vector< int32_t > argout1 = GetSupportedMapViewPerspectives();
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _SetMapViewObjectVisibility_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        std::map< int32_t, bool > argin3; ri >> argin3;
        SetMapViewObjectVisibility(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetMapViewObjectVisibility_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        std::map< int32_t, bool > argout1 = GetMapViewObjectVisibility(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _GetSupportedMapViewObjectVisibilities_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        std::vector< int32_t > argout1 = GetSupportedMapViewObjectVisibilities(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _GetScaleList_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        std::vector< ::DBus::Struct< uint16_t, uint16_t, int32_t, uint32_t > > argout1 = GetScaleList(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _SetMapViewScale_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        uint16_t argin3; ri >> argin3;
        SetMapViewScale(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _SetMapViewScaleByDelta_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        int16_t argin3; ri >> argin3;
        SetMapViewScaleByDelta(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _SetMapViewScaleByMetersPerPixel_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        double argin3; ri >> argin3;
        SetMapViewScaleByMetersPerPixel(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetMapViewScale_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint8_t argout1;
        int32_t argout2;
        GetMapViewScale(argin1, argout1, argout2);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        wi << argout2;
        return reply;
    }
    ::DBus::Message _SetMapViewBoundingBox_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        ::DBus::Struct< ::DBus::Struct< double, double >, ::DBus::Struct< double, double > > argin3; ri >> argin3;
        SetMapViewBoundingBox(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetMapViewBoundingBox_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        ::DBus::Struct< ::DBus::Struct< double, double >, ::DBus::Struct< double, double > > argout1 = GetMapViewBoundingBox(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _SetMapViewSaveArea_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        ::DBus::Struct< double, double, double, double > argin3; ri >> argin3;
        SetMapViewSaveArea(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetMapViewSaveArea_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        ::DBus::Struct< double, double, double, double > argout1 = GetMapViewSaveArea(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _SetMapViewPan_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        int32_t argin3; ri >> argin3;
        std::vector< ::DBus::Struct< uint16_t, uint16_t > > argin4; ri >> argin4;
        SetMapViewPan(argin1, argin2, argin3, argin4);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetMapViewPan_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        int32_t argin2; ri >> argin2;
        std::vector< ::DBus::Struct< uint16_t, uint16_t > > argout1 = GetMapViewPan(argin1, argin2);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _SetMapViewRotation_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        int32_t argin3; ri >> argin3;
        int32_t argin4; ri >> argin4;
        SetMapViewRotation(argin1, argin2, argin3, argin4);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetMapViewRotation_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        int32_t argout1;
        int32_t argout2;
        GetMapViewRotation(argin1, argout1, argout2);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        wi << argout2;
        return reply;
    }
    ::DBus::Message _SetMapViewVisibilityMode_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        int32_t argin3; ri >> argin3;
        SetMapViewVisibilityMode(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetMapViewVisibilityMode_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        int32_t argout1 = GetMapViewVisibilityMode(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _GetSupportedMapViewVisibilityModes_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        std::vector< int32_t > argout1 = GetSupportedMapViewVisibilityModes();
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _SetMapViewPerformanceLevel_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        int32_t argin3; ri >> argin3;
        SetMapViewPerformanceLevel(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetMapViewPerformanceLevel_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        int32_t argout1 = GetMapViewPerformanceLevel(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _GetSupportedMapViewPerformanceLevels_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        std::vector< int32_t > argout1 = GetSupportedMapViewPerformanceLevels();
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _DisplayRoute_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        uint32_t argin3; ri >> argin3;
        bool argin4; ri >> argin4;
        DisplayRoute(argin1, argin2, argin3, argin4);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _HideRoute_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        uint32_t argin3; ri >> argin3;
        HideRoute(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetDisplayedRoutes_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        std::vector< ::DBus::Struct< uint32_t, bool > > argout1 = GetDisplayedRoutes(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _GetPoiCategoriesVisible_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        std::vector< uint32_t > argout1 = GetPoiCategoriesVisible(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _SetPoiCategoriesVisible_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        std::vector< uint32_t > argin3; ri >> argin3;
        SetPoiCategoriesVisible(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _SetPoiCategoriesVisibleWithinLimits_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        std::vector< uint32_t > argin3; ri >> argin3;
        uint8_t argin4; ri >> argin4;
        uint8_t argin5; ri >> argin5;
        SetPoiCategoriesVisibleWithinLimits(argin1, argin2, argin3, argin4, argin5);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _SetPoiCategoriesNotVisible_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        std::vector< uint32_t > argin3; ri >> argin3;
        SetPoiCategoriesNotVisible(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _SetTrafficIncidentsVisibility_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        bool argin3; ri >> argin3;
        SetTrafficIncidentsVisibility(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _SetMapViewTheme_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        int32_t argin3; ri >> argin3;
        SetMapViewTheme(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetMapViewTheme_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        int32_t argout1 = GetMapViewTheme(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _GetSupportedMapViewThemes_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        std::vector< int32_t > argout1 = GetSupportedMapViewThemes();
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _ConvertPixelCoordsToGeoCoords_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        std::vector< ::DBus::Struct< uint16_t, uint16_t > > argin3; ri >> argin3;
        std::vector< ::DBus::Struct< double, double > > argout1 = ConvertPixelCoordsToGeoCoords(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _ConvertGeoCoordsToPixelCoords_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        std::vector< ::DBus::Struct< double, double > > argin3; ri >> argin3;
        std::vector< ::DBus::Struct< uint16_t, uint16_t > > argout1 = ConvertGeoCoordsToPixelCoords(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _DisplayCustomElements_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        std::vector< ::DBus::Struct< std::string, std::string, ::DBus::Struct< double, double >, ::DBus::Struct< int16_t, int16_t > > > argin3; ri >> argin3;
        std::vector< uint32_t > argout1 = DisplayCustomElements(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _HideCustomElements_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        std::vector< uint32_t > argin3; ri >> argin3;
        HideCustomElements(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetDisplayedCustomElements_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        std::map< uint32_t, ::DBus::Struct< std::string, std::string, ::DBus::Struct< double, double >, ::DBus::Struct< int16_t, int16_t > > > argout1 = GetDisplayedCustomElements(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _SelectElementsOnMap_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        ::DBus::Struct< uint16_t, uint16_t > argin2; ri >> argin2;
        std::vector< int32_t > argin3; ri >> argin3;
        uint16_t argin4; ri >> argin4;
        std::vector< ::DBus::Struct< int32_t, ::DBus::Struct< double, double >, ::DBus::Struct< uint8_t, ::DBus::Variant > > > argout1 = SelectElementsOnMap(argin1, argin2, argin3, argin4);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
};

} } }
#endif //__dbusxx__genivi_mapviewer_adaptor_h__ADAPTOR_MARSHAL_H
