/*
 * Video On Demand Samples
 *
 * Copyright (C) 2015 Microchip Technology Germany II GmbH & Co. KG
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You may also obtain this software under a propriety license from Microchip.
 * Please contact Microchip for further information.
 *
 */

/*----------------------------------------------------------*/
/*! \file                                                   */
/*! \brief   Base Board initialisation                      */
/*----------------------------------------------------------*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include "Board.h"
#include "Console.h"

uint32_t GetTickCount( void )
{
    struct timespec currentTime;
    if (clock_gettime(CLOCK_MONOTONIC_RAW, &currentTime))
    {
        ConsolePrintf( PRIO_ERROR, RED"GetTickCount failed!!"RESETCOLOR"\n" );
        return 0;
    }
    return ( currentTime.tv_sec * 1000 ) + ( currentTime.tv_nsec / 1000000 );
}

uint16_t GetTickCountWord()
{
    return ( uint16_t )( GetTickCount() & UINT16_MAX );
}
