/*
 * fetch.h - cve-check-tool helpers
 *
 * Copyright (C) 2015 Intel Corporation
 *
 * cve-check-tool is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#pragma once

#include <stdbool.h>

typedef enum {
        FETCH_STATUS_FAIL,
        FETCH_STATUS_UPDATE,
        FETCH_STATUS_OK
} FetchStatus;

/**
 * Fetch the given URI to the target directory, only if it is newer than
 * its counterpart on disk, or the counterpart does not yet exist.
 *
 * @param uri URI to fetch
 * @param target Target filename
 * @param verbose Whether to be verbose
 * @return A FetchStatus, indicating the operation taken
 */
FetchStatus fetch_uri(const char *uri, const char *target, bool verbose);

/**
 * Attempt to extract the given gzipped file
 *
 * @param filename Path to file
 * @return a boolean value, indicating success of the operation
 */
bool gunzip_file(const char *path);

/*
 * Editor modelines  -  https://www.wireshark.org/tools/modelines.html
 *
 * Local variables:
 * c-basic-offset: 8
 * tab-width: 8
 * indent-tabs-mode: nil
 * End:
 *
 * vi: set shiftwidth=8 tabstop=8 expandtab:
 * :indentSize=8:tabSize=8:noTabs=true:
 */
