/*
 * eopkg.h
 *
 * Copyright (C) 2015 Intel Corporation
 *
 * cve-check-tool is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#pragma once

#include "cve-check-tool.h"

/**
 * Inspect an Solus Operating System pspec.xml file (eopkg packaging)
 *
 * @param filename Path to the pspec.xml file
 * @return a struct source_package_t if successful, otherwise NULL
 */
struct source_package_t *eopkg_inspect_pspec(const char *filename);

bool eopkg_is_patched(struct source_package_t *pkg, char *id);
bool eopkg_is_ignored(struct source_package_t *pkg, char *id);

void eopkg_locate_sources(const char *directory, bool recurse, cve_add_callback cb);

bool eopkg_is_package(const char *filename);

/*
 * Editor modelines  -  https://www.wireshark.org/tools/modelines.html
 *
 * Local variables:
 * c-basic-offset: 8
 * tab-width: 8
 * indent-tabs-mode: nil
 * End:
 *
 * vi: set shiftwidth=8 tabstop=8 expandtab:
 * :indentSize=8:tabSize=8:noTabs=true:
 */
