/*
 * GPS Navigation ---An open source GPS navigation core software
 *
 *
 * Copyright (c) 2016  Aisin AW, Ltd
 *
 * This program is dual licensed under GPL version 2 or a commercial license.
 * See the LICENSE file distributed with this source file.
 */
/*
 *	This file was first automatically generated by dbusxx-xml2cpp;
 *  Then, some conflicting names had to be manually modified
 *  Example: all the GetVersion() methods
 */

#ifndef __dbusxx__genivi_navigationcore_adaptor_h__ADAPTOR_MARSHAL_H
#define __dbusxx__genivi_navigationcore_adaptor_h__ADAPTOR_MARSHAL_H

#include <dbus-c++/dbus.h>
#include <cassert>

namespace org {
namespace genivi {
namespace navigationcore {

class Session_adaptor
: public ::DBus::InterfaceAdaptor
{
public:

    Session_adaptor()
    : ::DBus::InterfaceAdaptor("org.genivi.navigationcore.Session")
    {
        register_method(Session_adaptor, GetVersion, _GetVersion_stub);
        register_method(Session_adaptor, CreateSession, _CreateSession_stub);
        register_method(Session_adaptor, DeleteSession, _DeleteSession_stub);
        register_method(Session_adaptor, GetSessionStatus, _GetSessionStatus_stub);
        register_method(Session_adaptor, GetAllSessions, _GetAllSessions_stub);
    }

    ::DBus::IntrospectedInterface *introspect() const
    {
        static ::DBus::IntrospectedArgument GetVersion_args[] =
        {
            { "version", "(qqqs)", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument CreateSession_args[] =
        {
            { "client", "s", true },
            { "sessionHandle", "u", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument DeleteSession_args[] =
        {
            { "sessionHandle", "u", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetSessionStatus_args[] =
        {
            { "sessionHandle", "u", true },
            { "sessionStatus", "i", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetAllSessions_args[] =
        {
            { "sessionsList", "a(us)", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SessionDeleted_args[] =
        {
            { "sessionHandle", "u", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedMethod Session_adaptor_methods[] =
        {
            { "GetVersion", GetVersion_args },
            { "CreateSession", CreateSession_args },
            { "DeleteSession", DeleteSession_args },
            { "GetSessionStatus", GetSessionStatus_args },
            { "GetAllSessions", GetAllSessions_args },
            { 0, 0 }
        };
        static ::DBus::IntrospectedMethod Session_adaptor_signals[] =
        {
            { "SessionDeleted", SessionDeleted_args },
            { 0, 0 }
        };
        static ::DBus::IntrospectedProperty Session_adaptor_properties[] =
        {
            { 0, 0, 0, 0 }
        };
        static ::DBus::IntrospectedInterface Session_adaptor_interface =
        {
            "org.genivi.navigationcore.Session",
            Session_adaptor_methods,
            Session_adaptor_signals,
            Session_adaptor_properties
        };
        return &Session_adaptor_interface;
    }

public:

    /* properties exposed by this interface, use
     * property() and property(value) to get and set a particular property
     */

public:

    /* methods exported by this interface,
     * you will have to implement them in your ObjectAdaptor
     */
    virtual ::DBus::Struct< uint16_t, uint16_t, uint16_t, std::string > SessionGetVersion() = 0; // Manual change
    virtual uint32_t CreateSession(const std::string& client) = 0;
    virtual void DeleteSession(const uint32_t& sessionHandle) = 0;
    virtual int32_t GetSessionStatus(const uint32_t& sessionHandle) = 0;
    virtual std::vector< ::DBus::Struct< uint32_t, std::string > > GetAllSessions() = 0;

public:

    /* signal emitters for this interface
     */
    void SessionDeleted(const uint32_t& arg1)
    {
        ::DBus::SignalMessage sig("SessionDeleted");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        emit_signal(sig);
    }

private:

    /* unmarshalers (to unpack the DBus message before calling the actual interface method)
     */
    ::DBus::Message _GetVersion_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        ::DBus::Struct< uint16_t, uint16_t, uint16_t, std::string > argout1 = SessionGetVersion(); // Manual change
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _CreateSession_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        std::string argin1; ri >> argin1;
        uint32_t argout1 = CreateSession(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _DeleteSession_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        DeleteSession(argin1);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetSessionStatus_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        int32_t argout1 = GetSessionStatus(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _GetAllSessions_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        std::vector< ::DBus::Struct< uint32_t, std::string > > argout1 = GetAllSessions();
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
};

} } }
namespace org {
namespace genivi {
namespace navigationcore {

class Routing_adaptor
: public ::DBus::InterfaceAdaptor
{
public:

    Routing_adaptor()
    : ::DBus::InterfaceAdaptor("org.genivi.navigationcore.Routing")
    {
        register_method(Routing_adaptor, GetVersion, _GetVersion_stub);
        register_method(Routing_adaptor, CreateRoute, _CreateRoute_stub);
        register_method(Routing_adaptor, DeleteRoute, _DeleteRoute_stub);
        register_method(Routing_adaptor, SetCostModel, _SetCostModel_stub);
        register_method(Routing_adaptor, GetCostModel, _GetCostModel_stub);
        register_method(Routing_adaptor, GetSupportedCostModels, _GetSupportedCostModels_stub);
        register_method(Routing_adaptor, SetRoutePreferences, _SetRoutePreferences_stub);
        register_method(Routing_adaptor, GetRoutePreferences, _GetRoutePreferences_stub);
        register_method(Routing_adaptor, GetSupportedRoutePreferences, _GetSupportedRoutePreferences_stub);
        register_method(Routing_adaptor, SetRouteSchedule, _SetRouteSchedule_stub);
        register_method(Routing_adaptor, GetRouteSchedule, _GetRouteSchedule_stub);
        register_method(Routing_adaptor, SetTransportationMeans, _SetTransportationMeans_stub);
        register_method(Routing_adaptor, GetTransportationMeans, _GetTransportationMeans_stub);
        register_method(Routing_adaptor, GetSupportedTransportationMeans, _GetSupportedTransportationMeans_stub);
        register_method(Routing_adaptor, SetExcludedAreas, _SetExcludedAreas_stub);
        register_method(Routing_adaptor, GetExcludedAreas, _GetExcludedAreas_stub);
        register_method(Routing_adaptor, SetWaypoints, _SetWaypoints_stub);
        register_method(Routing_adaptor, GetWaypoints, _GetWaypoints_stub);
        register_method(Routing_adaptor, CalculateRoute, _CalculateRoute_stub);
        register_method(Routing_adaptor, CancelRouteCalculation, _CancelRouteCalculation_stub);
        register_method(Routing_adaptor, CalculateRoutes, _CalculateRoutes_stub);
        register_method(Routing_adaptor, GetRouteSegments, _GetRouteSegments_stub);
        register_method(Routing_adaptor, GetRouteOverview, _GetRouteOverview_stub);
        register_method(Routing_adaptor, GetRouteBoundingBox, _GetRouteBoundingBox_stub);
        register_method(Routing_adaptor, GetAllRoutes, _GetAllRoutes_stub);
        register_method(Routing_adaptor, SetBlockedRouteStretches, _SetBlockedRouteStretches_stub);
        register_method(Routing_adaptor, GetBlockedRouteStretches, _GetBlockedRouteStretches_stub);
    }

    ::DBus::IntrospectedInterface *introspect() const
    {
        static ::DBus::IntrospectedArgument GetVersion_args[] =
        {
            { "version", "(qqqs)", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument CreateRoute_args[] =
        {
            { "sessionHandle", "u", true },
            { "routeHandle", "u", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument DeleteRoute_args[] =
        {
            { "sessionHandle", "u", true },
            { "routeHandle", "u", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetCostModel_args[] =
        {
            { "sessionHandle", "u", true },
            { "routeHandle", "u", true },
            { "costModel", "i", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetCostModel_args[] =
        {
            { "routeHandle", "u", true },
            { "costModel", "i", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetSupportedCostModels_args[] =
        {
            { "costModelsList", "ai", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetRoutePreferences_args[] =
        {
            { "sessionHandle", "u", true },
            { "routeHandle", "u", true },
            { "countryCode", "s", true },
            { "roadPreferenceList", "a(ii)", true },
            { "conditionPreferenceList", "a(ii)", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetRoutePreferences_args[] =
        {
            { "routeHandle", "u", true },
            { "countryCode", "s", true },
            { "roadPreferenceList", "a(ii)", false },
            { "conditionPreferenceList", "a(ii)", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetSupportedRoutePreferences_args[] =
        {
            { "routePreferencesList", "a(ii)", false },
            { "conditionPreferenceList", "a(ii)", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetRouteSchedule_args[] =
        {
            { "sessionHandle", "u", true },
            { "routeHandle", "u", true },
            { "routeSchedule", "a{iu}", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetRouteSchedule_args[] =
        {
            { "routeHandle", "u", true },
            { "valuesToReturn", "ai", true },
            { "routeSchedule", "a{iu}", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetTransportationMeans_args[] =
        {
            { "sessionHandle", "u", true },
            { "routeHandle", "u", true },
            { "transportationMeansList", "ai", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetTransportationMeans_args[] =
        {
            { "routeHandle", "u", true },
            { "transportationMeansList", "ai", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetSupportedTransportationMeans_args[] =
        {
            { "transportationMeansList", "ai", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetExcludedAreas_args[] =
        {
            { "sessionHandle", "u", true },
            { "routeHandle", "u", true },
            { "excludedAreas", "aa(dd)", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetExcludedAreas_args[] =
        {
            { "routeHandle", "u", true },
            { "excludedAreas", "aa(dd)", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetWaypoints_args[] =
        {
            { "sessionHandle", "u", true },
            { "routeHandle", "u", true },
            { "startFromCurrentPosition", "b", true },
            { "waypointsList", "aa{i(yv)}", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetWaypoints_args[] =
        {
            { "routeHandle", "u", true },
            { "startFromCurrentPosition", "b", false },
            { "waypointsList", "aa{i(yv)}", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument CalculateRoute_args[] =
        {
            { "sessionHandle", "u", true },
            { "routeHandle", "u", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument CancelRouteCalculation_args[] =
        {
            { "sessionHandle", "u", true },
            { "routeHandle", "u", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument CalculateRoutes_args[] =
        {
            { "sessionHandle", "u", true },
            { "calculatedRoutesList", "au", true },
            { "alternativeRoutesList", "au", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetRouteSegments_args[] =
        {
            { "routeHandle", "u", true },
            { "detailLevel", "n", true },
            { "valuesToReturn", "ai", true },
            { "numberOfSegments", "u", true },
            { "offset", "u", true },
            { "totalNumberOfSegments", "u", false },
            { "routeSegments", "aa{i(yv)}", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetRouteOverview_args[] =
        {
            { "routeHandle", "u", true },
            { "valuesToReturn", "ai", true },
            { "routeOverview", "a{i(yv)}", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetRouteBoundingBox_args[] =
        {
            { "routeHandle", "u", true },
            { "boundingBox", "((dd)(dd))", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetAllRoutes_args[] =
        {
            { "routesList", "au", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetBlockedRouteStretches_args[] =
        {
            { "sessionHandle", "u", true },
            { "routeHandle", "u", true },
            { "blockParameters", "a(uu)", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetBlockedRouteStretches_args[] =
        {
            { "routeHandle", "u", true },
            { "blockParameters", "a(uu)", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument RouteDeleted_args[] =
        {
            { "routeHandle", "u", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument RouteCalculationCancelled_args[] =
        {
            { "routeHandle", "u", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument RouteCalculationSuccessful_args[] =
        {
            { "routeHandle", "u", false },
            { "unfullfilledPreferences", "a{ii}", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument RouteCalculationFailed_args[] =
        {
            { "routeHandle", "u", false },
            { "errorCode", "i", false },
            { "unfullfilledPreferences", "a{ii}", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument RouteCalculationProgressUpdate_args[] =
        {
            { "routeHandle", "u", false },
            { "status", "i", false },
            { "percentage", "y", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument AlternativeRoutesAvailable_args[] =
        {
            { "routeHandlesList", "au", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedMethod Routing_adaptor_methods[] =
        {
            { "GetVersion", GetVersion_args },
            { "CreateRoute", CreateRoute_args },
            { "DeleteRoute", DeleteRoute_args },
            { "SetCostModel", SetCostModel_args },
            { "GetCostModel", GetCostModel_args },
            { "GetSupportedCostModels", GetSupportedCostModels_args },
            { "SetRoutePreferences", SetRoutePreferences_args },
            { "GetRoutePreferences", GetRoutePreferences_args },
            { "GetSupportedRoutePreferences", GetSupportedRoutePreferences_args },
            { "SetRouteSchedule", SetRouteSchedule_args },
            { "GetRouteSchedule", GetRouteSchedule_args },
            { "SetTransportationMeans", SetTransportationMeans_args },
            { "GetTransportationMeans", GetTransportationMeans_args },
            { "GetSupportedTransportationMeans", GetSupportedTransportationMeans_args },
            { "SetExcludedAreas", SetExcludedAreas_args },
            { "GetExcludedAreas", GetExcludedAreas_args },
            { "SetWaypoints", SetWaypoints_args },
            { "GetWaypoints", GetWaypoints_args },
            { "CalculateRoute", CalculateRoute_args },
            { "CancelRouteCalculation", CancelRouteCalculation_args },
            { "CalculateRoutes", CalculateRoutes_args },
            { "GetRouteSegments", GetRouteSegments_args },
            { "GetRouteOverview", GetRouteOverview_args },
            { "GetRouteBoundingBox", GetRouteBoundingBox_args },
            { "GetAllRoutes", GetAllRoutes_args },
            { "SetBlockedRouteStretches", SetBlockedRouteStretches_args },
            { "GetBlockedRouteStretches", GetBlockedRouteStretches_args },
            { 0, 0 }
        };
        static ::DBus::IntrospectedMethod Routing_adaptor_signals[] =
        {
            { "RouteDeleted", RouteDeleted_args },
            { "RouteCalculationCancelled", RouteCalculationCancelled_args },
            { "RouteCalculationSuccessful", RouteCalculationSuccessful_args },
            { "RouteCalculationFailed", RouteCalculationFailed_args },
            { "RouteCalculationProgressUpdate", RouteCalculationProgressUpdate_args },
            { "AlternativeRoutesAvailable", AlternativeRoutesAvailable_args },
            { 0, 0 }
        };
        static ::DBus::IntrospectedProperty Routing_adaptor_properties[] =
        {
            { 0, 0, 0, 0 }
        };
        static ::DBus::IntrospectedInterface Routing_adaptor_interface =
        {
            "org.genivi.navigationcore.Routing",
            Routing_adaptor_methods,
            Routing_adaptor_signals,
            Routing_adaptor_properties
        };
        return &Routing_adaptor_interface;
    }

public:

    /* properties exposed by this interface, use
     * property() and property(value) to get and set a particular property
     */

public:

    /* methods exported by this interface,
     * you will have to implement them in your ObjectAdaptor
     */
    virtual ::DBus::Struct< uint16_t, uint16_t, uint16_t, std::string > RoutingGetVersion() = 0; // Manual change
    virtual uint32_t CreateRoute(const uint32_t& sessionHandle) = 0;
    virtual void DeleteRoute(const uint32_t& sessionHandle, const uint32_t& routeHandle) = 0;
    virtual void SetCostModel(const uint32_t& sessionHandle, const uint32_t& routeHandle, const int32_t& costModel) = 0;
    virtual int32_t GetCostModel(const uint32_t& routeHandle) = 0;
    virtual std::vector< int32_t > GetSupportedCostModels() = 0;
    virtual void SetRoutePreferences(const uint32_t& sessionHandle, const uint32_t& routeHandle, const std::string& countryCode, const std::vector< ::DBus::Struct< int32_t, int32_t > >& roadPreferenceList, const std::vector< ::DBus::Struct< int32_t, int32_t > >& conditionPreferenceList) = 0;
    virtual void GetRoutePreferences(const uint32_t& routeHandle, const std::string& countryCode, std::vector< ::DBus::Struct< int32_t, int32_t > >& roadPreferenceList, std::vector< ::DBus::Struct< int32_t, int32_t > >& conditionPreferenceList) = 0;
    virtual void GetSupportedRoutePreferences(std::vector< ::DBus::Struct< int32_t, int32_t > >& routePreferencesList, std::vector< ::DBus::Struct< int32_t, int32_t > >& conditionPreferenceList) = 0;
    virtual void SetRouteSchedule(const uint32_t& sessionHandle, const uint32_t& routeHandle, const std::map< int32_t, uint32_t >& routeSchedule) = 0;
    virtual std::map< int32_t, uint32_t > GetRouteSchedule(const uint32_t& routeHandle, const std::vector< int32_t >& valuesToReturn) = 0;
    virtual void SetTransportationMeans(const uint32_t& sessionHandle, const uint32_t& routeHandle, const std::vector< int32_t >& transportationMeansList) = 0;
    virtual std::vector< int32_t > GetTransportationMeans(const uint32_t& routeHandle) = 0;
    virtual std::vector< int32_t > GetSupportedTransportationMeans() = 0;
    virtual void SetExcludedAreas(const uint32_t& sessionHandle, const uint32_t& routeHandle, const std::vector< std::vector< ::DBus::Struct< double, double > > >& excludedAreas) = 0;
    virtual std::vector< std::vector< ::DBus::Struct< double, double > > > GetExcludedAreas(const uint32_t& routeHandle) = 0;
    virtual void SetWaypoints(const uint32_t& sessionHandle, const uint32_t& routeHandle, const bool& startFromCurrentPosition, const std::vector< std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > > >& waypointsList) = 0;
    virtual void GetWaypoints(const uint32_t& routeHandle, bool& startFromCurrentPosition, std::vector< std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > > >& waypointsList) = 0;
    virtual void CalculateRoute(const uint32_t& sessionHandle, const uint32_t& routeHandle) = 0;
    virtual void CancelRouteCalculation(const uint32_t& sessionHandle, const uint32_t& routeHandle) = 0;
    virtual std::vector< uint32_t > CalculateRoutes(const uint32_t& sessionHandle, const std::vector< uint32_t >& calculatedRoutesList) = 0;
    virtual void GetRouteSegments(const uint32_t& routeHandle, const int16_t& detailLevel, const std::vector< int32_t >& valuesToReturn, const uint32_t& numberOfSegments, const uint32_t& offset, uint32_t& totalNumberOfSegments, std::vector< std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > > >& routeSegments) = 0;
    virtual std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > > GetRouteOverview(const uint32_t& routeHandle, const std::vector< int32_t >& valuesToReturn) = 0;
    virtual ::DBus::Struct< ::DBus::Struct< double, double >, ::DBus::Struct< double, double > > GetRouteBoundingBox(const uint32_t& routeHandle) = 0;
    virtual std::vector< uint32_t > GetAllRoutes() = 0;
    virtual void SetBlockedRouteStretches(const uint32_t& sessionHandle, const uint32_t& routeHandle, const std::vector< ::DBus::Struct< uint32_t, uint32_t > >& blockParameters) = 0;
    virtual std::vector< ::DBus::Struct< uint32_t, uint32_t > > GetBlockedRouteStretches(const uint32_t& routeHandle) = 0;

public:

    /* signal emitters for this interface
     */
    void RouteDeleted(const uint32_t& arg1)
    {
        ::DBus::SignalMessage sig("RouteDeleted");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        emit_signal(sig);
    }
    void RouteCalculationCancelled(const uint32_t& arg1)
    {
        ::DBus::SignalMessage sig("RouteCalculationCancelled");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        emit_signal(sig);
    }
    void RouteCalculationSuccessful(const uint32_t& arg1, const std::map< int32_t, int32_t >& arg2)
    {
        ::DBus::SignalMessage sig("RouteCalculationSuccessful");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        wi << arg2;
        emit_signal(sig);
    }
    void RouteCalculationFailed(const uint32_t& arg1, const int32_t& arg2, const std::map< int32_t, int32_t >& arg3)
    {
        ::DBus::SignalMessage sig("RouteCalculationFailed");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        wi << arg2;
        wi << arg3;
        emit_signal(sig);
    }
    void RouteCalculationProgressUpdate(const uint32_t& arg1, const int32_t& arg2, const uint8_t& arg3)
    {
        ::DBus::SignalMessage sig("RouteCalculationProgressUpdate");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        wi << arg2;
        wi << arg3;
        emit_signal(sig);
    }
    void AlternativeRoutesAvailable(const std::vector< uint32_t >& arg1)
    {
        ::DBus::SignalMessage sig("AlternativeRoutesAvailable");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        emit_signal(sig);
    }

private:

    /* unmarshalers (to unpack the DBus message before calling the actual interface method)
     */
    ::DBus::Message _GetVersion_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        ::DBus::Struct< uint16_t, uint16_t, uint16_t, std::string > argout1 = RoutingGetVersion(); // Manual change
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _CreateRoute_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argout1 = CreateRoute(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _DeleteRoute_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        DeleteRoute(argin1, argin2);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _SetCostModel_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        int32_t argin3; ri >> argin3;
        SetCostModel(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetCostModel_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        int32_t argout1 = GetCostModel(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _GetSupportedCostModels_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        std::vector< int32_t > argout1 = GetSupportedCostModels();
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _SetRoutePreferences_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        std::string argin3; ri >> argin3;
        std::vector< ::DBus::Struct< int32_t, int32_t > > argin4; ri >> argin4;
        std::vector< ::DBus::Struct< int32_t, int32_t > > argin5; ri >> argin5;
        SetRoutePreferences(argin1, argin2, argin3, argin4, argin5);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetRoutePreferences_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        std::string argin2; ri >> argin2;
        std::vector< ::DBus::Struct< int32_t, int32_t > > argout1;
        std::vector< ::DBus::Struct< int32_t, int32_t > > argout2;
        GetRoutePreferences(argin1, argin2, argout1, argout2);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        wi << argout2;
        return reply;
    }
    ::DBus::Message _GetSupportedRoutePreferences_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        std::vector< ::DBus::Struct< int32_t, int32_t > > argout1;
        std::vector< ::DBus::Struct< int32_t, int32_t > > argout2;
        GetSupportedRoutePreferences(argout1, argout2);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        wi << argout2;
        return reply;
    }
    ::DBus::Message _SetRouteSchedule_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        std::map< int32_t, uint32_t > argin3; ri >> argin3;
        SetRouteSchedule(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetRouteSchedule_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        std::vector< int32_t > argin2; ri >> argin2;
        std::map< int32_t, uint32_t > argout1 = GetRouteSchedule(argin1, argin2);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _SetTransportationMeans_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        std::vector< int32_t > argin3; ri >> argin3;
        SetTransportationMeans(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetTransportationMeans_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        std::vector< int32_t > argout1 = GetTransportationMeans(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _GetSupportedTransportationMeans_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        std::vector< int32_t > argout1 = GetSupportedTransportationMeans();
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _SetExcludedAreas_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        std::vector< std::vector< ::DBus::Struct< double, double > > > argin3; ri >> argin3;
        SetExcludedAreas(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetExcludedAreas_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        std::vector< std::vector< ::DBus::Struct< double, double > > > argout1 = GetExcludedAreas(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _SetWaypoints_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        bool argin3; ri >> argin3;
        std::vector< std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > > > argin4; ri >> argin4;
        SetWaypoints(argin1, argin2, argin3, argin4);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetWaypoints_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        bool argout1;
        std::vector< std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > > > argout2;
        GetWaypoints(argin1, argout1, argout2);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        wi << argout2;
        return reply;
    }
    ::DBus::Message _CalculateRoute_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        CalculateRoute(argin1, argin2);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _CancelRouteCalculation_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        CancelRouteCalculation(argin1, argin2);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _CalculateRoutes_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        std::vector< uint32_t > argin2; ri >> argin2;
        std::vector< uint32_t > argout1 = CalculateRoutes(argin1, argin2);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _GetRouteSegments_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        int16_t argin2; ri >> argin2;
        std::vector< int32_t > argin3; ri >> argin3;
        uint32_t argin4; ri >> argin4;
        uint32_t argin5; ri >> argin5;
        uint32_t argout1;
        std::vector< std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > > > argout2;
        GetRouteSegments(argin1, argin2, argin3, argin4, argin5, argout1, argout2);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        wi << argout2;
        return reply;
    }
    ::DBus::Message _GetRouteOverview_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        std::vector< int32_t > argin2; ri >> argin2;
        std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > > argout1 = GetRouteOverview(argin1, argin2);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _GetRouteBoundingBox_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        ::DBus::Struct< ::DBus::Struct< double, double >, ::DBus::Struct< double, double > > argout1 = GetRouteBoundingBox(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _GetAllRoutes_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        std::vector< uint32_t > argout1 = GetAllRoutes();
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _SetBlockedRouteStretches_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        std::vector< ::DBus::Struct< uint32_t, uint32_t > > argin3; ri >> argin3;
        SetBlockedRouteStretches(argin1, argin2, argin3);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetBlockedRouteStretches_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        std::vector< ::DBus::Struct< uint32_t, uint32_t > > argout1 = GetBlockedRouteStretches(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
};

} } }
namespace org {
namespace genivi {
namespace navigationcore {

class MapMatchedPosition_adaptor
: public ::DBus::InterfaceAdaptor
{
public:

    MapMatchedPosition_adaptor()
    : ::DBus::InterfaceAdaptor("org.genivi.navigationcore.MapMatchedPosition")
    {
        register_method(MapMatchedPosition_adaptor, GetVersion, _GetVersion_stub);
        register_method(MapMatchedPosition_adaptor, SetSimulationMode, _SetSimulationMode_stub);
        register_method(MapMatchedPosition_adaptor, GetSimulationStatus, _GetSimulationStatus_stub);
        register_method(MapMatchedPosition_adaptor, AddSimulationStatusListener, _AddSimulationStatusListener_stub);
        register_method(MapMatchedPosition_adaptor, RemoveSimulationStatusListener, _RemoveSimulationStatusListener_stub);
        register_method(MapMatchedPosition_adaptor, SetSimulationSpeed, _SetSimulationSpeed_stub);
        register_method(MapMatchedPosition_adaptor, GetSimulationSpeed, _GetSimulationSpeed_stub);
        register_method(MapMatchedPosition_adaptor, AddSimulationSpeedListener, _AddSimulationSpeedListener_stub);
        register_method(MapMatchedPosition_adaptor, RemoveSimulationSpeedListener, _RemoveSimulationSpeedListener_stub);
        register_method(MapMatchedPosition_adaptor, StartSimulation, _StartSimulation_stub);
        register_method(MapMatchedPosition_adaptor, PauseSimulation, _PauseSimulation_stub);
        register_method(MapMatchedPosition_adaptor, GetPosition, _GetPosition_stub);
        register_method(MapMatchedPosition_adaptor, SetPosition, _SetPosition_stub);
        register_method(MapMatchedPosition_adaptor, GetAddress, _GetAddress_stub);
        register_method(MapMatchedPosition_adaptor, GetPositionOnSegment, _GetPositionOnSegment_stub);
        register_method(MapMatchedPosition_adaptor, GetStatus, _GetStatus_stub);
    }

    ::DBus::IntrospectedInterface *introspect() const
    {
        static ::DBus::IntrospectedArgument GetVersion_args[] =
        {
            { "version", "(qqqs)", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetSimulationMode_args[] =
        {
            { "sessionHandle", "u", true },
            { "activate", "b", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetSimulationStatus_args[] =
        {
            { "simulationStatus", "i", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument AddSimulationStatusListener_args[] =
        {
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument RemoveSimulationStatusListener_args[] =
        {
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetSimulationSpeed_args[] =
        {
            { "sessionHandle", "u", true },
            { "speedFactor", "y", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetSimulationSpeed_args[] =
        {
            { "speedFactor", "y", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument AddSimulationSpeedListener_args[] =
        {
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument RemoveSimulationSpeedListener_args[] =
        {
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument StartSimulation_args[] =
        {
            { "sessionHandle", "u", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument PauseSimulation_args[] =
        {
            { "sessionHandle", "u", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetPosition_args[] =
        {
            { "valuesToReturn", "ai", true },
            { "position", "a{i(yv)}", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetPosition_args[] =
        {
            { "sessionHandle", "u", true },
            { "position", "a{i(yv)}", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetAddress_args[] =
        {
            { "valuesToReturn", "ai", true },
            { "address", "a{i(yv)}", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetPositionOnSegment_args[] =
        {
            { "valuesToReturn", "ai", true },
            { "positionOnSegment", "a{i(yv)}", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetStatus_args[] =
        {
            { "valuesToReturn", "ai", true },
            { "status", "a{i(yv)}", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SimulationStatusChanged_args[] =
        {
            { "simulationStatus", "i", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SimulationSpeedChanged_args[] =
        {
            { "speedFactor", "y", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument PositionUpdate_args[] =
        {
            { "changedValues", "ai", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument AddressUpdate_args[] =
        {
            { "changedValues", "ai", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument PositionOnSegmentUpdate_args[] =
        {
            { "changedValues", "ai", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument StatusUpdate_args[] =
        {
            { "changedValues", "ai", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument OffRoadPositionChanged_args[] =
        {
            { "distance", "u", false },
            { "direction", "i", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedMethod MapMatchedPosition_adaptor_methods[] =
        {
            { "GetVersion", GetVersion_args },
            { "SetSimulationMode", SetSimulationMode_args },
            { "GetSimulationStatus", GetSimulationStatus_args },
            { "AddSimulationStatusListener", AddSimulationStatusListener_args },
            { "RemoveSimulationStatusListener", RemoveSimulationStatusListener_args },
            { "SetSimulationSpeed", SetSimulationSpeed_args },
            { "GetSimulationSpeed", GetSimulationSpeed_args },
            { "AddSimulationSpeedListener", AddSimulationSpeedListener_args },
            { "RemoveSimulationSpeedListener", RemoveSimulationSpeedListener_args },
            { "StartSimulation", StartSimulation_args },
            { "PauseSimulation", PauseSimulation_args },
            { "GetPosition", GetPosition_args },
            { "SetPosition", SetPosition_args },
            { "GetAddress", GetAddress_args },
            { "GetPositionOnSegment", GetPositionOnSegment_args },
            { "GetStatus", GetStatus_args },
            { 0, 0 }
        };
        static ::DBus::IntrospectedMethod MapMatchedPosition_adaptor_signals[] =
        {
            { "SimulationStatusChanged", SimulationStatusChanged_args },
            { "SimulationSpeedChanged", SimulationSpeedChanged_args },
            { "PositionUpdate", PositionUpdate_args },
            { "AddressUpdate", AddressUpdate_args },
            { "PositionOnSegmentUpdate", PositionOnSegmentUpdate_args },
            { "StatusUpdate", StatusUpdate_args },
            { "OffRoadPositionChanged", OffRoadPositionChanged_args },
            { 0, 0 }
        };
        static ::DBus::IntrospectedProperty MapMatchedPosition_adaptor_properties[] =
        {
            { 0, 0, 0, 0 }
        };
        static ::DBus::IntrospectedInterface MapMatchedPosition_adaptor_interface =
        {
            "org.genivi.navigationcore.MapMatchedPosition",
            MapMatchedPosition_adaptor_methods,
            MapMatchedPosition_adaptor_signals,
            MapMatchedPosition_adaptor_properties
        };
        return &MapMatchedPosition_adaptor_interface;
    }

public:

    /* properties exposed by this interface, use
     * property() and property(value) to get and set a particular property
     */

public:

    /* methods exported by this interface,
     * you will have to implement them in your ObjectAdaptor
     */
    virtual ::DBus::Struct< uint16_t, uint16_t, uint16_t, std::string > PositionGetVersion() = 0; // Manual change
    virtual void SetSimulationMode(const uint32_t& sessionHandle, const bool& activate) = 0;
    virtual int32_t GetSimulationStatus() = 0;
    virtual void AddSimulationStatusListener() = 0;
    virtual void RemoveSimulationStatusListener() = 0;
    virtual void SetSimulationSpeed(const uint32_t& sessionHandle, const uint8_t& speedFactor) = 0;
    virtual uint8_t GetSimulationSpeed() = 0;
    virtual void AddSimulationSpeedListener() = 0;
    virtual void RemoveSimulationSpeedListener() = 0;
    virtual void StartSimulation(const uint32_t& sessionHandle) = 0;
    virtual void PauseSimulation(const uint32_t& sessionHandle) = 0;
    virtual std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > > GetPosition(const std::vector< int32_t >& valuesToReturn) = 0;
    virtual void SetPosition(const uint32_t& sessionHandle, const std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > >& position) = 0;
    virtual std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > > GetAddress(const std::vector< int32_t >& valuesToReturn) = 0;
    virtual std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > > GetPositionOnSegment(const std::vector< int32_t >& valuesToReturn) = 0;
    virtual std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > > GetStatus(const std::vector< int32_t >& valuesToReturn) = 0;

public:

    /* signal emitters for this interface
     */
    void SimulationStatusChanged(const int32_t& arg1)
    {
        ::DBus::SignalMessage sig("SimulationStatusChanged");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        emit_signal(sig);
    }
    void SimulationSpeedChanged(const uint8_t& arg1)
    {
        ::DBus::SignalMessage sig("SimulationSpeedChanged");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        emit_signal(sig);
    }
    void PositionUpdate(const std::vector< int32_t >& arg1)
    {
        ::DBus::SignalMessage sig("PositionUpdate");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        emit_signal(sig);
    }
    void AddressUpdate(const std::vector< int32_t >& arg1)
    {
        ::DBus::SignalMessage sig("AddressUpdate");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        emit_signal(sig);
    }
    void PositionOnSegmentUpdate(const std::vector< int32_t >& arg1)
    {
        ::DBus::SignalMessage sig("PositionOnSegmentUpdate");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        emit_signal(sig);
    }
    void StatusUpdate(const std::vector< int32_t >& arg1)
    {
        ::DBus::SignalMessage sig("StatusUpdate");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        emit_signal(sig);
    }
    void OffRoadPositionChanged(const uint32_t& arg1, const int32_t& arg2)
    {
        ::DBus::SignalMessage sig("OffRoadPositionChanged");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        wi << arg2;
        emit_signal(sig);
    }

private:

    /* unmarshalers (to unpack the DBus message before calling the actual interface method)
     */
    ::DBus::Message _GetVersion_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        ::DBus::Struct< uint16_t, uint16_t, uint16_t, std::string > argout1 = PositionGetVersion(); // Manual change
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _SetSimulationMode_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        bool argin2; ri >> argin2;
        SetSimulationMode(argin1, argin2);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetSimulationStatus_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        int32_t argout1 = GetSimulationStatus();
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _AddSimulationStatusListener_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        AddSimulationStatusListener();
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _RemoveSimulationStatusListener_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        RemoveSimulationStatusListener();
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _SetSimulationSpeed_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint8_t argin2; ri >> argin2;
        SetSimulationSpeed(argin1, argin2);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetSimulationSpeed_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint8_t argout1 = GetSimulationSpeed();
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _AddSimulationSpeedListener_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        AddSimulationSpeedListener();
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _RemoveSimulationSpeedListener_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        RemoveSimulationSpeedListener();
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _StartSimulation_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        StartSimulation(argin1);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _PauseSimulation_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        PauseSimulation(argin1);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetPosition_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        std::vector< int32_t > argin1; ri >> argin1;
        std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > > argout1 = GetPosition(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _SetPosition_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > > argin2; ri >> argin2;
        SetPosition(argin1, argin2);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetAddress_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        std::vector< int32_t > argin1; ri >> argin1;
        std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > > argout1 = GetAddress(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _GetPositionOnSegment_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        std::vector< int32_t > argin1; ri >> argin1;
        std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > > argout1 = GetPositionOnSegment(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _GetStatus_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        std::vector< int32_t > argin1; ri >> argin1;
        std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > > argout1 = GetStatus(argin1);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
};

} } }
namespace org {
namespace genivi {
namespace navigationcore {

class Guidance_adaptor
: public ::DBus::InterfaceAdaptor
{
public:

    Guidance_adaptor()
    : ::DBus::InterfaceAdaptor("org.genivi.navigationcore.Guidance")
    {
        register_method(Guidance_adaptor, GetVersion, _GetVersion_stub);
        register_method(Guidance_adaptor, StartGuidance, _StartGuidance_stub);
        register_method(Guidance_adaptor, StopGuidance, _StopGuidance_stub);
        register_method(Guidance_adaptor, SetVoiceGuidance, _SetVoiceGuidance_stub);
        register_method(Guidance_adaptor, GetGuidanceDetails, _GetGuidanceDetails_stub);
        register_method(Guidance_adaptor, PlayVoiceManeuver, _PlayVoiceManeuver_stub);
        register_method(Guidance_adaptor, GetWaypointInformation, _GetWaypointInformation_stub);
        register_method(Guidance_adaptor, GetDestinationInformation, _GetDestinationInformation_stub);
        register_method(Guidance_adaptor, GetManeuversList, _GetManeuversList_stub);
        register_method(Guidance_adaptor, SetRouteCalculationMode, _SetRouteCalculationMode_stub);
        register_method(Guidance_adaptor, SkipNextManeuver, _SkipNextManeuver_stub);
        register_method(Guidance_adaptor, GetGuidanceStatus, _GetGuidanceStatus_stub);
        register_method(Guidance_adaptor, SetVoiceGuidanceSettings, _SetVoiceGuidanceSettings_stub);
        register_method(Guidance_adaptor, GetVoiceGuidanceSettings, _GetVoiceGuidanceSettings_stub);
    }

    ::DBus::IntrospectedInterface *introspect() const
    {
        static ::DBus::IntrospectedArgument GetVersion_args[] =
        {
            { "version", "(qqqs)", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument StartGuidance_args[] =
        {
            { "sessionHandle", "u", true },
            { "routeHandle", "u", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument StopGuidance_args[] =
        {
            { "sessionHandle", "u", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetVoiceGuidance_args[] =
        {
            { "activate", "b", true },
            { "voice", "s", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetGuidanceDetails_args[] =
        {
            { "voiceGuidance", "b", false },
            { "vehicleOnTheRoad", "b", false },
            { "isDestinationReached", "b", false },
            { "maneuver", "i", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument PlayVoiceManeuver_args[] =
        {
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetWaypointInformation_args[] =
        {
            { "requestedNumberOfWaypoints", "q", true },
            { "numberOfWaypoints", "q", false },
            { "waypointsList", "a(uuiinnbq)", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetDestinationInformation_args[] =
        {
            { "offset", "u", false },
            { "travelTime", "u", false },
            { "direction", "i", false },
            { "side", "i", false },
            { "timeZone", "n", false },
            { "daylightSavingTime", "n", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetManeuversList_args[] =
        {
            { "requestedNumberOfManeuvers", "q", true },
            { "maneuverOffset", "u", true },
            { "numberOfManeuvers", "q", false },
            { "maneuversList", "a(ssqiua(uuiia{i(yv)}))", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetRouteCalculationMode_args[] =
        {
            { "sessionHandle", "u", true },
            { "routeCalculationMode", "i", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SkipNextManeuver_args[] =
        {
            { "sessionHandle", "u", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetGuidanceStatus_args[] =
        {
            { "guidanceStatus", "i", false },
            { "routeHandle", "u", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument SetVoiceGuidanceSettings_args[] =
        {
            { "promptMode", "i", true },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GetVoiceGuidanceSettings_args[] =
        {
            { "promptMode", "i", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument VehicleLeftTheRoadNetwork_args[] =
        {
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument GuidanceStatusChanged_args[] =
        {
            { "guidanceStatus", "i", false },
            { "routeHandle", "u", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument WaypointReached_args[] =
        {
            { "isDestination", "b", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument ManeuverChanged_args[] =
        {
            { "maneuver", "i", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument PositionOnRouteChanged_args[] =
        {
            { "offsetOnRoute", "u", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument VehicleLeftTheRoute_args[] =
        {
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument PositionToRouteChanged_args[] =
        {
            { "distance", "u", false },
            { "direction", "i", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedArgument ActiveRouteChanged_args[] =
        {
            { "changeCause", "i", false },
            { 0, 0, 0 }
        };
        static ::DBus::IntrospectedMethod Guidance_adaptor_methods[] =
        {
            { "GetVersion", GetVersion_args },
            { "StartGuidance", StartGuidance_args },
            { "StopGuidance", StopGuidance_args },
            { "SetVoiceGuidance", SetVoiceGuidance_args },
            { "GetGuidanceDetails", GetGuidanceDetails_args },
            { "PlayVoiceManeuver", PlayVoiceManeuver_args },
            { "GetWaypointInformation", GetWaypointInformation_args },
            { "GetDestinationInformation", GetDestinationInformation_args },
            { "GetManeuversList", GetManeuversList_args },
            { "SetRouteCalculationMode", SetRouteCalculationMode_args },
            { "SkipNextManeuver", SkipNextManeuver_args },
            { "GetGuidanceStatus", GetGuidanceStatus_args },
            { "SetVoiceGuidanceSettings", SetVoiceGuidanceSettings_args },
            { "GetVoiceGuidanceSettings", GetVoiceGuidanceSettings_args },
            { 0, 0 }
        };
        static ::DBus::IntrospectedMethod Guidance_adaptor_signals[] =
        {
            { "VehicleLeftTheRoadNetwork", VehicleLeftTheRoadNetwork_args },
            { "GuidanceStatusChanged", GuidanceStatusChanged_args },
            { "WaypointReached", WaypointReached_args },
            { "ManeuverChanged", ManeuverChanged_args },
            { "PositionOnRouteChanged", PositionOnRouteChanged_args },
            { "VehicleLeftTheRoute", VehicleLeftTheRoute_args },
            { "PositionToRouteChanged", PositionToRouteChanged_args },
            { "ActiveRouteChanged", ActiveRouteChanged_args },
            { 0, 0 }
        };
        static ::DBus::IntrospectedProperty Guidance_adaptor_properties[] =
        {
            { 0, 0, 0, 0 }
        };
        static ::DBus::IntrospectedInterface Guidance_adaptor_interface =
        {
            "org.genivi.navigationcore.Guidance",
            Guidance_adaptor_methods,
            Guidance_adaptor_signals,
            Guidance_adaptor_properties
        };
        return &Guidance_adaptor_interface;
    }

public:

    /* properties exposed by this interface, use
     * property() and property(value) to get and set a particular property
     */

public:

    /* methods exported by this interface,
     * you will have to implement them in your ObjectAdaptor
     */
    virtual ::DBus::Struct< uint16_t, uint16_t, uint16_t, std::string > GuidanceGetVersion() = 0; // Manual change
    virtual void StartGuidance(const uint32_t& sessionHandle, const uint32_t& routeHandle) = 0;
    virtual void StopGuidance(const uint32_t& sessionHandle) = 0;
    virtual void SetVoiceGuidance(const bool& activate, const std::string& voice) = 0;
    virtual void GetGuidanceDetails(bool& voiceGuidance, bool& vehicleOnTheRoad, bool& isDestinationReached, int32_t& maneuver) = 0;
    virtual void PlayVoiceManeuver() = 0;
    virtual void GetWaypointInformation(const uint16_t& requestedNumberOfWaypoints, uint16_t& numberOfWaypoints, std::vector< ::DBus::Struct< uint32_t, uint32_t, int32_t, int32_t, int16_t, int16_t, bool, uint16_t > >& waypointsList) = 0;
    virtual void GetDestinationInformation(uint32_t& offset, uint32_t& travelTime, int32_t& direction, int32_t& side, int16_t& timeZone, int16_t& daylightSavingTime) = 0;
    virtual void GetManeuversList(const uint16_t& requestedNumberOfManeuvers, const uint32_t& maneuverOffset, uint16_t& numberOfManeuvers, std::vector< ::DBus::Struct< std::string, std::string, uint16_t, int32_t, uint32_t, std::vector< ::DBus::Struct< uint32_t, uint32_t, int32_t, int32_t, std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > > > > > >& maneuversList) = 0;
    virtual void SetRouteCalculationMode(const uint32_t& sessionHandle, const int32_t& routeCalculationMode) = 0;
    virtual void SkipNextManeuver(const uint32_t& sessionHandle) = 0;
    virtual void GetGuidanceStatus(int32_t& guidanceStatus, uint32_t& routeHandle) = 0;
    virtual void SetVoiceGuidanceSettings(const int32_t& promptMode) = 0;
    virtual int32_t GetVoiceGuidanceSettings() = 0;

public:

    /* signal emitters for this interface
     */
    void VehicleLeftTheRoadNetwork()
    {
        ::DBus::SignalMessage sig("VehicleLeftTheRoadNetwork");
        emit_signal(sig);
    }
    void GuidanceStatusChanged(const int32_t& arg1, const uint32_t& arg2)
    {
        ::DBus::SignalMessage sig("GuidanceStatusChanged");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        wi << arg2;
        emit_signal(sig);
    }
    void WaypointReached(const bool& arg1)
    {
        ::DBus::SignalMessage sig("WaypointReached");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        emit_signal(sig);
    }
    void ManeuverChanged(const int32_t& arg1)
    {
        ::DBus::SignalMessage sig("ManeuverChanged");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        emit_signal(sig);
    }
    void PositionOnRouteChanged(const uint32_t& arg1)
    {
        ::DBus::SignalMessage sig("PositionOnRouteChanged");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        emit_signal(sig);
    }
    void VehicleLeftTheRoute()
    {
        ::DBus::SignalMessage sig("VehicleLeftTheRoute");
        emit_signal(sig);
    }
    void PositionToRouteChanged(const uint32_t& arg1, const int32_t& arg2)
    {
        ::DBus::SignalMessage sig("PositionToRouteChanged");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        wi << arg2;
        emit_signal(sig);
    }
    void ActiveRouteChanged(const int32_t& arg1)
    {
        ::DBus::SignalMessage sig("ActiveRouteChanged");
        ::DBus::MessageIter wi = sig.writer();
        wi << arg1;
        emit_signal(sig);
    }

private:

    /* unmarshalers (to unpack the DBus message before calling the actual interface method)
     */
    ::DBus::Message _GetVersion_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        ::DBus::Struct< uint16_t, uint16_t, uint16_t, std::string > argout1 = GuidanceGetVersion(); // Manual change
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
    ::DBus::Message _StartGuidance_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        StartGuidance(argin1, argin2);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _StopGuidance_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        StopGuidance(argin1);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _SetVoiceGuidance_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        bool argin1; ri >> argin1;
        std::string argin2; ri >> argin2;
        SetVoiceGuidance(argin1, argin2);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetGuidanceDetails_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        bool argout1;
        bool argout2;
        bool argout3;
        int32_t argout4;
        GetGuidanceDetails(argout1, argout2, argout3, argout4);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        wi << argout2;
        wi << argout3;
        wi << argout4;
        return reply;
    }
    ::DBus::Message _PlayVoiceManeuver_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        PlayVoiceManeuver();
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetWaypointInformation_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint16_t argin1; ri >> argin1;
        uint16_t argout1;
        std::vector< ::DBus::Struct< uint32_t, uint32_t, int32_t, int32_t, int16_t, int16_t, bool, uint16_t > > argout2;
        GetWaypointInformation(argin1, argout1, argout2);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        wi << argout2;
        return reply;
    }
    ::DBus::Message _GetDestinationInformation_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argout1;
        uint32_t argout2;
        int32_t argout3;
        int32_t argout4;
        int16_t argout5;
        int16_t argout6;
        GetDestinationInformation(argout1, argout2, argout3, argout4, argout5, argout6);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        wi << argout2;
        wi << argout3;
        wi << argout4;
        wi << argout5;
        wi << argout6;
        return reply;
    }
    ::DBus::Message _GetManeuversList_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint16_t argin1; ri >> argin1;
        uint32_t argin2; ri >> argin2;
        uint16_t argout1;
        std::vector< ::DBus::Struct< std::string, std::string, uint16_t, int32_t, uint32_t, std::vector< ::DBus::Struct< uint32_t, uint32_t, int32_t, int32_t, std::map< int32_t, ::DBus::Struct< uint8_t, ::DBus::Variant > > > > > > argout2;
        GetManeuversList(argin1, argin2, argout1, argout2);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        wi << argout2;
        return reply;
    }
    ::DBus::Message _SetRouteCalculationMode_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        int32_t argin2; ri >> argin2;
        SetRouteCalculationMode(argin1, argin2);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _SkipNextManeuver_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        uint32_t argin1; ri >> argin1;
        SkipNextManeuver(argin1);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetGuidanceStatus_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        int32_t argout1;
        uint32_t argout2;
        GetGuidanceStatus(argout1, argout2);
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        wi << argout2;
        return reply;
    }
    ::DBus::Message _SetVoiceGuidanceSettings_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        int32_t argin1; ri >> argin1;
        SetVoiceGuidanceSettings(argin1);
        ::DBus::ReturnMessage reply(call);
        return reply;
    }
    ::DBus::Message _GetVoiceGuidanceSettings_stub(const ::DBus::CallMessage &call)
    {
        ::DBus::MessageIter ri = call.reader();

        int32_t argout1 = GetVoiceGuidanceSettings();
        ::DBus::ReturnMessage reply(call);
        ::DBus::MessageIter wi = reply.writer();
        wi << argout1;
        return reply;
    }
};

} } }
#endif //__dbusxx__genivi_navigationcore_adaptor_h__ADAPTOR_MARSHAL_H
