/*
 * plugin-manager.h
 *
 * Copyright (C) 2015 Intel Corporation
 *
 * cve-check-tool is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <stdbool.h>
#include "plugin.h"

/**
 * Initialise the plugin manager, loading all available plugins
 */
void cve_plugin_manager_init(void);

/**
 * Destroy the plugin manager - unloading any loaded plugins
 */
void cve_plugin_manager_destroy(void);


/**
 * Get a plugin with a given name if it exists
 *
 * @param name Name of the plugin to load
 * @return A matching CvePlugin, or NULL if not found
 */
CvePlugin *cve_plugin_get_by_name(const char *name);

/**
 * Get a list of plugins for a given capability
 *
 * @note The allocated list must be freed, but not its contents
 * 
 * @param cap Capibility as exposed via CvePluginType flags
 * @return a list of matching plugins, or NULL
 */
GList *cve_plugin_get_by_cap(int cap);

/*
 * Editor modelines  -  https://www.wireshark.org/tools/modelines.html
 *
 * Local variables:
 * c-basic-offset: 8
 * tab-width: 8
 * indent-tabs-mode: nil
 * End:
 *
 * vi: set shiftwidth=8 tabstop=8 expandtab:
 * :indentSize=8:tabSize=8:noTabs=true:
 */
