/*
 * cli.h - cve-check-tool helpers
 *
 * Copyright (C) 2015 Intel Corporation
 *
 * cve-check-tool is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#define _GNU_SOURCE

#include "config.h"
#include "util.h"
#include "cve-check-tool.h"

#define COL "\x1B["
#define COLOR(x) COL"3"#x"m"

#define C_RESET "\033[0m"
#define C_RED COLOR(1)
#define C_GREEN COLOR(2)
#define C_YELLOW COLOR(3)
#define C_BLUE COLOR(4)
#define C_MAGENTA COLOR(5)
#define C_CYAN COLOR(6)
#define C_WHITE COLOR(7)

/*
 * Editor modelines  -  https://www.wireshark.org/tools/modelines.html
 *
 * Local variables:
 * c-basic-offset: 8
 * tab-width: 8
 * indent-tabs-mode: nil
 * End:
 *
 * vi: set shiftwidth=8 tabstop=8 expandtab:
 * :indentSize=8:tabSize=8:noTabs=true:
 */
