/*
 * rpm.h
 *
 * Copyright (C) 2015 Intel Corporation
 *
 * cve-check-tool is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#pragma once

#include "cve-check-tool.h"

/**
 * Inspect an RPM spec file
 *
 * @param filename Path to the .spec file
 * @return a struct source_package_t if successful, otherwise NULL
 */
struct source_package_t *rpm_inspect_spec(const char *filename);
struct source_package_t *srpm_examine(const char *filename);

/**
 * Inspect a src.rpm
 *
 * @param dir Directory where srpm is expected to be located
 * @param name Package name
 * @param version Package version
 * @param release Package release
 * @return a struct source_package_t if successful, otherwise NULL
 */

struct source_package_t *rpm_inspect_srpm(const char *dir, const char *name,
                                          const char *version, const char *release);

bool srpm_is_patched(struct source_package_t *t, char *id);
bool srpm_is_ignored(struct source_package_t *t, char *id);
bool rpm_is_patched(struct source_package_t *pkg, char *id);
bool rpm_is_ignored(struct source_package_t *pkg, char *id);

void rpm_locate_sources(const char *directory, bool recurse, cve_add_callback cb);
void srpm_locate_sources(const char *directory, bool recurse, cve_add_callback cb);

bool rpm_is_package(const char *filename);
bool srpm_is_package(const char *filename);

/*
 * Editor modelines  -  https://www.wireshark.org/tools/modelines.html
 *
 * Local variables:
 * c-basic-offset: 8
 * tab-width: 8
 * indent-tabs-mode: nil
 * End:
 *
 * vi: set shiftwidth=8 tabstop=8 expandtab:
 * :indentSize=8:tabSize=8:noTabs=true:
 */
