
/*
 *	This file was automatically generated by dbusxx-xml2cpp; DO NOT EDIT!
 */

#ifndef __dbusxx__genivi_mapviewer_proxy_h__PROXY_MARSHAL_H
#define __dbusxx__genivi_mapviewer_proxy_h__PROXY_MARSHAL_H

#include <dbus-c++/dbus.h>
#include <cassert>

namespace org {
namespace genivi {
namespace mapviewer {

class Session_proxy
: public ::DBus::InterfaceProxy
{
public:

    Session_proxy()
    : ::DBus::InterfaceProxy("org.genivi.mapviewer.Session")
    {
        connect_signal(Session_proxy, SessionDeleted, _SessionDeleted_stub);
    }

public:

    /* properties exported by this interface */
public:

    /* methods exported by this interface,
     * this functions will invoke the corresponding methods on the remote objects
     */
    ::DBus::Struct< uint16_t, uint16_t, uint16_t, std::string > SessionGetVersion()
    {
        ::DBus::CallMessage call;
        call.member("GetVersion");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        ::DBus::Struct< uint16_t, uint16_t, uint16_t, std::string > argout;
        ri >> argout;
        return argout;
    }

    uint32_t CreateSession(const std::string& client)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << client;
        call.member("CreateSession");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        uint32_t argout;
        ri >> argout;
        return argout;
    }

    void DeleteSession(const uint32_t& sessionHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        call.member("DeleteSession");
        ::DBus::Message ret = invoke_method (call);
    }

    int32_t GetSessionStatus(const uint32_t& sessionHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        call.member("GetSessionStatus");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        int32_t argout;
        ri >> argout;
        return argout;
    }

    std::vector< ::DBus::Struct< uint32_t, std::string > > GetAllSessions()
    {
        ::DBus::CallMessage call;
        call.member("GetAllSessions");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::vector< ::DBus::Struct< uint32_t, std::string > > argout;
        ri >> argout;
        return argout;
    }


public:

    /* signal handlers for this interface
     */
    virtual void SessionDeleted(const uint32_t& sessionHandle) = 0;

private:

    /* unmarshalers (to unpack the DBus message before calling the actual signal handler)
     */
    void _SessionDeleted_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        uint32_t sessionHandle;
        ri >> sessionHandle;
        SessionDeleted(sessionHandle);
    }
};

} } }
namespace org {
namespace genivi {
namespace mapviewer {

class Configuration_proxy
: public ::DBus::InterfaceProxy
{
public:

    Configuration_proxy()
    : ::DBus::InterfaceProxy("org.genivi.mapviewer.Configuration")
    {
        connect_signal(Configuration_proxy, ConfigurationChanged, _ConfigurationChanged_stub);
    }

public:

    /* properties exported by this interface */
public:

    /* methods exported by this interface,
     * this functions will invoke the corresponding methods on the remote objects
     */
    ::DBus::Struct< uint16_t, uint16_t, uint16_t, std::string > ConfigurationGetVersion()
    {
        ::DBus::CallMessage call;
        call.member("GetVersion");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        ::DBus::Struct< uint16_t, uint16_t, uint16_t, std::string > argout;
        ri >> argout;
        return argout;
    }

    void SetUnitsOfMeasurement(const std::map< int32_t, int32_t >& unitsOfMeasurementList)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << unitsOfMeasurementList;
        call.member("SetUnitsOfMeasurement");
        ::DBus::Message ret = invoke_method (call);
    }

    std::map< int32_t, int32_t > GetUnitsOfMeasurement()
    {
        ::DBus::CallMessage call;
        call.member("GetUnitsOfMeasurement");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::map< int32_t, int32_t > argout;
        ri >> argout;
        return argout;
    }

    std::map< int32_t, std::vector< int32_t > > GetSupportedUnitsOfMeasurement()
    {
        ::DBus::CallMessage call;
        call.member("GetSupportedUnitsOfMeasurement");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::map< int32_t, std::vector< int32_t > > argout;
        ri >> argout;
        return argout;
    }

    void SetTimeFormat(const int32_t& timeFormat)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << timeFormat;
        call.member("SetTimeFormat");
        ::DBus::Message ret = invoke_method (call);
    }

    int32_t GetTimeFormat()
    {
        ::DBus::CallMessage call;
        call.member("GetTimeFormat");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        int32_t argout;
        ri >> argout;
        return argout;
    }

    std::vector< int32_t > GetSupportedTimeFormats()
    {
        ::DBus::CallMessage call;
        call.member("GetSupportedTimeFormats");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::vector< int32_t > argout;
        ri >> argout;
        return argout;
    }

    void SetCoordinatesFormat(const int32_t& coordinatesFormat)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << coordinatesFormat;
        call.member("SetCoordinatesFormat");
        ::DBus::Message ret = invoke_method (call);
    }

    int32_t GetCoordinatesFormat()
    {
        ::DBus::CallMessage call;
        call.member("GetCoordinatesFormat");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        int32_t argout;
        ri >> argout;
        return argout;
    }

    std::vector< int32_t > GetSupportedCoordinatesFormats()
    {
        ::DBus::CallMessage call;
        call.member("GetSupportedCoordinatesFormats");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::vector< int32_t > argout;
        ri >> argout;
        return argout;
    }

    void SetLocale(const std::string& languageCode, const std::string& countryCode, const std::string& scriptCode)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << languageCode;
        wi << countryCode;
        wi << scriptCode;
        call.member("SetLocale");
        ::DBus::Message ret = invoke_method (call);
    }

    void GetLocale(std::string& languageCode, std::string& countryCode, std::string& scriptCode)
    {
        ::DBus::CallMessage call;
        call.member("GetLocale");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        ri >> languageCode;
        ri >> countryCode;
        ri >> scriptCode;
    }

    std::vector< ::DBus::Struct< std::string, std::string, std::string > > GetSupportedLocales()
    {
        ::DBus::CallMessage call;
        call.member("GetSupportedLocales");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::vector< ::DBus::Struct< std::string, std::string, std::string > > argout;
        ri >> argout;
        return argout;
    }


public:

    /* signal handlers for this interface
     */
    virtual void ConfigurationChanged(const std::vector< int32_t >& changedSettings) = 0;

private:

    /* unmarshalers (to unpack the DBus message before calling the actual signal handler)
     */
    void _ConfigurationChanged_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        std::vector< int32_t > changedSettings;
        ri >> changedSettings;
        ConfigurationChanged(changedSettings);
    }
};

} } }
namespace org {
namespace genivi {
namespace mapviewer {

class MapViewerControl_proxy
: public ::DBus::InterfaceProxy
{
public:

    MapViewerControl_proxy()
    : ::DBus::InterfaceProxy("org.genivi.mapviewer.MapViewerControl")
    {
        connect_signal(MapViewerControl_proxy, FollowCarModeChanged, _FollowCarModeChanged_stub);
        connect_signal(MapViewerControl_proxy, CameraPositionChanged, _CameraPositionChanged_stub);
        connect_signal(MapViewerControl_proxy, CameraHeadingChanged, _CameraHeadingChanged_stub);
        connect_signal(MapViewerControl_proxy, CameraTiltAngleChanged, _CameraTiltAngleChanged_stub);
        connect_signal(MapViewerControl_proxy, CameraDistanceFromTargetPointChanged, _CameraDistanceFromTargetPointChanged_stub);
        connect_signal(MapViewerControl_proxy, MapViewScaleChanged, _MapViewScaleChanged_stub);
        connect_signal(MapViewerControl_proxy, MapViewPerspectiveChanged, _MapViewPerspectiveChanged_stub);
        connect_signal(MapViewerControl_proxy, MapViewObjectVisibilityChanged, _MapViewObjectVisibilityChanged_stub);
        connect_signal(MapViewerControl_proxy, MapViewBoundingBoxChanged, _MapViewBoundingBoxChanged_stub);
        connect_signal(MapViewerControl_proxy, MapViewSaveAreaChanged, _MapViewSaveAreaChanged_stub);
        connect_signal(MapViewerControl_proxy, MapViewVisibilityChanged, _MapViewVisibilityChanged_stub);
        connect_signal(MapViewerControl_proxy, MapViewPerformanceLevelChanged, _MapViewPerformanceLevelChanged_stub);
        connect_signal(MapViewerControl_proxy, DisplayedRoutes, _DisplayedRoutes_stub);
        connect_signal(MapViewerControl_proxy, PoiCategoriesVisibilityChanged, _PoiCategoriesVisibilityChanged_stub);
        connect_signal(MapViewerControl_proxy, MapViewThemeChanged, _MapViewThemeChanged_stub);
    }

public:

    /* properties exported by this interface */
public:

    /* methods exported by this interface,
     * this functions will invoke the corresponding methods on the remote objects
     */
    ::DBus::Struct< uint16_t, uint16_t, uint16_t, std::string > MapViewerControlGetVersion()
    {
        ::DBus::CallMessage call;
        call.member("GetVersion");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        ::DBus::Struct< uint16_t, uint16_t, uint16_t, std::string > argout;
        ri >> argout;
        return argout;
    }

    uint32_t CreateMapViewInstance(const uint32_t& sessionHandle, const ::DBus::Struct< uint16_t, uint16_t >& mapViewSize, const int32_t& mapViewType)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewSize;
        wi << mapViewType;
        call.member("CreateMapViewInstance");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        uint32_t argout;
        ri >> argout;
        return argout;
    }

    void ReleaseMapViewInstance(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewInstanceHandle;
        call.member("ReleaseMapViewInstance");
        ::DBus::Message ret = invoke_method (call);
    }

    int32_t GetMapViewType(const uint32_t& mapViewInstanceHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << mapViewInstanceHandle;
        call.member("GetMapViewType");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        int32_t argout;
        ri >> argout;
        return argout;
    }

    std::vector< int32_t > GetSupportedMapViewTypes()
    {
        ::DBus::CallMessage call;
        call.member("GetSupportedMapViewTypes");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::vector< int32_t > argout;
        ri >> argout;
        return argout;
    }

    void SetTargetPoint(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const ::DBus::Struct< double, double, double >& targetPoint)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewInstanceHandle;
        wi << targetPoint;
        call.member("SetTargetPoint");
        ::DBus::Message ret = invoke_method (call);
    }

    ::DBus::Struct< double, double, double > GetTargetPoint(const uint32_t& mapViewInstanceHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << mapViewInstanceHandle;
        call.member("GetTargetPoint");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        ::DBus::Struct< double, double, double > argout;
        ri >> argout;
        return argout;
    }

    void SetFollowCarMode(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const bool& followCarMode)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewInstanceHandle;
        wi << followCarMode;
        call.member("SetFollowCarMode");
        ::DBus::Message ret = invoke_method (call);
    }

    bool GetFollowCarMode(const uint32_t& mapViewInstanceHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << mapViewInstanceHandle;
        call.member("GetFollowCarMode");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        bool argout;
        ri >> argout;
        return argout;
    }

    void SetCameraPosition(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const ::DBus::Struct< double, double, double >& position)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewInstanceHandle;
        wi << position;
        call.member("SetCameraPosition");
        ::DBus::Message ret = invoke_method (call);
    }

    ::DBus::Struct< double, double, double > GetCameraPosition(const uint32_t& mapViewInstanceHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << mapViewInstanceHandle;
        call.member("GetCameraPosition");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        ::DBus::Struct< double, double, double > argout;
        ri >> argout;
        return argout;
    }

    void SetCameraHeadingAngle(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const int32_t& heading)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewInstanceHandle;
        wi << heading;
        call.member("SetCameraHeadingAngle");
        ::DBus::Message ret = invoke_method (call);
    }

    void SetCameraHeadingToTarget(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const ::DBus::Struct< double, double >& target)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewInstanceHandle;
        wi << target;
        call.member("SetCameraHeadingToTarget");
        ::DBus::Message ret = invoke_method (call);
    }

    void SetCameraHeadingTrackUp(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewInstanceHandle;
        call.member("SetCameraHeadingTrackUp");
        ::DBus::Message ret = invoke_method (call);
    }

    void GetCameraHeading(const uint32_t& mapViewInstanceHandle, int32_t& headingType, int32_t& headingAngle, ::DBus::Struct< double, double >& target)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << mapViewInstanceHandle;
        call.member("GetCameraHeading");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        ri >> headingType;
        ri >> headingAngle;
        ri >> target;
    }

    void SetCameraTiltAngle(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const int32_t& tilt)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewInstanceHandle;
        wi << tilt;
        call.member("SetCameraTiltAngle");
        ::DBus::Message ret = invoke_method (call);
    }

    int32_t GetCameraTiltAngle(const uint32_t& mapViewInstanceHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << mapViewInstanceHandle;
        call.member("GetCameraTiltAngle");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        int32_t argout;
        ri >> argout;
        return argout;
    }

    void SetCameraRollAngle(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const int32_t& roll)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewInstanceHandle;
        wi << roll;
        call.member("SetCameraRollAngle");
        ::DBus::Message ret = invoke_method (call);
    }

    int32_t GetCameraRollAngle(const uint32_t& mapViewInstanceHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << mapViewInstanceHandle;
        call.member("GetCameraRollAngle");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        int32_t argout;
        ri >> argout;
        return argout;
    }

    void SetCameraDistanceFromTargetPoint(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const uint32_t& distance)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewInstanceHandle;
        wi << distance;
        call.member("SetCameraDistanceFromTargetPoint");
        ::DBus::Message ret = invoke_method (call);
    }

    uint32_t GetCameraDistanceFromTargetPoint(const uint32_t& mapViewInstanceHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << mapViewInstanceHandle;
        call.member("GetCameraDistanceFromTargetPoint");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        uint32_t argout;
        ri >> argout;
        return argout;
    }

    void SetMapViewScaleMode(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const int32_t& scaleMode)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewInstanceHandle;
        wi << scaleMode;
        call.member("SetMapViewScaleMode");
        ::DBus::Message ret = invoke_method (call);
    }

    int32_t GetMapViewScaleMode(const uint32_t& mapViewInstanceHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << mapViewInstanceHandle;
        call.member("GetMapViewScaleMode");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        int32_t argout;
        ri >> argout;
        return argout;
    }

    std::vector< int32_t > GetSupportedMapViewScaleModes(const uint32_t& mapViewInstanceHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << mapViewInstanceHandle;
        call.member("GetSupportedMapViewScaleModes");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::vector< int32_t > argout;
        ri >> argout;
        return argout;
    }

    void AddMapViewScaleChangedListener()
    {
        ::DBus::CallMessage call;
        call.member("AddMapViewScaleChangedListener");
        ::DBus::Message ret = invoke_method (call);
    }

    void RemoveMapViewScaleChangedListener()
    {
        ::DBus::CallMessage call;
        call.member("RemoveMapViewScaleChangedListener");
        ::DBus::Message ret = invoke_method (call);
    }

    void SetCameraHeight(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const uint32_t& height)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewInstanceHandle;
        wi << height;
        call.member("SetCameraHeight");
        ::DBus::Message ret = invoke_method (call);
    }

    uint32_t GetCameraHeight(const uint32_t& mapViewInstanceHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << mapViewInstanceHandle;
        call.member("GetCameraHeight");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        uint32_t argout;
        ri >> argout;
        return argout;
    }

    void SetMapViewPerspective(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const int32_t& perspective)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewInstanceHandle;
        wi << perspective;
        call.member("SetMapViewPerspective");
        ::DBus::Message ret = invoke_method (call);
    }

    int32_t GetMapViewPerspective(const uint32_t& mapViewInstanceHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << mapViewInstanceHandle;
        call.member("GetMapViewPerspective");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        int32_t argout;
        ri >> argout;
        return argout;
    }

    std::vector< int32_t > GetSupportedMapViewPerspectives()
    {
        ::DBus::CallMessage call;
        call.member("GetSupportedMapViewPerspectives");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::vector< int32_t > argout;
        ri >> argout;
        return argout;
    }

    void SetMapViewObjectVisibility(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const std::map< int32_t, bool >& objectVisibilityList)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewInstanceHandle;
        wi << objectVisibilityList;
        call.member("SetMapViewObjectVisibility");
        ::DBus::Message ret = invoke_method (call);
    }

    std::map< int32_t, bool > GetMapViewObjectVisibility(const uint32_t& mapViewInstanceHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << mapViewInstanceHandle;
        call.member("GetMapViewObjectVisibility");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::map< int32_t, bool > argout;
        ri >> argout;
        return argout;
    }

    std::vector< int32_t > GetSupportedMapViewObjectVisibilities(const uint32_t& mapViewInstanceHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << mapViewInstanceHandle;
        call.member("GetSupportedMapViewObjectVisibilities");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::vector< int32_t > argout;
        ri >> argout;
        return argout;
    }

    std::vector< ::DBus::Struct< uint16_t, uint16_t, int32_t, uint32_t > > GetScaleList(const uint32_t& mapViewInstanceHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << mapViewInstanceHandle;
        call.member("GetScaleList");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::vector< ::DBus::Struct< uint16_t, uint16_t, int32_t, uint32_t > > argout;
        ri >> argout;
        return argout;
    }

    void SetMapViewScale(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const uint16_t& scaleID)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewInstanceHandle;
        wi << scaleID;
        call.member("SetMapViewScale");
        ::DBus::Message ret = invoke_method (call);
    }

    void SetMapViewScaleByDelta(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const int16_t& scaleDelta)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewInstanceHandle;
        wi << scaleDelta;
        call.member("SetMapViewScaleByDelta");
        ::DBus::Message ret = invoke_method (call);
    }

    void SetMapViewScaleByMetersPerPixel(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const double& metersPerPixel)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewInstanceHandle;
        wi << metersPerPixel;
        call.member("SetMapViewScaleByMetersPerPixel");
        ::DBus::Message ret = invoke_method (call);
    }

    void GetMapViewScale(const uint32_t& mapViewInstanceHandle, uint8_t& scaleID, int32_t& isMinMax)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << mapViewInstanceHandle;
        call.member("GetMapViewScale");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        ri >> scaleID;
        ri >> isMinMax;
    }

    void SetMapViewBoundingBox(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const ::DBus::Struct< ::DBus::Struct< double, double >, ::DBus::Struct< double, double > >& boundingBox)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewInstanceHandle;
        wi << boundingBox;
        call.member("SetMapViewBoundingBox");
        ::DBus::Message ret = invoke_method (call);
    }

    ::DBus::Struct< ::DBus::Struct< double, double >, ::DBus::Struct< double, double > > GetMapViewBoundingBox(const uint32_t& mapViewInstanceHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << mapViewInstanceHandle;
        call.member("GetMapViewBoundingBox");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        ::DBus::Struct< ::DBus::Struct< double, double >, ::DBus::Struct< double, double > > argout;
        ri >> argout;
        return argout;
    }

    void SetMapViewSaveArea(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const ::DBus::Struct< double, double, double, double >& saveArea)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewInstanceHandle;
        wi << saveArea;
        call.member("SetMapViewSaveArea");
        ::DBus::Message ret = invoke_method (call);
    }

    ::DBus::Struct< double, double, double, double > GetMapViewSaveArea(const uint32_t& mapViewInstanceHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << mapViewInstanceHandle;
        call.member("GetMapViewSaveArea");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        ::DBus::Struct< double, double, double, double > argout;
        ri >> argout;
        return argout;
    }

    void SetMapViewPan(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const int32_t& panningAction, const std::vector< ::DBus::Struct< uint16_t, uint16_t > >& pixelCoordinates)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewInstanceHandle;
        wi << panningAction;
        wi << pixelCoordinates;
        call.member("SetMapViewPan");
        ::DBus::Message ret = invoke_method (call);
    }

    std::vector< ::DBus::Struct< uint16_t, uint16_t > > GetMapViewPan(const uint32_t& mapViewInstanceHandle, const int32_t& valueToReturn)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << mapViewInstanceHandle;
        wi << valueToReturn;
        call.member("GetMapViewPan");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::vector< ::DBus::Struct< uint16_t, uint16_t > > argout;
        ri >> argout;
        return argout;
    }

    void SetMapViewRotation(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const int32_t& rotationAngle, const int32_t& rotationAnglePerSecond)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewInstanceHandle;
        wi << rotationAngle;
        wi << rotationAnglePerSecond;
        call.member("SetMapViewRotation");
        ::DBus::Message ret = invoke_method (call);
    }

    void GetMapViewRotation(const uint32_t& mapViewInstanceHandle, int32_t& rotationAngle, int32_t& rotationAnglePerFrame)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << mapViewInstanceHandle;
        call.member("GetMapViewRotation");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        ri >> rotationAngle;
        ri >> rotationAnglePerFrame;
    }

    void SetMapViewVisibilityMode(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const int32_t& visibilityMode)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewInstanceHandle;
        wi << visibilityMode;
        call.member("SetMapViewVisibilityMode");
        ::DBus::Message ret = invoke_method (call);
    }

    int32_t GetMapViewVisibilityMode(const uint32_t& mapViewInstanceHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << mapViewInstanceHandle;
        call.member("GetMapViewVisibilityMode");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        int32_t argout;
        ri >> argout;
        return argout;
    }

    std::vector< int32_t > GetSupportedMapViewVisibilityModes()
    {
        ::DBus::CallMessage call;
        call.member("GetSupportedMapViewVisibilityModes");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::vector< int32_t > argout;
        ri >> argout;
        return argout;
    }

    void SetMapViewPerformanceLevel(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const int32_t& performanceLevel)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewInstanceHandle;
        wi << performanceLevel;
        call.member("SetMapViewPerformanceLevel");
        ::DBus::Message ret = invoke_method (call);
    }

    int32_t GetMapViewPerformanceLevel(const uint32_t& mapViewInstanceHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << mapViewInstanceHandle;
        call.member("GetMapViewPerformanceLevel");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        int32_t argout;
        ri >> argout;
        return argout;
    }

    std::vector< int32_t > GetSupportedMapViewPerformanceLevels()
    {
        ::DBus::CallMessage call;
        call.member("GetSupportedMapViewPerformanceLevels");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::vector< int32_t > argout;
        ri >> argout;
        return argout;
    }

    void DisplayRoute(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const uint32_t& routeHandle, const bool& highlighted)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewInstanceHandle;
        wi << routeHandle;
        wi << highlighted;
        call.member("DisplayRoute");
        ::DBus::Message ret = invoke_method (call);
    }

    void HideRoute(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const uint32_t& routeHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewInstanceHandle;
        wi << routeHandle;
        call.member("HideRoute");
        ::DBus::Message ret = invoke_method (call);
    }

    std::vector< ::DBus::Struct< uint32_t, bool > > GetDisplayedRoutes(const uint32_t& mapViewInstanceHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << mapViewInstanceHandle;
        call.member("GetDisplayedRoutes");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::vector< ::DBus::Struct< uint32_t, bool > > argout;
        ri >> argout;
        return argout;
    }

    std::vector< uint32_t > GetPoiCategoriesVisible(const uint32_t& mapViewInstanceHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << mapViewInstanceHandle;
        call.member("GetPoiCategoriesVisible");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::vector< uint32_t > argout;
        ri >> argout;
        return argout;
    }

    void SetPoiCategoriesVisible(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const std::vector< uint32_t >& poiCategoryIds)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewInstanceHandle;
        wi << poiCategoryIds;
        call.member("SetPoiCategoriesVisible");
        ::DBus::Message ret = invoke_method (call);
    }

    void SetPoiCategoriesVisibleWithinLimits(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const std::vector< uint32_t >& poiCategoryIds, const uint8_t& minScaleID, const uint8_t& maxScaleID)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewInstanceHandle;
        wi << poiCategoryIds;
        wi << minScaleID;
        wi << maxScaleID;
        call.member("SetPoiCategoriesVisibleWithinLimits");
        ::DBus::Message ret = invoke_method (call);
    }

    void SetPoiCategoriesNotVisible(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const std::vector< uint32_t >& poiCategoryIds)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewInstanceHandle;
        wi << poiCategoryIds;
        call.member("SetPoiCategoriesNotVisible");
        ::DBus::Message ret = invoke_method (call);
    }

    void SetTrafficIncidentsVisibility(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const bool& visible)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewInstanceHandle;
        wi << visible;
        call.member("SetTrafficIncidentsVisibility");
        ::DBus::Message ret = invoke_method (call);
    }

    void SetMapViewTheme(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const int32_t& mapViewTheme)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewInstanceHandle;
        wi << mapViewTheme;
        call.member("SetMapViewTheme");
        ::DBus::Message ret = invoke_method (call);
    }

    int32_t GetMapViewTheme(const uint32_t& mapViewInstanceHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << mapViewInstanceHandle;
        call.member("GetMapViewTheme");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        int32_t argout;
        ri >> argout;
        return argout;
    }

    std::vector< int32_t > GetSupportedMapViewThemes()
    {
        ::DBus::CallMessage call;
        call.member("GetSupportedMapViewThemes");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::vector< int32_t > argout;
        ri >> argout;
        return argout;
    }

    std::vector< ::DBus::Struct< double, double > > ConvertPixelCoordsToGeoCoords(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const std::vector< ::DBus::Struct< uint16_t, uint16_t > >& pixelCoordinates)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewInstanceHandle;
        wi << pixelCoordinates;
        call.member("ConvertPixelCoordsToGeoCoords");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::vector< ::DBus::Struct< double, double > > argout;
        ri >> argout;
        return argout;
    }

    std::vector< ::DBus::Struct< uint16_t, uint16_t > > ConvertGeoCoordsToPixelCoords(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const std::vector< ::DBus::Struct< double, double > >& geoCoordinates)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewInstanceHandle;
        wi << geoCoordinates;
        call.member("ConvertGeoCoordsToPixelCoords");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::vector< ::DBus::Struct< uint16_t, uint16_t > > argout;
        ri >> argout;
        return argout;
    }

    std::vector< uint32_t > DisplayCustomElements(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const std::vector< ::DBus::Struct< std::string, std::string, ::DBus::Struct< double, double >, ::DBus::Struct< int16_t, int16_t > > >& customElements)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewInstanceHandle;
        wi << customElements;
        call.member("DisplayCustomElements");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::vector< uint32_t > argout;
        ri >> argout;
        return argout;
    }

    void HideCustomElements(const uint32_t& sessionHandle, const uint32_t& mapViewInstanceHandle, const std::vector< uint32_t >& customElementHandles)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << sessionHandle;
        wi << mapViewInstanceHandle;
        wi << customElementHandles;
        call.member("HideCustomElements");
        ::DBus::Message ret = invoke_method (call);
    }

    std::map< uint32_t, ::DBus::Struct< std::string, std::string, ::DBus::Struct< double, double >, ::DBus::Struct< int16_t, int16_t > > > GetDisplayedCustomElements(const uint32_t& mapViewInstanceHandle)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << mapViewInstanceHandle;
        call.member("GetDisplayedCustomElements");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::map< uint32_t, ::DBus::Struct< std::string, std::string, ::DBus::Struct< double, double >, ::DBus::Struct< int16_t, int16_t > > > argout;
        ri >> argout;
        return argout;
    }

    std::vector< ::DBus::Struct< int32_t, ::DBus::Struct< double, double >, ::DBus::Struct< uint8_t, ::DBus::Variant > > > SelectElementsOnMap(const uint32_t& mapViewInstanceHandle, const ::DBus::Struct< uint16_t, uint16_t >& pixelCoordinate, const std::vector< int32_t >& selectableTypes, const uint16_t& maxNumberOfSelectedElements)
    {
        ::DBus::CallMessage call;
        ::DBus::MessageIter wi = call.writer();

        wi << mapViewInstanceHandle;
        wi << pixelCoordinate;
        wi << selectableTypes;
        wi << maxNumberOfSelectedElements;
        call.member("SelectElementsOnMap");
        ::DBus::Message ret = invoke_method (call);
        ::DBus::MessageIter ri = ret.reader();

        std::vector< ::DBus::Struct< int32_t, ::DBus::Struct< double, double >, ::DBus::Struct< uint8_t, ::DBus::Variant > > > argout;
        ri >> argout;
        return argout;
    }


public:

    /* signal handlers for this interface
     */
    virtual void FollowCarModeChanged(const uint32_t& mapViewInstanceHandle, const bool& followCarMode) = 0;
    virtual void CameraPositionChanged(const uint32_t& mapViewInstanceHandle, const ::DBus::Struct< double, double, double >& targetPoint) = 0;
    virtual void CameraHeadingChanged(const uint32_t& mapViewInstanceHandle, const uint16_t& headingType, const int32_t& headingAngle) = 0;
    virtual void CameraTiltAngleChanged(const uint32_t& mapViewInstanceHandle, const int32_t& tilt) = 0;
    virtual void CameraDistanceFromTargetPointChanged(const uint32_t& mapViewInstanceHandle, const uint32_t& distance) = 0;
    virtual void MapViewScaleChanged(const uint32_t& mapViewInstanceHandle, const uint8_t& scaleID, const int32_t& isMinMax) = 0;
    virtual void MapViewPerspectiveChanged(const uint32_t& mapViewInstanceHandle, const uint16_t& perspective) = 0;
    virtual void MapViewObjectVisibilityChanged(const uint32_t& mapViewInstanceHandle, const std::map< int32_t, bool >& objectVisibilityList) = 0;
    virtual void MapViewBoundingBoxChanged(const uint32_t& mapViewInstanceHandle, const ::DBus::Struct< ::DBus::Struct< double, double >, ::DBus::Struct< double, double > >& boundingBox) = 0;
    virtual void MapViewSaveAreaChanged(const uint32_t& mapViewInstanceHandle, const ::DBus::Struct< double, double, double, double >& saveArea) = 0;
    virtual void MapViewVisibilityChanged(const uint32_t& mapViewInstanceHandle, const int32_t& visibilityMode) = 0;
    virtual void MapViewPerformanceLevelChanged(const uint32_t& mapViewInstanceHandle, const int32_t& performanceLevel) = 0;
    virtual void DisplayedRoutes(const uint32_t& mapViewInstanceHandle, const std::vector< ::DBus::Struct< uint32_t, bool > >& displayedRoutes) = 0;
    virtual void PoiCategoriesVisibilityChanged(const uint32_t& mapViewInstanceHandle, const std::vector< uint32_t >& poiCategoryIds, const bool& visible, const uint8_t& minScaleID, const uint8_t& maxScaleID) = 0;
    virtual void MapViewThemeChanged(const uint32_t& mapViewInstanceHandle, const int32_t& mapViewTheme) = 0;

private:

    /* unmarshalers (to unpack the DBus message before calling the actual signal handler)
     */
    void _FollowCarModeChanged_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        uint32_t mapViewInstanceHandle;
        ri >> mapViewInstanceHandle;
        bool followCarMode;
        ri >> followCarMode;
        FollowCarModeChanged(mapViewInstanceHandle, followCarMode);
    }
    void _CameraPositionChanged_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        uint32_t mapViewInstanceHandle;
        ri >> mapViewInstanceHandle;
        ::DBus::Struct< double, double, double > targetPoint;
        ri >> targetPoint;
        CameraPositionChanged(mapViewInstanceHandle, targetPoint);
    }
    void _CameraHeadingChanged_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        uint32_t mapViewInstanceHandle;
        ri >> mapViewInstanceHandle;
        uint16_t headingType;
        ri >> headingType;
        int32_t headingAngle;
        ri >> headingAngle;
        CameraHeadingChanged(mapViewInstanceHandle, headingType, headingAngle);
    }
    void _CameraTiltAngleChanged_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        uint32_t mapViewInstanceHandle;
        ri >> mapViewInstanceHandle;
        int32_t tilt;
        ri >> tilt;
        CameraTiltAngleChanged(mapViewInstanceHandle, tilt);
    }
    void _CameraDistanceFromTargetPointChanged_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        uint32_t mapViewInstanceHandle;
        ri >> mapViewInstanceHandle;
        uint32_t distance;
        ri >> distance;
        CameraDistanceFromTargetPointChanged(mapViewInstanceHandle, distance);
    }
    void _MapViewScaleChanged_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        uint32_t mapViewInstanceHandle;
        ri >> mapViewInstanceHandle;
        uint8_t scaleID;
        ri >> scaleID;
        int32_t isMinMax;
        ri >> isMinMax;
        MapViewScaleChanged(mapViewInstanceHandle, scaleID, isMinMax);
    }
    void _MapViewPerspectiveChanged_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        uint32_t mapViewInstanceHandle;
        ri >> mapViewInstanceHandle;
        uint16_t perspective;
        ri >> perspective;
        MapViewPerspectiveChanged(mapViewInstanceHandle, perspective);
    }
    void _MapViewObjectVisibilityChanged_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        uint32_t mapViewInstanceHandle;
        ri >> mapViewInstanceHandle;
        std::map< int32_t, bool > objectVisibilityList;
        ri >> objectVisibilityList;
        MapViewObjectVisibilityChanged(mapViewInstanceHandle, objectVisibilityList);
    }
    void _MapViewBoundingBoxChanged_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        uint32_t mapViewInstanceHandle;
        ri >> mapViewInstanceHandle;
        ::DBus::Struct< ::DBus::Struct< double, double >, ::DBus::Struct< double, double > > boundingBox;
        ri >> boundingBox;
        MapViewBoundingBoxChanged(mapViewInstanceHandle, boundingBox);
    }
    void _MapViewSaveAreaChanged_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        uint32_t mapViewInstanceHandle;
        ri >> mapViewInstanceHandle;
        ::DBus::Struct< double, double, double, double > saveArea;
        ri >> saveArea;
        MapViewSaveAreaChanged(mapViewInstanceHandle, saveArea);
    }
    void _MapViewVisibilityChanged_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        uint32_t mapViewInstanceHandle;
        ri >> mapViewInstanceHandle;
        int32_t visibilityMode;
        ri >> visibilityMode;
        MapViewVisibilityChanged(mapViewInstanceHandle, visibilityMode);
    }
    void _MapViewPerformanceLevelChanged_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        uint32_t mapViewInstanceHandle;
        ri >> mapViewInstanceHandle;
        int32_t performanceLevel;
        ri >> performanceLevel;
        MapViewPerformanceLevelChanged(mapViewInstanceHandle, performanceLevel);
    }
    void _DisplayedRoutes_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        uint32_t mapViewInstanceHandle;
        ri >> mapViewInstanceHandle;
        std::vector< ::DBus::Struct< uint32_t, bool > > displayedRoutes;
        ri >> displayedRoutes;
        DisplayedRoutes(mapViewInstanceHandle, displayedRoutes);
    }
    void _PoiCategoriesVisibilityChanged_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        uint32_t mapViewInstanceHandle;
        ri >> mapViewInstanceHandle;
        std::vector< uint32_t > poiCategoryIds;
        ri >> poiCategoryIds;
        bool visible;
        ri >> visible;
        uint8_t minScaleID;
        ri >> minScaleID;
        uint8_t maxScaleID;
        ri >> maxScaleID;
        PoiCategoriesVisibilityChanged(mapViewInstanceHandle, poiCategoryIds, visible, minScaleID, maxScaleID);
    }
    void _MapViewThemeChanged_stub(const ::DBus::SignalMessage &sig)
    {
        ::DBus::MessageIter ri = sig.reader();

        uint32_t mapViewInstanceHandle;
        ri >> mapViewInstanceHandle;
        int32_t mapViewTheme;
        ri >> mapViewTheme;
        MapViewThemeChanged(mapViewInstanceHandle, mapViewTheme);
    }
};

} } }
#endif //__dbusxx__genivi_mapviewer_proxy_h__PROXY_MARSHAL_H
