/*
 * arch/arm/cpu/armv7/rmobile/pfc-r8a7792.c
 *     This file is r8a7792 processor support - PFC hardware block.
 *
 * Copyright (C) 2016 Renesas Electronics Corporation
 *
 * SPDX-License-Identifier: GPL-2.0
 */

#include <common.h>
#include <sh_pfc.h>
#include <asm/gpio.h>
#include "pfc-r8a7790.h"

enum {
	PINMUX_RESERVED = 0,

	PINMUX_DATA_BEGIN,
	GP_ALL(DATA),
	PINMUX_DATA_END,

	PINMUX_INPUT_BEGIN,
	GP_ALL(IN),
	PINMUX_INPUT_END,

	PINMUX_OUTPUT_BEGIN,
	GP_ALL(OUT),
	PINMUX_OUTPUT_END,

	PINMUX_FUNCTION_BEGIN,
	GP_ALL(FN),

	/* GPSR0 */
	FN_IP0_0, FN_IP0_1, FN_IP0_2, FN_IP0_3,
	FN_IP0_4, FN_IP0_5, FN_IP0_6, FN_IP0_7,
	FN_IP0_8, FN_IP0_9, FN_IP0_10, FN_IP0_11,
	FN_IP0_12, FN_IP0_13, FN_IP0_14, FN_IP0_15,
	FN_IP0_16, FN_IP0_17, FN_IP0_18, FN_IP0_19,
	FN_IP0_20, FN_IP0_21, FN_IP0_22, FN_IP0_23,
	FN_IP1_0, FN_IP1_1, FN_IP1_2, FN_IP1_3,
	FN_IP1_4,

	/* GPSR1 */
	FN_IP1_5, FN_IP1_6, FN_IP1_7, FN_IP1_8,
	FN_IP1_9, FN_IP1_10, FN_IP1_11, FN_IP1_12,
	FN_IP1_13, FN_IP1_14, FN_IP1_15, FN_IP1_16,
	FN_DU1_DB2_C0_DATA12, FN_DU1_DB3_C1_DATA13, FN_DU1_DB4_C2_DATA14, FN_DU1_DB5_C3_DATA15,
	FN_DU1_DB6_C4, FN_DU1_DB7_C5, FN_DU1_EXHSYNC_DU1_HSYNC, FN_DU1_EXVSYNC_DU1_VSYNC,
	FN_DU1_EXODDF_DU1_ODDF_DISP_CDE, FN_DU1_DISP, FN_DU1_CDE,

	/* GPSR2 */
	FN_D0, FN_D1, FN_D2, FN_D3,
	FN_D4, FN_D5, FN_D6, FN_D7,
	FN_D8, FN_D9, FN_D10, FN_D11,
	FN_D12, FN_D13, FN_D14, FN_D15,
	FN_A0, FN_A1, FN_A2, FN_A3,
	FN_A4, FN_A5, FN_A6, FN_A7,
	FN_A8, FN_A9, FN_A10, FN_A11,
	FN_A12, FN_A13, FN_A14, FN_A15,

	/* GPSR3 */
	FN_A16, FN_A17, FN_A18, FN_A19,
	FN_IP1_17, FN_IP1_18, FN_CS1_A26, FN_EX_CS0,
	FN_EX_CS1, FN_EX_CS2, FN_EX_CS3, FN_EX_CS4,
	FN_EX_CS5, FN_BS, FN_RD, FN_RD_WR,
	FN_WE0, FN_WE1, FN_EX_WAIT0, FN_IRQ0,
	FN_IRQ1, FN_IRQ2, FN_IRQ3, FN_IP1_19,
	FN_IP1_20, FN_IP1_21, FN_IP1_22, FN_CS0,

	/* GPSR4 */
	FN_VI0_CLK, FN_VI0_CLKENB, FN_VI0_HSYNC, FN_VI0_VSYNC,
	FN_VI0_D0_B0_C0, FN_VI0_D1_B1_C1, FN_VI0_D2_B2_C2, FN_VI0_D3_B3_C3,
	FN_VI0_D4_B4_C4, FN_VI0_D5_B5_C5, FN_VI0_D6_B6_C6, FN_VI0_D7_B7_C7,
	FN_VI0_D8_G0_Y0, FN_VI0_D9_G1_Y1, FN_VI0_D10_G2_Y2, FN_VI0_D11_G3_Y3,
	FN_VI0_FIELD,

	/* GPSR5 */
	FN_VI1_CLK, FN_VI1_CLKENB, FN_VI1_HSYNC, FN_VI1_VSYNC,
	FN_VI1_D0_B0_C0, FN_VI1_D1_B1_C1, FN_VI1_D2_B2_C2, FN_VI1_D3_B3_C3,
	FN_VI1_D4_B4_C4, FN_VI1_D5_B5_C5, FN_VI1_D6_B6_C6, FN_VI1_D7_B7_C7,
	FN_VI1_D8_G0_Y0, FN_VI1_D9_G1_Y1, FN_VI1_D10_G2_Y2, FN_VI1_D11_G3_Y3,
	FN_VI1_FIELD,

	/* GPSR6 */
	FN_IP2_0, FN_IP2_1, FN_IP2_2, FN_IP2_3,
	FN_IP2_4, FN_IP2_5, FN_IP2_6, FN_IP2_7,
	FN_IP2_8, FN_IP2_9, FN_IP2_10, FN_IP2_11,
	FN_IP2_12, FN_IP2_13, FN_IP2_14, FN_IP2_15,
	FN_IP2_16,

	/* GPSR7 */
	FN_IP3_0, FN_IP3_1, FN_IP3_2, FN_IP3_3,
	FN_IP3_4, FN_IP3_5, FN_IP3_6, FN_IP3_7,
	FN_IP3_8, FN_IP3_9, FN_IP3_10, FN_IP3_11,
	FN_IP3_12, FN_IP3_13, FN_VI3_D10_Y2, FN_IP3_14,
	FN_VI3_FIELD,

	/* GPSR8 */
	FN_VI4_CLK, FN_IP4_0, FN_IP4_1, FN_IP4_3_2,
	FN_IP4_4, FN_IP4_6_5, FN_IP4_8_7, FN_IP4_10_9,
	FN_IP4_12_11, FN_IP4_14_13, FN_IP4_16_15, FN_IP4_18_17,
	FN_IP4_20_19, FN_IP4_21, FN_IP4_22, FN_IP4_23, FN_IP4_24,

	/* GPSR9 */
	FN_VI5_CLK, FN_IP5_0, FN_IP5_1, FN_IP5_2,
	FN_IP5_3, FN_IP5_4, FN_IP5_5, FN_IP5_6,
	FN_IP5_7, FN_IP5_8, FN_IP5_9, FN_IP5_10,
	FN_IP5_11, FN_VI5_D9_Y1, FN_VI5_D10_Y2, FN_VI5_D11_Y3,
	FN_VI5_FIELD,

	/* GPSR10 */
	FN_IP6_0, FN_IP6_1, FN_HRTS0, FN_IP6_2,
	FN_IP6_3, FN_IP6_4, FN_IP6_5, FN_HCTS1,
	FN_IP6_6, FN_IP6_7, FN_SCK0, FN_CTS0,
	FN_RTS0, FN_TX0, FN_RX0, FN_SCK1,
	FN_CTS1, FN_RTS1, FN_TX1, FN_RX1,
	FN_IP6_9_8, FN_IP6_11_10, FN_IP6_13_12, FN_IP6_15_14,
	FN_IP6_16, FN_IP6_18_17, FN_SCIF_CLK, FN_CAN0_TX,
	FN_CAN0_RX, FN_CAN_CLK, FN_CAN1_TX, FN_CAN1_RX,

	/* GPSR11 */
	FN_IP7_1_0, FN_IP7_3_2, FN_IP7_5_4, FN_IP7_6,
	FN_IP7_7, FN_SD0_CLK, FN_SD0_CMD, FN_SD0_DAT0,
	FN_SD0_DAT1, FN_SD0_DAT2, FN_SD0_DAT3, FN_SD0_CD,
	FN_SD0_WP, FN_IP7_9_8, FN_IP7_11_10, FN_IP7_13_12,
	FN_IP7_15_14, FN_IP7_16, FN_IP7_17, FN_IP7_18,
	FN_IP7_19, FN_IP7_20, FN_ADICLK, FN_ADICS_SAMP,
	FN_ADIDATA, FN_ADICHS0, FN_ADICHS1, FN_ADICHS2,
	FN_AVS1, FN_AVS2,

	/* IPSR0 */
	FN_DU0_DR0_DATA0, FN_DU0_DR1_DATA1, FN_DU0_DR2_Y4_DATA2, FN_DU0_DR3_Y5_DATA3,
	FN_DU0_DR4_Y6_DATA4, FN_DU0_DR5_Y7_DATA5, FN_DU0_DR6_Y8_DATA6, FN_DU0_DR7_Y9_DATA7,
	FN_DU0_DG0_DATA8, FN_DU0_DG1_DATA9, FN_DU0_DG2_C6_DATA10, FN_DU0_DG3_C7_DATA11,
	FN_DU0_DG4_Y0_DATA12, FN_DU0_DG5_Y1_DATA13, FN_DU0_DG6_Y2_DATA14, FN_DU0_DG7_Y3_DATA15,
	FN_DU0_DB0, FN_DU0_DB1, FN_DU0_DB2_C0, FN_DU0_DB3_C1,
	FN_DU0_DB4_C2, FN_DU0_DB5_C3, FN_DU0_DB6_C4, FN_DU0_DB7_C5,

	/* IPSR1 */
	FN_DU0_EXHSYNC_DU0_HSYNC, FN_DU0_EXVSYNC_DU0_VSYNC, FN_DU0_EXODDF_DU0_ODDF_DISP_CDE, FN_DU0_DISP,
	FN_DU0_CDE, FN_DU1_DR2_Y4_DATA0, FN_DU1_DR3_Y5_DATA1, FN_DU1_DR4_Y6_DATA2,
	FN_DU1_DR5_Y7_DATA3, FN_DU1_DR6_DATA4, FN_DU1_DR7_DATA5, FN_DU1_DG2_C6_DATA6,
	FN_DU1_DG3_C7_DATA7, FN_DU1_DG4_Y0_DATA8, FN_DU1_DG5_Y1_DATA9, FN_DU1_DG6_Y2_DATA10,
	FN_DU1_DG7_Y3_DATA11, FN_A20, FN_MOSI_IO0, FN_A21, FN_MISO_IO1,
	FN_A22, FN_IO2, FN_A23, FN_IO3, FN_A24, FN_SPCLK, FN_A25, FN_SSL,

	/* IPSR2 */
	FN_VI2_CLK, FN_AVB_RX_CLK, FN_VI2_CLKENB, FN_AVB_RX_DV,
	FN_VI2_HSYNC, FN_AVB_RXD0, FN_VI2_VSYNC, FN_AVB_RXD1,
	FN_VI2_D0_C0, FN_AVB_RXD2, FN_VI2_D1_C1, FN_AVB_RXD3,
	FN_VI2_D2_C2, FN_AVB_RXD4, FN_VI2_D3_C3, FN_AVB_RXD5,
	FN_VI2_D4_C4, FN_AVB_RXD6, FN_VI2_D5_C5, FN_AVB_RXD7,
	FN_VI2_D6_C6, FN_AVB_RX_ER, FN_VI2_D7_C7, FN_AVB_COL,
	FN_VI2_D8_Y0, FN_AVB_TXD3, FN_VI2_D9_Y1, FN_AVB_TX_EN,
	FN_VI2_D10_Y2, FN_AVB_TXD0, FN_VI2_D11_Y3, FN_AVB_TXD1,
	FN_VI2_FIELD, FN_AVB_TXD2,

	/* IPSR3 */
	FN_VI3_CLK, FN_AVB_TX_CLK, FN_VI3_CLKENB, FN_AVB_TXD4,
	FN_VI3_HSYNC, FN_AVB_TXD5, FN_VI3_VSYNC, FN_AVB_TXD6,
	FN_VI3_D0_C0, FN_AVB_TXD7, FN_VI3_D1_C1, FN_AVB_TX_ER,
	FN_VI3_D2_C2, FN_AVB_GTX_CLK, FN_VI3_D3_C3, FN_AVB_MDC,
	FN_VI3_D4_C4, FN_AVB_MDIO, FN_VI3_D5_C5, FN_AVB_LINK,
	FN_VI3_D6_C6, FN_AVB_MAGIC, FN_VI3_D7_C7, FN_AVB_PHY_INT,
	FN_VI3_D8_Y0, FN_AVB_CRS, FN_VI3_D9_Y1, FN_AVB_GTXREFCLK,
	FN_VI3_D11_Y3,

	/* IPSR4 */
	FN_VI4_CLKENB, FN_VI0_D12_G4_Y4, FN_VI4_HSYNC, FN_VI0_D13_G5_Y5,
	FN_VI4_VSYNC, FN_VI0_D14_G6_Y6, FN_VI4_D0_C0, FN_VI0_D15_G7_Y7,
	FN_VI4_D1_C1, FN_VI0_D16_R0, FN_VI1_D12_G4_Y4_0, FN_VI4_D2_C2, FN_VI0_D17_R1, FN_VI1_D13_G5_Y5_0,
	FN_VI4_D3_C3, FN_VI0_D18_R2, FN_VI1_D14_G6_Y6_0, FN_VI4_D4_C4, FN_VI0_D19_R3, FN_VI1_D15_G7_Y7_0,
	FN_VI4_D5_C5, FN_VI0_D20_R4, FN_VI2_D12_Y4, FN_VI4_D6_C6, FN_VI0_D21_R5, FN_VI2_D13_Y5,
	FN_VI4_D7_C7, FN_VI0_D22_R6, FN_VI2_D14_Y6, FN_VI4_D8_Y0, FN_VI0_D23_R7, FN_VI2_D15_Y7,
	FN_VI4_D9_Y1, FN_VI3_D12_Y4, FN_VI4_D10_Y2, FN_VI3_D13_Y5,
	FN_VI4_D11_Y3, FN_VI3_D14_Y6, FN_VI4_FIELD, FN_VI3_D15_Y7,

	/* IPSR5 */
	FN_VI5_CLKENB, FN_VI1_D12_G4_Y4_1, FN_VI5_HSYNC, FN_VI1_D13_G5_Y5_1,
	FN_VI5_VSYNC, FN_VI1_D14_G6_Y6_1, FN_VI5_D0_C0, FN_VI1_D15_G7_Y7_1,
	FN_VI5_D1_C1, FN_VI1_D16_R0, FN_VI5_D2_C2, FN_VI1_D17_R1,
	FN_VI5_D3_C3, FN_VI1_D18_R2, FN_VI5_D4_C4, FN_VI1_D19_R3,
	FN_VI5_D5_C5, FN_VI1_D20_R4, FN_VI5_D6_C6, FN_VI1_D21_R5,
	FN_VI5_D7_C7, FN_VI1_D22_R6, FN_VI5_D8_Y0, FN_VI1_D23_R7,

	/* IPSR6 */
	FN_MSIOF0_SCK, FN_HSCK0, FN_MSIOF0_SYNC, FN_HCTS0,
	FN_MSIOF0_TXD, FN_HTX0, FN_MSIOF0_RXD, FN_HRX0,
	FN_MSIOF1_SCK, FN_HSCK1, FN_MSIOF1_SYNC, FN_HRTS1,
	FN_MSIOF1_TXD, FN_HTX1, FN_MSIOF1_RXD, FN_HRX1,
	FN_DRACK0, FN_SCK2, FN_DACK0, FN_TX2,
	FN_DREQ0, FN_RX2, FN_DACK1, FN_SCK3,
	FN_TX3, FN_DREQ1, FN_RX3,

	/* IPSR7 */
	FN_PWM0, FN_TCLK1, FN_FSO_CFE_0, FN_PWM1, FN_TCLK2, FN_FSO_CFE_1,
	FN_PWM2, FN_TCLK3, FN_FSO_TOE, FN_PWM3, FN_PWM4,
	FN_SSI_SCK3, FN_TPU0TO0, FN_SSI_WS3, FN_TPU0TO1,
	FN_SSI_SDATA3, FN_TPU0TO2, FN_SSI_SCK4, FN_TPU0TO3,
	FN_SSI_WS4, FN_SSI_SDATA4, FN_AUDIO_CLKOUT, FN_AUDIO_CLKA, FN_AUDIO_CLKB,

	FN_SEL_VI1_0, FN_SEL_VI1_1,
	PINMUX_FUNCTION_END,

	PINMUX_MARK_BEGIN,
	DU1_DB2_C0_DATA12_MARK, DU1_DB3_C1_DATA13_MARK,
	DU1_DB4_C2_DATA14_MARK, DU1_DB5_C3_DATA15_MARK,
	DU1_DB6_C4_MARK, DU1_DB7_C5_MARK, DU1_EXHSYNC_DU1_HSYNC_MARK, DU1_EXVSYNC_DU1_VSYNC_MARK,
	DU1_EXODDF_DU1_ODDF_DISP_CDE_MARK, DU1_DISP_MARK, DU1_CDE_MARK,

	D0_MARK, D1_MARK, D2_MARK, D3_MARK, D4_MARK, D5_MARK,
	D6_MARK, D7_MARK, D8_MARK, D9_MARK, D10_MARK, D11_MARK,
	D12_MARK, D13_MARK, D14_MARK, D15_MARK, A0_MARK, A1_MARK,
	A2_MARK, A3_MARK, A4_MARK, A5_MARK, A6_MARK, A7_MARK,
	A8_MARK, A9_MARK, A10_MARK, A11_MARK, A12_MARK, A13_MARK,
	A14_MARK, A15_MARK,

	A16_MARK, A17_MARK, A18_MARK, A19_MARK,
	CS1_A26_MARK, EX_CS0_MARK, EX_CS1_MARK, EX_CS2_MARK,
	EX_CS3_MARK, EX_CS4_MARK, EX_CS5_MARK, BS_MARK,
	RD_MARK, RD_WR_MARK, WE0_MARK, WE1_MARK, EX_WAIT0_MARK,
	IRQ0_MARK, IRQ1_MARK, IRQ2_MARK, IRQ3_MARK, CS0_MARK,

	VI0_CLK_MARK, VI0_CLKENB_MARK, VI0_HSYNC_MARK, VI0_VSYNC_MARK,
	VI0_D0_B0_C0_MARK, VI0_D1_B1_C1_MARK, VI0_D2_B2_C2_MARK, VI0_D3_B3_C3_MARK,
	VI0_D4_B4_C4_MARK, VI0_D5_B5_C5_MARK, VI0_D6_B6_C6_MARK, VI0_D7_B7_C7_MARK,
	VI0_D8_G0_Y0_MARK, VI0_D9_G1_Y1_MARK, VI0_D10_G2_Y2_MARK, VI0_D11_G3_Y3_MARK,
	VI0_FIELD_MARK,

	VI1_CLK_MARK, VI1_CLKENB_MARK, VI1_HSYNC_MARK,
	VI1_VSYNC_MARK, VI1_D0_B0_C0_MARK, VI1_D1_B1_C1_MARK,
	VI1_D2_B2_C2_MARK, VI1_D3_B3_C3_MARK, VI1_D4_B4_C4_MARK,
	VI1_D5_B5_C5_MARK, VI1_D6_B6_C6_MARK, VI1_D7_B7_C7_MARK,
	VI1_D8_G0_Y0_MARK, VI1_D9_G1_Y1_MARK, VI1_D10_G2_Y2_MARK,
	VI1_D11_G3_Y3_MARK, VI1_FIELD_MARK,

	VI3_D10_Y2_MARK, VI3_FIELD_MARK,

	VI4_CLK_MARK,

	VI5_CLK_MARK, VI5_D9_Y1_MARK, VI5_D10_Y2_MARK, VI5_D11_Y3_MARK, VI5_FIELD_MARK,

	HRTS0_MARK, HCTS1_MARK, SCK0_MARK, CTS0_MARK, RTS0_MARK, TX0_MARK,
	RX0_MARK, SCK1_MARK, CTS1_MARK, RTS1_MARK, TX1_MARK, RX1_MARK,
	SCIF_CLK_MARK, CAN0_TX_MARK, CAN0_RX_MARK,
	CAN_CLK_MARK, CAN1_TX_MARK, CAN1_RX_MARK,

	SD0_CLK_MARK, SD0_CMD_MARK, SD0_DAT0_MARK,
	SD0_DAT1_MARK, SD0_DAT2_MARK, SD0_DAT3_MARK,
	SD0_CD_MARK, SD0_WP_MARK, ADICLK_MARK,
	ADICS_SAMP_MARK, ADIDATA_MARK, ADICHS0_MARK,
	ADICHS1_MARK, ADICHS2_MARK, AVS1_MARK, AVS2_MARK,

	DU0_DR0_DATA0_MARK, DU0_DR1_DATA1_MARK, DU0_DR2_Y4_DATA2_MARK,
	DU0_DR3_Y5_DATA3_MARK, DU0_DR4_Y6_DATA4_MARK, DU0_DR5_Y7_DATA5_MARK,
	DU0_DR6_Y8_DATA6_MARK, DU0_DR7_Y9_DATA7_MARK, DU0_DG0_DATA8_MARK,
	DU0_DG1_DATA9_MARK, DU0_DG2_C6_DATA10_MARK, DU0_DG3_C7_DATA11_MARK,
	DU0_DG4_Y0_DATA12_MARK, DU0_DG5_Y1_DATA13_MARK, DU0_DG6_Y2_DATA14_MARK,
	DU0_DG7_Y3_DATA15_MARK, DU0_DB0_MARK, DU0_DB1_MARK,
	DU0_DB2_C0_MARK, DU0_DB3_C1_MARK, DU0_DB4_C2_MARK,
	DU0_DB5_C3_MARK, DU0_DB6_C4_MARK, DU0_DB7_C5_MARK,

	DU0_EXHSYNC_DU0_HSYNC_MARK, DU0_EXVSYNC_DU0_VSYNC_MARK,
	DU0_EXODDF_DU0_ODDF_DISP_CDE_MARK, DU0_DISP_MARK, DU0_CDE_MARK,
	DU1_DR2_Y4_DATA0_MARK, DU1_DR3_Y5_DATA1_MARK, DU1_DR4_Y6_DATA2_MARK,
	DU1_DR5_Y7_DATA3_MARK, DU1_DR6_DATA4_MARK, DU1_DR7_DATA5_MARK,
	DU1_DG2_C6_DATA6_MARK, DU1_DG3_C7_DATA7_MARK, DU1_DG4_Y0_DATA8_MARK,
	DU1_DG5_Y1_DATA9_MARK, DU1_DG6_Y2_DATA10_MARK, DU1_DG7_Y3_DATA11_MARK,
	A20_MARK, MOSI_IO0_MARK, A21_MARK, MISO_IO1_MARK, A22_MARK, IO2_MARK,
	A23_MARK, IO3_MARK, A24_MARK, SPCLK_MARK, A25_MARK, SSL_MARK,

	VI2_CLK_MARK, AVB_RX_CLK_MARK, VI2_CLKENB_MARK, AVB_RX_DV_MARK,
	VI2_HSYNC_MARK, AVB_RXD0_MARK, VI2_VSYNC_MARK, AVB_RXD1_MARK,
	VI2_D0_C0_MARK, AVB_RXD2_MARK, VI2_D1_C1_MARK, AVB_RXD3_MARK,
	VI2_D2_C2_MARK, AVB_RXD4_MARK, VI2_D3_C3_MARK, AVB_RXD5_MARK,
	VI2_D4_C4_MARK, AVB_RXD6_MARK, VI2_D5_C5_MARK, AVB_RXD7_MARK,
	VI2_D6_C6_MARK, AVB_RX_ER_MARK, VI2_D7_C7_MARK, AVB_COL_MARK,
	VI2_D8_Y0_MARK, AVB_TXD3_MARK, VI2_D9_Y1_MARK, AVB_TX_EN_MARK,
	VI2_D10_Y2_MARK, AVB_TXD0_MARK, VI2_D11_Y3_MARK, AVB_TXD1_MARK,
	VI2_FIELD_MARK, AVB_TXD2_MARK,

	VI3_CLK_MARK, AVB_TX_CLK_MARK, VI3_CLKENB_MARK, AVB_TXD4_MARK,
	VI3_HSYNC_MARK, AVB_TXD5_MARK, VI3_VSYNC_MARK, AVB_TXD6_MARK,
	VI3_D0_C0_MARK, AVB_TXD7_MARK, VI3_D1_C1_MARK, AVB_TX_ER_MARK,
	VI3_D2_C2_MARK, AVB_GTX_CLK_MARK, VI3_D3_C3_MARK, AVB_MDC_MARK,
	VI3_D4_C4_MARK, AVB_MDIO_MARK, VI3_D5_C5_MARK, AVB_LINK_MARK,
	VI3_D6_C6_MARK, AVB_MAGIC_MARK, VI3_D7_C7_MARK, AVB_PHY_INT_MARK,
	VI3_D8_Y0_MARK, AVB_CRS_MARK, VI3_D9_Y1_MARK, AVB_GTXREFCLK_MARK,
	VI3_D11_Y3_MARK,

	VI4_CLKENB_MARK, VI0_D12_G4_Y4_MARK, VI4_HSYNC_MARK, VI0_D13_G5_Y5_MARK,
	VI4_VSYNC_MARK, VI0_D14_G6_Y6_MARK, VI4_D0_C0_MARK, VI0_D15_G7_Y7_MARK,
	VI4_D1_C1_MARK, VI0_D16_R0_MARK, VI1_D12_G4_Y4_0_MARK,
	VI4_D2_C2_MARK, VI0_D17_R1_MARK, VI1_D13_G5_Y5_0_MARK,
	VI4_D3_C3_MARK, VI0_D18_R2_MARK, VI1_D14_G6_Y6_0_MARK,
	VI4_D4_C4_MARK, VI0_D19_R3_MARK, VI1_D15_G7_Y7_0_MARK,
	VI4_D5_C5_MARK, VI0_D20_R4_MARK, VI2_D12_Y4_MARK,
	VI4_D6_C6_MARK, VI0_D21_R5_MARK, VI2_D13_Y5_MARK,
	VI4_D7_C7_MARK, VI0_D22_R6_MARK, VI2_D14_Y6_MARK,
	VI4_D8_Y0_MARK, VI0_D23_R7_MARK, VI2_D15_Y7_MARK,
	VI4_D9_Y1_MARK, VI3_D12_Y4_MARK, VI4_D10_Y2_MARK, VI3_D13_Y5_MARK,
	VI4_D11_Y3_MARK, VI3_D14_Y6_MARK, VI4_FIELD_MARK, VI3_D15_Y7_MARK,

	VI5_CLKENB_MARK, VI1_D12_G4_Y4_1_MARK, VI5_HSYNC_MARK, VI1_D13_G5_Y5_1_MARK,
	VI5_VSYNC_MARK, VI1_D14_G6_Y6_1_MARK, VI5_D0_C0_MARK, VI1_D15_G7_Y7_1_MARK,
	VI5_D1_C1_MARK, VI1_D16_R0_MARK, VI5_D2_C2_MARK, VI1_D17_R1_MARK,
	VI5_D3_C3_MARK, VI1_D18_R2_MARK, VI5_D4_C4_MARK, VI1_D19_R3_MARK,
	VI5_D5_C5_MARK, VI1_D20_R4_MARK, VI5_D6_C6_MARK, VI1_D21_R5_MARK,
	VI5_D7_C7_MARK, VI1_D22_R6_MARK, VI5_D8_Y0_MARK, VI1_D23_R7_MARK,

	MSIOF0_SCK_MARK, HSCK0_MARK, MSIOF0_SYNC_MARK, HCTS0_MARK,
	MSIOF0_TXD_MARK, HTX0_MARK, MSIOF0_RXD_MARK, HRX0_MARK,
	MSIOF1_SCK_MARK, HSCK1_MARK, MSIOF1_SYNC_MARK, HRTS1_MARK,
	MSIOF1_TXD_MARK, HTX1_MARK, MSIOF1_RXD_MARK, HRX1_MARK,
	DRACK0_MARK, SCK2_MARK, DACK0_MARK, TX2_MARK,
	DREQ0_MARK, RX2_MARK, DACK1_MARK, SCK3_MARK,
	TX3_MARK, DREQ1_MARK, RX3_MARK,

	PWM0_MARK, TCLK1_MARK, FSO_CFE_0_MARK,
	PWM1_MARK, TCLK2_MARK, FSO_CFE_1_MARK,
	PWM2_MARK, TCLK3_MARK, FSO_TOE_MARK,
	PWM3_MARK, PWM4_MARK, SSI_SCK3_MARK, TPU0TO0_MARK,
	SSI_WS3_MARK, TPU0TO1_MARK, SSI_SDATA3_MARK, TPU0TO2_MARK,
	SSI_SCK4_MARK, TPU0TO3_MARK, SSI_WS4_MARK,
	SSI_SDATA4_MARK, AUDIO_CLKOUT_MARK,
	AUDIO_CLKA_MARK, AUDIO_CLKB_MARK,

	PINMUX_MARK_END,
};

static pinmux_enum_t pinmux_data[] = {
	PINMUX_DATA_GP_ALL(), /* PINMUX_DATA(GP_M_N_DATA, GP_M_N_FN...), */

	PINMUX_DATA(DU1_DB2_C0_DATA12_MARK, FN_DU1_DB2_C0_DATA12),
	PINMUX_DATA(DU1_DB3_C1_DATA13_MARK, FN_DU1_DB3_C1_DATA13),
	PINMUX_DATA(DU1_DB4_C2_DATA14_MARK, FN_DU1_DB4_C2_DATA14),
	PINMUX_DATA(DU1_DB5_C3_DATA15_MARK, FN_DU1_DB5_C3_DATA15),
	PINMUX_DATA(DU1_DB6_C4_MARK, FN_DU1_DB6_C4),
	PINMUX_DATA(DU1_DB7_C5_MARK, FN_DU1_DB7_C5),
	PINMUX_DATA(DU1_EXHSYNC_DU1_HSYNC_MARK, FN_DU1_EXHSYNC_DU1_HSYNC),
	PINMUX_DATA(DU1_EXVSYNC_DU1_VSYNC_MARK, FN_DU1_EXVSYNC_DU1_VSYNC),
	PINMUX_DATA(DU1_EXODDF_DU1_ODDF_DISP_CDE_MARK, FN_DU1_EXODDF_DU1_ODDF_DISP_CDE),
	PINMUX_DATA(DU1_DISP_MARK, FN_DU1_DISP),
	PINMUX_DATA(DU1_CDE_MARK, FN_DU1_CDE),

	PINMUX_DATA(D0_MARK, FN_D0),
	PINMUX_DATA(D1_MARK, FN_D1),
	PINMUX_DATA(D2_MARK, FN_D2),
	PINMUX_DATA(D3_MARK, FN_D3),
	PINMUX_DATA(D4_MARK, FN_D4),
	PINMUX_DATA(D5_MARK, FN_D5),
	PINMUX_DATA(D6_MARK, FN_D6),
	PINMUX_DATA(D7_MARK, FN_D7),
	PINMUX_DATA(D8_MARK, FN_D8),
	PINMUX_DATA(D9_MARK, FN_D9),
	PINMUX_DATA(D10_MARK, FN_D10),
	PINMUX_DATA(D11_MARK, FN_D11),
	PINMUX_DATA(D12_MARK, FN_D12),
	PINMUX_DATA(D13_MARK, FN_D13),
	PINMUX_DATA(D14_MARK, FN_D14),
	PINMUX_DATA(D15_MARK, FN_D15),
	PINMUX_DATA(A0_MARK, FN_A0),
	PINMUX_DATA(A1_MARK, FN_A1),
	PINMUX_DATA(A2_MARK, FN_A2),
	PINMUX_DATA(A3_MARK, FN_A3),
	PINMUX_DATA(A4_MARK, FN_A4),
	PINMUX_DATA(A5_MARK, FN_A5),
	PINMUX_DATA(A6_MARK, FN_A6),
	PINMUX_DATA(A7_MARK, FN_A7),
	PINMUX_DATA(A8_MARK, FN_A8),
	PINMUX_DATA(A9_MARK, FN_A9),
	PINMUX_DATA(A10_MARK, FN_A10),
	PINMUX_DATA(A11_MARK, FN_A11),
	PINMUX_DATA(A12_MARK, FN_A12),
	PINMUX_DATA(A13_MARK, FN_A13),
	PINMUX_DATA(A14_MARK, FN_A14),
	PINMUX_DATA(A15_MARK, FN_A15),

	PINMUX_DATA(A16_MARK, FN_A16),
	PINMUX_DATA(A17_MARK, FN_A17),
	PINMUX_DATA(A18_MARK, FN_A18),
	PINMUX_DATA(A19_MARK, FN_A19),
	PINMUX_DATA(CS1_A26_MARK, FN_CS1_A26),
	PINMUX_DATA(EX_CS0_MARK, FN_EX_CS0),
	PINMUX_DATA(EX_CS1_MARK, FN_EX_CS1),
	PINMUX_DATA(EX_CS2_MARK, FN_EX_CS2),
	PINMUX_DATA(EX_CS3_MARK, FN_EX_CS3),
	PINMUX_DATA(EX_CS4_MARK, FN_EX_CS4),
	PINMUX_DATA(EX_CS5_MARK, FN_EX_CS5),
	PINMUX_DATA(BS_MARK, FN_BS),
	PINMUX_DATA(RD_MARK, FN_RD),
	PINMUX_DATA(RD_WR_MARK, FN_RD_WR),
	PINMUX_DATA(WE0_MARK, FN_WE0),
	PINMUX_DATA(WE1_MARK, FN_WE1),
	PINMUX_DATA(EX_WAIT0_MARK, FN_EX_WAIT0),
	PINMUX_DATA(IRQ0_MARK, FN_IRQ0),
	PINMUX_DATA(IRQ1_MARK, FN_IRQ1),
	PINMUX_DATA(IRQ2_MARK, FN_IRQ2),
	PINMUX_DATA(IRQ3_MARK, FN_IRQ3),
	PINMUX_DATA(CS0_MARK, FN_CS0),

	PINMUX_DATA(VI0_CLK_MARK, FN_VI0_CLK),
	PINMUX_DATA(VI0_CLKENB_MARK, FN_VI0_CLKENB),
	PINMUX_DATA(VI0_HSYNC_MARK, FN_VI0_HSYNC),
	PINMUX_DATA(VI0_VSYNC_MARK, FN_VI0_VSYNC),
	PINMUX_DATA(VI0_D0_B0_C0_MARK, FN_VI0_D0_B0_C0),
	PINMUX_DATA(VI0_D1_B1_C1_MARK, FN_VI0_D1_B1_C1),
	PINMUX_DATA(VI0_D2_B2_C2_MARK, FN_VI0_D2_B2_C2),
	PINMUX_DATA(VI0_D3_B3_C3_MARK, FN_VI0_D3_B3_C3),
	PINMUX_DATA(VI0_D4_B4_C4_MARK, FN_VI0_D4_B4_C4),
	PINMUX_DATA(VI0_D5_B5_C5_MARK, FN_VI0_D5_B5_C5),
	PINMUX_DATA(VI0_D6_B6_C6_MARK, FN_VI0_D6_B6_C6),
	PINMUX_DATA(VI0_D7_B7_C7_MARK, FN_VI0_D7_B7_C7),
	PINMUX_DATA(VI0_D8_G0_Y0_MARK, FN_VI0_D8_G0_Y0),
	PINMUX_DATA(VI0_D9_G1_Y1_MARK, FN_VI0_D9_G1_Y1),
	PINMUX_DATA(VI0_D10_G2_Y2_MARK, FN_VI0_D10_G2_Y2),
	PINMUX_DATA(VI0_D11_G3_Y3_MARK, FN_VI0_D11_G3_Y3),
	PINMUX_DATA(VI0_FIELD_MARK, FN_VI0_FIELD),

	PINMUX_DATA(VI1_CLK_MARK, FN_VI1_CLK),
	PINMUX_DATA(VI1_CLKENB_MARK, FN_VI1_CLKENB),
	PINMUX_DATA(VI1_HSYNC_MARK, FN_VI1_HSYNC),
	PINMUX_DATA(VI1_VSYNC_MARK, FN_VI1_VSYNC),
	PINMUX_DATA(VI1_D0_B0_C0_MARK, FN_VI1_D0_B0_C0),
	PINMUX_DATA(VI1_D1_B1_C1_MARK, FN_VI1_D1_B1_C1),
	PINMUX_DATA(VI1_D2_B2_C2_MARK, FN_VI1_D2_B2_C2),
	PINMUX_DATA(VI1_D3_B3_C3_MARK, FN_VI1_D3_B3_C3),
	PINMUX_DATA(VI1_D4_B4_C4_MARK, FN_VI1_D4_B4_C4),
	PINMUX_DATA(VI1_D5_B5_C5_MARK, FN_VI1_D5_B5_C5),
	PINMUX_DATA(VI1_D6_B6_C6_MARK, FN_VI1_D6_B6_C6),
	PINMUX_DATA(VI1_D7_B7_C7_MARK, FN_VI1_D7_B7_C7),
	PINMUX_DATA(VI1_D8_G0_Y0_MARK, FN_VI1_D8_G0_Y0),
	PINMUX_DATA(VI1_D9_G1_Y1_MARK, FN_VI1_D9_G1_Y1),
	PINMUX_DATA(VI1_D10_G2_Y2_MARK, FN_VI1_D10_G2_Y2),
	PINMUX_DATA(VI1_D11_G3_Y3_MARK, FN_VI1_D11_G3_Y3),
	PINMUX_DATA(VI1_FIELD_MARK, FN_VI1_FIELD),

	PINMUX_DATA(VI3_D10_Y2_MARK, FN_VI3_D10_Y2),
	PINMUX_DATA(VI3_FIELD_MARK, FN_VI3_FIELD),

	PINMUX_DATA(VI4_CLK_MARK, FN_VI4_CLK),

	PINMUX_DATA(VI5_CLK_MARK, FN_VI5_CLK),
	PINMUX_DATA(VI5_D9_Y1_MARK, FN_VI5_D9_Y1),
	PINMUX_DATA(VI5_D10_Y2_MARK, FN_VI5_D10_Y2),
	PINMUX_DATA(VI5_D11_Y3_MARK, FN_VI5_D11_Y3),
	PINMUX_DATA(VI5_FIELD_MARK, FN_VI5_FIELD),

	PINMUX_DATA(HRTS0_MARK, FN_HRTS0),
	PINMUX_DATA(HCTS1_MARK, FN_HCTS1),
	PINMUX_DATA(SCK0_MARK, FN_SCK0),
	PINMUX_DATA(CTS0_MARK, FN_CTS0),
	PINMUX_DATA(RTS0_MARK, FN_RTS0),
	PINMUX_DATA(TX0_MARK, FN_TX0),
	PINMUX_DATA(RX0_MARK, FN_RX0),
	PINMUX_DATA(SCK1_MARK, FN_SCK1),
	PINMUX_DATA(CTS1_MARK, FN_CTS1),
	PINMUX_DATA(RTS1_MARK, FN_RTS1),
	PINMUX_DATA(TX1_MARK, FN_TX1),
	PINMUX_DATA(RX1_MARK, FN_RX1),
	PINMUX_DATA(SCIF_CLK_MARK, FN_SCIF_CLK),
	PINMUX_DATA(CAN0_TX_MARK, FN_CAN0_TX),
	PINMUX_DATA(CAN0_RX_MARK, FN_CAN0_RX),
	PINMUX_DATA(CAN_CLK_MARK, FN_CAN_CLK),
	PINMUX_DATA(CAN1_TX_MARK, FN_CAN1_TX),
	PINMUX_DATA(CAN1_RX_MARK, FN_CAN1_RX),

	PINMUX_DATA(SD0_CLK_MARK, FN_SD0_CLK),
	PINMUX_DATA(SD0_CMD_MARK, FN_SD0_CMD),
	PINMUX_DATA(SD0_DAT0_MARK, FN_SD0_DAT0),
	PINMUX_DATA(SD0_DAT1_MARK, FN_SD0_DAT1),
	PINMUX_DATA(SD0_DAT2_MARK, FN_SD0_DAT2),
	PINMUX_DATA(SD0_DAT3_MARK, FN_SD0_DAT3),
	PINMUX_DATA(SD0_CD_MARK, FN_SD0_CD),
	PINMUX_DATA(SD0_WP_MARK, FN_SD0_WP),
	PINMUX_DATA(ADICLK_MARK, FN_ADICLK),
	PINMUX_DATA(ADICS_SAMP_MARK, FN_ADICS_SAMP),
	PINMUX_DATA(ADIDATA_MARK, FN_ADIDATA),
	PINMUX_DATA(ADICHS0_MARK, FN_ADICHS0),
	PINMUX_DATA(ADICHS1_MARK, FN_ADICHS1),
	PINMUX_DATA(ADICHS2_MARK, FN_ADICHS2),
	PINMUX_DATA(AVS1_MARK, FN_AVS1),
	PINMUX_DATA(AVS2_MARK, FN_AVS2),

	PINMUX_IPSR_DATA(IP0_0, DU0_DR0_DATA0),
	PINMUX_IPSR_DATA(IP0_1, DU0_DR1_DATA1),
	PINMUX_IPSR_DATA(IP0_2, DU0_DR2_Y4_DATA2),
	PINMUX_IPSR_DATA(IP0_3, DU0_DR3_Y5_DATA3),
	PINMUX_IPSR_DATA(IP0_4, DU0_DR4_Y6_DATA4),
	PINMUX_IPSR_DATA(IP0_5, DU0_DR5_Y7_DATA5),
	PINMUX_IPSR_DATA(IP0_6, DU0_DR6_Y8_DATA6),
	PINMUX_IPSR_DATA(IP0_7, DU0_DR7_Y9_DATA7),
	PINMUX_IPSR_DATA(IP0_8, DU0_DG0_DATA8),
	PINMUX_IPSR_DATA(IP0_9, DU0_DG1_DATA9),
	PINMUX_IPSR_DATA(IP0_10, DU0_DG2_C6_DATA10),
	PINMUX_IPSR_DATA(IP0_11, DU0_DG3_C7_DATA11),
	PINMUX_IPSR_DATA(IP0_12, DU0_DG4_Y0_DATA12),
	PINMUX_IPSR_DATA(IP0_13, DU0_DG5_Y1_DATA13),
	PINMUX_IPSR_DATA(IP0_14, DU0_DG6_Y2_DATA14),
	PINMUX_IPSR_DATA(IP0_15, DU0_DG7_Y3_DATA15),
	PINMUX_IPSR_DATA(IP0_16, DU0_DB0),
	PINMUX_IPSR_DATA(IP0_17, DU0_DB1),
	PINMUX_IPSR_DATA(IP0_18, DU0_DB2_C0),
	PINMUX_IPSR_DATA(IP0_19, DU0_DB3_C1),
	PINMUX_IPSR_DATA(IP0_20, DU0_DB4_C2),
	PINMUX_IPSR_DATA(IP0_21, DU0_DB5_C3),
	PINMUX_IPSR_DATA(IP0_22, DU0_DB6_C4),
	PINMUX_IPSR_DATA(IP0_23, DU0_DB7_C5),

	PINMUX_IPSR_DATA(IP1_0, DU0_EXHSYNC_DU0_HSYNC),
	PINMUX_IPSR_DATA(IP1_1, DU0_EXVSYNC_DU0_VSYNC),
	PINMUX_IPSR_DATA(IP1_2, DU0_EXODDF_DU0_ODDF_DISP_CDE),
	PINMUX_IPSR_DATA(IP1_3, DU0_DISP),
	PINMUX_IPSR_DATA(IP1_4, DU0_CDE),
	PINMUX_IPSR_DATA(IP1_5, DU1_DR2_Y4_DATA0),
	PINMUX_IPSR_DATA(IP1_6, DU1_DR3_Y5_DATA1),
	PINMUX_IPSR_DATA(IP1_7, DU1_DR4_Y6_DATA2),
	PINMUX_IPSR_DATA(IP1_8, DU1_DR5_Y7_DATA3),
	PINMUX_IPSR_DATA(IP1_9, DU1_DR6_DATA4),
	PINMUX_IPSR_DATA(IP1_10, DU1_DR7_DATA5),
	PINMUX_IPSR_DATA(IP1_11, DU1_DG2_C6_DATA6),
	PINMUX_IPSR_DATA(IP1_12, DU1_DG3_C7_DATA7),
	PINMUX_IPSR_DATA(IP1_13, DU1_DG4_Y0_DATA8),
	PINMUX_IPSR_DATA(IP1_14, DU1_DG5_Y1_DATA9),
	PINMUX_IPSR_DATA(IP1_15, DU1_DG6_Y2_DATA10),
	PINMUX_IPSR_DATA(IP1_16, DU1_DG7_Y3_DATA11),
	PINMUX_IPSR_DATA(IP1_17, A20),
	PINMUX_IPSR_DATA(IP1_17, MOSI_IO0),
	PINMUX_IPSR_DATA(IP1_18, A21),
	PINMUX_IPSR_DATA(IP1_18, MISO_IO1),
	PINMUX_IPSR_DATA(IP1_19, A22),
	PINMUX_IPSR_DATA(IP1_19, IO2),
	PINMUX_IPSR_DATA(IP1_20, A23),
	PINMUX_IPSR_DATA(IP1_20, IO3),
	PINMUX_IPSR_DATA(IP1_21, A24),
	PINMUX_IPSR_DATA(IP1_21, SPCLK),
	PINMUX_IPSR_DATA(IP1_22, A25),
	PINMUX_IPSR_DATA(IP1_22, SSL),

	PINMUX_IPSR_DATA(IP2_0, VI2_CLK),
	PINMUX_IPSR_DATA(IP2_0, AVB_RX_CLK),
	PINMUX_IPSR_DATA(IP2_1, VI2_CLKENB),
	PINMUX_IPSR_DATA(IP2_1, AVB_RX_DV),
	PINMUX_IPSR_DATA(IP2_2, VI2_HSYNC),
	PINMUX_IPSR_DATA(IP2_2, AVB_RXD0),
	PINMUX_IPSR_DATA(IP2_3, VI2_VSYNC),
	PINMUX_IPSR_DATA(IP2_3, AVB_RXD1),
	PINMUX_IPSR_DATA(IP2_4, VI2_D0_C0),
	PINMUX_IPSR_DATA(IP2_4, AVB_RXD2),
	PINMUX_IPSR_DATA(IP2_5, VI2_D1_C1),
	PINMUX_IPSR_DATA(IP2_5, AVB_RXD3),
	PINMUX_IPSR_DATA(IP2_6, VI2_D2_C2),
	PINMUX_IPSR_DATA(IP2_6, AVB_RXD4),
	PINMUX_IPSR_DATA(IP2_7, VI2_D3_C3),
	PINMUX_IPSR_DATA(IP2_7, AVB_RXD5),
	PINMUX_IPSR_DATA(IP2_8, VI2_D4_C4),
	PINMUX_IPSR_DATA(IP2_8, AVB_RXD6),
	PINMUX_IPSR_DATA(IP2_9, VI2_D5_C5),
	PINMUX_IPSR_DATA(IP2_9, AVB_RXD7),
	PINMUX_IPSR_DATA(IP2_10, VI2_D6_C6),
	PINMUX_IPSR_DATA(IP2_10, AVB_RX_ER),
	PINMUX_IPSR_DATA(IP2_11, VI2_D7_C7),
	PINMUX_IPSR_DATA(IP2_11, AVB_COL),
	PINMUX_IPSR_DATA(IP2_12, VI2_D8_Y0),
	PINMUX_IPSR_DATA(IP2_12, AVB_TXD3),
	PINMUX_IPSR_DATA(IP2_13, VI2_D9_Y1),
	PINMUX_IPSR_DATA(IP2_13, AVB_TX_EN),
	PINMUX_IPSR_DATA(IP2_14, VI2_D10_Y2),
	PINMUX_IPSR_DATA(IP2_14, AVB_TXD0),
	PINMUX_IPSR_DATA(IP2_15, VI2_D11_Y3),
	PINMUX_IPSR_DATA(IP2_15, AVB_TXD1),
	PINMUX_IPSR_DATA(IP2_16, VI2_FIELD),
	PINMUX_IPSR_DATA(IP2_16, AVB_TXD2),

	PINMUX_IPSR_DATA(IP3_0, VI3_CLK),
	PINMUX_IPSR_DATA(IP3_0, AVB_TX_CLK),
	PINMUX_IPSR_DATA(IP3_1, VI3_CLKENB),
	PINMUX_IPSR_DATA(IP3_1, AVB_TXD4),
	PINMUX_IPSR_DATA(IP3_2, VI3_HSYNC),
	PINMUX_IPSR_DATA(IP3_2, AVB_TXD5),
	PINMUX_IPSR_DATA(IP3_3, VI3_VSYNC),
	PINMUX_IPSR_DATA(IP3_3, AVB_TXD6),
	PINMUX_IPSR_DATA(IP3_4, VI3_D0_C0),
	PINMUX_IPSR_DATA(IP3_4, AVB_TXD7),
	PINMUX_IPSR_DATA(IP3_5, VI3_D1_C1),
	PINMUX_IPSR_DATA(IP3_5, AVB_TX_ER),
	PINMUX_IPSR_DATA(IP3_6, VI3_D2_C2),
	PINMUX_IPSR_DATA(IP3_6, AVB_GTX_CLK),
	PINMUX_IPSR_DATA(IP3_7, VI3_D3_C3),
	PINMUX_IPSR_DATA(IP3_7, AVB_MDC),
	PINMUX_IPSR_DATA(IP3_8, VI3_D4_C4),
	PINMUX_IPSR_DATA(IP3_8, AVB_MDIO),
	PINMUX_IPSR_DATA(IP3_9, VI3_D5_C5),
	PINMUX_IPSR_DATA(IP3_9, AVB_LINK),
	PINMUX_IPSR_DATA(IP3_10, VI3_D6_C6),
	PINMUX_IPSR_DATA(IP3_10, AVB_MAGIC),
	PINMUX_IPSR_DATA(IP3_11, VI3_D7_C7),
	PINMUX_IPSR_DATA(IP3_11, AVB_PHY_INT),
	PINMUX_IPSR_DATA(IP3_12, VI3_D8_Y0),
	PINMUX_IPSR_DATA(IP3_12, AVB_CRS),
	PINMUX_IPSR_DATA(IP3_13, VI3_D9_Y1),
	PINMUX_IPSR_DATA(IP3_13, AVB_GTXREFCLK),
	PINMUX_IPSR_DATA(IP3_14, VI3_D11_Y3),

	PINMUX_IPSR_DATA(IP4_0, VI4_CLKENB),
	PINMUX_IPSR_DATA(IP4_0, VI0_D12_G4_Y4),
	PINMUX_IPSR_DATA(IP4_1, VI4_HSYNC),
	PINMUX_IPSR_DATA(IP4_1, VI0_D13_G5_Y5),
	PINMUX_IPSR_DATA(IP4_3_2, VI4_VSYNC),
	PINMUX_IPSR_DATA(IP4_3_2, VI0_D14_G6_Y6),
	PINMUX_IPSR_DATA(IP4_4, VI4_D0_C0),
	PINMUX_IPSR_DATA(IP4_4, VI0_D15_G7_Y7),
	PINMUX_IPSR_DATA(IP4_6_5, VI4_D1_C1),
	PINMUX_IPSR_DATA(IP4_6_5, VI0_D16_R0),
	PINMUX_IPSR_MODSEL_DATA(IP4_6_5, VI1_D12_G4_Y4_0, SEL_VI1_0),
	PINMUX_IPSR_DATA(IP4_8_7, VI4_D2_C2),
	PINMUX_IPSR_DATA(IP4_8_7, VI0_D17_R1),
	PINMUX_IPSR_MODSEL_DATA(IP4_8_7, VI1_D13_G5_Y5_0, SEL_VI1_0),
	PINMUX_IPSR_DATA(IP4_10_9, VI4_D3_C3),
	PINMUX_IPSR_DATA(IP4_10_9, VI0_D18_R2),
	PINMUX_IPSR_MODSEL_DATA(IP4_10_9, VI1_D14_G6_Y6_0, SEL_VI1_0),
	PINMUX_IPSR_DATA(IP4_12_11, VI4_D4_C4),
	PINMUX_IPSR_DATA(IP4_12_11, VI0_D19_R3),
	PINMUX_IPSR_MODSEL_DATA(IP4_12_11, VI1_D15_G7_Y7_0, SEL_VI1_0),
	PINMUX_IPSR_DATA(IP4_14_13, VI4_D5_C5),
	PINMUX_IPSR_DATA(IP4_14_13, VI0_D20_R4),
	PINMUX_IPSR_DATA(IP4_14_13, VI2_D12_Y4),
	PINMUX_IPSR_DATA(IP4_16_15, VI4_D6_C6),
	PINMUX_IPSR_DATA(IP4_16_15, VI0_D21_R5),
	PINMUX_IPSR_DATA(IP4_16_15, VI2_D13_Y5),
	PINMUX_IPSR_DATA(IP4_18_17, VI4_D7_C7),
	PINMUX_IPSR_DATA(IP4_18_17, VI0_D22_R6),
	PINMUX_IPSR_DATA(IP4_18_17, VI2_D14_Y6),
	PINMUX_IPSR_DATA(IP4_20_19, VI4_D8_Y0),
	PINMUX_IPSR_DATA(IP4_20_19, VI0_D23_R7),
	PINMUX_IPSR_DATA(IP4_20_19, VI2_D15_Y7),
	PINMUX_IPSR_DATA(IP4_21, VI4_D9_Y1),
	PINMUX_IPSR_DATA(IP4_21, VI3_D12_Y4),
	PINMUX_IPSR_DATA(IP4_22, VI4_D10_Y2),
	PINMUX_IPSR_DATA(IP4_22, VI3_D13_Y5),
	PINMUX_IPSR_DATA(IP4_23, VI4_D11_Y3),
	PINMUX_IPSR_DATA(IP4_23, VI3_D14_Y6),
	PINMUX_IPSR_DATA(IP4_24, VI4_FIELD),
	PINMUX_IPSR_DATA(IP4_24, VI3_D15_Y7),

	PINMUX_IPSR_DATA(IP5_0, VI5_CLKENB),
	PINMUX_IPSR_MODSEL_DATA(IP5_0, VI1_D12_G4_Y4_1, SEL_VI1_1),
	PINMUX_IPSR_DATA(IP5_1, VI5_HSYNC),
	PINMUX_IPSR_MODSEL_DATA(IP5_1, VI1_D13_G5_Y5_1, SEL_VI1_1),
	PINMUX_IPSR_DATA(IP5_2, VI5_VSYNC),
	PINMUX_IPSR_MODSEL_DATA(IP5_2, VI1_D14_G6_Y6_1, SEL_VI1_1),
	PINMUX_IPSR_DATA(IP5_3, VI5_D0_C0),
	PINMUX_IPSR_MODSEL_DATA(IP5_3, VI1_D15_G7_Y7_1, SEL_VI1_1),
	PINMUX_IPSR_DATA(IP5_4, VI5_D1_C1),
	PINMUX_IPSR_DATA(IP5_4, VI1_D16_R0),
	PINMUX_IPSR_DATA(IP5_5, VI5_D2_C2),
	PINMUX_IPSR_DATA(IP5_5, VI1_D17_R1),
	PINMUX_IPSR_DATA(IP5_6, VI5_D3_C3),
	PINMUX_IPSR_DATA(IP5_6, VI1_D18_R2),
	PINMUX_IPSR_DATA(IP5_7, VI5_D4_C4),
	PINMUX_IPSR_DATA(IP5_7, VI1_D19_R3),
	PINMUX_IPSR_DATA(IP5_8, VI5_D5_C5),
	PINMUX_IPSR_DATA(IP5_8, VI1_D20_R4),
	PINMUX_IPSR_DATA(IP5_9, VI5_D6_C6),
	PINMUX_IPSR_DATA(IP5_9, VI1_D21_R5),
	PINMUX_IPSR_DATA(IP5_10, VI5_D7_C7),
	PINMUX_IPSR_DATA(IP5_10, VI1_D22_R6),
	PINMUX_IPSR_DATA(IP5_11, VI5_D8_Y0),
	PINMUX_IPSR_DATA(IP5_11, VI1_D23_R7),

	PINMUX_IPSR_DATA(IP6_0, MSIOF0_SCK),
	PINMUX_IPSR_DATA(IP6_0, HSCK0),
	PINMUX_IPSR_DATA(IP6_1, MSIOF0_SYNC),
	PINMUX_IPSR_DATA(IP6_1, HCTS0),
	PINMUX_IPSR_DATA(IP6_2, MSIOF0_TXD),
	PINMUX_IPSR_DATA(IP6_2, HTX0),
	PINMUX_IPSR_DATA(IP6_3, MSIOF0_RXD),
	PINMUX_IPSR_DATA(IP6_3, HRX0),
	PINMUX_IPSR_DATA(IP6_4, MSIOF1_SCK),
	PINMUX_IPSR_DATA(IP6_4, HSCK1),
	PINMUX_IPSR_DATA(IP6_5, MSIOF1_SYNC),
	PINMUX_IPSR_DATA(IP6_5, HRTS1),
	PINMUX_IPSR_DATA(IP6_6, MSIOF1_TXD),
	PINMUX_IPSR_DATA(IP6_6, HTX1),
	PINMUX_IPSR_DATA(IP6_7, MSIOF1_RXD),
	PINMUX_IPSR_DATA(IP6_7, HRX1),
	PINMUX_IPSR_DATA(IP6_9_8, DRACK0),
	PINMUX_IPSR_DATA(IP6_9_8, SCK2),
	PINMUX_IPSR_DATA(IP6_11_10, DACK0),
	PINMUX_IPSR_DATA(IP6_11_10, TX2),
	PINMUX_IPSR_DATA(IP6_13_12, DREQ0),
	PINMUX_IPSR_DATA(IP6_13_12, RX2),
	PINMUX_IPSR_DATA(IP6_15_14, DACK1),
	PINMUX_IPSR_DATA(IP6_15_14, SCK3),
	PINMUX_IPSR_DATA(IP6_16, TX3),
	PINMUX_IPSR_DATA(IP6_18_17, DREQ1),
	PINMUX_IPSR_DATA(IP6_18_17, RX3),

	PINMUX_IPSR_DATA(IP7_1_0, PWM0),
	PINMUX_IPSR_DATA(IP7_1_0, TCLK1),
	PINMUX_IPSR_DATA(IP7_1_0, FSO_CFE_0),
	PINMUX_IPSR_DATA(IP7_3_2, PWM1),
	PINMUX_IPSR_DATA(IP7_3_2, TCLK2),
	PINMUX_IPSR_DATA(IP7_3_2, FSO_CFE_1),
	PINMUX_IPSR_DATA(IP7_5_4, PWM2),
	PINMUX_IPSR_DATA(IP7_5_4, TCLK3),
	PINMUX_IPSR_DATA(IP7_5_4, FSO_TOE),
	PINMUX_IPSR_DATA(IP7_6, PWM3),
	PINMUX_IPSR_DATA(IP7_7, PWM4),
	PINMUX_IPSR_DATA(IP7_9_8, SSI_SCK3),
	PINMUX_IPSR_DATA(IP7_9_8, TPU0TO0),
	PINMUX_IPSR_DATA(IP7_11_10, SSI_WS3),
	PINMUX_IPSR_DATA(IP7_11_10, TPU0TO1),
	PINMUX_IPSR_DATA(IP7_13_12, SSI_SDATA3),
	PINMUX_IPSR_DATA(IP7_13_12, TPU0TO2),
	PINMUX_IPSR_DATA(IP7_15_14, SSI_SCK4),
	PINMUX_IPSR_DATA(IP7_15_14, TPU0TO3),
	PINMUX_IPSR_DATA(IP7_16, SSI_WS4),
	PINMUX_IPSR_DATA(IP7_17, SSI_SDATA4),
	PINMUX_IPSR_DATA(IP7_18, AUDIO_CLKOUT),
	PINMUX_IPSR_DATA(IP7_19, AUDIO_CLKA),
	PINMUX_IPSR_DATA(IP7_20, AUDIO_CLKB),
};

static struct pinmux_gpio pinmux_gpios[] = {
	PINMUX_GPIO_GP_ALL(),

	GPIO_FN(DU1_DB2_C0_DATA12), GPIO_FN(DU1_DB3_C1_DATA13),
	GPIO_FN(DU1_DB4_C2_DATA14), GPIO_FN(DU1_DB5_C3_DATA15),
	GPIO_FN(DU1_DB6_C4), GPIO_FN(DU1_DB7_C5),
	GPIO_FN(DU1_EXHSYNC_DU1_HSYNC), GPIO_FN(DU1_EXVSYNC_DU1_VSYNC),
	GPIO_FN(DU1_EXODDF_DU1_ODDF_DISP_CDE), GPIO_FN(DU1_DISP), GPIO_FN(DU1_CDE),

	GPIO_FN(D0), GPIO_FN(D1), GPIO_FN(D2), GPIO_FN(D3),
	GPIO_FN(D4), GPIO_FN(D5), GPIO_FN(D6), GPIO_FN(D7),
	GPIO_FN(D8), GPIO_FN(D9), GPIO_FN(D10), GPIO_FN(D11),
	GPIO_FN(D12), GPIO_FN(D13), GPIO_FN(D14), GPIO_FN(D15),
	GPIO_FN(A0), GPIO_FN(A1), GPIO_FN(A2), GPIO_FN(A3),
	GPIO_FN(A4), GPIO_FN(A5), GPIO_FN(A6), GPIO_FN(A7),
	GPIO_FN(A8), GPIO_FN(A9), GPIO_FN(A10), GPIO_FN(A11),
	GPIO_FN(A12), GPIO_FN(A13), GPIO_FN(A14), GPIO_FN(A15),

	GPIO_FN(A16), GPIO_FN(A17), GPIO_FN(A18), GPIO_FN(A19),
	GPIO_FN(CS1_A26), GPIO_FN(EX_CS0), GPIO_FN(EX_CS1), GPIO_FN(EX_CS2),
	GPIO_FN(EX_CS3), GPIO_FN(EX_CS4), GPIO_FN(EX_CS5), GPIO_FN(BS),
	GPIO_FN(RD), GPIO_FN(RD_WR), GPIO_FN(WE0), GPIO_FN(WE1),
	GPIO_FN(EX_WAIT0), GPIO_FN(IRQ0), GPIO_FN(IRQ1), GPIO_FN(IRQ2),
	GPIO_FN(IRQ3), GPIO_FN(CS0),

	GPIO_FN(VI0_CLK), GPIO_FN(VI0_CLKENB), GPIO_FN(VI0_HSYNC),
	GPIO_FN(VI0_VSYNC), GPIO_FN(VI0_D0_B0_C0), GPIO_FN(VI0_D1_B1_C1),
	GPIO_FN(VI0_D2_B2_C2), GPIO_FN(VI0_D3_B3_C3), GPIO_FN(VI0_D4_B4_C4),
	GPIO_FN(VI0_D5_B5_C5), GPIO_FN(VI0_D6_B6_C6), GPIO_FN(VI0_D7_B7_C7),
	GPIO_FN(VI0_D8_G0_Y0), GPIO_FN(VI0_D9_G1_Y1), GPIO_FN(VI0_D10_G2_Y2),
	GPIO_FN(VI0_D11_G3_Y3), GPIO_FN(VI0_FIELD),

	GPIO_FN(VI1_CLK), GPIO_FN(VI1_CLKENB), GPIO_FN(VI1_HSYNC),
	GPIO_FN(VI1_VSYNC), GPIO_FN(VI1_D0_B0_C0), GPIO_FN(VI1_D1_B1_C1),
	GPIO_FN(VI1_D2_B2_C2), GPIO_FN(VI1_D3_B3_C3), GPIO_FN(VI1_D4_B4_C4),
	GPIO_FN(VI1_D5_B5_C5), GPIO_FN(VI1_D6_B6_C6), GPIO_FN(VI1_D7_B7_C7),
	GPIO_FN(VI1_D8_G0_Y0), GPIO_FN(VI1_D9_G1_Y1), GPIO_FN(VI1_D10_G2_Y2),
	GPIO_FN(VI1_D11_G3_Y3), GPIO_FN(VI1_FIELD),

	GPIO_FN(VI3_D10_Y2), GPIO_FN(VI3_FIELD),

	GPIO_FN(VI4_CLK),

	GPIO_FN(VI5_CLK), GPIO_FN(VI5_D9_Y1), GPIO_FN(VI5_D10_Y2),
	GPIO_FN(VI5_D11_Y3), GPIO_FN(VI5_FIELD),

	GPIO_FN(HRTS0), GPIO_FN(HCTS1), GPIO_FN(SCK0), GPIO_FN(CTS0),
	GPIO_FN(RTS0), GPIO_FN(TX0), GPIO_FN(RX0), GPIO_FN(SCK1),
	GPIO_FN(CTS1), GPIO_FN(RTS1), GPIO_FN(TX1), GPIO_FN(RX1),
	GPIO_FN(SCIF_CLK), GPIO_FN(CAN0_TX), GPIO_FN(CAN0_RX), GPIO_FN(CAN_CLK),
	GPIO_FN(CAN1_TX), GPIO_FN(CAN1_RX),

	GPIO_FN(SD0_CLK), GPIO_FN(SD0_CMD), GPIO_FN(SD0_DAT0),
	GPIO_FN(SD0_DAT1), GPIO_FN(SD0_DAT2), GPIO_FN(SD0_DAT3),
	GPIO_FN(SD0_CD), GPIO_FN(SD0_WP), GPIO_FN(ADICLK),
	GPIO_FN(ADICS_SAMP), GPIO_FN(ADIDATA), GPIO_FN(ADICHS0),
	GPIO_FN(ADICHS1), GPIO_FN(ADICHS2), GPIO_FN(AVS1),
	GPIO_FN(AVS2),

	GPIO_FN(DU0_DR0_DATA0), GPIO_FN(DU0_DR1_DATA1),
	GPIO_FN(DU0_DR2_Y4_DATA2), GPIO_FN(DU0_DR3_Y5_DATA3),
	GPIO_FN(DU0_DR4_Y6_DATA4), GPIO_FN(DU0_DR5_Y7_DATA5),
	GPIO_FN(DU0_DR6_Y8_DATA6), GPIO_FN(DU0_DR7_Y9_DATA7),
	GPIO_FN(DU0_DG0_DATA8), GPIO_FN(DU0_DG1_DATA9),
	GPIO_FN(DU0_DG2_C6_DATA10), GPIO_FN(DU0_DG3_C7_DATA11),
	GPIO_FN(DU0_DG4_Y0_DATA12), GPIO_FN(DU0_DG5_Y1_DATA13),
	GPIO_FN(DU0_DG6_Y2_DATA14), GPIO_FN(DU0_DG7_Y3_DATA15),
	GPIO_FN(DU0_DB0), GPIO_FN(DU0_DB1),
	GPIO_FN(DU0_DB2_C0), GPIO_FN(DU0_DB3_C1), GPIO_FN(DU0_DB4_C2),
	GPIO_FN(DU0_DB5_C3), GPIO_FN(DU0_DB6_C4), GPIO_FN(DU0_DB7_C5),

	GPIO_FN(DU0_EXHSYNC_DU0_HSYNC), GPIO_FN(DU0_EXVSYNC_DU0_VSYNC),
	GPIO_FN(DU0_EXODDF_DU0_ODDF_DISP_CDE), GPIO_FN(DU0_DISP),
	GPIO_FN(DU0_CDE), GPIO_FN(DU1_DR2_Y4_DATA0), GPIO_FN(DU1_DR3_Y5_DATA1),
	GPIO_FN(DU1_DR4_Y6_DATA2), GPIO_FN(DU1_DR5_Y7_DATA3),
	GPIO_FN(DU1_DR6_DATA4), GPIO_FN(DU1_DR7_DATA5),
	GPIO_FN(DU1_DG2_C6_DATA6), GPIO_FN(DU1_DG3_C7_DATA7),
	GPIO_FN(DU1_DG4_Y0_DATA8), GPIO_FN(DU1_DG5_Y1_DATA9),
	GPIO_FN(DU1_DG6_Y2_DATA10), GPIO_FN(DU1_DG7_Y3_DATA11),
	GPIO_FN(A20), GPIO_FN(MOSI_IO0), GPIO_FN(A21), GPIO_FN(MISO_IO1),
	GPIO_FN(A22), GPIO_FN(IO2), GPIO_FN(A23), GPIO_FN(IO3),
	GPIO_FN(A24), GPIO_FN(SPCLK), GPIO_FN(A25), GPIO_FN(SSL),

	GPIO_FN(VI2_CLK), GPIO_FN(AVB_RX_CLK), GPIO_FN(VI2_CLKENB),
	GPIO_FN(AVB_RX_DV), GPIO_FN(VI2_HSYNC), GPIO_FN(AVB_RXD0),
	GPIO_FN(VI2_VSYNC), GPIO_FN(AVB_RXD1), GPIO_FN(VI2_D0_C0),
	GPIO_FN(AVB_RXD2), GPIO_FN(VI2_D1_C1), GPIO_FN(AVB_RXD3),
	GPIO_FN(VI2_D2_C2), GPIO_FN(AVB_RXD4), GPIO_FN(VI2_D3_C3),
	GPIO_FN(AVB_RXD5), GPIO_FN(VI2_D4_C4), GPIO_FN(AVB_RXD6),
	GPIO_FN(VI2_D5_C5), GPIO_FN(AVB_RXD7), GPIO_FN(VI2_D6_C6),
	GPIO_FN(AVB_RX_ER), GPIO_FN(VI2_D7_C7), GPIO_FN(AVB_COL),
	GPIO_FN(VI2_D8_Y0), GPIO_FN(AVB_TXD3), GPIO_FN(VI2_D9_Y1),
	GPIO_FN(AVB_TX_EN), GPIO_FN(VI2_D10_Y2), GPIO_FN(AVB_TXD0),
	GPIO_FN(VI2_D11_Y3), GPIO_FN(AVB_TXD1), GPIO_FN(VI2_FIELD),
	GPIO_FN(AVB_TXD2),

	GPIO_FN(VI3_CLK), GPIO_FN(AVB_TX_CLK), GPIO_FN(VI3_CLKENB),
	GPIO_FN(AVB_TXD4), GPIO_FN(VI3_HSYNC), GPIO_FN(AVB_TXD5),
	GPIO_FN(VI3_VSYNC), GPIO_FN(AVB_TXD6), GPIO_FN(VI3_D0_C0),
	GPIO_FN(AVB_TXD7), GPIO_FN(VI3_D1_C1), GPIO_FN(AVB_TX_ER),
	GPIO_FN(VI3_D2_C2), GPIO_FN(AVB_GTX_CLK), GPIO_FN(VI3_D3_C3),
	GPIO_FN(AVB_MDC), GPIO_FN(VI3_D4_C4), GPIO_FN(AVB_MDIO),
	GPIO_FN(VI3_D5_C5), GPIO_FN(AVB_LINK), GPIO_FN(VI3_D6_C6),
	GPIO_FN(AVB_MAGIC), GPIO_FN(VI3_D7_C7), GPIO_FN(AVB_PHY_INT),
	GPIO_FN(VI3_D8_Y0), GPIO_FN(AVB_CRS), GPIO_FN(VI3_D9_Y1),
	GPIO_FN(AVB_GTXREFCLK), GPIO_FN(VI3_D11_Y3),

	GPIO_FN(VI4_CLKENB), GPIO_FN(VI0_D12_G4_Y4), GPIO_FN(VI4_HSYNC),
	GPIO_FN(VI0_D13_G5_Y5), GPIO_FN(VI4_VSYNC), GPIO_FN(VI0_D14_G6_Y6),
	GPIO_FN(VI4_D0_C0), GPIO_FN(VI0_D15_G7_Y7), GPIO_FN(VI4_D1_C1),
	GPIO_FN(VI0_D16_R0), GPIO_FN(VI1_D12_G4_Y4_0), GPIO_FN(VI4_D2_C2),
	GPIO_FN(VI0_D17_R1), GPIO_FN(VI1_D13_G5_Y5_0), GPIO_FN(VI4_D3_C3),
	GPIO_FN(VI0_D18_R2), GPIO_FN(VI1_D14_G6_Y6_0), GPIO_FN(VI4_D4_C4),
	GPIO_FN(VI0_D19_R3), GPIO_FN(VI1_D15_G7_Y7_0), GPIO_FN(VI4_D5_C5),
	GPIO_FN(VI0_D20_R4), GPIO_FN(VI2_D12_Y4), GPIO_FN(VI4_D6_C6),
	GPIO_FN(VI0_D21_R5), GPIO_FN(VI2_D13_Y5), GPIO_FN(VI4_D7_C7),
	GPIO_FN(VI0_D22_R6), GPIO_FN(VI2_D14_Y6), GPIO_FN(VI4_D8_Y0),
	GPIO_FN(VI0_D23_R7), GPIO_FN(VI2_D15_Y7), GPIO_FN(VI4_D9_Y1),
	GPIO_FN(VI3_D12_Y4), GPIO_FN(VI4_D10_Y2), GPIO_FN(VI3_D13_Y5),
	GPIO_FN(VI4_D11_Y3), GPIO_FN(VI3_D14_Y6), GPIO_FN(VI4_FIELD),
	GPIO_FN(VI3_D15_Y7),

	GPIO_FN(VI5_CLKENB), GPIO_FN(VI1_D12_G4_Y4_1), GPIO_FN(VI5_HSYNC),
	GPIO_FN(VI1_D13_G5_Y5_1), GPIO_FN(VI5_VSYNC), GPIO_FN(VI1_D14_G6_Y6_1),
	GPIO_FN(VI5_D0_C0), GPIO_FN(VI1_D15_G7_Y7_1), GPIO_FN(VI5_D1_C1),
	GPIO_FN(VI1_D16_R0), GPIO_FN(VI5_D2_C2), GPIO_FN(VI1_D17_R1),
	GPIO_FN(VI5_D3_C3), GPIO_FN(VI1_D18_R2), GPIO_FN(VI5_D4_C4),
	GPIO_FN(VI1_D19_R3), GPIO_FN(VI5_D5_C5), GPIO_FN(VI1_D20_R4),
	GPIO_FN(VI5_D6_C6), GPIO_FN(VI1_D21_R5), GPIO_FN(VI5_D7_C7),
	GPIO_FN(VI1_D22_R6), GPIO_FN(VI5_D8_Y0), GPIO_FN(VI1_D23_R7),

	GPIO_FN(MSIOF0_SCK), GPIO_FN(HSCK0), GPIO_FN(MSIOF0_SYNC),
	GPIO_FN(HCTS0), GPIO_FN(MSIOF0_TXD), GPIO_FN(HTX0),
	GPIO_FN(MSIOF0_RXD), GPIO_FN(HRX0), GPIO_FN(MSIOF1_SCK),
	GPIO_FN(HSCK1), GPIO_FN(MSIOF1_SYNC), GPIO_FN(HRTS1),
	GPIO_FN(MSIOF1_TXD), GPIO_FN(HTX1), GPIO_FN(MSIOF1_RXD),
	GPIO_FN(HRX1), GPIO_FN(DRACK0), GPIO_FN(SCK2),
	GPIO_FN(DACK0), GPIO_FN(TX2), GPIO_FN(DREQ0),
	GPIO_FN(RX2), GPIO_FN(DACK1), GPIO_FN(SCK3),
	GPIO_FN(TX3), GPIO_FN(DREQ1), GPIO_FN(RX3),

	GPIO_FN(PWM0), GPIO_FN(TCLK1), GPIO_FN(FSO_CFE_0),
	GPIO_FN(PWM1), GPIO_FN(TCLK2), GPIO_FN(FSO_CFE_1),
	GPIO_FN(PWM2), GPIO_FN(TCLK3), GPIO_FN(FSO_TOE),
	GPIO_FN(PWM3), GPIO_FN(PWM4),
	GPIO_FN(SSI_SCK3), GPIO_FN(TPU0TO0),
	GPIO_FN(SSI_WS3), GPIO_FN(TPU0TO1),
	GPIO_FN(SSI_SDATA3), GPIO_FN(TPU0TO2),
	GPIO_FN(SSI_SCK4), GPIO_FN(TPU0TO3),
	GPIO_FN(SSI_WS4), GPIO_FN(SSI_SDATA4),
	GPIO_FN(AUDIO_CLKOUT), GPIO_FN(AUDIO_CLKA), GPIO_FN(AUDIO_CLKB),

};

static struct pinmux_cfg_reg pinmux_config_regs[] = {
	{ PINMUX_CFG_REG("GPSR0", 0xE6060004, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		GP_0_28_FN, FN_IP1_4,
		GP_0_27_FN, FN_IP1_3,
		GP_0_26_FN, FN_IP1_2,
		GP_0_25_FN, FN_IP1_1,
		GP_0_24_FN, FN_IP1_0,
		GP_0_23_FN, FN_IP0_23,
		GP_0_22_FN, FN_IP0_22,
		GP_0_21_FN, FN_IP0_21,
		GP_0_20_FN, FN_IP0_20,
		GP_0_19_FN, FN_IP0_19,
		GP_0_18_FN, FN_IP0_18,
		GP_0_17_FN, FN_IP0_17,
		GP_0_16_FN, FN_IP0_16,
		GP_0_15_FN, FN_IP0_15,
		GP_0_14_FN, FN_IP0_14,
		GP_0_13_FN, FN_IP0_13,
		GP_0_12_FN, FN_IP0_12,
		GP_0_11_FN, FN_IP0_11,
		GP_0_10_FN, FN_IP0_10,
		GP_0_9_FN, FN_IP0_9,
		GP_0_8_FN, FN_IP0_8,
		GP_0_7_FN, FN_IP0_7,
		GP_0_6_FN, FN_IP0_6,
		GP_0_5_FN, FN_IP0_5,
		GP_0_4_FN, FN_IP0_4,
		GP_0_3_FN, FN_IP0_3,
		GP_0_2_FN, FN_IP0_2,
		GP_0_1_FN, FN_IP0_1,
		GP_0_0_FN, FN_IP0_0 }
	},
	{ PINMUX_CFG_REG("GPSR1", 0xE6060008, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_1_22_FN, FN_DU1_CDE,
		GP_1_21_FN, FN_DU1_DISP,
		GP_1_20_FN, FN_DU1_EXODDF_DU1_ODDF_DISP_CDE,
		GP_1_19_FN, FN_DU1_EXVSYNC_DU1_VSYNC,
		GP_1_18_FN, FN_DU1_EXHSYNC_DU1_HSYNC,
		GP_1_17_FN, FN_DU1_DB7_C5,
		GP_1_16_FN, FN_DU1_DB6_C4,
		GP_1_15_FN, FN_DU1_DB5_C3_DATA15,
		GP_1_14_FN, FN_DU1_DB4_C2_DATA14,
		GP_1_13_FN, FN_DU1_DB3_C1_DATA13,
		GP_1_12_FN, FN_DU1_DB2_C0_DATA12,
		GP_1_11_FN, FN_IP1_16,
		GP_1_10_FN, FN_IP1_15,
		GP_1_9_FN, FN_IP1_14,
		GP_1_8_FN, FN_IP1_13,
		GP_1_7_FN, FN_IP1_12,
		GP_1_6_FN, FN_IP1_11,
		GP_1_5_FN, FN_IP1_10,
		GP_1_4_FN, FN_IP1_9,
		GP_1_3_FN, FN_IP1_8,
		GP_1_2_FN, FN_IP1_7,
		GP_1_1_FN, FN_IP1_6,
		GP_1_0_FN, FN_IP1_5, }
	},
	{ PINMUX_CFG_REG("GPSR2", 0xE606000C, 32, 1) {
		GP_2_31_FN, FN_A15,
		GP_2_30_FN, FN_A14,
		GP_2_29_FN, FN_A13,
		GP_2_28_FN, FN_A12,
		GP_2_27_FN, FN_A11,
		GP_2_26_FN, FN_A10,
		GP_2_25_FN, FN_A9,
		GP_2_24_FN, FN_A8,
		GP_2_23_FN, FN_A7,
		GP_2_22_FN, FN_A6,
		GP_2_21_FN, FN_A5,
		GP_2_20_FN, FN_A4,
		GP_2_19_FN, FN_A3,
		GP_2_18_FN, FN_A2,
		GP_2_17_FN, FN_A1,
		GP_2_16_FN, FN_A0,
		GP_2_15_FN, FN_D15,
		GP_2_14_FN, FN_D14,
		GP_2_13_FN, FN_D13,
		GP_2_12_FN, FN_D12,
		GP_2_11_FN, FN_D11,
		GP_2_10_FN, FN_D10,
		GP_2_9_FN, FN_D9,
		GP_2_8_FN, FN_D8,
		GP_2_7_FN, FN_D7,
		GP_2_6_FN, FN_D6,
		GP_2_5_FN, FN_D5,
		GP_2_4_FN, FN_D4,
		GP_2_3_FN, FN_D3,
		GP_2_2_FN, FN_D2,
		GP_2_1_FN, FN_D1,
		GP_2_0_FN, FN_D0 }
	},
	{ PINMUX_CFG_REG("GPSR3", 0xE6060010, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_3_27_FN, FN_CS0,
		GP_3_26_FN, FN_IP1_22,
		GP_3_25_FN, FN_IP1_21,
		GP_3_24_FN, FN_IP1_20,
		GP_3_23_FN, FN_IP1_19,
		GP_3_22_FN, FN_IRQ3,
		GP_3_21_FN, FN_IRQ2,
		GP_3_20_FN, FN_IRQ1,
		GP_3_19_FN, FN_IRQ0,
		GP_3_18_FN, FN_EX_WAIT0,
		GP_3_17_FN, FN_WE1,
		GP_3_16_FN, FN_WE0,
		GP_3_15_FN, FN_RD_WR,
		GP_3_14_FN, FN_RD,
		GP_3_13_FN, FN_BS,
		GP_3_12_FN, FN_EX_CS5,
		GP_3_11_FN, FN_EX_CS4,
		GP_3_10_FN, FN_EX_CS3,
		GP_3_9_FN, FN_EX_CS2,
		GP_3_8_FN, FN_EX_CS1,
		GP_3_7_FN, FN_EX_CS0,
		GP_3_6_FN, FN_CS1_A26,
		GP_3_5_FN, FN_IP1_18,
		GP_3_4_FN, FN_IP1_17,
		GP_3_3_FN, FN_A19,
		GP_3_2_FN, FN_A18,
		GP_3_1_FN, FN_A17,
		GP_3_0_FN, FN_A16 }
	},
	{ PINMUX_CFG_REG("GPSR4", 0xE6060014, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_4_16_FN, FN_VI0_FIELD,
		GP_4_15_FN, FN_VI0_D11_G3_Y3,
		GP_4_14_FN, FN_VI0_D10_G2_Y2,
		GP_4_13_FN, FN_VI0_D9_G1_Y1,
		GP_4_12_FN, FN_VI0_D8_G0_Y0,
		GP_4_11_FN, FN_VI0_D7_B7_C7,
		GP_4_10_FN, FN_VI0_D6_B6_C6,
		GP_4_9_FN, FN_VI0_D5_B5_C5,
		GP_4_8_FN, FN_VI0_D4_B4_C4,
		GP_4_7_FN, FN_VI0_D3_B3_C3,
		GP_4_6_FN, FN_VI0_D2_B2_C2,
		GP_4_5_FN, FN_VI0_D1_B1_C1,
		GP_4_4_FN, FN_VI0_D0_B0_C0,
		GP_4_3_FN, FN_VI0_VSYNC,
		GP_4_2_FN, FN_VI0_HSYNC,
		GP_4_1_FN, FN_VI0_CLKENB,
		GP_4_0_FN, FN_VI0_CLK }
	},
	{ PINMUX_CFG_REG("GPSR5", 0xE6060018, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_5_16_FN, FN_VI1_FIELD,
		GP_5_15_FN, FN_VI1_D11_G3_Y3,
		GP_5_14_FN, FN_VI1_D10_G2_Y2,
		GP_5_13_FN, FN_VI1_D9_G1_Y1,
		GP_5_12_FN, FN_VI1_D8_G0_Y0,
		GP_5_11_FN, FN_VI1_D7_B7_C7,
		GP_5_10_FN, FN_VI1_D6_B6_C6,
		GP_5_9_FN, FN_VI1_D5_B5_C5,
		GP_5_8_FN, FN_VI1_D4_B4_C4,
		GP_5_7_FN, FN_VI1_D3_B3_C3,
		GP_5_6_FN, FN_VI1_D2_B2_C2,
		GP_5_5_FN, FN_VI1_D1_B1_C1,
		GP_5_4_FN, FN_VI1_D0_B0_C0,
		GP_5_3_FN, FN_VI1_VSYNC,
		GP_5_2_FN, FN_VI1_HSYNC,
		GP_5_1_FN, FN_VI1_CLKENB,
		GP_5_0_FN, FN_VI1_CLK }
	},
	{ PINMUX_CFG_REG("GPSR6", 0xE606001C, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_6_16_FN, FN_IP2_16,
		GP_6_15_FN, FN_IP2_15,
		GP_6_14_FN, FN_IP2_14,
		GP_6_13_FN, FN_IP2_13,
		GP_6_12_FN, FN_IP2_12,
		GP_6_11_FN, FN_IP2_11,
		GP_6_10_FN, FN_IP2_10,
		GP_6_9_FN, FN_IP2_9,
		GP_6_8_FN, FN_IP2_8,
		GP_6_7_FN, FN_IP2_7,
		GP_6_6_FN, FN_IP2_6,
		GP_6_5_FN, FN_IP2_5,
		GP_6_4_FN, FN_IP2_4,
		GP_6_3_FN, FN_IP2_3,
		GP_6_2_FN, FN_IP2_2,
		GP_6_1_FN, FN_IP2_1,
		GP_6_0_FN, FN_IP2_0 }
	},
	{ PINMUX_CFG_REG("GPSR7", 0xE6060020, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_7_16_FN, FN_VI3_FIELD,
		GP_7_15_FN, FN_IP3_14,
		GP_7_14_FN, FN_VI3_D10_Y2,
		GP_7_13_FN, FN_IP3_13,
		GP_7_12_FN, FN_IP3_12,
		GP_7_11_FN, FN_IP3_11,
		GP_7_10_FN, FN_IP3_10,
		GP_7_9_FN, FN_IP3_9,
		GP_7_8_FN, FN_IP3_8,
		GP_7_7_FN, FN_IP3_7,
		GP_7_6_FN, FN_IP3_6,
		GP_7_5_FN, FN_IP3_5,
		GP_7_4_FN, FN_IP3_4,
		GP_7_3_FN, FN_IP3_3,
		GP_7_2_FN, FN_IP3_2,
		GP_7_1_FN, FN_IP3_1,
		GP_7_0_FN, FN_IP3_0 }
	},
	{ PINMUX_CFG_REG("GPSR8", 0xE6060024, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_8_16_FN, FN_IP4_24,
		GP_8_15_FN, FN_IP4_23,
		GP_8_14_FN, FN_IP4_22,
		GP_8_13_FN, FN_IP4_21,
		GP_8_12_FN, FN_IP4_20_19,
		GP_8_11_FN, FN_IP4_18_17,
		GP_8_10_FN, FN_IP4_16_15,
		GP_8_9_FN, FN_IP4_14_13,
		GP_8_8_FN, FN_IP4_12_11,
		GP_8_7_FN, FN_IP4_10_9,
		GP_8_6_FN, FN_IP4_8_7,
		GP_8_5_FN, FN_IP4_6_5,
		GP_8_4_FN, FN_IP4_4,
		GP_8_3_FN, FN_IP4_3_2,
		GP_8_2_FN, FN_IP4_1,
		GP_8_1_FN, FN_IP4_0,
		GP_8_0_FN, FN_VI4_CLK }
	},
	{ PINMUX_CFG_REG("GPSR9", 0xE6060028, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_9_16_FN, FN_VI5_FIELD,
		GP_9_15_FN, FN_VI5_D11_Y3,
		GP_9_14_FN, FN_VI5_D10_Y2,
		GP_9_13_FN, FN_VI5_D9_Y1,
		GP_9_12_FN, FN_IP5_11,
		GP_9_11_FN, FN_IP5_10,
		GP_9_10_FN, FN_IP5_9,
		GP_9_9_FN, FN_IP5_8,
		GP_9_8_FN, FN_IP5_7,
		GP_9_7_FN, FN_IP5_6,
		GP_9_6_FN, FN_IP5_5,
		GP_9_5_FN, FN_IP5_4,
		GP_9_4_FN, FN_IP5_3,
		GP_9_3_FN, FN_IP5_2,
		GP_9_2_FN, FN_IP5_1,
		GP_9_1_FN, FN_IP5_0,
		GP_9_0_FN, FN_VI5_CLK }
	},
	{ PINMUX_CFG_REG("GPSR10", 0xE606002C, 32, 1) {
		GP_10_31_FN, FN_CAN1_RX,
		GP_10_30_FN, FN_CAN1_TX,
		GP_10_29_FN, FN_CAN_CLK,
		GP_10_28_FN, FN_CAN0_RX,
		GP_10_27_FN, FN_CAN0_TX,
		GP_10_26_FN, FN_SCIF_CLK,
		GP_10_25_FN, FN_IP6_18_17,
		GP_10_24_FN, FN_IP6_16,
		GP_10_23_FN, FN_IP6_15_14,
		GP_10_22_FN, FN_IP6_13_12,
		GP_10_21_FN, FN_IP6_11_10,
		GP_10_20_FN, FN_IP6_9_8,
		GP_10_19_FN, FN_RX1,
		GP_10_18_FN, FN_TX1,
		GP_10_17_FN, FN_RTS1,
		GP_10_16_FN, FN_CTS1,
		GP_10_15_FN, FN_SCK1,
		GP_10_14_FN, FN_RX0,
		GP_10_13_FN, FN_TX0,
		GP_10_12_FN, FN_RTS0,
		GP_10_11_FN, FN_CTS0,
		GP_10_10_FN, FN_SCK0,
		GP_10_9_FN, FN_IP6_7,
		GP_10_8_FN, FN_IP6_6,
		GP_10_7_FN, FN_HCTS1,
		GP_10_6_FN, FN_IP6_5,
		GP_10_5_FN, FN_IP6_4,
		GP_10_4_FN, FN_IP6_3,
		GP_10_3_FN, FN_IP6_2,
		GP_10_2_FN, FN_HRTS0,
		GP_10_1_FN, FN_IP6_1,
		GP_10_0_FN, FN_IP6_0 }
	},
	{ PINMUX_CFG_REG("GPSR11", 0xE6060030, 32, 1) {
		0, 0,
		0, 0,
		GP_11_29_FN, FN_AVS2,
		GP_11_28_FN, FN_AVS1,
		GP_11_27_FN, FN_ADICHS2,
		GP_11_26_FN, FN_ADICHS1,
		GP_11_25_FN, FN_ADICHS0,
		GP_11_24_FN, FN_ADIDATA,
		GP_11_23_FN, FN_ADICS_SAMP,
		GP_11_22_FN, FN_ADICLK,
		GP_11_21_FN, FN_IP7_20,
		GP_11_20_FN, FN_IP7_19,
		GP_11_19_FN, FN_IP7_18,
		GP_11_18_FN, FN_IP7_17,
		GP_11_17_FN, FN_IP7_16,
		GP_11_16_FN, FN_IP7_15_14,
		GP_11_15_FN, FN_IP7_13_12,
		GP_11_14_FN, FN_IP7_11_10,
		GP_11_13_FN, FN_IP7_9_8,
		GP_11_12_FN, FN_SD0_WP,
		GP_11_11_FN, FN_SD0_CD,
		GP_11_10_FN, FN_SD0_DAT3,
		GP_11_9_FN, FN_SD0_DAT2,
		GP_11_8_FN, FN_SD0_DAT1,
		GP_11_7_FN, FN_SD0_DAT0,
		GP_11_6_FN, FN_SD0_CMD,
		GP_11_5_FN, FN_SD0_CLK,
		GP_11_4_FN, FN_IP7_7,
		GP_11_3_FN, FN_IP7_6,
		GP_11_2_FN, FN_IP7_5_4,
		GP_11_1_FN, FN_IP7_3_2,
		GP_11_0_FN, FN_IP7_1_0 }
	},
	/* IPSR0 */
	{ PINMUX_CFG_REG("IPSR0", 0xE6060040, 32 ,1) {
		/* IP0_31 [1] */
		0, 0,
		/* IP0_30 [1] */
		0, 0,
		/* IP0_29 [1] */
		0, 0,
		/* IP0_28 [1] */
		0, 0,
		/* IP0_27 [1] */
		0, 0,
		/* IP0_26 [1] */
		0, 0,
		/* IP0_25 [1] */
		0, 0,
		/* IP0_24 [1] */
		0, 0,
		/* IP0_23 [1] */
		FN_DU0_DB7_C5, 0,
		/* IP0_22 [1] */
		FN_DU0_DB6_C4, 0,
		/* IP0_21 [1] */
		FN_DU0_DB5_C3, 0,
		/* IP0_20 [1] */
		FN_DU0_DB4_C2, 0,
		/* IP0_19 [1] */
		FN_DU0_DB3_C1, 0,
		/* IP0_18 [1] */
		FN_DU0_DB2_C0, 0,
		/* IP0_17 [1] */
		FN_DU0_DB1, 0,
		/* IP0_16 [1] */
		FN_DU0_DB0, 0,
		/* IP0_15 [1] */
		FN_DU0_DG7_Y3_DATA15, 0,
		/* IP0_14 [1] */
		FN_DU0_DG6_Y2_DATA14, 0,
		/* IP0_13 [1] */
		FN_DU0_DG5_Y1_DATA13, 0,
		/* IP0_12 [1] */
		FN_DU0_DG4_Y0_DATA12, 0,
		/* IP0_11 [1] */
		FN_DU0_DG3_C7_DATA11, 0,
		/* IP0_10 [1] */
		FN_DU0_DG2_C6_DATA10, 0,
		/* IP0_9 [1] */
		FN_DU0_DG1_DATA9, 0,
		/* IP0_8 [1] */
		FN_DU0_DG0_DATA8, 0,
		/* IP0_7 [1] */
		FN_DU0_DR7_Y9_DATA7, 0,
		/* IP0_6 [1] */
		FN_DU0_DR6_Y8_DATA6, 0,
		/* IP0_5 [1] */
		FN_DU0_DR5_Y7_DATA5, 0,
		/* IP0_4 [1] */
		FN_DU0_DR4_Y6_DATA4, 0,
		/* IP0_3 [1] */
		FN_DU0_DR3_Y5_DATA3, 0,
		/* IP0_2 [1] */
		FN_DU0_DR2_Y4_DATA2, 0,
		/* IP0_1 [1] */
		FN_DU0_DR1_DATA1, 0,
		/* IP0_0 [1] */
		FN_DU0_DR0_DATA0, 0, }
	},
	/* IPSR1 */
	{ PINMUX_CFG_REG("IPSR1", 0xE6060044, 32, 1) {
		/* IP1_31 [1] */
		0, 0,
		/* IP1_30 [1] */
		0, 0,
		/* IP1_29 [1] */
		0, 0,
		/* IP1_28 [1] */
		0, 0,
		/* IP1_27 [1] */
		0, 0,
		/* IP1_26 [1] */
		0, 0,
		/* IP1_25 [1] */
		0, 0,
		/* IP1_24 [1] */
		0, 0,
		/* IP1_23 [1] */
		0, 0,
		/* IP1_22 [1] */
		FN_A25, FN_SSL,
		/* IP1_21 [1] */
		FN_A24, FN_SPCLK,
		/* IP1_20 [1] */
		FN_A23, FN_IO3,
		/* IP1_19 [1] */
		FN_A22, FN_IO2,
		/* IP1_18 [1] */
		FN_A21, FN_MISO_IO1,
		/* IP1_17 [1] */
		FN_A20, FN_MOSI_IO0,
		/* IP1_16 [1] */
		FN_DU1_DG7_Y3_DATA11, 0,
		/* IP1_15 [1] */
		FN_DU1_DG6_Y2_DATA10, 0,
		/* IP1_14 [1] */
		FN_DU1_DG5_Y1_DATA9, 0,
		/* IP1_13 [1] */
		FN_DU1_DG4_Y0_DATA8, 0,
		/* IP1_12 [1] */
		FN_DU1_DG3_C7_DATA7, 0,
		/* IP1_11 [1] */
		FN_DU1_DG2_C6_DATA6, 0,
		/* IP1_10 [1] */
		FN_DU1_DR7_DATA5, 0,
		/* IP1_9 [1] */
		FN_DU1_DR6_DATA4, 0,
		/* IP1_8 [1] */
		FN_DU1_DR5_Y7_DATA3, 0,
		/* IP1_7 [1] */
		FN_DU1_DR4_Y6_DATA2, 0,
		/* IP1_6 [1] */
		FN_DU1_DR3_Y5_DATA1, 0,
		/* IP1_5 [1] */
		FN_DU1_DR2_Y4_DATA0, 0,
		/* IP1_4 [1] */
		FN_DU0_CDE, 0,
		/* IP1_3 [1] */
		FN_DU0_DISP, 0,
		/* IP1_2 [1] */
		FN_DU0_EXODDF_DU0_ODDF_DISP_CDE, 0,
		/* IP1_1 [1] */
		FN_DU0_EXVSYNC_DU0_VSYNC, 0,
		/* IP1_0 [1] */
		FN_DU0_EXHSYNC_DU0_HSYNC, 0, }
	},
	/* IPSR2 */
	{ PINMUX_CFG_REG("IPSR2", 0xE6060048, 32, 1) {
		/* IP2_31 [1] */
		0, 0,
		/* IP2_30 [1] */
		0, 0,
		/* IP2_29 [1] */
		0, 0,
		/* IP2_28 [1] */
		0, 0,
		/* IP2_27 [1] */
		0, 0,
		/* IP2_26 [1] */
		0, 0,
		/* IP2_25 [1] */
		0, 0,
		/* IP2_24 [1] */
		0, 0,
		/* IP2_23 [1] */
		0, 0,
		/* IP2_22 [1] */
		0, 0,
		/* IP2_21 [1] */
		0, 0,
		/* IP2_20 [1] */
		0, 0,
		/* IP2_19 [1] */
		0, 0,
		/* IP2_18 [1] */
		0, 0,
		/* IP2_17 [1] */
		0, 0,
		/* IP2_16 [1] */
		FN_VI2_FIELD, FN_AVB_TXD2,
		/* IP2_15 [1] */
		FN_VI2_D11_Y3, FN_AVB_TXD1,
		/* IP2_14 [1] */
		FN_VI2_D10_Y2, FN_AVB_TXD0,
		/* IP2_13 [1] */
		FN_VI2_D9_Y1, FN_AVB_TX_EN,
		/* IP2_12 [1] */
		FN_VI2_D8_Y0, FN_AVB_TXD3,
		/* IP2_11 [1] */
		FN_VI2_D7_C7, FN_AVB_COL,
		/* IP2_10 [1] */
		FN_VI2_D6_C6, FN_AVB_RX_ER,
		/* IP2_9 [1] */
		FN_VI2_D5_C5, FN_AVB_RXD7,
		/* IP2_8 [1] */
		FN_VI2_D4_C4, FN_AVB_RXD6,
		/* IP2_7 [1] */
		FN_VI2_D3_C3, FN_AVB_RXD5,
		/* IP2_6 [1] */
		FN_VI2_D2_C2, FN_AVB_RXD4,
		/* IP2_5 [1] */
		FN_VI2_D1_C1, FN_AVB_RXD3,
		/* IP2_4 [1] */
		FN_VI2_D0_C0, FN_AVB_RXD2,
		/* IP2_3 [1] */
		FN_VI2_VSYNC, FN_AVB_RXD1,
		/* IP2_2 [1] */
		FN_VI2_HSYNC, FN_AVB_RXD0,
		/* IP2_1 [1] */
		FN_VI2_CLKENB, FN_AVB_RX_DV,
		/* IP2_0 [1] */
		FN_VI2_CLK, FN_AVB_RX_CLK, }
	},
	/* IPSR3 */
	{ PINMUX_CFG_REG("IPSR3", 0xE606004C, 32, 1) {
		/* IP3_31 [1] */
		0, 0,
		/* IP3_30 [1] */
		0, 0,
		/* IP3_29 [1] */
		0, 0,
		/* IP3_28 [1] */
		0, 0,
		/* IP3_27 [1] */
		0, 0,
		/* IP3_26 [1] */
		0, 0,
		/* IP3_25 [1] */
		0, 0,
		/* IP3_24 [1] */
		0, 0,
		/* IP3_23 [1] */
		0, 0,
		/* IP3_22 [1] */
		0, 0,
		/* IP3_21 [1] */
		0, 0,
		/* IP3_20 [1] */
		0, 0,
		/* IP3_19 [1] */
		0, 0,
		/* IP3_18 [1] */
		0, 0,
		/* IP3_17 [1] */
		0, 0,
		/* IP3_16 [1] */
		0, 0,
		/* IP3_15 [1] */
		0, 0,
		/* IP3_14 [1] */
		FN_VI3_D11_Y3, 0,
		/* IP3_13 [1] */
		FN_VI3_D9_Y1, FN_AVB_GTXREFCLK,
		/* IP3_12 [1] */
		FN_VI3_D8_Y0, FN_AVB_CRS,
		/* IP3_11 [1] */
		FN_VI3_D7_C7, FN_AVB_PHY_INT,
		/* IP3_10 [1] */
		FN_VI3_D6_C6, FN_AVB_MAGIC,
		/* IP3_9 [1] */
		FN_VI3_D5_C5, FN_AVB_LINK,
		/* IP3_8 [1] */
		FN_VI3_D4_C4, FN_AVB_MDIO,
		/* IP3_7 [1] */
		FN_VI3_D3_C3, FN_AVB_MDC,
		/* IP3_6 [1] */
		FN_VI3_D2_C2, FN_AVB_GTX_CLK,
		/* IP3_5 [1] */
		FN_VI3_D1_C1, FN_AVB_TX_ER,
		/* IP3_4 [1] */
		FN_VI3_D0_C0, FN_AVB_TXD7,
		/* IP3_3 [1] */
		FN_VI3_VSYNC, FN_AVB_TXD6,
		/* IP3_2 [1] */
		FN_VI3_HSYNC, FN_AVB_TXD5,
		/* IP3_1 [1] */
		FN_VI3_CLKENB, FN_AVB_TXD4,
		/* IP3_0 [1] */
		FN_VI3_CLK, FN_AVB_TX_CLK,}
	},
	/* IPSR4 */
	{ PINMUX_CFG_REG_VAR("IPSR4", 0xE6060050, 32,
			     1, 1, 1, 1, 1, 1, 1,
			     1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 1, 1) {
		/* IP4_31 [1] */
		0, 0,
		/* IP4_30 [1] */
		0, 0,
		/* IP4_29 [1] */
		0, 0,
		/* IP4_28 [1] */
		0, 0,
		/* IP4_27 [1] */
		0, 0,
		/* IP4_26 [1] */
		0, 0,
		/* IP4_25 [1] */
		0, 0,
		/* IP4_24 [1] */
		FN_VI4_FIELD, FN_VI3_D15_Y7,
		/* IP4_23 [1] */
		FN_VI4_D11_Y3, FN_VI3_D14_Y6,
		/* IP4_22 [1] */
		FN_VI4_D10_Y2, FN_VI3_D13_Y5,
		/* IP4_21 [1] */
		FN_VI4_D9_Y1, FN_VI3_D12_Y4,
		/* IP4_20_19 [2] */
		FN_VI4_D8_Y0, FN_VI0_D23_R7, FN_VI2_D15_Y7, 0,
		/* IP4_18_17 [2] */
		FN_VI4_D7_C7, FN_VI0_D22_R6, FN_VI2_D14_Y6, 0,
		/* IP4_16_15 [2] */
		FN_VI4_D6_C6, FN_VI0_D21_R5, FN_VI2_D13_Y5, 0,
		/* IP4_14_13 [2] */
		FN_VI4_D5_C5, FN_VI0_D20_R4, FN_VI2_D12_Y4, 0,
		/* IP4_12_11 [2] */
		FN_VI4_D4_C4, FN_VI0_D19_R3, FN_VI1_D15_G7_Y7_0, 0,
		/* IP4_10_9 [2] */
		FN_VI4_D3_C3, FN_VI0_D18_R2, FN_VI1_D14_G6_Y6_0, 0,
		/* IP4_8_7 [2] */
		FN_VI4_D2_C2, FN_VI0_D17_R1, FN_VI1_D13_G5_Y5_0, 0,
		/* IP4_6_5 [2] */
		FN_VI4_D1_C1, FN_VI0_D16_R0, FN_VI1_D12_G4_Y4_0, 0,
		/* IP4_4 [1] */
		FN_VI4_D0_C0, FN_VI0_D15_G7_Y7,
		/* IP4_3_2 [2] */
		FN_VI4_VSYNC, FN_VI0_D14_G6_Y6, 0, 0,
		/* IP4_1 [1] */
		FN_VI4_HSYNC, FN_VI0_D13_G5_Y5,
		/* IP4_0 [1] */
		FN_VI4_CLKENB, FN_VI0_D12_G4_Y4,}
	},
	/* IPSR5 */
	{ PINMUX_CFG_REG("IPSR5", 0xE6060054, 32, 1) {
		/* IP5_31 [1] */
		0, 0,
		/* IP5_30 [1] */
		0, 0,
		/* IP5_29 [1] */
		0, 0,
		/* IP5_28 [1] */
		0, 0,
		/* IP5_27 [1] */
		0, 0,
		/* IP5_26 [1] */
		0, 0,
		/* IP5_25 [1] */
		0, 0,
		/* IP5_24 [1] */
		0, 0,
		/* IP5_23 [1] */
		0, 0,
		/* IP5_22 [1] */
		0, 0,
		/* IP5_21 [1] */
		0, 0,
		/* IP5_20 [1] */
		0, 0,
		/* IP5_19 [1] */
		0, 0,
		/* IP5_18 [1] */
		0, 0,
		/* IP5_17 [1] */
		0, 0,
		/* IP5_16 [1] */
		0, 0,
		/* IP5_15 [1] */
		0, 0,
		/* IP5_14 [1] */
		0, 0,
		/* IP5_13 [1] */
		0, 0,
		/* IP5_12 [1] */
		0, 0,
		/* IP5_11 [1] */
		FN_VI5_D8_Y0, FN_VI1_D23_R7,
		/* IP5_10 [1] */
		FN_VI5_D7_C7, FN_VI1_D22_R6,
		/* IP5_9 [1] */
		FN_VI5_D6_C6, FN_VI1_D21_R5,
		/* IP5_8 [1] */
		FN_VI5_D5_C5, FN_VI1_D20_R4,
		/* IP5_7 [1] */
		FN_VI5_D4_C4, FN_VI1_D19_R3,
		/* IP5_6 [1] */
		FN_VI5_D3_C3, FN_VI1_D18_R2,
		/* IP5_5 [1] */
		FN_VI5_D2_C2, FN_VI1_D17_R1,
		/* IP5_4 [1] */
		FN_VI5_D1_C1, FN_VI1_D16_R0,
		/* IP5_3 [1] */
		FN_VI5_D0_C0, FN_VI1_D15_G7_Y7_1,
		/* IP5_2 [1] */
		FN_VI5_VSYNC, FN_VI1_D14_G6_Y6_1,
		/* IP5_1 [1] */
		FN_VI5_HSYNC, FN_VI1_D13_G5_Y5_1,
		/* IP5_0 [1] */
		FN_VI5_CLKENB, FN_VI1_D12_G4_Y4_1,}
	},
	/* IPSR6 */
	{ PINMUX_CFG_REG_VAR("IPSR6", 0xE6060058, 32,
			     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
			     2, 1, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1) {
		/* IP6_31 [1] */
		0, 0,
		/* IP6_30 [1] */
		0, 0,
		/* IP6_29 [1] */
		0, 0,
		/* IP6_28 [1] */
		0, 0,
		/* IP6_27 [1] */
		0, 0,
		/* IP6_26 [1] */
		0, 0,
		/* IP6_25 [1] */
		0, 0,
		/* IP6_24 [1] */
		0, 0,
		/* IP6_23 [1] */
		0, 0,
		/* IP6_22 [1] */
		0, 0,
		/* IP6_21 [1] */
		0, 0,
		/* IP6_20 [1] */
		0, 0,
		/* IP6_19 [1] */
		0, 0,
		/* IP6_18_17 [2] */
		FN_DREQ1, FN_RX3, 0, 0,
		/* IP6_16 [1] */
		FN_TX3, 0,
		/* IP6_15_14 [2] */
		FN_DACK1, FN_SCK3, 0, 0,
		/* IP6_13_12 [2] */
		FN_DREQ0, FN_RX2, 0, 0,
		/* IP6_11_10 [2] */
		FN_DACK0, FN_TX2, 0, 0,
		/* IP6_9_8 [2] */
		FN_DRACK0, FN_SCK2, 0, 0,
		/* IP6_7 [1] */
		FN_MSIOF1_RXD, FN_HRX1,
		/* IP6_6 [1] */
		FN_MSIOF1_TXD, FN_HTX1,
		/* IP6_5 [1] */
		FN_MSIOF1_SYNC, FN_HRTS1,
		/* IP6_4 [1] */
		FN_MSIOF1_SCK, FN_HSCK1,
		/* IP6_3 [1] */
		FN_MSIOF0_RXD, FN_HRX0,
		/* IP6_2 [1] */
		FN_MSIOF0_TXD, FN_HTX0,
		/* IP6_1 [1] */
		FN_MSIOF0_SYNC, FN_HCTS0,
		/* IP6_0 [1] */
		FN_MSIOF0_SCK, FN_HSCK0, }
	},
	/* IPSR7 */
	{ PINMUX_CFG_REG_VAR("IPSR7", 0xE606005C, 32,
			     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
			     1, 1, 1, 1, 1, 2, 2, 2, 2, 1, 1, 2, 2, 2) {
		/* IP7_31 [1] */
		0, 0,
		/* IP7_30 [1] */
		0, 0,
		/* IP7_29 [1] */
		0, 0,
		/* IP7_28 [1] */
		0, 0,
		/* IP7_27 [1] */
		0, 0,
		/* IP7_26 [1] */
		0, 0,
		/* IP7_25 [1] */
		0, 0,
		/* IP7_24 [1] */
		0, 0,
		/* IP7_23 [1] */
		0, 0,
		/* IP7_22 [1] */
		0, 0,
		/* IP7_21 [1] */
		0, 0,
		/* IP7_20 [1] */
		FN_AUDIO_CLKB, 0,
		/* IP7_19 [1] */
		FN_AUDIO_CLKA, 0,
		/* IP7_18 [1] */
		FN_AUDIO_CLKOUT, 0,
		/* IP7_17 [1] */
		FN_SSI_SDATA4, 0,
		/* IP7_16 [1] */
		FN_SSI_WS4, 0,
		/* IP7_15_14 [2] */
		FN_SSI_SCK4, FN_TPU0TO3, 0, 0,
		/* IP7_13_12 [2] */
		FN_SSI_SDATA3, FN_TPU0TO2, 0, 0,
		/* IP7_11_10 [2] */
		FN_SSI_WS3, FN_TPU0TO1, 0, 0,
		/* IP7_9_8 [2] */
		FN_SSI_SCK3, FN_TPU0TO0, 0, 0,
		/* IP7_7 [1] */
		FN_PWM4, 0,
		/* IP7_6 [1] */
		FN_PWM3, 0,
		/* IP7_5_4 [2] */
		FN_PWM2, FN_TCLK3, FN_FSO_TOE, 0,
		/* IP7_3_2 [2] */
		FN_PWM1, FN_TCLK2, FN_FSO_CFE_1, 0,
		/* IP7_1_0 [2] */
		FN_PWM0, FN_TCLK1, FN_FSO_CFE_0, 0, }
	},
	/* MOD SEL */
	{ PINMUX_CFG_REG("MOD_SEL", 0xE6060140, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		/* MOD_SEL [1] */
		FN_SEL_VI1_0, FN_SEL_VI1_1, }
	},
	{ PINMUX_CFG_REG("INOUTSEL0", 0xE6050004, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		GP_0_28_IN, GP_0_28_OUT,
		GP_0_27_IN, GP_0_27_OUT,
		GP_0_26_IN, GP_0_26_OUT,
		GP_0_25_IN, GP_0_25_OUT,
		GP_0_24_IN, GP_0_24_OUT,
		GP_0_23_IN, GP_0_23_OUT,
		GP_0_22_IN, GP_0_22_OUT,
		GP_0_21_IN, GP_0_21_OUT,
		GP_0_20_IN, GP_0_20_OUT,
		GP_0_19_IN, GP_0_19_OUT,
		GP_0_18_IN, GP_0_18_OUT,
		GP_0_17_IN, GP_0_17_OUT,
		GP_0_16_IN, GP_0_16_OUT,
		GP_0_15_IN, GP_0_15_OUT,
		GP_0_14_IN, GP_0_14_OUT,
		GP_0_13_IN, GP_0_13_OUT,
		GP_0_12_IN, GP_0_12_OUT,
		GP_0_11_IN, GP_0_11_OUT,
		GP_0_10_IN, GP_0_10_OUT,
		GP_0_9_IN, GP_0_9_OUT,
		GP_0_8_IN, GP_0_8_OUT,
		GP_0_7_IN, GP_0_7_OUT,
		GP_0_6_IN, GP_0_6_OUT,
		GP_0_5_IN, GP_0_5_OUT,
		GP_0_4_IN, GP_0_4_OUT,
		GP_0_3_IN, GP_0_3_OUT,
		GP_0_2_IN, GP_0_2_OUT,
		GP_0_1_IN, GP_0_1_OUT,
		GP_0_0_IN, GP_0_0_OUT, }
	},
	{ PINMUX_CFG_REG("INOUTSEL1", 0xE6051004, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_1_22_IN, GP_1_22_OUT,
		GP_1_21_IN, GP_1_21_OUT,
		GP_1_20_IN, GP_1_20_OUT,
		GP_1_19_IN, GP_1_19_OUT,
		GP_1_18_IN, GP_1_18_OUT,
		GP_1_17_IN, GP_1_17_OUT,
		GP_1_16_IN, GP_1_16_OUT,
		GP_1_15_IN, GP_1_15_OUT,
		GP_1_14_IN, GP_1_14_OUT,
		GP_1_13_IN, GP_1_13_OUT,
		GP_1_12_IN, GP_1_12_OUT,
		GP_1_11_IN, GP_1_11_OUT,
		GP_1_10_IN, GP_1_10_OUT,
		GP_1_9_IN, GP_1_9_OUT,
		GP_1_8_IN, GP_1_8_OUT,
		GP_1_7_IN, GP_1_7_OUT,
		GP_1_6_IN, GP_1_6_OUT,
		GP_1_5_IN, GP_1_5_OUT,
		GP_1_4_IN, GP_1_4_OUT,
		GP_1_3_IN, GP_1_3_OUT,
		GP_1_2_IN, GP_1_2_OUT,
		GP_1_1_IN, GP_1_1_OUT,
		GP_1_0_IN, GP_1_0_OUT, }
	},
	{ PINMUX_CFG_REG("INOUTSEL2", 0xE6052004, 32, 1) { GP_INOUTSEL(2) } },
	{ PINMUX_CFG_REG("INOUTSEL3", 0xE6053004, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_3_27_IN, GP_3_27_OUT,
		GP_3_26_IN, GP_3_26_OUT,
		GP_3_25_IN, GP_3_25_OUT,
		GP_3_24_IN, GP_3_24_OUT,
		GP_3_23_IN, GP_3_23_OUT,
		GP_3_22_IN, GP_3_22_OUT,
		GP_3_21_IN, GP_3_21_OUT,
		GP_3_20_IN, GP_3_20_OUT,
		GP_3_19_IN, GP_3_19_OUT,
		GP_3_18_IN, GP_3_18_OUT,
		GP_3_17_IN, GP_3_17_OUT,
		GP_3_16_IN, GP_3_16_OUT,
		GP_3_15_IN, GP_3_15_OUT,
		GP_3_14_IN, GP_3_14_OUT,
		GP_3_13_IN, GP_3_13_OUT,
		GP_3_12_IN, GP_3_12_OUT,
		GP_3_11_IN, GP_3_11_OUT,
		GP_3_10_IN, GP_3_10_OUT,
		GP_3_9_IN, GP_3_9_OUT,
		GP_3_8_IN, GP_3_8_OUT,
		GP_3_7_IN, GP_3_7_OUT,
		GP_3_6_IN, GP_3_6_OUT,
		GP_3_5_IN, GP_3_5_OUT,
		GP_3_4_IN, GP_3_4_OUT,
		GP_3_3_IN, GP_3_3_OUT,
		GP_3_2_IN, GP_3_2_OUT,
		GP_3_1_IN, GP_3_1_OUT,
		GP_3_0_IN, GP_3_0_OUT, }
	},
	{ PINMUX_CFG_REG("INOUTSEL4", 0xE6054004, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_4_16_IN, GP_4_16_OUT,
		GP_4_15_IN, GP_4_15_OUT,
		GP_4_14_IN, GP_4_14_OUT,
		GP_4_13_IN, GP_4_13_OUT,
		GP_4_12_IN, GP_4_12_OUT,
		GP_4_11_IN, GP_4_11_OUT,
		GP_4_10_IN, GP_4_10_OUT,
		GP_4_9_IN, GP_4_9_OUT,
		GP_4_8_IN, GP_4_8_OUT,
		GP_4_7_IN, GP_4_7_OUT,
		GP_4_6_IN, GP_4_6_OUT,
		GP_4_5_IN, GP_4_5_OUT,
		GP_4_4_IN, GP_4_4_OUT,
		GP_4_3_IN, GP_4_3_OUT,
		GP_4_2_IN, GP_4_2_OUT,
		GP_4_1_IN, GP_4_1_OUT,
		GP_4_0_IN, GP_4_0_OUT, }
	},
	{ PINMUX_CFG_REG("INOUTSEL5", 0xE6055004, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_5_16_IN, GP_5_16_OUT,
		GP_5_15_IN, GP_5_15_OUT,
		GP_5_14_IN, GP_5_14_OUT,
		GP_5_13_IN, GP_5_13_OUT,
		GP_5_12_IN, GP_5_12_OUT,
		GP_5_11_IN, GP_5_11_OUT,
		GP_5_10_IN, GP_5_10_OUT,
		GP_5_9_IN, GP_5_9_OUT,
		GP_5_8_IN, GP_5_8_OUT,
		GP_5_7_IN, GP_5_7_OUT,
		GP_5_6_IN, GP_5_6_OUT,
		GP_5_5_IN, GP_5_5_OUT,
		GP_5_4_IN, GP_5_4_OUT,
		GP_5_3_IN, GP_5_3_OUT,
		GP_5_2_IN, GP_5_2_OUT,
		GP_5_1_IN, GP_5_1_OUT,
		GP_5_0_IN, GP_5_0_OUT, }
	},
	{ PINMUX_CFG_REG("INOUTSEL6", 0xE6055104, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_6_16_IN, GP_6_16_OUT,
		GP_6_15_IN, GP_6_15_OUT,
		GP_6_14_IN, GP_6_14_OUT,
		GP_6_13_IN, GP_6_13_OUT,
		GP_6_12_IN, GP_6_12_OUT,
		GP_6_11_IN, GP_6_11_OUT,
		GP_6_10_IN, GP_6_10_OUT,
		GP_6_9_IN, GP_6_9_OUT,
		GP_6_8_IN, GP_6_8_OUT,
		GP_6_7_IN, GP_6_7_OUT,
		GP_6_6_IN, GP_6_6_OUT,
		GP_6_5_IN, GP_6_5_OUT,
		GP_6_4_IN, GP_6_4_OUT,
		GP_6_3_IN, GP_6_3_OUT,
		GP_6_2_IN, GP_6_2_OUT,
		GP_6_1_IN, GP_6_1_OUT,
		GP_6_0_IN, GP_6_0_OUT, }
	},
	{ PINMUX_CFG_REG("INOUTSEL7", 0xE6055204, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_7_16_IN, GP_7_16_OUT,
		GP_7_15_IN, GP_7_15_OUT,
		GP_7_14_IN, GP_7_14_OUT,
		GP_7_13_IN, GP_7_13_OUT,
		GP_7_12_IN, GP_7_12_OUT,
		GP_7_11_IN, GP_7_11_OUT,
		GP_7_10_IN, GP_7_10_OUT,
		GP_7_9_IN, GP_7_9_OUT,
		GP_7_8_IN, GP_7_8_OUT,
		GP_7_7_IN, GP_7_7_OUT,
		GP_7_6_IN, GP_7_6_OUT,
		GP_7_5_IN, GP_7_5_OUT,
		GP_7_4_IN, GP_7_4_OUT,
		GP_7_3_IN, GP_7_3_OUT,
		GP_7_2_IN, GP_7_2_OUT,
		GP_7_1_IN, GP_7_1_OUT,
		GP_7_0_IN, GP_7_0_OUT, }
	},
	{ PINMUX_CFG_REG("INOUTSEL8", 0xE6055304, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_8_16_IN, GP_8_16_OUT,
		GP_8_15_IN, GP_8_15_OUT,
		GP_8_14_IN, GP_8_14_OUT,
		GP_8_13_IN, GP_8_13_OUT,
		GP_8_12_IN, GP_8_12_OUT,
		GP_8_11_IN, GP_8_11_OUT,
		GP_8_10_IN, GP_8_10_OUT,
		GP_8_9_IN, GP_8_9_OUT,
		GP_8_8_IN, GP_8_8_OUT,
		GP_8_7_IN, GP_8_7_OUT,
		GP_8_6_IN, GP_8_6_OUT,
		GP_8_5_IN, GP_8_5_OUT,
		GP_8_4_IN, GP_8_4_OUT,
		GP_8_3_IN, GP_8_3_OUT,
		GP_8_2_IN, GP_8_2_OUT,
		GP_8_1_IN, GP_8_1_OUT,
		GP_8_0_IN, GP_8_0_OUT, }
	},
	{ PINMUX_CFG_REG("INOUTSEL9", 0xE6055404, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_9_16_IN, GP_9_16_OUT,
		GP_9_15_IN, GP_9_15_OUT,
		GP_9_14_IN, GP_9_14_OUT,
		GP_9_13_IN, GP_9_13_OUT,
		GP_9_12_IN, GP_9_12_OUT,
		GP_9_11_IN, GP_9_11_OUT,
		GP_9_10_IN, GP_9_10_OUT,
		GP_9_9_IN, GP_9_9_OUT,
		GP_9_8_IN, GP_9_8_OUT,
		GP_9_7_IN, GP_9_7_OUT,
		GP_9_6_IN, GP_9_6_OUT,
		GP_9_5_IN, GP_9_5_OUT,
		GP_9_4_IN, GP_9_4_OUT,
		GP_9_3_IN, GP_9_3_OUT,
		GP_9_2_IN, GP_9_2_OUT,
		GP_9_1_IN, GP_9_1_OUT,
		GP_9_0_IN, GP_9_0_OUT, }
	},
	{ PINMUX_CFG_REG("INOUTSEL10", 0xE6055504, 32, 1) { GP_INOUTSEL(10) } },
	{ PINMUX_CFG_REG("INOUTSEL11", 0xE6055604, 32, 1) {
		0, 0,
		0, 0,
		GP_11_29_IN, GP_11_29_OUT,
		GP_11_28_IN, GP_11_28_OUT,
		GP_11_27_IN, GP_11_27_OUT,
		GP_11_26_IN, GP_11_26_OUT,
		GP_11_25_IN, GP_11_25_OUT,
		GP_11_24_IN, GP_11_24_OUT,
		GP_11_23_IN, GP_11_23_OUT,
		GP_11_22_IN, GP_11_22_OUT,
		GP_11_21_IN, GP_11_21_OUT,
		GP_11_20_IN, GP_11_20_OUT,
		GP_11_19_IN, GP_11_19_OUT,
		GP_11_18_IN, GP_11_18_OUT,
		GP_11_17_IN, GP_11_17_OUT,
		GP_11_16_IN, GP_11_16_OUT,
		GP_11_15_IN, GP_11_15_OUT,
		GP_11_14_IN, GP_11_14_OUT,
		GP_11_13_IN, GP_11_13_OUT,
		GP_11_12_IN, GP_11_12_OUT,
		GP_11_11_IN, GP_11_11_OUT,
		GP_11_10_IN, GP_11_10_OUT,
		GP_11_9_IN, GP_11_9_OUT,
		GP_11_8_IN, GP_11_8_OUT,
		GP_11_7_IN, GP_11_7_OUT,
		GP_11_6_IN, GP_11_6_OUT,
		GP_11_5_IN, GP_11_5_OUT,
		GP_11_4_IN, GP_11_4_OUT,
		GP_11_3_IN, GP_11_3_OUT,
		GP_11_2_IN, GP_11_2_OUT,
		GP_11_1_IN, GP_11_1_OUT,
		GP_11_0_IN, GP_11_0_OUT, }
	},
	{ },
};

static struct pinmux_data_reg pinmux_data_regs[] = {
	{ PINMUX_DATA_REG("INDT0", 0xE6050008, 32) {
		0, 0, 0, GP_0_28_DATA,
		GP_0_27_DATA, GP_0_26_DATA, GP_0_25_DATA, GP_0_24_DATA,
		GP_0_23_DATA, GP_0_22_DATA, GP_0_21_DATA, GP_0_20_DATA,
		GP_0_19_DATA, GP_0_18_DATA, GP_0_17_DATA, GP_0_16_DATA,
		GP_0_15_DATA, GP_0_14_DATA, GP_0_13_DATA, GP_0_12_DATA,
		GP_0_11_DATA, GP_0_10_DATA, GP_0_9_DATA, GP_0_8_DATA,
		GP_0_7_DATA, GP_0_6_DATA, GP_0_5_DATA, GP_0_4_DATA,
		GP_0_3_DATA, GP_0_2_DATA, GP_0_1_DATA, GP_0_0_DATA }
	},
	{ PINMUX_DATA_REG("INDT1", 0xE6051008, 32) {
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, GP_1_22_DATA, GP_1_21_DATA, GP_1_20_DATA,
		GP_1_19_DATA, GP_1_18_DATA, GP_1_17_DATA, GP_1_16_DATA,
		GP_1_15_DATA, GP_1_14_DATA, GP_1_13_DATA, GP_1_12_DATA,
		GP_1_11_DATA, GP_1_10_DATA, GP_1_9_DATA, GP_1_8_DATA,
		GP_1_7_DATA, GP_1_6_DATA, GP_1_5_DATA, GP_1_4_DATA,
		GP_1_3_DATA, GP_1_2_DATA, GP_1_1_DATA, GP_1_0_DATA }
	},
	{ PINMUX_DATA_REG("INDT2", 0xE6052008, 32) { GP_INDT(2) } },
	{ PINMUX_DATA_REG("INDT3", 0xE6053008, 32) {
		0, 0, 0, 0,
		GP_3_27_DATA, GP_3_26_DATA, GP_3_25_DATA, GP_3_24_DATA,
		GP_3_23_DATA, GP_3_22_DATA, GP_3_21_DATA, GP_3_20_DATA,
		GP_3_19_DATA, GP_3_18_DATA, GP_3_17_DATA, GP_3_16_DATA,
		GP_3_15_DATA, GP_3_14_DATA, GP_3_13_DATA, GP_3_12_DATA,
		GP_3_11_DATA, GP_3_10_DATA, GP_3_9_DATA, GP_3_8_DATA,
		GP_3_7_DATA, GP_3_6_DATA, GP_3_5_DATA, GP_3_4_DATA,
		GP_3_3_DATA, GP_3_2_DATA, GP_3_1_DATA, GP_3_0_DATA }
	},
	{ PINMUX_DATA_REG("INDT4", 0xE6054008, 32) {
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, GP_4_16_DATA,
		GP_4_15_DATA, GP_4_14_DATA, GP_4_13_DATA, GP_4_12_DATA,
		GP_4_11_DATA, GP_4_10_DATA, GP_4_9_DATA, GP_4_8_DATA,
		GP_4_7_DATA, GP_4_6_DATA, GP_4_5_DATA, GP_4_4_DATA,
		GP_4_3_DATA, GP_4_2_DATA, GP_4_1_DATA, GP_4_0_DATA }
	},
	{ PINMUX_DATA_REG("INDT5", 0xE6055008, 32) {
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, GP_5_16_DATA,
		GP_5_15_DATA, GP_5_14_DATA, GP_5_13_DATA, GP_5_12_DATA,
		GP_5_11_DATA, GP_5_10_DATA, GP_5_9_DATA, GP_5_8_DATA,
		GP_5_7_DATA, GP_5_6_DATA, GP_5_5_DATA, GP_5_4_DATA,
		GP_5_3_DATA, GP_5_2_DATA, GP_5_1_DATA, GP_5_0_DATA }
	},
	{ PINMUX_DATA_REG("INDT6", 0xE6055108, 32) {
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, GP_6_16_DATA,
		GP_6_15_DATA, GP_6_14_DATA, GP_6_13_DATA, GP_6_12_DATA,
		GP_6_11_DATA, GP_6_10_DATA, GP_6_9_DATA, GP_6_8_DATA,
		GP_6_7_DATA, GP_6_6_DATA, GP_6_5_DATA, GP_6_4_DATA,
		GP_6_3_DATA, GP_6_2_DATA, GP_6_1_DATA, GP_6_0_DATA }
	},
	{ PINMUX_DATA_REG("INDT7", 0xE6055208, 32) {
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, GP_7_16_DATA,
		GP_7_15_DATA, GP_7_14_DATA, GP_7_13_DATA, GP_7_12_DATA,
		GP_7_11_DATA, GP_7_10_DATA, GP_7_9_DATA, GP_7_8_DATA,
		GP_7_7_DATA, GP_7_6_DATA, GP_7_5_DATA, GP_7_4_DATA,
		GP_7_3_DATA, GP_7_2_DATA, GP_7_1_DATA, GP_7_0_DATA }
	},
	{ PINMUX_DATA_REG("INDT8", 0xE6055308, 32) {
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, GP_8_16_DATA,
		GP_8_15_DATA, GP_8_14_DATA, GP_8_13_DATA, GP_8_12_DATA,
		GP_8_11_DATA, GP_8_10_DATA, GP_8_9_DATA, GP_8_8_DATA,
		GP_8_7_DATA, GP_8_6_DATA, GP_8_5_DATA, GP_8_4_DATA,
		GP_8_3_DATA, GP_8_2_DATA, GP_8_1_DATA, GP_8_0_DATA }
	},
	{ PINMUX_DATA_REG("INDT9", 0xE6055408, 32) {
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, GP_9_16_DATA,
		GP_9_15_DATA, GP_9_14_DATA, GP_9_13_DATA, GP_9_12_DATA,
		GP_9_11_DATA, GP_9_10_DATA, GP_9_9_DATA, GP_9_8_DATA,
		GP_9_7_DATA, GP_9_6_DATA, GP_9_5_DATA, GP_9_4_DATA,
		GP_9_3_DATA, GP_9_2_DATA, GP_9_1_DATA, GP_9_0_DATA }
	},
	{ PINMUX_DATA_REG("INDT10", 0xE6055508, 32) { GP_INDT(10) } },
	{ PINMUX_DATA_REG("INDT11", 0xE6055608, 32) {
		0, 0, GP_11_29_DATA, GP_11_28_DATA,
		GP_11_27_DATA, GP_11_26_DATA, GP_11_25_DATA, GP_11_24_DATA,
		GP_11_23_DATA, GP_11_22_DATA, GP_11_21_DATA, GP_11_20_DATA,
		GP_11_19_DATA, GP_11_18_DATA, GP_11_17_DATA, GP_11_16_DATA,
		GP_11_15_DATA, GP_11_14_DATA, GP_11_13_DATA, GP_11_12_DATA,
		GP_11_11_DATA, GP_11_10_DATA, GP_11_9_DATA, GP_11_8_DATA,
		GP_11_7_DATA, GP_11_6_DATA, GP_11_5_DATA, GP_11_4_DATA,
		GP_11_3_DATA, GP_11_2_DATA, GP_11_1_DATA, GP_11_0_DATA }
	},
	{ },
};

static struct pinmux_info r8a7792_pinmux_info = {
	.name = "r8a7792_pfc",

	.unlock_reg = 0xe6060000, /* PMMR */

	.reserved_id = PINMUX_RESERVED,
	.data = { PINMUX_DATA_BEGIN, PINMUX_DATA_END },
	.input = { PINMUX_INPUT_BEGIN, PINMUX_INPUT_END },
	.output = { PINMUX_OUTPUT_BEGIN, PINMUX_OUTPUT_END },
	.mark = { PINMUX_MARK_BEGIN, PINMUX_MARK_END },
	.function = { PINMUX_FUNCTION_BEGIN, PINMUX_FUNCTION_END },

	.first_gpio = GPIO_GP_0_0,
	.last_gpio = GPIO_FN_AUDIO_CLKB,

	.gpios = pinmux_gpios,
	.cfg_regs = pinmux_config_regs,
	.data_regs = pinmux_data_regs,

	.gpio_data = pinmux_data,
	.gpio_data_size = ARRAY_SIZE(pinmux_data),
};

void r8a7792_pinmux_init(void)
{
	register_pinmux(&r8a7792_pinmux_info);
}

