/*
* Copyright (C) 2019 "IoT.bzh"
* Author Jonathan Aillet <jonathan.aillet@iot.bzh>
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*   http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

#ifndef _HAL_UTILITIES_ALSA_DATA_INCLUDE_
#define _HAL_UTILITIES_ALSA_DATA_INCLUDE_

#include <stdio.h>

#include <json-c/json.h>

#include <alsa/asoundlib.h>

#include <afb/afb-binding.h>

#include <ctl-config.h>

struct CtlHalAlsaDBScale {
	int min;
	int max;
	int step;
	int mute;
};

struct CtlHalAlsaCtlProperties {
	snd_ctl_elem_type_t type;
	int count;
	int minval;
	int maxval;
	int step;
	// TBD JAI : use them
	const char **enums;
	struct CtlHalAlsaDBScale *dbscale;
};

struct CtlHalAlsaCtl {
	char *name;
	int numid;
	int value;
	struct CtlHalAlsaCtlProperties alsaCtlProperties;
	struct CtlHalAlsaCtlProperties *alsaCtlCreation;
};

struct CtlHalAlsaMap {
	const char *uid;
	char *info;
	afb_event_t alsaControlEvent;
	struct CtlHalAlsaCtl ctl;
	json_object *actionJ;
	CtlActionT *action;
};

struct CtlHalAlsaMapT {
	struct CtlHalAlsaMap *ctls;
	unsigned int ctlsCount;
};

// Free contents of 'CtlHalAlsaMapT' data structure
uint8_t HalUtlFreeAlsaCtlsMap(struct CtlHalAlsaMapT *alsaCtlsMap);

#endif /* _HAL_UTILITIES_ALSA_DATA_INCLUDE_ */