--[[
   Copyright (C) 2018 "IoT.bzh"
   Author Frédéric Marec <frederic.marec@iot.bzh>

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.


   NOTE: strict mode: every global variables should be prefixed by '_'
--]]

local testPrefix ="4a-hal-manager_BasicAPITest_"

-- This tests the ping verb of the audio ping
_AFT.testVerbStatusSuccess(testPrefix.."ping","4a-hal-manager","ping", {}, nil, nil)

-- This tests the loaded verb of the audio loaded
_AFT.testVerbStatusSuccess(testPrefix.."loaded","4a-hal-manager","loaded", {verbose = true}, nil, nil)

-- This tests the load verb of the audio load
_AFT.testVerbStatusSuccess(testPrefix.."load","4a-hal-manager","load",
{
  metadata = {
    uid = "/dev/snd/by-path/pci-0000:00:1b.0",
    version =  0.9 ,
    api = "4a-hal-intel",
    require = {"alsacore", "smixer"},
    info = "4a hal for Intel device",
    author = "Jonathan Aillet",
    date = "2018-06-13"
  }
},
nil, nil)

-- This tests the unload verb of the audio unload
_AFT.testVerbStatusSuccess(testPrefix.."unload","4a-hal-manager","unload",
{api = "4a-hal-intel"}, nil, nil)
