# Telephony Service

## Overview

Telephony service allows respective clients access to the Handsfree Profile via the oFono package

## Verbs

| Name                | Description                                     | JSON Response                               |
|---------------------|-------------------------------------------------|---------------------------------------------|
| subscribe           | subscribe to telephony events                   | *Request:* {"value": "callStateChanged"}    |
| unsubscribe         | unsubscribe to telephony events                 | *Request:* {"value": "callStateChanged"}    |
| dial                | dial respective number                          | *Request:* {"value": "15035551212"}         |
| hangup              | hangup an active call or reject incoming call   |                                             |
| answer              | answer incoming call                            |                                             |

## Events

| Name                | Description                          | JSON Event Data                             |
|---------------------|--------------------------------------|---------------------------------------------|
| callStateChanged    | Call status change event             | see callStateChanged event                  |
| dialingCall         | Outgoing call events                 | {"colp": "3305551212"}                      |
| incomingCall        | Incoming call events                 | {"clip": "3305551212"}                      |
| terminatedCall      | Terminated call event                | *empty JSON response*                       |

### callStateChanged Event

This event has one field called *parameter* with one of the following states (see **doc/voicecall-api.txt** in oFono for further reference):

| Name           | Description                       |
|----------------|-----------------------------------|
| active         | Call is active                    |
| held           | Call is on hold                   |
| dialing        | Call is being dialed              |
| alerting       | Remote party is being alerted     |
| incoming       | Incoming call in progress         |
| waiting        | Call is waiting                   |
| disconnected   | Call is disconnected              |

